<cfcomponent extends="_transportes.funcoes.cfc_init">
	<cffunction name='prc_module_gateway' displayname='Chamada para backend de contrato de transporte' access='remote' returntype='Struct' output='true'>
		<cfargument name='OPERATION' required='yes'>
		<cfargument name='PARAMS'    required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pagfrete.pkg_contrato_backend.prc_module_gateway' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN'  cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OPERATION#'>
					<cfprocparam type='IN'  cfsqltype='CF_SQL_VARCHAR'  value='#arguments.PARAMS#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'      variable='retorno.result' >
				</cfstoredproc>
				
				<cfset result = XmlParse(retorno.result)>

				<cfset mensagem           = XmlSearch(result, '/params/mensagem')>
				<cfset pedagio_rota       = XmlSearch(result, '/params/valor_pedagio_rota')>
				<cfset contrato_id        = XmlSearch(result, '/params/contrato_id')>
				<cfset requisicao_id      = XmlSearch(result, '/params/requisicao_id')>
				<cfset pedagio_rota_volta = XmlSearch(result, '/params/valor_pedagio_rota_volta')>
				
				<cfif arguments.OPERATION eq 'verificar_roteiro'>
					<cfset retorno.valor_pedagio_rota = pedagio_rota[1].XmlText>
				<cfelseif arguments.OPERATION eq 'solicitar_roteiro_volta'>
					<cfset retorno.valor_pedagio_rota_volta = pedagio_rota_volta[1].XmlText>
				<cfelseif arguments.OPERATION eq 'inserir_contrato'>
					<cfset retorno.contrato_id = contrato_id[1].XmlText>
				<cfelseif arguments.OPERATION eq 'consulta_contrato'>
				    <cfset retorno.requisicao_id = requisicao_id[1].XmlText>
				</cfif>
				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat(mensagem[1].XmlText)>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<cffunction name='gera_contrato' displayname='Gera o PDF de impressão de um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pagfrete.pkg_impressao.prc_gera_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impressão gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>
