<cfcomponent extends="_transportes.funcoes.cfc_init">
	<cffunction name="get_validacoes_emissao" access="remote" returntype="query" output="true">
    	<cfargument name='PLACA_CAVALO'   required='yes'>
		<cfargument name='PLACA_CARRETA'  required='yes'>
		<cfargument name='COD_CONTRATADO' required='yes'>
		<cfargument name='COD_MOTORISTA'  required='yes'>
		<cfargument name='CARTAO_NUMERO'  required='yes'>
		<cfargument name='TIPO_PAGTO_ID'  required='yes'>
		<cfargument name='ROTA_ID'        required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.motorista_ok
			     , x.motorista_erro
				 , x.motorista_validacao_antt
				 , x.contratado_ok
				 , x.contratado_erro
				 , x.contratado_validacao_antt
				 , x.tracao_ok
				 , x.tracao_erro
				 , x.tracao_validacao_antt
				 , x.carreta_ok
				 , x.carreta_erro
				 , x.carreta_validacao_antt
				 , x.rota_ok
				 , x.rota_erro
				 , x.rota_validacao_operadora
				 , x.cartao_ok
				 , x.cartao_erro
				 , x.cartao_validacao_operadora
				 , x.numero_eixos
			from xmltable('/validacao_emissao/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_validacao_emissao(
			
			xmltype('<params>' ||
						'<tipo_pagto_id>#arguments.TIPO_PAGTO_ID#</tipo_pagto_id>' ||
				
						<cfif len(trim(arguments.PLACA_CAVALO))>
						  '<placa_tracao>#arguments.PLACA_CAVALO#</placa_tracao>' ||
						</cfif>
						
						<cfif len(trim(arguments.PLACA_CARRETA))>
						  '<placa_carreta>#arguments.PLACA_CARRETA#</placa_carreta>' ||
						</cfif>

						<cfif len(trim(arguments.COD_CONTRATADO))>
						  '<cod_contratado>#arguments.COD_CONTRATADO#</cod_contratado>' ||
						</cfif>
						
						<cfif len(trim(arguments.COD_MOTORISTA))>
						  '<cod_motorista>#arguments.COD_MOTORISTA#</cod_motorista>' ||
						</cfif>
						
						<cfif len(trim(arguments.CARTAO_NUMERO))>
						  '<cartao_numero>#arguments.CARTAO_NUMERO#</cartao_numero>' ||
						</cfif>
						
						<cfif len(trim(arguments.ROTA_ID))>
						  '<rota_id>#arguments.ROTA_ID#</rota_id>' ||
						</cfif>
						
					'</params>'))
                columns
                   motorista_ok               integer        path '/arrayItem/motorista_validacao/arrayItem/motorista_ok'
                 , motorista_erro             varchar2(4000) path '/arrayItem/motorista_validacao/arrayItem/motorista_erro'
                 , motorista_validacao_antt   varchar2(4000) path '/arrayItem/motorista_validacao/arrayItem/motorista_validacao_antt'
				 , contratado_ok              integer        path '/arrayItem/contratado_validacao/arrayItem/contratado_ok'
                 , contratado_erro            varchar2(4000) path '/arrayItem/contratado_validacao/arrayItem/contratado_erro'
                 , contratado_validacao_antt  varchar2(4000) path '/arrayItem/contratado_validacao/arrayItem/contratado_validacao_antt'
				 , tracao_ok             	  integer        path '/arrayItem/veiculo_tracao_validacao/arrayItem/tracao_ok'
                 , tracao_erro           	  varchar2(4000) path '/arrayItem/veiculo_tracao_validacao/arrayItem/tracao_erro'
                 , tracao_validacao_antt 	  varchar2(4000) path '/arrayItem/veiculo_tracao_validacao/arrayItem/tracao_validacao_antt'
				 , carreta_ok             	  integer        path '/arrayItem/veiculo_carreta_validacao/arrayItem/carreta_ok'
                 , carreta_erro           	  varchar2(4000) path '/arrayItem/veiculo_carreta_validacao/arrayItem/carreta_erro'
                 , carreta_validacao_antt 	  varchar2(4000) path '/arrayItem/veiculo_carreta_validacao/arrayItem/carreta_validacao_antt'
				 , rota_ok             	      integer        path '/arrayItem/rota_validacao/arrayItem/rota_ok'
                 , rota_erro           	      varchar2(4000) path '/arrayItem/rota_validacao/arrayItem/rota_erro'
                 , rota_validacao_operadora   varchar2(4000) path '/arrayItem/rota_validacao/arrayItem/rota_validacao_operadora'
				 , cartao_ok             	  integer        path '/arrayItem/cartao_validacao/arrayItem/cartao_ok'
                 , cartao_erro           	  varchar2(4000) path '/arrayItem/cartao_validacao/arrayItem/cartao_erro'
                 , cartao_validacao_operadora varchar2(4000) path '/arrayItem/cartao_validacao/arrayItem/cartao_validacao_operadora'
				 , numero_eixos				  integer        path '/arrayItem/numero_eixos'
            ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_dados_contr_proc_trans" access="remote" returntype="query" output="true">
    	<cfargument name='CONTRATO_ID'   required='yes'>
		<cfargument name='TIPO_PAGTO_ID' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.processo_transporte_codigo
				 , x.identificador_kmm
				 , x.status
				 , x.valor_inicial_frete
				 , x.data_quitacao
				 , x.valor_pedagio
				 , x.municipio_origem
				 , x.municipio_origem_uf
				 , x.municipio_destino
				 , x.municipio_destino_uf
				 , x.descricao_rota
				 , x.operacao_id
				 , x.operacao
				 , x.placa_tracao
				 , x.unidade_negocio
			   from xmltable('/dados_contrato/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_dados_contrato(
				   xmltype('<params>' ||
					  '<contrato_id>#arguments.CONTRATO_ID#</contrato_id>' ||
					  '<tipo_pagto_id>#arguments.TIPO_PAGTO_ID#</tipo_pagto_id>' ||
					 '</params>'))
								columns
								   processo_transporte_codigo integer       path '/arrayItem/processo_transporte_codigo'
								  ,identificador_kmm          varchar2(100) path '/arrayItem/identificador_kmm'
								  ,status                     varchar2(100) path '/arrayItem/status'
								  ,valor_inicial_frete        number        path '/arrayItem/valor_inicial_frete'
								  ,data_quitacao              varchar2(100) path '/arrayItem/data_quitacao'
								  ,valor_pedagio              number        path '/arrayItem/valor_pedagio'
								  ,municipio_origem           varchar2(400) path '/arrayItem/municipio_origem'
								  ,municipio_origem_uf        varchar2(10)  path '/arrayItem/municipio_origem_uf'
								  ,municipio_destino          varchar2(400) path '/arrayItem/municipio_destino'
								  ,municipio_destino_uf       varchar2(10)  path '/arrayItem/municipio_destino_uf'
								  ,descricao_rota             varchar2(400) path '/arrayItem/descricao_rota'
								  ,operacao_id                varchar2(10)  path '/arrayItem/operacao_id'
								  ,operacao                   varchar2(200) path '/arrayItem/operacao'
								  ,placa_tracao               varchar2(200) path '/arrayItem/placa_tracao'
								  ,unidade_negocio            varchar2(200) path '/arrayItem/unidade_negocio'
							) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_dados_contr_proc_trans_movi" access="remote" returntype="query" output="true">
    	<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='TIPO_PAGTO_ID' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.data
			     , x.identificador
				 , x.tipo
				 , x.descricao
				 , x.valor
			from xmltable('/movimentos_contrato/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_movimentos_contrato(
			xmltype('<params>' ||
						'<contrato_id>#arguments.CONTRATO_ID#</contrato_id>' ||
						'<tipo_pagto_id>#arguments.TIPO_PAGTO_ID#</tipo_pagto_id>' ||
					'</params>'))
                columns
                   data          varchar2(30)  path '/arrayItem/data'
                 , identificador varchar2(30)  path '/arrayItem/identificador'
				 , tipo          varchar2(30)  path '/arrayItem/tipo'
                 , descricao     varchar2(200) path '/arrayItem/descricao'
                 , valor         number        path '/arrayItem/valor'
            ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_dados_contr_proc_trans_docs" access="remote" returntype="query" output="true">
    	<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='TIPO_PAGTO_ID' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.numero
			     , x.serie
				 , x.tipo_documento
				 , x.codigo_filial
			from xmltable('/documentos_contrato/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_documentos_contrato(
			
			xmltype('<params>' ||
						'<contrato_id>#arguments.CONTRATO_ID#</contrato_id>' ||
						'<tipo_pagto_id>#arguments.TIPO_PAGTO_ID#</tipo_pagto_id>' ||
					'</params>'))
                columns
                   numero varchar2(100)         path '/arrayItem/numero'
				  ,serie varchar2(100)          path '/arrayItem/serie'
				  ,tipo_documento varchar2(100) path '/arrayItem/tipo_documento'
				  ,codigo_filial varchar2(100)  path '/arrayItem/codigo_filial'
            ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_contrato_dados_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name='CONTRATO_ID' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.num_romaneio
				 , x.cod_veiculo_controle
				 , x.placa_controle
				 , x.cod_veiculo_referencia
				 , x.placa_referencia
				 , x.carregamento
				 , x.destino
				 , x.remetente
				 , x.destinatario
				 , x.natureza
				 , x.especie
				 , x.unidade
				 , x.frete_em
				 , x.peso_total
				 , x.peso_cobrado
				 , x.frete_total
				 , x.frete_liquido
				 , x.valor_pedagio_vazio
				 , x.valor_pedagio_carregado
				 , x.data_inicio
				 , x.data_destinado
				 , x.data_inicio_carga
				 , x.data_termino_carga
				 , x.data_inicio_descarga
				 , x.data_termino_descarga
			   from xmltable('/contrato_dados_romaneio/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_contrato_dados_romaneio(
						   xmltype('<params>' ||
							  '<contrato_id>#arguments.CONTRATO_ID#</contrato_id>' ||
							 '</params>'))
										columns
										   num_romaneio            integer       path '/arrayItem/num_romaneio'
										  ,cod_veiculo_controle    varchar2(30)  path '/arrayItem/cod_veiculo_controle'
										  ,placa_controle          varchar2(30)  path '/arrayItem/placa_controle'
										  ,cod_veiculo_referencia  varchar2(30)  path '/arrayItem/cod_veiculo_referencia'
										  ,placa_referencia        varchar2(30)  path '/arrayItem/placa_referencia'
										  ,carregamento            varchar2(200) path '/arrayItem/carregamento'
										  ,destino                 varchar2(200) path '/arrayItem/destino'
										  ,remetente               varchar2(200) path '/arrayItem/remetente'
										  ,destinatario            varchar2(200) path '/arrayItem/destinatario'
										  ,natureza                varchar2(200) path '/arrayItem/natureza'
										  ,especie                 varchar2(200) path '/arrayItem/especie'
										  ,unidade                 varchar2(30)  path '/arrayItem/unidade'
										  ,frete_em                varchar2(50)  path '/arrayItem/frete_em'
										  ,peso_total              number        path '/arrayItem/peso_total'
										  ,peso_cobrado            number        path '/arrayItem/peso_cobrado'
										  ,frete_total             number        path '/arrayItem/frete_total'
										  ,frete_liquido           number        path '/arrayItem/frete_liquido'
										  ,valor_pedagio_vazio     number        path '/arrayItem/valor_pedagio_vazio'
										  ,valor_pedagio_carregado number        path '/arrayItem/valor_pedagio_carregado'
										  ,data_inicio             varchar2(30)  path '/arrayItem/data_inicio'
										  ,data_destinado          varchar2(30)  path '/arrayItem/data_destinado'
										  ,data_inicio_carga       varchar2(30)  path '/arrayItem/data_inicio_carga'
										  ,data_termino_carga      varchar2(30)  path '/arrayItem/data_termino_carga'
										  ,data_inicio_descarga    varchar2(30)  path '/arrayItem/data_inicio_descarga'
										  ,data_termino_descarga   varchar2(30)  path '/arrayItem/data_termino_descarga'
									) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_agendamento_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name='CONTRATO_ID' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.num_romaneio      
                 , x.viagem_id			
				 , x.cod_veiculo_controle   
				 , x.placa_controle         
				 , x.cod_veiculo_referencia 
				 , x.placa_referencia   
			     , x.motorista
				 , x.composicao
				 , x.carregamento           
				 , x.destino                
				 , x.remetente              
				 , x.destinatario           
				 , x.natureza               
				 , x.especie                
				 , x.unidade                
				 , x.frete_em               
				 , x.peso_total             
				 , x.peso_cobrado           
				 , x.frete_total            
				 , x.frete_liquido          
				 , x.valor_pedagio_vazio    
				 , x.valor_pedagio_carregado
				 , x.data_inicio            
				 , x.data_destinado         
				 , x.data_inicio_carga      
				 , x.data_termino_carga     
				 , x.data_inicio_descarga   
				 , x.data_termino_descarga  
				 , x.data_termino
			  from xmltable('/agendamento_romaneio/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_agendamento_romaneio(
			
			xmltype('<params>' ||
						'<contrato_id>#arguments.CONTRATO_ID#</contrato_id>' ||
					'</params>'))
                columns
                   num_romaneio            integer        path '/arrayItem/num_romaneio'
                 , viagem_id               integer        path '/arrayItem/viagem_id'
				 , cod_veiculo_controle    varchar2(200) path '/arrayItem/cod_veiculo_controle'
                 , placa_controle          varchar2(50) path '/arrayItem/placa_controle'
                 , cod_veiculo_referencia  varchar2(200) path '/arrayItem/cod_veiculo_referencia'
                 , placa_referencia        varchar2(50) path '/arrayItem/placa_referencia'
                 , carregamento            varchar2(500) path '/arrayItem/carregamento'
				 , composicao              varchar2(500) path '/arrayItem/composicao'
				 , motorista               varchar2(500) path '/arrayItem/motorista'
                 , destino                 varchar2(500) path '/arrayItem/destino'
                 , remetente               varchar2(500) path '/arrayItem/remetente'
                 , destinatario            varchar2(500) path '/arrayItem/destinatario'
                 , natureza                varchar2(100) path '/arrayItem/natureza'
                 , especie                 varchar2(100) path '/arrayItem/especie'
                 , unidade                 varchar2(20) path '/arrayItem/unidade'
                 , frete_em                varchar2(50) path '/arrayItem/frete_em'
                 , peso_total              number path '/arrayItem/peso_total'
                 , peso_cobrado            number path '/arrayItem/peso_cobrado'
                 , frete_total             number path '/arrayItem/frete_total'
                 , frete_liquido           number path '/arrayItem/frete_liquido'
                 , valor_pedagio_vazio     number path '/arrayItem/valor_pedagio_vazio'
                 , valor_pedagio_carregado number path '/arrayItem/valor_pedagio_carregado'
                 , data_inicio             varchar2(30) path '/arrayItem/data_inicio'
                 , data_destinado          varchar2(30) path '/arrayItem/data_destinado'
                 , data_inicio_carga       varchar2(30) path '/arrayItem/data_inicio_carga'
                 , data_termino_carga      varchar2(30) path '/arrayItem/data_termino_carga'
                 , data_inicio_descarga    varchar2(30) path '/arrayItem/data_inicio_descarga'
                 , data_termino_descarga   varchar2(30) path '/arrayItem/data_termino_descarga'
				 , data_termino            varchar2(30) path '/arrayItem/data_termino'
            ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_solicitacoes" access="remote" returntype="query" output="true">
    	<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.solicitacao_carga_id
				 , x.remetente
				 , x.destinatario
				 , x.origem
				 , x.destino
				 , x.natureza
			  from xmltable('/solicitacoes/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_solicitacoes(
							xmltype('<params>' ||
										'<num_romaneio>#arguments.NUM_ROMANEIO#</num_romaneio>' ||
									'</params>'))
								columns
								   solicitacao_carga_id integer       path '/arrayItem/solicitacao_carga_id'
								  ,remetente            varchar2(200) path '/arrayItem/remetente'
								  ,destinatario         varchar2(200) path '/arrayItem/destinatario'
								  ,origem               varchar2(200) path '/arrayItem/origem'
								  ,destino              varchar2(200) path '/arrayItem/destino'
								  ,natureza             varchar2(200) path '/arrayItem/natureza'
							) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_romaneio_itens" access="remote" returntype="query" output="true">
    	<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.operacao_id
				 , x.operacao
				 , x.remetente
				 , x.destinatario
				 , x.documento_emitido
				 , x.internacional
			  from xmltable('/romaneio_itens/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_romaneio_itens(			
					xmltype('<params>' ||
								'<num_romaneio>#arguments.NUM_ROMANEIO#</num_romaneio>' ||
							'</params>'))
						columns
						   operacao_id       integer        path '/arrayItem/operacao_id'
						  ,operacao          varchar2(4000) path '/arrayItem/operacao'
						  ,remetente         varchar2(200)  path '/arrayItem/remetente'
						  ,destinatario      varchar2(200)  path '/arrayItem/destinatario'
						  ,documento_emitido varchar2(20)   path '/arrayItem/documento_emitido'
						  ,internacional     varchar2(20)   path '/arrayItem/internacional'
					) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_itinerarios" access="remote" returntype="query" output="true">
    	<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.descricao
				 , x.origem
				 , x.destino
				 , x.data_previsao
				 , x.data
				 , x.tipo
			  from xmltable('/itinerarios/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_itinerarios(
					   xmltype('<params>' ||
						  '<num_romaneio>#arguments.NUM_ROMANEIO#</num_romaneio>' ||
						 '</params>'))
									columns
									   descricao     varchar2(300) path '/arrayItem/descricao'
									  ,origem        varchar2(300) path '/arrayItem/origem'
									  ,destino       varchar2(300) path '/arrayItem/destino'
									  ,data_previsao varchar2(30)  path '/arrayItem/data_previsao'
									  ,data          varchar2(30)  path '/arrayItem/data'
									  ,tipo          varchar2(30)  path '/arrayItem/tipo'
								) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_documentos" access="remote" returntype="query" output="true">
    	<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.tipo
				 , x.num_documento
				 , x.data_emissao
				 , x.filial
				 , x.remetente
				 , x.destinatario
				 , x.valor
			  from xmltable('/documentos/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_documentos(			   
			   xmltype('<params>' ||
				  '<num_romaneio>#arguments.NUM_ROMANEIO#</num_romaneio>' ||
				 '</params>'))
							columns
							   tipo          varchar2(20)  path '/arrayItem/tipo'
							  ,num_documento varchar2(20)  path '/arrayItem/num_documento'
							  ,data_emissao  varchar2(20)  path '/arrayItem/data_emissao'
							  ,filial        varchar2(200) path '/arrayItem/filial'
							  ,remetente     varchar2(200) path '/arrayItem/remetente'
							  ,destinatario  varchar2(200) path '/arrayItem/destinatario'
							  ,valor         number        path '/arrayItem/valor'
						) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_contrato_transp_lite" access="remote" returntype="query" output="true">
    	<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.lancto_id
				 , x.num_contrato
				 , x.data_emissao
				 , x.filial
				 , x.proprietario
				 , x.motorista
				 , x.valor
			   from xmltable('/contrato_transp/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_contrato_transp_lite(
			   xmltype('<params>' ||
				  '<num_romaneio>#arguments.NUM_ROMANEIO#</num_romaneio>' ||
				 '</params>'))
							columns
							   lancto_id    integer       path '/arrayItem/lancto_id'
							  ,num_contrato varchar2(30)  path '/arrayItem/num_contrato'
							  ,data_emissao varchar2(30)  path '/arrayItem/data_emissao'
							  ,filial       varchar2(200) path '/arrayItem/filial'
							  ,proprietario varchar2(200) path '/arrayItem/proprietario'
							  ,motorista    varchar2(200) path '/arrayItem/motorista'
							  ,valor        number        path '/arrayItem/valor'
						) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_organograma" access="remote" returntype="query" output="true">
    	<cfargument name="COD_PESSOA" 		required="no" default="">
        <cfargument name="COD_UNIDADE_NEGOCIO" 		required="no" default="">
        <cfargument name="COD_CENTRO_CUSTO" required="no" default="">
		<cfargument name="COD_DEPARTAMENTO" required="no" default="">
        <cfargument name="COD_SETOR" required="no" default="">
        <cfargument name="CENTRO_CUSTO" required="no" default="">
        <cfargument name="SETOR" required="no" default="">
		<cfargument name="NOME_FANTASIA" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.cod_unidade_negocio
				 , x.cod_pessoa
				 , x.nome_fantasia
				 , x.cod_departamento
				 , x.departamento
				 , x.cod_setor
				 , x.setor
				 , x.cod_centro_custo
				 , x.centro_custo
				 , x.data
				 , x.cod_organograma
			from xmltable('/organograma/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_organograma(			
			xmltype('<params>' ||
						
					<cfif len(trim(arguments.COD_PESSOA))>
						'<cod_pessoa>#arguments.COD_PESSOA#</cod_pessoa>' ||
					</cfif>
					
					<cfif len(trim(arguments.COD_UNIDADE_NEGOCIO))>
						'<cod_unidade_negocio>#arguments.COD_UNIDADE_NEGOCIO#</cod_unidade_negocio>' ||
					</cfif>
					
					<cfif len(trim(arguments.COD_CENTRO_CUSTO))>
						'<cod_centro_custo>#arguments.COD_CENTRO_CUSTO#</cod_centro_custo>' ||
					</cfif>
					
					<cfif len(trim(arguments.COD_DEPARTAMENTO))>
						'<cod_departamento>#arguments.COD_DEPARTAMENTO#</cod_departamento>' ||
					</cfif>
					
					<cfif len(trim(arguments.COD_SETOR))>
						'<cod_setor>#arguments.COD_SETOR#</cod_setor>' ||
					</cfif>
					
					<cfif len(trim(arguments.NOME_FANTASIA))>
						'<nome_fantasia>#arguments.NOME_FANTASIA#</nome_fantasia>' ||
					</cfif>
					
					<cfif len(trim(arguments.CENTRO_CUSTO))>
						'<centro_custo>#arguments.CENTRO_CUSTO#</centro_custo>' ||
					</cfif>
					
					<cfif len(trim(arguments.SETOR))>
						'<setor>#arguments.CENTRO_CUSTO#</setor>' ||
					</cfif>
					
					'</params>')
					)
                columns
                   cod_unidade_negocio integer      path '/arrayItem/cod_unidade_negocio'
                  ,cod_pessoa          integer      path '/arrayItem/cod_pessoa'
                  ,nome_fantasia       varchar2(50) path '/arrayItem/nome_fantasia'
                  ,cod_departamento    integer      path '/arrayItem/cod_departamento'
                  ,departamento        varchar2(50) path '/arrayItem/departamento'
                  ,cod_setor           integer      path '/arrayItem/cod_setor'
                  ,setor               varchar2(50) path '/arrayItem/setor'
                  ,cod_centro_custo    integer      path '/arrayItem/cod_centro_custo'
                  ,centro_custo        varchar2(50) path '/arrayItem/centro_custo'
                  ,data                varchar2(50) path '/arrayItem/data'
                  ,cod_organograma     varchar2(50) path '/arrayItem/cod_organograma'
            ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
    	<cfargument name="owner" required="yes">
    	<cfargument name="rv_domain" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.rv_domain
				 , x.rv_low_value
				 , x.rv_high_value
				 , x.rv_meaning
				 , x.rv_abbreviation
				 , x.owner
			   from xmltable('/cg_ref_codes/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_cg_ref_codes(			   
			   xmltype('<params>' ||
									'<owner>#arguments.OWNER#</owner>' ||
									'<rv_domain>#arguments.RV_DOMAIN#</rv_domain>' ||
								'</params>'))
							columns
							   rv_domain varchar2(100)       path '/arrayItem/rv_domain'
							  ,rv_low_value varchar2(100)    path '/arrayItem/rv_low_value'
							  ,rv_high_value varchar2(100)   path '/arrayItem/rv_high_value'
							  ,rv_meaning varchar2(100)      path '/arrayItem/rv_meaning'
							  ,rv_abbreviation varchar2(100) path '/arrayItem/rv_abbreviation'
							  ,owner varchar2(100)           path '/arrayItem/owner'
						) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_veiculo" access="remote" returntype="query" output="true">
    	<cfargument name='COD_VEICULO' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.veiculo_id
				 , x.placa
				 , x.cod_veiculo
			from xmltable('/veiculos/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_veiculo(
			xmltype('<params>' ||
						<cfif Len(Trim(arguments.COD_VEICULO))>
							'<cod_veiculo>#arguments.COD_VEICULO#</cod_veiculo>' ||
						</cfif>	
					'</params>'))
                columns
                   veiculo_id  integer      path '/arrayItem/veiculo_id'
                  ,placa       varchar2(30) path '/arrayItem/placa'
                  ,cod_veiculo varchar2(30) path '/arrayItem/cod_veiculo'
            ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_pessoa_light" access="remote" returntype="query" output="true">
    	<cfargument name='CNPJ_CPF' required='yes'>
		<cfargument name='NUM_MODALIDADE' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.cod_pessoa
				 , x.razao_social
				 , x.cnpj_cpf
			  from xmltable('/pessoas/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_pessoa_lite(
			     xmltype('<params>' ||
							<cfif len(trim(arguments.CNPJ_CPF))>
								'<cnpj_cpf>#arguments.CNPJ_CPF#</cnpj_cpf>' ||
							</cfif>
							  
							<cfif len(trim(arguments.NUM_MODALIDADE))>
								'<num_modalidade>#arguments.NUM_MODALIDADE#</num_modalidade>' ||
							</cfif>
					     '</params>'))
										columns
										   cod_pessoa   integer       path '/arrayItem/cod_pessoa'
										  ,razao_social varchar2(100) path '/arrayItem/razao_social'
										  ,cnpj_cpf     varchar2(100) path '/arrayItem/cnpj_cpf'
									) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_contrato" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="no" default="" />
        <cfargument name="solicitacao_carga_id" required="no" default="" />
        <cfargument name="viagem_id" required="no" default="" />
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="processo_transporte_codigo" required="no" default="" />
        <cfargument name="lancto_id" required="no" default="" />
        <cfargument name="cod_pessoa_filial" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="placa_cavalo" required="no" default="" />
        <cfargument name="placa_carreta" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="tipo_contrato" required="no" default="" />
        <cfargument name="internacional" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
		<cfargument name="modalidade_veiculo" required="no" default="" />
		<cfargument name="tipo_pagto_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.contrato_id
			     , x.tipo_contrato
				 , x.tipo_contrato_desc
				 , x.internacional
				 , x.num_romaneio
				 , x.diaria_ctrc_id
				 , x.diaria_crt_id
				 , x.divisao_id
				 , x.lancto_id
				 , x.processo_cliente_codigo
				 , x.processo_transporte_codigo
				 , x.cod_unidade_negocio
				 , x.filial
				 , x.cod_centro_custo
				 , x.centro_custo
				 , x.data_emissao
				 , x.situacao_id
				 , x.situacao
				 , x.status_codigo
				 , x.cartao_numero
				 , x.cnpj_cpf_proprietario
				 , x.proprietario
				 , x.cpf_motorista
				 , x.motorista
				 , x.cod_veiculo_cavalo
				 , x.placa_cavalo
				 , x.cod_veiculo_carreta
				 , x.placa_carreta
				 , x.rota_id
				 , x.rota
				 , x.valor_inicial_adiantamento
				 , x.valor_inicial_frete
				 , x.valor_frete_bruto
				 , x.percentual_receita
				 , x.user_insert
				 , x.date_insert
				 , x.usuario_cancelamento
				 , x.data_cancelamento
				 , x.contrato_quitacao_id
				 , x.contrato_quitado
				 , x.usuario_quitacao
				 , x.data_quitacao
				 , x.contrato_quitacao_id
				 , x.quitacao_quebra_peso
				 , x.data_prevista_pagamento
				 , x.modalidade_veiculo
				 , x.cockpit_situacao
				 , x.cockpit_situacao_desc
				 , x.valor_frete_bruto_atual
				 , x.valor_maximo_gravado
				 , x.permite_integrar
				 , x.permite_cancelar
				 , x.permite_bloquear
				 , x.permite_desbloquear
				 , x.permite_interromper
				 , x.permite_quitar
				 , x.permite_imprimir
				 , x.permite_consultar
				 , x.permite_credito
				 , x.permite_debito
				 , x.permite_pagar_adto
				 , x.permite_pagar_saldo
				 , x.observacao_aprovacao
			   from xmltable('/contratos/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_contrato_transp(
			   xmltype('<params>' ||
							<cfif len(trim(arguments.CONTRATO_ID))>
								'<contrato_id>#arguments.CONTRATO_ID#</contrato_id>' ||
							</cfif>
							
							<cfif len(trim(arguments.SOLICITACAO_CARGA_ID))>
								'<solicitacao_carga_id>#arguments.SOLICITACAO_CARGA_ID#</solicitacao_carga_id>' ||
							</cfif>
				  
							<cfif len(trim(arguments.VIAGEM_ID))>
								'<viagem_id>#arguments.VIAGEM_ID#</viagem_id>' ||
							</cfif>
							
							<cfif len(trim(arguments.NUM_ROMANEIO))>
								'<num_romaneio>#arguments.NUM_ROMANEIO#</num_romaneio>' ||
							</cfif>
				  
							<cfif len(trim(arguments.PROCESSO_TRANSPORTE_CODIGO))>
								'<processo_transporte_codigo>#arguments.PROCESSO_TRANSPORTE_CODIGO#</processo_transporte_codigo>' ||
							</cfif>
							
							<cfif len(trim(arguments.LANCTO_ID))>
								'<lancto_id>#arguments.LANCTO_ID#</lancto_id>' ||
							</cfif>
							
							<cfif len(trim(arguments.COD_PESSOA_FILIAL))>
								'<cod_pessoa_filial>#arguments.COD_PESSOA_FILIAL#</cod_pessoa_filial>' ||
							</cfif>
							
							<cfif len(trim(arguments.COD_CENTRO_CUSTO))>
								'<cod_centro_custo>#arguments.COD_CENTRO_CUSTO#</cod_centro_custo>' ||
							</cfif>
							
							<cfif len(trim(arguments.PLACA_CAVALO))>
								'<placa_cavalo>#arguments.PLACA_CAVALO#</placa_cavalo>' ||
							</cfif>
							
							<cfif len(trim(arguments.PLACA_CARRETA))>
								'<placa_carreta>#arguments.PLACA_CARRETA#</placa_carreta>' ||
							</cfif>
							
							<cfif len(trim(arguments.COD_MOTORISTA))>
								'<cod_motorista>#arguments.COD_MOTORISTA#</cod_motorista>' ||
							</cfif>
							
							<cfif len(trim(arguments.TIPO_CONTRATO))>
								'<tipo_contrato>#arguments.TIPO_CONTRATO#</tipo_contrato>' ||
							</cfif>
							
							<cfif len(trim(arguments.INTERNACIONAL))>
								'<internacional>#arguments.INTERNACIONAL#</internacional>' ||
							</cfif>
							
							<cfif len(trim(arguments.DATA_INICIO))>
								'<data_inicio>#arguments.DATA_INICIO#</data_inicio>' ||
							</cfif>
							
							<cfif len(trim(arguments.DATA_TERMINO))>
								'<data_termino>#arguments.DATA_TERMINO#</data_termino>' ||
							</cfif>
							
							<cfif len(trim(arguments.MODALIDADE_VEICULO))>
								'<modalidade_veiculo>#arguments.MODALIDADE_VEICULO#</modalidade_veiculo>' ||
							</cfif>
							
							<cfif len(trim(arguments.TIPO_PAGTO_ID))>
								'<tipo_pagto_id>#arguments.TIPO_PAGTO_ID#</tipo_pagto_id>' ||
							</cfif>
				 '</params>'))
							columns
							   contrato_id                 integer        path '/arrayItem/contrato_id'
							  ,tipo_contrato               integer        path '/arrayItem/tipo_contrato'
							  ,tipo_contrato_desc          varchar2(100)  path '/arrayItem/tipo_contrato_desc'
							  ,internacional               integer        path '/arrayItem/internacional'
							  ,num_romaneio                integer        path '/arrayItem/num_romaneio'
							  ,diaria_ctrc_id              integer        path '/arrayItem/diaria_ctrc_id'
							  ,diaria_crt_id               integer        path '/arrayItem/diaria_crt_id'
							  ,divisao_id                  integer        path '/arrayItem/divisao_id'
							  ,lancto_id                   integer        path '/arrayItem/lancto_id'
							  ,processo_cliente_codigo     varchar2(100)  path '/arrayItem/processo_cliente_codigo'
							  ,processo_transporte_codigo  varchar2(100)  path '/arrayItem/processo_transporte_codigo'
							  ,cod_unidade_negocio         integer        path '/arrayItem/cod_unidade_negocio'
							  ,filial                      varchar2(100)  path '/arrayItem/filial'
							  ,cod_centro_custo            integer        path '/arrayItem/cod_centro_custo'
							  ,centro_custo                varchar2(100)  path '/arrayItem/centro_custo'
							  ,data_emissao                varchar2(100)  path '/arrayItem/data_emissao'
							  ,situacao_id                 integer        path '/arrayItem/situacao_id'
							  ,situacao                    varchar2(100)  path '/arrayItem/situacao'
							  ,status_codigo               varchar2(100)  path '/arrayItem/status_codigo'
							  ,cartao_numero               varchar2(100)  path '/arrayItem/cartao_numero'
							  ,cnpj_cpf_proprietario       varchar2(100)  path '/arrayItem/cnpj_cpf_proprietario'
							  ,proprietario                varchar2(100)  path '/arrayItem/proprietario'
							  ,cpf_motorista               varchar2(100)  path '/arrayItem/cpf_motorista'
							  ,motorista                   varchar2(100)  path '/arrayItem/motorista'
							  ,cod_veiculo_cavalo          varchar2(100)  path '/arrayItem/cod_veiculo_cavalo'
							  ,placa_cavalo                varchar2(100)  path '/arrayItem/placa_cavalo'
							  ,cod_veiculo_carreta         varchar2(100)  path '/arrayItem/cod_veiculo_carreta'
							  ,placa_carreta               varchar2(100)  path '/arrayItem/placa_carreta'
							  ,rota_id                     integer        path '/arrayItem/rota_id'
							  ,rota                        varchar2(100)  path '/arrayItem/rota'
							  ,valor_inicial_adiantamento  number         path '/arrayItem/valor_inicial_adiantamento'
							  ,valor_inicial_frete         number         path '/arrayItem/valor_inicial_frete'
							  ,valor_frete_bruto           number         path '/arrayItem/valor_frete_bruto'
							  ,percentual_receita          number         path '/arrayItem/percentual_receita'
							  ,user_insert                 varchar2(30)   path '/arrayItem/user_insert'
							  ,date_insert                 varchar2(30)   path '/arrayItem/date_insert'
							  ,usuario_cancelamento        varchar2(30)   path '/arrayItem/usuario_cancelamento'
							  ,data_cancelamento           varchar2(30)   path '/arrayItem/data_cancelamento'
							  ,contrato_quitado            integer        path '/arrayItem/contrato_quitado'
							  ,usuario_quitacao            varchar2(30)   path '/arrayItem/usuario_quitacao'
							  ,data_quitacao               varchar2(30)   path '/arrayItem/data_quitacao'
							  ,contrato_quitacao_id        integer        path '/arrayItem/contrato_quitacao_id'
							  ,quitacao_quebra_peso        integer        path '/arrayItem/quitacao_quebra_peso'
							  ,data_prevista_pagamento     varchar2(30)   path '/arrayItem/data_prevista_pagamento'
							  ,modalidade_veiculo          varchar2(30)   path '/arrayItem/modalidade_veiculo'
							  ,cockpit_situacao            integer        path '/arrayItem/cockpit_situacao'
							  ,cockpit_situacao_desc       varchar2(50)   path '/arrayItem/cockpit_situacao_desc'
							  ,valor_frete_bruto_atual     number         path '/arrayItem/valor_frete_bruto_atual'
							  ,valor_maximo_gravado        number         path '/arrayItem/valor_maximo_gravado'
							  ,permite_integrar            number         path '/arrayItem/permite_integrar'
							  ,permite_cancelar            number         path '/arrayItem/permite_cancelar'
							  ,permite_bloquear            number         path '/arrayItem/permite_bloquear'
							  ,permite_desbloquear         number         path '/arrayItem/permite_desbloquear'
							  ,permite_interromper         number         path '/arrayItem/permite_interromper'
							  ,permite_quitar         	   number         path '/arrayItem/permite_quitar'
							  ,permite_imprimir            number         path '/arrayItem/permite_imprimir'
							  ,permite_consultar           number         path '/arrayItem/permite_consultar'
							  ,permite_credito             number         path '/arrayItem/permite_credito'
							  ,permite_debito              number         path '/arrayItem/permite_debito'
							  ,permite_pagar_adto          number         path '/arrayItem/permite_pagar_adto'
							  ,permite_pagar_saldo         number         path '/arrayItem/permite_pagar_saldo'
							  ,observacao_aprovacao        varchar2(4000) path '/arrayItem/observacao_aprovacao'
            ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_contrato_transp_item_setup" access="remote" returntype="query" output="true">
    	<cfargument name='DEBITO_CREDITO' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.item_id
				 , x.descricao
			  from xmltable('/itens/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_contrato_transp_item_setup( 
						   xmltype('<params>' ||
							  '<debito_credito>#arguments.DEBITO_CREDITO#</debito_credito>' ||
							 '</params>'))
										columns
										   item_id   integer       path '/arrayItem/item_id'
										  ,descricao varchar2(200) path '/arrayItem/descricao'
						    ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_termo_agregacao" access="remote" returntype="query" output="true">
    	<cfargument name='CONTRATO_ID' required='yes'>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.termo_id
			  from xmltable('/termos/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_termo_agregacao(
					xmltype('<params>' ||
								'<contrato_id>#arguments.CONTRATO_ID#</contrato_id>' ||
							'</params>'))
						columns
						   termo_id integer path '/arrayItem/termo_id'
					) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_cockpit_parametro" access="remote" returntype="query" output="true">    	
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select kss.pkg_parametro.fnc_valor_lista(p_identificador => 'M404-P0156') as parametro_valor 
              from dual             
		</cfquery>
		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_historico_cartao" access="remote" returntype="query" output="true">
    	<cfargument name="tipo_pagto_id" required="no" default="" />
		<cfargument name="cartao_numero" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="cod_proprietario" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.contrato_id
			     , x.processo_transporte_codigo
				 , x.num_romaneio
				 , x.unidade_negocio
				 , x.centro_custo
				 , x.num_cartao
				 , x.proprietario_cnpj_cpf
				 , x.proprietario_razao_social
				 , x.proprietario
				 , x.motorista_cpf
				 , x.motorista
				 , x.cod_veiculo_cavalo
				 , x.placa_cavalo
				 , x.cod_veiculo_carreta
				 , x.placa_carreta
				 , x.user_insert
				 , x.date_insert
				 , x.cancelamento_usuario
				 , x.cancelamento_data
				 , x.num_contratos
				 from xmltable('/historico_cartao/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_historico_cartao(
						 xmltype('<params>' ||
							 <cfif trim(len(arguments.cartao_numero))>
									'<cartao_numero>#arguments.cartao_numero#</cartao_numero>' ||
								</cfif>
								
								<cfif trim(len(arguments.cod_motorista))>
									'<cod_motorista>#arguments.COD_MOTORISTA#</cod_motorista>' ||
								</cfif>
								
								<cfif trim(len(arguments.cod_proprietario))>
									'<cod_proprietario>#arguments.COD_PROPRIETARIO#</cod_proprietario>' ||
								</cfif>
								
								'<tipo_pagto_id>#arguments.TIPO_PAGTO_ID#</tipo_pagto_id>' ||
						   '</params>'))
						  columns
							 contrato_id                integer       path '/arrayItem/contrato_id'
							,num_romaneio               integer       path '/arrayItem/num_romaneio'
							,processo_transporte_codigo integer       path '/arrayItem/processo_transporte_codigo'
							,unidade_negocio            varchar2(200) path '/arrayItem/unidade_negocio'
							,centro_custo               varchar2(200) path '/arrayItem/centro_custo'
							,num_cartao                 varchar2(200) path '/arrayItem/num_cartao'
							,proprietario_cnpj_cpf      varchar2(200) path '/arrayItem/proprietario_cnpj_cpf'
							,proprietario_razao_social  varchar2(200) path '/arrayItem/proprietario_razao_social'
							,proprietario               varchar2(200) path '/arrayItem/proprietario'
							,motorista_cpf              varchar2(200) path '/arrayItem/motorista_cpf'
							,motorista                  varchar2(200) path '/arrayItem/motorista'
							,cod_veiculo_cavalo         varchar2(200) path '/arrayItem/cod_veiculo_cavalo'
							,placa_cavalo               varchar2(200) path '/arrayItem/placa_cavalo'
							,cod_veiculo_carreta        varchar2(200) path '/arrayItem/cod_veiculo_carreta'
							,placa_carreta              varchar2(200) path '/arrayItem/placa_carreta'
							,user_insert                varchar2(200) path '/arrayItem/user_insert'
							,date_insert                varchar2(200) path '/arrayItem/date_insert'
							,cancelamento_usuario       varchar2(200) path '/arrayItem/cancelamento_usuario'
							,cancelamento_data          varchar2(200) path '/arrayItem/cancelamento_data'
							,num_contratos              integer       path '/arrayItem/num_contratos'
						 ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_rota" access="remote" returntype="query" output="true">
    	<cfargument name="tipo_pagto_id" required="no" default="" />
		<cfargument name="rota_id" required="no" default="" />
		<cfargument name="origem_municipio_id" required="no" default="" />
		<cfargument name="destino_municipio_id" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.rota_id
				 , x.abreviatura
				 , x.descricao_rota
				 , x.descricao_via
				 , x.origem_municipio_id
				 , x.origem
				 , x.origem_cod_pessoa
				 , x.origem_latitude
				 , x.origem_longitude
				 , x.destino_municipio_id
				 , x.destino
				 , x.destino_cod_pessoa
				 , x.destino_latitude
				 , x.destino_longitude
				 , x.distancia_padrao
				 , x.distancia_hodometro
				 , x.consolidado
				 , x.referencia_origem_id
				 , x.referencia_origem
				 , x.referencia_destino_id
				 , x.referencia_destino
				 , x.user_insert
				 , x.date_insert
				 , x.user_update
				 , x.date_update
				 , x.situacao_id
				 , case 
				      when x.situacao_id = 1 then 'OK'
					  else x.validacao_operadora
				   end as validacao_operadora
				 , x.ida_volta as PEDAGIO_IDA_VOLTA
				 , nvl(x.situacao_id, 0) as possui_rota_operadora
				 from xmltable('/rotas/arrayItem' passing pagfrete.pkg_contrato_backend.fnc_rota(
						 xmltype('<params>' ||
								<cfif len(trim(arguments.rota_id))>
									'<rota_id>#arguments.ROTA_ID#</rota_id>' ||
								</cfif>
								
								<cfif len(trim(arguments.origem_municipio_id))>
									'<origem_municipio_id>#arguments.ORIGEM_MUNICIPIO_ID#</origem_municipio_id>' ||
								</cfif>
								
								<cfif len(trim(arguments.destino_municipio_id))>
									'<destino_municipio_id>#arguments.DESTINO_MUNICIPIO_ID#</destino_municipio_id>' ||
								</cfif>
								
								'<tipo_pagto_id>#arguments.TIPO_PAGTO_ID#</tipo_pagto_id>' ||
						   '</params>'))
						  columns
							        rota_id               integer       path '/arrayItem/rota_id'
								   ,abreviatura           varchar2(200) path '/arrayItem/abreviatura'
								   ,descricao_rota        varchar2(200) path '/arrayItem/descricao_rota'
								   ,descricao_via         varchar2(200) path '/arrayItem/descricao_via'
								   ,origem_municipio_id   integer       path '/arrayItem/origem_municipio_id'
								   ,origem                varchar2(200) path '/arrayItem/origem'
								   ,origem_cod_pessoa     integer       path '/arrayItem/origem_cod_pessoa'
								   ,origem_latitude       number        path '/arrayItem/origem_latitude'
								   ,origem_longitude      number        path '/arrayItem/origem_longitude'
								   ,destino_municipio_id  integer       path '/arrayItem/destino_municipio_id'
								   ,destino               varchar2(200) path '/arrayItem/destino'
								   ,destino_cod_pessoa    integer       path '/arrayItem/destino_cod_pessoa'
								   ,destino_latitude      number        path '/arrayItem/destino_latitude'
								   ,destino_longitude     number        path '/arrayItem/destino_longitude'
								   ,distancia_padrao      number        path '/arrayItem/distancia_padrao'
								   ,distancia_hodometro   number        path '/arrayItem/distancia_hodometro'
								   ,consolidado           varchar2(30)  path '/arrayItem/consolidado'
								   ,referencia_origem_id  integer       path '/arrayItem/referencia_origem_id'
								   ,referencia_origem     varchar2(200) path '/arrayItem/referencia_origem'
								   ,referencia_destino_id integer       path '/arrayItem/referencia_destino_id'
								   ,referencia_destino    varchar2(200) path '/arrayItem/referencia_destino'
								   ,situacao_id  		  integer       path '/arrayItem/situacao_id'
								   ,ida_volta  		      integer       path '/arrayItem/ida_volta'
								   ,validacao_operadora   varchar2(200) path '/arrayItem/validacao_operadora'
								   ,user_insert           varchar2(30)  path '/arrayItem/user_insert'
								   ,date_insert           varchar2(30)  path '/arrayItem/date_insert'
								   ,user_update           varchar2(30)  path '/arrayItem/user_update'
								   ,date_update           varchar2(30)  path '/arrayItem/date_update'
						 ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
	
	<cffunction name="get_valor_atributo_operadora" access="remote" returntype="query" output="true">
    	<cfargument name="tipo_pagto_id" required="yes" />
		<cfargument name="atributo_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select x.atributo_valor
				 from xmltable('/atributo' passing pagfrete.pkg_contrato_backend.fnc_valor_atributo_operadora(
						 xmltype('<params>' ||
								'<tipo_pagto_id>#arguments.TIPO_PAGTO_ID#</tipo_pagto_id>' ||
								'<atributo_id>#arguments.ATRIBUTO_ID#</atributo_id>' ||
						   '</params>'))
						  columns
							        atributo_valor varchar2(4000) path '//atributo_valor'
						 ) x
		</cfquery>

		<cfreturn qr_result>
    </cffunction>
</cfcomponent>
