<html>
<cfinclude template="/_scripts/scripts.cfm" />
<cfinclude template="/_include/carregando.cfm" />

<cfscript>
    v_possui_acao_quitar_contr = 0;
    v_possui_acao_debito = 0;
    v_possui_acao_credito = 0;
	v_possui_acao_bloquear = 0;
	v_possui_acao_desbloquear = 0;
	v_possui_acao_dispensa_doc = 0;
	v_possui_acao_nivel_exigencia_doc = 0;
	v_possui_acao_liberar_viagem = 0;
	v_possui_acao_add_adto = 0;
	v_possui_acao_abonar_valor = 0;
	v_possui_acao_estornar_quit = 0;
	v_possui_acao_imprimir_recibo = 0;
	v_possui_acao_alterar_local_quit = 0;
	v_possui_acao_cancelar_amortizado = 0;

    if(!IsDefined("vars.web_url")){
	   vars.web_url = '/modulos/pagbem/lista_contratos/filtro.cfm';
	}

    conn = CreateComponent("modulos.pagbem._componentes.consulta.cfc_acesso");
    qrAcaoUsuario = conn.get_acao_usuario(web_url = vars.web_url);
</cfscript>

<cfloop query="qrAcaoUsuario">
	<cfscript>
		if(qrAcaoUsuario.COD_ACAO eq 'PAGBEM_QUITAR_CONTRATO' and v_possui_acao_quitar_contr eq 0) {
			v_possui_acao_quitar_contr = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'PAGBEM_DEBITO_CONTRATO' and v_possui_acao_debito eq 0) {
			v_possui_acao_debito = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'PAGBEM_CREDITO_CONTRATO' and v_possui_acao_credito eq 0) {
			v_possui_acao_credito = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'M351_BLOQUEAR_CONTRATO') {
			v_possui_acao_bloquear = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'M351_DESBLOQUEAR_CONTRATO') {
			v_possui_acao_desbloquear = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'M351_DISPENSA_ENTREGA_DOC') {
			v_possui_acao_dispensa_doc = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'M351_NIVEL_EXIGENCIA_DOC') {
			v_possui_acao_nivel_exigencia_doc = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'M351_LIBERAR_VIAGEM') {
			v_possui_acao_liberar_viagem = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'M351_ADICIONAR_VALOR_ADTO') {
			v_possui_acao_add_adto = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'M351_ABONAR_VALOR') {
			v_possui_acao_abonar_valor = 1;
		}
		
		if(qrAcaoUsuario.COD_ACAO eq 'M351_ESTORNAR_QUITACAO') {
			v_possui_acao_estornar_quit = 1;
		}
		
		if(qrAcaoUsuario.COD_ACAO eq 'M351_IMPRIMIR_RECIBO') {
			v_possui_acao_imprimir_recibo = 1;
		}
		
		if(qrAcaoUsuario.COD_ACAO eq 'M351_ALTERA_LOCAL_QUITACAO') {
			v_possui_acao_alterar_local_quit = 1;
		}
		
		if(qrAcaoUsuario.COD_ACAO eq 'M351_CANCELAR_CONTRATO_AMORTIZADO') {
			v_possui_acao_cancelar_amortizado = 1;
		}

	</cfscript>
</cfloop>


<cfscript>
	conn       = CreateComponent("modulos.pagbem._componentes.consulta.cfc_pagbem");
	qrContrato = conn.get_contrato(argumentCollection = vars);
	
	if (v_possui_acao_bloquear eq 1){
		vars.RV_DOMAIN = 'MOTIVO BLOQUEIO CONTRATO';
		qrMotivoBloqueio = conn.get_cg_ref_codes(argumentCollection = vars);
	}
	
	if (v_possui_acao_desbloquear){
		vars.RV_DOMAIN = 'MOTIVO DESBLOQUEIO CONTRATO';
		qrMotivoDesbloqueio = conn.get_cg_ref_codes(argumentCollection = vars);
	}
	
	if (v_possui_acao_dispensa_doc eq 1){
		vars.RV_DOMAIN = 'DOCUMENTOS DISPENSA ENTREGA';
		qrDocumentosDispensaEntrega = conn.get_cg_ref_codes(argumentCollection = vars);
	}
	
	if (v_possui_acao_nivel_exigencia_doc eq 1){
		vars.RV_DOMAIN = 'DOCUMENTOS NIVEL EXIGENCIA';
		qrDocumentosNivelExigencia = conn.get_cg_ref_codes(argumentCollection = vars);
	}
	
	if (v_possui_acao_alterar_local_quit eq 1){
		vars.RV_DOMAIN = 'LOCAL QUITACAO';
		qrLocalQuitacao = conn.get_cg_ref_codes(argumentCollection = vars);
	}
	
	if(v_possui_acao_quitar_contr eq 1) {
		conn          = CreateComponent("modulos.pagbem._componentes.consulta.cfc_funcionario");
		qrOrganograma = conn.get_organograma();
	}
</cfscript>

<script src="/_scripts/dragdrop/drag.js" type="text/javascript"></script>
<script type="text/javascript">
	// Configura botoes //
	parent.f_set_texto('titulo_aplicacao', 'Pagbem');
	parent.f_set_texto('titulo_pagina', 'Lista de Contratos');

	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); }

	parent.f_hidden('btn_incluir');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	parent.f_hidden('btn_confirmar');

	f_cria_botao('filtro','Filtro',"window.location = 'filtro.cfm';", parent.document.getElementById('barra_botoes_top'));

	// -------------------- //

	<cfif v_possui_acao_quitar_contr eq 1>
		var v_departamento = [];
		var v_setor		   = [];
		var v_centro_custo = [];

		<cfoutput query="qrOrganograma">
			v_departamento.push( {
				cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
				cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
				departamento: 	  '#JSStringFormat(qrOrganograma.DEPARTAMENTO)#'
			} );
		</cfoutput>

		<cfoutput query="qrOrganograma">

			v_setor.push( {
				cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
				cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
				cod_setor:		  '#JSStringFormat(qrOrganograma.COD_SETOR)#',
				setor:			  '#JSStringFormat(qrOrganograma.SETOR)#'
			} );

		</cfoutput>

		<cfoutput query="qrOrganograma">
			v_centro_custo.push( {
				cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
				cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
				cod_setor:		  '#JSStringFormat(qrOrganograma.COD_SETOR)#',
				cod_centro_custo: '#JSStringFormat(qrOrganograma.COD_CENTRO_CUSTO)#',
				centro_custo: 	  '#JSStringFormat(qrOrganograma.CENTRO_CUSTO)#',
				cod_organograma:  '#JSStringFormat(qrOrganograma.COD_ORGANOGRAMA)#'
			} );
		</cfoutput>
	</cfif>

	var setObrigatorio  = [];
	var setLimparCampos = [];

	setObrigatorio['quitar_contrato'] = function(p_valor, p_quitacao_quebra_peso) {
		with(document.forms[0]) {
			<cfif v_possui_acao_quitar_contr eq 1>
				if(p_valor == 1 && p_quitacao_quebra_peso == 1) {
					PESO_ENTREGA.setAttribute('obrigatorio', p_valor);
				}
				else {
					PESO_ENTREGA.setAttribute('obrigatorio', 0);
				}
			</cfif>
		}
	}

	setLimparCampos['quitar_contrato'] = function() {
		with(document.forms[0]) {
			<cfif v_possui_acao_quitar_contr eq 1>
				PESO_ENTREGA.value = '';
			</cfif>
		}
	}

		var p = new PopupMenu('pop');
	p.addItem('imn_atualizar', 					 'Atualizar...', 					  '/_imagens/botoes/16x16/atualizar.gif', 				  function() { f_atualizar(); });
	p.addSeparator('ims_1');
	p.addItem('imn_reintegrar_contrato',         'Reintegrar Contrato...',            '/_imagens/botoes/16x16/engrenagem.gif', 				  function() { f_reintegrar_contrato(); });
	p.addItem('imn_cancelar_contrato', 			 'Cancelar Contrato...', 			  '/_imagens/botoes/16x16/cancelar.gif', 				  function() { f_cancelar_contrato(); });
	p.addItem('imn_consultar_dados_viagem', 	 'Consultar Dados da Viagem...', 	  '/_imagens/botoes/16x16/lista_veiculos.gif', 			  function() { f_consultar_dados_viagem(); });
	p.addItem('imn_reimprimir_contrato', 		 'Reimprimir Contrato...', 			  '/_imagens/botoes/16x16/imprimir.gif', 				  function() { f_reimprimir_contrato(); });
	p.addItem('imn_consultar_dados_contrato', 	 'Consultar Dados do Contrato...', 	  '/_imagens/botoes/16x16/consultar_contrato_pagbem.gif',  function() { f_consultar_dados_contrato(); });

	<cfif v_possui_acao_debito eq 1>
	   p.addItem('imn_inserir_debito_contrato', 	 'Inserir Dbito no Contrato...', 	  '/_imagens/botoes/16x16/nota_debito.gif', 			  function() { f_inserir_debito_contrato(); });
	</cfif>

	<cfif v_possui_acao_credito eq 1>
	   p.addItem('imn_inserir_credito_contrato', 	 'Inserir Crdito no Contrato...', 	  '/_imagens/botoes/16x16/nota_credito.gif', 			  function() { f_inserir_credito_contrato(); });
	</cfif>

	<cfif v_possui_acao_bloquear eq 1>
	   p.addItem('imn_bloquear_contrato', 			 'Bloquear Contrato...', 				  '/_imagens/botoes/16x16/bloquear_contrato.png', 	  function() { f_mostrar_div(1); });
	</cfif>
	
	<cfif v_possui_acao_alterar_local_quit eq 1>
	   p.addItem('imn_alterar_local_quitacao', 			 'Alterar Local de Quitao...', 				  '/_imagens/botoes/16x16/alterar_local_quitacao.png', 	  function() { f_mostrar_div(8); });
	</cfif>

	<cfif v_possui_acao_desbloquear eq 1>
	   p.addItem('imn_desbloquear_contrato', 			 'Desbloquear Contrato...', 				  '/_imagens/botoes/16x16/desbloquear_contrato.png', 	  function() { f_mostrar_div(2); });
	</cfif>
	
	<cfif v_possui_acao_dispensa_doc eq 1>
	   p.addItem('imn_dispensa_doc', 			 'Dispensar Documento de Entrega...', 				  '/_imagens/botoes/16x16/dispensar_documento.png', 	  function() { f_mostrar_div(3); });
	</cfif>
	
	<cfif v_possui_acao_nivel_exigencia_doc eq 1>
	   p.addItem('imn_nivel_exigencia_doc', 			 'Alterar Nvel de Exigncia de Documento...', 				  '/_imagens/botoes/16x16/altera_nivel_exigencia.png', 	  function() { f_mostrar_div(4); });
	</cfif>
	
	<cfif v_possui_acao_liberar_viagem eq 1>
	   p.addItem('imn_liberar_viagem', 			 'Liberar Contrato...', 				  '/_imagens/botoes/16x16/liberar_contrato.png', 	  function() { f_liberar_viagem(); });
	</cfif>
	
	<cfif v_possui_acao_add_adto eq 1>
	   p.addItem('imn_adicionar_adto', 			 'Adicionar Valor de Adiantamento...', 				  '/_imagens/botoes/16x16/alterar_adto.png', 	  function() { f_mostrar_div(5); });
	</cfif>
	
	<cfif v_possui_acao_abonar_valor eq 1>
	   p.addItem('imn_abonar_valor', 			 'Abonar Valor...', 				  '/_imagens/botoes/16x16/abonar_valor.gif', 	  function() { f_mostrar_div(6); });
	</cfif>
	
	<cfif v_possui_acao_quitar_contr eq 1>
	   p.addItem('imn_quitar_contrato', 			 'Quitar Contrato...', 				  '/_imagens/botoes/16x16/quitar_contrato_pagbem.gif', 	  function() { f_mostrar_div(0); });
	</cfif>
	
	<cfif v_possui_acao_estornar_quit eq 1>
	   p.addItem('imn_estornar_quitacao', 			 'Estornar Quitao...', 				  '/_imagens/botoes/16x16/estornar_quitacao_pagbem.png', 	  function() { f_estornar_quitacao(); });
	</cfif>
	
	<cfif v_possui_acao_imprimir_recibo eq 1>
	   p.addItem('imn_imprimir_recibo', 			 'Imprimir Recibo de Quitao...', 				  '/_imagens/botoes/16x16/imprimir_recibo.png', 	  function() { f_imprimir_recibo(); });
	</cfif>
	
	function f_context(event, p_contrato_id, p_lancto_id, p_tipo_contrato, p_situacao_id, p_contrato_quitado, p_contrato_quitacao_id, p_data_autorizacao, p_quitacao_quebra_peso, p_data_cancelamento, p_valor_amortizado) {
		with(document.forms[0]) {
			CONTRATO_ID.value          = p_contrato_id;
			LANCTO_ID.value            = p_lancto_id;
			CONTRATO_QUITACAO_ID.value = p_contrato_quitacao_id;
			QUITACAO_QUEBRA_PESO.value = p_quitacao_quebra_peso;
			VALOR_AMORTIZADO.value     = p_valor_amortizado;

			if(Number(p_situacao_id) != 2) {
				p.itemIds['imn_reintegrar_contrato'].setVisible(true);
			}
			else {
				p.itemIds['imn_reintegrar_contrato'].setVisible(false);
			}

			p.itemIds['imn_cancelar_contrato'].setVisible(true);
			p.itemIds['imn_consultar_dados_viagem'].setVisible(true);

			if(p_data_cancelamento.trim() == '') {
				p.itemIds['imn_reimprimir_contrato'].setVisible(true);
			}else{
				p.itemIds['imn_reimprimir_contrato'].setVisible(false);
			}


			p.itemIds['imn_consultar_dados_contrato'].setVisible(true);

			<cfif v_possui_acao_quitar_contr eq 1>
				if(Number(p_contrato_quitado) == 0) {
					p.itemIds['imn_quitar_contrato'].setVisible(true);
				}
				else {
					p.itemIds['imn_quitar_contrato'].setVisible(false);
				}
			</cfif>

			<cfif v_possui_acao_debito eq 1>
				p.itemIds['imn_inserir_debito_contrato'].setVisible(true);
			</cfif>

			<cfif v_possui_acao_credito eq 1>
				p.itemIds['imn_inserir_credito_contrato'].setVisible(true);
			</cfif>
			
			<cfif v_possui_acao_bloquear eq 1>
				p.itemIds['imn_bloquear_contrato'].setVisible(true);
			</cfif>
			
			<cfif v_possui_acao_alterar_local_quit eq 1>
				p.itemIds['imn_alterar_local_quitacao'].setVisible(true);
			</cfif>
			
			<cfif v_possui_acao_desbloquear eq 1>
				p.itemIds['imn_desbloquear_contrato'].setVisible(true);
			</cfif>
			
			<cfif v_possui_acao_dispensa_doc eq 1>
				p.itemIds['imn_dispensa_doc'].setVisible(true);
			</cfif>
			
			<cfif v_possui_acao_nivel_exigencia_doc eq 1>
				p.itemIds['imn_nivel_exigencia_doc'].setVisible(true);
			</cfif>
			
			<cfif v_possui_acao_liberar_viagem eq 1>
				p.itemIds['imn_liberar_viagem'].setVisible(true);
			</cfif>
			
			<cfif v_possui_acao_add_adto eq 1>
				p.itemIds['imn_adicionar_adto'].setVisible(true);
			</cfif>
			
			<cfif v_possui_acao_abonar_valor eq 1>
				p.itemIds['imn_abonar_valor'].setVisible(true);
			</cfif>
			
			<cfif v_possui_acao_estornar_quit eq 1>
				p.itemIds['imn_estornar_quitacao'].setVisible(true);
			</cfif>

			<cfif v_possui_acao_imprimir_recibo eq 1>
				p.itemIds['imn_imprimir_recibo'].setVisible(true);
			</cfif>
			
			return p.contextMenu(event);
		}
	}

	function f_reintegrar_contrato() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/modulos/pagbem/lista_contratos/integrar_contrato.cfm</cf_url>?contrato_id=' + CONTRATO_ID.value, 'IntegrarContrato', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_cancelar_contrato() {
		with(document.forms[0]) {
			if(LANCTO_ID.value != '') {
				if(VALOR_AMORTIZADO.value != 0){
				  if (<cfoutput>#v_possui_acao_cancelar_amortizado#</cfoutput> == 1){
				     if(confirm('Este contrato possui o valor amortizado de R$ ' + VALOR_AMORTIZADO.value + ' , voc tem certeza que deseja cancelar este contrato?')){
					    f_abrir_janela('/modulos/contratotransp/emitir/cancelar.cfm?lancto_id='+LANCTO_ID.value + '&tipo_pagto_id=6', 'f_atualizar()','600', '200');
					 }
				  }else{
				     alert('No  possvel cancelar este contrato pois ele possui o valor amortizado de R$ ' + VALOR_AMORTIZADO.value + ' e seu usurio no possui permisso para cancelar contratos amortizados.');
				  }
				}else{				
				   f_abrir_janela('/modulos/contratotransp/emitir/cancelar.cfm?lancto_id='+LANCTO_ID.value + '&tipo_pagto_id=6', 'f_atualizar()','600', '200');
				}
			}
			else {
				if(confirm('Tem certeza que deseja cancelar este Contrato?')) {
					OPERACAO.value = 2;

					target = 'consultas';
					action = 'confirma.cfm';
					method = 'post';
					submit();
					method = 'get';
				}
			}
		}
	}
	
	function f_mostrar_div(idDiv) {
		f_ocultar_divs(idDiv);
		var obj;
		
		switch(idDiv){
			case 0:
				setObrigatorio['quitar_contrato'](1);			
				obj = document.getElementById('div_quitar');
				break;
			case 1:
				obj = document.getElementById('div_bloquear_contrato');
				break;
			case 2:
				obj = document.getElementById('div_desbloquear_contrato');
				break;
			case 3:
				obj = document.getElementById('div_dispensa_doc');
				break;
			case 4:
				obj = document.getElementById('div_nivel_exigencia_doc');
				break;
			case 5:
				obj = document.getElementById('div_add_adto');
				break;
			case 6:
				obj = document.getElementById('div_abonar_valor');
				break;
			case 7:
				obj = document.getElementById('div_estornar_quitacao');
				break;
			case 8:
				obj = document.getElementById('div_alterar_local_quitacao');
				break;
		}		
		
		f_get_scroll();

		if(obj.style.display == 'none') {
			switch(idDiv){
				case 0:
					setTimeout("document.getElementById('div_quitar').style.display = '';", 100);
					break;
				case 1:
					setTimeout("document.getElementById('div_bloquear_contrato').style.display = '';", 100);
					break;
				case 2:
					setTimeout("document.getElementById('div_desbloquear_contrato').style.display = '';", 100);
					break;
				case 3:
					setTimeout("document.getElementById('div_dispensa_doc').style.display = '';", 100);
					break;
				case 4:
					setTimeout("document.getElementById('div_nivel_exigencia_doc').style.display = '';", 100);
					break;
				case 5:
					setTimeout("document.getElementById('div_add_adto').style.display = '';", 100);
					break;
				case 6:
					setTimeout("document.getElementById('div_abonar_valor').style.display = '';", 100);
					break;
				case 8:
					setTimeout("document.getElementById('div_alterar_local_quitacao').style.display = '';", 100);
					break;
			}	
			
			obj.style.top = window.event.clientY + scrOfY;
			obj.style.left = 20 + scrOfX;
		}
	}
	
	function f_bloquear_contrato(){
		with(document.forms[0]) {
			if(!OBSERVACAO_BLOQUEIO.value){
				alert('Campo Observao  obrigatrio');
				
				return false;
			}
		
			if(confirm('Tem certeza que deseja bloquear este Contrato?')) {
				OPERACAO.value = 5;
				LOCK_UNLOCK.value = 0;
				MOTIVO_BLOQUEIO_DESBLOQUEIO.value = MOTIVO_BLOQUEIO.value;
				
				OBSERVACAO.value = OBSERVACAO_BLOQUEIO.value;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_desbloquear_contrato(){
		with(document.forms[0]) {
			if(!OBSERVACAO_DESBLOQUEIO.value){
				alert('Campo Observao  obrigatrio');
				
				return false;
			}
		
			if(confirm('Tem certeza que deseja desbloquear este Contrato?')) {
				OPERACAO.value = 5;
				LOCK_UNLOCK.value = 1;
				MOTIVO_BLOQUEIO_DESBLOQUEIO.value = MOTIVO_DESBLOQUEIO.value;
				
				OBSERVACAO.value = OBSERVACAO_DESBLOQUEIO.value;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_dispensar_doc_entrega(){
		with(document.forms[0]) {
			if(confirm('Tem certeza que deseja dispensar o documento?')) {
				OPERACAO.value = 6;
				DOCUMENTO.value = DOCUMENTO_DISPENSADO.value;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_alterar_nivel_exigencia_doc(){
		with(document.forms[0]) {
			if(confirm('Tem certeza que deseja alterar o nvel de exigncia do documento?')) {
				OPERACAO.value = 7;
				DOCUMENTO.value = DOCUMENTO_ALTERADO.value;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_liberar_viagem(){
		with(document.forms[0]) {
			if(confirm('Tem certeza que deseja liberar o contrato?')) {
				OPERACAO.value = 8;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_adicionar_adto(){
		with(document.forms[0]) {
			if(confirm('Tem certeza que deseja adicionar o valor de adiantamento no contrato?')) {
				OPERACAO.value = 9;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_abonar_valor(){
		with(document.forms[0]) {
			if(confirm('Tem certeza que deseja abonar o valor no contrato?')) {
				OPERACAO.value = 10;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_estornar_quitacao(){
		with(document.forms[0]) {
			if(confirm('Tem certeza que deseja estornar a quitao do contrato?')) {
				OPERACAO.value = 11;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}
	
	function f_imprimir_recibo() {
		with(document.forms[0]) {
			CONSULTA.value = 2;

			target = 'consultas';
			action = 'consultas.cfm';
			submit();
		}
	}
	
	function f_alterar_local_quitacao(){
		with(document.forms[0]) {
			if(confirm('Tem certeza que deseja alterar o local de quitao?')) {
				OPERACAO.value = 12;
				
				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}
	}

	function f_consultar_dados_viagem() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/modulos/pagbem/lista_contratos/dados_viagem.cfm</cf_url>?contrato_id=' + CONTRATO_ID.value, 'DadosViagem', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_reimprimir_contrato() {
		with(document.forms[0]) {
			CONSULTA.value = 1;

			target = 'consultas';
			action = 'consultas.cfm';
			submit();
		}
	}

	function f_consultar_dados_contrato() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/modulos/pagbem/lista_contratos/dados_contrato.cfm</cf_url>?contrato_id=' + CONTRATO_ID.value, 'DadosContrato', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_inserir_debito_contrato() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/modulos/pagbem/lista_contratos/movimentos_contrato.cfm</cf_url>?contrato_id=' + CONTRATO_ID.value + '&lancto_id='+LANCTO_ID.value + '&debito_credito=1&tipo_pagto_id=6', 'DebitoCredito', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_inserir_credito_contrato() {
		with(document.forms[0]) {
			f_abrir_janela('<cf_url>/modulos/pagbem/lista_contratos/movimentos_contrato.cfm</cf_url>?contrato_id=' + CONTRATO_ID.value + '&lancto_id='+LANCTO_ID.value + '&debito_credito=2&tipo_pagto_id=6', 'DebitoCredito', (screen.width * 0.7), (screen.height * 0.7), 'yes');
		}
	}

	function f_ocultar_divs(idDiv) {
		if (idDiv == 0){
			setLimparCampos['quitar_contrato']();
		}

		<cfif v_possui_acao_quitar_contr eq 1>
			f_ocultar_div(0);
		</cfif>
		
		<cfif v_possui_acao_bloquear eq 1>
			f_ocultar_div(1);
		</cfif>
		
		<cfif v_possui_acao_desbloquear eq 1>
			f_ocultar_div(2);
		</cfif>
		
		<cfif v_possui_acao_dispensa_doc eq 1>
			f_ocultar_div(3);
		</cfif>
		
		<cfif v_possui_acao_nivel_exigencia_doc eq 1>
			f_ocultar_div(4);
		</cfif>
		
		<cfif v_possui_acao_add_adto eq 1>
			f_ocultar_div(5);
		</cfif>
		
		<cfif v_possui_acao_abonar_valor eq 1>
			f_ocultar_div(6);
		</cfif>
		
		<cfif v_possui_acao_alterar_local_quit eq 1>
			f_ocultar_div(8);
		</cfif>
	}
	
	function f_ocultar_div(idDiv) {
		switch(idDiv){
			case 0:
				document.getElementById('div_quitar').style.display = 'none';
				break;
			case 1:
				document.getElementById('div_bloquear_contrato').style.display = 'none';
				break;
			case 2:
				document.getElementById('div_desbloquear_contrato').style.display = 'none';
				break;
			case 3:
				document.getElementById('div_dispensa_doc').style.display = 'none';
				break;
			case 4:
				document.getElementById('div_nivel_exigencia_doc').style.display = 'none';
				break;
			case 5:
				document.getElementById('div_add_adto').style.display = 'none';
				break;
			case 6:
				document.getElementById('div_abonar_valor').style.display = 'none';
				break;
			case 8:
				document.getElementById('div_alterar_local_quitacao').style.display = 'none';
				break;
		}
	}

	<cfif v_possui_acao_quitar_contr eq 1>
		function f_quitar_contrato() {
			with(document.forms[0]) {
				OPERACAO.value = 4;

				target = 'consultas';
				action = 'confirma.cfm';
				method = 'post';
				submit();
				method = 'get';
			}
		}

		function f_imprimir_recibo_pagamento() {
			with(document.forms[0]) {
				CONSULTA.value = 2;

				target = 'consultas';
				action = 'consultas.cfm';
				submit();
			}
		}
	</cfif>

		function f_executar_operacao(p_contrato_id, p_lancto_id, p_contrato_quitacao_id, p_quitacao_quebra_peso, p_operacao, p_processo_transporte_codigo, p_placa_cavalo, p_valor_original_adto, p_valor_amortizado) {
		with(document.forms[0]) {
			CONTRATO_ID.value             = p_contrato_id;
			LANCTO_ID.value               = p_lancto_id;
			CONTRATO_QUITACAO_ID.value    = p_contrato_quitacao_id;
			QUITACAO_QUEBRA_PESO.value    = p_quitacao_quebra_peso;
			PROCESSO_TRANSPORTE_CODIGO.value = p_processo_transporte_codigo;
			PLACA_CAVALO.value            = p_placa_cavalo;
			VALOR_AMORTIZADO.value        = p_valor_amortizado;
			
			<cfif v_possui_acao_add_adto eq 1>
				VALOR_ORIGINAL_ADTO.value 	  = p_valor_original_adto;
			</cfif>

			switch(p_operacao) {
				case 'REINTEGRAR':
				    f_reintegrar_contrato();
					break;
				case 'CANCELAR':
				    f_cancelar_contrato();
					break;
				case 'CONSULTAR_DADOS_VIAGEM':
					f_consultar_dados_viagem();
					break;
				case 'REIMPRIMIR':
					f_reimprimir_contrato();
					break;
				case 'CONSULTAR_PAGBEM':
					f_consultar_dados_contrato();
					break;
				<cfif v_possui_acao_bloquear eq 1>
					case 'BLOQUEAR':
						f_mostrar_div(1);
						break;
				</cfif>
				
				<cfif v_possui_acao_desbloquear>
					case 'DESBLOQUEAR':
						f_mostrar_div(2);
						break;
				</cfif>
				
				<cfif v_possui_acao_dispensa_doc>
					case 'DISPENSAR_DOC_ENTREGA':
						f_mostrar_div(3);
						break;
				</cfif>
				
				<cfif v_possui_acao_nivel_exigencia_doc>
					case 'NIVEL_EXIGENCIA_DOC':
						f_mostrar_div(4);
						break;
				</cfif>
				
				<cfif v_possui_acao_liberar_viagem eq 1>
					case 'LIBERAR_VIAGEM':
						f_liberar_viagem();
						break;
				</cfif>
				
				<cfif v_possui_acao_add_adto eq 1>
					case 'ADD_ADTO':
						f_mostrar_div(5);
						break;
				</cfif>
				
				<cfif v_possui_acao_add_adto eq 1>
					case 'ABONAR_VALOR':
						f_mostrar_div(6);
						break;
				</cfif>
				
				<cfif v_possui_acao_alterar_local_quit eq 1>
					case 'ALTERAR_LOCAL_QUITACAO':
						f_mostrar_div(8);
						break;
				</cfif>
				
				<cfif v_possui_acao_estornar_quit eq 1>
					case 'ESTORNAR_QUITACAO':
						f_estornar_quitacao();
						break;
				</cfif>
				
				<cfif v_possui_acao_imprimir_recibo eq 1>
					case 'IMPRIMIR_RECIBO':
						f_imprimir_recibo();
						break;
				</cfif>
				
				<cfif v_possui_acao_quitar_contr eq 1>
					case 'QUITAR':
						f_mostrar_div(0);
						break;
				</cfif>

				<cfif v_possui_acao_credito eq 1>
					case 'INSERIR_CREDITO':
						f_inserir_credito_contrato();
						break;
				</cfif>

				<cfif v_possui_acao_debito eq 1>
					case 'INSERIR_DEBITO':
						f_inserir_debito_contrato();
						break;
				</cfif>

				default:
					alert('Operao no programada.');
					break;
			}
		}
	}

	<cfif v_possui_acao_quitar_contr eq 1>
		function f_busca_departamento() {
			with(document.forms[0]) {
				var v_inserir;

				f_limpa_select(COD_DEPARTAMENTO);
				f_limpa_select(COD_SETOR);
				f_limpa_select(COD_CENTRO_CUSTO);

				f_cria_option('', '-- Selecione um Departamento --', COD_SETOR);
				f_cria_option('', '-- Selecione um Setor --', COD_CENTRO_CUSTO);

				if(!COD_PESSOA_FILIAL.value) {
					f_cria_option('', '-- Selecione uma Filial --', COD_DEPARTAMENTO);

					return;
				}

				f_cria_option('', '-- Selecione --', COD_DEPARTAMENTO);

				for(var i = 0; i < v_departamento.length; i++) {
					if(Number(v_departamento[i].cod_pessoa) == Number(COD_PESSOA_FILIAL.value)) {
						v_inserir = true;

						for(var j = 0; j < COD_DEPARTAMENTO.options.length; j++) {
							if(Number(COD_DEPARTAMENTO.options[j].value) == Number(v_departamento[i].cod_departamento)) {
								v_inserir = false;
							}
						}

						if(v_inserir) {
							f_cria_option(v_departamento[i].cod_departamento, v_departamento[i].cod_departamento + ' - ' + v_departamento[i].departamento, COD_DEPARTAMENTO);
						}
					}
				}

				if(COD_DEPARTAMENTO.options.length == 0) {
					f_cria_option('', '-- Esta Filial no possui nenhum Departamento --', COD_DEPARTAMENTO);
				}
				else if(COD_DEPARTAMENTO.options.length == 2) {
					COD_DEPARTAMENTO.options[0] = null;
					COD_DEPARTAMENTO.options[0].selected = true;
					COD_DEPARTAMENTO.onchange();
				}
			}
		}

		function f_busca_setor() {
			with(document.forms[0]) {
				var v_inserir;

				f_limpa_select(COD_SETOR);
				f_limpa_select(COD_CENTRO_CUSTO);

				f_cria_option('', '-- Selecione um Setor --', COD_CENTRO_CUSTO);

				if(!COD_DEPARTAMENTO.value) {
					f_cria_option('', '-- Selecione um Departamento --', COD_SETOR);

					return;
				}

				f_cria_option('', '-- Selecione --', COD_SETOR);

				for(var i = 0; i < v_setor.length; i++) {
					if((Number(v_setor[i].cod_pessoa) == Number(COD_PESSOA_FILIAL.value)) && (Number(v_setor[i].cod_departamento) == Number(COD_DEPARTAMENTO.value))) {
						v_inserir = true;

						for(var j = 0; j < COD_SETOR.options.length; j++) {
							if(Number(COD_SETOR.options[j].value) == Number(v_setor[i].cod_setor)) {
								v_inserir = false;
							}
						}

						if(v_inserir) {
							f_cria_option(v_setor[i].cod_setor, v_setor[i].cod_setor + ' - ' + v_setor[i].setor, COD_SETOR);
						}
					}
				}

				if(COD_SETOR.options.length == 0) {
					f_cria_option('', '-- Este Departamento no possui nenhum Setor --', COD_SETOR);
				}
				else if(COD_SETOR.options.length == 2) {
					COD_SETOR.options[0] = null;
					COD_SETOR.options[0].selected = true;
					COD_SETOR.onchange();
				}
			}
		}

		function f_busca_centro_custo() {
			with(document.forms[0]) {
				var v_option;

				f_limpa_select(COD_CENTRO_CUSTO);

				if(!COD_SETOR.value) {
					f_cria_option('', '-- Selecione um Setor --', COD_CENTRO_CUSTO);

					return;
				}

				f_cria_option('', '-- Selecione --', COD_CENTRO_CUSTO);

				for(var i = 0; i < v_centro_custo.length; i++) {
					if((Number(v_centro_custo[i].cod_pessoa) == Number(COD_PESSOA_FILIAL.value)) && (Number(v_centro_custo[i].cod_departamento) == Number(COD_DEPARTAMENTO.value)) && (Number(v_centro_custo[i].cod_setor) == Number(COD_SETOR.value))) {
						v_option = f_cria_option(v_centro_custo[i].cod_centro_custo, v_centro_custo[i].cod_centro_custo + ' - ' + v_centro_custo[i].centro_custo, COD_CENTRO_CUSTO);
						v_option.setAttribute('cod_organograma', v_centro_custo[i].cod_organograma);
					}
				}

				if(COD_CENTRO_CUSTO.options.length == 0) {
					f_cria_option('', '-- Este Setor no possui nenhum Centro de Custo --', COD_CENTRO_CUSTO);
				}
				else if(COD_CENTRO_CUSTO.options.length == 2) {
					COD_CENTRO_CUSTO.options[0] = null;
					COD_CENTRO_CUSTO.options[0].selected = true;
					COD_CENTRO_CUSTO.onchange();
				}
			}
		}

		function f_muda_centro_custo() {
			with(document.forms[0]) {
				COD_ORGANOGRAMA.value = COD_CENTRO_CUSTO.options[COD_CENTRO_CUSTO.selectedIndex].getAttribute('cod_organograma');
			}
		}
	</cfif>
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/status.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height: 100%;">
<script src="/_scripts/dragdrop.js" type="text/javascript"></script>
<form id="form_transportes" name="form_transportes" method="get" action="" onSubmit="return f_confirmar()">
    <input type="hidden" name="OPERACAO" id="OPERACAO" value="" sempre_ativo="1" />
    <input type="hidden" name="CONSULTA" id="CONSULTA" value="" sempre_ativo="1" />
    <input type="hidden" name="CONTRATO_ID" id="CONTRATO_ID" value="" sempre_ativo="1" />
    <input type="hidden" name="PROCESSO_TRANSPORTE_CODIGO" id="PROCESSO_TRANSPORTE_CODIGO" value="" sempre_ativo="1" />
    <input type="hidden" name="PLACA_CAVALO" id="PLACA_CAVALO" value="" sempre_ativo="1" />
    <input type="hidden" name="LANCTO_ID" id="LANCTO_ID" value="" sempre_ativo="1" />
    <input type="hidden" name="CONTRATO_QUITACAO_ID" id="CONTRATO_QUITACAO_ID" value="" sempre_ativo="1" />
    <input type="hidden" name="QUITACAO_QUEBRA_PESO" id="QUITACAO_QUEBRA_PESO" value="" sempre_ativo="1" />
    <input type="hidden" name="COD_ORGANOGRAMA" id="COD_ORGANOGRAMA" value="" sempre_ativo="1" />
    <input type="hidden" name="LOCK_UNLOCK" id="LOCK_UNLOCK" value="" sempre_ativo="1" />
	<input type="hidden" name="OBSERVACAO" id="OBSERVACAO" value="" sempre_ativo="1" />
	<input type="hidden" name="MOTIVO_BLOQUEIO_DESBLOQUEIO" id="MOTIVO_BLOQUEIO_DESBLOQUEIO" value="" sempre_ativo="1" />
	<input type="hidden" name="DOCUMENTO" id="DOCUMENTO" value="" sempre_ativo="1" />
	<input type="hidden" name="VALOR_ADD_ADTO" id="VALOR_ADD_ADTO" value="" sempre_ativo="1" />
    <input type="hidden" name="VALOR_AMORTIZADO" id="VALOR_AMORTIZADO" value="" sempre_ativo="1" />
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
		<cfset grid_cod = 'PAGBEM_LISTA_CONTRATOS_#v_possui_acao_quitar_contr#_#v_possui_acao_debito#_#v_possui_acao_credito#'>

        <cfif qrContrato.RecordCount gt 0>
      	<tr>
        	<td>

				<cfset grid_query = 'qrContrato'>
                <cfset grid_field_list    = ''>
                <cfset grid_field_caption = ''>
                <cfset grid_field_align   = ''>
                <cfset grid_field_type    = ''>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'REINTEGRAR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Reintegrar Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CANCELAR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cancelar Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CONSULTAR_DADOS_VIAGEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Consultar Dados da Viagem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'REIMPRIMIR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Reimprimir Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CONSULTAR_PAGBEM')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Consultar Dados do Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
				
				<cfif v_possui_acao_bloquear eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'BLOQUEAR')>
					<cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Bloquear Contrato</nobr>')>
					<cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
					<cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
				</cfif>

				<cfif v_possui_acao_desbloquear eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'DESBLOQUEAR')>
					<cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Desbloquear Contrato</nobr>')>
					<cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
					<cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>								
				</cfif>
				
				<cfif v_possui_acao_dispensa_doc eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'DISPENSAR_DOC_ENTREGA')>
					<cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Dispensar Documento de Entrega</nobr>')>
					<cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
					<cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>								
				</cfif>
				
				<cfif v_possui_acao_nivel_exigencia_doc eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'NIVEL_EXIGENCIA_DOC')>
					<cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Alterar Nvel de Exigncia de Documento</nobr>')>
					<cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
					<cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>								
				</cfif>
				
				<cfif v_possui_acao_liberar_viagem eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'LIBERAR_VIAGEM')>
					<cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Liberar Contrato</nobr>')>
					<cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
					<cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>								
				</cfif>
				
				<cfif v_possui_acao_alterar_local_quit eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'ALTERAR_LOCAL_QUITACAO')>
					<cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Alterar Local de Quitao</nobr>')>
					<cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
					<cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
				</cfif>

				<cfif v_possui_acao_debito eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'INSERIR_DEBITO')>
	                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserir Dbito no Contrato</nobr>')>
	                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
	                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
				</cfif>
				
				<cfif v_possui_acao_credito eq 1>
	                <cfset grid_field_list 	  = ListAppend(grid_field_list,'INSERIR_CREDITO')>
	                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserir Crdito no Contrato</nobr>')>
	                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
	                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
				</cfif>
				
				<cfif v_possui_acao_add_adto eq 1>
	                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ADD_ADTO')>
	                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Adicionar Adiantamento no Contrato</nobr>')>
	                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
	                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
				</cfif>
				
				<cfif v_possui_acao_abonar_valor eq 1>
	                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ABONAR_VALOR')>
	                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Abonar Valor</nobr>')>
	                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
	                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
				</cfif>

                <cfif v_possui_acao_quitar_contr eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'QUITAR')>
                    <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Quitar Contrato</nobr>')>
                    <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                    <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                </cfif>
				
				<cfif v_possui_acao_estornar_quit eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'ESTORNAR_QUITACAO')>
                    <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Estornar Quitao Contrato</nobr>')>
                    <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                    <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                </cfif>

				<cfif v_possui_acao_imprimir_recibo eq 1>
					<cfset grid_field_list 	  = ListAppend(grid_field_list,'IMPRIMIR_RECIBO')>
                    <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Imprimir Recibo de Quitao</nobr>')>
                    <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                    <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                </cfif>
				
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TIPO_CONTRATO_DESC')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tipo Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'INTERNACIONAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Internacional</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_ROMANEIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Romaneio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'LANCTO_ID')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Contrato Transporte</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PROCESSO_TRANSPORTE_CODIGO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'MODALIDADE_VEICULO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Modalidade</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_CODIGO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Status Pagbem</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_UNIDADE_NEGOCIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>C&oacute;d. Unidade Neg&oacute;cio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'FILIAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Filial</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_CENTRO_CUSTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>C&oacute;d. Centro Custo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CENTRO_CUSTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Centro Custo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_EMISSAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data Emiss&atilde;o Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SITUACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Situa&ccedil;&atilde;o Integra&ccedil;&atilde;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CARTAO_NUMERO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cart&atilde;o N&uacute;mero</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CNPJ_CPF_PROPRIETARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>CNPJ/CPF Propriet&aacute;rio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PROPRIETARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Propriet&aacute;rio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CPF_MOTORISTA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>CPF Motorista</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'MOTORISTA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Motorista</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_CAVALO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Frota Cavalo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PLACA_CAVALO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Placa Cavalo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_CARRETA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Frota Carreta</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PLACA_CARRETA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Placa Carreta</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ROTA_ID')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>C&oacute;d. Rota</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ROTA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Rota</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_INICIAL_ADIANTAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Inicial Adto.</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_INICIAL_FRETE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Inicial Frete</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_FRETE_BRUTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Bruto Contrato</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'PERCENTUAL_RECEITA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>% Atual Custo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USER_INSERT')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserido Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATE_INSERT')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Inserido Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USUARIO_CANCELAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cancelado Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_CANCELAMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cancelado Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CONTRATO_QUITADO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Local Quita&ccedil;&atilde;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USUARIO_QUITACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Quitado Por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_QUITACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Quitado Em</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'OBSERVACAO_APROVACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Obs. Aprova&ccedil;&atilde;o</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'CARTAO_PROPRIETARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Cart&atilde;o N&uacute;mero Propriet&aacute;rio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
				<cfset grid_field_list 	  = ListAppend(grid_field_list,'VALOR_AMORTIZADO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Valor Amortizado</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'right')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
				
                <cfset grid_td_context_eval 		  = 'fnc_grid_td_context_eval'>
				<cfset grid_tr_class_function 		  = 'fnc_grid_tr_class'>
                <cfset grid_tr_onclick_function 	  = 'fnc_grid_tr_onclick'>
                <cfset grid_td_inline_function 		  = 'fnc_grid_td_inline'>
                <cfset grid_td_class_function 		  = 'fnc_grid_td_class'>
                <cfset grid_td_style_function		  = 'fnc_grid_td_style'>
                <cfset grid_tr_oncontextmenu_function = 'fnc_grid_tr_oncontext_menu'>
                <cfset grid_td_title_function         = 'fnc_grid_td_title_function'>

                <cfscript>
                    function fnc_grid_td_context_eval(field) {
                        switch(ucase(field)) {
							case "REINTEGRAR":
								if(qrContrato.SITUACAO_ID neq 2 and not Len(Trim(qrContrato.DATA_CANCELAMENTO))) {
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#REINTEGRAR#chr(39)#)"><img src="/_imagens/botoes/16x16/engrenagem.gif" alt="Reintegrar Contrato" title="Reintegrar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/engrenagem_disable.gif" alt="Reintegrar Contrato" title="Reintegrar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}


								break;
							case "CANCELAR":
							    if (qrContrato.STATUS_CODIGO neq 'Frete_Finalizado' and not Len(Trim(qrContrato.DATA_CANCELAMENTO))){
								    return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#CANCELAR#chr(39)# ,0 ,0 ,0, #chr(39)##qrContrato.VALOR_AMORTIZADO##chr(39)# )"><img src="/_imagens/botoes/16x16/cancelar.gif" alt="Cancelar Contrato" title="Cancelar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/cancelar_disable.gif" alt="Cancelar Contrato" title="Cancelar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "BLOQUEAR":
							    if (len(trim(qrContrato.FRETE_LIBERADO_POR)) and qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )){
								    return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#BLOQUEAR#chr(39)#)"><img src="/_imagens/botoes/16x16/bloquear_contrato.png" alt="Bloquear Contrato" title="Bloquear Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/bloquear_contrato_disabled.png" alt="Bloquear Contrato" title="Bloquear Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "DESBLOQUEAR":
							    if (len(trim(qrContrato.FRETE_LIBERADO_POR)) and qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )){
								    return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#DESBLOQUEAR#chr(39)#)"><img src="/_imagens/botoes/16x16/desbloquear_contrato.png" alt="Desbloquear Contrato" title="Desbloquear Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/desbloquear_contrato_disabled.png" alt="Desbloquear Contrato" title="Desbloquear Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "DISPENSAR_DOC_ENTREGA":
							    if (len(trim(qrContrato.FRETE_LIBERADO_POR)) and qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )){
								    return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#DISPENSAR_DOC_ENTREGA#chr(39)#)"><img src="/_imagens/botoes/16x16/dispensar_documento.png" alt="Dispensar Documento de Entrega" title="Dispensar Documento de Entrega" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/dispensar_documento_disabled.png" alt="Desbloquear Contrato" title="Desbloquear Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "LIBERAR_VIAGEM":
							    if ((not len(trim(qrContrato.FRETE_LIBERADO_POR))) and qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )){
								    return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#LIBERAR_VIAGEM#chr(39)#)"><img src="/_imagens/botoes/16x16/liberar_contrato.png" alt="Liberar Contrato" title="Liberar Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/liberar_contrato_disabled.png" alt="Desbloquear Contrato" title="Desbloquear Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "NIVEL_EXIGENCIA_DOC":
							    if (len(trim(qrContrato.FRETE_LIBERADO_POR)) and qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )){
								    return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#NIVEL_EXIGENCIA_DOC#chr(39)#)"><img src="/_imagens/botoes/16x16/altera_nivel_exigencia.png" alt="Alterar Nvel de Exigncia de Documento" title="Alterar Nvel de Exigncia de Documento" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/altera_nivel_exigencia_disabled.png" alt="Desbloquear Contrato" title="Desbloquear Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "ADD_ADTO":
							    if (len(trim(qrContrato.FRETE_LIBERADO_POR)) and qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )){
								    return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#ADD_ADTO#chr(39)#, #chr(39)##qrContrato.PROCESSO_TRANSPORTE_CODIGO##chr(39)#, #chr(39)##qrContrato.PLACA_CAVALO##chr(39)#, #chr(39)##qrContrato.VALOR_ADIANTADO##chr(39)#)"><img src="/_imagens/botoes/16x16/alterar_adto.png" alt="Adicionar Adiantamento no Contrato" title="Adicionar Adiantamento no Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/alterar_adto_disabled.png" alt="Adicionar Adiantamento no Contrato" title="Adicionar Adiantamento no Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "ABONAR_VALOR":
							    if (len(trim(qrContrato.FRETE_LIBERADO_POR)) and qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )){
								    return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#ABONAR_VALOR#chr(39)#, #chr(39)##qrContrato.PROCESSO_TRANSPORTE_CODIGO##chr(39)#, #chr(39)##qrContrato.PLACA_CAVALO##chr(39)#, #chr(39)##qrContrato.VALOR_ADIANTADO##chr(39)#)"><img src="/_imagens/botoes/16x16/abonar_valor.png" alt="Abonar Valor" title="Abonar Valor" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/abonar_valor_disabled.png" alt="Abonar Valor" title="Abonar Valor" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "CONSULTAR_DADOS_VIAGEM":
								return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#CONSULTAR_DADOS_VIAGEM#chr(39)#)"><img src="/_imagens/botoes/16x16/lista_veiculos.gif" alt="Consultar Dados da Viagem" title="Consultar Dados da Viagem" width="16" height="16" align="absmiddle" /></button>';
								break;
							case "REIMPRIMIR":
								if( not Len(Trim(qrContrato.DATA_CANCELAMENTO)) and qrContrato.SITUACAO_ID eq 2 ){
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#REIMPRIMIR#chr(39)#,  #chr(39)##qrContrato.PROCESSO_TRANSPORTE_CODIGO##chr(39)#,  #chr(39)##qrContrato.PLACA_CAVALO##chr(39)#)"><img src="/_imagens/botoes/16x16/imprimir.gif" alt="Reimprimir Contrato" title="Reimprimir Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
								}	return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/imprimir_disable.gif" alt="No  possvel reimprimir o contrato pois o mesmo est cancelado" title="No  possvel reimprimir o contrato pois o mesmo est cancelado" width="16" height="16" align="absmiddle" /></button>';
								break;
							case "CONSULTAR_PAGBEM":
							    if (qrContrato.SITUACAO_ID eq 2) {
								return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#CONSULTAR_PAGBEM#chr(39)#)"><img src="/_imagens/botoes/16x16/consultar_contrato_pagbem.gif" alt="Consultar Dados do Contrato" title="Consultar Dados do Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else{
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/consultar_contrato_pagbem_disable.gif" alt="S  possvel consultar dados de contratos integrados" title="S  possvel consultar dados de contratos integrados" width="16" height="16" align="absmiddle" /></button>';
								}
								break;
							case "QUITAR":
								if(qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )) {
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#QUITAR#chr(39)#)"><img src="/_imagens/botoes/16x16/quitar_contrato_pagbem.gif" alt="Quitar Contrato (Caso o contrato j esteja quitado na Pagbem, mas no possua quitao no KMM, clicar no cone Consultar Dados do Contrato e em seguida atualizar a lista de contratos)" title="Quitar Contrato (Caso o contrato j esteja quitado na gbem, mas no possua quitao no KMM, clicar no cone Consultar Dados do Contrato e em seguida atualizar a lista de contratos)" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/quitar_contrato_pagbem_disable.gif" alt="Quitar Contrato (Caso o contrato j esteja quitado na Pagbem, mas no possua quitao no KMM, clicar no cone Consultar Dados do Contrato e em seguida atualizar a lista de contratos)" title="Quitar Contrato (Caso o contrato j esteja quitado na Pagbem, mas no possua quitao no KMM, clicar no cone Consultar Dados do Contrato e em seguida atualizar a lista de contratos)" width="16" height="16" align="absmiddle" /></button>';
								}

								break;
							case "ESTORNAR_QUITACAO":
								if(qrContrato.CONTRATO_QUITADO eq 1 and qrContrato.STATUS_CODIGO eq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )) {
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#ESTORNAR_QUITACAO#chr(39)#)"><img src="/_imagens/botoes/16x16/estornar_quitacao_pagbem.png" alt="Estornar Quitao Contrato" title="Estornar Quitao Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/estornar_quitacao_pagbem_disabled.png" alt="Estornar Quitao Contrato" title="Estornar Quitao Contrato" width="16" height="16" align="absmiddle" /></button>';
								}

								break;
							case "ALTERAR_LOCAL_QUITACAO":
								if(qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )) {
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#ALTERAR_LOCAL_QUITACAO#chr(39)#)"><img src="/_imagens/botoes/16x16/alterar_local_quitacao.png" alt="Alterar Local de Quitao" title="Alterar Local de Quitao" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/alterar_local_quitacao_disable.png" alt="Alterar Local de Quitao" title="Alterar Local de Quitao" width="16" height="16" align="absmiddle" /></button>';
								}

								break;
							case "IMPRIMIR_RECIBO":
								if(qrContrato.CONTRATO_QUITADO eq 1 and qrContrato.STATUS_CODIGO eq 'Frete_Finalizado' and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )) {
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#IMPRIMIR_RECIBO#chr(39)#,  #chr(39)##qrContrato.PROCESSO_TRANSPORTE_CODIGO##chr(39)#,  #chr(39)##qrContrato.PLACA_CAVALO##chr(39)#)"><img src="/_imagens/botoes/16x16/imprimir_recibo.png" alt="Imprimir Recibo de Quitao" title="Imprimir Recibo de Quitao" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/imprimir_recibo_disable.png" alt="Imprimir Recibo de Quitao" title="Imprimir Recibo de Quitao" width="16" height="16" align="absmiddle" /></button>';
								}

								break;
							case "INSERIR_DEBITO":

								if(ListFind('1,2', qrContrato.TIPO_CONTRATO, ',') and qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 6 and qrContrato.SITUACAO_ID eq 2 and (not len(trim(qrContrato.DATA_CANCELAMENTO)) )) {
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#INSERIR_DEBITO#chr(39)#)"><img src="/_imagens/botoes/16x16/nota_debito.gif" alt="Inserir Dbito no Contrato" title="Inserir Dbito no Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/nota_debito_disable.gif" alt="Inserir Dbito no Contrato" title="Inserir Dbito no Contrato" width="16" height="16" align="absmiddle" /></button>';
								}

								break;
							case "INSERIR_CREDITO":
								if (ListFind('1,2', qrContrato.TIPO_CONTRATO, ',') and qrContrato.CONTRATO_QUITADO eq 0 and qrContrato.STATUS_CODIGO neq 6 and qrContrato.SITUACAO_ID eq 2 and (not len (trim (qrContrato.DATA_CANCELAMENTO)) )) {
									return '<button type="button" id="btn_botao" class="botao-16x16" onClick="f_executar_operacao(#chr(39)##qrContrato.CONTRATO_ID##chr(39)#, #chr(39)##qrContrato.LANCTO_ID##chr(39)#, #chr(39)##qrContrato.CONTRATO_QUITACAO_ID##chr(39)#, #chr(39)##qrContrato.QUITACAO_QUEBRA_PESO##chr(39)#, #chr(39)#INSERIR_CREDITO#chr(39)#)"><img src="/_imagens/botoes/16x16/nota_credito.gif" alt="Inserir Crdito no Contrato" title="Inserir Crdito no Contrato" width="16" height="16" align="absmiddle" /></button>';
								}
								else {
									return '<button type="button" id="btn_botao" class="botao-16x16"><img src="/_imagens/botoes/16x16/nota_credito_disable.gif" alt="Inserir Crdito no Contrato" title="Inserir Crdito no Contrato" width="16" height="16" align="absmiddle" /></button>';
								}

								break;
							case "VALOR_INICIAL_ADIANTAMENTO":
								return LSNumberFormat(qrContrato.VALOR_INICIAL_ADIANTAMENTO, ',.__');
								break;
							case "VALOR_INICIAL_FRETE":
								return LSNumberFormat(qrContrato.VALOR_INICIAL_FRETE, ',.__');
								break;
							case "VALOR_FRETE_BRUTO":
								return LSNumberFormat(qrContrato.VALOR_FRETE_BRUTO, ',.__');
								break;
							case "PERCENTUAL_RECEITA":
								return LSNumberFormat(qrContrato.PERCENTUAL_RECEITA, ',.__');
								break;
							case "CONTRATO_QUITADO":
								return qrContrato.LOCAL_QUITACAO;

								break;
							case "VALOR_AMORTIZADO":
								return LSNumberFormat(qrContrato.VALOR_AMORTIZADO, ',.__');
								break;
							default:
								return Evaluate("#grid_query#.#field#");
								break;
						}
                    }

                    function fnc_grid_tr_class() {
						return "linha_branca";
					}

					function fnc_grid_tr_onclick() {
						return "this.className = (this.className == 'linha_azul_escura' ? 'linha_branca' : 'linha_azul_escura');";
					}

					function fnc_grid_td_inline(field) {
						return " nowrap";
					}

					function fnc_grid_td_class(field) {
						switch(ucase(field)) {
							case "SITUACAO":
								if(qrContrato.SITUACAO_ID eq 1) {
									return "linha_amarela";
								}
								else if(qrContrato.SITUACAO_ID eq 2) {
									return "linha_verde";
								}
								else if(qrContrato.SITUACAO_ID eq 3) {
									return "linha_vermelha";
								}

								break;
							default:
								return "";
								break;
						}
					}

					function fnc_grid_td_style(field) {
						switch(ucase(field)) {
							case "REINTEGRAR":
								return "width: 22px;";
								break;
							case "CANCELAR":
								return "width: 22px;";
								break;
							case "BLOQUEAR":
								return "width: 22px;";
								break;
							case "DESBLOQUEAR":
								return "width: 22px;";
								break;
							case "DISPENSA_DOC_ENTREGA":
								return "width: 22px;";
								break;
							case "NIVEL_EXIGENCIA_DOC":
								return "width: 22px;";
								break;
							case "LIBERAR_VIAGEM":
								return "width: 22px;";
								break;
							case "ADD_ADTO":
								return "width: 22px;";
								break;
							case "ABONAR_VALOR":
								return "width: 22px;";
								break;
							case "CONSULTAR_DADOS_VIAGEM":
								return "width: 22px;";
								break;
							case "REIMPRIMIR":
								return "width: 22px;";
								break;
							case "CONSULTAR_PAGBEM":
								return "width: 22px;";
								break;
							case "QUITAR":
								return "width: 22px;";
								break;
							case "ESTORNAR_QUITACAO":
								return "width: 22px;";
								break;
							case "IMPRIMIR_RECIBO":
								return "width: 22px;";
								break;
							case "INSERIR_DEBITO":
								return "width: 22px;";
								break;
							case "INSERIR_CREDITO":
								return "width: 22px;";
								break;
							default:
								return "";
								break;
						}
					}

					function fnc_grid_tr_oncontext_menu() {
						return "return f_context(event, '#qrContrato.CONTRATO_ID#', '#qrContrato.LANCTO_ID#', '#qrContrato.TIPO_CONTRATO#', '#qrContrato.SITUACAO_ID#', '#qrContrato.CONTRATO_QUITADO#', '#qrContrato.CONTRATO_QUITACAO_ID#', '', '#qrContrato.QUITACAO_QUEBRA_PESO#', '#qrContrato.DATA_CANCELAMENTO#', '#qrContrato.VALOR_AMORTIZADO#')";
					}

					function fnc_grid_td_title_function(field){
                    	switch(ucase(field)) {
                        	case "QUITAR":
								return "Quitar Contrato (Caso o contrato j esteja quitado na Pagbem, mas no possua quitao no KMM, clicar no cone Consultar Dados do Contrato e em seguida atualizar a lista de contratos)";
							case "ESTORNAR_QUITACAO":
								return "Estornar Quitao Contrato";
							case "ALTERAR_LOCAL_QUITACAO":
								return "Alterar Local de Quitao";
							case "IMPRIMIR_RECIBO":
								return "Imprimir Recibo de Quitao";
							case "INSERIR_DEBITO":
								return "Inserir Dbito no Contrato";
							case "INSERIR_CREDITO":
								return "Inserir Crdito no Contrato";
							case "REINTEGRAR":
							    return "Reintegrar Contrato";
							case "CANCELAR":
								return "Cancelar Contrato";
							case "BLOQUEAR":
								return "Bloquear Contrato";
							case "DESBLOQUEAR":
								return "Desbloquear Contrato";
							case "DISPENSAR_DOC_ENTREGA":
								return "Dispensar Documento de Entrega";
							case "LIBERAR_VIAGEM":
								return "Liberar Contrato";
							case "NIVEL_EXIGENCIA_DOC":
								return "Alterar Nvel de Exigncia de Documento";
							case "ADD_ADTO":
								return "Adicionar Adiantamento no Contrato";
							case "ABONAR_VALOR":
								return "Abonar Valor";
							case "CONSULTAR_DADOS_VIAGEM":
								return "Consultar Dados da Viagem";
							case "REIMPRIMIR":
								return "Reimprimir Contrato";
							case "CONSULTAR_PAGBEM":
								return "Consultar Dados do Contrato";
							case "TIPO_CONTRATO_DESC":
								return "Tipo Contrato";
							case "INTERNACIONAL":
								return "Internacional";
							case "NUM_ROMANEIO":
								return "N&ordm; Romaneio";
							case "LANCTO_ID":
								return "N&ordm; Contrato Transporte";
							case "PROCESSO_CLIENTE_CODIGO":
								return "Processo Cliente C&oacute;digo";
							case "PROCESSO_TRANSPORTE_CODIGO":
								return "N&ordm; Contrato";
							case "COD_UNIDADE_NEGOCIO":
								return "C&oacute;d. Unidade Neg&oacute;cio";
							case "FILIAL":
								return "Filial";
							case "COD_CENTRO_CUSTO":
								return "C&oacute;d. Centro Custo";
							case "CENTRO_CUSTO":
								return "Centro Custo";
							case "DATA_EMISSAO":
								return "Data Emiss&atilde;o Contrato";
							case "SITUACAO":
								return "Situa&ccedil;&atilde;o Integra&ccedil;&atilde;o";
							case "CARTAO_NUMERO":
								return "Cart&atilde;o N&uacute;mero";
							case "CNPJ_CPF_PROPRIETARIO":
								return "CNPJ/CPF Propriet&aacute;rio";
							case "PROPRIETARIO":
								return "Propriet&aacute;rio";
							case "CPF_MOTORISTA":
								return "CPF Motorista";
							case "MOTORISTA":
								return "Motorista";
							case "COD_VEICULO_CAVALO":
								return "Frota Cavalo";
							case "PLACA_CAVALO":
								return "Placa Cavalo";
							case "COD_VEICULO_CARRETA":
								return "Frota Carreta";
							case "PLACA_CARRETA":
								return "Placa Carreta";
							case "ROTA_ID":
								return "C&oacute;d. Rota";
							case "ROTA":
								return "Rota";
							case "VALOR_INICIAL_ADIANTAMENTO":
								return "Valor Inicial Adto.";
							case "VALOR_INICIAL_FRETE":
								return "Valor Inicial Frete";
							case "VALOR_FRETE_BRUTO":
								return "Valor Bruto Contrato";
							case "PERCENTUAL_RECEITA":
								return "% Atual Custo";
							case "USER_INSERT":
								return "Inserido Por";
							case "DATE_INSERT":
								return "Inserido Em";
							case "USUARIO_CANCELAMENTO":
								return "Cancelado Por";
							case "DATA_CANCELAMENTO":
								return "Cancelado Em";
							case "CONTRATO_QUITADO":
								return "Local Quita&ccedil;&atilde;o";
							case "USUARIO_QUITACAO":
								return "Quitado Por";
							case "DATA_QUITACAO":
								return "Quitado Em";
							case "USUARIO_AUTORIZACAO":
								return "Autorizado Por";
							case "DATA_AUTORIZACAO":
								return "Autorizado Em";
							case "OBSERVACAO_APROVACAO":
								return "Obs. Aprova&ccedil;&atilde;o";
							case "DATA_PREVISTA_PAGAMENTO":
								return "Previso Pagamento";
							case "CARTAO_PROPRIETARIO":
								return "Cart&atilde;o N&uacute;mero Propriet&aacute;rio";
                    	}
					}
                </cfscript>

                <cfset grid_fixed_header = 0 />
                <cfinclude template="/_include/grid/grid.cfm" />
            </td>
        </tr>
        <cfelse>
        <tr>
            <td align="center" valign="middle" class="obrigatorio" style="padding-top: 10px;">Nenhum contrato foi encontrado.</td>
        </tr>
        </cfif>
	</table>
    <cfif v_possui_acao_quitar_contr eq 1>
    <div id="div_quitar" style="position: absolute; width: 400px; height: 100px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_quitar">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito" style="padding-right: 10px;"><nobr><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Quitar Contrato</label></nobr></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
                        <tr>
                            <td nowrap class="texto" style="height: 21px;">Peso de Entrega:</td>
                            <td class="texto"><input type="text" name="PESO_ENTREGA" id="PESO_ENTREGA" maxlength="15" obrigatorio="1" tipo="numerico" display="PESO DE ENTREGA" onChange="this.value = Number(this.value).toFixed(2);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 100px;" /></td>
                        </tr>
						<tr>
                            <td nowrap class="texto" style="height: 21px;">Documentos entregues:</td>
                            <td class="texto"><select name="DOCUMENTOS_ENTREGUES" id="DOCUMENTOS_ENTREGUES" obrigatorio="1" display="DOCUMENTOS ENTREGUES">
				                              	<option value="1">Sim</option>
				                              	<option value="0">No</option>
				                              </select></td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right"><button type="button" class="botao" onClick="f_ocultar_div(0)"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                    <button type="button" class="botao" onClick="f_quitar_contrato()"><nobr><img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr></button></td>
            </tr>
        </table>
    </div>
    </cfif>
	
	<cfif v_possui_acao_bloquear eq 1>
	<div id="div_bloquear_contrato" style="position: absolute; width: 500px; height: 100px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_quitar">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito" style="padding-right: 10px;"><nobr><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Bloquear Contrato</label></nobr></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
						<tr>
                            <td nowrap class="texto" style="height: 21px; width=10%">Motivo bloqueio:&nbsp;</td>
							<td nowrap class="texto" style="height: 21px; width=90%">
								<select name="MOTIVO_BLOQUEIO" id="MOTIVO_BLOQUEIO" display="MOTIVO_BLOQUEIO">							
									<cfoutput query="qrMotivoBloqueio">
										<option value="#qrMotivoBloqueio.id#">#qrMotivoBloqueio.id#</option>
									</cfoutput>
								</select>
							</td>
                        </tr>
						<tr>
							<td nowrap class="texto" style="height: 21px; width=10%">Observa&ccedil;&atilde;o:&nbsp;</td>
							<td nowrap class="texto" style="height: 21px; width=90%">
								<input type="text" maxlength="50" name="OBSERVACAO_BLOQUEIO" id="OBSERVACAO_BLOQUEIO" display="OBSERVACAO_BLOQUEIO" style="width: 100%;" />
							</td>
						</tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
					<button type="button" class="botao" onClick="f_ocultar_div(1)"><nobr>
						<img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr>
					</button>&nbsp;
                    <button type="button" class="botao" onClick="f_bloquear_contrato()"><nobr>
						<img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr>
					</button>
				</td>
            </tr>
        </table>
    </div>
	</cfif>
	
	<cfif v_possui_acao_desbloquear eq 1>
	<div id="div_desbloquear_contrato" style="position: absolute; width: 500px; height: 100px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_quitar">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito" style="padding-right: 10px;"><nobr><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Desbloquear Contrato</label></nobr></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
						<tr>
							<td nowrap class="texto" style="height: 21px; width=10%">Motivo desbloqueio:&nbsp;</td>
                            <td nowrap class="texto" style="height: 21px; width=90%">
								<select name="MOTIVO_DESBLOQUEIO" id="MOTIVO_DESBLOQUEIO" display="MOTIVO_DESBLOQUEIO">							
									<cfoutput query="qrMotivoDesbloqueio">
										<option value="#qrMotivoDesbloqueio.id#">#qrMotivoDesbloqueio.id#</option>
									</cfoutput>
								</select>
							</td>
                        </tr>
						<tr>
							<td nowrap class="texto" style="height: 21px; width=10%">Observa&ccedil;&atilde;o:&nbsp;</td>
							<td nowrap class="texto" style="height: 21px; width=90%">
								<input type="text" maxlength="50" name="OBSERVACAO_DESBLOQUEIO" id="OBSERVACAO_DESBLOQUEIO" display="OBSERVACAO_DESBLOQUEIO" style="width: 100%;" />
							</td>
						</tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
					<button type="button" class="botao" onClick="f_ocultar_div(2)"><nobr>
						<img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr>
					</button>&nbsp;
                    <button type="button" class="botao" onClick="f_desbloquear_contrato()"><nobr>
						<img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr>
					</button>
				</td>
            </tr>
        </table>
    </div>
	</cfif>
	
	<cfif v_possui_acao_dispensa_doc eq 1>
	<div id="div_dispensa_doc" style="position: absolute; width: 400px; height: 100px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_quitar">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito" style="padding-right: 10px;"><nobr><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Dispensar Documento de Entrega</label></nobr></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
						<tr>
                            <td class="texto">
								Documento:&nbsp;<select name="DOCUMENTO_DISPENSADO" id="DOCUMENTO_DISPENSADO" display="DOCUMENTO_DISPENSADO">							
									<cfoutput query="qrDocumentosDispensaEntrega">
										<option value="#qrDocumentosDispensaEntrega.id#">#qrDocumentosDispensaEntrega.id#</option>
									</cfoutput>
								</select>
							</td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
					<button type="button" class="botao" onClick="f_ocultar_div(3)"><nobr>
						<img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr>
					</button>&nbsp;
                    <button type="button" class="botao" onClick="f_dispensar_doc_entrega()"><nobr>
						<img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr>
					</button>
				</td>
            </tr>
        </table>
    </div>
	</cfif>
	
	<cfif v_possui_acao_nivel_exigencia_doc eq 1>
	<div id="div_nivel_exigencia_doc" style="position: absolute; width: 400px; height: 100px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_quitar">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito" style="padding-right: 10px;"><nobr><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Alterar Nvel de Exigncia de Documento</label></nobr></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
						<tr>
                            <td nowrap class="texto" style="height: 21px;">Documento:</td>
							<td>
								<select name="DOCUMENTO_ALTERADO" id="DOCUMENTO_ALTERADO" display="DOCUMENTO_ALTERADO">							
									<cfoutput query="qrDocumentosNivelExigencia">
										<option value="#qrDocumentosNivelExigencia.id#">#qrDocumentosNivelExigencia.id#</option>
									</cfoutput>
								</select>
							</td>
                        </tr>
						<tr>
							<td nowrap class="texto" style="height: 21px;">Regular:</td>
							<td>
								<select name="REGULAR" id="REGULAR" obrigatorio="1" display="Regular">
									<option value="1">Sim</option>
				                    <option value="0">No</option>
				                </select>
							</td>
						</tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
					<button type="button" class="botao" onClick="f_ocultar_div(4)"><nobr>
						<img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr>
					</button>&nbsp;
                    <button type="button" class="botao" onClick="f_alterar_nivel_exigencia_doc()"><nobr>
						<img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr>
					</button>
				</td>
            </tr>
        </table>
    </div>
	</cfif>
	
	<cfif v_possui_acao_add_adto eq 1>
	<div id="div_add_adto" style="position: absolute; width: 400px; height: 100px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_quitar">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito" style="padding-right: 10px;"><nobr><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Adicionar Adiantamento no Contrato</label></nobr></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
						<tr>
							<td nowrap class="texto" style="height: 21px;">Valor original do adiantamento:</td>
							<td class="texto" colspan="3"><input type="text" name="VALOR_ORIGINAL_ADTO" readonly id="VALOR_ORIGINAL_ADTO" maxlength="100" obrigatorio="1" tipo="numerico" display="Valor original do adiantamento" onChange="this.value = Number(this.value).toFixed(2);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;" /></td>
						</tr>
						<tr>
							<td nowrap class="texto" style="height: 21px;">Valor adicional:</td>
							<td class="texto" colspan="3"><input type="text" name="VALOR_ADD_ADTO" id="VALOR_ADD_ADTO" maxlength="100" obrigatorio="1" tipo="numerico" display="Valor adicional do adiantamento" onChange="this.value = Number(this.value).toFixed(2);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;" /></td>
						</tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
					<button type="button" class="botao" onClick="f_ocultar_div(5)"><nobr>
						<img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr>
					</button>&nbsp;
                    <button type="button" class="botao" onClick="f_adicionar_adto()"><nobr>
						<img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr>
					</button>
				</td>
            </tr>
        </table>
    </div>
	</cfif>
	
	<cfif v_possui_acao_abonar_valor eq 1>
	<div id="div_abonar_valor" style="position: absolute; width: 400px; height: 100px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_quitar">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito" style="padding-right: 10px;"><nobr><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Abonar Valor no Contrato</label></nobr></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
						<tr>
							<td nowrap class="texto" style="height: 21px;">Valor abonado:</td>
							<td class="texto" colspan="3"><input type="text" name="VALOR_ABONADO" id="VALOR_ABONADO" maxlength="100" obrigatorio="1" tipo="numerico" display="Valor abonado" onChange="this.value = Number(this.value).toFixed(2);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;" /></td>
						</tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
					<button type="button" class="botao" onClick="f_ocultar_div(6)"><nobr>
						<img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr>
					</button>&nbsp;
                    <button type="button" class="botao" onClick="f_abonar_valor()"><nobr>
						<img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr>
					</button>
				</td>
            </tr>
        </table>
    </div>
	</cfif>
	
	<cfif v_possui_acao_alterar_local_quit eq 1>
	<div id="div_alterar_local_quitacao" style="position: absolute; width: 400px; height: 100px; display: none;">
        <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
            <tr id="tr_cabecalho_interno_quitar">
                <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito" style="padding-right: 10px;"><nobr><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label>Alterar Local de Quitao</label></nobr></td>
            </tr>
            <tr>
                <td height="98%">
                    <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
						<tr>
                            <td nowrap class="texto" style="height: 21px; width=10%">Local&nbsp;</td>
							<td nowrap class="texto" style="height: 21px; width=90%">
								<select name="LOCAL_QUITACAO" id="LOCAL_QUITACAO" display="LOCAL_QUITACAO">							
									<cfoutput query="qrLocalQuitacao">
										<option value="#qrLocalQuitacao.id#">#qrLocalQuitacao.id#</option>
									</cfoutput>
								</select>
							</td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td height="1%" id="barra_botoes_bottom" class="texto" align="right">
					<button type="button" class="botao" onClick="f_ocultar_div(8)"><nobr>
						<img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr>
					</button>&nbsp;
                    <button type="button" class="botao" onClick="f_alterar_local_quitacao()"><nobr>
						<img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr>
					</button>
				</td>
            </tr>
        </table>
    </div>
	</cfif>
	
</form>
</body>
<script type="text/javascript">
	f_hide_carregando();
	<cfoutput>
		try { document.getElementById("td_#grid_cod#_REINTEGRAR").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_CANCELAR").innerHTML = '';               } catch (e) {}
		try { document.getElementById("td_#grid_cod#_BLOQUEAR").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_DESBLOQUEAR").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_DISPENSAR_DOC_ENTREGA").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_NIVEL_EXIGENCIA_DOC").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_ADD_ADTO").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_ABONAR_VALOR").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_LIBERAR_VIAGEM").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_CONSULTAR_DADOS_VIAGEM").innerHTML = ''; } catch (e) {}
		try { document.getElementById("td_#grid_cod#_REIMPRIMIR").innerHTML = '';             } catch (e) {}
		try { document.getElementById("td_#grid_cod#_CONSULTAR_PAGBEM").innerHTML = '';       } catch (e) {}
		try { document.getElementById("td_#grid_cod#_QUITAR").innerHTML = '';                 } catch (e) {}
		try { document.getElementById("td_#grid_cod#_ESTORNAR_QUITACAO").innerHTML = '';                 } catch (e) {}
		try { document.getElementById("td_#grid_cod#_ALTERAR_LOCAL_QUITACAO").innerHTML = '';                 } catch (e) {}
		try { document.getElementById("td_#grid_cod#_IMPRIMIR_RECIBO").innerHTML = '';                 } catch (e) {}
		try { document.getElementById("td_#grid_cod#_INSERIR_DEBITO").innerHTML = '';         } catch (e) {}
		try { document.getElementById("td_#grid_cod#_INSERIR_CREDITO").innerHTML = '';        } catch (e) {}
	</cfoutput>
</script>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style=" display: none;"></iframe>
<cfset RequestEnd = 0 />
