<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!---
    -- PROPÓSITO
    -- Verifica o cartão
    -- ANDERSONC 30/05/2012 - ALTERADO
    --->
    <cffunction name='verificar_cartao' displayname='Verifica o cartão' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
        <cfargument name='CARTAO_NUMERO' required='no' default=''>
        <cfargument name='PROPRIETARIO_COD_PESSOA' required='no' default=''>
        <cfargument name='MOTORISTA_COD_PESSOA' required='no' default=''>
		<cfargument name='CARTAO_NUMERO_PROPRIETARIO' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='pagbem.pkg_logistica.prc_verificar_cartao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PROPRIETARIO_COD_PESSOA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTORISTA_COD_PESSOA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO_PROPRIETARIO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitação para Verificar Cartão na Pagbem enviada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPÓSITO
	-- Verifica os dados do contratado, motorista, cavalo e carreta
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='verificar_dados' displayname='Verifica os dados do contratado, motorista, cavalo e carreta' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
		<cfargument name='PLACA_CAVALO' required='no' default=''>
		<cfargument name='PLACA_CARRETA' required='no' default=''>
		<cfargument name='COD_MOTORISTA' required='no' default=''>
		<cfargument name='COD_CONTRATADO' required='no' default=''>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pagbem.pkg_logistica.prc_verificar_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CONTRATADO#'  null='#iif(len(trim(arguments.COD_CONTRATADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitação para Atualizar Cadastros na Pagbem enviada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Emite um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='emitir_contrato' displayname='Emite um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='ROTA_ID' required='no' default=''>
		<cfargument name='CARTAO_NUMERO' required='no' default=''>
		<cfargument name='PAGAMENTO_PEDAGIO' required='yes'>
		<cfargument name='CARTAO_NUMERO_PROPRIETARIO' required='no' default=''>
		<cftry>
            <cfstoredproc procedure='pagbem.pkg_contrato.prc_emitir_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTRATO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PAGAMENTO_PEDAGIO#'  null='#iif(len(trim(arguments.PAGAMENTO_PEDAGIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO_PROPRIETARIO#' null='#iif(len(trim(arguments.CARTAO_NUMERO_PROPRIETARIO)), de('no'), de('yes'))#'>
			</cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Contrato emitido com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Integra um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='integrar_contrato' displayname='Integra um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pagbem.pkg_contrato.prc_integrar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato integrado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Cancela um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='cancelar_contrato' displayname='Cancela um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pagbem.pkg_contrato.prc_cancelar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato cancelado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Gera o PDF de impressão de um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='gera_contrato' displayname='Gera o PDF de impressão de um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pagbem.pkg_impressao.prc_gera_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impressão gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPÓSITO
	-- Gera o PDF de impressão de um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='imprimir_recibo' displayname='Gera o PDF de recibo de pagamento de um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pagbem.pkg_impressao.prc_gera_recibo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Impressão gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
    <!---
	-- PROPÓSITO
	-- Consulta um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='consulta_contrato' displayname='Consulta um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pagbem.pkg_pagbem.prc_consulta_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1'  null='no'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.RESULT' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato consultado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Insere um débito/crédito em um contrato
	-- ANDERSONC 30/05/2012 15:06:08 - CRIADO
	--->
	<cffunction name='debito_credito_contrato' displayname='Insere um débito/crédito em um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='USUARIO_LIBERACAO' required='yes'>
		<cfargument name='SENHA_LIBERACAO' required='yes'>
        <cfargument name='DEBITO_CREDITO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pagbem.pkg_contrato.prc_debito_credito_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' value='#arguments.USUARIO_LIBERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' value='#arguments.SENHA_LIBERACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
                <cfif arguments.DEBITO_CREDITO eq 1>
					<cfset retorno.mensagem = JSStringFormat('Débito inserido com sucesso.')>
                <cfelse>
                	<cfset retorno.mensagem = JSStringFormat('Crédito inserido com sucesso.')>
                </cfif>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Quita um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='quitar_contrato' displayname='Quita um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='PESO_ENTREGA' required='yes'>
        <cfargument name='DOCUMENTOS_ENTREGUES' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='pagbem.pkg_contrato.prc_quitar_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTRATO_QUITACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_ENTREGA#'  null='#iif(len(trim(arguments.PESO_ENTREGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTOS_ENTREGUES#'  null='#iif(len(trim(arguments.DOCUMENTOS_ENTREGUES)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Contrato quitado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPÓSITO
	-- Autoriza o pagamento de um contrato
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='autoriza_pagamento' displayname='Autoriza o pagamento de um contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTRATO_ID' required='yes'>
		<cfargument name='QUANTIDADE_DIAS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='repom.pkg_repom.prc_autoriza_pagamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE_DIAS#'  null='#iif(len(trim(arguments.QUANTIDADE_DIAS)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pagamento do contrato autorizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Buscar o retorno da validação da ANTT
	-- RAFAEL 19/06/2012 16:36:40 - CRIADO
	--->
	<cffunction name='retorno_financeiro' displayname='Retornos financeiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='MERCOSUL' required='yes' default="0">
		<cftry>
				<cfstoredproc procedure='repom.pkg_retorno.prc_financeiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MERCOSUL#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch.Detail>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    <!---
	-- PROPÓSITO
	-- Buscar o retorno da validação da ANTT
	-- RAFAEL 19/06/2012 16:36:40 - CRIADO
	--->
	<cffunction name='retorno_contabil' displayname='Retornos financeiro' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA' required='yes'>
		<cfargument name='MERCOSUL' required='yes' default="0">
		<cftry>
				<cfstoredproc procedure='repom.pkg_retorno.prc_contabil' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MERCOSUL#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch.Detail>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Buscar o retorno da validação da ANTT
	-- RAFAEL 19/06/2012 16:36:40 - CRIADO
	--->
	<cffunction name='retorno_antt' displayname='Buscar o retorno da validação da ANTT' access='remote' returntype='Struct' output='true'>
		<cfargument name='PLACA_CAVALO' required='yes'>
		<cfargument name='PLACA_CARRETA' required='yes'>
		<cfargument name='COD_CONTRATADO' required='yes'>
		<cftry>
				<cfstoredproc procedure='pagbem.pkg_logistica.prc_retorno_antt' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CONTRATADO#'  null='#iif(len(trim(arguments.COD_CONTRATADO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VEICULO_VALIDADO_ANTT' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.VEICULO_ERRO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CARRETA_VALIDADO_ANTT' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CARRETA_ERRO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTRATADO_VALIDADO_ANTT' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.CONTRATADO_ERRO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Insere a taxa de ativacao do contrato
	-- KMM_THOMASJ 08/04/2014 14:05:00- CRIADO
	--->
	<cffunction name='ins_taxa_ativacao' displayname='nsere a taxa de ativacao do contrato' access='remote' returntype='Struct' output='true'>
		<cfargument name='LANCTO_ID' required='yes'>
        <cfargument name='CARTAO_NUMERO' required='yes'>
        <cfargument name='CARTAO_ID' required='no'>
		<cftry>
            <cfstoredproc procedure='repom.pkg_contrato.prc_ins_taxa_ativacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LANCTO_ID#'  null='#iif(len(trim(arguments.LANCTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CARTAO_NUMERO#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CARTAO_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROP�SITO
	-- Consulta os roteiros cadastrados na Pagbem
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='consulta_roteiros' displayname='Consulta os roteiros cadastrados na Pagbem' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='pagbem.pkg_pagbem.prc_consulta_roteiros' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROP�SITO
    -- Verifica o roteiro e retorna o valor de ped�gio
    -- ANDERSONC 30/05/2012 - ALTERADO
    --->
    <cffunction name='verificar_roteiro' displayname='Verifica o roteiro e retorna o valor de ped�gio' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default=''>
        <cfargument name='ROTA_ID' required='no' default=''>
        <cfargument name='PLACA_CAVALO' required='no' default=''>
        <cfargument name='PLACA_CARRETA' required='no' default=''>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='pagbem.pkg_logistica.prc_verificar_roteiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CAVALO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_CARRETA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_PEDAGIO_ROTA' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicita��o para Verificar Roteiro na Pagbem enviada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
	-- PROP�SITO
	-- Solicita um roteiro
	-- ANDERSONC 30/05/2012 - ALTERADO
	--->
	<cffunction name='solicita_roteiro' displayname='Solicita um roteiro' access='remote' returntype='Struct' output='true'>
	<cfargument name='ROTA_ID' required='yes'>
	<cfargument name='NUMERO_EIXOS' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='pagbem.pkg_pagbem.prc_consultar_valor_rota' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUMERO_EIXOS#'  null='#iif(len(trim(arguments.NUMERO_EIXOS)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.VALOR_PEDAGIO_ROTA' >
			</cfstoredproc>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Roteiro solicitado com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<cffunction name='bloquear_desbloquear_contrato' displayname='Realiza o bloqueio/desbloqueio do contrato na Pagbem' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTRATO_ID' required='yes'>
	<cfargument name='LOCK_UNLOCK' required='yes'>
	<cfargument name='MOTIVO_BLOQUEIO_DESBLOQUEIO' required='yes'>
	<cfargument name='OBSERVACAO' required='no' default=''>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='pagbem.pkg_pagbem.prc_lock_unlock_contrato' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LOCK_UNLOCK#'  null='#iif(len(trim(arguments.LOCK_UNLOCK)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO_BLOQUEIO_DESBLOQUEIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operação realizada com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<cffunction name='dispensar_doc_entrega' displayname='Dispensa documento na quitação de contrato' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTRATO_ID' required='yes'>
	<cfargument name='DOCUMENTO'   required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='pagbem.pkg_pagbem.prc_dispensa_entrega_doc_quit' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DOCUMENTO#' >
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operação realizada com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<cffunction name='alterar_nivel_exigencia_doc' displayname='Altera o nível de exigência do documento na quitação de contrato' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTRATO_ID' required='yes'>
	<cfargument name='DOCUMENTO'   required='yes'>
	<cfargument name='REGULAR'   required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='pagbem.pkg_pagbem.prc_altera_nivel_exigencia_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' value='#arguments.DOCUMENTO#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' value='#arguments.REGULAR#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operação realizada com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<cffunction name='liberar_contrato' displayname='Libera o contrato que foi emitido bloqueado' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTRATO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='pagbem.pkg_pagbem.prc_liberar_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operação realizada com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<cffunction name='alterar_valor_adto' displayname='Alterar valor do adiantamento' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTRATO_ID' required='yes'>
	<cfargument name='VALOR_ADD_ADTO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='pagbem.pkg_pagbem.prc_alterar_valor_adto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.VALOR_ADD_ADTO#'  null='#iif(len(trim(arguments.VALOR_ADD_ADTO)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operação realizada com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<cffunction name='abonar_valor_contrato' displayname='Alterar valor do adiantamento' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTRATO_ID' required='yes'>
	<cfargument name='VALOR_ABONADO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='pagbem.pkg_pagbem.prc_abonar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' value='#arguments.VALOR_ABONADO#'  null='#iif(len(trim(arguments.VALOR_ABONADO)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operação realizada com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<cffunction name='estornar_quitacao' displayname='Estornar Quitação Contrato' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTRATO_ID' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='pagbem.pkg_pagbem.prc_estorna_quitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operação realizada com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>

<cffunction name='alterar_local_quitacao' displayname='Estornar Quitação Contrato' access='remote' returntype='Struct' output='true'>
	<cfargument name='CONTRATO_ID' required='yes'>
	<cfargument name='LOCAL_QUITACAO' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='pagbem.pkg_pagbem.prc_altera_local_quitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'             value='#arguments.LOCAL_QUITACAO#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
			</cfstoredproc>
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Operação realizada com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
	
</cfcomponent>
