<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
    -- PROPÓSITO
    -- Retorna centros de custo
    -- GUTO 16/06/2011 - CRIADO
    --->
    <cffunction name="get_centro_custo" access="remote" returntype="query" output="true">
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cc.cod_centro_custo, cc.centro_custo
              from kss.v$centro_custo cc
             order by cc.centro_custo
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Retorna os dados Repom para uma solicitação de carga
    -- FABIOG 16/06/2011 - CRIADO
    --->
    <cffunction name="get_dados_cartao" access="remote" returntype="query" output="true">
    	<cfargument name="solicitacao_carga_id" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sc.solicitacao_carga_dados_id
                 , sc.solicitacao_carga_id
                 , sc.cartao_id
                 , (select c.cartao_numero
                      from pagbem.v$cartao c
                     where c.cartao_id = sc.cartao_id
                   )as cartao_numero
                 , sc.adto_trajeto_vazio
              from pagbem.v$solicitacao_carga_dados sc
             where sc.solicitacao_carga_id = #arguments.SOLICITACAO_CARGA_ID#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Retorna os roteiros de uma requisição
    -- ANDERSON 10/06/2011 - CRIADO
    --->
    <cffunction name="get_roteiro" access="remote" returntype="Struct" output="true">
    	<cfargument name="origem_municipio_id" required="no" default="" />
        <cfargument name="destino_municipio_id" required="no" default="" />
        <cfargument name="tipo_integracao" required="yes" default="1" />
        <cftry>
        	<cftransaction action='begin'>
                <cfscript>
					conn = CreateComponent("modulos.pagbem._componentes.manipulacao.cfc_pagbem");
                    ret_cons_rot = conn.consulta_roteiros(ORIGEM_MUNICIPIO_ID  = arguments.origem_municipio_id,
														  DESTINO_MUNICIPIO_ID = arguments.destino_municipio_id);
                </cfscript>
                <cfif ret_cons_rot.erro>
                    <cfthrow object="#ret_cons_rot.mensagem#">
                </cfif>

                <cfquery name="qr_roteiro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select distinct
                           r.roteirizacao_id
                         , r.rota_id
                         , r.codigo_rota_pagbem
						 , r.km_rota_pagbem
                         , r.rota_ok
                         , ro.descricao_via
                         , ro.descricao_rota
                         , mo.municipio as cidade_origem
                         , mo.uf_id as estado_origem
                         , md.municipio as cidade_destino
                         , md.uf_id as  estado_destino
                      from pagbem.v$roteirizacao r
                     inner join oper.v$rota ro
                        on ro.rota_id = r.rota_id
                     inner join cep.municipio mo
                        on mo.municipio_id = ro.origem_municipio_id
                     inner join cep.municipio md
                        on md.municipio_id = ro.destino_municipio_id
                     where ro.ORIGEM_MUNICIPIO_ID = #arguments.origem_municipio_id#
                       and ro.destino_municipio_id = #arguments.destino_municipio_id#
                </cfquery>

                <cfset retorno.qr_roteiro = qr_roteiro>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna as cargas que estão configuradas para a Repom
    -- ANDERSON 13/06/2011 - CRIADO
    --->
    <cffunction name="get_cargas" access="remote" returntype="query" output="true">
    	<cfargument name="solicitacao_carga_id" required="no" default="" />
        <cfargument name="viagem_id" required="no" default="" />
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="processo_transporte_codigo" required="no" default="" />
        <cfargument name="cod_pessoa_filial" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="origem_municipio_id" required="no" default="" />
        <cfargument name="destino_municipio_id" required="no" default="" />
        <cfargument name="veiculo_id_cavalo" required="no" default="" />
        <cfargument name="veiculo_id_carreta" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="modalidade" required="no" default="" />
        <cfargument name="tipo_pagamento_id" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.solicitacao_carga_id
                 , c.viagem_id
                 , c.num_romaneio
                 , c.situacao
                 , c.tipo_pagamento
                 , c.operacao_pagbem
                 , c.cartao_ok
                 , c.cartao_numero
                 , c.cartao_taxa_ativacao
                 , case
                      when c.contrato_emitido = 1 then 1
                      else c.rota_ok
                   end as rota_ok
                 , c.valor_pedagio_rota
                 , case
                      when c.contrato_emitido = 1 then 1
                      else c.contratado_ok
                   end as contratado_ok
                 , case
                      when c.contrato_emitido = 1 then 1
                      else c.motorista_ok
                   end as motorista_ok
                 , case
                      when c.contrato_emitido = 1 then 1
                      else c.veiculo_ok
                   end as veiculo_ok
                 , c.adto_trajeto_vazio
                 , c.contrato_emitido
                 , c.numero_contrato
                 , c.valor_contrato
                 , c.cnpj_cpf_remetente
                 , c.remetente
                 , c.origem
                 , to_char(c.data_carregamento_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_carregamento_inicio
                 , to_char(c.data_carregamento_fim, 'dd/mm/yyyy hh24:mi:ss') as data_carregamento_fim
                 , c.cnpj_cpf_destinatario
                 , c.destinatario
                 , c.destino
                 , to_char(c.data_entrega_inicio, 'dd/mm/yyyy hh24:mi:ss') as data_entrega_inicio
                 , to_char(c.data_entrega_fim, 'dd/mm/yyyy hh24:mi:ss') as data_entrega_fim
                 , c.dias_atraso
                 , c.operacao_id
                 , c.operacao
                 , c.modalidade_desc
                 , c.composicao
                 , oper.pkg_veiculo.fnc_numero_eixos_composicao(oper.pkg_veiculo.fnc_placa(c.veiculo_id_cavalo), oper.pkg_veiculo.fnc_placa(c.veiculo_id_carreta)) as numero_eixos
                 , c.motorista
                 , c.num_natureza
                 , c.natureza
                 , c.grupo_natureza
                 , c.peso_m3
                 , c.frete_em
                 , c.user_insert
                 , to_char(c.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , c.user_update
                 , to_char(c.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from pagbem.v$cargas c
             <cfif Len(Trim(arguments.placa_cavalo))>
			 inner join oper.v$veiculo vcv
                on vcv.veiculo_id = c.veiculo_id_cavalo
             </cfif>
             <cfif Len(Trim(arguments.placa_carreta))>
			 inner join oper.v$veiculo vcr
                on vcr.veiculo_id = c.veiculo_id_carreta
             </cfif>
             where 1 = 1
			<cfif Len(Trim(arguments.solicitacao_carga_id))>
               and c.solicitacao_carga_id = #arguments.solicitacao_carga_id#
            <cfelseif Len(Trim(arguments.viagem_id))>
               and c.viagem_id = #arguments.viagem_id#
            <cfelseif Len(Trim(arguments.num_romaneio))>
               and c.num_romaneio = #arguments.num_romaneio#
            <cfelseif Len(Trim(arguments.processo_transporte_codigo))>
               and exists (select 1
                             from pagbem.v$contrato ct
                            where ct.num_romaneio = c.num_romaneio
                              and ct.processo_transporte_codigo = #arguments.processo_transporte_codigo#
                          )
            <cfelse>
                and c.situacao_id <> 5
            	<cfif Len(Trim(arguments.cod_pessoa_filial))>
					and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                </cfif>
                <cfif Len(Trim(arguments.cod_centro_custo))>
					and c.cod_centro_custo = #arguments.cod_centro_custo#
                </cfif>
                <cfif Len(Trim(arguments.origem_municipio_id))>
					and c.origem_municipio_id = #arguments.origem_municipio_id#
                </cfif>
                <cfif Len(Trim(arguments.destino_municipio_id))>
					and c.destino_municipio_id = #arguments.destino_municipio_id#
                </cfif>
                <cfif Len(Trim(arguments.veiculo_id_cavalo))>
					and c.veiculo_id_cavalo = #arguments.veiculo_id_cavalo#
                </cfif>
                <cfif Len(Trim(arguments.placa_cavalo))>
					and vcv.placa = '#arguments.placa_cavalo#'
                </cfif>
                <cfif Len(Trim(arguments.veiculo_id_carreta))>
					and c.veiculo_id_carreta = #arguments.veiculo_id_carreta#
                </cfif>
                <cfif Len(Trim(arguments.placa_carreta))>
					and vcr.placa = '#arguments.placa_carreta#'
                </cfif>
                <cfif Len(Trim(arguments.cod_motorista))>
					and c.cod_motorista = #arguments.cod_motorista#
                </cfif>
                <cfif Len(Trim(arguments.modalidade))>
					and c.modalidade = '#arguments.modalidade#'
                </cfif>
                <cfif Len(Trim(arguments.tipo_pagamento_id))>
					and c.tipo_pagamento_id = #arguments.tipo_pagamento_id#
                </cfif>
                <cfif Len(Trim(arguments.data_inicio))>
                    and c.data_carregamento_inicio >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
                </cfif>
                <cfif Len(Trim(arguments.data_termino))>
                    and c.data_carregamento_fim <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                </cfif>
            </cfif>
             order by c.data_carregamento_inicio, c.data_carregamento_fim
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os contratos
    -- ANDERSONC 01/11/2011 - CRIADO
    --->
    <cffunction name="get_contrato" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="no" default="" />
        <cfargument name="solicitacao_carga_id" required="no" default="" />
        <cfargument name="viagem_id" required="no" default="" />
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="processo_transporte_codigo" required="no" default="" />
        <cfargument name="lancto_id" required="no" default="" />
        <cfargument name="cod_pessoa_filial" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="placa_cavalo" required="no" default="" />
        <cfargument name="placa_carreta" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="tipo_contrato" required="no" default="" />
        <cfargument name="internacional" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.contrato_id
                 , c.tipo_contrato
                 , c.tipo_contrato_desc
                 , c.internacional
                 , c.num_romaneio
                 , c.diaria_ctrc_id
                 , c.diaria_crt_id
                 , c.divisao_id
                 , c.lancto_id
                 , c.processo_cliente_codigo
                 , c.processo_transporte_codigo
                 , c.cod_unidade_negocio
                 , c.filial
                 , c.cod_centro_custo
                 , c.centro_custo
                 , to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , c.situacao_id
                 , c.situacao
                 , c.status_codigo
                 , c.cartao_numero
				 , c.cartao_proprietario
				 , nvl(c.cartao_proprietario, c.cartao_numero) as cartao_pagamento
                 , c.cnpj_cpf_proprietario
                 , c.proprietario
                 , c.cpf_motorista
                 , c.motorista
                 , c.cod_veiculo_cavalo
                 , c.placa_cavalo
                 , c.cod_veiculo_carreta
                 , c.placa_carreta
                 , c.rota_id
                 , c.rota
                 , c.valor_inicial_adiantamento
                 , c.valor_inicial_frete
                 , c.valor_frete_bruto
                 , c.percentual_receita
                 , c.user_insert
                 , to_char(c.date_insert, 'dd/mm/yyyy hh24:mi') as date_insert
                 , c.usuario_cancelamento
                 , to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi') as data_cancelamento
                 , c.contrato_quitado
                 , c.usuario_quitacao
                 , to_char(c.data_quitacao, 'dd/mm/yyyy hh24:mi') as data_quitacao
                 , c.contrato_quitacao_id
                 , c.quitacao_quebra_peso
                 , c.modalidade_veiculo
                 ,  ct.valor_frete_liquido +
                 	nvl((select sum(cti.valor * decode(cti.desconto,0,1,-1))
	                       from oper.v$contrato_transp_item cti
	                      where cti.lancto_id = ct.lancto_id
	                        and cti.compoe_frete = 1
	                        and cti.data_cancelamento is null),0) as valor_frete_bruto_atual
                 , nvl(ct.valor_maximo_tabela_frete, 0) + nvl(ct.valor_maximo_pedagio, 0) as valor_maximo_gravado
				 , c.frete_liberado_por
				 , c.frete_liberado_em
				 , (select nvl(sum(cti.valor), 0)
                      from oper.v$contrato_transp_item cti
                     where cti.lancto_id = c.lancto_id
                       and cti.adiantamento = 1) as valor_adiantado
			     , c.local_quitacao
				 , ct.observacao_aprovacao
			     , (select sum(fcpa.valor_amortizacao)
					  from oper.v$contrato_transp_pagar ctp
					 inner join finan.v$finan_contas_pagar_amort fcpa
					    on fcpa.contas_pagar_id = ctp.contas_pagar_id
					 where ctp.lancto_id = ct.lancto_id ) as valor_amortizado
              from pagbem.v$contrato_dados c
              left join oper.v$contrato_transp ct
                on ct.lancto_id = c.lancto_id
             where 1 = 1
            <cfif Len(Trim(arguments.contrato_id))>
              and c.contrato_id = #arguments.contrato_id#
            <cfelseif Len(Trim(arguments.solicitacao_carga_id))>
               and exists (select 1
                             from logistica.v$viagem v
                            inner join logistica.v$viagem_carga vc
                                    on vc.viagem_id = v.viagem_id
                            where v.num_romaneio = c.num_romaneio
                              and vc.solicitacao_carga_id = #arguments.solicitacao_carga_id#
                          )
            <cfelseif Len(Trim(arguments.viagem_id))>
               and exists (select 1
                             from logistica.v$viagem v
                            where v.num_romaneio = c.num_romaneio
                              and v.viagem_id = #arguments.viagem_id#
                          )
            <cfelseif Len(Trim(arguments.num_romaneio))>
               and c.num_romaneio = #arguments.num_romaneio#
            <cfelseif Len(Trim(arguments.processo_transporte_codigo))>
               and c.processo_transporte_codigo = #arguments.processo_transporte_codigo#
            <cfelseif Len(Trim(arguments.lancto_id))>
               and c.lancto_id = #arguments.lancto_id#
            <cfelse>
				<cfif Len(Trim(arguments.cod_pessoa_filial))>
                   and c.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                </cfif>
                <cfif Len(Trim(arguments.cod_centro_custo))>
                   and c.cod_centro_custo = #arguments.cod_centro_custo#
                </cfif>
                <cfif Len(Trim(arguments.placa_cavalo))>
                   and c.placa_cavalo = '#arguments.placa_cavalo#'
                </cfif>
                <cfif Len(Trim(arguments.placa_carreta))>
                   and c.placa_carreta = '#arguments.placa_carreta#'
                </cfif>
                <cfif Len(Trim(arguments.cod_motorista))>
                   and c.cod_motorista = #arguments.cod_motorista#
                </cfif>
                <cfif Len(Trim(arguments.tipo_contrato))>
                   and c.tipo_contrato = #arguments.tipo_contrato#
                </cfif>
                <cfif Len(Trim(arguments.internacional))>
                   and c.internacional = #arguments.internacional#
                </cfif>

                <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                   and c.date_insert between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                <cfelseif Len(Trim(arguments.data_inicio))>
                   and c.date_insert >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
                <cfelseif Len(Trim(arguments.data_termino))>
                   and c.date_insert <= to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
                </cfif>
			</cfif>
			<cfif IsDefined('arguments.modalidade_veiculo') and Len(Trim(arguments.modalidade_veiculo))>
               and upper(c.modalidade_veiculo) = upper('#arguments.modalidade_veiculo#')
            </cfif>
             order by c.processo_transporte_codigo
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os dados do romaneio de um contrato
    -- ANDERSON 08/02/2012 - CRIADO
    --->
    <cffunction name="get_contrato_dados_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="yes" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_controle) as cod_veiculo_controle
                 , r.placa_controle
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(r.placa_referencia) as cod_veiculo_referencia
                 , r.placa_referencia
                 , r.carregamento
                 , r.destino
                 , r.remetente
                 , r.destinatario
                 , (select n.descricao
                      from logistica.v$viagem v
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = v.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     inner join oper.v$natureza n
                             on n.num_natureza = sc.num_natureza
                     where v.num_romaneio = r.num_romaneio
                       and rownum = 1
                   ) as natureza
                 , (select e.descricao
                      from logistica.v$viagem v
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = v.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     inner join oper.v$especie e
                             on e.num_especie = sc.num_especie
                     where v.num_romaneio = r.num_romaneio
                       and rownum = 1
                   ) as especie
                 , (select um.unidade
                      from logistica.v$viagem v
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = v.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     inner join fiscal.v$unidade_medida um
                             on um.cod_unidade = sc.cod_unidade
                     where v.num_romaneio = r.num_romaneio
                       and rownum = 1
                   ) as unidade
                 , (select sc.valor_em
                      from logistica.v$viagem v
                     inner join logistica.v$viagem_carga vc
                             on vc.viagem_id = v.viagem_id
                     inner join logistica.v$solicitacao_carga sc
                             on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                     where v.num_romaneio = r.num_romaneio
                       and rownum = 1
                   ) as frete_em
                 , r.peso_total
                 , r.peso_cobrado
                 , r.frete_total
                 , r.frete_liquido
                 , to_char(r.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
                 , to_char(r.data_destinado, 'dd/mm/yyyy hh24:mi') as data_destinado
                 , to_char(r.data_inicio_carga, 'dd/mm/yyyy hh24:mi') as data_inicio_carga
                 , to_char(r.data_termino_carga, 'dd/mm/yyyy hh24:mi') as data_termino_carga
                 , to_char(r.data_inicio_descarga, 'dd/mm/yyyy hh24:mi') as data_inicio_descarga
                 , to_char(r.data_termino_descarga, 'dd/mm/yyyy hh24:mi') as data_termino_descarga
              from oper.v$romaneio r
             where exists (select 1
                             from pagbem.v$contrato c
                            where c.num_romaneio = r.num_romaneio
                              and c.contrato_id = #arguments.contrato_id#
                          )
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os dados do agendamento de um romaneio
    -- ANDERSON 08/02/2012 - CRIADO
    --->
    <cffunction name="get_agendamento_romaneio" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.viagem_id
                 , logistica.pkg_agendamento.fnc_viagem_composicao_definida(v.viagem_id) as composicao
                 , (select oper.pkg_global.fnc_get_cod_funcionario(vmv.cod_motorista) || ' - ' || kss.pkg_pessoa.fnc_get_cliente(vmv.cod_motorista)
                      from logistica.v$viagem_motorista_veiculo vmv
                     where vmv.viagem_id = v.viagem_id
                       and vmv.cod_motorista is not null
                   ) as motorista
                 , to_char(v.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
                 , to_char(v.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
              from logistica.v$viagem v
             where v.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna as solicitações de carga vinculadas a um Romaneio
    -- RAFAEL 30/05/2012 - CRIADO
    --->
    <cffunction name="get_solicitacoes" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select sc.solicitacao_carga_id
                 , kss.pkg_pessoa.fnc_get_cliente(sc.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(sc.cod_destinatario) as destinatario
                 , cep.pkg_municipio.fnc_municipio_uf(sc.origem_municipio_id, ' - ') as origem
                 , cep.pkg_municipio.fnc_municipio_uf(sc.destino_municipio_id, ' - ') as destino
                 , (select n.descricao
                      from oper.v$natureza n
                     where n.num_natureza = sc.num_natureza
                   ) as natureza
              from logistica.v$solicitacao_carga sc
             inner join logistica.v$viagem_carga vc
                     on vc.solicitacao_carga_id = sc.solicitacao_carga_id
             inner join logistica.v$viagem v
                     on v.viagem_id = vc.viagem_id
              where v.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os dados dos itens de um romaneio agendamento de um romaneio
    -- RAFAEL 30/05/2012 - CRIADO
    --->
    <cffunction name="get_romaneio_itens" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select ri.operacao_id
                 , logistica.pkg_operacao.fnc_descricao_completa(ri.operacao_id) as operacao
                 , kss.pkg_pessoa.fnc_get_cliente(ri.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(ri.cod_destinatario) as destinatario
                 , case
                    when exists (select 1
                                   from fiscal.v$conhecimento c
                                  where c.num_romaneio = ri.num_romaneio
                                    and c.item_id = ri.item_id

                                 union all

                                 select 1
                                   from fiscal.v$nf_es_frete f
                                  where f.num_romaneio = ri.num_romaneio
                                    and f.item_id = ri.item_id

                                 union all

                                 select 1
                                   from oper.v$romaneio_intc_conhecimento c
                                  where c.num_romaneio = ri.num_romaneio
                                ) then 'Sim'
                     else 'Não'
                   end as documento_emitido
                 , (select case
                             when o.internacional = 0 then 'Não'
                             else 'Sim'
                           end as internacional
                      from logistica.v$operacao o
                     where o.operacao_id = ri.operacao_id
                   )as internacional
              from oper.v$romaneio_item ri
             where ri.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os itinerários de um Romaneio
    -- RAFAEL 30/05/2012 - CRIADO
    --->
    <cffunction name="get_itinerarios" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (select r.descricao_rota
                      from oper.v$rota r
                     where r.rota_id = ri.rota_id
                   ) as descricao
            	 , (select m.municipio || ' - ' || m.uf_id
                      from cep.municipio m
                     where m.municipio_id = ri.origem_municipio_id
                   ) as origem
                 , (select m.municipio || ' - ' || m.uf_id
                      from cep.municipio m
                     where m.municipio_id = ri.destino_municipio_id
                   ) as destino
                 , to_char(ri.data_previsao, 'dd/mm/yyyy hh24:mi') as data_previsao
              from oper.v$romaneio_itinerario ri
             where ri.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os documentos vinculados a um Romaneio
    -- RAFAEL 30/05/2012 - CRIADO
    --->
    <cffunction name="get_documentos" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select 'CTRC/CTe' as tipo
                 , to_char(c.num_conhecimento || '/' || c.serie) as num_documento
                 , to_char(c.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_pessoa_filial) as filial
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_destinatario) as destinatario
                 , c.total_conhecimento as valor
              from fiscal.v$conhecimento c
             where c.num_romaneio = #arguments.num_romaneio#

              union all

            select 'NF Frete' as tipo
                 , to_char(nf.num_nota_fiscal || '/' || nf.serie) as num_documento
                 , to_char(nf.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , kss.pkg_pessoa.fnc_get_cliente(nf.cod_pessoa_filial) as filial
                 , kss.pkg_pessoa.fnc_get_cliente(f.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(f.cod_destinatario) as destinatario
                 , f.total_viagem as valor
              from fiscal.v$nf_es_frete f
             inner join fiscal.v$nf_es nf
                     on nf.num_nota_id = f.nf_es_id
             where f.num_romaneio = #arguments.num_romaneio#

              union all

            select 'CRT' as tipo
                 , to_char(c2.num_crt_completo) as num_documento
                 , to_char(c2.emissao_data, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , kss.pkg_pessoa.fnc_get_cliente(c2.cod_pessoa_filial) as filial
                 , kss.pkg_pessoa.fnc_get_cliente(c2.cod_remetente) as remetente
                 , kss.pkg_pessoa.fnc_get_cliente(c2.cod_destinatario) as destinatario
                 , nvl((c2.total_custo_origem + c2.total_custo_destino * c2.cotacao), 0) as valor
              from oper.v$romaneio_intc_conhecimento ic
             inner join fiscal.v$intc_conhecimento c2
                     on c2.conhecimento_id = ic.conhecimento_id
             where ic.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os Contratos de Tranmsporte vinculados a um Romaneio
    -- RAFAEL 30/05/2012 - CRIADO
    --->
    <cffunction name="get_contrato_transp" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.lancto_id
                 , ct.num_formulario || '/' || ct.serie_formulario as num_contrato
                 , to_char(ct.data_emissao, 'dd/mm/yyyy hh24:mi') as data_emissao
                 , kss.pkg_pessoa.fnc_get_cliente(ct.cod_pessoa_filial) as filial
                 , kss.pkg_pessoa.fnc_get_cliente(ct.proprietario_cod_pessoa) as proprietario
                 , kss.pkg_pessoa.fnc_get_cliente(ct.motorista_cod_pessoa) as motorista
                 , ct.valor_frete_bruto as valor
              from oper.v$contrato_transp ct
             where ct.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os dados do romaneio/pagbem
    -- FABIOG 16/06/2011 - CRIADO
    --->
    <cffunction name="get_dados_contrato" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="no" default="" />
    	<cfargument name="contrato_id" required="no" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.contrato_id
                 , c.processo_transporte_codigo
                 , c.num_romaneio
                 , c.lancto_id
                 , case
				      when c.cartao_id is not null then (select ca.cartao_numero
                                                           from pagbem.v$cartao ca
                                                          where ca.cartao_id = c.cartao_id
                                                        )
					  else pagbem.pkg_pagbem.fnc_cartao_solicitacao(p_lancto_id        => c.lancto_id
                                                                  , p_cartao_motorista => 0
                                                                   )
				   end as cartao_numero
                 , c.valor_inicial_adiantamento
                 , c.valor_inicial_frete
                 , c.usuario_cancelamento
                 , to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi') as data_cancelamento
                 , (select count(1)
                      from pagbem.v$contrato_quitacao cq
                     where cq.contrato_id = c.contrato_id
                       and cq.data_estorno is null
                   ) as contrato_quitado
                 , (select cq.contrato_quitacao_id
                      from pagbem.v$contrato_quitacao cq
                     where cq.contrato_id = c.contrato_id
                       and cq.data_estorno is null
                   ) as contrato_quitacao_id
                 , (select cq.user_insert
                      from pagbem.v$contrato_quitacao cq
                     where cq.contrato_id = c.contrato_id
                       and cq.data_estorno is null
                   ) as usuario_quitacao
                 , (select to_char(nvl(cq.data_quitacao, cq.date_insert), 'dd/mm/yyyy hh24:mi')
                      from pagbem.v$contrato_quitacao cq
                     where cq.contrato_id = c.contrato_id
                       and cq.data_estorno is null
                   ) as data_quitacao
                 , 0 as contrato_pagamento
                 , (select un.cod_unidade_negocio || ' - ' || kss.pkg_pessoa.fnc_get_cliente(un.cod_pessoa, 1)
                      from kss.v$unidade_negocio un
                     where un.cod_pessoa = c.cod_pessoa_filial) as unidade_negocio
              from pagbem.v$contrato c
             where 1 = 1
            <cfif Len(Trim(arguments.num_romaneio))>
               and c.num_romaneio = #arguments.num_romaneio#
            <cfelseif Len(Trim(arguments.contrato_id))>
               and c.contrato_id = #arguments.contrato_id#
            </cfif>
             order by c.processo_transporte_codigo
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os dados do romaneio/pagbem
    -- FABIOG 16/06/2011 - CRIADO
    --->
    <cffunction name="get_dados_quitacao" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_quitacao_id" required="no" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select qs.peso_entrega
			     , qs.valor_avaria
			     , qs.valor_saldo_quitacao
			     , qs.valor_saldo_motorista
			     , qs.valor_diferenca_frete
			     , qs.valor_quebra
			     , decode(qs.documentos_entregues, 1, 'Sim', 'Não') as documentos_entregues
			  from pagbem.v$contrato_quitacao cq
			 inner join pagbem.v$quitacao_simulacao qs
			    on qs.quitacao_simulacao_id = cq.quitacao_simulacao_id
			 where 1 = 1
            <cfif Len(Trim(arguments.contrato_quitacao_id))>
               and cq.contrato_quitacao_id = #arguments.contrato_quitacao_id#
            </cfif>
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os dados do contrato/pagbem para o nó processo_transporte
    -- FABIOG 16/06/2011 - CRIADO
    --->
    <cffunction name="get_dados_contrato_consulta" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select extractvalue(xmltype.createxml(r.xml_retorno) , '/retorno/resultado/situacaoFrete') as situacaoFrete
				     , extractvalue(xmltype.createxml(r.xml_retorno) , '/retorno/resultado/saldos/valorLiberado') as valorLiberado
				     , extractvalue(xmltype.createxml(r.xml_retorno) , '/retorno/resultado/saldos/valorTotalConsumido') as valorTotalConsumido
				     , extractvalue(xmltype.createxml(r.xml_retorno) , '/retorno/resultado/saldos/valorBloqueado') as valorBloqueado
				     , extractvalue(xmltype.createxml(r.xml_retorno) , '/retorno/resultado/pagamentoFrete/freteQuitacaoRegras/quebraTolerancia') as quebraTolerancia
			         , extractvalue(xmltype.createxml(r.xml_retorno) , '/retorno/resultado/pagamentoFrete/freteQuitacaoRegras/tipoTolerancia') as tipoTolerancia
			         , extractvalue(xmltype.createxml(r.xml_retorno) , '/retorno/resultado/pagamentoFrete/freteQuitacaoRegras/quebraTipoCobranca') as quebraTipoCobranca
			         , extractvalue(xmltype.createxml(r.xml_retorno) , '/retorno/resultado/pagamentoFrete/freteQuitacaoRegras/freteTipoPeso') as freteTipoPeso
			         , extractvalue(xmltype.createxml(r.xml_retorno) , '/retorno/resultado/pagamentoFrete/freteQuitacaoRegras/freteLimiteSuperior') as freteLimiteSuperior
			         , extractvalue(xmltype.createxml(r.xml_retorno) , '/retorno/resultado/pagamentoFrete/freteQuitacaoRegras/avariaTipoCobranca') as avariaTipoCobranca
				  from pagbem.v$requisicao r
				 where r.requisicao_id = #arguments.REQUISICAO_ID#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os dados do contrato/pagbem para o nó movimento/movimentos
    -- FABIOG 16/06/2011 - CRIADO
    --->
    <cffunction name="get_dados_contr_proc_trans_movi" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select nvl((select tp.descricao
                          from pagbem.v$tipo_movimento tp
                         where tp.movimento_codigo = extractvalue(t.column_value, 'movimento/movimento_codigo')
                       ), 'DESCRIÇÃO NÃO DEFINIDA'
                      ) as descricao
                 , to_char(replace(extractvalue(t.column_value, 'movimento/valor'), ',', ''), 'FM9G9999G990D00', 'nls_numeric_characters=,.') as valor
                 , extractvalue(t.column_value, 'movimento/data') as data
              from table(xmlsequence(extract(pagbem.pkg_comunicacao.fnc_xml_retorno_requisicao(#arguments.REQUISICAO_ID#), '/processo_transporte/movimentos/movimento'))) t
		</cfquery>
		<cfreturn qr_result>
    </cffunction>


    <!---
    -- PROPÓSITO
    -- Retorna os dados do contrato/pagbem para o nó cupons/cupom
    -- FABIOG 16/06/2011 - CRIADO
    --->
    <cffunction name="get_dados_contr_proc_trans_cupom" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select extractvalue(t.column_value, 'cupom/cupom_codigo') as cupom_codigo
                     , extractvalue(t.column_value, 'cupom/posto') as posto
                     , extractvalue(t.column_value, 'cupom/data') as data
                     , extractvalue(t.column_value, 'cupom/hora') as hora
                  from table(xmlsequence(extract(pagbem.pkg_comunicacao.fnc_xml_retorno_requisicao(#arguments.REQUISICAO_ID#), '/processo_transporte/cupons/cupom'))) t
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os dados do contrato/pagbem para o nó itens/item
    -- FABIOG 16/06/2011 - CRIADO
    --->
    <cffunction name="get_dados_contr_proc_trans_item" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select extractvalue(t.column_value, 'item/quantidade') as quantidade
                     , extractvalue(t.column_value, 'item/valor') as valor
                     , extractvalue(t.column_value, 'item/data_vencimento_nf') as data_vencimento_nf
                     , extractvalue(t.column_value, 'item/produto') as produto
                  from table(xmlsequence(extract(pagbem.pkg_comunicacao.fnc_xml_retorno_requisicao(#arguments.REQUISICAO_ID#), '/processo_transporte/cupons/cupom/itens/item'))) t
		</cfquery>
		<cfreturn qr_result>
    </cffunction>



     <!---
	  -- PROPÓSITO
      -- Retorna os dados de Grupo de Mercadoria
	  -- FABIOG 18/07/2011 - CRIADO
	  --->
    <cffunction name="get_dados_agendamento" access="remote" returntype="query" output="true">
    	<cfargument name="num_romaneio" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select v.composicao
                     , kss.pkg_pessoa.fnc_get_cliente(v.cod_motorista) as motorista
                     , to_char(v.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
                     , to_char(v.data_termino, 'dd/mm/yyyy hh24:mi') as data_termino
                  from logistica.v$viagem v
                 where v.num_romaneio = #arguments.num_romaneio#
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

















    <!---
    -- PROPÓSITO
    -- Retorna o histórico da utilização dos cartões Repom
    -- ANDERSON 10/09/2011 - CRIADO
    --->
    <cffunction name="get_historico_cartao" access="remote" returntype="query" output="true">
    	<cfargument name="cartao_numero" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="cod_proprietario" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.contrato_id
                 , t.processo_transporte_codigo
                 , t.num_romaneio
                 , t.unidade_negocio
                 , t.centro_custo
                 , t.cartao_numero
                 , t.proprietario_cnpj_cpf
                 , t.proprietario_razao_social
                 , t.proprietario
                 , t.motorista_cpf
                 , t.motorista
                 , t.cod_veiculo_cavalo
                 , t.placa_cavalo
                 , t.cod_veiculo_carreta
                 , t.placa_carreta
                 , t.user_insert
                 , to_char(t.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , t.usuario_cancelamento
                 , to_char(t.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
                 , (select count(*)
                      from pagbem.v$contrato co
                     where co.cartao_id = t.cartao_id
                       --and co.status_codigo in (1,14)todo
                       ) as num_contratos
              from (
                    select ct.contrato_id
                         , ct.processo_transporte_codigo
                         , ct.num_romaneio
                         , (select o.cod_unidade_negocio || ' - ' || kss.pkg_pessoa.fnc_get_cliente(o.cod_pessoa, 1)
                              from logistica.v$viagem v
                             inner join logistica.v$viagem_carga vc
                                     on vc.viagem_id = v.viagem_id
                             inner join logistica.v$solicitacao_carga sc
                                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = sc.cod_organograma
                             where v.num_romaneio = ct.num_romaneio
                               and rownum = 1
                           ) as unidade_negocio
                         , (select o.cod_centro_custo || ' - ' || cc.centro_custo
                              from logistica.v$viagem v
                             inner join logistica.v$viagem_carga vc
                                     on vc.viagem_id = v.viagem_id
                             inner join logistica.v$solicitacao_carga sc
                                     on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                             inner join kss.v$organograma o
                                     on o.cod_organograma = sc.cod_organograma
                             inner join kss.v$centro_custo cc
                                     on cc.cod_centro_custo = o.cod_centro_custo
                             where v.num_romaneio = ct.num_romaneio
                               and rownum = 1
                           ) as centro_custo
                         , c.cartao_numero
                         , c.cartao_id
                         , kss.pkg_pessoa.fnc_get_identificador(ct.cod_proprietario) as proprietario_cnpj_cpf
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_proprietario) as proprietario_razao_social
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_proprietario, 1) as proprietario
                         , kss.pkg_pessoa.fnc_get_identificador(ct.cod_motorista) as motorista_cpf
                         , kss.pkg_pessoa.fnc_get_cliente(ct.cod_motorista, 1) as motorista
                         , oper.pkg_veiculo.fnc_placa(ct.veiculo_id_cavalo) as placa_cavalo
                         , oper.pkg_veiculo.fnc_cod_veiculo(ct.veiculo_id_cavalo) as cod_veiculo_cavalo
                         , oper.pkg_veiculo.fnc_placa(ct.veiculo_id_carreta) as placa_carreta
                         , oper.pkg_veiculo.fnc_cod_veiculo(ct.veiculo_id_carreta) as cod_veiculo_carreta
                         , ct.user_insert
                         , ct.date_insert
                         , ct.usuario_cancelamento
                         , ct.data_cancelamento
                      from pagbem.v$contrato ct
                      left join pagbem.v$cartao c
                        on c.cartao_id = ct.cartao_id
                     where 1 = 1
                       and (
                            <cfif Len(Trim(arguments.cartao_numero))>
								c.cartao_numero = to_char(#arguments.cartao_numero#)
                            </cfif>

                            <cfif Len(Trim(arguments.cod_motorista))>
								<cfif Len(Trim(arguments.cartao_numero))>
                                	or
                                </cfif>
                                ct.cod_motorista = #arguments.cod_motorista#
                            </cfif>

                            <cfif Len(Trim(arguments.cod_proprietario))>
                            	<cfif Len(Trim(arguments.cartao_numero)) or Len(Trim(arguments.cod_motorista))>
                                    or
                                </cfif>
                                ct.cod_proprietario = #arguments.cod_proprietario#
                            </cfif>
                           )
                     order by ct.date_insert desc
                   ) t
             where rownum <= 10
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna o status de validação das integrações com a Repom
    -- ANDERSON 22/09/2011 - CRIADO
    --->
    <cffunction name="get_validacao_romaneio" access="remote" returntype="Struct" output="true">
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="cartao_numero" required="no" default="" />
        <cfargument name="rota_id" required="no" default="" />
        <cfargument name="cod_contratado" required="no" default="" />
        <cfargument name="cod_motorista" required="no" default="" />
        <cfargument name="placa_cavalo" required="no" default="" />
        <cfargument name="placa_carreta" required="no" default="" />
        <cftry>
        	<cftransaction action='begin'>
				<cfif arguments.placa_carreta eq arguments.placa_cavalo>
                    <cfset arguments.placa_carreta = '' />
                </cfif>

                <cfscript>
                    conn = CreateComponent("modulos.pagbem._componentes.manipulacao.cfc_pagbem");
                </cfscript>

                <cfscript>
                    ret_antt = conn.retorno_antt(placa_cavalo   = arguments.placa_cavalo
                                                ,placa_carreta  = arguments.placa_carreta
                                                ,cod_contratado = arguments.cod_contratado);

                </cfscript>
                <cfif ret_antt.erro>
                    <cfthrow object="#ret_antt.mensagem#">
                </cfif>

                <cfset retorno.veiculo_validado_antt = ret_antt.veiculo_validado_antt>
                <cfset retorno.veiculo_erro = ret_antt.veiculo_erro>
                <cfset retorno.carreta_validado_antt = ret_antt.carreta_validado_antt>
                <cfset retorno.carreta_erro = ret_antt.carreta_erro>
                <cfset retorno.contratado_validado_antt = ret_antt.contratado_validado_antt>
                <cfset retorno.contratado_erro = ret_antt.contratado_erro>

                <cfif Len(Trim(arguments.num_romaneio))>
                    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#" debug="yes">
                        select case
                                  when '#arguments.cartao_numero#' is not null then
                                     (select sign(count(1))
                                        from pagbem.v$cartao c
                                       where c.cartao_numero = '#arguments.cartao_numero#'
                                         and c.requisicao_id is not null
                                     )
                                  else
                                     (select sign(count(1))
                                        from logistica.v$viagem_carga vc
                                       inner join pagbem.v$solicitacao_carga_dados scd
                                               on scd.solicitacao_carga_id = vc.solicitacao_carga_id
                                       inner join pagbem.v$cartao c
                                               on c.cartao_id = scd.cartao_id
                                       where vc.viagem_id = v.viagem_id
                                         and vc.solicitacao_carga_id = (select max(scd2.solicitacao_carga_id) keep(dense_rank last order by scd2.date_insert)
                                                                          from logistica.v$viagem_carga vc2
                                                                         inner join pagbem.v$solicitacao_carga_dados scd2
                                                                                 on scd2.solicitacao_carga_id = vc2.solicitacao_carga_id
                                                                         where vc2.viagem_id = vc.viagem_id
                                                                       )
                                         and c.requisicao_id is not null
                                     )
                               end as cartao_ok
                             , null as cartao_avisos
                             , case
                                  when '#arguments.rota_id#' is not null then
                                     pagbem.pkg_logistica.fnc_rota_ok(null, v.viagem_id, '#arguments.rota_id#', case
																						                            when '#arguments.placa_cavalo#' is not null then
																						                            	oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
																						                            else 0
																					                            end)
                                  else 0
                               end as rota_ok
							 , case
                                  when '#arguments.rota_id#' is not null then
                                     pagbem.pkg_logistica.fnc_rota_tag_ok('#arguments.rota_id#', case
																									when '#arguments.placa_cavalo#' is not null then
																										oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
																									else 0
																								 end)
                                  else -1
                               end as rota_tag_ok
							 , case
						          when '#arguments.rota_id#' is not null then
						           pagbem.pkg_logistica.fnc_roteirizacao_id('#arguments.rota_id#', case
																			                            when '#arguments.placa_cavalo#' is not null then
																			                            	oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
																			                            else 0
																		                            end)
						          else
						           null
						       end as roteirizacao_id
                             , case
                                  when '#arguments.cod_contratado#' is not null then
                                     pagbem.pkg_logistica.fnc_contratado_ok(null, v.viagem_id, '#arguments.cod_contratado#')
                                  else 0
                               end as contratado_ok
                             , case
                                  when '#arguments.cod_contratado#' is not null then
                                     pagbem.pkg_logistica.fnc_contratado_avisos(null, v.viagem_id, '#arguments.cod_contratado#')
                                  else null
                               end as contratado_avisos
                             , case
                                  when '#arguments.cod_motorista#' is not null then
                                     pagbem.pkg_logistica.fnc_motorista_ok(null, v.viagem_id, '#arguments.cod_motorista#')
                                  else 0
                               end as motorista_ok
                             , case
                                  when '#arguments.cod_motorista#' is not null then
                                     pagbem.pkg_logistica.fnc_motorista_avisos(null, v.viagem_id, '#arguments.cod_motorista#')
                                  else null
                               end as motorista_avisos
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_ok(null, v.viagem_id, '#arguments.placa_cavalo#')
                                  else 0
                               end as cavalo_ok
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_avisos(null, v.viagem_id, '#arguments.placa_cavalo#')
                                  else null
                               end as cavalo_avisos
							 , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_tag_ok(null, v.viagem_id, '#arguments.placa_cavalo#')
                                  else 0
                               end as cavalo_semparar_ok
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_tag_mensagem(null, v.viagem_id, '#arguments.placa_cavalo#')
                                  else null
                               end as cavalo_tag_mensagem
                             , case
                                  when '#arguments.placa_carreta#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_ok(null, v.viagem_id, '#arguments.placa_carreta#')
                                  else 1
                               end as carreta_ok
                             , case
                                  when '#arguments.placa_carreta#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_avisos(null, v.viagem_id, '#arguments.placa_carreta#')
                                  else null
                               end as carreta_avisos
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
                                  else 0
                               end as numero_eixos
                          from logistica.v$viagem v
                         where v.num_romaneio = #arguments.num_romaneio#
                    </cfquery>
                <cfelse>
                    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                        select (select sign(count(1))
                                  from pagbem.v$cartao c
                                 where c.cartao_numero = '#arguments.cartao_numero#'
                                   and c.requisicao_id is not null
                               ) as cartao_ok
                             , null as cartao_avisos
                             , case
                                  when '#arguments.rota_id#' is not null then
                                     pagbem.pkg_logistica.fnc_rota_ok(null, null, '#arguments.rota_id#', case
																						                 	when '#arguments.placa_cavalo#' is not null then
																						                 		oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
																						                 	else 0
																					                     end)
                                  else 0
                               end as rota_ok
							 , case
                                  when '#arguments.rota_id#' is not null then
                                     pagbem.pkg_logistica.fnc_rota_tag_ok('#arguments.rota_id#', case
																									when '#arguments.placa_cavalo#' is not null then
																										oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
																									else 0
																								 end)
                                  else -1
                               end as rota_tag_ok
							 , case
						          when '#arguments.rota_id#' is not null then
						           pagbem.pkg_logistica.fnc_roteirizacao_id('#arguments.rota_id#', case
																			                            when '#arguments.placa_cavalo#' is not null then
																			                            	oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
																			                            else 0
																		                            end)
						          else
						           null
						       end as roteirizacao_id
                             , case
                                  when '#arguments.cod_contratado#' is not null then
                                     pagbem.pkg_logistica.fnc_contratado_ok(null, null, '#arguments.cod_contratado#')
                                  else 0
                               end as contratado_ok
                             , case
                                  when '#arguments.cod_contratado#' is not null then
                                     pagbem.pkg_logistica.fnc_contratado_avisos(null, null, '#arguments.cod_contratado#')
                                  else null
                               end as contratado_avisos
                             , case
                                  when '#arguments.cod_motorista#' is not null then
                                     pagbem.pkg_logistica.fnc_motorista_ok(null, null, '#arguments.cod_motorista#')
                                  else 0
                               end as motorista_ok
                             , case
                                  when '#arguments.cod_motorista#' is not null then
                                     pagbem.pkg_logistica.fnc_motorista_avisos(null, null, '#arguments.cod_motorista#')
                                  else null
                               end as motorista_avisos
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_ok(null, null, '#arguments.placa_cavalo#')
                                  else 0
                               end as cavalo_ok
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_avisos(null, null, '#arguments.placa_cavalo#')
                                  else null
                               end as cavalo_avisos
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_tag_ok(null, null, '#arguments.placa_cavalo#')
                                  else 0
                               end as cavalo_semparar_ok
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_tag_mensagem(null, null, '#arguments.placa_cavalo#')
                                  else null
                               end as cavalo_tag_mensagem
							 , case
                                  when '#arguments.placa_carreta#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_ok(null, null, '#arguments.placa_carreta#')
                                  else 0
                               end as carreta_ok
                             , case
                                  when '#arguments.placa_carreta#' is not null then
                                     pagbem.pkg_logistica.fnc_veiculo_avisos(null, null, '#arguments.placa_carreta#')
                                  else null
                               end as carreta_avisos
                             , case
                                  when '#arguments.placa_cavalo#' is not null then
                                     oper.pkg_veiculo.fnc_numero_eixos_composicao('#arguments.placa_cavalo#', '#arguments.placa_carreta#')
                                  else 0
                               end as numero_eixos
                          from dual
                    </cfquery>
        		</cfif>
                <cfset retorno.query = qr_result>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os métodos da Repom
    -- ANDERSON 03/10/2011 - CRIADO
    --->
    <cffunction name="get_metodo" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.metodo
              from pagbem.v$metodo m
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna as requisições da Repom
    -- ANDERSON 03/10/2011 - CRIADO
    --->
    <cffunction name="get_requisicao" access="remote" returntype="query" output="true">
    	<cfargument name="metodo" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.requisicao_id
                 , r.metodo
                 , kss.to_tempo(r.tempo_execucao, 5).retorno as tempo_execucao
                 , case
                      when r.erro is not null then 1
                      else 0
                   end as possui_erro
                 , r.user_insert
                 , to_char(r.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , r.user_update
                 , to_char(r.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from pagbem.v$requisicao r
             where 1 = 1
			<cfif Len(Trim(arguments.metodo))>
               and upper(r.metodo) = upper('#arguments.metodo#')
			</cfif>

            <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
               and r.date_insert between to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
			<cfelseif Len(Trim(arguments.data_inicio))>
               and r.date_insert >= to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss')
			<cfelseif Len(Trim(arguments.data_termino))>
               and r.date_insert <= to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
			</cfif>
             order by r.date_insert desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna o XML de Envio de uma requisição
    -- ANDERSON 03/10/2011 - CRIADO
    --->
    <cffunction name="get_requisicao_xml_envio" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.xml_envio.getClobVal() as xml_envio
              from pagbem.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna o XML de Retorno de uma requisição
    -- ANDERSON 03/10/2011 - CRIADO
    --->
    <cffunction name="get_requisicao_xml_retorno" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select xmlserialize(document xmltype.createxml(r.xml_retorno) as CLOB INDENT SIZE = 2) as xml_retorno
              from pagbem.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna o JSON de Envio de uma requisição
    -- ANDERSON 03/10/2011 - CRIADO
    --->
    <cffunction name="get_requisicao_json_envio" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.json_envio as json_envio
              from pagbem.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna o JSON de Retorno de uma requisição
    -- ANDERSON 03/10/2011 - CRIADO
    --->
    <cffunction name="get_requisicao_json_retorno" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.json_retorno
              from pagbem.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna o Erro de uma requisição
    -- ANDERSON 03/10/2011 - CRIADO
    --->
    <cffunction name="get_requisicao_erro" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.erro
              from pagbem.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os contratos quitados aguardando autorizacao de pagamento
    -- GUTO 23/01/2012 - CRIADO
    --->
    <cffunction name="get_contrato_autorizacao" access="remote" returntype="query" output="true">
    	<cfargument name="lancto_id" required="no" default="" />
    	<cfargument name="processo_transporte_codigo" required="no" default="" />
        <cfargument name="num_romaneio" required="no" default="" />
        <cfargument name="cod_centro_custo" required="no" default="" />
        <cfargument name="cod_organograma_quitacao" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfargument name="data_inicio_quit" required="no" default="" />
        <cfargument name="data_termino_quit" required="no" default="" />
        <cfargument name="cod_pessoa_agregado" required="no" default="" />
        <cfargument name="placa" required="no" default="" />
        <cfargument name="status_codigo" required="no" default="" />
        <cfargument name="modalidade_veiculo" required="no" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.contrato_id
            	 , c.contrato_id as contrato_id_pagbem
                 , to_char(ct.data_emissao, 'dd/mm/yyyy') as data_emissao_contrato
                 , c.tipo_contrato
                 , kss.fnc_ref_code('REPOM', 'REPOM.TIPO_CONTRATO', c.tipo_contrato) as tipo_contrato_desc
                 , c.cod_pessoa_filial
                 , case
                    when ct.lancto_id is null then kss.pkg_pessoa.fnc_get_cliente(c.cod_pessoa_filial, 1)
                   else (select cc.centro_custo
                           from kss.v$centro_custo cc
                          where cc.cod_centro_custo = ct.cod_centro_custo) end filial
                 , c.num_romaneio
                 , c.processo_cliente_codigo
                 , c.processo_transporte_codigo
                 , c.cartao_id
                 , case
				      when c.cartao_id is not null then (select crt.cartao_numero
                                                           from pagbem.v$cartao crt
                                                          where crt.cartao_id = c.cartao_id
                                                        )
					  else pagbem.pkg_pagbem.fnc_cartao_solicitacao(p_lancto_id        => c.lancto_id
                                                                  , p_cartao_motorista => 0
                                                                   )
				   end as cartao_numero
                 , c.cod_proprietario
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_proprietario, 1) as proprietario
                 , c.cod_motorista
                 , kss.pkg_pessoa.fnc_get_cliente(c.cod_motorista, 1) as motorista
                 , c.veiculo_id_cavalo
                 , oper.pkg_veiculo.fnc_placa(c.veiculo_id_cavalo) as placa_cavalo
                 , c.veiculo_id_carreta
                 , oper.pkg_veiculo.fnc_placa(c.veiculo_id_carreta) as placa_carreta
                 , c.rota_id
                 , ct.valor_adto as valor_adiantamento
                 , ct.valor_frete_bruto as valor_contrato
                 , ct.valor_pedagio
                 , ct.valor_saldo
                 , c.internacional
                 , c.situacao_id
                 , kss.fnc_ref_code('REPOM', 'CONTRATO_MOVIMENTO.SITUACAO_ID', c.situacao_id) as situacao
                 , c.requisicao_id
                 , c.processo_transporte_codigo
                 , c.lancto_id
                 , c.usuario_cancelamento
                 , to_char(c.data_cancelamento, 'dd/mm/yyyy hh24:mi:ss') as data_cancelamento
                 , (select sign(count(1))
                      from pagbem.v$contrato_quitacao cq
                     where cq.contrato_id = c.contrato_id
                   ) as contrato_quitado
                 , cq.contrato_quitacao_id as contrato_quitacao_id
                 , (select sign(count(1))
                      from pagbem.v$contrato_pagamento cp
                     where cp.contrato_id = c.contrato_id
                   ) as pagamento_autorizado
                 , nvl((select cc.centro_custo
                      from kss.v$centro_custo cc
                     inner join kss.v$organograma o
                             on o.cod_centro_custo = cc.cod_centro_custo
                     where o.cod_organograma = cq.cod_organograma),'Posto') as filial_quitacao
                 , to_char(nvl(cq.data_quitacao, cq.date_insert),'dd/mm/yyyy') as data_quitacao
                 , cq.user_insert as usuario_quitacao
                 , ct.remetente
                 , ct.num_nota_fiscal
                 , ct.total_nota_fiscal
                 , ct.num_conhecimento
                 , ct.num_crt
                 , case
                      when oper.pkg_contrato_transp.fnc_custo_documento(ct.num_romaneio,null,null,null,null) > 0 then
                           round((ct.valor_frete_bruto/oper.pkg_contrato_transp.fnc_custo_documento(ct.num_romaneio,null,null,null,null)) * oper.pkg_contrato_transp.fnc_valor_contrato_receita(ct.num_romaneio,null,null,null),2)
                   else oper.pkg_contrato_transp.fnc_valor_contrato_receita(ct.num_romaneio,null,null,null) end total_receita
                 , round(oper.pkg_contrato_transp.fnc_valor_contrato_receita(ct.num_romaneio,null,null,null),2) as total_receita_viagem
                 , round(oper.pkg_contrato_transp.fnc_custo_documento(ct.num_romaneio,null,null,null,null),2) as total_custo_viagem
                 , case
                      when oper.pkg_contrato_transp.fnc_valor_contrato_receita(ct.num_romaneio,null,null,null) = 0 then 0
                    else round(100*(oper.pkg_contrato_transp.fnc_custo_documento(ct.num_romaneio,null,null,null,null)/oper.pkg_contrato_transp.fnc_valor_contrato_receita(ct.num_romaneio,null,null,null)),2) end percentual_custo
                 , to_char(ct.data_emissao_cte,'dd/mm/yyyy')  as data_emissao_cte
                 , to_char(ct.data_emissao_nfe,'dd/mm/yyyy')  as data_emissao_nfe
                 , ct.num_fatura
                 , ct.num_fatura_nfe
                 , to_char(ct.data_emissao_fatura_nfe,'dd/mm/yyyy')  as data_emissao_fatura_nfe
                 , to_char(ct.data_emissao_fatura_cte,'dd/mm/yyyy')  as data_emissao_fatura_cte
                 , ct.num_fatura_crt
                 , to_char(ct.data_emissao_fatura_crt,'dd/mm/yyyy')  as data_emissao_fatura_crt
                 , c.status_codigo
                 , kss.fnc_ref_code('REPOM', 'CONTRATO.STATUS_CODIGO', c.status_codigo) as status
                 , to_char((select max(cp.data_autorizacao)
                      from pagbem.v$contrato_pagamento cp
                     where cp.contrato_id = c.contrato_id
                   ),'dd/mm/yyyy')  as data_autorizacao
                 , ct.saldo_contrato
                 , ct.valor_total_operacao
                 , ct.modalidade_veiculo
              from pagbem.v$contrato c
             left join pagbem.v$contrato_quitacao cq
                     on cq.contrato_id = c.contrato_id
                    and cq.data_estorno is null
             left join oper.v$contrato_transp_listagem ct
                    on ct.lancto_id = c.lancto_id
             where 1 = 1
            <cfif Len(Trim(arguments.status_codigo))>
               and c.status_codigo in (#arguments.status_codigo#)
            </cfif>
            <cfif Len(Trim(arguments.processo_transporte_codigo))>
              and c.processo_transporte_codigo in (#arguments.processo_transporte_codigo#)
            </cfif>
            <cfif Len(Trim(arguments.cod_centro_custo)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and ct.cod_centro_custo = #arguments.cod_centro_custo#
            </cfif>
            <cfif Len(Trim(arguments.num_romaneio)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and c.num_romaneio in (#arguments.num_romaneio#)
            </cfif>
            <cfif Len(Trim(arguments.lancto_id)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and c.lancto_id = #arguments.lancto_id#
            </cfif>

            <cfif Len(Trim(arguments.data_inicio)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and trunc(ct.data_emissao) >= '#arguments.data_inicio#'
            </cfif>
            <cfif Len(Trim(arguments.data_termino)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and trunc(ct.data_emissao) <= '#arguments.data_termino#'
            </cfif>
            <cfif Len(Trim(arguments.data_inicio_quit)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and trunc(cq.date_insert) >= '#arguments.data_inicio_quit#'
            </cfif>
            <cfif Len(Trim(arguments.data_termino_quit)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and trunc(cq.date_insert) <= '#arguments.data_termino_quit#'
            </cfif>

            <cfif Len(Trim(arguments.cod_organograma_quitacao)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and cq.cod_organograma = #arguments.cod_organograma_quitacao#
            </cfif>
            <cfif Len(Trim(arguments.cod_pessoa_agregado)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and c.cod_proprietario = #arguments.cod_pessoa_agregado#
            </cfif>
            <cfif Len(Trim(arguments.placa)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and oper.pkg_veiculo.fnc_placa(c.veiculo_id_cavalo) = '#arguments.placa#'
            </cfif>
            <cfif IsDefined('arguments.modalidade_veiculo') and Len(Trim(arguments.modalidade_veiculo)) and not Len(Trim(arguments.processo_transporte_codigo))>
               and ct.modalidade_veiculo = '#arguments.modalidade_veiculo#'
            </cfif>
             order by c.processo_transporte_codigo
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna organogramas que fizerem quitacao de contrato
    -- GUTO 03/10/2011 - CRIADO
    --->
    <cffunction name="get_organograma_quitacao" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.cod_organograma
                 , cc.cod_centro_custo
                 , cc.centro_custo
              from pagbem.v$contrato_quitacao cq
             inner join kss.v$organograma o
                     on o.cod_organograma = cq.cod_organograma
             inner join kss.v$centro_custo cc
                     on cc.cod_centro_custo = o.cod_centro_custo
            group by o.cod_organograma
                   , cc.cod_centro_custo
                   , cc.centro_custo
         </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna CG_REF_CODES
    -- GUTO 16/06/2011 - CRIADO
    --->
    <cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
    	<cfargument name="rv_domain" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cg.rv_low_value as id, cg.rv_abbreviation as descricao, cg.rv_meaning as descricao_completa
              from pagbem.v$cg_ref_codes cg
             where cg.rv_domain = upper('#arguments.rv_domain#')
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorno Financeiro
    -- ANDERSON 17/07/2012 - CRIADO
    --->
    <cffunction name="get_retorno_financeiro" access="remote" returntype="query" output="true">
    	<cfargument name="internacional" required="no" default="" />
        <cfargument name="contrato_pagbem" required="no" default="" />
        <cfargument name="titulo_bancario" required="no" default="" />
        <cfargument name="situacao_id" required="no" default="" />
        <cfargument name="data_movimento_inicio" required="no" default="" />
        <cfargument name="data_movimento_fim" required="no" default="" />
        <cfargument name="data_transacao_inicio" required="no" default="" />
        <cfargument name="data_transacao_fim" required="no" default="" />
        <cfargument name="data_pagamento_inicio" required="no" default="" />
        <cfargument name="data_pagamento_fim" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rf.retorno_financeiro_id
                 , to_char(rf.data_movimento, 'dd/mm/yyyy') as data_movimento
                 , decode(rf.internacional, 0, 'Não', 'Sim') as internacional
                 , rf.identificador_registro
                 , rf.contrato_pagbem
                 , rf.processo_transporte_cliente
                 , case
                      when (select c.tipo_unidade_emissao
                              from pagbem.v$contrato c
                             where c.processo_transporte_codigo = rf.contrato_pagbem
                               and c.internacional = rf.internacional
                           ) = 'UNIDADE_NEGOCIO' then (select lpad(un.cod_unidade_negocio, 4, 0) || ' - ' || un.unidade_negocio
                                                         from kss.v$unidade_negocio un
                                                        where un.cod_unidade_negocio = rf.filial_emissao
                                                      )
                      else (select lpad(cc.cod_centro_custo, 4, 0) || ' - ' || cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = rf.filial_emissao
                           )
                   end as filial_emissao
                 , (select tf.nome
                      from pagbem.v$tipo_transacao_financeira tf
                     where tf.cod_tipo_transacao = rf.tipo_transacao_financeira) as tipo_transacao_financeira
                 , decode(rf.tipo_movimentacao_financeira, 0, 'Débito', 'Crédito') as tipo_movimentacao_financeira
                 , rf.valor_transacao_financeira
                 , to_char(rf.data_transacao_financeira, 'dd/mm/yyyy') as data_transacao_financeira
                 , to_char(rf.data_pagamento, 'dd/mm/yyyy') as data_pagamento
                 , rf.titulo_bancario
                 , rf.valor_titulo_bancario
                 , rf.lancto_finan_id
                 , rf.lancto_finan_erro
                 , rf.num_lancamento_cc
                 , rf.situacao_id
                 , c.lancto_id
                 , decode(c.data_cancelamento,null,'Emitido','Cancelado') as contrato_status
                 , (select min(decode(fcp.situacao,0,'Em aberto','Quitado')) keep (dense_rank last order by fcp.date_insert)
                      from oper.v$contrato_transp_pagar ctp
                      inner join finan.v$finan_contas_pagar fcp
                              on fcp.contas_pagar_id = ctp.contas_pagar_id
                     where ctp.lancto_id = c.lancto_id) as cpg_status
                 , (select cg.rv_high_value
                      from pagbem.v$cg_ref_codes cg
                     where cg.rv_domain = 'RETORNO FINANCEIRO SITUACAO'
                       and cg.rv_low_value = rf.situacao_id) as situacao
              from pagbem.v$retorno_financeiro rf
             left join pagbem.v$contrato c
                     on c.processo_transporte_codigo = rf.contrato_pagbem
                    and c.internacional = rf.internacional
             where 1 = 1
			<cfif Len(Trim(arguments.internacional))>
               and rf.internacional = #arguments.internacional#
			</cfif>

            <cfif Len(Trim(arguments.contrato_pagbem))>
               and rf.contrato_pagbem = #arguments.contrato_pagbem#
            </cfif>

            <cfif Len(Trim(arguments.titulo_bancario)) and not Len(Trim(arguments.contrato_pagbem))>
              and rf.titulo_bancario = #arguments.titulo_bancario#
            </cfif>

            <cfif Len(Trim(arguments.situacao_id)) and not Len(Trim(arguments.contrato_pagbem))>
              and rf.situacao_id = #arguments.situacao_id#
            </cfif>

            <cfif Len(Trim(arguments.data_movimento_inicio)) and Len(Trim(arguments.data_movimento_fim)) and not Len(Trim(arguments.contrato_pagbem))>
               and rf.data_movimento between to_date('#arguments.data_movimento_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_movimento_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfelseif Len(Trim(arguments.data_movimento_inicio)) and not Len(Trim(arguments.contrato_pagbem))>
               and rf.data_movimento >= to_date('#arguments.data_movimento_inicio#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_movimento_fim)) and not Len(Trim(arguments.contrato_pagbem))>
               and rf.data_movimento <= to_date('#arguments.data_movimento_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>

            <cfif Len(Trim(arguments.data_transacao_inicio)) and Len(Trim(arguments.data_transacao_fim)) and not Len(Trim(arguments.contrato_pagbem))>
               and rf.data_transacao_financeira between to_date('#arguments.data_transacao_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_transacao_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfelseif Len(Trim(arguments.data_transacao_inicio)) and not Len(Trim(arguments.contrato_pagbem))>
               and rf.data_transacao_financeira >= to_date('#arguments.data_transacao_inicio#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_transacao_fim)) and not Len(Trim(arguments.contrato_pagbem))>
               and rf.data_transacao_financeira <= to_date('#arguments.data_transacao_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>

            <cfif Len(Trim(arguments.data_pagamento_inicio)) and Len(Trim(arguments.data_pagamento_fim)) and not Len(Trim(arguments.contrato_pagbem))>
               and rf.data_pagamento between to_date('#arguments.data_pagamento_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_pagamento_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfelseif Len(Trim(arguments.data_pagamento_inicio)) and not Len(Trim(arguments.contrato_pagbem))>
               and rf.data_pagamento >= to_date('#arguments.data_pagamento_inicio#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_pagamento_fim)) and not Len(Trim(arguments.contrato_pagbem))>
               and rf.data_pagamento <= to_date('#arguments.data_pagamento_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>

        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorno Contábil/Fiscal
    -- ANDERSON 17/07/2012 - CRIADO
    --->
    <cffunction name="get_retorno_contabil" access="remote" returntype="query" output="true">
    	<cfargument name="internacional" required="no" default="" />
        <cfargument name="contrato_pagbem" required="no" default="" />
        <cfargument name="data_movimento_inicio" required="no" default="" />
        <cfargument name="data_movimento_fim" required="no" default="" />
        <cfargument name="data_transacao_inicio" required="no" default="" />
        <cfargument name="data_transacao_fim" required="no" default="" />
        <cfargument name="situacao_id" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(rc.data_movimento, 'dd/mm/yyyy') as data_movimento
                 , decode(rc.internacional, 0, 'Não', 'Sim') as internacional
                 , rc.identificador_registro
                 , rc.situacao_id
                 , rc.retorno_contabil_id
                 , (select cg.rv_high_value
                      from pagbem.v$cg_ref_codes cg
                     where cg.rv_domain = 'RETORNO CONTABIL SITUACAO'
                       and cg.rv_low_value = rc.situacao_id) as situacao
                 , rc.contrato_pagbem
                 , rc.processo_transporte_cliente
                 , case
                      when (select c.tipo_unidade_emissao
                              from pagbem.v$contrato c
                             where c.processo_transporte_codigo = rc.contrato_pagbem
                               and c.internacional = rc.internacional
                           ) = 'UNIDADE_NEGOCIO' then (select lpad(un.cod_unidade_negocio, 4, 0) || ' - ' || un.unidade_negocio
                                                         from kss.v$unidade_negocio un
                                                        where un.cod_unidade_negocio = rc.filial_emissao
                                                      )
                      else (select lpad(cc.cod_centro_custo, 4, 0) || ' - ' || cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = rc.filial_emissao
                           )
                   end as filial_emissao
                 , kss.fnc_ref_code('REPOM', 'RETORNO_CONTABIL.TIPO_TRANSACAO', rc.tipo_transacao) as tipo_transacao
                 , rc.codigo_transacao
                 , rc.descricao_transacao
                 , decode(rc.tipo_movimentacao_financeira, 0, 'Débito', 'Crédito') as tipo_movimentacao_financeira
                 , rc.valor_transacao
                 , to_char(rc.data_transacao, 'dd/mm/yyyy hh24:mi:ss') as data_transacao
                 , rc.cnpj_cpf_fornecedor
                 , rc.nome_razao_social_fornecedor
                 , c.lancto_id
                 , to_char(ct.data_emissao, 'dd/mm/yyyy') as data_emissao_ct
                 , decode(c.data_cancelamento,null,'Emitido','Cancelado') as contrato_status
                 , rc.integracao_erro
              from pagbem.v$retorno_contabil rc
             left join pagbem.v$contrato c
                     on c.processo_transporte_codigo = rc.contrato_pagbem
                    and c.internacional = rc.internacional
             left join oper.v$contrato_transp ct
                    on ct.lancto_id = c.lancto_id
             where 1 = 1
			<cfif Len(Trim(arguments.internacional))>
               and rc.internacional = #arguments.internacional#
			</cfif>

            <cfif Len(Trim(arguments.contrato_pagbem))>
               and rc.contrato_pagbem = #arguments.contrato_pagbem#
            </cfif>

            <cfif Len(Trim(arguments.situacao_id)) and not Len(Trim(arguments.contrato_pagbem))>
               and rc.situacao_id in (#arguments.situacao_id#)
            </cfif>

            <cfif Len(Trim(arguments.data_movimento_inicio)) and Len(Trim(arguments.data_movimento_fim)) and not Len(Trim(arguments.contrato_pagbem))>
               and rc.data_movimento between to_date('#arguments.data_movimento_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_movimento_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfelseif Len(Trim(arguments.data_movimento_inicio)) and not Len(Trim(arguments.contrato_pagbem))>
               and rc.data_movimento >= to_date('#arguments.data_movimento_inicio#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_movimento_fim)) and not Len(Trim(arguments.contrato_pagbem))>
               and rc.data_movimento <= to_date('#arguments.data_movimento_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>

            <cfif Len(Trim(arguments.data_transacao_inicio)) and Len(Trim(arguments.data_transacao_fim)) and not Len(Trim(arguments.contrato_pagbem))>
               and rc.data_transacao between to_date('#arguments.data_transacao_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_transacao_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            <cfelseif Len(Trim(arguments.data_transacao_inicio)) and not Len(Trim(arguments.contrato_pagbem))>
               and rc.data_transacao >= to_date('#arguments.data_transacao_inicio#', 'dd/mm/yyyy')
            <cfelseif Len(Trim(arguments.data_transacao_fim)) and not Len(Trim(arguments.contrato_pagbem))>
               and rc.data_transacao <= to_date('#arguments.data_transacao_fim# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Lista de conferncia de contratos
    -- GUTO 16/06/2011 - CRIADO
    --->
    <cffunction name="get_retorno_contratos" access="remote" returntype="query" output="true">
    	<cfargument name="data_inicio" required="yes" default="" />
    	<cfargument name="data_termino" required="yes" default="" />
    	<cfargument name="STATUS_CODIGO" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ct.lancto_id
                 , ct.num_formulario
                 , c.processo_transporte_codigo
                 , to_char(ct.data_emissao,'dd/mm/yyyy') as data_emissao
                 , ct.internacional
                 , cc.centro_custo as centro_custo_emissao
                 , gerencial.pkg_gerencial_dml.fnc_diretoria(ct.organizacional_id, ct.data_emissao).nome as diretoria
                 , gerencial.pkg_gerencial_dml.fnc_segmento(ct.organizacional_id).nome as segmento
                 , kss.pkg_organizacional.fnc_descricao_completa(ct.organizacional_id) as cc_gerencial
                 , ct.valor_frete_bruto - nvl((select sum(cti.valor)
                                             from oper.v$contrato_transp_item cti
                                             inner join oper.v$contrato_transp_item_setup ctis
                                                     on ctis.item_id = cti.item_id
                                            where cti.lancto_id = ct.lancto_id
                                              and ctis.desconto = 1
                                              and ctis.compoe_frete = 1),0) as valor_docto
                 , nvl((select cti.valor
                      from oper.v$contrato_transp_item cti
                     where cti.lancto_id = ct.lancto_id
                       and cti.item_id = 4),0) as pedagio
                 , case
                    when ct.data_cancelamento is not null then 'Cancelado'
                   else (select cg.rv_meaning
                      from pagbem.v$cg_ref_codes cg
                     where cg.rv_domain = 'CONTRATO.STATUS_CODIGO'
                     and cg.rv_low_value = c.status_codigo) end status
                 , (select cpg.valor_docto
                         - finan.pkg_cpg.fnc_pagar_total_amort(cpg.contas_pagar_id,sysdate,1)
                         - finan.pkg_cpg.fnc_pagar_total_desc(cpg.contas_pagar_id,sysdate,null,1)
                         + finan.pkg_cpg.fnc_pagar_total_juro(cpg.contas_pagar_id,sysdate,1)
                     from finan.v$finan_contas_pagar cpg
                    inner join oper.v$contrato_transp_pagar ctp
                            on ctp.contas_pagar_id = cpg.contas_pagar_id
                    where ctp.lancto_id = ct.lancto_id) as saldo_financeiro
                 ,nvl((select sum(rf.valor_transacao_financeira)
                     from pagbem.v$retorno_financeiro rf
                    where rf.internacional = c.internacional
                      and rf.contrato_pagbem = c.processo_transporte_codigo
                      and rf.tipo_movimentacao_financeira = 0),0) as baixa_financeira_pagbem
                 ,nvl((select sum(rc.valor_transacao)
                     from pagbem.v$retorno_contabil rc
                    where rc.internacional = c.internacional
                      and rc.contrato_pagbem = c.processo_transporte_codigo
                      and rc.tipo_transacao <> 1),0) as baixa_contabil_pagbem
                 ,nvl((select sum(rc.valor_transacao)
                     from pagbem.v$retorno_contabil rc
                     inner join kss.v$pessoa p
                             on p.cnpj_cpf = trim(rc.cnpj_cpf_fornecedor)
                     inner join kss.v$unidade_negocio un
                             on un.cod_pessoa = p.cod_pessoa
                    where rc.internacional = c.internacional
                      and rc.contrato_pagbem = c.processo_transporte_codigo
                      and rc.tipo_transacao = 1),0) as abastecimento_interno_pagbem
                 ,nvl((select sum(rc.valor_transacao)
                     from pagbem.v$retorno_contabil rc
                    where not exists (select 1
                                        from kss.v$pessoa p
                                       inner join kss.v$unidade_negocio un
                                               on un.cod_pessoa = p.cod_pessoa
                                      where p.cnpj_cpf = trim(rc.cnpj_cpf_fornecedor))
                      and rc.internacional = c.internacional
                      and rc.contrato_pagbem = c.processo_transporte_codigo
                      and rc.tipo_transacao = 1),0) as abastecimento_externo_pagbem
              from oper.v$contrato_transp ct
              inner join kss.v$centro_custo cc
                      on cc.cod_centro_custo = ct.cod_centro_custo
              inner join pagbem.v$contrato c
                      on c.lancto_id = ct.lancto_id
              where ct.data_emissao >= '#arguments.DATA_INICIO#'
                and ct.data_emissao <= '#arguments.DATA_TERMINO# 23:59:59'
                <cfif Len(Trim(arguments.STATUS_CODIGO))>
                  and c.status_codigo = #arguments.STATUS_CODIGO#
                </cfif>
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Painel de retornos FINANCEIRO
    -- GUTO - CRIADO
    --->
    <cffunction name="get_painel_retornos_financeiro" access="remote" returntype="query" output="true">
    	<cfargument name="data" required="no" default=""/>
    	<cfargument name="tipo_transacao" required="no" default=""/>
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(data_movimento,'dd/mm/yyyy') as data_movimento,
                   dia,
                   decode(internacional,1,'Sim','Nao') as internacional,
                   feriado,
                   (select cg.rv_abbreviation
                      from pagbem.v$cg_ref_codes cg
                     where cg.rv_low_value = situacao
                       and cg.rv_domain = 'RETORNO FINANCEIRO SITUACAO') as situacao
              from (select data_movimento,
                           dia,
                           internacional,
                           (select f.descricao
                             from kss.v$feriado f
                            where f.data = a.data_movimento) as feriado,
                            nvl(min(situacao),-1) as situacao
                      from (select r.data_movimento
                                 , to_char(r.data_movimento,'day') as dia
                                 , r.internacional
                                 , min(r.situacao_id) as situacao
                              from pagbem.v$retorno_financeiro r
                            where r.data_movimento >= nvl('#arguments.data#',trunc(sysdate,'month'))
                              <cfif Len(Trim(arguments.TIPO_TRANSACAO))>
                                and r.tipo_transacao = #arguments.TIPO_TRANSACAO#
                              </cfif>
                            group by r.data_movimento, r.internacional
                            union
                            select trunc(sysdate - level) as data_movimento,
                                   to_char(sysdate - level,'day') as dia,
                                   0 as internacional,
                                   null as situacao
                              from dual
                              connect by nvl('#arguments.data#',trunc(sysdate,'month'))  <= sysdate - level
                            union
                            select trunc(sysdate - level) as data_movimento,
                                   to_char(sysdate - level,'day') as dia,
                                   1 as internacional,
                                   null as situacao
                              from dual
                              connect by nvl('#arguments.data#',trunc(sysdate,'month'))  <= sysdate - level) a
                    group by data_movimento,
                             dia,
                             internacional
                    order by data_movimento)
            order by internacional, to_date(data_movimento,'dd/mm/yyyy')
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Painel de retornos CONTABIL
    -- GUTO - CRIADO
    --->
    <cffunction name="get_painel_retornos_contabil" access="remote" returntype="query" output="true">
    	<cfargument name="data" required="no" default=""/>
    	<cfargument name="tipo_transacao" required="no" default=""/>
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(data_movimento,'dd/mm/yyyy') as data_movimento,
                   dia,
                   decode(internacional,1,'Sim','Nao') as internacional,
                   feriado,
                   (select cg.rv_abbreviation
                      from pagbem.v$cg_ref_codes cg
                     where cg.rv_low_value = situacao
                       and cg.rv_domain = 'RETORNO CONTABIL SITUACAO') as situacao
              from (select data_movimento,
                           dia,
                           internacional,
                           (select f.descricao
                             from kss.v$feriado f
                            where f.data = a.data_movimento) as feriado,
                            nvl(min(situacao),-1) as situacao
                      from (select r.data_movimento
                                 , to_char(r.data_movimento,'day') as dia
                                 , r.internacional
                                 , min(r.situacao_id) as situacao
                              from pagbem.v$retorno_contabil r
                            where r.data_movimento >= nvl('#arguments.data#',trunc(sysdate,'month'))
                              <cfif Len(Trim(arguments.TIPO_TRANSACAO))>
                                and r.tipo_transacao = #arguments.TIPO_TRANSACAO#
                              </cfif>
                            group by r.data_movimento, r.internacional
                            union
                            select trunc(sysdate - level) as data_movimento,
                                   to_char(sysdate - level,'day') as dia,
                                   0 as internacional,
                                   null as situacao
                              from dual
                              connect by nvl('#arguments.data#',trunc(sysdate,'month'))  <= sysdate - level
                            union
                            select trunc(sysdate - level) as data_movimento,
                                   to_char(sysdate - level,'day') as dia,
                                   1 as internacional,
                                   null as situacao
                              from dual
                              connect by nvl('#arguments.data#',trunc(sysdate,'month'))  <= sysdate - level) a
                    group by data_movimento,
                             dia,
                             internacional
                    order by data_movimento)
            order by internacional, to_date(data_movimento,'dd/mm/yyyy')
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

	<cffunction name="get_pedagios_rota" access="remote" returntype="query" output="true">
    	<cfargument name="roteirizacao_valor_id" required="no" default="-1"/>
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select rvp.roteirizacao_praca_id
			     , rvp.roteirizacao_valor_id
			     , rvp.ordem
			     , rvp.concessionaria
			     , rvp.praca
			     , rvp.valor_pedagio
			     , rvp.user_insert
			     , rvp.date_insert
			     , rvp.user_update
			     , rvp.date_update
			  from pagbem.v$roteirizacao_valor_pracas rvp
			  where rvp.roteirizacao_valor_id = #arguments.roteirizacao_valor_id#
			  order by ordem
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPÓSITO
    -- Retorna os Contratos de Tranmsporte vinculados a um Romaneio
    -- RAFAEL 30/05/2012 - CRIADO
    --->
    <cffunction name="get_contrato_transp_item_setup" access="remote" returntype="query" output="true">
    	<cfargument name="debito_credito" required="yes" default="" />
    	<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ctis.item_id
                 , ctis.descricao
              from oper.v$contrato_transp_item_setup ctis
			 inner join pagbem.v$contrato_movimento_motivo cmm
                on cmm.item_id = ctis.item_id
             where ctis.compoe_frete = 1
        	<cfif arguments.debito_credito eq 1>
               and ctis.desconto = 1
            <cfelseif arguments.debito_credito eq 2>
               and ctis.desconto = 0
            </cfif>
		</cfquery>
		<cfreturn qr_result>
    </cffunction>

</cfcomponent>
