<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init" output="yes">
	
	<!--- 
	-- PROPSITO  
	-- Consulta todos os cargos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="get_cargos" displayname="Consulta todos os cargos" access="remote" returntype="query" output="true">
			<cfargument name="cod_cargo" required="no" default="">
			<cfquery datasource="#session.dsn#" name="qr_cargos" username="#session.usuario#" password="#session.senha#">
				select cod_cargo, cargo
				from rh.rh_cargos_salarios
				<cfif Len(Trim(arguments.cod_cargo))> 
					where cod_cargo = #arguments.cod_cargo#
				</cfif>
				order by cargo				
			</cfquery>
	    <cfreturn qr_cargos>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Consulta situao da CNH do motorista
	-- NOTAS EXPLICATIVAS
	-- GUTO
	--->	
	<cffunction name="get_cnh_situacao" displayname="Consulta situao da CNH do motorista" access="remote" returntype="query" output="true">
	 	<cfargument name="cod_funcionario" required="yes">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select cod_funcionario, nome_funcionario, mensagem, status 
			  from oper.v$motorista_cnh_situacao
			 where cod_funcionario = #arguments.cod_funcionario#
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Retorna dados completos do motorista
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 22/11/2005 - criado
	--->	
	<cffunction name="get_dados_motorista" output="false" returntype="query" access="remote">
		<cfargument name="cod_funcionario" required="no" default="">
		<cfargument name="com_foto" required="no" default="0">
		<cfargument name="nome" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_funcionario, nome_completo, endereco, cidade_uf, 
				   telefone, rg, cpf, cnh, cnh_validade, data_admissao, 
				   cobertura, num_celular, mopp,
				   cod_pessoa, empresa, agregado				   
				   <cfif arguments.com_foto eq 1>
				   ,foto
				   </cfif> 				   
			  from oper.v$funcionario_dados		
			 where 1=1
			 <cfif len(trim(arguments.cod_funcionario))>
			   and cod_funcionario = #arguments.cod_funcionario#
			 </cfif>
			 <cfif len(trim(arguments.nome))>
			   and upper(nome_completo) like upper('%#arguments.nome#%')
			 </cfif>			 
		   <cfif arguments.com_foto eq 1>
		   		and foto is not null
		   </cfif> 
		</cfquery> 
		<cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Retorna todos pedidos de reserva que no foram encerrados ou cancelados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 22/02/2006
	--->	
	<cffunction name="get_dados_pedido_reserva" displayname="Retorna todos pedidos de reserva que no foram encerrados ou cancelados" access="remote" returntype="query" output="true">
		<cfargument name="controle_evo_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios" username="#session.usuario#" password="#session.senha#">
			select mpr.controle_evo_id, pf.nome as solicitado_por, mpr.placa, mpr.data_envio, mpr.data_pedido, 
				   mpr.motivo, mpr.data_previsao, mpr.data_previsao_retorno,
				   oper.pkg_global.fnc_get_cod_funcionario(mpr.COD_PESSOA_ALOCADO) as cod_funcionario_subst,
				   nvl(pfa.nome,'No definido') as substituido_por, 
				   cd.rv_meaning as situacao, nvl(mpr.LOCAL_TROCA,'No definido.') as LOCAL_TROCA, 
				   oper.pkg_global.fnc_get_cod_funcionario(mpr.cod_pessoa_pedido) as cod_funcionario,
				   mpr.cod_pessoa_pedido, mpr.COD_PESSOA_ALOCADO,
				   mpr.situacao as situacao_id,
                   oper.pkg_motorista.fnc_status_cto_experiencia(oper.pkg_global.fnc_get_cod_funcionario(mpr.cod_pessoa_pedido)) status_contrato_experiencia
				   from oper.v$motorista_ped_reserva mpr
			 inner join oper.cg_ref_codes cd
					 on cd.rv_low_value = mpr.situacao
					and cd.rv_domain = 'MOTORISTA_PED_RESERVA.SITUACAO'
					and mpr.situacao in (0,1)
			 inner join oper.v$pessoa_fisica pf
					 on mpr.cod_pessoa_pedido = pf.cod_pessoa
			 left join oper.v$pessoa_fisica pfa
					 on mpr.cod_pessoa_alocado = pfa.cod_pessoa  
		     where controle_evo_id = #arguments.controle_evo_id#
			order by mpr.data_pedido desc
		</cfquery>
		<cfreturn qrfuncionarios>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Busca limite de KM do veculo que o motorista pode assumir
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->
	<cffunction name="get_dados_veiculo_motorista" output="true" returntype="query" >
		<cfargument name="cod_funcionario" required="no" default="" />
		<cfargument name="cod_pessoa" required="no" default="" />
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select 	decode(oper.pkg_motorista.fnc_km_limite_veiculo(vm.cod_pessoa,sysdate),-1,'Problemas Conta',oper.pkg_motorista.fnc_km_limite_veiculo(vm.cod_pessoa,sysdate)) as km_limite,
    					oper.pkg_veiculo.fnc_km_atual(vm.placa) as km_atual
			  from oper.v$veiculo_motorista vm
			 inner join oper.v$motorista_reg_historico mrh
			         on mrh.cod_pessoa = vm.cod_pessoa
              and vm.data_fim is null
			 where mrh.data_inicio = (select max(mrh2.data_inicio)
        							          from oper.v$motorista_reg_historico mrh2
        							         where mrh2.cod_pessoa = mrh.cod_pessoa)
			  <cfif Len(Trim(arguments.cod_funcionario))>
				  and mrh.cod_registro = #arguments.cod_funcionario#
			  </cfif>
			  <cfif Len(Trim(arguments.cod_pessoa))>
				  and mrh.cod_pessoa = #arguments.cod_pessoa#
			  </cfif>
			 </cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Lista filiais
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 24/02/2006 - criado
	--->	
	<cffunction name="get_filial" displayname="Lista filiais" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="" />
		<cfargument name="nome" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_pessoa,
				   razao_social,
				   nome,
				   identificador,
				   cnpj_cpf,
				   inscricao_estadual,
				   endereco,
				   bairro,
				   cep,
				   municipio,
				   uf,
				   municipio_uf,
				   municipio_id,
				   telefone,
				   pais_id,
				   pais,
				   filial
			  from oper.v$filial
			 where 1=1
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and cod_pessoa = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif len(trim(arguments.nome))>
			   and upper(razao_social) like upper('%#arguments.nome#%')
			 </cfif>
		     order by nome, razao_social, municipio_uf			 
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>	
	<!--- 
	-- PROPSITO
	-- Lista filiais
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 24/02/2006 - criado
	--->
	<cffunction name="get_filiais" displayname="Busca todas as filiais" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no">
		<cfquery name="qr_filiais" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pu.cod_unidade_negocio, pj.cnpj_basico, pj.cnpj_ordem, 
				   pj.cnpj_basico || pj.cnpj_ordem || pj.cnpj_dv as cnpj_completo,
				   pj.cnpj_basico, pj.cnpj_ordem, pj.municipio, pj.uf,
		           'Del Pozo ' || pj.municipio as nome_fantasia, 
				   pj.cod_pessoa
			  from oper.pessoa_juridica pj
			 inner join kss.v$unidade_negocio pu 
				on pj.cod_pessoa = pu.cod_pessoa
			   and pj.cnpj_basico = '76642743'
			 <cfif IsDefined("arguments.cod_pessoa_filial")>
			   and pj.cod_pessoa = #arguments.cod_pessoa_filial#
			 </cfif>
			 order by pj.cnpj_ordem
   	   	</cfquery>
		<cfreturn qr_filiais>		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Consulta o funcionrio pelo cdigo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="get_funcionario" displayname="Consulta funcionrio pelo cdigo" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="no" default="">
		<cfargument name="pessoa" required="no" default="0">
		<cfargument name="nome" required="no" default="">
		<cfargument name="ativos" required="no" default="0">
		<cfargument name="filtro" required="no" default="">
        <cfargument name="num_modalidade" required="no" default="">
		<cfif arguments.pessoa EQ 0>
			<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
				<cfif session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'vialacteos/'>
				 select distinct fma.num_matricula cod_funcionario,
                        f.nome_funcionario,
                        f.cpf_funcionario,
                        f.cod_pessoa,
                        f.cod_entreposto as empresa
                   from oper.v$rh_funcionario f
              left join kss.v$funcionario_matr_atual fma
                     on fma.cod_pessoa = f.cod_pessoa
                  where 1 = 1
                 <cfelse>
				 <cfif session.site eq 'rodomar/' or session.site eq 'bbm/'>
				select distinct
					   f.cod_funcionario cod_funcionario, 
					   f.nome_funcionario, 
					   f.cpf_funcionario, 
					   f.cod_pessoa,
					   f.cod_entreposto as empresa
				  from oper.v$rh_funcionario f
				 where 1=1
				<cfelseif session.site eq 'transemba/' or session.site eq 'axon/'>
                select fd.matricula as cod_funcionario
                     , fd.nome as nome_funcionario
                     , fd.cpf as cpf_funcionario
                     , fd.cod_pessoa
                     , fd.cod_pessoa_empresa as empresa
                  from folha.v$funcionario_dados fd
                 where fd.data_demissao is null
                 	<cfif Len(Trim(session.cod_pessoa))>
                   		and fd.cod_pessoa_empresa = #session.cod_pessoa#
                   </cfif>
				<cfelse>
					select distinct
							oper.pkg_global.fnc_get_cod_funcionario(f.cod_funcionario) cod_funcionario, 
						   f.nome_funcionario, 
						   f.cpf_funcionario, 
						   oper.pkg_global.fnc_get_cod_pessoa_func(oper.pkg_global.fnc_get_cod_funcionario(f.cod_funcionario)) as cod_pessoa,
						   f.cod_entreposto as empresa,
                            (select  sign(count(1))      
                              from kss.v$pessoa_modalidade pm
                             inner join kss.v$pessoa_fisica pf
                                on pm.COD_PESSOA = pf.cod_pessoa
                             where pm.NUM_MODALIDADE in (2,6) and pm.SITUACAO = 1
                               and pf.cpf||pf.cpf_dv = f.cpf_funcionario ) eh_motorista     
					  from oper.v$rh_funcionario f
					 where 1=1
                    <cfif Len(Trim(arguments.FILTRO))>
                    	<cfif IsNumeric(arguments.FILTRO)>
                        	and f.cod_funcionario = #arguments.FILTRO#
                        <cfelse>
                            and upper(kss.pkg_string.fnc_string_clean(f.nome_funcionario)) like upper('%#arguments.FILTRO#%')
                        </cfif>
                    </cfif>
					<cfif Isdefined("arguments.ativos") and arguments.ativos eq 1>
					   and oper.pkg_global.fnc_get_cod_pessoa_func(oper.pkg_global.fnc_get_cod_funcionario(f.cod_funcionario)) <> -1
					</cfif>
				</cfif>
                </cfif>
				<cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and session.site neq 'ouroverde/' and session.site neq 'transgires/' and session.site neq 'transemba/' and session.site neq 'vialacteos/' and session.site neq 'axon/'>
				   and f.cod_funcionario = #arguments.cod_funcionario#			
				</cfif>
                <cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and (session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'vialacteos/')>
				   and fma.num_matricula = #arguments.cod_funcionario#			
				</cfif>
                <cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and (session.site eq 'transemba/' or session.site eq 'axon/')>
				   and fd.matricula = #arguments.cod_funcionario#			
				</cfif>
                <cfif Len(Trim(arguments.num_modalidade)) and (session.site eq 'ouroverde/' or session.site eq 'transgires/')>
                   and fma.num_modalidade in (#arguments.num_modalidade#)
                </cfif>
				<cfif len(trim(arguments.nome)) and session.site neq 'transemba/' and session.site neq 'axon/'>
				   and upper(f.nome_funcionario) like upper('%#arguments.nome#%')
                <cfelseif len(trim(arguments.nome))>
                   and upper(fd.nome) like upper('%#arguments.nome#%')
				</cfif>
                
                <cfif session.site neq 'transemba/' and session.site neq 'axon/'>
				 order by f.nome_funcionario
                <cfelse>
				 order by fd.nome
				</cfif>
			</cfquery>
			<cfif qr_funcionario.RecordCount  EQ 0 and len(trim(arguments.cod_funcionario)) and session.site neq 'transemba/' and session.site neq 'vialacteos/' and session.site neq 'axon/'>
				<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
					select p.cod_pessoa as cod_funcionario, p.nome as nome_funcionario, p.cod_pessoa, 0 as empresa
					 from kss.v$pessoa_fisica p
						where p.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
				</cfquery>			
			</cfif>
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
				select p.cod_pessoa as cod_funcionario, p.nome as nome_funcionario, p.cod_pessoa, 0 as empresa
				 from oper.v$pessoa_fisica p
				 where p.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#) 
			</cfquery>			
		</cfif>			
		<cfreturn qr_funcionario>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Consulta os funcionrios conforme o argumento que o usurio passar
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="get_funcionarios" displayname="Retorna todos os funcionarios conforme parmetro passado" access="remote" returntype="query" output="true">
		<cfargument name="nome" 		required="no">
		<cfargument name="cpf" 			required="no">
		<cfargument name="cod_cargo" 	required="no">
		<cfargument name="pessoa" 		required="no" default="0" >
			<cfif arguments.pessoa EQ 0>
				<cfquery datasource="#session.dsn#" name="qr_funcionarios" username="#session.usuario#" password="#session.senha#">
					select f.cod_funcionario, f.nome_funcionario, f.cpf_funcionario, f.cod_cargo,
						   oper.pkg_global.fnc_get_cod_pessoa_func(f.cod_funcionario) as cod_pessoa
					from oper.v$rh_funcionario f
					where f.data_demissao is null
						<cfif isDefined("arguments.nome") and Len(Trim(arguments.nome))>
						  and upper(f.nome_funcionario) like upper('%#arguments.nome#%')
						</cfif>
						<cfif isDefined("arguments.cpf") and Len(Trim(arguments.cpf))>
						  and f.cpf_funcionario like '#arguments.cpf#%'
						</cfif>
						<cfif isDefined("arguments.cargo") and Len(Trim(arguments.cargo))>
						  and f.cod_cargo in (#arguments.cargo#)
						</cfif>
					 order by f.nome_funcionario
				</cfquery>
			<cfelse>
				<cfquery datasource="#session.dsn#" name="qr_funcionarios" username="#session.usuario#" password="#session.senha#">
					select oper.pkg_global.fnc_get_cod_funcionario(p.cod_pessoa) as cod_funcionario, p.nome as nome_funcionario, p.cod_pessoa
					 from oper.pessoa_fisica p
						where p.situacao_id = 1
						<cfif isDefined("arguments.nome") and Len(Trim(arguments.nome))>
						  and upper(p.nome) like upper('%#arguments.nome#%')
						</cfif>
						<cfif isDefined("arguments.cpf") and Len(Trim(arguments.cpf))>
						  and p.cpf like '#arguments.cpf#%'
						</cfif>
				</cfquery>			
			</cfif>					
		 <cfreturn qr_funcionarios>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Retorna todos os funcionarios que esto afastados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->
	<cffunction name="get_funcionarios_afastados" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="motorista" required="no">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_afastados" username="#session.usuario#" password="#session.senha#">
		select /*+ ordered use_hash(f mc) */ f.cod_funcionario, pj.nome_fantasia as entreposto,
				f.nome_funcionario, to_char(fa.data_afastamento,'dd/mm/yyyy') as data_afastamento, 
				round(oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta,sysdate,0),2) as saldo,
                gr.cod_grupo_ctrl grupo_motorista,
                oper.pkg_motorista.fnc_status_cto_experiencia(f.cod_funcionario) status_contrato_experiencia,
                (select vg.descricao
                   from oper.v$veiculo_grupo_setup vg
                  where vg.GRUPO_ID = oper.pkg_veiculo.fnc_grupo_veiculo(gr.cod_grupo_ctrl)) as grupo_veiculo
			from oper.v$rh_funcionario f
             inner join rh.rh_gestao_entreposto en
                     on en.cod_entreposto = f.cod_entreposto
             inner join kss.v$pessoa_juridica pj
                      on pj.cnpj_basico = en.cnpj_basico
                     and pj.cnpj_ordem = en.cnpj_ordem
             inner join oper.v$motorista_reg_historico mc
                     on mc.cod_registro = f.cod_funcionario
	    	 inner join oper.v$rh_funcionario_afastamento fa 
		         on mc.cod_registro = fa.cod_funcionario 
		     inner join kss.v$pessoa_fisica pf
                                   on pf.cpf||pf.cpf_dv = f.cpf_funcionario              
                           
             left join oper.v$ccorrente cc  
			       on cc.cod_pessoa = mc.cod_pessoa
             left join (oper.v$grupo_ctrl_motorista grm
                        inner join oper.v$grupo_ctrl gr
                                on gr.grupo_ctrl_id = grm.grupo_ctrl_id)
                   on grm.cod_pessoa = mc.cod_pessoa             
		   where 1=1
         and mc.data_fim is null
	 	 <cfif not IsDefined("arguments.motorista") or arguments.motorista eq 1>
	  	     and f.cod_cargo = 1 
		 </cfif>
  	     and f.data_demissao is null 
  			 and cc.modalidade_id = 4			  
  			 and cc.ativo = 1
  			 and (fa.data_retorno is null or fa.data_retorno > sysdate) 	
             and fa.data_afastamento = (select max(fa2.data_afastamento)
                                          from oper.v$rh_funcionario_afastamento fa2
                                 where fa.cod_funcionario = fa2.cod_funcionario)
  			 and f.cod_funcionario not in (select distinct f2.cod_funcionario
                											   from oper.v$rh_funcionario f2 
            										   inner join oper.v$motorista_reg_historico mc
            											         on f2.cod_funcionario = mc.cod_registro
            											 inner join rh.rh_rescisao_temp r 
            											 		     on mc.cod_registro = r.cod_funcionario   
            												left join oper.v$ccorrente cc  
            													     on cc.cod_pessoa = mc.cod_pessoa
            												      and cc.modalidade_id = 4			  
            												      and cc.ativo = 1
            												    where 1=1
															 	 <cfif not IsDefined("arguments.motorista") or arguments.motorista eq 1>
																  and f2.cod_cargo = 1  
																 </cfif>
																  and f2.data_demissao is null)
		    order by fa.data_afastamento
		 </cfquery>
		<cfreturn qrfuncionarios_afastados>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os funcionarios que foram demitidos
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->	
	<cffunction name="get_funcionarios_demitidos" displayname="" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_demitidos" username="#session.usuario#" password="#session.senha#">
			 select distinct /*+ ordered use_hash(f mc) */ f.cod_funcionario, f.nome_funcionario, 
			 		to_char(r.data_demissao,'dd/mm/yyyy') as data_demissao, 
                    round(oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta,sysdate,0),2) as saldo,
           		    pj.nome_fantasia as entreposto, gr.cod_grupo_ctrl grupo_motorista,
                    (select vg.descricao
                       from oper.v$veiculo_grupo_setup vg
                      where vg.GRUPO_ID = oper.pkg_veiculo.fnc_grupo_veiculo(gr.cod_grupo_ctrl)) as grupo_veiculo
                   from oper.v$rh_funcionario f 
             inner join oper.v$motorista_controle mc
                     on f.cod_funcionario = mc.cod_funcionario
             inner join rh.rh_gestao_entreposto en
                     on en.cod_entreposto = f.cod_entreposto
             inner join kss.v$pessoa_juridica pj
                     on pj.cnpj_basico = en.cnpj_basico
                    and pj.cnpj_ordem = en.cnpj_ordem
             inner join rh.rh_rescisao_temp r 
                     on mc.cod_funcionario = r.cod_funcionario   
             inner join oper.v$ccorrente cc  
                     on cc.cod_pessoa = mc.cod_pessoa
                    and cc.modalidade_id = 4			  
                    and cc.ativo = 1
             left join (oper.v$grupo_ctrl_motorista grm
                       inner join oper.v$grupo_ctrl gr
                               on gr.grupo_ctrl_id = grm.grupo_ctrl_id)
                    on grm.cod_pessoa = mc.cod_pessoa             
              where f.cod_cargo = 1  
                and f.data_demissao is null
		</cfquery>
		<cfreturn qrfuncionarios_demitidos>
	</cffunction>
			
	<!--- 
	-- PROPSITO
	-- Retorna todos os funcionarios que esto gozando frias
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->	
	<cffunction name="get_funcionarios_ferias" displayname="" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_ferias" username="#session.usuario#" password="#session.senha#">
              select f.cod_funcionario, 
                     f.nome_funcionario, pj.nome_fantasia as entreposto,
                   to_char(fe.periodo_efetuado_inicial,'dd/mm/yyyy') as inicio,
                   to_char(fe.periodo_efetuado_final+1,'dd/mm/yyyy') as retorno, 
                   round(oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta,sysdate,0),2) as saldo,    
                   oper.pkg_motorista.fnc_km_limite_veiculo(cc.cod_pessoa,sysdate) as km_limite,
                   nvl(to_char(oper.pkg_motorista.fnc_nota_atual(cc.cod_pessoa)),'Sem Nota') as nota, 
                   gr.cod_grupo_ctrl grupo_motorista,                   
                   oper.pkg_motorista.fnc_status_cto_experiencia(f.cod_funcionario) status_contrato_experiencia,
                   (select vg.descricao
                      from oper.v$veiculo_grupo_setup vg
                     where vg.GRUPO_ID = oper.pkg_veiculo.fnc_grupo_veiculo(gr.cod_grupo_ctrl)) as grupo_veiculo
                from oper.v$rh_funcionario f 
               inner join rh.rh_ferias_concessao fe 
                   on f.cod_funcionario = fe.cod_funcionario          
               inner join oper.v$motorista_reg_historico mrh
                   on mrh.cod_registro = f.cod_funcionario
                  and mrh.data_fim is null
                 inner join rh.rh_gestao_entreposto en
                     on en.cod_entreposto = f.cod_entreposto
                 inner join kss.v$pessoa_juridica pj
                      on pj.cnpj_basico = en.cnpj_basico
                     and pj.cnpj_ordem = en.cnpj_ordem
               inner join oper.v$ccorrente cc  
                   on cc.cod_pessoa = mrh.cod_pessoa
                  and cc.modalidade_id = 4                  
                  and cc.ativo = 1
                inner join kss.v$pessoa_fisica pf
                                   on pf.cpf||pf.cpf_dv = f.cpf_funcionario 
                left join (oper.v$grupo_ctrl_motorista grm
                              inner join oper.v$grupo_ctrl gr
                                      on gr.grupo_ctrl_id = grm.grupo_ctrl_id)
                      on grm.cod_pessoa = mrh.cod_pessoa
               where fe.periodo_efetuado_final + 1 > sysdate 
                    and f.cod_cargo = 1
               order by fe.periodo_efetuado_final desc
		</cfquery>
		<cfreturn qrfuncionarios_ferias>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna dados para impresso do holerite
	-- NOTAS EXPLICATIVAS
	-- GUTO
	--->	
	<cffunction name="get_funcionarios_holerite" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="yes">
		<cfargument name="mes" 				  required="yes">
		<cfargument name="ano" 				  required="yes">
      <cfargument name="cod_recibo_tipo" required="no" default="1">
		<!--- Executado apenas se o site for da delpozo --->
		<cfif isdefined("session.site") and session.site eq "delpozo/">
			<!--- Busca o codigo do entreposto --->
			<cfquery datasource="#session.dsn#" name="qr_dados_func" username="#session.usuario#" password="#session.senha#">
				select cod_entreposto
				  from oper.v$rh_funcionario
				 where cod_funcionario = #cod_funcionario#
			</cfquery>	
			<!--- Altera a gestao --->
			<cfif qr_dados_func.cod_entreposto eq 11>
					<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					  delete kss.pessoa_usuario_acesso_cur
					</cfquery>	
					<cfquery name="qr_gestao" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
  					  select cod_pessoa ,upper('#session.usuario#')  as usuario
						from kss.pessoa_unidade_negocio 
					   where cod_unidade_negocio > 0
						 and cod_unidade_negocio is not null  
						 and cod_pessoa = 15967
					</cfquery>	
					<cfloop query="qr_gestao">
                        <cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                            insert into kss.pessoa_usuario_acesso_cur 
                                (cod_pessoa, usuario) 
                            values
                                (#qr_gestao.cod_pessoa#,'#qr_gestao.usuario#')
                        </cfquery>			
                    </cfloop>
			</cfif>
		</cfif>		
		<cfquery datasource="#session.dsn#" name="qr_folha" username="#session.usuario#" password="#session.senha#">
			    select rhf.cod_entreposto
                     , rhf.cod_departamento
                     , rhf.cod_setor
                     , rhf.cod_funcionario || ' - ' || rhf.nome_funcionario as rh_funcionario_cod_funcio
                     , rhr.num_recibo
                     , rhr.total_proventos
                     , rhr.total_descontos
                     , rhr.valor_liquido
                     , rhr.salario_base
                     , rhr.salario_contr_inss
                     , rhr.base_calc_fgts
                     , rhr.valor_fgts
                     , rhr.base_calc_irrf
                     , rhr.cod_funcionario
                     , to_char(rhr.mes, '00') || '/' || rhr.ano to_char_rh_recibo_mes_rh
                     , to_char(rhr.data_pagamento, 'dd/mm/yyyy') as data_pagamento
                     , rhent.entreposto
                     , rhent.razao_social
                     , rhent.logotipo
                     , rhent.inscr_estadual
                     , rhent.endereco || ',' || rhent.numero entreposto_endereco_entre
                     , 'CNPJ: ' || substr(rhent.cgc, 1, 2) || '.' || substr(rhent.cgc, 3, 3) || '.' || substr(rhent.cgc, 6, 3) || '/' || substr(rhent.cgc, 9, 4) || '-' || substr(rhent.cgc, 13, 2) substr_entreposto_cgc_1
                     , rhc.msg_recibo
                     , rhri.referencia
                     , rhri.valor
                     , rhri.complemento_evento
                     , rhe.descricao
                     , to_char(rhe.cod_evento, '0000') cod_evento
                     , decode(rhe.provento, 1, rhri.valor, '0') decode_rh_evento_provento
                     , decode(rhe.provento, 0, rhri.valor, '0') decode_rh_evento_proven_2
                     , (select rhf.cod_cargo
                         from rh.v$rh_funcionario_cargos rhf
                        where rhf.cod_funcionario = #arguments.cod_funcionario#
                          and rhf.data_alteracao = (select max(t.data_alteracao)
                                                      from rh.v$rh_funcionario_cargos t
                                                     where 1 = 1
                                                       and t.cod_funcionario = #arguments.cod_funcionario#
                                                       and t.data_alteracao <= (select last_day(to_date('01/'|| rhr.mes || '/' || rhr.ano)) from dual))) as cod_cargo
                      , (select rhcs.cargo
                           from rh.v$rh_cargos_salarios rhcs
                          where rhcs.cod_cargo = (select rhf.cod_cargo
                                                    from rh.v$rh_funcionario_cargos rhf
                                                   where rhf.cod_funcionario = #arguments.cod_funcionario#
                                                     and rhf.data_alteracao = (select max(t.data_alteracao)
                                                                                 from rh.v$rh_funcionario_cargos t
                                                                                where 1 = 1
                                                                                  and t.cod_funcionario = #arguments.cod_funcionario#
                                                                                  and t.data_alteracao <= (select last_day(to_date('01/'|| rhr.mes || '/' || rhr.ano)) from dual)))) as cargo
                       , (select rhcs.cod_familia || '-' || rhcs.cod_ocup
                            from rh.v$rh_cargos_salarios rhcs
                           where rhcs.cod_cargo = (select rhf.cod_cargo
                                                     from rh.v$rh_funcionario_cargos rhf
                                                    where rhf.cod_funcionario = #arguments.cod_funcionario#
                                                      and rhf.data_alteracao = (select max(t.data_alteracao)
                                                                                  from rh.v$rh_funcionario_cargos t
                                                                                 where 1 = 1
                                                                                   and t.cod_funcionario = #arguments.cod_funcionario#
                                                                                   and t.data_alteracao <= (select last_day(to_date('01/'|| rhr.mes || '/' || rhr.ano)) from dual)))) as cbo
                     
                    from rh.v$rh_funcionario rhf
              inner join rh.v$rh_recibo rhr
                      on rhf.cod_funcionario = rhr.cod_funcionario
              inner join rh.v$rh_recibo_it rhri
                      on rhr.num_recibo = rhri.num_recibo
              inner join rh.v$rh_evento rhe
                      on rhe.cod_evento = rhri.cod_evento
              inner join rh.v$entreposto rhent
                      on rhf.cod_entreposto = rhent.cod_entreposto
              inner join rh.v$rh_cargos_salarios rhc
                      on rhf.cod_cargo = rhc.cod_cargo
                   where 1 = 1
                     and rhr.ano = #arguments.ano#
                     and rhr.mes = #arguments.mes#
                     and rhf.cod_funcionario = #arguments.cod_funcionario#
                     and rhr.cod_recibo_tipo = #arguments.cod_recibo_tipo# 
                ORDER BY rhf.nome_funcionario, rhri.cod_evento
		</cfquery>
		<cfreturn qr_folha>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna todos os funcionarios que esto parados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->	
	<cffunction name="get_funcionarios_parados" displayname="" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_parados" username="#session.usuario#" password="#session.senha#">
            select cod_funcionario, nome_funcionario, round(oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cod_conta,sysdate,0),2) as saldo,
                         oper.pkg_motorista.fnc_km_limite_veiculo(cod_pessoa,sysdate) as km_limite,
                         nvl(to_char(oper.pkg_motorista.fnc_nota_atual(cod_pessoa),'0.00'),'Sem Nota') as nota, desde,
                         entreposto, grupo_motorista, status_contrato_experiencia,
                         (select vg.descricao
                           from oper.v$veiculo_grupo_setup vg
                          where vg.GRUPO_ID = oper.pkg_veiculo.fnc_grupo_veiculo(grupo_motorista)) as grupo_veiculo
                    from (select  /*+ ORDERED use_hash(mhr f) */distinct 
                                 f.cod_funcionario, f.nome_funcionario, pj.nome_fantasia as entreposto,
                                 nvl(to_char(max(vm.data_fim),'dd/mm/yyyy'),to_char(max(f.data_admissao),'dd/mm/yyyy')) as desde,
                                 cc.cod_conta,cc.cod_pessoa, gr.cod_grupo_ctrl grupo_motorista,
                                oper.pkg_motorista.fnc_status_cto_experiencia(f.cod_funcionario) status_contrato_experiencia
                         from oper.v$motorista_reg_historico mhr
                           inner join oper.v$rh_funcionario f 
                                   on mhr.cod_registro = f.cod_funcionario
                           inner join rh.rh_gestao_entreposto en
                                   on en.cod_entreposto = f.cod_entreposto
                           inner join kss.v$pessoa_juridica pj
                                   on pj.cnpj_basico = en.cnpj_basico
                                  and pj.cnpj_ordem = en.cnpj_ordem
                           inner join oper.v$ccorrente cc  
                                   on cc.cod_pessoa = mhr.cod_pessoa
                                             
                           inner join kss.v$pessoa_fisica pf
                                   on pf.cpf||pf.cpf_dv = f.cpf_funcionario                                   
                           
                           
                            left join oper.v$veiculo_motorista vm 
                                   on vm.cod_pessoa = mhr.cod_pessoa
                            left join (oper.v$grupo_ctrl_motorista grm
                                          inner join oper.v$grupo_ctrl gr
                                                  on gr.grupo_ctrl_id = grm.grupo_ctrl_id)
                                  on grm.cod_pessoa = mhr.cod_pessoa
                            where f.cod_cargo = 1 
                              and mhr.data_fim is null
                              and f.data_demissao is null     
                              and cc.modalidade_id = 4      
                              and cc.ativo = 1    
                            group by f.cod_funcionario, f.nome_funcionario,pj.nome_fantasia, cc.cod_conta,cc.cod_pessoa, gr.cod_grupo_ctrl) a                
                   where a.cod_funcionario not in  (select np.cod_funcionario
                                       from oper.v$funcionario_nao_parado np)
                   order by entreposto, nome_funcionario, grupo_motorista
		</cfquery>
		<cfreturn qrfuncionarios_parados>
	</cffunction>
	<!--- 
	-- PROPSITO
	-- Retorna vales pessoais trocados no periodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 13/01/2009
	--->	
	<cffunction name="get_vales_pessoais" displayname="" access="remote" returntype="query" output="true">
    	<cfargument name="cod_funcionario" required="no" default="">
    	<cfargument name="mes_ano" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select v.num_vale, to_char(v.data_troca,'dd/mm/yyyy') as data_troca,
                   p.cliente as local_troca, v.valor
              from oper.v$vale v  
              inner join kss.v$pessoa p 
                      on p.cod_pessoa = v.cod_pessoa_troca 
			  inner join oper.v$motorista_reg_historico mhr
                      on mhr.COD_PESSOA = v.COD_PESSOA_FUNCIONARIO
                     and mhr.COD_REGISTRO = #arguments.cod_funcionario#
             where to_char(v.data_troca,'mm/yyyy') = '#Trim(arguments.mes_ano)#'
               and v.tipo_id = 2
               order by data_troca 
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>    
	<!--- 
	-- PROPSITO
	-- Retorna todos os grupos de motoristas
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/08/2007
	--->	
	<cffunction name="get_grupos_controle" displayname="" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_parados" username="#session.usuario#" password="#session.senha#">
            select gr.grupo_ctrl_id, gr.cod_grupo_ctrl, gr.descricao, gr.ativo, gr.fixo,
                   gr.rateio_comissao, gr.rateio_media_combust, gr.data, gr.bloqueado
              from oper.v$grupo_ctrl gr
             where gr.ativo = 1
             order by grupo_ctrl_id
 		</cfquery>
		<cfreturn qrfuncionarios_parados>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os veiculos que esto vinculados a grupos
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/08/2007
	--->	
	<cffunction name="get_veiculo_grupos_controle" displayname="" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_parados" username="#session.usuario#" password="#session.senha#">
            select gr.cod_grupo_ctrl, gcv.grupo_ctrl_id, gcv.placa
              from oper.v$grupo_ctrl_veiculo gcv
             inner join oper.v$grupo_ctrl gr
                     on gr.grupo_ctrl_id = gcv.grupo_ctrl_id
             order by gr.grupo_ctrl_id, placa                      
   		</cfquery>
		<cfreturn qrfuncionarios_parados>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os motorista que esto vinculados a grupos
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/08/2007
	--->	
	<cffunction name="get_motorista_grupos_controle" displayname="" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_parados" username="#session.usuario#" password="#session.senha#">
            select gc.grupo_ctrl_id, gc.cod_grupo_ctrl, gcm.cod_pessoa, 
                   mc.cod_funcionario, p.cliente as motorista
              from oper.v$grupo_ctrl gc
             inner join oper.v$grupo_ctrl_motorista gcm
                     on gcm.grupo_ctrl_id = gc.grupo_ctrl_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = gcm.cod_pessoa
             inner join oper.v$motorista_controle mc
                     on mc.cod_pessoa = p.cod_pessoa        
             where 1=1
             <cfif Len(Trim(arguments.COD_PESSOA))>
               and gcm.cod_pessoa = #arguments.COD_PESSOA#
             </cfif>
             order by gc.grupo_ctrl_id, mc.cod_funcionario,  motorista
        </cfquery>
		<cfreturn qrfuncionarios_parados>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os funcionarios que esto viajando
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->
	<cffunction name="get_funcionarios_viajando" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="letra_inicial" required="no" type="string">
		<cfargument name="cod_pessoa" required="no" type="string">		
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_viajando" username="#session.usuario#" password="#session.senha#" blockfactor="100">
		SELECT /*+ORDERED LEADING (MC) */
          f.cod_funcionario, f.nome_funcionario, to_char(vm.data_inicio,'dd/mm/yyyy') as data_inicio,
  				substr(vm.placa,1,3)||'-'||substr(vm.placa,4,4) as placa, 
  				round(oper.pkg_ccorrente.fnc_saldo_ccorrente_dia(cc.cod_conta,sysdate,0),2) as saldo,
  				oper.fnc_localizacao_motorista(vm.cod_pessoa).latitude as latitude,
  				oper.fnc_localizacao_motorista(vm.cod_pessoa).longitude as longitude,
  				initCap(oper.fnc_localizacao_motorista(vm.cod_pessoa).referencia) as referencia,
			  	decode(oper.pkg_motorista.fnc_km_limite_veiculo(vm.cod_pessoa,sysdate),-1,'Problemas Conta',oper.pkg_motorista.fnc_km_limite_veiculo(vm.cod_pessoa,sysdate)) as km_limite,
			  	oper.pkg_veiculo.fnc_km_atual(vm.placa) as km_atual,
			  	nvl(to_char(oper.pkg_motorista.fnc_nota_atual(vm.cod_pessoa)),'Sem Nota') as nota,
			    pj.nome_fantasia as entreposto, gr.cod_grupo_ctrl as grupo_motorista,
                oper.pkg_motorista.fnc_status_cto_experiencia(f.cod_funcionario) status_contrato_experiencia,
                (select vg.descricao
                   from oper.v$veiculo_grupo_setup vg
                  where vg.GRUPO_ID = oper.pkg_veiculo.fnc_grupo_veiculo(gr.cod_grupo_ctrl)) as grupo_veiculo
			 FROM oper.v$motorista_reg_historico mc
				inner join oper.v$rh_funcionario f 
						on f.cod_funcionario = mc.cod_registro
			inner join rh.rh_gestao_entreposto en
					on en.cod_entreposto = f.cod_entreposto
			inner join kss.v$pessoa_juridica pj
					on pj.cnpj_basico = en.cnpj_basico
				   and pj.cnpj_ordem = en.cnpj_ordem
			inner join oper.v$veiculo_motorista vm     
						on mc.cod_pessoa = vm.cod_pessoa
			inner join oper.v$ccorrente cc 
			 	    on cc.cod_pessoa = vm.cod_pessoa
           left join (oper.v$grupo_ctrl_motorista grm
                          inner join oper.v$grupo_ctrl gr
                                  on gr.grupo_ctrl_id = grm.grupo_ctrl_id) 
              on grm.cod_pessoa = vm.cod_pessoa                    
		     where f.cod_cargo = 1 and f.data_demissao is null     
			    and vm.data_fim is null 
			    and cc.modalidade_id = 4
				  and cc.ativo = 1				 
		 order by f.nome_funcionario
		</cfquery>
	<cfreturn qrfuncionarios_viajando>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca os dados da gestao para a modalidade passada
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->
	<cffunction name="get_gestao" displayname="" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qrGestao" username="#session.usuario#" password="#session.senha#">
				select oper.pkg_global.fnc_get_parametro(17,'LOGISTICA') as limite_conta_corrente_mot
				  from dual
		</cfquery>
		<cfreturn qrGestao>
	</cffunction>
			
	<!--- 
	-- PROPSITO
	-- Retorna os eventos para o Holerite
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="get_holerite_eventos" displayname="Retorna os eventos para o Holerite" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" displayname="Cdigo do funcionario" required="yes">
		<cfargument name="mes" displayname="Ms para a impresso do holerite" required="yes">
		<cfargument name="ano" displayname="Ano para a impresso do holerite" required="yes">
      <cfargument name="cod_recibo_tipo" required="no" default="1">
		<cfquery datasource="#session.dsn#" name="qr_eventos" username="#session.usuario#" password="#session.senha#">
			SELECT rh_recibo_it.complemento_evento, rh_evento.descricao,                            
				   to_char(rh_evento.cod_evento,'0000') cod_evento,                               
				   rh_recibo_it.referencia, decode(rh_evento.provento,1,rh_recibo_it.valor,'0') decode_rh_evento_provento,                             
				   decode(rh_evento.provento,0,rh_recibo_it.valor,'0') decode_rh_evento_proven_2  
			  FROM rh.entreposto entreposto , oper.v$rh_funcionario rh_funcionario ,               
				   rh.rh_cargos_salarios rh_cargos_salarios,                     
				   rh.rh_recibo rh_recibo , rh.rh_recibo_it rh_recibo_it ,               
				   rh.rh_evento rh_evento  
			WHERE (rh_funcionario.cod_entreposto = entreposto.cod_entreposto)           
			  and (rh_cargos_salarios.cod_cargo = rh_funcionario.cod_cargo)           
			  and (rh_recibo.ano = #arguments.ano#)          
			  and (rh_recibo.mes = #arguments.mes#)          
			  and (rh_funcionario.cod_funcionario = #arguments.cod_funcionario#)           
			  and (rh_recibo.cod_recibo_tipo = #arguments.cod_recibo_tipo#)          
			  and (rh_recibo.cod_funcionario = rh_funcionario.cod_funcionario)
			  and (rh_recibo_it.num_recibo = rh_recibo.num_recibo)
			  and (rh_evento.cod_evento = rh_recibo_it.cod_evento)
			ORDER BY rh_funcionario.nome_funcionario, rh_evento.provento desc, rh_recibo_it.valor desc, rh_recibo_it.cod_evento
		</cfquery>
		<!--- Executado apenas se o site for da delpozo --->
		<cfif isdefined("session.site") and session.site eq "delpozo/">
			<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  delete kss.pessoa_usuario_acesso_cur
			</cfquery>
			<cfquery name="qr_unidade_negocio" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			  select cod_pessoa,upper('#session.usuario#')
				from kss.pessoa_unidade_negocio
			   where cod_unidade_negocio > 0
				 and cod_unidade_negocio is not null
			</cfquery>
            <cfloop query="qr_unidade_negocio">
				<cfquery datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                  insert into kss.pessoa_usuario_acesso_cur
                    (cod_pessoa,usuario)
                  values
                    (#qr_unidade_negocio.cod_pessoa#,upper('#session.usuario#'))
                </cfquery>
			</cfloop>
		</cfif>
		<!---                                             --->
		<cfreturn qr_eventos>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Consulta log holerite
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 04/01/2006
	--->	
	<cffunction name="get_log_holerite" displayname="Consulta log holerite" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" 	required="yes">
		<cfargument name="mes" 				required="yes">
		<cfargument name="ano" 				required="yes">
		<cfquery datasource="#session.dsn#" name="qr_funcionario_lotacao" username="#session.usuario#" password="#session.senha#">
			select lh.cod_funcionario, f.nome_funcionario as funcionario, 
				   mes, ano, data_impressao, nvl(u.apelido,u.usuario) as usuario
	   	      from oper.v$rh_log_holerite lh
		     inner join oper.v$rh_funcionario f
			    on lh.cod_funcionario = f.cod_funcionario
			 inner join kss.kss_usuarios u
				on lh.usuario = u.usuario
		     where lh.cod_funcionario = #arguments.cod_funcionario#
			   and mes = #arguments.mes#
			   and ano = #arguments.ano#
		</cfquery>
		<cfreturn qr_funcionario_lotacao>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca a media de faturamento da empresa e do motorista.
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->	
	<cffunction name="get_motorista_media" displayname="Busca a media de faturamento da empresa e do motorista." access="remote" returntype="struct" output="true">
		<cfargument name="cod_funcionario" required="yes" />
		<cftry>
			<cfstoredproc datasource="#session.dsn#" procedure="oper.prc_motorista_media_frete" username="#session.usuario#" password="#session.senha#">
				<cfprocparam type="in" cfsqltype="cf_sql_numeric" dbvarname="p_cod_funcionario" value="#arguments.cod_funcionario#">
				<cfprocparam type="out" cfsqltype="cf_sql_float" dbvarname="p_media_empresa" variable="retorno.media_empresa">
				<cfprocparam type="out" cfsqltype="cf_sql_float" dbvarname="p_media_motorista" variable="retorno.media_motorista">
				<cfprocparam type="out" cfsqltype="cf_sql_float" dbvarname="p_percentual" variable="retorno.percentual">
			</cfstoredproc>		
			<cfcatch type="any">
				<cfset session.erro = cfcatch.Detail>						
				<cfset retorno.mensagem = 'Problemas para calcular a mdia.'>						
				<cfset retorno.erro = true>		
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Busca o motorista atualmente responsavel pelo veiculo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 17/02/2006
	--->	
	<cffunction name="get_motorista_veiculo" output="true" returntype="query" displayname="Busca todos os itens do informativo">
		<cfargument name="placa" required="yes">
		<cfargument name="data" required="yes">
		<cfquery datasource="#session.dsn#" name="qrMotorista" username="#session.usuario#" password="#session.senha#">
			select oper.pkg_global.fnc_get_cod_funcionario(pf.cod_pessoa) as cod_funcionario, pf.cod_pessoa, pf.nome
			  from oper.v$veiculo_motorista vm
			 inner join oper.v$pessoa_fisica pf
					 on pf.cod_pessoa = vm.cod_pessoa
             inner join table(kss.pkg_string.fnc_split(oper.pkg_veiculo.fnc_get_composicao('#arguments.placa#',to_date('#arguments.data#','dd/mm/yyyy hh24:mi')),'|')) t
                     on t.column_value = vm.placa
			 where to_date('#arguments.data#','dd/mm/yyyy hh24:mi') between vm.DATA_INICIO and nvl(vm.DATA_FIM,sysdate)		
			 </cfquery>
		<cfreturn qrMotorista>
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca o organograma
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER - 03/01/2006 - criado
	-- GUTO 24/02/2006 - modificado, inserido o lag para montar a arvore no combo
	--->	
	<cffunction name="get_organograma" displayname="Busca o organograma" access="remote" returntype="query" output="true">
		<cfargument name="COD_PESSOA" 		required="no" default="">
        <cfargument name="COD_UNIDADE_NEGOCIO" 		required="no" default="">
        <cfargument name="COD_CENTRO_CUSTO" required="no" default="">
		<cfargument name="COD_DEPARTAMENTO" required="no" default="">
        <cfargument name="COD_SETOR" required="no" default="">
        <cfargument name="CENTRO_CUSTO" required="no" default="">
        <cfargument name="SETOR" required="no" default="">
		<cfargument name="NOME_FANTASIA" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_organograma" username="#session.usuario#" password="#session.senha#">
			select /*+FIRST_ROWS*/ distinct rownum, u.cod_unidade_negocio, p.cod_pessoa, 
  					 p.cliente nome_fantasia, d.cod_departamento, d.descricao as departamento,
   			    s.cod_setor,  s.descricao as setor,
  				    c.cod_centro_custo, c.centro_custo,
  				    sysdate as data, o.cod_organograma
			 from kss.v$organograma o 
			inner join kss.v$unidade_negocio u
					on o.cod_unidade_negocio = u.cod_unidade_negocio
			inner join kss.v$pessoa p
					on u.cod_pessoa = p.cod_pessoa
			inner join kss.v$departamento d
					  on o.cod_departamento = d.cod_departamento
			inner join kss.v$setor s
					on o.cod_setor = s.cod_setor				
			inner join kss.v$centro_custo c
					  on o.cod_centro_custo = c.cod_centro_custo
			where 1=1
			<cfif len(trim(arguments.COD_PESSOA))>
			  and u.cod_pessoa = #arguments.COD_PESSOA#
			</cfif>
            <cfif len(trim(arguments.COD_UNIDADE_NEGOCIO))>
			  and u.cod_unidade_negocio = #arguments.COD_UNIDADE_NEGOCIO#
			</cfif>
            <cfif len(trim(arguments.COD_CENTRO_CUSTO))>
            	and o.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
            </cfif>
			<cfif len(trim(arguments.COD_DEPARTAMENTO))>
			  and o.cod_departamento = #arguments.COD_DEPARTAMENTO#
			</cfif>
			<cfif len(trim(arguments.COD_SETOR))>
			  and o.cod_setor = #arguments.COD_SETOR#
			</cfif>
            <cfif len(trim(arguments.NOME_FANTASIA))>
			  and upper(p.cliente) like upper('%#arguments.NOME_FANTASIA#%')
			</cfif>
            <cfif len(trim(arguments.CENTRO_CUSTO))>
			  and upper(c.centro_custo) like upper('%#arguments.CENTRO_CUSTO#%')
			</cfif>
            <cfif len(trim(arguments.SETOR))>
              and upper(s.descricao) like upper('%#arguments.setor#%')	
            </cfif>
			order by nome_fantasia, departamento, setor, c.centro_custo
		</cfquery>
		<cfreturn qr_organograma>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Busca todos os postos autorizados e ativos
	-- NOTAS EXPLICATIVAS
	-- GUTO
	--->	
	<cffunction name="get_postos" displayname="Busca todos os postos autorizados e ativos" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nome_fantasia, municipio, uf, endereco, sentido, bandeira, responsavel, num_ctf ,
            	   abastecimento, lavagem, lubrificacao
			  from oper.v$postos_liberados
              order by uf
	   	</cfquery>
		<cfreturn qr_result>		
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Lanamento de prejuzos pendentes
	-- NOTAS EXPLICATIVAS
	-- GUTO - 23/02/2006
	--->	
	<cffunction name="get_prejuizos_pendentes" displayname="Lanamento de prejuzos pendentes" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select fnc_concat_all(to_concat_expr('Placa: ' || a.placa || ' Motorista: ' || oper.pkg_global.FNC_BUSCA_NOME_PESSOA(a.cod_pessoa)  || ' - ' ||a.historico, chr(10))) pendentes
			from oper.v$acidente_debito a
			where valor_acidente - valor_debitado > 0
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna todos pedidos de reserva que no foram encerrados ou cancelados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 03/03/2006
	--->
	<cffunction name="get_pedidos_reserva" displayname="Retorna todos pedidos de reserva que no foram encerrados ou cancelados" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select mpr.controle_evo_id, pf.nome as solicitado_por, mpr.placa, mpr.data_envio, mpr.data_pedido, mpr.motivo, mpr.data_previsao, mpr.data_previsao_retorno,
				   oper.pkg_global.fnc_get_cod_funcionario(mpr.COD_PESSOA_ALOCADO) as cod_funcionario_subst,
				   nvl(pfa.nome,'No definido') as substituido_por, 
				   cd.rv_meaning as situacao, nvl(mpr.LOCAL_TROCA,'No definido.') as LOCAL_TROCA, 
				   oper.pkg_global.fnc_get_cod_funcionario(mpr.cod_pessoa_pedido) as cod_funcionario,
				   mpr.situacao as situacao_id, oper.pkg_motorista.fnc_status_cto_experiencia(oper.pkg_global.fnc_get_cod_funcionario(mpr.cod_pessoa_pedido)) status_contrato_experiencia
				   from oper.v$motorista_ped_reserva mpr
			 inner join oper.cg_ref_codes cd
					 on cd.rv_low_value = mpr.situacao
					and cd.rv_domain = 'MOTORISTA_PED_RESERVA.SITUACAO'
			 inner join oper.v$pessoa_fisica pf
					 on mpr.cod_pessoa_pedido = pf.cod_pessoa
			 left join oper.v$pessoa_fisica pfa
					 on mpr.cod_pessoa_alocado = pfa.cod_pessoa  
		     where 1=1
					<cfif len(trim(arguments.data_inicio))>
       and trunc(mpr.data_pedido) >= '#arguments.data_inicio#'
					</cfif>
     <cfif len(trim(arguments.data_fim))>
       and trunc(mpr.data_pedido) <= '#arguments.data_fim#'
     <cfelse>
		   		and trunc(mpr.data_pedido) >= trunc(sysdate)
			   </cfif>             
			order by mpr.data_pedido desc 
		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna todos pedidos de reserva que no foram encerrados ou cancelados
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->
	<cffunction name="get_pedidos_reserva_aberto" displayname="" access="remote" returntype="query" output="true">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios" username="#session.usuario#" password="#session.senha#">
              select /*+ ordered */ mpr.controle_evo_id, 
                           pf.nome as solicitado_por, 
                   mpr.placa, 
                   mpr.data_envio, 
                   mpr.data_pedido,
                   mpr.motivo, 
                   mpr.data_previsao, 
                   mpr.data_previsao_retorno,
                   oper.pkg_global.fnc_get_cod_funcionario(mpr.COD_PESSOA_ALOCADO) as cod_funcionario_subst,
                   nvl(pfa.nome,'No definido') as substituido_por, 
                   cd.rv_meaning as situacao, nvl(mpr.LOCAL_TROCA,'No definido.') as LOCAL_TROCA, 
                   oper.pkg_global.fnc_get_cod_funcionario(mpr.cod_pessoa_pedido) as cod_funcionario, 
                   gr.cod_grupo_ctrl grupo_motorista, oper.pkg_motorista.fnc_status_cto_experiencia(mpr.cod_pessoa_pedido) status_contrato_experiencia,
                   (select vg.descricao
                      from oper.v$veiculo_grupo_setup vg
                     where vg.GRUPO_ID = oper.pkg_veiculo.fnc_grupo_veiculo(gr.cod_grupo_ctrl)) as grupo_veiculo
                   from oper.v$motorista_ped_reserva mpr
               inner join oper.cg_ref_codes cd
                   on cd.rv_low_value = mpr.situacao
                  and cd.rv_domain = 'MOTORISTA_PED_RESERVA.SITUACAO'
                  and mpr.situacao in (0,1)
               inner join oper.v$pessoa_fisica pf
                   on mpr.cod_pessoa_pedido = pf.cod_pessoa
               left join oper.v$pessoa_fisica pfa
                   on mpr.cod_pessoa_alocado = pfa.cod_pessoa  
               left join (oper.v$grupo_ctrl_motorista grm
                             inner join oper.v$grupo_ctrl gr
                                     on gr.grupo_ctrl_id = grm.grupo_ctrl_id)
                     on grm.cod_pessoa = pf.cod_pessoa
                     order by mpr.data_pedido desc
		</cfquery>
		<cfreturn qrfuncionarios>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Buscas os recados para os motoristas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->	
	<cffunction name="get_recados" displayname="Buscas os recados para os motoristas" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" displayname="Cdigo do Funcionario"  required="false">
		<cfargument name="abertas" displayname="Cdigo do Funcionario"  required="false">
		<cfargument name="ativas" displayname="Cdigo do Funcionario"  required="false">
		<cfif isDefined("arguments.cod_funcionario")>
			<cfquery datasource="#session.dsn#" name="qr_func" username="#session.usuario#" password="#session.senha#" timeout="25">
				select decode(oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_funcionario#),-1,#arguments.cod_funcionario#,oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_funcionario#))
					   as cod_funcionario,
					   decode(oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#),-1,#arguments.cod_funcionario#,oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#))  as cod_pessoa
				   from dual
			</cfquery>
		</cfif>
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select recado_id, cod_pessoa, oper.pkg_global.fnc_get_cod_funcionario(cod_pessoa) as cod_funcionario, 
				   oper.pkg_global.FNC_BUSCA_NOME_PESSOA(cod_pessoa) as nome_funcionario, 
				   recado, data_inicio, data_fim, ativo, user_insert
			  from oper.v$motorista_recado	
			where extrato = 1
			<cfif isDefined("arguments.cod_funcionario")>
				and cod_pessoa = #qr_func.cod_pessoa#
			</cfif>

			<cfif isDefined("arguments.abertas")>
				and sysdate between data_inicio and data_fim
			</cfif>

			<cfif isDefined("arguments.ativas")>
				and ativo = 1
			</cfif>
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca recados em abertos e ativos para os motoristas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->	
	<cffunction name="get_recados_agrupado" displayname="Busca recados em abertos e ativos para os motoristas" access="remote" returntype="query" output="true">
	 	<cfargument name="cod_pessoa" required="no">
	 	<cfargument name="cod_funcionario" required="no">
		<cfargument name="agrupado" default="0" required="no">
		<cfif arguments.agrupado eq 0>
			<cfquery name="qr_recados"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ first_rows*/ mrh.cod_pessoa, mr.recado_id, 
					   mrh.cod_registro as cod_funcionario, 
					   oper.pkg_global.fnc_busca_nome_pessoa(mr.cod_pessoa) as nome_funcionario, 
					   mr.recado, mr.data_inicio, mr.data_fim, mr.ativo, mr.user_insert
				  from oper.v$motorista_recado mr
				 inner join oper.v$motorista_reg_historico mrh
						 on mrh.cod_pessoa = mr.cod_pessoa
						and mrh.data_fim is null
				where mr.extrato = 0
				  and mr.ativo = 1
				  <cfif isDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa))>
					 and mr.cod_pessoa = #arguments.cod_pessoa#
				  </cfif>
				  <cfif isDefined("arguments.cod_funcionario") and Len(Trim(arguments.cod_funcionario))>
					 and mrh.cod_registro = '#arguments.cod_funcionario#'
				  </cfif>
			</cfquery>
		<cfelse>
			<cfquery name="qr_recados"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ first_rows*/ mrh.cod_pessoa, mrh.cod_registro as cod_funcionario, 
						   fnc_concat_all(to_concat_expr('[' || mr.user_insert || '] ' || mr.recado, chr(10))) recado
				  from oper.v$motorista_recado mr
				 inner join oper.v$motorista_reg_historico mrh
						 on mrh.cod_pessoa = mr.cod_pessoa
						  and mrh.data_fim is null
				where mr.extrato = 0
				  and mr.ativo = 1
  				  <cfif isDefined("arguments.cod_pessoa") and Len(Trim(arguments.cod_pessoa))>
					 and mr.cod_pessoa = #arguments.cod_pessoa#
				  </cfif>
				  <cfif isDefined("arguments.cod_funcionario") and Len(Trim(arguments.cod_funcionario))>
					 and mrh.cod_registro = '#arguments.cod_funcionario#'
				  </cfif>
				 group by mrh.cod_pessoa, mrh.cod_registro
			</cfquery>
		</cfif>
		<cfreturn qr_recados>
	</cffunction>
			
	<!--- 
	-- PROPSITO
	-- Consulta Responsavel pelo Grupo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 21/02/2006
	--->
	<cffunction name="get_responsavel" displayname="Consulta todos os cargos" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="no">
		<cfargument name="placa" required="no">
		<cfargument name="parametro" required="no">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select cod_grupo, placa, cod_pessoa 
			  from oper.v$motorista_grupo
			 <cfif isDefined("arguments.placa") and Len(Trim(arguments.placa))>
				 where placa = '#UCase(arguments.placa)#'
			 <cfelseif isDefined("arguments.parametro") and not IsNumeric(arguments.parametro)>
				 where placa = '#arguments.parametro#'
			 </cfif>
			 <cfif isDefined("arguments.cod_funcionario") and Len(Trim(arguments.cod_funcionario))>
				 where cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func( #arguments.cod_funcionario# )
			 <cfelseif isDefined("arguments.parametro") and IsNumeric(arguments.parametro)>
				 where cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func( #arguments.parametro# )
			 <cfelseif isDefined("arguments.cod_pessoa") and IsNumeric(arguments.cod_pessoa)>
				 where cod_pessoa = #arguments.cod_pessoa#
			 </cfif>
		</cfquery>
	    <cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca todos os setores da empresa
	-- NOTAS EXPLICATIVAS
	-- GUTO - 23/02/2005
	--->	
	<cffunction name="get_setores" displayname="Busca todos os setores da empresa" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="" />
		<cfargument name="borracharia" required="no" default="" />
       	<cfargument name="setor" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct  s.cod_setor, 
				   decode(s.cod_setor,3,s.descricao || ' - ' || pj.nome_fantasia,s.descricao) as descricao, 
				   decode(s.cod_setor,3,s.descricao || ' - ' || pj.nome_fantasia,s.descricao) as setor, 
        		   s.cod_pessoa_filial as cod_pessoa, 
				   s.cod_pessoa_filial, pj.cnpj_basico, pj.cnpj_ordem, s.filial
			  from oper.v$setor s
	         inner join oper.v$pessoa_juridica pj
               on s.cod_pessoa_filial = pj.cod_pessoa
			 where 1=1
			 <cfif Len(Trim(arguments.BORRACHARIA))>
			    and s.possui_borracharia = 1
			 </cfif>
             <cfif len(trim(arguments.setor))>
             	and upper(descricao) like upper('%#arguments.setor#%') 
             </cfif> 
			 <cfif Len(Trim(arguments.COD_PESSOA_FILIAL))>
			    and s.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
			 <cfelse>
	 		    order by s.cod_pessoa_filial 
			 </cfif>
   	   	</cfquery>
		<cfreturn qr_result>		
	</cffunction>			

	<!--- 
	-- PROPSITO
	-- Retorna true se nao for possivel imprimir o holerite
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 04/01/2006 - criado
	--->	
	<cffunction name="get_trava_folha" displayname="Retorna true se for possivel imprimir o holerite" access="remote" returntype="boolean" output="true">
		<cfargument name="cod_funcionario" 	required="yes">
		<cfargument name="mes" 				required="yes">
		<cfargument name="ano" 				required="yes">
		<cfquery datasource="#session.dsn#" name="qr_trava" username="#session.usuario#" password="#session.senha#">
			select 0  
			  from delpozo.rh_gestao_internet 
			 where to_date('#arguments.mes#/#arguments.ano#','mm/yyyy') between to_date(mes_ano_inicio,'mm/yyyy') and to_date(mes_ano_fim,'mm/yyyy')
		</cfquery>	
		<cfif qr_trava.RecordCount GT 0>
			<cfreturn false>
		<cfelse>	
			<cfreturn true>
		</cfif>
	</cffunction>	
	

	<!--- 
	-- PROPSITO
	-- Verifica se o usuario pode imprimir o holerite do funcioanrio 
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 04/01/2006 - criado
	--->	
	<cffunction name="get_func_autorizados" displayname="Busca todos os funcionarios que o usuario pode imprimir a folha" access="remote" returntype="query" output="true">
	<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
		select cod_funcionario 
		  from oper.liberacao_holerite
		 where usuario = user           
	</cfquery>	
		<cfreturn qr_result>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Busca a data e o KM rodado depois do ultimo acidente.
	-- NOTAS EXPLICATIVAS
	-- GUTO
	--->	
	<cffunction name="get_ultimo_acidente" displayname="Busca a data e o KM rodado depois do ultimo acidente." access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select min(km) as km, min(data_ultimo_acidente) as data_primeiro_acidente,
						 replace(
					  replace(  
						   replace(
								replace(
									 replace(oper.pkg_global.FNC_GET_PARAMETRO(8,'LOGISTICA'),'[data_ultimo_acidente]',
											 to_char(min(data_ultimo_acidente),'dd/mm/yyyy')),'[km_rodado]',
												  trim(to_char(min(KM),'99G999G999G999'))),'[valor_gasto_acidente]',
													   trim(to_char(sum(trunc(valor_debitado)),'999G999G990D00'))),'[valor_restante]',
														   trim(to_char(sum(valor_acidente - valor_debitado),'999G999G990D00'))), '[dias_sem_acidente]',
																																						trim(to_char((trunc(sysdate)-max(data_acidente)), '99900'))) as mensagem
				 from oper.mv$km_acidente
				 natural join oper.v$acidente_debito
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Busca o veiculo atual do funcionario
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="get_veiculo_atual" access="remote" returntype="string" output="true">
		<cfargument name="cod_funcionario" displayname="Cdigo do funcionario" type="numeric" required="true">
		<cfquery datasource="#session.dsn#" name="qrVeiculo" username="#session.usuario#" password="#session.senha#">
		
			select oper.pkg_veiculo.fnc_get_veiculo_atual(#arguments.cod_funcionario#) as placa
			  from dual
  		</cfquery>
	<cfreturn qrVeiculo.placa>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Verifica se o cod pessoa  de um funcionario
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="verifica_funcionario" displayname="Verifica se o cod pessoa  de um funcionario" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no">
		<cfquery datasource="#session.dsn#" name="qr_dados" username="#session.usuario#" password="#session.senha#">
			select cod_funcionario, autoriza_adiantamento
			  from oper.v$rh_funcionario
			 where cod_funcionario = oper.pkg_global.fnc_get_cod_funcionario(#arguments.cod_pessoa#)
			 and data_demissao is null
  		</cfquery>
		<cfreturn qr_dados>
	</cffunction>
			
	<!--- 
	-- PROPSITO
	-- Confere diferena entre holerite e comisso
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER 28/12/2005 - criado
	--->	
	<cffunction name="get_verifica_holerites" displayname="Faturamento Motorista - Pendentes" access="remote" returntype="query" output="true">
		<cfargument name="mes" required="no">
		<cfargument name="ano" required="no">
      <cfargument name="cod_recibo_tipo" required="no" default="1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_funcionario, nome_funcionario, sum(pgto_folha) as pgto_folha, sum(pgto_comissao) as pgto_comissao
			  from (select distinct rh_funcionario.cod_funcionario, rh_funcionario.nome_funcionario, rh_recibo.total_proventos as pgto_folha, 0 as pgto_comissao
						from oper.v$rh_funcionario rh_funcionario ,        
								 rh.rh_cargos_salarios rh_cargos_salarios,              
								 rh.rh_recibo rh_recibo , rh.rh_recibo_it rh_recibo_it , 
								 rh.rh_evento rh_evento  
						 where (rh_cargos_salarios.cod_cargo = rh_funcionario.cod_cargo)       
					   and (rh_cargos_salarios.cod_cargo = 1)
						   and (rh_recibo.ano = #arguments.ano#)      
						   and (rh_recibo.mes = #arguments.mes#)      
						   and (rh_recibo.cod_recibo_tipo = #arguments.cod_recibo_tipo#)      
						   and (rh_recibo.cod_funcionario = rh_funcionario.cod_funcionario)       
						   and (rh_recibo_it.num_recibo = rh_recibo.num_recibo)       
						   and (rh_evento.cod_evento = rh_recibo_it.cod_evento)  
				   
					 union     
			
						select cod_funcionario, motorista as nome_funcionario, 0 as pgto_folha,
						   sum(round((frete_motorista - pedagio_descontado - desc_atraso_descarga)*(comissao/100),2)) as pgto_comissao 
						  from oper.v$_mot_viagens_fechadas
						 where mes_competencia = #arguments.mes#
						   and ano_competencia = #arguments.ano#
					 group by cod_funcionario, motorista)
			group by cod_funcionario, nome_funcionario
			order by nome_funcionario
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Faturamento Motorista - Pendentes
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="get_viagens_pendentes" displayname="Faturamento Motorista - Pendentes" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" 	required="no">
		<cfargument name="cod_pessoa" 		required="no">
		<cfargument name="mes" 				required="no">
		<cfargument name="ano" 				required="no">
		<cfif IsDefined("arguments.cod_funcionario")>
			<cfquery name="qr_func"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#) as cod_pessoa
				  from dual		
			</cfquery>
		</cfif>
		
		<cfquery datasource="#session.dsn#" name="qr_dados" username="#session.usuario#" password="#session.senha#">
			select cod_funcionario, motorista, num_romaneio, carregamento, destino, 
				   frete_liquido, pedagio, data_inicio, data_termino, data_viagem, 
				   situacao, fat_motorista_km, fat_total_motorista, total_viagem, 
				   case when valor_motorista < 0 then 0 else valor_motorista end  valor_motorista, 
				   percentual, fat_motorista, perc_viagem, placa_controle, placa_referencia, cumpriu_horario_carr as cumpriu_horario, num_atraso
			  from oper.v$_mot_viagens_pendentes
			 where data_viagem >= '01/01/2008'
               and data_viagem < '01/#arguments.mes#/#arguments.ano#'
			 <cfif IsDefined("arguments.cod_pessoa")>
			   and cod_pessoa = #arguments.cod_pessoa#			   			 
			 </cfif>
			 <cfif IsDefined("arguments.cod_funcionario")>
			   and cod_pessoa = #qr_func.cod_pessoa#			   			 
			 </cfif>
  		</cfquery>
		<cfreturn qr_dados>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Faturamento Motorista - Fechadas
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="get_viagens_fechadas" displayname="Faturamento Motorista - Pendentes" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" 		required="no">
		<cfargument name="cod_funcionario" 	required="no">
		<cfargument name="mes" 				required="no">
		<cfargument name="ano" 				required="no">
		<cfif IsDefined("arguments.cod_funcionario")>
			<cfquery name="qr_func"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select distinct mrh.cod_pessoa
				  from oper.v$motorista_reg_historico mrh
				  where mrh.cod_registro = #arguments.cod_funcionario#
					and nvl(mrh.data_fim,sysdate) = (select max(nvl(mrh2.data_fim,sysdate))
													   from oper.v$motorista_reg_historico mrh2
													  where mrh2.cod_registro = mrh.cod_registro)	
			</cfquery>
			<cfif qr_func.RecordCount eq 0>
				<cfquery name="qr_func"  datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#) as cod_pessoa
					  from dual		
				</cfquery>				
			</cfif>
		</cfif>
        <cfif (val(arguments.ano) gte 2008 and val(arguments.mes) gte 03) or val(arguments.ano) gt 2008>
            <cfquery datasource="#session.dsn#" name="qr_dados" username="#session.usuario#" password="#session.senha#">
                select vf.cod_funcionario, vf.motorista, vf.num_romaneio, vf.carregamento, vf.destino, vf.frete_liquido, vf.desc_atraso_descarga, 
                	   decode(cr.periculosidade,1,'Sim','No') as periculosidade, n.descricao as natureza, 
                       vf.pedagio, vf.data_inicio, vf.data_termino, vf.mes_competencia, vf.ano_competencia, vf.situacao, 
                       vf.fat_motorista_km, vf.total_viagem, vf.percentual, vf.fat_motorista, vf.num_atraso, vf.cumpriu_horario_carr as cumpriu_horario,   
                       vf.perc_viagem, vf.frete_motorista + decode(nvl(r.valor_descarga,0),0,0,(r.valor_descarga*vf.perc_viagem)/100) as frete_motorista, vf.pedagio_descontado, vf.descarga, vf.carga, vf.placa_controle, vf.placa_referencia, 
                       decode(nvl(r.valor_descarga,0),0,0,(r.valor_descarga*vf.perc_viagem)/100) as valor_descarga,
                       round((vf.frete_motorista - vf.pedagio_descontado - vf.desc_atraso_descarga)*(comissao/100),2) as fat_total_motorista
                  from oper.v$_mot_viagens_fechadas_novo vf
                  inner join oper.v$romaneio r
                          on vf.num_romaneio = r.num_romaneio
                  inner join oper.v$natureza n
                           on n.num_natureza = r.NUM_NATUREZA
                  left join oper.v$comissao_romaneio cr
                          on cr.NUM_ROMANEIO = r.num_romaneio
                          and cr.COD_PESSOA = vf.cod_pessoa
                 where vf.mes_competencia = #arguments.mes#
                   and vf.ano_competencia = #arguments.ano#
                 <cfif IsDefined("arguments.cod_pessoa")>
                   and vf.cod_pessoa= #arguments.cod_pessoa#
                 </cfif>
                 <cfif IsDefined("arguments.cod_funcionario")>
                   and vf.cod_pessoa = #qr_func.cod_pessoa#			   			 
                 </cfif>
                   and vf.frete_motorista > 0
                   order by vf.data_inicio_motorista
            </cfquery>
		<cfelse>
            <cfquery datasource="#session.dsn#" name="qr_dados" username="#session.usuario#" password="#session.senha#">
                select vf.cod_funcionario, vf.motorista, vf.num_romaneio, vf.carregamento, vf.destino, vf.frete_liquido, vf.desc_atraso_descarga, 
                       vf.pedagio, vf.data_inicio, vf.data_termino, vf.mes_competencia, vf.ano_competencia, vf.situacao, 
                       vf.fat_motorista_km, vf.total_viagem, vf.percentual, vf.fat_motorista, vf.num_atraso, vf.cumpriu_horario_carr as cumpriu_horario,   
                       vf.perc_viagem, vf.frete_motorista + decode(nvl(r.valor_descarga,0),0,0,(r.valor_descarga*vf.perc_viagem)/100) as frete_motorista, vf.pedagio_descontado, vf.descarga, vf.carga, vf.placa_controle, vf.placa_referencia, 
                       decode(nvl(r.valor_descarga,0),0,0,(r.valor_descarga*vf.perc_viagem)/100) as valor_descarga,
                       round((vf.frete_motorista - vf.pedagio_descontado - vf.desc_atraso_descarga)*(comissao/100),2) as fat_total_motorista
                  from oper.v$_mot_viagens_fechadas vf
                 inner join oper.v$romaneio r
                         on vf.num_romaneio = r.num_romaneio
                 where vf.mes_competencia = #arguments.mes#
                   and vf.ano_competencia = #arguments.ano#
                 <cfif IsDefined("arguments.cod_pessoa")>
                   and vf.cod_pessoa= #arguments.cod_pessoa#
                 </cfif>
                 <cfif IsDefined("arguments.cod_funcionario")>
                   and vf.cod_pessoa = #qr_func.cod_pessoa#			   			 
                 </cfif>
                   and vf.frete_motorista > 0 
            </cfquery>
         </cfif>
		<cfreturn qr_dados>
	</cffunction>		
	
	<!--- 
	-- PROPSITO 
	-- Busca os motoristas titulares dos veiculos
	-- CRISTOFER  09/05/2006
	--->		
	<cffunction name="get_controle_veiculo_mot_titular" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select frota_controle,
				   modelo_cavalo,
				   frota_referencia,
				   modelo_carreta,
				   cod_grupo,
				   km,
				   cod_funcionario_atual,
				   nome_atual,
				   km_limite_atual,
				   cod_funcionario_titular_1,
				   nome_titular_1,
				   km_limite_1,
				   recado_1,
				   situacao,
				   com_motorista
			  from oper.v$controle_veiculo_mot_titular	
			 order by cod_grupo
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca os documentos pendentes do motorista
	-- GUTO  09/05/2006
	--->		
	<cffunction name="get_documentos_pendente" access="remote" returntype="query" output="false">
		<cfargument name="cod_pessoa" required="yes"/>
        <cfargument name="limitado" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct fl.lancto_id,
				   'Documentos para entregar da viagem ' || fl.num_romaneio as descricao,
				   sysdate as data_limite,
				   oper.pkg_global.FNC_BUSCA_NOME_PESSOA(rhv.cod_pessoa) as nome_funcionario,
				   rhv.cod_pessoa, sysdate as data, fl.urgencia				   
			  from oper.v$romaneio_hist_veiculo rhv
			 inner join oper.v$fluxo_docto fl
					 on rhv.num_romaneio = fl.num_romaneio
			 inner join oper.v$fluxo_docto_it fi
					 on fl.lancto_id = fi.lancto_id
			 where nvl(rhv.data_termino, sysdate) = (select max(nvl(rhv2.data_termino, sysdate))
													  from oper.v$romaneio_hist_veiculo rhv2
													 inner join oper.v$romaneio r
															 on r.num_romaneio = rhv2.num_romaneio
															and r.situacao_id in (1, 2)
													 where rhv2.num_romaneio = rhv.num_romaneio)
			   and rhv.cod_pessoa in (#arguments.cod_pessoa#)
			   and fi.cod_etapa = 'M'
			   and fl.situacao_id = 0
               and fl.item_id is not null
			   and exists (select 'x'
							 from oper.v$fluxo_docto_it fi2
							where fi.lancto_id = fi2.lancto_id
							  and fi2.situacao_id = 0
							  and fi2.cod_etapa = 'M')
               <cfif Len(Trim(arguments.limitado))>
			 	and rhv.data_termino  > sysdate - 365 
			   </cfif>         
			 order by data desc
 		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca as declaraes de mltiplos vnculos dos funcionrios
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 30/10/2006 - criado
	--->	
	<cffunction name="get_declaracao" displayname="Busca as declaraes de mltiplos vnculos." access="remote" returntype="query" output="true">
		<cfargument name="identificador" required="no" default=""/>
		<cfargument name="nome_pessoa" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select num_declaracao, num_rpa, data, servico, inss, irrf, comentarios, identificador, nome_pessoa, carreteiro
			  from rh.rh_declaracao_multi_vinc
  			 where 1=1
			 <cfif Len(Trim(arguments.identificador))>
			 	and identificador = #arguments.identificador#
			 </cfif>
			 <cfif Len(Trim(arguments.nome_pessoa))>
			 	and nome_pessoa like '%#arguments.nome_pessoa#%'
			 </cfif>
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Calcula os valores do INSS e do IRRF levando em considerao a data, os valores dos campos servio e carreteiro e o nmero de dependentes.
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 30/10/2006 - criado
	--->	
	<cffunction name="calcula_inss_irrf" displayname="Calcula valor do IRRF levando em considerao a data, os valores dos campos servio e carreteiro e o nmero de dependentes." access="remote" returntype="query" output="true">
		<cfargument name="servico" required="no" default="0"/>
		<cfargument name="data" required="no" default="#LSDateFormat(Now(),'dd/mm/yyyy')#"/>
		<cfargument name="carreteiro" required="no" default="0"/>
		<cfargument name="num_dependentes" required="no" default="0"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			<cfset arguments.num_dependentes = 9>
			select rh.package_ci.retorna_inss_declaracao(#arguments.servico#,'#arguments.data#',#arguments.carreteiro#) inss, 
       			   rh.package_ci.retorna_irrf_declaracao(#arguments.servico#,'#arguments.data#',#arguments.carreteiro#,#arguments.num_dependentes#) irrf
			  from dual
   		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca dados do DTI para preencher na tela da declarao de mltiplos vnculos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 31/10/2006 - criado
	--->	
	<cffunction name="get_proprietario_despacho" displayname="Busca dados do proprietrio no DTI para preencher na tela da declarao de mltiplos vnculos." access="remote" returntype="query" output="true">
		<cfargument name="despacho_id" required="no" default="0"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select io.prop_cnpj_cpf, io.prop_nome, rp.data, nvl(io.num_dependentes, 0) as num_dependentes, rp.num_rpa
			  from fiscal.intc_despacho io
			 inner join  rh.rh_rpa rp
					 on io.num_rpa = rp.num_rpa
			 where io.cod_proprietario = rp.cod_pessoa
			 <cfif Len(Trim(arguments.despacho_id))>
				and despacho_id = #arguments.despacho_id#
			 </cfif>
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca dados do proprietrio para alteraes na tela da declarao de mltiplos vnculos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 01/11/2006 - criado
	--->	
	<cffunction name="get_proprietario_declaracao" displayname="Busca dados do proprietrio no DTI para preencher na tela da declarao de mltiplos vnculos." access="remote" returntype="query" output="true">
		<cfargument name="IDENTIFICADOR" required="no" default="">
		<cfargument name="NOME_PESSOA" required="no" default="">		
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select 	dc.num_declaracao, dc.num_rpa,
					dc.data, dc.servico, dc.inss,
					dc.irrf, dc.comentarios,
					dc.identificador,
					dc.nome_pessoa,
					dc.carreteiro,
					rp.num_dependentes
			  from rh.rh_declaracao_multi_vinc dc
        inner join rh.rh_rpa rp on rp.num_rpa = dc.num_rpa
          	 where 1=1
          	<cfif Len(Trim(arguments.IDENTIFICADOR))>
			   and dc.identificador like('%#arguments.identificador#%')	
			</cfif>   
			<cfif Len(Trim(arguments.NOME_PESSOA))>
               and upper(dc.nome_pessoa) like upper('%#arguments.nome_pessoa#%')
			</cfif>
		  group by 	dc.num_declaracao, dc.num_rpa,
		  			dc.data, dc.servico, dc.inss,
					dc.irrf, dc.comentarios,
					dc.identificador,
					dc.nome_pessoa,
					dc.carreteiro,
					rp.num_dependentes
		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Busca dados do proprietrio para alteraes na tela da declarao de mltiplos vnculos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 01/11/2006 - criado
	--->	
	<cffunction name="print_declaracao_dependentes" displayname="Busca dados do proprietrio no DTI para preencher na tela da declarao de mltiplos vnculos." access="remote" returntype="query" output="true">
		<cfargument name="COD_PESSOA" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				select p.identificador as cpf,
       				   pf.cart_ident_num as identidade,
					   p.cliente as nome
        		  from kss.v$pessoa p
			inner join kss.v$pessoa_fisica pf
			 	    on pf.cod_pessoa = p.cod_pessoa
		  		 where p.cod_pessoa = #arguments.cod_pessoa#
  		</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Busca dados do proprietrio para alteraes na tela da declarao de mltiplos vnculos
	-- NOTAS EXPLICATIVAS
	--  
	-- arlen 01/11/2006 - criado
	--->	
	<cffunction name="print_retencao_inss" displayname="Busca dados do proprietrio no DTI para preencher na tela da declarao de mltiplos vnculos." access="remote" returntype="query" output="true">
		<cfargument name="identificador" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
				
  			</cfquery>
	   <cfreturn qr_result>	   
	</cffunction>
	
	<!--- 
	-- PROPSITO  
	-- Busca todas as coberturas para usar no cadastro de motoristas em gerenciadoras de risco
	-- NOTAS EXPLICATIVAS
	-- arlen
	--->	
	<cffunction name="get_cobertura" displayname="Busca todas as coberturas para usar no cadastro de motoristas em gerenciadoras de risco." access="remote" returntype="query" output="true">
			<cfargument name="cod_cobertura" required="no" default="">
			<cfargument name="cod_gerenciadora" required="no" default="">
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select cod_cobertura, descricao
				from grisco.v$gerenciadora_cobertura
				<cfif Len(Trim(arguments.cod_cobertura))> 
					where cod_cobertura = #arguments.cod_cobertura#
				</cfif>
				<cfif Len(Trim(arguments.cod_gerenciadora))> 
					where cod_gerenciadora = #arguments.cod_gerenciadora#
				</cfif>
				order by descricao				
			</cfquery>
	    <cfreturn qr_result>
	</cffunction>	
	
	<!--- 
	-- PROPSITO  
	-- Busca todas as gerenciadoras para usar no cadastro de motoristas em gerenciadoras de risco
	-- NOTAS EXPLICATIVAS
	-- arlen
	--->	
	<cffunction name="get_gerenciadora" displayname="Busca todas as gerenciadoras para usar no cadastro de motoristas em gerenciadoras de risco." access="remote" returntype="query" output="true">
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
                select g.cod_gerenciadora,
                       p.razao_social,
                       g.dias_validade,
                       g.cod_gerenciadora as cod_pessoa
                  from grisco.v$gerenciadora g
                  inner join kss.v$pessoa_juridica p
                          on p.cod_pessoa = g.cod_gerenciadora
                 where g.cod_gerenciadora in (select cod_gerenciadora from grisco.v$gerenciadora_cobertura)
              order by p.razao_social     		
			</cfquery>
	    <cfreturn qr_result>
	</cffunction>
	
	<!--- 
	-- PROPSITO  
	-- Busca de motoristas cadastrados em gerenciadoras de risco
	-- NOTAS EXPLICATIVAS
	-- arlen
	--->	
	<cffunction name="get_g_risco_pessoa" displayname="Busca de motoristas cadastrados em gerenciadoras de risco." access="remote" returntype="query" output="true">
			<cfargument name="cod_pessoa_fisica" required="no" default="">
			<cfargument name="cod_gerenciadora" required="no" default="">
			<cfargument name="numero_controle" required="no" default="">
			<cfargument name="motorista_cpf" required="no" default="">
			<cfargument name="data_verificacao" required="no" default="">
			<cfargument name="data_vencimento" required="no" default="">
			<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
				select rp.cod_pessoa_fisica,
				   rp.cod_gerenciadora,
				   rp.numero_controle,
				   rp.cod_cobertura,
				   rp.data_verificacao,
				   rp.data_vencimento,
				   rp.valor_maximo,
				   rp.observacao,
				   pe.razao_social as nome,
				   pe.cnpj_cpf,
				   pj.razao_social 
			  from grisco.v$gerenciadora_pessoa rp, 
			  	   kss.v$pessoa pe, 
				   kss.v$pessoa_juridica pj
			  where 1 = 1
			    and rp.cod_pessoa_fisica = pe.cod_pessoa
				and rp.cod_gerenciadora = pj.cod_pessoa
			<cfif Len(Trim(arguments.cod_pessoa_fisica))> 
				and rp.cod_pessoa_fisica = #arguments.cod_pessoa_fisica#
			</cfif>
			<cfif Len(Trim(arguments.cod_gerenciadora))> 
				and rp.cod_gerenciadora = #arguments.cod_gerenciadora#
			</cfif>
			<cfif Len(Trim(arguments.numero_controle))> 
				and rp.numero_controle = '#arguments.numero_controle#'
			</cfif>
			<cfif Len(Trim(arguments.motorista_cpf))> 
				and pe.cnpj_cpf = '#arguments.motorista_cpf#'
			</cfif>
			<cfif Len(Trim(arguments.data_verificacao))> 
				and rp.data_verificacao = '#arguments.data_verificacao#'
			</cfif>
			<cfif Len(Trim(arguments.data_vencimento))> 
				and rp.data_vencimento = '#arguments.data_vencimento#'
			</cfif>
			order by rp.numero_controle				
			</cfquery>
	    <cfreturn qr_result>
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Retorna todos os veiculos que esto vinculados a grupos
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/08/2007
	--->	
	<cffunction name="get_controle_trafego_veiculo_grupo" displayname="" access="remote" returntype="query" output="true">
    	<cfargument name="grupo_controle_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_parados" username="#session.usuario#" password="#session.senha#">
            select ct.placa_controle, ct.placa_referencia, ct.placa_tracao, ct.placa_reboque, ct.km_revisao, ct.cod_pessoa, 
                 ct.cod_funcionario, ct.cnh_status, ct.cnh_mensagem, ct.aniversario_motorista,
                   ct.distancia, ct.referencia, ct.referencia_id, ct.distancia_destino, ct.tempo, ct.num_romaneio, ct.status,
                   ct.tempo_evento, to_char(nvl(ct.previsao_carregado,ct.previsao_vazio),'dd/mm hh24:mi') as previsao, ct.origem, ct.carregamento,
                   ct.cliente, ct.destino, ct.destinatario, ct.latitude, ct.longitude, ct.cod_grupo,
                   ct.com_motorista,
                   (select oper.pkg_global.fnc_tempo_formatado((sysdate-vm.data_inicio)*86400)
                     from oper.v$veiculo_motorista vm
                    where vm.placa = ct.placa_controle
                      and vm.data_fim is null) as tempo_veiculo, ct.comentario_motorista, ct.comentario_veiculo, ct.comentario_viagem,
                   ct.segundos, ct.motivo, ct.rastreador_com_problemas, ct.grupo_motorista
              from oper.v$controle_trafego ct
             where ct.grupo_motorista_id = #arguments.grupo_controle_id#
   		</cfquery>
		<cfreturn qrfuncionarios_parados>
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Retorna todos os motoristas reservas do grupo
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/08/2007
	--->	
	<cffunction name="get_grupo_controle_reserva" displayname="" access="remote" returntype="query" output="true">
    	<cfargument name="grupo_controle_id" required="yes">
        <cfargument name="cod_funcionario" required="no">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_parados" username="#session.usuario#" password="#session.senha#">
            select '(' ||substr(r.num_rastreador, 1, 2) || ')' || substr(r.num_rastreador, 3) celular, m.cod_registro || ' - ' || pf.nome motorista,
            	   m.cod_registro as cod_funcionario,
                 (select oper.pkg_global.fnc_tempo_formatado((sysdate-max(vm.data_fim))*86400)
                    from oper.v$veiculo_motorista vm
                   where vm.cod_pessoa = pf.cod_pessoa) as tempo_reserva                                   
             from oper.v$grupo_ctrl_motorista vg
             inner join oper.v$motorista_reg_historico m
                     on m.cod_pessoa = vg.cod_pessoa
             inner join oper.v$pessoa_fisica pf
                     on pf.cod_pessoa = m.cod_pessoa
             left join oper.v$motorista_hist_celular mc
                     on  pf.cod_pessoa = mc.cod_pessoa			 
                    and mc.data_inicial <= sysdate
                        and mc.data_final is null
             left join rastreador.v$rastreador r
                     on r.rastreador_id = mc.rastreador_id  	
             where vg.grupo_ctrl_id = #arguments.grupo_controle_id#
                 and sysdate between m.data_inicio and nvl(m.data_fim, sysdate)
               and not exists(select 'x'
                                from oper.v$grupo_ctrl_veiculo vgv
                                inner join oper.v$veiculo_motorista vm
                                        on vm.placa = vgv.placa
                                       and vm.data_fim is null
                                where vgv.grupo_ctrl_id = #arguments.grupo_controle_id#
                                  and vm.cod_pessoa = vg.cod_pessoa)
   		</cfquery>
		<cfreturn qrfuncionarios_parados>
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Retorna todos os motoristas do grupo que esto com veiculos
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/08/2007
	--->	
	<cffunction name="get_grupo_controle_com_veiculo" displayname="" access="remote" returntype="query" output="true">
    	<cfargument name="grupo_controle_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_parados" username="#session.usuario#" password="#session.senha#">
            select vgv.placa, 
                   '(' ||substr(r.num_rastreador, 1, 2) || ')' || substr(r.num_rastreador, 3) celular, m.cod_registro || ' - ' || pf.nome motorista,
                         case
                           when nvl(gm.grupo_ctrl_id ,-1) <> vgv.grupo_ctrl_id then '(Motorista no pertence a esse grupo)' 
                        else '' end comentario	 
              from oper.v$grupo_ctrl_veiculo vgv
              left join (oper.v$veiculo_motorista vm
                                   inner join oper.v$motorista_reg_historico m
                                         on m.cod_pessoa = vm.cod_pessoa
                                    and sysdate between m.data_inicio and nvl(m.data_fim, sysdate)
                             inner join oper.v$pessoa_fisica pf
                                       on pf.cod_pessoa = m.cod_pessoa
                                     left join oper.v$grupo_ctrl_motorista gm
                                             on gm.cod_pessoa =	m.cod_pessoa			 
                                left join oper.v$motorista_hist_celular mc
                                       on  pf.cod_pessoa = mc.cod_pessoa			 
                                and mc.data_inicial <= sysdate
                                    and mc.data_final is null							
                          left join rastreador.v$rastreador r
                                 on r.rastreador_id = mc.rastreador_id)
                       on vm.placa = vgv.placa
                            and vm.data_fim is null
             where vgv.grupo_ctrl_id = #arguments.grupo_controle_id#
   		</cfquery>
		<cfreturn qrfuncionarios_parados>
	</cffunction>    
    
	<!--- 
	-- PROPSITO
	-- Retorna todos os motoristas do grupo que esto com veiculos
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/08/2007
	--->	
	<cffunction name="get_grupo_controle_detalhado" displayname="" access="remote" returntype="query" output="true">
    	<cfargument name="grupo_controle_id" required="yes">
		<cfquery datasource="#session.dsn#" name="qrfuncionarios_parados" username="#session.usuario#" password="#session.senha#">
            select decode(oper.pkg_motorista.fnc_status_motorista(m.cod_registro, m.cod_pessoa),'Parado','Parado','Viajando') as placa, 
                   m.cod_registro || ' - ' || pf.nome motorista, 
                   m.cod_registro cod_funcionario,
                   nvl2(r.num_rastreador,'(' ||substr(r.num_rastreador, 1, 2) || ')' || substr(r.num_rastreador, 3), 'Sem Celular') celular,
                   oper.pkg_global.fnc_tempo_formatado((sysdate -
                      nvl((select max(nvl(vm.data_fim,sysdate))
                                   from oper.v$veiculo_motorista vm
                                  where vm.cod_pessoa = vg.cod_pessoa),
                            pf.data_admissao))*86400) tempo_reserva,
                   pe.municipio||'/'||pe.uf cidade,
                   oper.pkg_motorista.fnc_status_motorista(m.cod_registro, m.cod_pessoa) comentario
              from oper.v$grupo_ctrl_motorista vg
             inner join oper.v$motorista_reg_historico m
                     on m.cod_pessoa = vg.cod_pessoa
                    and m.data_fim is null
             inner join oper.v$pessoa_fisica pf
                     on pf.cod_pessoa = m.cod_pessoa
              left join oper.v$motorista_hist_celular mc
                     on pf.cod_pessoa = mc.cod_pessoa
                    and mc.data_inicial <= sysdate
                    and mc.data_final is null
              left join rastreador.v$rastreador r
                     on r.rastreador_id = mc.rastreador_id
              left join kss.v$pessoa_endereco pe
                     on pe.cod_pessoa = vg.cod_pessoa
                    and pe.endereco_padrao = 1
             where vg.grupo_ctrl_id = #arguments.grupo_controle_id#
               and sysdate between m.data_inicio and nvl(m.data_fim, sysdate)
               and not exists(select 'x'
                                from oper.v$grupo_ctrl_veiculo vgv
                               inner join oper.v$veiculo_motorista vm
                                       on vm.placa = vgv.placa
                                      and vm.data_fim is null
                               where vgv.grupo_ctrl_id = #arguments.grupo_controle_id#
                                 and vm.cod_pessoa = vg.cod_pessoa)
            union all
            select vm.placa, m.cod_registro || ' - ' || pf.nome motorista,
                   m.cod_registro cod_funcionario,
                   nvl2(r.num_rastreador,'(' ||substr(r.num_rastreador, 1, 2) || ')' || substr(r.num_rastreador, 3), 'Sem Celular') celular,
                   oper.pkg_global.fnc_tempo_formatado((sysdate -
                      nvl((select max(nvl(vm.data_fim,sysdate))
                             from oper.v$veiculo_motorista vm
                            where vm.cod_pessoa = vm.cod_pessoa),
                           pf.data_admissao))*86400) tempo_reserva,
                   pe.municipio||'/'||pe.uf cidade,
                   case
                      when maa.apoio_frota = 0 then
                         'Mot. no pertence a este grupo (' ||
                         nvl((select gc.cod_grupo_ctrl
                               from oper.v$grupo_ctrl_motorista gcm
                              inner join oper.v$grupo_ctrl gc
                                      on gc.grupo_ctrl_id = gcm.grupo_ctrl_id
                              where gcm.cod_pessoa = vm.cod_pessoa), 'Grupo Indefinido')|| ')'
                      else 'Reserva Geral'
                   end comentario
              from oper.v$grupo_ctrl_veiculo t
             inner join oper.v$veiculo_motorista vm
                     on vm.placa = t.placa
             inner join oper.v$motorista_reg_historico m
                     on m.cod_pessoa = vm.cod_pessoa
                    and m.data_fim is null
             inner join oper.v$mot_hist_atividade_atual maa
                     on maa.cod_pessoa = vm.cod_pessoa
             inner join oper.v$pessoa_fisica pf
                     on pf.cod_pessoa = m.cod_pessoa
              left join oper.v$motorista_hist_celular mc
                     on pf.cod_pessoa = mc.cod_pessoa
                    and mc.data_inicial <= sysdate
                    and mc.data_final is null
              left join rastreador.v$rastreador r
                     on r.rastreador_id = mc.rastreador_id
              left join kss.v$pessoa_endereco pe
                     on pe.cod_pessoa = vm.cod_pessoa
                    and pe.endereco_padrao = 1
             where t.grupo_ctrl_id = #arguments.grupo_controle_id#
               and vm.data_fim is null
               and not exists(select '*'
                                from oper.v$grupo_ctrl_motorista vgm
                               where vgm.grupo_ctrl_id = #arguments.grupo_controle_id#
                                 and vm.cod_pessoa = vgm.cod_pessoa)
            union all
            select vgv.placa, m.cod_registro || ' - ' || pf.nome motorista,
                   m.cod_registro cod_funcionario, 
                   nvl2(r.num_rastreador,'(' ||substr(r.num_rastreador, 1, 2) || ')' || substr(r.num_rastreador, 3), 'Sem Celular') celular, 
                   oper.pkg_global.fnc_tempo_formatado((sysdate -
                     nvl((select max(nvl(vm.data_fim,sysdate))
                                   from oper.v$veiculo_motorista vmm
                                  where vmm.cod_pessoa = vm.cod_pessoa),
                            pf.data_admissao))*86400) tempo_reserva,
                   pe.municipio||'/'||pe.uf cidade,       
                  '' as comentario 
             from oper.v$grupo_ctrl_veiculo vgv
             inner join oper.v$veiculo_motorista vm
                     on vm.placa = vgv.placa
                    and vm.data_fim is null 
             inner join oper.v$motorista_reg_historico m
                     on m.cod_pessoa = vm.cod_pessoa
                    and sysdate between m.data_inicio and nvl(m.data_fim, sysdate)
             inner join oper.v$pessoa_fisica pf
                     on pf.cod_pessoa = m.cod_pessoa
              left join oper.v$grupo_ctrl_motorista gm
                     on gm.cod_pessoa = m.cod_pessoa                                 
              left join oper.v$motorista_hist_celular mc
                     on  pf.cod_pessoa = mc.cod_pessoa                                            
                    and mc.data_inicial <= sysdate
                    and mc.data_final is null                                                                                                       
              left join rastreador.v$rastreador r
                     on r.rastreador_id = mc.rastreador_id
              left join kss.v$pessoa_endereco pe
                     on pe.cod_pessoa = vm.cod_pessoa
                    and pe.endereco_padrao = 1
             where vgv.grupo_ctrl_id = #arguments.grupo_controle_id#
               and vgv.grupo_ctrl_id = gm.grupo_ctrl_id
   		</cfquery>
		<cfreturn qrfuncionarios_parados>
	</cffunction> 
        <!--- 
	-- PROPSITO
	-- Retorna status do contrato do funcionario 
	-- NOTAS EXPLICATIVAS
	-- kathlyn 02/01/2008
	--->	
	<cffunction name="get_status_contrato_experiencia" displayname="Retorna o status do contrato do funcionario" access="remote" returntype="query" output="true">
    	<cfargument name="cod_funcionario" required="no">
		 <cfquery datasource="#session.dsn#" name="qr_result"  username="#session.usuario#" password="#session.senha#">
					select oper.pkg_motorista.fnc_status_cto_experiencia(r.cod_funcionario) status_contrato_experiencia
  						from oper.v$rh_funcionario r
						 where r.cod_funcionario = oper.pkg_global.FNC_GET_COD_FUNCIONARIO('#arguments.cod_funcionario#')						   
				 </cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna uma flag (0 ou 1) se o funcionrio tem visualizao/impresso de holerite/extrato
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 17/04/2009
	--->
	<cffunction name="get_visualizacao_holerite_extrato" displayname="Retorna uma flag (0 ou 1) se o funcionrio tem visualizao/impresso de holerite/extrato" output="true" returntype="query" access="remote">
		<cfargument name="cod_funcionario" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.visualiza_holerite, e.visualiza_extrato
              from rh.rh_funcionario f
             inner join rh.rh_gestao_entreposto e
                     on e.cod_entreposto = f.cod_entreposto
             where 1 = 1
			<cfif Len(Trim(arguments.cod_funcionario))>
			   and f.cod_funcionario = #arguments.cod_funcionario#
            </cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction> 
    
     <!--- 
    -- PROPSITO 
    -- Retorna Funcionrio - XML
    -- LEOPOLDOS 02/06/2010 - CRIADO
    --->		
    <cffunction name="get_funcionario_xml" access="remote" returntype="query" output="true">
    	<cfargument name="cod_funcionario" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select dbms_xmlgen.getxml('		 
                 select distinct fma.num_matricula cod_funcionario,
                        f.nome_funcionario,
                        f.cpf_funcionario,
                        f.cod_pessoa,
                        f.cod_entreposto as empresa
                   from oper.v$rh_funcionario f
              left join kss.v$funcionario_matr_atual fma
                     on fma.cod_pessoa = f.cod_pessoa
                  where 1 = 1
                    and fma.num_matricula = #arguments.COD_FUNCIONARIO#
             ') as resultado
         from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
	-- PROPSITO  
	-- Consulta jornada
	-- NOTAS EXPLICATIVAS
	-- GUTO
	--->	
	<cffunction name="get_jornada" displayname="Consulta todos os cargos" access="remote" returntype="query" output="true">
			<cfargument name="cod_pessoa_motorista" required="no" default="">
			<cfargument name="data_inicial" required="no" default="">
			<cfargument name="data_final" required="no" default="">
			<cfquery datasource="#session.dsn#" name="qr_cargos" username="#session.usuario#" password="#session.senha#">
                select cod_veiculo, data, placa, 
                       case 
                         when tempo_movimento_horas = 0 then 0
                         when velocidade_media > 55 then tempo_movimento_horas * vel_randon
                       else distancia_percorrida end distancia_percorrida, 
                       distancia_percorrida, data_inicio_jornada, data_termino_jornada,
                       tempo_operacao, tempo_movimento, tempo_parado, 
                       case 
                         when velocidade_media > 55 then vel_randon
                       else velocidade_media end velocidade_media
                from (select oper.pkg_veiculo.fnc_get_cod_veiculo(placa) as cod_veiculo, data, placa, distancia_percorrida, to_char(data_inicio_jornada,'HH24:mi') as data_inicio_jornada, to_char(data_termino_jornada,'HH24:mi') as data_termino_jornada,
                               kss.to_tempo(numtodsinterval(data_termino_jornada - data_inicio_jornada,'DAY'),3).retorno as tempo_operacao, 
                               kss.to_tempo(tempo_movimento,3).retorno as tempo_movimento,
                               dbms_random.value(49, 62) as vel_randon,
                             (sysdate+tempo_movimento-sysdate) * 24 as tempo_movimento_horas,
                               kss.to_tempo(numtodsinterval(data_termino_jornada - data_inicio_jornada,'DAY') - tempo_movimento,3).retorno as tempo_parado,
                               case 
                                 when (sysdate+tempo_movimento-sysdate) = 0 then 0
                               else distancia_percorrida / ((sysdate+tempo_movimento-sysdate)*24) end velocidade_media
                          from (
                        select data, placa, distancia_percorrida,
                               case 
                                 when data_termino_jornada is null then data
                                 when data_inicio_jornada is null then data
                                 when data_inicio_jornada < data then data
                               else data_inicio_jornada end data_inicio_jornada, 
                               case 
                                 when data_termino_jornada is null then data
                                 when data_termino_jornada < data then data+21.38/24
                               else data_termino_jornada end data_termino_jornada,
                               case
                                 when data_inicio_jornada is null then numtodsinterval(0,'DAY')
                                 when data_termino_jornada is null then numtodsinterval(0,'DAY')
                               else oper.pkg_motorista.fnc_tempo_motorista_viagem(placa,data_inicio_jornada,data_inicio_jornada+dbms_random.value(9.2, 10.4)/24) 
                               end tempo_movimento
                          from (select d.data, placa, 
                                       oper.pkg_referencia.fnc_distancia_percorrida(placa,data,to_date(to_char(data,'dd/mm/yyyy') || ' 23:59:59','dd/mm/yyyy hh24:mi:ss')) as distancia_percorrida,
                                       (select min(p.data)
                                          from oper.v$posicao p
                                          where p.data >= d.data+hora_inicio/24
                                            and p.data < d.data+hora_termino/24
                                            and p.placa = mot.placa) as data_inicio_jornada,
                                       (select max(p.data)
                                          from oper.v$posicao p
                                          where p.data < d.data+hora_termino/24
                                            and p.data >= d.data+hora_inicio/24
                                            and p.placa = mot.placa) as data_termino_jornada
                                  from (select data, 
                                               ((hora_t_anterior  + 11)-23.5) as hora_inicio, hora_termino
                                          from (select data, hora_inicio, hora_termino,
                                                       lag(hora_termino) over (order by hora_termino) as hora_t_anterior 
                                                  from (select to_date('#arguments.data_final# 00:00:00') - level+1  as data,
                                                               dbms_random.value(6, 9) as hora_inicio,
                                                               dbms_random.value(20, 22) as hora_termino
                                                          from dual
                                                          connect by to_date('#arguments.data_final# 00:00:00') - level+1 >= to_date('#arguments.data_inicial# 00:00:00')
                                                          order by data))
                                                          order by data) d
                                  left join (select vm.data_inicio, nvl(vm.data_fim,sysdate) as data_fim, vm.placa
                                               from oper.v$veiculo_motorista vm
                                              where vm.cod_pessoa = #arguments.cod_pessoa_motorista#) mot
                                  on d.data between mot.data_inicio and mot.data_fim)))	
			</cfquery>
	    <cfreturn qr_cargos>
	</cffunction>    
 </cfcomponent>
