<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO
	-- Registra um conhecimento com o numero pr-definido
	-- guto 12/04/2006 18:04:25 - CRIADO
	--->
	<cffunction name='registra_conhecimento' displayname='Registra um conhecimento com o numero pr-definido' access='remote' returntype='Struct' output='false'>;
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REM_RAZAO_SOCIAL' required='yes'>
		<cfargument name='REM_ENDERECO' required='yes'>
		<cfargument name='REM_MUNICIPIO' required='yes'>
		<cfargument name='REM_UF' required='yes'>
		<cfargument name='REM_CEP' required='yes'>
		<cfargument name='REM_CNPJ_CPF' required='yes'>
		<cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_MUNICIPIO' required='yes'>
		<cfargument name='DEST_UF' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_CNPJ_CPF' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COD_CONSIGNATARIO' required='no' default="">
		<cfargument name='CONS_RAZAO_SOCIAL' required='no' default="">
		<cfargument name='CONS_ENDERECO' required='no' default="">
        <cfargument name='CONS_ENDERECO_NUM' required='no' default="">
		<cfargument name='CONS_MUNICIPIO' required='no' default="">
		<cfargument name='CONS_UF' required='no' default="">
		<cfargument name='CONS_CEP' required='no' default="">
		<cfargument name='CONS_CNPJ_CPF' required='no' default="">
		<cfargument name='CONS_INSCRICAO_ESTADUAL' required='no' default="">
        <cfargument name='CONS_BAIRRO' required='no' default="">
        <cfargument name='CONS_MUNICIPIO_ID' required='no' default="">
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='no' default="0">
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='no' default="0" >
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='NOME_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_UF' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='RODAPE' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='CARGA_ID' required='no' default="">
		<cfargument name='COD_CLIENTE_COBRANCA' required='no' default="">
		<cfargument name='COB_RAZAO_SOCIAL' required='no' default="">
		<cfargument name='COB_ENDERECO' required='no' default="">
		<cfargument name='COB_MUNICIPIO' required='no' default="">
		<cfargument name='COB_UF' required='no' default="">
		<cfargument name='COB_CEP' required='no' default="">
		<cfargument name='COB_CNPJ_CPF' required='no' default="">
		<cfargument name='COB_INSCRICAO_ESTADUAL' required='no' default="">
		<cfargument name='PRAZO_ENTREGA' required='no' default="">
		<cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='no' default="">
		<cfargument name='PLACA_TRACAO' required='no' default="">
		<cfargument name='REGRA_FISCAL_ID' required='no' default="1">
		<cfargument name='NUM_LOTE' required='no' default="">
		<cfargument name='TERCEIRO' required='no' default="0">
		<cfargument name='PLACA_REFERENCIA_COMPOSICAO' required='no' default="0">
		
		<cfargument name='COD_REDESPACHO' required='no' default="">
		<cfargument name='RED_RAZAO_SOCIAL' required='no' default="">
		<cfargument name='RED_ENDERECO' required='no' default="">
		<cfargument name='RED_MUNICIPIO' required='no' default="">
		<cfargument name='RED_UF' required='no' default="">
		<cfargument name='RED_CEP' required='no' default="">
		<cfargument name='RED_CNPJ_CPF' required='no' default="">
		<cfargument name='RED_INSCRICAO_ESTADUAL' required='no' default="">
        <cfargument name='RED_MUNICIPIO_ID' required="yes">
		<cfargument name='COLETA_LOGRADOURO' required='no' default="">
		<cfargument name='COLETA_COMPLEMENTO' required='no' default="">
		<cfargument name='COLETA_BAIRRO' required='no' default="">
		<cfargument name='COLETA_CEP' required='no' default="">
		<cfargument name='ENTREGA_LOGRADOURO' required='no' default="">
		<cfargument name='ENTREGA_COMPLEMENTO' required='no' default="">
		<cfargument name='ENTREGA_BAIRRO' required='no' default="">
		<cfargument name='ENTREGA_CEP' required='no' default="">
		
		<cfargument name='CONHECIMENTO_ID_SUB' required='no' default="">
		<cfargument name='NUM_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='SERIE_CONHECIMENTO_SUB_CONTR' required='no' default="">
		
		<cfargument name='IMPRESSO' required='no' default="0">

		<cfargument name='VEICULO_PROPRIETARIO' required='no' default="">

		<cfargument name='VALOR_SERVICO_AGREGADO' required='no' default="">
		<cfargument name='VALOR_PEDAGIO_AGREGADO' required='no' default="">
		<cfargument name='VALOR_DESCARGA_AGREGADO' required='no' default="">
		<cfargument name='VALOR_ADIANTAMENTO_AGREGADO' required='no' default="">
		<cfargument name='OBSERVACAO_AGREGADO' required='no' default="">
		
		<cfargument name='CFOP' required='no' default="">
		<cfargument name='CFOP_ID' required='no' default="">
		<cfargument name='NATUREZA_OPERACAO' required='no' default="">
		<cfargument name='FUNDAMENTACAO_LEGAL' required='no' default="">
		<cfargument name='COD_NEGOCIADOR' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
        <cfargument name='OPERACAO_ID' required='no' default="">
        <cfargument name='CTRC_FATURAMENTO' required='no' default="0">
        
        <cfif trim(arguments.m3) eq ''>
			<cfset arguments.m3 = 0>
		</cfif>
		<cftry>
			<cftransaction action='begin'>
				<cfif arguments.terceiro eq 1>
					<cfset v_composicao = arguments.placa_tracao>
					<cfloop list="#arguments.placa_referencia_composicao#" index="v_pl">
						<cfset v_composicao = ListAppend(v_composicao,v_pl,',')>
					</cfloop>
					<cfscript>
						conn = CreateComponent("modulos.nfes._componentes.manipulacao.cfc_controle_trafego");
						romaneio = conn.gera_romaneio_terceiro(	NUM_ROMANEIO		= arguments.num_romaneio,
																COMPOSICAO			= v_composicao,
																DATA_INICIO			= arguments.data_emissao,
																OPERACAO_ID			= arguments.operacao_id,
																VIAGEM_CARGA_ID		= arguments.viagem_carga_id,
																COD_MOTORISTA		= arguments.cod_motorista,
																COD_REMETENTE		= arguments.cod_remetente,
																COLETA_MUNICIPIO_ID	= arguments.coleta_municipio_id,
																COD_DESTINATARIO	= arguments.cod_destinatario,
																ENTREGA_MUNICIPIO_ID= arguments.red_municipio_id,
																VOLUME				= arguments.volume,
																PESO				= arguments.peso,
																M3					= arguments.m3,
																FRETE_VALOR			= arguments.frete_valor,
																NUM_NATUREZA		= arguments.num_natureza,
																NUM_ESPECIE			= arguments.num_especie,
																COD_UNIDADE			= arguments.cod_unidade,
																FRETE_EM			= arguments.frete_em,
																DESPACHO			= arguments.despacho,
																OBSERVACAO			= arguments.observacao
																);
					</cfscript>
					<cfif romaneio.erro>
						<cfthrow object="#romaneio.mensagem#">
					<cfelse>
						<cfset arguments.num_romaneio 	= romaneio.num_romaneio>
						<cfset arguments.item_id 		= romaneio.item_id>
					</cfif>
				</cfif>
				
				<!---Inserindo uma nova entrega--->
				<cfif (arguments.item_id eq 0 or not Len(Trim(arguments.item_id))) and Len(Trim(arguments.placa_tracao)) and Len(Trim(arguments.num_romaneio))>
					<cfscript>
						conn = CreateObject("component","modulos.nfes._componentes.manipulacao.cfc_controle_trafego");
						set_item = conn.ins_romaneio_item	(num_romaneio		= arguments.num_romaneio
															,num_lote			= arguments.num_lote
															,volume				= arguments.volume
															,cod_unidade		= arguments.cod_unidade
															,peso				= arguments.peso
															,m3					= arguments.m3
															,valor_frete		= arguments.frete_valor
															,cod_remetente		= arguments.cod_remetente
															,redespacho			= 0
															,rem_municipio_id	= arguments.rem_municipio_id
															,cod_destinatario	= arguments.cod_destinatario
															,dest_municipio_id	= arguments.dest_municipio_id
															,valor_frete_liquido= 0
															,despacho			= 0
															,observacao			= ''
															,manifesto_id		= ''
															,ordem				= arguments.ENTREGAS
															,data_previsao		= ''
															);
						
					</cfscript>
					<cfset arguments.item_id = set_item.item_id>
				</cfif>
	
				<cfif Len(Trim(arguments.placa_tracao)) and Len(Trim(arguments.num_romaneio))>
					<cfscript>
						conn = CreateObject("component","modulos.nfes._componentes.manipulacao.cfc_controle_trafego");
						ins_rota = conn.ins_itinerario_item_romaneio(num_romaneio = arguments.num_romaneio,
																	 item_id	  = arguments.item_id,
																	 municipio_origem_id = arguments.coleta_municipio_id,
																	 municipio_destino_id = arguments.red_municipio_id);
					</cfscript>
	
					<cfif ins_rota.erro>
						<cfthrow object="#ins_rota.mensagem#">
					</cfif>
				</cfif>

				<cfif arguments.NUM_CONHECIMENTO eq -1>					 
					<!---Insere o CTRC com o numero definido--->
					<cfscript>
						retorno = this.ins_conhecimento_private(argumentCollection = arguments);
					</cfscript>
				<cfelse>
					<!---Registra o CTRC com o numero definido--->
					<cfscript>
						retorno = this.registra_conhecimento_private(argumentCollection = arguments);
					</cfscript>
				</cfif>
				
				<cfset retorno.prestacao_servico = 0>
				<!--- Insere Notas fiscais --->
				<cfscript>
					v_numero 	   = this.ListaToArray    (lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
					v_data_emissao = this.ListaToArray    (lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
					v_serie 	   = this.ListaToArray    (lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
					v_sub_serie    = this.ListaToArray    (lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
					v_modelo       = this.ListaToArray    (lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
					v_valor		   = this.ListaToArray    (lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
					v_valor_segurado  = this.ListaToArray (lista = arguments, variavel = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
					v_peso            = this.ListaToArray    (lista = arguments, variavel = "NOTA_PESO_NOTAS_FISCAIS");
					v_peso_cobrado         = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
					
					v_ordem_compra         = this.ListaToArray(lista = arguments, variavel = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
					
					v_qtde_volume          = this.ListaToArray(lista = arguments, variavel = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
					v_cod_unidade          = this.ListaToArray(lista = arguments, variavel = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
					v_m3                   = this.ListaToArray(lista = arguments, variavel = 'NOTA_M3_NOTAS_FISCAIS');
					v_peso_cubado          = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
					v_peso_kg_convertido   = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_KG_CONVERTIDO_NOTAS_FISCAIS');
					v_num_natureza         = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
					v_natureza             = this.ListaToArray(lista = arguments, variavel = 'NOTA_NATUREZA_NOTAS_FISCAIS');
					v_complemento          = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
					v_num_especie          = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
					v_especie              = this.ListaToArray(lista = arguments, variavel = 'NOTA_ESPECIE_NOTAS_FISCAIS');
					v_altura               = this.ListaToArray(lista = arguments, variavel = 'NOTA_ALTURA_NOTAS_FISCAIS');
					v_largura              = this.ListaToArray(lista = arguments, variavel = 'NOTA_LARGURA_NOTAS_FISCAIS');
					v_comprimento          = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
					v_cubagem              = this.ListaToArray(lista = arguments, variavel = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
						
						
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
					<cfscript>
						if (ArrayLen(v_numero) neq ArrayLen(v_ordem_compra)) {
							v_ordem = '';
						} else {
							v_ordem = v_ordem_compra[count];
						}
//						if (ArrayLen(v_peso_cobrado) neq ArrayLen(v_ordem_compra)) {
//							v_peso_cobrado_item = v_peso[count];
//						} else {
							v_peso_cobrado_item = v_peso_cobrado[count];
//						}
						
						if(ArrayLen(v_qtde_volume) eq 0) {
							this.ins_nf_conhecimento(conhecimento_id = retorno.conhecimento_id,
													 numero			 = v_numero[count],
													 data_emissao	 = v_data_emissao[count],
													 modelo 		 = v_modelo[count],
													 serie 			 = v_serie[count],
													 sub_serie 		 = v_sub_serie[count],
													 valor_total 	 = v_valor[count],
													 valor_segurado  = v_valor[count],
													 peso            = v_peso[count],
													 peso_cobrado	 = v_peso_cobrado_item,
													 ordem_compra_cliente = v_ordem);
						} else {
							this.ins_nf_conhecimento(	conhecimento_id      = retorno.conhecimento_id,
														numero			     = v_numero[count],
														data_emissao	     = v_data_emissao[count],
														modelo 		         = v_modelo[count],
														serie 			     = v_serie[count],
														sub_serie 		     = v_sub_serie[count],
														valor_total 	     = v_valor[count],
														valor_segurado       = v_valor_segurado[count],
														peso                 = v_peso[count],
														ordem_compra_cliente = v_ordem,
														qtde_volume 		 = v_qtde_volume[count],
														cod_unidade 		 = v_cod_unidade[count],
														m3 				     = v_m3[count],
														peso_cubado 		 = v_peso_cubado[count],
														peso_kg_convertido   = v_peso_kg_convertido[count],
														num_natureza 		 = v_num_natureza[count],
														natureza 			 = v_natureza[count],
														complemento          = v_complemento[count],
														num_especie          = v_num_especie[count],
														especie              = v_especie[count],
														altura               = v_altura[count],
														largura              = v_largura[count],
														comprimento          = v_comprimento[count],
														cubagem              = v_cubagem[count],
														peso_cobrado         = v_peso_cobrado[count]);
						}
					</cfscript>
				</cfloop>

                <!---Insere vinculo com a tabela de Frete--->
                <cfif IsDefined("arguments.COD_TABELA_FRETE_RET") and  Len(Trim(arguments.COD_TABELA_FRETE_RET))>
	                <cfscript>
                    	ins_ctrc_tf = this.ins_conhecimento_tf(CONHECIMENTO_ID = retorno.CONHECIMENTO_ID,
						                                       COD_TABELA_FRETE = arguments.COD_TABELA_FRETE_RET,
															   LOTACAO			= arguments.FLAG_LOTACAO,
															   URGENTE		    = arguments.FLAG_URGENTE,
															   TRUCK            = arguments.FLAG_TRUCK,
															   COLETA           = arguments.FLAG_COLETA,
															   NUM_AJUDANTES    = arguments.NUM_AJUDANTES,
															   NUM_ENTREGAS     = arguments.NUM_ENTREGAS_PAGAS,
															   MUNICIPIO_ULT_ENTREGA = arguments.MUNICIPIO_ULT_ENTREGA_ID);
					</cfscript>
                    <cfif ins_ctrc_tf.erro>
                    	<cfthrow object="#ins_ctrc_tf.mensagem#">
                    </cfif>
                </cfif>                
				
				<!--- Para Agregados insere o PS --->
				<cfif arguments.veiculo_proprietario eq 2>
					<cfif len(trim(arguments.valor_servico_agregado)) and arguments.valor_servico_agregado gt 0>
						<cfscript>
							set_agregado = this.ins_agregado_adto(cod_pessoa   			= arguments.COD_PROPRIETARIO,
																 num_romaneio 			= arguments.NUM_ROMANEIO,
																 conhecimento_id      	= retorno.conhecimento_id,
																 placa                	= arguments.PLACA_CONTROLE,
																 cod_pessoa_motorista 	= arguments.COD_MOTORISTA,
																 data_lancamento      	= arguments.DATA_EMISSAO,
																 valor_servico 			= arguments.VALOR_SERVICO_AGREGADO,
																 pedagio       			= arguments.VALOR_PEDAGIO_AGREGADO,
																 pedagio_semparar       = arguments.VALOR_PEDAGIO_SEMPARAR,
																 despesa       			= arguments.VALOR_DESCARGA_AGREGADO,
																 adiantamento  			= arguments.VALOR_ADIANTAMENTO_AGREGADO,
																 observacao    			= arguments.OBSERVACAO_AGREGADO,
																 soma_pedagio			= arguments.AGREGADO_SOMA_PEDAGIO,
																 soma_despesa			= arguments.AGREGADO_SOMA_DESPESA);
						</cfscript>
						<cfif set_agregado.erro>
							<cfthrow object="#set_agregado.mensagem#">
						</cfif>
						<cfset retorno.prestacao_servico = 1>
					</cfif>
				</cfif>
                
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfif arguments.EMITE_TABELA_FRETE eq 1>
                	<cfscript>
						if(IsDefined('arguments.PLACA_REFERENCIA_INTERNA')) {
							v_placa_referencia_interna = Replace(arguments.PLACA_REFERENCIA_INTERNA, ',', ' > ', 'all');
						}
						else {
							v_placa_referencia_interna = '';
						}
						
						conn_cons_tf = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
						qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id(ORIGEM_MUNICIPIO_ID  = arguments.COLETA_MUNICIPIO_ID,
																					DESTINO_MUNICIPIO_ID = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.red_municipio_id), de(arguments.MUNICIPIO_ULT_ENTREGA_ID)),
																					COD_NEGOCIADOR       = arguments.COD_NEGOCIADOR,
																					NUM_NATUREZA		 = arguments.NUM_NATUREZA,
																					COMPOSICAO			 = arguments.PLACA_TRACAO & ' > ' & v_placa_referencia_interna);
					</cfscript>
					<cfif qrTabelaFreteRotaId.erro>
						<cfthrow object="#qrTabelaFreteRotaId.mensagem#">
					</cfif>
					
					<cfscript>
						conn_cons_doc = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
						qrDadosFiscais = conn_cons_doc.get_ctrc_dados_fiscais(NUM_ROMANEIO 		   = arguments.NUM_ROMANEIO,
																	 		  ITEM_ID 			   = arguments.ITEM_ID,
																			  COD_DESTINATARIO 	   = arguments.COD_DESTINATARIO,
																			  PRODUTO_ID  		   = arguments.NUM_PRODUTO,
																			  PAGO_POR 			   = arguments.PAGADOR,
																			  COLETA_UF 		   = arguments.COLETA_UF,
																			  ENTREGA_UF 		   = arguments.RED_UF,
																			  ST_ICMS_ID 		   = arguments.ST_ICMS_ID,
																			  COD_REMETENTE 	   = arguments.COD_REMETENTE,
																			  REGRA_FISCAL_ID 	   = arguments.REGRA_FISCAL,
																			  COB_UF 			   = arguments.COB_UF,
																			  COLETA_MUNICIPIO_ID  = arguments.COLETA_MUNICIPIO_ID,
																			  ENTREGA_MUNICIPIO_ID = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.red_municipio_id), de(arguments.MUNICIPIO_ULT_ENTREGA_ID)),
																			  VIAGEM_CARGA_ID 	   = arguments.VIAGEM_CARGA_ID,
																			  COD_CLIENTE_COBRANCA = arguments.COD_CLIENTE_COBRANCA,
																			  UF_FILIAL 		   = arguments.UF_FILIAL_EMISSAO,
																			  NOTA_FISCAL 		   = 0);
					</cfscript>
					<cfif qrDadosFiscais.erro>
						<cfthrow object="#qrDadosFiscais.mensagem#">
					</cfif>
                    
                    <cfscript>
						conn_cons_vei = CreateComponent("_transportes.consulta.cfc_veiculo");
						qrNumeroEixos = conn_cons_vei.get_numero_eixos_composicao(PLACA = arguments.PLACA_TRACAO & ' > ' & v_placa_referencia_interna);
					</cfscript>
					<cfif qrNumeroEixos.erro>
						<cfthrow object="#qrNumeroEixos.mensagem#">
					</cfif>
                    
                    <cfscript>
						// Constantes
						arguments.CONSTANTE_VIAGEM_CARGA_ID		  = arguments.VIAGEM_CARGA_ID;
						arguments.CONSTANTE_PESO_BRUTO            = ArraySum(v_peso_kg_convertido);
						arguments.CONSTANTE_PESO_COBRADO          = ArraySum(v_peso_cobrado);
						arguments.CONSTANTE_VALOR_MERCADORIA      = ArraySum(v_valor);
						arguments.CONSTANTE_MUNICIPIO_ID_ORIGEM   = arguments.COLETA_MUNICIPIO_ID;
						arguments.CONSTANTE_MUNICIPIO_ID_DESTINO  = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.red_municipio_id), de(arguments.MUNICIPIO_ULT_ENTREGA_ID));
						arguments.CONSTANTE_FRETE_PROPRIO		  = qrDadosFiscais.FRETE_PROPRIO;
						arguments.CONSTANTE_UF_TOMADOR			  = qrDadosFiscais.TOMADOR_UF;
						arguments.CONSTANTE_COD_ATIVIDADE_TOMADOR = qrDadosFiscais.COD_ATIVIDADE_TOMADOR;
						arguments.CONSTANTE_ST_ICMS_ID			  = Trim(arguments.ST_ICMS_ID);
						arguments.CONSTANTE_PLACA_TRACAO	 	  = arguments.PLACA_TRACAO;
						
						if(v_placa_referencia_interna eq '') {
							arguments.CONSTANTE_PLACA_CARRETA = '';
						}
						else {
							arguments.CONSTANTE_PLACA_CARRETA = ListGetAt(v_placa_referencia_interna, 1, ' > ');
						}
						
						arguments.CONSTANTE_NRO_EIXOS = qrNumeroEixos.EIXOS;
						// ----------
					</cfscript>
                    
                    <cfscript>
						qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						qrConstante 	  = conn_cons_tf.get_constante();
						qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						
						conn_manip_tf = CreateComponent("modulos.nfes._componentes.manipulacao.comercial.cfc_tabela_frete");
					</cfscript>
					
					<cfloop query="qrConstante">
						<cfscript>
							ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
														  		   VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
						</cfscript>
						<cfif ret_cons.erro>
							<cfthrow object="#ret_cons.mensagem#">
						</cfif>
					</cfloop>
					
					<cfscript>
						ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
														 		  VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_cons_tf.erro>
						<cfthrow object="#ret_cons_tf.mensagem#">
					</cfif>
					
					<cfscript>
						ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
														  		   VALOR		 = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
					</cfscript>
					<cfif ret_cons_tfr.erro>
						<cfthrow object="#ret_cons_tfr.mensagem#">
					</cfif>
					
					<cfloop query="qrVariavel">
						<cfscript>
							ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
																	 		  TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID,
																	 		  TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 		  VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					</cfloop>
                    
                    <cfscript>
						ret_calc = this.calcula_ctrc_tabela_frete(CONHECIMENTO_ID = retorno.CONHECIMENTO_ID,
																  TABELA_FRETE_ID = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_calc.erro>
						<cfthrow object="#ret_calc.mensagem#">
					</cfif>
                </cfif>
                <!--- /// --->
                
				<cfset retorno.num_romaneio = arguments.num_romaneio>
				<cfset retorno.item_id = arguments.item_id>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conhecimento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	



	<!--- 
	-- PROPSITO
	-- Registra um conhecimento
	-- guto 19/04/2006 10:49:20 - CRIADO
	--->
	<cffunction name='registra_conhecimento_private' displayname='Registra um conhecimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='IMPRESSO' required='no' default="">
		<cfargument name='CANCELADO' required='no' default="">
		<cfargument name='CARGA_ID' required='no' default="">
		<cfif IsDefined("arguments.VALOR_ICMS_SUBSTIT") and not Len(Trim(arguments.VALOR_ICMS_SUBSTIT))> 
			<cfset arguments.VALOR_ICMS_SUBSTIT = 0>
		</cfif>
        <cfif arguments.impresso eq 1>
        	<cfset arguments.impresso_em = lsdateformat(now())&' '&timeformat(now(),'HH:MM:SS')>
        <cfelse>
        	<cfset arguments.impresso_em = ''>
        </cfif>
        <cfif arguments.cancelado eq 1>
        	<cfset arguments.cancelado_em = lsdateformat(now())&' '&timeformat(now(),'HH:MM:SS')>
        <cfelse>
        	<cfset arguments.cancelado_em = ''>
        </cfif>
        <cfif len(trim(arguments.carga_id))>
         	<cfset arguments.tipo_venda = 2>
        <cfelse>
        	<cfset arguments.tipo_venda = 1>
        </cfif>
		<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_registra_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_CONHECIMENTO'  value='#arguments.NUM_CONHECIMENTO#' variable='retorno.NUM_CONHECIMENTO'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
			<!---<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#session.COD_PESSOA#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#session.COD_DEPARTAMENTO#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#session.COD_SETOR#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#session.COD_CENTRO_CUSTO#'>--->
            
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#' null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#' null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#' null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#' null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
            
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' variable='retorno.DATA_EMISSAO' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='0' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#trim(arguments.ST_ICMS_ID)#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_RAZAO_SOCIAL'  value='#arguments.REM_RAZAO_SOCIAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO'  value='#Left(arguments.REM_ENDERECO,60)#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_MUNICIPIO'  value='#arguments.REM_MUNICIPIO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_UF'  value='#arguments.REM_UF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CNPJ_CPF'  value='#arguments.REM_CNPJ_CPF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_INSCRICAO_ESTADUAL'  value='#arguments.REM_INSCRICAO_ESTADUAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#Left(arguments.DEST_ENDERECO,60)#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONSIGNATARIO' value='#arguments.COD_CONSIGNATARIO#'  null='#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_RAZAO_SOCIAL'  value='#arguments.CONS_RAZAO_SOCIAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO'  value='#arguments.CONS_ENDERECO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_MUNICIPIO'  value='#arguments.CONS_MUNICIPIO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_UF'  value='#arguments.CONS_UF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CEP'  value='#arguments.CONS_CEP#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CNPJ_CPF'  value='#arguments.CONS_CNPJ_CPF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_INSCRICAO_ESTADUAL' value='#arguments.CONS_INSCRICAO_ESTADUAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REDESPACHO' value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_RAZAO_SOCIAL'  value='#arguments.red_razao_social#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO'  value='#arguments.red_endereco#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_MUNICIPIO'  value='#arguments.red_municipio#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_UF'  value='#arguments.red_uf#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CEP'  value='#arguments.red_cep#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CNPJ_CPF'  value='#arguments.red_cnpj_cpf#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_INSCRICAO_ESTADUAL'  value='#arguments.red_inscricao_estadual#' >
			<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.coleta_logradouro#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.coleta_complemento#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.coleta_bairro#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.coleta_cep#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_UF'  value='#arguments.COLETA_UF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.RED_ENDERECO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.entrega_complemento#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.RED_BAIRRO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.RED_CEP#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_UF'  value='#arguments.RED_UF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA_REFERENCIA#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_MOTORISTA'  value='#arguments.NOME_MOTORISTA#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_CNPJ_CPF'  value='#arguments.PROP_CNPJ_CPF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_RAZAO_SOCIAL'  value='#arguments.PROP_RAZAO_SOCIAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_ENDERECO'  value='#arguments.PROP_ENDERECO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_UF'  value='#trim(arguments.PROP_UF)#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_CANCELADO' value='#arguments.cancelado_em#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_IMPRESSO'  value='#arguments.impresso_em#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RODAPE'  value='#arguments.RODAPE#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTRADA_DADOS'  value='2'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_COMPLEMENTO'  value='0'>
			<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID' variable='retorno.CONHECIMENTO_ID'  >
			<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
			<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_tem_nota" value="1">
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.red_municipio_id#'  null='#iif(len(trim(arguments.red_municipio_id)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE_COBRANCA'  value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_RAZAO_SOCIAL'  value='#arguments.COB_RAZAO_SOCIAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_ENDERECO'  value='#arguments.COB_ENDERECO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_MUNICIPIO'  value='#arguments.COB_MUNICIPIO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_UF'  value='#arguments.COB_UF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_CEP'  value='#arguments.COB_CEP#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_CNPJ_CPF'  value='#arguments.COB_CNPJ_CPF#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_INSCRICAO_ESTADUAL'  value='#arguments.COB_INSCRICAO_ESTADUAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRAZO_ENTREGA'  value='#arguments.PRAZO_ENTREGA#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA_GERENCIAL'  value='#arguments.COD_ORGANOGRAMA_GERENCIAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REGRA_FISCAL_ID'  value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_TRACAO'  value='#arguments.PLACA_TRACAO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID_SUB_CONTR'  value='#arguments.CONHECIMENTO_ID_SUB#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_SUB)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REDUCAO_BASE_ICMS' null="yes">
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REDUCAO_BASE_ICMS_SUBSTIT' null="yes">
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS_SUBSTIT' null="yes">
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS_SUBSTIT' null="yes">
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_PRESUMIDO' null="yes">
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_CONHECIMENTO_SUB_CONTR'  value='#arguments.NUM_CONHECIMENTO_SUB_CONTR#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO_SUB_CONTR)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE_CONHECIMENTO_SUB_CONTR'  value='#arguments.SERIE_CONHECIMENTO_SUB_CONTR#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ISS' null="yes">
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ISS' null="yes">
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ISS' null="yes">
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_FATURAMENTO' null="yes">
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL'  value='#arguments.FUNDAMENTACAO_LEGAL#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO_REAL'  value='#arguments.PESO_KG#'  null='#iif(len(trim(arguments.PESO_KG)), de('no'), de('yes'))#'>


			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_VENDA'  value='#arguments.TIPO_VENDA#'  null='#iif(len(trim(arguments.TIPO_VENDA)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FATURADO'  value=''  null='yes'>

			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO_NUM'  value='#arguments.REM_ENDERECO_NUM#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_BAIRRO'  value='#arguments.REM_BAIRRO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>

			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO_NUM'  value='#arguments.DEST_ENDERECO_NUM#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>

			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO_NUM'  value='#arguments.CONS_ENDERECO_NUM#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_BAIRRO'  value='#arguments.CONS_BAIRRO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONS_MUNICIPIO_ID'  value='#arguments.CONS_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.CONS_MUNICIPIO_ID)), de('no'), de('yes'))#'>

			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO_NUM'  value='#arguments.RED_ENDERECO_NUM#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_BAIRRO'  value='#arguments.RED_BAIRRO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RED_MUNICIPIO_ID'  value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>

			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_ENDERECO_NUM'  value='#arguments.COB_ENDERECO_NUM#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_BAIRRO'  value='#arguments.COB_BAIRRO#' >
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COB_MUNICIPIO_ID'  value='#arguments.COB_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COB_MUNICIPIO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CTRC_FATURAMENTO'  value='#arguments.CTRC_FATURAMENTO#'  null='#iif(len(trim(arguments.CTRC_FATURAMENTO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANIZACIONAL'  value='#arguments.COD_ORGANIZACIONAL#' >
		</cfstoredproc>
		<cfreturn retorno>
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere nota fiscal ao conhecimento
	-- cristofer 22/11/2006 10:24:53 - CRIADO
	--->
	<cffunction name='ins_nf_conhecimento' displayname='Insere nota fiscal ao conhecimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUB_SERIE' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='VALOR_SEGURADO' required='yes'>
		<cfargument name='ORDEM_COMPRA_CLIENTE' required='no' default="">
		<cfargument name='PESO' required='no' default="0">
		<cfargument name='PESO_CUBADO' required='no' default="">
		<cfargument name='PESO_COBRADO' required='no' default="">
		<cfargument name='QTDE_VOLUME' required='no' default="1">
		<cfargument name='ALTURA' required='no' default="">
		<cfargument name='COMPRIMENTO' required='no' default="">
		<cfargument name='LARGURA' required='no' default="">
		<cfargument name='M3' required='no' default="">
		<cfargument name='CUBAGEM' required='no' default="">
		<cfargument name='NUM_NATUREZA' required='no' default="">
		<cfargument name='COMPLEMENTO' required='no' default="">
		<cfargument name='NUM_ESPECIE' required='no' default="">
		<cfargument name='COD_UNIDADE' required='no' default="">
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ins_nf_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUMERO'  value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODELO'  value='#arguments.MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUB_SERIE'  value='#arguments.SUB_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_SEGURADO'  value='#arguments.VALOR_SEGURADO#'  null='#iif(len(trim(arguments.VALOR_SEGURADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ORDEM_COMPRA_CLIENTE'  value='#arguments.ORDEM_COMPRA_CLIENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO_CUBADO'  value='#arguments.PESO_CUBADO#'  null='#iif(len(trim(arguments.PESO_CUBADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO_COBRADO'  value='#arguments.PESO_COBRADO#'  null='#iif(len(trim(arguments.PESO_COBRADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COMPRIMENTO'  value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CUBAGEM'  value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um nota fiscal vinculada a um conhecimento
	-- guto 19/04/2006 10:55:48 - CRIADO
	--->
	<cffunction name='del_nf_conhecimento' displayname='Exclui um nota fiscal vinculada a um conhecimento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_del_nf_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUMERO'  value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere adiantamento para o agregado
	-- guto 25/10/2006 15:44:36 - CRIADO
	--->
	<cffunction name='ins_agregado_adto' displayname='Insere adiantamento para o agregado' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='no' default="">
		<cfargument name='MANIFESTO_ID' required='no' default="">
		<cfargument name='PLACA' required='yes'>
		<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
		<cfargument name='DATA_LANCAMENTO' required='yes'>
		<cfargument name='VALOR_SERVICO' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='PEDAGIO_SEMPARAR' required='yes'>
		<cfargument name='DESPESA' required='yes'>
		<cfargument name='ADIANTAMENTO' required='yes'>
		<cfargument name='DESCARGA_POR_CONTA' required='no' default="0">
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='SOMA_PEDAGIO' required='no' default="0">
		<cfargument name='SOMA_DESPESA' required='no' default="0">
		<cftry>
				<cfstoredproc procedure='oper.pkg_agregado.prc_ins_agregado_adto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PS_ID' null='yes' variable="retorno.ps_id">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_MOTORISTA'  value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_LANCAMENTO'  value='#arguments.DATA_LANCAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_SERVICO'  value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO_SEMPARAR'  value='#arguments.PEDAGIO_SEMPARAR#'  null='#iif(len(trim(arguments.PEDAGIO_SEMPARAR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPESA'  value='#arguments.DESPESA#'  null='#iif(len(trim(arguments.DESPESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ADIANTAMENTO'  value='#arguments.ADIANTAMENTO#'  null='#iif(len(trim(arguments.ADIANTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCARGA_POR_CONTA'  value='#arguments.DESCARGA_POR_CONTA#'  null='#iif(len(trim(arguments.DESCARGA_POR_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_EMITENTE'  value='#session.COD_PESSOA_USUARIO#'  null='#iif(len(trim(session.COD_PESSOA_USUARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MANIFESTO_ID'  value='#arguments.MANIFESTO_ID#'  null='#iif(len(trim(arguments.MANIFESTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SOMA_PEDAGIO'  value='#arguments.SOMA_PEDAGIO#'  null='#iif(len(trim(arguments.SOMA_PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SOMA_DESPESA'  value='#arguments.SOMA_DESPESA#'  null='#iif(len(trim(arguments.SOMA_DESPESA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('PS Inserido com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>		
	
	<!--- 
	-- PROPSITO
	-- Altera os dados do conhecimento
	-- cristofer 07/12/2006 19:36:14 - CRIADO
	--->
	<cffunction name='upd_conhecimento' displayname='Altera os dados do conhecimento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='CONHECIMENTO_COMPLEMENTO' required='no' default="0">
		<cfargument name='SERIE' required='yes'>
		<cfargument name='ITEM_ID' required='no' default="">
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='CFOP' required='yes'>
		<cfargument name='NATUREZA_OPERACAO' required='yes'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='REM_RAZAO_SOCIAL' required='yes'>
		<cfargument name='REM_ENDERECO' required='yes'>
		<cfargument name='REM_MUNICIPIO' required='yes'>
		<cfargument name='REM_UF' required='yes'>
		<cfargument name='REM_CEP' required='yes'>
		<cfargument name='REM_CNPJ_CPF' required='yes'>
		<cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_MUNICIPIO' required='yes'>
		<cfargument name='DEST_UF' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_CNPJ_CPF' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COD_CONSIGNATARIO' required='yes'>
		<cfargument name='CONS_RAZAO_SOCIAL' required='yes'>
		<cfargument name='CONS_ENDERECO' required='yes'>
        <cfargument name='CONS_MUNICIPIO' required='yes'>
		<cfargument name='CONS_UF' required='yes'>
		<cfargument name='CONS_CEP' required='yes'>
		<cfargument name='CONS_CNPJ_CPF' required='yes'>
		<cfargument name='CONS_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COD_REDESPACHO' required='yes'>
		<cfargument name='RED_RAZAO_SOCIAL' required='yes'>
		<cfargument name='RED_ENDERECO' required='yes'>
		<cfargument name='RED_MUNICIPIO' required='yes'>
		<cfargument name='RED_UF' required='yes'>
		<cfargument name='RED_CEP' required='yes'>
		<cfargument name='RED_CNPJ_CPF' required='yes'>
		<cfargument name='RED_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COLETA_LOGRADOURO' required='yes'>
		<cfargument name='COLETA_COMPLEMENTO' required='yes'>
		<cfargument name='COLETA_BAIRRO' required='yes'>
		<cfargument name='COLETA_CEP' required='yes'>
		<cfargument name='COLETA_COD_UF' required='no' default="">
		<cfargument name='COLETA_COD_MUNICIPIO' required='no' default="">
		<cfargument name='COLETA_COD_DISTRITO' required='no' default="">
		<cfargument name='COLETA_COD_DV' required='no' default="">
		<cfargument name='ENTREGA_LOGRADOURO' required='yes'>
		<cfargument name='ENTREGA_COMPLEMENTO' required='yes'>
		<cfargument name='ENTREGA_BAIRRO' required='yes'>
		<cfargument name='ENTREGA_CEP' required='yes'>
		<cfargument name='ENTREGA_COD_UF' required='no' default="">
		<cfargument name='ENTREGA_COD_MUNICIPIO' required='no' default="">
		<cfargument name='ENTREGA_COD_DISTRITO' required='no' default="">
		<cfargument name='ENTREGA_COD_DV' required='no' default="">
		<cfargument name='PLACA_REFERENCIA' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='NOME_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_UF' required='yes'>
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='IMPRESSO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='RODAPE' required='yes'>
		<cfargument name='ENTRADA_DADOS' required='yes'>
		<cfargument name='CORRECAO' required='yes'>
		<cfargument name='TEM_NOTA' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='COB_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COB_ENDERECO' required='yes'>
		<cfargument name='COB_MUNICIPIO' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COB_CEP' required='yes'>
		<cfargument name='COB_CNPJ_CPF' required='yes'>
		<cfargument name='COB_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='PRAZO_ENTREGA' required='yes'>
		<cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='CONHECIMENTO_ID_SUB' required='no' default="">
		<cfargument name='NUM_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='SERIE_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='PESO_REAL' required='no' default="">
        <cfargument name='NUM_LOTE' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
			
				<!---Verifica se o o veculo  de terceiro --->
				<cfquery name="qr_proprietario" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
					select oper.pkg_veiculo.FNC_VEICULO_PROPRIETARIO('#arguments.PLACA_TRACAO#') as proprietario
					  from dual
				</cfquery>	
				
				<!---Inserindo uma nova entrega--->
				<cfif not Len(Trim(arguments.NUM_ROMANEIO)) and Len(Trim(arguments.placa_tracao)) and qr_proprietario.proprietario neq 3 >
					<!---Verifica se o conjunto possui romaneio em aberto--->
					<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
						select r.num_romaneio, roo.cod_pessoa_filial
						  from oper.v$romaneio roo
						 inner join oper.v$romaneio_hist_veiculo r
						         on roo.num_romaneio = r.num_romaneio
						 where r.placa_controle = '#arguments.PLACA_TRACAO#'
						   and r.placa_referencia = '#arguments.PLACA_REFERENCIA#'
						   and r.DATA_TERMINO is null						   
					</cfquery>

					<!---Verifica se o romaneio do veculo pertence a filial--->
					<cfif qr_result.COD_PESSOA_FILIAL neq session.cod_pessoa and qr_proprietario.proprietario neq 3>
						<cfthrow detail="O romaneio atual do veculo pertence a outra filial. Verifique os dados ou destine o veculo.">
					</cfif>
					
					<cfif qr_proprietario.proprietario neq 3>
						<cfif qr_result.RecordCount eq 0>
							<cfstoredproc procedure='oper.pkg_romaneio_dml.prc_ins_inicio_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
								<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CONTROLE'  value='#arguments.PLACA_TRACAO#' >
								<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#arguments.PLACA_REFERENCIA#' >
								<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL' value="#session.COD_PESSOA#">
								<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO' variable='retorno.NUM_ROMANEIO' >
								<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
							</cfstoredproc>
							<cfset arguments.NUM_ROMANEIO = retorno.NUM_ROMANEIO>
						<cfelse>
							<cfset arguments.NUM_ROMANEIO = qr_result.NUM_ROMANEIO>
						</cfif>
					</cfif>
				</cfif>
                
                <cfif arguments.situacao_id eq 1>
                	<cfset arguments.cancelado_em = lsdateformat(now())&' '&timeformat(now(),'HH:MM:SS')>
                <cfelse>
                	<cfset arguments.cancelado_em = ''>
                </cfif>
                <cfif arguments.impresso eq 1>
                	<cfset arguments.impresso_em = lsdateformat(now())&' '&timeformat(now(),'HH:MM:SS')>
                <cfelse>
                	<cfset arguments.impresso_em = ''>
                </cfif>
							
				<cfscript>
					retorno = this.upd_conhecimento_private(argumentCollection = arguments);
				</cfscript>
				<!--- Insere Notas fiscais --->
				<cfscript>
					retorno.conhecimento_id = arguments.conhecimento_id;
					v_numero 	   = this.ListaToArray    (lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
					v_data_emissao = this.ListaToArray    (lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
					v_serie 	   = this.ListaToArray    (lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
					v_sub_serie    = this.ListaToArray    (lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
					v_modelo       = this.ListaToArray    (lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
					v_valor		   = this.ListaToArray    (lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
					v_valor_segurado  = this.ListaToArray (lista = arguments, variavel = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
					v_peso         = this.ListaToArray    (lista = arguments, variavel = "NOTA_PESO_NOTAS_FISCAIS");
					v_peso_cobrado         = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
					
					v_ordem_compra         = this.ListaToArray(lista = arguments, variavel = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
					
					v_qtde_volume          = this.ListaToArray(lista = arguments, variavel = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
					v_cod_unidade          = this.ListaToArray(lista = arguments, variavel = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
					v_m3                   = this.ListaToArray(lista = arguments, variavel = 'NOTA_M3_NOTAS_FISCAIS');
					v_peso_cubado          = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
					v_peso_kg_convertido   = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_KG_CONVERTIDO_NOTAS_FISCAIS');
					v_num_natureza         = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
					v_natureza             = this.ListaToArray(lista = arguments, variavel = 'NOTA_NATUREZA_NOTAS_FISCAIS');
					v_complemento          = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
					v_num_especie          = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
					v_especie              = this.ListaToArray(lista = arguments, variavel = 'NOTA_ESPECIE_NOTAS_FISCAIS');
					v_altura               = this.ListaToArray(lista = arguments, variavel = 'NOTA_ALTURA_NOTAS_FISCAIS');
					v_largura              = this.ListaToArray(lista = arguments, variavel = 'NOTA_LARGURA_NOTAS_FISCAIS');
					v_comprimento          = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
					v_cubagem              = this.ListaToArray(lista = arguments, variavel = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
						
						
				</cfscript>
                
				<cfscript>
					conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
					qrNotas = conn.get_conhecimento_nota_fiscal(conhecimento_id = retorno.conhecimento_id);
				</cfscript>
				<cfloop query="qrNotas">
					<cfif not listfind(ArrayToList(v_numero),qrNotas.numero)>
						<cfscript>
							this.ins_nf_conhecimento(	conhecimento_id      = retorno.conhecimento_id,
														numero			     = qrNotas.numero);
						</cfscript>
					</cfif>
				</cfloop>

				<cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
					<cfscript>
				
						this.ins_nf_conhecimento(	conhecimento_id      = retorno.conhecimento_id,
													numero			     = v_numero[count],
													data_emissao	     = v_data_emissao[count],
													modelo 		         = v_modelo[count],
													serie 			     = v_serie[count],
													sub_serie 		     = v_sub_serie[count],
													valor_total 	     = v_valor[count],
													valor_segurado       = v_valor_segurado[count],
													peso                 = v_peso[count],
													ordem_compra_cliente = v_ordem_compra[count],
													qtde_volume 		 = v_qtde_volume[count],
													cod_unidade 		 = v_cod_unidade[count],
													m3 				     = v_m3[count],
													peso_cubado 		 = v_peso_cubado[count],
													peso_kg_convertido   = v_peso_kg_convertido[count],
													num_natureza 		 = v_num_natureza[count],
													natureza 			 = v_natureza[count],
													complemento          = v_complemento[count],
													num_especie          = v_num_especie[count],
													especie              = v_especie[count],
													altura               = v_altura[count],
													largura              = v_largura[count],
													comprimento          = v_comprimento[count],
													cubagem              = v_cubagem[count],
													peso_cobrado         = v_peso_cobrado[count]);
					</cfscript>
				</cfloop>
                
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfif arguments.EMITE_TABELA_FRETE eq 1>
                	<cfscript>
						if(IsDefined('arguments.PLACA_REFERENCIA_INTERNA')) {
							v_placa_referencia_interna = Replace(arguments.PLACA_REFERENCIA_INTERNA, ',', ' > ', 'all');
						}
						else {
							v_placa_referencia_interna = '';
						}
						
						conn_cons_tf = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
						qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id(ORIGEM_MUNICIPIO_ID  = arguments.COLETA_MUNICIPIO_ID,
																					DESTINO_MUNICIPIO_ID = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.ENTREGA_MUNICIPIO_ID), de(arguments.MUNICIPIO_ULT_ENTREGA_ID)),
																					COD_NEGOCIADOR       = arguments.COD_NEGOCIADOR,
																					NUM_NATUREZA		 = arguments.NUM_NATUREZA,
																					COMPOSICAO			 = arguments.PLACA_TRACAO & ' > ' & v_placa_referencia_interna);
					</cfscript>
					<cfif qrTabelaFreteRotaId.erro>
						<cfthrow object="#qrTabelaFreteRotaId.mensagem#">

					</cfif>
					
					<cfscript>
						conn_cons_doc = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
						qrDadosFiscais = conn_cons_doc.get_ctrc_dados_fiscais(NUM_ROMANEIO 		   = arguments.NUM_ROMANEIO,
																	 		  ITEM_ID 			   = arguments.ITEM_ID,
																			  COD_DESTINATARIO 	   = arguments.COD_DESTINATARIO,
																			  PRODUTO_ID  		   = arguments.NUM_PRODUTO,
																			  PAGO_POR 			   = arguments.PAGADOR,
																			  COLETA_UF 		   = arguments.COLETA_UF,
																			  ENTREGA_UF 		   = arguments.ENTREGA_UF,
																			  ST_ICMS_ID 		   = arguments.ST_ICMS_ID,
																			  COD_REMETENTE 	   = arguments.COD_REMETENTE,
																			  REGRA_FISCAL_ID 	   = arguments.REGRA_FISCAL,
																			  COB_UF 			   = arguments.COB_UF,
																			  COLETA_MUNICIPIO_ID  = arguments.COLETA_MUNICIPIO_ID,
																			  ENTREGA_MUNICIPIO_ID = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.ENTREGA_MUNICIPIO_ID), de(arguments.MUNICIPIO_ULT_ENTREGA_ID)),
																			  VIAGEM_CARGA_ID 	   = arguments.VIAGEM_CARGA_ID,
																			  COD_CLIENTE_COBRANCA = arguments.COD_CLIENTE_COBRANCA,
																			  UF_FILIAL 		   = arguments.UF_FILIAL_EMISSAO,
																			  NOTA_FISCAL 		   = 0);
					</cfscript>
					<cfif qrDadosFiscais.erro>
						<cfthrow object="#qrDadosFiscais.mensagem#">
					</cfif>
                    
                    <cfscript>
						conn_cons_vei = CreateComponent("_transportes.consulta.cfc_veiculo");
						qrNumeroEixos = conn_cons_vei.get_numero_eixos_composicao(PLACA = arguments.PLACA_TRACAO & ' > ' & v_placa_referencia_interna);
					</cfscript>
					<cfif qrNumeroEixos.erro>
						<cfthrow object="#qrNumeroEixos.mensagem#">
					</cfif>
                    
                    <cfscript>
						// Constantes
						arguments.CONSTANTE_VIAGEM_CARGA_ID		  = arguments.VIAGEM_CARGA_ID;
						arguments.CONSTANTE_PESO_BRUTO            = ArraySum(v_peso_kg_convertido);
						arguments.CONSTANTE_PESO_COBRADO          = ArraySum(v_peso_cobrado);
						arguments.CONSTANTE_VALOR_MERCADORIA      = ArraySum(v_valor);
						arguments.CONSTANTE_MUNICIPIO_ID_ORIGEM   = arguments.COLETA_MUNICIPIO_ID;
						arguments.CONSTANTE_MUNICIPIO_ID_DESTINO  = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.ENTREGA_MUNICIPIO_ID), de(arguments.MUNICIPIO_ULT_ENTREGA_ID));
						arguments.CONSTANTE_FRETE_PROPRIO		  = qrDadosFiscais.FRETE_PROPRIO;
						arguments.CONSTANTE_UF_TOMADOR			  = qrDadosFiscais.TOMADOR_UF;
						arguments.CONSTANTE_COD_ATIVIDADE_TOMADOR = qrDadosFiscais.COD_ATIVIDADE_TOMADOR;
						arguments.CONSTANTE_ST_ICMS_ID			  = Trim(arguments.ST_ICMS_ID);
						arguments.CONSTANTE_PLACA_TRACAO	 	  = arguments.PLACA_TRACAO;
						
						if(v_placa_referencia_interna eq '') {
							arguments.CONSTANTE_PLACA_CARRETA = '';
						}
						else {
							arguments.CONSTANTE_PLACA_CARRETA = ListGetAt(v_placa_referencia_interna, 1, ' > ');
						}
						
						arguments.CONSTANTE_NRO_EIXOS = qrNumeroEixos.EIXOS;
						// ----------
					</cfscript>
                    
                    <cfscript>
						qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						qrConstante 	  = conn_cons_tf.get_constante();
						qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						
						conn_manip_tf = CreateComponent("modulos.nfes._componentes.manipulacao.comercial.cfc_tabela_frete");
					</cfscript>
					
					<cfloop query="qrConstante">
						<cfscript>
							ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
														  		   VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
						</cfscript>
						<cfif ret_cons.erro>
							<cfthrow object="#ret_cons.mensagem#">
						</cfif>
					</cfloop>
					
					<cfscript>
						ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
														 		  VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_cons_tf.erro>
						<cfthrow object="#ret_cons_tf.mensagem#">
					</cfif>
					
					<cfscript>
						ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
														  		   VALOR		 = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
					</cfscript>
					<cfif ret_cons_tfr.erro>
						<cfthrow object="#ret_cons_tfr.mensagem#">
					</cfif>
					
					<cfloop query="qrVariavel">
						<cfscript>
							ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
																	 		  TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID,
																	 		  TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 		  VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					</cfloop>
                    
                    <cfscript>
						ret_calc = this.calcula_ctrc_tabela_frete(CONHECIMENTO_ID = retorno.CONHECIMENTO_ID,
																  TABELA_FRETE_ID = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_calc.erro>
						<cfthrow object="#ret_calc.mensagem#">
					</cfif>
                </cfif>
                
				<cfscript>
					ret_valid_tf = this.valida_ctrc_tabela_frete(CONHECIMENTO_ID = retorno.CONHECIMENTO_ID);
				</cfscript>
				<cfif ret_valid_tf.erro>
					<cfthrow object="#ret_valid_tf.mensagem#">
				</cfif>                
                <!--- /// --->
                
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conhecimento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
    
	<!--- 
	-- PROPSITO
	-- Gera um conhecimento zerado
	-- cristofer 12/12/2006 09:52:15 - CRIADO
	--->
	<cffunction name='upd_conhecimento_private' displayname='Gera um conhecimento zerado' access='remote' returntype='Struct' output='true'>
    			<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_alt_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_CONHECIMENTO'  value='#arguments.NUM_CONHECIMENTO#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#' variable='retorno.NUM_ROMANEIO'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA_GERENCIAL'  value='#arguments.COD_ORGANOGRAMA_GERENCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRAZO_ENTREGA'  value='#arguments.PRAZO_ENTREGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='#arguments.ST_ORIGEM_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#trim(arguments.ST_ICMS_ID)#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_RAZAO_SOCIAL'  value='#arguments.REM_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO'  value='#arguments.REM_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO_NUM'  value='#arguments.REM_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_BAIRRO'  value='#arguments.REM_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_MUNICIPIO'  value='#arguments.REM_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_UF'  value='#arguments.REM_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CNPJ_CPF'  value='#arguments.REM_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_INSCRICAO_ESTADUAL'  value='#arguments.REM_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO_NUM'  value='#arguments.DEST_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONSIGNATARIO'  value='#arguments.COD_CONSIGNATARIO#'  null='#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_RAZAO_SOCIAL'  value='#arguments.CONS_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO'  value='#arguments.CONS_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO_NUM'  value='#arguments.CONS_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_BAIRRO'  value='#arguments.CONS_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_MUNICIPIO'  value='#arguments.CONS_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_UF'  value='#arguments.CONS_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CEP'  value='#arguments.CONS_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CNPJ_CPF'  value='#arguments.CONS_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_INSCRICAO_ESTADUAL'  value='#arguments.CONS_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONS_MUNICIPIO_ID'  value='#arguments.CONS_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.CONS_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REDESPACHO'  value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_RAZAO_SOCIAL'  value='#arguments.RED_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO'  value='#arguments.RED_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO_NUM'  value='#arguments.RED_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_BAIRRO'  value='#arguments.RED_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_MUNICIPIO'  value='#arguments.RED_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_UF'  value='#arguments.RED_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CEP'  value='#arguments.RED_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CNPJ_CPF'  value='#arguments.RED_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_INSCRICAO_ESTADUAL'  value='#arguments.RED_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RED_MUNICIPIO_ID'  value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE_COBRANCA'  value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_RAZAO_SOCIAL'  value='#arguments.COB_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_ENDERECO'  value='#arguments.COB_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_ENDERECO_NUM'  value='#arguments.COB_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_BAIRRO'  value='#arguments.COB_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_MUNICIPIO'  value='#arguments.COB_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_UF'  value='#arguments.COB_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_CEP'  value='#arguments.COB_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_CNPJ_CPF'  value='#arguments.COB_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_INSCRICAO_ESTADUAL'  value='#arguments.COB_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COB_MUNICIPIO_ID'  value='#arguments.COB_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COB_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				  	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_CNPJ_CPF'  value='#arguments.PROP_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_RAZAO_SOCIAL'  value='#arguments.PROP_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_ENDERECO'  value='#arguments.PROP_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_UF'  value='#left(arguments.PROP_UF,2)#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_MOTORISTA'  value='#arguments.NOME_MOTORISTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_TRACAO'  value='#arguments.PLACA_TRACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA_REFERENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.ENTREGA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.ENTREGA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.ENTREGA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.ENTREGA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO_REAL'  value='#arguments.PESO_REAL#' null='#iif(len(trim(arguments.PESO_REAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ISS' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ISS' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ISS' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS_SUBSTIT' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_PRESUMIDO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REDUCAO_BASE_ICMS' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REDUCAO_BASE_ICMS_SUBSTIT' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS_SUBSTIT' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_FATURAMENTO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CANCELADO'  value='#arguments.CANCELADO_EM#'  null='#iif(len(trim(arguments.CANCELADO_EM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_IMPRESSO'  value='#arguments.IMPRESSO_EM#'  null='#iif(len(trim(arguments.IMPRESSO_EM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FATURADO'  value=''  null='yes'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' variable='retorno.OBSERVACAO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RODAPE'  value='#arguments.RODAPE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTRADA_DADOS'  value='#arguments.ENTRADA_DADOS#'  null='#iif(len(trim(arguments.ENTRADA_DADOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REGRA_FISCAL_ID'  value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID_SUB_CONTR'  value='#arguments.CONHECIMENTO_ID_SUB#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_SUB)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_CONHECIMENTO_SUB_CONTR'  value='#arguments.NUM_CONHECIMENTO_SUB_CONTR#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO_SUB_CONTR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE_CONHECIMENTO_SUB_CONTR'  value='#arguments.SERIE_CONHECIMENTO_SUB_CONTR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_VENDA' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_COMPLEMENTO'  value='#arguments.CONHECIMENTO_COMPLEMENTO#'  null='#iif(len(trim(arguments.CONHECIMENTO_COMPLEMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CORRECAO'  value='#arguments.CORRECAO#'  null='#iif(len(trim(arguments.CORRECAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TEM_NOTA'  value='#arguments.TEM_NOTA#'  null='#iif(len(trim(arguments.TEM_NOTA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
    
	<!--- 
	-- PROPSITO
	-- Gera um conhecimento zerado
	-- cristofer 12/12/2006 09:52:15 - CRIADO
	--->
	<cffunction name='gera_conhecimento_zerado' displayname='Gera um conhecimento zerado' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='IMPRESSO' required='no' default="0">
		<cfargument name='NUM_ROMANEIO' required='no' default="">
		<cfargument name='ITEM_ID' required='no' default="">
		<cfargument name='PLACA_CONTROLE' required='no' default="">
		<cfargument name='PLACA_REFERENCIA' required='no' default="">
        <cfif arguments.impresso eq 0>
        	<cfset arguments.impresso_em = "">
        <cfelse>
        	<cfset arguments.impresso_em = DateFormat(now(),'dd/mm/yyyy')&" "&TimeFormat(now(),'HH:MM:SS')>
        </cfif>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_gera_conhecimento_zerado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_CONHECIMENTO'  value='#arguments.NUM_CONHECIMENTO#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' variable='retorno.DATA_EMISSAO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_IMPRESSO'  value='#arguments.impresso_em#'  null='#iif(len(trim(arguments.impresso_em)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID' variable='retorno.CONHECIMENTO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_CONTROLE'  value='#arguments.PLACA_CONTROLE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_REFERENCIA'  value='#arguments.PLACA_REFERENCIA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Conhecimento gerado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Cancela um formulario de Conhecimento
	-- cristofer 12/12/2006 09:52:15 - CRIADO
	--->
	<cffunction name='cancela_formulario_ctrc' displayname='Gera um conhecimento zerado' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action="begin">
				<cfscript>
					zerado = this.gera_conhecimento_zerado(	num_conhecimento 	= arguments.num_conhecimento,
															serie				= arguments.serie,
															data_emissao		= arguments.data_emissao,
															cod_pessoa_filial	= arguments.cod_pessoa_filial,
															cod_departamento	= arguments.cod_departamento,
															cod_setor			= arguments.cod_setor,
															cod_centro_custo	= arguments.cod_centro_custo,
															impresso 			= 1);
				</cfscript>
				<cfif zerado.erro>
					<cfthrow object="#zerado.mensagem#">
				</cfif>
				<cfscript>
					cancelamento = this.can_conhecimento (	conhecimento_id = zerado.conhecimento_id,
															motivo = arguments.motivo);
				</cfscript>
				<cfif cancelamento.erro>
					<cfthrow object="#cancelamento.mensagem#">
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Formulario cancelado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback" />
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Vincula um romaneio a um CTRC
	-- 03/05/2006 - GUTO
	--->
	<cffunction name="vincula_conhecimento_romaneio" displayname="Insere uma item vinculado a carta frete" access="remote" returntype="struct" output="true">
		<cfargument name="num_romaneio" required="yes" />
		<cfargument name="item_id" 		required="yes" />
		<cfargument name="conhecimento_id" required="yes" />
		<cfargument name="proprietario_consulta" required="no" />
		<cfargument name="COMPOSICAO" required="yes" />
		<cfargument name="NUM_LOTE" required="yes" />
		<cftry>
			<cftransaction action="begin">
				<cfif arguments.vincular eq 'LOTE'>
					<cfif not len(trim(arguments.composicao))>
						<cfthrow detail=" necessrio informar a composio">
					</cfif>
					<cfscript>
						conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
						qrConhecimento = conn.get_conhecimento(conhecimento_id = arguments.conhecimento_id);
						qrLote = conn.get_lote(num_lote = arguments.num_lote);
					</cfscript>
					<cfscript>
						conn = CreateComponent("modulos.nfes._componentes.manipulacao.cfc_controle_trafego");
						romaneio = conn.gera_romaneio_terceiro(	NUM_ROMANEIO		= '',
																COMPOSICAO			= arguments.composicao,
																DATA_INICIO			= LSDateFormat(qrConhecimento.data_emissao)&' '&TimeFormat(qrConhecimento.data_emissao,'HH:MM:SS'),
																NUM_LOTE			= arguments.num_lote,
																COD_MOTORISTA		= qrConhecimento.cod_motorista,
																COD_REMETENTE		= qrConhecimento.cod_remetente,
																COLETA_MUNICIPIO_ID	= qrConhecimento.coleta_municipio_id,
																COD_DESTINATARIO	= qrConhecimento.cod_destinatario,
																ENTREGA_MUNICIPIO_ID= qrConhecimento.entrega_municipio_id,
																VOLUME				= qrConhecimento.volume,
																PESO				= qrConhecimento.peso,
																M3					= qrConhecimento.m3,
																FRETE_VALOR			= qrConhecimento.frete_valor,
																NUM_NATUREZA		= qrConhecimento.num_natureza,
																NUM_ESPECIE			= qrConhecimento.num_especie,
																COD_UNIDADE			= qrConhecimento.cod_unidade,
																FRETE_EM			= qrLote.frete_em,
																DESPACHO			= qrConhecimento.despacho,
																OBSERVACAO			= ''
																);
					</cfscript>
					<cfif romaneio.erro>
						<cfthrow object="#romaneio.mensagem#">
					<cfelse>
						<cfset arguments.num_romaneio 	= romaneio.num_romaneio>
						<cfset arguments.item_id 		= romaneio.item_id>
					</cfif>
				</cfif>
				<cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transp.prc_vincula_ctrc_romaneio" username="#session.usuario#" password="#session.senha#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_conhecimento_id" value="#arguments.conhecimento_id#" null="#iif(len(trim(arguments.conhecimento_id)),de('no'),de('yes'))#">
					<cfprocparam type="in" cfsqltype="cf_sql_integer" dbvarname="p_num_romaneio" value="#arguments.num_romaneio#" null="#iif(len(trim(arguments.num_romaneio)),de('no'),de('yes'))#">
					<cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="v_item_id" value="#arguments.item_id#" variable="retorno.item_id" null="#iif(len(trim(arguments.item_id)),de('no'),de('yes'))#">
				</cfstoredproc>
				<cfset retorno.erro = false>		
				<cfset retorno.mensagem = 'Conhecimento vinculado ao romaneio n #arguments.num_romaneio# com sucesso.'>		
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>		

	<!--- 
	-- PROPSITO
	-- Vincula um romaneio a uma NF ES
	-- 03/05/2006 - GUTO
	--->
	<cffunction name="vincula_nf_es_romaneio" displayname="" access="remote" returntype="struct" output="true">
		<cfargument name="num_romaneio" required="yes" />
		<cfargument name="item_id" 		required="yes" />
		<cfargument name="num_nota_id" required="yes" />
		<cfargument name="proprietario_consulta" required="no" />
		<cfargument name="COMPOSICAO" required="yes" />
		<cfargument name="NUM_LOTE" required="yes" />
		<cftry>
			<cftransaction action="begin">
				<cfif arguments.vincular eq 'LOTE'>
					<cfif not len(trim(arguments.composicao))>
						<cfthrow detail=" necessrio informar a composio">
					</cfif>
					<cfscript>
						conn = CreateComponent("modulos.nfes._componentes.consulta.cfc_emissao_documentos");
						qrNotaFistalFrete = conn.get_nf_es_frete(num_nota_id = arguments.num_nota_id);
						qrLote = conn.get_lote(num_lote = arguments.num_lote);
					</cfscript>
					<cfscript>
						conn = CreateComponent("modulos.nfes._componentes.manipulacao.cfc_contrato_transporte");
						romaneio = conn.gera_romaneio_terceiro(	NUM_ROMANEIO		= '',
																COMPOSICAO			= arguments.composicao,
																DATA_INICIO			= qrNotaFistalFrete.data_emissao,
																NUM_LOTE			= arguments.num_lote,
																COD_MOTORISTA		= qrNotaFistalFrete.cod_motorista,
																COD_REMETENTE		= qrNotaFistalFrete.cod_remetente,
																COLETA_MUNICIPIO_ID	= qrNotaFistalFrete.coleta_municipio_id,
																COD_DESTINATARIO	= qrNotaFistalFrete.cod_destinatario,
																ENTREGA_MUNICIPIO_ID= qrNotaFistalFrete.entrega_municipio_id,
																VOLUME				= qrNotaFistalFrete.volume,
																PESO				= qrNotaFistalFrete.peso,
																M3					= qrNotaFistalFrete.m3,
																FRETE_VALOR			= qrNotaFistalFrete.serv_total_nota,
																NUM_NATUREZA		= qrNotaFistalFrete.natureza_id,
																NUM_ESPECIE			= qrNotaFistalFrete.num_especie,
																COD_UNIDADE			= qrNotaFistalFrete.cod_unidade,
																FRETE_EM			= qrLote.frete_em,
																DESPACHO			= qrNotaFistalFrete.despacho,
																OBSERVACAO			= ''
																);
					</cfscript>
					<cfif romaneio.erro>
						<cfthrow object="#romaneio.mensagem#">
					<cfelse>
						<cfset arguments.num_romaneio 	= romaneio.num_romaneio>
						<cfset arguments.item_id 		= romaneio.item_id>
					</cfif>
				</cfif>
      <cfstoredproc procedure='oper.pkg_romaneio.prc_vincula_nf_es_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
       <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
        <cfprocparam type="inout" cfsqltype="cf_sql_integer" dbvarname="p_item_id" value="#arguments.item_id#" variable="retorno.item_id" null="#iif(len(trim(arguments.item_id)),de('no'),de('yes'))#">
       <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
      </cfstoredproc>
				<cfset retorno.erro = false>		
				<cfset retorno.mensagem = 'Nota Fiscal vinculada ao romaneio n #NumberFormat(arguments.num_romaneio)# com sucesso.'>		
			</cftransaction>
			<cfcatch>
				<cftransaction action="rollback"/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>		 

	<!--- 
	-- PROPSITO
	-- Gera um CTRC de Complemento
	-- cristofer 19/12/2006 15:18:49 - CRIADO
	--->
	<cffunction name='gera_ctrc_complemento' displayname='Gera um CTRC de Complemento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID_COMPLEM' required='yes'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='COB_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COB_ENDERECO' required='yes'>
		<cfargument name='COB_MUNICIPIO' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COB_CEP' required='yes'>
		<cfargument name='COB_CNPJ_CPF' required='yes'>
		<cfargument name='COB_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='IMPRESSO' required='yes'>
        <cfif arguments.impresso eq 1>
        	<cfset arguments.impresso_em = lsdateformat(now())&' '&timeformat(now(),'HH:MM:SS')>
        <cfelse>
        	<cfset arguments.impresso_em = ''>
        </cfif>
		<cftry>
			<cftransaction action='begin'> 
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_gera_ctrc_complemento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID_COMPLEM'  value='#arguments.CONHECIMENTO_ID_COMPLEM#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_COMPLEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_CONHECIMENTO'  value='#arguments.NUM_CONHECIMENTO#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID' variable='retorno.CONHECIMENTO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RELACAO_ID' variable='retorno.RELACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE_COBRANCA'  value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_RAZAO_SOCIAL'  value='#arguments.COB_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_ENDERECO'  value='#arguments.COB_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_MUNICIPIO'  value='#arguments.COB_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_UF'  value='#arguments.COB_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_CEP'  value='#arguments.COB_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_CNPJ_CPF'  value='#arguments.COB_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_INSCRICAO_ESTADUAL'  value='#arguments.COB_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' scale='5' dbvarname='P_IMPRESSO'  value='#arguments.IMPRESSO_EM#'  null='#iif(len(trim(arguments.IMPRESSO_EM)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Complemento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um lote
	-- cristofer 26/12/2006 14:41:57 - CRIADO
	--->
	<cffunction name='ins_lote' displayname='Insere um lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_INICIO_RETIRADA' required='yes'>
		<cfargument name='DATA_PRAZO_RETIRADA' required='yes'>
		<cfargument name='DATA_CONTRATO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='no' default="">
		<cfargument name='M3' required='no' default="">
		<cfargument name='FRETE_EM' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='QTDE_VIAGEM' required='no' default="">
		<cfargument name='FRETE_PROPRIO' required='yes'>
		<cfargument name='FRETE_VALOR_UNITARIO' required='no' default="">
		<cfargument name='FRETE_VALOR' required='no' default="0">
		<cfargument name='FRETE_POR_CONTA' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='PEDAGIO_INCLUSO' required='no' default="1">
		<cfargument name='SITUACAO_TRIBUTARIA' required='no' default="00">
		<cfargument name='ALIQUOTA_ICMS' required='no' default="0">
		<cfargument name='REDUCAO_BASE_CALCULO' required='no' default="0">
		<cfargument name='ICMS_INCLUSO' required='no' default="0">
		<cfargument name='DESTACA_BASE_CALC_ICMS' required='no' default="0">
		<cfargument name='FUNDAMENTACAO_LEGAL' required='no' default="">
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='COLETA_LOGRADOURO' required='yes'>
		<cfargument name='COLETA_COMPLEMENTO' required='yes'>
		<cfargument name='COLETA_BAIRRO' required='yes'>
		<cfargument name='COLETA_CEP' required='yes'>

		<cfargument name='COLETA_COD_UF' required='no' default="">
		<cfargument name='COLETA_COD_MUNICIPIO' required='no' default="">
		<cfargument name='COLETA_COD_DV' required='no' default="">
		<cfargument name='COLETA_COD_DISTRITO' required='no' default="">

		<cfargument name='ENTREGA_LOGRADOURO' required='yes'>
		<cfargument name='ENTREGA_COMPLEMENTO' required='yes'>
		<cfargument name='ENTREGA_CEP' required='yes'>
		<cfargument name='ENTREGA_BAIRRO' required='yes'>

		<cfargument name='ENTREGA_COD_UF' required='no' default="">
		<cfargument name='ENTREGA_COD_MUNICIPIO' required='no' default="">
		<cfargument name='ENTREGA_COD_DISTRITO' required='no' default="">
		<cfargument name='ENTREGA_COD_DV' required='no' default="">

		<cfargument name='CONTROLE_PESO' required='no' default="0">
		<cfargument name='CONTROLE_VIAGEM' required='no' default="0">
		<cfargument name='CONTROLE_PESO_VEICULO' required='no' default="0">
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='NEGOCIADO_POR' required='no' default="">
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='OBSERVACAO_EMITENTE' required='no' default="">
		<cfargument name='NEGOCIADO_POR_TELEFONE' required='no' default="">
		<cfargument name='NEGOCIADO_POR_EMAIL' required='no' default="">
		<cfargument name='SEGURO' required='no' default="1">
		<cfargument name='COM_RETORNO_EMBALAGEM' required='no' default="0">
		<cfargument name='REM_ENVIA_MONITORAMENTO' required='no' default="0">
		<cfargument name='DEST_ENVIA_MONITORAMENTO' required='no' default="0">
		<cfargument name='PERMITE_LANCTOCTRC_ANTESMACR' required='no' default="1">
		<cfargument name='FRACIONADO' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
		<cfargument name='INTERNACIONAL' required='yes'>
		<cfargument name='DEDICADO' required='yes'>
		
		<cfargument name="ID_SEG_RCTR_C" required="yes">
		<cfargument name="RCF_DC" required="yes">
		<cfargument name="RESPONSAVEL_RCF_DC" required="yes">
		<cfargument name="ID_SEG_RCF_DC" required="yes">
		<cfargument name="VALOR_COB_RCF_DC_CLIENTE" required="yes">
		<cfargument name="EXIGE_GERENCIADORA" required="yes">
		<cfargument name="COD_GERENCIADORA" required="yes">
		<cfargument name="EXIGE_MONITORAMENTO" required="yes">
		<cfargument name="COD_PESSOA_MONITORA" required="yes">
		<cfargument name="TIPO_VALOR_MERCADORIA" required="yes">
		<cfargument name="VALOR_MEDIO_MERCADORIA" required="yes">
		<cfargument name="INTERVALO_MINUTO" required="yes">
		<cfargument name="RCTR_VI" required="yes">
		<cfargument name="ID_SEG_RCTR_VI" required="no" default="">
		<cfargument name="OBSERVACAO_SEG" required="no" default="">
		<cfargument name="NUM_LIBERACAO_RCTR_C" required="yes">
		<cfargument name="NUM_LIBERACAO_RCF_DC" required="yes">
		<cfargument name="NUM_LIBERACAO_RCTR_VI" required="yes">
		<cfargument name="COD_PESSOA_ESCOLTA" required="yes">
		<cfargument name="TIPO_ESCOLTA" required="yes">
		<cfargument name="RR" required="yes">
		<cfargument name="ID_SEG_RR" required="no" default="">
		<cfargument name="NUM_LIBERACAO_RR" required="yes">
		<cfargument name="ID_LOTE_SEGURO" required="no" default="">

		<cfargument name='DOCUMENTO_FATURA' required='no' default="">
		<cfargument name='DOCUMENTO_EMBARCADOR' required='no' default="">
		<cfargument name='DOCUMENTO_MOTORISTA' required='no' default="">

		<cfargument name='DOCUMENTOS_LOTE' required='no' default="">

		<cfargument name='COD_NEGOCIADOR' required='no' default="">

		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_ins_lote' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_RETIRADA'  value='#arguments.DATA_INICIO_RETIRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PRAZO_RETIRADA'  value='#arguments.DATA_PRAZO_RETIRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONTRATO'  value='#arguments.DATA_CONTRATO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FRETE_EM'  value='#arguments.FRETE_EM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_VIAGEM'  value='#arguments.QTDE_VIAGEM#'  null='#iif(len(trim(arguments.QTDE_VIAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_PROPRIO'  value='#arguments.FRETE_PROPRIO#'  null='#iif(len(trim(arguments.FRETE_PROPRIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR_UNITARIO'  value='#arguments.FRETE_VALOR_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_POR_CONTA'  value='#arguments.FRETE_POR_CONTA#'  null='#iif(len(trim(arguments.FRETE_POR_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO_INCLUSO'  value='#arguments.PEDAGIO_INCLUSO#'  null='#iif(len(trim(arguments.PEDAGIO_INCLUSO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SITUACAO_TRIBUTARIA'  value='#arguments.SITUACAO_TRIBUTARIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REDUCAO_BASE_CALCULO'  value='#arguments.REDUCAO_BASE_CALCULO#'  null='#iif(len(trim(arguments.REDUCAO_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_INCLUSO'  value='#arguments.ICMS_INCLUSO#'  null='#iif(len(trim(arguments.ICMS_INCLUSO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESTACA_BASE_CALC_ICMS'  value='#arguments.DESTACA_BASE_CALC_ICMS#'  null='#iif(len(trim(arguments.DESTACA_BASE_CALC_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL'  value='#arguments.FUNDAMENTACAO_LEGAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >

					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_COD_UF' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_COD_MUNICIPIO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_COD_DV' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_COD_DISTRITO' null="yes">

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.ENTREGA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.ENTREGA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.ENTREGA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.ENTREGA_BAIRRO#' >

					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_COD_UF' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_COD_MUNICIPIO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_COD_DISTRITO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_COD_DV' null="yes">

					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_PESO'  value='#arguments.CONTROLE_PESO#'  null='#iif(len(trim(arguments.CONTROLE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_VIAGEM'  value='#arguments.CONTROLE_VIAGEM#'  null='#iif(len(trim(arguments.CONTROLE_VIAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_PESO_VEICULO'  value='#arguments.CONTROLE_PESO_VEICULO#'  null='#iif(len(trim(arguments.CONTROLE_PESO_VEICULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REGRA_FISCAL'  value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NEGOCIADO_POR'  value='#arguments.NEGOCIADO_POR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_EMITENTE'  value='#arguments.OBSERVACAO_EMITENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NEGOCIADO_POR_TELEFONE'  value='#arguments.NEGOCIADO_POR_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NEGOCIADO_POR_EMAIL'  value='#arguments.NEGOCIADO_POR_EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEGURO'  value='#arguments.SEGURO#'  null='#iif(len(trim(arguments.SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE' variable='retorno.NUM_LOTE' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COM_RETORNO_EMBALAGEM' value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REM_ENVIA_MONITORAMENTO' value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DEST_ENVIA_MONITORAMENTO' value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERMITE_LANCTOCTRC_ANTESMACR' value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRACIONADO'  value='#arguments.FRACIONADO#'  null='#iif(len(trim(arguments.FRACIONADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INTERNACIONAL'  value='#arguments.INTERNACIONAL#'  null='#iif(len(trim(arguments.INTERNACIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DEDICADO'  value='#arguments.DEDICADO#'  null='#iif(len(trim(arguments.DEDICADO)), de('no'), de('yes'))#'>
		  	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
				</cfstoredproc>
				
				<!--- Insere o compartilhamento entre agencias --->
				<cfscript>
					compto = this.ins_lote_setor_compto(num_lote 			= retorno.num_lote,
														cod_pessoa_filial	= arguments.cod_pessoa_filial,
														cod_departamento	= arguments.cod_departamento,
														cod_setor			= arguments.cod_setor,
														cod_centro_custo	= arguments.cod_centro_custo,
														permite_destinar 	= 1);
				</cfscript>
				<cfif compto.erro>
					<cfthrow object="#compto.mensagem#">
				</cfif>
				
			
				<!--- Insere o compartilhamento entre agencias --->
				<cfscript>
					compto = this.ins_lote_setor_docto(num_lote 			= retorno.num_lote,
														cod_pessoa_filial	= arguments.cod_pessoa_filial,
														cod_departamento	= arguments.cod_departamento,
														cod_setor			= arguments.cod_setor,
														cod_centro_custo	= arguments.cod_centro_custo);
				</cfscript>
				<cfif compto.erro>
					<cfthrow object="#compto.mensagem#">
				</cfif>
				
				<!--- Consignatario --->
				<cfif len(trim(arguments.cod_consignatario))>
					<cfscript>
						consig = this.ins_lote_consignatario(	NUM_LOTE			= retorno.num_lote,
																COD_CONSIGNATARIO	= arguments.cod_consignatario,
																RAZAO_SOCIAL		= arguments.cons_razao_social,
																CEP					= arguments.cons_cep,
																ENDERECO			= arguments.cons_endereco,
																CNPJ_CPF			= arguments.cons_cnpj_cpf,
																INSCRICAO_ESTADUAL	= arguments.cons_inscricao_estadual,
																MUNICIPIO			= arguments.cons_municipio,
																UF					= arguments.cons_uf,
																MUNICIPIO_ID		= arguments.cons_municipio_id);
					</cfscript>
					<cfif consig.erro>
						<cfthrow object="#consig.mensagem#">
					</cfif>
				<cfelse>
					<cfscript>
						consig = this.del_lote_consignatario(	NUM_LOTE			= retorno.num_lote);
					</cfscript>
					<cfif consig.erro>
						<cfthrow object="#consig.mensagem#">
					</cfif>
				</cfif>
				
				<!--- Cliente Cobranca --->
				<cfif len(trim(arguments.cod_cliente_cobranca))>
					<cfscript>
						cobran = this.ins_lote_cliente_cobranca(NUM_LOTE			= retorno.num_lote,
																COD_CLIENTE_COBRANCA	= arguments.cod_cliente_cobranca,
																CNPJ_CPF			= arguments.cob_cnpj_cpf,
																RAZAO_SOCIAL		= arguments.cob_razao_social,
																INSCRICAO_ESTADUAL	= arguments.cob_inscricao_estadual,
																CEP					= arguments.cob_cep,
																ENDERECO			= arguments.cob_endereco,
																MUNICIPIO_ID		= arguments.cob_municipio_id);
					</cfscript>
					<cfif cobran.erro>
						<cfthrow object="#cobran.mensagem#">
					</cfif>
				<cfelse>
					<cfscript>
						cobran = this.del_lote_cliente_cobranca(NUM_LOTE			= retorno.num_lote);
					</cfscript>
					<cfif cobran.erro>
						<cfthrow object="#cobran.mensagem#">
					</cfif>
				</cfif>
				
				<!--- Documentos --->
				<cfset lista_doctos = this.listconcat(lista1 = arguments.documento_embarcador,
													lista2 = arguments.documento_motorista,
													unique = 1)>
				<cfset lista_doctos = this.listconcat(lista1 = lista_doctos,
													lista2 = arguments.documento_fatura,
													unique = 1)>
				<cfloop list="#arguments.documentos_lote#" index="idx">
					<cfif not listfind(lista_doctos, idx)>
						<cfscript>
							v_docto = this.del_lote_docto(num_lote = retorno.num_lote,
														  documento_id = idx);
						</cfscript>
						<cfif v_docto.erro>
							<cfthrow object="#v_docto.mensagem#">
						</cfif>
					</cfif>
				</cfloop>
				<cfloop index="idx" list="#lista_doctos#" delimiters=",">
					<cfscript>
						v_docto = this.ins_lote_docto(num_lote = retorno.num_lote,
													documento_id = idx,
													embarcador = IIf(ListFind(arguments.documento_embarcador,idx,','),DE("1"),DE("0")),
													motorista = IIf(ListFind(arguments.documento_motorista,idx,','),DE("1"),DE("0")),
													faturista = IIf(ListFind(arguments.documento_fatura,idx,','),DE("1"),DE("0")));
					</cfscript>
					<cfif v_docto.erro>
						<cfthrow object="#v_docto.mensagem#">
					</cfif>
				</cfloop>
				
				<!--- Seguros --->
				<cfquery name="qrSeguro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select id_lote_seguro
					  from oper.v$lote_seguro
					 where num_lote = #retorno.num_lote#
				</cfquery>
				<cfif qrSeguro.recordcount>
					<cfscript>
						seg = this.upd_lote_seguro (NUM_LOTE					= retorno.num_lote, 
													ID_SEG_RCTR_C				= arguments.ID_SEG_RCTR_C,
													RCF_DC						= arguments.RCF_DC,
													RESPONSAVEL_RCF_DC			= arguments.RESPONSAVEL_RCF_DC,
													ID_SEG_RCF_DC				= arguments.ID_SEG_RCF_DC,
													VALOR_COB_RCF_DC_CLIENTE	= arguments.VALOR_COB_RCF_DC_CLIENTE,
													EXIGE_GERENCIADORA			= arguments.EXIGE_GERENCIADORA,
													COD_GERENCIADORA			= arguments.COD_GERENCIADORA,
													EXIGE_MONITORAMENTO			= arguments.EXIGE_MONITORAMENTO,
													COD_PESSOA_MONITORA			= arguments.COD_PESSOA_MONITORA,
													TIPO_VALOR_MERCADORIA		= arguments.TIPO_VALOR_MERCADORIA,
													VALOR_MEDIO_MERCADORIA		= arguments.VALOR_MEDIO_MERCADORIA,
													INTERVALO_MINUTO			= arguments.INTERVALO_MINUTO,
													RCTR_VI						= arguments.RCTR_VI,
													ID_SEG_RCTR_VI				= arguments.ID_SEG_RCTR_VI,
													OBSERVACAO					= arguments.OBSERVACAO,
													NUM_LIBERACAO_RCTR_C		= arguments.NUM_LIBERACAO_RCTR_C,
													NUM_LIBERACAO_RCF_DC		= arguments.NUM_LIBERACAO_RCF_DC,
													NUM_LIBERACAO_RCTR_VI		= arguments.NUM_LIBERACAO_RCTR_VI,
													COD_PESSOA_ESCOLTA			= arguments.COD_PESSOA_ESCOLTA,
													TIPO_ESCOLTA				= arguments.TIPO_ESCOLTA,
													RR							= arguments.RR,
													ID_SEG_RR					= arguments.ID_SEG_RR,
													NUM_LIBERACAO_RR			= arguments.NUM_LIBERACAO_RR,
													ID_LOTE_SEGURO				= qrSeguro.ID_LOTE_SEGURO);
					</cfscript>
				<cfelseif Len(Trim(arguments.ID_SEG_RCTR_C))>
					<cfscript>
						seg = this.ins_lote_seguro (NUM_LOTE					= retorno.num_lote, 
													ID_SEG_RCTR_C				= arguments.ID_SEG_RCTR_C,
													RCF_DC						= arguments.RCF_DC,
													RESPONSAVEL_RCF_DC			= arguments.RESPONSAVEL_RCF_DC,
													ID_SEG_RCF_DC				= arguments.ID_SEG_RCF_DC,
													VALOR_COB_RCF_DC_CLIENTE	= arguments.VALOR_COB_RCF_DC_CLIENTE,
													EXIGE_GERENCIADORA			= arguments.EXIGE_GERENCIADORA,
													COD_GERENCIADORA			= arguments.COD_GERENCIADORA,
													EXIGE_MONITORAMENTO			= arguments.EXIGE_MONITORAMENTO,
													COD_PESSOA_MONITORA			= arguments.COD_PESSOA_MONITORA,
													TIPO_VALOR_MERCADORIA		= arguments.TIPO_VALOR_MERCADORIA,
													VALOR_MEDIO_MERCADORIA		= arguments.VALOR_MEDIO_MERCADORIA,
													INTERVALO_MINUTO			= arguments.INTERVALO_MINUTO,
													RCTR_VI						= arguments.RCTR_VI,
													ID_SEG_RCTR_VI				= arguments.ID_SEG_RCTR_VI,
													OBSERVACAO					= arguments.OBSERVACAO,
													NUM_LIBERACAO_RCTR_C		= arguments.NUM_LIBERACAO_RCTR_C,
													NUM_LIBERACAO_RCF_DC		= arguments.NUM_LIBERACAO_RCF_DC,
													NUM_LIBERACAO_RCTR_VI		= arguments.NUM_LIBERACAO_RCTR_VI,
													COD_PESSOA_ESCOLTA			= arguments.COD_PESSOA_ESCOLTA,
													TIPO_ESCOLTA				= arguments.TIPO_ESCOLTA,
													RR							= arguments.RR,
													ID_SEG_RR					= arguments.ID_SEG_RR,
													NUM_LIBERACAO_RR			= arguments.NUM_LIBERACAO_RR);				
					</cfscript>
				</cfif>
				<cfif IsDefined("seg.erro") and seg.erro>
					<cfthrow object="#seg.mensagem#">
				</cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote n #NumberFormat(retorno.num_lote)# inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	
	<!--- 
	-- PROPSITO
	-- Altera um lote
	-- cristofer 28/12/2006 11:14:06 - CRIADO
	--->
	<cffunction name='upd_lote' displayname='Altera um lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_INICIO_RETIRADA' required='yes'>
		<cfargument name='DATA_PRAZO_RETIRADA' required='yes'>
		<cfargument name='DATA_CONTRATO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='PESO' required='yes'>
		
		<cfargument name='VOLUME' required='no' default="">
		<cfargument name='M3' required='no' default="">
		<cfargument name='FRETE_EM' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='QTDE_VIAGEM' required='no' default="">
		<cfargument name='FRETE_PROPRIO' required='yes'>
		<cfargument name='FRETE_VALOR_UNITARIO' required='no' default="">
		<cfargument name='FRETE_VALOR' required='no' default="0">
		<cfargument name='FRETE_POR_CONTA' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='PEDAGIO_INCLUSO' required='no' default="1">
		<cfargument name='SITUACAO_TRIBUTARIA' required='no' default="00">
		<cfargument name='ALIQUOTA_ICMS' required='no' default="0">
		<cfargument name='REDUCAO_BASE_CALCULO' required='no' default="0">
		<cfargument name='ICMS_INCLUSO' required='no' default="0">
		<cfargument name='DESTACA_BASE_CALC_ICMS' required='no' default="0">
		<cfargument name='FUNDAMENTACAO_LEGAL' required='no' default="">		
		
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='COLETA_LOGRADOURO' required='yes'>
		<cfargument name='COLETA_COMPLEMENTO' required='yes'>
		<cfargument name='COLETA_BAIRRO' required='yes'>
		<cfargument name='COLETA_CEP' required='yes'>
		<cfargument name='COLETA_COD_UF' required='no' default="">
		<cfargument name='COLETA_COD_MUNICIPIO' required='no' default="">
		<cfargument name='COLETA_COD_DV' required='no' default="">
		<cfargument name='COLETA_COD_DISTRITO' required='no' default="">

		<cfargument name='ENTREGA_LOGRADOURO' required='yes'>
		<cfargument name='ENTREGA_COMPLEMENTO' required='yes'>
		<cfargument name='ENTREGA_CEP' required='yes'>
		<cfargument name='ENTREGA_BAIRRO' required='yes'>

		<cfargument name='ENTREGA_COD_UF' required='no' default="">
		<cfargument name='ENTREGA_COD_MUNICIPIO' required='no' default="">
		<cfargument name='ENTREGA_COD_DISTRITO' required='no' default="">
		<cfargument name='ENTREGA_COD_DV' required='no' default="">

		<cfargument name='CONTROLE_PESO' required='no' default="0">
		<cfargument name='CONTROLE_VIAGEM' required='no' default="0">
		<cfargument name='CONTROLE_PESO_VEICULO' required='no' default="0">
		<cfargument name='SITUACAO_ID' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='NEGOCIADO_POR' required='no' default="">
		<cfargument name='NEGOCIADO_POR_TELEFONE' required='no' default="0">
		<cfargument name='NEGOCIADO_POR_EMAIL' required='no' default="0">
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='OBSERVACAO_EMITENTE' required='no' default="">
		<cfargument name='FRACIONADO' required='yes'>
		<cfargument name='SEGURO' required='no' default="1">
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
		<cfargument name='INTERNACIONAL' required='yes'>
		<cfargument name='DEDICADO' required='yes'>

		<cfargument name='DOCUMENTO_FATURA' required='no' default="">
		<cfargument name='DOCUMENTO_EMBARCADOR' required='no' default="">
		<cfargument name='DOCUMENTO_MOTORISTA' required='no' default="">

		<cfargument name='DOCUMENTOS_LOTE' required='no' default="">
		
		<cfargument name="ID_SEG_RCTR_C" required="yes">
		<cfargument name="RCF_DC" required="yes">
		<cfargument name="RESPONSAVEL_RCF_DC" required="yes">
		<cfargument name="ID_SEG_RCF_DC" required="yes">
		<cfargument name="VALOR_COB_RCF_DC_CLIENTE" required="yes">
		<cfargument name="EXIGE_GERENCIADORA" required="yes">
		<cfargument name="COD_GERENCIADORA" required="yes">
		<cfargument name="EXIGE_MONITORAMENTO" required="yes">
		<cfargument name="COD_PESSOA_MONITORA" required="yes">
		<cfargument name="TIPO_VALOR_MERCADORIA" required="yes">
		<cfargument name="VALOR_MEDIO_MERCADORIA" required="yes">
		<cfargument name="INTERVALO_MINUTO" required="yes">
		<cfargument name="RCTR_VI" required="yes">
		<cfargument name="ID_SEG_RCTR_VI" required="no" default="">
		<cfargument name="OBSERVACAO_SEG" required="no" default="">
		<cfargument name="NUM_LIBERACAO_RCTR_C" required="yes">
		<cfargument name="NUM_LIBERACAO_RCF_DC" required="yes">
		<cfargument name="NUM_LIBERACAO_RCTR_VI" required="yes">
		<cfargument name="COD_PESSOA_ESCOLTA" required="yes">
		<cfargument name="TIPO_ESCOLTA" required="yes">
		<cfargument name="RR" required="yes">
		<cfargument name="ID_SEG_RR" required="no" default="">
		<cfargument name="NUM_LIBERACAO_RR" required="yes">
		<cfargument name="ID_LOTE_SEGURO" required="no" default="">
		<cfargument name='COD_NEGOCIADOR' required='no' default="">

		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_alt_lote' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_INICIO_RETIRADA'  value='#arguments.DATA_INICIO_RETIRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_PRAZO_RETIRADA'  value='#arguments.DATA_PRAZO_RETIRADA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_CONTRATO'  value='#arguments.DATA_CONTRATO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FRETE_EM'  value='#arguments.FRETE_EM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_VIAGEM'  value='#arguments.QTDE_VIAGEM#'  null='#iif(len(trim(arguments.QTDE_VIAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_PROPRIO'  value='#arguments.FRETE_PROPRIO#'  null='#iif(len(trim(arguments.FRETE_PROPRIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR_UNITARIO'  value='#arguments.FRETE_VALOR_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_POR_CONTA'  value='#arguments.FRETE_POR_CONTA#'  null='#iif(len(trim(arguments.FRETE_POR_CONTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO_INCLUSO'  value='1'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SITUACAO_TRIBUTARIA'  value='#arguments.SITUACAO_TRIBUTARIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REDUCAO_BASE_CALCULO'  value='#arguments.REDUCAO_BASE_CALCULO#'  null='#iif(len(trim(arguments.REDUCAO_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_INCLUSO'  value='#arguments.ICMS_INCLUSO#'  null='#iif(len(trim(arguments.ICMS_INCLUSO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESTACA_BASE_CALC_ICMS'  value='#arguments.DESTACA_BASE_CALC_ICMS#'  null='#iif(len(trim(arguments.DESTACA_BASE_CALC_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL'  value='#arguments.FUNDAMENTACAO_LEGAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_COD_UF' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_COD_MUNICIPIO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_COD_DV' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_COD_DISTRITO' null="yes">
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.ENTREGA_LOGRADOURO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.ENTREGA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.ENTREGA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.ENTREGA_CEP#' >
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_COD_UF' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_COD_MUNICIPIO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_COD_DISTRITO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_COD_DV' null="yes">
					
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_PESO'  value='#arguments.CONTROLE_PESO#'  null='#iif(len(trim(arguments.CONTROLE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_VIAGEM'  value='#arguments.CONTROLE_VIAGEM#'  null='#iif(len(trim(arguments.CONTROLE_VIAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTROLE_PESO_VEICULO'  value='#arguments.CONTROLE_PESO_VEICULO#'  null='#iif(len(trim(arguments.CONTROLE_PESO_VEICULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SITUACAO_ID'  value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REGRA_FISCAL'  value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NEGOCIADO_POR'  value='#arguments.NEGOCIADO_POR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NEGOCIADO_POR_TELEFONE'  value='#arguments.NEGOCIADO_POR_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NEGOCIADO_POR_EMAIL'  value='#arguments.NEGOCIADO_POR_EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_EMITENTE'  value='#arguments.OBSERVACAO_EMITENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COM_RETORNO_EMBALAGEM'  value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REM_ENVIA_MONITORAMENTO'  value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DEST_ENVIA_MONITORAMENTO'  value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERMITE_LANCTOCTRC_ANTESMACR'  value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRACIONADO'  value='#arguments.FRACIONADO#'  null='#iif(len(trim(arguments.FRACIONADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEGURO'  value='#arguments.SEGURO#'  null='#iif(len(trim(arguments.SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INTERNACIONAL'  value='#arguments.INTERNACIONAL#'  null='#iif(len(trim(arguments.INTERNACIONAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DEDICADO'  value='#arguments.DEDICADO#'  null='#iif(len(trim(arguments.DEDICADO)), de('no'), de('yes'))#'>
		  	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.num_lote = arguments.num_lote>
				
				<!--- Insere o compartilhamento entre agencias --->
				<cfscript>
					compto = this.ins_lote_setor_compto(num_lote 			= retorno.num_lote,
														cod_pessoa_filial	= arguments.cod_pessoa_filial,
														cod_departamento	= arguments.cod_departamento,
														cod_setor			= arguments.cod_setor,
														cod_centro_custo	= arguments.cod_centro_custo,
														permite_destinar 	= 1);
				</cfscript>
				<cfif compto.erro>
					<cfthrow object="#compto.mensagem#">
				</cfif>
				
			
				<!--- Insere o compartilhamento entre agencias --->
				<cfscript>
					compto = this.ins_lote_setor_docto(num_lote 			= retorno.num_lote,
														cod_pessoa_filial	= arguments.cod_pessoa_filial,
														cod_departamento	= arguments.cod_departamento,
														cod_setor			= arguments.cod_setor,
														cod_centro_custo	= arguments.cod_centro_custo);
				</cfscript>
				<cfif compto.erro>
					<cfthrow object="#compto.mensagem#">
				</cfif>
				
				<!--- Consignatario --->
				<cfif len(trim(arguments.cod_consignatario))>
					<cfscript>
						consig = this.ins_lote_consignatario(	NUM_LOTE			= retorno.num_lote,
																COD_CONSIGNATARIO	= arguments.cod_consignatario,
																RAZAO_SOCIAL		= arguments.cons_razao_social,
																CEP					= arguments.cons_cep,
																ENDERECO			= arguments.cons_endereco,
																CNPJ_CPF			= arguments.cons_cnpj_cpf,
																INSCRICAO_ESTADUAL	= arguments.cons_inscricao_estadual,
																MUNICIPIO			= arguments.cons_municipio,
																UF					= arguments.cons_uf,
																MUNICIPIO_ID		= arguments.cons_municipio_id);
					</cfscript>
					<cfif consig.erro>
						<cfthrow object="#consig.mensagem#">
					</cfif>
				<cfelse>
					<cfscript>
						consig = this.del_lote_consignatario(	NUM_LOTE			= retorno.num_lote);
					</cfscript>
					<cfif consig.erro>
						<cfthrow object="#consig.mensagem#">
					</cfif>
				</cfif>
				
				<!--- Cliente Cobranca --->
				<cfif len(trim(arguments.cod_cliente_cobranca))>
					<cfscript>
						cobran = this.ins_lote_cliente_cobranca(NUM_LOTE			= retorno.num_lote,
																COD_CLIENTE_COBRANCA	= arguments.cod_cliente_cobranca,
																CNPJ_CPF			= arguments.cob_cnpj_cpf,
																RAZAO_SOCIAL		= arguments.cob_razao_social,
																INSCRICAO_ESTADUAL	= arguments.cob_inscricao_estadual,
																CEP					= arguments.cob_cep,
																ENDERECO			= arguments.cob_endereco,
																MUNICIPIO_ID		= arguments.cob_municipio_id);
					</cfscript>
					<cfif cobran.erro>
						<cfthrow object="#cobran.mensagem#">
					</cfif>
				<cfelse>
					<cfscript>
						cobran = this.del_lote_cliente_cobranca(NUM_LOTE			= retorno.num_lote);
					</cfscript>
					<cfif cobran.erro>
						<cfthrow object="#cobran.mensagem#">
					</cfif>
				</cfif>
				
				<!--- Documentos --->
				<cfset lista_doctos = this.listconcat(lista1 = arguments.documento_embarcador,
													lista2 = arguments.documento_motorista,
													unique = 1)>
				<cfset lista_doctos = this.listconcat(lista1 = lista_doctos,
													lista2 = arguments.documento_fatura,
													unique = 1)>
				<cfloop list="#arguments.documentos_lote#" index="idx">
					<cfif not listfind(lista_doctos, idx)>
						<cfscript>
							v_docto = this.del_lote_docto(num_lote = retorno.num_lote,
														  documento_id = idx);
						</cfscript>
						<cfif v_docto.erro>
							<cfthrow object="#v_docto.mensagem#">
						</cfif>
					</cfif>
				</cfloop>
				<cfloop index="idx" list="#lista_doctos#" delimiters=",">
					<cfscript>
						v_docto = this.ins_lote_docto(num_lote = retorno.num_lote,
													documento_id = idx,
													embarcador = IIf(ListFind(arguments.documento_embarcador,idx,','),DE("1"),DE("0")),
													motorista = IIf(ListFind(arguments.documento_motorista,idx,','),DE("1"),DE("0")),
													faturista = IIf(ListFind(arguments.documento_fatura,idx,','),DE("1"),DE("0")));
					</cfscript>
					<cfif v_docto.erro>
						<cfthrow object="#v_docto.mensagem#">
					</cfif>
				</cfloop>
				
				<!--- Seguros --->
				<cfquery name="qrSeguro" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
					select id_lote_seguro
					  from oper.v$lote_seguro
					 where num_lote = #retorno.num_lote#
				</cfquery>
				<cfif qrSeguro.recordcount>
					<cfscript>
						seg = this.upd_lote_seguro (NUM_LOTE					= retorno.num_lote, 
													ID_SEG_RCTR_C				= arguments.ID_SEG_RCTR_C,
													RCF_DC						= arguments.RCF_DC,
													RESPONSAVEL_RCF_DC			= arguments.RESPONSAVEL_RCF_DC,
													ID_SEG_RCF_DC				= arguments.ID_SEG_RCF_DC,
													VALOR_COB_RCF_DC_CLIENTE	= arguments.VALOR_COB_RCF_DC_CLIENTE,
													EXIGE_GERENCIADORA			= arguments.EXIGE_GERENCIADORA,
													COD_GERENCIADORA			= arguments.COD_GERENCIADORA,
													EXIGE_MONITORAMENTO			= arguments.EXIGE_MONITORAMENTO,
													COD_PESSOA_MONITORA			= arguments.COD_PESSOA_MONITORA,
													TIPO_VALOR_MERCADORIA		= arguments.TIPO_VALOR_MERCADORIA,
													VALOR_MEDIO_MERCADORIA		= arguments.VALOR_MEDIO_MERCADORIA,
													INTERVALO_MINUTO			= arguments.INTERVALO_MINUTO,
													RCTR_VI						= arguments.RCTR_VI,
													ID_SEG_RCTR_VI				= arguments.ID_SEG_RCTR_VI,
													OBSERVACAO					= arguments.OBSERVACAO,
													NUM_LIBERACAO_RCTR_C		= arguments.NUM_LIBERACAO_RCTR_C,
													NUM_LIBERACAO_RCF_DC		= arguments.NUM_LIBERACAO_RCF_DC,
													NUM_LIBERACAO_RCTR_VI		= arguments.NUM_LIBERACAO_RCTR_VI,
													COD_PESSOA_ESCOLTA			= arguments.COD_PESSOA_ESCOLTA,
													TIPO_ESCOLTA				= arguments.TIPO_ESCOLTA,
													RR							= arguments.RR,
													ID_SEG_RR					= arguments.ID_SEG_RR,
													NUM_LIBERACAO_RR			= arguments.NUM_LIBERACAO_RR,
													ID_LOTE_SEGURO				= qrSeguro.ID_LOTE_SEGURO);
					</cfscript>
				<cfelseif Len(Trim(arguments.ID_SEG_RCTR_C))>
					<cfscript>
						seg = this.ins_lote_seguro (NUM_LOTE					= retorno.num_lote, 
													ID_SEG_RCTR_C				= arguments.ID_SEG_RCTR_C,
													RCF_DC						= arguments.RCF_DC,
													RESPONSAVEL_RCF_DC			= arguments.RESPONSAVEL_RCF_DC,
													ID_SEG_RCF_DC				= arguments.ID_SEG_RCF_DC,
													VALOR_COB_RCF_DC_CLIENTE	= arguments.VALOR_COB_RCF_DC_CLIENTE,
													EXIGE_GERENCIADORA			= arguments.EXIGE_GERENCIADORA,
													COD_GERENCIADORA			= arguments.COD_GERENCIADORA,
													EXIGE_MONITORAMENTO			= arguments.EXIGE_MONITORAMENTO,
													COD_PESSOA_MONITORA			= arguments.COD_PESSOA_MONITORA,
													TIPO_VALOR_MERCADORIA		= arguments.TIPO_VALOR_MERCADORIA,
													VALOR_MEDIO_MERCADORIA		= arguments.VALOR_MEDIO_MERCADORIA,
													INTERVALO_MINUTO			= arguments.INTERVALO_MINUTO,
													RCTR_VI						= arguments.RCTR_VI,
													ID_SEG_RCTR_VI				= arguments.ID_SEG_RCTR_VI,
													OBSERVACAO					= arguments.OBSERVACAO,
													NUM_LIBERACAO_RCTR_C		= arguments.NUM_LIBERACAO_RCTR_C,
													NUM_LIBERACAO_RCF_DC		= arguments.NUM_LIBERACAO_RCF_DC,
													NUM_LIBERACAO_RCTR_VI		= arguments.NUM_LIBERACAO_RCTR_VI,
													COD_PESSOA_ESCOLTA			= arguments.COD_PESSOA_ESCOLTA,
													TIPO_ESCOLTA				= arguments.TIPO_ESCOLTA,
													RR							= arguments.RR,
													ID_SEG_RR					= arguments.ID_SEG_RR,
													NUM_LIBERACAO_RR			= arguments.NUM_LIBERACAO_RR);				
					</cfscript>
				</cfif>
				<cfif IsDefined("seg.erro") and seg.erro>
					<cfthrow object="#seg.mensagem#">
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um lote
	-- cristofer 26/12/2006 14:41:57 - CRIADO
	--->
	<cffunction name='del_lote' displayname='Insere um lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_del_lote' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote n #NumberFormat(arguments.num_lote)# excluido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um lote
	-- cristofer 26/12/2006 15:04:38 - CRIADO
	--->
	<cffunction name='ins_lote_docto' displayname='Insere um lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='EMBARCADOR' required='yes'>
		<cfargument name='FATURISTA' required='yes'>
		<cfargument name='MOTORISTA' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_alt_lote_docto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EMBARCADOR'  value='#arguments.EMBARCADOR#'  null='#iif(len(trim(arguments.EMBARCADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FATURISTA'  value='#arguments.FATURISTA#'  null='#iif(len(trim(arguments.FATURISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MOTORISTA'  value='#arguments.MOTORISTA#'  null='#iif(len(trim(arguments.MOTORISTA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento vinculado ao lote com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um documento do lote
	-- cristofer 26/12/2006 15:04:38 - CRIADO
	--->
	<cffunction name='del_lote_docto' displayname='Insere um lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_del_lote_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento desvinculado do lote com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere ou altera o cliente de cobranca do lote
	-- cristofer 28/12/2006 10:30:45 - CRIADO
	--->
	<cffunction name='ins_lote_cliente_cobranca' displayname='Insere ou altera o cliente de cobranca do lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='CNPJ_CPF' required='yes'>
		<cfargument name='RAZAO_SOCIAL' required='yes'>
		<cfargument name='INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='CEP' required='yes'>
		<cfargument name='ENDERECO' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_ins_lote_cliente_cobranca' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE_COBRANCA'  value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CNPJ_CPF'  value='#arguments.CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RAZAO_SOCIAL'  value='#arguments.RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INSCRICAO_ESTADUAL'  value='#arguments.INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CEP'  value='#arguments.CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENDERECO'  value='#arguments.ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui o cliente de cobranca do lote
	-- cristofer 28/12/2006 10:31:27 - CRIADO
	--->
	<cffunction name='del_lote_cliente_cobranca' displayname='Exclui o cliente de cobranca do lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_del_lote_cliente_cobranca' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Insere ou altera o consignatario do lote
	-- cristofer 28/12/2006 10:33:03 - CRIADO
	--->
	<cffunction name='ins_lote_consignatario' displayname='Insere ou altera o consignatario do lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='COD_CONSIGNATARIO' required='yes'>
		<cfargument name='RAZAO_SOCIAL' required='yes'>
		<cfargument name='CEP' required='yes'>
		<cfargument name='ENDERECO' required='yes'>
		<cfargument name='CNPJ_CPF' required='yes'>
		<cfargument name='INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='MUNICIPIO' required='yes'>
		<cfargument name='UF' required='yes'>
		<cfargument name='MUNICIPIO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_alt_lote_consignatario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONSIGNATARIO'  value='#arguments.COD_CONSIGNATARIO#'  null='#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RAZAO_SOCIAL'  value='#arguments.RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CEP'  value='#arguments.CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENDERECO'  value='#arguments.ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CNPJ_CPF'  value='#arguments.CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INSCRICAO_ESTADUAL'  value='#arguments.INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MUNICIPIO'  value='#arguments.MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF'  value='#arguments.UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_UF' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MUNICIPIO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DV' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DISTRITO' null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MUNICIPIO_ID'  value='#arguments.MUNICIPIO_ID#'  null='#iif(len(trim(arguments.MUNICIPIO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui o consignatario do lote
	-- cristofer 28/12/2006 10:34:11 - CRIADO
	--->
	<cffunction name='del_lote_consignatario' displayname='Exclui o consignatario do lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cftry>
				<cfquery name="qrConsignatario" datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					select cod_consignatario
					  from oper.v$lote_consignatario
					 where num_lote = #arguments.num_lote#
				</cfquery>
				<cfoutput query="qrConsignatario">
					<cfstoredproc procedure='oper.pkg_lote_dml.prc_del_lote_consignatario' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONSIGNATARIO'  value='#qrConsignatario.COD_CONSIGNATARIO#'>
					</cfstoredproc>
				</cfoutput>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere um compartilhamento do lote entre agencias
	-- cristofer 28/12/2006 13:55:20 - CRIADO
	--->
	<cffunction name='ins_lote_setor_compto' displayname='Insere um compartilhamento do lote entre agencias' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='PERMITE_DESTINAR' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_alt_lote_setor_compto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERMITE_DESTINAR'  value='#arguments.PERMITE_DESTINAR#'  null='#iif(len(trim(arguments.PERMITE_DESTINAR)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Compartilhamento inserido com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um compartilhamento do lote entre agencias
	-- cristofer 28/12/2006 14:08:23 - CRIADO
	--->
	<cffunction name='ins_lote_setor_docto' displayname='Insere um compartilhamento do lote entre agencias' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_alt_lote_setor_docto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere o seguro no lote
	-- cristofer 28/12/2006 14:56:27 - CRIADO
	--->
	<cffunction name='ins_lote_seguro' displayname='Insere o seguro no lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='ID_SEG_RCTR_C' required='yes'>
		<cfargument name='RCF_DC' required='yes'>
		<cfargument name='RESPONSAVEL_RCF_DC' required='yes'>
		<cfargument name='ID_SEG_RCF_DC' required='yes'>
		<cfargument name='VALOR_COB_RCF_DC_CLIENTE' required='yes'>
		<cfargument name='EXIGE_GERENCIADORA' required='yes'>
		<cfargument name='COD_GERENCIADORA' required='yes'>
		<cfargument name='EXIGE_MONITORAMENTO' required='yes'>
		<cfargument name='COD_PESSOA_MONITORA' required='yes'>
		<cfargument name='TIPO_VALOR_MERCADORIA' required='yes'>
		<cfargument name='VALOR_MEDIO_MERCADORIA' required='yes'>
		<cfargument name='INTERVALO_MINUTO' required='yes'>
		<cfargument name='RCTR_VI' required='yes'>
		<cfargument name='ID_SEG_RCTR_VI' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='NUM_LIBERACAO_RCTR_C' required='yes'>
		<cfargument name='NUM_LIBERACAO_RCF_DC' required='yes'>
		<cfargument name='NUM_LIBERACAO_RCTR_VI' required='yes'>
		<cfargument name='COD_PESSOA_ESCOLTA' required='yes'>
		<cfargument name='TIPO_ESCOLTA' required='yes'>
		<cfargument name='RR' required='yes'>
		<cfargument name='ID_SEG_RR' required='yes'>
		<cfargument name='NUM_LIBERACAO_RR' required='yes'>
		<cfargument name='ID_LOTE_SEGURO' required='no' default="">
		<cfargument name='ROWID' required='no' default="">
		<cftry>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_ins_lote_seguro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_SEG_RCTR_C'  value='#arguments.ID_SEG_RCTR_C#'  null='#iif(len(trim(arguments.ID_SEG_RCTR_C)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RCF_DC'  value='#arguments.RCF_DC#'  null='#iif(len(trim(arguments.RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESPONSAVEL_RCF_DC'  value='#arguments.RESPONSAVEL_RCF_DC#'  null='#iif(len(trim(arguments.RESPONSAVEL_RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_SEG_RCF_DC'  value='#arguments.ID_SEG_RCF_DC#'  null='#iif(len(trim(arguments.ID_SEG_RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_COB_RCF_DC_CLIENTE'  value='#arguments.VALOR_COB_RCF_DC_CLIENTE#'  null='#iif(len(trim(arguments.VALOR_COB_RCF_DC_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EXIGE_GERENCIADORA'  value='#arguments.EXIGE_GERENCIADORA#'  null='#iif(len(trim(arguments.EXIGE_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_GERENCIADORA'  value='#arguments.COD_GERENCIADORA#'  null='#iif(len(trim(arguments.COD_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EXIGE_MONITORAMENTO'  value='#arguments.EXIGE_MONITORAMENTO#'  null='#iif(len(trim(arguments.EXIGE_MONITORAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_MONITORA'  value='#arguments.COD_PESSOA_MONITORA#'  null='#iif(len(trim(arguments.COD_PESSOA_MONITORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_VALOR_MERCADORIA'  value='#arguments.TIPO_VALOR_MERCADORIA#'  null='#iif(len(trim(arguments.TIPO_VALOR_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_MEDIO_MERCADORIA'  value='#arguments.VALOR_MEDIO_MERCADORIA#'  null='#iif(len(trim(arguments.VALOR_MEDIO_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INTERVALO_MINUTO'  value='#arguments.INTERVALO_MINUTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RCTR_VI'  value='#arguments.RCTR_VI#'  null='#iif(len(trim(arguments.RCTR_VI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_SEG_RCTR_VI'  value='#arguments.ID_SEG_RCTR_VI#'  null='#iif(len(trim(arguments.ID_SEG_RCTR_VI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LIBERACAO_RCTR_C'  value='#arguments.NUM_LIBERACAO_RCTR_C#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LIBERACAO_RCF_DC'  value='#arguments.NUM_LIBERACAO_RCF_DC#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LIBERACAO_RCTR_VI'  value='#arguments.NUM_LIBERACAO_RCTR_VI#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_ESCOLTA'  value='#arguments.COD_PESSOA_ESCOLTA#'  null='#iif(len(trim(arguments.COD_PESSOA_ESCOLTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_ESCOLTA'  value='#arguments.TIPO_ESCOLTA#'  null='#iif(len(trim(arguments.TIPO_ESCOLTA)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RR'  value='#arguments.RR#'  null='#iif(len(trim(arguments.RR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_SEG_RR'  value='#arguments.ID_SEG_RR#'  null='#iif(len(trim(arguments.ID_SEG_RR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LIBERACAO_RR'  value='#arguments.NUM_LIBERACAO_RR#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_LOTE_SEGURO'  value='#arguments.ID_LOTE_SEGURO#' variable='retorno.ID_LOTE_SEGURO'  null='#iif(len(trim(arguments.ID_LOTE_SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID'  value='#arguments.ROWID#' variable='retorno.ROWID'  null='#iif(len(trim(arguments.ROWID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera o seguro no lote
	-- cristofer 28/12/2006 14:57:09 - CRIADO
	--->
	<cffunction name='upd_lote_seguro' displayname='Altera o seguro no lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='ID_SEG_RCTR_C' required='yes'>
		<cfargument name='RCF_DC' required='yes'>
		<cfargument name='RESPONSAVEL_RCF_DC' required='yes'>
		<cfargument name='ID_SEG_RCF_DC' required='yes'>
		<cfargument name='VALOR_COB_RCF_DC_CLIENTE' required='yes'>
		<cfargument name='EXIGE_GERENCIADORA' required='yes'>
		<cfargument name='COD_GERENCIADORA' required='yes'>
		<cfargument name='EXIGE_MONITORAMENTO' required='yes'>
		<cfargument name='COD_PESSOA_MONITORA' required='yes'>
		<cfargument name='TIPO_VALOR_MERCADORIA' required='yes'>
		<cfargument name='VALOR_MEDIO_MERCADORIA' required='yes'>
		<cfargument name='INTERVALO_MINUTO' required='yes'>
		<cfargument name='RCTR_VI' required='yes'>
		<cfargument name='ID_SEG_RCTR_VI' required='yes'>
		<cfargument name='NUM_LIBERACAO_RCTR_C' required='yes'>
		<cfargument name='NUM_LIBERACAO_RCF_DC' required='yes'>
		<cfargument name='NUM_LIBERACAO_RCTR_VI' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='COD_PESSOA_ESCOLTA' required='yes'>
		<cfargument name='TIPO_ESCOLTA' required='yes'>
		<cfargument name='RR' required='yes'>
		<cfargument name='ID_SEG_RR' required='yes'>
		<cfargument name='NUM_LIBERACAO_RR' required='yes'>
		<cfargument name='ID_LOTE_SEGURO' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_alt_lote_seguro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_SEG_RCTR_C'  value='#arguments.ID_SEG_RCTR_C#'  null='#iif(len(trim(arguments.ID_SEG_RCTR_C)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RCF_DC'  value='#arguments.RCF_DC#'  null='#iif(len(trim(arguments.RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RESPONSAVEL_RCF_DC'  value='#arguments.RESPONSAVEL_RCF_DC#'  null='#iif(len(trim(arguments.RESPONSAVEL_RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_SEG_RCF_DC'  value='#arguments.ID_SEG_RCF_DC#'  null='#iif(len(trim(arguments.ID_SEG_RCF_DC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_COB_RCF_DC_CLIENTE'  value='#arguments.VALOR_COB_RCF_DC_CLIENTE#'  null='#iif(len(trim(arguments.VALOR_COB_RCF_DC_CLIENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EXIGE_GERENCIADORA'  value='#arguments.EXIGE_GERENCIADORA#'  null='#iif(len(trim(arguments.EXIGE_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_GERENCIADORA'  value='#arguments.COD_GERENCIADORA#'  null='#iif(len(trim(arguments.COD_GERENCIADORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EXIGE_MONITORAMENTO'  value='#arguments.EXIGE_MONITORAMENTO#'  null='#iif(len(trim(arguments.EXIGE_MONITORAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_MONITORA'  value='#arguments.COD_PESSOA_MONITORA#'  null='#iif(len(trim(arguments.COD_PESSOA_MONITORA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_VALOR_MERCADORIA'  value='#arguments.TIPO_VALOR_MERCADORIA#'  null='#iif(len(trim(arguments.TIPO_VALOR_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_MEDIO_MERCADORIA'  value='#arguments.VALOR_MEDIO_MERCADORIA#'  null='#iif(len(trim(arguments.VALOR_MEDIO_MERCADORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INTERVALO_MINUTO'  value='#arguments.INTERVALO_MINUTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RCTR_VI'  value='#arguments.RCTR_VI#'  null='#iif(len(trim(arguments.RCTR_VI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_SEG_RCTR_VI'  value='#arguments.ID_SEG_RCTR_VI#'  null='#iif(len(trim(arguments.ID_SEG_RCTR_VI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LIBERACAO_RCTR_C'  value='#arguments.NUM_LIBERACAO_RCTR_C#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LIBERACAO_RCF_DC'  value='#arguments.NUM_LIBERACAO_RCF_DC#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LIBERACAO_RCTR_VI'  value='#arguments.NUM_LIBERACAO_RCTR_VI#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_ESCOLTA'  value='#arguments.COD_PESSOA_ESCOLTA#'  null='#iif(len(trim(arguments.COD_PESSOA_ESCOLTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_ESCOLTA'  value='#arguments.TIPO_ESCOLTA#'  null='#iif(len(trim(arguments.TIPO_ESCOLTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RR'  value='#arguments.RR#'  null='#iif(len(trim(arguments.RR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_SEG_RR'  value='#arguments.ID_SEG_RR#'  null='#iif(len(trim(arguments.ID_SEG_RR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_LIBERACAO_RR'  value='#arguments.NUM_LIBERACAO_RR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_LOTE_SEGURO'  value='#arguments.ID_LOTE_SEGURO#'  null='#iif(len(trim(arguments.ID_LOTE_SEGURO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui o seguro no lote
	-- cristofer 28/12/2006 14:57:46 - CRIADO
	--->
	<cffunction name='del_lote_seguro' displayname='Exclui o seguro no lote' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_LOTE' required='yes'>
		<cfargument name='ID_LOTE_SEGURO' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_lote_dml.prc_del_lote_seguro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_LOTE'  value='#arguments.NUM_LOTE#'  null='#iif(len(trim(arguments.NUM_LOTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ID_LOTE_SEGURO'  value='#arguments.ID_LOTE_SEGURO#'  null='#iif(len(trim(arguments.ID_LOTE_SEGURO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Lote alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Insere nota fiscal de ES
	-- guto 10/02/2007 10:11:33 - CRIADO
	--->
	<cffunction name='ins_nota_fiscal_es' displayname='Insere nota fiscal de ES' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='NUM_NOTA_FISCAL' required='yes'>
		<cfargument name='COD_MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='E_S' required='yes'>
		<cfargument name='SERVICO' required='yes'>
		<cfargument name='INSCRICAO_ESTADUAL_SUBSTITUT' required='no' default="">
		<cfargument name='NATUREZA_ID' required='yes'>
		<cfargument name='NATUREZA_DESCRICAO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_ES' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO' required='yes'>
		<cfargument name='DEST_UF' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_TELEFONE' required='yes'>
		<cfargument name='DEST_CNPJ_CPF' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='NF_IMPOSTO_ID' required='no' default="">
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NOTA' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='CALC_BASE_ICMS' required='no' default="0">
		<cfargument name='CALC_VALOR_ICMS' required='no' default="0">
		<cfargument name='CALC_BASE_ICMS_SUBST' required='no' default="0">
		<cfargument name='CALC_VALOR_ICMS_SUBST' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_PRODUTOS' required='no' default="0">
		<cfargument name='CALC_VALOR_FRETE' required='no' default="0">
		<cfargument name='CALC_VALOR_SEGURO' required='no' default="0">
		<cfargument name='CALC_OUTRAS_DESPESAS' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_IPI' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_NOTA' required='yes'>
		<cfargument name='COD_TRANSPORTADOR' required='no' default="">
		<cfargument name='TRP_RAZAO_SOCIAL' required='no' default="">
		<cfargument name='TRP_ENDERECO' required='no' default="">
		<cfargument name='TRP_MUNICIPIO' required='no' default="">
		<cfargument name='TRP_UF' required='no' default="">
		<cfargument name='TRP_CNPJ_CPF' required='no' default="">
		<cfargument name='TRP_INSCRICAO_ESTADUAL' required='no' default="">
		<cfargument name='TRP_PLACA' required='no' default="">
		<cfargument name='TRP_PLACA_UF' required='no' default="1">
		<cfargument name='TRP_FRETE_POR' required='no' default="1">
		<cfargument name='TRP_QUANTIDADE' required='no' default="">
		<cfargument name='TRP_ESPECIE' required='no' default="">
		<cfargument name='TRP_MARCA' required='no' default="">
		<cfargument name='TRP_NUMERO' required='no' default="">
		<cfargument name='TRP_PESO_BRUTO' required='no' default="0">
		<cfargument name='TRP_PESO_LIQUIDO' required='no' default="0">
		<cfargument name='INFO_COMPLEMENTARES' required='yes'>
		<cfargument name='RESERVADO_FISCO' required='no' default="Este campo destina-se a preencher o campo Reservado ao Fisco da nota fiscal de E/S, quando da insero da mesma.">
		<cfargument name='OBSERVACAO_FISCAL' required='no' default="">
		<cfargument name='OBSERVACAO_USUARIO' required='no' default="">
		<cfargument name='CONVERSAO_TAXA' required='no' default="">
		<cfargument name='EMITIDA' required='no' default="1">
		<cfargument name='MANUAL' required='no' default="1">
		<cfargument name='CONVERSAO_MOEDA' required='no' default="220">
		<cfargument name='TIPO_RECOLHIMENTO_ISS' required='yes'>
		<cfargument name='COD_SERVICO_DES' required='no' default="">
		<cfargument name='NATUREZA_SISS_ID' required='no' default="">
		<cfargument name='INCLUIR_SISS' required='no' default="1">
		<cfargument name='AVISTA_APRAZO' required='yes'>
        <cfargument name='CONTABILIZA' required='no' default="1">
        <cfargument name='NATUREZA_OPERACAO' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='COD_ORGANIZACIONAL' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es_manual' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#' variable='retorno.NUM_NOTA_ID'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_E_S'  value='#arguments.E_S#'  null='#iif(len(trim(arguments.E_S)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERVICO'  value='#arguments.SERVICO#'  null='#iif(len(trim(arguments.SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INSCRICAO_ESTADUAL_SUBSTITUT'  value='#arguments.INSCRICAO_ESTADUAL_SUBSTITUT#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NATUREZA_ID'  value='#arguments.NATUREZA_ID#'  null='#iif(len(trim(arguments.NATUREZA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_DESCRICAO'  value='#arguments.NATUREZA_DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ES'  value='#arguments.DATA_ES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_TELEFONE'  value='#arguments.DEST_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_NOTA'  value='#arguments.SERV_TOTAL_NOTA#'  null='#iif(len(trim(arguments.SERV_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS'  value='#arguments.CALC_BASE_ICMS#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS'  value='#arguments.CALC_VALOR_ICMS#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS_SUBST'  value='#arguments.CALC_BASE_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS_SUBST'  value='#arguments.CALC_VALOR_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_PRODUTOS'  value='#arguments.CALC_VALOR_TOTAL_PRODUTOS#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_FRETE'  value='#arguments.CALC_VALOR_FRETE#'  null='#iif(len(trim(arguments.CALC_VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_SEGURO'  value='#arguments.CALC_VALOR_SEGURO#'  null='#iif(len(trim(arguments.CALC_VALOR_SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_OUTRAS_DESPESAS'  value='#arguments.CALC_OUTRAS_DESPESAS#'  null='#iif(len(trim(arguments.CALC_OUTRAS_DESPESAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_IPI'  value='#arguments.CALC_VALOR_TOTAL_IPI#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_IPI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_NOTA'  value='#arguments.CALC_VALOR_TOTAL_NOTA#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_RAZAO_SOCIAL'  value='#arguments.TRP_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ENDERECO'  value='#arguments.TRP_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MUNICIPIO'  value='#arguments.TRP_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_UF'  value='#arguments.TRP_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_CNPJ_CPF'  value='#arguments.TRP_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_INSCRICAO_ESTADUAL'  value='#arguments.TRP_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA'  value='#arguments.TRP_PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA_UF'  value='#arguments.TRP_PLACA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_FRETE_POR'  value='#arguments.TRP_FRETE_POR#'  null='#iif(len(trim(arguments.TRP_FRETE_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_QUANTIDADE'  value='#arguments.TRP_QUANTIDADE#'  null='#iif(len(trim(arguments.TRP_QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ESPECIE'  value='#arguments.TRP_ESPECIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MARCA'  value='#arguments.TRP_MARCA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_NUMERO'  value='#arguments.TRP_NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_PESO_BRUTO'  value='#arguments.TRP_PESO_BRUTO#'  null='#iif(len(trim(arguments.TRP_PESO_BRUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_PESO_LIQUIDO'  value='#arguments.TRP_PESO_LIQUIDO#'  null='#iif(len(trim(arguments.TRP_PESO_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFO_COMPLEMENTARES'  value='#arguments.INFO_COMPLEMENTARES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESERVADO_FISCO'  value='#arguments.RESERVADO_FISCO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_FISCAL'  value='#arguments.OBSERVACAO_FISCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#REReplace(arguments.OBSERVACAO_USUARIO,'','-')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONVERSAO_TAXA'  value='#arguments.CONVERSAO_TAXA#'  null='#iif(len(trim(arguments.CONVERSAO_TAXA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_EMITIDA'  value='#arguments.EMITIDA#'  null='#iif(len(trim(arguments.EMITIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MANUAL'  value='#arguments.MANUAL#'  null='#iif(len(trim(arguments.MANUAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONVERSAO_MOEDA'  value='#arguments.CONVERSAO_MOEDA#'  null='#iif(len(trim(arguments.CONVERSAO_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_RECOLHIMENTO_ISS'  value='#arguments.TIPO_RECOLHIMENTO_ISS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_SERVICO_DES'  value='#arguments.COD_SERVICO_DES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_SISS_ID'  value='#arguments.NATUREZA_SISS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_SISS'  value='#arguments.INCLUIR_SISS#'  null='#iif(len(trim(arguments.INCLUIR_SISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AVISTA_APRAZO'  value='#arguments.AVISTA_APRAZO#'  null='#iif(len(trim(arguments.AVISTA_APRAZO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='CONTABILIZA'  value='#arguments.CONTABILIZA#'  null='#iif(len(trim(arguments.CONTABILIZA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#'  null='#iif(len(trim(arguments.NATUREZA_OPERACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANIZACIONAL'  value='#arguments.COD_ORGANIZACIONAL#' >
				</cfstoredproc>
				<!---Insere Itens--->
				<cfscript>
					arguments.num_nota_id = retorno.num_nota_id;
					V_ES = this.ListaToArray(lista = arguments, variavel = "ES_SERVICOS");
					V_NUM_NOTA_IT_ID = this.ListaToArray(lista = arguments, variavel = "NUM_NOTA_IT_ID_SERVICOS");
					V_CFOP = this.ListaToArray(lista = arguments, variavel = "CFOP_SERVICOS");
					V_CFOP_ID = this.ListaToArray(lista = arguments, variavel = "CFOP_ID_SERVICOS");
					V_PRODUTO_ID = this.ListaToArray(lista = arguments, variavel = "PRODUTO_ID_SERVICOS");
					V_DESCRICAO = this.ListaToArray(lista = arguments, variavel = "DESCRICAO_SERVICOS");
					V_DESCRICAO_COMPLEMENTO = this.ListaToArray(lista = arguments, variavel = "DESCRICAO_COMPLEMENTO_SERVICOS");
					V_COD_NCM = this.ListaToArray(lista = arguments, variavel = "COD_NCM_SERVICOS");
					V_ST_ORIGEM_ID = this.ListaToArray(lista = arguments, variavel = "ST_ORIGEM_ID_SERVICOS");
					V_ST_ICMS_ID = this.ListaToArray(lista = arguments, variavel = "ST_ICMS_ID_SERVICOS");
					V_COD_UNIDADE = this.ListaToArray(lista = arguments, variavel = "COD_UNIDADE_SERVICOS");
					V_QTDE_PESO = this.ListaToArray(lista = arguments, variavel = "QTDE_PESO_SERVICOS");
					V_QTDE_VOLUME = this.ListaToArray(lista = arguments, variavel = "QTDE_VOLUME_SERVICOS");
					V_QTDE_METRO = this.ListaToArray(lista = arguments, variavel = "QTDE_METRO_SERVICOS");
					V_VALOR_EM = this.ListaToArray(lista = arguments, variavel = "VALOR_EM_SERVICOS");
					V_VALOR_EM_UNIDADE = this.ListaToArray(lista = arguments, variavel = "VALOR_EM_UNIDADE_SERVICOS");
					V_VALOR_UNITARIO = this.ListaToArray(lista = arguments, variavel = "VALOR_UNITARIO_SERVICOS");
					V_VALOR_TOTAL = this.ListaToArray(lista = arguments, variavel = "VALOR_TOTAL_SERVICOS");
					V_SERV_TOTAL_TRIBUTAVEL = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_TRIBUTAVEL_SERVICOS");
					V_SERV_TOTAL_NAO_TRIBUTAVEL = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_NAO_TRIBUTAVEL_SERVICOS");
					V_SERV_TOTAL_PRODUTO = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_PRODUTO_SERVICOS");
					V_SERV_ISS_ALIQUOTA = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_ALIQUOTA_SERVICOS");
					V_SERV_ISS_DEDUCAO = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_DEDUCAO_SERVICOS");
					V_SERV_ISS_VALOR = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_VALOR_SERVICOS");
					V_INCLUIR_LIVRO_FISCAL = this.ListaToArray(lista = arguments, variavel = "INCLUIR_LIVRO_FISCAL_SERVICOS");
					V_INCLUIR_SINTEGRA = this.ListaToArray(lista = arguments, variavel = "INCLUIR_SINTEGRA_SERVICOS");
					V_UF_UNIDADE_NEGOCIO = this.ListaToArray(lista = arguments, variavel = "UF_UNIDADE_NEGOCIO_SERVICOS");
					V_UF_DESTINATARIO = this.ListaToArray(lista = arguments, variavel = "UF_DESTINATARIO_SERVICOS");
				</cfscript>			
				<cfloop from="1" to="#ArrayLen(V_ES)#" index="count">
					<cfscript>
						this.ins_nota_fiscal_es_it( es = v_es[count],
													num_nota_id = retorno.NUM_NOTA_ID,
													cfop = v_cfop[count],
													cfop_id = v_cfop_id[count],
													produto_id = v_produto_id[count],
													descricao = v_descricao[count],
													descricao_complemento = v_descricao_complemento[count],
													cod_ncm = v_cod_ncm[count],
													st_origem_id = v_st_origem_id[count], 
													st_icms_id = v_st_icms_id[count],
													cod_unidade = v_cod_unidade[count],
													qtde_peso = v_qtde_peso[count],
													qtde_volume = v_qtde_volume[count],
													qtde_metro = v_qtde_metro[count],
													valor_em = v_valor_em[count],
													valor_em_unidade = v_valor_em_unidade[count],
													valor_unitario = v_valor_unitario[count],
													valor_total = v_valor_total[count],
													serv_total_tributavel = v_serv_total_tributavel[count],
													serv_total_nao_tributavel = v_serv_total_nao_tributavel[count],
													serv_total_produto = v_serv_total_produto[count],
													serv_iss_aliquota = v_serv_iss_aliquota[count],
													serv_iss_deducao = v_serv_iss_deducao[count],
													serv_iss_valor = v_serv_iss_valor[count],
													incluir_livro_fiscal = v_incluir_livro_fiscal[count],
													uf_unidade_negocio = v_uf_unidade_negocio[count],
													uf_destinatario = v_uf_destinatario[count],
													incluir_sintegra = v_incluir_sintegra[count]);
					</cfscript>	
				</cfloop>
				
				<cfscript>
					V_IMPOSTO_ID 				= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ID_ITENS_IMPOSTO");
					V_NF_IMPOSTO_ID 			= this.ListaToArray(lista = arguments, variavel = "NF_IMPOSTO_ID_ITENS_IMPOSTO");
					V_IMPOSTO_REDUCAO_BASE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_REDUCAO_BASE_ITENS_IMPOSTO");
					V_IMPOSTO_BASE_CALCULO 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_BASE_CALCULO_ITENS_IMPOSTO");
					V_IMPOSTO_ALIQUOTA 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ALIQUOTA_ITENS_IMPOSTO");
					V_IMPOSTO_TOTAL 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_TOTAL_ITENS_IMPOSTO");
					V_IMPOSTO_DATA_VENCIMENTO 	= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_DATA_VENCIMENTO_ITENS_IMPOSTO");
					V_IMPOSTO_RETIDO_FONTE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_RETIDO_FONTE_ITENS_IMPOSTO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ITENS_IMPOSTO, lista2 = ArrayToList(V_NF_IMPOSTO_ID));
				</cfscript>	
				<cfloop list="#v_excluir#" index="l_id">
					<cfscript>
						ret = this.del_nf_es_imposto(num_nota_id = arguments.num_nota_id,
													 nf_imposto_id = l_id);
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>				
				</cfloop>
				<cfloop from="1" to="#ArrayLen(V_NF_IMPOSTO_ID)#" index="count">
					<cfscript>
						if(len(trim(V_NF_IMPOSTO_ID[count]))) {
							ret = this.upd_nf_es_imposto(	num_nota_id 			= arguments.num_nota_id,
															nf_imposto_id 			= v_nf_imposto_id[count],
															imposto_id				= v_imposto_id[count],
															imposto_reducao_base	= v_imposto_reducao_base[count],
															imposto_base_calculo	= v_imposto_base_calculo[count],
															imposto_aliquota		= v_imposto_aliquota[count],
															imposto_total			= v_imposto_total[count],
															imposto_retido_fonte	= v_imposto_retido_fonte[count],
															data_vencimento			= v_imposto_data_vencimento[count]);
						} else {
							ret = this.ins_nf_es_imposto(	num_nota_id 			= arguments.num_nota_id,
															imposto_id				= v_imposto_id[count],
															imposto_reducao_base	= v_imposto_reducao_base[count],
															imposto_base_calculo	= v_imposto_base_calculo[count],
															imposto_aliquota		= v_imposto_aliquota[count],
															imposto_total			= v_imposto_total[count],
															imposto_retido_fonte	= v_imposto_retido_fonte[count],
															data_vencimento			= v_imposto_data_vencimento[count]);
						}
					</cfscript>	
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
				</cfloop>				
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera nota fiscal de ES
	-- guto 10/02/2007 10:16:07 - CRIADO
	--->
	<cffunction name='alt_nota_fiscal_es' displayname='Altera nota fiscal de ES' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='NUM_NOTA_FISCAL' required='yes'>
		<cfargument name='COD_MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='E_S' required='yes'>
		<cfargument name='SERVICO' required='yes'>
		<cfargument name='INSCRICAO_ESTADUAL_SUBSTITUT' required='no' default="">
		<cfargument name='NATUREZA_ID' required='yes'>
		<cfargument name='NATUREZA_DESCRICAO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_ES' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO' required='yes'>
		<cfargument name='DEST_UF' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_TELEFONE' required='yes'>
		<cfargument name='DEST_CNPJ_CPF' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='NF_IMPOSTO_ID' required='no' default="">
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NOTA' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='CALC_BASE_ICMS' required='no' default="0">
		<cfargument name='CALC_VALOR_ICMS' required='no' default="0">
		<cfargument name='CALC_BASE_ICMS_SUBST' required='no' default="0">
		<cfargument name='CALC_VALOR_ICMS_SUBST' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_PRODUTOS' required='no' default="0">
		<cfargument name='CALC_VALOR_FRETE' required='no' default="0">
		<cfargument name='CALC_VALOR_SEGURO' required='no' default="0">
		<cfargument name='CALC_OUTRAS_DESPESAS' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_IPI' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_NOTA' required='yes'>
		<cfargument name='COD_TRANSPORTADOR' required='no' default="">
		<cfargument name='TRP_RAZAO_SOCIAL' required='no' default="">
		<cfargument name='TRP_ENDERECO' required='no' default="">
		<cfargument name='TRP_MUNICIPIO' required='no' default="">
		<cfargument name='TRP_UF' required='no' default="">
		<cfargument name='TRP_CNPJ_CPF' required='no' default="">
		<cfargument name='TRP_INSCRICAO_ESTADUAL' required='no' default="">
		<cfargument name='TRP_PLACA' required='no' default="">
		<cfargument name='TRP_PLACA_UF' required='no' default="">
		<cfargument name='TRP_FRETE_POR' required='no' default="1">
		<cfargument name='TRP_QUANTIDADE' required='no' default="1">
		<cfargument name='TRP_ESPECIE' required='no' default="">
		<cfargument name='TRP_MARCA' required='no' default="">
		<cfargument name='TRP_NUMERO' required='no' default="">
		<cfargument name='TRP_PESO_BRUTO' required='no' default="0">
		<cfargument name='TRP_PESO_LIQUIDO' required='no' default="0">
		<cfargument name='INFO_COMPLEMENTARES' required='yes'>
		<cfargument name='RESERVADO_FISCO' required='no' default="Este campo destina-se a preencher o campo Reservado ao Fisco da nota fiscal de E/S, quando da insero da mesma.">
		<cfargument name='OBSERVACAO_FISCAL' required='no' default="">
		<cfargument name='OBSERVACAO_USUARIO' required='no' default="">
		<cfargument name='CONVERSAO_TAXA' required='no' default="">
		<cfargument name='EMITIDA' required='no' default="1">
		<cfargument name='MANUAL' required='no' default="1">
		<cfargument name='CONVERSAO_MOEDA' required='no' default="220">
		<cfargument name='TIPO_RECOLHIMENTO_ISS' required='yes'>
		<cfargument name='COD_SERVICO_DES' required='no' default="">
		<cfargument name='NATUREZA_SISS_ID' required='no' default="">
		<cfargument name='INCLUIR_SISS' required='no' default="1">
		<cfargument name='AVISTA_APRAZO' required='yes'>
		<cfargument name='CORRECAO_NOTA' required='no' default="">
        <cfargument name='CONTABILIZA' required='no' default="1">
        <cfargument name='NATUREZA_OPERACAO' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='COD_ORGANIZACIONAL' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_alt_nf_es' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#' variable='arguments.NUM_NOTA_ID'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_E_S'  value='#arguments.E_S#'  null='#iif(len(trim(arguments.E_S)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERVICO'  value='#arguments.SERVICO#'  null='#iif(len(trim(arguments.SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INSCRICAO_ESTADUAL_SUBSTITUT'  value='#arguments.INSCRICAO_ESTADUAL_SUBSTITUT#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NATUREZA_ID'  value='#arguments.NATUREZA_ID#'  null='#iif(len(trim(arguments.NATUREZA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_DESCRICAO'  value='#arguments.NATUREZA_DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ES'  value='#arguments.DATA_ES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_TELEFONE'  value='#arguments.DEST_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_NOTA'  value='#arguments.SERV_TOTAL_NOTA#'  null='#iif(len(trim(arguments.SERV_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS'  value='#arguments.CALC_BASE_ICMS#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS'  value='#arguments.CALC_VALOR_ICMS#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS_SUBST'  value='#arguments.CALC_BASE_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS_SUBST'  value='#arguments.CALC_VALOR_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_PRODUTOS'  value='#arguments.CALC_VALOR_TOTAL_PRODUTOS#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_FRETE'  value='#arguments.CALC_VALOR_FRETE#'  null='#iif(len(trim(arguments.CALC_VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_SEGURO'  value='#arguments.CALC_VALOR_SEGURO#'  null='#iif(len(trim(arguments.CALC_VALOR_SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_OUTRAS_DESPESAS'  value='#arguments.CALC_OUTRAS_DESPESAS#'  null='#iif(len(trim(arguments.CALC_OUTRAS_DESPESAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_IPI'  value='#arguments.CALC_VALOR_TOTAL_IPI#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_IPI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_NOTA'  value='#arguments.CALC_VALOR_TOTAL_NOTA#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_RAZAO_SOCIAL'  value='#arguments.TRP_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ENDERECO'  value='#arguments.TRP_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MUNICIPIO'  value='#arguments.TRP_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_UF'  value='#arguments.TRP_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_CNPJ_CPF'  value='#arguments.TRP_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_INSCRICAO_ESTADUAL'  value='#arguments.TRP_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA'  value='#arguments.TRP_PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA_UF'  value='#arguments.TRP_PLACA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_FRETE_POR'  value='#arguments.TRP_FRETE_POR#'  null='#iif(len(trim(arguments.TRP_FRETE_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_QUANTIDADE'  value='#arguments.TRP_QUANTIDADE#'  null='#iif(len(trim(arguments.TRP_QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ESPECIE'  value='#arguments.TRP_ESPECIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MARCA'  value='#arguments.TRP_MARCA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_NUMERO'  value='#arguments.TRP_NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_PESO_BRUTO'  value='#arguments.TRP_PESO_BRUTO#'  null='#iif(len(trim(arguments.TRP_PESO_BRUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRP_PESO_LIQUIDO'  value='#arguments.TRP_PESO_LIQUIDO#'  null='#iif(len(trim(arguments.TRP_PESO_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFO_COMPLEMENTARES'  value='#arguments.INFO_COMPLEMENTARES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESERVADO_FISCO'  value='#arguments.RESERVADO_FISCO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_FISCAL'  value='#arguments.OBSERVACAO_FISCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#REReplace(arguments.OBSERVACAO_USUARIO,'','-')#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONVERSAO_TAXA'  value='#arguments.CONVERSAO_TAXA#'  null='#iif(len(trim(arguments.CONVERSAO_TAXA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONVERSAO_MOEDA'  value='#arguments.CONVERSAO_MOEDA#'  null='#iif(len(trim(arguments.CONVERSAO_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_SISS'  value='#arguments.INCLUIR_SISS#'  null='#iif(len(trim(arguments.INCLUIR_SISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_RECOLHIMENTO_ISS'  value='#arguments.TIPO_RECOLHIMENTO_ISS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_SERVICO_DES'  value='#arguments.COD_SERVICO_DES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_SISS_ID'  value='#arguments.NATUREZA_SISS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CORRECAO_NOTA'  value='#arguments.CORRECAO_NOTA#'  null='#iif(len(trim(arguments.CORRECAO_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AVISTA_APRAZO'  value='#arguments.AVISTA_APRAZO#'  null='#iif(len(trim(arguments.AVISTA_APRAZO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='CONTABILIZA'  value='#arguments.CONTABILIZA#'  null='#iif(len(trim(arguments.CONTABILIZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#'  null='#iif(len(trim(arguments.NATUREZA_OPERACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANIZACIONAL'  value='#arguments.COD_ORGANIZACIONAL#' >
                </cfstoredproc>
				<!---Insere Itens--->
				<cfscript>
					V_ES = this.ListaToArray(lista = arguments, variavel = "ES_SERVICOS");
					V_NUM_NOTA_IT_ID = this.ListaToArray(lista = arguments, variavel = "NUM_NOTA_IT_ID_SERVICOS");
					V_CFOP = this.ListaToArray(lista = arguments, variavel = "CFOP_SERVICOS");
					V_CFOP_ID = this.ListaToArray(lista = arguments, variavel = "CFOP_ID_SERVICOS");
					V_PRODUTO_ID = this.ListaToArray(lista = arguments, variavel = "PRODUTO_ID_SERVICOS");
					V_DESCRICAO = this.ListaToArray(lista = arguments, variavel = "DESCRICAO_SERVICOS");
					V_DESCRICAO_COMPLEMENTO = this.ListaToArray(lista = arguments, variavel = "DESCRICAO_COMPLEMENTO_SERVICOS");
					V_COD_NCM = this.ListaToArray(lista = arguments, variavel = "COD_NCM_SERVICOS");
					V_ST_ORIGEM_ID = this.ListaToArray(lista = arguments, variavel = "ST_ORIGEM_ID_SERVICOS");
					V_ST_ICMS_ID = this.ListaToArray(lista = arguments, variavel = "ST_ICMS_ID_SERVICOS");
					V_COD_UNIDADE = this.ListaToArray(lista = arguments, variavel = "COD_UNIDADE_SERVICOS");
					V_QTDE_PESO = this.ListaToArray(lista = arguments, variavel = "QTDE_PESO_SERVICOS");
					V_QTDE_VOLUME = this.ListaToArray(lista = arguments, variavel = "QTDE_VOLUME_SERVICOS");
					V_QTDE_METRO = this.ListaToArray(lista = arguments, variavel = "QTDE_METRO_SERVICOS");
					V_VALOR_EM = this.ListaToArray(lista = arguments, variavel = "VALOR_EM_SERVICOS");
					V_VALOR_EM_UNIDADE = this.ListaToArray(lista = arguments, variavel = "VALOR_EM_UNIDADE_SERVICOS");
					V_VALOR_UNITARIO = this.ListaToArray(lista = arguments, variavel = "VALOR_UNITARIO_SERVICOS");
					V_VALOR_TOTAL = this.ListaToArray(lista = arguments, variavel = "VALOR_TOTAL_SERVICOS");
					V_SERV_TOTAL_TRIBUTAVEL = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_TRIBUTAVEL_SERVICOS");
					V_SERV_TOTAL_NAO_TRIBUTAVEL = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_NAO_TRIBUTAVEL_SERVICOS");
					V_SERV_TOTAL_PRODUTO = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_PRODUTO_SERVICOS");
					V_SERV_ISS_ALIQUOTA = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_ALIQUOTA_SERVICOS");
					V_SERV_ISS_DEDUCAO = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_DEDUCAO_SERVICOS");
					V_SERV_ISS_VALOR = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_VALOR_SERVICOS");
					V_INCLUIR_LIVRO_FISCAL = this.ListaToArray(lista = arguments, variavel = "INCLUIR_LIVRO_FISCAL_SERVICOS");
					V_UF_UNIDADE_NEGOCIO = this.ListaToArray(lista = arguments, variavel = "UF_UNIDADE_NEGOCIO_SERVICOS");
					V_UF_DESTINATARIO = this.ListaToArray(lista = arguments, variavel = "UF_DESTINATARIO_SERVICOS");
					V_INCLUIR_SINTEGRA = this.ListaToArray(lista = arguments, variavel = "INCLUIR_SINTEGRA_SERVICOS");
				</cfscript>			
				<cfloop from="1" to="#ArrayLen(V_ES)#" index="count">
					<cfif Len(Trim(V_NUM_NOTA_IT_ID[count]))>
						<cfscript>
							this.alt_nota_fiscal_es_it( es = v_es[count],
														num_nota_id = arguments.NUM_NOTA_ID,
														num_nota_it_id = v_num_nota_it_id[count],
														cfop = v_cfop[count],
														cfop_id = v_cfop_id[count],
														produto_id = v_produto_id[count],
														descricao = v_descricao[count],
														descricao_complemento = v_descricao_complemento[count],
														cod_ncm = v_cod_ncm[count],
														st_origem_id = v_st_origem_id[count],
														st_icms_id = v_st_icms_id[count],
														cod_unidade = v_cod_unidade[count],
														qtde_peso = v_qtde_peso[count],
														qtde_volume = v_qtde_volume[count],
														qtde_metro = v_qtde_metro[count],
														valor_em = v_valor_em[count],
														valor_em_unidade = v_valor_em_unidade[count],
														valor_unitario = v_valor_unitario[count],
														valor_total = v_valor_total[count],
														serv_total_tributavel = v_serv_total_tributavel[count],
														serv_total_nao_tributavel = v_serv_total_nao_tributavel[count],
														serv_total_produto = v_serv_total_produto[count],
														serv_iss_aliquota = v_serv_iss_aliquota[count],
														serv_iss_deducao = v_serv_iss_deducao[count],
														serv_iss_valor = v_serv_iss_valor[count],
														incluir_livro_fiscal = v_incluir_livro_fiscal[count],
														uf_unidade_negocio = v_uf_unidade_negocio[count],
														uf_destinatario = v_uf_destinatario[count],
													    incluir_sintegra = v_incluir_sintegra[count]);
						</cfscript>	
					<cfelse>
						<cfscript>
							this.ins_nota_fiscal_es_it( es = v_es[count],
														num_nota_id = arguments.NUM_NOTA_ID,
														cfop = v_cfop[count],
														cfop_id = v_cfop_id[count],
														produto_id = v_produto_id[count],
														descricao = v_descricao[count],
														descricao_complemento = v_descricao_complemento[count],
														cod_ncm = v_cod_ncm[count],
														st_origem_id = v_st_origem_id[count],
														st_icms_id = v_st_icms_id[count],
														cod_unidade = v_cod_unidade[count],
														qtde_peso = v_qtde_peso[count],
														qtde_volume = v_qtde_volume[count],
														qtde_metro = v_qtde_metro[count],
														valor_em = v_valor_em[count],
														valor_em_unidade = v_valor_em_unidade[count],
														valor_unitario = v_valor_unitario[count],
														valor_total = v_valor_total[count],
														serv_total_tributavel = v_serv_total_tributavel[count],
														serv_total_nao_tributavel = v_serv_total_nao_tributavel[count],
														serv_total_produto = v_serv_total_produto[count],
														serv_iss_aliquota = v_serv_iss_aliquota[count],
														serv_iss_deducao = v_serv_iss_deducao[count],
														serv_iss_valor = v_serv_iss_valor[count],
														incluir_livro_fiscal = v_incluir_livro_fiscal[count],
														uf_unidade_negocio = v_uf_unidade_negocio[count],
														uf_destinatario = v_uf_destinatario[count],
													    incluir_sintegra = v_incluir_sintegra[count]);
						</cfscript>	
					</cfif>
				</cfloop>
				
				
				<cfscript>
					V_IMPOSTO_ID 				= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_IMPOSTO_ID_IMPOSTOS");
					V_NF_IMPOSTO_ID 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_NF_IMPOSTO_ID_IMPOSTOS");
					V_IMPOSTO_REDUCAO_BASE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_REDUCAO_BASE_IMPOSTOS");
					V_IMPOSTO_BASE_CALCULO 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_BASE_CALCULO_IMPOSTOS");
					V_IMPOSTO_ALIQUOTA 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ALIQUOTA_IMPOSTOS");
					V_IMPOSTO_TOTAL 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_TOTAL_IMPOSTOS");
					V_IMPOSTO_DATA_VENCIMENTO 	= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_DATA_VENCIMENTO_IMPOSTOS");
					V_IMPOSTO_RETIDO_FONTE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_RETIDO_FONTE_IMPOSTOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_IMPOSTOS, lista2 = ArrayToList(V_NF_IMPOSTO_ID));
				</cfscript>	
				<cfloop list="#v_excluir#" index="l_id">
					<cfscript>
						ret = this.del_nf_es_imposto(num_nota_id = arguments.num_nota_id,
													 nf_imposto_id = l_id);
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>				
				</cfloop>
				<cfloop from="1" to="#ArrayLen(V_NF_IMPOSTO_ID)#" index="count">
					<cfscript>
						if(len(trim(V_NF_IMPOSTO_ID[count]))) {
							ret = this.upd_nf_es_imposto(	num_nota_id 			= arguments.num_nota_id,
															nf_imposto_id 			= v_nf_imposto_id[count],
															imposto_id				= v_imposto_id[count],
															imposto_reducao_base	= v_imposto_reducao_base[count],
															imposto_base_calculo	= v_imposto_base_calculo[count],
															imposto_aliquota		= v_imposto_aliquota[count],
															imposto_total			= v_imposto_total[count],
															imposto_retido_fonte	= v_imposto_retido_fonte[count],
															data_vencimento			= v_imposto_data_vencimento[count]);
						} else {
							ret = this.ins_nf_es_imposto(	num_nota_id 			= arguments.num_nota_id,
															imposto_id				= v_imposto_id[count],
															imposto_reducao_base	= v_imposto_reducao_base[count],
															imposto_base_calculo	= v_imposto_base_calculo[count],
															imposto_aliquota		= v_imposto_aliquota[count],
															imposto_total			= v_imposto_total[count],
															imposto_retido_fonte	= v_imposto_retido_fonte[count],
															data_vencimento			= v_imposto_data_vencimento[count]);
						}
					</cfscript>	
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nota fiscal alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!--- 
	-- PROPSITO
	-- Altera item da nota fiscal de ES
	-- guto 10/02/2007 10:17:54 - CRIADO
	--->
	<cffunction name='ins_nota_fiscal_es_it' displayname='Altera item da nota fiscal de ES' access='remote' returntype='Struct' output='true'>
		<cfargument name='ES' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='DESCRICAO_COMPLEMENTO' required='yes'>
		<cfargument name='COD_NCM' required='yes'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='QTDE_PESO' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='QTDE_METRO' required='yes'>
		<cfargument name='VALOR_EM' required='yes'>
		<cfargument name='VALOR_EM_UNIDADE' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='ICMS_REDUCAO_BASE' required='no' default="100">
		<cfargument name='ICMS_BASE_CALCULO' required='no' default="0">
		<cfargument name='ICMS_ALIQUOTA' required='no' default="0">
		<cfargument name='ICMS_VALOR' required='no' default="0">
		<cfargument name='ICMS_BASE_CALC_SUBST' required='no' default="0">
		<cfargument name='ICMS_VALOR_SUBST' required='no' default="0">
		<cfargument name='IPI_REDUCAO_BASE' required='no' default="0">
		<cfargument name='IPI_BASE_CALCULO' required='no' default="0">
		<cfargument name='IPI_ALIQUOTA' required='no' default="0">
		<cfargument name='IPI_VALOR' required='no' default="0">
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_PRODUTO' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='DESCONTO_PERCENTUAL' required='no' default="0">
		<cfargument name='DESCONTO_VALOR' required='no' default="0">
		<cfargument name='INCLUIR_ESTOQUE' required='no' default="0">
		<cfargument name='INCLUIR_LIVRO_FISCAL' required='no' default="1">
		<cfargument name='UF_UNIDADE_NEGOCIO' required='yes'>
		<cfargument name='UF_DESTINATARIO' required='yes'>
		<cfargument name='INCLUIR_SINTEGRA' required='yes'>  
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ES'  value='#arguments.ES#'  null='#iif(len(trim(arguments.ES)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_IT_ID' variable='retorno.NUM_NOTA_IT_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>

					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_COMPLEMENTO'  value='#arguments.DESCRICAO_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_NCM'  value='#arguments.COD_NCM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='#arguments.ST_ORIGEM_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_PESO'  value='#arguments.QTDE_PESO#'  null='#iif(len(trim(arguments.QTDE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_METRO'  value='#arguments.QTDE_METRO#'  null='#iif(len(trim(arguments.QTDE_METRO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_EM'  value='#arguments.VALOR_EM#'  null='#iif(len(trim(arguments.VALOR_EM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR_EM_UNIDADE'  value='#arguments.VALOR_EM_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_REDUCAO_BASE'  value='#arguments.ICMS_REDUCAO_BASE#'  null='#iif(len(trim(arguments.ICMS_REDUCAO_BASE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_BASE_CALCULO'  value='#arguments.ICMS_BASE_CALCULO#'  null='#iif(len(trim(arguments.ICMS_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_ALIQUOTA'  value='#arguments.ICMS_ALIQUOTA#'  null='#iif(len(trim(arguments.ICMS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_VALOR'  value='#arguments.ICMS_VALOR#'  null='#iif(len(trim(arguments.ICMS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_BASE_CALC_SUBST'  value='#arguments.ICMS_BASE_CALC_SUBST#'  null='#iif(len(trim(arguments.ICMS_BASE_CALC_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_VALOR_SUBST'  value='#arguments.ICMS_VALOR_SUBST#'  null='#iif(len(trim(arguments.ICMS_VALOR_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_REDUCAO_BASE'  value='#arguments.IPI_REDUCAO_BASE#'  null='#iif(len(trim(arguments.IPI_REDUCAO_BASE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_BASE_CALCULO'  value='#arguments.IPI_BASE_CALCULO#'  null='#iif(len(trim(arguments.IPI_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_ALIQUOTA'  value='#arguments.IPI_ALIQUOTA#'  null='#iif(len(trim(arguments.IPI_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_VALOR'  value='#arguments.IPI_VALOR#'  null='#iif(len(trim(arguments.IPI_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_PRODUTO'  value='#arguments.SERV_TOTAL_PRODUTO#'  null='#iif(len(trim(arguments.SERV_TOTAL_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO_PERCENTUAL'  value='#arguments.DESCONTO_PERCENTUAL#'  null='#iif(len(trim(arguments.DESCONTO_PERCENTUAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO_VALOR'  value='#arguments.DESCONTO_VALOR#'  null='#iif(len(trim(arguments.DESCONTO_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_ESTOQUE'  value='#arguments.INCLUIR_ESTOQUE#'  null='#iif(len(trim(arguments.INCLUIR_ESTOQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_LIVRO_FISCAL'  value='#arguments.INCLUIR_LIVRO_FISCAL#' null='#iif(len(trim(arguments.INCLUIR_LIVRO_FISCAL)), de('no'), de('yes'))#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_UNIDADE_NEGOCIO'  value='#arguments.UF_UNIDADE_NEGOCIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_DESTINATARIO'  value='#arguments.UF_DESTINATARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_SINTEGRA'  value='#arguments.INCLUIR_SINTEGRA#' null='#iif(len(trim(arguments.INCLUIR_SINTEGRA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='p_contabiliza'  value='1'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='p_imposto_icms_id'  null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='p_imposto_iss_id'  null="yes">
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera item da nota fiscal de ES
	-- guto 10/02/2007 10:23:35 - CRIADO
	--->
	<cffunction name='alt_nota_fiscal_es_it' displayname='Altera item da nota fiscal de ES' access='remote' returntype='Struct' output='true'>
		<cfargument name='ES' required='yes'>
		<cfargument name='NUM_NOTA_IT_ID' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='PRODUTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='DESCRICAO_COMPLEMENTO' required='yes'>
		<cfargument name='COD_NCM' required='yes'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='QTDE_PESO' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='QTDE_METRO' required='yes'>
		<cfargument name='VALOR_EM' required='yes'>
		<cfargument name='VALOR_EM_UNIDADE' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='ICMS_REDUCAO_BASE' required='no' default="100">
		<cfargument name='ICMS_BASE_CALCULO' required='no' default="0">
		<cfargument name='ICMS_ALIQUOTA' required='no' default="0">
		<cfargument name='ICMS_VALOR' required='no' default="0">
		<cfargument name='ICMS_BASE_CALC_SUBST' required='no' default="0">
		<cfargument name='ICMS_VALOR_SUBST' required='no' default="0">
		<cfargument name='IPI_REDUCAO_BASE' required='no' default="0">
		<cfargument name='IPI_BASE_CALCULO' required='no' default="0">
		<cfargument name='IPI_ALIQUOTA' required='no' default="0">
		<cfargument name='IPI_VALOR' required='no' default="0">
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_PRODUTO' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='DESCONTO_PERCENTUAL' required='no' default="0">
		<cfargument name='DESCONTO_VALOR' required='no' default="0">
		<cfargument name='INCLUIR_ESTOQUE' required='no' default="0">
		<cfargument name='INCLUIR_LIVRO_FISCAL' required='yes'>
		<cfargument name='UF_UNIDADE_NEGOCIO' required='yes'>
		<cfargument name='UF_DESTINATARIO' required='yes'>
		<cfargument name='CORRECAO_NOTA' required='no' default="">
		<cfargument name='INCLUIR_SINTEGRA' required='yes'>        
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_alt_nf_es_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ES'  value='#arguments.ES#'  null='#iif(len(trim(arguments.ES)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_IT_ID'  value='#arguments.NUM_NOTA_IT_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_IT_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_COMPLEMENTO'  value='#arguments.DESCRICAO_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_NCM'  value='#arguments.COD_NCM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='#arguments.ST_ORIGEM_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_PESO'  value='#arguments.QTDE_PESO#'  null='#iif(len(trim(arguments.QTDE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_METRO'  value='#arguments.QTDE_METRO#'  null='#iif(len(trim(arguments.QTDE_METRO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_EM'  value='#arguments.VALOR_EM#'  null='#iif(len(trim(arguments.VALOR_EM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR_EM_UNIDADE'  value='#arguments.VALOR_EM_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_REDUCAO_BASE'  value='#arguments.ICMS_REDUCAO_BASE#'  null='#iif(len(trim(arguments.ICMS_REDUCAO_BASE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_BASE_CALCULO'  value='#arguments.ICMS_BASE_CALCULO#'  null='#iif(len(trim(arguments.ICMS_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_ALIQUOTA'  value='#arguments.ICMS_ALIQUOTA#'  null='#iif(len(trim(arguments.ICMS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_VALOR'  value='#arguments.ICMS_VALOR#'  null='#iif(len(trim(arguments.ICMS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_BASE_CALC_SUBST'  value='#arguments.ICMS_BASE_CALC_SUBST#'  null='#iif(len(trim(arguments.ICMS_BASE_CALC_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_VALOR_SUBST'  value='#arguments.ICMS_VALOR_SUBST#'  null='#iif(len(trim(arguments.ICMS_VALOR_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_REDUCAO_BASE'  value='#arguments.IPI_REDUCAO_BASE#'  null='#iif(len(trim(arguments.IPI_REDUCAO_BASE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_BASE_CALCULO'  value='#arguments.IPI_BASE_CALCULO#'  null='#iif(len(trim(arguments.IPI_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_ALIQUOTA'  value='#arguments.IPI_ALIQUOTA#'  null='#iif(len(trim(arguments.IPI_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_VALOR'  value='#arguments.IPI_VALOR#'  null='#iif(len(trim(arguments.IPI_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_PRODUTO'  value='#arguments.SERV_TOTAL_PRODUTO#'  null='#iif(len(trim(arguments.SERV_TOTAL_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO_PERCENTUAL'  value='#arguments.DESCONTO_PERCENTUAL#'  null='#iif(len(trim(arguments.DESCONTO_PERCENTUAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO_VALOR'  value='#arguments.DESCONTO_VALOR#'  null='#iif(len(trim(arguments.DESCONTO_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_ESTOQUE'  value='#arguments.INCLUIR_ESTOQUE#'  null='#iif(len(trim(arguments.INCLUIR_ESTOQUE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_LIVRO_FISCAL'  value='0'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_UNIDADE_NEGOCIO'  value='#arguments.UF_UNIDADE_NEGOCIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_DESTINATARIO'  value='#arguments.UF_DESTINATARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CORRECAO_NOTA'  value='#arguments.CORRECAO_NOTA#'  null='#iif(len(trim(arguments.CORRECAO_NOTA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Excluso das Notas Fiscais de Entrada e Sada.
	-- WAGNER 13/02/2007 09:11:01 - CRIADO
	--->
	<cffunction name='del_nota_fiscal_es' displayname='Excluso das Notas Fiscais de Entrada e Sada.' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='MOTIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_del_nf_es' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Nota Fiscal Excluida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Cancelamento de PS.
	-- guto 09/04/2007 11:16:56 - CRIADO
	--->
	<cffunction name='cancela_ps' displayname='Cancelamento de PS.' access='remote' returntype='Struct' output='true'>
		<cfargument name='PS_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_agregado.prc_del_agregado_adto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PS_ID'  value='#arguments.PS_ID#'  null='#iif(len(trim(arguments.PS_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('P.S. cancelado com sucesso! Ateno! Todos os documentos devem ser retidos na filial!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!--- 
	-- PROPSITO
	-- Libera CRT para impresso
	-- louis 01/06/2007 08:55:56 - CRIADO
	--->
	<cffunction name='libera_ctrc_impressao' displayname='Libera CRT para impresso' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ctrc_nao_impresso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTRC liberado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfscript>
					conn = CreateObject("component","_transportes.funcoes.cfc_erros");
				</cfscript>
				<cfset retorno.mensagem_src = conn.fnc_limpa_erro(cfcatch.Detail)>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Insere um imposto para a NFES
	-- cristofer 26/06/2007 11:09:03 - CRIADO
	--->
	<cffunction name='ins_nf_es_imposto' displayname='Insere um imposto para a NFES' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='IMPOSTO_ID' required='yes'>
		<cfargument name='IMPOSTO_REDUCAO_BASE' required='yes'>
		<cfargument name='IMPOSTO_BASE_CALCULO' required='yes'>
		<cfargument name='IMPOSTO_ALIQUOTA' required='yes'>
		<cfargument name='IMPOSTO_TOTAL' required='yes'>
		<cfargument name='IMPOSTO_RETIDO_FONTE' required='yes'>
		<cfargument name='DATA_VENCIMENTO' required='yes'>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_ID'  value='#arguments.IMPOSTO_ID#'  null='#iif(len(trim(arguments.IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_IMPOSTO_REDUCAO_BASE'  value='#arguments.IMPOSTO_REDUCAO_BASE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_BASE_CALCULO'  value='#arguments.IMPOSTO_BASE_CALCULO#'  null='#iif(len(trim(arguments.IMPOSTO_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_ALIQUOTA'  value='#arguments.IMPOSTO_ALIQUOTA#'  null='#iif(len(trim(arguments.IMPOSTO_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_TOTAL'  value='#arguments.IMPOSTO_TOTAL#'  null='#iif(len(trim(arguments.IMPOSTO_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_RETIDO_FONTE'  value='#arguments.IMPOSTO_RETIDO_FONTE#'  null='#iif(len(trim(arguments.IMPOSTO_RETIDO_FONTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCIMENTO'  value='#arguments.DATA_VENCIMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Imposto inserido com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Altera um imposto para a NFES
	-- cristofer 26/06/2007 11:10:52 - CRIADO
	--->
	<cffunction name='upd_nf_es_imposto' displayname='Altera um imposto para a NFES' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='NF_IMPOSTO_ID' required='yes'>
		<cfargument name='IMPOSTO_ID' required='yes'>
		<cfargument name='IMPOSTO_REDUCAO_BASE' required='yes'>
		<cfargument name='IMPOSTO_BASE_CALCULO' required='yes'>
		<cfargument name='IMPOSTO_ALIQUOTA' required='yes'>
		<cfargument name='IMPOSTO_TOTAL' required='yes'>
		<cfargument name='IMPOSTO_RETIDO_FONTE' required='yes'>
		<cfargument name='DATA_VENCIMENTO' required='yes'>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_upd_nf_es_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_ID'  value='#arguments.IMPOSTO_ID#'  null='#iif(len(trim(arguments.IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_REDUCAO_BASE'  value='#arguments.IMPOSTO_REDUCAO_BASE#'  null='#iif(len(trim(arguments.IMPOSTO_REDUCAO_BASE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_BASE_CALCULO'  value='#arguments.IMPOSTO_BASE_CALCULO#'  null='#iif(len(trim(arguments.IMPOSTO_BASE_CALCULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_ALIQUOTA'  value='#arguments.IMPOSTO_ALIQUOTA#'  null='#iif(len(trim(arguments.IMPOSTO_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_TOTAL'  value='#arguments.IMPOSTO_TOTAL#'  null='#iif(len(trim(arguments.IMPOSTO_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_RETIDO_FONTE'  value='#arguments.IMPOSTO_RETIDO_FONTE#'  null='#iif(len(trim(arguments.IMPOSTO_RETIDO_FONTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCIMENTO'  value='#arguments.DATA_VENCIMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Imposto alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
	-- PROPSITO
	-- Exclui um imposto para a NFES
	-- cristofer 26/06/2007 11:10:11 - CRIADO
	--->
	<cffunction name='del_nf_es_imposto' displayname='Exclui um imposto para a NFES' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='NF_IMPOSTO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_del_nf_es_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Imposto excluido com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!--- 
    -- PROPSITO
    -- Insere nota fiscal de servio de Frete
    -- ANDERSONC 16/07/2009 14:18:00 - ALTERADO
    --->
    <cffunction name='ins_nf_es_frete' displayname='Insere nota fiscal de servio de Frete' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='COD_DEPARTAMENTO' required='yes'>
        <cfargument name='COD_SETOR' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='COD_MODELO' required='yes'>
        <cfargument name='SERIE' required='yes'>
        <cfargument name='SUBSERIE' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='ITEM_ID' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='NUM_NOTA_FISCAL' required='yes'>
        <cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
        <cfargument name='NUM_PRODUTO' required='yes'>
        <cfargument name='PAGADOR' required='yes'>
        <cfargument name='COD_REMETENTE' required='yes'>
        <cfargument name='REM_RAZAO_SOCIAL' required='yes'>
        <cfargument name='REM_ENDERECO' required='yes'>
        <cfargument name='REM_MUNICIPIO' required='yes'>
        <cfargument name='REM_UF' required='yes'>
        <cfargument name='REM_CEP' required='yes'>
        <cfargument name='REM_CNPJ_CPF' required='yes'>
        <cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='COD_DESTINATARIO' required='yes'>
        <cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
        <cfargument name='DEST_ENDERECO' required='yes'>
        <cfargument name='DEST_MUNICIPIO' required='yes'>
        <cfargument name='DEST_UF' required='yes'>
        <cfargument name='DEST_CEP' required='yes'>
        <cfargument name='DEST_CNPJ_CPF' required='yes'>
        <cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='COD_CONSIGNATARIO' required='yes'>
        <cfargument name='CONS_RAZAO_SOCIAL' required='yes'>
        <cfargument name='CONS_ENDERECO' required='yes'>
        <cfargument name='CONS_MUNICIPIO' required='yes'>
        <cfargument name='CONS_UF' required='yes'>
        <cfargument name='CONS_CEP' required='yes'>
        <cfargument name='CONS_CNPJ_CPF' required='yes'>
        <cfargument name='CONS_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
        <cfargument name='COB_RAZAO_SOCIAL' required='yes'>
        <cfargument name='COB_ENDERECO' required='yes'>
        <cfargument name='COB_MUNICIPIO' required='yes'>
        <cfargument name='COB_UF' required='yes'>
        <cfargument name='COB_CEP' required='yes'>
        <cfargument name='COB_CNPJ_CPF' required='yes'>
        <cfargument name='COB_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='COD_REDESPACHO' required='yes'>
        <cfargument name='RED_RAZAO_SOCIAL' required='yes'>
        <cfargument name='RED_ENDERECO' required='yes'>
        <cfargument name='RED_MUNICIPIO' required='yes'>
        <cfargument name='RED_UF' required='yes'>
        <cfargument name='RED_CEP' required='yes'>
        <cfargument name='RED_CNPJ_CPF' required='yes'>
        <cfargument name='RED_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
        <cfargument name='COLETA_LOGRADOURO' required='yes'>
        <cfargument name='COLETA_COMPLEMENTO' required='yes'>
        <cfargument name='COLETA_BAIRRO' required='yes'>
        <cfargument name='COLETA_CEP' required='yes'>
        <cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
        <cfargument name='ENTREGA_LOGRADOURO' required='yes'>
        <cfargument name='ENTREGA_COMPLEMENTO' required='yes'>
        <cfargument name='ENTREGA_BAIRRO' required='yes'>
        <cfargument name='ENTREGA_CEP' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='PLACA_TRACAO' required='yes'>
        <cfargument name='COD_MOTORISTA' required='yes'>
        <cfargument name='NOME_MOTORISTA' required='yes'>
        <cfargument name='COD_PROPRIETARIO' required='yes'>
        <cfargument name='PROP_CNPJ_CPF' required='yes'>
        <cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
        <cfargument name='PROP_ENDERECO' required='yes'>
        <cfargument name='PROP_UF' required='yes'>
        <cfargument name='NUM_NATUREZA' required='yes'>
        <cfargument name='NUM_ESPECIE' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='PESO' required='yes'>
        <cfargument name='VOLUME' required='yes'>
        <cfargument name='M3' required='yes'>
        <cfargument name='FRETE_PESO' required='yes'>
        <cfargument name='SEC_CAT' required='yes'>
        <cfargument name='GRIS' required='yes'>
        <cfargument name='PEDAGIO' required='yes'>
        <cfargument name='FRETE_UNITARIO' required='yes'>
        <cfargument name='FRETE_VALOR' required='yes'>
        <cfargument name='DESPACHO' required='yes'>
        <cfargument name='ADEME' required='yes'>
        <cfargument name='DESCONTO' required='yes'>
        <cfargument name='COLETA_ENTREGA' required='yes'>
        <cfargument name='IMPOSTOS' required='yes'>
        <cfargument name='TOTAL_VIAGEM' required='yes'>
        <cfargument name='REGRA_FISCAL_ID' required='yes'>
        <cfargument name='TERCEIRO' required='no' default="0">
        <cfargument name='PESO_REAL' required='no' default="0">
        <cfargument name='OBSERVACAO' required='no' default="">
        <cfargument name='INCLUIR_SINTEGRA' required='yes'>
        <cfargument name='INCLUIR_LIVRO_FISCAL' required='yes'>
        <cfargument name='NFSE' required='no' default="0">
        <cfargument name='NATUREZA_OPERACAO' required='no' default="">
        <cfargument name='OPERACAO_ID' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
   		<cfargument name='TABELA_FRETE_ROTA_ID' required='no' default="">
   		<cfargument name='tipo_servico_comercial' required='no' default="">        
        
        <cftry>
            <cftransaction action='begin'>
				<!---Terceiro --->
				<cfif arguments.terceiro eq 1>
					<cfset v_composicao = arguments.placa_tracao>
					<cfloop list="#arguments.placa_referencia_composicao#" index="v_pl">
						<cfset v_composicao = ListAppend(v_composicao,v_pl,',')>
					</cfloop>
					<cfscript>
						conn = CreateComponent("modulos.nfes._componentes.manipulacao.cfc_contrato_transporte");
						romaneio = conn.gera_romaneio_terceiro(	NUM_ROMANEIO		= arguments.num_romaneio,
																COMPOSICAO			= v_composicao,
																DATA_INICIO			= arguments.data_emissao & ' ' & LSTimeFormat(Now(),'HH:MM'),
																OPERACAO_ID			= arguments.operacao_id,
																VIAGEM_CARGA_ID	    = arguments.viagem_carga_id,
																COD_MOTORISTA		= arguments.cod_motorista,
																COD_REMETENTE		= arguments.cod_remetente,
																COLETA_MUNICIPIO_ID	= arguments.coleta_municipio_id,
																COD_DESTINATARIO	= arguments.cod_destinatario,
																ENTREGA_MUNICIPIO_ID= arguments.entrega_municipio_id,
																VOLUME				= arguments.volume,
																PESO				= arguments.peso,
																M3					= arguments.m3,
																FRETE_VALOR			= arguments.frete_valor,
																NUM_NATUREZA		= arguments.num_natureza,
																NUM_ESPECIE			= arguments.num_especie,
																COD_UNIDADE			= arguments.cod_unidade,
																FRETE_EM			= arguments.frete_em,
																DESPACHO			= arguments.despacho,
																OBSERVACAO			= 'Frete Municipal'
																);
					</cfscript>
					<cfif romaneio.erro>
						<cfthrow object="#romaneio.mensagem#">
					<cfelse>
						<cfset arguments.num_romaneio 	= romaneio.num_romaneio>
						<cfset arguments.item_id 		= romaneio.item_id>
					</cfif>
				</cfif>
                
                <cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA_GERENCIAL'  value='#arguments.COD_ORGANOGRAMA_GERENCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
    
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_RAZAO_SOCIAL'  value='#arguments.REM_RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO'  value='#arguments.REM_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_MUNICIPIO'  value='#arguments.REM_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_UF'  value='#arguments.REM_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CNPJ_CPF'  value='#arguments.REM_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_INSCRICAO_ESTADUAL'  value='#arguments.REM_INSCRICAO_ESTADUAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONSIGNATARIO'  value='#arguments.COD_CONSIGNATARIO#'  null='#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_RAZAO_SOCIAL'  value='#arguments.CONS_RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO'  value='#arguments.CONS_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_MUNICIPIO'  value='#arguments.CONS_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_UF'  value='#arguments.CONS_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CEP'  value='#arguments.CONS_CEP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CNPJ_CPF'  value='#arguments.CONS_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_INSCRICAO_ESTADUAL'  value='#arguments.CONS_INSCRICAO_ESTADUAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE_COBRANCA'  value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_RAZAO_SOCIAL'  value='#arguments.COB_RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_ENDERECO'  value='#arguments.COB_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_MUNICIPIO'  value='#arguments.COB_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_UF'  value='#arguments.COB_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_CEP'  value='#arguments.COB_CEP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_CNPJ_CPF'  value='#arguments.COB_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_INSCRICAO_ESTADUAL'  value='#arguments.COB_INSCRICAO_ESTADUAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REDESPACHO'  value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_RAZAO_SOCIAL'  value='#arguments.RED_RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO'  value='#arguments.RED_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_MUNICIPIO'  value='#arguments.RED_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_UF'  value='#arguments.RED_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CEP'  value='#arguments.RED_CEP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CNPJ_CPF'  value='#arguments.RED_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_INSCRICAO_ESTADUAL'  value='#arguments.RED_INSCRICAO_ESTADUAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_LOGRADOURO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.ENTREGA_LOGRADOURO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.ENTREGA_COMPLEMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.ENTREGA_BAIRRO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.ENTREGA_CEP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_TRACAO'  value='#arguments.PLACA_TRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_MOTORISTA'  value='#arguments.NOME_MOTORISTA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_CNPJ_CPF'  value='#arguments.PROP_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_RAZAO_SOCIAL'  value='#arguments.PROP_RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_ENDERECO'  value='#arguments.PROP_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_UF'  value='#Left(arguments.PROP_UF,2)#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_VIAGEM'  value='#arguments.TOTAL_VIAGEM#'  null='#iif(len(trim(arguments.TOTAL_VIAGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REGRA_FISCAL_ID'  value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_ES_ID' variable='retorno.NF_ES_ID' >
                	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='PESO_REAL'  value='#arguments.PESO_REAL#'  null='#iif(len(trim(arguments.PESO_REAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#arguments.OBSERVACAO#'  null='#iif(len(trim(arguments.OBSERVACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_TOTAL_RETIDO'  value='#arguments.TOTAL_RETIDO#'  null='#iif(len(trim(arguments.TOTAL_RETIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_RECOLHIMENTO_ISS'  value='#arguments.TIPO_RECOLHIMENTO_ISS#'  null='#iif(len(trim(arguments.TIPO_RECOLHIMENTO_ISS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_INCLUIR_LIVRO_FISCAL'  value='#arguments.INCLUIR_LIVRO_FISCAL#'  null='#iif(len(trim(arguments.INCLUIR_LIVRO_FISCAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_INCLUIR_SINTEGRA'  value='#arguments.INCLUIR_SINTEGRA#'  null='#iif(len(trim(arguments.INCLUIR_SINTEGRA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#'  null='#iif(len(trim(arguments.NATUREZA_OPERACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='p_tipo_servico_comercial'  value='#arguments.tipo_servico_comercial#'  null='#iif(len(trim(arguments.tipo_servico_comercial)), de('no'), de('yes'))#'>                    
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' dbvarname='P_TABELA_FRETE_ROTA_ID'  value='#arguments.TABELA_FRETE_ROTA_ID#'  null='#iif(len(trim(arguments.TABELA_FRETE_ROTA_ID)), de('no'), de('yes'))#'>
                    
                </cfstoredproc>

				<!--- Insere Notas fiscais --->
				<cfscript>
					v_numero 	   = this.ListaToArray    (lista = arguments, variavel = "NOTA_NUMERO_NOTAS_FISCAIS");
					v_data_emissao = this.ListaToArray    (lista = arguments, variavel = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
					v_serie 	   = this.ListaToArray    (lista = arguments, variavel = "NOTA_SERIE_NOTAS_FISCAIS");
					v_sub_serie    = this.ListaToArray    (lista = arguments, variavel = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
					v_modelo       = this.ListaToArray    (lista = arguments, variavel = "NOTA_MODELO_NOTAS_FISCAIS");
					v_valor		   = this.ListaToArray    (lista = arguments, variavel = "NOTA_VALOR_NOTAS_FISCAIS");
					v_valor_segurado  = this.ListaToArray (lista = arguments, variavel = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
					v_peso         = this.ListaToArray    	(lista = arguments, variavel = "PESO_NF_NOTAS_FISCAIS");
					if (arrayLen(v_peso) eq 0) {
						v_peso         = this.ListaToArray    (lista = arguments, variavel = "NOTA_PESO_NOTAS_FISCAIS");
					}
					v_peso_cobrado         = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
					
					v_ordem_compra         = this.ListaToArray(lista = arguments, variavel = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
					
					v_qtde_volume          = this.ListaToArray(lista = arguments, variavel = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
					v_cod_unidade          = this.ListaToArray(lista = arguments, variavel = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
					v_m3                   = this.ListaToArray(lista = arguments, variavel = 'NOTA_M3_NOTAS_FISCAIS');
					v_peso_cubado          = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
					v_peso_kg_convertido   = this.ListaToArray(lista = arguments, variavel = 'NOTA_PESO_KG_CONVERTIDO_NOTAS_FISCAIS');
					v_num_natureza         = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
					v_natureza             = this.ListaToArray(lista = arguments, variavel = 'NOTA_NATUREZA_NOTAS_FISCAIS');
					v_complemento          = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
					v_num_especie          = this.ListaToArray(lista = arguments, variavel = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
					v_especie              = this.ListaToArray(lista = arguments, variavel = 'NOTA_ESPECIE_NOTAS_FISCAIS');
					v_altura               = this.ListaToArray(lista = arguments, variavel = 'NOTA_ALTURA_NOTAS_FISCAIS');
					v_largura              = this.ListaToArray(lista = arguments, variavel = 'NOTA_LARGURA_NOTAS_FISCAIS');
					v_comprimento          = this.ListaToArray(lista = arguments, variavel = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
					v_cubagem              = this.ListaToArray(lista = arguments, variavel = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
						
						
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
					<cfscript>
						if (ArrayLen(v_numero) neq ArrayLen(v_ordem_compra)) {
							v_ordem = '';
						} else {
							v_ordem = v_ordem_compra[count];
						}
						if (ArrayLen(v_peso_cobrado) neq ArrayLen(v_ordem_compra)) {
							v_peso_cobrado_item = v_peso[count];
						} else {
							v_peso_cobrado_item = v_peso_cobrado[count];
						}
						
						if(ArrayLen(v_qtde_volume) eq 0) {
							this.ins_nf_es_frete_nf(nf_es_id 		 = retorno.nf_es_id,
													 numero			 = v_numero[count],
													 data_emissao	 = v_data_emissao[count],
													 modelo 		 = v_modelo[count],
													 serie 			 = v_serie[count],
													 sub_serie 		 = v_sub_serie[count],
													 valor_total 	 = v_valor[count],
													 valor_segurado  = v_valor[count],
													 peso            = v_peso[count],
													 peso_cobrado	 = v_peso_cobrado_item,
													 ordem_compra_cliente = v_ordem);
						} else {
							this.ins_nf_es_frete_nf(	nf_es_id      	     = retorno.nf_es_id,
														numero			     = v_numero[count],
														data_emissao	     = v_data_emissao[count],
														modelo 		         = v_modelo[count],
														serie 			     = v_serie[count],
														sub_serie 		     = v_sub_serie[count],
														valor_total 	     = v_valor[count],
														valor_segurado       = v_valor_segurado[count],
														peso                 = v_peso[count],
														ordem_compra_cliente = v_ordem,
														qtde_volume 		 = v_qtde_volume[count],
														cod_unidade 		 = v_cod_unidade[count],
														m3 				     = v_m3[count],
														peso_cubado 		 = v_peso_cubado[count],
														peso_kg_convertido   = v_peso_kg_convertido[count],
														num_natureza 		 = v_num_natureza[count],
														natureza 			 = v_natureza[count],
														complemento          = v_complemento[count],
														num_especie          = v_num_especie[count],
														especie              = v_especie[count],
														altura               = v_altura[count],
														largura              = v_largura[count],
														comprimento          = v_comprimento[count],
														cubagem              = v_cubagem[count],
														peso_cobrado         = v_peso_cobrado[count]);
						}
					</cfscript>
				</cfloop>
                
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfif arguments.EMITE_TABELA_FRETE eq 1>
                	<cfscript>
						if(IsDefined('arguments.PLACA_REFERENCIA_INTERNA')) {
							v_placa_referencia_interna = Replace(arguments.PLACA_REFERENCIA_INTERNA, ',', ' > ', 'all');
						}
						else {
							v_placa_referencia_interna = '';
						}
						
						conn_cons_tf = CreateComponent("_transportes.consulta.comercial.cfc_tabela_frete");
						qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id(ORIGEM_MUNICIPIO_ID  = arguments.COLETA_MUNICIPIO_ID,
																					DESTINO_MUNICIPIO_ID = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.ENTREGA_MUNICIPIO_ID), de(arguments.MUNICIPIO_ULT_ENTREGA_ID)),
																					COD_NEGOCIADOR       = arguments.COD_NEGOCIADOR,
																					NUM_NATUREZA		 = arguments.NUM_NATUREZA,
																					COMPOSICAO			 = arguments.PLACA_TRACAO & ' > ' & v_placa_referencia_interna);
					</cfscript>
					<cfif qrTabelaFreteRotaId.erro>
						<cfthrow object="#qrTabelaFreteRotaId.mensagem#">
					</cfif>
					
					<cfscript>
						conn_cons_doc = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
						qrDadosFiscais = conn_cons_doc.get_ctrc_dados_fiscais(NUM_ROMANEIO 		   = arguments.NUM_ROMANEIO,
																	 		  ITEM_ID 			   = arguments.ITEM_ID,
																			  COD_DESTINATARIO 	   = arguments.COD_DESTINATARIO,
																			  PRODUTO_ID  		   = arguments.NUM_PRODUTO,
																			  PAGO_POR 			   = arguments.PAGADOR,
																			  COLETA_UF 		   = arguments.COLETA_UF,
																			  ENTREGA_UF 		   = arguments.ENTREGA_UF,
																			  ST_ICMS_ID 		   = arguments.ST_ICMS_ID,
																			  COD_REMETENTE 	   = arguments.COD_REMETENTE,
																			  REGRA_FISCAL_ID 	   = arguments.REGRA_FISCAL,
																			  COB_UF 			   = arguments.COB_UF,
																			  COLETA_MUNICIPIO_ID  = arguments.COLETA_MUNICIPIO_ID,
																			  ENTREGA_MUNICIPIO_ID = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.ENTREGA_MUNICIPIO_ID), de(arguments.MUNICIPIO_ULT_ENTREGA_ID)),
																			  VIAGEM_CARGA_ID 	   = arguments.VIAGEM_CARGA_ID,
																			  COD_CLIENTE_COBRANCA = arguments.COD_CLIENTE_COBRANCA,
																			  UF_FILIAL 		   = arguments.UF_FILIAL_EMISSAO,
																			  NOTA_FISCAL 		   = 1);
					</cfscript>
					<cfif qrDadosFiscais.erro>
						<cfthrow object="#qrDadosFiscais.mensagem#">
					</cfif>
                    
                    <cfscript>
						conn_cons_vei = CreateComponent("_transportes.consulta.cfc_veiculo");
						qrNumeroEixos = conn_cons_vei.get_numero_eixos_composicao(PLACA = arguments.PLACA_TRACAO & ' > ' & v_placa_referencia_interna);
					</cfscript>
					<cfif qrNumeroEixos.erro>
						<cfthrow object="#qrNumeroEixos.mensagem#">
					</cfif>
                    
                    <cfscript>
						// Constantes
						arguments.CONSTANTE_VIAGEM_CARGA_ID		  = arguments.VIAGEM_CARGA_ID;
						arguments.CONSTANTE_PESO_BRUTO            = ArraySum(v_peso_kg_convertido);
						arguments.CONSTANTE_PESO_COBRADO          = ArraySum(v_peso_cobrado);
						arguments.CONSTANTE_VALOR_MERCADORIA      = ArraySum(v_valor);
						arguments.CONSTANTE_MUNICIPIO_ID_ORIGEM   = arguments.COLETA_MUNICIPIO_ID;
						arguments.CONSTANTE_MUNICIPIO_ID_DESTINO  = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.ENTREGA_MUNICIPIO_ID), de(arguments.MUNICIPIO_ULT_ENTREGA_ID));
						arguments.CONSTANTE_FRETE_PROPRIO		  = qrDadosFiscais.FRETE_PROPRIO;
						arguments.CONSTANTE_UF_TOMADOR			  = qrDadosFiscais.TOMADOR_UF;
						arguments.CONSTANTE_COD_ATIVIDADE_TOMADOR = qrDadosFiscais.COD_ATIVIDADE_TOMADOR;
						arguments.CONSTANTE_ST_ICMS_ID			  = Trim(arguments.ST_ICMS_ID);
						arguments.CONSTANTE_PLACA_TRACAO	 	  = arguments.PLACA_TRACAO;
						
						if(v_placa_referencia_interna eq '') {
							arguments.CONSTANTE_PLACA_CARRETA = '';
						}
						else {
							arguments.CONSTANTE_PLACA_CARRETA = ListGetAt(v_placa_referencia_interna, 1, ' > ');
						}
						
						arguments.CONSTANTE_NRO_EIXOS = qrNumeroEixos.EIXOS;
						// ----------
					</cfscript>
                    
                    <cfscript>
						qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						qrConstante 	  = conn_cons_tf.get_constante();
						qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
						
						conn_manip_tf = CreateComponent("modulos.nfes._componentes.manipulacao.cfc_tabela_frete");
					</cfscript>
					
					<cfloop query="qrConstante">
						<cfscript>
							ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
														  		   VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
						</cfscript>
						<cfif ret_cons.erro>
							<cfthrow object="#ret_cons.mensagem#">
						</cfif>
					</cfloop>
					
					<cfscript>
						ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
														 		  VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_cons_tf.erro>
						<cfthrow object="#ret_cons_tf.mensagem#">
					</cfif>
					
					<cfscript>
						ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
														  		   VALOR		 = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID);
					</cfscript>
					<cfif ret_cons_tfr.erro>
						<cfthrow object="#ret_cons_tfr.mensagem#">
					</cfif>
					
					<cfloop query="qrVariavel">
						<cfscript>
							ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
																	 		  TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID,
																	 		  TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 		  VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					</cfloop>
                    
                    <cfscript>
						ret_calc = this.calcula_nfes_tabela_frete(NF_ES_ID 		  = retorno.NF_ES_ID,
																  TABELA_FRETE_ID = qrTabelaFreteRota.TABELA_FRETE_ID);
					</cfscript>
					<cfif ret_calc.erro>
						<cfthrow object="#ret_calc.mensagem#">
					</cfif>
                </cfif>
                <!--- /// --->
                
                <!---INSERE IMPOSTOS--->
                <cfscript>
					V_IMPOSTO_ID 				= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ID_ITENS_IMPOSTO");
					V_NF_IMPOSTO_ID 			= this.ListaToArray(lista = arguments, variavel = "NF_IMPOSTO_ID_ITENS_IMPOSTO");
					V_IMPOSTO_REDUCAO_BASE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_REDUCAO_BASE_ITENS_IMPOSTO");
					V_IMPOSTO_BASE_CALCULO 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_BASE_CALCULO_ITENS_IMPOSTO");
					V_IMPOSTO_ALIQUOTA 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ALIQUOTA_ITENS_IMPOSTO");
					V_IMPOSTO_TOTAL 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_TOTAL_ITENS_IMPOSTO");
					V_IMPOSTO_DATA_VENCIMENTO 	= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_DATA_VENCIMENTO_ITENS_IMPOSTO");
					V_IMPOSTO_RETIDO_FONTE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_RETIDO_FONTE_ITENS_IMPOSTO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ITENS_IMPOSTO, lista2 = ArrayToList(V_NF_IMPOSTO_ID));
				</cfscript>	
				<cfloop list="#v_excluir#" index="l_id">
					<cfscript>
						ret = this.del_nf_es_imposto(num_nota_id = arguments.num_nota_id,
													 nf_imposto_id = l_id);
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>				
				</cfloop>
				<cfloop from="1" to="#ArrayLen(V_NF_IMPOSTO_ID)#" index="count">
					<cfscript>
						if(len(trim(V_NF_IMPOSTO_ID[count]))) {
							ret = this.upd_nf_es_imposto(	num_nota_id 			= retorno.NF_ES_ID,
															nf_imposto_id 			= v_nf_imposto_id[count],
															imposto_id				= v_imposto_id[count],
															imposto_reducao_base	= v_imposto_reducao_base[count],
															imposto_base_calculo	= v_imposto_base_calculo[count],
															imposto_aliquota		= v_imposto_aliquota[count],
															imposto_total			= v_imposto_total[count],
															imposto_retido_fonte	= v_imposto_retido_fonte[count],
															data_vencimento			= v_imposto_data_vencimento[count]);
						} else {
							ret = this.ins_nf_es_imposto(	num_nota_id 			= retorno.NF_ES_ID,
															imposto_id				= v_imposto_id[count],
															imposto_reducao_base	= v_imposto_reducao_base[count],
															imposto_base_calculo	= v_imposto_base_calculo[count],
															imposto_aliquota		= v_imposto_aliquota[count],
															imposto_total			= v_imposto_total[count],
															imposto_retido_fonte	= v_imposto_retido_fonte[count],
															data_vencimento			= v_imposto_data_vencimento[count]);
						}
					</cfscript>	
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
				</cfloop>
                
                <cfscript>
					ret = this.valida_nf_frete(num_nota_id 			= retorno.NF_ES_ID);
				</cfscript>
                <cfif isDefined("ret.erro") and ret.erro>
					<cfthrow object="#ret.mensagem#">
				</cfif>
                                
                <!---Gerar RPS--->
                <cfif arguments.NFSE eq 1>
					<cfscript>
                        ret_rps = this.gerar_rps(num_nota_id = retorno.NF_ES_ID);
                    </cfscript>
                    <cfif ret_rps.erro>
                        <cfthrow object="#ret_rps.mensagem#">
                    </cfif>
                </cfif>
                                
				<cfset retorno.num_romaneio = arguments.num_romaneio>
				<cfset retorno.item_id 		= arguments.item_id>
                <cfset retorno.erro 		= false>
                <cfset retorno.mensagem 	= JSStringFormat('Nota fiscal inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
	-- PROPSITO
	-- Insere nota fiscal a nota fiscal de servico
	-- guto 22/11/2006 10:24:53 - CRIADO
	--->
	<cffunction name='ins_nf_es_frete_nf' displayname='Insere nota fiscal a uma NF de frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='NF_ES_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUB_SERIE' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='VALOR_SEGURADO' required='yes'>
		<cfargument name='ORDEM_COMPRA_CLIENTE' required='no' default="">
		<cfargument name='PESO' required='no' default="0">
		<cfargument name='PESO_CUBADO' required='no' default="">
		<cfargument name='PESO_COBRADO' required='no' default="">
		<cfargument name='QTDE_VOLUME' required='no' default="1">
		<cfargument name='ALTURA' required='no' default="">
		<cfargument name='COMPRIMENTO' required='no' default="">
		<cfargument name='LARGURA' required='no' default="">
		<cfargument name='M3' required='no' default="">
		<cfargument name='CUBAGEM' required='no' default="">
		<cfargument name='NUM_NATUREZA' required='no' default="">
		<cfargument name='COMPLEMENTO' required='no' default="">
		<cfargument name='NUM_ESPECIE' required='no' default="">
		<cfargument name='COD_UNIDADE' required='no' default="">
				<cfstoredproc procedure='fiscal.pkg_nf_es.PRC_INS_NF_ES_NOTA_FISCAL' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_ES_ID'  value='#arguments.NF_ES_ID#'  null='#iif(len(trim(arguments.NF_ES_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUMERO'  value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MODELO'  value='#arguments.MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUB_SERIE'  value='#arguments.SUB_SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_SEGURADO'  value='#arguments.VALOR_SEGURADO#'  null='#iif(len(trim(arguments.VALOR_SEGURADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ORDEM_COMPRA_CLIENTE'  value='#arguments.ORDEM_COMPRA_CLIENTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO_CUBADO'  value='#arguments.PESO_CUBADO#'  null='#iif(len(trim(arguments.PESO_CUBADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO_COBRADO'  value='#arguments.PESO_COBRADO#'  null='#iif(len(trim(arguments.PESO_COBRADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALTURA'  value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COMPRIMENTO'  value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LARGURA'  value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CUBAGEM'  value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPLEMENTO'  value='#arguments.COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!--- 
	-- PROPSITO
	-- Exclui um nota fiscal vinculada a uma nf de servio de frete municipal
	-- guto 19/04/2006 10:55:48 - CRIADO
	--->
	<cffunction name='del_nf_es_frete_nota_fiscal' displayname='Exclui um nota fiscal vinculada a uma nf de servio de frete municipal' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NF_ES_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_del_nf_es_frete_nf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_ES_ID'  value='#arguments.NF_ES_ID#'  null='#iif(len(trim(arguments.NF_ES_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUMERO'  	value='#arguments.NUMERO#'    null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>	   

	<!--- 
    -- PROPSITO
    -- Insere nota fiscal de terceiro
    -- guto 10/12/2008 15:40:50 - CRIADO
    --->
    <cffunction name='ins_nf_terceiro' displayname='Insere nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='COD_DEPARTAMENTO' required='yes'>
        <cfargument name='COD_SETOR' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='NUM_NOTA_FISCAL' required='yes'>
        <cfargument name='COD_MODELO' required='yes'>
        <cfargument name='SERIE' required='yes'>
        <cfargument name='SUBSERIE' required='yes'>
        <cfargument name='NATUREZA_ID' required='yes'>
        <cfargument name='NATUREZA_DESCRICAO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='DATA_ENTRADA' required='yes'>
        <cfargument name='COD_EMITENTE' required='yes'>
        <cfargument name='EMIT_RAZAO_SOCIAL' required='yes'>
        <cfargument name='EMIT_ENDERECO' required='yes'>
        <cfargument name='EMIT_BAIRRO' required='yes'>
        <cfargument name='EMIT_MUNICIPIO' required='yes'>
        <cfargument name='EMIT_UF' required='yes'>
        <cfargument name='EMIT_CEP' required='yes'>
        <cfargument name='EMIT_TELEFONE' required='yes'>
        <cfargument name='EMIT_CNPJ_CPF' required='yes'>
        <cfargument name='EMIT_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='COD_CLIENTE' required='yes'>
        <cfargument name='NF_IMPOSTO_ID' required='no' default="">
        <cfargument name='CALC_BASE_ICMS' required='yes'>
        <cfargument name='CALC_VALOR_ICMS' required='yes'>
        <cfargument name='CALC_BASE_ICMS_SUBST' required='yes'>
        <cfargument name='CALC_VALOR_ICMS_SUBST' required='yes'>
        <cfargument name='CALC_VALOR_TOTAL_PRODUTOS' required='yes'>
        <cfargument name='CALC_VALOR_FRETE' required='yes'>
        <cfargument name='CALC_VALOR_SEGURO' required='yes'>
        <cfargument name='CALC_OUTRAS_DESPESAS' required='yes'>
        <cfargument name='CALC_VALOR_TOTAL_IPI' required='yes'>
        <cfargument name='CALC_VALOR_TOTAL_NOTA' required='yes'>
        <cfargument name='OBSERVACAO_FISCAL' required='yes'>
        <cfargument name='OBSERVACAO_USUARIO' required='yes'>
        <cfargument name='CONFERIDA' required='no' default="0">
        <cfargument name='COD_CONTABIL' required='yes'>
        <cfargument name='INCLUIR_SISS' required='yes'>
        <cfargument name='COD_SERVICO_DES' required='yes'>
        <cfargument name='NATUREZA_SISS_ID' required='yes'>
        <cfargument name='AVISTA_APRAZO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ins_nf_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID' variable='retorno.NUM_NOTA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NATUREZA_ID'  value='#arguments.NATUREZA_ID#'  null='#iif(len(trim(arguments.NATUREZA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_DESCRICAO'  value='#arguments.NATUREZA_DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_EMITENTE'  value='#arguments.COD_EMITENTE#'  null='#iif(len(trim(arguments.COD_EMITENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_RAZAO_SOCIAL'  value='#arguments.EMIT_RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_ENDERECO'  value='#arguments.EMIT_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_BAIRRO'  value='#arguments.EMIT_BAIRRO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_MUNICIPIO'  value='#arguments.EMIT_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_UF'  value='#arguments.EMIT_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_CEP'  value='#arguments.EMIT_CEP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_TELEFONE'  value='#arguments.EMIT_TELEFONE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_CNPJ_CPF'  value='#arguments.EMIT_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_INSCRICAO_ESTADUAL'  value='#arguments.EMIT_INSCRICAO_ESTADUAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE'  value='#arguments.COD_CLIENTE#'  null='#iif(len(trim(arguments.COD_CLIENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS'  value='#arguments.CALC_BASE_ICMS#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS'  value='#arguments.CALC_VALOR_ICMS#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS_SUBST'  value='#arguments.CALC_BASE_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS_SUBST)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS_SUBST'  value='#arguments.CALC_VALOR_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS_SUBST)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_PRODUTOS'  value='#arguments.CALC_VALOR_TOTAL_PRODUTOS#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_FRETE'  value='#arguments.CALC_VALOR_FRETE#'  null='#iif(len(trim(arguments.CALC_VALOR_FRETE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_SEGURO'  value='#arguments.CALC_VALOR_SEGURO#'  null='#iif(len(trim(arguments.CALC_VALOR_SEGURO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_OUTRAS_DESPESAS'  value='#arguments.CALC_OUTRAS_DESPESAS#'  null='#iif(len(trim(arguments.CALC_OUTRAS_DESPESAS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_IPI'  value='#arguments.CALC_VALOR_TOTAL_IPI#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_IPI)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_NOTA'  value='#arguments.CALC_VALOR_TOTAL_NOTA#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_FISCAL'  value='#arguments.OBSERVACAO_FISCAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#arguments.OBSERVACAO_USUARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONFERIDA'  value='#arguments.CONFERIDA#'  null='#iif(len(trim(arguments.CONFERIDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_CONTABIL'  value='#arguments.COD_CONTABIL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_SISS'  value='#arguments.INCLUIR_SISS#'  null='#iif(len(trim(arguments.INCLUIR_SISS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SERVICO_DES'  value='#arguments.COD_SERVICO_DES#'  null='#iif(len(trim(arguments.COD_SERVICO_DES)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_SISS_ID'  value='#arguments.NATUREZA_SISS_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AVISTA_APRAZO'  value='#arguments.AVISTA_APRAZO#'  null='#iif(len(trim(arguments.AVISTA_APRAZO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                
                <!---Itens--->
                <cfscript>
					v_num_nota_it_id = this.ListaToArray(lista=arguments,variavel="NUM_NOTA_IT_ID_PRODUTOS");
					v_uf_unidade_negocio = this.ListaToArray(lista=arguments,variavel="UF_UNIDADE_NEGOCIO_PRODUTOS");
					v_uf_emitente = this.ListaToArray(lista=arguments,variavel="UF_EMITENTE_PRODUTOS");
					v_descricao_complemento = this.ListaToArray(lista=arguments,variavel="DESCRICAO_COMPLEMENTO_PRODUTOS");
					v_cod_ncm = this.ListaToArray(lista=arguments,variavel="COD_NCM_PRODUTOS");
					v_valor_em_unidade = this.ListaToArray(lista=arguments,variavel="VALOR_EM_UNIDADE_PRODUTOS");
					v_serv_total_tributavel = this.ListaToArray(lista=arguments,variavel="SERV_TOTAL_TRIBUTAVEL_PRODUTOS");
					v_serv_total_nao_tributavel = this.ListaToArray(lista=arguments,variavel="SERV_TOTAL_NAO_TRIBUTAVEL_PRODUTOS");
					v_serv_total_produto = this.ListaToArray(lista=arguments,variavel="SERV_TOTAL_PRODUTO_PRODUTOS");
					v_incluir_sintegra = this.ListaToArray(lista=arguments,variavel="INCLUIR_SINTEGRA_PRODUTOS");
					v_serv_iss_aliquota = this.ListaToArray(lista=arguments,variavel="SERV_ISS_ALIQUOTA_PRODUTOS");
					v_serv_iss_deducao = this.ListaToArray(lista=arguments,variavel="SERV_ISS_DEDUCAO_PRODUTOS");
					v_serv_iss_valor = this.ListaToArray(lista=arguments,variavel="SERV_ISS_VALOR_PRODUTOS");
					v_incluir_estoque = this.ListaToArray(lista=arguments,variavel="INCLUIR_ESTOQUE_PRODUTOS");
					v_cfop = this.ListaToArray(lista=arguments,variavel="CFOP_PRODUTOS");
					v_cfop_id = this.ListaToArray(lista=arguments,variavel="CFOP_ID_PRODUTOS");
					v_produto_id = this.ListaToArray(lista=arguments,variavel="PRODUTO_ID_PRODUTOS");
					v_produto_descricao = this.ListaToArray(lista=arguments,variavel="PRODUTO_DESCRICAO_PRODUTOS");
					v_st_origem_id = this.ListaToArray(lista=arguments,variavel="ST_ORIGEM_ID_PRODUTOS");
					v_st_icms_id = this.ListaToArray(lista=arguments,variavel="ST_ICMS_ID_PRODUTOS");
					v_incluir_livro_fiscal = this.ListaToArray(lista=arguments,variavel="INCLUIR_LIVRO_FISCAL_PRODUTOS");
					v_produto_peso = this.ListaToArray(lista=arguments,variavel="PRODUTO_PESO_PRODUTOS");
					v_produto_volume = this.ListaToArray(lista=arguments,variavel="PRODUTO_VOLUME_PRODUTOS");
					v_produto_metro = this.ListaToArray(lista=arguments,variavel="PRODUTO_METRO_PRODUTOS");
					v_cod_unidade = this.ListaToArray(lista=arguments,variavel="COD_UNIDADE_PRODUTOS");
					v_produto_valor_em = this.ListaToArray(lista=arguments,variavel="PRODUTO_VALOR_EM_PRODUTOS");
					v_produto_valor_unitario = this.ListaToArray(lista=arguments,variavel="PRODUTO_VALOR_UNITARIO_PRODUTOS");
					v_produto_valor_total = this.ListaToArray(lista=arguments,variavel="PRODUTO_VALOR_TOTAL_PRODUTOS");
					v_produto_desconto_percentual = this.ListaToArray(lista=arguments,variavel="PRODUTO_DESCONTO_PERCENTUAL_PRODUTOS");
					v_produto_valor_desconto = this.ListaToArray(lista=arguments,variavel="PRODUTO_VALOR_DESCONTO_PRODUTOS");
					v_produto_valor_final = this.ListaToArray(lista=arguments,variavel="PRODUTO_VALOR_FINAL_PRODUTOS");
					v_produto_icms_reducao_base = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_REDUCAO_BASE_PRODUTOS");
					v_produto_icms_base_calculo = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_BASE_CALCULO_PRODUTOS");
					v_produto_icms_aliquota = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_ALIQUOTA_PRODUTOS");
					v_produto_icms_valor = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_VALOR_PRODUTOS");
					v_produto_ipi_reducao_base = this.ListaToArray(lista=arguments,variavel="PRODUTO_IPI_REDUCAO_BASE_PRODUTOS");
					v_produto_ipi_base_calculo = this.ListaToArray(lista=arguments,variavel="PRODUTO_IPI_BASE_CALCULO_PRODUTOS");
					v_produto_ipi_aliquota = this.ListaToArray(lista=arguments,variavel="PRODUTO_IPI_ALIQUOTA_PRODUTOS");
					v_produto_ipi_valor = this.ListaToArray(lista=arguments,variavel="PRODUTO_IPI_VALOR_PRODUTOS");
					v_natureza_operacao = this.ListaToArray(lista=arguments,variavel="NATUREZA_OPERACAO_PRODUTOS");
					v_produto_icms_base_calculo_subst = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_BASE_CALCULO_SUBST_PRODUTOS");
					v_produto_icms_valor_subst = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_VALOR_SUBST_PRODUTOS");
				</cfscript>
                
                <cfloop from="1" to="#ArrayLen(v_num_nota_it_id)#" index="count">
                	<cfscript>
						set_item = this.ins_nf_terceiro_it(NUM_NOTA_ID = retorno.NUM_NOTA_ID
														  ,CFOP        = v_cfop[count]
														  ,CFOP_ID     = v_cfop_id[count]
														  ,UF_UNIDADE_NEGOCIO = v_uf_unidade_negocio[count]
														  ,UF_EMITENTE = v_uf_emitente[count]
														  ,PRODUTO_ID = v_produto_id[count]
														  ,DESCRICAO_COMPLEMENTO = v_descricao_complemento[count]
														  ,DESCRICAO = v_produto_descricao[count]
														  ,COD_NCM = v_cod_ncm[count]
														  ,ST_ORIGEM_ID = v_st_origem_id[count]
														  ,ST_ICMS_ID = v_st_icms_id[count]
														  ,COD_UNIDADE = v_cod_unidade[count]
														  ,QTDE_PESO = v_produto_peso[count]
														  ,QTDE_VOLUME = v_produto_volume[count]
														  ,QTDE_METRO = v_produto_metro[count]
														  ,VALOR_EM = v_produto_valor_em[count]
														  ,VALOR_EM_UNIDADE = v_valor_em_unidade[count]
														  ,VALOR_UNITARIO = v_produto_valor_unitario[count]
														  ,VALOR_TOTAL = v_produto_valor_total[count]
														  ,ICMS_REDUCAO_BASE = v_produto_icms_reducao_base[count]
														  ,ICMS_BASE_CALCULO = v_produto_icms_base_calculo[count]
														  ,ICMS_ALIQUOTA = v_produto_icms_aliquota[count]
														  ,ICMS_VALOR = v_produto_icms_valor[count]
														  ,ICMS_BASE_CALC_SUBST = v_produto_icms_base_calculo_subst[count]
														  ,ICMS_VALOR_SUBST = v_produto_icms_valor_subst[count]
														  ,IPI_REDUCAO_BASE = v_produto_ipi_reducao_base[count]
														  ,IPI_BASE_CALCULO = v_produto_ipi_base_calculo[count]
														  ,IPI_ALIQUOTA = v_produto_ipi_aliquota[count]
														  ,IPI_VALOR = v_produto_ipi_valor[count]
														  ,SERV_TOTAL_TRIBUTAVEL = v_serv_total_tributavel[count]
														  ,SERV_TOTAL_NAO_TRIBUTAVEL = v_serv_total_nao_tributavel[count]
														  ,SERV_TOTAL_PRODUTO = v_serv_total_produto[count]
														  ,SERV_ISS_ALIQUOTA = v_serv_iss_aliquota[count]
														  ,SERV_ISS_DEDUCAO = v_serv_iss_deducao[count]
														  ,SERV_ISS_VALOR = v_serv_iss_valor[count]
														  ,DESCONTO_PERCENTUAL = v_produto_desconto_percentual[count]
														  ,DESCONTO_VALOR = v_produto_valor_desconto[count]
														  ,INCLUIR_ESTOQUE = v_incluir_estoque[count]
														  ,INCLUIR_LIVRO_FISCAL = v_incluir_livro_fiscal[count]
														  ,INCLUIR_SINTEGRA = v_incluir_sintegra[count]);
					</cfscript>     
                    <cfif set_item.erro>
                    	<cfthrow object="#set_item.mensagem#">
                    </cfif>
                </cfloop>    
                
                <!---Impostos--->
                <cfscript>
					v_imposto_id = this.ListaToArray(lista=arguments,variavel="IMPOSTO_ID_ITENS_IMPOSTO");
					v_imposto_reducao_base = this.ListaToArray(lista=arguments,variavel="IMPOSTO_REDUCAO_BASE_ITENS_IMPOSTO");
					v_imposto_base_calculo = this.ListaToArray(lista=arguments,variavel="IMPOSTO_BASE_CALCULO_ITENS_IMPOSTO");
					v_imposto_aliquota = this.ListaToArray(lista=arguments,variavel="IMPOSTO_ALIQUOTA_ITENS_IMPOSTO");
					v_imposto_total = this.ListaToArray(lista=arguments,variavel="IMPOSTO_TOTAL_ITENS_IMPOSTO");
					v_imposto_data_vencimento = this.ListaToArray(lista=arguments,variavel="IMPOSTO_DATA_VENCIMENTO_ITENS_IMPOSTO");
					v_imposto_retido_fonte = this.ListaToArray(lista=arguments,variavel="IMPOSTO_RETIDO_FONTE_ITENS_IMPOSTO");
				</cfscript>
                <cfloop from="1" to="#ArrayLen(v_imposto_id)#" index="count">
					<cfscript>
                        set_impostos = this.ins_nf_terceiro_imposto(NUM_NOTA_ID = retorno.NUM_NOTA_ID
                                                                   ,IMPOSTO_ID = v_imposto_id[count]
                                                                   ,IMPOSTO_REDUCAO_BASE = v_imposto_reducao_base[count]
                                                                   ,IMPOSTO_BASE_CALCULO = v_imposto_base_calculo[count]
                                                                   ,IMPOSTO_ALIQUOTA = v_imposto_aliquota[count]
                                                                   ,IMPOSTO_TOTAL = v_imposto_total[count]
                                                                   ,DATA_VENCIMENTO = v_imposto_data_vencimento[count]
                                                                   ,IMPOSTO_RETIDO_FONTE = v_imposto_retido_fonte[count]);				
                    </cfscript>      
                    <cfif set_impostos.erro>
                    	<cfthrow object="#set_impostos.mensagem#">
                    </cfif>
                </cfloop>     
                
                <!---Rateio--->
                <cfscript>
					v_apelido = this.ListaToArray(lista=arguments,variavel="APELIDO_RATEIO");
					v_cod_contabil_rateio = this.ListaToArray(lista=arguments,variavel="COD_CONTABIL_RATEIO_RATEIO");
					v_historico = this.ListaToArray(lista=arguments,variavel="HISTORICO_RATEIO");
					v_cod_centro_custo_rateio = this.ListaToArray(lista=arguments,variavel="COD_CENTRO_CUSTO_RATEIO_RATEIO");
					v_centro_custo_rateio = this.ListaToArray(lista=arguments,variavel="CENTRO_CUSTO_RATEIO_RATEIO");
					v_percentual_rateio = this.ListaToArray(lista=arguments,variavel="PERCENTUAL_RATEIO_RATEIO");
					v_valor_rateio = this.ListaToArray(lista=arguments,variavel="VALOR_RATEIO_RATEIO");
					v_cod_pessoa_rateio = this.ListaToArray(lista=arguments,variavel="COD_PESSOA_RATEIO_RATEIO");
					v_cod_departamento_rateio = this.ListaToArray(lista=arguments,variavel="COD_DEPARTAMENTO_RATEIO_RATEIO");
					v_cod_setor_rateio = this.ListaToArray(lista=arguments,variavel="COD_SETOR_RATEIO_RATEIO");
				</cfscript>
                
                <cfloop from="1" to="#ArrayLen(v_percentual_rateio)#" index="count">
                	<cfscript>
						set_rateio = this.ins_nf_terceiro_rateio(NUM_NOTA_ID = retorno.NUM_NOTA_ID
																,COD_PESSOA = v_cod_pessoa_rateio[count]
																,COD_DEPARTAMENTO = v_cod_departamento_rateio[count]
																,COD_SETOR = v_cod_setor_rateio[count]
																,COD_CENTRO_CUSTO = v_cod_centro_custo_rateio[count]
																,COD_CONTABIL = v_cod_contabil_rateio[count]
																,PERC_RATEIO = v_percentual_rateio[count]
																,VALOR_RATEIO = v_valor_rateio[count]);
					</cfscript>
                    <cfif set_rateio.erro>
                    	<cfthrow object="#set_rateio.mensagem#">
                    </cfif>
                </cfloop>
                
                <!---Contas a Pagar--->
                <cfscript>
					v_contas_pagar_id = this.ListaToArray(lista=arguments,variavel="CONTAS_PAGAR_ID_FATURAMENTO");
					v_fat_num_docto = this.ListaToArray(lista=arguments,variavel="FAT_NUM_DOCTO_FATURAMENTO");
					v_fat_data_vencto = this.ListaToArray(lista=arguments,variavel="FAT_DATA_VENCTO_FATURAMENTO");
					v_fat_valor_docto = this.ListaToArray(lista=arguments,variavel="FAT_VALOR_DOCTO_FATURAMENTO");
					v_fat_num_historico = this.ListaToArray(lista=arguments,variavel="FAT_NUM_HISTORICO_FATURAMENTO");
					v_fat_historico = this.ListaToArray(lista=arguments,variavel="FAT_HISTORICO_FATURAMENTO");
					v_fat_tipo_pagto = this.ListaToArray(lista=arguments,variavel="FAT_TIPO_PAGTO_FATURAMENTO");
					v_fat_docto_id = this.ListaToArray(lista=arguments,variavel="FAT_DOCTO_ID_FATURAMENTO");				
					v_fat_caixa_id = this.ListaToArray(lista=arguments,variavel="CAIXA_ID_FATURAMENTO");				
					v_parcela = 1;
                    conn = CreateComponent("_transportes.manipulacao.cfc_caixa");
				</cfscript>
	                
                <cfloop from="1" to="#ArrayLen(v_fat_num_docto)#" index="count">
                	<cfscript>
						set_contas_pagar  = this.ins_nft_contas_pagar(NUM_NOTA_ID = retorno.NUM_NOTA_ID
																	 ,CONTAS_PAGAR_ID = v_contas_pagar_id[count]
																	 ,DOCTO_ID = v_fat_docto_id[count]
																	 ,NUM_DOCTO = v_fat_num_docto[count]
																	 ,PARC_DOCTO = v_parcela
																	 ,COD_HISTORICO = v_fat_historico[count]
																	 ,BANCO_ID = ''
																	 ,AGENCIA_ID = ''
																	 ,CONTA = ''
																	 ,TIPO_PAGTO_ID = v_fat_tipo_pagto[count]
																	 ,DATA_EMISSAO = arguments.DATA_EMISSAO
																	 ,DATA_VENCTO = v_fat_data_vencto[count]
																	 ,VALOR_DOCTO = v_fat_valor_docto[count]
																	 ,CODIGO_BARRAS = '');				
						v_parcela = v_parcela + 1;
					</cfscript>
                    <cfif set_contas_pagar.erro>
                    	<cfthrow object="#set_contas_pagar.mensagem#">
                    </cfif>       
                    
                    <cfloop from="1" to="#ArrayLen(v_percentual_rateio)#" index="cr">
                        <cfscript>
						   set_rateio = conn.ins_finan_contas_pagar_rateio(CONTAS_PAGAR_ID = set_contas_pagar.CONTAS_PAGAR_ID
																		  ,COD_PESSOA = v_cod_pessoa_rateio[cr]
																		  ,COD_DEPARTAMENTO = v_cod_departamento_rateio[cr]
																		  ,COD_SETOR = v_cod_setor_rateio[cr]
																		  ,COD_CENTRO_CUSTO = v_cod_centro_custo_rateio[cr]
																		  ,PERC_RATEIO = v_percentual_rateio[cr]
																		  ,VALOR_RATEIO = v_fat_valor_docto[count]*(v_percentual_rateio[cr]/100));
                        </cfscript>
                        <cfif set_rateio.erro>
                            <cfthrow object="#set_rateio.mensagem#">
                        </cfif>
                    </cfloop>                             

					<!---Pagamento--->
                    <cfif Len(Trim(v_fat_caixa_id[count])) and v_fat_tipo_pagto[count] eq 1>
                        <cfscript>
                            set_pagto = conn.ins_pagto_caixa(contas_pagar_id  = set_contas_pagar.CONTAS_PAGAR_ID
                                                            ,num_recibo = ''
                                                            ,data_amortizacao = arguments.DATA_EMISSAO
															,valor_amortizacao = v_fat_valor_docto[count]
															,TIPO_PAGTO_ID = v_fat_tipo_pagto[count]
															,COD_HISTORICO = v_fat_historico[count]
															,CAIXA_ID = v_fat_caixa_id[count]
															,COD_PESSOA_PAGAMENTO = arguments.COD_EMITENTE);
															
                        </cfscript>

						<cfif set_pagto.erro>
                            <cfthrow object="#set_pagto.mensagem#">
                        </cfif>                
                    </cfif>
                </cfloop>
                
            
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Altera nota fiscal de terceiro
    -- guto 10/12/2008 15:45:36 - CRIADO
    --->
    <cffunction name='upd_nf_terceiro' displayname='Altera nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='yes'>
        <cfargument name='COD_DEPARTAMENTO' required='yes'>
        <cfargument name='COD_SETOR' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='NUM_NOTA_FISCAL' required='yes'>
        <cfargument name='COD_MODELO' required='yes'>
        <cfargument name='SERIE' required='yes'>
        <cfargument name='SUBSERIE' required='yes'>
        <cfargument name='NATUREZA_ID' required='yes'>
        <cfargument name='NATUREZA_DESCRICAO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='DATA_ENTRADA' required='yes'>
        <cfargument name='COD_EMITENTE' required='yes'>
        <cfargument name='EMIT_RAZAO_SOCIAL' required='yes'>
        <cfargument name='EMIT_ENDERECO' required='yes'>
        <cfargument name='EMIT_BAIRRO' required='yes'>
        <cfargument name='EMIT_MUNICIPIO' required='yes'>
        <cfargument name='EMIT_UF' required='yes'>
        <cfargument name='EMIT_CEP' required='yes'>
        <cfargument name='EMIT_TELEFONE' required='yes'>
        <cfargument name='EMIT_CNPJ_CPF' required='yes'>
        <cfargument name='EMIT_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='COD_CLIENTE' required='yes'>
        <cfargument name='NF_IMPOSTO_ID' required='no' default="">
        <cfargument name='CALC_BASE_ICMS' required='yes'>
        <cfargument name='CALC_VALOR_ICMS' required='yes'>
        <cfargument name='CALC_BASE_ICMS_SUBST' required='yes'>
        <cfargument name='CALC_VALOR_ICMS_SUBST' required='yes'>
        <cfargument name='CALC_VALOR_TOTAL_PRODUTOS' required='yes'>
        <cfargument name='CALC_VALOR_FRETE' required='yes'>
        <cfargument name='CALC_VALOR_SEGURO' required='yes'>
        <cfargument name='CALC_OUTRAS_DESPESAS' required='yes'>
        <cfargument name='CALC_VALOR_TOTAL_IPI' required='yes'>
        <cfargument name='CALC_VALOR_TOTAL_NOTA' required='yes'>
        <cfargument name='OBSERVACAO_FISCAL' required='yes'>
        <cfargument name='OBSERVACAO_USUARIO' required='yes'>
        <cfargument name='CONFERIDA' required='no' default="0">
        <cfargument name='COD_CONTABIL' required='yes'>
        <cfargument name='INCLUIR_SISS' required='yes'>
        <cfargument name='COD_SERVICO_DES' required='yes'>
        <cfargument name='NATUREZA_SISS_ID' required='yes'>
        <cfargument name='AVISTA_APRAZO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_alt_nf_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_FISCAL'  value='#arguments.NUM_NOTA_FISCAL#'  null='#iif(len(trim(arguments.NUM_NOTA_FISCAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NATUREZA_ID'  value='#arguments.NATUREZA_ID#'  null='#iif(len(trim(arguments.NATUREZA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_DESCRICAO'  value='#arguments.NATUREZA_DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ENTRADA'  value='#arguments.DATA_ENTRADA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_EMITENTE'  value='#arguments.COD_EMITENTE#'  null='#iif(len(trim(arguments.COD_EMITENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_RAZAO_SOCIAL'  value='#arguments.EMIT_RAZAO_SOCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_ENDERECO'  value='#arguments.EMIT_ENDERECO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_BAIRRO'  value='#arguments.EMIT_BAIRRO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_MUNICIPIO'  value='#arguments.EMIT_MUNICIPIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_UF'  value='#arguments.EMIT_UF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_CEP'  value='#arguments.EMIT_CEP#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_TELEFONE'  value='#arguments.EMIT_TELEFONE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_CNPJ_CPF'  value='#arguments.EMIT_CNPJ_CPF#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EMIT_INSCRICAO_ESTADUAL'  value='#arguments.EMIT_INSCRICAO_ESTADUAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE'  value='#arguments.COD_CLIENTE#'  null='#iif(len(trim(arguments.COD_CLIENTE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS'  value='#arguments.CALC_BASE_ICMS#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS'  value='#arguments.CALC_VALOR_ICMS#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_BASE_ICMS_SUBST'  value='#arguments.CALC_BASE_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS_SUBST)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_ICMS_SUBST'  value='#arguments.CALC_VALOR_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS_SUBST)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_PRODUTOS'  value='#arguments.CALC_VALOR_TOTAL_PRODUTOS#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_FRETE'  value='#arguments.CALC_VALOR_FRETE#'  null='#iif(len(trim(arguments.CALC_VALOR_FRETE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_SEGURO'  value='#arguments.CALC_VALOR_SEGURO#'  null='#iif(len(trim(arguments.CALC_VALOR_SEGURO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_OUTRAS_DESPESAS'  value='#arguments.CALC_OUTRAS_DESPESAS#'  null='#iif(len(trim(arguments.CALC_OUTRAS_DESPESAS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_IPI'  value='#arguments.CALC_VALOR_TOTAL_IPI#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_IPI)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CALC_VALOR_TOTAL_NOTA'  value='#arguments.CALC_VALOR_TOTAL_NOTA#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_FISCAL'  value='#arguments.OBSERVACAO_FISCAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#arguments.OBSERVACAO_USUARIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONFERIDA'  value='#arguments.CONFERIDA#'  null='#iif(len(trim(arguments.CONFERIDA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_CONTABIL'  value='#arguments.COD_CONTABIL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_SISS'  value='#arguments.INCLUIR_SISS#'  null='#iif(len(trim(arguments.INCLUIR_SISS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SERVICO_DES'  value='#arguments.COD_SERVICO_DES#'  null='#iif(len(trim(arguments.COD_SERVICO_DES)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_SISS_ID'  value='#arguments.NATUREZA_SISS_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AVISTA_APRAZO'  value='#arguments.AVISTA_APRAZO#'  null='#iif(len(trim(arguments.AVISTA_APRAZO)), de('no'), de('yes'))#'>
                </cfstoredproc>

                <!---Itens--->
                <cfscript>
					v_num_nota_it_id = this.ListaToArray(lista=arguments,variavel="NUM_NOTA_IT_ID_PRODUTOS");
					v_uf_unidade_negocio = this.ListaToArray(lista=arguments,variavel="UF_UNIDADE_NEGOCIO_PRODUTOS");
					v_uf_emitente = this.ListaToArray(lista=arguments,variavel="UF_EMITENTE_PRODUTOS");
					v_descricao_complemento = this.ListaToArray(lista=arguments,variavel="DESCRICAO_COMPLEMENTO_PRODUTOS");
					v_cod_ncm = this.ListaToArray(lista=arguments,variavel="COD_NCM_PRODUTOS");
					v_valor_em_unidade = this.ListaToArray(lista=arguments,variavel="VALOR_EM_UNIDADE_PRODUTOS");
					v_serv_total_tributavel = this.ListaToArray(lista=arguments,variavel="SERV_TOTAL_TRIBUTAVEL_PRODUTOS");
					v_serv_total_nao_tributavel = this.ListaToArray(lista=arguments,variavel="SERV_TOTAL_NAO_TRIBUTAVEL_PRODUTOS");
					v_serv_total_produto = this.ListaToArray(lista=arguments,variavel="SERV_TOTAL_PRODUTO_PRODUTOS");
					v_incluir_sintegra = this.ListaToArray(lista=arguments,variavel="INCLUIR_SINTEGRA_PRODUTOS");
					v_serv_iss_aliquota = this.ListaToArray(lista=arguments,variavel="SERV_ISS_ALIQUOTA_PRODUTOS");
					v_serv_iss_deducao = this.ListaToArray(lista=arguments,variavel="SERV_ISS_DEDUCAO_PRODUTOS");
					v_serv_iss_valor = this.ListaToArray(lista=arguments,variavel="SERV_ISS_VALOR_PRODUTOS");
					v_incluir_estoque = this.ListaToArray(lista=arguments,variavel="INCLUIR_ESTOQUE_PRODUTOS");
					v_cfop = this.ListaToArray(lista=arguments,variavel="CFOP_PRODUTOS");
					v_cfop_id = this.ListaToArray(lista=arguments,variavel="CFOP_ID_PRODUTOS");
					v_produto_id = this.ListaToArray(lista=arguments,variavel="PRODUTO_ID_PRODUTOS");
					v_produto_descricao = this.ListaToArray(lista=arguments,variavel="PRODUTO_DESCRICAO_PRODUTOS");
					v_st_origem_id = this.ListaToArray(lista=arguments,variavel="ST_ORIGEM_ID_PRODUTOS");
					v_st_icms_id = this.ListaToArray(lista=arguments,variavel="ST_ICMS_ID_PRODUTOS");
					v_incluir_livro_fiscal = this.ListaToArray(lista=arguments,variavel="INCLUIR_LIVRO_FISCAL_PRODUTOS");
					v_produto_peso = this.ListaToArray(lista=arguments,variavel="PRODUTO_PESO_PRODUTOS");
					v_produto_volume = this.ListaToArray(lista=arguments,variavel="PRODUTO_VOLUME_PRODUTOS");
					v_produto_metro = this.ListaToArray(lista=arguments,variavel="PRODUTO_METRO_PRODUTOS");
					v_cod_unidade = this.ListaToArray(lista=arguments,variavel="COD_UNIDADE_PRODUTOS");
					v_produto_valor_em = this.ListaToArray(lista=arguments,variavel="PRODUTO_VALOR_EM_PRODUTOS");
					v_produto_valor_unitario = this.ListaToArray(lista=arguments,variavel="PRODUTO_VALOR_UNITARIO_PRODUTOS");
					v_produto_valor_total = this.ListaToArray(lista=arguments,variavel="PRODUTO_VALOR_TOTAL_PRODUTOS");
					v_produto_desconto_percentual = this.ListaToArray(lista=arguments,variavel="PRODUTO_DESCONTO_PERCENTUAL_PRODUTOS");
					v_produto_valor_desconto = this.ListaToArray(lista=arguments,variavel="PRODUTO_VALOR_DESCONTO_PRODUTOS");
					v_produto_valor_final = this.ListaToArray(lista=arguments,variavel="PRODUTO_VALOR_FINAL_PRODUTOS");
					v_produto_icms_reducao_base = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_REDUCAO_BASE_PRODUTOS");
					v_produto_icms_base_calculo = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_BASE_CALCULO_PRODUTOS");
					v_produto_icms_aliquota = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_ALIQUOTA_PRODUTOS");
					v_produto_icms_valor = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_VALOR_PRODUTOS");
					v_produto_ipi_reducao_base = this.ListaToArray(lista=arguments,variavel="PRODUTO_IPI_REDUCAO_BASE_PRODUTOS");
					v_produto_ipi_base_calculo = this.ListaToArray(lista=arguments,variavel="PRODUTO_IPI_BASE_CALCULO_PRODUTOS");
					v_produto_ipi_aliquota = this.ListaToArray(lista=arguments,variavel="PRODUTO_IPI_ALIQUOTA_PRODUTOS");
					v_produto_ipi_valor = this.ListaToArray(lista=arguments,variavel="PRODUTO_IPI_VALOR_PRODUTOS");
					v_natureza_operacao = this.ListaToArray(lista=arguments,variavel="NATUREZA_OPERACAO_PRODUTOS");
					v_produto_icms_base_calculo_subst = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_BASE_CALCULO_SUBST_PRODUTOS");
					v_produto_icms_valor_subst = this.ListaToArray(lista=arguments,variavel="PRODUTO_ICMS_VALOR_SUBST_PRODUTOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_PRODUTOS, lista2 = ArrayToList(v_num_nota_it_id));
				</cfscript>
                
                <cfloop list="#v_excluir#" delimiters="," index="id">
                	<cfscript>
						set_item = this.del_nf_terceiro_it(NUM_NOTA_IT_ID = id
														  ,NUM_NOTA_ID = arguments.NUM_NOTA_ID
														   );
					</cfscript>
                    <cfif set_item.erro>
                    	<cfthrow object="#set_item.mensagem#">
                    </cfif>                    
                </cfloop>
                
                <cfloop from="1" to="#ArrayLen(v_num_nota_it_id)#" index="count">
                   <cfif Len(Trim(v_num_nota_it_id[count]))>
						<cfscript>
                            set_item = this.upd_nf_terceiro_it(NUM_NOTA_ID = arguments.NUM_NOTA_ID
															  ,NUM_NOTA_IT_ID = v_num_nota_it_id[count] 
                                                              ,CFOP        = v_cfop[count]
                                                              ,CFOP_ID     = v_cfop_id[count]
                                                              ,UF_UNIDADE_NEGOCIO = v_uf_unidade_negocio[count]
                                                              ,UF_EMITENTE = v_uf_emitente[count]
                                                              ,PRODUTO_ID = v_produto_id[count]
                                                              ,DESCRICAO_COMPLEMENTO = v_descricao_complemento[count]
                                                              ,DESCRICAO = v_produto_descricao[count]
                                                              ,COD_NCM = v_cod_ncm[count]
                                                              ,ST_ORIGEM_ID = v_st_origem_id[count]
                                                              ,ST_ICMS_ID = v_st_icms_id[count]
                                                              ,COD_UNIDADE = v_cod_unidade[count]
                                                              ,QTDE_PESO = v_produto_peso[count]
                                                              ,QTDE_VOLUME = v_produto_volume[count]
                                                              ,QTDE_METRO = v_produto_metro[count]
                                                              ,VALOR_EM = v_produto_valor_em[count]
                                                              ,VALOR_EM_UNIDADE = v_valor_em_unidade[count]
                                                              ,VALOR_UNITARIO = v_produto_valor_unitario[count]
                                                              ,VALOR_TOTAL = v_produto_valor_total[count]
                                                              ,ICMS_REDUCAO_BASE = v_produto_icms_reducao_base[count]
                                                              ,ICMS_BASE_CALCULO = v_produto_icms_base_calculo[count]
                                                              ,ICMS_ALIQUOTA = v_produto_icms_aliquota[count]
                                                              ,ICMS_VALOR = v_produto_icms_valor[count]
                                                              ,ICMS_BASE_CALC_SUBST = v_produto_icms_base_calculo_subst[count]
                                                              ,ICMS_VALOR_SUBST = v_produto_icms_valor_subst[count]
                                                              ,IPI_REDUCAO_BASE = v_produto_ipi_reducao_base[count]
                                                              ,IPI_BASE_CALCULO = v_produto_ipi_base_calculo[count]
                                                              ,IPI_ALIQUOTA = v_produto_ipi_aliquota[count]
                                                              ,IPI_VALOR = v_produto_ipi_valor[count]
                                                              ,SERV_TOTAL_TRIBUTAVEL = v_serv_total_tributavel[count]
                                                              ,SERV_TOTAL_NAO_TRIBUTAVEL = v_serv_total_nao_tributavel[count]
                                                              ,SERV_TOTAL_PRODUTO = v_serv_total_produto[count]
                                                              ,SERV_ISS_ALIQUOTA = v_serv_iss_aliquota[count]
                                                              ,SERV_ISS_DEDUCAO = v_serv_iss_deducao[count]
                                                              ,SERV_ISS_VALOR = v_serv_iss_valor[count]
                                                              ,DESCONTO_PERCENTUAL = v_produto_desconto_percentual[count]
                                                              ,DESCONTO_VALOR = v_produto_valor_desconto[count]
                                                              ,INCLUIR_ESTOQUE = v_incluir_estoque[count]
                                                              ,INCLUIR_LIVRO_FISCAL = v_incluir_livro_fiscal[count]
                                                              ,INCLUIR_SINTEGRA = v_incluir_sintegra[count]);
                        </cfscript>     
                   <cfelse>
						<cfscript>
                            set_item = this.ins_nf_terceiro_it(NUM_NOTA_ID = arguments.NUM_NOTA_ID
                                                              ,CFOP        = v_cfop[count]
                                                              ,CFOP_ID     = v_cfop_id[count]
                                                              ,UF_UNIDADE_NEGOCIO = v_uf_unidade_negocio[count]
                                                              ,UF_EMITENTE = v_uf_emitente[count]
                                                              ,PRODUTO_ID = v_produto_id[count]
                                                              ,DESCRICAO_COMPLEMENTO = v_descricao_complemento[count]
                                                              ,DESCRICAO = v_produto_descricao[count]
                                                              ,COD_NCM = v_cod_ncm[count]
                                                              ,ST_ORIGEM_ID = v_st_origem_id[count]
                                                              ,ST_ICMS_ID = v_st_icms_id[count]
                                                              ,COD_UNIDADE = v_cod_unidade[count]
                                                              ,QTDE_PESO = v_produto_peso[count]
                                                              ,QTDE_VOLUME = v_produto_volume[count]
                                                              ,QTDE_METRO = v_produto_metro[count]
                                                              ,VALOR_EM = v_produto_valor_em[count]
                                                              ,VALOR_EM_UNIDADE = v_produto_valor_em[count]
                                                              ,VALOR_UNITARIO = v_produto_valor_unitario[count]
                                                              ,VALOR_TOTAL = v_produto_valor_total[count]
                                                              ,ICMS_REDUCAO_BASE = v_produto_icms_reducao_base[count]
                                                              ,ICMS_BASE_CALCULO = v_produto_icms_base_calculo[count]
                                                              ,ICMS_ALIQUOTA = v_produto_icms_aliquota[count]
                                                              ,ICMS_VALOR = v_produto_icms_valor[count]
                                                              ,ICMS_BASE_CALC_SUBST = v_produto_icms_base_calculo_subst[count]
                                                              ,ICMS_VALOR_SUBST = v_produto_icms_valor_subst[count]
                                                              ,IPI_REDUCAO_BASE = v_produto_ipi_reducao_base[count]
                                                              ,IPI_BASE_CALCULO = v_produto_ipi_base_calculo[count]
                                                              ,IPI_ALIQUOTA = v_produto_ipi_aliquota[count]
                                                              ,IPI_VALOR = v_produto_ipi_valor[count]
                                                              ,SERV_TOTAL_TRIBUTAVEL = v_serv_total_tributavel[count]
                                                              ,SERV_TOTAL_NAO_TRIBUTAVEL = v_serv_total_nao_tributavel[count]
                                                              ,SERV_TOTAL_PRODUTO = v_serv_total_produto[count]
                                                              ,SERV_ISS_ALIQUOTA = v_serv_iss_aliquota[count]
                                                              ,SERV_ISS_DEDUCAO = v_serv_iss_deducao[count]
                                                              ,SERV_ISS_VALOR = v_serv_iss_valor[count]
                                                              ,DESCONTO_PERCENTUAL = v_produto_desconto_percentual[count]
                                                              ,DESCONTO_VALOR = v_produto_valor_desconto[count]
                                                              ,INCLUIR_ESTOQUE = v_incluir_estoque[count]
                                                              ,INCLUIR_LIVRO_FISCAL = v_incluir_livro_fiscal[count]
                                                              ,INCLUIR_SINTEGRA = v_incluir_sintegra[count]);
                        </cfscript>     
                    </cfif>
                    <cfif set_item.erro>
                    	<cfthrow object="#set_item.mensagem#">
                    </cfif>
                </cfloop>    
                
                <!---Impostos--->
                <cfscript>
					v_nf_imposto_id = this.ListaToArray(lista=arguments,variavel="NF_IMPOSTO_ID_ITENS_IMPOSTO");
					v_imposto_id = this.ListaToArray(lista=arguments,variavel="IMPOSTO_ID_ITENS_IMPOSTO");
					v_imposto_reducao_base = this.ListaToArray(lista=arguments,variavel="IMPOSTO_REDUCAO_BASE_ITENS_IMPOSTO");
					v_imposto_base_calculo = this.ListaToArray(lista=arguments,variavel="IMPOSTO_BASE_CALCULO_ITENS_IMPOSTO");
					v_imposto_aliquota = this.ListaToArray(lista=arguments,variavel="IMPOSTO_ALIQUOTA_ITENS_IMPOSTO");
					v_imposto_total = this.ListaToArray(lista=arguments,variavel="IMPOSTO_TOTAL_ITENS_IMPOSTO");
					v_imposto_data_vencimento = this.ListaToArray(lista=arguments,variavel="IMPOSTO_DATA_VENCIMENTO_ITENS_IMPOSTO");
					v_imposto_retido_fonte = this.ListaToArray(lista=arguments,variavel="IMPOSTO_RETIDO_FONTE_ITENS_IMPOSTO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ITENS_IMPOSTO, lista2 = ArrayToList(v_nf_imposto_id));
				</cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="id">
                	<cfscript>
						set_impostos = this.del_nf_terceiro_imposto(NF_IMPOSTO_ID = id
														           ,NUM_NOTA_ID = arguments.NUM_NOTA_ID
														           );
					</cfscript>
                    <cfif set_impostos.erro>
                    	<cfthrow object="#set_impostos.mensagem#">
                    </cfif>                    
                </cfloop>                
                <cfloop from="1" to="#ArrayLen(v_imposto_id)#" index="count">
                	<cfif Len(Trim(v_nf_imposto_id[count]))>
						<cfscript>
                            set_impostos = this.upd_nf_terceiro_imposto(NUM_NOTA_ID = arguments.NUM_NOTA_ID
																	   ,NF_IMPOSTO_ID = v_nf_imposto_id[count]	
                                                                       ,IMPOSTO_ID = v_imposto_id[count]
                                                                       ,IMPOSTO_REDUCAO_BASE = v_imposto_reducao_base[count]
                                                                       ,IMPOSTO_BASE_CALCULO = v_imposto_base_calculo[count]
                                                                       ,IMPOSTO_ALIQUOTA = v_imposto_aliquota[count]
                                                                       ,IMPOSTO_TOTAL = v_imposto_total[count]
                                                                       ,DATA_VENCIMENTO = v_imposto_data_vencimento[count]
                                                                       ,IMPOSTO_RETIDO_FONTE = v_imposto_retido_fonte[count]);				
                        </cfscript>      
                    <cfelse>
						<cfscript>
                            set_impostos = this.ins_nf_terceiro_imposto(NUM_NOTA_ID = arguments.NUM_NOTA_ID
                                                                       ,IMPOSTO_ID = v_imposto_id[count]
                                                                       ,IMPOSTO_REDUCAO_BASE = v_imposto_reducao_base[count]
                                                                       ,IMPOSTO_BASE_CALCULO = v_imposto_base_calculo[count]
                                                                       ,IMPOSTO_ALIQUOTA = v_imposto_aliquota[count]
                                                                       ,IMPOSTO_TOTAL = v_imposto_total[count]
                                                                       ,DATA_VENCIMENTO = v_imposto_data_vencimento[count]
                                                                       ,IMPOSTO_RETIDO_FONTE = v_imposto_retido_fonte[count]);				
                        </cfscript>      
                    </cfif>
                    <cfif set_impostos.erro>
                    	<cfthrow object="#set_impostos.mensagem#">
                    </cfif>
                </cfloop>     
                
                <!---Rateio--->
                <cfscript>
					v_nf_rateio_id = this.ListaToArray(lista=arguments,variavel="NF_RATEIO_ID_RATEIO");
					v_apelido = this.ListaToArray(lista=arguments,variavel="APELIDO_RATEIO");
					v_cod_contabil_rateio = this.ListaToArray(lista=arguments,variavel="COD_CONTABIL_RATEIO_RATEIO");
					v_historico = this.ListaToArray(lista=arguments,variavel="HISTORICO_RATEIO");
					v_cod_centro_custo_rateio = this.ListaToArray(lista=arguments,variavel="COD_CENTRO_CUSTO_RATEIO_RATEIO");
					v_centro_custo_rateio = this.ListaToArray(lista=arguments,variavel="CENTRO_CUSTO_RATEIO_RATEIO");
					v_percentual_rateio = this.ListaToArray(lista=arguments,variavel="PERCENTUAL_RATEIO_RATEIO");
					v_valor_rateio = this.ListaToArray(lista=arguments,variavel="VALOR_RATEIO_RATEIO");
					v_cod_pessoa_rateio = this.ListaToArray(lista=arguments,variavel="COD_PESSOA_RATEIO_RATEIO");
					v_cod_departamento_rateio = this.ListaToArray(lista=arguments,variavel="COD_DEPARTAMENTO_RATEIO_RATEIO");
					v_cod_setor_rateio = this.ListaToArray(lista=arguments,variavel="COD_SETOR_RATEIO_RATEIO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RATEIO, lista2 = ArrayToList(v_nf_rateio_id));
				</cfscript>
                
                <cfloop list="#v_excluir#" delimiters="," index="id">
                	<cfscript>
						set_rateio = this.del_nf_terceiro_rateio(NF_RATEIO_ID = id
														          ,NUM_NOTA_ID = arguments.NUM_NOTA_ID
														          );
					</cfscript>
                    <cfif set_rateio.erro>
                    	<cfthrow object="#set_rateio.mensagem#">
                    </cfif>                    
                </cfloop>
                
                <cfloop from="1" to="#ArrayLen(v_percentual_rateio)#" index="count">
                	<cfif Len(Trim(v_nf_rateio_id[count]))>
						<cfscript>
                            set_rateio = this.upd_nf_terceiro_rateio(NUM_NOTA_ID = arguments.NUM_NOTA_ID
																	,NF_RATEIO_ID = v_nf_rateio_id[count]
                                                                    ,COD_PESSOA = v_cod_pessoa_rateio[count]
                                                                    ,COD_DEPARTAMENTO = v_cod_departamento_rateio[count]
                                                                    ,COD_SETOR = v_cod_setor_rateio[count]
                                                                    ,COD_CENTRO_CUSTO = v_cod_centro_custo_rateio[count]
                                                                    ,COD_CONTABIL = v_cod_contabil_rateio[count]
                                                                    ,PERC_RATEIO = v_percentual_rateio[count]
                                                                    ,VALOR_RATEIO = v_valor_rateio[count]);
                        </cfscript>
                    <cfelse>
						<cfscript>
                            set_rateio = this.ins_nf_terceiro_rateio(NUM_NOTA_ID = arguments.NUM_NOTA_ID
                                                                    ,COD_PESSOA = v_cod_pessoa_rateio[count]
                                                                    ,COD_DEPARTAMENTO = v_cod_departamento_rateio[count]
                                                                    ,COD_SETOR = v_cod_setor_rateio[count]
                                                                    ,COD_CENTRO_CUSTO = v_cod_centro_custo_rateio[count]
                                                                    ,COD_CONTABIL = v_cod_contabil_rateio[count]
                                                                    ,PERC_RATEIO = v_percentual_rateio[count]
                                                                    ,VALOR_RATEIO = v_valor_rateio[count]);
                        </cfscript>
                    </cfif>
                    <cfif set_rateio.erro>
                    	<cfthrow object="#set_rateio.mensagem#">
                    </cfif>
                </cfloop>
                
                <!---Contas a Pagar--->
                <cfscript>
					v_contas_pagar_id = this.ListaToArray(lista=arguments,variavel="CONTAS_PAGAR_ID_FATURAMENTO");
					v_fat_num_docto = this.ListaToArray(lista=arguments,variavel="FAT_NUM_DOCTO_FATURAMENTO");
					v_fat_data_vencto = this.ListaToArray(lista=arguments,variavel="FAT_DATA_VENCTO_FATURAMENTO");
					v_fat_valor_docto = this.ListaToArray(lista=arguments,variavel="FAT_VALOR_DOCTO_FATURAMENTO");
					v_fat_num_historico = this.ListaToArray(lista=arguments,variavel="FAT_NUM_HISTORICO_FATURAMENTO");
					v_fat_historico = this.ListaToArray(lista=arguments,variavel="FAT_HISTORICO_FATURAMENTO");
					v_fat_tipo_pagto = this.ListaToArray(lista=arguments,variavel="FAT_TIPO_PAGTO_FATURAMENTO");
					v_fat_docto_id = this.ListaToArray(lista=arguments,variavel="FAT_DOCTO_ID_FATURAMENTO");				
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_FATURAMENTO, lista2 = ArrayToList(v_contas_pagar_id));
				</cfscript>

                <cfloop list="#v_excluir#" delimiters="," index="id">
                	<cfscript>
						set_contas_pagar = this.del_nft_contas_pagar(CONTAS_PAGAR_ID = id);
					</cfscript>
                    <cfif set_contas_pagar.erro>
                    	<cfthrow object="#set_contas_pagar.mensagem#">
                    </cfif>                    
                </cfloop>
                
                <cfloop from="1" to="#ArrayLen(v_fat_num_docto)#" index="count">
                	<cfif Len(Trim(v_contas_pagar_id[count]))>
						<cfscript>
                            set_contas_pagar  = this.upd_nft_contas_pagar(NUM_NOTA_ID = arguments.NUM_NOTA_ID
                                                                         ,CONTAS_PAGAR_ID = v_contas_pagar_id[count]
                                                                         ,DOCTO_ID = v_fat_docto_id[count]
                                                                         ,NUM_DOCTO = v_fat_num_docto[count]
                                                                         ,PARC_DOCTO = 1
                                                                         ,COD_HISTORICO = v_fat_historico[count]
                                                                         ,BANCO_ID = ''
                                                                         ,AGENCIA_ID = ''
                                                                         ,CONTA = ''
                                                                         ,TIPO_PAGTO_ID = v_fat_tipo_pagto[count]
                                                                         ,DATA_EMISSAO = arguments.DATA_EMISSAO
                                                                         ,DATA_VENCTO = v_fat_data_vencto[count]
                                                                         ,VALOR_DOCTO = v_fat_valor_docto[count]
                                                                         ,CODIGO_BARRAS = '');					
                        </cfscript>
                    <cfelse>
						<cfscript>
                            set_contas_pagar  = this.ins_nft_contas_pagar(NUM_NOTA_ID = arguments.NUM_NOTA_ID
                                                                         ,CONTAS_PAGAR_ID = v_contas_pagar_id[count]
                                                                         ,DOCTO_ID = v_fat_docto_id[count]
                                                                         ,NUM_DOCTO = v_fat_num_docto[count]
                                                                         ,PARC_DOCTO = 1
                                                                         ,COD_HISTORICO = v_fat_historico[count]
                                                                         ,BANCO_ID = ''
                                                                         ,AGENCIA_ID = ''
                                                                         ,CONTA = ''
                                                                         ,TIPO_PAGTO_ID = v_fat_tipo_pagto[count]
                                                                         ,DATA_EMISSAO = arguments.DATA_EMISSAO
                                                                         ,DATA_VENCTO = v_fat_data_vencto[count]
                                                                         ,VALOR_DOCTO = v_fat_valor_docto[count]
                                                                         ,CODIGO_BARRAS = '');					
                        </cfscript>
                    </cfif>
                    <cfif set_contas_pagar.erro>
                    	<cfthrow object="#set_contas_pagar.mensagem#">
                    </cfif>                    
                </cfloop>
                                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Nota fiscal alterada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Excluir nota fiscal de terceiro
    -- guto 10/12/2008 15:48:06 - CRIADO
    --->
    <cffunction name='del_nf_terceiro' displayname='Excluir nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='MOTIVO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_del_nf_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MOTIVO'  value='#arguments.MOTIVO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Nota fiscal excluda com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere item da nota fiscal de terceiro
    -- guto 10/12/2008 15:44:19 - CRIADO
    --->
    <cffunction name='ins_nf_terceiro_it' displayname='Insere item da nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='CFOP' required='yes'>
        <cfargument name='CFOP_ID' required='yes'>
        <cfargument name='UF_UNIDADE_NEGOCIO' required='yes'>
        <cfargument name='UF_EMITENTE' required='yes'>
        <cfargument name='PRODUTO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='DESCRICAO_COMPLEMENTO' required='yes'>
        <cfargument name='COD_NCM' required='yes'>
        <cfargument name='ST_ORIGEM_ID' required='yes'>
        <cfargument name='ST_ICMS_ID' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='QTDE_PESO' required='yes'>
        <cfargument name='QTDE_VOLUME' required='yes'>
        <cfargument name='QTDE_METRO' required='yes'>
        <cfargument name='VALOR_EM' required='yes'>
        <cfargument name='VALOR_EM_UNIDADE' required='yes'>
        <cfargument name='VALOR_UNITARIO' required='yes'>
        <cfargument name='VALOR_TOTAL' required='yes'>
        <cfargument name='ICMS_REDUCAO_BASE' required='yes'>
        <cfargument name='ICMS_BASE_CALCULO' required='yes'>
        <cfargument name='ICMS_ALIQUOTA' required='yes'>
        <cfargument name='ICMS_VALOR' required='yes'>
        <cfargument name='ICMS_BASE_CALC_SUBST' required='yes'>
        <cfargument name='ICMS_VALOR_SUBST' required='yes'>
        <cfargument name='IPI_REDUCAO_BASE' required='yes'>
        <cfargument name='IPI_BASE_CALCULO' required='yes'>
        <cfargument name='IPI_ALIQUOTA' required='yes'>
        <cfargument name='IPI_VALOR' required='yes'>
        <cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
        <cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
        <cfargument name='SERV_TOTAL_PRODUTO' required='yes'>
        <cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
        <cfargument name='SERV_ISS_DEDUCAO' required='yes'>
        <cfargument name='SERV_ISS_VALOR' required='yes'>
        <cfargument name='DESCONTO_PERCENTUAL' required='yes'>
        <cfargument name='DESCONTO_VALOR' required='yes'>
        <cfargument name='INCLUIR_ESTOQUE' required='yes'>
        <cfargument name='INCLUIR_LIVRO_FISCAL' required='yes'>
        <cfargument name='INCLUIR_SINTEGRA' required='yes'>
        <cftry>
            <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ins_nf_terceiro_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_IT_ID' variable='retorno.NUM_NOTA_IT_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_UNIDADE_NEGOCIO'  value='#arguments.UF_UNIDADE_NEGOCIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_EMITENTE'  value='#arguments.UF_EMITENTE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_COMPLEMENTO'  value='#arguments.DESCRICAO_COMPLEMENTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_NCM'  value='#arguments.COD_NCM#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='#arguments.ST_ORIGEM_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_PESO'  value='#arguments.QTDE_PESO#'  null='#iif(len(trim(arguments.QTDE_PESO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_METRO'  value='#arguments.QTDE_METRO#'  null='#iif(len(trim(arguments.QTDE_METRO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_EM'  value='#arguments.VALOR_EM#'  null='#iif(len(trim(arguments.VALOR_EM)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR_EM_UNIDADE'  value='#arguments.VALOR_EM_UNIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_REDUCAO_BASE'  value='#arguments.ICMS_REDUCAO_BASE#'  null='#iif(len(trim(arguments.ICMS_REDUCAO_BASE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_BASE_CALCULO'  value='#arguments.ICMS_BASE_CALCULO#'  null='#iif(len(trim(arguments.ICMS_BASE_CALCULO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_ALIQUOTA'  value='#arguments.ICMS_ALIQUOTA#'  null='#iif(len(trim(arguments.ICMS_ALIQUOTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_VALOR'  value='#arguments.ICMS_VALOR#'  null='#iif(len(trim(arguments.ICMS_VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_BASE_CALC_SUBST'  value='#arguments.ICMS_BASE_CALC_SUBST#'  null='#iif(len(trim(arguments.ICMS_BASE_CALC_SUBST)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_VALOR_SUBST'  value='#arguments.ICMS_VALOR_SUBST#'  null='#iif(len(trim(arguments.ICMS_VALOR_SUBST)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_REDUCAO_BASE'  value='#arguments.IPI_REDUCAO_BASE#'  null='#iif(len(trim(arguments.IPI_REDUCAO_BASE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_BASE_CALCULO'  value='#arguments.IPI_BASE_CALCULO#'  null='#iif(len(trim(arguments.IPI_BASE_CALCULO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_ALIQUOTA'  value='#arguments.IPI_ALIQUOTA#'  null='#iif(len(trim(arguments.IPI_ALIQUOTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_VALOR'  value='#arguments.IPI_VALOR#'  null='#iif(len(trim(arguments.IPI_VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_PRODUTO'  value='#arguments.SERV_TOTAL_PRODUTO#'  null='#iif(len(trim(arguments.SERV_TOTAL_PRODUTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO_PERCENTUAL'  value='#arguments.DESCONTO_PERCENTUAL#'  null='#iif(len(trim(arguments.DESCONTO_PERCENTUAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO_VALOR'  value='#arguments.DESCONTO_VALOR#'  null='#iif(len(trim(arguments.DESCONTO_VALOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_ESTOQUE'  value='#arguments.INCLUIR_ESTOQUE#'  null='#iif(len(trim(arguments.INCLUIR_ESTOQUE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_LIVRO_FISCAL'  value='#arguments.INCLUIR_LIVRO_FISCAL#'  null='#iif(len(trim(arguments.INCLUIR_LIVRO_FISCAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_SINTEGRA'  value='#arguments.INCLUIR_SINTEGRA#'  null='#iif(len(trim(arguments.INCLUIR_SINTEGRA)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Ok')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Alterar item da nota fiscal de terceiro
    -- guto 10/12/2008 15:53:12 - CRIADO
    --->
    <cffunction name='upd_nf_terceiro_it' displayname='Alterar item da nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='NUM_NOTA_IT_ID' required='yes'>
        <cfargument name='CFOP' required='yes'>
        <cfargument name='CFOP_ID' required='yes'>
        <cfargument name='PRODUTO_ID' required='yes'>
        <cfargument name='UF_UNIDADE_NEGOCIO' required='yes'>
        <cfargument name='UF_EMITENTE' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='DESCRICAO_COMPLEMENTO' required='yes'>
        <cfargument name='COD_NCM' required='yes'>
        <cfargument name='ST_ORIGEM_ID' required='yes'>
        <cfargument name='ST_ICMS_ID' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='QTDE_PESO' required='yes'>
        <cfargument name='QTDE_VOLUME' required='yes'>
        <cfargument name='QTDE_METRO' required='yes'>
        <cfargument name='VALOR_EM' required='yes'>
        <cfargument name='VALOR_EM_UNIDADE' required='yes'>
        <cfargument name='VALOR_UNITARIO' required='yes'>
        <cfargument name='VALOR_TOTAL' required='yes'>
        <cfargument name='ICMS_REDUCAO_BASE' required='yes'>
        <cfargument name='ICMS_BASE_CALCULO' required='yes'>
        <cfargument name='ICMS_ALIQUOTA' required='yes'>
        <cfargument name='ICMS_VALOR' required='yes'>
        <cfargument name='ICMS_BASE_CALC_SUBST' required='yes'>
        <cfargument name='ICMS_VALOR_SUBST' required='yes'>
        <cfargument name='IPI_REDUCAO_BASE' required='yes'>
        <cfargument name='IPI_BASE_CALCULO' required='yes'>
        <cfargument name='IPI_ALIQUOTA' required='yes'>
        <cfargument name='IPI_VALOR' required='yes'>
        <cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
        <cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
        <cfargument name='SERV_TOTAL_PRODUTO' required='yes'>
        <cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
        <cfargument name='SERV_ISS_DEDUCAO' required='yes'>
        <cfargument name='SERV_ISS_VALOR' required='yes'>
        <cfargument name='DESCONTO_PERCENTUAL' required='yes'>
        <cfargument name='DESCONTO_VALOR' required='yes'>
        <cfargument name='INCLUIR_ESTOQUE' required='yes'>
        <cfargument name='INCLUIR_LIVRO_FISCAL' required='yes'>
        <cfargument name='INCLUIR_SINTEGRA' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_alt_nf_terceiro_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_IT_ID'  value='#arguments.NUM_NOTA_IT_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_IT_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_UNIDADE_NEGOCIO'  value='#arguments.UF_UNIDADE_NEGOCIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_UF_EMITENTE'  value='#arguments.UF_EMITENTE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO_COMPLEMENTO'  value='#arguments.DESCRICAO_COMPLEMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_NCM'  value='#arguments.COD_NCM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='#arguments.ST_ORIGEM_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_PESO'  value='#arguments.QTDE_PESO#'  null='#iif(len(trim(arguments.QTDE_PESO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_VOLUME'  value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_QTDE_METRO'  value='#arguments.QTDE_METRO#'  null='#iif(len(trim(arguments.QTDE_METRO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_EM'  value='#arguments.VALOR_EM#'  null='#iif(len(trim(arguments.VALOR_EM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR_EM_UNIDADE'  value='#arguments.VALOR_EM_UNIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_UNITARIO'  value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_TOTAL'  value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_REDUCAO_BASE'  value='#arguments.ICMS_REDUCAO_BASE#'  null='#iif(len(trim(arguments.ICMS_REDUCAO_BASE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_BASE_CALCULO'  value='#arguments.ICMS_BASE_CALCULO#'  null='#iif(len(trim(arguments.ICMS_BASE_CALCULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_ALIQUOTA'  value='#arguments.ICMS_ALIQUOTA#'  null='#iif(len(trim(arguments.ICMS_ALIQUOTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_VALOR'  value='#arguments.ICMS_VALOR#'  null='#iif(len(trim(arguments.ICMS_VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_BASE_CALC_SUBST'  value='#arguments.ICMS_BASE_CALC_SUBST#'  null='#iif(len(trim(arguments.ICMS_BASE_CALC_SUBST)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ICMS_VALOR_SUBST'  value='#arguments.ICMS_VALOR_SUBST#'  null='#iif(len(trim(arguments.ICMS_VALOR_SUBST)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_REDUCAO_BASE'  value='#arguments.IPI_REDUCAO_BASE#'  null='#iif(len(trim(arguments.IPI_REDUCAO_BASE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_BASE_CALCULO'  value='#arguments.IPI_BASE_CALCULO#'  null='#iif(len(trim(arguments.IPI_BASE_CALCULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_ALIQUOTA'  value='#arguments.IPI_ALIQUOTA#'  null='#iif(len(trim(arguments.IPI_ALIQUOTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IPI_VALOR'  value='#arguments.IPI_VALOR#'  null='#iif(len(trim(arguments.IPI_VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_TOTAL_PRODUTO'  value='#arguments.SERV_TOTAL_PRODUTO#'  null='#iif(len(trim(arguments.SERV_TOTAL_PRODUTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO_PERCENTUAL'  value='#arguments.DESCONTO_PERCENTUAL#'  null='#iif(len(trim(arguments.DESCONTO_PERCENTUAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO_VALOR'  value='#arguments.DESCONTO_VALOR#'  null='#iif(len(trim(arguments.DESCONTO_VALOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_ESTOQUE'  value='#arguments.INCLUIR_ESTOQUE#'  null='#iif(len(trim(arguments.INCLUIR_ESTOQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_LIVRO_FISCAL'  value='#arguments.INCLUIR_LIVRO_FISCAL#'  null='#iif(len(trim(arguments.INCLUIR_LIVRO_FISCAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_INCLUIR_SINTEGRA'  value='#arguments.INCLUIR_SINTEGRA#'  null='#iif(len(trim(arguments.INCLUIR_SINTEGRA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Excluir item da nota fiscal de terceiro
    -- guto 10/12/2008 15:53:47 - CRIADO
    --->
    <cffunction name='del_nf_terceiro_it' displayname='Excluir item da nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='NUM_NOTA_IT_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_del_nf_terceiro_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_IT_ID'  value='#arguments.NUM_NOTA_IT_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_IT_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere imposto na nota fiscal de terceiro
    -- guto 10/12/2008 15:54:54 - CRIADO
    --->
    <cffunction name='ins_nf_terceiro_imposto' displayname='Insere imposto na nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='IMPOSTO_ID' required='yes'>
        <cfargument name='IMPOSTO_REDUCAO_BASE' required='yes'>
        <cfargument name='IMPOSTO_BASE_CALCULO' required='yes'>
        <cfargument name='IMPOSTO_ALIQUOTA' required='yes'>
        <cfargument name='IMPOSTO_TOTAL' required='yes'>
        <cfargument name='DATA_VENCIMENTO' required='yes'>
        <cfargument name='IMPOSTO_RETIDO_FONTE' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ins_nf_terceiro_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_ID'  value='#arguments.IMPOSTO_ID#'  null='#iif(len(trim(arguments.IMPOSTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_IMPOSTO_REDUCAO_BASE'  value='#arguments.IMPOSTO_REDUCAO_BASE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_BASE_CALCULO'  value='#arguments.IMPOSTO_BASE_CALCULO#'  null='#iif(len(trim(arguments.IMPOSTO_BASE_CALCULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_ALIQUOTA'  value='#arguments.IMPOSTO_ALIQUOTA#'  null='#iif(len(trim(arguments.IMPOSTO_ALIQUOTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_TOTAL'  value='#arguments.IMPOSTO_TOTAL#'  null='#iif(len(trim(arguments.IMPOSTO_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCIMENTO'  value='#arguments.DATA_VENCIMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_RETIDO_FONTE'  value='#arguments.IMPOSTO_RETIDO_FONTE#'  null='#iif(len(trim(arguments.IMPOSTO_RETIDO_FONTE)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera imposto na nota fiscal de terceiro
    -- guto 10/12/2008 15:55:29 - CRIADO
    --->
    <cffunction name='upd_nf_terceiro_imposto' displayname='Altera imposto na nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='NF_IMPOSTO_ID' required='yes'>
        <cfargument name='IMPOSTO_ID' required='yes'>
        <cfargument name='IMPOSTO_REDUCAO_BASE' required='yes'>
        <cfargument name='IMPOSTO_BASE_CALCULO' required='yes'>
        <cfargument name='IMPOSTO_ALIQUOTA' required='yes'>
        <cfargument name='IMPOSTO_TOTAL' required='yes'>
        <cfargument name='DATA_VENCIMENTO' required='yes'>
        <cfargument name='IMPOSTO_RETIDO_FONTE' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_alt_nf_terceiro_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_ID'  value='#arguments.IMPOSTO_ID#'  null='#iif(len(trim(arguments.IMPOSTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_REDUCAO_BASE'  value='#arguments.IMPOSTO_REDUCAO_BASE#'  null='#iif(len(trim(arguments.IMPOSTO_REDUCAO_BASE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_BASE_CALCULO'  value='#arguments.IMPOSTO_BASE_CALCULO#'  null='#iif(len(trim(arguments.IMPOSTO_BASE_CALCULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_ALIQUOTA'  value='#arguments.IMPOSTO_ALIQUOTA#'  null='#iif(len(trim(arguments.IMPOSTO_ALIQUOTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_TOTAL'  value='#arguments.IMPOSTO_TOTAL#'  null='#iif(len(trim(arguments.IMPOSTO_TOTAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCIMENTO'  value='#arguments.DATA_VENCIMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTO_RETIDO_FONTE'  value='#arguments.IMPOSTO_RETIDO_FONTE#'  null='#iif(len(trim(arguments.IMPOSTO_RETIDO_FONTE)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui imposto na nota fiscal de terceiro
    -- guto 10/12/2008 15:55:55 - CRIADO
    --->
    <cffunction name='del_nf_terceiro_imposto' displayname='Exclui imposto na nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='NF_IMPOSTO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_del_nf_terceiro_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere rateio na nota fiscal de terceiro
    -- guto 10/12/2008 15:56:53 - CRIADO
    --->
    <cffunction name='ins_nf_terceiro_rateio' displayname='Insere rateio na nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='COD_DEPARTAMENTO' required='yes'>
        <cfargument name='COD_SETOR' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='COD_CONTABIL' required='yes'>
        <cfargument name='PERC_RATEIO' required='yes'>
        <cfargument name='VALOR_RATEIO' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ins_nf_terceiro_rateio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_RATEIO_ID' variable='retorno.NF_RATEIO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONTABIL'  value='#arguments.COD_CONTABIL#'  null='#iif(len(trim(arguments.COD_CONTABIL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERC_RATEIO'  value='#arguments.PERC_RATEIO#'  null='#iif(len(trim(arguments.PERC_RATEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_RATEIO'  value='#arguments.VALOR_RATEIO#'  null='#iif(len(trim(arguments.VALOR_RATEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera rateio na nota fiscal de terceiro
    -- guto 10/12/2008 15:57:24 - CRIADO
    --->
    <cffunction name='upd_nf_terceiro_rateio' displayname='Altera rateio na nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NF_RATEIO_ID' required='yes'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cfargument name='COD_DEPARTAMENTO' required='yes'>
        <cfargument name='COD_SETOR' required='yes'>
        <cfargument name='COD_CENTRO_CUSTO' required='yes'>
        <cfargument name='COD_CONTABIL' required='yes'>
        <cfargument name='PERC_RATEIO' required='yes'>
        <cfargument name='VALOR_RATEIO' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_alt_nf_terceiro_rateio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_RATEIO_ID'  value='#arguments.NF_RATEIO_ID#'  null='#iif(len(trim(arguments.NF_RATEIO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA'  value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONTABIL'  value='#arguments.COD_CONTABIL#'  null='#iif(len(trim(arguments.COD_CONTABIL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PERC_RATEIO'  value='#arguments.PERC_RATEIO#'  null='#iif(len(trim(arguments.PERC_RATEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_RATEIO'  value='#arguments.VALOR_RATEIO#'  null='#iif(len(trim(arguments.VALOR_RATEIO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui rateio na nota fiscal de terceiro
    -- guto 10/12/2008 15:57:56 - CRIADO
    --->
    <cffunction name='del_nf_terceiro_rateio' displayname='Exclui rateio na nota fiscal de terceiro' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='NF_RATEIO_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_del_nf_terceiro_rateio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NF_RATEIO_ID'  value='#arguments.NF_RATEIO_ID#'  null='#iif(len(trim(arguments.NF_RATEIO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Insere contas a pagar da NFT
    -- guto 10/12/2008 15:58:53 - CRIADO
    --->
    <cffunction name='ins_nft_contas_pagar' displayname='Insere contas a pagar da NFT' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='CONTAS_PAGAR_ID' required='yes'>
        <cfargument name='DOCTO_ID' required='yes'>
        <cfargument name='NUM_DOCTO' required='yes'>
        <cfargument name='PARC_DOCTO' required='yes'>
        <cfargument name='COD_HISTORICO' required='yes'>
        <cfargument name='BANCO_ID' required='yes'>
        <cfargument name='AGENCIA_ID' required='yes'>
        <cfargument name='CONTA' required='yes'>
        <cfargument name='TIPO_PAGTO_ID' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='DATA_VENCTO' required='yes'>
        <cfargument name='VALOR_DOCTO' required='yes'>
        <cfargument name='CODIGO_BARRAS' required='yes'>
        <cfargument name='COMENTARIO' required='no' default=''>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_ins_nft_contas_pagar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTAS_PAGAR_ID'  value='#arguments.CONTAS_PAGAR_ID#' variable='retorno.CONTAS_PAGAR_ID'  null='#iif(len(trim(arguments.CONTAS_PAGAR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_ID'  value='#arguments.DOCTO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PARC_DOCTO'  value='#arguments.PARC_DOCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO#'  null='#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BANCO_ID'  value='#arguments.BANCO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AGENCIA_ID'  value='#arguments.AGENCIA_ID#'  null='#iif(len(trim(arguments.AGENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTA'  value='#arguments.CONTA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_DOCTO'  value='#arguments.VALOR_DOCTO#'  null='#iif(len(trim(arguments.VALOR_DOCTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CODIGO_BARRAS'  value='#arguments.CODIGO_BARRAS#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Altera contas a pagar da NFT
    -- guto 10/12/2008 15:59:26 - CRIADO
    --->
    <cffunction name='upd_nft_contas_pagar' displayname='Altera contas a pagar da NFT' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='CONTAS_PAGAR_ID' required='yes'>
        <cfargument name='DOCTO_ID' required='yes'>
        <cfargument name='NUM_DOCTO' required='yes'>
        <cfargument name='PARC_DOCTO' required='yes'>
        <cfargument name='COD_HISTORICO' required='yes'>
        <cfargument name='BANCO_ID' required='yes'>
        <cfargument name='AGENCIA_ID' required='yes'>
        <cfargument name='CONTA' required='yes'>
        <cfargument name='TIPO_PAGTO_ID' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='DATA_VENCTO' required='yes'>
        <cfargument name='VALOR_DOCTO' required='yes'>
        <cfargument name='COMENTARIO' required='no' default=''>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_alt_nft_contas_pagar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTAS_PAGAR_ID'  value='#arguments.CONTAS_PAGAR_ID#'  null='#iif(len(trim(arguments.CONTAS_PAGAR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DOCTO_ID'  value='#arguments.DOCTO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NUM_DOCTO'  value='#arguments.NUM_DOCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PARC_DOCTO'  value='#arguments.PARC_DOCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_HISTORICO'  value='#arguments.COD_HISTORICO#'  null='#iif(len(trim(arguments.COD_HISTORICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_BANCO_ID'  value='#arguments.BANCO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_AGENCIA_ID'  value='#arguments.AGENCIA_ID#'  null='#iif(len(trim(arguments.AGENCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONTA'  value='#arguments.CONTA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_PAGTO_ID'  value='#arguments.TIPO_PAGTO_ID#'  null='#iif(len(trim(arguments.TIPO_PAGTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_VENCTO'  value='#arguments.DATA_VENCTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_DOCTO'  value='#arguments.VALOR_DOCTO#'  null='#iif(len(trim(arguments.VALOR_DOCTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMENTARIO'  value='#arguments.COMENTARIO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Exclui contas a pagar da NFT
    -- guto 10/12/2008 16:00:03 - CRIADO
    --->
    <cffunction name='del_nft_contas_pagar' displayname='Exclui contas a pagar da NFT' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTAS_PAGAR_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='fiscal.pkg_nf_terceiro.prc_del_nft_contas_pagar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONTAS_PAGAR_ID'  value='#arguments.CONTAS_PAGAR_ID#'  null='#iif(len(trim(arguments.CONTAS_PAGAR_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Insere dados da tabela de frete vinculada ao conhecimento
    -- guto 16/10/2008 15:52:27 - CRIADO
    --->
    <cffunction name='ins_conhecimento_tf' displayname='Insere dados da tabela de frete vinculada ao conhecimento' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='COD_TABELA_FRETE' required='yes'>
        <cfargument name='LOTACAO' required='yes'>
        <cfargument name='URGENTE' required='yes'>
        <cfargument name='TRUCK' required='yes'>
        <cfargument name='COLETA' required='yes'>
        <cfargument name='NUM_AJUDANTES' required='yes'>
        <cfargument name='NUM_ENTREGAS' required='yes'>
        <cfargument name='MUNICIPIO_ULT_ENTREGA' required='yes'>
        <cftry>
            <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ins_ctrc_contrato_tf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_TABELA_FRETE'  value='#arguments.COD_TABELA_FRETE#'  null='#iif(len(trim(arguments.COD_TABELA_FRETE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_LOTACAO'  value='#arguments.LOTACAO#'  null='#iif(len(trim(arguments.LOTACAO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_URGENTE'  value='#arguments.URGENTE#'  null='#iif(len(trim(arguments.URGENTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TRUCK'  value='#arguments.TRUCK#'  null='#iif(len(trim(arguments.TRUCK)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA'  value='#arguments.COLETA#'  null='#iif(len(trim(arguments.COLETA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_AJUDANTES'  value='#arguments.NUM_AJUDANTES#'  null='#iif(len(trim(arguments.NUM_AJUDANTES)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ENTREGAS'  value='#arguments.NUM_ENTREGAS#'  null='#iif(len(trim(arguments.NUM_ENTREGAS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_MUNICIPIO_ULT_ENTREGA'  value='#arguments.MUNICIPIO_ULT_ENTREGA#'  null='#iif(len(trim(arguments.MUNICIPIO_ULT_ENTREGA)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Ok')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    
    <!--- 
	-- PROPSITO
	-- Fazer as validaes necessrias para a Emisso de Uma NF Frete
	-- RAFAEL 02/12/2009 11:02:30 - CRIADO
	--->
	<cffunction name='valida_nf_frete' displayname='Fazer as validaes necessrias para a Emisso de Uma NF Frete' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_valida_nf_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere NFSE
	-- RAFAEL 29/10/2010 15:47:22 - CRIADO
	--->
		<cffunction name='ins_nfse' displayname='Insere NFSE' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='COD_MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUBSERIE' required='yes'>
		<cfargument name='E_S' required='yes'>
		<cfargument name='SERVICO' required='yes'>
		<cfargument name='INSCRICAO_ESTADUAL_SUBSTITUT' required='no' default="">
		<cfargument name='NATUREZA_ID' required='yes'>
		<cfargument name='NATUREZA_DESCRICAO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='DATA_ES' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='DEST_RAZAO_SOCIAL' required='yes'>
		<cfargument name='DEST_ENDERECO' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO' required='yes'>
		<cfargument name='DEST_UF' required='yes'>
		<cfargument name='DEST_CEP' required='yes'>
		<cfargument name='DEST_TELEFONE' required='yes'>
		<cfargument name='DEST_CNPJ_CPF' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='NF_IMPOSTO_ID' required='no' default="">
		<cfargument name='SERV_TOTAL_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NAO_TRIBUTAVEL' required='yes'>
		<cfargument name='SERV_TOTAL_NOTA' required='yes'>
		<cfargument name='SERV_ISS_ALIQUOTA' required='yes'>
		<cfargument name='SERV_ISS_DEDUCAO' required='yes'>
		<cfargument name='SERV_ISS_VALOR' required='yes'>
		<cfargument name='CALC_BASE_ICMS' required='no' default="0">
		<cfargument name='CALC_VALOR_ICMS' required='no' default="0">
		<cfargument name='CALC_BASE_ICMS_SUBST' required='no' default="0">
		<cfargument name='CALC_VALOR_ICMS_SUBST' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_PRODUTOS' required='no' default="0">
		<cfargument name='CALC_VALOR_FRETE' required='no' default="0">
		<cfargument name='CALC_VALOR_SEGURO' required='no' default="0">
		<cfargument name='CALC_OUTRAS_DESPESAS' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_IPI' required='no' default="0">
		<cfargument name='CALC_VALOR_TOTAL_NOTA' required='yes'>
		<cfargument name='COD_TRANSPORTADOR' required='no' default="">
		<cfargument name='TRP_RAZAO_SOCIAL' required='no' default="">
		<cfargument name='TRP_ENDERECO' required='no' default="">
		<cfargument name='TRP_MUNICIPIO' required='no' default="">
		<cfargument name='TRP_UF' required='no' default="">
		<cfargument name='TRP_CNPJ_CPF' required='no' default="">
		<cfargument name='TRP_INSCRICAO_ESTADUAL' required='no' default="">
		<cfargument name='TRP_PLACA' required='no' default="">
		<cfargument name='TRP_PLACA_UF' required='no' default="1">
		<cfargument name='TRP_FRETE_POR' required='no' default="1">
		<cfargument name='TRP_QUANTIDADE' required='no' default="">
		<cfargument name='TRP_ESPECIE' required='no' default="">
		<cfargument name='TRP_MARCA' required='no' default="">
		<cfargument name='TRP_NUMERO' required='no' default="">
		<cfargument name='TRP_PESO_BRUTO' required='no' default="0">
		<cfargument name='TRP_PESO_LIQUIDO' required='no' default="0">
		<cfargument name='INFO_COMPLEMENTARES' required='yes'>
		<cfargument name='RESERVADO_FISCO' required='no' default="Este campo destina-se a preencher o campo Reservado ao Fisco da nota fiscal de E/S, quando da insero da mesma.">
		<cfargument name='OBSERVACAO_FISCAL' required='no' default="">
		<cfargument name='OBSERVACAO_USUARIO' required='no' default="">
		<cfargument name='EMITIDA' required='no' default="0">
		<cfargument name='CANCELADA' required='no' default="0">
		<cfargument name='CONFERIDA' required='no' default="0">
		<cfargument name='CONVERSAO_TAXA' required='no' default="">
		<cfargument name='CONVERSAO_MOEDA' required='no' default="220">
		<cfargument name='INCLUIR_SISS' required='yes'>
		<cfargument name='TIPO_RECOLHIMENTO_ISS' required='yes'>
		<cfargument name='COD_SERVICO_DES' required='no' default="">
		<cfargument name='NATUREZA_SISS_ID' required='no' default="">
		<cfargument name='AVISTA_APRAZO' required='yes'>
		<cfargument name='NATUREZA_OPERACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_nf_es.prc_ins_nf_es' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#' variable='retorno.NUM_NOTA_ID'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_MODELO'  value='#arguments.COD_MODELO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SUBSERIE'  value='#arguments.SUBSERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_E_S'  value='#arguments.E_S#'  null='#iif(len(trim(arguments.E_S)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERVICO'  value='#arguments.SERVICO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INSCRICAO_ESTADUAL_SUBSTITUT'  value='#arguments.INSCRICAO_ESTADUAL_SUBSTITUT#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NATUREZA_ID'  value='#arguments.NATUREZA_ID#'  null='#iif(len(trim(arguments.NATUREZA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_DESCRICAO'  value='#arguments.NATUREZA_DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_ES'  value='#arguments.DATA_ES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_TELEFONE'  value='#arguments.DEST_TELEFONE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_IMPOSTO_ID'  value='#arguments.NF_IMPOSTO_ID#'  null='#iif(len(trim(arguments.NF_IMPOSTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_NAO_TRIBUTAVEL'  value='#arguments.SERV_TOTAL_NAO_TRIBUTAVEL#'  null='#iif(len(trim(arguments.SERV_TOTAL_NAO_TRIBUTAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_TOTAL_NOTA'  value='#arguments.SERV_TOTAL_NOTA#'  null='#iif(len(trim(arguments.SERV_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_ALIQUOTA'  value='#arguments.SERV_ISS_ALIQUOTA#'  null='#iif(len(trim(arguments.SERV_ISS_ALIQUOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_DEDUCAO'  value='#arguments.SERV_ISS_DEDUCAO#'  null='#iif(len(trim(arguments.SERV_ISS_DEDUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERV_ISS_VALOR'  value='#arguments.SERV_ISS_VALOR#'  null='#iif(len(trim(arguments.SERV_ISS_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_BASE_ICMS'  value='#arguments.CALC_BASE_ICMS#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_ICMS'  value='#arguments.CALC_VALOR_ICMS#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_BASE_ICMS_SUBST'  value='#arguments.CALC_BASE_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_BASE_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_ICMS_SUBST'  value='#arguments.CALC_VALOR_ICMS_SUBST#'  null='#iif(len(trim(arguments.CALC_VALOR_ICMS_SUBST)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_PRODUTOS'  value='#arguments.CALC_VALOR_TOTAL_PRODUTOS#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_PRODUTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_FRETE'  value='#arguments.CALC_VALOR_FRETE#'  null='#iif(len(trim(arguments.CALC_VALOR_FRETE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_SEGURO'  value='#arguments.CALC_VALOR_SEGURO#'  null='#iif(len(trim(arguments.CALC_VALOR_SEGURO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_OUTRAS_DESPESAS'  value='#arguments.CALC_OUTRAS_DESPESAS#'  null='#iif(len(trim(arguments.CALC_OUTRAS_DESPESAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_IPI'  value='#arguments.CALC_VALOR_TOTAL_IPI#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_IPI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CALC_VALOR_TOTAL_NOTA'  value='#arguments.CALC_VALOR_TOTAL_NOTA#'  null='#iif(len(trim(arguments.CALC_VALOR_TOTAL_NOTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_TRANSPORTADOR'  value='#arguments.COD_TRANSPORTADOR#'  null='#iif(len(trim(arguments.COD_TRANSPORTADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_RAZAO_SOCIAL'  value='#arguments.TRP_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ENDERECO'  value='#arguments.TRP_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MUNICIPIO'  value='#arguments.TRP_MUNICIPIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_UF'  value='#arguments.TRP_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_CNPJ_CPF'  value='#arguments.TRP_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_INSCRICAO_ESTADUAL'  value='#arguments.TRP_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA'  value='#arguments.TRP_PLACA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_PLACA_UF'  value='#arguments.TRP_PLACA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_FRETE_POR'  value='#arguments.TRP_FRETE_POR#'  null='#iif(len(trim(arguments.TRP_FRETE_POR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_QUANTIDADE'  value='#arguments.TRP_QUANTIDADE#'  null='#iif(len(trim(arguments.TRP_QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_ESPECIE'  value='#arguments.TRP_ESPECIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_MARCA'  value='#arguments.TRP_MARCA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TRP_NUMERO'  value='#arguments.TRP_NUMERO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_PESO_BRUTO'  value='#arguments.TRP_PESO_BRUTO#'  null='#iif(len(trim(arguments.TRP_PESO_BRUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TRP_PESO_LIQUIDO'  value='#arguments.TRP_PESO_LIQUIDO#'  null='#iif(len(trim(arguments.TRP_PESO_LIQUIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_INFO_COMPLEMENTARES'  value='#arguments.INFO_COMPLEMENTARES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RESERVADO_FISCO'  value='#arguments.RESERVADO_FISCO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_FISCAL'  value='#arguments.OBSERVACAO_FISCAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO_USUARIO'  value='#arguments.OBSERVACAO_USUARIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_EMITIDA'  value='#arguments.EMITIDA#'  null='#iif(len(trim(arguments.EMITIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CANCELADA'  value='#arguments.CANCELADA#'  null='#iif(len(trim(arguments.CANCELADA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONFERIDA'  value='#arguments.CONFERIDA#'  null='#iif(len(trim(arguments.CONFERIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONVERSAO_TAXA'  value='#arguments.CONVERSAO_TAXA#'  null='#iif(len(trim(arguments.CONVERSAO_TAXA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONVERSAO_MOEDA'  value='#arguments.CONVERSAO_MOEDA#'  null='#iif(len(trim(arguments.CONVERSAO_MOEDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_INCLUIR_SISS'  value='#arguments.INCLUIR_SISS#'  null='#iif(len(trim(arguments.INCLUIR_SISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_TIPO_RECOLHIMENTO_ISS'  value='#arguments.TIPO_RECOLHIMENTO_ISS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_SERVICO_DES'  value='#arguments.COD_SERVICO_DES#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_SISS_ID'  value='#arguments.NATUREZA_SISS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_AVISTA_APRAZO'  value='#arguments.AVISTA_APRAZO#'  null='#iif(len(trim(arguments.AVISTA_APRAZO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ROWID' variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#'  null='#iif(len(trim(arguments.NATUREZA_OPERACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORGANIZACIONAL_ID'  value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANIZACIONAL'  value='#arguments.COD_ORGANIZACIONAL#' >
				</cfstoredproc>
					<!---Insere Itens--->
					<cfscript>
						arguments.num_nota_id = retorno.num_nota_id;
						V_ES = this.ListaToArray(lista = arguments, variavel = "ES_SERVICOS");
						V_NUM_NOTA_IT_ID = this.ListaToArray(lista = arguments, variavel = "NUM_NOTA_IT_ID_SERVICOS");
						V_CFOP = this.ListaToArray(lista = arguments, variavel = "CFOP_SERVICOS");
						V_CFOP_ID = this.ListaToArray(lista = arguments, variavel = "CFOP_ID_SERVICOS");
						V_PRODUTO_ID = this.ListaToArray(lista = arguments, variavel = "PRODUTO_ID_SERVICOS");
						V_DESCRICAO = this.ListaToArray(lista = arguments, variavel = "DESCRICAO_SERVICOS");
						V_DESCRICAO_COMPLEMENTO = this.ListaToArray(lista = arguments, variavel = "DESCRICAO_COMPLEMENTO_SERVICOS");
						V_COD_NCM = this.ListaToArray(lista = arguments, variavel = "COD_NCM_SERVICOS");
						V_ST_ORIGEM_ID = this.ListaToArray(lista = arguments, variavel = "ST_ORIGEM_ID_SERVICOS");
						V_ST_ICMS_ID = this.ListaToArray(lista = arguments, variavel = "ST_ICMS_ID_SERVICOS");
						V_COD_UNIDADE = this.ListaToArray(lista = arguments, variavel = "COD_UNIDADE_SERVICOS");
						V_QTDE_PESO = this.ListaToArray(lista = arguments, variavel = "QTDE_PESO_SERVICOS");
						V_QTDE_VOLUME = this.ListaToArray(lista = arguments, variavel = "QTDE_VOLUME_SERVICOS");
						V_QTDE_METRO = this.ListaToArray(lista = arguments, variavel = "QTDE_METRO_SERVICOS");
						V_VALOR_EM = this.ListaToArray(lista = arguments, variavel = "VALOR_EM_SERVICOS");
						V_VALOR_EM_UNIDADE = this.ListaToArray(lista = arguments, variavel = "VALOR_EM_UNIDADE_SERVICOS");
						V_VALOR_UNITARIO = this.ListaToArray(lista = arguments, variavel = "VALOR_UNITARIO_SERVICOS");
						V_VALOR_TOTAL = this.ListaToArray(lista = arguments, variavel = "VALOR_TOTAL_SERVICOS");
						V_SERV_TOTAL_TRIBUTAVEL = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_TRIBUTAVEL_SERVICOS");
						V_SERV_TOTAL_NAO_TRIBUTAVEL = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_NAO_TRIBUTAVEL_SERVICOS");
						V_SERV_TOTAL_PRODUTO = this.ListaToArray(lista = arguments, variavel = "SERVICO_TOTAL_PRODUTO_SERVICOS");
						V_SERV_ISS_ALIQUOTA = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_ALIQUOTA_SERVICOS");
						V_SERV_ISS_DEDUCAO = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_DEDUCAO_SERVICOS");
						V_SERV_ISS_VALOR = this.ListaToArray(lista = arguments, variavel = "SERVICO_ISS_VALOR_SERVICOS");
						V_INCLUIR_LIVRO_FISCAL = this.ListaToArray(lista = arguments, variavel = "INCLUIR_LIVRO_FISCAL_SERVICOS");
						V_INCLUIR_SINTEGRA = this.ListaToArray(lista = arguments, variavel = "INCLUIR_SINTEGRA_SERVICOS");
						V_UF_UNIDADE_NEGOCIO = this.ListaToArray(lista = arguments, variavel = "UF_UNIDADE_NEGOCIO_SERVICOS");
						V_UF_DESTINATARIO = this.ListaToArray(lista = arguments, variavel = "UF_DESTINATARIO_SERVICOS");
					</cfscript>			
					<cfloop from="1" to="#ArrayLen(V_ES)#" index="count">
						<cfscript>
							this.ins_nota_fiscal_es_it( es = v_es[count],
														num_nota_id = retorno.NUM_NOTA_ID,
														cfop = v_cfop[count],
														cfop_id = v_cfop_id[count],
														produto_id = v_produto_id[count],
														descricao = v_descricao[count],
														descricao_complemento = v_descricao_complemento[count],
														cod_ncm = v_cod_ncm[count],
														st_origem_id = v_st_origem_id[count], 
														st_icms_id = v_st_icms_id[count],
														cod_unidade = v_cod_unidade[count],
														qtde_peso = v_qtde_peso[count],
														qtde_volume = v_qtde_volume[count],
														qtde_metro = v_qtde_metro[count],
														valor_em = v_valor_em[count],
														valor_em_unidade = v_valor_em_unidade[count],
														valor_unitario = v_valor_unitario[count],
														valor_total = 0,
														serv_total_tributavel = v_serv_total_tributavel[count],
														serv_total_nao_tributavel = v_serv_total_nao_tributavel[count],
														serv_total_produto = v_serv_total_produto[count],
														serv_iss_aliquota = v_serv_iss_aliquota[count],
														serv_iss_deducao = v_serv_iss_deducao[count],
														serv_iss_valor = v_serv_iss_valor[count],
														incluir_livro_fiscal = v_incluir_livro_fiscal[count],
														uf_unidade_negocio = v_uf_unidade_negocio[count],
														uf_destinatario = v_uf_destinatario[count],
														incluir_sintegra = v_incluir_sintegra[count]);
						</cfscript>	
					</cfloop>
					
					<cfscript>
						V_IMPOSTO_ID 				= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ID_ITENS_IMPOSTO");
						V_NF_IMPOSTO_ID 			= this.ListaToArray(lista = arguments, variavel = "NF_IMPOSTO_ID_ITENS_IMPOSTO");
						V_IMPOSTO_REDUCAO_BASE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_REDUCAO_BASE_ITENS_IMPOSTO");
						V_IMPOSTO_BASE_CALCULO 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_BASE_CALCULO_ITENS_IMPOSTO");
						V_IMPOSTO_ALIQUOTA 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_ALIQUOTA_ITENS_IMPOSTO");
						V_IMPOSTO_TOTAL 			= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_TOTAL_ITENS_IMPOSTO");
						V_IMPOSTO_DATA_VENCIMENTO 	= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_DATA_VENCIMENTO_ITENS_IMPOSTO");
						V_IMPOSTO_RETIDO_FONTE 		= this.ListaToArray(lista = arguments, variavel = "IMPOSTO_RETIDO_FONTE_ITENS_IMPOSTO");
						v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ITENS_IMPOSTO, lista2 = ArrayToList(V_NF_IMPOSTO_ID));
					</cfscript>	
					<cfloop list="#v_excluir#" index="l_id">
						<cfscript>
							ret = this.del_nf_es_imposto(num_nota_id = arguments.num_nota_id,
														 nf_imposto_id = l_id);
						</cfscript>
						<cfif ret.erro>
							<cfthrow object="#ret.mensagem#">
						</cfif>				
					</cfloop>
					<cfloop from="1" to="#ArrayLen(V_NF_IMPOSTO_ID)#" index="count">
						<cfscript>
							if(len(trim(V_NF_IMPOSTO_ID[count]))) {
								ret = this.upd_nf_es_imposto(	num_nota_id 			= arguments.num_nota_id,
																nf_imposto_id 			= v_nf_imposto_id[count],
																imposto_id				= v_imposto_id[count],
																imposto_reducao_base	= v_imposto_reducao_base[count],
																imposto_base_calculo	= v_imposto_base_calculo[count],
																imposto_aliquota		= v_imposto_aliquota[count],
																imposto_total			= v_imposto_total[count],
																imposto_retido_fonte	= v_imposto_retido_fonte[count],
																data_vencimento			= v_imposto_data_vencimento[count]);
							} else {
								ret = this.ins_nf_es_imposto(	num_nota_id 			= arguments.num_nota_id,
																imposto_id				= v_imposto_id[count],
																imposto_reducao_base	= v_imposto_reducao_base[count],
																imposto_base_calculo	= v_imposto_base_calculo[count],
																imposto_aliquota		= v_imposto_aliquota[count],
																imposto_total			= v_imposto_total[count],
																imposto_retido_fonte	= v_imposto_retido_fonte[count],
																data_vencimento			= v_imposto_data_vencimento[count]);
							}
						</cfscript>	
						<cfif ret.erro>
							<cfthrow object="#ret.mensagem#">
						</cfif>
					</cfloop>
                    
                    <!---Gerar RPS--->
                    <cfscript>
						ret_rps = this.gerar_rps(num_nota_id = arguments.num_nota_id);
					</cfscript>
					<cfif ret_rps.erro>
						<cfthrow object="#ret_rps.mensagem#">
					</cfif>
                    
				<cfset retorno.erro = false>
					<cfset retorno.mensagem = JSStringFormat('Nota fiscal inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar RPS
	-- RAFAEL 29/10/2010 16:24:26 - CRIADO
	--->
	<cffunction name='gerar_rps' displayname='Gerar RPS' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='nfse.pkg_nfse.prc_rps_gerar' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>				
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Gerar PDF do RPS(Recibo Provisrio de Servios)
	-- RAFAEL 03/11/2010 16:20:28 - CRIADO
	--->
	<cffunction name='gerar_rps_pdf' displayname='Gerar PDF do RPS(Recibo Provisrio de Servios)' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_NOTA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='nfse.pkg_impressao_rps.prc_gerar_rps_pdf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NOTA_ID'  value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('RPS gerado com sucesso')>

			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Executa o clculo da tabela de frete para o CTRC
	-- ANDERSONC 04/08/2010 15:26:41 - CRIADO
	--->
	<cffunction name='calcula_nfes_tabela_frete' displayname='Executa o clculo da tabela de frete para o CTRC' access='remote' returntype='Struct' output='true'>
		<cfargument name='NF_ES_ID' required='yes'>
		<cfargument name='TABELA_FRETE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_nf_es.prc_calcula_nfes_tabela_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NF_ES_ID'  value='#arguments.NF_ES_ID#'  null='#iif(len(trim(arguments.NF_ES_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ID'  value='#arguments.TABELA_FRETE_ID#'  null='#iif(len(trim(arguments.TABELA_FRETE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere um conhecimento
	-- Cristofer 16/12/2006 10:49:20 - CRIADO
	--->
	<cffunction name='ins_conhecimento_private' displayname='Insere um conhecimento' access='remote' returntype='Struct' output='true'>;
			<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ins_conhecimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID' variable='retorno.CONHECIMENTO_ID' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_CONHECIMENTO'  value='#arguments.NUM_CONHECIMENTO#' variable='retorno.NUM_CONHECIMENTO'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE'  value='#arguments.SERIE#' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ITEM_ID'  value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PESSOA_FILIAL'  value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DEPARTAMENTO'  value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_SETOR'  value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CENTRO_CUSTO'  value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_ORGANOGRAMA_GERENCIAL'  value='#arguments.COD_ORGANOGRAMA_GERENCIAL#' >
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DATA_EMISSAO'  value='#arguments.DATA_EMISSAO#' variable='retorno.DATA_EMISSAO' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PRAZO_ENTREGA'  value='#arguments.PRAZO_ENTREGA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_PRODUTO'  value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CFOP_ID'  value='#arguments.CFOP_ID#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CFOP'  value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NATUREZA_OPERACAO'  value='#arguments.NATUREZA_OPERACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ORIGEM_ID'  value='#arguments.ST_ORIGEM_ID#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PAGADOR'  value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REMETENTE'  value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_RAZAO_SOCIAL'  value='#arguments.REM_RAZAO_SOCIAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO'  value='#arguments.REM_ENDERECO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_ENDERECO_NUM'  value='#arguments.REM_ENDERECO_NUM#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_BAIRRO'  value='#arguments.REM_BAIRRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_MUNICIPIO'  value='#arguments.REM_MUNICIPIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_UF'  value='#arguments.REM_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CEP'  value='#arguments.REM_CEP#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_CNPJ_CPF'  value='#arguments.REM_CNPJ_CPF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_REM_INSCRICAO_ESTADUAL'  value='#arguments.REM_INSCRICAO_ESTADUAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REM_MUNICIPIO_ID'  value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_DESTINATARIO'  value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_RAZAO_SOCIAL'  value='#arguments.DEST_RAZAO_SOCIAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO'  value='#arguments.DEST_ENDERECO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_ENDERECO_NUM'  value='#arguments.DEST_ENDERECO_NUM#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_BAIRRO'  value='#arguments.DEST_BAIRRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_MUNICIPIO'  value='#arguments.DEST_MUNICIPIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_UF'  value='#arguments.DEST_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CEP'  value='#arguments.DEST_CEP#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_CNPJ_CPF'  value='#arguments.DEST_CNPJ_CPF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DEST_INSCRICAO_ESTADUAL'  value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DEST_MUNICIPIO_ID'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CONSIGNATARIO'  value='#arguments.COD_CONSIGNATARIO#'  null='#iif(len(trim(arguments.COD_CONSIGNATARIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_RAZAO_SOCIAL'  value='#arguments.CONS_RAZAO_SOCIAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO'  value='#arguments.CONS_ENDERECO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_ENDERECO_NUM'  value='#arguments.CONS_ENDERECO_NUM#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_BAIRRO'  value='#arguments.CONS_BAIRRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_MUNICIPIO'  value='#arguments.CONS_MUNICIPIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_UF'  value='#arguments.CONS_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CEP'  value='#arguments.CONS_CEP#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_CNPJ_CPF'  value='#arguments.CONS_CNPJ_CPF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CONS_INSCRICAO_ESTADUAL'  value='#arguments.CONS_INSCRICAO_ESTADUAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONS_MUNICIPIO_ID'  value='#arguments.CONS_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.CONS_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_REDESPACHO'  value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_RAZAO_SOCIAL'  value='#arguments.RED_RAZAO_SOCIAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO'  value='#arguments.RED_ENDERECO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_ENDERECO_NUM'  value='#arguments.RED_ENDERECO_NUM#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_BAIRRO'  value='#arguments.RED_BAIRRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_MUNICIPIO'  value='#arguments.RED_MUNICIPIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_UF'  value='#arguments.RED_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CEP'  value='#arguments.RED_CEP#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_CNPJ_CPF'  value='#arguments.RED_CNPJ_CPF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RED_INSCRICAO_ESTADUAL'  value='#arguments.RED_INSCRICAO_ESTADUAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_RED_MUNICIPIO_ID'  value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_CLIENTE_COBRANCA'  value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_RAZAO_SOCIAL'  value='#arguments.COB_RAZAO_SOCIAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_ENDERECO'  value='#arguments.COB_ENDERECO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_ENDERECO_NUM'  value='#arguments.COB_ENDERECO_NUM#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_BAIRRO'  value='#arguments.COB_BAIRRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_MUNICIPIO'  value='#arguments.COB_MUNICIPIO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_UF'  value='#arguments.COB_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_CEP'  value='#arguments.COB_CEP#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_CNPJ_CPF'  value='#arguments.COB_CNPJ_CPF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COB_INSCRICAO_ESTADUAL'  value='#arguments.COB_INSCRICAO_ESTADUAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COB_MUNICIPIO_ID'  value='#arguments.COB_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COB_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_PROPRIETARIO'  value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_CNPJ_CPF'  value='#arguments.PROP_CNPJ_CPF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_RAZAO_SOCIAL'  value='#arguments.PROP_RAZAO_SOCIAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_ENDERECO'  value='#arguments.PROP_ENDERECO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PROP_UF'  value='#arguments.PROP_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COD_MOTORISTA'  value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME_MOTORISTA'  value='#arguments.NOME_MOTORISTA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA_TRACAO'  value='#arguments.PLACA_TRACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PLACA'  value='#arguments.PLACA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_LOGRADOURO'  value='#arguments.COLETA_LOGRADOURO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_COMPLEMENTO'  value='#arguments.COLETA_COMPLEMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_BAIRRO'  value='#arguments.COLETA_BAIRRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_CEP'  value='#arguments.COLETA_CEP#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COLETA_UF'  value='#arguments.COLETA_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_MUNICIPIO_ID'  value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_LOGRADOURO'  value='#arguments.ENTREGA_LOGRADOURO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_COMPLEMENTO'  value='#arguments.ENTREGA_COMPLEMENTO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_BAIRRO'  value='#arguments.ENTREGA_BAIRRO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_CEP'  value='#arguments.ENTREGA_CEP#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ENTREGA_UF'  value='#arguments.RED_UF#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTREGA_MUNICIPIO_ID'  value='#arguments.red_municipio_id#'  null='#iif(len(trim(arguments.red_municipio_id)), de('no'), de('yes'))#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO'  value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PESO_REAL'  value='#arguments.PESO_REAL#'  null='#iif(len(trim(arguments.PESO_REAL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VOLUME'  value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_M3'  value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_ESPECIE'  value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_UNIDADE'  value='#arguments.COD_UNIDADE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_UNITARIO'  value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_VALOR'  value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESPACHO'  value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS'  value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS'  value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS'  value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ADEME'  value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_DESCONTO'  value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_IMPOSTOS'  value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_FRETE_PESO'  value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_SEC_CAT'  value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_GRIS'  value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_PEDAGIO'  value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_COLETA_ENTREGA'  value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_SUBSTIT'  value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ISS'  value='#arguments.BASE_CALCULO_ISS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ISS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ISS'  value='#arguments.ALIQUOTA_ISS#'  null='#iif(len(trim(arguments.ALIQUOTA_ISS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ISS'  value='#arguments.VALOR_ISS#'  null='#iif(len(trim(arguments.VALOR_ISS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ALIQUOTA_ICMS_SUBSTIT'  value='#arguments.ALIQUOTA_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_ICMS_PRESUMIDO'  value='#arguments.VALOR_ICMS_PRESUMIDO#'  null='#iif(len(trim(arguments.VALOR_ICMS_PRESUMIDO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REDUCAO_BASE_ICMS'  value='#arguments.REDUCAO_BASE_ICMS#'  null='#iif(len(trim(arguments.REDUCAO_BASE_ICMS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REDUCAO_BASE_ICMS_SUBSTIT'  value='#arguments.REDUCAO_BASE_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.REDUCAO_BASE_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_BASE_CALCULO_ICMS_SUBSTIT'  value='#arguments.BASE_CALCULO_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_VALOR_FATURAMENTO'  value='#arguments.VALOR_FATURAMENTO#'  null='#iif(len(trim(arguments.VALOR_FATURAMENTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TOTAL_CONHECIMENTO'  value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_CANCELADO'  value='#arguments.CANCELADO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FATURADO'  value='#arguments.FATURADO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_OBSERVACAO'  value='#arguments.OBSERVACAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_RODAPE'  value='#arguments.RODAPE#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_ENTRADA_DADOS'  value='#arguments.ENTRADA_DADOS#'  null='#iif(len(trim(arguments.ENTRADA_DADOS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_REGRA_FISCAL_ID'  value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_ID_SUB_CONTR'  value='#arguments.CONHECIMENTO_ID_SUB_CONTR#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_SUB_CONTR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_NUM_CONHECIMENTO_SUB_CONTR'  value='#arguments.NUM_CONHECIMENTO_SUB_CONTR#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO_SUB_CONTR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_SERIE_CONHECIMENTO_SUB_CONTR'  value='#arguments.SERIE_CONHECIMENTO_SUB_CONTR#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TIPO_VENDA'  value='#arguments.TIPO_VENDA#'  null='#iif(len(trim(arguments.TIPO_VENDA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CARGA_ID'  value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_CONHECIMENTO_COMPLEMENTO'  value='#arguments.CONHECIMENTO_COMPLEMENTO#'  null='#iif(len(trim(arguments.CONHECIMENTO_COMPLEMENTO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_FUNDAMENTACAO_LEGAL'  value='#arguments.FUNDAMENTACAO_LEGAL#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5' dbvarname='P_TEM_NOTA'  value='#arguments.TEM_NOTA#'  null='#iif(len(trim(arguments.TEM_NOTA)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_INTEGER' dbvarname='P_ROWID' variable='retorno.ROWID' >
			</cfstoredproc>
		<cfreturn retorno>
	</cffunction>
</cfcomponent>