<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna o grupo negociador de uma pessoa
    -- ANDERSONC 13/07/2010 - CRIADO
    --->		
    <cffunction name="get_grupo_negociador_pessoa" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfargument name="ctrc_id" required="no" default="">
        <cfargument name="operacao_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select gn.grupo_id
                 , gn.descricao
                 , gn.emite_tabela_frete
              from oper.v$grupo_negociador gn
             inner join oper.v$grupo_negociador_pessoa gnp
                     on gnp.grupo_id = gn.grupo_id
             where 1 = 1
			<cfif Len(Trim(arguments.cod_pessoa))>
               and gnp.cod_pessoa = #arguments.cod_pessoa#
            </cfif>
            
            <cfif Len(Trim(arguments.num_romaneio))>
               and exists (select 1
                             from logistica.v$viagem v
                            inner join logistica.v$viagem_carga vc
                                    on vc.viagem_id = v.viagem_id
                            inner join logistica.v$solicitacao_carga sc
                                    on sc.solicitacao_carga_id = vc.solicitacao_carga_id
                            inner join logistica.v$operacao o
                                    on o.operacao_id = sc.operacao_id
                            where o.cod_negociador = gnp.cod_pessoa
                              and v.num_romaneio = #arguments.num_romaneio#
                          )
               and rownum = 1
            <cfelseif Len(Trim(arguments.ctrc_id))>
               and exists (select 1
                             from fiscal.v$conhecimento c
                            where c.cod_negociador = gnp.cod_pessoa
                              and c.conhecimento_id = #arguments.ctrc_id#
                          )
            <cfelseif Len(Trim(arguments.operacao_id))>
               and exists (select 1
                             from logistica.v$operacao o
                            where o.cod_negociador = gnp.cod_pessoa
                              and o.operacao_id = #arguments.operacao_id#
                          )
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as classificaes de natureza
    -- ANDERSON 28/09/2010 - CRIADO
    --->		
    <cffunction name="get_classificacao_natureza" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cn.classificacao_natureza_id
                 , cn.descricao
              from comercial.v$classificacao_natureza cn
             order by cn.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as classificaes comerciais
    -- ANDERSON 28/09/2010 - CRIADO
    --->		
    <cffunction name="get_classificacao_comercial" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cc.classificacao_comercial_id
                 , cc.descricao
                 , cc.lotacao_minima
              from comercial.v$classificacao_comercial cc
             order by cc.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Retorna a tabela de frete por rota que deve ser utilizada atravs dos parmetros informados
    -- ANDERSONC 12/07/2010 - CRIADO
    --->
    <cffunction name='get_tabela_frete_rota_id' displayname='Retorna a tabela de frete que deve ser utilizada atravs dos parmetros informados' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
        <cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
        <cfargument name='COD_NEGOCIADOR' required='yes'>
        <cfargument name='NUM_NATUREZA' required='yes'>
        <cfargument name='COMPOSICAO' required='yes'>
        <cftry>
            <cfstoredproc procedure='comercial.pkg_tabela_frete.prc_tabela_frete_rota_id' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_MUNICIPIO_ID'  value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPOSICAO'  value='#arguments.COMPOSICAO#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ROTA_ID' variable='retorno.TABELA_FRETE_ROTA_ID' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ID' variable='retorno.TABELA_FRETE_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna a tabela de frete por rota internacional que deve ser utilizada atravs dos parmetros informados
	-- ANDERSONC 30/09/2010 14:04:55 - CRIADO
	--->
	<cffunction name='get_tabela_frete_rota_id_intc' displayname='Retorna a tabela de frete por rota internacional que deve ser utilizada atravs dos parmetros informados' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_NEGOCIADOR' required='yes'>
		<cfargument name='CLASSIFICACAO_NATUREZA_ID' required='yes'>
		<cfargument name='CLASSIFICACAO_COMERCIAL_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='comercial.pkg_tabela_frete.prc_tabela_frete_rota_id_intc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_MUNICIPIO_ID'  value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_COD_NEGOCIADOR'  value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICACAO_NATUREZA_ID'  value='#arguments.CLASSIFICACAO_NATUREZA_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_NATUREZA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CLASSIFICACAO_COMERCIAL_ID'  value='#arguments.CLASSIFICACAO_COMERCIAL_ID#'  null='#iif(len(trim(arguments.CLASSIFICACAO_COMERCIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ROTA_ID' variable='retorno.TABELA_FRETE_ROTA_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna a tabela de frete por rota que deve ser utilizada atravs dos parmetros informados
	-- ANDERSONC 10/08/2011 11:05:33 - CRIADO
	--->
	<cffunction name='get_tabela_frete_rota_id_cf' displayname='Retorna a tabela de frete por rota que deve ser utilizada atravs dos parmetros informados' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DESTINO_MUNICIPIO_ID' required='yes'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='COMPOSICAO' required='yes'>
		<cfargument name='ROTA_ID' required='no' default="">
		<cftry>
				<cfstoredproc procedure='comercial.pkg_tabela_frete.prc_tabela_frete_rota_id_cf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ORIGEM_MUNICIPIO_ID'  value='#arguments.ORIGEM_MUNICIPIO_ID#' variable='retorno.ORIGEM_MUNICIPIO_ID'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DESTINO_MUNICIPIO_ID'  value='#arguments.DESTINO_MUNICIPIO_ID#' variable='retorno.DESTINO_MUNICIPIO_ID'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_OPERACAO_ID'  value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_NATUREZA'  value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COMPOSICAO'  value='#arguments.COMPOSICAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ROTA_ID' variable='retorno.TABELA_FRETE_ROTA_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROTA_ID'  value='#arguments.ROTA_ID#'  null='#iif(len(trim(arguments.ROTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as tabelas de frete por rota
    -- ANDERSONC 13/07/2010 - CRIADO
    --->		
    <cffunction name="get_tabela_frete_rota" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_frete_rota_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tfr.tabela_frete_rota_id
                 , tfr.tabela_frete_id
                 , (select tf.descricao
                      from comercial.v$tabela_frete tf
                     where tf.tabela_frete_id = tfr.tabela_frete_id
                   ) as tabela_frete_desc
                 , tfr.rota_id
                 , (select r.descricao_rota
                      from oper.v$rota r
                     where r.rota_id = tfr.rota_id
                   ) as rota_desc
                 , tfr.classificacao_natureza_id
                 , nvl(
                       (select cn.descricao
                          from comercial.v$classificacao_natureza cn
                         where cn.classificacao_natureza_id = tfr.classificacao_natureza_id
                       ), '* Todos *'
                      ) as classificacao_natureza_desc
                 , tfr.classificacao_comercial_id
                 , nvl(
                       (select cc.descricao
                          from comercial.v$classificacao_comercial cc
                         where cc.classificacao_comercial_id = tfr.classificacao_comercial_id
                       ), '* Todos *'
                      ) as classificacao_comercial_desc
                 , (select tn.descricao
                      from comercial.v$tipo_negociacao tn
                     where tn.tipo_negociacao_id = tfr.tipo_negociacao_id
                   ) as tipo_negociacao
                 , (select tfv.modelo_id
                      from comercial.v$tabela_frete_vigencia tfv
                     where tfv.tabela_frete_vigencia_id = tfr.tabela_frete_vigencia_id) as modelo_id                   
              from comercial.v$tabela_frete_rota tfr
             where 1 = 1
			<cfif Len(Trim(arguments.tabela_frete_rota_id))>
               and tfr.tabela_frete_rota_id = #arguments.tabela_frete_rota_id#
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as constantes
    -- ANDERSONC 13/07/2010 - CRIADO
    --->		
    <cffunction name="get_constante" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.cod_constante
                 , c.valor_default
              from comercial.v$constante c
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as variveis de uma tabela de frete por rota
    -- ANDERSONC 13/07/2010 - CRIADO
    --->		
    <cffunction name="get_tabela_frete_variavel" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_frete_rota_id" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select max(tfv.tabela_frete_variavel_id) keep (dense_rank first order by tfv.tabela_frete_rota_id nulls last) as tabela_frete_variavel_id
                 , tfv.tabela_frete_id
                 , max(tfv.tabela_frete_rota_id) keep (dense_rank first order by tfv.tabela_frete_rota_id nulls last) as tabela_frete_rota_id
                 , tfv.variavel_id
                 , (select v.cod_variavel
                      from comercial.v$variavel v
                     where v.variavel_id = tfv.variavel_id
                   ) as cod_variavel
                 , max(tfv.tipo) keep (dense_rank first order by tfv.tabela_frete_rota_id nulls last) as tipo
                 , max(tfv.formula) keep (dense_rank first order by tfv.tabela_frete_rota_id nulls last) as formula
                 , max(tfv.valor) keep (dense_rank first order by tfv.tabela_frete_rota_id nulls last) as valor
              from comercial.v$tabela_frete_variavel tfv
             where exists (select 1
                             from comercial.v$tabela_frete_rota tfr
                            where tfr.tabela_frete_id = tfv.tabela_frete_id
                              and tfr.tabela_frete_vigencia_id = tfv.tabela_frete_vigencia_id
                              and tfr.tabela_frete_rota_id = #arguments.tabela_frete_rota_id#
                          )
               and nvl(tfv.tabela_frete_rota_id, #arguments.tabela_frete_rota_id#) = #arguments.tabela_frete_rota_id#
             group by tfv.tabela_frete_id, tfv.variavel_id
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Ajusta a situao tributria
	-- ANDERSONC 28/07/2010 13:33:32 - CRIADO
	--->
	<cffunction name='retorna_st_icms' displayname='Ajusta a situao tributria' access='remote' returntype='Struct' output='true'>
		<cfargument name='PRODUTO_ID' required='yes'>
        <cfargument name='REGRA_FISCAL_ID' required='yes'>
        <cfargument name='DOCUMENTO_ID' required='yes'>
        <cfargument name='TABELA_FRETE_ID' required='yes'>
        <cfargument name='ST_ICMS_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='comercial.pkg_formula_tabela_frete.prc_retorna_st_icms' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRODUTO_ID'  value='#arguments.PRODUTO_ID#'  null='#iif(len(trim(arguments.PRODUTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REGRA_FISCAL_ID'  value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ID'  value='#arguments.TABELA_FRETE_ID#'  null='#iif(len(trim(arguments.TABELA_FRETE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ST_ICMS_ID'  value='#arguments.ST_ICMS_ID#' variable='retorno.ST_ICMS_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!--- 
    -- PROPSITO 
    -- Cria as constantes e variveis, e executa o clculo
    -- ANDERSONC 13/07/2010 - CRIADO
    --->		
    <cffunction name="calculo_tabela_frete" access="remote" returntype="Struct" output="true">
    	<cfargument name="tabela_frete_id" required="yes">
    	<cfargument name="tabela_frete_rota_id" required="yes">
        <cftry>
        	<cftransaction action='begin'>
				<cfscript>
                    qrConstante = this.get_constante();
                    qrVariavel  = this.get_tabela_frete_variavel(tabela_frete_rota_id = arguments.tabela_frete_rota_id);
                    
                    conn = CreateComponent("_transportes.manipulacao.comercial.cfc_tabela_frete");
                </cfscript>
                
                <cfloop query="qrConstante">
                    <cfscript>
                        ret_cons = conn.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
                                                      VALOR			= iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
                    </cfscript>
                    <cfif ret_cons.erro>
                        <cfthrow object="#ret_cons.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfscript>
                    ret_cons_tf = conn.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
                                                     VALOR		   = arguments.tabela_frete_id);
                </cfscript>
                <cfif ret_cons_tf.erro>
                    <cfthrow object="#ret_cons_tf.mensagem#">
                </cfif>
                
                <cfscript>
                    ret_cons_tfr = conn.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
                                                      VALOR		    = arguments.tabela_frete_rota_id);
                </cfscript>
                <cfif ret_cons_tfr.erro>
                    <cfthrow object="#ret_cons_tfr.mensagem#">
                </cfif>
                
                <cfloop query="qrVariavel">
                    <cfscript>
                        ret_var = conn.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		  = qrVariavel.TABELA_FRETE_ID,
                                                                 TABELA_FRETE_ROTA_ID 	  = arguments.tabela_frete_rota_id,
                                                                 TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
                                                                 VALOR					  = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
                    </cfscript>
                    <cfif ret_var.erro>
                        <cfthrow object="#ret_var.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfscript>
                    ret_recalc = conn.recalculo_tabela_frete();
                </cfscript>
                <cfif ret_recalc.erro>
                    <cfthrow object="#ret_recalc.mensagem#">
                </cfif>
                
                <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select tfvt.tabela_frete_id
                         , tfvt.tabela_frete_rota_id
                         , tfvt.tabela_frete_variavel_id
                         , tfvt.valor
                         , v.cod_variavel
                         , v.descricao
                         , tfv.tipo
                      from comercial.tabela_frete_variavel_temp tfvt
                     inner join comercial.v$tabela_frete_variavel tfv
                             on tfv.tabela_frete_variavel_id = tfvt.tabela_frete_variavel_id
                     inner join comercial.v$variavel v
                             on v.variavel_id = tfv.variavel_id
                     where tfvt.tabela_frete_id = #arguments.tabela_frete_id#
                       and v.exibir_emissao = 1
                     order by v.ordem_exibicao, v.tipo, v.descricao
                </cfquery>
                
                <cfset retorno.st_icms_id = ''>
                
                <cfset retorno.query = qr_result>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Cria as constantes e variveis, e executa o clculo
    -- ANDERSONC 30/09/2010 - CRIADO
    --->		
    <cffunction name="calculo_tabela_frete_intc" access="remote" returntype="Struct" output="true">
    	<cfargument name="tabela_frete_id" required="yes">
    	<cfargument name="tabela_frete_rota_id" required="yes">
        <cftry>
        	<cftransaction action='begin'>
				<cfscript>
                    qrConstante = this.get_constante();
                    qrVariavel  = this.get_tabela_frete_variavel(tabela_frete_rota_id = arguments.tabela_frete_rota_id);
                    
                    conn = CreateComponent("_transportes.manipulacao.comercial.cfc_tabela_frete");
                </cfscript>
                
                <cfloop query="qrConstante">
                    <cfscript>
                        ret_cons = conn.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
                                                      VALOR			= iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
                    </cfscript>
                    <cfif ret_cons.erro>
                        <cfthrow object="#ret_cons.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfscript>
                    ret_cons_tf = conn.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
                                                     VALOR		   = arguments.tabela_frete_id);
                </cfscript>
                <cfif ret_cons_tf.erro>
                    <cfthrow object="#ret_cons_tf.mensagem#">
                </cfif>
                
                <cfscript>
                    ret_cons_tfr = conn.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
                                                      VALOR		    = arguments.tabela_frete_rota_id);
                </cfscript>
                <cfif ret_cons_tfr.erro>
                    <cfthrow object="#ret_cons_tfr.mensagem#">
                </cfif>
                
                <cfloop query="qrVariavel">
                    <cfscript>
                        ret_var = conn.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		  = qrVariavel.TABELA_FRETE_ID,
                                                                 TABELA_FRETE_ROTA_ID 	  = arguments.tabela_frete_rota_id,
                                                                 TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
                                                                 VALOR					  = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
                    </cfscript>
                    <cfif ret_var.erro>
                        <cfthrow object="#ret_var.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfscript>
                    ret_recalc = conn.recalculo_tabela_frete();
                </cfscript>
                <cfif ret_recalc.erro>
                    <cfthrow object="#ret_recalc.mensagem#">
                </cfif>
                
                <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select tfvt.tabela_frete_id
                         , tfvt.tabela_frete_rota_id
                         , tfvt.tabela_frete_variavel_id
                         , tfvt.valor
                         , v.cod_variavel
                         , v.descricao
                         , tfv.tipo
                      from comercial.tabela_frete_variavel_temp tfvt
                     inner join comercial.v$tabela_frete_variavel tfv
                             on tfv.tabela_frete_variavel_id = tfvt.tabela_frete_variavel_id
                     inner join comercial.v$variavel v
                             on v.variavel_id = tfv.variavel_id
                     where tfvt.tabela_frete_id = #arguments.tabela_frete_id#
                       and v.exibir_emissao = 1
                     order by v.ordem_exibicao, v.tipo, v.descricao
                </cfquery>
                
                <cfset retorno.query = qr_result>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Cria as constantes e variveis, e executa o clculo
    -- ANDERSONC 13/07/2010 - CRIADO
    --->		
    <cffunction name="calculo_tabela_frete_cf" access="remote" returntype="Struct" output="true">
    	<cfargument name="tabela_frete_id" required="yes">
    	<cfargument name="tabela_frete_rota_id" required="yes">
        <cftry>
        	<cftransaction action='begin'>
				<cfscript>
					qrConstante = this.get_constante();
                    qrVariavel  = this.get_tabela_frete_variavel(tabela_frete_rota_id = arguments.tabela_frete_rota_id);
                    
                    conn = CreateComponent("_transportes.manipulacao.comercial.cfc_tabela_frete");
                </cfscript>
                
				<cfloop query="qrConstante">
                    <cfscript>
                        ret_cons = conn.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
                                                      VALOR			= iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
                    </cfscript>
                    <cfif ret_cons.erro>
                        <cfthrow object="#ret_cons.mensagem#">
                    </cfif>
                </cfloop>
                
                <cfscript>
                    ret_cons_tf = conn.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
                                                     VALOR		   = arguments.tabela_frete_id);
                </cfscript>
                <cfif ret_cons_tf.erro>
                    <cfthrow object="#ret_cons_tf.mensagem#">
                </cfif>
                
                <cfscript>
                    ret_cons_tfr = conn.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
                                                      VALOR		    = arguments.tabela_frete_rota_id);
                </cfscript>
                <cfif ret_cons_tfr.erro>
                    <cfthrow object="#ret_cons_tfr.mensagem#">
                </cfif>
                
                <cfloop query="qrVariavel">
                	<!---<cfif ListFindNoCase('MARGEM_AGREGADO;MARGEM_TERCEIRO;VALOR_MAXIMO_AGREGADO;VALOR_MAXIMO_TERCEIRO', qrVariavel.COD_VARIAVEL, ';')>--->
						<cfscript>
							ret_var = conn.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		  = qrVariavel.TABELA_FRETE_ID,
																	 TABELA_FRETE_ROTA_ID 	  = arguments.tabela_frete_rota_id,
																	 TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
																	 VALOR					  = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
						</cfscript>
						<cfif ret_var.erro>
							<cfthrow object="#ret_var.mensagem#">
						</cfif>
					<!---</cfif>--->
                </cfloop>
                
                <cfscript>
                    ret_recalc = conn.recalculo_tabela_frete();
                </cfscript>
                <cfif ret_recalc.erro>
                    <cfthrow object="#ret_recalc.mensagem#">
                </cfif>
                
                <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select tfvt.tabela_frete_id
                         , tfvt.tabela_frete_rota_id
                         , tfvt.tabela_frete_variavel_id
                         , tfvt.valor
                         , v.cod_variavel
                         , v.descricao
                         , tfv.tipo
                      from comercial.tabela_frete_variavel_temp tfvt
                     inner join comercial.v$tabela_frete_variavel tfv
                             on tfv.tabela_frete_variavel_id = tfvt.tabela_frete_variavel_id
                     inner join comercial.v$variavel v
                             on v.variavel_id = tfv.variavel_id
                     where tfvt.tabela_frete_id = #arguments.tabela_frete_id#
                     order by v.ordem_exibicao, v.tipo, v.descricao
                </cfquery>
                
                <cfset retorno.query = qr_result>
                <cfset retorno.erro = false>
            </cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
        <cfreturn retorno>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o mapeamento entre campos de um documento fiscal e variveis de tabela de frete
    -- ANDERSON 16/07/2010 - CRIADO
    --->		
    <cffunction name="get_documento_campo_mapeamento" access="remote" returntype="query" output="true">
    	<cfargument name="documento_id" required="yes">
        <cfargument name="nome_campo" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select dcm.mapeamento_id
                 , dc.documento_id
                 , (select d.descricao
                      from comercial.v$documento d
                     where d.documento_id = dc.documento_id
                   ) as documento
                 , dcm.campo_id
                 , dc.nome as nome_campo
                 , dc.descricao as descricao_campo
                 , dcm.variavel_id
                 , (select v.cod_variavel
                      from comercial.v$variavel v
                     where v.variavel_id = dcm.variavel_id
                   ) as cod_variavel
                 , (select v.descricao
                      from comercial.v$variavel v
                     where v.variavel_id = dcm.variavel_id
                   ) as descricao_variavel
              from comercial.v$documento_campo_mapeamento dcm
             inner join comercial.v$documento_campo dc
                     on dc.campo_id = dcm.campo_id
             where dc.documento_id = #arguments.documento_id#
			<cfif Len(trim(arguments.nome_campo))>
			   and dc.nome = '#arguments.nome_campo#'
			</cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Verifica se todos os campos de um documento esto mapeados
	-- ANDERSONC 20/07/2010 18:49:26 - CRIADO
	--->
	<cffunction name='verifica_doc_mapeamento' displayname='Verifica se todos os campos de um documento esto mapeados' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_NEGOCIADOR' required='yes'>
        <cfargument name='DOCUMENTO_ID' required='yes'>
		<cftry>
            <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, substitui os valores dos arguments pelos valores da tabela de frete --->
			<cfscript>
                qrGrupoNegociadorPessoa = this.get_grupo_negociador_pessoa(cod_pessoa = arguments.COD_NEGOCIADOR);
            </cfscript>
            <cfif qrGrupoNegociadorPessoa.EMITE_TABELA_FRETE eq 1>
                <cfstoredproc procedure='comercial.pkg_comercial.prc_verifica_doc_mapeamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
				
                <cfscript>
                    qrDocumentoCampoMapeamento = this.get_documento_campo_mapeamento(documento_id = arguments.DOCUMENTO_ID);
                </cfscript>
                <cfloop query="qrDocumentoCampoMapeamento">
                    <cfscript>
                        if(IsDefined('arguments.VARIAVEl_#qrDocumentoCampoMapeamento.COD_VARIAVEL#')) {
                            arguments[qrDocumentoCampoMapeamento.NOME_CAMPO] = arguments['VARIAVEL_' & qrDocumentoCampoMapeamento.COD_VARIAVEL];
                        }
						else {
							arguments[qrDocumentoCampoMapeamento.NOME_CAMPO] = 0;
						}
                    </cfscript>
                </cfloop>
            </cfif>
            <!--- /// --->
            
            <cfset arguments.EMITE_TABELA_FRETE = qrGrupoNegociadorPessoa.EMITE_TABELA_FRETE>
            <cfset retorno.arguments = arguments>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>