﻿<cfcomponent displayname="Manipulações da área de emissao de documentos" extends="_transportes.funcoes.cfc_init">
	<!---
    -- PROPÓSITO
    -- Registrar um MDF-e
    -- JAQUELINEF 10/12/2013 16:00:16 - CRIADO
    --->
    <cffunction name='ins_mdfe' displayname='Registrar um MDF-e' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='no' default="#session.cod_pessoa#">
        <cfargument name='COD_DEPARTAMENTO' required='no' default="#session.cod_departamento#">
        <cfargument name='COD_SETOR' required='no' default="#session.cod_setor#">
        <cfargument name='COD_CENTRO_CUSTO' required='no' default="#session.cod_centro_custo#">
        <cfargument name='DATA_EMISSAO' required='no' default="">
        <cfargument name='UF_ORIGEM' required='no' default="">
        <cfargument name='UF_DESTINO' required='no' default="">
		<cfargument name='CARGA_CONSOLIDADA_ID' required='no' default="">
		<cfargument name='OBS_MDFE' required='no' default="">
		<cfargument name='CONHECIMENTO_ID' required='no' default="">
		<cfargument name='AUTORIZA_MDFE' required='no' default="1">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_mdfe.prc_ins_mdfe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.MDFE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='WEB_DACTE' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF_ORIGEM#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.UF_DESTINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'    value='#arguments.CARGA_CONSOLIDADA_ID#'  null='#iif(len(trim(arguments.CARGA_CONSOLIDADA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  null='yes' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  null='yes' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null='yes' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null='yes' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  value='#arguments.OBS_MDFE#' null='#iif(len(trim(arguments.OBS_MDFE)), de('no'), de('yes'))#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>

                </cfstoredproc>


                <!--- Envia MDFE para SEFAZ--->
				<cfif arguments.AUTORIZA_MDFE eq 1>
					<cfscript>
						envia_mdfe = this.envia_mdfe_private(mdfe_id = retorno.mdfe_id, apenas_insere_doc = 0);
					</cfscript>
					<cfif envia_mdfe.erro>
						<cfthrow object="#envia_mdfe.mensagem#">
					</cfif>
					
					<cfset retorno.erro = false>
					<cfset retorno.mensagem = JSStringFormat('MDF-e emitido com sucesso.')>
				<cfelse>
				    <cfscript>
						envia_mdfe = this.envia_mdfe_private(mdfe_id = retorno.mdfe_id, apenas_insere_doc = 1);
					</cfscript>
					<cfif envia_mdfe.erro>
						<cfthrow object="#envia_mdfe.mensagem#">
					</cfif>
					
				    <cfset retorno.erro = false>
                    <cfset retorno.mensagem = JSStringFormat('MDF-e gerado com sucesso.')>
				</cfif>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


    <!---
	-- PROPÓSITO
	-- Enviar MDFE para SEFAZ
	-- JAQUELINEF 10/12/2013 16:50:16 - CRIADO
	--->
	<cffunction name='envia_mdfe_private' displayname='Enviar MDFE para SEFAZ' access='remote' returntype='Struct' output='true'>
		<cfargument name='MDFE_ID' required='yes'>
		<cfargument name='APENAS_INSERE_DOC' required='no' default=''>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_mdfe.prc_envia_mdfe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MDFE_ID#'  null='#iif(len(trim(arguments.MDFE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.APENAS_INSERE_DOC#'  null='#iif(len(trim(arguments.APENAS_INSERE_DOC)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('MDF-e enviado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPÓSITO
	-- Enviar MDFE para SEFAZ
	-- JAQUELINEF 10/12/2013 16:50:16 - CRIADO
	--->
	<cffunction name='envia_mdfe' displayname='Enviar MDFE para SEFAZ' access='remote' returntype='Struct' output='true'>
		<cfargument name='MDFE_ID' required='yes'>
		<cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_mdfe.prc_envia_mdfe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MDFE_ID#'  null='#iif(len(trim(arguments.MDFE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
	            <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('MDF-e enviado com sucesso.')>
            </cftransaction>
			<cfcatch>
	            <cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPÓSITO
    -- Consultar Status do MDF-e
    -- jaquelinef 10/12/2013 17:23:37 - CRIADO
    --->
    <cffunction name='consulta_status' displayname='Consultar Status do MDFE' access='remote' returntype='Struct' output='true'>
        <cfargument name='MDFE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_mdfe.prc_consulta_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MDFE_ID#'  null='#iif(len(trim(arguments.MDFE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('MDF-e consultado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Imprimir DAMFE
    -- jaquelinef 10/12/2013 18:12:47 - CRIADO
    --->
    <cffunction name='gera_damdfe' displayname='Imprimir DAMFE' access='remote' returntype='Struct' output='true'>
        <cfargument name='MDFE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_impressao_damdfe.prc_gera_damdfe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MDFE_ID#'  null='#iif(len(trim(arguments.MDFE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('DAMDFE gerado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Consultar MDF-e por chave de acesso.
    -- jaquelinef 27/12/2013 16:42:07 - CRIADO
    --->
    <cffunction name='consulta_chave' displayname='Consultar MDF-e por chave de acesso.' access='remote' returntype='Struct' output='true'>
        <cfargument name='MDFE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_mdfe.prc_consulta_chave' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MDFE_ID#'  null='#iif(len(trim(arguments.MDFE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('MDF-e consultado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Encerrar um MDF-e.
    -- jaquelinef 27/12/2013 17:02:21 - CRIADO
    --->
    <cffunction name='encerrar_mdfe' displayname='Encerrar um MDF-e.' access='remote' returntype='Struct' output='true'>
        <cfargument name='MDFE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_mdfe.prc_encerrar_mdfe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MDFE_ID#'  null='#iif(len(trim(arguments.MDFE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('MDF-e encerrado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	<!---
    -- PROPÓSITO
    -- Cancelar um MDF-e.
    -- jaquelinef 27/12/2013 17:12:10 - CRIADO
    --->
    <cffunction name='cancelar_mdfe' displayname='Cancelar um MDF-e.' access='remote' returntype='Struct' output='true'>
        <cfargument name='MDFE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_mdfe.prc_can_mdfe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MDFE_ID#'  null='#iif(len(trim(arguments.MDFE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='Cancelado pelo site' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('MDF-e cancelado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Excluir um MDF-e rejeitado pela Sefaz.
    -- jaquelinef 30/12/2013 14:02:56 - CRIADO
    --->
    <cffunction name='del_mdfe' displayname='Excluir um MDF-e rejeitado pela Sefaz.' access='remote' returntype='Struct' output='true'>
        <cfargument name='MDFE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_mdfe.prc_del_mdfe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MDFE_ID#'  null='#iif(len(trim(arguments.MDFE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('MDF-e excluido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Inserir MDF-es para o romaneio por UFs de coleta/entrega
    -- jaquelinef 10/09/2014 14:11:32 - CRIADO
    --->
    <cffunction name='ins_mdfe_romaneio' displayname='Inserir MDF-es para o romaneio por UFs de coleta/entrega' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='COD_PESSOA_FILIAL' required='no' default="#session.cod_pessoa#">
        <cfargument name='COD_DEPARTAMENTO' required='no' default="#session.cod_departamento#">
        <cfargument name='COD_SETOR' required='no' default="#session.cod_setor#">
        <cfargument name='COD_CENTRO_CUSTO' required='no' default="#session.cod_centro_custo#">
        <cfargument name='DATA_EMISSAO' required='no' default="">
		<cfargument name='APENAS_INSERE_MDFE' required='no' default="0">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_mdfe.prc_ins_mdfe_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='WEB_CTE' >
                </cfstoredproc>

                <!--- Envia MDFE para SEFAZ--->
				<cfscript>
					envia_mdfe = this.envia_mdfe_romaneio_private(num_romaneio = arguments.NUM_ROMANEIO, apenas_insere_mdfe = arguments.APENAS_INSERE_MDFE);
				</cfscript>
				<cfif envia_mdfe.erro>
					<cfthrow object="#envia_mdfe.mensagem#">
				</cfif>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('MDF-e gerado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

   	<!---
    -- PROPÓSITO
    -- Inserir MDF-es para um conhecimento avulso
    -- luiz 11/05/2016 14:11:32 - CRIADO
    --->
    <cffunction name='ins_mdfe_cte' displayname='Inserir MDF-es para um conhecimento avulso' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='no' default="">
        <cfargument name='COD_PESSOA_FILIAL' required='no' default="#session.cod_pessoa#">
        <cfargument name='COD_DEPARTAMENTO' required='no' default="#session.cod_departamento#">
        <cfargument name='COD_SETOR' required='no' default="#session.cod_setor#">
        <cfargument name='COD_CENTRO_CUSTO' required='no' default="#session.cod_centro_custo#">
        <cfargument name='DATA_EMISSAO' required='no' default="">
        <cfargument name='CONHECIMENTO_ID' required='yes'>

        <cftry>

            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_mdfe.prc_ins_mdfe_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.MDFE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='WEB_CTE' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONHECIMENTO_ID#' >
                </cfstoredproc>

                <!--- Envia MDFE para SEFAZ--->
                <cfscript>
                    envia_mdfe = this.envia_mdfe_private(mdfe_id = retorno.mdfe_id);
                </cfscript>
                <cfif envia_mdfe.erro>
                    <cfthrow object="#envia_mdfe.mensagem#">
                </cfif>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('MDF-e gerado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Enviar MDF-es para o romaneio por UFs de coleta/entrega
    -- jaquelinef 10/09/2014 14:13:02 - CRIADO
    --->
    <cffunction name='envia_mdfe_romaneio_private' displayname='Enviar MDF-es para o romaneio por UFs de coleta/entrega' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='CARGA_CONSOLIDADA_ID' required='no' default="">
		<cfargument name='APENAS_INSERE_MDFE' required='no' default="0">
        <cftry>
             <cfstoredproc procedure='fiscal.pkg_mdfe.prc_envia_mdfe_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
				 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_CONSOLIDADA_ID#'  null='#iif(len(trim(arguments.CARGA_CONSOLIDADA_ID)), de('no'), de('yes'))#'>
				 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.APENAS_INSERE_MDFE#'  null='#iif(len(trim(arguments.APENAS_INSERE_MDFE)), de('no'), de('yes'))#'>
             </cfstoredproc>
             <cfset retorno.erro = false>
             <cfset retorno.mensagem = JSStringFormat('MDF-e enviados com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPÓSITO
    -- Consulta statusMDF-es para o romaneio por UFs de coleta/entrega
    -- jaquelinef 10/09/2014 14:13:58 - CRIADO
    --->
    <cffunction name='consulta_status_romaneio' displayname='Consulta statusMDF-es para o romaneio por UFs de coleta/entrega' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_mdfe.prc_consulta_status_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('MDF-e consultados com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPÓSITO
	-- Efetua a inutilizacao da MDF-e
	-- Matheus 18/07/2017 - CRIADO
	--->
	<cffunction name='prc_inutilizar_mdfe' displayname='Inutiliza a Numeraï¿½ï¿½o da MDFe' access='remote' returntype='Struct' output='true'>
		<cfargument name='MDFE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_mdfe_backend.prc_inutiliza_mdfe_web' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MDFE_ID#'  null='#iif(len(trim(arguments.MDFE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('MDFe inutilizado.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPÓSITO
	-- Efetua o envio do Evento de Pagamento de Operação de Transporte da MDF-e
	-- Eric 18/03/2020 - CRIADO
	--->
	<cffunction name='prc_pag_oper_transporte' displayname='Envia evento de Pagamento de Operacao de Transporte de MDFe' access='remote' returntype='Struct' output='true'>
		<cfargument name='MDFE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_mdfe.prc_pag_oper_transporte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MDFE_ID#'  null='#iif(len(trim(arguments.MDFE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Evento de Pagamento de Operação de Transporte vinculado ao MDFe.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

</cfcomponent>
