﻿<cfcomponent displayname="Consultas da área de emissao de documentos" extends="_transportes.funcoes.cfc_init">
    
    <!--- 
	-- PROPÓSITO 
	-- Busca os dados resumidos do MDFE
	-- NOTAS EXPLICATIVAS
	-- JAQUELINEF 10/12/2013
	--->
	<cffunction name="get_mdfe_resumo" access="remote" returntype="query" output="true">
		<cfargument name="mdfe_id" required="no" default="" />
		<cfargument name="num_romaneio" required="no" default="" />
		<cfargument name="atual" required="no" default="1" />        
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
                select dm.documento_id
                     , m.mdfe_id
                     , m.num_mdfe
                     , m.serie
                     , d.chave
                     , ds.cod_status
                     , ds.situacao_id
                     , ds.descricao_status
                     , ds.permite_editar
                     , ds.permite_inutilizar
                     , ds.emitido
                     , d.tipo_emissao_id
                     , m.num_romaneio
                     , case when ds.situacao_id = 3 then 1 else 0 end as cancelado
                     , case when ds.situacao_id = 11 then 1 else 0 end as encerrado
                     , m.uf_origem
                     , m.uf_destino
                  from fiscal.v$mdfe m
                 inner join fiscal.v$documento_mdfe dm
                    on dm.mdfe_id = m.mdfe_id
                 inner join sefaz.documento d
                    on d.documento_id = dm.documento_id
                 inner join fiscal.v$documento_status ds
                    on ds.documento_id = dm.documento_id
                 where m.mdfe_id <cfif arguments.atual eq 0> not </cfif>in  (select max(mcte.mdfe_id) keep(dense_rank last order by mcte.data_emissao) mdfe_id
                                        from fiscal.v$mdfe mcte
                                       where mcte.num_romaneio = m.num_romaneio
                                       group by mcte.uf_origem, mcte.uf_destino)
				<cfif Len(Trim(arguments.mdfe_id))>                 
                   and m.mdfe_id = #arguments.mdfe_id#
                </cfif>
                
				<cfif Len(Trim(arguments.num_romaneio))>                 
                   and m.num_romaneio = #arguments.num_romaneio#
                </cfif>
                order by m.num_mdfe desc
		</cfquery> 
		<cfreturn qr_result>
	</cffunction>
    
     <!--- 
	-- PROPÓSITO 
	-- Busca os dados resumidos do MDFE gerados pelo cte
	-- NOTAS EXPLICATIVAS
	-- Luiz G 10/12/2013
	--->
	<cffunction name="get_mdfe_resumo_id" access="remote" returntype="query" output="true">
		<cfargument name="mdfe_id" required="no" default="" />   
        <cfargument name="atual" required="no" default="1" />   
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
                select dm.documento_id
                     , m.mdfe_id
                     , m.num_mdfe
                     , m.serie
                     , d.chave
                     , ds.cod_status
                     , ds.situacao_id
                     , ds.descricao_status
                     , ds.permite_editar
                     , ds.permite_inutilizar
                     , ds.emitido
                     , d.tipo_emissao_id
                     , m.num_romaneio
                     , case when ds.situacao_id = 3 then 1 else 0 end as cancelado
                     , case when ds.situacao_id = 11 then 1 else 0 end as encerrado
                     , m.uf_origem
                     , m.uf_destino
                  from fiscal.v$mdfe m
                 inner join fiscal.v$documento_mdfe dm
                    on dm.mdfe_id = m.mdfe_id
                 inner join sefaz.documento d
                    on d.documento_id = dm.documento_id
                 inner join fiscal.v$documento_status ds
                    on ds.documento_id = dm.documento_id
                 where 1 = 0 
                 
				<cfif Len(Trim(arguments.mdfe_id))>                 
                   or m.mdfe_id = #arguments.mdfe_id#
                </cfif>  
                
                <cfif arguments.atual eq 0> 
                  and 1 = 0 
                </cfif>                  
                 
                order by m.num_mdfe desc
		</cfquery> 
		<cfreturn qr_result>
	</cffunction>
    
    
    
</cfcomponent>