<cfparam name="vars.DATA_INICIAL">
<cfparam name="vars.DATA_FINAL">
<cfscript>
	conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
	qrFicha = conn.get_ficha_dados_veiculo(cod_equipamento = vars.cod_equipamento);
</cfscript>
<cfif qrFicha.recordCount eq 0 >
	<script>
		alert('Equipamento/veculo no encontrado!');		
		window.close();
	</script>
    <cfabort />
<cfelse>
	<cfscript>
        vars.equipamento_id = qrFicha.equipamento_id;
		qrFichaDatas = conn.get_ficha_datas_veiculo_os(equipamento_id = vars.equipamento_id);
    </cfscript>
	<cfif vars.data_inicial eq '' >
		<cfscript>
        vars.data_inicial = qrFichaDatas.data_abertura_inicial;
    	</cfscript>
    </cfif>
    <cfif vars.data_final eq '' >
		<cfscript>
        vars.data_final = qrFichaDatas.data_abertura_final;
    	</cfscript>
    </cfif>
	<cfscript>
        qrFichaDetalhes  = conn.get_ficha_dados_veiculo_os(argumentCollection = vars);
    </cfscript>
    <cfif qrFichaDetalhes.recordCount eq 0 >
		<script>
            alert('No h detalhes sobre o veculo!');		
            window.close();
        </script>
        <cfabort />
    </cfif>
</cfif>

<cfdocument name="pdf_contrato" format="pdf">
	<cfset v_mat_total_contrato = 0>
    <cfset v_serv_total_contrato = 0 >

      <style type="text/css">
      table {
          font-family:Verdana, Geneva, sans-serif;
      }
      .titulo_1 {
        font-size: 18px;
        font-weight: bold;
      }
      .titulo_2 {
        font-size: 11px;
		background-color:#CCC;
        font-weight: bold;
      }  
      .texto {
        font-size: 10px;
      }
      .texto_negrito {
        font-size: 10px;
        font-weight:bold;
      }  
      .texto_eventos {
        font-size: 10px;
      }
      .texto_eventos_complemento {
        font-size: 10px;
        font-style:italic;
      }
	  
	  .linha_1 { 
        font-size: 10px;
	  	background-color:#EAEAEA;		  
	  }

	  .linha_2 { 
        font-size: 10px;
	  }
	  
	  .rodape {
	  	background-color:#D6D6D6;		  
		font-weight:bold;
		font-size:12px;
	  }

	.titulo_3{
		border-bottom:1px solid #000;
		border-top:1px solid #000;
		text-align:center;
		font-family:Verdana, Arial, Helvetica, sans-serif;
		font-weight:normal;
		font-size:10px; 
		padding:2px;
		background: none;
	}	  
    </style>

      <body>
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td colspan="2"><cfoutput query="qrFicha" group="EQUIPAMENTO_ID">
            <table width="100%" border="0" cellpadding="2" cellspacing="1" class="texto">
              <tr>
                <td colspan="4" class="titulo_3">Dados do Veiculo/Equipamento</td>
              </tr>
              <tr>
                <td width="13%">Equipamento:</td>
                <td width="1%">#qrFicha.COD_EQUIPAMENTO#</td>
                <td width="10%">Ano:</td>
                <td width="99%">#qrFicha.ANO#</td>
              </tr>
              <tr>
                <td>Marca/Modelo:</td>
                <td><nobr>#qrFicha.MARCA#/#qrFicha.MODELO#</nobr></td>
                <td>Classifica&ccedil;&atilde;o:</td>
                <td>#qrFicha.CLASSIFICACAO#</td>
              </tr>
              <tr>
                <td>Propriet&aacute;rio:</td>
                <td colspan="3">#qrFicha.IDENTIFICADOR# - #qrFicha.PROPRIETARIO#</td>
              </tr>
              <tr>
                <td>Per&iacute;odo:</td>
                <td colspan="3">#vars.DATA_INICIAL# at #vars.DATA_FINAL#</td>
              </tr>
            </table>
            </cfoutput>
			</td>
        </tr>
        <cfset v_mat_total_contrato = 0>
        <cfset v_serv_total_contrato = 0>
        <cfoutput query="qrFichaDetalhes" group="ORDEM_SERVICO_ID">
        <tr>
          <td colspan="2" >
           <table width="100%" border="0" cellpadding="2" cellspacing="1" class="texto" style="border-top:1px ##999 solid; border-left:1px ##999 solid; border-right:0px ##999 solid; padding-right:15px;">
            <tr class="titulo_2">
              <td width="4%" align="center" nowrap>O.S.</td>
              <td width="5%" align="center" nowrap>Abertura</td>
              <td width="7%" align="center" nowrap>Fechamento</td>
              <td width="3%" align="center" nowrap>KM</td>
              <td width="9%" align="center" nowrap>Pedido</td>
              <td width="4%" align="center" nowrap>Nota Fiscal</td>
              <td width="68%" align="center">&nbsp;</td>
            </tr>
            <tr>
              <td align="center" valign="middle" nowrap class="titulo_1">#qrFichaDetalhes.NUM_ORDEM_SERVICO#</td>
              <td align="center" valign="middle" nowrap>#qrFichaDetalhes.DATA_ABERTURA#</td>
              <td align="center" valign="middle" nowrap>#qrFichaDetalhes.DATA_FECHAMENTO#</td>
              <td align="center" valign="middle" nowrap>#qrFichaDetalhes.KM#</td>
              <td align="center" valign="middle" nowrap>#qrFichaDetalhes.NUM_CONTROLE#</td>
              <td align="center" valign="middle">#qrFichaDetalhes.NUM_NOTA_FISCAL#</td>
              <td align="center" valign="middle">&nbsp;</td>
            </tr>
            <tr>
              <td align="center">&nbsp;</td>
              <td colspan="6" align="left">
                  <table width="100%" border="0" cellpadding="2" cellspacing="1" class="texto">
                    <tr>
                      <td colspan="6" class="titulo_2">Materiais</td>
                    </tr>
                    <tr class="texto_negrito">
                      <td colspan="1">C&oacute;digo</td>
                      <td colspan="2">Descri&ccedil;&atilde;o</td>
                      <td colspan="1" align="center">Quantidade</td>
                      <td colspan="1" align="center" nowrap >Valor</td>
                      <td colspan="1" align="center" nowrap>Valor Total</td>
                    </tr>
                    <cfset v_mat_contrato = 0>
                    <cfoutput>
                        <cfif (qrFichaDetalhes.MATERIAL eq 1) and (qrFichaDetalhes.QUANTIDADE gte 0) >
                    <tr>
                      <td colspan="1">#qrFichaDetalhes.CODIGO#</td>
                      <td colspan="2">#qrFichaDetalhes.MATERIAL_SERVICO#</td>
                      <td colspan="1" align="center">#qrFichaDetalhes.QUANTIDADE#</td>
                      <td colspan="1" align="right">#LSNumberFormat(qrFichaDetalhes.VALOR_UNITARIO,',.__')#</td>
                      <td colspan="1" align="right">#LSNumberFormat(qrFichaDetalhes.VALOR_TOTAL,',.__')#</td>
                    </tr>
						<cfscript>
                            v_mat_contrato += val(qrFichaDetalhes.VALOR_TOTAL);
                            v_mat_total_contrato += val(qrFichaDetalhes.VALOR_TOTAL);
                        </cfscript>
                        </cfif>
                    </cfoutput>
                  </table>
              </td>
            </tr>
            <cfscript>
				qrTabela = conn.get_os_tabelas(ordem_servico_id = qrFichaDetalhes.ORDEM_SERVICO_ID);
			</cfscript>
            <tr>
              <td align="center">&nbsp;</td>
              <td colspan="6" align="left">
              <table width="100%" border="0" cellspacing="1" cellpadding="2" class="texto">
                <tr>
                  <td colspan="2" class="titulo_2">Tabelas</td>
                </tr>
                <cfloop query="qrTabela">
                <tr>
                  <td>#qrTabela.NOME#</td>
                </tr>
                </cfloop>
              </table>
              </td>
            </tr>
            <tr>
              <td align="center">&nbsp;</td>
              <td colspan="6" align="left"><table width="100%" border="0" cellpadding="2" cellspacing="1" class="texto">
                <tr>
                  <td colspan="5" class="titulo_2">Servi&ccedil;os</td>
                </tr>
                <tr class="texto_negrito">
                  <td width="13%">C&oacute;digo</td>
                  <td>Descri&ccedil;&atilde;o</td>
                  <td width="11%" align="center" nowrap>Tempo Padr&atilde;o</td>
                  <td width="11%" align="center">Valor</td>
                </tr>
                <cfset v_serv_contrato = 0>
                <cfoutput>
					<cfif qrFichaDetalhes.MATERIAL eq 0>
                        <tr>
                          <td>#qrFichaDetalhes.CODIGO#</td>
                          <td>#qrFichaDetalhes.MATERIAL_SERVICO#</td>
                          <td align="center">#qrFichaDetalhes.TEMPO#</td>
                          <td align="right" style="padding-right:23px">#LSNumberFormat(qrFichaDetalhes.VALOR_TOTAL,',.__')#</td>
                        </tr>
                        <cfscript>
							v_serv_contrato += val(qrFichaDetalhes.VALOR_TOTAL);
							v_serv_total_contrato += val(qrFichaDetalhes.VALOR_TOTAL);
						</cfscript>
                    </cfif>
                </cfoutput>
              </table></td>
            </tr>
          </table></td>
        </tr>
        <tr>
          <td style="border-left:1px ##999 solid; border-right:0px ##999 solid" colspan="2" >&nbsp;</td>
        </tr>
        <tr>
          <td colspan="2" align="right" style="border-bottom:1px ##999 solid; border-left:1px ##999 solid; border-right:0px ##999 solid; padding-right:20px">
          <table width="205" border="0" cellpadding="2" cellspacing="1" class="texto">
            <tr>
              <td colspan="2" align="center" class="titulo_2">Total O.S.</td>
            </tr>
            <tr>
              <td colspan="2">Mercadorias</td>
            </tr>
            <tr>
              <td width="94" nowrap style="padding-left:15px">Valor:</td>
              <td width="98" align="right">#LSNumberFormat(v_mat_contrato,',.__')#</td>
            </tr>
            <tr>
              <td colspan="2" nowrap>Servi&ccedil;os</td>
            </tr>
            <tr>
              <td nowrap style="padding-left:15px">Valor:</td>
              <td align="right">#LSNumberFormat(v_serv_contrato,',.__')#</td>
            </tr>
            <tr class="rodape">
              <td align="right" nowrap style="padding-left:15px">TOTAL:</td>
              <td align="right">#LSNumberFormat(v_mat_contrato + v_serv_contrato,',.__')#</td>
            </tr>
          </table></td>
        </tr>
        </cfoutput>
        <cfoutput>
			<tr>
			  <td colspan="2" align="center" style="border-top:2px ##999 solid;"><table width="205" border="0" cellpadding="2" cellspacing="1" class="texto">
            <tr>
              <td colspan="2" align="center" class="titulo_1">Resumo do Ve&iacute;culo</td>
            </tr>
            <tr>
              <td colspan="2">Mercadorias</td>
            </tr>
            <tr>
              <td width="94" nowrap style="padding-left:15px">Valor:</td>
              <td width="98" align="right">#LSNumberFormat(v_mat_total_contrato,',.__')#</td>
            </tr>
            <tr>
              <td colspan="2" nowrap>Servi&ccedil;os</td>
            </tr>
            <tr>
              <td nowrap style="padding-left:15px">Valor:</td>
              <td align="right">#LSNumberFormat(v_serv_total_contrato,',.__')#</td>
            </tr>
            <tr class="rodape">
              <td align="right" nowrap style="padding-left:15px">TOTAL:</td>
              <td align="right">#LSNumberFormat(v_mat_total_contrato + v_serv_total_contrato,',.__')#</td>
            </tr>
          </table></td>
		  </tr>  
        </cfoutput>
      </table>
    </body>
 
</cfdocument>

<cfset path = ExpandPath("/temp")>
<cfset data_tempo = "#Second(Now())##Minute(Now())##Hour(Now())##Day(Now())##Year(Now())#">
<cfpdf action="merge" destination="#path#/ficha_veicular_#vars.cod_equipamento#_#session.usuario#_#data_tempo#.pdf" overwrite="yes">
<cfpdfparam source="pdf_contrato">
</cfpdf>
<script>
  window.location = '/temp/ficha_veicular_<cfoutput>#vars.cod_equipamento#_#session.usuario#_#data_tempo#</cfoutput>.pdf';
</script>
