<cfif IsDefined("vars.DATA_INICIO") and IsDefined("vars.DATA_FIM")>
	<cfscript>
		conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
		qrDisponibilidadeFrota = conn.get_disponibilidade_frota(argumentCollection = vars);
	</cfscript>
<cfelse> 
	<script type="text/javascript">
		alert('Dados no definidos!');
		window.close();
	</script>
</cfif>

<cfdocument name="pdf_disponibilidade_frota" format="pdf" orientation="portrait">
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Disponibilidade da Frota</title>
<style type="text/css">
	body {
		margin: 0;
		padding: 0;
	}
	.fonte {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-stretch: condensed;
		font-size: 12px;
	}
</style>
</head>
<body>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
	<tr>
		<td><table width="100%" border="0" cellpadding="3" cellspacing="1" class="fonte">
        	<tr>
            	<td colspan="7" nowrap align="center" style="font-size: 22px; padding-bottom: 22px;"><b>Disponibilidade da Frota</b></td>
            </tr>
            <tr>
            	<td colspan="7" nowrap align="left" valign="top"><b>Per&iacute;odo:</b> <cfoutput>#vars.DATA_INICIO#</cfoutput> <b>at&eacute;</b> <cfoutput>#vars.DATA_FIM#</cfoutput></td>
            </tr>
            <tr>
            	<td align="left" valign="bottom"><b>Centro de Custo</b></td>
                <td align="right" valign="bottom"><b>Qtde. Ve&iacute;culos</b></td>
                <td align="right" valign="bottom"><b>Qtde. Ve&iacute;c. Manut.</b></td>
                <td align="right" valign="bottom"><b>Horas Dispon&iacute;veis</b></td>
                <td align="right" valign="bottom"><b>% Horas Dispon&iacute;veis</b></td>
                <td align="right" valign="bottom"><b>Horas Paradas</b></td>
                <td align="right" valign="bottom"><b>% Horas Paradas</b></td>
            </tr>
            <cfoutput query="qrDisponibilidadeFrota">
            <tr>
            	<td nowrap align="left">#qrDisponibilidadeFrota.CENTRO_CUSTO#</td>
                <td nowrap align="right">#qrDisponibilidadeFrota.QTDE_VEICULOS#</td>
                <td nowrap align="right">#qrDisponibilidadeFrota.QTDE_VEICULOS_MANUT#</td>
                <td nowrap align="right">#qrDisponibilidadeFrota.HORAS_DISPONIVEIS#</td>
                <td nowrap align="right">#LSNumberFormat(qrDisponibilidadeFrota.HORAS_DISPONIVEIS_PERC, ',.__')#</td>
                <td nowrap align="right">#LSNumberFormat(qrDisponibilidadeFrota.HORAS_PARADAS, ',.__')#</td>
                <td nowrap align="right">#LSNumberFormat(qrDisponibilidadeFrota.HORAS_PARADAS_PERC, ',.__')#</td>
            </tr>
            </cfoutput>
        </table></td>
	</tr>
</table>
</body>
</html>
<cfdocumentitem type="footer">
	<style type="text/css">
		body {
			margin: 0;
			padding: 0;
		}
		.fonte {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-stretch: condensed;
			font-size: 10px;
		}
	</style>
	<table width="100%" border="0" cellpadding="0" cellspacing="0" class="fonte">
        <tr>
        	<td nowrap align="left"><cfoutput>#session.usuario# - #DateFormat(Now(), 'dd/mm/yyyy') & " " & TimeFormat(Now(), 'HH:mm:ss')#</cfoutput></td>
            <td nowrap align="right">P&aacute;ginas: <cfoutput>#cfdocument.CurrentPageNumber# de #cfdocument.TotalPageCount#</cfoutput></td>
        </tr>
    </table>
</cfdocumentitem>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfset data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss')>
<cfpdf action="merge" destination="#path#/disponibilidade_frota_#data_hora#.pdf" overwrite="yes">
	<cfpdfparam source="pdf_disponibilidade_frota" />
</cfpdf>
<script>
	window.location = '/temp/disponibilidade_frota_<cfoutput>#data_hora#</cfoutput>.pdf';
</script>