<cfscript>
	if (IsDefined("arguments.ORDEM_SERVICO_ID")) {
		conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
		connP = CreateComponent("_transportes.consulta.cfc_pessoa");
		connV = CreateComponent("_transportes.consulta.cfc_veiculo");
		qrUnidade = connP.get_pessoa_light( cod_pessoa = session.cod_pessoa);
		qrUnidadeFone = connP.getTelefone( cod_pessoa = session.cod_pessoa);
		qrOS = conn.get_ordens_servico( ORDEM_SERVICO_ID = arguments.ORDEM_SERVICO_ID, ABERTAS = 0, SOCORRO=-1);
		qrMaterialOS = conn.get_os_materiais( ordem_servico_id = arguments.ORDEM_SERVICO_ID );
		qrAtividadeOS = conn.get_os_atividades( ordem_servico_id = arguments.ORDEM_SERVICO_ID );
		qrOficina = connP.get_pessoa_light( cod_pessoa = qrOS.COD_PESSOA_OFICINA );
		qrOficinaEndereco = connP.getEndereco( cod_pessoa = qrOS.COD_PESSOA_OFICINA );
		qrVeiculo = connV.get_veiculo( placa = qrOS.PLACA );
		qrVeiculoMotorista = connV.get_veiculo_motorista( placa = qrOS.PLACA, data = qrOS.DATA_ABERTURA );
	}
	v_total_os = 0;
	v_total_nf = 0;
	v_total_valor_os = 0;
</cfscript>

<cfdocument format="pdf" name="OS" overwrite="yes" >
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />

<title>..: KM&amp;M Transporte e Log&iacute;stica :..</title>

<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<style>
	html{
		width:100%;
		margin:auto;
		background-color:#FFF !important;
	}
	body{
		width:100%;
		margin:auto;
		background-color:#FFF !important;
	}
	.content{
		width:1000px;
		margin:auto;
		padding:auto;
		background-color:#FFF !important;
	}
	
	.borda{
		border:1px solid #607C92;
		padding:0;
		margin:0;
		background-color:#FFF !important;
	}
	
	.texto_titulo_1{
		font-weight:bold;
		font-size:20px;	
		color:#293F88;
		background-color:#FFF !important;
	}
	
	.texto_titulo_2{
		font-weight:500;
		font-size:11px;	
		color:#333;
		background-color:#FFF !important;
	}
	
	.texto_negrito, .td_titulo, .td_texto_lateral{
		font-weight:600;
		color:#333;
		background-color:#FFF !important;
	}
	
	.td_titulo{
		text-transform:uppercase; 
		background-color:#c1cadb; 
		border-bottom:1px solid #607C92;
		height:22px;
		background-color:#FFF !important;
	}
	
	.td_texto_lateral{
		color: #293F88;
		font-size:14px;
		background-color:#FFF !important;
	}

    input[type="checkbox"]{
        position: absolute;
        visibility: hidden;
    }

    label{
        display: block;
        height: 12px;
        width: 10px;
        margin-left: 33px;
        background-color: #E4E8ED !important;
        border: 1px solid #607C92 !important;
    }
	
	table, tr, td, div, html, body{
		background-color:#FFF !important;
	}
</style>
</head>
<body class="background">
 <div class="content">
	<table width="1000px">
    	<tr>
        	<td>
            	<cfoutput>
            	<table cellpadding="0" cellspacing="0" style="border-top:2px ##607C92 solid; border-right:4px ##607C92 solid; background-color:##FFF; width:100%; border-bottom:none" height="80px" >
                	<tr style="border-right:2px solid ##607C92;">
                    	<td align="center" valign="middle" style="border-right:1px solid ##607C92; border-left:1px solid ##607C92; width:15%; background-color:##fff"><img src="/<cfoutput>#session.site#</cfoutput>_imagens/logos/logo_relatorio.jpg"></td>
                        <td valign="middle" style="border-right:1px solid ##607C92; background-color:##FFF; width:60%">
                        	<table width="100%" height="100%" class="texto" >
                            	<tr height="33%">
                                	<td class="texto_titulo_1" align="center">#qrUnidade.RAZAO_SOCIAL#</td>
                            	</tr>
                                <tr height="33%">
                                    <td class="texto_titulo_2" align="center">#qrUnidade.ENDERECO_COMPLETO#</td>
                                </tr>
                                <tr height="33%">
                                    <td class="texto_titulo_2" align="center">Fone:<cfloop query="qrUnidadeFone">
                                    												(#qrUnidadeFone.TELEFONE_DDD#) #qrUnidadeFone.TELEFONE_PREFIXO#-#qrUnidadeFone.TELEFONE_NUMERO#&nbsp;&nbsp;&nbsp;&nbsp;
                                                                                   </cfloop>
                                                                                    </td>
                                </tr>
                            </table>
                        </td>
                        <td style="width:25%;border-left:1px solid ##607C92;  " align="center" valign="middle" height="100%">
                        	<table width="100%" height="100%" class="texto" cellpadding="0" cellspacing="0">
                            	<tr height="50%">
                                	<td class="td_texto_lateral"  align="center" style="border-bottom:1px solid ##607C92; ">OS <!---#qrOS.TIPO_OS#--->: #qrOS.NUM_ORDEM_SERVICO#</td>
                            	</tr>
                                <tr height="50%">
                                	<td class="td_texto_lateral" align="center" >#lsDateFormat(qrOS.DATA_ABERTURA)#</td>
                            	</tr>
                           	</table>
                        </td>
                    </tr>
                </table>

                <table width="100%" class="borda"  cellpadding="0" cellspacing="0"  style="border-right:4px solid ##607C92 !important; " >
                    <tr class="texto" height="15px">
                        <td colspan="1" align="center" class="td_titulo" width="50%">Fornecedor</td>
                        <td align="center"  class="td_titulo" width="50%" style="border-left:1px solid ##607C92;" >Pedido</td>
                    </tr>
                    <tr class="texto" height="15px">
                        <td class="texto_negrito" width="50%" style="padding-left:1px"><nobr>Razao Social: <span class="texto" style="font-weight:normal; padding-left:3px">#qrOficina.RAZAO_SOCIAL#</span></nobr></td>
                        <td class="texto_negrito" width="50%" style="border-left:1px solid ##607C92;padding-left:1px"><nobr>Condi&ccedil;&atilde;o de Pagamento: <span class="texto" style="font-weight:normal; padding-left:3px"><!---#qrOficina.RAZAO_SOCIAL#---></span></nobr></td>
                    </tr>
                    <tr class="texto" height="15px">
                        <td class="texto_negrito" width="50%" style="padding-left:1px">Endere&ccedil;o: <span class="texto" style="font-weight:normal; padding-left:3px">#qrOficinaEndereco.LOGRADOURO#, #qrOficinaEndereco.NUMERO# #mid(qrOficinaEndereco.CEP,1,5)#-#mid(qrOficinaEndereco.CEP,6,3)#</span></td>
                        <td class="texto_negrito" width="50%" style="border-left:1px solid ##607C92;;padding-left:1px"><nobr>Prazo de Pagamento:<span class="texto" style="font-weight:normal; padding-left:3px"><!---#qrOficinaEndereco.LOGRADOURO#---></span></nobr></td>
                    </tr>
                    <tr class="texto" height="15px">
                        <td class="texto_negrito" width="50%" style="padding-left:1px">Bairro: <span class="texto" style="font-weight:normal; padding-left:3px ;padding-left:1px">#qrOficinaEndereco.BAIRRO# - #qrOficinaEndereco.MUNICIPIO#</span></td>
                        <td class="texto_negrito" width="50%" style="border-left:1px solid ##607C92;padding-left:1px"><nobr>Prazo de Entrega:<span class="texto" style="font-weight:normal; padding-left:3px"><!---#qrOficinaEndereco.BAIRRO#---></span></nobr></td>
                    </tr>
                    <tr height="15px">
                        <td>&nbsp;</td>
                        <td class="texto_negrito" style="border-left:1px solid ##607C92;padding-left:1px"><nobr>Local de Entrega:<span class="texto" style="font-weight:normal; padding-left:3px"><!---#qrOficinaEndereco.MUNICIPIO#---></span></nobr></td>
                    </tr>
                </table>

                <table width="100%" border="0" cellspacing="2" cellpadding="1" class="borda">
                  <tr class="texto">
                    <td class="td_titulo" colspan="7" align="center" >Ve&iacute;culo</td>
                  </tr>
                  <tr class="texto_negrito">
                    <td width="1%" nowrap>Frota</td>
                    <td width="1%" nowrap>Placa</td>
                    <td width="1%" nowrap>Motorista</td>
                    <td width="1%" nowrap>KM Atual</td>
                    <td width="1%" nowrap>Respons&aacute;vel</td>
                    <td width="1%" nowrap>Abertura</td>
                    <td width="1%" nowrap>Fechamento</td>
                  </tr>
                  <tr class="texto">
                    <td nowrap>#qrVeiculo.COD_VEICULO#</td>
                    <td nowrap>#qrVeiculo.PLACA#</td>
                    <td nowrap>#qrVeiculoMotorista.NOME#</td>
                    <td nowrap>#qrOS.KM_RODADO#</td>
                    <td nowrap>#qrOS.RESPONSAVEL#</td>
                    <td nowrap>#lsDateFormat(qrOS.DATA_ABERTURA)#</td>
                    <td nowrap>#lsdateFormat(qrOS.DATA_FECHAMENTO)#</td>
                  </tr>
                </table>

               	</cfoutput>
                <table width="100%" cellpadding="2" cellspacing="1" class="borda" style="" >
                	<tr class="texto">
                    	<td class="td_titulo" colspan="7" align="center" >Servi&ccedil;os</td>
                    </tr>
                    <tr class="texto_negrito">
                    	<td align="left" width="6%">C&oacute;digo</td>
                    	<td width="38%" align="left" style="padding-left:30px" >Atividade</td>
                        <td width="10%" align="center">KM Previsto</td>
                        <td width="10%" align="center">Data Prevista</td>
                        <td width="9%" align="center">Quantidade</td>
                        <td width="9%" align="right">Valor</td>
                        <td width="8%" align="center">Executada</td>
                    </tr>
                    <cfif qrAtividadeOS.recordCount eq 0 >
                    	<tr class="texto" height="30">
                            <td class="obrigatorio" colspan="7" align="center" >Nenhuma atividade atribu&iacute;da.</td>
                        </tr>
                    <cfelse>
                    <cfoutput query="qrAtividadeOS">
                    <tr class="texto">
                    	<td>#qrAtividadeOS.COD_ATIVIDADE#</td>
                    	<td>#qrAtividadeOS.TITULO#</td>
                        <td align="center">#qrAtividadeOS.KM_PREVISAO#</td>
                        <td align="center">#LsDateFormat(qrAtividadeOS.DATA_PREVISAO)#</td>
                        <td align="center">#qrAtividadeOS.QUANTIDADE#</td>
                        <td align="right">#lsNumberFormat(qrAtividadeOS.VALOR_SERVICO_ATIVIDADE,'.,__')#</td>
                        <td align="center" style="padding:0px">
                            <label for="executada"></label>
                            <input type="checkbox" class="check" name="executada"/>
                        </td>
                    </tr>
                    </cfoutput>
                    </cfif>
                </table>
                <table width="100%" cellpadding="2" cellspacing="1" class="borda" style="" >
                	<tr class="texto">
                    	<td class="td_titulo" colspan="4" align="center" >Materiais</td>
                    </tr>
                    <tr class="texto_negrito">
                    	<td width="55%" align="left" >Material</td>
                        <td width="15%" align="center">Quantidade</td>
                        <td width="15%" align="center">Valor Unit&aacute;rio</td>
                        <td width="15%" align="right">Valor Total</td>
                    </tr>
                    <cfoutput query="qrMaterialOS">
                    <tr class="texto">
                    	<td>#qrMaterialOS.COD_MATERIAL#-#qrMaterialOS.MATERIAL_RETIRADO#</td>
                        <td align="center">#qrMaterialOS.QUANTIDADE#</td>
                        <td align="center">R$ #lsNumberFormat(qrMaterialOS.VALOR_UNITARIO,'.,__')#</td>
                        <td align="right">R$ #lsNumberFormat(qrMaterialOS.VALOR_UNITARIO * qrMaterialOS.QUANTIDADE,'.,__')#</td>
                    </tr>
                    </cfoutput>
                </table>
                
                <cfoutput> 
                <table width="100%" border="0" cellspacing="2" cellpadding="1" class="borda">
                  <tr class="texto">
                    <td class="td_titulo" align="center" >Observa&ccedil;&atilde;o</td>
                  </tr>
                  <tr class="texto">
                    <td>#qrOS.OBSERVACAO#</td>
                  </tr>
                </table>
                </cfoutput>
                
            </td>
        </tr>
    </table>
 </div>
</body>
</html>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfset data_hora = dateformat(now(),'ddmmyyyy') & lstimeformat(now(),'hhmss') >

<cfpdf action="merge" destination="#path#/os_#qrOS.NUM_ORDEM_SERVICO#_#data_hora#.pdf" overwrite="yes">
	<cfpdfparam source="os" />
</cfpdf>
<cffile action="readbinary" file="#path#/os_#qrOS.NUM_ORDEM_SERVICO#_#data_hora#.pdf" variable="VARQUIVO">
