<!---LOCALIZAR COM AJAX --->
<cfif IsDefined("vars.CONSULTA") and vars.CONSULTA eq 100>
	<cfscript>
        conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
        qrOrdemServico = conn.get_ordens_servico(argumentCollection = vars, empresa = 0, abertas = 0);
    </cfscript>
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr>
            <td class="texto">
                <table width="100%" border="0" cellspacing="1" cellpadding="1">
                    <tr class="titulo_2">
                        <td nowrap align="right">N&ordm; O.S.</td>
                        <td nowrap align="left">Tipo</td>
                        <td nowrap align="left">Equipamento</td>
                        <td nowrap align="left">Data de Abertura</td>
                        <td nowrap align="left">Respons&aacute;vel</td>
                        <td nowrap align="right">CNPJ Oficina</td>
                        <td nowrap align="left">Oficina</td>
                        <td nowrap align="right">Valor do Servi&ccedil;o</td>
                        <td nowrap align="right">Valor Total</td>
                    </tr>
                    <cfoutput query="qrOrdemServico">
                    <tr class="linha_#(qrOrdemServico.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrOrdemServico.CurrentRow Mod 2) + 1#';" onClick="f_retorna_valor('#JSStringFormat(qrOrdemServico.ORDEM_SERVICO_ID)#')">
                        <td nowrap align="right">#qrOrdemServico.NUM_ORDEM_SERVICO#</td>
                        <td nowrap align="left">#qrOrdemServico.TIPO_ORDEM_SERVICO#</td>
                        <td nowrap align="left">#qrOrdemServico.COD_EQUIPAMENTO#</td>
                        <td nowrap align="left">#qrOrdemServico.DATA_ABERTURA#</td>
                        <td nowrap align="left">#qrOrdemServico.RESPONSAVEL#</td>
                        <td nowrap align="right">#qrOrdemServico.CNPJ_OFICINA#</td>
                        <td nowrap align="left">#qrOrdemServico.OFICINA#</td>
                        <td nowrap align="right">#qrOrdemServico.VALOR_SERVICO#</td>
                        <td nowrap align="right">#qrOrdemServico.VALOR_TOTAL_OS#</td>
                    </tr>
                    </cfoutput>
                    <cfif qrOrdemServico.RecordCount eq 0>
                    <tr>
                        <td colspan="8" align="center" valign="middle" class="obrigatorio">Nenhuma ordem de servi&ccedil;o foi encontrada.</td>
                    </tr>
                    </cfif>
                </table>
            </td>
        </tr>
    </table>
</cfif>

<cfif IsDefined("vars.CONSULTA") and vars.CONSULTA eq 1>
	<cftry>
	<cfset retorno = StructNew()>
	<cfset retorno.erro = false>
	<cfset retorno.mensagem = "">
	
	<cfscript>
        conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
        qrOrdemServico = conn.get_ordens_servico(ordem_servico_id = vars.ORDEM_SERVICO_ID, abertas = 0);
		qrMaterial 	   = conn.get_os_materiais(ordem_servico_id = vars.ORDEM_SERVICO_ID);
		qrAtividade	   = conn.get_os_atividades(ordem_servico_id = vars.ORDEM_SERVICO_ID);
		qrTabela	   = conn.get_os_tabelas(ordem_servico_id = vars.ORDEM_SERVICO_ID, somente_folhas = 1);
        qrTabelasCombo = conn.get_tabela_manutencao(equipamento_id = qrOrdemServico.EQUIPAMENTO_ID);
    </cfscript>
    <cfif qrOrdemServico.RecordCount gt 0>
        <script type="text/javascript">
            with(parent.document.form_transportes) {
				parent.document.getElementById('tabela_os').rows[0].cells[1].style.display = 'none';
				
				parent.document.getElementById('tabela_os').rows[0].cells[2].innerHTML = '2. Materiais';
				parent.document.getElementById('tabela_os').rows[0].cells[3].innerHTML = '3. Atividades';
				parent.document.getElementById('tabela_os').rows[0].cells[4].innerHTML = '4. Tabelas';
				
				//OBSERVACAO.onblur = function() { parent.f_muda_aba('td_aba_pedidos_itens', ''); }
				
				parent.f_limpar_MATERIAL();
                parent.f_limpar_ATIVIDADE();
				parent.f_limpar_TABELA();
				
				<cfoutput>
					ORDEM_SERVICO_ID.value = '#JSStringFormat(qrOrdemServico.ORDEM_SERVICO_ID)#';
                	EMPRESA.value = '#JSStringFormat(qrOrdemServico.EMPRESA)#';
					VALOR_SERVICO.value = parent.toCurrency(Number('#JSStringFormat(qrOrdemServico.VALOR_SERVICO)#'));
					NUM_ORDEM_SERVICO.value = '#JSStringFormat(qrOrdemServico.NUM_ORDEM_SERVICO)#';
					DATA_ABERTURA.value = '#JSStringFormat(qrOrdemServico.DATA_ABERTURA)#';
					DATA_ATENDIMENTO.value = '#JSStringFormat(qrOrdemServico.DATA_ATENDIMENTO)#';
					DATA_PREVISAO_LIBERACAO.value = '#JSStringFormat(qrOrdemServico.DATA_PREVISAO_LIBERACAO)#';
					DATA_FECHAMENTO.value = '#JSStringFormat(qrOrdemServico.DATA_FECHAMENTO)#';
					TIPO_ORDEM_SERVICO_ID.value = '#JSStringFormat(qrOrdemServico.TIPO_ORDEM_SERVICO_ID)#';
					COD_EQUIPAMENTO.value = '#JSStringFormat(qrOrdemServico.COD_EQUIPAMENTO)#';
					CENTRO_CUSTO_VEICULO.value = '#JSStringFormat(qrOrdemServico.CENTRO_CUSTO)#';
					MATERIAL_DESCRICAO.value = '#JSStringFormat(qrOrdemServico.MATERIAL)#';
					EQUIPAMENTO_ID.value = '#JSStringFormat(qrOrdemServico.EQUIPAMENTO_ID)#';
					KM_ABERTURA.value = '#JSStringFormat(qrOrdemServico.KM_ABERTURA)#';
					CNPJ.value = '#JSStringFormat(qrOrdemServico.CNPJ_OFICINA)#';
					OFICINA.value = '#JSStringFormat(qrOrdemServico.OFICINA)#';
					COD_PESSOA_OFICINA.value = '#JSStringFormat(qrOrdemServico.COD_PESSOA_OFICINA)#';
					COD_FUNCIONARIO.value = '#JSStringFormat(qrOrdemServico.COD_FUNCIONARIO)#';
					RESPONSAVEL.value = '#JSStringFormat(qrOrdemServico.RESPONSAVEL)#';
					COD_PESSOA_RESPONSAVEL.value = '#JSStringFormat(qrOrdemServico.COD_PESSOA_RESPONSAVEL)#';
					NUM_ORDEM_SERVICO_VINCULO.value = '#JSStringFormat(qrOrdemServico.NUM_ORDEM_SERVICO_VINCULO)#';
					TIPO_MANUTENCAO_ID.value = '#JSStringFormat(qrOrdemServico.TIPO_MANUTENCAO_ID)#';
					parent.f_limpa_select(ORDEM_SERVICO_ID_VINCULO);
					<cfif Len(Trim(qrOrdemServico.ORDEM_SERVICO_ID_VINCULO))>
						parent.f_cria_option('#JSStringFormat(qrOrdemServico.ORDEM_SERVICO_ID_VINCULO)#', '#JSStringFormat(qrOrdemServico.NUM_ORDEM_SERVICO_VINCULO)# - #JSStringFormat(qrOrdemServico.DATA_ABERTURA_OS_VINCULO)#', ORDEM_SERVICO_ID_VINCULO);
						ORDEM_SERVICO_ID_VINCULO.value = '#JSStringFormat(qrOrdemServico.ORDEM_SERVICO_ID_VINCULO)#';
					<cfelse>
						parent.f_cria_option('', '-- Informe um N de O.S. --', ORDEM_SERVICO_ID_VINCULO);
					</cfif>
					
					OBSERVACAO.value = '#JSStringFormat(qrOrdemServico.OBSERVACAO)#';
				</cfoutput>
				parent.f_habilita_impressao();
				parent.document.getElementById('div_pendencias').innerHTML = '';
				parent.f_busca_pedidos_abertos('<cfoutput>#vars.ORDEM_SERVICO_ID#</cfoutput>');
            }
        </script>
        
        <cfif qrTabelasCombo.RecordCount gt 0>
			<script type="text/javascript">
                with(parent.document.form_transportes) {
				   parent.f_limpa_select(TABELA_ID);
                   parent.f_limpar_TABELA();
                   parent.f_limpar_ATIVIDADE();
                   parent.f_cria_option('', '-- Selecione a Tabela --', TABELA_ID);
                   <cfoutput query="qrTabelasCombo">
                      parent.f_cria_option('#TABELA_ID#', '#PATH#', TABELA_ID);
                   </cfoutput>
                }
            </script>
        </cfif>
        
        <cfif qrMaterial.RecordCount gt 0>
            <script type="text/javascript">
                with(parent.document.form_transportes) {
                    <cfoutput query="qrMaterial">
						parent.f_incluir_MATERIAL();
						
						/* Campos */
						CONTROLE_ID_MAT.value = '#JSStringFormat(qrMaterial.CONTROLE_ID)#';
						COD_PESSOA_RETIRADA.value = '#JSStringFormat(qrMaterial.COD_PESSOA_RETIRADA)#';
						<!---MAT_PEDIDO_ITEM_ID.value = '#JSStringFormat(qrMaterial.PEDIDO_ITEM_ID)#';--->
						
						//f_limpa_select(MATERIAL_ID);
						v_opt = parent.f_cria_option('#JSStringFormat(qrMaterial.MATERIAL_ID)#', '#JSStringFormat(qrMaterial.MATERIAL)#', MATERIAL_ID);
						v_opt.setAttribute('cod_genuino', '#JSStringFormat(qrMaterial.COD_GENUINO)#');
						v_opt.setAttribute('cod_fabricante', '#JSStringFormat(qrMaterial.COD_FABRICANTE)#');
						v_opt.setAttribute('cod_paralelo', '#JSStringFormat(qrMaterial.COD_PARALELO)#');
						v_opt.setAttribute('identificado', '#JSStringFormat(qrMaterial.IDENTIFICADO)#');
						v_opt.setAttribute('unidade_estoque', '#JSStringFormat(qrMaterial.UNIDADE_ESTOQUE)#');
						MATERIAL_ID.value = '#JSStringFormat(qrMaterial.MATERIAL_ID)#';
						
						QUANTIDADE.value = '#JSStringFormat(qrMaterial.QUANTIDADE)#';

						VALOR_UNITARIO.value = parent.toCurrency(Number('#JSStringFormat(qrMaterial.VALOR_UNITARIO)#'));
						VALOR_TOTAL.value = parent.toCurrency(Number('#JSStringFormat(qrMaterial.VALOR_TOTAL)#'));
						
						parent.f_limpa_select(MAT_POSICAO_ID);
						parent.f_cria_option('#JSStringFormat(qrMaterial.POSICAO_ID)#', '#JSStringFormat(qrMaterial.POSICAO)#', MAT_POSICAO_ID);
						MAT_POSICAO_ID.value = '#JSStringFormat(qrMaterial.POSICAO_ID)#';

						COD_EQUIPAMENTO_MONTADO.value = '#JSStringFormat(qrMaterial.COD_EQUIPAMENTO)#';
						COD_EQUIPAMENTO_RETIRADO.value = '#JSStringFormat(qrMaterial.COD_EQUIPAMENTO_RETIRADO)#';
						COD_EQUIPAMENTO_COMPONENTE.value = ''; // SQL
						COMPONENTE.value = ''; // SQL
						/* ------ */
						
						parent.f_salvar_MATERIAL();
                    </cfoutput>
                }
            </script>
        </cfif>
        
        <cfif qrAtividade.RecordCount gt 0>
            <script type="text/javascript">
                with(parent.document.form_transportes) {
                    <cfoutput query="qrAtividade">
						parent.f_incluir_ATIVIDADE();
						
						 <!---Campos --->
						CONTROLE_ID_ATV.value = '#JSStringFormat(qrAtividade.CONTROLE_ID_ATIVIDADE)#';
						CONTROLE_ID_TABELA.value = '#JSStringFormat(qrAtividade.CONTROLE_ID_TABELA)#';
						<!---ATV_PEDIDO_ITEM_ID.value = '#JSStringFormat(qrAtividade.PEDIDO_ITEM_ID)#';--->
						ATV_VALOR_TOTAL.value = '#JSStringFormat(qrAtividade.VALOR_ATIVIDADE)#';
						ATV_QUANTIDADE.value = '#JSStringFormat(qrAtividade.QUANTIDADE)#';
						ATV_VALOR_UNITARIO.value = '#JSStringFormat(qrAtividade.VALOR_UNITARIO)#';
						
						//parent.f_limpar_ATIVIDADE();
						parent.f_cria_option('#JSStringFormat(qrAtividade.ATIVIDADE_ID)#', '#JSStringFormat(qrAtividade.TITULO)#', ATIVIDADE_ID);
						ATIVIDADE_ID.value = '#JSStringFormat(qrAtividade.ATIVIDADE_ID)#';
						
						parent.f_limpa_select(ATV_POSICAO_ID);
						parent.f_cria_option('#JSStringFormat(qrAtividade.POSICAO_ID)#', '#JSStringFormat(qrAtividade.POSICAO)#', ATV_POSICAO_ID);
						ATV_POSICAO_ID.value = '#JSStringFormat(qrAtividade.POSICAO_ID)#';
						/* ------ */
						
						parent.f_salvar_ATIVIDADE();
                    </cfoutput>
                }
            </script>
        </cfif>
        
        <cfif qrTabela.RecordCount gt 0>
            <script type="text/javascript">
                with(parent.document.form_transportes) {
                    <cfoutput query="qrTabela">
						parent.f_incluir_TABELA();
						parent.v_insere_atividades_tabela = 0;
						/* Campos */
						CONTROLE_ID_TAB.value = '#JSStringFormat(qrTabela.CONTROLE_ID)#';
						TABELA_ID.value		  = '#JSStringFormat(qrTabela.TABELA_ID)#';
						LISTA_TABELAS.value   = '#JSStringFormat(qrTabela.LISTA_TABELA_SEPARADOR)#';
						/* ------ */
						parent.f_salvar_TABELA();
						parent.v_insere_atividades_tabela = 1;
                    </cfoutput>
                }
            </script>
        </cfif>
        
        <cfif not Len(Trim(qrOrdemServico.DATA_FECHAMENTO))>
			<script type="text/javascript">
                parent.f_habilitar_botao('editar', 'f_editar()');
                parent.f_habilitar_botao('excluir', 'f_excluir()');
            </script>
        <cfelse>
			<script type="text/javascript">
                parent.f_desabilitar_botao('editar');
                parent.f_desabilitar_botao('excluir');
            </script>        
        </cfif>
    <cfelse>
        <script type="text/javascript">
            alert('Nenhuma ordem de servio foi encontrada.');
        </script>
    </cfif>
	
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>			
		</cfcatch>
		</cftry>
		
		<cfscript>
			fnc_trata_erros(struct_erro = retorno, mostra_msg_ok  = false);
		</cfscript>
	
</cfif>

<cfif IsDefined("vars.CONSULTA") and vars.CONSULTA eq 2>
	<cfscript>
		conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_almoxarifado");
		qrPedido = conn.get_pedidos_abertos_fornecedor(cod_pessoa_fornecedor = vars.COD_PESSOA_FORNECEDOR,
													   equipamento_id = vars.EQUIPAMENTO_ID,
													   ordem_servico_id = vars.ORDEM_SERVICO_ID,
													   os_externa = 1);
	</cfscript>
    
    <script defer="defer">
		v_pedido = new Array();
		v_pedido_item = new Array();
	</script>
    
    <table width="100%" border="0" cellspacing="1" cellpadding="3">
		<cfif qrPedido.RecordCount gt 0>
        <tr class="titulo_1">
            <td width="1%" nowrap align="center">&nbsp;</td>
            <td width="1%" nowrap align="center">&nbsp;</td>
            <td nowrap align="center">N&ordm; Pedido</td>
            <td nowrap align="center">Data do Pedido</td>
            <td nowrap align="center">Situa&ccedil;&atilde;o</td>
            <td nowrap align="center">N&ordm; Solicita&ccedil;&atilde;o</td>
            <td nowrap align="center">Solicitante</td>
            <td nowrap align="center">Equipamento</td>
            <td nowrap align="center">Vlr. Materiais</td>
            <td nowrap align="center">Vlr. Atividades</td>
            <td nowrap align="center">Vlr. Total</td>
            <td width="1%" nowrap align="center">Vlr. Utilizado</td>
        </tr>
        <cfset v_count_pedido = 0>
        <cfset v_count_pedido_item = 0>
        
        <cfoutput query="qrPedido" group="PEDIDO_ID">
            <tr class="titulo_4">
                <td nowrap align="center"><button type="button" id="BTN_MOSTRAR_PEDIDO_ITENS_#qrPedido.PEDIDO_ID#" class="botao-16x16" <cfif Len(Trim(vars.ORDEM_SERVICO_ID))>disabled="disabled"</cfif> onClick="f_mostrar_pedido_itens(#JSStringFormat(qrPedido.PEDIDO_ID)#)"><img src="/_imagens/botoes/16x16/mostrar.gif" alt="Mostrar Itens do Pedido" title="Mostrar Itens do Pedido" width="16" height="16" align="absmiddle" /></button>
                    <button type="button" id="BTN_OCULTAR_PEDIDO_ITENS_#qrPedido.PEDIDO_ID#" class="botao-16x16" <cfif Len(Trim(vars.ORDEM_SERVICO_ID))>disabled="disabled"</cfif> onClick="f_ocultar_pedido_itens(#JSStringFormat(qrPedido.PEDIDO_ID)#)" style="display: none;"><img src="/_imagens/botoes/16x16/ocultar.gif" alt="Ocultar Itens do Pedido" title="Ocultar Itens do Pedido" width="16" height="16" align="absmiddle" /></button></td>
                <td nowrap align="center"><input type="checkbox" name="PEDIDO_ID" id="PEDIDO_ID_#qrPedido.PEDIDO_ID#" class="check" <cfif qrPedido.PEDIDO_UTILIZADO_OS eq 1>checked</cfif> value="#qrPedido.PEDIDO_ID#" <cfif Len(Trim(vars.ORDEM_SERVICO_ID))>disabled="disabled"</cfif> onClick="f_on_click_pedido(#v_count_pedido#)" /></td>
                <td nowrap align="center">#qrPedido.NUM_PEDIDO#</td>
                <td nowrap align="center">#qrPedido.DATA_PEDIDO#</td>
                <td nowrap align="center">#qrPedido.SITUACAO#</td>
                <td nowrap align="center">#qrPedido.NUM_SOLICITACAO_COMPRA#</td>
                <td nowrap align="left">#qrPedido.SOLICITANTE#</td>
                <td nowrap align="center">#qrPedido.EQUIPAMENTO#</td>
                <td nowrap align="right">#LSNumberFormat(qrPedido.VALOR_MATERIAL, ',.__')#</td>
                <td nowrap align="right">#LSNumberFormat(qrPedido.VALOR_ATIVIDADE, ',.__')#</td>
                <td nowrap align="right">#LSNumberFormat(qrPedido.VALOR_TOTAL_PEDIDO, ',.__')#</td>
                <td nowrap align="center"><input type="text" name="VALOR_UTILIZADO_#qrPedido.PEDIDO_ID#" id="VALOR_UTILIZADO_#qrPedido.PEDIDO_ID#" value="#NumberFormat(qrPedido.PEDIDO_VALOR_UTILIZADO_OS, '.__')#" readonly="true" display="PEDIDO N&ordm; #qrPedido.NUM_PEDIDO# / VALOR UTILIZADO" <cfif Len(Trim(vars.ORDEM_SERVICO_ID))>disabled="disabled"</cfif> style="width: 100px; text-align: center;" /></td>
            </tr>
            <script defer="defer">
				v_pedido[#v_count_pedido#] = new Array();
				
                v_pedido[#v_count_pedido#]['pedido_id'] = '#JSStringFormat(qrPedido.PEDIDO_ID)#';
            </script>
            <cfset v_count_pedido = v_count_pedido + 1>
			<cfoutput>
                <cfif Len(Trim(qrPedido.PEDIDO_ITEM_ID))>
                <tr id="tr_pedido_itens_#qrPedido.PEDIDO_ID#_#qrPedido.PEDIDO_ITEM_ID#" class="linha_2" style="display: none;">
                    <td>&nbsp;</td>
                    <td nowrap align="center"><input type="checkbox" name="PEDIDO_ITEM_ID" id="PEDIDO_ITEM_ID_#qrPedido.PEDIDO_ITEM_ID#" class="check" <cfif qrPedido.PEDIDO_ITEM_UTILIZADO_OS eq 1>checked</cfif> value="#qrPedido.PEDIDO_ITEM_ID#" <cfif Len(Trim(vars.ORDEM_SERVICO_ID))>disabled="disabled"</cfif> onClick="f_on_click_pedido_item(#v_count_pedido_item#)" /></td>
                    <td colspan="8" align="left">#qrPedido.DESCRICAO_ITEM#</td>
                    <td nowrap align="right">#LSNumberFormat(qrPedido.VALOR_NEGOCIADO, ',.__')#</td>
                    <td>&nbsp;</td>
                </tr>
                <script defer="defer">
					v_pedido_item[#v_count_pedido_item#] = new Array();
					
					v_pedido_item[#v_count_pedido_item#]['pedido_item_id']           = '#JSStringFormat(qrPedido.PEDIDO_ITEM_ID)#';
                    v_pedido_item[#v_count_pedido_item#]['pedido_id'] 	             = '#JSStringFormat(qrPedido.PEDIDO_ID)#';
					v_pedido_item[#v_count_pedido_item#]['atividade_id'] 	         = '#JSStringFormat(qrPedido.ATIVIDADE_ID)#';
					v_pedido_item[#v_count_pedido_item#]['atividade_posicao_id'] 	 = '#JSStringFormat(qrPedido.ATIVIDADE_POSICAO_ID)#';
					v_pedido_item[#v_count_pedido_item#]['atividade_posicao'] 	     = '#JSStringFormat(qrPedido.ATIVIDADE_POSICAO)#';
					v_pedido_item[#v_count_pedido_item#]['material_id'] 	         = '#JSStringFormat(qrPedido.MATERIAL_ID)#';
					v_pedido_item[#v_count_pedido_item#]['material_cod_genuino'] 	 = '#JSStringFormat(qrPedido.MATERIAL_COD_GENUINO)#';
					v_pedido_item[#v_count_pedido_item#]['material_cod_fabricante']  = '#JSStringFormat(qrPedido.MATERIAL_COD_FABRICANTE)#';
					v_pedido_item[#v_count_pedido_item#]['material_cod_paralelo'] 	 = '#JSStringFormat(qrPedido.MATERIAL_COD_PARALELO)#';
					v_pedido_item[#v_count_pedido_item#]['material_identificado'] 	 = '#JSStringFormat(qrPedido.MATERIAL_IDENTIFICADO)#';
					v_pedido_item[#v_count_pedido_item#]['material_unidade_estoque'] = '#JSStringFormat(qrPedido.MATERIAL_UNIDADE_ESTOQUE)#';
					v_pedido_item[#v_count_pedido_item#]['material_posicao_id'] 	 = '#JSStringFormat(qrPedido.MATERIAL_POSICAO_ID)#';
					v_pedido_item[#v_count_pedido_item#]['material_posicao'] 	     = '#JSStringFormat(qrPedido.MATERIAL_POSICAO)#';
					v_pedido_item[#v_count_pedido_item#]['descricao_item'] 	         = '#JSStringFormat(qrPedido.DESCRICAO_ITEM)#';
					v_pedido_item[#v_count_pedido_item#]['quantidade'] 	             = '#JSStringFormat(qrPedido.QUANTIDADE)#';
					v_pedido_item[#v_count_pedido_item#]['valor_unitario'] 	         = '#JSStringFormat(qrPedido.VALOR_UNITARIO)#';
					v_pedido_item[#v_count_pedido_item#]['valor_negociado']          = '#JSStringFormat(qrPedido.VALOR_NEGOCIADO)#';
                </script>
                <cfset v_count_pedido_item = v_count_pedido_item + 1>
                </cfif>
			</cfoutput>
        </cfoutput>
        <tr class="titulo_1">
            <td colspan="11" nowrap align="right">Total</td>
            <td id="tr_valor_total" nowrap align="center">0.00</td>
        </tr>
        <cfif Len(Trim(vars.ORDEM_SERVICO_ID))>
        	<script defer="defer">
				f_soma_valor_utilizado();
			</script>
        </cfif>
        <cfelse>
        <tr style="padding-top: 15px;">
            <td align="left" valign="middle" class="obrigatorio">Para este fornecedor n&atilde;o foi encontrado nenhum pedido aberto.</td>
        </tr>
        </cfif>
    </table>
</cfif>

<cfif IsDefined("vars.CONSULTA") and vars.CONSULTA eq 3>
	<cfscript>
		conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
	    qrSolicitacoes  = conn.get_equipamento_solicitacao(equipamento_id = vars.EQUIPAMENTO_ID);
		qrMaterial	    = conn.get_veiculo_material(equipamento_id = vars.EQUIPAMENTO_ID);
		qrServicos 	    = conn.get_veiculo_atividade(equipamento_id = vars.EQUIPAMENTO_ID, nao_executada = 1);
		qrTabela 	    = conn.get_equipamento_tabela(equipamento_id = vars.EQUIPAMENTO_ID);
	</cfscript>
    
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
    	<cfif qrSolicitacoes.RecordCount gt 0>
            <tr>
                <td>
                    <fieldset><legend>Pend&ecirc;ncias Registradas</legend>
                    <table width="100%" border="0" cellspacing="1" cellpadding="2" id="pendencias">
                        <tr class="titulo_1">
                            <td width="1%" align="center">Executar</td>
                            <td nowrap align="center" width="9%">Placa</td>
                            <td nowrap align="center" width="15%">Data</td>
                            <td nowrap align="left" width="30%">Motorista</td>
                            <td nowrap align="left" width="1%">Tipo</td>
                            <td align="left" width="44%">Pend&ecirc;ncia</td>
                        </tr>
                        <cfoutput query="qrSolicitacoes">
                        <tr class="linha_2">
                            <td nowrap align="center"><button id="btn_executar_pendencia" onClick="f_executar_solicitacao(this, event, #qrSolicitacoes.SOLICITACAO_ID#)" type="button" class="botao-16x16"><img src="/_imagens/botoes/16x16/ferramentas.gif" alt="Executar na OS" width="16" height="16" align="absmiddle"></button>
                                       <input name="CONTROLE_ID_SOLICITACAO" type="hidden" value="#qrSolicitacoes.SOLICITACAO_ID#" id="pendencia_#qrSolicitacoes.SOLICITACAO_ID#" disabled="disabled"></td></td>
                            <td nowrap align="center">#qrSolicitacoes.COD_EQUIPAMENTO#</td>
                            <td nowrap align="center">#qrSolicitacoes.DATA_SOLICITACAO#</td>
                            <td nowrap align="left">#qrSolicitacoes.MOTORISTA#</td>
                            <td nowrap align="center">#qrSolicitacoes.TIPO#</td>
                            <td align="left">#qrSolicitacoes.TEXTO#</td>
                        </tr>
                        </cfoutput>                    
                    </table>
                    </fieldset>
                </td>
            </tr>
            <tr>
                <td>
                    <fieldset><legend>Pend&ecirc;ncias que ser&atilde;o executadas</legend>
                    <table width="100%" border="0" cellspacing="1" cellpadding="2" id="pendencias_executar">
                        <tr class="titulo_1">
                            <td width="1%">Retirar</td>
                            <td nowrap align="center" width="9%">Placa</td>
                            <td nowrap align="center" width="15%">Data</td>
                            <td nowrap align="left" width="30%">Motorista</td>
                            <td nowrap align="left" width="1%">Tipo</td>
                            <td align="left" width="44%">Pend&ecirc;ncia</td>
                        </tr>
                    </table>
                    </fieldset>
                </td>
            </tr>
        </cfif>
        <tr>
    		<td>
				<fieldset><legend>Materiais montados no ve&iacute;culo</legend>
                <table width="100%" border="0" cellspacing="1" cellpadding="2">
            		<tr class="titulo_1">
              			<td nowrap align="center">Placa</td>
                        <td nowrap align="center">C&oacute;digo</td>
                        <td nowrap align="left">Material</td>
                        <td nowrap align="center">Posi&ccedil;&atilde;o</td>
                        <td nowrap align="center">Km Previs&atilde;o</td>
                        <td nowrap align="center">Alerta com</td>
                        <td nowrap align="center">Diferen&ccedil;a</td>
                        <td nowrap align="center">Data previs&atilde;o</td>
                        <td nowrap align="center">Alerta com</td>
                        <td nowrap align="center">Diferen&ccedil;a</td>
                        <td nowrap align="center">Status</td>
            		</tr>
            		<cfoutput query="qrMaterial">
              		<tr class="linha_#(qrMaterial.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrMaterial.Currentrow Mod 2) + 1#';">
                        <td nowrap align="center">#qrMaterial.COD_EQUIPAMENTO#</td>
                        <td nowrap align="center">#qrMaterial.COD_EQUIPAMENTO_IDENTIFICADO#</td>
                        <td nowrap align="left">#qrMaterial.MATERIAL#</td>
                        <td nowrap align="center">#qrMaterial.POSICAO#</td>
                        <td nowrap align="center">#qrMaterial.KM_PREVISAO#</td>
                        <td nowrap align="center">#qrMaterial.ALERTA_KM#</td>
                        <td nowrap align="center">#qrMaterial.KM_PREVISTO#</td>
                        <td nowrap align="center">#LSDateFormat(qrMaterial.DATA_PREVISAO)#</td>
                        <td nowrap align="center">#qrMaterial.ALERTA_DIAS#</td>
                        <td nowrap align="center">#qrMaterial.DIAS#</td>
                        <cfswitch expression="#qrMaterial.STATUS_ID#">
                            <cfcase value="0">
                            	<cfset v_estilo = 'ok'>
                            </cfcase>
                            <cfcase value="1">
                            	<cfset v_estilo = 'ok'>
                            </cfcase>
                            <cfcase value="-1">
                            	<cfset v_estilo = 'a_vencer'>
                            </cfcase>
                            <cfcase value="-2">
                            	<cfset v_estilo = 'vencido'>
                            </cfcase>
                        </cfswitch>
                        <td nowrap align="center" class="#v_estilo#">#qrMaterial.STATUS#</td>
              		</tr>
            		</cfoutput>
                    <cfif qrMaterial.RecordCount eq 0>
                    <tr>
                        <td colspan="11" align="center" valign="middle" class="obrigatorio">Nenhum registro foi encontrado.</td>
                    </tr>
                    </cfif>
          		</table>
                </fieldset>
            </td>
        </tr>
        <tr>
    		<td>
				<fieldset><legend>Servios no ve&iacute;culo</legend>
                <table width="100%" border="0" cellspacing="1" cellpadding="2">
            		<tr class="titulo_1">
              			<td nowrap align="center">Placa</td>
                        <td nowrap align="left">Atividade</td>
                        <td nowrap align="center">Posi&ccedil;&atilde;o</td>
                        <td nowrap align="center">Km Previs&atilde;o</td>
                        <td nowrap align="center">Alerta com</td>
                        <td nowrap align="center">Diferen&ccedil;a</td>
                        <td nowrap align="center">Data previs&atilde;o</td>
                        <td nowrap align="center">Alerta com</td>
                        <td nowrap align="center">Diferen&ccedil;a</td>
                        <td nowrap align="center">Status</td>
            		</tr>
            		<cfoutput query="qrServicos">
              		<tr class="linha_#(qrServicos.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrServicos.Currentrow Mod 2) + 1#';">
                        <td nowrap align="center">#qrServicos.COD_EQUIPAMENTO#</td>
                        <td nowrap align="left" <cfif qrServicos.IMPORTANCIA eq 3>title="Atividade de ALTA importncia" style="color: red;"</cfif>>#qrServicos.COD_ATIVIDADE#-#qrServicos.TITULO#</td>
                        <td nowrap align="center">#qrServicos.POSICAO#</td>
                        <cfif qrServicos.GARANTIA_KM gt 0>
                          <td align="center">#qrServicos.KM_PREVISAO#</td>
                          <td align="center">#qrServicos.ALERTA_KM#</td>
                          <td align="center">#qrServicos.KM_PREVISTO#</td>
                        <cfelse>
                          <td align="center" colspan="3">No Controlada</td>
                        </cfif>
                        <cfif qrServicos.GARANTIA_DIAS gt 0>
                          <td align="center">#LSDateFormat(qrServicos.DATA_PREVISAO)#</td>
                          <td align="center">#qrServicos.ALERTA_DIAS#</td>
                          <td align="center">#qrServicos.DIAS#</td>
                        <cfelse>
                          <td align="center" colspan="3">No Controlada</td>
                        </cfif>
                        <cfswitch expression="#qrServicos.STATUS_ID#">
                            <cfcase value="0">
                            	<cfset v_estilo = 'ok'>
                            </cfcase>
                            <cfcase value="1">
                            	<cfset v_estilo = 'ok'>
                            </cfcase>
                            <cfcase value="-1">
                            	<cfset v_estilo = 'a_vencer'>
                            </cfcase>
                            <cfcase value="-2">
                            	<cfset v_estilo = 'vencido'>
                            </cfcase>
                        </cfswitch>
                        <td nowrap align="center" class="#v_estilo#">#qrServicos.STATUS#</td>
              		</tr>
            		</cfoutput>
                    <cfif qrServicos.RecordCount eq 0>
                    <tr>
                        <td colspan="10" align="center" valign="middle" class="obrigatorio">Nenhum registro foi encontrado.</td>
                    </tr>
                    </cfif>
          		</table>
                </fieldset>
            </td>
        </tr>
        <tr>
    		<td>
				<fieldset><legend>Tabelas de manuten&ccedil;&atilde;o para o ve&iacute;culo</legend>
                <table width="100%" border="0" cellspacing="1" cellpadding="2">
            		<tr class="titulo_1">
              			<td nowrap align="center">Placa</td>
                        <td nowrap align="left">Tabela</td>
                        <td nowrap align="center">Obrigat&oacute;ria</td>
                        <td nowrap align="center">Atualiza Revis&atilde;o</td>
                        <td nowrap align="center">Km Previs&atilde;o</td>
                        <td nowrap align="center">Alerta com</td>
                        <td nowrap align="center">Diferen&ccedil;a</td>
                        <td nowrap align="center">Data previs&atilde;o</td>
                        <td nowrap align="center">Alerta com</td>
                        <td nowrap align="center">Diferen&ccedil;a</td>
                        <td nowrap align="center">Status</td>
            		</tr>
            		<cfoutput query="qrTabela">
              		<tr class="linha_#(qrTabela.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrTabela.Currentrow Mod 2) + 1#';">
                        <td nowrap align="center">#qrTabela.COD_EQUIPAMENTO#</td>
                        <td nowrap align="left">#qrTabela.TABELA#</td>
                        <td nowrap align="center"><cf_sim_nao>#qrTabela.OBRIGATORIA#</cf_sim_nao></td>
                        <td nowrap align="center"><cf_sim_nao>#qrTabela.ATUALIZA_REVISAO#</cf_sim_nao></td>
                        
						<cfif qrTabela.INTERVALO_KM gt 0>
                            <td align="center">#qrTabela.KM_PREVISAO#</td>
                            <td align="center">#qrTabela.ALERTA_KM#</td>
                            <td align="center">#qrTabela.KM_PREVISTO#</td>
                        <cfelse>
                        	<td align="center" colspan="3">No Controlada</td>
                        </cfif>
                        <cfif qrTabela.INTERVALO_DIAS gt 0>
                            <td align="center">#LSDateFormat(qrTabela.DATA_PREVISAO)#</td>
                            <td align="center">#qrTabela.ALERTA_DIAS#</td>
                            <td align="center">#qrTabela.DIAS_PREVISTO#</td>
                        <cfelse>
                        	<td align="center" colspan="3">No Controlada</td>
                        </cfif>    
                        <cfswitch expression="#qrTabela.STATUS_ID#">
                            <cfcase value="0">
                            	<cfset v_estilo = 'ok'>
                            </cfcase>
                            <cfcase value="1">
                            	<cfset v_estilo = 'ok'>
                            </cfcase>
                            <cfcase value="-1">
                            	<cfset v_estilo = 'a_vencer'>
                            </cfcase>
                            <cfcase value="-2">
                            	<cfset v_estilo = 'vencido'>
                            </cfcase>
                            <cfcase value="-3">
                            	<cfif qrTabela.OBRIGATORIA eq 1>
									<cfset v_estilo = 'vencido'>
                                <cfelse>
                                	<cfset v_estilo = 'a_vencer'>
                                </cfif>
                            </cfcase>
                        </cfswitch>
                        <td nowrap align="center" class="#v_estilo#">#qrTabela.STATUS#</td>
              		</tr>
            		</cfoutput>
                    <cfif qrTabela.RecordCount eq 0>
                    <tr>
                        <td colspan="11" align="center" valign="middle" class="obrigatorio">Nenhum registro foi encontrado.</td>
                    </tr>
                    </cfif>
          		</table>
                </fieldset>
            </td>
        </tr>
    </table>
</cfif>

<cfif IsDefined("vars.CONSULTA") and vars.CONSULTA eq 4>

	<cfscript>
			conn = CreateComponent("modulos.manutencao._componentes.consulta.almoxarifado.cfc_compras");
			qrTabelaPrecoFixo = conn.get_tabela_preco_fixo(cod_pessoa_fornecedor = vars.COD_PESSOA_OFICINA);
			
			v_material_id  = conn.ListaToArray(lista = vars, variavel = 'MATERIAL_ID_MATERIAL');
			v_atividade_id = conn.ListaToArray(lista = vars, variavel = 'ATIVIDADE_ID_ATIVIDADE');
			v_materiais	   = '';
			v_atividades   = '';
		</cfscript>

        <cfif qrTabelaPrecoFixo.RecordCount gt 0>
          <script>
		  	with(parent.document.forms[0]){
				parent.document.getElementById('sp_inf_of_preco_fixo').style.display = '';
				
				TABELA_PRECO_ID.value = '<cfoutput>#qrTabelaPrecoFixo.TABELA_ID#</cfoutput>';
				
				if(MATERIAL_ID.options.length > 1)
					parent.f_filtra_material();
				
				if(ATIVIDADE_ID.options.length > 1)
					parent.f_busca_atividade();
			}
		  </script>
         	<script type="text/javascript">
				var v_lista_material;
				var v_lista_atividade;
				var v_quantidade;
				var v_valor_sugerido;
				var v_valor_total;

				parent.f_set_read_only_valores('<cfoutput>#qrTabelaPrecoFixo.TABELA_ID#</cfoutput>');
			</script>
           
            <cfloop from="1" to="#ArrayLen(v_material_id)#" index="count_mat">
                <cfset v_materiais = v_materiais & v_material_id[count_mat] & ';' />
            </cfloop>
            <cfloop from="1" to="#ArrayLen(v_atividade_id)#" index="count_atv">
                <cfset v_atividades = v_atividades & v_atividade_id[count_atv] & ';' />
            </cfloop>
            
            <cfif Len(Trim(v_materiais))>
                <cfset v_materiais = Mid(v_materiais, 1, Len(v_materiais) - 1) />
            </cfif>
            <cfif Len(Trim(v_atividades))>
                <cfset v_atividades = Mid(v_atividades, 1, Len(v_atividades) - 1) />
            </cfif>
            
            <cfscript>
                if(Len(Trim(v_materiais))) {
                    qrVerificacaoMateriais  = conn.get_verificacao_tabela_materiais(tabela_id = qrTabelaPrecoFixo.TABELA_ID, material_id = v_materiais);
                }
                if(Len(Trim(v_atividades))) {
                    qrVerificacaoAtividades = conn.get_verificacao_tabela_atividades(tabela_id = qrTabelaPrecoFixo.TABELA_ID, atividade_id = v_atividades);
                }
            </cfscript>
            
            <cfif IsDefined("qrVerificacaoMateriais")>
                <cfoutput query="qrVerificacaoMateriais">
                    <script type="text/javascript">
						v_lista_material = parent.f_listagem_MATERIAL();
						v_valor_sugerido = '#JSStringFormat(qrVerificacaoMateriais.VALOR)#';
						
						for(var i = 0; i < v_lista_material.length; i++) {
							if(Number(v_lista_material[i].MATERIAL_ID) == #qrVerificacaoMateriais.MATERIAL_ID#) {
								if(!v_valor_sugerido) {
									parent.f_excluir_MATERIAL(v_lista_material[i].id, true);
								}
								else {
									
									v_valor_sugerido = Number(v_valor_sugerido).toFixed(2);
									v_quantidade = parent.document.getElementById('QUANTIDADE_MATERIAL_' + v_lista_material[i].id).value;
									v_valor_total = Number(v_quantidade) * Number(v_valor_sugerido);

									parent.document.getElementById('VALOR_UNITARIO_MATERIAL_' + v_lista_material[i].id).value = v_valor_sugerido;
									parent.document.getElementById('VALOR_TOTAL_MATERIAL_' + v_lista_material[i].id).value = Number(v_valor_total).toFixed(2);
									parent.document.getElementById('tr_lista_MATERIAL_' + v_lista_material[i].id).cells[7].innerText = v_valor_sugerido;
									parent.document.getElementById('tr_lista_MATERIAL_' + v_lista_material[i].id).cells[8].innerText = Number(v_valor_total).toFixed(2);
								}
							}
						}
                    </script>
                </cfoutput>
            </cfif>
            <script type="text/javascript">
				//parent.f_hide_carregando_ajax();
			</script>
            
            
            <cfif IsDefined("qrVerificacaoAtividades")>
                <cfoutput query="qrVerificacaoAtividades">
                    <script type="text/javascript">
						v_lista_atividade = parent.f_listagem_ATIVIDADE();
						v_valor_sugerido = '#JSStringFormat(qrVerificacaoAtividades.VALOR)#';
						
						for(var i = 0; i < v_lista_atividade.length; i++) {
							if(Number(v_lista_atividade[i].ATIVIDADE_ID) == #qrVerificacaoAtividades.ATIVIDADE_ID#) {
								if(!v_valor_sugerido) {
									parent.f_excluir_ATIVIDADE(v_lista_atividade[i].id, true);
								}
								else {
									v_valor_sugerido = Number(v_valor_sugerido).toFixed(4);
									//v_quantidade = parent.document.getElementById('ATIVIDADE_QUANTIDADE_ATIVIDADE_' + v_lista_atividade[i].id).value;
									//v_valor_total = Number(v_quantidade) * Number(v_valor_sugerido);
									
									parent.document.getElementById('ATV_VALOR_TOTAL_ATIVIDADE_' + v_lista_atividade[i].id).value = v_valor_sugerido;
									parent.document.getElementById('tr_lista_ATIVIDADE_' + v_lista_atividade[i].id).cells[3].innerText = Number(v_valor_sugerido).toFixed(2);
									//parent.document.getElementById('tr_lista_ATIVIDADE_' + v_lista_atividade[i].id).cells[7].innerText = Number(v_valor_total).toFixed(2);
								}
							}
						}
                    </script>
                </cfoutput>
            </cfif>
			
        <cfelse>
        	<script type="text/javascript">
				parent.document.getElementById('sp_inf_of_preco_fixo').style.display = 'none';
				parent.document.forms[0].TABELA_PRECO_ID.value = '';
				parent.f_set_read_only_valores('');
			</script>
        </cfif>
        
        <script type="text/javascript">
			parent.f_hide_carregando_ajax();
		</script>




</cfif>
