<cfscript>
	conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
	qrFechamento = conn.get_contrato_fechamento_relatorio(fechamento_id = vars.FECHAMENTO_ID);
	qrFechamentoDesconto = conn.get_contrato_fechamento_desconto(fechamento_id = vars.FECHAMENTO_ID);
</cfscript>
<cfdocument name="pdf_contrato" format="pdf">
      <style type="text/css">
      table {
          font-family:Verdana, Geneva, sans-serif;
      }
      .titulo_1 {
        font-size: 18px;
        font-weight: bold;
      }
      .titulo_2 {
        font-size: 11px;
        font-weight: bold;
      }  
      .texto {
        font-size: 10px;
      }
      .texto_negrito {
        font-size: 10px;
        font-weight:bold;
      }  
      .texto_eventos {
        font-size: 10px;
      }
      .texto_eventos_complemento {
        font-size: 10px;
        font-style:italic;
      }
	  
	  .linha_1 { 
        font-size: 10px;
	  	background-color:#EAEAEA;		  
	  }

	  .linha_2 { 
        font-size: 10px;
	  }
	  
	  .rodape {
	  	background-color:#D6D6D6;		  
		font-weight:bold;
		font-size:12px;
	  }
    </style>
<cfoutput query="qrFechamento" group="FECHAMENTO_ID">
      <body>
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td colspan="2"><table width="100%" border="0" cellpadding="2" cellspacing="0" class="texto">
            <tr>
              <td width="16%" rowspan="5" align="center" style="padding:10px"><img src="#session.caminho_img_logo#" ></td>
              <td width="29%" nowrap>#session.empresa.RAZAO_SOCIAL#</td>
              <td width="55%" align="right" style="padding-right:10px" nowrap>Emitido em: #LSDateFormat(Now())# #LSTimeFormat(Now())#</td>
            </tr>
            <tr>
              <td nowrap>#session.empresa.ENDERECO#</td>
              <td align="right" nowrap>&nbsp;</td>
            </tr>
            <tr>
              <td nowrap>#formataCpfCnpj(session.empresa.CNPJ)#</td>
              <td align="right" nowrap>&nbsp;</td>
            </tr> 
            <tr>
              <td colspan="2" nowrap><span class="texto_negrito">Usurio: #session.usuario#</span></td>
            </tr>
            <tr>
              <td nowrap>&nbsp;</td>
              <td align="right" nowrap style="padding-right:10px">Per&iacute;odo: #qrFechamento.DATA_INICIAL# at #qrFechamento.DATA_FINAL#</td>
            </tr>
          </table></td>
        </tr>
        <tr>
          <td colspan="2" style="border-top:2px ##000 solid">
          <table width="100%" border="0" cellspacing="0" cellpadding="3" class="texto">
            <tr class="titulo_2">
              <td style="border-bottom:1px ##000 solid">Equipamento</td>
              <td style="border-bottom:1px ##000 solid" align="center">KM Inicial</td>
              <td style="border-bottom:1px ##000 solid" align="center">KM Final</td>
              <td style="border-bottom:1px ##000 solid" align="center">KM Rodado</td>
              <td style="border-bottom:1px ##000 solid" align="center">Faixa</td>
              <td style="border-bottom:1px ##000 solid" align="right">Valor KM</td>
              <td style="border-bottom:1px ##000 solid" align="right">Valor Total</td>
            </tr>
            <cfoutput>
                <tr class="linha_#(qrFechamento.currentrow mod 2)+1#">
                  <td>#qrFechamento.COD_EQUIPAMENTO#</td>
                  <td align="center">#qrFechamento.KM_INICIAL#</td>
                  <td align="center">#qrFechamento.KM_FINAL#</td>
                  <td align="center">#qrFechamento.KM_RODADO#</td>
                  <td align="center">#qrFechamento.NUM_FAIXA#</td>
                  <td align="right">#qrFechamento.VALOR_KM#</td>
                  <td align="right">#LSNumberFormat(qrFechamento.TOTAL,',.__')#</td>                  
                </tr>
            </cfoutput>
            <tr class="rodape">
              <td style="border-bottom:1px ##000 solid">&nbsp;</td>
              <td style="border-bottom:1px ##000 solid" align="center">&nbsp;</td>
              <td style="border-bottom:1px ##000 solid" align="center">&nbsp;</td>
              <td style="border-bottom:1px ##000 solid" align="center">#ArraySum(ListToArray(ValueList(qrFechamento.KM_RODADO)))#</td>
              <td style="border-bottom:1px ##000 solid" align="center">&nbsp;</td>
              <td style="border-bottom:1px ##000 solid" align="right">#LSNumberFormat(ArraySum(ListToArray(ValueList(qrFechamento.TOTAL)))/ArraySum(ListToArray(ValueList(qrFechamento.KM_RODADO))),',.____')#</td>
              <td style="border-bottom:1px ##000 solid" align="right">#LSNumberFormat(ArraySum(ListToArray(ValueList(qrFechamento.TOTAL))),',.__')#</td>
            </tr>
          </table></td>
        </tr>
        <tr>
          <td class="titulo_2" colspan="2" align="center" style="padding:5px; border-bottom:1px ##000 solid; border-top:1px ##000 solid;">Descri&ccedil;&atilde;o dos Descontos</td>
        </tr>
        <tr>
          <td class="titulo_2" style="padding-right:15px; text-align:center">
          <table width="100%" border="0" cellspacing="0" cellpadding="3">
            <tr class="titulo_2">
              <td width="11%" align="center" nowrap>Num.Nota</td>
              <td width="11%" align="center" nowrap>Data emiss&atilde;o</td>
              <td width="10%" align="center" nowrap>Frota</td>
              <td width="55%" nowrap>Emitente</td>
              <td width="13%" align="right" nowrap>Valor</td>
            </tr>
            <cfloop query="qrFechamentoDesconto">
                <tr class="linha_#(qrFechamentoDesconto.currentrow mod 2)+1#">
                  <td align="center" nowrap>#qrFechamentoDesconto.NUM_NOTA_FISCAL#</td>
                  <td align="center" nowrap>#qrFechamentoDesconto.DATA_EMISSAO#</td>
                  <td align="center" nowrap>#qrFechamentoDesconto.COD_VEICULO#</td>
                  <td nowrap>#formataCpfCnpj(qrFechamentoDesconto.EMIT_CNPJ_CPF)# - #qrFechamentoDesconto.EMIT_RAZAO_SOCIAL#</td>
                  <td align="right" nowrap>#LSNumberFormat(qrFechamentoDesconto.VALOR_DESCONTO,',.__')#</td>
                </tr>
            </cfloop>
                <tr class="rodape">
                  <td height="22" colspan="4" align="center" nowrap>&nbsp;</td>
                  <td align="right" style="padding-right:2px" nowrap>#LSNumberFormat(ArraySum(ListToArray(ValueList(qrFechamentoDesconto.VALOR_DESCONTO))),',.__')#</td>
                </tr>
          </table>
          </td>
        </tr>
		<tr>
          <td colspan="2" style="border-top:1px ##000 solid">
          <p>&nbsp;</p>
          <table width="126" border="0" cellspacing="1" cellpadding="2" class="texto">
            <tr>
              <td colspan="2" align="center" valign="bottom" class="titulo_1" style="padding:5px; border-bottom:1px ##000 solid">Total</td>
            </tr>
            <tr>
              <td width="104" valign="bottom" class="titulo_2">Acordo:</td>
              <td width="11" align="right" valign="bottom">#LSNumberFormat(qrFechamento.VALOR_ACORDO,',.__')#</td>
            </tr>
            <tr>
              <td valign="bottom" class="titulo_2">Desconto:</td>
              <td align="right" valign="bottom">#LSNumberFormat(qrFechamento.DESCONTO,',.__')#</td>
            </tr>
            <tr>
              <td valign="bottom" nowrap class="titulo_2">Total acordo:</td>
              <td align="right" valign="bottom" class="titulo_1">#LSNumberFormat(qrFechamento.TOTAL_ACORDO,',.__')#</td>
            </tr>
          </table></td>
        </tr>        
      </table>
    </body>
</cfoutput>
 
</cfdocument>

<cfset path = ExpandPath("/" & session.site & "/upload/temp")>
<cfpdf action="merge" destination="#path#/contrato#vars.fechamento_id#.pdf" overwrite="yes">
	<cfpdfparam source="pdf_contrato" />
</cfpdf>
<script>
  window.location = '/<cfoutput>#session.site#</cfoutput>/upload/temp/contrato<cfoutput>#vars.fechamento_id#</cfoutput>.pdf';
</script>