<cfcomponent extends="_transportes.funcoes.cfc_init">
  <!---
	-- PROPSITO
	-- Insere registros nalista temp
	-- Luiz 16/05/2017 - CRIADO
	--->
    <cffunction name='ins_lista_temp' displayname='Inserir registros na lista temporria' access='remote' returntype='Struct' output='true'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
           <cfstoredproc procedure='kss.pkg_lista_temp.prc_ins_lista_temp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
			  <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'    value='#arguments.TIPO#' >
           </cfstoredproc>
           <cfset retorno.erro = false>
           <cfset retorno.mensagem = JSStringFormat('Itens inseridos com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>


	<!---
	-- PROPSITO
	-- Insere modelo de equipamento
	-- guto 01/08/2006 16:29:52 - CRIADO
	--->
	<cffunction name='ins_modelo' displayname='Insere modelo de equipamento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#' variable='retorno.MODELO_ID'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modelo de equipamento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Altera modelo de equipamento
	-- guto 01/08/2006 16:31:13 - CRIADO
	--->
	<cffunction name='alt_modelo' displayname='Altera modelo de equipamento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modelo de equipamento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui modelo de equipamento
	-- guto 01/08/2006 16:32:27 - CRIADO
	--->
	<cffunction name='del_modelo' displayname='Exclui modelo de equipamento' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MODELO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Modelo de equipamento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere vnculo entre equipamento e programa
	-- arlen 09/10/2006 09:46:07 - CRIADO
	--->
	<cffunction name='ins_equipamento_modelo' displayname='Insere vnculo entre equipamento e programa' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='DATA_INICIAL' required='yes'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
                <cfset lista_equipamento_id = arguments.EQUIPAMENTO_ID>
				<cfloop list="#lista_equipamento_id#" index="equip" delimiters=",">
                    <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_equipamento_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER'  >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#equip#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIAL#' >
                        <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#' variable='retorno.CONTROLE_ID'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    </cfstoredproc>
                </cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Equipamento vinculado ao programa com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Coloca uma data final para fechamento do vnculo entre equipamento e modelo
	-- arlen 09/10/2006 09:49:59 - CRIADO
	--->
	<cffunction name='fecha_equipamento_modelo' displayname='Coloca uma data final para o vnculo entre equipamento e programa' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='DATA_FINAL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_fecha_equipamento_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER'  >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FINAL#' >
                </cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('vnculo entre equipamento e programa alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Altera o vnculo entre equipamento e programa
	-- FERNANDAB 10/09/2015 - CRIADO
	--->
	<cffunction name='alt_equipamento_modelo' displayname='Altera o vnculo entre equipamento e programa' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_equipamento_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER'  >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODELO_ID#' >
                </cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vnculo entre equipamento e programa alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Exclui o vnculo entre o equipamento e o modelo
	-- arlen 09/10/2006 09:52:59 - CRIADO
	--->
	<cffunction name='del_equipamento_modelo' displayname='Exclui o vnculo entre o equipamento e o programa' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_equipamento_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER'  >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('vnculo entre equipamento e programa excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Insere um grupo de atividades
    -- ANDERSONC 18/11/2009 17:15:01 - CRIADO
    --->
    <cffunction name='ins_atv_grupo' displayname='Insere um grupo de atividade' access='remote' returntype='Struct' output='true'>
        <cfargument name='GRUPO_ID' required='yes'>
        <cfargument name='GRUPO_ID_PAI' required='no' default="">
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_atividade_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRUPO_ID#' variable='retorno.GRUPO_ID'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRUPO_ID_PAI#'  null='#iif(len(trim(arguments.GRUPO_ID_PAI)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Grupo para atividades inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Altera um grupo de atividades
    -- ANDERSONC 18/11/2009 17:17:30 - CRIADO
    --->
    <cffunction name='alt_atv_grupo' displayname='Altera um grupo de atividades' access='remote' returntype='Struct' output='true'>
        <cfargument name='GRUPO_ID' required='yes'>
        <cfargument name='GRUPO_ID_PAI' required='no' default="">
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_atividade_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRUPO_ID_PAI#'  null='#iif(len(trim(arguments.GRUPO_ID_PAI)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Grupo para atividades alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
	-- PROPSITO
	-- Exclui atividade de grupo.
	-- ARLEN 04/10/2006 16:48:34 - CRIADO
	--->
	<cffunction name='del_atv_grupo' displayname='Exclui atividade de grupo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='GRUPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_atividade_grupo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER'  >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Grupo para atividades excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere compartimento de veculo.
	-- ARLEN 03/10/2006 13:48:46 - CRIADO
	--->
	<cffunction name='ins_atv_compartimento' displayname='Insere compartimento de veculo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ORDEM' required='yes'>
		<cfargument name='COMPARTIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_atv_compartimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER'  >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ORDEM#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPARTIMENTO_ID#' variable='retorno.COMPARTIMENTO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Compartimento inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera compartimento de veculo.
	-- ARLEN 03/10/2006 13:55:22 - CRIADO
	--->
	<cffunction name='upd_atv_compartimento' displayname='Altera compartimento de veculo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COMPARTIMENTO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ORDEM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_atv_compartimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER'  >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPARTIMENTO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ORDEM#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Compartimento alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>


				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui compartimento de veculo.
	-- ARLEN 03/10/2006 14:09:55 - CRIADO
	--->
	<cffunction name='del_atv_compartimento' displayname='Exclui compartimento de veculo.' access='remote' returntype='Struct' output='true'>
		<cfargument name='COMPARTIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_atv_compartimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER'  >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPARTIMENTO_ID#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Compartimento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere Especialidade
	-- guto 01/08/2006 16:49:28 - CRIADO
	--->
	<cffunction name='ins_recurso_especialidade' displayname='Insere Especialidade' access='remote' returntype='Struct' output='true'>;
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ESPECIALIDADE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_recurso_especialidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ESPECIALIDADE_ID#' variable='retorno.ESPECIALIDADE_ID'  null='#iif(len(trim(arguments.ESPECIALIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Especialidade inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera Especialidade
	-- guto 01/08/2006 16:50:04 - CRIADO
	--->
	<cffunction name='alt_recurso_especialidade' displayname='Altera Especialidade' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ESPECIALIDADE_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_recurso_especialidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ESPECIALIDADE_ID#'  null='#iif(len(trim(arguments.ESPECIALIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Especialidade alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui Especialidade
	-- guto 01/08/2006 16:50:33 - CRIADO
	--->
	<cffunction name='del_recurso_especialidade' displayname='Exclui Especialidade' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ESPECIALIDADE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_recurso_especialidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ESPECIALIDADE_ID#'  null='#iif(len(trim(arguments.ESPECIALIDADE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Especialidade excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere posio
	-- guto 22/09/2006 14:05:10 - CRIADO
	--->
	<cffunction name='ins_equipamento_posicao' displayname='Insere posio' access='remote' returntype='Struct' output='true'>
		<cfargument name='POSICAO' required='yes'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_equipamento_posicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.POSICAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#' variable='retorno.POSICAO_ID'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('posio inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Altera posio
	-- guto 22/09/2006 14:05:57 - CRIADO
	--->
	<cffunction name='upd_equipamento_posicao' displayname='Altera posio' access='remote' returntype='Struct' output='true'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cfargument name='POSICAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_equipamento_posicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.POSICAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('posio alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui posio
	-- guto 22/09/2006 14:06:33 - CRIADO
	--->
	<cffunction name='del_equipamento_posicao' displayname='Exclui posio' access='remote' returntype='Struct' output='true'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_equipamento_posicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('posio excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Altera as posies de um material
	-- arlen 17/10/2006 09:08:26 - CRIADO
	--->
	<cffunction name='upd_material' displayname='Altera as posies de um material' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='MATERIAL_PAI' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<!--- Insere os itens para atributo do tipo LISTA --->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ATRIBUTOS");
					v_posicao_id = this.ListaToArray (lista = arguments, variavel = "POSICAO_ID_ATRIBUTOS");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ATRIBUTOS, lista2 = ArrayToList(v_posicao_id));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_posicao_material(	material_id = arguments.material_id,
													posicao_id = l_item_id);
					</cfscript>
				</cfloop>

				<cfloop from="1" to="#ArrayLen(v_posicao_id)#" index="count">
				    <cfif Len(Trim(v_item_id[count]))>
						<cfscript>
							this.upd_posicao_material(item_id = v_item_id[count],
							                          material_id = arguments.material_id,
													  posicao_id = v_posicao_id[count]	);
						</cfscript>
					<cfelse>
						<cfscript>
							this.ins_posicao_material(material_id = arguments.material_id,
													  posicao_id = v_posicao_id[count]	);
						</cfscript>
					</cfif>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('posies do material alteradas com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere posio para um material.
	-- arlen 13/10/2006 16:27:15 - CRIADO
	--->
	<cffunction name='ins_posicao_material' displayname='Insere posio para um material.' access='remote' returntype='Struct' output='true'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='no' default="0">
			<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_posicao_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='MODE' cfsqltype='CF_SQL_INTEGER'  >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera posio de um material
	-- arlen 17/10/2006 14:05:57 - CRIADO
	--->
	<cffunction name='upd_posicao_material' displayname='Altera posio de Material' access='remote' returntype='Struct' output='true'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cfargument name='ITEM_ID' required='no' default="0">
			<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_posicao_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#' null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui posio de um material.
	-- arlen 16/10/2006 16:32:18 - CRIADO
	--->
	<cffunction name='del_posicao_material' displayname='Exclui posio de um material.' access='remote' returntype='Struct' output='true'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='POSICAO_ID' required='yes'>
			<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_posicao_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
		<cfreturn StructNew() />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere um novo processo
	-- guto 01/08/2006 16:33:24 - CRIADO
	--->
	<cffunction name='ins_processo' displayname='Insere um novo processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DETALHAMENTO' required='yes'>
		<cfargument name='TEMPO_EXECUCAO_HORAS' required='yes'>
		<cfargument name='TEMPO_EXECUCAO_MINUTOS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar'   value='#arguments.DETALHAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TEMPO_EXECUCAO_HORAS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TEMPO_EXECUCAO_MINUTOS#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROCESSO_ID#' variable='retorno.PROCESSO_ID'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfscript>
				  // Recursos
				  v_percentual_participacao = this.ListaToArray (lista = arguments, variavel = "PERCENTUAL_PARTICIPACAO_RECURSO");
				  v_especialidade_id = this.ListaToArray (lista = arguments, variavel = "ESPECIALIDADE_ID_RECURSO");
				  v_nivel_id = this.ListaToArray (lista = arguments, variavel = "NIVEL_ID_RECURSO");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_especialidade_id)#" index="count">
					<cfscript>
						this.ins_processo_recurso_private( processo_id = retorno.processo_id,
													         	  especialidade_id = v_especialidade_id[count],
														           nivel_id         = v_nivel_id[count],
														           quantidade       = 1,
																	  percentual_participacao = v_percentual_participacao[count]);

					</cfscript>
				</cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Processo inserido com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!---
	-- PROPSITO
	-- Altera um novo processo
	-- guto 01/08/2006 16:34:09 - CRIADO
	--->
	<cffunction name='alt_processo' displayname='Altera um novo processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='DETALHAMENTO' required='yes'>
		<cfargument name='TEMPO_EXECUCAO_HORAS' required='yes'>
		<cfargument name='TEMPO_EXECUCAO_MINUTOS' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar'   value='#arguments.DETALHAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TEMPO_EXECUCAO_HORAS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TEMPO_EXECUCAO_MINUTOS#' >
				</cfstoredproc>
				<cfscript>
				  // Recursos
				  v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_RECURSO");
				  v_percentual_participacao = this.ListaToArray (lista = arguments, variavel = "PERCENTUAL_PARTICIPACAO_RECURSO");
				  v_especialidade_id = this.ListaToArray (lista = arguments, variavel = "ESPECIALIDADE_ID_RECURSO");
				  v_nivel_id = this.ListaToArray (lista = arguments, variavel = "NIVEL_ID_RECURSO");
				  v_recurso_excluir = this.ListDiff(lista1 = arguments.lista_deleted_RECURSO, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_recurso_excluir#" delimiters="," index="l_item_id">
					<cfscript>
					   this.del_processo_recurso_private(item_id = l_item_id);
					</cfscript>
				</cfloop>
				<cfloop from="1" to="#ArrayLen(v_especialidade_id)#" index="count">
					<cfscript>
						if(not len(trim(v_item_id[count]))) {
							//caso o v_processo_id seja nulo insere
							this.ins_processo_recurso_private( processo_id      = arguments.processo_id,
																		  especialidade_id = v_especialidade_id[count],
																		  nivel_id         = v_nivel_id[count],
																		  quantidade       = 1,
																		  percentual_participacao = v_percentual_participacao[count]);
						} else {
							//senao altera
							this.alt_processo_recurso_private( item_id          = v_item_id[count],
							                                   processo_id      = arguments.processo_id,
																		  especialidade_id = v_especialidade_id[count],
																		  nivel_id         = v_nivel_id[count],
																		  quantidade       = 1,
																		  percentual_participacao = v_percentual_participacao[count]);
						}

					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Processo alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	<!---
	-- PROPSITO
	-- Exclui processo
	-- guto 01/08/2006 16:37:48 - CRIADO
	--->
	<cffunction name='del_processo' displayname='Exclui processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Processo excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	<!---
	-- PROPSITO
	-- Insere processo recurso (ESPECIALIDADE) - Private
	-- guto 01/08/2006 16:40:05 - CRIADO
	--->
	<cffunction name='ins_processo_recurso_private' displayname='Insere processo recurso (ESPECIALIDADE)' access='remote' output='false'>;
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='ESPECIALIDADE_ID' required='yes'>
		<cfargument name='NIVEL_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PERCENTUAL_PARTICIPACAO' required='yes'>
		<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_processo_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ESPECIALIDADE_ID#'  null='#iif(len(trim(arguments.ESPECIALIDADE_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERCENTUAL_PARTICIPACAO#'  null='#iif(len(trim(arguments.PERCENTUAL_PARTICIPACAO)), de('no'), de('yes'))#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   null='yes' variable="retorno.ITEM_ID">
			<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
		</cfstoredproc>
	</cffunction>
	<!---
	-- PROPSITO
	-- Altera vinculo do processo com o recurso (ESPECIALIDADE) Private
	-- guto 01/08/2006 16:41:10 - CRIADO
	--->
	<cffunction name='alt_processo_recurso_private' displayname='Altera vinculo do processo com o recurso (ESPECIALIDADE)' access='remote' output='false'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='ESPECIALIDADE_ID' required='yes'>
		<cfargument name='NIVEL_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='PERCENTUAL_PARTICIPACAO' required='yes'>
			<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_processo_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ESPECIALIDADE_ID#'  null='#iif(len(trim(arguments.ESPECIALIDADE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERCENTUAL_PARTICIPACAO#'  null='#iif(len(trim(arguments.PERCENTUAL_PARTICIPACAO)), de('no'), de('yes'))#'>
			</cfstoredproc>
	</cffunction>
	<!---
	-- PROPSITO
	-- Exclui vinculo do recurso com o processo - PRIVATE
	-- guto 01/08/2006 16:42:15 - CRIADO
	--->
	<cffunction name='del_processo_recurso_private' displayname='Exclui vinculo do recurso com o processo' access='remote' output='false'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_processo_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
			<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
		</cfstoredproc>
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere Atividade
	-- guto 01/08/2006 16:17:20 - CRIADO
	--->
	<cffunction name='ins_atividade' displayname='Insere Atividade' access='remote' returntype='Struct' output='true'>;
		<cfargument name='COD_ATIVIDADE' required='no' default="">
		<cfargument name='TITULO' required='yes'>
		<cfargument name='TEMPO_EXECUCAO_HORAS' required='yes'>
		<cfargument name='TEMPO_EXECUCAO_MINUTOS' required='yes'>
		<cfargument name='MULTIPLO' required='no' default="0">
		<cfargument name='GRUPO_ID' required='no' default="">
		<cfargument name='COMPARTIMENTO_ID' required='no' default="">
		<cfargument name='TIPO_ID' required='no' default="">
		<cfargument name='IMPORTANCIA' required='no' default="">
		<cfargument name='VERIFICACAO' required='no' default="">
		<cfargument name='GARANTIA_KM' required='no' default="0">
		<cfargument name='GARANTIA_HORAS_TRABALHADAS' required='no' default="0">
		<cfargument name='GARANTIA_DIAS' required='no' default="0">
		<cfargument name='GARANTIA_LTS_COMBUSTIVEL' required='no' default="0">
		<cfargument name='ALERTA_KM' required='no' default="0">
		<cfargument name='ALERTA_HORAS_TRABALHADAS' required='no' default="0">
		<cfargument name='ALERTA_DIAS' required='no' default="0">
		<cfargument name='ALERTA_LTS_COMBUSTIVEL' required='no' default="0">
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='NIVEL_ID' required='no' default="0">
		<cfargument name='TEMPO_INDEFINIDO' required='no' default="0">
        <cfargument name='ATIVO' required='no' default="1">
		<cfargument name='MATERIAL_ID' required='no' default="">
        <cfargument name='MATERIAL_ID_PAI' required='no' default="">

		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ATIVIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='00 #arguments.TEMPO_EXECUCAO_HORAS#:#arguments.TEMPO_EXECUCAO_MINUTOS#:00' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MULTIPLO#'  null='#iif(len(trim(arguments.MULTIPLO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COMPARTIMENTO_ID#'  null='#iif(len(trim(arguments.COMPARTIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPORTANCIA#'  null='#iif(len(trim(arguments.IMPORTANCIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VERIFICACAO#'  null='#iif(len(trim(arguments.VERIFICACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_KM#'  null='#iif(len(trim(arguments.GARANTIA_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.GARANTIA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_DIAS#'  null='#iif(len(trim(arguments.GARANTIA_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.GARANTIA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_KM#'  null='#iif(len(trim(arguments.ALERTA_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.ALERTA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_DIAS#'  null='#iif(len(trim(arguments.ALERTA_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.ALERTA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TEMPO_INDEFINIDO#'  null='#iif(len(trim(arguments.TEMPO_INDEFINIDO)), de('no'), de('yes'))#'>	
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#' variable='retorno.ATIVIDADE_ID'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
			        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID_PAI#'  null='#iif(len(trim(arguments.MATERIAL_ID_PAI)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfif arguments.multiplo neq 0>
					<cfscript>
					  // Posicoes
					  v_posicao_id = this.ListaToArray (lista = arguments, variavel = "POSICAO_ID_POSICOES");
					  // Tipo oficina
					  v_tipo_id = this.ListaToArray (lista = arguments, variavel = "OFICINA_TIPO_ID_TIPO");
					</cfscript>
					<cfloop from="1" to="#ArrayLen(v_posicao_id)#" index="count">
						<cfscript>
								//caso o v_processo_id seja nulo insere
								this.ins_atividade_posicao( atividade_id = retorno.atividade_id,
														    posicao_id   = v_posicao_id[count]);
						</cfscript>
					</cfloop>
				</cfif>

				<cfscript>
					  // Atividade dependencia
					  v_atividade_id_principal = this.ListaToArray (lista = arguments, variavel = "ATIVIDADE_ID_PRINCIPAL_ATIVIDADE_DEPENDENCIA");
					  v_obrigatoria = this.ListaToArray (lista = arguments, variavel = "OBRIGATORIA_ATIVIDADE_ATIVIDADE_DEPENDENCIA");
				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_atividade_id_principal)#" index="count">
					<cfscript>
							//caso o v_processo_id seja nulo insere
							this.ins_atividade_dependencia( atividade_id_principal = retorno.atividade_id,
																	  atividade_id_dependente  = v_atividade_id_principal[count],
																	  obrigatoria = v_obrigatoria[count]);
					</cfscript>
				</cfloop>

				<cfscript>
					  // Atividade CONUJUGADA
					  v_atividade_id_conjugada = this.ListaToArray (lista = arguments, variavel = "ATIVIDADE_ID_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_obrigatoria_conjugada = this.ListaToArray (lista = arguments, variavel = "OBRIGATORIA_ATIVIDADE_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_garantia_km           = this.ListaToArray (lista = arguments, variavel = "GARANTIA_KM_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_garantia_dias 		  = this.ListaToArray (lista = arguments, variavel = "GARANTIA_DIAS_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_garantia_horas	      = this.ListaToArray (lista = arguments, variavel = "GARANTIA_HORAS_TRABALHADAS_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_garantia_lts_combustivel = this.ListaToArray (lista = arguments, variavel = "GARANTIA_LTS_COMBUSTIVEL_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_alerta_km	             = this.ListaToArray (lista = arguments, variavel = "ALERTA_KM_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_alerta_dias              = this.ListaToArray (lista = arguments, variavel = "ALERTA_DIAS_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_alerta_horas             = this.ListaToArray (lista = arguments, variavel = "ALERTA_HORAS_TRABALHADAS_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_alerta_lts_combustivel   = this.ListaToArray (lista = arguments, variavel = "ALERTA_LTS_COMBUSTIVEL_CONJUGADA_ATIVIDADE_CONJUGADA");
				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_atividade_id_conjugada)#" index="count">
					<cfscript>
							//caso o v_processo_id seja nulo insere
							ins_conjugada = this.ins_atividade_conjugada( atividade_id_principal = retorno.atividade_id,
														  atividade_id_conjugada = v_atividade_id_conjugada[count],
														  obrigatoria = v_obrigatoria_conjugada[count],
														  garantia_km = v_garantia_km[count],
														  garantia_dias = v_garantia_dias[count],
														  garantia_horas_trabalhadas = v_garantia_horas[count],
														  garantia_lts_combustivel = v_garantia_lts_combustivel[count],
														  alerta_km = v_alerta_km[count],
														  alerta_dias = v_alerta_dias[count],
														  alerta_horas_trabalhadas = v_alerta_horas[count],
														  alerta_lts_combustivel = v_alerta_lts_combustivel[count]);
					</cfscript>
                    <cfif ins_conjugada.erro>
                    	<cfthrow object="ins_conjugada.mensagem">
                    </cfif>
				</cfloop>

				<cfscript>
				  // Tipo oficina
				  v_tipo_id = this.ListaToArray (lista = arguments, variavel = "OFICINA_TIPO_ID_TIPO");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_tipo_id)#" index="count">
					<cfscript>
						this.ins_atividade_oficina_tipo(atividade_id = retorno.atividade_id,
						                                tipo_id = v_tipo_id[count] );
					</cfscript>
				</cfloop>

				<cfscript>
				  // Processos
				  v_processo = this.ListaToArray (lista = arguments, variavel = "PROCESSO_PROCESSOS");
				  v_processo_id = this.ListaToArray (lista = arguments, variavel = "PROCESSO_ID_PROCESSOS");
				  v_ordem = this.ListaToArray (lista = arguments, variavel = "ORDEM_PROCESSOS");
				  v_item_pai = this.ListaToArray (lista = arguments, variavel = "ITEM_PAI_PROCESSOS");
				  v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_PROCESSOS");
					v_ar = structnew();
					v_ar[0] = '';

				</cfscript>

				<cfloop from="1" to="#ArrayLen(v_processo)#" index="count">
					<cfscript>
						conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
						qrProcesso = conn.get_processo(titulo = v_processo[count]);
						// Busca o identificador do processo
					</cfscript>
					<cfif qrProcesso.recordcount>
						<cfset retorno.processo_id = qrProcesso.processo_id>
					<cfelse>
						<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#v_processo[count]#' >
							<cfprocparam type='IN' cfsqltype='cf_sql_varchar'   value='' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value="0" >
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value="0" >
							<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   null="yes" variable='retorno.PROCESSO_ID'>
							<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
						</cfstoredproc>
					</cfif>
					<cfscript>
						ret = this.ins_atividade_processo(atividade_id = retorno.atividade_id,
															processo_id = retorno.processo_id,
															item_pai = v_ar[v_item_pai[count]],
															ordem = v_ordem[count]);
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
					<cfscript>
						v_ar[v_item_id[count]] = ret.item_id;
					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera Atividade
	-- guto 01/08/2006 16:18:04 - CRIADO
	--->
	<cffunction name='upd_atividade' displayname='Altera Atividade' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='COD_ATIVIDADE' required='no' default="">
		<cfargument name='TITULO' required='yes'>
		<cfargument name='TEMPO_EXECUCAO_HORAS' required='yes'>
		<cfargument name='TEMPO_EXECUCAO_MINUTOS' required='yes'>
		<cfargument name='MULTIPLO' required='no' default="0">
		<cfargument name='GRUPO_ID' required='no' default="">
		<cfargument name='COMPARTIMENTO_ID' required='no' default="">
		<cfargument name='TIPO_ID' required='no' default="">
		<cfargument name='IMPORTANCIA' required='no' default="">
		<cfargument name='VERIFICACAO' required='no' default="">
		<cfargument name='GARANTIA_KM' required='no' default="0">
		<cfargument name='GARANTIA_HORAS_TRABALHADAS' required='no' default="0">
		<cfargument name='GARANTIA_DIAS' required='no' default="0">
		<cfargument name='GARANTIA_LTS_COMBUSTIVEL' required='no' default="0">
		<cfargument name='ALERTA_KM' required='no' default="0">
		<cfargument name='ALERTA_HORAS_TRABALHADAS' required='no' default="0">
		<cfargument name='ALERTA_DIAS' required='no' default="0">
		<cfargument name='ALERTA_LTS_COMBUSTIVEL' required='no' default="0">
		<cfargument name='NIVEL_ID' required='no' default="0">
		<cfargument name='TEMPO_INDEFINIDO' required='no' default="0">
      <cfargument name='ATIVO' required='no' default="1">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ATIVIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='00 #arguments.TEMPO_EXECUCAO_HORAS#:#arguments.TEMPO_EXECUCAO_MINUTOS#:00' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MULTIPLO#'  null='#iif(len(trim(arguments.MULTIPLO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRUPO_ID#'  null='#iif(len(trim(arguments.GRUPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COMPARTIMENTO_ID#'  null='#iif(len(trim(arguments.COMPARTIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPORTANCIA#'  null='#iif(len(trim(arguments.IMPORTANCIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VERIFICACAO#'  null='#iif(len(trim(arguments.VERIFICACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_KM#'  null='#iif(len(trim(arguments.GARANTIA_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.GARANTIA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_DIAS#'  null='#iif(len(trim(arguments.GARANTIA_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.GARANTIA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_KM#'  null='#iif(len(trim(arguments.ALERTA_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.ALERTA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_DIAS#'  null='#iif(len(trim(arguments.ALERTA_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.ALERTA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TEMPO_INDEFINIDO#'  null='#iif(len(trim(arguments.TEMPO_INDEFINIDO)), de('no'), de('yes'))#'>
               <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVO#'  null='#iif(len(trim(arguments.ATIVO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Insere os itens para atributo do tipo LISTA --->
				<cfscript>
					v_posicao_id = this.ListaToArray (lista = arguments, variavel = "POSICAO_ID_POSICOES");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_POSICOES, lista2 = ArrayToList(v_posicao_id));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_atividade_posicao(atividade_id = arguments.atividade_id,
						                           posicao_id   = l_item_id);
					</cfscript>
				</cfloop>

				<cfscript>
					  // Atividade dependencia
					  v_atividade_id_principal = this.ListaToArray (lista = arguments, variavel = "ATIVIDADE_ID_PRINCIPAL_ATIVIDADE_DEPENDENCIA");
					  v_obrigatoria = this.ListaToArray (lista = arguments, variavel = "OBRIGATORIA_ATIVIDADE_ATIVIDADE_DEPENDENCIA");
					  v_excluir_dependencia = this.ListDiff(lista1 = arguments.lista_deleted_ATIVIDADE_DEPENDENCIA, lista2 = ArrayToList(v_atividade_id_principal));
				</cfscript>

				<!--- Excluir os itens --->
				<cfloop list="#v_excluir_dependencia#" delimiters="," index="l_item_id">
					<cfscript>
						this.del_atividade_dependencia(atividade_id_principal = arguments.atividade_id,
						                               atividade_id_dependente = l_item_id);
					</cfscript>
				</cfloop>

				<cfloop from="1" to="#ArrayLen(v_atividade_id_principal)#" index="count">
					<cfscript>
							//caso o v_processo_id seja nulo insere
							this.ins_atividade_dependencia( atividade_id_principal = arguments.atividade_id,
																	  atividade_id_dependente  = v_atividade_id_principal[count],
																	  obrigatoria = v_obrigatoria[count]);
					</cfscript>
				</cfloop>

				<cfscript>
					  // Atividade CONUJUGADA
					  v_atividade_id_conjugada = this.ListaToArray (lista = arguments, variavel = "ATIVIDADE_ID_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_obrigatoria_conjugada = this.ListaToArray (lista = arguments, variavel = "OBRIGATORIA_ATIVIDADE_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_garantia_km           = this.ListaToArray (lista = arguments, variavel = "GARANTIA_KM_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_garantia_dias 		  = this.ListaToArray (lista = arguments, variavel = "GARANTIA_DIAS_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_garantia_horas	      = this.ListaToArray (lista = arguments, variavel = "GARANTIA_HORAS_TRABALHADAS_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_garantia_lts_combustivel = this.ListaToArray (lista = arguments, variavel = "GARANTIA_LTS_COMBUSTIVEL_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_alerta_km	             = this.ListaToArray (lista = arguments, variavel = "ALERTA_KM_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_alerta_dias              = this.ListaToArray (lista = arguments, variavel = "ALERTA_DIAS_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_alerta_horas             = this.ListaToArray (lista = arguments, variavel = "ALERTA_HORAS_TRABALHADAS_CONJUGADA_ATIVIDADE_CONJUGADA");
					  v_alerta_lts_combustivel   = this.ListaToArray (lista = arguments, variavel = "ALERTA_LTS_COMBUSTIVEL_CONJUGADA_ATIVIDADE_CONJUGADA");
				</cfscript>

                <cfscript>
					// Exclui vinculos
					del_conjugada = this.del_atividade_conjugada( atividade_id_principal = arguments.atividade_id);
				</cfscript>
				<cfif del_conjugada.erro>
                    <cfthrow object="del_conjugada.mensagem">
                </cfif>

				<cfloop from="1" to="#ArrayLen(v_atividade_id_conjugada)#" index="count">
					<cfscript>
							//caso o v_processo_id seja nulo insere
							ins_conjugada = this.ins_atividade_conjugada( atividade_id_principal = arguments.atividade_id,
																		  atividade_id_conjugada = v_atividade_id_conjugada[count],
																		  obrigatoria = v_obrigatoria_conjugada[count],
																		  garantia_km = v_garantia_km[count],
																		  garantia_dias = v_garantia_dias[count],
																		  garantia_horas_trabalhadas = v_garantia_horas[count],
																		  garantia_lts_combustivel = v_garantia_lts_combustivel[count],
																		  alerta_km = v_alerta_km[count],
																		  alerta_dias = v_alerta_dias[count],
																		  alerta_horas_trabalhadas = v_alerta_horas[count],
																		  alerta_lts_combustivel = v_alerta_lts_combustivel[count]);
					</cfscript>
                    <cfif ins_conjugada.erro>
                    	<cfthrow object="ins_conjugada.mensagem">
                    </cfif>
				</cfloop>

				<cfscript>
				  // Tipo oficina
				  v_tipo_id = this.ListaToArray (lista = arguments, variavel = "OFICINA_TIPO_ID_TIPO");
				</cfscript>
				<cfscript>
					conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
					qrAtividadeOficinaTipo = conn.get_atividade_oficina_tipo(atividade_id = arguments.atividade_id);
				</cfscript>
				<cfoutput query="qrAtividadeOficinaTipo">
					<cfscript>
						this.del_atividade_oficina_tipo(atividade_id = arguments.atividade_id,
						                                tipo_id = qrAtividadeOficinaTipo.tipo_id);
					</cfscript>
				</cfoutput>
				<cfloop from="1" to="#ArrayLen(v_tipo_id)#" index="count">
					<cfscript>
						this.ins_atividade_oficina_tipo(atividade_id = arguments.atividade_id,
						                                tipo_id      = v_tipo_id[count] );
					</cfscript>
				</cfloop>

				<cfloop from="1" to="#ArrayLen(v_posicao_id)#" index="count">
					<cfscript>
							//caso o v_processo_id seja nulo insere
							this.ins_atividade_posicao( atividade_id = arguments.atividade_id,
																 posicao_id   = v_posicao_id[count]);
					</cfscript>

				</cfloop>
				<cfscript>
				  // Processos
				  v_processo = this.ListaToArray (lista = arguments, variavel = "PROCESSO_PROCESSOS");
				  v_processo_id = this.ListaToArray (lista = arguments, variavel = "PROCESSO_ID_PROCESSOS");
				  v_ordem = this.ListaToArray (lista = arguments, variavel = "ORDEM_PROCESSOS");
				  v_item_pai = this.ListaToArray (lista = arguments, variavel = "ITEM_PAI_PROCESSOS");
				  v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_PROCESSOS");
					v_ar = structnew();
					v_ar[0] = '';

				</cfscript>

				<!--- Excluir os itens --->
				<cfscript>
					conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
					qrProcesso = conn.get_atividade_processo(atividade_id = arguments.atividade_id);
				</cfscript>
				<cfoutput query="qrProcesso">
					<cfscript>
						this.del_atividade_processo(item_id = qrProcesso.item_id);
					</cfscript>
				</cfoutput>
				<cfloop from="1" to="#ArrayLen(v_processo)#" index="count">
					<cfscript>
						qrProcesso = conn.get_processo(titulo_full = v_processo[count]);
						// Busca o identificador do processo
					</cfscript>
					<cfif qrProcesso.recordcount>
						<cfset retorno.processo_id = qrProcesso.processo_id>
					<cfelse>
						<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#v_processo[count]#' >
							<cfprocparam type='IN' cfsqltype='cf_sql_varchar'   value='' >
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value="0" >
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value="0" >
							<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   null="yes" variable='retorno.PROCESSO_ID'>
							<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
						</cfstoredproc>
					</cfif>
					<cfscript>
						retorno.atividade_id = arguments.atividade_id;
						ret = this.ins_atividade_processo(atividade_id = retorno.atividade_id,
															processo_id = retorno.processo_id,
															item_pai = v_ar[v_item_pai[count]],
															ordem = v_ordem[count]);
					</cfscript>
					<cfif ret.erro>
						<cfthrow object="#ret.mensagem#">
					</cfif>
					<cfscript>
						v_ar[v_item_id[count]] = ret.item_id;
					</cfscript>
				</cfloop>

 				<cfscript>
				   ret = this.alt_tempo_execucao_processo(atividade_id           = arguments.atividade_id
                                                         ,tempo_execucao_horas   = arguments.tempo_execucao_horas
                                                         ,tempo_execucao_minutos = arguments.tempo_execucao_minutos);
                </cfscript>
                <cfif ret.erro>
				    <cfthrow object="#ret.mensagem#">
				</cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui Atividade
	-- guto 01/08/2006 16:19:34 - CRIADO
	--->
	<cffunction name='del_atividade' displayname='Exclui Atividade' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Insere vinculo entre as atividades
    -- guto 12/07/2008 09:45:42 - CRIADO
    --->
    <cffunction name='ins_atividade_conjugada' displayname='Insere vinculo entre as atividades' access='remote' returntype='Struct' output='true'>
        <cfargument name='ATIVIDADE_ID_PRINCIPAL' required='yes'>
        <cfargument name='ATIVIDADE_ID_CONJUGADA' required='yes'>
        <cfargument name='OBRIGATORIA' required='yes'>
        <cfargument name='GARANTIA_KM' required='yes'>
        <cfargument name='GARANTIA_HORAS_TRABALHADAS' required='yes'>
        <cfargument name='GARANTIA_DIAS' required='yes'>
        <cfargument name='GARANTIA_LTS_COMBUSTIVEL' required='yes'>
        <cfargument name='ALERTA_KM' required='yes'>
        <cfargument name='ALERTA_HORAS_TRABALHADAS' required='yes'>
        <cfargument name='ALERTA_DIAS' required='yes'>
        <cfargument name='ALERTA_LTS_COMBUSTIVEL' required='yes'>
        <cftry>
            <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_atividade_conjugada' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID_PRINCIPAL#'  null='#iif(len(trim(arguments.ATIVIDADE_ID_PRINCIPAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID_CONJUGADA#'  null='#iif(len(trim(arguments.ATIVIDADE_ID_CONJUGADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OBRIGATORIA#'  null='#iif(len(trim(arguments.OBRIGATORIA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_KM#'  null='#iif(len(trim(arguments.GARANTIA_KM)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.GARANTIA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_DIAS#'  null='#iif(len(trim(arguments.GARANTIA_DIAS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.GARANTIA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_KM#'  null='#iif(len(trim(arguments.ALERTA_KM)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.ALERTA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_DIAS#'  null='#iif(len(trim(arguments.ALERTA_DIAS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.ALERTA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Exclui vinculos entre as atividades
    -- guto 12/07/2008 09:45:42 - CRIADO
    --->
    <cffunction name='del_atividade_conjugada' displayname='Insere vinculo entre as atividades' access='remote' returntype='Struct' output='true'>
        <cfargument name='ATIVIDADE_ID_PRINCIPAL' required='yes'>
        <cftry>
            <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_atividade_conjugada' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID_PRINCIPAL#'  null='#iif(len(trim(arguments.ATIVIDADE_ID_PRINCIPAL)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Vincular atividade ao tipo da oficina
	-- guto 28/09/2006 11:40:24 - CRIADO
	--->
	<cffunction name='ins_atividade_oficina_tipo' displayname='Vincular atividade ao tipo da oficina' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_atividade_oficina_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!---
	-- PROPSITO
	-- Vincular atividade ao tipo da oficina
	-- guto 28/09/2006 11:40:50 - CRIADO
	--->
	<cffunction name='del_atividade_oficina_tipo' displayname='Vincular atividade ao tipo da oficina' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_atividade_oficina_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere atividade posio
	-- guto 01/08/2006 16:20:25 - CRIADO
	--->
	<cffunction name='ins_atividade_posicao' displayname='Insere atividade posio' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='POSICAO_ID' required='no' default="">
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_atividade_posicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	<!---
	-- PROPSITO
	-- Exclui atividade posio
	-- guto 01/08/2006 16:26:29 - CRIADO
	--->
	<cffunction name='del_atividade_posicao' displayname='Exclui atividade posio' access='remote' returntype='Struct' output='true'>;
		<cfargument name='POSICAO_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
			<cfset retorno = StructNew()>
			<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_atividade_posicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
		<cfreturn retorno />
	</cffunction>
	<!---
	-- PROPSITO
	-- Vincula atividade ao processo
	-- guto 01/08/2006 16:28:07 - CRIADO
	--->
	<cffunction name='ins_atividade_processo' displayname='Vincula atividade ao processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_PAI' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='ORDEM' required='yes'>
		<cftry>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_atividade_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_PAI#'  null='#iif(len(trim(arguments.ITEM_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   null='yes' variable="retorno.ITEM_ID">
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade vinculada com sucesso')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	<!---
	-- PROPSITO
	-- Altera dados do vinculo da atividade com o processo
	-- GUTO 03/08/2006 11:47:12 - CRIADO
	--->
	<cffunction name='upd_atividade_processo' displayname='Altera dados do vinculo da atividade com o processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='PROCESSO_ID' required='yes'>
		<cfargument name='ITEM_PAI' required='yes'>
		<cfargument name='ORDEM' required='yes'>
		<cftry>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_atividade_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROCESSO_ID#'  null='#iif(len(trim(arguments.PROCESSO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_PAI#'  null='#iif(len(trim(arguments.ITEM_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM#'  null='#iif(len(trim(arguments.ORDEM)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	<!---
	-- PROPSITO
	-- Desvincula atividade do processo
	-- guto 01/08/2006 16:28:51 - CRIADO
	--->
	<cffunction name='del_atividade_processo' displayname='Desvincula atividade do processo' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_atividade_processo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade desvinculada com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere dependencia entre atividades
	-- guto 30/10/2006 18:21:51 - CRIADO
	--->
	<cffunction name='ins_atividade_dependencia' displayname='Insere dependencia entre atividades' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATIVIDADE_ID_PRINCIPAL' required='yes'>
		<cfargument name='ATIVIDADE_ID_DEPENDENTE' required='yes'>
		<cfargument name='OBRIGATORIA' required='yes'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_atividade_dependencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID_PRINCIPAL#'  null='#iif(len(trim(arguments.ATIVIDADE_ID_PRINCIPAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID_DEPENDENTE#'  null='#iif(len(trim(arguments.ATIVIDADE_ID_DEPENDENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OBRIGATORIA#'  null='#iif(len(trim(arguments.OBRIGATORIA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui dependencia entre atividades
	-- guto 30/10/2006 18:23:20 - CRIADO
	--->
	<cffunction name='del_atividade_dependencia' displayname='Exclui dependencia entre atividades' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATIVIDADE_ID_PRINCIPAL' required='yes'>
		<cfargument name='ATIVIDADE_ID_DEPENDENTE' required='yes'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_atividade_dependencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID_PRINCIPAL#'  null='#iif(len(trim(arguments.ATIVIDADE_ID_PRINCIPAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID_DEPENDENTE#'  null='#iif(len(trim(arguments.ATIVIDADE_ID_DEPENDENTE)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

    <!---
	-- PROPSITO
	-- Vincula Funcionrios as especialidades e oficinas
	-- ERIC 20/10/2010 10:19:21 - CRIADO
	--->
	<cffunction name='ins_especialidades_func' displayname='Vincula Funcionrios as especialidades e oficinas' access='remote' returntype='Struct' output='true'>
		<cftry>
			<cftransaction action='begin'>
                <!--- Especialidades --->
				<cfscript>
                    v_recurso_id  	   = this.ListaToArray (lista = arguments, variavel = "RECURSO_ID_RECURSO");
                    v_especialidade_id = this.ListaToArray (lista = arguments, variavel = "ESPECIALIDADE_ID_RECURSO");
                    v_nivel_id         = this.ListaToArray (lista = arguments, variavel = "NIVEL_ID_RECURSO");
                    v_cod_pessoa       = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_RECURSO");
                    v_recurso_excluir  = this.ListDiff(lista1 = arguments.lista_deleted_RECURSO, lista2 = ArrayToList(v_recurso_id));
                </cfscript>

                <cfloop list="#v_recurso_excluir#" delimiters="," index="recur_item_id">
                    <cfscript>
                        set_del_recur = this.del_recurso(recurso_id = recur_item_id);
                    </cfscript>
                    <cfif set_del_recur.erro>
                        <cfthrow object="#set_del_recur.mensagem#">
                    </cfif>
                </cfloop>

                <cfloop from="1" to="#ArrayLen(v_recurso_id)#" index="indice_recurso">
                    <cfscript>
						if(not len(trim(v_recurso_id[indice_recurso]))) {
							//caso o v_recurso_id seja nulo insere
							set_recur = this.ins_recurso(recurso_id       = v_recurso_id[indice_recurso]
										    		   , cod_pessoa       = v_cod_pessoa[indice_recurso]
													   , especialidade_id = v_especialidade_id[indice_recurso]
													   , nivel_id         = v_nivel_id[indice_recurso]);

							v_recurso_id[indice_recurso] = set_recur.RECURSO_ID;
						} else {
							//senao altera
							set_recur = this.alt_recurso(recurso_id       = v_recurso_id[indice_recurso]
													   , cod_pessoa       = v_cod_pessoa[indice_recurso]
													   , especialidade_id = v_especialidade_id[indice_recurso]
													   , nivel_id         = v_nivel_id[indice_recurso]);
						}
                    </cfscript>
                    <cfif set_recur.erro>
                        <cfthrow object="#set_recur.mensagem#">
                    </cfif>
                </cfloop>

                <!--- vnculo com Oficina(s) --->
                <cfif ArrayLen(v_recurso_id) gt 0>
					<cfscript>
                        v_cod_pessoa_oficina = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_OFICINA_OFICINAS");
                        v_data_inicio        = this.ListaToArray (lista = arguments, variavel = "DATA_INICIO_OFICINAS");
                        v_data_fim           = this.ListaToArray (lista = arguments, variavel = "DATA_FIM_OFICINAS");

                        conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
                        qrOficina = conn.get_distinct_oficina_recurso(cod_pessoa = v_cod_pessoa[1]);
                    </cfscript>

                    <cfloop query="qrOficina">
                        <cfif ListFind(ArrayToList(v_cod_pessoa_oficina, ','), qrOficina.COD_PESSOA_OFICINA, ',') eq 0>
                            <cfscript>
                                set_oficina = this.del_lista_recurso_oficina(lista_recurso      = ArrayToList(v_recurso_id, ',')
                                                                           , cod_pessoa_oficina = qrOficina.COD_PESSOA_OFICINA);
                            </cfscript>
                            <cfif set_oficina.erro>
                                <cfthrow object="#set_oficina.mensagem#">
                            </cfif>
                        </cfif>
                    </cfloop>

                    <cfloop from="1" to="#ArrayLen(v_cod_pessoa_oficina)#" index="indice_oficina">
                        <cfscript>
                            set_oficina = this.alt_lista_recurso_oficina(lista_recurso      = ArrayToList(v_recurso_id, ',')
                                                                       , cod_pessoa_oficina = v_cod_pessoa_oficina[indice_oficina]
                                                                       , data_inicio        = v_data_inicio[indice_oficina]
                                                                       , data_fim           = v_data_fim[indice_oficina]);
                        </cfscript>
                        <cfif set_oficina.erro>
                            <cfthrow object="#set_oficina.mensagem#">
                        </cfif>
                    </cfloop>
                </cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Recurso alterado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere recurso
	-- guto 01/08/2006 16:43:01 - CRIADO
	--->
	<cffunction name='ins_recurso' displayname='Insere recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='ESPECIALIDADE_ID' required='yes'>
		<cfargument name='NIVEL_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ESPECIALIDADE_ID#'  null='#iif(len(trim(arguments.ESPECIALIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.RECURSO_ID' value='#arguments.RECURSO_ID#' null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Recurso inserido com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera recurso
	-- guto 01/08/2006 16:47:39 - CRIADO
	--->
	<cffunction name='alt_recurso' displayname='Altera recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='RECURSO_ID' required='yes'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='ESPECIALIDADE_ID' required='yes'>
		<cfargument name='NIVEL_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA#'  null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ESPECIALIDADE_ID#'  null='#iif(len(trim(arguments.ESPECIALIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Recurso alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui recurso
	-- guto 01/08/2006 16:48:22 - CRIADO
	--->
	<cffunction name='del_recurso' displayname='Exclui recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='RECURSO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_recurso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RECURSO_ID#'  null='#iif(len(trim(arguments.RECURSO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Recurso excludo com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>

		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere uma lista de recurso em oficina
	-- ERIC 20/10/2010 10:19:21 - CRIADO
	--->
	<cffunction name='alt_lista_recurso_oficina' displayname='Insere uma lista de recurso em oficina' access='remote' returntype='Struct' output='true'>;
		<cfargument name='LISTA_RECURSO'      required='yes'>
		<cfargument name='COD_PESSOA_OFICINA' required='yes'>
		<cfargument name='DATA_INICIO'        required='yes'>
		<cfargument name='DATA_FIM'           required='yes'>
		<cftry>
            <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_lista_recurso_oficina' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LISTA_RECURSO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_OFICINA#'  null='#iif(len(trim(arguments.COD_PESSOA_OFICINA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' > </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Recurso alterado com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Remove uma lista de recurso em oficina
	-- ERIC 21/10/2010 10:19:21 - CRIADO
	--->
	<cffunction name='del_lista_recurso_oficina' displayname='Remove uma lista de recurso em oficina' access='remote' returntype='Struct' output='true'>;
		<cfargument name='LISTA_RECURSO'      required='yes'>
		<cfargument name='COD_PESSOA_OFICINA' required='yes'>
		<cftry>
            <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_lista_recurso_oficina' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LISTA_RECURSO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_OFICINA#'  null='#iif(len(trim(arguments.COD_PESSOA_OFICINA)), de('no'), de('yes'))#'></cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Recurso removido com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere uma tabela de manuteno
	-- guto 01/08/2006 17:00:29 - CRIADO
	--->
	<cffunction name='ins_tabela_manutencao' displayname='Insere uma tabela de manuteno' access='remote' returntype='Struct' output='true'>;
		<cfargument name='NOME' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='TABELA_PAI' required='yes'>
		<cfargument name='OBRIGATORIA' required='yes'>
		<cfargument name='TABELA_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='no' default="">
		<cfargument name='INTERVALO_KM' required='yes'>
		<cfargument name='INTERVALO_DIAS' required='yes'>
		<cfargument name='INTERVALO_HORAS_TRABALHADAS' required='yes'>
		<cfargument name='INTERVALO_LTS_COMBUSTIVEL' required='yes'>
		<cfargument name='ALERTA_KM' required='yes'>
		<cfargument name='ALERTA_DIAS' required='yes'>
		<cfargument name='ALERTA_HORAS_TRABALHADAS' required='yes'>
		<cfargument name='ALERTA_LTS_COMBUSTIVEL' required='yes'>
		<cfargument name='VERIFICACAO_PNEUS' required='yes'>
		<cfargument name='ATUALIZA_REVISAO' required='yes'>
		<cfargument name='EXIGE_LAVAGEM' required='yes'>
        <cfargument name='TIPO_EXECUCAO' required='no' default="0">
		<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_tabela_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_PAI#'  null='#iif(len(trim(arguments.TABELA_PAI)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OBRIGATORIA#'  null='#iif(len(trim(arguments.OBRIGATORIA)), de('no'), de('yes'))#'>
				<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#' variable='retorno.TABELA_ID'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INTERVALO_KM#'  null='#iif(len(trim(arguments.INTERVALO_KM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INTERVALO_DIAS#'  null='#iif(len(trim(arguments.INTERVALO_DIAS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INTERVALO_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.INTERVALO_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INTERVALO_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.INTERVALO_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_KM#'  null='#iif(len(trim(arguments.ALERTA_KM)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_DIAS#'  null='#iif(len(trim(arguments.ALERTA_DIAS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.ALERTA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.ALERTA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATUALIZA_REVISAO#'  null='#iif(len(trim(arguments.ATUALIZA_REVISAO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VERIFICACAO_PNEUS#'  null='#iif(len(trim(arguments.VERIFICACAO_PNEUS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EXIGE_LAVAGEM#'  null='#iif(len(trim(arguments.EXIGE_LAVAGEM)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_EXECUCAO#'  null='#iif(len(trim(arguments.TIPO_EXECUCAO)), de('no'), de('yes'))#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
			</cfstoredproc>
			<cfloop index="i" list="#arguments.ATIVIDADE_ID#" delimiters=",">
				<cfscript>
					this.ins_tabela_atividade( tabela_id = retorno.tabela_id,
											   atividade_id = i );

				</cfscript>
			</cfloop>

			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Tabela de reviso inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera uma tabela de manuteno
	-- guto 01/08/2006 17:01:29 - CRIADO
	--->
	<cffunction name='alt_tabela_manutencao' displayname='Altera uma tabela de manuteno' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TABELA_ID' required='yes'>
		<cfargument name='NOME' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='TABELA_PAI' required='yes'>
		<cfargument name='OBRIGATORIA' required='yes'>
		<cfargument name='INTERVALO_KM' required='yes'>
		<cfargument name='INTERVALO_DIAS' required='yes'>
		<cfargument name='INTERVALO_HORAS_TRABALHADAS' required='yes'>
		<cfargument name='INTERVALO_LTS_COMBUSTIVEL' required='yes'>
		<cfargument name='ALERTA_KM' required='yes'>
		<cfargument name='ALERTA_DIAS' required='yes'>
		<cfargument name='ALERTA_HORAS_TRABALHADAS' required='yes'>
		<cfargument name='ALERTA_LTS_COMBUSTIVEL' required='yes'>
		<cfargument name='VERIFICACAO_PNEUS' required='yes'>
		<cfargument name='ATUALIZA_REVISAO' required='yes'>
		<cfargument name='EXIGE_LAVAGEM' required='yes'>
        <cfargument name='TIPO_EXECUCAO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_tabela_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_PAI#'  null='#iif(len(trim(arguments.TABELA_PAI)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OBRIGATORIA#'  null='#iif(len(trim(arguments.OBRIGATORIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INTERVALO_KM#'  null='#iif(len(trim(arguments.INTERVALO_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INTERVALO_DIAS#'  null='#iif(len(trim(arguments.INTERVALO_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INTERVALO_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.INTERVALO_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INTERVALO_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.INTERVALO_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_KM#'  null='#iif(len(trim(arguments.ALERTA_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_DIAS#'  null='#iif(len(trim(arguments.ALERTA_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.ALERTA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.ALERTA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATUALIZA_REVISAO#'  null='#iif(len(trim(arguments.ATUALIZA_REVISAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VERIFICACAO_PNEUS#'  null='#iif(len(trim(arguments.VERIFICACAO_PNEUS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EXIGE_LAVAGEM#'  null='#iif(len(trim(arguments.EXIGE_LAVAGEM)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_EXECUCAO#'  null='#iif(len(trim(arguments.TIPO_EXECUCAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
					conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
					qrAtividades = conn.get_tabela_atividade(tabela_id = arguments.tabela_id);
				</cfscript>
				<cfoutput query="qrAtividades">
					<cfscript>
						this.del_tabela_atividade( tabela_id = qrAtividades.tabela_id,
												   atividade_id = qrAtividades.atividade_id );

					</cfscript>
				</cfoutput>
				<cfloop index="i" list="#arguments.ATIVIDADE_ID#" delimiters=",">
					<cfscript>
						this.ins_tabela_atividade( tabela_id = arguments.tabela_id,
												   atividade_id = i );

					</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tabela de reviso alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Excluir uma tabela de manuteno
	-- guto 01/08/2006 17:02:06 - CRIADO
	--->
	<cffunction name='del_tabela_manutencao' displayname='Excluir uma tabela de manuteno' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TABELA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_tabela_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tabela de reviso excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere periodicidade a tabela de manuteno
	-- guto 02/08/2006 09:12:53 - CRIADO
	--->
	<cffunction name='ins_tabela_periodicidade' displayname='Insere periodicidade a tabela de manuteno' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='TABELA_ID' required='yes'>
		<cfargument name='PERIODICIDADE_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='TOLERANCIA' required='yes'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_tabela_periodicidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERIODICIDADE_ID#'  null='#iif(len(trim(arguments.PERIODICIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOLERANCIA#'  null='#iif(len(trim(arguments.TOLERANCIA)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#' variable="retorno.item_id">
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera periodicidade a tabela de manuteno
	-- guto 02/08/2006 09:13:32 - CRIADO
	--->
	<cffunction name='alt_tabela_periodicidade' displayname='Altera periodicidade a tabela de manuteno' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='TABELA_ID' required='yes'>
		<cfargument name='PERIODICIDADE_ID' required='yes'>
		<cfargument name='VALOR' required='yes'>
		<cfargument name='TOLERANCIA' required='yes'>
				<cfset retorno = StructNew()>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_tabela_periodicidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERIODICIDADE_ID#'  null='#iif(len(trim(arguments.PERIODICIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOLERANCIA#'  null='#iif(len(trim(arguments.TOLERANCIA)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera periodicidade a tabela de manuteno
	-- guto 02/08/2006 09:13:57 - CRIADO
	--->
	<cffunction name='del_tabela_periodicidade' displayname='Altera periodicidade a tabela de manuteno' access='remote' returntype='Struct' output='true'>;
		<cfargument name='ITEM_ID' required='yes'>
				<cfset retorno = StructNew()>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_tabela_periodicidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere atividade em uma tabela de manuteno
	-- ANDERSONC 16/12/2009 16:17:45 - CRIADO
	--->
	<cffunction name='ins_tabela_atividade' displayname='Insere atividade em uma tabela de manuteno' access='remote' returntype='Struct' output='true'>
		<cfargument name='TABELA_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
            <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_tabela_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('OK.')>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui atividade em uma tabela de manuteno
	-- ANDERSONC 16/12/2009 16:18:53 - CRIADO
	--->
	<cffunction name='del_tabela_atividade' displayname='Exclui atividade em uma tabela de manuteno' access='remote' returntype='Struct' output='true'>
		<cfargument name='TABELA_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_tabela_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('OK.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere um modelo de equipamento em uma tabela de manuteno
	-- guto 01/08/2006 16:57:01 - CRIADO
	--->
	<cffunction name='ins_tabela_equipamento' displayname='Insere um modelo de equipamento em uma tabela de manuteno' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TABELA_ID' required='yes'>
		<cfargument name='EQUIPAMENTO_MODELO_ID' required='yes'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_tabela_equipamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_MODELO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui um modelo de equipamento em uma tabela de manuteno
	-- guto 01/08/2006 16:57:51 - CRIADO
	--->
	<cffunction name='del_tabela_equipamento' displayname='Exclui um modelo de equipamento em uma tabela de manuteno' access='remote' returntype='Struct' output='true'>;
		<cfargument name='TABELA_ID' required='yes'>
		<cfargument name='EQUIPAMENTO_MODELO_ID' required='yes'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_tabela_equipamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_MODELO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_MODELO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Vincula uma tabela a um modelo de equipamento
	-- guto 07/11/2006 09:12:07 - CRIADO
	--->
	<cffunction name='ins_tabela_modelo' displayname='Vincula uma tabela a um modelo de equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='TABELA_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_tabela_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo criado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Desvincula uma tabela a um modelo de equipamento
	-- guto 07/11/2006 09:12:07 - CRIADO
	--->
	<cffunction name='del_tabela_modelo' displayname='Desvincula uma tabela a um modelo de equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='TABELA_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_tabela_modelo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Item Desvinculado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Altera um tipo de embalagem
    -- ANDERSONC 29/12/2009 11:08:12 - CRIADO
    --->
    <cffunction name='atualiza_especialidades_valor' displayname='Atualiza os valores de especialidades' access='remote' returntype='Struct' output='true'>
        <cftry>
            <cftransaction action='begin'>

				<cfscript>
					v_controle_id = ListaToArray (lista = arguments, variavel = "CONTROLE_ID_ESPVALOR");
					v_especialidade_id = ListaToArray (lista = arguments, variavel = "ESPECIALIDADE_ID_ESPVALOR");
					v_nivel_id = ListaToArray (lista = arguments, variavel = "NIVEL_ID_ESPVALOR");
					v_valor_empresa = ListaToArray (lista = arguments, variavel = "VALOR_EMPRESA_ESPVALOR");
					v_valor_terceiro = ListaToArray (lista = arguments, variavel = "VALOR_TERCEIRO_ESPVALOR");
					v_data_inicio = ListaToArray (lista = arguments, variavel = "DATA_INICIO_ESPVALOR");
					v_data_fim = ListaToArray (lista = arguments, variavel = "DATA_FIM_ESPVALOR");
					v_controle_excluir = ListDiff(lista1 = arguments.lista_deleted_ESPVALOR, lista2 = ArrayToList(v_controle_id));
				</cfscript>


                <!--- Excluir os itens --->
                <cfloop list="#v_controle_excluir#" delimiters="," index="l_item_id">
                    <cfscript>
                        ret_del = this.del_especialidade_valor(controle_id = l_item_id);
                    </cfscript>
                    <cfif ret_del.erro>
                        <cfthrow object="#ret_del.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Inserir/Atualizar os itens --->
                <cfloop from="1" to="#ArrayLen(v_especialidade_id)#" index="count">
                    <cfif not len(trim(v_controle_id[count]))>
                        <!---caso o v_controle_id seja nulo insere--->
                        <cfscript>
                            ret_ins = this.ins_especialidade_valor( controle_id      = v_controle_id[count],
                                                                    especialidade_id = v_especialidade_id[count],
                                                                    nivel_id         = v_nivel_id[count],
                                                                    valor_empresa    = v_valor_empresa[count],
                                                                    valor_terceiro   = v_valor_terceiro[count],
                                                                    data_inicio      = v_data_inicio[count],
                                                                    data_fim    	  = v_data_fim[count]);
                        </cfscript>
                        <cfif ret_ins.erro>
                            <cfthrow object="#ret_ins.mensagem#">
                        </cfif>
                    <cfelse>
                        <!---senao altera--->
                        <cfscript>
                            ret_alt = this.alt_especialidade_valor( controle_id 	 = v_controle_id[count],
                                                                    especialidade_id = v_especialidade_id[count],
                                                                    nivel_id         = v_nivel_id[count],
                                                                    valor_empresa    = v_valor_empresa[count],
                                                                    valor_terceiro   = v_valor_terceiro[count],
                                                                    data_inicio      = v_data_inicio[count],
                                                                    data_fim    	 = v_data_fim[count]);
                        </cfscript>
                        <cfif ret_alt.erro>
                            <cfthrow object="#ret_alt.mensagem#">
                        </cfif>


                    </cfif>
                </cfloop>

				<!---Valida Valores--->
                <cfscript>
                    ret_valida = this.valida_especialidade_valor();
                </cfscript>
                <cfif ret_valida.erro>
                    <cfthrow object="#ret_valida.mensagem#">
                </cfif>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Valores de Especialidades Inseridos/Atualizados com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Insere especialidades e valores.
	-- arlen 11/12/2006 10:11:45 - CRIADO
	--->
	<cffunction name='ins_especialidade_valor' displayname='Insere especialidades e valores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ESPECIALIDADE_ID' required='yes'>
		<cfargument name='NIVEL_ID' required='yes'>
		<cfargument name='VALOR_EMPRESA' required='yes'>
		<cfargument name='VALOR_TERCEIRO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FIM' required='yes'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_especialidade_valor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ESPECIALIDADE_ID#'  null='#iif(len(trim(arguments.ESPECIALIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_EMPRESA#'  null='#iif(len(trim(arguments.VALOR_EMPRESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TERCEIRO#'  null='#iif(len(trim(arguments.VALOR_TERCEIRO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#' variable='retorno.CONTROLE_ID'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Valores para especialidades inseridos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera especialidades e valores.
	-- arlen 11/12/2006 10:13:49 - CRIADO
	--->
	<cffunction name='alt_especialidade_valor' displayname='Altera especialidades e valores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='ESPECIALIDADE_ID' required='yes'>
		<cfargument name='NIVEL_ID' required='yes'>
		<cfargument name='VALOR_EMPRESA' required='yes'>
		<cfargument name='VALOR_TERCEIRO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FIM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_especialidade_valor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ESPECIALIDADE_ID#'  null='#iif(len(trim(arguments.ESPECIALIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NIVEL_ID#'  null='#iif(len(trim(arguments.NIVEL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_EMPRESA#'  null='#iif(len(trim(arguments.VALOR_EMPRESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TERCEIRO#'  null='#iif(len(trim(arguments.VALOR_TERCEIRO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Valores para especialidades alterados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui especialidades e valores.
	-- arlen 11/12/2006 10:14:51 - CRIADO
	--->
	<cffunction name='del_especialidade_valor' displayname='Exclui especialidades e valores.' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		  <cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_especialidade_valor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Valores para especialidades excludos com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Valida Especialidades
	-- RAFAEL 16/02/2012 11:38:14 - CRIADO
	--->
	<cffunction name='valida_especialidade_valor' displayname='Valida Especialidades' access='remote' returntype='Struct' output='true'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_valida_especialidade_valor' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Valores de Especialidades Validados com Sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Vincula um modelo a uma atividade
	-- rafael 28/07/2008 09:54:07 - CRIADO
	--->

	<cffunction name='ins_modelo_atividade' displayname='Vincula um modelo a uma atividade' access='remote' returntype='Struct' output='true'>
        <cfargument name='MODELO_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='GARANTIA_KM' required='yes'>
		<cfargument name='GARANTIA_HORAS_TRABALHADAS' required='yes'>
		<cfargument name='GARANTIA_DIAS' required='yes'>
		<cfargument name='GARANTIA_LTS_COMBUSTIVEL' required='yes'>
		<cfargument name='ALERTA_KM' required='yes'>
		<cfargument name='ALERTA_HORAS_TRABALHADAS' required='yes'>
		<cfargument name='ALERTA_DIAS' required='yes'>
		<cfargument name='ALERTA_LTS_COMBUSTIVEL' required='yes'>

        <cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_modelo_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_KM#'  null='#iif(len(trim(arguments.GARANTIA_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.GARANTIA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_DIAS#'  null='#iif(len(trim(arguments.GARANTIA_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.GARANTIA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_KM#'  null='#iif(len(trim(arguments.ALERTA_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.ALERTA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_DIAS#'  null='#iif(len(trim(arguments.ALERTA_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.ALERTA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo criado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Atualiza vinculo de um modelo a uma atividade
	-- rafael 28/07/2008 09:58:39 - CRIADO
	--->
	<cffunction name='upd_modelo_atividade' displayname='Atualiza vinculo de um modelo a uma atividade' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='MODELO_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='GARANTIA_KM' required='yes'>
		<cfargument name='GARANTIA_HORAS_TRABALHADAS' required='yes'>
		<cfargument name='GARANTIA_DIAS' required='yes'>
		<cfargument name='GARANTIA_LTS_COMBUSTIVEL' required='yes'>
		<cfargument name='ALERTA_KM' required='yes'>
		<cfargument name='ALERTA_HORAS_TRABALHADAS' required='yes'>
		<cfargument name='ALERTA_DIAS' required='yes'>
		<cfargument name='ALERTA_LTS_COMBUSTIVEL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_modelo_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_KM#'  null='#iif(len(trim(arguments.GARANTIA_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.GARANTIA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_DIAS#'  null='#iif(len(trim(arguments.GARANTIA_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GARANTIA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.GARANTIA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_KM#'  null='#iif(len(trim(arguments.ALERTA_KM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_HORAS_TRABALHADAS#'  null='#iif(len(trim(arguments.ALERTA_HORAS_TRABALHADAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_DIAS#'  null='#iif(len(trim(arguments.ALERTA_DIAS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALERTA_LTS_COMBUSTIVEL#'  null='#iif(len(trim(arguments.ALERTA_LTS_COMBUSTIVEL)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Vinculo atualizado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Exclui vinculo do modelo com a atividade
    -- guto 09/06/2008 17:49:53 - CRIADO
    --->
    <cffunction name='del_modelo_atividade' displayname='Exclui vinculo do modelo com a atividade' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_modelo_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Insere um tipo de ordem de servio
    -- ANDERSONC 08/12/2009 10:55:12 - CRIADO
    --->
    <cffunction name='ins_tipo_ordem_servico' displayname='Insere um tipo de ordem de servio' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_tipo_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.TIPO_ORDEM_SERVICO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Altera um tipo de ordem de servio
    -- ANDERSONC 08/12/2009 10:55:56 - CRIADO
    --->
    <cffunction name='upd_tipo_ordem_servico' displayname='Altera um tipo de ordem de servio' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_ORDEM_SERVICO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_alt_tipo_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.TIPO_ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Exclui um tipo de ordem de servio
    -- ANDERSONC 08/12/2009 10:56:36 - CRIADO
    --->
    <cffunction name='del_tipo_ordem_servico' displayname='Exclui um tipo de ordem de servio' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_ORDEM_SERVICO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_del_tipo_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.TIPO_ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Altera dados da atividade no equipamento
	-- guto 27/12/2006 13:48:32 - CRIADO
	--->
	<cffunction name='alt_equipamento_atividade' displayname='Altera dados da atividade no equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='KM_PREVISAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_alt_equipamento_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_PREVISAO#'  null='#iif(len(trim(arguments.KM_PREVISAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados alterados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Excluir previso para o veculo
	-- guto 27/12/2006 13:48:32 - CRIADO
	--->
	<cffunction name='del_equipamento_atividade' displayname='Altera dados da atividade no equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_del_equipamento_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados alterados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere atividade manualmente no equipamento
	-- guto 27/12/2006 15:15:08 - CRIADO
	--->
	<cffunction name='ins_equipamento_atividade' displayname='Insere atividade manualmente no equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='KM_PREVISAO' required='yes'>
		<cfargument name='KM_RODADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_ins_equipamento_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_PREVISAO#'  null='#iif(len(trim(arguments.KM_PREVISAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_RODADO#'  null='#iif(len(trim(arguments.KM_RODADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade inserida com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere previso de atividade para o equipamento.
	-- wagner 06/01/2007 10:53:24 - CRIADO
	--->
	<cffunction name='ins_equip_ativ_previsao' displayname='Insere previso de atividade para o equipamento.' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cfargument name='DATA_EXECUCAO' required='yes'>
		<cfargument name='ORDEM_SERVICO_ID_PREVISAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_ins_equip_ativ_previsao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' 	cfsqltype='CF_SQL_NUMERIC' SCALE='5'   	value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' 	cfsqltype='CF_SQL_NUMERIC' SCALE='5'   	value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' 	cfsqltype='CF_SQL_NUMERIC' SCALE='5'   		value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' 	cfsqltype='CF_SQL_VARCHAR' 			   	value='#arguments.DATA_EXECUCAO#' >
					<cfprocparam type='IN' 	cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID_PREVISAO#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID_PREVISAO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  		variable='retorno.CONTROLE_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Previso inserida com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- INsere tabela em veculo novo
    -- guto 05/11/2008 15:44:42 - CRIADO
    --->
    <cffunction name='ins_tabela_veiculo_novo' displayname='INsere tabela em veculo novo' access='remote' returntype='Struct' output='true'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='TABELA_ID' required='yes'>
        <cfargument name='DATA_EXECUCAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_manutencao.prc_ins_tabela_equip_novo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EXECUCAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.KM#' null='#iif(len(trim(arguments.KM)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tabela vinculada com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Exclui tabela do equipamento
	-- guto 22/09/2006 14:05:10 - CRIADO
	--->
	<cffunction name='del_equipamento_tabela' displayname='Insere posio' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_del_equip_tab_execucao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tabela desvinculada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch.Detail>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Insere contrato de manuteno
    -- guto 30/05/2008 10:55:24 - CRIADO
    --->
    <cffunction name='ins_contrato_manutencao' displayname='Insere contrato de manuteno' access='remote' returntype='Struct' output='true'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='COD_PESSOA_CONCESSIONARIA' required='yes'>
        <cfargument name='DATA_INICIAL' required='yes'>
        <cfargument name='DATA_FINAL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_ins_contrato_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_CONCESSIONARIA#'  null='#iif(len(trim(arguments.COD_PESSOA_CONCESSIONARIA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FINAL#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTRATO_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Altera contrato de manuteno
    -- guto 30/05/2008 10:58:03 - CRIADO
    --->
    <cffunction name='upd_contrato_manutencao' displayname='Altera contrato de manuteno' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTRATO_ID' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cfargument name='COD_PESSOA_CONCESSIONARIA' required='yes'>
        <cfargument name='DATA_INICIAL' required='yes'>
        <cfargument name='DATA_FINAL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_alt_contrato_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_CONCESSIONARIA#'  null='#iif(len(trim(arguments.COD_PESSOA_CONCESSIONARIA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FINAL#' >
                </cfstoredproc>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Exclui contrato de manuteno
    -- guto 30/05/2008 10:58:42 - CRIADO
    --->
    <cffunction name='del_contrato_manutencao' displayname='Exclui contrato de manuteno' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTRATO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_del_contrato_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Insere tabela de custo ao contrato
    -- guto 30/05/2008 11:05:30 - CRIADO
    --->
    <cffunction name='ins_contrato_tabela_custo' displayname='Insere tabela de custo ao contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTRATO_ID' required='yes'>
        <cfargument name='DATA_VIGENCIA' required='yes'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_ins_contrato_tabela_custo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VIGENCIA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.TABELA_ID' >
                </cfstoredproc>

				<cfscript>
				  // Faixa
				  v_num_faixa  = this.ListaToArray (lista = arguments, variavel = "NUM_FAIXA_FAIXA");
				  v_km_inicial = this.ListaToArray (lista = arguments, variavel = "KM_INICIAL_FAIXA");
				  v_km_final   = this.ListaToArray (lista = arguments, variavel = "KM_FINAL_FAIXA");
				  v_valor_km   = this.ListaToArray (lista = arguments, variavel = "VALOR_KM_FAIXA");
				  v_observacao   = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_num_faixa)#" index="count">
					<cfscript>
						ins_faixa = this.ins_contrato_tabela_faixa(tabela_id  = retorno.tabela_id,
						                               km_inicial = v_km_inicial[count],
													   km_final	  = v_km_final[count],
													   valor_km   = replace(v_valor_km[count],',','.'),
													   observacao = v_observacao[count]);
					</cfscript>
                    <cfif ins_faixa.erro>
                    	<cfthrow object="#ins_faixa.mensagem#">
                    </cfif>
				</cfloop>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tabela de custo inserida com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Altera tabela de custo ao contrato
    -- guto 30/05/2008 11:06:25 - CRIADO
    --->
    <cffunction name='upd_contrato_tabela_custo' displayname='Altera tabela de custo ao contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='TABELA_ID' required='yes'>
        <cfargument name='CONTRATO_ID' required='yes'>
        <cfargument name='DATA_VIGENCIA' required='yes'>
        <cfargument name='MODELO_ID' required='yes'>
        <cfargument name='TITULO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_alt_contrato_tabela_custo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MODELO_ID#'  null='#iif(len(trim(arguments.MODELO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VIGENCIA#' >
                </cfstoredproc>

				<cfscript>
				  // Faixa
				  v_num_faixa  = this.ListaToArray (lista = arguments, variavel = "NUM_FAIXA_FAIXA");
				  v_km_inicial = this.ListaToArray (lista = arguments, variavel = "KM_INICIAL_FAIXA");
				  v_km_final   = this.ListaToArray (lista = arguments, variavel = "KM_FINAL_FAIXA");
				  v_valor_km   = this.ListaToArray (lista = arguments, variavel = "VALOR_KM_FAIXA");
 				  v_observacao   = this.ListaToArray (lista = arguments, variavel = "OBSERVACAO");
				</cfscript>

				<cfscript>
                    del_faixas = this.del_contrato_tabela_faixas(tabela_id  = arguments.tabela_id);
                </cfscript>
                <cfif del_faixas.erro>
                    <cfthrow object="#del_faixas.mensagem#">
                </cfif>

				<cfloop from="1" to="#ArrayLen(v_num_faixa)#" index="count">
					<cfscript>
						ins_faixa = this.ins_contrato_tabela_faixa(tabela_id  = arguments.tabela_id,
						                               km_inicial = v_km_inicial[count],
													   km_final	  = v_km_final[count],
													   valor_km   = replace(v_valor_km[count],',','.'),
													   observacao = v_observacao[count]);
					</cfscript>
                    <cfif ins_faixa.erro>
                    	<cfthrow object="#ins_faixa.mensagem#">
                    </cfif>
				</cfloop>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Exclui tabela de custo ao contrato
    -- guto 30/05/2008 11:06:59 - CRIADO
    --->
    <cffunction name='del_contrato_tabela_custo' displayname='Exclui tabela de custo ao contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='TABELA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_del_contrato_tabela_custo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Contrato excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
    -- Insere faixa de controle e valor na tabela de custo
    -- guto 30/05/2008 11:13:09 - CRIADO
	--->
    <cffunction name='ins_contrato_tabela_faixa' displayname='Insere faixa de controle e valor na tabela de custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='TABELA_ID' required='yes'>
        <cfargument name='KM_INICIAL' required='yes'>
        <cfargument name='KM_FINAL' required='yes'>
        <cfargument name='ANO_FABRICACAO_INICIAL' required='no' default="0">
        <cfargument name='ANO_FABRICACAO_FINAL' required='no' default="0">
        <cfargument name='VALOR_KM' required='yes'>
        <cfargument name='OBSERVACAO' required='no' default="0">
        <cftry>
                    <cfstoredproc procedure='manutencao.pkg_contrato.prc_ins_contrato_tabela_faixa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_INICIAL#'  null='#iif(len(trim(arguments.KM_INICIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_FINAL#'  null='#iif(len(trim(arguments.KM_FINAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANO_FABRICACAO_INICIAL#'  null='#iif(len(trim(arguments.ANO_FABRICACAO_INICIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANO_FABRICACAO_FINAL#'  null='#iif(len(trim(arguments.ANO_FABRICACAO_FINAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_KM#'  null='#iif(len(trim(arguments.VALOR_KM)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_FAIXA' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.OBSERVACAO#'  null='#iif(len(trim(arguments.OBSERVACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                    <cfset retorno.mensagem = ''>
                <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Altera faixa de controle e valor na tabela de custo
    -- guto 30/05/2008 11:23:15 - CRIADO
    --->
    <cffunction name='alt_contrato_tabela_faixa' displayname='Altera faixa de controle e valor na tabela de custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_FAIXA' required='yes'>
        <cfargument name='TABELA_ID' required='yes'>
        <cfargument name='KM_INICIAL' required='yes'>
        <cfargument name='KM_FINAL' required='yes'>
        <cfargument name='ANO_FABRICACAO_INICIAL' required='no' default="0">
        <cfargument name='ANO_FABRICACAO_FINAL' required='no' default="0">
        <cfargument name='VALOR_KM' required='yes'>
            <cftry>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_alt_contrato_tabela_faixa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FAIXA#'  null='#iif(len(trim(arguments.NUM_FAIXA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_INICIAL#'  null='#iif(len(trim(arguments.KM_INICIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_FINAL#'  null='#iif(len(trim(arguments.KM_FINAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANO_FABRICACAO_INICIAL#'  null='#iif(len(trim(arguments.ANO_FABRICACAO_INICIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ANO_FABRICACAO_FINAL#'  null='#iif(len(trim(arguments.ANO_FABRICACAO_FINAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_KM#'  null='#iif(len(trim(arguments.VALOR_KM)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.mensagem = ''>
                <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
            </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Exclui faixa de controle e valor na tabela de custo
    -- guto 30/05/2008 11:23:43 - CRIADO
    --->
    <cffunction name='del_contrato_tabela_faixa' displayname='Exclui faixa de controle e valor na tabela de custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_FAIXA' required='yes'>
        	<cftry>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_del_contrato_tabela_faixa' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FAIXA#'  null='#iif(len(trim(arguments.NUM_FAIXA)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.mensagem = ''>
                <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
            </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Exclui totas as faixas de valor na tabela de custo
    -- guto 30/05/2008 11:23:43 - CRIADO
    --->
    <cffunction name='del_contrato_tabela_faixas' displayname='Exclui faixa de controle e valor na tabela de custo' access='remote' returntype='Struct' output='true'>
        <cfargument name='TABELA_ID' required='yes'>
        	<cftry>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_del_contrato_tabela_faixas' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.mensagem = ''>
                <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
            </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Insere equipamento ao contrato
    -- guto 30/05/2008 11:25:17 - CRIADO
    --->
    <cffunction name='ins_contrato_equipamento' displayname='Insere equipamento ao contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='CONTRATO_ID' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_ins_contrato_equipamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Altera vinculo do equipamento com o contrato
    -- guto 30/05/2008 11:34:28 - CRIADO
    --->
    <cffunction name='fecha_contrato_equipamento' displayname='Altera vinculo do equipamento com o contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='DATA_TERMINO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_fecha_contrato_equipamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo fechado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Altera vinculo do equipamento com o contrato
    -- guto 30/05/2008 11:34:28 - CRIADO
    --->
    <cffunction name='upd_contrato_equipamento' displayname='Altera vinculo do equipamento com o contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='CONTRATO_ID' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_TERMINO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_alt_contrato_equipamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Exclui vinculo do equipamento com o contrato
    -- guto 30/05/2008 11:36:04 - CRIADO
    --->
    <cffunction name='del_contrato_equipamento' displayname='Exclui vinculo do equipamento com o contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_del_contrato_equipamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Vinculo excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset retorno.mensagem_str = cfcatch.Detail>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Insere fechamento de contrado
    -- guto 06/10/2008 17:09:39 - CRIADO
    --->
    <cffunction name='ins_contrato_fechamento' displayname='Insere fechamento de contrado' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTRATO_ID' required='yes'>
        <cfargument name='DATA_FECHAMENTO' required='yes'>
        <cfargument name='DATA_INICIAL' required='yes'>
        <cfargument name='DATA_FINAL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_ins_contrato_fechamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FECHAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FINAL#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.FECHAMENTO_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fechamento inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Altera fechamento de contrado
    -- guto 06/10/2008 17:10:43 - CRIADO
    --->
    <cffunction name='upd_contrato_fechamento' displayname='Altera fechamento de contrado' access='remote' returntype='Struct' output='true'>
        <cfargument name='FECHAMENTO_ID' required='yes'>
        <cfargument name='CONTRATO_ID' required='yes'>
        <cfargument name='DATA_FECHAMENTO' required='yes'>
        <cfargument name='DATA_INICIAL' required='yes'>
        <cfargument name='DATA_FINAL' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_alt_contrato_fechamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FECHAMENTO_ID#'  null='#iif(len(trim(arguments.FECHAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTRATO_ID#'  null='#iif(len(trim(arguments.CONTRATO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FECHAMENTO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FINAL#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fechamento alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Exclui fechamento de contrado
    -- guto 06/10/2008 17:11:21 - CRIADO
    --->
    <cffunction name='del_contrato_fechamento' displayname='Exclui fechamento de contrado' access='remote' returntype='Struct' output='true'>
        <cfargument name='FECHAMENTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_del_contrato_fechamento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FECHAMENTO_ID#'  null='#iif(len(trim(arguments.FECHAMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fechamento excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
    -- PROPSITO
    -- Insere item do fechamento do contrato
    -- guto 06/10/2008 17:18:55 - CRIADO
    --->
    <cffunction name='ins_contrato_fechamento_it' displayname='Insere item do fechamento do contrato' access='remote' returntype='Struct' output='true'>
        <cfargument name='FECHAMENTO_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='DATA_INICIAL' required='yes'>
        <cfargument name='DATA_FINAL' required='yes'>
        <cfargument name='KM_INICIAL' required='yes'>
        <cfargument name='KM_FINAL' required='yes'>
        <cfargument name='TABELA_ID' required='yes'>
        <cfargument name='NUM_FAIXA' required='yes'>
        <cfargument name='VALOR_KM' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_contrato.prc_ins_contrato_fechamento_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FECHAMENTO_ID#'  null='#iif(len(trim(arguments.FECHAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FINAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_INICIAL#'  null='#iif(len(trim(arguments.KM_INICIAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_FINAL#'  null='#iif(len(trim(arguments.KM_FINAL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_FAIXA#'  null='#iif(len(trim(arguments.NUM_FAIXA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_KM#'  null='#iif(len(trim(arguments.VALOR_KM)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ITEM_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Fechamento do frota (' &arguments.PLACA& ') inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Insere desconto
    -- guto 10/10/2008 10:51:52 - CRIADO
    --->
    <cffunction name='manipula_contrato_fechamento_descontos' displayname='Insere desconto' access='remote' returntype='Struct' output='true'>
        <cfargument name='FECHAMENTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
				<!--- Insere/Altera/Exclui Descontos--->
				<cfscript>
					v_controle_id = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_DESCONTO");
					v_num_nota_id = this.ListaToArray (lista = arguments, variavel = "NF_TERCEIRO_ID_DESCONTO");
					v_cod_veiculo = this.ListaToArray (lista = arguments, variavel = "COD_VEICULO_DESCONTO");
					v_valor_desconto = this.ListaToArray (lista = arguments, variavel = "VALOR_DESCONTO_DESCONTO");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_DESCONTO, lista2 = ArrayToList(v_controle_id));
				</cfscript>
				<!--- Excluir Itens --->
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					 <cfscript>
					 	 this.del_contrato_fechamento_desconto(controle_id = l_item_id);
					 </cfscript>
				</cfloop>

				<!--- Insere os Itens --->
				<cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
						<cfscript>
								if (not Len(Trim(v_controle_id[count])))  {
									WriteOutput('INSERE');
									set_desconto = this.ins_contrato_fechamento_desconto(fechamento_id = arguments.FECHAMENTO_ID,
																						  num_nota_id   = v_num_nota_id[count],
																						  placa         = v_cod_veiculo[count],
																						  valor_desconto = v_valor_desconto[count]);
								} else {
									WriteOutput('EDITA');
									set_desconto = this.upd_contrato_fechamento_desconto(controle_id	= v_controle_id[count],
																					     fechamento_id = arguments.FECHAMENTO_ID,
																						 num_nota_id   = v_num_nota_id[count],
																						 placa         = v_cod_veiculo[count],
																						 valor_desconto = v_valor_desconto[count]);
								}
						</cfscript>
                        <cfif set_desconto.erro>
                        	<cfthrow object="#set_desconto.mensagem#">
                        </cfif>
				</cfloop>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Descontos inseridos com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Insere desconto
    -- guto 10/10/2008 10:51:52 - CRIADO
    --->
    <cffunction name='ins_contrato_fechamento_desconto' displayname='Insere desconto' access='remote' returntype='Struct' output='true'>
        <cfargument name='FECHAMENTO_ID' required='yes'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='VALOR_DESCONTO' required='yes'>
        <cftry>
            <cfstoredproc procedure='manutencao.pkg_contrato.prc_ins_contrato_desconto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FECHAMENTO_ID#'  null='#iif(len(trim(arguments.FECHAMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_DESCONTO#'  null='#iif(len(trim(arguments.VALOR_DESCONTO)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
    -- PROPSITO
    -- Altera desconto
    -- publico 10/10/2008 10:53:28 - CRIADO
    --->
    <cffunction name='upd_contrato_fechamento_desconto' displayname='Altera desconto' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='FECHAMENTO_ID' required='yes'>
        <cfargument name='NUM_NOTA_ID' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='VALOR_DESCONTO' required='yes'>
        <cftry>
            <cfstoredproc procedure='manutencao.pkg_contrato.prc_alt_contrato_desconto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FECHAMENTO_ID#'  null='#iif(len(trim(arguments.FECHAMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_DESCONTO#'  null='#iif(len(trim(arguments.VALOR_DESCONTO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	<!---
    -- PROPSITO
    -- Exclui desconto
    -- publico 10/10/2008 10:53:28 - CRIADO
    --->
    <cffunction name='del_contrato_fechamento_desconto' displayname='Altera desconto' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='manutencao.pkg_contrato.prc_del_contrato_desconto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Abre ordem de servio
	-- guto 06/10/2006 16:06:54 - CRIADO
	--->
	<cffunction name='abre_ordem_servico' displayname='Abre ordem de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='DATA_ABERTURA' required='yes'>
		<cfargument name='COD_PESSOA_OFICINA' required='no' default="#session.COD_PESSOA#">
		<cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
		<cfargument name='EMPRESA' required='no' default="1">
		<cfargument name='CONTROLE_ID_TABELA' required='no' default="">
		<cfargument name='CONTROLE_ID_ATIVIDADE' required='no' default="">
		<cfargument name='ABRIR_INDIVIDUAL' required='no' default="0">
		<cfargument name='SOCORRO' required='no' default="0">
        <cfargument name='ORDEM_SERVICO_ID_VINCULO' required='yes'>
		<cfargument name='TIPO_ORDEM_SERVICO_ID' required='no' default="">
        <cfargument name='KM_ATUAL' required='no' default="">
      	<cfargument name='COD_CENTRO_CUSTO' required='no' default="#session.COD_CENTRO_CUSTO#">
        <cfargument name='CONTROLE_ID' required="no" default="">
		<cfargument name='SOLICITACAO_ID_PENDENCIA' required="no" default="">
		<cftry>
			<cftransaction action='begin'>
				<cfif arguments.ABRIR_INDIVIDUAL eq 0>
					 <cfscript>
						conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
						v_composicao = conn.get_composicao(equipamento_id = arguments.EQUIPAMENTO_ID);
					</cfscript>
				<cfelse>
					 <cfscript>
						v_composicao = arguments.EQUIPAMENTO_ID;
					</cfscript>
				</cfif>
                <cfif not Len(Trim(v_composicao))>
					 <cfscript>
						v_composicao = arguments.EQUIPAMENTO_ID;
					</cfscript>
                </cfif>
				<cfloop index="V_EQUIP" list="#v_composicao#">
					<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_abre_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#V_EQUIP#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ABERTURA#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_OFICINA#'  null='#iif(len(trim(arguments.COD_PESSOA_OFICINA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_PESSOA_RESPONSAVEL)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMPRESA#'  null='#iif(len(trim(arguments.EMPRESA)), de('no'), de('yes'))#'>
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_ORDEM_SERVICO'  null='yes'>
						<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   variable='retorno.ORDEM_SERVICO_ID'  null='yes'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.SOCORRO#'>
                  		<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID_VINCULO#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID_VINCULO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.TIPO_ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                  		<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_ATUAL#'  null='#iif(len(trim(arguments.KM_ATUAL)), de('no'), de('yes'))#'>
                  		<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					</cfstoredproc>
					<!---Insere atividades--->
					<cfif Len(Trim(arguments.CONTROLE_ID_ATIVIDADE))>
						<cfloop index="i" delimiters="," list="#arguments.CONTROLE_ID_ATIVIDADE#">
                        	<cfif GetToken(i,2,'_') eq V_EQUIP >
								<cfscript>
									ret3 = this.ins_os_atividade_private(ordem_servico_id   = retorno.ORDEM_SERVICO_ID,
																		 atividade_id       = GetToken(i,1,'_'),
																		 posicao_id         = GetToken(i,3,'_'),
																		 observacao			= arguments['OBS_'&GetToken(i,4,'_')],
																		 controle_id_tabela = '');
                                </cfscript>
                                <cfif ret3.erro>
                                    <cfthrow object="#ret3.mensagem#">
                                </cfif>
                            </cfif>
						</cfloop>
					</cfif>

					<!---Insere pendencias--->
					<cfif Len(Trim(arguments.SOLICITACAO_ID_PENDENCIA))>
						<cfloop index="i" delimiters="," list="#arguments.SOLICITACAO_ID_PENDENCIA#">
                        	<cfif GetToken(i,2,'_') eq V_EQUIP >
								<cfscript>
									ret3 = this.ins_os_equip_solicitacao(SOLICITACAO_ID   = GetToken(i,1,'_'),
                                                                         ORDEM_SERVICO_ID = retorno.ORDEM_SERVICO_ID);
                                </cfscript>
                                <cfif ret3.erro>
                                    <cfthrow object="#ret3.mensagem#">
                                </cfif>
                            </cfif>
						</cfloop>
					</cfif>

                    <!---Insere tabela--->
					<cfif Len(Trim(arguments.CONTROLE_ID_TABELA))>
						<cfloop index="i" delimiters="," list="#arguments.CONTROLE_ID_TABELA#">
                        	<cfif GetToken(i,2,'_') eq V_EQUIP >
								<cfscript>
                                        ret = this.ins_os_tabela_manutencao(ordem_servico_id = retorno.ORDEM_SERVICO_ID,
                                                                            tabela_id     = GetToken(i,1,'_'));
                                </cfscript>
                                <cfif ret.erro>
                                    <cfthrow object="#ret.mensagem#">
                                </cfif>
                            </cfif>
						</cfloop>
					</cfif>

					<!---Insere Atendimento no caso de OS de socorro--->
                    <cfif IsDefined("arguments.CONTROLE_ID_ATENDIMENTO_0")>
                        <cfscript>
                            v_cod_pessoa_mecanico   = this.ListaToArray (lista = arguments, variavel = "COD_PESSOA_MECANICO_ATENDIMENTO");
                            v_placa_veiculo_socorro = this.ListaToArray (lista = arguments, variavel = "PLACA_VEICULO_SOCORRO_ATENDIMENTO");
                            v_data_saida 			= this.ListaToArray (lista = arguments, variavel = "DATA_SAIDA_ATENDIMENTO");
                        </cfscript>
                        <cfloop from="1" to="#ArrayLen(v_cod_pessoa_mecanico)#" index="count">
                            <cfscript>
                                ret = this.ins_os_atendimento_private(ordem_servico_id	  	= retorno.ORDEM_SERVICO_ID,
																	  cod_pessoa_mecanico   = v_cod_pessoa_mecanico[count],
																	  placa_veiculo_socorro = v_placa_veiculo_socorro[count],
																	  data_saida			= v_data_saida[count]);
                            </cfscript>
                            <cfif ret.erro>
                                <cfthrow object="#ret.mensagem#">
                            </cfif>
                        </cfloop>
                    </cfif>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem(ns) de servio aberta(s) com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!---
    -- PROP?SITO
    -- Envia e-mail apos abertura de Ordem de servio
    -- Igor 27/12/2019 10:05:41 - CRIADO
	--->

    <cffunction name='envia_email_ordem_servico' displayname='Envia e-mail ao abrir O.S' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='P_TITULO' required='yes'>
		<cfargument name='P_TIPO' required='yes'>
			<cftry>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.PRC_ENVIA_EMAIL_OS' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                	<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.P_TITULO#'  null='#iif(len(trim(arguments.P_TITULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.P_TIPO#'  null='#iif(len(trim(arguments.P_TIPO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('E-mail enviado com sucesso!.')>
			<cfcatch type="exception">
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
			</cftry>
        <cfreturn retorno />
    </cffunction> 

    <!---
	-- PROPSITO
	-- Vincula atividade a OS - PRIVATE
	-- guto 21/09/2006 15:58:34 - CRIADO
	--->
	<cffunction name='ins_os_atividade_private' displayname='Vincula atividade a OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cfargument name='CONTROLE_ID_TABELA' required='yes'>
		<cfargument name='GERADA_POR' required='no' default="1">
		<cfargument name='CONTROLE_ID_ORDEM_COMPRA' required='no' default="">
		<cfargument name='HORA_COMBINADA' required='no' default="">
		<cfargument name='MINUTO_COMBINADA' required='no' default="">
		<cfargument name='FORA_CONTRATO' required='no' default="">
		<cfargument name='CUSTO_ATIVIDADE' required='no' default="">
        <cfargument name='OBSERVACAO' required="no" default="">
		<cfargument name='QUANTIDADE' required='no' default="1">
		<cfargument name='VALOR_UNITARIO' required='no' default="">
        	<cftry>
                    <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_os_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID_TABELA#'  null='#iif(len(trim(arguments.CONTROLE_ID_TABELA)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GERADA_POR#'  null='#iif(len(trim(arguments.GERADA_POR)), de('no'), de('yes'))#'>

                        <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
                        <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >

                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.HORA_COMBINADA#'  null='#iif(len(trim(arguments.HORA_COMBINADA)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MINUTO_COMBINADA#'  null='#iif(len(trim(arguments.MINUTO_COMBINADA)), de('no'), de('yes'))#'>

                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FORA_CONTRATO#'  null='#iif(len(trim(arguments.FORA_CONTRATO)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CUSTO_ATIVIDADE#'  null='#iif(len(trim(arguments.CUSTO_ATIVIDADE)), de('no'), de('yes'))#'>
                        <cfprocparam type="in" cfsqltype="cf_sql_varchar"  value="#arguments.OBSERVACAO#" null='#iif(len(trim(arguments.OBSERVACAO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
                    </cfstoredproc>
                    <cfset retorno.erro = false>
                    <cfset retorno.mensagem = JSStringFormat('Atividade inserida com sucesso!')>
            <cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
        </cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere uma tabela de manutencao em uma OS
	-- LOUIS 19/06/2007 10:58:22  - CRIADO
	--->
	<cffunction name='ins_tabela_manutencao_os' displayname='Insere uma tabela de manutencao em uma OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='TABELA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_os_tabela_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tabela vinculada a OS com sucesso!')>
		</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Insere atendimento a OS de Socorro
    -- guto 03/09/2007 17:18:41 - CRIADO
    --->
    <cffunction name='ins_os_atendimento_private' displayname='Insere atendimento a OS de Socorro' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORDEM_SERVICO_ID' required='yes'>
        <cfargument name='COD_PESSOA_MECANICO' required='yes'>
        <cfargument name='PLACA_VEICULO_SOCORRO' required='yes'>
        <cfargument name='DATA_SAIDA' required='yes'>
                <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_os_atendimento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_MECANICO#'  null='#iif(len(trim(arguments.COD_PESSOA_MECANICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_VEICULO_SOCORRO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SAIDA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
                </cfstoredproc>
        <cfreturn structnew() />
    </cffunction>

    <!---
	-- PROPSITO
	-- Vincula uma tabela de manuteno a uma ordem de servio
	-- ANDERSONC 23/11/2009 09:05:38 - CRIADO
	--->
	<cffunction name='ins_os_tabela_manutencao' displayname='Vincula uma tabela de manuteno a uma ordem de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='TABELA_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_os_tabela_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Tabela de manuteno vinculada com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Altera vinculo
    -- guto 09/10/2008 11:20:11 - CRIADO
    --->
    <cffunction name='upd_os_tabela_manutencao' displayname='Altera vinculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='ORDEM_SERVICO_ID' required='yes'>
        <cfargument name='TABELA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_alt_os_tabela_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TABELA_ID#'  null='#iif(len(trim(arguments.TABELA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!---
	-- PROPSITO
	-- Desvincula tabela de manuteno a uma OS
	-- guto 21/09/2006 15:11:37 - CRIADO
	--->
	<cffunction name='del_os_tabela_manutencao' displayname='Desvincula tabela de manuteno a uma OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_del_os_tabela_manutencao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
        <cfset retorno.erro = false>
        <cfset retorno.mensagem = JSStringFormat('Ok')>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />

	</cffunction>

    <!---
	-- PROPSITO
	-- Abre a execuo do processo
	-- guto 17/10/2006 09:54:42 - CRIADO
	--->
	<cffunction name='abre_processo_execucao' displayname='Abre a execuo do processo' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='COD_PESSOA_PRINCIPAL' required='yes'>
		<cfargument name='COD_PESSOA_AUXILIAR' required='no' default="">
		<cfargument name='DATA_INICIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfset v_lista_completa = listconcat(arguments.CONTROLE_ID,'',1)>
				<cfloop index="id" list="#v_lista_completa#" delimiters=",">
						<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_abre_processo_execucao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#id#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_PRINCIPAL#'  null='#iif(len(trim(arguments.COD_PESSOA_PRINCIPAL)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_AUXILIAR#'  null='#iif(len(trim(arguments.COD_PESSOA_AUXILIAR)), de('no'), de('yes'))#'>
							<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
							<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EXECUCAO_ID' >
							<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
						</cfstoredproc>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('execuo aberta com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere a atividade para marcar o material
	-- guto 21/09/2006 15:37:48 - CRIADO
	--->
	<cffunction name='ins_marca_material' displayname='Insere a atividade para marcar o material' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ORDEM_SERVICO_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.PRC_MARCA_MATERIAL' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.COD_EQUIPAMENTO' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.EQUIPAMENTO_ID_GERADO' >
				</cfstoredproc>

                <cfif Len(Trim(arguments.ORDEM_SERVICO_ID))>
                    <cfstoredproc procedure='manutencao.pkg_manutencao.prc_ins_equipamento_analise' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#retorno.EQUIPAMENTO_ID_GERADO#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#LSDateFormat(Now())# #LSTimeFormat(Now())#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#session.cod_pessoa#'>
                        <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ANALISE_ID' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                    </cfstoredproc>
                </cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Equipamento numero ' & retorno.COD_EQUIPAMENTO & ' registrado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch.Detail>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Vincula material a OS
	-- GUTO 11/10/2006 09:52:59 - CRIADO
	--->
	<cffunction name='ins_os_material' displayname='Vincula material a OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='COD_PESSOA_RETIRADA' required='yes'>
		<cfargument name='ETIQUETA_ID' required='no' default="">
		<cfargument name='OBSERVACAO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					  // Material
					  v_material_id = this.ListaToArray (lista = arguments, variavel = "MATERIAL_ID_MATERIAL");
					  v_posicao_id  = this.ListaToArray (lista = arguments, variavel = "MAT_POSICAO_ID_MATERIAL");
					  v_quantidade  = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_MATERIAL");
					  v_cod_equipamento_montado  = this.ListaToArray (lista = arguments, variavel = "COD_EQUIPAMENTO_MONTADO_MATERIAL");
					  v_cod_equipamento_retirado  = this.ListaToArray (lista = arguments, variavel = "COD_EQUIPAMENTO_RETIRADO_MATERIAL");
					  v_cod_equipamento_componente = this.ListaToArray (lista = arguments, variavel = "COD_EQUIPAMENTO_COMPONENTE_MATERIAL");
					  v_list_etiquetas = this.ListaToArray(lista = arguments, variavel = "ETIQUETA_ID_MATERIAL");
				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_material_id)#" index="count">
					<cfscript>
						set_material = this.ins_os_material_private( ordem_servico_id = arguments.ORDEM_SERVICO_ID,
												 	         cod_pessoa_retirada = arguments.COD_PESSOA_RETIRADA,
													         cod_equipamento_montado = v_cod_equipamento_montado[count],
													         cod_equipamento_retirado = v_cod_equipamento_retirado[count],
													         cod_equipamento_componente = v_cod_equipamento_componente[count],
													         material_id      = v_material_id[count],
													         posicao_id       = v_posicao_id[count],
													         quantidade       = v_quantidade[count],
													         ORGANIZACIONAL_ID_ORIGEM = arguments.ORGANIZACIONAL_ID_ORIGEM,
															 etiqueta_id	  = v_list_etiquetas[count],
															 OBSERVACAO = arguments.OBSERVACAO
															       );

					</cfscript>
                    <cfif set_material.erro>
                    	<cfthrow object="#set_material.mensagem#">
                    </cfif>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Material retirado do almoxarifado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Vincula material a OS
	-- guto 21/09/2006 15:37:48 - CRIADO
	--->
	<cffunction name='ins_os_material_private' displayname='Vincula material a OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cfargument name='COD_PESSOA_RETIRADA' required='yes'>
		<cfargument name='COD_EQUIPAMENTO_MONTADO' required='no' default="">
		<cfargument name='COD_EQUIPAMENTO_RETIRADO' required='no' default="">
		<cfargument name='COD_EQUIPAMENTO_COMPONENTE' required='no' default="">
		<cfargument name='VALOR_UNITARIO' required='no' default="">
        <cfargument name='VALOR_TOTAL' required='no' default="">
        <cfargument name='FORA_CONTRATO' required='no' default="">
		<cfargument name='ORGANIZACIONAL_ID_ORIGEM' required='no' default="">
        <cfargument name='ETIQUETA_ID' required='no' default="">
		<cfargument name='OBSERVACAO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>

			<!--- Inserção de Etiquetas--->
               <cfif len(trim(arguments.ETIQUETA_ID))>
			<cfscript>
                   v_etiqueta_id = ListToArray(arguments.ETIQUETA_ID);
               </cfscript>

               <cfloop from="1" to="#ArrayLen(v_etiqueta_id)#" index="count">
                   <cfscript>
                      retorno = this.ins_lista_temp(VALOR = v_etiqueta_id[count]
                                                  , TIPO  = 'EOPER_ETIQUETA_ID' );
                   </cfscript>
                   <cfif retorno.erro>
                       <cfthrow object="#ret.mensagem#">
                   </cfif>
               </cfloop>
			</cfif>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_os_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_EQUIPAMENTO_MONTADO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_EQUIPAMENTO_RETIRADO#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_EQUIPAMENTO_COMPONENTE#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RETIRADA#'  null='#iif(len(trim(arguments.COD_PESSOA_RETIRADA)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FORA_CONTRATO#'  null='#iif(len(trim(arguments.FORA_CONTRATO)), de('no'), de('yes'))#'>
				    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value=''  null=yes>
				    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGANIZACIONAL_ID_ORIGEM#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID_ORIGEM)), de('no'), de('yes'))#'>
				    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'     value='#arguments.observacao#'>

				</cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material vinculado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Exclui material da OS e retorna para o estoque
	-- guto 11/10/2006 11:08:52 - CRIADO
	--->
	<cffunction name='del_os_material' displayname='Exclui material da OS e retorna para o estoque' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
	    <cfargument name='ETIQUETA_ID' required='no' default="">



		<cftry>
			<cftransaction action='begin'>

			<!--- Inserção de Etiquetas--->
               <cfif len(trim(arguments.ETIQUETA_ID))>
			<cfscript>
                   v_etiqueta_id = ListToArray(arguments.ETIQUETA_ID);
               </cfscript>

               <cfloop from="1" to="#ArrayLen(v_etiqueta_id)#" index="count">
                   <cfscript>
                      retorno = this.ins_lista_temp(VALOR = v_etiqueta_id[count]
                                                  , TIPO  = 'EOPER_ETIQUETA_ID' );
                   </cfscript>
                   <cfif retorno.erro>
                       <cfthrow object="#ret.mensagem#">
                   </cfif>
               </cfloop>
			</cfif>


            <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_del_os_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material devolvido com sucesso ao almoxarifado!')>
     		</cftransaction>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem_str = cfcatch.Detail>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Altera material vinculado ao equipamento na analise de equipamentos
	-- LOUIS 30/07/2007 10:44 - CRIADO
	--->
	<cffunction name='alt_material_analise' displayname='Altera recurso' access='remote' returntype='Struct' output='true'>;
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_alt_material_analise' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Material alterado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere o fechamento uma execuo
	-- guto 17/10/2006 11:48:22 - CRIADO
	--->
	<cffunction name='fecha_processo_execucao' displayname='Insere o fechamento uma execuo' access='remote' returntype='Struct' output='true'>
		<cfargument name='EXECUCAO_ID' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='FECHA_EXECUCAO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='COD_PESSOA_AUXILIAR' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_fecha_processo_execucao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EXECUCAO_ID#'  null='#iif(len(trim(arguments.EXECUCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FECHA_EXECUCAO#'  null='#iif(len(trim(arguments.FECHA_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_AUXILIAR#'  null='#iif(len(trim(arguments.COD_PESSOA_AUXILIAR)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('execuo fechada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Executa o fechamento da OS.
	-- guto 18/10/2006 08:14:14 - CRIADO
	--->
	<cffunction name='fecha_ordem_servico' displayname='Executa o fechamento da OS.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='DATA_FECHAMENTO' required='yes'>
		<cfargument name='NUM_CONTROLE' required='no' default="">
		<cfargument name='NUM_NOTA_ID' required='no' default="">
		<cfargument name='VALOR_SERVICO' required='no' default="">

        <cfargument name='CONTROLE_ID_EXECUTAR' required='no' default="">
        <cfargument name='CONTROLE_ID_CANCELAR' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
                <cfif Len(Trim(arguments.NUM_CONTROLE)) >
                    <cfloop list="#arguments.NUM_CONTROLE#" index="item" delimiters=",">
                        <cfscript>
                            ins_os_ordem_compra = this.ins_os_ordem_compra(ordem_servico_id = arguments.ordem_servico_id,
                                                                           num_controle = item);

                        </cfscript>
                        <cfif ins_os_ordem_compra.erro>
                            <cfthrow object="#ins_os_ordem_compra.mensagem#">
                        </cfif>
                    </cfloop>
                </cfif>

                <!---Vincula Solicitações do Motorista--->
                <cfif Len(Trim(arguments.CONTROLE_ID_EXECUTAR)) >
                    <cfloop list="#arguments.CONTROLE_ID_EXECUTAR#" index="solicitacao_executar" delimiters=",">
                        <cfscript>
                            vincula_solicitacao = this.equip_solicitacao_ok( SOLICITACAO_ID   = solicitacao_executar,
                                                                             ORDEM_SERVICO_ID_EXECUCAO = arguments.ORDEM_SERVICO_ID);
                        </cfscript>
                        <cfif isDefined("vincula_solicitacao.erro") and vincula_solicitacao.erro>
                            <cfthrow object="#vincula_solicitacao.mensagem#">
                        </cfif>
                    </cfloop>
                </cfif>

                <!---Desvincula Solicitações do Motorista--->
                <cfif Len(Trim(arguments.CONTROLE_ID_CANCELAR)) >
                    <cfloop list="#arguments.CONTROLE_ID_CANCELAR#" index="solicitacao_cancelar" delimiters=",">
                        <cfscript>
                            desvincula_solicitacao = this.desvincula_solicitacao_os( solicitacao_id   = solicitacao_cancelar);
                        </cfscript>
                        <cfif isDefined("desvincula_solicitacao.erro") and desvincula_solicitacao.erro>
                            <cfthrow object="#desvincula_solicitacao.mensagem#">
                        </cfif>
                    </cfloop>
                </cfif>

                <cfscript>
					fecha_os = this.fecha_os(ORDEM_SERVICO_ID = arguments.ORDEM_SERVICO_ID
					                        ,DATA_FECHAMENTO  = arguments.DATA_FECHAMENTO
											,NUM_NOTA_ID	  = arguments.NUM_NOTA_ID
											);
				</cfscript>
				<cfif fecha_os.erro>
					<cfthrow object="#fecha_os.mensagem#">
				</cfif>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de servio fechada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Marcar Solicitao do Motorista como atendida
	-- RAFAEL 08/01/2010 14:34:14 - CRIADO
	--->
	<cffunction name='equip_solicitacao_ok' displayname='Marcar Solicitao do Motorista como atendida' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='NOVO_TEXTO' required='no' default="">
		<cfargument name='ORDEM_SERVICO_ID_EXECUCAO' required='yes'>
		<cftry>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_equip_solicitacao_ok' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOVO_TEXTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID_EXECUCAO#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID_EXECUCAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao atendida com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Desvincular Solicitao de uma Ordem de servio
	-- RAFAEL 25/05/2010 13:48:31 - CRIADO
	--->
	<cffunction name='desvincula_solicitacao_os' displayname='Desvincular Solicitao de uma Ordem de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='manutencao.pkg_manutencao.prc_solicitacao_desvincula' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
        <cfcatch>
            <cftransaction action='rollback'/>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Exclui uma OS da atividade
	-- guto 28/11/2006 11:57:25 - CRIADO
	--->
	<cffunction name='del_os_atividade' displayname='Exclui uma OS da atividade' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_del_os_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Atividade excluda com sucesso!')>
			<cfcatch>
            	<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere o fechamento de processos pendentes
	-- arlen 30/11/2006 10:48:22 - CRIADO
	--->
	<cffunction name='fecha_processos_pendentes' displayname='Insere o fechamento da execuo de processos pendentes' access='remote' returntype='Struct' output='true'>
		<cfargument name='EXECUCAO_ID' required='yes'>
		<cfargument name='DATA_TERMINO' required='yes'>
		<cfargument name='FECHA_EXECUCAO' required='yes'>
		<cfargument name='OBSERVACAO' required='no' default="">
		<cfargument name='COD_PESSOA_AUXILIAR' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfloop index="id" list="#arguments.EXECUCAO_ID#" delimiters=",">
					<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_fecha_processo_execucao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#id#'  null='#iif(len(trim(arguments.EXECUCAO_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FECHA_EXECUCAO#'  null='#iif(len(trim(arguments.FECHA_EXECUCAO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_AUXILIAR#'  null='#iif(len(trim(arguments.COD_PESSOA_AUXILIAR)), de('no'), de('yes'))#'>
					</cfstoredproc>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('execuo fechada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere uma Solicitao para um equipamento
	-- ANDERSONC 16/12/2009 16:51:36 - CRIADO
	--->
	<cffunction name='ins_equipamento_solicitacao' displayname='Insere uma Solicitao para um equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='DATA_SOLICITACAO' required='yes'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
        <cfargument name='ORDEM_SERVICO_ID' required='no' default="">
		<cftry>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_ins_equip_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SOLICITACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TEXTO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#' variable='retorno.SOLICITACAO_ID'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_PESSOA_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>

                <!---Vincula Solicitao a OS --->
				<cfif Len(Trim(arguments.ORDEM_SERVICO_ID))>
					<cfscript>
                        ret = this.ins_os_equip_solicitacao(SOLICITACAO_ID	  = retorno.SOLICITACAO_ID,
                                                            ORDEM_SERVICO_ID  = arguments.ORDEM_SERVICO_ID);
                    </cfscript>
                    <cfif ret.erro>
                        <cfthrow object="#ret.mensagem#">
                    </cfif>
                </cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao inserida com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera uma Solicitao de um equipamento
	-- ANDERSONC 16/12/2009 16:52:43 - CRIADO
	--->
	<cffunction name='alt_equipamento_solicitacao' displayname='Altera uma Solicitao de um equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='DATA_SOLICITACAO' required='yes'>
		<cfargument name='TEXTO' required='yes'>
		<cfargument name='ATENDIDA' required='yes'>
		<cfargument name='ORDEM_SERVICO_ID_EXECUCAO' required='yes'>
		<cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
		<cfargument name='TIPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_alt_equip_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_SOLICITACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TEXTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATENDIDA#'  null='#iif(len(trim(arguments.ATENDIDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID_EXECUCAO#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID_EXECUCAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_PESSOA_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Cancela Solicitao de um equipamento
	-- ANDERSONC 16/12/2009 16:52:43 - CRIADO
	--->
	<cffunction name='cancela_equipamento_solicitacao' displayname='Altera uma Solicitao de um equipamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.PRC_CANCELA_EQUIP_SOLICITACAO' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao cancelada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere uma ordem de servio no sistema
	-- guto 21/09/2006 14:16:42 - CRIADO
	--->
	<cffunction name='ins_ordem_servico' displayname='Insere uma ordem de servio no sistema' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ORDEM_SERVICO' required='yes'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='DATA_ABERTURA' required='yes'>
		<cfargument name='DATA_ATENDIMENTO' required='yes'>
		<cfargument name='DATA_FECHAMENTO' required='yes'>
		<cfargument name='COD_PESSOA_OFICINA' required='yes'>
		<cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
		<cfargument name='VALOR_SERVICO' required='yes'>
		<cfargument name='NUM_NOTA_ID' required='no' default="">
		<cfargument name='NUM_CONTROLE' required='no' default="">
		<cfargument name='OBSERVACAO' required='no' default="">
        <cfargument name='TIPO_ORDEM_SERVICO_ID' required='no' default="">
        <cfargument name='TIPO_MANUTENCAO_ID' required='no' default="">
        <cfargument name='ENVIA_EMAIL' required='no' default="">
        <cfargument name='KM_ABERTURA' required='yes'>
		<cfargument name='ORDEM_SERVICO_ID_VINCULO' required='no' default="">
		<cfargument name='SOLICITACAO_ID_PENDENCIA' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ORDEM_SERVICO#' variable='retorno.NUM_ORDEM_SERVICO'  null='#iif(len(trim(arguments.NUM_ORDEM_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ABERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ATENDIMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_OFICINA#'  null='#iif(len(trim(arguments.COD_PESSOA_OFICINA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_PESSOA_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='cf_sql_varchar' SCALE='5'   value='#arguments.OBSERVACAO#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   variable='retorno.ORDEM_SERVICO_ID'  null='yes'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.TIPO_ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_ABERTURA#'  null='#iif(len(trim(arguments.KM_ABERTURA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_MANUTENCAO_ID#'  null='#iif(len(trim(arguments.TIPO_MANUTENCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID_VINCULO#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID_VINCULO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfscript>
				  // Tabela
				  v_tabela_id = this.ListaToArray (lista = arguments, variavel = "TABELA_ID_TABELA");

				  // Atividade
				  v_atividade_id = this.ListaToArray (lista = arguments, variavel = "ATIVIDADE_ID_ATIVIDADE");
				  v_posicao_atv_id = this.ListaToArray (lista = arguments, variavel = "ATV_POSICAO_ID_ATIVIDADE");
				  v_fora_contrato = this.ListaToArray (lista = arguments, variavel = "FORA_CONTRATO_ATIVIDADE");
				  v_custo_atividade = this.ListaToArray (lista = arguments, variavel = "ATV_VALOR_TOTAL_ATIVIDADE");
				  v_controle_id_ordem_compra = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_ORDEM_COMPRA_ATIVIDADE");
				  v_controle_id_tabela = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_TABELA_ATIVIDADE");
				  v_atv_quantidade = this.ListaToArray (lista = arguments, variavel = "ATV_QUANTIDADE_ATIVIDADE");
				  v_atv_valor_unitario = this.ListaToArray (lista = arguments, variavel = "ATV_VALOR_UNITARIO_ATIVIDADE");

				  // Material
				  v_material_id = this.ListaToArray (lista = arguments, variavel = "MATERIAL_ID_MATERIAL");
				  v_posicao_id  = this.ListaToArray (lista = arguments, variavel = "MAT_POSICAO_ID_MATERIAL");
				  v_quantidade  = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_MATERIAL");
				  v_cod_equipamento_montado     = this.ListaToArray (lista = arguments, variavel = "COD_EQUIPAMENTO_MONTADO_MATERIAL");
				  v_cod_equipamento_retirado    = this.ListaToArray (lista = arguments, variavel = "COD_EQUIPAMENTO_RETIRADO_MATERIAL");
				  v_cod_equipamento_componente  = this.ListaToArray (lista = arguments, variavel = "COD_EQUIPAMENTO_COMPONENTE_MATERIAL");
				  v_valor_unitario  = this.ListaToArray (lista = arguments, variavel = "VALOR_UNITARIO_MATERIAL");
				  v_valor_total  = this.ListaToArray (lista = arguments, variavel = "VALOR_TOTAL_MATERIAL");
				  v_fora_contrato_mat  = this.ListaToArray (lista = arguments, variavel = "VALOR_TOTAL_MATERIAL");
				</cfscript>

                <cfloop from="1" to="#ArrayLen(v_tabela_id)#" index="count">
					<cfscript>
						ins_os_tabela = this.ins_os_tabela_manutencao(ordem_servico_id = retorno.ORDEM_SERVICO_ID,
													  				  tabela_id        = v_tabela_id[count]);

					</cfscript>
                    <cfif ins_os_tabela.erro>
                    	<cfthrow object="#ins_os_tabela.mensagem#">
                    </cfif>
				</cfloop>

				<cfloop from="1" to="#ArrayLen(v_atividade_id)#" index="count">
					<cfscript>
						ins_os_atividade = this.ins_os_atividade_private( ordem_servico_id = retorno.ORDEM_SERVICO_ID,
																	   atividade_id     = v_atividade_id[count],
																	   posicao_id       = v_posicao_atv_id[count],
																	   controle_id_tabela = v_controle_id_tabela[count],
																	   controle_id_ordem_compra   = '',
																	   fora_contrato			    = '',
																	   custo_atividade	        = v_custo_atividade[count],
																	   quantidade               = v_atv_quantidade[count],
																	   valor_unitario           = v_atv_valor_unitario[count]
																	   );

					</cfscript>
                    <cfif ins_os_atividade.erro>
                    	<cfthrow object="#ins_os_atividade.mensagem#">
                    </cfif>
				</cfloop>

                <cfloop from="1" to="#ArrayLen(v_material_id)#" index="count">
					<cfscript>
                      ins_os_material = this.ins_os_material_private( ordem_servico_id = retorno.ORDEM_SERVICO_ID,
																	  material_id = v_material_id[count],
																	  cod_pessoa_retirada = arguments.COD_PESSOA_OFICINA,
																	  cod_equipamento_montado = v_cod_equipamento_montado[count],
																	  cod_equipamento_retirado = v_cod_equipamento_retirado[count],
																	  cod_equipamento_componente = v_cod_equipamento_componente[count],
																	  posicao_id = v_posicao_id[count],
																	  quantidade = v_quantidade[count],
																	  valor_unitario = v_valor_unitario[count],
																	  valor_total = v_valor_total[count],
																	  fora_contrato = v_fora_contrato_mat[count]);

                    </cfscript>
                    <cfif ins_os_material.erro>
                    	<cfthrow object="#ins_os_material.mensagem#">
                    </cfif>
                </cfloop>


				<!---<cfloop list="#arguments.NUM_CONTROLE#" index="item" delimiters=",">
					<cfscript>
						ins_os_ordem_compra = this.ins_os_ordem_compra(ordem_servico_id = retorno.ordem_servico_id,
											                           num_controle = item);

					</cfscript>
                    <cfif ins_os_ordem_compra.erro>
                    	<cfthrow object="#ins_os_ordem_compra.mensagem#">
                    </cfif>
				</cfloop>--->

                <!---Vincula Solicitações--->
				<cfif isDefined("arguments.CONTROLE_ID_SOLICITACAO")>
                    <cfloop index="i" delimiters="," list="#arguments.CONTROLE_ID_SOLICITACAO#">
                        <cfscript>
                            vincula_solicitacao = this.ins_os_equip_solicitacao(SOLICITACAO_ID		= GetToken(i,1,'_'),
                                                                            	ORDEM_SERVICO_ID	= retorno.ORDEM_SERVICO_ID);
                        </cfscript>
                        <cfif vincula_solicitacao.erro>
                            <cfthrow object="#vincula_solicitacao.mensagem#">
                        </cfif>
                    </cfloop>
                </cfif>

				<!---Insere pendencias--->
					<cfif Len(Trim(arguments.SOLICITACAO_ID_PENDENCIA))>
						<cfloop index="i" delimiters="," list="#arguments.SOLICITACAO_ID_PENDENCIA#">
                        	<cfif GetToken(i,2,'_') eq V_EQUIP >
								<cfscript>
									ret3 = this.ins_os_equip_solicitacao(SOLICITACAO_ID   = GetToken(i,1,'_'),
                                                                         ORDEM_SERVICO_ID = retorno.ORDEM_SERVICO_ID);
                                </cfscript>
                                <cfif ret3.erro>
                                    <cfthrow object="#ret3.mensagem#">
                                </cfif>
                            </cfif>
						</cfloop>
					</cfif>

				<cfif Len(Trim(arguments.DATA_FECHAMENTO)) >
                    <cfscript>
                        // Fecha ordem de servio
                        fecha_os = this.fecha_ordem_servico_private(ORDEM_SERVICO_ID = retorno.ORDEM_SERVICO_ID,
                                                                    data_fechamento = arguments.DATA_FECHAMENTO);

                    </cfscript>
                    <cfif fecha_os.erro>
                        <cfthrow object="#fecha_os.mensagem#">
                    </cfif>
                </cfif>
                <cfset arguments.ORDEM_SERVICO_ID = retorno.ORDEM_SERVICO_ID>
				<cfset retorno.mensagem = JSStringFormat('Ordem de servio N ' & retorno.NUM_ORDEM_SERVICO & ' inserida com sucesso!')>
                <cfset retorno.erro = false>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfif retorno.erro eq false>
			<cfif Len(Trim(arguments.ENVIA_EMAIL)) >
				<cfinclude template="/modulos/manutencao/ordem_servico/controle/imprimir_os.cfm">
				<cfscript>
					envia_email_os = this.private_envia_email_os_pdf(ORDEM_SERVICO_ID = arguments.ORDEM_SERVICO_ID, LISTA_EMAIL = arguments.LISTA_EMAIL , ANEXO = VARQUIVO);
				</cfscript>
				<cfif envia_email_os.erro>
					<cfthrow object="#envia_email_os.mensagem#">
				</cfif>
			</cfif>
		</cfif>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Vincular Pendncia a Ordem de servio
	-- RAFAEL 08/01/2010 09:40:12 - CRIADO
	--->
	<cffunction name='ins_os_equip_solicitacao' displayname='Vincular Pendncia a Ordem de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_ID' required='yes'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cftry>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_os_equip_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.OS_EQUIP_SOLICITACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pendncia vinculada a Ordem de servio com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Executa o fechamento da OS. PRIVATE
	-- guto 18/10/2006 08:14:14 - CRIADO
	--->
	<cffunction name='fecha_ordem_servico_private' displayname='Executa o fechamento da OS.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='DATA_FECHAMENTO' required='yes'>
        	<cftry>
                <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_fecha_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FECHAMENTO#' >
                </cfstoredproc>

				<cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ordem de servio fechada com sucesso!')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>

		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Vincula atividade a OS
	-- guto 21/09/2006 15:58:34 - CRIADO
	--->
	<cffunction name='ins_os_atividade' displayname='Vincula atividade a OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cfargument name='CONTROLE_ID_TABELA' required='yes'>
		<cfargument name='GERADA_POR' required='no' default="1">
		<cfargument name='HORA_COMBINADA' required='no' default="">
		<cfargument name='MINUTO_COMBINADA' required='no' default="">
		<cfargument name='CONTROLE_ID_ORDEM_COMPRA' required='no' default="">
		<cfargument name='FORA_CONTRATO' required='no' default="">
		<cfargument name='CUSTO_ATIVIDADE' required='no' default="">
        <cfargument name='OBSERVACAO' required='no' default="">
		<cfargument name='QUANTIDADE' required='no' default="">
		<cfargument name='VALOR_UNITARIO' required='no' default="">
		<cftry>
			<cftransaction>
			<cfscript>
					  // Material
					  v_atividade_id 				= this.ListaToArray (lista = arguments, variavel = "ATIVIDADE_ID_ATIVIDADE");
					  v_posicao_id  				= this.ListaToArray (lista = arguments, variavel = "POSICAO_ID_ATIVIDADE");
					  v_gerada_por	  				= this.ListaToArray (lista = arguments, variavel = "GERADA_POR_ATIVIDADE");
					  v_hora_combinada  			= this.ListaToArray (lista = arguments, variavel = "HORA_COMBINADA_ATIVIDADE");
					  v_minuto_combinada  			= this.ListaToArray (lista = arguments, variavel = "MINUTO_COMBINADA_ATIVIDADE");
					  v_custo_atividade  			= this.ListaToArray (lista = arguments, variavel = "CUSTO_ATIVIDADE_ATIVIDADE");
					  v_observacao					= this.ListaToArray (lista = arguments, variavel = "OBSERVACAO");
					  v_quantidade					= this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_ATIVIDADE");
					  v_valor_unitario				= this.ListaToArray (lista = arguments, variavel = "VALOR_UNITARIO_ATIVIDADE");
			</cfscript>
			<cfloop from="1" to="#ArrayLen(v_atividade_id)#" index="i">
					<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_os_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#v_atividade_id[i]#'  null='#iif(len(trim(v_atividade_id[i])), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#v_posicao_id[i]#'  null='#iif(len(trim(v_posicao_id[i])), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID_TABELA#'  null='#iif(len(trim(arguments.CONTROLE_ID_TABELA)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#v_gerada_por[i]#'  null='#iif(len(trim(v_gerada_por[i])), de('no'), de('yes'))#'>

						<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
						<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='0'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#v_hora_combinada[i]#'  null='#iif(len(trim(v_hora_combinada[i])), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#v_minuto_combinada[i]#'  null='#iif(len(trim(v_minuto_combinada[i])), de('no'), de('yes'))#'>

						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID_ORDEM_COMPRA#'  null='#iif(len(trim(arguments.CONTROLE_ID_ORDEM_COMPRA)), de('no'), de('yes'))#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FORA_CONTRATO#'  null='#iif(len(trim(arguments.FORA_CONTRATO)), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#v_custo_atividade[i]#'  null='#iif(len(trim(v_custo_atividade[i])), de('no'), de('yes'))#'>
						<cfprocparam type='in' cfsqltype='CF_SQL_VARCHAR'  value='#v_observacao[i]#' null='#iif(len(trim(v_observacao[i])), de('no'), de('yes'))#'>
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#v_custo_atividade[i]#'  null='#iif(len(trim(v_custo_atividade[i])), de('no'), de('yes'))#'>
					</cfstoredproc>
			</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Cancela ordem de servio.
	-- arlen 28/11/2006 13:38:43 - CRIADO
	--->
	<cffunction name='cancela_ordem_servico' displayname='Cancela ordem de servio.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='DATA_CANCELAMENTO' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_cancela_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_CANCELAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO_CANCELAMENTO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de servio cancelada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere uma previso de liberao
	-- guto 16/10/2006 10:35:43 - CRIADO
	--->
	<cffunction name='ins_os_previsao_liberacao' displayname='Insere uma previso de liberao' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='DATA_PREVISAO' required='yes'>
		<cfargument name='MOTIVO_ADIAMENTO' required='no'>
		<cfargument name='PREVISAO_ID' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_os_previsao_liberacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_PREVISAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MOTIVO_ADIAMENTO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PREVISAO_ID#' variable='retorno.PREVISAO_ID'  null='#iif(len(trim(arguments.PREVISAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Previso para liberao do veculo inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Exclui uma OS da atividade
	-- guto 28/11/2006 11:57:25 - CRIADO
	--->
	<cffunction name='del_os_atividade_finalizada' displayname='Exclui uma OS da atividade' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_del_os_ativ_finalizada' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Atividade excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset retorno.mensagem_str = cfcatch.Detail>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Vincula material a OS
	-- GUTO 11/10/2006 09:52:59 - CRIADO
	--->
	<cffunction name='ins_os_externa_material' displayname='Vincula material a OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='COD_PESSOA_RETIRADA' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfscript>
					  // Material
					  v_material_id = this.ListaToArray (lista = arguments, variavel = "MATERIAL_ID_MATERIAL");
					  v_posicao_id  = this.ListaToArray (lista = arguments, variavel = "MAT_POSICAO_ID_MATERIAL");
					  v_quantidade  = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_MATERIAL");
					  v_valor_unitario  = this.ListaToArray (lista = arguments, variavel = "VALOR_UNITARIO_MATERIAL");
					  v_valor_total     = this.ListaToArray (lista = arguments, variavel = "VALOR_TOTAL_MATERIAL");
					  v_cod_equipamento_montado  = this.ListaToArray (lista = arguments, variavel = "COD_EQUIPAMENTO_MONTADO_MATERIAL");
					  v_cod_equipamento_retirado  = this.ListaToArray (lista = arguments, variavel = "COD_EQUIPAMENTO_RETIRADO_MATERIAL");
					  v_cod_equipamento_componente = this.ListaToArray (lista = arguments, variavel = "COD_EQUIPAMENTO_COMPONENTE_MATERIAL");
					  v_list_etiquetas = this.ListaToArray(lista = arguments, variavel = "ETIQUETA_ID");


				</cfscript>
				<cfloop from="1" to="#ArrayLen(v_material_id)#" index="count">

					<cfscript>
						set_material = this.ins_os_material_private( ordem_servico_id = arguments.ORDEM_SERVICO_ID,
																	 cod_pessoa_retirada = arguments.COD_PESSOA_RETIRADA,
																	 cod_equipamento_montado = v_cod_equipamento_montado[count],
																	 cod_equipamento_retirado = v_cod_equipamento_retirado[count],
																	 cod_equipamento_componente = v_cod_equipamento_componente[count],
																	 valor_unitario = v_valor_unitario[count],
																	 valor_total	= v_valor_total[count],
																	 material_id      = v_material_id[count],
																	 posicao_id       = v_posicao_id[count],
																	 quantidade       = v_quantidade[count],
																	 ORGANIZACIONAL_ID_ORIGEM = arguments.ORGANIZACIONAL_ID_ORIGEM,
																	 etiqueta_id	  = v_list_etiquetas[count]);

					</cfscript>
                    <cfif set_material.erro>
                    	<cfthrow object="#set_material.mensagem#">
                    </cfif>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Materiais adicionados com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Altera uma ordem de servio
	-- louis 21/08/2007 16:07:37 - CRIADO
	--->
	<cffunction name='upd_ordem_servico' displayname='Altera uma ordem de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='NUM_ORDEM_SERVICO' required='yes'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='DATA_ABERTURA' required='yes'>
		<cfargument name='DATA_ATENDIMENTO' required='yes'>
		<cfargument name='DATA_FECHAMENTO' required='yes'>
		<cfargument name='COD_PESSOA_OFICINA' required='yes'>
		<cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
		<cfargument name='EMPRESA' required='yes'>
		<cfargument name='VALOR_SERVICO' required='yes'>
		<cfargument name='TIPO_MANUTENCAO_ID' required='no' default="">
		<cfargument name='KM_ABERTURA' required='no'>
 	 	<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_alt_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ORDEM_SERVICO#'  null='#iif(len(trim(arguments.NUM_ORDEM_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ABERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ATENDIMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FECHAMENTO#' null='#iif(len(trim(arguments.DATA_FECHAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_OFICINA#'  null='#iif(len(trim(arguments.COD_PESSOA_OFICINA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_PESSOA_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMPRESA#'  null='#iif(len(trim(arguments.EMPRESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_MANUTENCAO_ID#'  null='#iif(len(trim(arguments.TIPO_MANUTENCAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_ABERTURA#'  null='#iif(len(trim(arguments.KM_ABERTURA)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de servio alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Altera o vinculo de um material a uma atividade
	-- wagner 29/10/2006 09:08:26 - CRIADO
	--->
	<cffunction name='upd_material_atividade' displayname='Altera o vinculo de um material a uma atividade' access='remote' returntype='Struct' output='true'>;
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>

		<cftry>

			<cftransaction action='begin'>
				<!--- Insere os itens para atributo do tipo LISTA --->
				<cfscript>
					v_atividade_id = this.ListaToArray (lista = arguments, variavel = "ATIVIDADE_ID_ATIVIDADES");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ATIVIDADES, lista2 = ArrayToList(v_atividade_id));
				</cfscript>
				<!--- Excluir os itens --->
				<cfloop list="#v_excluir#" delimiters="," index="l_atv_id">

					<cfscript>

						this.del_material_atividade(material_id = arguments.material_id,
													atividade_id = l_atv_id);
					</cfscript>
				</cfloop>
				<!--- Insere os Itens --->
				<cfloop from="1" to="#ArrayLen(v_atividade_id)#" index="count">
				 		<cfscript>
								this.ins_material_atividade(material_id = arguments.material_id,
														  atividade_id = v_atividade_id[count]	);
						</cfscript>
				</cfloop>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('vnculos atualizados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- desvincula um material a uma atividade
	-- wagner 29/11/2006 17:27:54 - CRIADO
	--->
	<cffunction name='del_material_atividade' displayname='desvincula um material a uma atividade' access='remote' returntype='Struct' output='true'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
			<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_material_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere o vnculo de um materia a uma atividade
	-- wagner 29/11/2006 17:24:28 - CRIADO
	--->
	<cffunction name='ins_material_atividade' displayname='Insere o vnculo de um materia a uma atividade' access='remote' returntype='Struct' output='true'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
			<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_material_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

    <!---
	-- PROPSITO
	-- Inserir Tipo de Pendncia
	-- RAFAEL 14/12/2009 17:14:33 - CRIADO
	--->
	<cffunction name='ins_equip_solicitacao_tipo' displayname='Inserir Tipo de Pendncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='NIVEL_IMPORTANCIA' required='yes'>
		<cfargument name='DADOS_ADICIONAIS' required='yes'>
		<cfargument name='CONTROLE_TRAFEGO' required='yes'>
		<cfargument name='LISTA_EMAIL' required='yes'>
		<cfargument name='BLOQUEIA_VEICULO' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_ins_equip_solicitacao_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.TIPO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NIVEL_IMPORTANCIA#'  null='#iif(len(trim(arguments.NIVEL_IMPORTANCIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DADOS_ADICIONAIS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_TRAFEGO#'  null='#iif(len(trim(arguments.CONTROLE_TRAFEGO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LISTA_EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BLOQUEIA_VEICULO#'  null='#iif(len(trim(arguments.BLOQUEIA_VEICULO)), de('no'), de('yes'))#'>
				</cfstoredproc>


					<cfscript>
						v_atividade_id = this.ListaToArray(lista = arguments, variavel = "ATIVIDADE_ID");
					</cfscript>

					<cfloop from="1" to="#ArrayLen(v_atividade_id)#" index="count">
						<cfscript>
							set_atividade = this.ins_equip_solicitacao_atv(atividade_id = v_atividade_id[count],
																			tipo_id      =  retorno.TIPO_ID
																			);
						</cfscript>
						<cfif set_atividade.erro>
							<cfthrow object="#set_atividade.mensagem#">
						</cfif>
					</cfloop>


				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Pendncia inserido com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Vincula atividade a pendncia
    -- Igor 30/07/2020 - CRIADO
    --->
    <cffunction name='ins_equip_solicitacao_atv' displayname='Altera vinculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>        
        <cftry>

            <cfstoredproc procedure='manutencao.pkg_tabela_manut.prc_ins_equip_solicitacao_atv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>

            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

		<!---
    -- PROPSITO
    -- Vincula atividade a pendncia
    -- Igor 30/07/2020 - CRIADO
    --->
    <cffunction name='del_equip_solicitacao_atv' displayname='Altera vinculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_ID' required='yes'>
		<cfargument name='ATIVIDADE_ID' required='yes'>        
        <cftry>

            <cfstoredproc procedure='manutencao.pkg_tabela_manut.prc_del_equip_solicitacao_atv' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
			</cfstoredproc>

            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Alterar Tipo de Pendncia
	-- RAFAEL 14/12/2009 17:18:13 - CRIADO
	--->
	<cffunction name='upd_equip_solicitacao_tipo' displayname='Alterar Tipo de Pendncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='NIVEL_IMPORTANCIA' required='yes'>
		<cfargument name='DADOS_ADICIONAIS' required='yes'>
		<cfargument name='CONTROLE_TRAFEGO' required='yes'>
		<cfargument name='LISTA_EMAIL' required='yes'>
		<cfargument name='BLOQUEIA_VEICULO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_alt_equip_solicitacao_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NIVEL_IMPORTANCIA#'  null='#iif(len(trim(arguments.NIVEL_IMPORTANCIA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DADOS_ADICIONAIS#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_TRAFEGO#'  null='#iif(len(trim(arguments.CONTROLE_TRAFEGO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LISTA_EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BLOQUEIA_VEICULO#'  null='#iif(len(trim(arguments.BLOQUEIA_VEICULO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Pendncia alterado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Excluir Tipo de Pendncia
	-- RAFAEL 14/12/2009 17:19:16 - CRIADO
	--->
	<cffunction name='del_equip_solicitacao_tipo' displayname='Excluir Tipo de Pendncia' access='remote' returntype='Struct' output='true'>
		<cfargument name='TIPO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao.prc_del_equip_solicitacao_tipo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ID#'  null='#iif(len(trim(arguments.TIPO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Tipo de Pendncia excludo com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Gerar PDF da OS
	-- MARCELO 30/03/2016 15:58:99EOQQ - CRIADO
	--->
	<cffunction name='gerar_os' displayname='Gerar PDF da OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_relatorio.prc_relatorio_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.ORDEM_SERVICO_ID#' null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.RELATORIO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de servio impressa com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Gerar PDF da ficha de materiais da OS
	-- 
	--->
	<cffunction name='gerar_ficha_mat_os' displayname='Gerar PDF da ficha de mateiais OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_relatorio.prc_rel_ficha_mat_os' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.ORDEM_SERVICO_ID#' null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.RELATORIO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de servio impressa com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

 <!---
	-- PROPSITO
	-- Gerar PDF das atividades a lançar OS
	-- 
	--->
	<cffunction name='gerar_ficha_ativ_os' displayname='Gerar PDF da OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_relatorio.prc_rel_ativ_tempo_os' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.ORDEM_SERVICO_ID#' null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.RELATORIO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de servio impressa com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!---
	-- PROPSITO
	-- Reabrir OS
	-- GUSTAVO R. 14/10/2016 11:09:00 - CRIADO
	--->
	<cffunction name='reabrir_os' displayname='Reabrir OS' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_abrir_os_finalizada' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.ORDEM_SERVICO_ID#' null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de servio aberta com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


<!---
    -- PROPSITO
    -- Reabre OS fechada pelo sistema
    -- guto 18/10/2006 08:14:14 - CRIADO
    --->
    <cffunction name='reabre_ordem_servico' displayname='Executa o fechamento da OS.' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORDEM_SERVICO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_reabre_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ordem de servio reaberta com sucesso. O fechamento automtico roda a cada 30 min.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Altera uma ordem de servio
	-- ANDERSONC 01/12/2009 09:56:03 - CRIADO
	--->
	<cffunction name='upd_ordem_servico_externa' displayname='Altera uma ordem de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='NUM_ORDEM_SERVICO' required='yes'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cfargument name='DATA_ABERTURA' required='yes'>
		<cfargument name='DATA_ATENDIMENTO' required='yes'>
		<cfargument name='COD_PESSOA_OFICINA' required='yes'>
		<cfargument name='COD_PESSOA_RESPONSAVEL' required='yes'>
		<cfargument name='EMPRESA' required='yes'>
		<cfargument name='VALOR_SERVICO' required='yes'>
        <cfargument name='ORDEM_SERVICO_ID_VINCULO' required='yes'>
        <cfargument name='TIPO_ORDEM_SERVICO_ID' required='yes'>
        <cfargument name='TIPO_MANUTENCAO_ID' required='no' default="">
        <cfargument name='KM_ABERTURA' required='yes'>
        <cfargument name='PEDIDO_ID' required='no' default=''>
        <cfargument name='PEDIDO_ITEM_ID' required='no' default=''>
        <cfargument name='DATA_FECHAMENTO' required='yes'>
        <cfargument name='OBSERVACAO' required='no'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_alt_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ORDEM_SERVICO#'  null='#iif(len(trim(arguments.NUM_ORDEM_SERVICO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ABERTURA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_ATENDIMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='' null='yes'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_OFICINA#'  null='#iif(len(trim(arguments.COD_PESSOA_OFICINA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_PESSOA_RESPONSAVEL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMPRESA#'  null='#iif(len(trim(arguments.EMPRESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_SERVICO#'  null='#iif(len(trim(arguments.VALOR_SERVICO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID_VINCULO#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID_VINCULO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.TIPO_ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_ABERTURA#'  null='#iif(len(trim(arguments.KM_ABERTURA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_MANUTENCAO_ID#'  null='#iif(len(trim(arguments.TIPO_MANUTENCAO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>

                <!--- Materiais --->
                <cfscript>
				    v_controle_id_mat 			 = this.ListaToArray(lista = arguments, variavel = "CONTROLE_ID_MAT_MATERIAL");
					v_material_id 				 = this.ListaToArray(lista = arguments, variavel = "MATERIAL_ID_MATERIAL");
					v_posicao_id  				 = this.ListaToArray(lista = arguments, variavel = "MAT_POSICAO_ID_MATERIAL");
					v_quantidade  				 = this.ListaToArray(lista = arguments, variavel = "QUANTIDADE_MATERIAL");
					v_cod_equipamento_montado    = this.ListaToArray(lista = arguments, variavel = "COD_EQUIPAMENTO_MONTADO_MATERIAL");
					v_cod_equipamento_retirado   = this.ListaToArray(lista = arguments, variavel = "COD_EQUIPAMENTO_RETIRADO_MATERIAL");
					v_cod_equipamento_componente = this.ListaToArray(lista = arguments, variavel = "COD_EQUIPAMENTO_COMPONENTE_MATERIAL");
					v_valor_unitario  			 = this.ListaToArray(lista = arguments, variavel = "VALOR_UNITARIO_MATERIAL");
					v_valor_total 				 = this.ListaToArray(lista = arguments, variavel = "VALOR_TOTAL_MATERIAL");
					v_mat_pedido_item_id    	 = this.ListaToArray(lista = arguments, variavel = "MAT_PEDIDO_ITEM_ID_MATERIAL");
					v_excluir_material 			 = this.ListDiff(lista1 = arguments.lista_deleted_MATERIAL, lista2 = ArrayToList(v_controle_id_mat));
				</cfscript>

                <cfloop list="#v_excluir_material#" index="del_material">
                	<cfscript>
						del_material = this.del_os_material(controle_id = del_material);
					</cfscript>
                    <cfif del_material.erro>
                    	<cfthrow object="#del_material.mensagem#">
                    </cfif>
                </cfloop>

                <cfloop from="1" to="#ArrayLen(v_material_id)#" index="count">
					<cfscript>
						if(Len(Trim(v_controle_id_mat[count]))) {
							set_material = this.upd_os_material(controle_id         = v_controle_id_mat[count],
																ordem_servico_id    = arguments.ORDEM_SERVICO_ID,
																material_id         = v_material_id[count],
																quantidade          = v_quantidade[count],
																posicao_id          = v_posicao_id[count],
																cod_pessoa_retirada = arguments.COD_PESSOA_OFICINA,
																valor_unitario      = v_valor_unitario[count],
																valor_total         = v_valor_total[count]);
						}
						else {
							set_material = this.ins_os_material_private(ordem_servico_id           = arguments.ORDEM_SERVICO_ID,
																		material_id                = v_material_id[count],
																		cod_pessoa_retirada        = arguments.COD_PESSOA_OFICINA,
																		cod_equipamento_montado    = v_cod_equipamento_montado[count],
																		cod_equipamento_retirado   = v_cod_equipamento_retirado[count],
																		cod_equipamento_componente = v_cod_equipamento_componente[count],
																		posicao_id                 = v_posicao_id[count],
																		quantidade                 = v_quantidade[count],
																		valor_unitario             = v_valor_unitario[count],
																		valor_total                = v_valor_total[count],
																	    pedido_item_id	    	   = v_mat_pedido_item_id[count]);
						}
                    </cfscript>
                    <cfif set_material.erro>
                    	<cfthrow object="#set_material.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Atividades --->
                <cfscript>
					v_controle_id_atv    = this.ListaToArray(lista = arguments, variavel = "CONTROLE_ID_ATV_ATIVIDADE");
					v_atividade_id		 = this.ListaToArray(lista = arguments, variavel = "ATIVIDADE_ID_ATIVIDADE");
					v_posicao_atv_id 	 = this.ListaToArray(lista = arguments, variavel = "ATV_POSICAO_ID_ATIVIDADE");
					v_controle_id_tabela = this.ListaToArray(lista = arguments, variavel = "CONTROLE_ID_TABELA_ATIVIDADE");
					v_atv_pedido_item_id = this.ListaToArray(lista = arguments, variavel = "ATV_PEDIDO_ITEM_ID_ATIVIDADE");
					v_atv_valor_total = this.ListaToArray(lista = arguments, variavel = "ATV_VALOR_TOTAL_ATIVIDADE");
					v_excluir_atividade  = this.ListDiff(lista1 = arguments.lista_deleted_ATIVIDADE, lista2 = ArrayToList(v_controle_id_atv));
				</cfscript>

                <cfloop list="#v_excluir_atividade#" index="deletar_atv">
					<cfscript>
						ret_del_atividade = this.del_os_atividade(controle_id = deletar_atv);
					</cfscript>
					<cfif ret_del_atividade.erro>
                    	<cfthrow object="#ret_del_atividade.mensagem#">
                    </cfif>
                </cfloop>

                <cfloop from="1" to="#ArrayLen(v_atividade_id)#" index="count">
					<cfscript>
						if(Len(Trim(v_controle_id_atv[count]))) {
							set_atividade = this.upd_os_atividade(controle_id        = v_controle_id_atv[count],
																  ordem_servico_id   = arguments.ORDEM_SERVICO_ID,
																  executada          = 1,
															      controle_id_tabela = v_controle_id_tabela[count],
																  valor				 = v_atv_valor_total[count],
																  pedido_item_id	 = v_atv_pedido_item_id[count]);
						}
						else {
							set_atividade = this.ins_os_atividade_private(ordem_servico_id   = arguments.ORDEM_SERVICO_ID,
																		  atividade_id       = v_atividade_id[count],
																		  posicao_id         = v_posicao_atv_id[count],
																		  controle_id_tabela = v_controle_id_tabela[count],
																		  custo_atividade    = v_atv_valor_total[count],
																		  pedido_item_id	 = v_atv_pedido_item_id[count]);
						}
					</cfscript>
                    <cfif set_atividade.erro>
                    	<cfthrow object="#set_atividade.mensagem#">
                    </cfif>
				</cfloop>
                <!--- Tabelas --->
                <cfscript>
				    v_tabela_controle_id = this.ListaToArray(lista = arguments, variavel = "CONTROLE_ID_TAB_TABELA");
					v_tabela_id 		 = this.ListaToArray(lista = arguments, variavel = "TABELA_ID_TABELA");
					v_excluir_tabela 	 = this.ListDiff(lista1 = arguments.lista_deleted_TABELA, lista2 = ArrayToList(v_tabela_controle_id));
				</cfscript>

                <cfloop list="#v_excluir_tabela#" index="del_tabela">
                	<cfscript>
						del_tabela = this.del_os_tabela_manutencao(controle_id = del_tabela);
					</cfscript>
                    <cfif del_tabela.erro>
                    	<cfthrow object="#del_tabela.mensagem#">
                    </cfif>
                </cfloop>

                <cfloop from="1" to="#ArrayLen(v_tabela_id)#" index="count">
					<cfscript>
						if(Len(Trim(v_tabela_controle_id[count]))) {
							set_tabela = this.upd_os_tabela_manutencao(ordem_servico_id = arguments.ORDEM_SERVICO_ID,
																	   controle_id      = v_tabela_controle_id[count],
																	   tabela_id        = v_tabela_id[count]);
						}
						else {
							set_tabela = this.ins_os_tabela_manutencao(ordem_servico_id = arguments.ORDEM_SERVICO_ID,
													  			   	   tabela_id        = v_tabela_id[count]);
						}
					</cfscript>
                    <cfif set_tabela.erro>
                    	<cfthrow object="#set_tabela.mensagem#">
                    </cfif>
				</cfloop>

                <!--- Fechamento da Ordem de servio --->
                <cfscript>
					if(Len(Trim(arguments.DATA_FECHAMENTO))) {
						set_fechamento = this.fecha_ordem_servico_private(ordem_servico_id = retorno.ORDEM_SERVICO_ID,
															 			  data_fechamento  = arguments.DATA_FECHAMENTO);
				    }
				</cfscript>
                <cfif IsDefined("set_fechamento") and set_fechamento.erro>
                    <cfthrow object="#set_fechamento.mensagem#">
                </cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de servio alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Altera vinculo
    -- guto 09/10/2008 11:23:08 - CRIADO
    --->
    <cffunction name='upd_os_atividade' displayname='Altera vinculo' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONTROLE_ID' required='yes'>
        <cfargument name='ORDEM_SERVICO_ID' required='yes'>
        <cfargument name='EXECUTADA' required='yes'>
        <cfargument name='CONTROLE_ID_TABELA' required='yes'>
        <cfargument name='VALOR' required='no' default="0">
		<cfargument name='QUANTIDADE' required='no' default="1">
		<cfargument name='VALOR_UNITARIO' required='no' default="0">
        <cftry>
            <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_alt_os_atividade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EXECUTADA#'  null='#iif(len(trim(arguments.EXECUTADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID_TABELA#'  null='#iif(len(trim(arguments.CONTROLE_ID_TABELA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR#'  null='#iif(len(trim(arguments.VALOR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Ok')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Altera o vnculo de um material com uma ordem de servio
	-- ANDERSONC 01/12/2009 12:38:22 - CRIADO
	--->
	<cffunction name='upd_os_material' displayname='Altera o vnculo de um material com uma ordem de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='MATERIAL_ID' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='POSICAO_ID' required='yes'>
		<cfargument name='EQUIPAMENTO_ID' required='no' default=''>
		<cfargument name='COD_PESSOA_RETIRADA' required='yes'>
        <cfargument name='VALOR_UNITARIO' required='no' default=''>
        <cfargument name='VALOR_TOTAL' required='no' default=''>
        <cfargument name='PEDIDO_ITEM_ID' required='no' default=''>
		<cftry>
            <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_alt_os_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.POSICAO_ID#'  null='#iif(len(trim(arguments.POSICAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_RETIRADA#'  null='#iif(len(trim(arguments.COD_PESSOA_RETIRADA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material vinculado com sucesso.')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
    -- PROPSITO
    -- Exclui OS
    -- guto 13/09/2007 16:23:51 - CRIADO
    --->
    <cffunction name='del_ordem_servico' displayname='Exclui OS' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORDEM_SERVICO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_del_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Ordem de servio excluda com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Envia email contendo o PDF da Ordem de servio
	-- RAFAEL 09/04/2013 17:33:08 - CRIADO
	--->
	<cffunction name='envia_email_os_pdf' displayname='Envia email contendo o PDF da Ordem de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='LISTA_EMAIL' required='yes'>
		<cfargument name='ANEXO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_envia_email_os_pdf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LISTA_EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB'   value='#arguments.ANEXO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Email enviado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Envia email contendo o PDF da Ordem de servio
	-- RAFAEL 09/04/2013 17:33:08 - CRIADO
	--->
	<cffunction name='private_envia_email_os_pdf' displayname='Envia email contendo o PDF da Ordem de servio' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='LISTA_EMAIL' required='yes'>
		<cfargument name='ANEXO' required='yes'>
		<cftry>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_envia_email_os_pdf' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LISTA_EMAIL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB'   value='#arguments.ANEXO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Insere ordem de compra
	-- guto 18/12/2006 19:42:49 - CRIADO
	--->
	<cffunction name='ins_ordem_compra' displayname='Insere ordem de compra' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA_EMISSAO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='EMPRESA' required='no' default="1">
		<cfargument name='COD_PESSOA_AUTORIZACAO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_DOCUMENTO' required='yes'>
		<cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
		<cfargument name='NOME_RESPONSAVEL' required='yes'>
		<cfargument name='CONDICAO_PAGTO' required='yes'>
		<cfargument name='EQUIPAMENTO_ID' required='no' default="">
		<cfargument name='KM_VEICULO' required='no' default="">
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='TOTAL_ORCADO' required='yes'>
		<cfargument name='TOTAL_DESCONTO' required='yes'>
		<cfargument name='TOTAL_COMBINADO' required='yes'>
		<cfargument name='NUM_CONTROLE' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_ordem_compra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMPRESA#'  null='#iif(len(trim(arguments.EMPRESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_AUTORIZACAO#'  null='#iif(len(trim(arguments.COD_PESSOA_AUTORIZACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_DOCUMENTO#'  null='#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME_RESPONSAVEL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONDICAO_PAGTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_VEICULO#'  null='#iif(len(trim(arguments.KM_VEICULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_ORCADO#'  null='#iif(len(trim(arguments.TOTAL_ORCADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_DESCONTO#'  null='#iif(len(trim(arguments.TOTAL_DESCONTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_COMBINADO#'  null='#iif(len(trim(arguments.TOTAL_COMBINADO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONTROLE#' variable='retorno.NUM_CONTROLE'  null='#iif(len(trim(arguments.NUM_CONTROLE)), de('no'), de('yes'))#'>
				</cfstoredproc>

				<!--- Insere os itens para a ordem de compra--->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ORDEM_COMPRA_ITEM");
					v_servico_material = this.ListaToArray (lista = arguments, variavel = "SERVICO_MATERIAL_ORDEM_COMPRA_ITEM");
					v_quantidade = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_ORDEM_COMPRA_ITEM");
					v_cod_unidade = this.ListaToArray (lista = arguments, variavel = "COD_UNIDADE_ORDEM_COMPRA_ITEM");
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ORDEM_COMPRA_ITEM");
					v_valor_unitario = this.ListaToArray (lista = arguments, variavel = "VALOR_UNITARIO_ORDEM_COMPRA_ITEM");
					v_valor_total = this.ListaToArray (lista = arguments, variavel = "VALOR_TOTAL_ORDEM_COMPRA_ITEM");
				</cfscript>
				<!--- Insere os Itens --->
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
				 		<cfscript>
								this.ins_ordem_compra_item(num_controle = retorno.num_controle,
														  			descricao    = v_descricao[count],
																	servico_material = v_servico_material[count],
																	cod_unidade = v_cod_unidade[count],
																	quantidade = v_quantidade[count],
																	valor_unitario = v_valor_unitario[count],
																	valor_total = v_valor_total[count],
																	cod_unidade = v_cod_unidade[count]);
						</cfscript>
				</cfloop>

				<!--- Insere atividades da ordem de compra--->
				<cfscript>
					v_controle_id = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_ATIVIDADE");
					v_atividade_id = this.ListaToArray (lista = arguments, variavel = "ATIVIDADE_ID_ATIVIDADE");
					v_posicao_id = this.ListaToArray (lista = arguments, variavel = "POSICAO_ID_ATIVIDADE");
				</cfscript>
				<!--- Insere os Itens --->
				<cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
				 		<cfscript>
								this.ins_atividade_equipamento_oc(equipamento_id = arguments.equipamento_id,
																  atividade_id   = v_atividade_id[count],
																  posicao_id     = v_posicao_id[count],
																  num_ordem_compra  = retorno.num_controle);
						</cfscript>
				</cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de compra ('& #retorno.NUM_CONTROLE# & ') inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera ordem de compra
	-- guto 18/12/2006 19:46:06 - CRIADO
	--->
	<cffunction name='alt_ordem_compra' displayname='Altera ordem de compra' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONTROLE' required='yes'>
		<cfargument name='COD_PESSOA_EMISSAO' required='yes'>
		<cfargument name='TITULO' required='yes'>
		<cfargument name='EMPRESA' required='yes'>
		<cfargument name='COD_PESSOA_AUTORIZACAO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_DOCUMENTO' required='yes'>
		<cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
		<cfargument name='NOME_RESPONSAVEL' required='yes'>
		<cfargument name='CONDICAO_PAGTO' required='yes'>
		<cfargument name='EQUIPAMENTO_ID' required='no' default="">
		<cfargument name='KM_VEICULO' required='no' default="">
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='TOTAL_ORCADO' required='yes'>
		<cfargument name='TOTAL_DESCONTO' required='yes'>
		<cfargument name='TOTAL_COMBINADO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_alt_ordem_compra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONTROLE#'  null='#iif(len(trim(arguments.NUM_CONTROLE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMPRESA#'  null='#iif(len(trim(arguments.EMPRESA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_AUTORIZACAO#'  null='#iif(len(trim(arguments.COD_PESSOA_AUTORIZACAO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_DOCUMENTO#'  null='#iif(len(trim(arguments.NUM_DOCUMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME_RESPONSAVEL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONDICAO_PAGTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.KM_VEICULO#'  null='#iif(len(trim(arguments.KM_VEICULO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_ORCADO#'  null='#iif(len(trim(arguments.TOTAL_ORCADO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_DESCONTO#'  null='#iif(len(trim(arguments.TOTAL_DESCONTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_COMBINADO#'  null='#iif(len(trim(arguments.TOTAL_COMBINADO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<!--- Insere os itens para a ordem de compra--->
				<cfscript>
					v_item_id = this.ListaToArray (lista = arguments, variavel = "ITEM_ID_ORDEM_COMPRA_ITEM");
					v_servico_material = this.ListaToArray (lista = arguments, variavel = "SERVICO_MATERIAL_ORDEM_COMPRA_ITEM");
					v_quantidade = this.ListaToArray (lista = arguments, variavel = "QUANTIDADE_ORDEM_COMPRA_ITEM");
					v_cod_unidade = this.ListaToArray (lista = arguments, variavel = "COD_UNIDADE_ORDEM_COMPRA_ITEM");
					v_descricao = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_ORDEM_COMPRA_ITEM");
					v_valor_unitario = this.ListaToArray (lista = arguments, variavel = "VALOR_UNITARIO_ORDEM_COMPRA_ITEM");
					v_valor_total = this.ListaToArray (lista = arguments, variavel = "VALOR_TOTAL_ORDEM_COMPRA_ITEM");
					v_excluir = this.ListDiff(lista1 = arguments.lista_deleted_ORDEM_COMPRA_ITEM, lista2 = ArrayToList(v_item_id));
				</cfscript>
				<!--- Excluir Itens --->
				<cfloop list="#v_excluir#" delimiters="," index="l_item_id">
					 <cfscript>
					 	 this.del_ordem_compra_item(item_id = l_item_id);
					 </cfscript>
				</cfloop>

				<!--- Insere os Itens --->
				<cfloop from="1" to="#ArrayLen(v_item_id)#" index="count">
						<cfscript>
								if (not Len(Trim(v_item_id[count])))  {
									this.ins_ordem_compra_item(num_controle = arguments.num_controle,
																		descricao    = v_descricao[count],
																		servico_material = v_servico_material[count],
																		cod_unidade = v_cod_unidade[count],
																		quantidade = v_quantidade[count],
																		valor_unitario = v_valor_unitario[count],
																		valor_total = v_valor_total[count],
																		cod_unidade = v_cod_unidade[count]);
								} else {
									this.alt_ordem_compra_item(num_controle = arguments.num_controle,
															   item_id      = v_item_id[count],
															   descricao    = v_descricao[count],
															   servico_material = v_servico_material[count],
															   quantidade = v_quantidade[count],
															   valor_unitario = v_valor_unitario[count],
															   valor_total = v_valor_total[count],
															   cod_unidade = v_cod_unidade[count]);
								}
						</cfscript>
				</cfloop>

                <cfif IsDefined("arguments.lista_deleted_ATIVIDADE")>
					<!--- Insere atividades da ordem de compra--->
                    <cfscript>
                        v_controle_id  = this.ListaToArray (lista = arguments, variavel = "CONTROLE_ID_ATIVIDADE");
                        v_atividade_id = this.ListaToArray (lista = arguments, variavel = "ATIVIDADE_ID_ATIVIDADE");
                        v_posicao_id   = this.ListaToArray (lista = arguments, variavel = "POSICAO_ID_ATIVIDADE");
                        v_excluir      = this.ListDiff(lista1 = arguments.lista_deleted_ATIVIDADE, lista2 = ArrayToList(v_controle_id));
                    </cfscript>
                    <!--- Excluir Itens --->
                    <cfloop list="#v_excluir#" delimiters="," index="l_controle_id">
                         <cfscript>
                             this.del_atividade_equipamento_oc(controle_id = l_controle_id);
                         </cfscript>
                    </cfloop>

                    <!--- Insere os Itens --->
                    <cfloop from="1" to="#ArrayLen(v_controle_id)#" index="count">
                            <cfscript>
                                    if (not Len(Trim(v_controle_id[count])))  {
                                        this.ins_atividade_equipamento_oc(equipamento_id = arguments.equipamento_id,
                                                                          atividade_id   = v_atividade_id[count],
                                                                          posicao_id     = v_posicao_id[count],
                                                                          num_ordem_compra   = arguments.num_controle);
                                    } else {
                                            this.upd_atividade_equipamento_oc( controle_id    = v_controle_id[count],
                                                                               equipamento_id = arguments.equipamento_id,
                                                                               atividade_id   = v_atividade_id[count],
                                                                               posicao_id     = v_posicao_id[count],
                                                                               num_ordem_compra  = arguments.num_controle);
                                    }
                            </cfscript>
                    </cfloop>

                </cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de compra alterada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Excluir ordem de compra
	-- guto 18/12/2006 19:48:29 - CRIADO
	--->
	<cffunction name='del_ordem_compra' displayname='Excluir ordem de compra' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONTROLE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_del_ordem_compra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONTROLE#'  null='#iif(len(trim(arguments.NUM_CONTROLE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordem de compra excluda com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Insere item a ordem de compra
	-- guto 18/12/2006 20:19:38 - CRIADO
	--->
	<cffunction name='ins_ordem_compra_item' displayname='Insere item a ordem de compra' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONTROLE' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='SERVICO_MATERIAL' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_ins_ordem_compra_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONTROLE#'  null='#iif(len(trim(arguments.NUM_CONTROLE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SERVICO_MATERIAL#'  null='#iif(len(trim(arguments.SERVICO_MATERIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ITEM_ID' >
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!---
	-- PROPSITO
	-- Altera item a ordem de compra
	-- guto 18/12/2006 20:21:09 - CRIADO
	--->
	<cffunction name='alt_ordem_compra_item' displayname='Altera item a ordem de compra' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONTROLE' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='SERVICO_MATERIAL' required='yes'>
		<cfargument name='QUANTIDADE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='VALOR_UNITARIO' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_alt_ordem_compra_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONTROLE#'  null='#iif(len(trim(arguments.NUM_CONTROLE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SERVICO_MATERIAL#'  null='#iif(len(trim(arguments.SERVICO_MATERIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UNITARIO#'  null='#iif(len(trim(arguments.VALOR_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

	<!---
	-- PROPSITO
	-- Exclui item da ordem de compra
	-- guto 18/12/2006 20:22:09 - CRIADO
	--->
	<cffunction name='del_ordem_compra_item' displayname='Exclui item da ordem de compra' access='remote' returntype='Struct' output='true'>
		<cfargument name='ITEM_ID' required='yes'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_del_ordem_compra_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
		<cfreturn structnew() />
	</cffunction>

    <!---
	-- PROPSITO
	-- Alterar tempo de execucao do processo quando a atividade for editada. Só atualiza quando atividade possui um processo
	-- LEANDROS 05/05/2014 - CRIADO
	--->
	<cffunction name='alt_tempo_execucao_processo' displayname='Altera tempo de execuo de um processo' access='remote' returntype='Struct' output='true'>
		<cfargument name='ATIVIDADE_ID' required='yes'>
		<cfargument name='TEMPO_EXECUCAO_HORAS' required='yes'>
		<cfargument name='TEMPO_EXECUCAO_MINUTOS' required='yes'>
           <cftry>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_tempo_execucao_proc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='00 #arguments.TEMPO_EXECUCAO_HORAS#:#arguments.TEMPO_EXECUCAO_MINUTOS#:00' >
				</cfstoredproc>
                <cfset retorno.erro = false>

                <cfcatch>
				     <cfset retorno.erro = true>
				     <cfset retorno.mensagem = cfcatch>
				     <cfset request.erro = cfcatch>
		        </cfcatch>
           </cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Insere um percentual de trabalho para o centro de custo
	-- WAGNERS 11/12/2012 11:45:20 - CRIADO
	--->
	<cffunction name='ins_ccusto_perc_trabalho' displayname='Insere um percentual de trabalho para o centro de custo' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_VIGENCIA' required='yes'>
		<cfargument name='PERCENTUAL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_ccusto_perc_trabalho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VIGENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERCENTUAL#'  null='#iif(len(trim(arguments.PERCENTUAL)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Percentual registrado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!---
	-- PROPSITO
	-- Altera o percentual de trabalho de um centro de custo
	-- WAGNERS 11/12/2012 15:24:00 - CRIADO
	--->
	<cffunction name='upd_ccusto_perc_trabalho' displayname='Altera o percentual de trabalho de um centro de custo' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_VIGENCIA' required='yes'>
		<cfargument name='PERCENTUAL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_ccusto_perc_trabalho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VIGENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERCENTUAL#'  null='#iif(len(trim(arguments.PERCENTUAL)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados alterados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!---
	-- PROPSITO
	-- Exclui o percentual de trabalho de um centro de custo
	-- WAGNERS 11/12/2012 15:27:18 - CRIADO
	--->
	<cffunction name='del_ccusto_perc_trabalho' displayname='Exclui o percentual de trabalho de um centro de custo' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_ccusto_perc_trabalho' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Insere um percentual de trabalho para o centro de custo
	-- WAGNERS 11/12/2012 11:45:20 - CRIADO
	--->
	<cffunction name='ins_ccgerencial_perc_trab' displayname='Insere um percentual de trabalho para o centro de custo' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORGANIZACIONAL_ID' required='yes'>
		<cfargument name='DATA_VIGENCIA' required='yes'>
		<cfargument name='PERCENTUAL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_ins_ccgerencial_perc_trab' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VIGENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERCENTUAL#'  null='#iif(len(trim(arguments.PERCENTUAL)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONTROLE_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Percentual registrado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!---
	-- PROPSITO
	-- Altera o percentual de trabalho de um centro de custo
	-- WAGNERS 11/12/2012 15:24:00 - CRIADO
	--->
	<cffunction name='upd_ccgerencial_perc_trab' displayname='Altera o percentual de trabalho de um centro de custo' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cfargument name='ORGANIZACIONAL_ID' required='yes'>
		<cfargument name='DATA_VIGENCIA' required='yes'>
		<cfargument name='PERCENTUAL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_alt_ccgerencial_perc_trab' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_VIGENCIA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PERCENTUAL#'  null='#iif(len(trim(arguments.PERCENTUAL)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados alterados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


	<!---
	-- PROPSITO
	-- Exclui o percentual de trabalho de um centro de custo
	-- WAGNERS 11/12/2012 15:27:18 - CRIADO
	--->
	<cffunction name='del_ccgerencial_perc_trab' displayname='Exclui o percentual de trabalho de um centro de custo' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTROLE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_del_ccgerencial_perc_trab' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTROLE_ID#'  null='#iif(len(trim(arguments.CONTROLE_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Registro excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Executa o fechamento de múltiplas OS's.
	-- RAFAEL PENCZKOSKI 18/10/2016 16:20:41 - CRIADO
	--->
	<cffunction name='fecha_ordens_servico' displayname='Executa o fechamento de múltiplas OS.' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_FECHAMENTO' required='yes'>

		<cftry>
			<cftransaction action='begin'>
                <cfscript>
                   v_ordem_servico_id = this.ListaToArray (lista = arguments, variavel = "ORDEM_SERVICO_ID");
                </cfscript>

				<cfloop from="1" to="#ArrayLen(v_ordem_servico_id)#" index="count">
				   <cfif isDefined('arguments.CHECKED_'&count)>
                      <cfscript>
				         ret_os = this.fecha_ordem_servico(ordem_servico_id = v_ordem_servico_id[count]
				                                          ,data_fechamento  = arguments.data_fechamento);
                      </cfscript>

                      <cfif ret_os.erro>
                         <cfthrow object="#ret_os.mensagem#">
                      </cfif>
                   </cfif>
                </cfloop>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ordens de servio fechadas com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	<!---
	-- PROPSITO
	-- Executa o fechamento de OS.
	-- LEANDRO SILVA 04/09/2017 10:14 - CRIADO
	--->
	<cffunction name='fecha_os' displayname='Executa o fechamento de OS.' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cfargument name='DATA_FECHAMENTO'  required='yes'>
		<cfargument name='NUM_NOTA_ID'      required='no' default="">

		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_fecha_ordem_servico' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FECHAMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NOTA_ID#'  null='#iif(len(trim(arguments.NUM_NOTA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('OS fechada com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!---
	-- PROPSITO
	-- Atualiza os dados da view materializada
	-- RAFAEL COSTA 18/02/2019 - CRIADO
	--->
	<cffunction name='atualiza_dados' displayname='Atualiza os dados da view materializada.' access='remote' returntype='Struct' output='true'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_atualiza_dados' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dados atualizados com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	 <!---
	-- PROPSITO 
	-- Gerar Relatrio de preventivas a vencer
	-- IGOR NOBREGA 09/01/2020
	--->
	<cffunction name='gerar_relatorio_de_preventivas_vencer' displayname='Gerar Relatorio de preventivas' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_backend.prc_relatorio_prevet_vencer' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.EQUIPAMENTO_ID#' null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.RELATORIO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Relatrio impresso com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

		<cffunction name='gerar_relatorio_de_preventivas_vencer_itens' displayname='Gerar Relatorio de preventivas' access='remote' returntype='Struct' output='true'>
		<cfargument name='EQUIPAMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_backend.prc_rel_prevet_vencer_itens' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.EQUIPAMENTO_ID#' null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.RELATORIO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Relatrio impresso com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

		 <!---
	-- PROPSITO 
	-- Gerar Relatrio de o.s de manuteno preventiva
	-- IGOR NOBREGA 13/01/2020
	--->
	<cffunction name='gerar_relatorio_manutencao_preventiva' displayname='Gerar Relatorio de preventivas' access='remote' returntype='Struct' output='true'>
		<cfargument name='ORDEM_SERVICO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_backend.prc_rel_manut_prev' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.ORDEM_SERVICO_ID#' null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.RELATORIO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Relatrio impresso com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

<!---
	-- PROPSITO 
	-- Gerar Relatrio de servios executados por mecnicos
	-- MATHEUS KROL 19/06/2020
	--->
	<cffunction name='gerar_relatorio_servicos_mecanico' displayname='Gerar Relatorio de Servios por mecnico' access='remote' returntype='Struct' output='true'>
		<cfargument name='COD_PESSOA' required='yes'>
		<cfargument name='CONTROLE_ID_PROCESSO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='manutencao.pkg_manutencao_dml.prc_servicos_mecanico_rel' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.COD_PESSOA#' null='#iif(len(trim(arguments.COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='6'   value='#arguments.CONTROLE_ID_PROCESSO#' null='#iif(len(trim(arguments.CONTROLE_ID_PROCESSO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.RELATORIO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Relatrio impresso com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>
