<cfcomponent displayname="Controle e manipulao" extends="_transportes.funcoes.cfc_init">
    <!--- 
    -- PROPSITO
    -- Altera um material
    -- cristofer 07/07/2006 09:08:26 - CRIADO
    --->
    <cffunction name='upd_material_pai' displayname='Altera um material' access='remote' returntype='Struct' output='true'>;
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='MATERIAL_PAI' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfscript>
                    conn = CreateComponent("_transportes.consulta.cfc_almoxarifado");
                    qrMaterial = conn.get_material(material_id = arguments.material_id);
                    if(arguments.material_pai eq 0)
                        arguments.material_pai = '';
                </cfscript>
                <cfif not qrMaterial.recordcount>
                    <cfthrow message="No foi possvel localizar o material!">
                </cfif>
                <cfstoredproc procedure='almoxarifado.pkg_almoxarifado_dml.prc_alt_material' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#qrMaterial.MATERIAL_ID#'  null='#iif(len(trim(qrMaterial.MATERIAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_PAI#'  null='#iif(len(trim(arguments.MATERIAL_PAI)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#qrMaterial.COD_MATERIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#qrMaterial.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#qrMaterial.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#qrMaterial.COMPOE_DESCRICAO#'  null='#iif(len(trim(qrMaterial.COMPOE_DESCRICAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#qrMaterial.ESTOQUE#'  null='#iif(len(trim(qrMaterial.ESTOQUE)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#qrMaterial.UNIDADE_ESTOQUE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#qrMaterial.UNIDADE_COMERCIALIZACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#qrMaterial.IDENTIFICADO#'  null='#iif(len(trim(qrMaterial.IDENTIFICADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#qrMaterial.ATIVO#'  null='#iif(len(trim(qrMaterial.ATIVO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Material alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
    -- PROPSITO
    -- Processar a solicitao de carga de manuteno
    -- FABIOG 11/11/2011 11:23:18 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra_os' displayname='Processar a solicitao de carga de manuteno' access='remote' returntype='Struct' output='true'>
        <cftry>
            <cfscript>
                v_ordens_id = listtoarray(arguments.ORDEM_SERVICO_ID,',');
                conn = CreateComponent("modulos.manutencao._componentes.consulta.cfc_manutencao");
                qrOrdens = conn.get_ordens_servico(ordem_servico_id_lista = arguments.ordem_servico_id);
                qrAtividade = conn.get_os_atividades_simples(ordem_servico_id = arguments.ordem_servico_id);
                qrMaterial = conn.get_os_materiais(ordem_servico_id = arguments.ordem_servico_id);
                
                v_ordens = ArrayNew(1);
                for(i=1; i<=qrOrdens.recordCount; i++){
                    arrayAppend(v_ordens,qrOrdens.NUM_ORDEM_SERVICO[i]);
                }
                v_lista = arrayToList(v_ordens,', ');
                ret = this.ins_solicitacao_compra( titulo                   = 'Gerada partir das Ordens de Servio: '&v_lista
                                                 , cod_organograma          = session.COD_ORGANOGRAMA
                                                 , cod_pessoa_emissao       = session.COD_PESSOA_USUARIO
                                                 , data_emissao             = lsDateFormat(now())
                                                 , equipamento_id           = arguments.EQUIPAMENTO_ID
                                                 , observacao               = 'Solicitao de compra gerada a partir dos dados das Ordens de Servio: '&v_lista
                                                 , situacao_id              = 1 //Aberta - default
                                                 , log_alteracao            = ''
                                                 , prioridade_id            = 3
                                                 , area_id                  = arguments.AREA_ID
                                                 , cod_pessoa_fornecedor    = arguments.COD_PESSOA_FORNECEDOR
                                                 , organizacional_id        = arguments.ORGANIZACIONAL_ID
                                                 , ordem_servico_id         = arguments.ORDEM_SERVICO_ID
                                                 );
            </cfscript>            
            <cfif ret.erro >
                <cfthrow object="#ret.mensagem#">
            </cfif>
            <cfoutput query="qrAtividade">
                <cfscript>
                    retAtv = this.ins_solicitacao_compra_atividade(SOLICITACAO_ID = ret.SOLICITACAO_ID
                                                                  ,DESCRICAO      = Left(qrAtividade.TITULO,100)
                                                                  ,ATIVIDADE_ID   = qrAtividade.ATIVIDADE_ID
                                                                  ,VALOR_SUGERIDO = qrAtividade.VALOR_ATIVIDADE
                                                                  ,QUANTIDADE     = 1
                                                                  ,TIPO_COMPRA_ID = 3);
                </cfscript>
                <cfif retAtv.erro>
                    <cfthrow object="#retAtv.mensagem#">
                </cfif>
            </cfoutput>
            
            <cfoutput query="qrMaterial">
                <!--- insere apenas os materiais que no so de estoque--->
                <cfif not len(trim(qrMaterial.LANCAMENTO_ID_SAIDA))>
                    <cfscript>
                        retMat = this.ins_solicitacao_compra_material(SOLICITACAO_ID  = ret.SOLICITACAO_ID
                                                                     ,DESCRICAO       = qrMaterial.MATERIAL
                                                                     ,MATERIAL_ID     = qrMaterial.MATERIAL_ID
                                                                     ,COD_UNIDADE     = qrMaterial.UNIDADE_ESTOQUE
                                                                     ,QUANTIDADE      = qrMaterial.QUANTIDADE
                                                                     ,VALOR_SUGERIDO  = qrMaterial.VALOR_UNITARIO
                                                                     ,TIPO_COMPRA_ID  = 3);
                    </cfscript>
                    <cfif retMat.erro>
                        <cfthrow object="#retMat.mensagem#">
                    </cfif>
                </cfif>
            </cfoutput>
            <cfset v_ordens_id = listToArray(arguments.ORDEM_SERVICO_ID,',') >
            <cfloop from="1" to="#ArrayLen(v_ordens_id)#" index="i">
                <cfscript>
                    retVinc = this.vincula_os_ordem_compra( solicitacao_compra_id = ret.SOLICITACAO_ID
                                                          , ordem_servico_id = v_ordens_id[i] );
                </cfscript>
                <cfif retVinc.erro>
                    <cfthrow object="#retVinc.mensagem#">
                </cfif>
            </cfloop>
            
             <cfset retorno.erro = false>
             <cfset retorno.mensagem = JSStringFormat('Solicitao de Compra n #retorno.NUM_CONTROLE# inserida com sucesso.')>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Insere uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:49:14 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra' displayname='Insere uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='NUM_CONTROLE' required='no' default="">
        <cfargument name='TITULO' required='yes'>
        <cfargument name='COD_ORGANOGRAMA' required='yes'>
        <cfargument name='COD_PESSOA_EMISSAO' required='yes'>
        <cfargument name='DATA_EMISSAO' required='yes'>
        <cfargument name='EQUIPAMENTO_ID' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='LOG_ALTERACAO' required='yes'>
        <cfargument name='PRIORIDADE_ID' required='yes'>
        <cfargument name='AREA_ID' required='yes'>
        <cfargument name='COD_PESSOA_FORNECEDOR' required='yes'>
        <cfargument name='TABELA_ID' required='no'>
        <cfargument name='EQUIPAMENTO_CUSTO_ID' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">    
        <cfargument name='ORDEM_SERVICO_ID' required='no' default="">            

        <cfargument name='OBSERVACAO' required='no'>
            <cftry>
                <cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicitacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.SOLICITACAO_ID' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_CONTROLE' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TITULO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='9' >                 
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_EMISSAO#'  null='#iif(len(trim(arguments.COD_PESSOA_EMISSAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PRIORIDADE_ID#'  null='#iif(len(trim(arguments.PRIORIDADE_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AREA_ID#'  null='#iif(len(trim(arguments.AREA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FORNECEDOR#'  null='#iif(len(trim(arguments.COD_PESSOA_FORNECEDOR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EQUIPAMENTO_CUSTO_ID#'  null='#iif(len(trim(arguments.EQUIPAMENTO_CUSTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>                                        
                

                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   null='yes'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   null='yes'>
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'    value='1' >
                 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>

                
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Solicitao de Compra n #retorno.NUM_CONTROLE# inserida com sucesso.')>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Insere uma atividade para uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:57:48 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra_atividade' displayname='Insere uma atividade para uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='ATIVIDADE_ID' required='yes'>
        <cfargument name='COMPRA_LIBERADA' required='no' default='0'>
        <cfargument name='VALOR_SUGERIDO' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='TIPO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ATIVIDADE_ID#'  null='#iif(len(trim(arguments.ATIVIDADE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_SUGERIDO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_COMPRA_ID#'  null='#iif(len(trim(arguments.TIPO_COMPRA_ID)), de('no'), de('yes'))#'> 
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Atividade inserida com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Insere um material para uma solicitao de compra
    -- ANDERSONC 16/09/2009 14:53:59 - CRIADO
    --->
    <cffunction name='ins_solicitacao_compra_material' displayname='Insere um material para uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='SOLICITACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='MATERIAL_ID' required='yes'>
        <cfargument name='COD_UNIDADE' required='yes'>
        <cfargument name='QUANTIDADE' required='yes'>
        <cfargument name='COMPRA_LIBERADA' required='no' default='0'>
        <cfargument name='VALOR_SUGERIDO' required='yes'>
        <cfargument name='TIPO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='compras.pkg_solicitacao.prc_ins_solicitacao_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.CONTROLE_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.SOLICITACAO_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.MATERIAL_ID#'  null='#iif(len(trim(arguments.MATERIAL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='1'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.QUANTIDADE#'  null='#iif(len(trim(arguments.QUANTIDADE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COMPRA_LIBERADA#'  null='#iif(len(trim(arguments.COMPRA_LIBERADA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VALOR_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_SUGERIDO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.TIPO_COMPRA_ID#'  null='#iif(len(trim(arguments.TIPO_COMPRA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Material inserido com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    
    <!--- 
    -- PROPSITO
    -- Vincula uma Ordem de Servio  a uma solicitao de compra
    -- WAGNERS 16/03/2012 17:53:17 - CRIADO
    --->
    <cffunction name='vincula_os_ordem_compra' displayname='Vincula uma Ordem de Servio  a uma solicitao de compra' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORDEM_SERVICO_ID' required='yes'>
        <cfargument name='SOLICITACAO_COMPRA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='manutencao.pkg_ordem_servico.prc_vincula_os_ordem_compra' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORDEM_SERVICO_ID#'  null='#iif(len(trim(arguments.ORDEM_SERVICO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_COMPRA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_COMPRA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = JSStringFormat('Ordem de servio vinculada com sucesso!')>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
</cfcomponent>  
