<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPSITO
	-- Busca o dado de um parametro
	-- CRISTOFER  10/11/2006
	--->
	<cffunction name="get_parametro_lista" access="remote" returntype="string" output="true">
    	<cfargument name="identificador" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_parametro.fnc_valor_lista('#arguments.identificador#') valor from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna dados do Veculo
	-- NOTAS EXPLICATIVAS
	--
	-- 07/12/2005 - criado
	--->
	<cffunction name="get_veiculo" displayname="Retorna dados do Veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="placa_exa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="frota_exa" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7">
		<!---Terceiros--->
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct vd.veiculo_id, vd.placa,
                    vd.cod_veiculo,
                    vd.num_rastreador,
                    vd.rastreador_id,
                    vd.rastreador_com_problemas,
                    vd.marca_id,
                    vd.marca,
                    vd.modelo_id,
                    vd.situacao_id,
                    vd.uf,
                    vd.capacidade_tanque,
                    oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(vd.placa,sysdate) capacidade,
                    vd.km_revisao,
                    vd.modelo,
                    vd.proprietario,
                    vd.observacao,
                    vd.cor_predominante,
                    vd.ano,
                    vd.chassis,
                    vd.renavan,
                    va.agrupamento_id,
                    va.descricao as agrupamento,
                    vtc.tipo_carroceria_id,
               		vtc.descricao as tipo_carroceria,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TAG_CTF') as tag_ctf,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TARA') as tara,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'COMBUSTIVEL') as combustivel,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'NUMERO_EIXOS') as numero_eixos,
                    vd.municipio_id,
                    (select municipio
                       from cep.municipio m
                      where m.municipio_id = vd.municipio_id) as municipio,
                    vd.tipo_carroceria_id,
                    va.tracao,
                    vtc.descricao as tipo
              from oper.v$veiculo_dados vd
              left join oper.v$veiculo_tipo_carroceria vtc
                     on vd.tipo_carroceria_id = vtc.tipo_carroceria_id
              left join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
              left join oper.v$veiculo_proprietario vp on vp.placa = vd.placa
                                                      and vp.data_fim is null
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
			   and vd.placa like upper('%#arguments.placa#%')
			</cfif>
			<cfif Len(Trim(arguments.placa_exa))>
			   and upper(vd.placa) = '#arguments.placa_exa#'
			</cfif>
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vd.cod_veiculo) like upper('#arguments.cod_veiculo#%')
			</cfif>
			<cfif Len(Trim(arguments.proprietario))>
			   and vd.proprietario in (#arguments.proprietario#)
			</cfif>
			<cfif Len(Trim(arguments.frota))>
			   and (vd.placa like upper('#arguments.frota#%')
			       or vd.cod_veiculo like upper('#arguments.frota#%'))
			</cfif>
			<cfif Len(Trim(arguments.frota_exa))>
			   and (upper(vd.placa) = '#arguments.frota_exa#'
			       or upper(vd.cod_veiculo) = '#arguments.frota_exa#')
			</cfif>
			order by vd.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca modelos de equipamentos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 06/10/2006
	--->
	<cffunction name="get_modelos" returntype="query" access="remote">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select modelo_id, descricao
				  from manutencao.v$modelo m
    		     where 1=1
 			  <cfif Len(Trim(arguments.modelo_id))>
				and m.modelo_id = #arguments.modelo_id#
			  </cfif>
 			  <cfif Len(Trim(arguments.descricao))>
				and upper(m.descricao) like upper('%#arguments.descricao#%')
			  </cfif>
 			  order by m.descricao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca modelos de equipamentos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 06/10/2006
	--->
	<cffunction name="get_equipamento_modelo" returntype="query" access="remote">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select /*+ORDERED*/ em.controle_id, em.modelo_id, em.equipamento_id,
				       m.descricao, e.cod_equipamento,
                       to_char(em.data_inicial,'dd/mm/yyyy') as data_inicial,
                       to_char(em.data_final,'dd/mm/yyyy') as data_final,
						 md.material
				  from manutencao.v$equipamento_modelo em
				 inner join manutencao.v$modelo m
				          on em.modelo_id = m.modelo_id
				  inner join almoxarifado.v$equipamento e
				 	       on em.equipamento_id = e.equipamento_id
              inner join almoxarifado.v$material_dados md
				          on md.material_id = e.material_id
		    	  where 1=1
 			  <cfif Len(Trim(arguments.modelo_id))>
				and em.modelo_id = #arguments.modelo_id#
			  </cfif>
			  <cfif Len(Trim(arguments.descricao))>
			 	and upper(e.cod_equipamento) like upper('%#arguments.descricao#%')
			  </cfif>
 			  order by em.controle_id
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca grupo de atividades
	-- NOTAS EXPLICATIVAS
	-- ARLEN 05/10/2006
	--->
	<cffunction name="get_atividade_grupo" returntype="query" access="remote">
		<cfargument name="grupo_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select grupo_id, descricao
			   from manutencao.v$atividade_grupo
			  where 1=1
  			  <cfif Len(Trim(arguments.grupo_id))>
			 	and grupo_id = #arguments.compartimento_id#
			  </cfif>
  			  <cfif Len(Trim(arguments.descricao))>
			 	and upper(descricao) like upper('%#arguments.descricao#%')
			  </cfif>
			  order by descricao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca compartimentos do Veculo
	-- NOTAS EXPLICATIVAS
	-- ARLEN 04/10/2006
	--->
	<cffunction name="get_atividade_compartimento" returntype="query" access="remote">
		<cfargument name="compartimento_id" required="no" default="">
		<cfargument name="descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select compartimento_id, descricao, ordem
			   from manutencao.v$atividade_compartimento
			  where 1=1
  			  <cfif Len(Trim(arguments.compartimento_id))>
			 	and compartimento_id = #arguments.compartimento_id#
			  </cfif>
  			  <cfif Len(Trim(arguments.descricao))>
			 	and upper(kss.pkg_string.fnc_string_clean(descricao)) like upper('%#arguments.descricao#%')
			  </cfif>
			  order by ordem
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca POSI��ES
	-- NOTAS EXPLICATIVAS
	-- GUTO 21/09/2006
	--->
	<cffunction name="get_equipamento_posicao" returntype="query" access="remote">
		<cfargument name="posicao_id" required="no" default="">
		<cfargument name="posicao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select posicao_id, posicao
			  from manutencao.v$equipamento_posicao p
  		     where 1=1
 			  <cfif Len(Trim(arguments.posicao_id))>
				and p.posicao_id = #arguments.posicao_id#
			  </cfif>
 			  <cfif Len(Trim(arguments.posicao))>
				and upper(p.posicao) like upper('%#arguments.posicao#%')
			  </cfif>
			  order by p.posicao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca posi��es dos materiais
	-- NOTAS EXPLICATIVAS
	-- arlen 16/10/2006
	--->
	<cffunction name="get_posicao_material" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select mp.item_id, mp.material_id, mp.posicao_id, ep.posicao, ep.posicao_id
				from manutencao.v$material_posicao mp
               inner join manutencao.v$equipamento_posicao ep
				  on ep.posicao_id = mp.posicao_id
               where 1 = 1
			  <cfif Len(Trim(arguments.material_id))>
				and mp.material_id = #arguments.material_id#
			  </cfif>
			  order by ep.posicao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca processo
	-- NOTAS EXPLICATIVAS
	-- GUTO 03/08/2006
	--->
	<cffunction name="get_processo" returntype="query" access="remote">
		<cfargument name="processo_id" required="no" default="">
		<cfargument name="titulo" required="no" default="">
		<cfargument name="titulo_full" required="no" default="">
		<cfargument name="sem_detalhamento" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.processo_id, p.titulo,
				   <cfif arguments.sem_detalhamento eq 0>to_char(p.detalhamento) as detalhamento, </cfif>
				   to_char(p.tempo_execucao)  as tempo_execucao,
 	            trim(to_char(extract( day from p.tempo_execucao) + extract( hour from p.tempo_execucao),'00')) as tempo_execucao_horas,
               trim(to_char(extract( minute from p.tempo_execucao),'00')) as tempo_execucao_minutos
			  from manutencao.v$processo p
		     where 1=1
 			  <cfif Len(Trim(arguments.processo_id))>
				and p.processo_id = #arguments.processo_id#
			  </cfif>
			  <cfif Len(Trim(arguments.titulo))>
				and upper(p.titulo) like upper('%#arguments.TITULO#%')
			  </cfif>
			  <cfif Len(Trim(arguments.titulo_full))>
				and upper(p.titulo) like upper('#arguments.TITULO_full#')
			  </cfif>
			  order by p.titulo
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca niveis de especialidade dos recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/08/2006
	--->
	<cffunction name="get_recurso_nivel" returntype="query" access="remote">
		<cfargument name="nivel_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select substr(sys_connect_by_path(rn.descricao, ','),2) as niveis,
				   rn.descricao, rn.nivel_id
			  from manutencao.v$recurso_nivel rn
			  where 1=1
			  <cfif Len(Trim(arguments.nivel_id))>
			 	 and rn.nivel_id = #arguments.nivel_id#
			  </cfif>
			 start with rn.nivel_pai is null
			connect by prior rn.nivel_id = rn.nivel_pai
			order siblings by rn.descricao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca especialidade dos recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 02/08/2006
	--->
	<cffunction name="get_recurso_especialidade" returntype="query" access="remote">
		<cfargument name="descricao" required="no" default="">
		<cfargument name="especialidade_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select especialidade_id, descricao
			  from manutencao.v$recurso_especialidade
			 where 1=1
			  <cfif Len(Trim(arguments.descricao))>
				and upper(descricao) like upper('%#arguments.descricao#%')
			  </cfif>
			  <cfif Len(Trim(arguments.especialidade_id))>
				and especialidade_id = #arguments.especialidade_id#
			  </cfif>
			  order by descricao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tipos de atividades
	-- GUTO 16/09/2006
	--->
	<cffunction name="get_atividade_tipo" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.tipo_id, a.nome, a.descricao
			  from manutencao.v$atividade_tipo a
			order by a.nome
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tipos de oficina
	-- GUTO 16/09/2006
	--->
	<cffunction name="get_tipo_oficina" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oficina_tipo_id, descricao, num_modalidade
              from manutencao.v$oficina_tipo t
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca as atividades
	-- CRISTOFER  10/08/2006
	--->
	<cffunction name="get_atividade" access="remote" returntype="query" output="true">
		<cfargument name="cod_atividade"  required="no" default="">
		<cfargument name="titulo" 			 required="no" default="">
		<cfargument name="atividade_id"  required="no" default="">
		<cfargument name="cod_ativ_exato"  required="no" default="">
		<cfargument name="importancia" 	 required="no" default="">
		<cfargument name="grupo_id" 		 required="no" default="">
		<cfargument name="tabela_id" 		 required="no" default="">
      <cfargument name="situacao_ativo" required="no" default="0">
		<cfargument name="somente_arvore" required="no" default="0">
      <cfargument name="ordem_servico_id" required="no" default=""> 
	   <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
	   select x.*
        from xmltable('/atividades/arrayItem' passing manutencao.pkg_manutencao_backend.fnc_atividade(
        xmltype('<params>' ||
         <cfif len(trim(arguments.titulo))>
             '<titulo>#arguments.titulo#</titulo>' ||
         </cfif>
         <cfif len(trim(arguments.cod_atividade))>
             '<cod_atividade>#arguments.cod_atividade#</cod_atividade>' ||
         </cfif>
         <cfif len(trim(arguments.cod_ativ_exato))>
             '<cod_ativ_exato>#arguments.cod_ativ_exato#</cod_ativ_exato>' ||
         </cfif>
         <cfif len(trim(arguments.atividade_id))>
             '<atividade_id>#arguments.atividade_id#</atividade_id>' ||
         </cfif>
         <cfif len(trim(arguments.importancia))>
             '<importancia>#arguments.importancia#</importancia>' ||
         </cfif>
         <cfif len(trim(arguments.grupo_id))>
            '<grupo_id>#arguments.grupo_id#</grupo_id>' ||
         </cfif>
         <cfif len(trim(arguments.tabela_id))>
            '<tabela_id>#arguments.tabela_id#</tabela_id>' ||
         </cfif>
         <cfif len(trim(arguments.situacao_ativo)) >
            '<situacao_ativo>#arguments.situacao_ativo#</situacao_ativo>' ||
         </cfif>
			<cfif len(trim(arguments.ordem_servico_id)) >
            '<ordem_servico_id>#arguments.ordem_servico_id#</ordem_servico_id>' ||
         </cfif> 
        '</params>')				
			) 
                columns
                   atividade_id               integer       path '/arrayItem/atividade_id'
                 , cod_atividade              varchar2(30)  path '/arrayItem/cod_atividade'
                 , titulo                     varchar2(240) path '/arrayItem/titulo'
                 , tempo_execucao             varchar2(20)  path '/arrayItem/tempo_execucao'
                 , tempo_execucao_total       integer       path '/arrayItem/tempo_execucao_total'
                 , tempo_execucao_horas       varchar2(3)   path '/arrayItem/tempo_execucao_horas'
                 , tempo_execucao_minutos     varchar2(3)   path '/arrayItem/tempo_execucao_minutos'
                 , garantia_km                integer       path '/arrayItem/garantia_km'
                 , garantia_horas_trabalhadas integer       path '/arrayItem/garantia_horas_trabalhadas'
                 , garantia_dias              integer       path '/arrayItem/garantia_dias'
                 , garantia_lts_combustivel   integer       path '/arrayItem/garantia_lts_combustivel'
                 , alerta_km                  integer       path '/arrayItem/alerta_km'
                 , alerta_horas_trabalhadas   integer       path '/arrayItem/alerta_horas_trabalhadas'
                 , alerta_dias                integer       path '/arrayItem/alerta_dias'
                 , alerta_lts_combustivel     integer       path '/arrayItem/alerta_lts_combustivel'
                 , multiplo                   integer       path '/arrayItem/multiplo'
                 , grupo_id                   integer       path '/arrayItem/grupo_id'
                 , tipo_id                    integer       path '/arrayItem/tipo_id'
                 , compartimento_id           integer       path '/arrayItem/compartimento_id'
                 , grupo                      varchar2(60)  path '/arrayItem/grupo'
                 , importancia                integer       path '/arrayItem/importancia'
                 , verificacao                integer       path '/arrayItem/verificacao'
                 , tempo_indefinido           integer       path '/arrayItem/tempo_indefinido'
                 , nivel_id                   integer       path '/arrayItem/nivel_id'
                 , tempo_minutos              integer       path '/arrayItem/tempo_minutos'
                 , produto_id                 integer       path '/arrayItem/produto_id'
                 , cod_material               varchar2(30)  path '/arrayItem/cod_material'
                 , material_id_pai            integer       path '/arrayItem/material_id_pai'
                 , valor                      integer       path '/arrayItem/valor'
                 , ativo                      integer       path '/arrayItem/ativo'
             ) x
       
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atividades ddireto na tabela 
	-- GUTO 19/08/2020
	--->
	<cffunction name="get_atividade_direto_tabela" returntype="query" access="remote">
		<cfargument name="situacao_ativo" required="no" default="0">
		<cfargument name="somente_arvore" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select a.atividade_id
                    , a.cod_atividade
                    , a.titulo
                    , to_char(a.tempo_execucao) as tempo_execucao
                    , (sysdate + a.tempo_execucao - sysdate) as tempo_execucao_total
                    , trim(to_char((extract(day from a.tempo_execucao) * 24) + extract( hour from a.tempo_execucao), '00')) as tempo_execucao_horas
                    , trim(to_char(extract(minute from a.tempo_execucao), '00')) as tempo_execucao_minutos
                    , a.garantia_km
                    , a.garantia_horas_trabalhadas
                    , a.garantia_dias
                    , a.garantia_lts_combustivel
                    , a.alerta_km
                    , a.alerta_horas_trabalhadas
                    , a.alerta_dias
                    , a.alerta_lts_combustivel
                    , a.multiplo
                    , a.grupo_id
                    , a.tipo_id
                    , a.compartimento_id
                    , ag.descricao as grupo
                    , a.importancia
                    , a.verificacao
                    , a.tempo_indefinido
                    , a.nivel_id
                    , round((sysdate + a.tempo_execucao - sysdate) * 1440) as tempo_minutos
                    , (select ap.produto_id
                         from manutencao.v$atividade_produto ap
                        where ap.atividade_id = a.atividade_id
                      ) as produto_id
                    , (select mp.cod_material
                         from almoxarifado.v$material_atividade ma
                        inner join almoxarifado.v$material m
                           on m.material_id  = ma.material_id
                        inner join almoxarifado.v$material mp
                           on mp.material_id = m.material_pai
                        where ma.atividade_id = a.atividade_id  )  as cod_material
                    , (select m.material_pai
                         from almoxarifado.v$material_atividade ma
                        inner join almoxarifado.v$material m
                           on m.material_id  = ma.material_id
                        where ma.atividade_id = a.atividade_id  ) as material_id_pai  , 0 as valor       
                    , a.ativo
                 from manutencao.v$atividade a
                 left join manutencao.v$atividade_grupo ag
                        on ag.grupo_id = a.grupo_id  where  1 = 1                      
 			   <cfif Len(Trim(arguments.situacao_ativo))>
	 	  	      and a.ativo = 1 
			   </cfif>
			  order by ag.descricao, a.titulo 
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
	-- PROPSITO
	-- Busca processo recurso
	-- NOTAS EXPLICATIVAS
	-- GUTO 03/08/2006
	--->
	<cffunction name="get_processo_recurso" returntype="query" access="remote">
		<cfargument name="processo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select item_id, processo_id, especialidade_id, quantidade, nivel_id, percentual_participacao,
											(select kss.fnc_concat_all(kss.to_concat_expr(nivel_id,','))
														from manutencao.v$recurso_nivel rn
													where rn.nivel_id <= p.nivel_id) as niveis_permitidos,
											(select count(*)
														from manutencao.v$processo_recurso pr
													where pr.processo_id = p.processo_id) as num_funcionarios
						from manutencao.v$processo_recurso p
			    where 1=1
 			  <cfif Len(Trim(arguments.processo_id))>
	 	  		and p.processo_id = #arguments.processo_id#
			  </cfif>
			  order by p.processo_id
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os processos da atividade
	-- CRISTOFER  11/08/2006
	--->
	<cffunction name="get_atividade_processo" access="remote" returntype="query">
		<cfargument name="atividade_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ap.item_id,
				   ap.item_pai,
				   ap.ordem,
				   ap.atividade_id,
				   ap.processo_id,
				   p.titulo as processo,
				   ap.user_insert,
				   ap.date_insert,
				   ap.user_update,
				   ap.date_update,
				   ap.site
			  from manutencao.v$atividade_processo ap
			 inner join manutencao.v$processo p
			         on p.processo_id = ap.processo_id
			 where ap.atividade_id in (#arguments.atividade_id#)
			 start with ap.item_pai is null
			connect by prior ap.item_id = ap.item_pai
			order siblings by ap.ordem
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca as posi��es da atividade
	-- CRISTOFER  11/08/2006
	--->
	<cffunction name="get_atividade_posicao" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ap.posicao_id,
				   ap.atividade_id,
				   ep.posicao
			  from manutencao.v$atividade_posicao ap
			 inner join manutencao.v$equipamento_posicao ep
			         on ep.posicao_id = ap.posicao_id
			 where atividade_id in (#arguments.atividade_id#)
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca dependencia entre as atividades
	-- GUTO 30/10/2006
	--->
	<cffunction name="get_atividade_dependencia" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id_principal" required="no" default="">
		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="atividade_id_dependente" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ad.atividade_id_principal, ad.atividade_id_dependente, ad.obrigatoria,
					 a1.titulo as atividade_principal, a2.titulo as atividade_dependente,
					 a1.cod_atividade as cod_atividade_principal, a2.cod_atividade as cod_atividade_dependente
			  from manutencao.v$atividade_dependencia ad
			 inner join manutencao.v$atividade a1
						on a1.atividade_id = ad.atividade_id_principal
			 inner join manutencao.v$atividade a2
						on a2.atividade_id = ad.atividade_id_dependente
			 where 1=1
			   <cfif Len(Trim(arguments.atividade_id_principal))>
				   and ad.atividade_id_principal = #arguments.atividade_id_principal#
				</cfif>
		     <cfif Len(Trim(arguments.atividade_id))>
               and ad.atividade_id_principal = #arguments.atividade_id#
             </cfif>
			   <cfif Len(Trim(arguments.atividade_id_dependente))>
				   and ad.atividade_id_dependente = #arguments.atividade_id_dependente#
				</cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atividades conjugadas
	-- GUTO 11/07/2008
	--->
	<cffunction name="get_atividade_conjugada" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id_principal" required="no" default="">
   		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="atividade_id_conjugada" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ad.atividade_id_principal, ad.atividade_id_conjugada, ad.baixa_obrigatoria,
                   a1.titulo as atividade_principal, a2.titulo as atividade_conjugada,
                   a1.cod_atividade as cod_atividade_principal, a2.cod_atividade as cod_atividade_conjugada,
				   ad.garantia_km, ad.garantia_horas_trabalhadas, ad.garantia_dias, ad.garantia_lts_combustivel,
				   ad.alerta_km, ad.alerta_horas_trabalhadas, ad.alerta_dias, ad.alerta_lts_combustivel
              from manutencao.v$atividade_conjugada ad
             inner join manutencao.v$atividade a1
                     on a1.atividade_id = ad.atividade_id_principal
             inner join manutencao.v$atividade a2
                     on a2.atividade_id = ad.atividade_id_conjugada
             where 1=1
		     <cfif Len(Trim(arguments.atividade_id_principal))>
               and ad.atividade_id_principal = #arguments.atividade_id_principal#
             </cfif>
		     <cfif Len(Trim(arguments.atividade_id))>
               and ad.atividade_id_principal = #arguments.atividade_id#
             </cfif>
             <cfif Len(Trim(arguments.atividade_id_conjugada))>
               and ad.atividade_id_conjugada = #arguments.atividade_id_conjugada#
             </cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atividade tipos de oficina
	-- GUTO 16/09/2006
	--->
	<cffunction name="get_atividade_oficina_tipo" access="remote" returntype="query" output="true">
		<cfargument name="atividade_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select atividade_id, oficina_tipo_id as tipo_id
			  from manutencao.v$atividade_oficina_tipo
			 where atividade_id = #arguments.atividade_id#
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca oficinas cadastradas
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO - 10/04/2007 - criado
	--->
	<cffunction name="get_oficinas" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa" required="no" default=""/>
		<cfargument name="interna" required="no" default=""/>
		<cfargument name="com_os" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select to_char(o.cod_pessoa) as cod_pessoa, o.cnpj_cpf, o.identificador, o.inscricao_estadual,
				   o.razao_social, o.cliente
			  from manutencao.v$oficinas o
			 where 1=1
			 <cfif Len(Trim(arguments.COD_PESSOA))>
			   and cod_pessoa = #arguments.COD_PESSOA#
			 </cfif>
			 <cfif Len(Trim(arguments.INTERNA))>
			   and interna= #arguments.INTERNA#
			 </cfif>
			 <cfif Len(Trim(arguments.COM_OS))>
			   and exists (select 'x'
			                 from manutencao.v$ordem_servico os
							where os.cod_pessoa_oficina = o.cod_pessoa)
			 </cfif>
			 order by cliente
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca as oficinas distintas a que os funcion�rios est�o vinculados
	-- NOTAS EXPLICATIVAS
	-- ERICG 21/10/2010
	--->
	<cffunction name="get_distinct_oficina_recurso" returntype="query" access="remote">
		<cfargument name="RECURSO_ID" required="no" default="" >
		<cfargument name="COD_PESSOA" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select distinct to_char(ro.cod_pessoa_oficina) as cod_pessoa_oficina
               , to_char(ro.data_inicio, 'dd/mm/yyyy') data_inicio
               , to_char(ro.data_fim, 'dd/mm/yyyy') data_fim
            from manutencao.v$recurso_oficina ro
           inner join manutencao.v$recurso re
                   on re.recurso_id in ro.recurso_id
           where 1 = 1
			<cfif len(Trim(arguments.RECURSO_ID))>
			   and ro.recurso_id in (#arguments.RECURSO_ID#)
		    </cfif>
			<cfif len(Trim(arguments.COD_PESSOA))>
			    and re.COD_PESSOA = #arguments.COD_PESSOA#
		    </cfif>
		    order by data_inicio desc
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 03/08/2006
	--->
	<cffunction name="get_recurso" returntype="query" access="remote">
		<cfargument name="recurso_id" required="no" default="">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="nivel_id" required="no" default="">
		<cfargument name="especialidade_id" required="no" default="">
		<cfargument name="todos" required="no" default="1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct r.recurso_id,
				    to_char(r.cod_pessoa) as cod_pessoa,
                pf.cliente as nome_funcionario,
				    oper.pkg_global.fnc_get_cod_funcionario(r.cod_pessoa) as cod_funcionario,
				    r.especialidade_id,
				    re.descricao as especialidade,
				    r.nivel_id,
                rn.descricao as nivel
			  from manutencao.v$recurso r
			 inner join manutencao.v$recurso_especialidade re
					 on re.especialidade_id = r.especialidade_id
			 inner join manutencao.v$recurso_nivel rn
					 on rn.nivel_id = r.nivel_id
			 inner join kss.v$pessoa pf
					 on pf.cod_pessoa = r.cod_pessoa
             inner join kss.v$pessoa_modalidade m
                on m.cod_pessoa = r.cod_pessoa
                and m.num_modalidade in (16,25,23,24,4)
			   and m.situacao = 1
		     where 1=1
			  <cfif arguments.todos eq 0>
			 	 and (exists (select 'x'
				               from manutencao.v$recurso_oficina ro
                      inner join manutencao.v$recurso r2
                              on r2.recurso_id = ro.recurso_id
                      where r2.cod_pessoa = r.cod_pessoa
                        and ro.cod_pessoa_oficina = #session.cod_pessoa#)
      			 	 or not exists (select 'x'
      				                  from manutencao.v$recurso_oficina ro
                               inner join manutencao.v$recurso r2
                                       on r2.recurso_id = ro.recurso_id
                               inner join oper.v$filial f
                                       on f.cod_pessoa = ro.cod_pessoa_oficina
                               where r2.cod_pessoa = r.cod_pessoa) )
			  </cfif>
 			  <cfif Len(Trim(arguments.cod_pessoa))>
							and r.cod_pessoa = #arguments.cod_pessoa#
			   </cfif>
			   <cfif Len(Trim(arguments.recurso_id))>
				   and r.recurso_id = #arguments.recurso_id#
			   </cfif>
			   <cfif Len(Trim(arguments.especialidade_id))>
				   and re.especialidade_id in (#arguments.especialidade_id#)
			   </cfif>
			   <cfif Len(Trim(arguments.nivel_id))>
				   and rn.nivel_id in (#arguments.nivel_id#)
			   </cfif>
			  order by nome_funcionario
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuten��o
	-- NOTAS EXPLICATIVAS
	-- GUTO 22/08/2006
	--->
	<cffunction name="get_tabela_manutencao" returntype="query" access="remote">
		<cfargument name="tabela_id" required="no" default="" />
		<cfargument name="titulo" required="no" default="" />
		<cfargument name="equipamento_id" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select replace(substr(sys_connect_by_path(replace(tm.nome,'/','@@'), '/'),2),'@@','/') as path,
                   tm.nome || ' [' || replace(substr(sys_connect_by_path(replace(tm.nome,'/','@@'), '/'),2),'@@','/')  || ']' as tabelas,
                   tm.nome, substr(sys_connect_by_path(tm.tabela_id, ','),2) as lista_tabelas,
                   substr(sys_connect_by_path('|' || tm.tabela_id || '|', ','),2) as lista_tabela_separador,
                   tm.descricao, tm.tabela_id, tm.tabela_pai, tm.obrigatoria,
                   tm.intervalo_km, tm.intervalo_dias,
                   tm.intervalo_horas_trabalhadas, tm.intervalo_lts_combustivel, tm.alerta_km,
                   tm.alerta_dias, tm.alerta_horas_trabalhadas, tm.alerta_lts_combustivel,
                   tm.verificacao_pneus, tm.atualiza_revisao, tm.exige_lavagem,tipo_execucao
              from manutencao.v$tabela_manutencao tm
             where 1=1
             <cfif Len(Trim(arguments.tabela_id))>
               and tm.tabela_id in (#arguments.tabela_id#)
             </cfif>
             <cfif Len(Trim(arguments.equipamento_id))>
               and tm.tabela_id in (select t.tabela_id
                                      from almoxarifado.v$equipamento e
                                     inner join manutencao.v$equipamento_tabela_manut et
                                        on et.equipamento_id = e.equipamento_id
                                     inner join manutencao.v$tabela_manutencao t
                                        on et.tabela_id = t.tabela_id
                                     where e.equipamento_id = #arguments.equipamento_id#
                                       and (t.intervalo_km <> 0 or t.intervalo_dias <> 0 or t.intervalo_horas_trabalhadas <> 0 or t.intervalo_lts_combustivel <> 0)
                                       and et.ordem_servico_id_execucao is null
                                     union
                                    select t.tabela_id
                                      from almoxarifado.v$equipamento e
                                     inner join manutencao.v$equipamento_modelo em
                                        on em.equipamento_id = e.equipamento_id
                                       and em.data_final is null
                                     inner join manutencao.v$tabela_modelo tm
                                        on tm.modelo_id = em.modelo_id
                                     inner join manutencao.v$tabela_manutencao t
                                        on t.tabela_id = tm.tabela_id
                                     where e.equipamento_id = #arguments.equipamento_id#
                                       and not exists (select 1
                                                         from manutencao.v$equipamento_tabela_manut et
                                                        where et.equipamento_id = e.equipamento_id
                                                          and et.tabela_id = t.tabela_id
                                                          and et.ordem_servico_id_execucao is null)
                                  )
             </cfif>
             <cfif Len(Trim(arguments.titulo))>
               and upper(tm.nome) like upper('%#arguments.titulo#%')
             </cfif>
             start with tm.tabela_pai = 0
           connect by prior tm.tabela_id = tm.tabela_pai
             order siblings by tm.tabela_pai
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuten��o (ATIVIDADE)
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/09/2006
	--->
	<cffunction name="get_tabela_atividade" returntype="query" access="remote">
		<cfargument name="tabela_id" required="yes"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ta.tabela_id, ta.atividade_id, a.titulo,
					round((sysdate + a.tempo_execucao - sysdate) * 1440) as tempo_minutos
			  from manutencao.v$tabela_atividade ta
			 inner join manutencao.v$atividade a
		  		     on a.atividade_id = ta.atividade_id
	      	 where 1=1
			 <cfif Len(Trim(arguments.tabela_id))>
			   and ta.tabela_id = #arguments.tabela_id#
			 </cfif>
		     order by ta.tabela_id
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuten��o vinculadas a um modelo
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/09/2006
	--->
	<cffunction name="get_tabela_modelo" returntype="query" access="remote">
		<cfargument name="tabela_id" required="no" default=""/>
		<cfargument name="modelo_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tm.tabela_id, tm.modelo_id, m.descricao as modelo,
					 tma.nome as tabela
			  from manutencao.v$tabela_modelo tm
			 inner join manutencao.v$modelo m
						on m.modelo_id = tm.modelo_id
			 inner join manutencao.v$tabela_manutencao tma
						on tma.tabela_id = tm.tabela_id
			 where 1=1
			 <cfif Len(Trim(arguments.tabela_id))>
			   and tm.tabela_id = #arguments.tabela_id#
			 </cfif>
			 <cfif Len(Trim(arguments.modelo_id))>
			   and tm.modelo_id = #arguments.modelo_id#
			 </cfif>
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os valores dos niveis de especialidades
	-- NOTAS EXPLICATIVAS
	-- ARLEN 11/12/2006
	--->
	<cffunction name="get_especialidade_valor" returntype="query" access="remote">
		<cfargument name="CONTROLE_ID" required="no" default="" >
		<cfargument name="ESPECIALIDADE_ID" required="no" default="" >
		<cfargument name="NIVEL_ID" required="no" default="" >
		<cfargument name="ABERTOS" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ev.controle_id,
				   ev.especialidade_id,
				   ev.nivel_id,
				   ev.valor_empresa,
				   ev.valor_terceiro,
				   to_char(ev.data_inicio,'dd/mm/yyyy hh24:mi:ss') data_inicio_char,
				   to_char(ev.data_fim,'dd/mm/yyyy hh24:mi:ss') data_fim_char,
				   re.descricao as especialidade_nome,
				   rn.descricao as nivel_nome
			from manutencao.v$especialidade_valor ev
			inner join manutencao.v$recurso_especialidade re
					   on re.especialidade_id = ev.especialidade_id
			inner join manutencao.v$recurso_nivel rn
					   on rn.nivel_id = ev.nivel_id
			where 1=1
			<cfif len(Trim(arguments.ABERTOS))>
			  and sysdate <= nvl(ev.data_fim,sysdate)
			</cfif>
			<cfif len(Trim(arguments.CONTROLE_ID))>
			  and ev.controle_id = #arguments.CONTROLE_ID#
			</cfif>
			<cfif len(Trim(arguments.ESPECIALIDADE_ID))>
			  and ev.especialidade_id = #arguments.ESPECIALIDADE_ID#
			</cfif>
			<cfif len(Trim(arguments.NIVEL_ID))>
			  and ev.nivel_id = #arguments.NIVEL_ID#
			</cfif>
			order by ev.data_inicio desc, re.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamentos
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 08/04/2009
	--->
	<cffunction name="get_equipamentos" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
        <cfargument name="placa" required="no" default="">
        <cfargument name="data_abertura" required="no" default="">
		<cfargument name="sem_modelo" required="no" default="0">
        <cfargument name="equipamento" required="no" default="">
        <cfargument name="analisados" required="no" default="">
        <cfargument name="sem_material" required="no" default="0">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.equipamento_id
                 , m.cod_equipamento
                 , m.placa
            <cfif arguments.sem_material eq 0>
                 , ma.descricao_completa
                 , ma.material
            <cfelse>
                 , (select kss.pkg_organograma.fnc_centro_custo((select max(vca.cod_centro_custo) keep(dense_rank last order by vca.data)
																	   from oper.v$veiculo_ccusto vca
																	  where vca.placa = m.placa
																	    and vca.data <= <cfif Len(trim(arguments.data_abertura))>'#arguments.data_abertura#'<cfelse>sysdate</cfif>))
					      from dual) as centro_custo
            </cfif>
                 , (select ce.contrato_id
                      from manutencao.v$contrato_equipamento ce
                     where ce.equipamento_id = m.equipamento_id
                       and ce.data_termino is null) as contrato_id
			        , kss.pkg_organizacional.fnc_cod_organizacional(oper.pkg_veiculo.fnc_veiculo_ccusto_gerencial(m.placa)) as cod_organizacional
                 , kss.pkg_binario.fnc_verifica_flag(m.situacao, 1) as situacao
              from almoxarifado.v$equipamento m
            <cfif arguments.sem_material eq 0>
             inner join almoxarifado.v$material_dados ma
                     on ma.material_id = m.material_id
            </cfif>
            <cfif Len(trim(arguments.analisados))>
              left join manutencao.v$equipamento_analise ea
                     on ea.equipamento_id = m.equipamento_id
            </cfif>
             where 1 = 1
            <cfif Len(Trim(arguments.equipamento_id))>
               and m.equipamento_id = #arguments.equipamento_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_equipamento))>
               and m.cod_equipamento = oper.pkg_veiculo.fnc_get_cod_veiculo(upper('#arguments.cod_equipamento#'))
            </cfif>
            <cfif Len(Trim(arguments.placa))>
               and (m.cod_equipamento = '#arguments.placa#'
                    or m.placa = oper.pkg_veiculo.fnc_get_placa(upper('#arguments.placa#'))
                   )
            </cfif>
            <cfif arguments.sem_modelo eq 1>
               and not exists (select 'x'
                                 from manutencao.v$equipamento_modelo em
                                where em.equipamento_id = m.equipamento_id
                                  and em.data_final is null)
            </cfif>
            <cfif Len(trim(arguments.equipamento))>
               and upper(ma.material) like upper('%#arguments.equipamento#%')
            </cfif>
            <cfif Len(trim(arguments.analisados))>
               and ea.data_analise is null
            </cfif>
             order by <cfif arguments.sem_material eq 0>ma.material,</cfif> m.cod_equipamento
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamentos e seus programas
	-- NOTAS EXPLICATIVAS
	-- FERNANDAB 08/09/2015
	--->
	<cffunction name="get_equipamentos_programas" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="sem_programa" required="no" default="0">
		<cfargument name="equipamento" required="no" default="">
		<cfargument name="vazio" required="no" default="">
		<cfargument name="listar_todos" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select em.controle_id
              , m.equipamento_id
              , m.cod_equipamento
              , ma.material
              , mo.modelo_id
              , mo.descricao
           from almoxarifado.v$equipamento m
          inner join almoxarifado.v$material_dados ma
             on ma.material_id = m.material_id
           left join manutencao.v$equipamento_modelo em
             on em.equipamento_id =  m.equipamento_id
            and em.data_final is null
           left join manutencao.v$modelo mo
             on mo.modelo_id = em.modelo_id
          where 1 = 1
			<cfif Len(Trim(arguments.vazio))>
            and 1 = 0
         </cfif>
         <cfif arguments.listar_todos eq 0>
            <cfif Len(Trim(arguments.equipamento_id))>
               and m.equipamento_id = #arguments.equipamento_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_equipamento))>
               and m.cod_equipamento = oper.pkg_veiculo.fnc_get_cod_veiculo('#arguments.cod_equipamento#')
            </cfif>
            <cfif Len(Trim(arguments.placa))>
               and (m.cod_equipamento = '#arguments.placa#'
                    or m.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
                   )
            </cfif>
            <cfif Len(trim(arguments.equipamento))>
               and upper(ma.material) like upper('%#arguments.equipamento#%')
            </cfif>
         </cfif>
         <cfif arguments.sem_programa eq 1>
         	and em.controle_id is null
         </cfif>
          order by m.cod_equipamento
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna todos os vinculos de Atividades/Modelos
	-- Rafael Rudnik 20/05/2008
	--->
    <cffunction name="get_atividade_modelo" returntype="query" access="remote">
        <cfargument name="modelo_id" required="no"/>
        <cfargument name="atividade_id" required="no"/>
        <cfargument name="controle_id" required="no"/>
        <cfargument name="titulo" required="no"/>
        <cfargument name="descricao_atividade" required="no"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select ma.controle_id
              , ma.modelo_id
              , ma.atividade_id
              , ma.garantia_km
              , ma.garantia_horas_trabalhadas
              , ma.garantia_dias
              , ma.garantia_lts_combustivel
              , ma.alerta_km
              , ma.alerta_horas_trabalhadas
              , ma.alerta_dias
              , ma.alerta_lts_combustivel
              , ma.user_insert
              , ma.date_insert
              , ma.user_update
              , ma.date_update
              , ma.site
              , at.titulo
              , at.cod_atividade
              , mo.descricao
           from manutencao.v$atividade_modelo ma
          inner join manutencao.v$atividade at
                  on at.atividade_id = ma.atividade_id
          inner join manutencao.v$modelo mo
                  on mo.modelo_id = ma.modelo_id
          where 1 = 1
			<cfif isDefined("arguments.controle_id") and len(trim(arguments.controle_id))>
            and ma.controle_id = '#arguments.controle_id#'
		   </cfif>
           <cfif isDefined("arguments.modelo_id") and len(trim(arguments.modelo_id))>
            and ma.modelo_id = '#arguments.modelo_id#'
		   </cfif>
           <cfif isDefined("arguments.atividade_id") and len(trim(arguments.atividade_id))>
            and ma.atividade_id = '#arguments.atividade_id#'
		   </cfif>
           <cfif isDefined("arguments.titulo") and len(trim(arguments.titulo))>
            and upper(at.titulo) LIKE upper('%#arguments.titulo#%')
		   </cfif>
          order by ma.controle_id desc
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Retorna os tipos de ordem de servi�o
    -- ANDERSON 08/12/2009 - CRIADO
    --->
    <cffunction name="get_tipo_ordem_servico" access="remote" returntype="query" output="true">
        <cfargument name="tipo_ordem_servico_id" required="no" default="">
        <cfargument name="descricao" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	select tos.tipo_ordem_servico_id
                 , tos.descricao
              from manutencao.v$tipo_ordem_servico tos
             where 1 = 1
			<cfif Len(Trim(arguments.tipo_ordem_servico_id))>
               and tos.tipo_ordem_servico_id = #arguments.tipo_ordem_servico_id#
            </cfif>
            <cfif Len(Trim(arguments.descricao))>
               and upper(tos.descricao) like upper('#arguments.descricao#%')
            </cfif>
             order by tos.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca todas as atividades vinculadas ao equipamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 27/12/2006
	--->
	<cffunction name="get_equipamento_atividades_vinculadas" returntype="query" access="remote">
		<cfargument name="EQUIPAMENTO_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ea.controle_id, a.atividade_id, a.cod_atividade, a.titulo as atividade,
				    decode(a.importancia,1,'Baixa',2,'M�dia','Alta') as importancia ,
					 e.cod_equipamento, ea.data_previsao, po.posicao,
					 ea.km_previsao, ea.km_rodado, ea.lts_previsao,
					 ea.data_previsao, ose.data_abertura as data_execucao,
					 manutencao.to_manut_atividade(ea.atividade_id, em.MODELO_ID).garantia_km as garantia_km,
					 manutencao.to_manut_atividade(ea.atividade_id, em.MODELO_ID).garantia_dias as garantia_dias
			  from manutencao.v$equipamento_atividade ea
			 inner join almoxarifado.v$equipamento e
						on e.equipamento_id = ea.equipamento_id
			 inner join manutencao.v$atividade a
						on a.atividade_id = ea.atividade_id
			 left join manutencao.v$equipamento_modelo em
						on em.equipamento_id = e.equipamento_id
					  and em.data_final is null
		      left join manutencao.v$equipamento_posicao po
			         on nvl(po.posicao_id,0) = nvl(ea.posicao_id,0)
			  left join manutencao.v$ordem_servico ose
						on ose.ordem_servico_id = ea.ordem_servico_id_execucao
			where 1=1
			<cfif len(Trim(arguments.EQUIPAMENTO_ID))>
			  and e.equipamento_id = #arguments.EQUIPAMENTO_ID#
			</cfif>
			order by ea.atividade_id, ose.data_abertura desc nulls first
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna tabelas em aberto no equipamento
	-- Guto 01/08/2008
	--->
    <cffunction name="get_equipamento_tabela_manutencao" returntype="query" access="remote">
        <cfargument name="cod_equipamento" required="no" default=""/>
        <cfargument name="equipamento_id" required="no" default=""/>
        <cfargument name="abertas" required="no" default="1"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.tabela_id, t.nome, et.controle_id,
		           et.km_previsao, nvl(oper.pkg_pneu.fnc_km_atual(e.placa),0) as km_atual,
                   et.km_previsao - nvl(oper.pkg_pneu.fnc_km_atual(e.placa),0) as diferenca,
                   t.atualiza_revisao,
                   case
                       when t.tipo_execucao = 0 then ''
                       when t.tipo_execucao = 1 then 'Completa'
                       when t.tipo_execucao = 2 then 'Parcial'
                   end tipo_execucao,
                   case
                     when et.ordem_servico_id_execucao = -1 then 'Inicial'
                   else nvl(to_char(os.data_fechamento,'dd/mm/yyyy'),'Previs�o') end data_execucao,
                   et.km_rodado, t.tipo_execucao, et.ordem_servico_id_execucao, os.num_ordem_servico as NUM_OS_EXECUCAO,
                   et.ordem_servico_id_previsao, osp.num_ordem_servico as num_os_previsao
                from almoxarifado.v$equipamento e
                inner join manutencao.v$equipamento_tabela_manut et
                                on et.equipamento_id = e.equipamento_id
                inner join manutencao.v$tabela_manutencao t
                                on t.tabela_id = et.tabela_id
                left join manutencao.v$os_tabela_manutencao otm
                       on otm.ordem_servico_id = et.ordem_servico_id_execucao
					  and otm.tabela_id = et.tabela_id
                left join manutencao.v$ordem_servico os
                       on os.ordem_servico_id = otm.ordem_servico_id
                left join manutencao.v$ordem_servico osp
                       on osp.ordem_servico_id = et.ordem_servico_id_previsao
            where 1=1
          <cfif arguments.ABERTAS eq 1>
            and et.ordem_servico_id_execucao is null
          </cfif>
          <cfif len(trim(arguments.cod_equipamento))>
                and e.cod_equipamento = '#arguments.cod_equipamento#'
		  </cfif>
          <cfif len(trim(arguments.equipamento_id))>
                and e.equipamento_id = #arguments.equipamento_id#
		  </cfif>
          <cfif arguments.ABERTAS eq 1>
	          order by e.cod_equipamento, et.km_previsao
          <cfelse>
             order by et.tabela_id, et.km_previsao desc
          </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca o contratos cadastrados
	-- GUTO 11/06/2008
	--->
	<cffunction name="get_contrato" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="no" default="">
    	<cfargument name="cod_pessoa_concessionaria" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cm.contrato_id, cm.titulo, to_char(cm.cod_pessoa_concessionaria) as cod_pessoa_concessionaria,
            	   to_char(cm.data_inicial,'dd/mm/yyyy') as data_inicial,
                   to_char(cm.data_final,'dd/mm/yyyy') as data_final,
                   p.cliente as concessionaria,
                   p.cnpj_cpf as cnpj_concessionaria
              from manutencao.v$contrato_manutencao cm
             inner join kss.v$pessoa p
                     on p.cod_pessoa = cm.cod_pessoa_concessionaria
              where 1=1
              <cfif Len(Trim(arguments.contrato_id))>
                and contrato_id = #arguments.contrato_id#
              </cfif>
              <cfif Len(Trim(arguments.cod_pessoa_concessionaria))>
                and cod_pessoa_concessionaria = #arguments.cod_pessoa_concessionaria#
              </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca o tabelas de custo
	-- GUTO 11/06/2008
	--->
	<cffunction name="get_contrato_tabela_custo" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_id" required="no" default="">
    	<cfargument name="contrato_id" required="no" default="">
    	<cfargument name="modelo_id" required="no" default="">
    	<cfargument name="atual" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ctc.contrato_id
                 , ctc.tabela_id
                 , ctc.titulo
                 , to_char(ctc.data_vigencia,'dd/mm/yyyy') as data_vigencia
                 , ctc.modelo_id
                 , m.descricao as modelo
                 , ctf.num_faixa
                 , ctf.km_inicial
                 , ctf.km_final
                 , ctf.ano_fabricacao_inicial
                 , ctf.ano_fabricacao_final
                 , ctf.valor_km
                 , ctf.observacao
              from manutencao.v$contrato_tabela_custo ctc
              left join manutencao.v$contrato_tabela_faixa ctf
                     on ctc.tabela_id = ctf.tabela_id
              left join manutencao.v$modelo m
                     on m.modelo_id = ctc.modelo_id
             where 1=1
            <cfif Len(Trim(arguments.tabela_id))>
              and ctc.tabela_id = #arguments.tabela_id#
            </cfif>
  	  	    <cfif Len(Trim(arguments.contrato_id))>
              and ctc.contrato_id = #arguments.contrato_id#
            </cfif>
            <cfif Len(Trim(arguments.modelo_id))>
              and ctc.modelo_id = #arguments.modelo_id#
            </cfif>
            <cfif Len(Trim(arguments.atual))>
              and ctc.data_vigencia = (select max(ctc2.data_vigencia)
                                         from manutencao.v$contrato_tabela_custo ctc2
                                        where ctc2.contrato_id = ctc.contrato_id
                                          and ctc2.modelo_id = ctc.modelo_id)
            </cfif>
            order by ctc.contrato_id, ctc.tabela_id, ctf.km_inicial
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca vinculos entre equipamentos e contratos
	-- GUTO 03/09/2008
	--->
	<cffunction name="get_contrato_equipamento" access="remote" returntype="query" output="true">
    	<cfargument name="contrato_id" required="no" default="">
    	<cfargument name="cod_equipamento" required="no" default="">
    	<cfargument name="situacao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select ce.controle_id
                 , c.titulo
                 , ce.equipamento_id
                 , e.cod_equipamento
                 , m.descricao_completa as material
                 , to_char(ce.data_inicio,'dd/mm/yyyy') as data_inicio
                 , to_char(ce.data_termino,'dd/mm/yyyy') as data_termino
              from manutencao.v$contrato_manutencao c
             inner join manutencao.v$contrato_equipamento ce
                     on ce.contrato_id = c.contrato_id
             inner join manutencao.v$equipamento e
                     on e.equipamento_id = ce.equipamento_id
             inner join almoxarifado.v$material m
                     on m.material_id = e.material_id
              where 1=1
              <cfif Len(Trim(arguments.contrato_id))>
                and c.contrato_id = #arguments.contrato_id#
              </cfif>
              <cfif Len(Trim(arguments.cod_equipamento))>
                and e.cod_equipamento = '#arguments.cod_equipamento#'
              </cfif>
              <cfif Len(Trim(arguments.situacao))>
                <cfif arguments.situacao eq 1>
                  and ce.data_termino is null
                <cfelse>
                 and ce.data_termino is not null
                </cfif>
              </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca dados do fechamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/10/2008
	--->
	<cffunction name="get_contrato_fechamento" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfargument name="contrato_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select f.fechamento_id
                 , f.contrato_id
                 , to_char(f.data_fechamento,'dd/mm/yyyy') as data_fechamento
                 , to_char(f.data_inicial,'dd/mm/yyyy') as data_inicial
                 , to_char(f.data_final,'dd/mm/yyyy') as data_final
                 , nvl(f.valor_acordo,0) valor_acordo
                 , nvl(f.desconto,0) desconto
                 , nvl(f.total_acordo,0) as total_acordo
                 , c.titulo as contrato
                 , to_char(f.data_inicial,'dd/mm/yyyy') || ' at ' || to_char(f.data_final,'dd/mm/yyyy') as periodo
              from manutencao.v$contrato_fechamento f
             inner join manutencao.v$contrato_manutencao c
                on c.contrato_id = f.contrato_id
             where 1=1
             <cfif Len(Trim(arguments.contrato_id))>
			   and f.contrato_id = #arguments.contrato_id#
             </cfif>
             <cfif Len(Trim(arguments.fechamento_id))>
			   and f.fechamento_id = #arguments.fechamento_id#
             </cfif>
             <cfif Len(Trim(arguments.data_inicial))>
			   and f.data_fechamento >= '#arguments.data_inicial#'
             </cfif>
             <cfif Len(Trim(arguments.data_final))>
			   and f.data_fechamento <= '#arguments.data_final#'
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>


	<!---
	-- PROPSITO
	-- Busca dados dos itens fechamento
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/10/2008
	--->
	<cffunction name="get_contrato_fechamento_it" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfargument name="contrato_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select fi.fechamento_id
                 , fi.item_id
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(fi.placa) as cod_equipamento
                 , fi.placa
                 , to_char(cf.data_inicial,'dd/mm/yyyy') as data_inicial
                 , to_char(cf.data_final,'dd/mm/yyyy') as data_final
                 , fi.km_inicial
                 , fi.km_final
                 , fi.km_final-fi.km_inicial as km_rodado
                 , fi.tabela_id
                 , fi.num_faixa
                 , fi.valor_km
                 , fi.valor_km * (fi.km_final-fi.km_inicial) as total
                 , cm.titulo as contrato
              from manutencao.v$contrato_fechamento_it fi
             inner join manutencao.v$contrato_fechamento cf
                on cf.fechamento_id = fi.fechamento_id
             inner join manutencao.v$contrato_manutencao cm
                on cm.contrato_id = cf.contrato_id
             where 1=1
             <cfif Len(Trim(arguments.placa))>
			   and fi.placa = '#arguments.placa#'
             </cfif>
             <cfif Len(Trim(arguments.contrato_id))>
			   and cf.contrato_id = #arguments.contrato_id#
             </cfif>
             <cfif Len(Trim(arguments.fechamento_id))>
			   and cf.fechamento_id = #arguments.fechamento_id#
             </cfif>
             <cfif Len(Trim(arguments.data_inicial))>
			   and cf.data_fechamento >= '#arguments.data_inicial#'
             </cfif>
             <cfif Len(Trim(arguments.data_final))>
			   and cf.data_fechamento <= '#arguments.data_final#'
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca dados dos descontos fechamentos
	-- NOTAS EXPLICATIVAS
	-- GUTO 10/10/2008
	--->
	<cffunction name="get_contrato_fechamento_desconto" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct fd.controle_id
                 , fd.fechamento_id
                 , fd.num_nota_id
                 , fd.placa
                 , fd.valor_desconto
                 , nf.num_nota_fiscal
                 , nf.emit_razao_social
                 , nf.emit_cnpj_cpf
                 , to_char(nf.data_emissao,'dd/mm/yyyy') as data_emissao
                 , fd.placa
                 , oper.pkg_veiculo.fnc_get_cod_veiculo(fd.placa) as cod_veiculo
              from manutencao.v$contrato_fechamento_desconto fd
              left join fiscal.v$nf_terceiro nf
                on nf.num_nota_id = fd.num_nota_id
              left join fiscal.v$nf_terceiro_rateio nr
                on nr.num_nota_id = nf.num_nota_id
            where 1=1
             <cfif Len(Trim(arguments.fechamento_id))>
			   and fd.fechamento_id = #arguments.fechamento_id#
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca fechamento de manutencao
	-- NOTAS EXPLICATIVAS
	-- IGOR 07/10/2008
	--->
	<cffunction name="get_fechamento_manutencao" returntype="query" access="remote">
		<cfargument name="data_inicial" required="no" default="">
   		<cfargument name="data_final" required="no" default="">
   		<cfargument name="contrato_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select placa, contrato, equipamento_id, cod_equipamento,
                	   to_char(data_final,'dd/mm/yyyy hh24:mi:ss') as data_final,
                       to_char(data_inicial,'dd/mm/yyyy hh24:mi:ss') as data_inicial,
                       tabela_id,
                	   contrato_id, num_faixa, valor_km, sum(km_faixa) as km_rodado, (sum(km_faixa) * valor_km) as total,
                 case
                        when alfa_i > beta_i and alfa_t > beta_t and alfa_i < beta_t  then  alfa_i
                        when alfa_i < beta_i and alfa_t < beta_t and alfa_t > beta_i then  beta_i
                        when alfa_i < beta_i and alfa_t > beta_t and alfa_t > beta_i then  beta_i
                        when alfa_i > beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_i
                        when alfa_i > beta_i and alfa_i > beta_t then 0
                        when alfa_t < beta_i and alfa_t < beta_t then 0
                        end km_inicial,
                 case
                        when alfa_i > beta_i and alfa_t > beta_t and alfa_i < beta_t  then  beta_t
                        when alfa_i < beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t
                        when alfa_i < beta_i and alfa_t > beta_t and alfa_t > beta_i then  beta_t
                        when alfa_i > beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t
                        when alfa_i > beta_i and alfa_i > beta_t then 0
                        when alfa_t < beta_i and alfa_t < beta_t then 0
                        end km_final
              from (select placa, contrato, equipamento_id, cod_equipamento,  contrato_id, alfa_i,
                           alfa_t, beta_i, beta_t, num_faixa, valor_km, data_final, data_inicial, tabela_id,
                         case
                                when alfa_i > beta_i and alfa_t > beta_t and alfa_i < beta_t  then  beta_t - alfa_i

                                when alfa_i < beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t - beta_i
                                when alfa_i < beta_i and alfa_t > beta_t and alfa_t > beta_i then  beta_t - beta_i
                                when alfa_i > beta_i and alfa_t < beta_t and alfa_t > beta_i then  alfa_t - alfa_i
                                when alfa_i > beta_i and alfa_i > beta_t then 0
                                when alfa_t < beta_i and alfa_t < beta_t then 0
                                end km_faixa
                            from (
                            select cm.titulo as contrato, e.placa, e.cod_equipamento, ce.equipamento_id,  ct.contrato_id,
                                   t.km_inicial alfa_i, nvl(t.km_final, power(10, 38)) alfa_t,
                                   z.primeiro_km beta_i, z.ultimo_km beta_t, t.num_faixa, t.valor_km, em.data_final, em.data_inicial,
								   t.tabela_id
                             from manutencao.v$contrato_equipamento ce
                            inner join manutencao.v$contrato_manutencao cm
                                            on cm.contrato_id = ce.contrato_id
                            inner join manutencao.v$equipamento_modelo em
                                            on em.equipamento_id = ce.equipamento_id
                            inner join almoxarifado.v$equipamento e
                                            on e.equipamento_id = ce.equipamento_id
                            inner join manutencao.v$contrato_tabela_custo ct
                                            on ct.contrato_id = ce.contrato_id
                                         and ct.modelo_id = em.modelo_id
                            inner join manutencao.v$contrato_tabela_faixa t
                                            on t.tabela_id = ct.tabela_id
                            inner join (
                            			  select y.placa, ultimo_km, primeiro_km, max(dt) as data_final, min(dta) as data_inicial
                                            from (select x.placa, x.dt, x.km, x.dta, x.kma,
                                                         last_value(x.km) over (partition by x.placa) ultimo_km, first_value(x.kma) over (partition by x.placa) primeiro_km
                                                    from (select t.placa, t.data_hora dt,t.km,
                                                                 lag(t.data_hora, 1,(select nvl(max(i.data_hora), to_date('#arguments.data_inicial#','dd/mm/yyyy'))
                                                            from oper.v$veiculo_km i
                                                           where 1=1
                                                             and i.data_hora < to_date('#arguments.data_inicial#','dd/mm/yyyy')
                                                             and i.placa = t.placa)) over (partition by t.placa order by t.data_hora) dta,
                                                                 lag(t.km, 1, (select z.km
                                                                                 from oper.v$veiculo_km z
                                                                                where z.data_hora = (select nvl(max(i.data_hora), to_date('#arguments.data_inicial#','dd/mm/yyyy'))
                                                                                                                             from oper.v$veiculo_km i
                                                                                                                            where 1=1
                                                                                                                                and i.data_hora < to_date('#arguments.data_inicial#','dd/mm/yyyy')
                                                                                                                                and i.placa = t.placa)
                                                                                    and z.placa = t.placa)) over (partition by t.placa order by t.data_hora) kma
                                                                            from oper.v$veiculo_km t
                                                                         inner join oper.v$veiculo_proprietario vp
                                                                                         on vp.placa = t.placa
                                                                                        and t.data_hora between vp.data_inicio and nvl(vp.data_fim,sysdate)
                                                                            where 1=1
                                                                                     and trunc(t.data_hora) between to_date('#arguments.data_inicial#','dd/mm/yyyy') and to_date('#arguments.data_final#','dd/mm/yyyy'))x
                                                                                     ) y
                            group by y.placa, ultimo_km, primeiro_km) z
                            on z.placa = e.PLACA
                            )
                            <cfif Len(Trim(arguments.contrato_id))>
                            	where contrato_id = #arguments.contrato_id#
                            </cfif>
                            order by placa, alfa_i
            )
            where km_faixa > 0
            group by placa, contrato, equipamento_id, cod_equipamento, contrato_id, tabela_id, num_faixa, valor_km, alfa_i, alfa_t, beta_i, beta_t,
					data_final, data_inicial
            order by cod_equipamento
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Nota fiscal de terceiro e Ordem de Compra
	-- GUTO  20/12/2006
	--->
	<cffunction name="get_nf_terceiro" access="remote" returntype="query" output="true">
		<cfargument name="num_nota_fiscal" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select nf.num_nota_id
                 , nf.num_nota_fiscal
                 , nfpi.valor_utilizado
                 , p.identificador as cnpj_oficina
                 , p.razao_social as razao_social_oficina
                 , p.cliente as nome_fantasia_oficina
                 , p.cod_pessoa as cod_pessoa_oficina
                 , nf.calc_valor_total_nota
                 , sp.equipamento as frota
			  from fiscal.v$nf_terceiro nf
			 inner join kss.v$pessoa p
 				on p.cod_pessoa = nf.cod_emitente
 		     inner join fiscal.v$nf_terceiro_pedido_item nfpi
                on nfpi.num_nota_id = nf.num_nota_id
             inner join compras.v$solicitacao_pedido sp
                on sp.pedido_id = nfpi.pedido_id
			 where 1=1
			 <cfif Len(Trim(arguments.num_nota_fiscal))>
			   and nf.num_nota_fiscal = #arguments.num_nota_fiscal#
			 </cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
	-- PROPSITO
	-- Busca servicos vencidos ou a vencer para a OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_veiculo_atividade" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
      <cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="nao_executada" required="no" default="">
		<cfargument name="km" required="no" default="">
		<cfset v_composicao = this.get_composicao(placa = arguments.PLACA, equipamento_id = arguments.EQUIPAMENTO_ID)>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.equipamento_id, r.controle_id, r.cod_equipamento, r.atividade_id, r.posicao_id, r.posicao, r.cod_atividade,
				   r.titulo, r.data_previsao, r.km_previsao, r.importancia, r.alerta_km,
				   r.alerta_dias, r.dias,
			       manutencao.to_veiculo_km(r.cod_equipamento,r.data_previsao,r.data_previsao).km_data_inicial km_real,
					   case
						  when r.ordem_servico_id_execucao is null
						   and (
                               (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao and manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).garantia_km > 0)
							   <cfif Len(Trim(arguments.km))>
							   or (r.km_previsao < #arguments.km# and manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).garantia_km > 0)
							   </cfif>
							   or (sysdate > r.data_previsao and manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).garantia_dias > 0)) then 'Vencido'
						  when r.ordem_servico_id_execucao is null
						   and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).alerta_km > r.km_previsao and manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).garantia_km > 0)
							   or (sysdate + manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).alerta_dias > r.data_previsao and manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).garantia_dias > 0)) then 'A Vencer'
						  when r.ordem_servico_id_execucao is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 'Ok'
					   else 'Executada' end status,
					   case
						  when r.ordem_servico_id_execucao is null
						   and (
                               (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao and manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).garantia_km > 0)
							   <cfif Len(Trim(arguments.km))>
							   or (r.km_previsao < #arguments.km# and manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).garantia_km > 0)
							   </cfif>
							   or (sysdate > r.data_previsao and manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).garantia_dias > 0)) then -2
						  when r.ordem_servico_id_execucao is null
						   and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).alerta_km > r.km_previsao and manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).garantia_km > 0)
							   or (sysdate + manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).alerta_dias > r.data_previsao and manutencao.to_manut_atividade(r.atividade_id, r.modelo_id).garantia_dias > 0)) then -1
						  when r.ordem_servico_id_execucao is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 1
					   else 0 end status_id,
					   r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto,
                       r.garantia_km,r.garantia_dias

			  from (
						select /*+ ORDERED */ e.equipamento_id, ea.controle_id, e.cod_equipamento, a.atividade_id, ap.posicao_id, nvl(ap.posicao, 'nica') as posicao,
						   a.cod_atividade, a.titulo, ea.data_previsao, ea.km_previsao,
						   a.importancia, ea.ordem_servico_id_execucao,
								   manutencao.to_manut_atividade(ea.atividade_id, em.modelo_id).alerta_km as alerta_km,
								   manutencao.to_manut_atividade(ea.atividade_id, em.modelo_id).alerta_dias as alerta_dias,
                           decode(manutencao.to_manut_atividade(ea.atividade_id, em.modelo_id).garantia_dias,0,0,round(ea.data_previsao - sysdate)) as dias,
                           a.garantia_km,a.garantia_dias, em.modelo_id
							  from manutencao.v$equipamento_atividade ea
							 inner join manutencao.v$atividade a
									 on a.atividade_id = ea.atividade_id
							 inner join almoxarifado.v$equipamento e
									 on e.equipamento_id = ea.equipamento_id
							  left join manutencao.v$equipamento_modelo em
                                     on em.equipamento_id = e.equipamento_id
                                    and sysdate between em.data_inicial and nvl(em.data_final, sysdate)
							  left join manutencao.v$equipamento_posicao ap
									 on ea.posicao_id = ap.posicao_id
							 where 1=1
							  <cfif Len(Trim(arguments.nao_executada))>
							   and ea.ordem_servico_id_execucao is null
							   and a.verificacao = 0
							  </cfif>
							  <cfif Len(Trim(arguments.placa)) or Len(Trim(arguments.equipamento_id))>
							   and e.equipamento_id in (#v_composicao#)
							  </cfif>
							  <cfif Len(Trim(arguments.equipamento_id))>
							   and e.equipamento_id in (#arguments.equipamento_id#)
							  </cfif>
							  <cfif Len(Trim(arguments.atividade_id))>
							   and a.atividade_id = #arguments.atividade_id#
							  </cfif>
						 ) r
			  order by r.cod_equipamento, r.posicao, r.km_previsao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca materiais com a garantia vencida para a OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_veiculo_material" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
		<cfargument name="km_atual" required="no" default="">
      <cfargument name="data_inicial" required="no" default="">
      <cfargument name="data_final" required="no" default="">
		<cfset v_composicao = this.get_composicao(placa = arguments.placa, equipamento_id = arguments.equipamento_id)>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select r.equipamento_id, r.cod_equipamento, r.controle_id, r.material_id, r.posicao,
				   r.cod_material, r.material, r.data_previsao, r.km_previsao,
				   r.alerta_km, r.alerta_dias, r.dias, r.ordem_servico_id_desmontagem,
					   case
						  when (r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
                           and r.km_previsao > 0)
							   or sysdate > r.data_previsao) then 'Vencido'
						  when (r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_material(r.material_id).alerta_km > r.km_previsao
                           and r.km_previsao > 0)
							   or sysdate + manutencao.to_manut_material(r.material_id).alerta_dias > r.data_previsao) then 'A Vencer'
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 'Ok'
					   else 'Executada' end status,
					   case
						  when (r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao
                           and r.km_previsao > 0)
							   or sysdate > r.data_previsao) then -2
						  when (r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_material(r.material_id).alerta_km > r.km_previsao
                           and r.km_previsao > 0)
							   or sysdate + manutencao.to_manut_material(r.material_id).alerta_dias > r.data_previsao) then -1
						  when r.ordem_servico_id_desmontagem is null
						   and (manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial <= r.km_previsao
							   or sysdate <= r.data_previsao) then 1
					   else 0 end status_id,
					   r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto,
						cod_equipamento_identificado
			  from (select e.equipamento_id, e.cod_equipamento, em.controle_id, nvl(ap.posicao, 'nica') as posicao,
						   		m.material_id, m.cod_material, m.material, em.data_previsao, em.km_previsao,
								   manutencao.to_manut_material(em.material_id).alerta_km as alerta_km,
								   manutencao.to_manut_material(em.material_id).alerta_dias as alerta_dias,
								   round(sysdate - em.data_previsao) as dias, em.ordem_servico_id_desmontagem,
									mp.cod_equipamento as cod_equipamento_identificado
						  from manutencao.v$equipamento_material em
						 inner join almoxarifado.v$material_dados m
									 on m.material_id = em.material_id
						 inner join almoxarifado.v$equipamento e
									 on e.equipamento_id = em.equipamento_id
						  left join manutencao.v$equipamento_posicao ap
								   on em.posicao_id = ap.posicao_id
						  left join almoxarifado.v$equipamento mp
						         on mp.equipamento_id = em.equipamento_id_identificado
						 where em.ordem_servico_id_desmontagem is null
						 <cfif Len(Trim(arguments.placa)) or Len(Trim(arguments.equipamento_id))>
						   and e.equipamento_id in (#v_composicao#)
						 </cfif>
						 ) r
			 where 1=1
			  order by r.cod_equipamento, r.posicao, r.data_previsao
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca solicita��es enviadas pelos motoristas
	-- NOTAS EXPLICATIVAS
	-- GUTO 05/10/2006
	--->
	<cffunction name="get_equipamento_solicitacao" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfargument name="abertas" required="no" default="1">
		<cfif Len(Trim(arguments.placa))>
			<cfset v_composicao = this.get_composicao(placa = arguments.placa)>
		</cfif>
		<cfif Len(Trim(arguments.equipamento_id))>
			<cfset v_composicao = this.get_composicao(equipamento_id = arguments.equipamento_id)>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			 select /*+ first_rows */ e.cod_equipamento
                  , ms.solicitacao_id
                  , ms.equipamento_id
                  , to_char(ms.data_solicitacao, 'dd/mm/yyyy') as data_solicitacao
                  , ms.texto
                  , ms.atendida
                  , ms.ordem_servico_id_execucao
                  , ms.user_insert
                  , ms.date_insert
                  , (select to_char(cod_pessoa)
          			   from oper.v$veiculo_motorista vm
         			  where vm.placa = e.cod_equipamento
           				and vm.data_inicio = (select max(vm2.data_inicio)
                                   				from oper.v$veiculo_motorista vm2
                                  			   where vm.placa = e.cod_equipamento)) as cod_pessoa_motorista
                  , oper.pkg_global.fnc_busca_nome_pessoa((select cod_pessoa
                                                			 from oper.v$veiculo_motorista vm
                                              				where vm.placa = e.cod_equipamento
                                                			  and vm.data_inicio = (select max(vm2.data_inicio)
                                                                        			  from oper.v$veiculo_motorista vm2
                                                                       				 where vm.placa = e.cod_equipamento))) as motorista
                  , (select est.descricao
                       from manutencao.v$equipamento_solicitacao_tipo est
                      where est.tipo_id = ms.tipo_id ) as tipo
			   from manutencao.v$equipamento_solicitacao ms
			  inner join almoxarifado.v$equipamento e
			     on e.equipamento_id = ms.equipamento_id
  			  where 1=1
  			  <cfif Len(Trim(arguments.equipamento_id))>
			 	and ms.equipamento_id = #arguments.equipamento_id#
			  </cfif>
  			  <cfif Len(Trim(arguments.placa))>
			 	and ms.equipamento_id in (#v_composicao#)
			  </cfif>



  			  <cfif Len(Trim(arguments.abertas)) eq 1>
			 	and ms.ordem_servico_id_execucao is null
			  </cfif>
			  order by ms.data_solicitacao desc
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuten��o vincculadas a um Veculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 05/10/2006
	--->
	<cffunction name="get_equipamento_tabela" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfset v_composicao = this.get_composicao(placa = arguments.placa, equipamento_id = arguments.equipamento_id)>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select r.equipamento_id, r.cod_equipamento, r.nome as tabela, r.obrigatoria,
               r.data_previsao, r.km_previsao, r.ordem_servico_id_execucao,
               nvl(r.controle_id, to_number(r.tabela_id||r.equipamento_id)) as identificador,
               r.controle_id, r.tabela_id, r.atualiza_revisao,
               r.dias_previsto, r.alerta_km, r.alerta_dias,
               nvl(manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial,0) as km_atual,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then 'Sem execuo'
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 'Executada'
                 when r.ordem_servico_id_execucao is null
                     and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao and r.intervalo_km > 0)
                      or (sysdate > r.data_previsao and r.intervalo_dias > 0)) then 'Vencida'
                 when r.ordem_servico_id_execucao is null
                     and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao and r.intervalo_km > 0)
                      or (sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao and r.intervalo_dias > 0)) then 'A vencer'
                 else 'OK' end status,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then -3
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 0
                 when r.ordem_servico_id_execucao is null
                     and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao and r.intervalo_km > 0)
                      or (sysdate > r.data_previsao and r.intervalo_dias > 0)) then -2
                 when r.ordem_servico_id_execucao is null
                     and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao and r.intervalo_km > 0)
                      or (sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao and r.intervalo_dias > 0)) then -1
                 else 1 end status_id,
                 r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto,
                 r.intervalo_km,r.intervalo_dias
                from (select e.equipamento_id, e.cod_equipamento, t.nome,
                       t.obrigatoria, t.tabela_id, et.data_previsao, et.km_previsao,
                       et.ordem_servico_id_execucao, et.controle_id ,
                       round(sysdate - et.data_previsao) as dias_previsto,
                       manutencao.to_manut_tabela(et.tabela_id).alerta_km as alerta_km,
                       manutencao.to_manut_tabela(et.tabela_id).alerta_dias as alerta_dias,
                             t.atualiza_revisao,t.intervalo_km,t.intervalo_dias
                    from almoxarifado.v$equipamento e
                   inner join manutencao.v$equipamento_tabela_manut et
                       on et.equipamento_id = e.equipamento_id
                   inner join manutencao.v$tabela_manutencao t
                       on et.tabela_id = t.tabela_id
                   where e.equipamento_id in (#v_composicao#)
                         and (t.intervalo_km <> 0 or t.intervalo_dias <> 0 or t.intervalo_horas_trabalhadas <> 0 or t.intervalo_lts_combustivel <> 0)
                 ) r
            where 1=1
                and r.ordem_servico_id_execucao  is null
  			  <cfif Len(Trim(arguments.equipamento_id))>
			 	and r.equipamento_id = #arguments.equipamento_id#
			  </cfif>
        union
          select r.equipamento_id, r.cod_equipamento, r.nome as tabela, r.obrigatoria,
               r.data_previsao, r.km_previsao, r.ordem_servico_id_execucao,
               nvl(r.controle_id, to_number(r.tabela_id||r.equipamento_id)) as identificador,
               r.controle_id, r.tabela_id, r.atualiza_revisao,
               r.dias_previsto, r.alerta_km, r.alerta_dias,
                 nvl(manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial,0) as km_atual,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then 'Sem execuo'
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 'Executada'
                 when r.ordem_servico_id_execucao is null
                     and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao and r.intervalo_km > 0)
                      or (sysdate > r.data_previsao and r.intervalo_dias > 0)) then 'Vencida'
                 when r.ordem_servico_id_execucao is null
                     and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao and r.intervalo_km > 0)
                      or (sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao and r.intervalo_dias > 0)) then 'A vencer'
                 else 'OK' end status,
                 case
                 when r.ordem_servico_id_execucao is null and r.controle_id is null then -3
                 when r.ordem_servico_id_execucao is not null and r.controle_id is not null then 0
                 when r.ordem_servico_id_execucao is null
                     and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial > r.km_previsao and r.intervalo_km > 0)
                      or (sysdate > r.data_previsao and r.intervalo_dias > 0)) then -2
                 when r.ordem_servico_id_execucao is null
                     and ((manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_tabela(r.tabela_id).alerta_km >= r.km_previsao and r.intervalo_km > 0)
                      or (sysdate + manutencao.to_manut_tabela(r.tabela_id).alerta_dias > r.data_previsao and r.intervalo_dias > 0)) then -1
                 else 1 end status_id,
                 r.km_previsao - manutencao.to_veiculo_km(r.cod_equipamento,sysdate,sysdate).km_data_inicial as km_previsto,
                 r.intervalo_km,r.intervalo_dias
            from (select e.equipamento_id, e.cod_equipamento, t.nome,
                   t.obrigatoria, t.tabela_id, null as data_previsao, null as km_previsao,
                   null as ordem_servico_id_execucao, null as controle_id ,
                   null as dias_previsto,
                   manutencao.to_manut_tabela(tm.tabela_id).alerta_km as alerta_km,
                   manutencao.to_manut_tabela(tm.tabela_id).alerta_dias as alerta_dias,
                         t.atualiza_revisao,t.intervalo_km,t.intervalo_dias
                from almoxarifado.v$equipamento e
               inner join manutencao.v$equipamento_modelo em
                   on em.equipamento_id = e.equipamento_id
                   and em.data_final is null
               inner join manutencao.v$tabela_modelo tm
                   on tm.modelo_id = em.modelo_id
               inner join manutencao.v$tabela_manutencao t
                   on t.tabela_id = tm.tabela_id
               where e.equipamento_id in (#v_composicao#)
                   and not exists (select 1
                                       from manutencao.v$equipamento_tabela_manut et
                          where et.equipamento_id = e.equipamento_id
                            and et.tabela_id = t.tabela_id
                                        and et.ordem_servico_id_execucao  is null)
                 ) r
            where 1=1
  			  <cfif Len(Trim(arguments.equipamento_id))>
			 	and r.equipamento_id = #arguments.equipamento_id#
			  </cfif>
			  order by km_previsto

 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna o KM baseado o parametro de limite de revisao
	-- Se o KM limite for negativo No ser� permitida a inclus�o de tabelas que atualizam revis�o
	-- Se o KM estiver positivo a revis�o pode ser executada
	-- NOTAS EXPLICATIVAS
	-- GUTO 09/07/2007
	--->
	<cffunction name="get_permite_revisao" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
		<cfargument name="km_veiculo" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select (#arguments.km_veiculo# - (rf.revisao_km + vc.km_revisao - to_number(kss.pkg_global.fnc_parametro_num(11,'OPERACIONAL',18,4)))) as km_limite
              from oper.v$rank_frota rf
		     inner join oper.v$veiculo_controle vc
                on vc.placa = rf.placa_controle
             where 1 = 1
			<cfif Len(Trim(arguments.placa))>
               and rf.placa_controle = '#arguments.placa#'
            </cfif>
            <cfif Len(Trim(arguments.equipamento_id))>
               and rf.placa_controle = (select e.placa
                                          from almoxarifado.v$equipamento e
                                         where e.equipamento_id = #arguments.equipamento_id#)
            </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tipos de Solicitao
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 15/12/2009
	--->
	<cffunction name="get_solic_equip_tipo" returntype="query" access="remote">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="controle_trafego" required="no" default="">
        <cfargument name="bloqueia_veiculo" required="no" default="">
        <cfargument name="tipo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select est.tipo_id
                 , est.descricao
                 , est.dados_adicionais
                 , est.nivel_importancia
                 , est.controle_trafego
                 , decode(est.controle_trafego, 0,'No','Sim') as controle_trafego_descricao
                 , est.bloqueia_veiculo
                 , decode(est.bloqueia_veiculo, 0,'No','Sim') as bloqueia_veiculo_descricao
                 , est.lista_email
              from manutencao.v$equipamento_solicitacao_tipo est
             where 1 = 1
        	<cfif Len(Trim(arguments.descricao))>
              and upper(est.descricao) like upper('%#arguments.descricao#%')
        	</cfif>
            <cfif Len(Trim(arguments.controle_trafego))>
              and est.controle_trafego = #arguments.controle_trafego#
        	</cfif>
            <cfif Len(Trim(arguments.bloqueia_veiculo))>
              and est.bloqueia_veiculo = #arguments.bloqueia_veiculo#
        	</cfif>
            <cfif Len(Trim(arguments.tipo_id))>
              and est.tipo_id = #arguments.tipo_id#
        	</cfif>
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tipos de Solicitao
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 15/12/2009
	--->
	<cffunction name="get_solicitacao_equip_tipo" returntype="query" access="remote">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="controle_trafego" required="no" default="">
        <cfargument name="bloqueia_veiculo" required="no" default="">
        <cfargument name="tipo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select est.tipo_id
                 , est.descricao
                 , est.dados_adicionais
                 , est.nivel_importancia
                 , est.controle_trafego
                 , decode(est.controle_trafego, 0,'No','Sim') as controle_trafego_descricao
                 , est.bloqueia_veiculo
                 , decode(est.bloqueia_veiculo, 0,'No','Sim') as bloqueia_veiculo_descricao
                 , est.lista_email
                 , atv.controle_id
                 , atv.atividade_id
                 , a.titulo
              from manutencao.v$equipamento_solicitacao_tipo est
             left join manutencao.v$equipamento_solicitacao_atv atv
               on atv.tipo_id = est.tipo_id
             left join manutencao.v$atividade a
               on a.atividade_id = atv.atividade_id
             where 1 = 1
        	<cfif Len(Trim(arguments.descricao))>
              and upper(est.descricao) like upper('%#arguments.descricao#%')
        	</cfif>
            <cfif Len(Trim(arguments.controle_trafego))>
              and est.controle_trafego = #arguments.controle_trafego#
        	</cfif>
            <cfif Len(Trim(arguments.bloqueia_veiculo))>
              and est.bloqueia_veiculo = #arguments.bloqueia_veiculo#
        	</cfif>
            <cfif Len(Trim(arguments.tipo_id))>
              and est.tipo_id = #arguments.tipo_id#
        	</cfif>
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os proprietarios dos equipamentos
	-- NOTAS EXPLICATIVAS
	-- WAGNER 29/12/2006
	--->
	<cffunction name="get_proprietario_equipamento" returntype="query" access="remote">
		<cfargument name="EQUIPAMENTO_ID" required="yes">
		<cfargument name="DATA" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select t.cod_pessoa_proprietario, p.cliente as nome
               from almoxarifado.v$equipamento_proprietario t
              inner join kss.v$pessoa p
                      on p.cod_pessoa = t.cod_pessoa_proprietario
     	      where t.equipamento_id = #arguments.equipamento_id#
			    <cfif Len(Trim(arguments.DATA))>
				   and '#arguments.DATA#' between t.data_inicio and nvl(t.date_fim, '#arguments.DATA#')
				<cfelse>
				   and t.date_fim is null
				</cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO

	-- Busca km atual do Veculo
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_km_atual" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
        <cfargument name="data" required="no" default="">
        <cfif Len(Trim(arguments.data))>
        	<cfset v_data = "to_date('#arguments.data#', 'dd/mm/yyyy hh24:mi')">
        <cfelse>
        	<cfset v_data = "sysdate">
        </cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select manutencao.to_veiculo_km(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'), #PreserveSingleQuotes(v_data)#, #PreserveSingleQuotes(v_data)#).km_data_inicial as km_atual,
			       manutencao.to_equipamento_dados(oper.pkg_veiculo.fnc_get_placa('#arguments.placa#'), #PreserveSingleQuotes(v_data)#).equipamento_id as equipamento_id
			  from dual
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Busca as ordens de servi�os de um equipamento
    -- ANDERSON 11/09/2009 - CRIADO
    --->
    <cffunction name="get_os_equipamento" access="remote" returntype="query" output="true">
    	<cfargument name="equipamento_id" required="yes">
        <cfargument name="ordem_servico_id" required="no" default="" hint="Busca as ordens de servi�o exceto esta">
        <cfargument name="num_ordem_servico" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select os.ordem_servico_id
                 , os.num_ordem_servico
                 , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data_abertura
              from manutencao.v$ordem_servico os
             where os.equipamento_id = #arguments.equipamento_id#
			<cfif Len(Trim(arguments.ordem_servico_id))>
               and os.ordem_servico_id <> #arguments.ordem_servico_id#
            </cfif>
            <cfif Len(Trim(arguments.num_ordem_servico))>
               and os.num_ordem_servico like '#arguments.num_ordem_servico#%'
            </cfif>
             order by os.num_ordem_servico asc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca as ordens de servi�o
	-- ANDERSON 30/11/2009 - CRIADO
	--->
	<cffunction name="get_ordens_servico" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
        <cfargument name="placa_equipamento" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_pessoa_oficina" required="no" default="">
		<cfargument name="abertas" required="no" default="1">
		<cfargument name="check_list" required="no" default="0">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="num_ordem_servico" required="no" default="">
		<cfargument name="status" required="no" default="">
		<cfargument name="socorro" required="no" default="0">
        <cfargument name="tipo_ordem_servico_id" required="no" default="">
        <cfargument name="ordem_servico_id_lista" required="no" default="">
        <cfargument name="ordem" required="no" default="">
        <cfargument name="v_composicao" required="no" default="">
        <cfargument name="individual" required="no" default="0">
        <cfargument name="preventiva" required="no" default="">
        <cfargument name="externas" required="no" default="">
        <cfargument name="cavalo" required="no" default="">
		<cfargument name="cod_centro_custo" required="no" default="">
        <cfif arguments.individual eq 0>
			<cfif Len(Trim(arguments.placa))>
                <cfset v_composicao = this.get_composicao(placa = arguments.placa)>
            </cfif>
            <cfif Len(Trim(arguments.equipamento_id))>
                <cfset v_composicao = this.get_composicao(equipamento_id = arguments.equipamento_id)>
            </cfif>
        </cfif>

        <cfif (!Len(Trim(v_composicao)) and ( Len(Trim(arguments.placa)) or  Len(Trim(arguments.equipamento_id)))) and arguments.individual eq 0>
            <cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select 'Veculo No encontrado.' as erro from dual
            </cfquery>
            <cfreturn qr_result>
        <cfelse>
            <cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select /*+ ORDERED*/ os.ordem_servico_id
                     , os.num_ordem_servico
                     , os.obs_os_atividade
                     , os.empresa
                     , decode(os.empresa, 1, 'Sim', 'No') as empresa_descricao
                     , decode(os.empresa, 1, 'Interna', 'Externa') as os_tipo
                     , decode(os.empresa, 1, 0, 1) as externa
                     , (select kss.pkg_organograma.fnc_centro_custo((select max(vcc2.cod_centro_custo) keep(dense_rank last order by vcc2.data)
																	   from oper.v$veiculo_ccusto vcc2
																	  where vcc2.placa = e.placa
																	    and vcc2.data <= os.data_abertura))
					      from dual) as centro_custo
                     , os.equipamento_id
                     , e.material_id
                     , e.cod_equipamento
                     , e.placa
                     , oper.pkg_veiculo.fnc_get_cod_veiculo(e.placa) as cod_veiculo
                     , almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ') as material
                     , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data_abertura
                     , to_char(os.cod_pessoa_responsavel) as cod_pessoa_responsavel
                     , oper.pkg_global.fnc_get_cod_funcionario(os.cod_pessoa_responsavel) as cod_funcionario
                     , oper.pkg_global.fnc_busca_nome_pessoa(os.cod_pessoa_responsavel) as responsavel
                     , os.cod_pessoa_oficina
                     , p.cnpj_cpf as cnpj_oficina
                     , p.identificador as identificador_oficina
                     , p.razao_social as razao_social_oficina
                     , p.cliente as oficina
                     , oper.pkg_global.fnc_busca_nome_pessoa((select oc.cod_pessoa_autorizacao
                                                                from manutencao.v$ordem_compra oc
                                                               inner join manutencao.v$os_ordem_compra osc
                                                                  on osc.num_controle = oc.num_controle
                                                                where osc.ordem_servico_id = os.ordem_servico_id)) as analista_responsavel
                     , os.km_rodado
                     , os.observacao
                     , os.tipo_manutencao_id
                     , to_char(os.data_previsao_liberacao, 'dd/mm/yyyy hh24:mi') as data_previsao_liberacao
                     , case
                          when to_number((nvl(os.data_fechamento, sysdate) - os.data_abertura)) > 100 then
                             'Mais de 100 dias'
                          else
                             to_char(manutencao.to_tempo_execucao(numtodsinterval(to_number((nvl(os.data_fechamento, sysdate) - os.data_abertura)), 'DAY'), 2).retorno)
                       end as tempo_aberto
                     , case
                          when os.data_fechamento is null then
                             almoxarifado.to_ponto(e.cod_equipamento, sysdate).landmark
                          when os.data_fechamento is not null then
                             'OS Finalizada'
                       end posicao_atual
                     , to_char(os.data_saida, 'dd/mm/yyyy hh24:mi') as data_saida
                     , to_char(os.data_chegada, 'dd/mm/yyyy hh24:mi') as data_chegada
                     , to_char(os.data_atendimento, 'dd/mm/yyyy hh24:mi') as data_atendimento
                     , to_char(os.data_fechamento, 'dd/mm/yyyy hh24:mi') as data_fechamento
                     , os.log_alteracoes
                     , (select cg.organizacional_id
                          from oper.v$veiculo_ccusto_gerencial cg
                         where cg.placa = e.placa
                           and cg.data_cancelamento is null) as organizacional_id
				         , kss.pkg_organizacional.fnc_cod_organizacional(oper.pkg_veiculo.fnc_veiculo_ccusto_gerencial(e.placa)) as cod_organizacional
                     , (select oser.valor_servico
                          from manutencao.v$ordem_servico oser
                         where oser.ordem_servico_id = os.ordem_servico_id) as valor_servico
                     , os.socorro
                     , nft.num_nota_fiscal
                     , o.ordem_servico_id_vinculo
                     , (select oser.num_ordem_servico
                          from manutencao.v$ordem_servico oser
                         where oser.ordem_servico_id = o.ordem_servico_id_vinculo) as num_ordem_servico_vinculo
                     , (select to_char(oser.data_abertura, 'dd/mm/yyyy hh24:mi')
                          from manutencao.v$ordem_servico oser
                         where oser.ordem_servico_id = o.ordem_servico_id_vinculo) as data_abertura_os_vinculo
                     , os.tipo_ordem_servico_id
                     , (select tos.descricao
                          from manutencao.v$tipo_ordem_servico tos
                         where tos.tipo_ordem_servico_id = os.tipo_ordem_servico_id) as tipo_ordem_servico
                     /*, os.km_abertura */
                     , (select oser.valor_servico_fechamento + oser.valor_materiais_fechamento
                          from manutencao.v$ordem_servico oser
                         where oser.ordem_servico_id = os.ordem_servico_id) as valor_total_os
                     , coalesce(
                          (select ccl.valor_lancamento
                              from manutencao.v$ordem_servico oser
                        inner join finan.v$ccorrente_lancamento ccl
                                on ccl.num_lancamento = oser.num_lancamento
                            where oser.ordem_servico_id = os.ordem_servico_id)
                        , (select lc.valor
                             from oper.v$lancamento_documento ld
                            inner join oper.v$lancamento_ccorrente lc
                               on lc.num_lancamento = ld.num_lancamento
                            where ld.docto_id = os.ordem_servico_id
                              and ld.cod_origem = 'OS INTERNA'
                              and lc.num_lancamento_contrapartida is null)    
                        , 0
                                ) as valor_lancto
                     , os.km_abertura
                     , (select s.num_controle
                          from compras.v$solicitacao s
                         where s.solicitacao_id = os.solicitacao_compra_id
                           and s.situacao_id not in (0,11)) as solicitacao_compra
                     , decOde((select sign(count(1))
                                 from manutencao.v$tabela_manutencao tm
                                where tm.atualiza_revisao = 1
                                  and tm.tabela_id in (select otm.tabela_id
                                                         from manutencao.v$os_tabela_manutencao otm
                                                        where otm.ordem_servico_id = os.ordem_servico_id )) , 1, 'Sim', 'No') as atualiza_revisao
                     , substr(oper.pkg_veiculo.fnc_get_composicao( e.placa , os.data_abertura), 2,7) as placa_cavalo
					 , os.num_ordem_compra
					 , (select count(1)
                          from manutencao.v$os_atividade osa
                         where osa.ordem_servico_id = os.ordem_servico_id) as qtd_atividade
          , o.codigo_barras
                  from manutencao.v$ordem_servico_dados os
				 inner join manutencao.v$ordem_servico o
				    on o.ordem_servico_id = os.ordem_servico_id
                 inner join kss.v$pessoa p
                         on p.cod_pessoa = os.cod_pessoa_oficina
                 inner join almoxarifado.v$equipamento e
                         on e.equipamento_id = os.equipamento_id
                  left join fiscal.v$nf_terceiro nft
                         on nft.num_nota_id = os.num_nota_id
                 where 1 = 1
				<cfif Len(Trim(arguments.cod_centro_custo))>
				   and o.cod_centro_custo = #arguments.cod_centro_custo#
				</cfif>
                 <cfif Len(Trim(arguments.cavalo))>
                   and  oper.pkg_veiculo.fnc_veiculo_tracao(e.placa) = #arguments.cavalo#
                 </cfif>
                <cfif Len(Trim(arguments.externas))>
                   <cfif arguments.externas eq 1>
                      and os.empresa = 0
				   <cfelseif arguments.externas eq 0>
                      and os.empresa = 1
                   </cfif>
                <cfelseif Len(Trim(arguments.empresa)) and arguments.empresa neq 2>
                   and os.empresa = #arguments.empresa#
                </cfif>

                <cfif Len(Trim(arguments.placa_equipamento))>
                   and (e.cod_equipamento = '#arguments.placa_equipamento#'
                    	or e.placa = '#arguments.placa_equipamento#')
                </cfif>
                <cfif Len(Trim(arguments.cod_equipamento))>
                   and e.cod_equipamento = '#arguments.cod_equipamento#'
                </cfif>
                <cfif Len(Trim(arguments.ordem_servico_id))>
                   and os.ordem_servico_id in (#arguments.ordem_servico_id#)
                </cfif>
                <cfif Len(Trim(arguments.ordem_servico_id_lista))>
                   and os.ordem_servico_id in (#arguments.ordem_servico_id_lista#)
                </cfif>
                <cfif arguments.socorro neq -1>
                   and os.socorro = #arguments.socorro#
                </cfif>
                <cfif arguments.abertas eq 1>
                   and os.data_fechamento is null
                </cfif>
                <cfif arguments.check_list eq 1>
                   and exists (select 'x'
                                 from manutencao.v$os_atividade oa
                                inner join manutencao.v$atividade a
                                        on a.atividade_id = oa.atividade_id
                                where oa.ordem_servico_id = os.ordem_servico_id
                                  and a.verificacao = 1
                                  and oa.executada = 0)
                </cfif>
                <cfif Len(Trim(arguments.cod_pessoa_oficina))>
                   and os.cod_pessoa_oficina = #arguments.cod_pessoa_oficina#
                </cfif>
                <cfif Len(Trim(arguments.num_ordem_servico))>
                   and os.num_ordem_servico = #arguments.num_ordem_servico#
                </cfif>
                <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final)) >
                   and os.data_abertura between '#LSDateFormat(arguments.data_inicial)#' and '#LSDateFormat(arguments.data_final)# 23:59:59'
                </cfif>
                <cfif Len(Trim(arguments.data_inicial)) and (Len(Trim(arguments.data_final)) eq 0) >
                   and os.data_abertura >= '#LSDateFormat(arguments.data_inicial)#'
                </cfif>
                <cfif Len(Trim(arguments.data_final)) and (Len(Trim(arguments.data_inicial)) eq 0) >
                   and os.data_abertura <= '#LSDateFormat(arguments.data_final)#'
                </cfif>
                <cfif Len(Trim(arguments.status)) and arguments.status eq 0>
                   and os.data_fechamento is null
                </cfif>
                <cfif Len(Trim(arguments.status)) and arguments.status eq 1>
                   and os.data_fechamento is not null
                </cfif>
                <cfif Len(Trim(arguments.tipo_ordem_servico_id))>
                   and os.tipo_ordem_servico_id = #arguments.tipo_ordem_servico_id#
                </cfif>
                <cfif arguments.preventiva eq 1>
                   and exists (select 1
                                  from manutencao.v$tabela_manutencao tm
                                 where tm.tabela_id in (select otm.tabela_id
                                                          from manutencao.v$os_tabela_manutencao otm
                                                         where otm.ordem_servico_id = os.ordem_servico_id))
                </cfif>
                <cfif arguments.preventiva eq 0>
                   and not exists (select 1
                                     from manutencao.v$tabela_manutencao tm
                                    where tm.tabela_id in (select otm.tabela_id
                                                             from manutencao.v$os_tabela_manutencao otm
                                                            where otm.ordem_servico_id = os.ordem_servico_id))
                </cfif>
                <cfif arguments.individual eq 1 and Len(Trim(arguments.placa))>
                   and os.equipamento_id = #arguments.equipamento_id#
                <cfelse>
                	<cfif Len(Trim(arguments.equipamento_id)) or Len(Trim(arguments.placa))>
                       and os.equipamento_id in (#v_composicao#)
                    </cfif>
                </cfif>
				<cfif len(trim(arguments.ordem))>
                    order by #arguments.ordem#
                <cfelse>
                 order by os.cod_pessoa_responsavel, os.tipo_ordem_servico_id, os.cod_pessoa_oficina, os.data_abertura desc
                </cfif>
            </cfquery>
            <cfreturn qr_result>
        </cfif>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca as ordens de servi�o externas em aberto
	-- ANDERSON 30/11/2009 - CRIADO
	--->
	<cffunction name="get_ordens_servico_ex" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
        <cfargument name="placa_equipamento" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_pessoa_oficina" required="no" default="">
		<cfargument name="abertas" required="no" default="1">
		<cfargument name="check_list" required="no" default="0">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="num_ordem_servico" required="no" default="">
		<cfargument name="status" required="no" default="">
		<cfargument name="socorro" required="no" default="0">
        <cfargument name="tipo_ordem_servico_id" required="no" default="">
        <cfargument name="ordem_servico_id_lista" required="no" default="">
        <cfargument name="ordem" required="no" default="">
        <cfargument name="v_composicao" required="no" default="">
        <cfargument name="individual" required="no" default="0">
        <cfargument name="preventiva" required="no" default="">
        <cfargument name="externas" required="no" default="">
        <cfargument name="cavalo" required="no" default="">
        <cfif arguments.individual eq 0>
			<cfif Len(Trim(arguments.placa))>
                <cfset v_composicao = this.get_composicao(placa = arguments.placa)>
            </cfif>
            <cfif Len(Trim(arguments.equipamento_id))>
                <cfset v_composicao = this.get_composicao(equipamento_id = arguments.equipamento_id)>
            </cfif>
        </cfif>

        <cfif (!Len(Trim(v_composicao)) and ( Len(Trim(arguments.placa)) or  Len(Trim(arguments.equipamento_id)))) and arguments.individual eq 0>
            <cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select 'Veculo No encontrado.' as erro from dual
            </cfquery>
            <cfreturn qr_result>
        <cfelse>
            <cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select os.ordem_servico_id
                     , os.num_ordem_servico
                     , e.cod_equipamento
                     , e.placa
                     , oper.pkg_veiculo.fnc_get_cod_veiculo(e.placa) as cod_veiculo
                     , almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id,' ') as material
                     , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data_abertura
                     , to_char(os.cod_pessoa_oficina) as cod_pessoa_oficina
                     , p.identificador as identificador_oficina
                     , p.razao_social  as razao_social_oficina
                     , p.cliente       as oficina
                     , os.tipo_ordem_servico_id
                     , (select to_char(max(opl.data_previsao), 'dd/mm/yyyy hh24:mi')
                          from manutencao.v$os_previsao_liberacao opl
                         where opl.ordem_servico_id = os.ordem_servico_id) as data_previsao_liberacao
                     , to_char(os.data_atendimento, 'dd/mm/yyyy hh24:mi')  as data_atendimento
                     , (select s.num_controle
                          from compras.v$solicitacao s
                         where s.solicitacao_id = os.solicitacao_compra_id) as num_ordem_compra
                    , os.codigo_barras
                  from manutencao.v$ordem_servico os
                 inner join kss.v$pessoa p
                    on p.cod_pessoa = os.cod_pessoa_oficina
                 inner join almoxarifado.v$equipamento e
                    on e.equipamento_id = os.equipamento_id
                 where 1 = 1
				<cfif arguments.individual eq 1 and Len(Trim(arguments.placa))>
                   and os.equipamento_id = #arguments.equipamento_id#
                <cfelse>
                	<cfif Len(Trim(arguments.equipamento_id)) or Len(Trim(arguments.placa))>
                       and os.equipamento_id in (#v_composicao#)
                    </cfif>
                </cfif>
				<cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final)) >
                   and os.data_abertura between '#LSDateFormat(arguments.data_inicial)#' and '#LSDateFormat(arguments.data_final)# 23:59:59'
                </cfif>
                <cfif Len(Trim(arguments.data_inicial)) and (Len(Trim(arguments.data_final)) eq 0) >
                   and os.data_abertura >= '#LSDateFormat(arguments.data_inicial)#'
                </cfif>
                <cfif Len(Trim(arguments.data_final)) and (Len(Trim(arguments.data_inicial)) eq 0) >
                   and os.data_abertura <= '#LSDateFormat(arguments.data_final)#'
                </cfif>
                <cfif Len(Trim(arguments.externas))>
                   <cfif arguments.externas eq 1>
                      and os.empresa = 0
				   <cfelseif arguments.externas eq 0>
                      and os.empresa = 1
                   </cfif>
                <cfelseif Len(Trim(arguments.empresa)) and arguments.empresa neq 2>
                   and os.empresa = #arguments.empresa#
                </cfif>
                <cfif arguments.abertas eq 1>
                   and os.data_fechamento is null
                </cfif>
				<cfif len(trim(arguments.ordem))>
                    order by #arguments.ordem#
                <cfelse>
                 order by os.cod_pessoa_responsavel, os.tipo_ordem_servico_id, os.cod_pessoa_oficina, os.data_abertura desc
                </cfif>
            </cfquery>
            <cfreturn qr_result>
        </cfif>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca composicao
	-- NOTAS EXPLICATIVAS
	-- GUTO 04/10/2006
	--->
	<cffunction name="get_composicao" returntype="string" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select
			      <cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
				   manutencao.to_equipamento_dados(#arguments.EQUIPAMENTO_ID#,sysdate).composicao as composicao
				   <cfelseif Len(Trim(arguments.PLACA))>
				   manutencao.to_equipamento_dados('#arguments.PLACA#',sysdate).composicao as composicao
				   </cfif>
			  from dual
		</cfquery>
		<cfreturn qr_result.composicao>
	</cffunction>


    <!---                                                                                              REMOVER
	-- PROPSITO
	-- Busca atividades da ordem de compra
	-- NOTAS EXPLICATIVAS
	-- GUTO 01/02/2007
	--->
	<cffunction name="get_ordem_compra_atividade" returntype="query" access="remote">
		<cfargument name="NUM_ORDEM_COMPRA" required="no" default="" >
		<cfargument name="NF_TERCEIRO_ID" required="no" default="" >
		<cfargument name="EQUIPAMENTO_ID" required="no" default="" >
		<cfargument name="COD_EQUIPAMENTO" required="no" default="" >
		<cfargument name="ABERTAS" required="no" default="0" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select ea.controle_id, ea.equipamento_id, ea.atividade_id, ag.descricao as grupo,
                   ea.posicao_id, ea.num_ordem_compra, ea.ordem_servico_id_execucao,
                   e.cod_equipamento, a.titulo, ep.posicao,
                   oc.data_emissao, to_char(oc.cod_pessoa_autorizacao) as cod_pessoa_autorizacao, p.cliente as responsavel,
                   fr.identificador as cnpj_fornecedor,
                   oc.num_controle, fr.cliente as fornecedor, a.cod_atividade,
                   nvl((select sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_servicos,0)) + sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_material,0))
                          from manutencao.v$os_ordem_compra ooc
                         where ooc.num_controle = oc.num_controle),0) as total_utilizado_os
                from manutencao.v$equipamento_atividade_oc ea
               inner join manutencao.v$ordem_compra oc
                   on oc.num_controle = ea.num_ordem_compra
               inner join kss.v$pessoa p
                   on p.cod_pessoa = oc.cod_pessoa_autorizacao
               inner join kss.v$pessoa fr
                   on fr.cod_pessoa = oc.cod_pessoa_fornecedor
               inner join almoxarifado.v$equipamento e
                   on e.equipamento_id = ea.equipamento_id
               inner join manutencao.v$atividade a
                      on a.atividade_id = ea.atividade_id
               inner join manutencao.v$atividade_grupo ag
                       on ag.grupo_id = a.grupo_id
                left join manutencao.v$equipamento_posicao ep
                   on ep.posicao_id = ea.posicao_id
			  where 1=1
				<cfif len(Trim(arguments.COD_EQUIPAMENTO))>
				  and e.COD_EQUIPAMENTO = '#arguments.COD_EQUIPAMENTO#'
				</cfif>
				<cfif len(Trim(arguments.EQUIPAMENTO_ID))>
				  and ea.equipamento_id = #arguments.EQUIPAMENTO_ID#
				</cfif>
				<cfif len(Trim(arguments.NUM_ORDEM_COMPRA))>
				  and ea.num_ordem_compra = #arguments.NUM_ORDEM_COMPRA#
				</cfif>
				<cfif arguments.ABERTAS eq 1>
				  and ea.ordem_servico_id_execucao is null
				</cfif>
                order by grupo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    <!---                                                                                              REMOVER                                                                             	--->

    <!---
	-- PROPSITO
	-- Busca todos os processos da OS
	-- NOTAS EXPLICATIVAS
	-- arlen 16/10/2006
	--->
	<cffunction name="get_os_processos_atividades" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="placa" required="no" default="">
		<cfif Len(Trim(arguments.placa))>
			<cfset v_composicao = this.get_composicao(placa = arguments.placa)>
		</cfif>
		<cfif Len(Trim(arguments.equipamento_id))>
			<cfset v_composicao = this.get_composicao(equipamento_id = arguments.equipamento_id)>
		</cfif>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			    select tipo
                     , ordem_servico_id
                     , equipamento_id
                     , cod_equipamento
                     , num_ordem_servico
                     , grupo_id
                     , grupo
                     , compartimento_id
                     , compartimento
                     , posicao_id
                     , nvl(posicao, 'nica') as posicao
                     , atividade
                     , nvl(processo,atividade) as processo
                     , controle_id_processo
                     , controle_id_atividade
                     , executada
                     , execucao_id
                     , cod_pessoa_principal
                     , oper.pkg_global.fnc_busca_nome_pessoa(cod_pessoa_principal) as principal
                     , cod_pessoa_auxiliar
                     , oper.pkg_global.fnc_busca_nome_pessoa(cod_pessoa_auxiliar) as auxiliar
                     , to_char(data_inicio, 'dd/mm HH24:mi') as data_inicio
                     , to_char(data_termino, 'dd/mm HH24:mi') as data_termino
                     , tempo_estimado
                     , tempo_execucao
                     , nivel
					 , observacao
                from (select 2 as tipo
                           , os.ordem_servico_id
                           , e.equipamento_id
                           , e.cod_equipamento
                           , os.num_ordem_servico
                           , a.grupo_id
                           , ag.descricao as grupo
                           , a.compartimento_id
                           , ac.descricao as compartimento
                           , ep.posicao_id
                           , ep.posicao
                           , manutencao.to_tempo_execucao(p.tempo_execucao).retorno as tempo_estimado
                           , a.titulo as atividade
                           , p.titulo as processo
                           , op.controle_id as controle_id_processo
                           , oa.controle_id as controle_id_atividade
                           , opa.executado as executada
                           , ope.execucao_id
                           , case
                                when ope.execucao_id_origem is null then ope.cod_pessoa_principal
                                else null
                             end as cod_pessoa_principal
                           , case
                                when ope.execucao_id_origem is null then ope.cod_pessoa_auxiliar
                                else ope.cod_pessoa_principal 
                             end cod_pessoa_auxiliar
                           , ope.data_inicio
                           , ope.data_termino
						         , ope.observacao 
                           , manutencao.to_tempo_execucao(numtodsInterval(nvl(ope.data_termino,sysdate) - ope.data_inicio,'DAY')).retorno as tempo_execucao
                           , (select rn.descricao
                                from manutencao.v$recurso_nivel rn
                               where rn.nivel_id = pr.nivel_id) as nivel
                        from manutencao.v$ordem_servico os
                       inner join almoxarifado.v$equipamento e
                          on e.equipamento_id = os.equipamento_id
                       inner join manutencao.v$os_atividade oa
                          on oa.ordem_servico_id = os.ordem_servico_id
                       inner join manutencao.v$atividade a
                          on a.atividade_id = oa.atividade_id
                        left join manutencao.v$atividade_compartimento ac
                          on ac.compartimento_id = a.compartimento_id
                        left join manutencao.v$atividade_grupo ag
                          on ag.grupo_id = a.grupo_id
                       inner join manutencao.v$os_processo_atividade opa
                          on opa.controle_id_atividade = oa.controle_id
                       inner join manutencao.v$os_processos op
                          on op.controle_id = opa.controle_id_processo
						       and op.ordem_servico_id = os.ordem_servico_id
                       inner join manutencao.v$processo p
                          on p.processo_id = op.processo_id
                       inner join manutencao.v$processo_recurso pr
                          on pr.processo_id = op.PROCESSO_ID
                         and op.PROCESSO_RECURSO_ID = pr.ITEM_ID
                        left join manutencao.v$os_processo_execucao ope
                          on ope.controle_id = op.controle_id
                        left join manutencao.v$equipamento_posicao ep
                          on ep.posicao_id = oa.posicao_id
                       where os.data_fechamento is null)
			   where 1=1
			<cfif Len(Trim(arguments.ordem_servico_id))>
				 and ordem_servico_id = #arguments.ordem_servico_id#
			</cfif>
			<cfif IsDefined("v_composicao")>
				 and equipamento_id in (#v_composicao#)
			</cfif>
		    order by ordem_servico_id, compartimento, grupo, posicao, controle_id_processo, nivel, data_inicio
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca processos da OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_processos" returntype="query" access="remote">
		<cfargument name="controle_id" required="no" default="">
		<cfargument name="execucao_id" required="no" default="">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select os.ordem_servico_id
                     , oa.controle_id as controle_id_atividade
                     , oa.atividade_id
                     , a.titulo as atividade
                     , nvl(p.titulo,a.titulo) as processo
                     , opa.CONTROLE_ID_PROCESSO
                     , case
                          when oa.gerada_por = 1 then 'Sistema'
                          when oa.gerada_por = 2 then 'Solicitao Mot.'
                          else 'Check List' end gerada_por, oa.executada
                     , manutencao.to_tempo_execucao(nvl(oa.tempo_execucao_oficina,numtodsinterval(0,'DAY'))).retorno as tempo_execucao
                     , oa.date_insert
                     , p.processo_id
                     , to_char(nvl(ope.data_inicio,sysdate), 'dd/mm/yyyy HH24:mi') as date_inicio
                     , nvl(ep.posicao,'nica') as posicao
                     , ope.execucao_id
                     , to_char(ope.cod_pessoa_principal) as cod_pessoa_principal
                     , oper.pkg_global.fnc_busca_nome_pessoa(ope.cod_pessoa_principal) as principal
                     , ope.cod_pessoa_auxiliar
                     , oper.pkg_global.fnc_busca_nome_pessoa(ope.cod_pessoa_auxiliar) as auxiliar
                     , to_char( nvl(ope.data_inicio, sysdate) , 'dd/mm/yyyy hh24:MM') as data_formatada
				  from manutencao.v$ordem_servico os
				 inner join manutencao.v$os_atividade oa
				    on oa.ordem_servico_id = os.ordem_servico_id
				 inner join manutencao.v$atividade a
					on a.atividade_id = oa.atividade_id
				 inner join manutencao.v$os_processo_atividade opa
					on opa.controle_id_atividade = oa.controle_id
				 inner join manutencao.v$os_processos op
					on op.controle_id = opa.controle_id_processo
				 inner join manutencao.v$processo p
					on p.processo_id = op.processo_id
				  left join manutencao.v$equipamento_posicao ep
					on ep.posicao_id = oa.posicao_id
				  left join manutencao.v$os_processo_execucao ope
					on ope.controle_id = op.controle_id
				 where 1=1
				<cfif Len(Trim(arguments.ordem_servico_id))>
				   and os.ordem_servico_id in (#arguments.ordem_servico_id#)
				</cfif>
				<cfif Len(Trim(arguments.controle_id))>

				   and op.controle_id = #arguments.controle_id#
				   and (ope.execucao_id = (select max(ope2.execucao_id)
					                          from manutencao.v$os_processo_execucao ope2
											 where ope2.controle_id = op.controle_id)
										or (select max(ope2.execucao_id)
					                          from manutencao.v$os_processo_execucao ope2
											where ope2.controle_id = op.controle_id) is null)
				</cfif>
				<cfif Len(Trim(arguments.execucao_id))>
					and ope.execucao_id = #arguments.execucao_id#
				</cfif>
			order by oa.date_insert, op.date_insert
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca materiais usados na OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_materiais" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select os.ordem_servico_id
                 , om.controle_id
                 , om.material_id
                 , to_char(om.cod_pessoa_retirada) as cod_pessoa_retirada
                 , p.cliente as responsavel
                 , m.material
                 , e.cod_equipamento
                 , nvl(ep.posicao,'nica') as posicao
                 , nvl(om.posicao_id, '-1') as posicao_id
                 , er.cod_equipamento as cod_equipamento_retirado
                 , om.quantidade
                 , manutencao.to_os_material(om.controle_id).atividade_ok as atividade_ok
                 , m.unidade_estoque
                 , om.valor_unitario
                 , mr.descricao_completa as material_retirado
                 , om.observacao
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(om.material_id, 9) as cod_genuino
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(om.material_id, 10) as cod_fabricante
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(om.material_id, 11) as cod_paralelo
                 , m.identificado
                 , om.valor_total
                 , m.cod_material
                 , om.lancamento_id_saida
			  from manutencao.v$ordem_servico os
			 inner join manutencao.v$os_material om
			    on om.ordem_servico_id = os.ordem_servico_id
			 inner join almoxarifado.v$material_dados m
				on m.material_id = om.material_id
			 inner join almoxarifado.v$material_dados mr
				on mr.material_id = om.material_id_retirado
		      left join kss.v$pessoa p
			    on p.cod_pessoa = om.cod_pessoa_retirada
              left join almoxarifado.v$equipamento e
				on e.equipamento_id = om.equipamento_id
			  left join manutencao.v$equipamento_posicao ep
				on ep.posicao_id = om.posicao_id
			  left join almoxarifado.v$equipamento er
				on er.equipamento_id = om.equipamento_id_retirado
			 where 1=1
			   and os.ordem_servico_id in (#arguments.ordem_servico_id#)
		  order by om.date_insert
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamento montado
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2006
	--->
	<cffunction name="get_equipamento_montado" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="yes">
		<cfargument name="material_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.equipamento_id
                 , e.cod_equipamento
                 , e.material_id
                 , md.material
              from almoxarifado.v$equipamento  e
			 inner join manutencao.v$equipamento_material em
				on em.equipamento_id_identificado = e.equipamento_id
			   and em.ordem_servico_id_desmontagem is null
		     inner join almoxarifado.v$material_dados md
			    on md.material_id = e.material_id
			 where 1=1
			   and em.equipamento_id = #arguments.equipamento_id#
			<cfif Len(Trim(arguments.material_id))>
			   and e.material_id = #arguments.material_id#
			</cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamentos no estoque
	-- NOTAS EXPLICATIVAS
	-- GUTO 21/09/2006
	--->
	<cffunction name="get_equipamentos_estoque" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default=""/>
		<cfargument name="cod_pessoa_filial" required="no" default=""/>
		<cfargument name="transferencia" required="no" default="0"/>
		<cfargument name="cod_equipamento" required="no" default=""/>
      <cfargument name="cod_centro_custo" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select e.cod_equipamento
                 , e.equipamento_id
                 , max(el.data_entrada) data_entrada
                 , almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ') as material
			  from almoxarifado.v$equipamento e
			 inner join almoxarifado.v$equipamento_localizacao el
				on el.equipamento_id = e.equipamento_id
			 where el.data_saida is null
               and e.data_inativacao is null
             <cfif arguments.transferencia eq 0>
                and not exists (select 'x'
                                  from manutencao.v$equipamento_analise ea
                                 where ea.equipamento_id = e.equipamento_id
                                   and ea.data_analise is null)
             </cfif>
			 <cfif Len(Trim(arguments.cod_equipamento))>

			   and e.cod_equipamento = '#arguments.cod_equipamento#'
			 </cfif>
			 <cfif Len(Trim(arguments.material_id))>
			   and e.material_id = #arguments.material_id#
			 </cfif>
			 <cfif  Len(Trim(arguments.cod_pessoa_filial))>
             	and el.cod_pessoa_filial = #arguments.cod_pessoa_filial#
			 </cfif>
          <cfif  Len(Trim(arguments.cod_centro_custo))>
             	and el.cod_centro_custo = #arguments.cod_centro_custo#
			 </cfif>
			 group by e.cod_equipamento, e.equipamento_id,  almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(e.material_id, ' ')
		     order by e.cod_equipamento
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamento componente
	-- NOTAS EXPLICATIVAS
	-- GUTO 07/10/2006
	--->
	<cffunction name="get_material_componente" returntype="query" access="remote">
		<cfargument name="material_id" required="yes">
		<cfargument name="material_id_os" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select mc.material_id, almoxarifado.pkg_almoxarifado.FNC_GET_MATERIAL_DESCRICAO(mc.material_id,' ') as material
				  from (select t.material_id, material_pai, material
							  from almoxarifado.v$material_dados t
							 start with t.material_id = #arguments.material_id#
							connect by t.material_id = prior t.material_pai) a
				 inner join almoxarifado.v$material_componente mc
							on mc.material_id_componente = a.material_id
			 <cfif Len(Trim(arguments.material_id_os))>
			 where not exists (select t.material_id, material_pai, material
									   from almoxarifado.v$material_dados t
									  where t.material_id = mc.material_id
									  start with t.material_id = #arguments.material_id_os#
									 connect by t.material_id = prior t.material_pai)
			 and not exists (select t.material_id, material_pai, material
									   from almoxarifado.v$material_dados t
									  where t.material_id = #arguments.material_id_os#
									  start with t.material_id = mc.material_id
									 connect by t.material_id = prior t.material_pai)
			 </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca dados completos do material atraves do codigo
	-- NOTAS EXPLICATIVAS
	-- GUTO 20/09/2006
	--->
	<cffunction name="get_material_dados_por_codigo" returntype="query" access="remote">
      <cfargument name="material_id" required="no" default=""/>
      <cfargument name="cod_material" required="no" default=""/>
      <cfargument name="material" required="no" default=""/>
      <cfargument name="atributo" required="no" default=""/>
      <cfargument name="com_saldo_estoque" required="no" default="0"/>
      <cfargument name="cod_pessoa_filial" required="no" default=""/>
      <cfargument name="cod_centro_custo" required="no" default=""/>
      <cfargument name="estoque" required="no" default="1"/>
      <cfargument name="niv_arvore" required="no" default=""/>
      <cfargument name="ativo" required="no" default="1"/>
      <cfargument name="tabela_id" required="no" default=""/>
      <cfargument name="ordem_servico_id" required="no" default=""/>
      <cfargument name="data_base" required="no" default="#LSDateFormat(now())# #TimeFormat(now(),'HH:MM:SS')#">
      <cfargument name="busca_atividade" required="no" default=""/>
      <cfargument name="busca_material" required="no" default=""/>
      <cfargument name="arvore_galhos" required="no" default=""/>



		<cfif not Len(Trim(arguments.cod_pessoa_filial))>
         <cfset arguments.cod_pessoa_filial = session.cod_pessoa>
      </cfif>
		<cfif not Len(Trim(arguments.cod_centro_custo))>
         <cfset arguments.cod_centro_custo = session.cod_centro_custo>
      </cfif>
	  
	 <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
	    select material_id             
			, material_pai            
			, cod_material            
			, titulo                  
			, descricao               
			, compoe_descricao        
			, estoque                 
			, unidade_estoque         
			, unidade_comercializacao 
			, identificado            
			, cod_genuino             
			, cod_fabricante          
			, cod_paralelo            
			, valor_unitario          
			, material                
			, produto_id              
			, valor                   
			, saldo_estoque           
			, localizacao             
			, exige_devolucao         
			, qtde_maxima             
			, qtde_minima             
			, niv_arvore   
         , categoria     
         , grupo_id      
        from xmltable('/estoque_material/arrayItem' passing almoxarifado.pkg_almoxarifado_backend.fnc_material_saldo(
			
			xmltype('<params>' ||

			<cfif len(trim(arguments.material_id))>
			  '<material_id>#arguments.material_id#</material_id>' ||
			</cfif>

		  <cfif len(trim(arguments.cod_material))>
			  '<cod_material>#arguments.cod_material#</cod_material>'  ||
			</cfif>

      <cfif len(trim(arguments.material))>
			  '<material>#arguments.material#</material>'  ||
			</cfif>

			<cfif len(trim(arguments.atributo))>
			  '<atributo>#arguments.atributo#</atributo>'  ||
			</cfif>

      <cfif len(trim(arguments.com_saldo_estoque))>
			  '<com_saldo_estoque>#arguments.com_saldo_estoque#</com_saldo_estoque>' ||
			</cfif>

      <cfif len(trim(arguments.cod_pessoa_filial))>
			  '<cod_pessoa_filial>#arguments.cod_pessoa_filial#</cod_pessoa_filial>'  ||
			</cfif>

			<cfif len(trim(arguments.cod_centro_custo))>
			  '<cod_centro_custo>#arguments.cod_centro_custo#</cod_centro_custo>'  ||
			</cfif>

			<cfif len(trim(arguments.estoque))>
			  '<estoque>#arguments.estoque#</estoque>'  ||
			</cfif>

      <cfif len(trim(arguments.niv_arvore))>
			  '<niv_arvore>#arguments.niv_arvore#</niv_arvore>'  ||
			</cfif>

			<cfif len(trim(arguments.ativo))>
			  '<ativo>#arguments.ativo#</ativo>'  ||
			</cfif>

			<cfif len(trim(arguments.tabela_id))>
			  '<tabela_id>#arguments.tabela_id#</tabela_id>'  ||
			</cfif>

			<cfif len(trim(arguments.data_base))>
			  '<data_base>#arguments.data_base#</data_base>'  ||
			</cfif>

			<cfif len(trim(arguments.ordem_servico_id))>
			  '<ordem_servico_id>#arguments.ordem_servico_id#</ordem_servico_id>'  ||
			</cfif>

	      <cfif len(trim(arguments.busca_atividade))>
			  '<busca_atividade>#arguments.busca_atividade#</busca_atividade>' ||
			</cfif>
	      <cfif len(trim(arguments.busca_material))>
			  '<busca_material>#arguments.busca_material#</busca_material>' ||
			</cfif>
	      <cfif len(trim(arguments.arvore_galhos))>
			  '<arvore_galhos>#arguments.arvore_galhos#</arvore_galhos>' ||
			</cfif>

			'</params>')				
			) 
                columns    
                   material_id             integer        path '/arrayItem/material_id'
                 , material_pai            integer        path '/arrayItem/material_pai'
                 , cod_material            varchar2(30)   path '/arrayItem/cod_material'
                 , titulo                  varchar2(160)  path '/arrayItem/titulo'
                 , descricao               varchar2(160)  path '/arrayItem/descricao'
                 , compoe_descricao        integer        path '/arrayItem/compoe_descricao'
                 , estoque                 integer        path '/arrayItem/estoque'
                 , unidade_estoque         varchar2(10)   path '/arrayItem/unidade_estoque'
                 , unidade_comercializacao varchar2(10)   path '/arrayItem/unidade_comercializacao'
                 , identificado            integer        path '/arrayItem/identificado'
                 , cod_genuino             varchar2(4000) path '/arrayItem/cod_genuino'
                 , cod_fabricante          varchar2(4000) path '/arrayItem/cod_fabricante'
                 , cod_paralelo            varchar2(4000) path '/arrayItem/cod_paralelo'
                 , valor_unitario          varchar2(4000) path '/arrayItem/valor_unitario'
                 , material                varchar2(255)  path '/arrayItem/material'
                 , produto_id              integer        path '/arrayItem/produto_id'
                 , valor                   number         path '/arrayItem/valor'
                 , saldo_estoque           integer        path '/arrayItem/saldo_estoque'
                 , localizacao             varchar2(4000) path '/arrayItem/localizacao'
                 , exige_devolucao         varchar2(4000) path '/arrayItem/exige_devolucao'
                 , qtde_maxima             varchar2(4000) path '/arrayItem/qtde_maxima'
                 , qtde_minima             varchar2(4000) path '/arrayItem/qtde_minima'
                 , niv_arvore              integer        path '/arrayItem/niv_arvore'
                 , categoria               varchar2(4000) path '/arrayItem/categoria'
                 , grupo_id                integer        path '/arrayItem/grupo_id'
      )
	  
	  
	  
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
	
    <!---
	-- PROPSITO
	-- Busca posi��es que um material pode assumir
	-- NOTAS EXPLICATIVAS
	-- GUTO 12/09/2006
	--->
	<cffunction name="get_material_posicao" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct mp.material_id, ep.posicao_id, ep.posicao
			  from manutencao.v$material_posicao mp
			 inner join manutencao.v$equipamento_posicao ep
						 on ep.posicao_id = mp.posicao_id
			 where mp.material_id in (
						select m.material_id
						  from almoxarifado.v$material m
					 start with m.material_id = #arguments.material_id#
					connect by m.material_id = prior m.material_pai)
		     order by ep.posicao
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- GUTO 18/10/2006
	--->
	<cffunction name="get_oficina_processos" returntype="query" access="remote">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 					select distinct po.tipo
                         , po.ordem_servico_id
                         , decode(po.observacao, null, '', 'Obs.: '||po.observacao) as observacao_concat
                         , po.observacao
                         , po.empresa
                         , to_char(po.cod_pessoa_oficina) as cod_pessoa_oficina
                         , po.equipamento_id
                         , po.cod_equipamento
                         , po.num_ordem_servico
                         , po.grupo_id
                         , nvl(po.grupo,'Veculo') as grupo
                         , po.compartimento_id
                         , nvl(po.compartimento,'Veculo') as compartimento
                         , po.posicao_id
                         , e.placa
                         , po.posicao, po.atividade, po.atividade_id, po.processo_id, po.processo, po.executada, po.execucao_id,
							 po.controle_id_processo, po.controle_id_atividade,
							 po.cod_pessoa_principal, po.principal, po.cod_pessoa_auxiliar, po.auxiliar,
							 po.data_inicio, po.data_termino, po.tempo_estimado, po.tempo_execucao, po.tempo_execucao_min,
							 po.ordem_processo, po.verificacao,
                             manutencao.to_tempo_execucao(numtodsinterval(sum(sysdate + po.tempo_execucao_interval - sysdate) over(partition by po.ordem_servico_id order by po.ordem_servico_id),'day')).retorno as tempo_total_os,
                             manutencao.to_tempo_execucao(numtodsinterval(sum(sysdate + po.tempo_execucao_interval - sysdate) over(),'day') ).retorno as tempo_total_oficina
					  from manutencao.v$processos_oficina po
					 inner join manutencao.v$processo_recurso pr
					    on po.processo_id = pr.processo_id
                      left join almoxarifado.v$equipamento e
                        on e.equipamento_id = po.equipamento_id
				     where po.cod_pessoa_oficina = #session.cod_pessoa#
					   and po.executada = 0
					   and not exists (select 'x'
						                 from manutencao.v$os_processo_execucao ope2
                                        where ope2.controle_id = po.controle_id_processo
                                          and ope2.data_termino is null)
				<cfif Len(Trim(arguments.cod_pessoa))>
					   and exists (select 'x'
                                     from manutencao.v$recurso re
                                    where (re.especialidade_id = pr.especialidade_id
                                        or pr.especialidade_id is null)
                                       and re.nivel_id <= nvl(pr.nivel_id,po.nivel_id)
                                       and re.cod_pessoa = #arguments.cod_pessoa#)
			     </cfif>
						order by ordem_servico_id, compartimento, grupo, posicao, atividade, atividade_id, ordem_processo, data_inicio
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca servicos executados na OS
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->
	<cffunction name="get_veiculo_atividade_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select osa.controle_id, atv.titulo, nvl(mep.posicao, 'nica') as posicao, decode(osa.observacao, null, '', 'Obs.: '||osa.observacao) as observacao_concat, osa.observacao,
                atv.cod_atividade, ag.descricao as grupo,
                manutencao.to_os_atividade(osa.controle_id).material_ok as material_ok,
                manutencao.to_material_dados(manutencao.to_os_atividade(osa.controle_id).material_id).descricao_completa as material_utilizado,
                manutencao.to_tempo_execucao(osa.tempo_execucao_ajustado,3).retorno as tempo_execucao,
                case
                    when os.empresa = 0 or osa.valor_servico is not null then
                       osa.valor_servico
                    else
                       round(manutencao.to_tempo_convertido(osa.tempo_execucao_ajustado).horas * (select sum(decode(os.empresa,1,ova.valor_empresa,ova.valor_terceiro))
                                                                                                 from manutencao.mv$os_valor_atividade ova
                                                                                                where ova.ordem_servico_id = os.ordem_servico_id
                                                                                                  and ova.atividade_id = osa.atividade_id),2)
                end valor,
                case
                  when osa.gerada_por = 1 then 'Sistema'
                  when osa.gerada_por = 2 then 'Solicitao do Motorista'
                  when osa.gerada_por = 3 then 'Check List'
                else '' end gerada_por, os.observacao
           from manutencao.v$ordem_servico os
          inner join manutencao.v$os_atividade osa
             on osa.ordem_servico_id = os.ordem_servico_id
          inner join manutencao.v$atividade atv
             on atv.atividade_id = osa.atividade_id
           left join manutencao.v$atividade_grupo ag
             on ag.grupo_id = atv.grupo_id
           left join manutencao.v$equipamento_posicao mep
             on mep.posicao_id = osa.posicao_id
           where osa.ordem_servico_id = #arguments.ordem_servico_id#
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca materiais com a garantia na OS
	-- NOTAS EXPLICATIVAS
	-- ANDERSON - 15/06/2009 - ALTERADO
	--->
	<cffunction name="get_veiculo_material_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select md.material_id
            	 , om.controle_id
                 , om.posicao_id
                 , nvl(ep.posicao, 'nica') as posicao
                 --, round(nvl(nullif(om.valor_unitario,0), almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(p_material_id => om.material_id,p_atributo_id => 23)                ), 2) as valor_unitario
                 --, round(nvl(nullif(om.valor_total   ,0), almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(p_material_id => om.material_id,p_atributo_id => 23) * om.quantidade), 2) as valor_total
                 , case
                     when decode(om.lancamento_id_saida, null, 'Oficina', 'Estoque') = 'Estoque' then
                        round(nvl(nullif(om.valor_unitario, 0), almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(p_material_id => om.material_id, p_atributo_id => 23)), 2)
                     else
                        om.valor_unitario	
                  end valor_unitario 
         
                 , case
                     when decode(om.lancamento_id_saida, null, 'Oficina', 'Estoque') = 'Estoque' then
                        round(nvl(nullif(om.valor_unitario, 0), almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(p_material_id => om.material_id, p_atributo_id => 23)) * om.quantidade, 2)
                     else
                        om.valor_total	
                  end valor_total 
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(md.material_id, 12) as localizacao
                 , md.material
                 , mdr.material as material_retirado
                 , om.quantidade
                 , e.cod_equipamento
                 , decode(om.lancamento_id_saida, null, 'Oficina', 'Estoque') as origem_material
              from manutencao.v$os_material om
             inner join almoxarifado.v$material_dados md
                     on md.material_id = om.material_id
             inner join almoxarifado.v$material_dados mdr
                     on mdr.material_id = om.material_id_retirado
              left join manutencao.v$equipamento_posicao ep
                     on ep.posicao_id = om.posicao_id
              left join almoxarifado.v$equipamento e
                     on e.equipamento_id = om.equipamento_id
   		     where om.ordem_servico_id = #arguments.ordem_servico_id#
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuten��o vincculadas a um Veculo
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->

	<cffunction name="get_equipamento_tabela_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select tm.nome as tabela, ost.ordem_servico_id,
				       case
                           when tm.tipo_execucao is null then ''
                           when tm.tipo_execucao = 1 then 'Completa'
                           when tm.tipo_execucao = 2 then 'Parcial'
                       else '' end tipo_execucao
				  from manutencao.v$os_tabela_manutencao ost
           inner join manutencao.v$tabela_manutencao tm
          		   on tm.tabela_id = ost.tabela_id
				where ost.ORDEM_SERVICO_ID = #arguments.ordem_servico_id#
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>


   <!---
	-- PROPSITO
	-- Busca dados do organograma da O.S
	-- NOTAS EXPLICATIVAS
	-- JEAN C. MELO 08/02/2018
	--->

	<cffunction name="get_organograma_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">

          select os.ordem_servico_id
               , org.cod_organograma
               , dp.descricao as departamento
               , st.descricao as setor
               , un.unidade_negocio
               , cc.centro_custo
            from kss.v$organograma org
           inner join manutencao.v$ordem_servico os
             on os.cod_centro_custo = org.cod_centro_custo
           inner join kss.v$departamento dp
             on dp.cod_departamento = org.cod_departamento
           inner join kss.v$setor st
             on st.cod_setor = org.cod_setor
          inner join kss.v$unidade_negocio un
             on un.cod_unidade_negocio = org.cod_unidade_negocio
          inner join kss.v$centro_custo cc
             on cc.cod_centro_custo = org.cod_centro_custo
			 where os.ORDEM_SERVICO_ID = #arguments.ordem_servico_id#
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca solicita��es (por OS) enviadas pelos motoristas
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->
	<cffunction name="get_equipamento_solicitacao_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.cod_equipamento,
                   ms.solicitacao_id,
                   ms.equipamento_id,
                   to_char(ms.data_solicitacao, 'dd/mm/yyyy hh24:mi:ss') as data_solicitacao,
                   ms.texto,
                   ms.atendida,
                   ms.ordem_servico_id_execucao,
                   ms.user_insert,
                   ms.date_insert,
                   (select to_char(cod_pessoa)
                      from oper.v$veiculo_motorista vm
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as cod_pessoa_motorista,
                   (select p.cliente
                      from oper.v$veiculo_motorista vm
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = vm.cod_pessoa
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as motorista
              from manutencao.v$equipamento_solicitacao ms
             inner join almoxarifado.v$equipamento e
                      on e.equipamento_id = ms.equipamento_id
  			  where ms.ordem_servico_id_execucao = #arguments.ordem_servico_id#
			  order by ms.data_solicitacao desc
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atendimentos vinculados a OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 09/07/2007
	--->
	<cffunction name="get_os_atendimento" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default=""/>
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
        <cfargument name="recurso_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.controle_id, os.ordem_servico_id, to_char(os.cod_pessoa_mecanico) as cod_pessoa_mecanico, p.cliente as mecanico,
                   os.placa_veiculo_socorro,
                   to_char(os.data_saida,'dd/mm/yyyy hh24:mi') as data_saida,
                   to_char(os.data_retorno,'dd/mm/yyyy hh24:mi') as data_retorno, os.km_deslocamento,
                   o.num_ordem_servico, p2.cliente as oficina
              from manutencao.v$os_atendimento os
             inner join kss.v$pessoa p
                     on p.cod_pessoa = os.cod_pessoa_mecanico
             inner join manutencao.v$ordem_servico o
                     on o.ordem_servico_id = os.ordem_servico_id
             inner join kss.v$pessoa p2
                     on p2.cod_pessoa = o.cod_pessoa_oficina
             where 1=1
             <cfif Len(Trim(arguments.ORDEM_SERVICO_ID))>
               and os.ordem_servico_id in (#arguments.ORDEM_SERVICO_ID#)
             </cfif>
             <cfif Len(Trim(arguments.DATA_INICIO))>
               and o.data_abertura >= '#arguments.DATA_INICIO#'
             </cfif>
             <cfif Len(Trim(arguments.DATA_FIM))>
               and o.data_abertura <= '#arguments.DATA_FIM#'
             </cfif>
             <cfif Len(Trim(arguments.recurso_id))>
               and os.cod_pessoa_mecanico in (#arguments.recurso_id#)
             </cfif>
             order by os.cod_pessoa_mecanico
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca tabelas de manuten��o na OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_os_tabelas" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="yes">
        <cfargument name="somente_folhas" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ot.controle_id
                 , os.ordem_servico_id
                 , os.num_ordem_servico
                 , ot.confirmada
                 , ot.tabela_id
                 , tm.nome
                 , nvl((select min(oa.executada)
                          from manutencao.v$os_atividade oa
                         where oa.controle_id_tabela = ot.controle_id),1) as executada
                 , manutencao.to_tempo_execucao(numtodsinterval(nvl((select sum(sysdate+oa.tempo_execucao_oficina-sysdate)
																	   from manutencao.v$os_atividade oa
																	  where oa.controle_id_tabela = ot.controle_id),0),'DAY')).retorno as tempo_execucao
                  , (select substr(sys_connect_by_path('|' || tabela_id || '|', ','),2)
                        from manutencao.v$tabela_manutencao tm2
                       where tm2.tabela_id = ot.tabela_id
                       start with tabela_pai = 0
                     connect by prior tabela_id = tabela_pai
                       ) as lista_tabela_separador
			 from manutencao.v$ordem_servico os
			inner join manutencao.v$os_tabela_manutencao ot
				 on ot.ordem_servico_id = os.ordem_servico_id
			inner join manutencao.v$tabela_manutencao tm
					   on tm.tabela_id = ot.tabela_id
			where 1=1
			  and os.ordem_servico_id in (#arguments.ordem_servico_id#)
		  <cfif arguments.somente_folhas eq 1>
              and tm.tabela_id not in ( select tm2.tabela_pai
                                          from manutencao.v$os_tabela_manutencao ot2
                                         inner join manutencao.v$tabela_manutencao tm2
                                            on tm2.tabela_id = ot2.tabela_id
                                         where ot2.ordem_servico_id = ot.ordem_servico_id)
          </cfif>
			order by ot.date_insert
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atividades da OS
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 30/04/2010 - ALTERADO
	--->
	<cffunction name="get_os_atividades" returntype="query" access="remote">
		<cfargument name="controle_id" required="no" default="">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="verificacao" required="no" default="0">

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.ordem_servico_id
                 , oa.atividade_id
                 , oa.controle_id_tabela
                 , oa.controle_id as controle_id_atividade
                 , a.titulo
                 , manutencao.to_os_atividade(oa.controle_id).material_ok as material_ok
                 , manutencao.to_material_dados(manutencao.to_os_atividade(oa.controle_id).material_id).descricao_completa as material_utilizado
                 , case
                      when oa.gerada_por = 1 then 'Sistema'
                      when oa.gerada_por = 2 then 'Solicitao Mot.'
                      else 'Check List'
                   end gerada_por
                 , oa.executada
                 , manutencao.to_tempo_execucao(nvl(oa.tempo_execucao_ajustado, numtodsinterval(0, 'DAY'))).retorno as tempo_execucao
                 , oa.date_insert
                 , oa.posicao_id
                 , nvl(ep.posicao, 'nica') as posicao
				     , nvl(case
                          when os.empresa = 0 or oa.valor_servico is not null then
                             oa.valor_servico
                          else
                             round(manutencao.to_tempo_convertido(oa.tempo_execucao_ajustado).horas * (select sum(decode(os.empresa,1,ova.valor_empresa,ova.valor_terceiro))
                                                                                                         from manutencao.mv$os_valor_atividade_dados ova
                                                                                                        where ova.ordem_servico_id = os.ordem_servico_id
                                                                                                          and ova.atividade_id = oa.atividade_id),2)
				       end, 0) valor_atividade
                 , a.cod_atividade
                 , (select max(km_previsao) keep(dense_rank last order by ea.controle_id)
                      from manutencao.v$equipamento_atividade ea
                     where ea.equipamento_id = os.equipamento_id
                       and ea.ordem_servico_id_execucao = os.ordem_servico_id
                       and ea.atividade_id = oa.atividade_id) as km_previsao
                 , (select max(data_previsao) keep(dense_rank last order by ea.controle_id)
                      from manutencao.v$equipamento_atividade ea
                     where ea.equipamento_id = os.equipamento_id
                       and ea.ordem_servico_id_execucao = os.ordem_servico_id
                       and ea.atividade_id = oa.atividade_id) as data_previsao
                 , os.valor_servico
                 , oa.valor_servico as valor_servico_atividade
                 , oa.quantidade
                 , nvl(oa.valor_unitario,0) as valor_unitario
            from manutencao.v$ordem_servico os
           inner join manutencao.v$os_atividade oa
              on oa.ordem_servico_id = os.ordem_servico_id
           inner join manutencao.v$atividade a
              on a.atividade_id = oa.atividade_id
            left join manutencao.v$equipamento_posicao ep
              on ep.posicao_id = oa.posicao_id
             where 1=1
            <cfif Len(Trim(arguments.ordem_servico_id))>
                and os.ordem_servico_id in (#arguments.ordem_servico_id#)
            </cfif>
            <cfif Len(Trim(arguments.controle_id))>
                and op.controle_id = #arguments.controle_id#
            </cfif>
            <cfif arguments.verificacao eq 1>
                and a.verificacao = 1
            </cfif>
			order by oa.date_insert, oa.atividade_id
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca simples das atividades da OS
	-- NOTAS EXPLICATIVAS
	--->
	<cffunction name="get_os_atividades_simples" returntype="query" access="remote">
		<cfargument name="controle_id" required="no" default="">

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select oa.atividade_id
                 , a.titulo
                 , nvl(oa.valor_servico,0) as valor_atividade
            from manutencao.v$ordem_servico os
           inner join manutencao.v$os_atividade oa
              on oa.ordem_servico_id = os.ordem_servico_id
           inner join manutencao.v$atividade a
              on a.atividade_id = oa.atividade_id
             where 1=1
            <cfif Len(Trim(arguments.ordem_servico_id))>
                and os.ordem_servico_id in (#arguments.ordem_servico_id#)
            </cfif>
			order by oa.date_insert
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca solicita��es (por OS) enviadas pelos motoristas
	-- NOTAS EXPLICATIVAS
	-- RAFAEL COSTA 30/04/2010
	--->
	<cffunction name="get_equipamento_solicitacao_gerada_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.cod_equipamento,
                   ms.solicitacao_id,
                   ms.equipamento_id,
                   to_char(ms.data_solicitacao, 'dd/mm/yyyy hh24:mi:ss') as data_solicitacao,
                   ms.texto,
                   ms.atendida,
                   ms.ordem_servico_id_execucao,
                   ms.user_insert,
                   ms.date_insert,
                   (select to_char(cod_pessoa)
                      from oper.v$veiculo_motorista vm
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as cod_pessoa_motorista,
                   (select p.cliente
                      from oper.v$veiculo_motorista vm
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = vm.cod_pessoa
                     where vm.placa = e.cod_equipamento
                       and sysdate between vm.data_inicio and nvl(vm.data_fim,sysdate)) as motorista,
                   oses.ordem_servico_id
              from manutencao.v$equipamento_solicitacao ms
        inner join almoxarifado.v$equipamento e
                on e.equipamento_id = ms.equipamento_id
        inner join manutencao.v$os_equipamento_solicitacao oses
                on oses.solicitacao_id = ms.solicitacao_id
             where 1 = 1
          <cfif Len(Trim(arguments.ordem_servico_id))>
               and oses.ordem_servico_id = #arguments.ordem_servico_id#
          </cfif>
          <cfif Len(Trim(arguments.equipamento_id))>
               and ms.equipamento_id = #arguments.equipamento_id#
          </cfif>
               and ms.atendida = 0
          order by ms.data_solicitacao desc
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 25/09/2009 - EDITADO
	--->
	<cffunction name="print_oficina_processos" returntype="query" access="remote" output="true">
		<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="aberta" required="no" default="">
		<cfargument name="controle_id_processo" required="no" default="">
        <cfargument name="ordem_servico_id" required="no" default="">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="verificacao" required="no" default="0">
        <cfargument name="externa" required="no" default="0" hint="0-No; 1-Sim">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo
                 , rownum as linha_controle
                 , ordem_servico_id
                 , empresa
                 , to_char(cod_pessoa_oficina) as cod_pessoa_oficina
                 , equipamento_id
                 , cod_equipamento
                 , agrupamento
                 , num_ordem_servico
                 , grupo_id
                 , grupo
                 , compartimento_id
                 , compartimento
                 , posicao_id
                 , posicao
                 , atividade
                 , processo_id
                 , processo
                 , executada
                 , execucao_id
                 , controle_id_processo
                 , controle_id_atividade
                 , to_char(cod_pessoa_principal) as cod_pessoa_principal
                 , principal
                 , to_char(cod_pessoa_auxiliar) as cod_pessoa_auxiliar
                 , auxiliar
                 , data_inicio
                 , data_termino
                 , tempo_estimado
                 , tempo_execucao
                 , ordem_processo
                 , nome_mecanico
                 , nivel_id
                 , especialidade_id
                 , observacao
                 , placa
              from (select distinct po.tipo,
                           po.ordem_servico_id,
                           e.placa,
                           po.empresa,
                           po.cod_pessoa_oficina,
                           po.equipamento_id,
                           po.cod_equipamento,
                           po.cod_equipamento || ' > ' || nvl(po.compartimento, 'Veculo') as agrupamento,
                           po.num_ordem_servico,
                           po.grupo_id,
                           nvl(po.grupo, 'Veculo') as grupo,
                           po.compartimento_id,
                           nvl(po.compartimento, 'Veculo') as compartimento,
                           po.posicao_id,
                           po.posicao,
                           po.atividade || ' > ' || nvl(po.grupo, 'Veculo') as atividade,
                           po.processo_id,
                           po.processo,
                           po.executada,
                           po.execucao_id,
                           po.controle_id_processo,
                           po.controle_id_atividade,
                           po.cod_pessoa_principal,
                           po.principal,
                           po.cod_pessoa_auxiliar,
                           po.auxiliar,
                           po.data_inicio,
                           po.data_termino,
                           po.tempo_estimado,
                           po.tempo_execucao,
                           po.ordem_processo,
                           p.cliente as nome_mecanico,
                           decode(po.observacao, null, '', 'Obs.: '||po.observacao) as observacao,
                           0 as nivel_id,
                           0 as especialidade_id
                      from manutencao.v$processos_oficina po
                     inner join manutencao.v$processo_recurso pr
                             on po.processo_id = pr.processo_id
                      left join almoxarifado.v$equipamento e
                        on e.equipamento_id = po.equipamento_id
                    <cfif arguments.externa eq 1>
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = po.cod_pessoa_oficina
                    <cfelse>
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = po.cod_pessoa_principal
                     inner join manutencao.v$recurso r
                             on r.cod_pessoa = p.cod_pessoa
                            and r.especialidade_id = pr.especialidade_id
                    </cfif>
                     where 1 = 1
                       and po.executada = 0
                    <cfif arguments.externa eq 0>
                       and po.execucao_id is not null
                       and po.cod_pessoa_oficina = #session.cod_pessoa#
                    </cfif>
                    <cfif Len(Trim(arguments.cod_pessoa))>
                       and po.cod_pessoa_principal = #arguments.cod_pessoa#
                    </cfif>
                    <cfif Len(Trim(arguments.aberta))>
                       and po.data_termino is null
                    </cfif>
                    <cfif Len(Trim(arguments.controle_id_processo))>
                       and po.controle_id_processo in (#arguments.controle_id_processo#)
                    </cfif>
                    <cfif Len(Trim(arguments.ordem_servico_id))>
                       and po.ordem_servico_id = #arguments.ordem_servico_id#
                    </cfif>

                    <cfif Len(Trim(arguments.equipamento_id))>

                       and po.equipamento_id = #arguments.equipamento_id#
                    </cfif>
                    <cfif arguments.verificacao eq 1>
                       and po.verificacao = 1
                    </cfif>
                     order by ordem_servico_id, compartimento, grupo, posicao, atividade, ordem_processo, data_inicio)
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca recursos que podem executar o processo
	-- NOTAS EXPLICATIVAS
	-- GUTO 17/10/2007
	--->
	<cffunction name="get_recursos_processo" returntype="query" access="remote">
		<cfargument name="processo_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select distinct r.recurso_id,
                   to_char(r.cod_pessoa) as cod_pessoa, pf.cliente as nome_funcionario,
                   oper.pkg_global.fnc_get_cod_funcionario(r.cod_pessoa) as cod_funcionario,
                   r.especialidade_id,
                   re.descricao as especialidade,
                   r.nivel_id, rn.descricao as nivel
                from manutencao.v$recurso r
               inner join manutencao.v$recurso_especialidade re
                   on re.especialidade_id = r.especialidade_id
               inner join manutencao.v$recurso_nivel rn
                   on rn.nivel_id = r.nivel_id
               inner join kss.v$pessoa pf
                   on pf.cod_pessoa = r.cod_pessoa
               inner join manutencao.v$processo_recurso pr
                       on pr.especialidade_id = re.especialidade_id
                      and pr.nivel_id >= rn.nivel_id
                      and pr.processo_id = #arguments.processo_id#
                 where 1=1
                           and re.especialidade_id in (select especialidade_id
                                                         from manutencao.v$processo_recurso p
                                                        where 1=1
                                                          and p.processo_id = #arguments.processo_id#)
                  order by nome_funcionario
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca recursos de processos abertos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 01/11/2006
	--->
	<cffunction name="get_recurso_processo_aberto" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct to_char(r.cod_pessoa) as cod_pessoa,
							pf.cliente as nome_funcionario,
							(select manutencao.sum_dsinterval(p.tempo_execucao) + min(ope.DATA_INICIO)
        								  from manutencao.v$ordem_servico os
                         inner join manutencao.v$os_atividade oa
                                 on oa.ordem_servico_id = os.ordem_servico_id
                         inner join manutencao.v$os_processo_atividade opa
                                 on opa.controle_id_atividade = oa.controle_id
                         inner join manutencao.v$os_processo_execucao ope
                                 on opa.controle_id_processo = ope.controle_id
                         inner join manutencao.v$os_processos op
                                 on opa.controle_id_processo = op.controle_id
                         inner join manutencao.v$processo p
                                 on p.processo_id = op.processo_id
        								 where ope.cod_pessoa_principal = pf.cod_pessoa
        									and ope.data_termino is null) - sysdate as no_horario,
							manutencao.to_tempo_execucao((select manutencao.sum_dsinterval(p.tempo_execucao)
        								  from manutencao.v$ordem_servico os
                         inner join manutencao.v$os_atividade oa
                                 on oa.ordem_servico_id = os.ordem_servico_id
                         inner join manutencao.v$os_processo_atividade opa

                                 on opa.controle_id_atividade = oa.controle_id
                         inner join manutencao.v$os_processo_execucao ope
                                 on opa.controle_id_processo = ope.controle_id
                         inner join manutencao.v$os_processos op
                                 on opa.controle_id_processo = op.controle_id
                         inner join manutencao.v$processo p
                                 on p.processo_id = op.processo_id
        								 where ope.cod_pessoa_principal = pf.cod_pessoa
        									and ope.data_termino is null)).retorno as tempo_execucao
			  from manutencao.v$recurso r
		inner join kss.v$pessoa pf
		        on pf.cod_pessoa = r.cod_pessoa
	    	 where 1 = 1
			   and exists (select /*+PUSH_SUBQ*/ 'x'
        								  from manutencao.v$ordem_servico os
                         inner join manutencao.v$os_atividade oa
                                 on oa.ordem_servico_id = os.ordem_servico_id
                         inner join manutencao.v$os_processo_atividade opa
                                 on opa.controle_id_atividade = oa.controle_id
                         inner join manutencao.v$os_processo_execucao op
                                 on opa.controle_id_processo = op.controle_id
        								 where op.cod_pessoa_principal = pf.cod_pessoa
        									and op.data_termino is null)
			   and (exists (select 'x'
              from manutencao.v$recurso_oficina ro
        inner join manutencao.v$recurso r2
                on r2.recurso_id = ro.recurso_id
             where r2.cod_pessoa = r.cod_pessoa
               and ro.cod_pessoa_oficina = #session.cod_pessoa#)
  	 or not exists (select 'x'
  	                  from manutencao.v$recurso_oficina ro
                inner join manutencao.v$recurso r2
                        on r2.recurso_id = ro.recurso_id
                inner join oper.v$filial f
                        on f.cod_pessoa = ro.cod_pessoa_oficina
                     where r2.cod_pessoa = r.cod_pessoa) )
			 order by nome_funcionario
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os recursos de processos que No possuem execu��es atribu�das
	-- NOTAS EXPLICATIVAS
	-- ANDERSON - 10/08/2009 - EDITADO
	--->
	<cffunction name="get_recurso_processo_sem_execucao" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct to_char(r.cod_pessoa) as cod_pessoa
                 , pf.cliente as nome_funcionario
              from manutencao.v$recurso r
             inner join kss.v$pessoa pf
                     on pf.cod_pessoa = r.cod_pessoa
             where 1 = 1
               and not exists (select 'x'
                                 from manutencao.v$ordem_servico os
                                inner join manutencao.v$os_atividade oa
                                        on oa.ordem_servico_id = os.ordem_servico_id
                                inner join manutencao.v$os_processo_atividade opa
                                        on opa.controle_id_atividade = oa.controle_id
                                inner join manutencao.v$os_processo_execucao op
                                        on opa.controle_id_processo = op.controle_id
                                where op.cod_pessoa_principal = pf.cod_pessoa
                                  and op.data_termino is null)
               and exists (select 'x'
                             from manutencao.v$recurso_oficina ro
                            inner join manutencao.v$recurso r2
                                    on r2.recurso_id = ro.recurso_id
                            where r2.cod_pessoa = r.cod_pessoa
                              and ro.cod_pessoa_oficina = #session.cod_pessoa#)
             order by nome_funcionario
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Busca os equipamentos vinculados a um recurso de um processo aberto
    -- ANDERSON 01/12/2009 - ALTERADO
    --->
    <cffunction name="get_recurso_processo_equipamentos" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_principal" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.equipamento_id
                 , t.cod_equipamento
                 , kss.fnc_concat_all(kss.to_concat_expr(to_char(t.num_ordem_servico), ', ')) as num_ordem_servico
              from (
                    select po.equipamento_id
                         , po.cod_equipamento
                         , os.num_ordem_servico
                      from manutencao.v$processos_oficina po
                     inner join manutencao.v$ordem_servico os
                             on os.ordem_servico_id = po.ordem_servico_id
                     where po.cod_pessoa_oficina = #session.cod_pessoa#
                       and po.execucao_id is not null
                       and po.executada = 0
                       and po.cod_pessoa_principal = #arguments.cod_pessoa_principal#
                     group by po.equipamento_id, po.cod_equipamento, os.num_ordem_servico
                   ) t
             group by t.equipamento_id, t.cod_equipamento
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca as ocorr�ncias de Previs�o de Libera��o
	-- NOTAS EXPLICATIVAS
	-- WAGNER 05/12/2006
	--->
	<cffunction name="get_liberacao" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" default="" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 			select t.previsao_id,
				   t.ordem_servico_id,
			       to_char(t.data_previsao,'dd/mm/yyyy hh24:mi') as data_previsao,
    			   t.responsavel as responsavel,
     			   t.motivo_adiamento,
				   t.date_update
  			  from manutencao.v$os_previsao_liberacao t
  			 where t.ordem_servico_id = #arguments.ordem_servico_id#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca itens de ordens vinculadas a OS
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 30/04/2010 - ALTERADO
	--->
	<cffunction name="get_ordem_compra_os" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select oc.num_controle
                  ,p.razao_social as titulo
                 , (select pf.cliente
                      from kss.v$pessoa pf
                     where pf.cod_pessoa = oc.cod_pessoa_fornecedor) as fornecedor
                  ,to_char(oc.data_emissao, 'dd/mm/yyyy') as data_emissao
                  ,oc.total_orcado
                  ,oc.total_desconto
                  ,oc.total_combinado
                  ,e.cod_equipamento as placa
                  ,nvl(nvl(manutencao.to_ordem_servico(os.ordem_servico_id).valor_total_servicos,0) +
                       nvl(manutencao.to_ordem_servico(os.ordem_servico_id).valor_total_material, 0), 0
                      ) as total_utilizado
              from manutencao.v$ordem_compra oc
             inner join manutencao.v$os_ordem_compra ooc
                     on ooc.num_controle = oc.num_controle
             inner join manutencao.v$ordem_servico_dados os
                     on os.ordem_servico_id = ooc.ordem_servico_id
             inner join kss.v$pessoa p
                     on p.cod_pessoa = os.cod_pessoa_oficina
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id
             where 1 = 1
            <cfif len(Trim(arguments.ordem_servico_id))>
               and ooc.ordem_servico_id = #arguments.ordem_servico_id#
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca itens de ordens vinculadas a OS
	-- NOTAS EXPLICATIVAS
	-- RAFAEL COSTA 09/06/2009
	--->
	<cffunction name="get_ordem_compra_nf_terceiro" returntype="query" access="remote">
		<cfargument name="ORDEM_SERVICO_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
              select osd.num_nota_id
                    ,toc.ordem_compra_id
                    ,p.razao_social as titulo
                    ,to_char(oc.data_emissao, 'dd/mm/yyyy') as data_emissao

                    ,oc.total_orcado
                    ,oc.total_desconto
                    ,oc.total_combinado
                    ,nvl((select sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_servicos,0)) +
                                 sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id).valor_total_material,0))
                           from manutencao.v$os_ordem_compra ooc
                          where ooc.num_controle = oc.num_controle),0) as valor_utilizado
                    ,oc.num_controle
                    ,e.cod_equipamento as placa
                from manutencao.v$ordem_servico_dados osd
          inner join manutencao.v$nf_terceiro_ordem_compra toc
                  on toc.nf_terceiro_id = osd.num_nota_id
          inner join manutencao.v$ordem_compra oc
                  on oc.num_controle = toc.ordem_compra_id
          inner join kss.v$pessoa p
                  on p.cod_pessoa = osd.cod_pessoa_oficina
          inner join almoxarifado.v$equipamento e
                  on e.equipamento_id = osd.equipamento_id
               where 1 = 1
            <cfif len(Trim(arguments.ORDEM_SERVICO_ID))>
               and osd.ordem_servico_id = #arguments.ORDEM_SERVICO_ID#
            </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca ordens de servi�o vinculadas a nf de terceiro
	-- NOTAS EXPLICATIVAS
	-- JONAS 03/07/2009
	--->
	<cffunction name="get_ordem_servico_nf_terceiro" returntype="query" access="remote">
		<cfargument name="ORDEM_SERVICO_ID" required="yes" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select osd.num_nota_id,
         		 osd.num_ordem_servico,
                osd.ordem_servico_id,
                p.razao_social as titulo,
                e.cod_equipamento as placa,
                to_char(osd.data_abertura, 'dd/mm/yyyy') as data_abertura,
                nvl(
                    nvl(manutencao.to_ordem_servico(osd.ordem_servico_id).valor_total_servicos,0) +-- + manutencao.to_ordem_servico(osd.ordem_servico_id).valor_total_material) as valor,
                    nvl(manutencao.to_ordem_servico(osd.ordem_servico_id).valor_total_material,0)
                ,0) as valor
           from manutencao.v$ordem_servico_dados osd
          inner join kss.v$pessoa p
             on p.cod_pessoa = osd.cod_pessoa_oficina
          inner join almoxarifado.v$equipamento e
             on e.equipamento_id = osd.equipamento_id
          where 1 = 1
            and osd.num_nota_id = (select num_nota_id from manutencao.v$ordem_servico_dados where ordem_servico_id = #arguments.ordem_servico_id#)
          order by osd.data_abertura
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca equipamentos
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 16/12/2009
	--->
	<cffunction name="get_solicitacao_equipamento" returntype="query" access="remote">
		<cfargument name="solicitacao_id" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select es.solicitacao_id
                     , es.equipamento_id
                     , es.data_solicitacao
                     , es.texto
                     , es.atendida
                     , es.ordem_servico_id_execucao
                     , e.cod_equipamento
                     , to_char(es.cod_pessoa_responsavel) as cod_pessoa_responsavel
                     , (select to_number(fm.num_matricula)
                          from kss.v$funcionario_matr_historico fm
                         where fm.cod_pessoa = es.cod_pessoa_responsavel) as cod_funcionario
                     , kss.pkg_pessoa.fnc_get_cliente(es.cod_pessoa_responsavel) as nome_funcionario
                     , es.tipo_id
                     , est.descricao as tipo
				  from manutencao.v$equipamento_solicitacao es
                 inner join almoxarifado.v$equipamento e
                    on e.equipamento_id = es.equipamento_id
                 inner join manutencao.v$equipamento_solicitacao_tipo est
                    on est.tipo_id = es.tipo_id
    		     where 1=1
 			  <cfif Len(Trim(arguments.solicitacao_id))>
				and es.solicitacao_id = #arguments.solicitacao_id#
			  </cfif>
			  <cfif Len(Trim(arguments.equipamento_id))>
				and es.equipamento_id = #arguments.equipamento_id#
			  </cfif>
			  <cfif Len(Trim(arguments.cod_equipamento))>
				and upper(e.cod_equipamento) like upper('%#arguments.cod_equipamento#%')
			  </cfif>
 			  order by e.cod_equipamento
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- GUTO 18/10/2006
	--->
	<cffunction name="get_material_atividade" returntype="query" access="remote">
		<cfargument name="MATERIAL_ID" required="yes" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
 				select mab.material_id,
					   mab.atividade_id,
					   atv.titulo
				  from manutencao.v$material_atividade_baixa mab
	    	inner join manutencao.v$atividade atv
					on atv.atividade_id = mab.atividade_id
				 where 1=1
				   and mab.material_id = #arguments.MATERIAL_ID#
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	- Busca Veculos em manuten��o
	-- NOTAS EXPLICATIVAS
	-- GUTO 15/12/2009
	--->
	<cffunction name="get_veiculos_manutencao" returntype="query" access="remote">
   <cfargument name="cod_pessoa_filial" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.ordem_servico_id, os.num_ordem_servico,
                   e.placa, e.cod_equipamento, o.cliente as oficina,
                   nvl(tos.descricao, 'No identificado') as tipo_os,
                   to_char(os.data_abertura,'dd/mm/yyyy hh24:mi') as data_abertura,
                   kss.to_tempo(numtodsinterval((nvl(os.data_fechamento,sysdate) - os.data_abertura),'day'),1).retorno as tempo_total,
                   numtodsinterval((nvl(os.data_fechamento,sysdate) - os.data_abertura),'day') as tempo_internval, os.observacao,
                   r.cliente as responsavel, os.user_insert,
                   to_char(os.date_insert,'dd/mm/yyyy hh24:mi') as date_insert,
                   to_char(manutencao.to_os_liberacao(e.placa).data_previsao,'dd/mm/yyyy hh24:mi') as data_prev_liberacao
                   ,manutencao.to_os_liberacao(e.placa).motivo as motivo
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id
             inner join kss.v$pessoa o
                     on o.cod_pessoa = os.cod_pessoa_oficina
              left join manutencao.v$tipo_ordem_servico tos
                     on tos.tipo_ordem_servico_id = os.tipo_ordem_servico_id
             inner join kss.v$pessoa r
                     on r.cod_pessoa = os.cod_pessoa_responsavel
             where os.data_fechamento is null


        <cfif Len(Trim(arguments.COD_PESSOA_FILIAL)) and arguments.COD_PESSOA_FILIAL eq -1>
              and os.empresa = 0
           </cfif>

        <cfif Len(Trim(arguments.COD_PESSOA_FILIAL)) and arguments.COD_PESSOA_FILIAL neq -1>
              and (
                    (os.cod_pessoa_oficina = #arguments.COD_PESSOA_FILIAL# and os.empresa = 1)
                 or ( (select vca.cod_Pessoa_filial
                        from oper.v$veiculo_ccusto_atual vca
                        where vca.placa = e.placa  )  =  #arguments.COD_PESSOA_FILIAL# and os.empresa = 0)
                 )
           </cfif>

            order by tempo_internval desc
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os processos da atividade detalhado
	-- CRISTOFER  11/08/2006
	--->
	<cffunction name="get_atividade_processos" access="remote" returntype="query">
		<cfargument name="atividade_id" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.atividade_id, a.titulo as atividade, a.cod_atividade,
					 manutencao.to_tempo_execucao(manutencao.sum_dsinterval(nvl(p.tempo_execucao,a.tempo_execucao)) over(partition by a.atividade_id order by a.atividade_id)).retorno as tempo_total,
					 p.processo_id, p.titulo as processo,
					 manutencao.to_tempo_execucao(nvl(p.tempo_execucao,a.tempo_execucao)).retorno as tempo_execucao,
					 ap.ordem, ap.item_id
			  from manutencao.v$atividade a
			 left join manutencao.v$atividade_processo ap
						on ap.atividade_id = a.atividade_id
			 left join manutencao.v$processo p
						on p.processo_id = ap.processo_id
			 order by a.atividade_id, ap.ordem
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca horas dos recursos
	-- NOTAS EXPLICATIVAS
	-- GUTO 11/10/2006
	--->
	<cffunction name="get_horas_recursos" returntype="query" access="remote">
		<cfargument name="cod_pessoa_responsavel" required="no" default="">
		<cfargument name="recurso_id" required="no">
		<cfargument name="data_inicio" required="no">
		<cfargument name="data_termino" required="no">
		<cfquery result="query" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		 select to_char(cod_pessoa_principal) as cod_pessoa_principal, principal, cod_pessoa_auxiliar,
 			 	    auxiliar, tempo_execucao,
 				    especialidade_id, especialidade, nivel, nivel_id,
				    valor_hora, valor_total_horas,
					manutencao.to_tempo_execucao(manutencao.sum_dsinterval(tempo_exec_interval) over(partition by cod_pessoa_principal order by cod_pessoa_principal),3).retorno as tempo_total_func,
					sum(nvl(valor_total_horas,0)) over(partition by cod_pessoa_principal order by cod_pessoa_principal) as valor_total_func
			from (
			select ope.cod_pessoa_principal, pe.cliente as principal,
					 ope.cod_pessoa_auxiliar, pea.cliente as auxiliar,
					 manutencao.sum_dsinterval(op.tempo_execucao_ajustado * (pr.percentual_participacao/100)) / decode(ope.cod_pessoa_auxiliar,null,1,2) as tempo_exec_interval,
					 manutencao.to_tempo_execucao(manutencao.sum_dsinterval(op.tempo_execucao_ajustado * (pr.percentual_participacao/100))/ decode(ope.cod_pessoa_auxiliar,null,1,2),3) .retorno as tempo_execucao,
					 e.especialidade_id, e.descricao as especialidade,
					 n.descricao as nivel, n.nivel_id,
					 avg(manutencao.to_recurso_valor(ope.cod_pessoa_principal,e.especialidade_id,n.nivel_id,ope.data_termino).valor_hora) as valor_hora,
					 round((((sysdate + manutencao.sum_dsinterval(op.tempo_execucao_ajustado * (pr.percentual_participacao/100)) - sysdate)*24) * avg(manutencao.to_recurso_valor(ope.cod_pessoa_principal,e.especialidade_id,n.nivel_id,ope.data_termino).valor_hora)) / decode(ope.cod_pessoa_auxiliar,null,1,2) ,2) as valor_total_horas
			  from manutencao.v$ordem_servico os
             inner join manutencao.v$os_processos op
                     on os.ordem_servico_id = op.ordem_servico_id
			 inner join manutencao.v$os_processo_execucao ope
               on op.controle_id = ope.controle_id
			 inner join manutencao.v$processo p
               on p.processo_id = op.processo_id
			 inner join manutencao.v$processo_recurso pr on pr.item_id = op.processo_recurso_id
			 inner join manutencao.v$recurso_nivel n on n.nivel_id = pr.nivel_id
			 inner join manutencao.v$recurso_especialidade e on e.especialidade_id =
																				 pr.especialidade_id
			 inner join kss.v$pessoa pe on pe.cod_pessoa = ope.cod_pessoa_principal
			  left join kss.v$pessoa pea on pea.cod_pessoa = ope.cod_pessoa_auxiliar
			 where op.executado = 1
				and ope.fecha_execucao = 1
			<cfif Len(Trim(arguments.COD_PESSOA_RESPONSAVEL))>
				and ope.cod_pessoa_principal = #arguments.COD_PESSOA_RESPONSAVEL#
			</cfif>
			<cfif IsDefined("arguments.RECURSO_ID") and arguments.RECURSO_ID neq "">
				and (ope.cod_pessoa_principal in (#arguments.RECURSO_ID#) or
				     ope.cod_pessoa_auxiliar in (#arguments.RECURSO_ID#) )
			</cfif>
			<cfif Len(Trim(arguments.DATA_INICIO)) and Len(Trim(arguments.DATA_TERMINO))>
				and trunc(os.data_abertura) between to_date('#arguments.data_inicio#','dd/mm/yyyy') and to_date('#arguments.data_termino#','dd/mm/yyyy')
			</cfif>
			 group by ope.cod_pessoa_principal, pe.cliente, ope.cod_pessoa_auxiliar,
						 pea.cliente, e.descricao, e.especialidade_id, n.descricao,
						 n.nivel_id) a
			  order by a.cod_pessoa_principal
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Processos para abertos na oficina
	-- NOTAS EXPLICATIVAS
	-- ARLEN 13/12/2006
	--->
	<cffunction name="get_atividade_equipamento" returntype="query" access="remote">
		<cfargument name="ordem_servico_id" required="no" default="">
		<cfargument name="num_ordem_servico" required="no" default="">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct po.tipo, po.ordem_servico_id, po.num_ordem_servico, po.empresa, to_char(po.cod_pessoa_oficina) as cod_pessoa_oficina, po.equipamento_id,
				   po.cod_equipamento,
				   po.cod_equipamento || ' > ' || nvl(po.compartimento,'Veculo')  || ' > ' || nvl(po.grupo,'Veculo') as agrupamento,
				   po.num_ordem_servico, po.grupo_id, nvl(po.grupo,'Veculo') as grupo, po.compartimento_id, nvl(po.compartimento,'Veculo') as compartimento, po.posicao_id,
				   po.posicao, po.atividade, po.processo_id, po.processo, po.executada, po.execucao_id,
				   po.controle_id_processo, po.controle_id_atividade,
				   to_char(po.cod_pessoa_principal) as cod_pessoa_principal, po.principal, to_char(po.cod_pessoa_auxiliar) as cod_pessoa_auxiliar, po.auxiliar,
				   po.data_inicio, po.data_termino, po.tempo_estimado, po.tempo_execucao,
				   po.ordem_processo,
				   os.data_abertura as data_abertura
			  from manutencao.v$processos_oficina po
			 inner join manutencao.v$processo_recurso pr
					 on po.processo_id = pr.processo_id
			 inner join manutencao.v$ordem_servico os
       				 on os.ordem_servico_id = po.ordem_servico_id
			 <cfif len(Trim(atividade_id))>
			 inner join manutencao.v$atividade_processo ap
			 		 on ap.processo_id = po.processo_id
			 inner join manutencao.v$atividade a
            		 on a.atividade_id = ap.atividade_id
			 </cfif>
			 where 1=1
			 <cfif len(Trim(ordem_servico_id))>
			   and po.ordem_servico_id = #arguments.ordem_servico_id#
			 </cfif>
			 <cfif len(Trim(num_ordem_servico))>
			   and po.num_ordem_servico = #arguments.num_ordem_servico#
			 <cfelse>
                <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_fim))>
                   and os.data_abertura between '#LSDateFormat(arguments.data_inicio,'dd/mm/yyyy')#' and '#LSDateFormat(arguments.data_fim,'dd/mm/yyyy')#'
                </cfif>
             </cfif>
			 <cfif len(Trim(equipamento_id))>
			   and po.equipamento_id = #arguments.equipamento_id#
			 </cfif>
			 <cfif len(Trim(atividade_id))>
			   and a.atividade_id in (#arguments.atividade_id#)
			 </cfif>
			 <cfif Len(Trim(arguments.empresa))>
			   and os.empresa= #arguments.empresa#
			 </cfif>
			 order by ordem_servico_id, compartimento, grupo, posicao,  atividade, ordem_processo, data_inicio
 		 </cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
	-- PROPSITO
	-- Busca processos relacionados aos recursos
	-- NOTAS EXPLICATIVAS
	-- ARLEN 18/12/2006
	--->
	<cffunction name="get_processos_recursos" returntype="query" access="remote">
		<cfargument name="ATIVIDADE_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select pr.item_id,
				   pr.processo_id,
				   pr.especialidade_id,
				   pr.nivel_id,
				   pr.quantidade,
				   pr.percentual_participacao,
				   p.titulo as titulo_processo,
				   p.detalhamento,
				   manutencao.to_tempo_execucao(p.tempo_execucao, 3) .retorno as tempo_execucao,
				   a.atividade_id,
				   a.cod_atividade,
				   a.titulo,
				   re.descricao as descricao_especialidade,
				   rn.descricao as descricao_nivel,
				   ag.grupo_id,
				   ag.descricao
			  from manutencao.v$processo_recurso pr
			 inner join manutencao.v$processo p
			 			on pr.processo_id = p.processo_id
			 inner join manutencao.v$atividade_processo ap
			 			on ap.processo_id = p.processo_id
			 inner join manutencao.v$atividade a
			 			on a.atividade_id = ap.atividade_id
			 inner join manutencao.v$recurso_especialidade re
			 			on re.especialidade_id = pr.especialidade_id
			 inner join manutencao.v$recurso_nivel rn
			 			on rn.nivel_id = pr.nivel_id
			 inner join manutencao.v$atividade_grupo ag
            			on ag.grupo_id = a.grupo_id
			 where 1 = 1
 			<cfif len(Trim(arguments.ATIVIDADE_ID))>
			  and a.atividade_id = #arguments.ATIVIDADE_ID#
			</cfif>
			order by ag.descricao, a.titulo, p.titulo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca atividades executadas
	-- NOTAS EXPLICATIVAS
	-- GUTO 31/01/2007
	--->
	<cffunction name="get_atividades_executadas" returntype="query" access="remote">
		<cfargument name="ATIVIDADE_ID" required="no" default="">
		<cfargument name="DATA_INICIO" required="no" default="">
		<cfargument name="DATA_FIM" required="no" default="">
		<cfargument name="PLACA" required="no" default="">
      <cfargument name="HISTORICO" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select placa, ordem_servico_id, num_ordem_servico, atividade, km_execucao,
				   nvl(lag(km_execucao) over(partition by placa order by placa, data_execucao),0) as km_anterior,
				   data_execucao,
				   nvl(lag(data_execucao) over(partition by placa order by placa, data_execucao),data_execucao) as data_anterior
			from (
				  select os.ordem_servico_id,
                         e.cod_equipamento as placa,
                         os.num_ordem_servico,
                         os.data_abertura as data_execucao,
                         a.cod_atividade || '-' || a.titulo as atividade,
                         nvl(os.km_abertura, 0) as km_execucao
                    from manutencao.v$equipamento_atividade ea
                   inner join manutencao.v$atividade a
                      on a.atividade_id = ea.atividade_id
                   inner join manutencao.v$ordem_servico os
                      on os.ordem_servico_id = ea.ordem_servico_id_execucao
                   inner join almoxarifado.v$equipamento e
                      on e.equipamento_id = os.equipamento_id
                   where 1 = 1
                  <cfif len(trim(arguments.ATIVIDADE_ID))>
                    and a.atividade_id = #arguments.ATIVIDADE_ID#
                 </cfif>

                  union

                  select os.ordem_servico_id,
                         e.cod_equipamento as placa,
                         os.num_ordem_servico,
                         os.data_abertura as data_execucao,
                         a.cod_atividade || '-' || a.titulo as atividade,
                         nvl(os.km_abertura, 0) as km_execucao
                    from manutencao.v$equipamento_atividade ea
                   inner join manutencao.v$atividade a
                      on a.atividade_id = ea.atividade_id
                   inner join manutencao.v$ordem_servico os
                      on os.ordem_servico_id = ea.ordem_servico_id_previsao
                   inner join almoxarifado.v$equipamento e
                      on e.equipamento_id = os.equipamento_id

                 <cfif len(trim(arguments.HISTORICO))>
                  union                     
                   select os.ordem_servico_id
                          ,e.placa
                          ,os.num_ordem_servico
                          ,os.data_abertura as data_execucao
                          ,a.cod_atividade || '-' || a.titulo as atividade
                          ,nvl(os.km_abertura, 0) as km_execucao
                      from manutencao.v$ordem_servico os
                     inner join almoxarifado.v$equipamento e
                        on e.equipamento_id = os.equipamento_id                        
                     inner join manutencao.v$equipamento_tabela_manut etm
                        on etm.EQUIPAMENTO_ID = e.equipamento_id                        
                     inner join manutencao.v$tabela_atividade ta
                        on ta.TABELA_ID = etm.TABELA_ID                        
                     left join manutencao.v$atividade a
                        on a.atividade_id = ta.atividade_id
                 </cfif>
                   where 1 = 1
                 <cfif len(trim(arguments.ATIVIDADE_ID))>
                    and a.atividade_id = #arguments.ATIVIDADE_ID#
                 </cfif>
                  )
             where 1=1
			 <cfif Len(Trim(arguments.DATA_INICIO))>
			   and data_execucao >= '#arguments.DATA_INICIO#'
			 </cfif>
			 <cfif Len(Trim(arguments.DATA_FIM))>
			   and data_execucao <= '#arguments.DATA_FIM#'
			 </cfif>
			 <cfif Len(Trim(arguments.PLACA))>
			   and placa = '#arguments.PLACA#'
			 </cfif>
			order by placa, data_execucao
		</cfquery>
	<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Veculos que possuem uma determinada atividade.
	-- NOTAS EXPLICATIVAS
	-- WAGNER 29/12/2006
	--->
	<cffunction name="get_atividade_veiculo" returntype="query" access="remote">
		<cfargument name="ATIVIDADE_ID" required="no" default="">
		<cfargument name="MODALIDADE" required="no" default="">
		<cfargument name="STATUS_ID" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select *
                  from (
                select /*+ ORDERED */
					   r.equipamento_id,
					   r.controle_id,
					   r.cod_equipamento,
					   r.atividade_id,
					   r.posicao_id,
					   r.posicao,
					   r.cod_atividade,
					   r.titulo,
					   r.data_previsao,
					   r.km_previsao,
					   r.importancia,
					   r.alerta_km,
					   r.alerta_dias,
					   r.dias,
					   case
						   when r.ordem_servico_id_execucao is null and
							  r.km_atual_veiculo > r.km_previsao or
							  r.km_previsao < r.km_atual_veiculo or
							  (sysdate > r.data_previsao and
							  manutencao.to_manut_atividade(r.atividade_id, r.modelo_id)
							  .garantia_dias > 0) then -2
						   when r.ordem_servico_id_execucao is null and
							  r.km_atual_veiculo +
							  manutencao.to_manut_atividade(r.atividade_id, r.modelo_id)
							  .alerta_km > r.km_previsao or
							  (sysdate + manutencao.to_manut_atividade(r.atividade_id, r.modelo_id)
							  .alerta_dias > r.data_previsao and
							   manutencao.to_manut_atividade(r.atividade_id, r.modelo_id)
							  .garantia_dias > 0) then -1
						   when r.ordem_servico_id_execucao is null and
							  r.km_atual_veiculo <= r.km_previsao or
							  sysdate <= r.data_previsao then 1
						   else 0 end status_id,
							  r.km_previsao - r.km_atual_veiculo as km_previsto
				  from (select e.equipamento_id,
							   ea.controle_id,
							   e.cod_equipamento,
							   a.atividade_id,
							   ap.posicao_id,
							   nvl(ap.posicao, 'nica') as posicao,
							   a.cod_atividade,
							   a.titulo,
							   ea.data_previsao,
							   ea.km_previsao,
							   a.importancia,
							   ea.ordem_servico_id_execucao,
							   (select nvl(max(km), 0)
								  from oper.v$veiculo_km
								 where placa = e.cod_equipamento
								   and data_hora < sysdate) as km_atual_veiculo,
							   manutencao.to_manut_atividade(ea.atividade_id, em.modelo_id) .alerta_km as alerta_km,
							   manutencao.to_manut_atividade(ea.atividade_id, em.modelo_id) .alerta_dias as alerta_dias,
							   decode(manutencao.to_manut_atividade(ea.atividade_id, em.modelo_id).garantia_dias,0,0,
							   round(ea.data_previsao - sysdate)) as dias, em.modelo_id
						  from manutencao.v$equipamento_atividade ea
                    inner join manutencao.v$equipamento_manutencao em
                            on ea.equipamento_id = em.equipamento_id
                           and em.controla_manutencao = 1
					inner join manutencao.v$atividade a
							on a.atividade_id = ea.atividade_id
					inner join almoxarifado.v$equipamento e
							on e.equipamento_id = ea.equipamento_id
					 left join manutencao.v$equipamento_modelo em
						    on em.equipamento_id = e.equipamento_id
						   and sysdate between em.data_inicial and nvl(em.data_final, sysdate)
					 left join manutencao.v$equipamento_posicao ap

							on ea.posicao_id = ap.posicao_id
						 where 1 = 1
						<cfif Len(Trim(arguments.atividade_id))>
				   		   and a.atividade_id in (#arguments.atividade_id#)
						</cfif>
						<cfif Len(Trim(arguments.importancia))>
						   and a.importancia = #arguments.importancia#
						</cfif>
	  					   and ea.ordem_servico_id_execucao is null
						) r )
                      <cfif Len(Trim(arguments.STATUS_ID))>
                      where status_id = #arguments.STATUS_ID#
                      </cfif>
                      order by cod_atividade, cod_equipamento, posicao, km_previsao
			</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca horas de recursos agrupados, para o RH
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO - 10/04/2007 - criado
	--->
	<cffunction name="get_horas_recursos_agrupado" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
        <cfargument name="recurso_id" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select to_char(t.cod_pessoa) as cod_pessoa, p.cliente as recurso,
				   manutencao.to_tempo_execucao(numtodsinterval(sum(tempo_pago), 'DAY'), 3) .retorno as tempo_pago,
       			   manutencao.to_tempo_execucao(numtodsinterval(sum(tempo_gasto), 'DAY'), 3) .retorno as tempo_gasto,
				   round(sum(valor_servico),2) as valor_total, ro.interna,
                   nvl((select sum(os.km_deslocamento)
                      from manutencao.v$os_atendimento os
                     inner join kss.v$pessoa p
                             on p.cod_pessoa = os.cod_pessoa_mecanico
                     inner join manutencao.v$ordem_servico o
                             on o.ordem_servico_id = os.ordem_servico_id
                     where o.data_abertura >= '#arguments.DATA_INICIO#'
                       and o.data_abertura <= '#arguments.DATA_FIM#'
                       and os.cod_pessoa_mecanico = t.cod_pessoa),0) as km_deslocamento
			  from (
					select /*+ ordered */ pe.cod_pessoa_principal as cod_pessoa,
						   sum(sysdate + ( (decode(op.tempo_execucao_ajustado, to_dsinterval('+000000000 00:00:00'), pe.tempo_execucao, op.tempo_execucao_ajustado)) * (pr.percentual_participacao / 100)) - sysdate) as tempo_pago,             
				           sum(sysdate + (pe.tempo_execucao) - sysdate) as tempo_gasto,
						   sum(round( manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado, to_dsinterval('+000000000 00:00:00'), pe.tempo_execucao, op.tempo_execucao_ajustado)) *(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora, 2) ) as valor_servico
					  from manutencao.v$ordem_servico os
                    inner join manutencao.v$os_processos op
	                  	     on os.ordem_servico_id = op.ordem_servico_id
					inner join manutencao.v$os_processo_execucao pe
							on pe.controle_id = op.controle_id
					inner join manutencao.v$processo_recurso pr
							on pr.item_id = op.processo_recurso_id
					where pe.fecha_execucao = 1
					  and pe.cod_pessoa_auxiliar is null
					  and trunc(pe.data_termino) between '#arguments.data_inicio#' and '#arguments.data_fim#'
					<cfif Len(Trim(arguments.recurso_id))>
                      and pe.cod_pessoa_principal in (#arguments.recurso_id#)
                    </cfif>
					group by pe.cod_pessoa_principal

					UNION ALL

					select /*+ ordered */ pe.cod_pessoa_principal cod_pessoa,
						   sum(sysdate + ( (decode(op.tempo_execucao_ajustado, to_dsinterval('+000000000 00:00:00'), pe.tempo_execucao, op.tempo_execucao_ajustado))  * (pr.percentual_participacao / 100)) - sysdate) as tempo_pago,             
         				   sum(sysdate + (pe.tempo_execucao) - sysdate) as tempo_gasto,
						   sum(round( manutencao.to_tempo_convertido(((decode(op.tempo_execucao_ajustado, to_dsinterval('+000000000 00:00:00'), pe.tempo_execucao, op.tempo_execucao_ajustado))/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora, 2) ) as valor_servico
					  from manutencao.v$ordem_servico os
                    inner join manutencao.v$os_processos op
                    	    on os.ordem_servico_id = op.ordem_servico_id
					inner join manutencao.v$os_processo_execucao pe
							on pe.controle_id = op.controle_id
					inner join manutencao.v$processo_recurso pr
							on pr.item_id = op.processo_recurso_id
					where pe.fecha_execucao = 1
					  and pe.cod_pessoa_auxiliar is not null
					  and trunc(pe.data_termino) between '#arguments.data_inicio#' and '#arguments.data_fim#'
					<cfif Len(Trim(arguments.recurso_id))>
                      and pe.cod_pessoa_principal in (#arguments.recurso_id#)
                    </cfif>
					group by pe.cod_pessoa_principal

					UNION ALL

					select /*+ ordered */  pe.cod_pessoa_auxiliar cod_pessoa,
						   sum(sysdate + ( (decode(op.tempo_execucao_ajustado, to_dsinterval('+000000000 00:00:00'), pe.tempo_execucao, op.tempo_execucao_ajustado)) * (pr.percentual_participacao / 100)) - sysdate) as tempo_pago,             
        				   sum(sysdate + (pe.tempo_execucao) - sysdate) as tempo_gasto,
						   sum(round( manutencao.to_tempo_convertido(((decode(op.tempo_execucao_ajustado, to_dsinterval('+000000000 00:00:00'), pe.tempo_execucao, op.tempo_execucao_ajustado))/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora, 2) ) as valor_servico
					  from manutencao.v$ordem_servico os
                    inner join manutencao.v$os_processos op
                            on os.ordem_servico_id = op.ordem_servico_id
					inner join manutencao.v$os_processo_execucao pe
							on pe.controle_id = op.controle_id
					inner join manutencao.v$processo_recurso pr
							on pr.item_id = op.processo_recurso_id
					where pe.fecha_execucao = 1
					  and pe.cod_pessoa_auxiliar is not null
					  and trunc(pe.data_termino) between '#arguments.data_inicio#' and '#arguments.data_fim#'
					<cfif Len(Trim(arguments.recurso_id))>
                      and pe.cod_pessoa_auxiliar in (#arguments.recurso_id#)
                    </cfif>
					group by pe.cod_pessoa_auxiliar
					  ) t
			  inner join kss.v$pessoa p
					  on p.cod_pessoa = t.cod_pessoa
			  inner join (select distinct r.cod_pessoa as cod_pessoa_funcionario, o.interna
							from manutencao.v$recurso r
						   inner join manutencao.v$recurso_oficina ro
								   on ro.recurso_id = r.recurso_id
						   inner join manutencao.v$oficinas o
								   on o.cod_pessoa = ro.cod_pessoa_oficina
						  where ro.data_fim is null) ro
					  on ro.cod_pessoa_funcionario = p.cod_pessoa
			group by t.cod_pessoa, p.cliente, ro.interna
			order by p.cliente, ro.interna
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os execu��es de Tabelas de manuten��o
	-- NOTAS EXPLICATIVAS
	-- GUTO 13/07/2007
	--->
	<cffunction name="get_tabela_veiculo" returntype="query" access="remote">
    	<cfargument name="tabela_id" required="no" default="">
      <cfargument name="status" required="no" default="">
      <cfargument name="somente_ativos" required="no" default="0">

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select cod_equipamento,
			       placa,
                   tabela,
                   km_atual_veiculo,
                   intervalo_km,
                   case when intervalo_km > 0 then
                      to_char(alerta_km)
                   else
                      'No Controlada'
                   end alerta_km,
                   case when intervalo_km > 0 then
                      to_char(km_previsao)
                   else
                      'No Controlada'
                   end km_previsao,
                   case when intervalo_km > 0 then
                      to_char(km_previsto)
                   else
                      'No Controlada'
                   end km_previsto,
                   case when intervalo_dias > 0 then
                      to_char(data_previsao,'dd/mm/yyyy')
                   else
                      'No Controlada'
                   end data_previsao,
                   case when intervalo_dias > 0 then
                      to_char(alerta_dias)
                   else
                      'No Controlada'
                   end alerta_dias,
                   case when intervalo_dias > 0 then
                      to_char(dias)
                   else
                      'No Controlada'
                   end dias,
                   intervalo_dias,
                   status_id
              from (select cod_equipamento
                         , placa
                         , tabela
                         , data_previsao
                         , km_previsao
                         , km_atual_veiculo
                         , alerta_km
                         , alerta_dias
                         , intervalo_km
                         , intervalo_dias
                         , case
                              when r.ordem_servico_id_execucao is null and r.controle_id is null then
                                 -3
                              when r.ordem_servico_id_execucao is not null and
                                 r.controle_id is not null then
                                 0
                              when r.ordem_servico_id_execucao is null and
                                 ((manutencao.to_veiculo_km(r.cod_equipamento, sysdate, sysdate)
                                 .km_data_inicial > r.km_previsao and r.intervalo_km > 0) or
                                 (sysdate > r.data_previsao and r.intervalo_dias > 0)) then
                                 -2
                              when r.ordem_servico_id_execucao is null and
                                 ((manutencao.to_veiculo_km(r.cod_equipamento, sysdate, sysdate)
                                 .km_data_inicial + manutencao.to_manut_tabela(r.tabela_id)
                                 .alerta_km >= r.km_previsao and r.intervalo_km > 0) or
                                 (sysdate + manutencao.to_manut_tabela(r.tabela_id)
                                 .alerta_dias > r.data_previsao and r.intervalo_dias > 0)) then
                                 -1
                              else
                                 1
                            end status_id
                          , km_previsao - km_atual_veiculo as km_previsto
                          , round(sysdate  - data_previsao) as dias
                      from (select e.cod_equipamento
                                 , e.placa, tm.nome as tabela
                                 , et.ordem_servico_id_execucao
                                 , et.data_previsao
                                 , et.km_previsao
                                 , nvl(manutencao.to_veiculo_km(e.cod_equipamento, sysdate, sysdate).km_data_inicial,0) as km_atual_veiculo
                                 , tm.alerta_km
                                 , tm.alerta_dias
                                 , tm.intervalo_km
                                 , tm.intervalo_dias
                                 , tm.tabela_id
                                 , et.controle_id
                                 ,(select max(km.km)
                                     from oper.v$veiculo_km km
                                    where km.placa = e.placa) as km_data_inicial
                              from almoxarifado.v$equipamento e
                             inner join manutencao.v$equipamento_tabela_manut et
                                     on e.equipamento_id = et.equipamento_id
                             inner join manutencao.v$tabela_manutencao tm
                                     on et.tabela_id = tm.tabela_id
                             where et.ordem_servico_id_execucao is null
                               <cfif Len(Trim(arguments.TABELA_ID))>
                               	and tm.tabela_id in (#arguments.TABELA_ID#)
                               </cfif>
                               <cfif arguments.somente_ativos eq 1>
                               	and e.data_inativacao is null
                               </cfif>
                               ) r)
             where 1=1
             <cfif Len(Trim(arguments.STATUS_ID))>
             	and status_id = #arguments.STATUS_ID#
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!--- 
	-- PROPSITO 
	-- Busca relatrios de materiais
	-- WAGNER  19/02/2007
	--->		
	<cffunction name="get_relatorio_materiais" access="remote" returntype="query" output="true">
		<cfargument name="data_inicial" 			required="no" default="">
		<cfargument name="data_final" 				required="no" default="">
		<cfargument name="material_id" 				required="no" default="">
		<cfargument name="modelo_id" 				required="no" default="">
		<cfargument name="operacao_tipo_id" 		required="no" default="">
		<cfargument name="cod_pessoa_filial" 		required="no" default="">
		<cfargument name="COD_PESSOA_PROPRIETARIO" 	required="no" default="">
		<cfargument name="cod_grupo" 				required="no" default="">
		<cfargument name="cod_equipamento" 			required="no" default="">
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select MATERIAL
                  ,MATERIAL_ID
                  ,OPERACAO_TIPO_ID
                  ,DATA_LANCAMENTO
                  ,QUANTIDADE
                  ,NUM_ORDEM_SERVICO
                  , case
                       when t.operacao_tipo_id = 2 then to_number(t.valor_atributo,'99999999d009999999999999999999999999999999999999999999999999999','nls_numeric_characters=''.,''')
                   else almoxarifado.to_material_estoque(t.material_id).valor_unitario end unitario,
                   case
                       when t.operacao_tipo_id = 2 then t.quantidade * to_number(t.valor_atributo,'99999999d009999999999999999999999999999999999999999999999999999','nls_numeric_characters=''.,''')
                   else t.quantidade * almoxarifado.to_material_estoque(t.material_id).valor_unitario end valor_total
                  ,OPERACAO
                  ,OBSERVACAO
                  ,to_char(COD_PESSOA_FILIAL) as COD_PESSOA_FILIAL
                  ,(select f.nome
                      from oper.v$filial f
                     where f.cod_pessoa = COD_PESSOA_FILIAL) as FILIAL
                  ,EMPRESA
                  ,COD_EQUIPAMENTO
                  ,EQUIPAMENTO_ID
                  ,to_char(COD_PESSOA_PROPRIETARIO) as COD_PESSOA_PROPRIETARIO
                  ,nvl((select f.nome
                          from oper.v$filial f
                         where f.cod_pessoa = COD_PESSOA_PROPRIETARIO)
                       ,kss.pkg_pessoa.fnc_get_cliente(cod_pessoa_proprietario)) as proprietario
                  ,COD_GRUPO
                  ,MODELO_EQUIPAMENTO
                  ,IDENTIFICADOR
                  ,MATERIAL_EQUIPAMENTO
                  ,(select ag.descricao
                      from table(almoxarifado.pkg_almoxarifado.fnc_material_antecessores(material_id)) t
                     inner join almoxarifado.v$material m 
                        on m.material_id = t.material_id
                     inner join manutencao.v$atividade_grupo ag 
                        on ag.grupo_id = m.grupo_id
                     where rownum = 1) as sistema
			 from ( select m.lancamento_id
			             , almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(m.material_id, ' ') as material
						 , m.material_id
						 , m.operacao_tipo_id
						 , m.data_lancamento
						 , m.quantidade
						 , os.num_ordem_servico
						 , round(nvl(om.valor_unitario, almoxarifado.to_material(om.material_id).valor_unitario), 2) as unitario
						 , round(nvl(om.valor_total, almoxarifado.to_material(om.material_id).valor_unitario * om.quantidade), 2) as valor_total
						 , ot.descricao as operacao
						 , m.observacao
						 , m.cod_pessoa_filial
						 , os.empresa
						 , e.cod_equipamento as cod_equipamento
						 , e.equipamento_id as equipamento_id
						 , epv.cod_pessoa_proprietario
						 , manutencao.pkg_manutencao.fnc_placa_grupo(e.equipamento_id,m.data_lancamento) cod_grupo
						 , mo.modelo_id
						 , mo.descricao as modelo_equipamento
						 , manutencao.to_equipamento_dados(m.equipamento_id) .cod_equipamento as identificador
						 , md.descricao_completa as material_equipamento
						 , ma.valor as valor_atributo
                      from almoxarifado.v$movimentacao m 
                     inner join almoxarifado.v$operacao_tipo ot 
                        on ot.operacao_tipo_id = m.operacao_tipo_id
                      left join almoxarifado.v$movimentacao_atributo ma 
                        on ma.lancamento_id = m.lancamento_id
                       and ma.atributo_id = 23
                      left join manutencao.v$os_material om
                        on om.lancamento_id_saida = m.lancamento_id
                      left join manutencao.v$ordem_servico_grupo os
                        on os.ordem_servico_id = om.ordem_servico_id
                      left join almoxarifado.v$equipamento e 
                       on e.equipamento_id = os.equipamento_id
                      left join manutencao.v$equipamento_modelo em 
                        on em.equipamento_id = e.equipamento_id
                       and em.data_final is null                      
                      left join almoxarifado.v$material md
                        on e.material_id = md.material_id
                      left join manutencao.v$modelo mo 
                        on mo.modelo_id = em.modelo_id                      
                      left join almoxarifado.v$equipamento_proprietario ep 
                        on ep.equipamento_id = e.equipamento_id
                       and m.data_lancamento between ep.data_inicio and nvl(ep.date_fim,sysdate)
                      left join almoxarifado.v$equipamento_proprietario epv 
                        on epv.equipamento_id = os.equipamento_id
                       and m.data_lancamento between epv.data_inicio and nvl(ep.date_fim,sysdate)
                     where 1 = 1
                        <cfif len(trim(arguments.MODELO_ID))>
                            and mo.modelo_id = #arguments.MODELO_ID#
                        </cfif>
                        <cfif len(trim(arguments.COD_EQUIPAMENTO))>
                            and e.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
                        </cfif>
                        <cfif (len(trim(arguments.data_inicial)) and len(trim(arguments.data_final)))>				
                            and m.data_lancamento >= '#arguments.data_inicial# 00:00:00'
                            and m.data_lancamento <= '#arguments.data_final# 23:59:59'
                        </cfif>
                        <cfif len(trim(arguments.cod_pessoa_filial))>
                            and m.cod_pessoa_filial = #arguments.cod_pessoa_filial#
                        </cfif>
                        <cfif len(trim(arguments.material_id))>
                            and md.material_id in(#arguments.material_id#)
                        </cfif>					
                        <cfif len(trim(arguments.cod_grupo))>
                            and manutencao.pkg_manutencao.fnc_placa_grupo(e.equipamento_id,m.data_lancamento) in(#ListQualify(arguments.COD_GRUPO,"'")#)
                        </cfif>	) t
				where 1=1
				<cfif len(trim(arguments.operacao_tipo_id))>
                    and operacao_tipo_id = #arguments.operacao_tipo_id#
                </cfif> 
                <cfif len(trim(arguments.COD_PESSOA_PROPRIETARIO))>
                    and cod_pessoa_proprietario = #arguments.cod_pessoa_proprietario#
                </cfif>                                
                order by  DATA_LANCAMENTO
			</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---

	-- PROPSITO
	-- Busca pessoas que s�o proprietarias de equipamentos na empresa
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO - 10/04/2007 - criado
	--->
	<cffunction name="get_proprietarios" displayname="" access="remote" returntype="query" output="true">
    	<cfargument name="controla_manutencao" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
            select to_char(p.cod_pessoa) as cod_pessoa
                 , p.cnpj_cpf
                 , p.identificador
                 , p.inscricao_estadual
                 , p.razao_social
                 , p.cliente
              from manutencao.v$proprietarios p
             where 1 = 1
			<cfif Len(Trim(arguments.controla_manutencao))>
               and (oper.pkg_agregado.fnc_consulta_valor(40, sysdate, p.cod_pessoa, 1) = #arguments.controla_manutencao#
                    or exists (select 1
                                 from kss.v$pessoa_modalidade pm
                                where pm.cod_pessoa = p.cod_pessoa
                                  and pm.num_modalidade in (9,23)
                              )
                   )
			</cfif>
             order by p.cliente
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca materiais inseridos em OSs externas
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO - 10/04/2007 - criado
	--->
	<cffunction name="get_material_externo" displayname="" access="remote" returntype="query" output="true">
		<cfargument name="DATA_INICIO" required="no" default=""/>
		<cfargument name="DATA_FIM" required="no" default=""/>
		<cfargument name="COD_PESSOA_PROPRIETARIO" required="no" default=""/>
		<cfargument name="COD_PESSOA_OFICINA" required="no" default=""/>
		<cfargument name="MATERIAL_ID" required="no" default=""/>
		<cfargument name="COD_EQUIPAMENTO" required="no" default=""/>
		<cfargument name="MODELO_ID" required="no" default=""/>
		<cfargument name="GRUPO" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
              select /*+ ORDERED USE_HASH(OS OM M)  */
                         'Material Externo' as tipo,
                             oper.pkg_pneu.FNC_PLACA_GRUPO(e.cod_equipamento, os.data_abertura) as grupo,
                             m.descricao_completa as material, m.material_id, os.num_ordem_servico,
                   os.data_abertura, om.quantidade, om.valor_unitario,
                   om.valor_total, e.cod_equipamento as placa, to_char(p.cod_pessoa) as cod_pessoa_oficina,
                             p.cliente as oficina, pp.cliente as empresa,
                             mo.descricao as modelo_equipamento, me.descricao_completa as material_equipamento,
                             manutencao.to_equipamento_dados(om.equipamento_id).cod_equipamento as identificador,
                             om.equipamento_id as equipamento_id_montado,
                   (select ag.descricao
                      from table (almoxarifado.pkg_almoxarifado.fnc_material_antecessores(om.material_id)) t
                     inner join almoxarifado.v$material m
                             on m.material_id = t.material_id
                     inner join manutencao.v$atividade_grupo ag
                             on ag.grupo_id = m.grupo_id
                     where rownum = 1) as sistema
                from manutencao.v$ordem_servico_grupo os
               inner join manutencao.v$os_material om
                   on om.ordem_servico_id = os.ordem_servico_id
               inner join almoxarifado.v$material m
                   on m.material_id = om.material_id
               inner join almoxarifado.v$equipamento e
                   on e.equipamento_id = os.equipamento_id
                     inner join almoxarifado.v$material me
                             on me.material_id = e.material_id
               inner join almoxarifado.v$equipamento_proprietario epa
                   on epa.equipamento_id = e.equipamento_id
                   and os.data_abertura between epa.data_inicio and nvl(epa.date_fim,sysdate)
               inner join kss.v$pessoa pp
                   on pp.cod_pessoa = epa.cod_pessoa_proprietario
               inner join kss.v$pessoa p
                   on p.cod_pessoa = os.cod_pessoa_oficina
                     left  join manutencao.v$equipamento_modelo em
                                     on em.equipamento_id = e.equipamento_id
                                    and em.data_final is null
                     left join manutencao.v$modelo mo
                                     on mo.modelo_id = em.modelo_id

              where os.empresa = 0
   			  <cfif Len(Trim(arguments.DATA_INICIO))>
			  	and trunc(os.data_abertura) >= '#arguments.DATA_INICIO#'
			  </cfif>
			  <cfif Len(Trim(arguments.DATA_FIM))>
			  	and trunc(os.data_abertura) <= '#arguments.DATA_FIM#'
			  </cfif>
			  <cfif Len(Trim(arguments.COD_PESSOA_OFICINA))>
				 and os.cod_pessoa_oficina in (#arguments.COD_PESSOA_OFICINA#)
			  </cfif>
			  <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
				 and epa.cod_pessoa_proprietario in (#arguments.COD_PESSOA_PROPRIETARIO#)
			  </cfif>
			  <cfif Len(Trim(arguments.MATERIAL_ID))>
			  	and m.material_id in (#arguments.MATERIAL_ID#)
			  </cfif>
			  <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
			  	and e.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
			  </cfif>

			  <cfif Len(Trim(arguments.MODELO_ID))>
			  	and em.modelo_id = #arguments.MODELO_ID#
			  </cfif>
			  <cfif Len(Trim(arguments.GRUPO))>
			     and os.grupo in(#ListQualify(arguments.GRUPO,"'")#)
			  </cfif>
			order by os.data_abertura
   		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Relatrio de fechamento de custo de OS
	-- NOTAS EXPLICATIVAS
	-- GUTO 26/11/2007
	--->
	<cffunction name="get_os_fechamento_custo" returntype="query" access="remote">
		<cfargument name="data_inicio" required="no" default=""/>
		<cfargument name="data_fim" required="no" default=""/>
		<cfargument name="empresa" required="no" default=""/>
		<cfargument name="socorro" required="no" default=""/>
		<cfargument name="COD_PESSOA_OFICINA" required="no" default=""/>
		<cfargument name="COD_PESSOA_FORNECEDOR" required="no" default=""/>
		<cfargument name="COD_PESSOA_PROPRIETARIO" required="no" default=""/>
		<cfargument name="COD_EQUIPAMENTO_ATRIBUIDO" required="no" default=""/>
		<cfargument name="tipo_tabela_revisao_os" required="no" default=""/>
		<cfargument name="grupo" required="no" default=""/>
		<cfargument name="modelo_id" required="no" default=""/>
		<cfargument name="equipamento_id" required="no" default=""/>
		<cfargument name="cod_equipamento" required="no" default=""/>
		<cfargument name="tipo_ordem_servico_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.ordem_servico_id, o.equipamento_id, o.cod_equipamento,
            	   /*manutencao.to_veiculo_km(o.cod_equipamento,o.data_abertura,o.data_abertura).km_data_inicial as km_abertura,*/
                   o.km_rodado as km_abertura,
                   o.data_abertura, o.grupo, o.data_abertura, o.tipo_os, o.num_nota_fiscal,
                     o.num_ordem_servico, o.custo_servico, o.custo_material,
                     o.modelo, o.material, o.oficina,
                     o.ap.ordem_servico_id as aprop_ordem_servico_id,
                     o.ap.num_ordem_servico as aprop_num_ordem_servico,
                     o.ap.cod_equipamento as aprop_cod_equipamento,
                     o.ap.modelo as aprop_modelo,
                     o.ap.material as aprop_material,
                     o.ap.grupo as aprop_grupo, km_revisao_ct,
                     (select decode(nvl(min(tm.tipo_execucao),0),1,'Completa',2,'Parcial','')
                        from manutencao.v$os_tabela_manutencao ot
                       inner join manutencao.v$tabela_manutencao tm
                               on tm.tabela_id = ot.tabela_id
                       where ot.ordem_servico_id = o.ordem_servico_id
                       and tm.tipo_execucao > 0) as tabela_execucao, o.tipo_ordem_servico
              from ( select os.ordem_servico_id, e.equipamento_id, e.cod_equipamento, nft.num_nota_fiscal, os.km_revisao_ct,
                                             oper.pkg_pneu.fnc_placa_grupo(e.cod_equipamento, os.data_abertura) as grupo,
                                             os.data_abertura,
                                             os.km_rodado,
                                             case
                                                 when os.socorro = 1 then 'Socorro'
                                                 when os.empresa = 1 then 'Atendimento'
                                                 when os.empresa = 0 then 'Externo'
                                             else '' end tipo_os, os.num_ordem_servico,
                                             case
                                               when socorro = 1 then round((select sum((manutencao.to_tempo_convertido(p.tempo_execucao_ajustado).horas * ev.valor_empresa) * pr.percentual_participacao / 100) as valor
                                                              from manutencao.v$os_processos p
                                                              inner join manutencao.v$processo_recurso pr
                                                                  on pr.item_id = p.processo_recurso_id
                                                              inner join manutencao.v$especialidade_valor ev
                                                                  on ev.especialidade_id = pr.especialidade_id
                                                                  and ev.nivel_id = pr.nivel_id
                                                             where p.ordem_servico_id = os.ordem_servico_id),2)
                                               when empresa = 1 then
                                                     nvl((select /*+ ordered */ sum(ova.valor_pago)
                                                            from manutencao.v$os_valor_processo ova
                                                     where ova.ordem_servico_id = os.ordem_servico_id),0)
                                             else os.valor_servico_fechamento end custo_servico,
                                             case
                                               when empresa = 1 then
                                                            nvl((select sum(almoxarifado.to_material_estoque(om.material_id).valor_unitario*om.quantidade)
                                                                   from manutencao.v$os_material om
                                                                  where om.ordem_servico_id = os.ordem_servico_id),0)
                                             else nvl((select sum(om.valor_total)
                                                         from manutencao.v$os_material om
                                                        where om.ordem_servico_id = os.ordem_servico_id),0) end custo_material,
                                             mo.descricao as modelo, m.descricao_completa as material, p.cliente as oficina,
                                             case
                                                 when to_number(m.veiculo) = 1 then null
                                                 when to_number(m.veiculo) = 0 then manutencao.to_os_custo(os.EQUIPAMENTO_ID,os.data_abertura)
                                             end ap,
											 (select tos.descricao
                                                from manutencao.v$tipo_ordem_servico tos
                                               where tos.tipo_ordem_servico_id = os.tipo_ordem_servico_id ) as tipo_ordem_servico
                                    from manutencao.v$ordem_servico os
                                    inner join almoxarifado.v$equipamento e
                                                    on e.equipamento_id = os.equipamento_id
                                    inner join almoxarifado.v$equipamento eat
                                                    on eat.equipamento_id = os.equipamento_id_aprop
                                    inner join almoxarifado.v$material_dados m
                                                    on m.material_id = e.material_id
                                    inner join kss.v$pessoa p
                                                    on p.cod_pessoa = os.cod_pessoa_oficina
                                   <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
                                    inner join almoxarifado.v$equipamento_proprietario epa
                                                    on epa.equipamento_id = os.equipamento_id
                                                   and os.data_abertura between epa.data_inicio and nvl(epa.date_fim,sysdate)
                                    			   and epa.cod_pessoa_proprietario in (select pj.cod_pessoa
                                                                                         from kss.v$pessoa_juridica pj
                                                                                        where cnpj_basico in (select cnpj_basico
                                                                                                                from kss.v$pessoa_juridica
                                                                                                               where cod_pessoa in (#arguments.COD_PESSOA_PROPRIETARIO#)))
                                    </cfif>
                                    left join manutencao.v$equipamento_modelo em
                                                    on em.equipamento_id = e.equipamento_id
                                                 and em.data_final is null

                                    left join manutencao.v$modelo mo
                                                 on mo.modelo_id = em.modelo_id
                                    left join fiscal.v$nf_terceiro nft
                                           on nft.num_nota_id = os.num_nota_id
                                where 1=1
                                <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
                                  and e.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
                                </cfif>
                                <cfif Len(Trim(arguments.COD_EQUIPAMENTO_ATRIBUIDO))>
                                  and eat.cod_equipamento = '#arguments.COD_EQUIPAMENTO_ATRIBUIDO#'
                                </cfif>
                                <cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
                                  and os.equipamento_id = #arguments.EQUIPAMENTO_ID#
                                </cfif>
                                <cfif Len(Trim(arguments.DATA_INICIO))>
                                  and trunc(os.data_abertura) >= '#arguments.DATA_INICIO#'
                                </cfif>
                                <cfif Len(Trim(arguments.DATA_FIM))>
                                  and trunc(os.data_abertura) <= '#arguments.DATA_FIM#'
                                </cfif>
                                <cfif Len(Trim(arguments.COD_PESSOA_OFICINA))>
                                  and os.cod_pessoa_oficina in (#arguments.COD_PESSOA_OFICINA#)
                                </cfif>
                                <cfif Len(Trim(arguments.COD_PESSOA_FORNECEDOR))>
                                  and os.cod_pessoa_oficina in (#arguments.COD_PESSOA_FORNECEDOR#)
                                </cfif>
                                <cfif Len(Trim(arguments.SOCORRO))>
                                  and os.socorro = #arguments.SOCORRO#
                                </cfif>
                                <cfif Len(Trim(arguments.EMPRESA))>
                                  and os.empresa = #arguments.EMPRESA#
                                </cfif>
                                <cfif Len(Trim(arguments.MODELO_ID))>
                                  and em.modelo_id in (#arguments.MODELO_ID#)
                                </cfif>
								<cfif Len(Trim(arguments.tipo_ordem_servico_id))>
								   and os.tipo_ordem_servico_id = #arguments.tipo_ordem_servico_id#
								</cfif>
								<cfif Len(Trim(arguments.tipo_tabela_revisao_os))>
                                    <cfswitch expression="#arguments.tipo_tabela_revisao_os#">
                                       <cfcase value="1">
                                          and exists (select 1
                                                        from manutencao.v$os_tabela_manutencao tm
                                                       inner join manutencao.v$tabela_manutencao t
                                                               on t.tabela_id = tm.tabela_id
                                                              and t.atualiza_revisao = 1
                                                       where tm.ordem_servico_id = os.ordem_servico_id)
                                       </cfcase>
                                       <cfcase value="0">
                                          and not exists (select 1
                                                            from manutencao.v$os_tabela_manutencao tm
                                                           inner join manutencao.v$tabela_manutencao t
                                                                   on t.tabela_id = tm.tabela_id
                                                                  and t.atualiza_revisao = 1
                                                           where tm.ordem_servico_id = os.ordem_servico_id)
                                       </cfcase>
                                     </cfswitch>
                                </cfif>
                                ) o
                                where 1=1
                                <cfif Len(Trim(arguments.grupo))>
                                  and o.grupo in (#ListQualify(arguments.grupo,"'",",")#)
                                </cfif>

        </cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca servicos executados
	-- GUTO  15/02/2007
	--->
	<cffunction name="get_relatorio_atividade" access="remote" returntype="query" output="true">
		<cfargument name="data_inicio" required="no" default="">
		<cfargument name="data_fim" required="no" default="">
		<cfargument name="cod_pessoa_oficina" required="no" default="">
		<cfargument name="grupo" required="no" default="">
		<cfargument name="atividade_id" required="no" default="">
		<cfargument name="empresa" required="no" default="">
		<cfargument name="cod_pessoa_proprietario" required="no" default="">
		<cfargument name="verificacao" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tipo, ordem_servico_id, num_nota_fiscal,grupo, num_ordem_servico, atividade_id, atividade, posicao, data_abertura,
                          importancia, verificacao, grupo_id, compartimento_id, cod_equipamento, filial, empresa,
                          valor_rateio, horas, proprietario, modelo_equipamento, material, sistema,
                          oper.pkg_veiculo.fnc_get_placa(cod_equipamento) placa,
                       case
                        when a.empresa = 1 then
                          round(manutencao.to_tempo_convertido(a.tempo_execucao_ajustado).horas * (select avg(decode(a.empresa,1,ova.valor_empresa,ova.valor_terceiro))
                                                                from manutencao.mv$os_valor_atividade ova
                                                               where ova.ordem_servico_id = a.ordem_servico_id
                                                                and ova.atividade_id = a.atividade_id),2)
                       else 0
                       end valor
                     from (
                   select /*+ USE_HASH(E M) USE_HASH(OS P) */
                                      'Servi�o' as tipo,
                                      os.ordem_servico_id, nft.num_nota_fiscal,
                                      oper.pkg_pneu.FNC_PLACA_GRUPO(e.cod_equipamento, os.data_abertura) as grupo,
                                      os.num_ordem_servico,
                                      a.atividade_id,
                                      a.titulo as atividade,
                                      ep.posicao,
                                      os.data_abertura,
                                      a.importancia,
                                      a.verificacao,
                                      a.grupo_id,
                                      a.compartimento_id,
                                      e.cod_equipamento,
                                      p.cliente as filial, os.empresa,
                                      oa.tempo_execucao_ajustado,
                                      nvl(oa.valor_servico, 0) as valor_rateio,
                                      manutencao.to_tempo_execucao(oa.tempo_execucao_ajustado,3).retorno as horas,
                                      pp.cliente as proprietario, mo.descricao as modelo_equipamento,
                                      m.descricao_completa as material, mg.descricao as sistema
                                  from almoxarifado.v$equipamento e
                                  inner join almoxarifado.v$material m
                                          on m.material_id = e.material_id
                                  inner join manutencao.v$ordem_servico os
                                          on e.equipamento_id = os.equipamento_id
                                  inner join kss.v$pessoa p
                                         on p.cod_pessoa = os.cod_pessoa_oficina
                                  inner join almoxarifado.v$equipamento_proprietario epa
                                      on epa.equipamento_id = e.equipamento_id
                                     and os.data_abertura between epa.data_inicio and nvl(epa.date_fim,sysdate)
                                  inner join kss.v$pessoa pp
                                          on pp.cod_pessoa = epa.cod_pessoa_proprietario
                                  left join manutencao.v$os_atividade oa
                                      on oa.ordem_servico_id = os.ordem_servico_id
                                  left join manutencao.v$atividade a
                                      on a.atividade_id = oa.atividade_id
                                  left join manutencao.v$atividade_grupo mg
                                         on mg.grupo_id = a.grupo_id
                                  left join fiscal.v$nf_terceiro nft
                                         on nft.num_nota_id = os.num_nota_id
                                  left join manutencao.v$equipamento_posicao ep
                                      on nvl(ep.posicao_id,0) = nvl(oa.posicao_id,0)
                                  left join manutencao.v$equipamento_modelo em
                                         on em.equipamento_id = e.equipamento_id
                                        and em.data_final is null
                                  left join manutencao.v$modelo mo
                                         on mo.modelo_id = em.modelo_id
                                   where 1=1
					  <cfif Len(Trim(arguments.DATA_INICIO))>
                       and trunc(os.data_abertura) >= '#arguments.DATA_INICIO#'
                      </cfif>
                      <cfif Len(Trim(arguments.DATA_FIM))>
                       and trunc(os.data_abertura) <= '#arguments.DATA_FIM#'
                      </cfif>
                      <cfif Len(Trim(arguments.ATIVIDADE_ID))>
                       and a.atividade_id in (#arguments.ATIVIDADE_ID#)
                      </cfif>
                      <cfif Len(Trim(arguments.VERIFICACAO))>
                       and a.verificacao = #arguments.VERIFICACAO#
                      </cfif>
                      <cfif Len(Trim(arguments.COD_PESSOA_PROPRIETARIO))>
                       and epa.cod_pessoa_proprietario = #arguments.COD_PESSOA_PROPRIETARIO#
                      </cfif>
                      <cfif Len(Trim(arguments.COD_PESSOA_OFICINA))>
                       and os.cod_pessoa_oficina = #arguments.COD_PESSOA_OFICINA#
                      </cfif>
                      <cfif Len(Trim(arguments.EMPRESA))>
                       and os.empresa = #arguments.EMPRESA#
                      </cfif>
                      <cfif Len(Trim(arguments.COD_EQUIPAMENTO))>
                       and e.cod_equipamento = '#arguments.COD_EQUIPAMENTO#'
                      </cfif>
                      <cfif Len(Trim(arguments.MODELO_ID))>
                       and em.modelo_id = #arguments.MODELO_ID#
                      </cfif>
                               <cfif Len(Trim(arguments.GRUPO))>
                       and oper.pkg_pneu.FNC_PLACA_GRUPO(e.cod_equipamento, os.data_abertura) = '#arguments.GRUPO#'
                      </cfif> ) a
			  order by a.num_ordem_servico
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca todas as atividades vinculadas ao equipamento
	-- NOTAS EXPLICATIVAS
	-- ANDERSON 13/05/2010 - ALTERADO
	--->
	<cffunction name="get_tabela_atividade_posicao" returntype="query" access="remote">
		<cfargument name="TABELA_ID" required="no" default="" >
        <cfargument name="TABELAS_ARVORE" required="no" default="0" >
        <cfargument name="ORDEM_SERVICO_ID" required="no" default="0" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select distinct <cfif arguments.TABELAS_ARVORE eq 0>ta.tabela_id,</cfif> a.atividade_id, a.titulo as atividade, ep.posicao_id, ep.posicao
				   <cfif (Len(Trim(arguments.ORDEM_SERVICO_ID))) and (Len(Trim(arguments.TABELAS_ARVORE))) and (arguments.TABELAS_ARVORE eq 1)>
                   	 , (select oasub.valor_servico
                          from manutencao.v$ordem_servico ossub
                         inner join manutencao.v$os_atividade oasub
                            on oasub.ordem_servico_id = ossub.ordem_servico_id
                         where ossub.ordem_servico_id = #arguments.ORDEM_SERVICO_ID#
                           and oasub.atividade_id = a.atividade_id) as valor_servico
                   </cfif>
                  from manutencao.v$tabela_atividade ta
                 inner join manutencao.v$atividade a
                    on a.atividade_id = ta.atividade_id
                  left join manutencao.v$atividade_posicao ap
                    on ap.atividade_id = a.atividade_id
                  left join manutencao.v$equipamento_posicao ep
                    on ep.posicao_id = nvl(ap.posicao_id,-1)
                 where 1 = 1
			<cfif Len(Trim(arguments.TABELA_ID))>
				<cfif (Len(Trim(arguments.TABELAS_ARVORE))) and arguments.TABELAS_ARVORE eq 0>
                   and ta.tabela_id in (#arguments.TABELA_ID#)
                <cfelseif (Len(Trim(arguments.ORDEM_SERVICO_ID))) and (Len(Trim(arguments.TABELAS_ARVORE))) and (arguments.TABELAS_ARVORE eq 1)>
                   and ta.atividade_id in (select ass.atividade_id
                                             from manutencao.v$ordem_servico os
                                            inner join manutencao.v$os_atividade oa
                                               on oa.ordem_servico_id = os.ordem_servico_id
                                            inner join manutencao.v$atividade ass
                                               on ass.atividade_id = oa.atividade_id
                                            inner join manutencao.v$tabela_atividade ta
                                               on ass.atividade_id = ta.atividade_id
                                             left join manutencao.v$equipamento_posicao ep
                                               on ep.posicao_id = oa.posicao_id
                                            where 1=1
                                              and ass.atividade_id = a.atividade_id
                                              and os.ordem_servico_id = #arguments.ORDEM_SERVICO_ID#
                                            group by ass.atividade_id)
                    or ta.tabela_id in (select tm.tabela_id
                                          from manutencao.v$tabela_manutencao tm
                                         start with tm.tabela_id in (#arguments.TABELA_ID#)
                                       connect by prior tm.tabela_pai = tm.tabela_id)
                <cfelse>
                   and ta.tabela_id in (select tm.tabela_id
                                          from manutencao.v$tabela_manutencao tm
                                         start with tm.tabela_id in (#arguments.TABELA_ID#)
                                       connect by prior tm.tabela_pai = tm.tabela_id)
                </cfif>
            </cfif>
             order by ep.posicao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca dados do fechamento para relatorio
	-- NOTAS EXPLICATIVAS
	-- IGOR 27/10/2008
	--->
	<cffunction name="get_contrato_fechamento_relatorio" returntype="query" access="remote">
		<cfargument name="fechamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
             select fi.item_id,
                oper.pkg_veiculo.fnc_get_cod_veiculo(fi.placa) as cod_equipamento,
                fi.placa,
                f.fechamento_id,
                f.contrato_id,
                fi.km_inicial, fi.km_final, fi.km_final-fi.km_inicial as km_rodado,
                fi.tabela_id, fi.num_faixa, fi.valor_km,
                fi.valor_km * (fi.km_final-fi.km_inicial) as total,
                to_char(f.data_fechamento,'dd/mm/yyyy') as data_fechamento,
                to_char(f.data_inicial,'dd/mm/yyyy') as data_inicial,
                to_char(f.data_final,'dd/mm/yyyy') as data_final,

                nvl(f.valor_acordo,0) valor_acordo, nvl(f.desconto,0) desconto,
                nvl(f.total_acordo,0) as total_acordo, c.titulo as contrato,
                to_char(f.data_inicial,'dd/mm/yyyy') || ' at ' || to_char(f.data_final,'dd/mm/yyyy') as periodo
            from manutencao.v$contrato_fechamento f
            inner join manutencao.v$contrato_fechamento_it fi
                  on fi.fechamento_id = f.fechamento_id
            inner join manutencao.v$contrato_manutencao c
                  on c.contrato_id = f.contrato_id
            where 1=1
             <cfif Len(Trim(arguments.fechamento_id))>
			   and f.fechamento_id = #arguments.fechamento_id#
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca cc_gerecial do equipamento
	-- NOTAS EXPLICATIVAS
	-- JAQUELINEF 04/04/2013
	--->
	<cffunction name="get_organizacional_id" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select  vc.organizacional_id
              from  almoxarifado.v$equipamento e
              inner join oper.v$veiculo_ccusto_gerencial vc
                 on vc.placa = e.PLACA
              where e.EQUIPAMENTO_ID = #arguments.equipamento_id#
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    <!---
	-- PROPSITO
	-- Busca materiais que controlam estoque minimo (AGRUPADOS)

	-- NOTAS EXPLICATIVAS
	-- GUTO 20/09/2006
	--->
	<cffunction name="get_materiais_controlados" returntype="query" access="remote">
		<cfargument name="material_id" required="no" default=""/>
		<cfargument name="material" required="no" default=""/>
		<cfargument name="cod_material" required="no" default=""/>
		<cfargument name="todos" required="no" default="0"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.material_id, m.material_pai, m.cod_material, m.titulo, m.descricao,
				   m.compoe_descricao, m.estoque, m.unidade_estoque, m.unidade_comercializacao,
                   m.identificado, m.material, m.cod_genuino, m.cod_fabricante, m.cod_paralelo,
                   almoxarifado.pkg_almoxarifado.fnc_estoque_material(m.material_id, #session.cod_pessoa#, sysdate) as saldo_estoque
			  from almoxarifado.v$material_dados m
             <cfif arguments.todos eq 0>inner<cfelse>left</cfif> join almoxarifado.v$material_atributo ma
                     on m.material_id = ma.material_id
                    and ma.atributo_id = 5
			 where 1=1
			 <cfif Len(Trim(arguments.material_id))>
			   and m.material_id = #arguments.material_id#
			 </cfif>
			 <cfif Len(Trim(arguments.cod_material))>
			   and ( upper(m.cod_material) like upper('#arguments.cod_material#%')
			      or upper(m.cod_genuino) like upper('#arguments.cod_material#%')
				  or upper(m.cod_fabricante) like upper('#arguments.cod_material#%')
				  or upper(m.cod_paralelo) like upper('#arguments.cod_material#%') )
			 </cfif>
			 <cfif Len(Trim(arguments.material))>
                 and upper(kss.pkg_string.fnc_string_clean(m.material)) like upper('%#arguments.material#%')
             </cfif>
             order by m.material_id
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca ordens de compra cadastradas
	-- NOTAS EXPLICATIVAS
	-- GUTO 19/12/2006
	--->
	<cffunction name="get_ordem_compra" returntype="query" access="remote">
		<cfargument name="NUM_CONTROLE" required="no" default="" >
		<cfargument name="NUM_DOCUMENTO" required="no" default="" >
		<cfargument name="DATA_EMISSAO" required="no" default="" >
		<cfargument name="COD_PESSOA_EMISSAO" required="no" default="" >
		<cfargument name="COD_PESSOA_FORNECEDOR" required="no" default="" >

		<cfargument name="VINCULADA_NOTA" required="no" default="" >
		<cfargument name="APROVADA" required="no" default="" >
		<cfargument name="DATA_FIM" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select oc.titulo,
                   oc.empresa,
                   oc.num_controle,
                   to_char(oc.cod_pessoa_emissao) as cod_pessoa_emissao,
                   em.cliente as emissao,
                   to_char(oc.cod_pessoa_autorizacao) as cod_pessoa_autorizacao,
                   aut.cliente as autorizacao,
                   to_char(oc.data_emissao, 'dd/mm/yyyy') as data_emissao,
                   oc.num_documento,
                   to_char(oc.cod_pessoa_fornecedor) as cod_pessoa_fornecedor,
                   f.cliente as fornecedor,
                   oc.nome_responsavel,
                   oc.condicao_pagto,
                   oc.equipamento_id,
                   manutencao.to_equipamento_dados(oc.equipamento_id, sysdate).placa as placa,
                   oc.km_veiculo,
                   oc.total_orcado,
                   oc.total_desconto,
                   oc.total_combinado,
                   oc.observacao,
                   oc.situacao,
                   oc.vinculada_nota,
                   oc.aprovada,
                   oc.cancelada,
                   (select cnpj_cpf
                      from kss.v$pessoa p
                     where p.cod_pessoa = oc.cod_pessoa_fornecedor) as cnpj_fornecedor,
                   nvl((select sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id)
                                      .valor_total_servicos,
                                      0)) + sum(nvl(manutencao.to_ordem_servico(ooc.ordem_servico_id)
                                                    .valor_total_material,
                                                    0))
                         from manutencao.v$os_ordem_compra ooc
                        where ooc.num_controle = oc.num_controle),
                       0) as total_utilizado_os
              from manutencao.v$ordem_compra oc
             inner join kss.v$pessoa em
                on em.cod_pessoa = oc.cod_pessoa_emissao
             inner join kss.v$pessoa aut
                on aut.cod_pessoa = oc.cod_pessoa_autorizacao
             inner join kss.v$pessoa f
                on f.cod_pessoa = oc.cod_pessoa_fornecedor
             where 1 = 1

			<cfif len(Trim(arguments.APROVADA))>
			  and oc.aprovada = #arguments.APROVADA#
			</cfif>
			<cfif len(Trim(arguments.DATA_FIM))>
			  and oc.data_emissao <= '#arguments.DATA_FIM#'
			</cfif>
			<cfif len(Trim(arguments.NUM_CONTROLE))>
			  and oc.num_controle in (#arguments.NUM_CONTROLE#)
			</cfif>
			<cfif len(Trim(arguments.NUM_DOCUMENTO))>
			  and (oc.num_documento = #arguments.NUM_DOCUMENTO#
			       or oc.num_controle = #arguments.NUM_DOCUMENTO# )
			</cfif>
			<cfif len(Trim(arguments.DATA_EMISSAO))>
			  and trunc(oc.data_emissao) = '#arguments.DATA_EMISSAO#'
			</cfif>
			<cfif len(Trim(arguments.COD_PESSOA_EMISSAO))>
			  and oc.cod_pessoa_emissao = #arguments.COD_PESSOA_EMISSAO#
			</cfif>
			<cfif len(Trim(arguments.COD_PESSOA_FORNECEDOR))>
			  and oc.cod_pessoa_fornecedor = #arguments.COD_PESSOA_FORNECEDOR#
			</cfif>
			order by oc.num_documento, oc.num_controle
		</cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
    -- PROPSITO
    -- Busca itens de ordens de compra cadastradas
    -- NOTAS EXPLICATIVAS
    -- GUTO 19/12/2006
    --->
    <cffunction name="get_ordem_compra_item" returntype="query" access="remote">
    <cfargument name="NUM_CONTROLE" required="no" default="" >
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select oci.num_controle, oci.item_id, oci.descricao, oci.servico_material,
               oci.quantidade, oci.cod_unidade, oci.valor_unitario,
               oci.valor_total
          from manutencao.v$ordem_compra_item oci
         where 1=1
		<cfif len(Trim(arguments.NUM_CONTROLE))>
           and oci.num_controle = #arguments.NUM_CONTROLE#
        </cfif>
    </cfquery>
    <cfreturn qr_result>
    </cffunction>


    <!---
    -- PROPSITO
    -- Retorna ficha de atividades do equipamento
    -- GUTO 29/04/2010 - CRIADO
    --->
    <cffunction name="get_equipamento_ficha_atividade" access="remote" returntype="query" output="true">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="data_inicial" required="no" default="">
        <cfargument name="data_final" required="no" default="">
        <cfargument name="atividade_id" required="no" default="">
        <cfargument name="historico" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.num_ordem_servico, a.ordem_servico_id, a.titulo, to_char(a.data_os,'dd/mm/yyyy') as data_os,
                   decode(km_posterior,null,'Montado','Trocada') as situacao,
                   case
                     when km_posterior is not null then
                          km_posterior - a.km_abertura
                   else manutencao.to_veiculo_km(oper.pkg_veiculo.fnc_get_placa(a.placa), sysdate, sysdate).km_data_inicial - a.km_abertura
                   end rodado,
                   a.km_abertura as km_execucao,
                   nvl(km_posterior,manutencao.to_veiculo_km(oper.pkg_veiculo.fnc_get_placa(a.placa), sysdate, sysdate).km_data_inicial) as km_atual,
                   (select ati.nome
                      from manutencao.v$atividade_tipo ati
                     where ati.tipo_id = av.tipo_id) as tipo,
                   decode(av.importancia,1,'Baixa',2,'Mdia',3,'Alta') as importancia,
                   av.garantia_km, a.equipamento_id, a.placa, a.posicao, vd.marca, vd.modelo, vd.agrupamento, vd.classificacao
              from (select os.num_ordem_servico as num_ordem_servico, os.ordem_servico_id, a.titulo, os.data_abertura as data_os, os.km_abertura,
                           lag(os.km_abertura) over (partition by e.placa,oa.atividade_id,ep.posicao_id order by e.placa, oa.atividade_id,ep.posicao_id, os.data_abertura) as km_anterior,
                           lead(os.km_abertura) over (partition by e.placa,oa.atividade_id,ep.posicao_id order by e.placa, oa.atividade_id,ep.posicao_id, os.data_abertura) as km_posterior,
                           os.equipamento_id, e.placa, oa.posicao_id, ep.posicao, oa.atividade_id
                      from manutencao.v$ordem_servico os
                     inner join manutencao.v$os_atividade oa
                             on oa.ordem_servico_id = os.ordem_servico_id
                     inner join manutencao.v$atividade a
                             on a.atividade_id = oa.atividade_id
                     inner join almoxarifado.v$equipamento e
                             on e.equipamento_id = os.equipamento_id
                     inner join manutencao.v$equipamento_posicao ep
                             on ep.posicao_id = oa.posicao_id
                          <cfif Len(Trim(arguments.ATIVIDADE_ID))>
            		          where oa.atividade_id = #arguments.ATIVIDADE_ID#
                          </cfif>
                    order by e.placa, oa.atividade_id, ep.posicao_id, os.data_abertura) a
             inner join oper.v$veiculo_dados vd
                     on vd.placa = a.placa
             inner join manutencao.v$atividade av
                     on av.atividade_id = a.atividade_id
            where 1=1
            	<cfif Len(Trim(arguments.DATA_INICIAL)) >
                	and trunc(a.data_os) >= '#arguments.DATA_INICIAL#'
                </cfif>
                <cfif Len(Trim(arguments.DATA_FINAL)) >
                	and trunc(a.data_os) <= '#arguments.DATA_FINAL#'
                </cfif>
			    <cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
                  and a.equipamento_id = #arguments.EQUIPAMENTO_ID#
                  <cfif arguments.historico eq 0>
  	                 and km_posterior is null
                  </cfif>
                </cfif>
				<cfif Len(Trim(arguments.EQUIPAMENTO_ID))>
                  <cfif arguments.historico eq 0>
                      order by a.placa, a.data_os, a.atividade_id, a.posicao_id
                  <cfelse>
                     order by a.placa, a.atividade_id, a.posicao_id, a.data_os
                  </cfif>
                <cfelse>
                  order by a.placa, a.atividade_id, a.posicao_id, a.data_os
                </cfif>

        </cfquery>
        <cfreturn qr_result>
    </cffunction>


    <!---
	-- PROPSITO
	-- Busca Veculos p/ manuten��o/controle de estoque
	-- JAQUELINEF 18/10/2013
	--->
	<cffunction name="get_veiculos" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
        <cfargument name="placa" required="no" default="">
		<cfargument name="sem_modelo" required="no" default="0">
        <cfargument name="equipamento" required="no" default="">
        <cfargument name="analisados" required="no" default="">
	    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select m.equipamento_id
                 , m.cod_equipamento
                 , m.placa
                 , ma.material
                 , (select ce.contrato_id
                      from manutencao.v$contrato_equipamento ce
                     where ce.equipamento_id = m.equipamento_id
                       and ce.data_termino is null) as contrato_id
                  , vm.marca
                  , vmo.modelo
              from almoxarifado.v$equipamento m
             inner join oper.v$veiculo v
                on v.cod_veiculo = m.cod_equipamento
             inner join oper.v$veiculo_marca vm
                on vm.marca_id =v.marca_id
             inner join almoxarifado.v$material_dados ma
                     on ma.material_id = m.material_id
             inner join oper.v$veiculo_modelo vmo
                on vmo.modelo_id = v.modelo_id
            <cfif Len(trim(arguments.analisados))>
              left join manutencao.v$equipamento_analise ea
                     on ea.equipamento_id = m.equipamento_id
            </cfif>
             where 1 = 1
            <cfif Len(Trim(arguments.equipamento_id))>
               and m.equipamento_id = #arguments.equipamento_id#
            </cfif>
            <cfif Len(Trim(arguments.cod_equipamento))>
               and m.cod_equipamento = '#arguments.cod_equipamento#'
            </cfif>
            <cfif Len(Trim(arguments.placa))>
               and (m.cod_equipamento = '#arguments.placa#'
                    or m.placa = oper.pkg_veiculo.fnc_get_placa('#arguments.placa#')
                   )
            </cfif>
            <cfif arguments.sem_modelo eq 1>
               and not exists (select 'x'
                                 from manutencao.v$equipamento_modelo em
                                where em.equipamento_id = m.equipamento_id
                                  and em.data_final is null)
            </cfif>
            <cfif Len(trim(arguments.equipamento))>
               and upper(ma.material) like upper('%#arguments.equipamento#%')
            </cfif>
            <cfif Len(trim(arguments.analisados))>
               and ea.data_analise is null
            </cfif>
             order by ma.material, m.cod_equipamento
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna de custo de manutencao
	-- SERVICOS EXTERNOS
	-- IGOR 10/11/2008
	--->
    <cffunction name="get_custo_retorno_variavel" returntype="query" access="remote">
        <cfargument name="data_inicio" required="no" default=""/>
        <cfargument name="data_fim" required="no" default=""/>
        <cfargument name="tipo_id" required="no" default="-1"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mes_ano, ano_mes, sum(valor)/decode(max(num_veiculos),0,1,max(num_veiculos)) as valor
              from (select to_char(os.data,'mm/yyyy') as mes_ano,
                           to_char(os.data,'yyyymm') as ano_mes,
                           sum(os.valor) as valor, min(manutencao.pkg_manutencao.fnc_veiculos_ativos(os.data)) as num_veiculos
                      from manutencao.v$custo_retorno_lancamento os
                     inner join manutencao.custo_retorno_tipo r on r.tipo_id = os.tipo_id
                     where r.d_c = #arguments.tipo_id#
              <cfif Len(Trim(arguments.data_inicio))>
                    and os.data >= '#arguments.data_inicio#'
              </cfif>
              <cfif Len(Trim(arguments.data_fim))>
                    and os.data <= '#arguments.data_fim#'
              </cfif>
                group by to_char(os.data,'mm/yyyy'),
                         to_char(os.data,'yyyymm')
 			  <cfif Len(Trim(arguments.data_inicio))>
                union all

                select to_char(data,'mm/yyyy') as mes_ano,
                       to_char(data,'yyyymm') as ano_mes,
                             0 as valor, 0
                from (select add_months(sysdate,-1*(level-1)) as data
                        from dual connect by level <= 30)
                where 1=1
                  <cfif Len(Trim(arguments.data_inicio))>
                        and data >= '#arguments.data_inicio#'
                  </cfif>
                  <cfif Len(Trim(arguments.data_fim))>
    					and to_date(to_char(data, 'mm/yyyy'), 'mm/yyyy') <= to_date(to_char(to_date('#arguments.data_fim#', 'dd/mm/yyyy'), 'mm/yyyy'), 'mm/yyyy')
                  </cfif>
              </cfif>
                )
            group by mes_ano, ano_mes
                order by ano_mes
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna os dados do tipo de custo
	-- NOTAS EXPLICATIVAS
	-- IGOR 06/11/2008
	--->
	<cffunction name="get_num_veiculos" returntype="query" access="remote">
        <cfargument name="equipamento_id" required="no" default=""/>
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>
        <cfargument name="data_fim" required="no" default=""/>
        <cfargument name="marca_id" required="no" default=""/>
        <cfargument name="modelo_id" required="no" default=""/>
        <cfargument name="ano" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
          select sum(total_veiculos) as total_veiculos, mes_ano, ano_mes
			from
				(select count(e.cod_equipamento) as total_veiculos,
                        dt.mes_ano, dt.ano_mes
                        from almoxarifado.v$equipamento e
                        inner join (select vei.placa,
                                           (select max(vhs.situacao_id) keep(dense_rank last order by vhs.data)
                                              from oper.v$veiculo_hist_situacao vhs
                                             where vhs.placa = vei.placa
                                               and vhs.data <= nvl2('#arguments.data_inicio#', sysdate, '#arguments.data_inicio#')
                                           ) as situacao_id
                                      from oper.v$veiculo vei
                                     inner join oper.v$veiculo_modelo vmo
                                             on vmo.marca_id = vei.marca_id
                                            and vmo.modelo_id = vei.modelo_id
                                     inner join oper.v$veiculo_marca vma
                                             on vma.marca_id = vei.marca_id
                                     inner join oper.v$veiculo_tipo_controle vet
                                             on vet.tipo_carroceria_id = vei.tipo_carroceria_id
                                     inner join oper.v$veiculo_ultimo_km vkm
                                             on vkm.placa = vei.placa
                                  <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                                      inner join oper.v$veiculo_proprietario vp
                                              on vp.placa = vei.placa
                                             and vp.data_fim is null
                                             and vp.cod_pessoa in (select pj.cod_pessoa
                                                                     from kss.v$pessoa_juridica pj
                                                                    where cnpj_basico in (select cnpj_basico
                                                                                            from kss.v$pessoa_juridica
                                                                                           where cod_pessoa in (#arguments.cod_pessoa_proprietario#)))
                                  </cfif>
                                  where 1=1
                                  <cfif Len(Trim(arguments.MARCA_ID))>
                                    and vei.marca_id = #arguments.MARCA_ID#
                                  </cfif>
                                  <cfif Len(Trim(arguments.MODELO_ID))>
                                    and vei.modelo_id in (#arguments.MODELO_ID#)
                                  </cfif>
                                  <cfif Len(Trim(arguments.ANO))>
                                    and vei.ano = #arguments.ANO#
                                  </cfif>
                                  <cfif Len(Trim(arguments.equipamento_id))>
                                    and vei.placa = (select e.cod_equipamento
                                                     from almoxarifado.v$equipamento e
                                                    where e.equipamento_id = #arguments.equipamento_id#)
                                  </cfif>) vc
                                on vc.placa = e.cod_equipamento,
                                  (select to_char(data,'mm/yyyy') as mes_ano,
                                                         to_char(data,'yyyymm') as ano_mes,
                                                         0 as valor
                                                  from (select add_months(trunc(last_day(sysdate))-1, -1 * (level - 1)) as data
                                                          from dual
                                                        connect by level <= 30)
                                                  where 1=1
                                                  <cfif Len(Trim(arguments.data_inicio))>
                                                        and data >= '#arguments.data_inicio#'
                                                  </cfif>
                                                  <cfif Len(Trim(arguments.data_fim))>
                                                        and to_date('01/'||to_char(data,'mm/yyyy')) <= to_date('01/'||to_char(to_date('#arguments.data_fim#','dd/mm/yyyy'),'mm/yyyy'))
                                                  </cfif>
                                                    ) dt
                               where e.data_inativacao is null
                                  or (e.data_inativacao > to_date(dt.mes_ano,'mm/yyyy') and vc.situacao_id = 0)
                                  group by dt.mes_ano, dt.ano_mes

                            union

                            select 0 as valor, to_char(data,'mm/yyyy') as mes_ano,
                                   to_char(data,'yyyymm') as ano_mes

                            from (select add_months(sysdate,-1*(level-1)) as data
                                    from dual connect by level <= 30)
                            where 1=1
                              <cfif Len(Trim(arguments.data_inicio))>
                                    and data >= '#arguments.data_inicio#'
                              </cfif> )
				group by mes_ano, ano_mes
                      order by ano_mes
        </cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna de custo de manutencao
	-- SERVICOS INTERNOS
	-- Guto 01/08/2008
	--->
    <cffunction name="get_custo_empresa_servico" returntype="query" access="remote">
        <cfargument name="equipamento_id" required="no" default=""/>
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>
        <cfargument name="data_inicio" required="no" default=""/>
        <cfargument name="data_fim" required="no" default=""/>
        <cfargument name="marca_id" required="no" default=""/>
        <cfargument name="modelo_id" required="no" default=""/>
        <cfargument name="ano" required="no" default=""/>
		<cfquery name="qr_parametros" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select to_number(kss.pkg_global.fnc_obtem_parametro_str(11,'OPERACIONAL',30,1))/100 as perc_encargos,
               to_number(kss.pkg_global.fnc_obtem_parametro_str(11,'OPERACIONAL',30,2))/100 as perc_geral
		  from dual
  	    </cfquery>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select mes_ano
                , ano_mes
                , sum(valor) as valor
                , sum(valor_agregado) as valor_agregado
             from (select to_char(op.data_termino,'mm/yyyy') as mes_ano
                        , to_char(op.data_termino,'yyyymm') as ano_mes
                        , case
                             when op.empresa = 1 then
                               (valor_pago + (valor_pago * #qr_parametros.perc_encargos#)) + ((valor_pago + (valor_pago * #qr_parametros.perc_encargos#)) * #qr_parametros.perc_geral#)
                           	 else (valor_pago + (valor_pago * #qr_parametros.perc_geral#)) end valor
                        , case
                             when op.empresa = 1 and not exists (select 1
                                                                    from kss.v$pessoa_juridica pj
                                                                   where cnpj_basico in (select cnpj_basico
                                                                                           from kss.v$pessoa_juridica
                                                                                          where cod_pessoa in (otv.cod_pessoa_proprietario))) then
                               (valor_pago + (valor_pago * #qr_parametros.perc_encargos#)) + ((valor_pago + (valor_pago * #qr_parametros.perc_encargos#)) * #qr_parametros.perc_geral#)
                             when op.empresa = 0 and not exists (select 1
                                                                    from kss.v$pessoa_juridica pj
                                                                   where cnpj_basico in (select cnpj_basico
                                                                                           from kss.v$pessoa_juridica
                                                                                          where cod_pessoa in (otv.cod_pessoa_proprietario))) then
                               (valor_pago + (valor_pago * #qr_parametros.perc_geral#))
                             else 0 end valor_agregado
                     from manutencao.v$ordem_servico os
                    inner join manutencao.v$ordem_servico_tipo_veiculo otv
                            on otv.ordem_servico_id = os.ordem_servico_id
                    inner join manutencao.v$os_valor_processo op
                            on op.ordem_servico_id = os.ordem_servico_id
                    inner join almoxarifado.v$equipamento_proprietario ep
                            on ep.equipamento_id = os.equipamento_id
                           and os.data_abertura between ep.data_inicio and nvl(ep.date_fim,sysdate)
                    where os.empresa = 1
          <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
              and ep.cod_pessoa_proprietario in (select pj.cod_pessoa
                                                   from kss.v$pessoa_juridica pj
                                                  where cnpj_basico in (select cnpj_basico
                                                                          from kss.v$pessoa_juridica
                                                                         where cod_pessoa in (#arguments.cod_pessoa_proprietario#)))
          </cfif>
		  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
              and op.equipamento_id in (select e2.equipamento_id
                                          from almoxarifado.v$equipamento e2
                                         inner join oper.v$veiculo v
                                                 on v.placa = e2.cod_equipamento
                                         where 1=1
									   <cfif Len(Trim(arguments.MARCA_ID))>
                                           and v.marca_id = #arguments.MARCA_ID#
                                       </cfif>
                                       <cfif Len(Trim(arguments.MODELO_ID))>
                                           and v.modelo_id in (#arguments.MODELO_ID#)
                                       </cfif>
                                       <cfif Len(Trim(arguments.ANO))>
                                           and v.ano = #arguments.ANO#
                                       </cfif>
                                       )
          </cfif>
          <cfif Len(Trim(arguments.equipamento_id))>
              and os.equipamento_id = #arguments.equipamento_id#
          </cfif>
          <cfif Len(Trim(arguments.data_inicio))>
              and trunc(op.data_termino) >= '#arguments.data_inicio#'
          </cfif>
          <cfif Len(Trim(arguments.data_fim))>
              and trunc(op.data_termino) <= '#arguments.data_fim#'
          </cfif>
            group by op.controle_id, to_char(op.data_termino,'mm/yyyy'), to_char(op.data_termino,'yyyymm'), op.valor_pago, op.empresa, otv.proprietario, otv.cod_pessoa_proprietario
          <cfif Len(Trim(arguments.data_inicio & arguments.data_fim))>
                union all
                select to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'mm/yyyy') as mes_ano
                     , to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') as ano_mes
                     , 0 as valor
                     , 0 as valor_agregado
                  from dual
                 connect by to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') <= to_char(to_date('#arguments.data_fim#'),'yyyymm')
          </cfif>
            )
            group by mes_ano, ano_mes
            order by ano_mes
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna de custo de manutencao
	-- SERVICOS EXTERNOS
	-- Guto 01/08/2008
	--->
    <cffunction name="get_custo_externo_servico" returntype="query" access="remote">
        <cfargument name="equipamento_id" required="no" default=""/>
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>
        <cfargument name="data_inicio" required="no" default=""/>
        <cfargument name="data_fim" required="no" default=""/>
        <cfargument name="marca_id" required="no" default=""/>
        <cfargument name="modelo_id" required="no" default=""/>
        <cfargument name="ano" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mes_ano, ano_mes, sum(valor) as valor
            from (
            select to_char(os.data_abertura,'mm/yyyy') as mes_ano,
                     to_char(os.data_abertura,'yyyymm') as ano_mes,
                             sum(os.valor_servico) as valor
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento_proprietario ep
                     on ep.equipamento_id = os.equipamento_id
                    and os.data_abertura between ep.data_inicio and nvl(ep.date_fim,sysdate)
				 <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                 and ep.cod_pessoa_proprietario in (select pj.cod_pessoa
                                                      from kss.v$pessoa_juridica pj
                                                     where cnpj_basico in (select cnpj_basico
                                                                             from kss.v$pessoa_juridica
                                                                            where cod_pessoa in (#arguments.cod_pessoa_proprietario#)))
                 </cfif>
                 where os.empresa = 0
			  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                 and os.equipamento_id in (select e2.equipamento_id
                                             from almoxarifado.v$equipamento e2
                                             inner join oper.v$veiculo v
                                                     on v.placa = e2.cod_equipamento
                                             where 1=1
                                               <cfif Len(Trim(arguments.MARCA_ID))>
                                                 and v.marca_id = #arguments.MARCA_ID#
                                               </cfif>
                                               <cfif Len(Trim(arguments.MODELO_ID))>
                                                 and v.modelo_id in (#arguments.MODELO_ID#)
                                               </cfif>
                                               <cfif Len(Trim(arguments.ANO))>
                                                 and v.ano = #arguments.ANO#
                                               </cfif>
                                           )
              </cfif>
              <cfif Len(Trim(arguments.equipamento_id))>
                  and os.equipamento_id_aprop = #arguments.equipamento_id#
              </cfif>
              <cfif Len(Trim(arguments.data_inicio))>
                    and os.data_abertura >= '#arguments.data_inicio#'
              </cfif>
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(os.data_abertura) <= '#arguments.data_fim#'
              </cfif>
                group by to_char(os.data_abertura,'mm/yyyy'),
                         to_char(os.data_abertura,'yyyymm')
 			  <cfif Len(Trim(arguments.data_inicio & arguments.data_fim))>
                union all

                select to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'mm/yyyy') as mes_ano,
                       to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') as ano_mes,
                       0 as valor
                  from dual
                 connect by to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') <= to_char(to_date('#arguments.data_fim#'),'yyyymm')

              </cfif>
                )
            group by mes_ano, ano_mes
                order by ano_mes
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna de custo de manutencao
	-- EMPRESA PE�AS
	-- Guto 01/08/2008
	--->
    <cffunction name="get_custo_empresa_pecas" returntype="query" access="remote">
        <cfargument name="equipamento_id" required="no" default=""/>
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>
        <cfargument name="data_inicio" required="no" default=""/>
        <cfargument name="data_fim" required="no" default=""/>
        <cfargument name="marca_id" required="no" default=""/>
        <cfargument name="modelo_id" required="no" default=""/>
        <cfargument name="ano" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mes_ano, ano_mes, sum(valor) as valor
              from (
            select to_char(mv.data_lancamento,'mm/yyyy') as mes_ano,
                     to_char(mv.data_lancamento,'yyyymm') as ano_mes,
                             sum(om.VALOR_TOTAL) as valor
              from manutencao.v$ordem_servico os
             inner join manutencao.v$os_material om
                     on om.ordem_servico_id = os.ordem_servico_id
             inner join almoxarifado.v$movimentacao mv
                     on mv.lancamento_id = om.lancamento_id_saida
             inner join almoxarifado.v$equipamento_proprietario ep
                     on ep.equipamento_id = os.equipamento_id
                    and os.data_abertura between ep.data_inicio and nvl(ep.date_fim,sysdate)
				 <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                 and ep.cod_pessoa_proprietario in (select pj.cod_pessoa
                                                      from kss.v$pessoa_juridica pj
                                                     where cnpj_basico in (select cnpj_basico
                                                                             from kss.v$pessoa_juridica
                                                                            where cod_pessoa in (#arguments.cod_pessoa_proprietario#)))
                 </cfif>
             where os.empresa = 1
			  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                 and os.equipamento_id_aprop in (select e2.equipamento_id
                                             from almoxarifado.v$equipamento e2
                                             inner join oper.v$veiculo v
                                                     on v.placa = e2.cod_equipamento
                                             where 1=1
                                               <cfif Len(Trim(arguments.MARCA_ID))>
                                                 and v.marca_id = #arguments.MARCA_ID#
                                               </cfif>
                                               <cfif Len(Trim(arguments.MODELO_ID))>
                                                 and v.modelo_id in (#arguments.MODELO_ID#)
                                               </cfif>
                                               <cfif Len(Trim(arguments.ANO))>
                                                 and v.ano = #arguments.ANO#
                                               </cfif>
                                           )
              </cfif>
              <cfif Len(Trim(arguments.data_inicio))>
                    and mv.data_lancamento >= '#arguments.data_inicio#'
              </cfif>
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(mv.data_lancamento) <= '#arguments.data_fim#'
              </cfif>
              <cfif Len(Trim(arguments.equipamento_id))>
                  and os.equipamento_id = #arguments.equipamento_id#
              </cfif>
            group by to_char(mv.data_lancamento,'mm/yyyy'),
                     to_char(mv.data_lancamento,'yyyymm')

            union all

            select /*+ordered */to_char(m.data_lancamento,'mm/yyyy') as mes_ano,
                   to_char(m.data_lancamento,'yyyymm') as ano_mes,
                   sum((select nvl(round(to_number(ma.valor,'99999999d0099999999999','nls_numeric_characters=''.,'''),3),0)
                          from almoxarifado.v$movimentacao_atributo ma
                         where ma.lancamento_id = m.lancamento_id
                                       and ma.atributo_id = 3)*m.quantidade) as valor_venda
              from almoxarifado.v$movimentacao m
             inner join almoxarifado.v$movimentacao_equipamento me
                     on me.lancamento_id = m.lancamento_id
             inner join almoxarifado.v$equipamento_proprietario ep
                     on ep.equipamento_id = me.equipamento_id
                    and m.data_lancamento between ep.data_inicio and nvl(ep.date_fim,sysdate)
				 <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                 and ep.cod_pessoa_proprietario in (select pj.cod_pessoa
                                                      from kss.v$pessoa_juridica pj
                                                     where cnpj_basico in (select cnpj_basico
                                                                             from kss.v$pessoa_juridica
                                                                            where cod_pessoa in (#arguments.cod_pessoa_proprietario#)))
                 </cfif>
             where m.operacao_tipo_id = 3
			  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                 and me.equipamento_id in (select e2.equipamento_id
                                             from almoxarifado.v$equipamento e2
                                             inner join oper.v$veiculo v
                                                     on v.placa = e2.cod_equipamento
                                             where 1=1
                                               <cfif Len(Trim(arguments.MARCA_ID))>
                                                 and v.marca_id = #arguments.MARCA_ID#
                                               </cfif>
                                               <cfif Len(Trim(arguments.MODELO_ID))>
                                                 and v.modelo_id in (#arguments.MODELO_ID#)
                                               </cfif>
                                               <cfif Len(Trim(arguments.ANO))>
                                                 and v.ano = #arguments.ANO#
                                               </cfif>
                                           )
              </cfif>

               and not exists (select 1
                                   from manutencao.v$os_material mo
                                                     where mo.lancamento_id_saida = m.lancamento_id)
               and m.data_lancamento > '01/01/2007'
              <cfif Len(Trim(arguments.equipamento_id))>
                  and me.equipamento_id = #arguments.equipamento_id#
              </cfif>
              <cfif Len(Trim(arguments.data_inicio))>
                    and m.data_lancamento >= '#arguments.data_inicio#'
              </cfif>
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(m.data_lancamento) <= '#arguments.data_fim#'
              </cfif>
            group by to_char(m.data_lancamento,'mm/yyyy'),
                     to_char(m.data_lancamento,'yyyymm')

 			  <cfif Len(Trim(arguments.data_inicio & arguments.data_fim))>
                union all

                select to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'mm/yyyy') as mes_ano,

                       to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') as ano_mes,
                       0 as valor
                  from dual
                 connect by to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') <= to_char(to_date('#arguments.data_fim#'),'yyyymm')

              </cfif>

            )
            group by mes_ano, ano_mes
            order by ano_mes
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna de custo de manutencao
	-- EXTERNOS PE�AS
	-- Guto 01/08/2008
	--->
    <cffunction name="get_custo_externo_pecas" returntype="query" access="remote">
        <cfargument name="equipamento_id" required="no" default=""/>
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>
        <cfargument name="data_inicio" required="no" default=""/>
        <cfargument name="data_fim" required="no" default=""/>
        <cfargument name="marca_id" required="no" default=""/>
        <cfargument name="modelo_id" required="no" default=""/>
        <cfargument name="ano" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                select mes_ano, ano_mes, sum(valor) as valor
              from (select to_char(os.data_abertura,'mm/yyyy') as mes_ano,
                       to_char(os.data_abertura,'yyyymm') as ano_mes,
                       sum(om.valor_total) as valor
                  from manutencao.v$ordem_servico os
                 inner join manutencao.v$os_material om
                         on om.ordem_servico_id = os.ordem_servico_id
                 inner join almoxarifado.v$equipamento_proprietario ep
                         on ep.equipamento_id = os.equipamento_id
                                and os.data_abertura between ep.data_inicio and nvl(ep.date_fim,sysdate)
				 <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                        and ep.cod_pessoa_proprietario in (select pj.cod_pessoa
                                                             from kss.v$pessoa_juridica pj
                                                            where cnpj_basico in (select cnpj_basico
                                                                                    from kss.v$pessoa_juridica
                                                                                   where cod_pessoa in (#arguments.cod_pessoa_proprietario#)))
                 </cfif>
                where os.empresa = 0
			  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                 and os.equipamento_id_aprop in (select e2.equipamento_id
                                             from almoxarifado.v$equipamento e2
                                             inner join oper.v$veiculo v
                                                     on v.placa = e2.cod_equipamento
                                             where 1=1
                                               <cfif Len(Trim(arguments.MARCA_ID))>
                                                 and v.marca_id = #arguments.MARCA_ID#
                                               </cfif>
                                               <cfif Len(Trim(arguments.MODELO_ID))>
                                                 and v.modelo_id in (#arguments.MODELO_ID#)
                                               </cfif>
                                               <cfif Len(Trim(arguments.ANO))>
                                                 and v.ano = #arguments.ANO#
                                               </cfif>
                                           )
              </cfif>

              <cfif Len(Trim(arguments.equipamento_id))>
                  and os.equipamento_id = #arguments.equipamento_id#
              </cfif>
              <cfif Len(Trim(arguments.data_inicio))>
                    and os.data_abertura >= '#arguments.data_inicio#'
              </cfif>
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(os.data_abertura) <= '#arguments.data_fim#'
              </cfif>
                group by to_char(os.data_abertura,'mm/yyyy'),
                         to_char(os.data_abertura,'yyyymm')
 			  <cfif Len(Trim(arguments.data_inicio & arguments.data_fim))>
                union all

                select to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'mm/yyyy') as mes_ano,
                       to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') as ano_mes,
                       0 as valor
                  from dual
                 connect by to_char(add_months(to_date('#arguments.data_inicio#'),level-1),'yyyymm') <= to_char(to_date('#arguments.data_fim#'),'yyyymm')

              </cfif>
                )
            group by mes_ano, ano_mes
                order by ano_mes
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna de custo de manutencao
	-- ORDENS DE COMPRA
	-- Guto 01/08/2008
	--->
    <cffunction name="get_custo_projetado_ordem_compra" returntype="query" access="remote">
        <cfargument name="equipamento_id" required="no" default=""/>
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>
        <cfargument name="data_inicio" required="no" default=""/>
        <cfargument name="data_fim" required="no" default=""/>
        <cfargument name="marca_id" required="no" default=""/>
        <cfargument name="modelo_id" required="no" default=""/>
        <cfargument name="ano" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
               select ano_mes, mes_ano, sum(valor) as valor
                 from (select to_char(t.data_emissao,'mm/yyyy') as mes_ano,
                              to_char(t.data_emissao,'yyyymm') as ano_mes,
                              sum(t.total_combinado) as valor
                         from manutencao.v$ordem_compra t
                      <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                        inner join almoxarifado.v$equipamento_proprietario ep
                                on ep.equipamento_id = t.equipamento_id
                               and t.data_emissao between ep.data_inicio and nvl(ep.date_fim,sysdate)
                               and ep.cod_pessoa_proprietario in (select pj.cod_pessoa
                                                                    from kss.v$pessoa_juridica pj
                                                                   where cnpj_basico in (select cnpj_basico
                                                                                           from kss.v$pessoa_juridica
                                                                                          where cod_pessoa in (#arguments.cod_pessoa_proprietario#)))
                      </cfif>
                        where t.aprovada = 1
                          and t.cancelada = 0
                          and not exists (select 1
                                            from manutencao.v$nf_terceiro_ordem_compra nf
                                           where nf.num_controle = t.num_controle)
              <cfif Len(Trim(arguments.equipamento_id))>
                  and t.equipamento_id = #arguments.equipamento_id#
              <cfelse>
                  and t.equipamento_id is not null
				  <cfif Len(Trim(arguments.MARCA_ID)) or Len(Trim(arguments.MODELO_ID)) or Len(Trim(arguments.ANO))>
                     and t.equipamento_id in (select e2.equipamento_id
                                                 from almoxarifado.v$equipamento e2
                                                 inner join oper.v$veiculo v
                                                         on v.placa = e2.cod_equipamento
                                                 where 1=1
                                                   <cfif Len(Trim(arguments.MARCA_ID))>
                                                     and v.marca_id = #arguments.MARCA_ID#
                                                   </cfif>
                                                   <cfif Len(Trim(arguments.MODELO_ID))>
                                                     and v.modelo_id in (#arguments.MODELO_ID#)
                                                   </cfif>
                                                   <cfif Len(Trim(arguments.ANO))>
                                                     and v.ano = #arguments.ANO#
                                                   </cfif>
                                               )
                  </cfif>
              </cfif>
              <cfif Len(Trim(arguments.data_inicio))>
                    and t.data_emissao >= '#arguments.data_inicio#'
              </cfif>
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(t.data_emissao) <= '#arguments.data_fim#'
              </cfif>
                group by to_char(t.data_emissao,'mm/yyyy'),
                         to_char(t.data_emissao,'yyyymm')
			  union all
                select to_char(data,'mm/yyyy') as mes_ano,
                       to_char(data,'yyyymm') as ano_mes,
                             0 as valor
                from (select add_months(sysdate,-1*(level-1)) as data
                        from dual connect by level <= 30)
                where 1=1
              <cfif Len(Trim(arguments.data_inicio))>
                    and data >= '#arguments.data_inicio#'
              </cfif>
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(data) <= '#arguments.data_fim#'
              </cfif>
				)
                group by ano_mes, mes_ano
                order by ano_mes
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna de custo de manutencao
	-- KM RODADO FROTA
	-- Guto 01/08/2008
	--->
    <cffunction name="get_km_rodado_frota" returntype="query" access="remote">
        <cfargument name="equipamento_id" required="no" default=""/>
        <cfargument name="cod_pessoa_proprietario" required="no" default=""/>
        <cfargument name="data_inicio" required="no" default=""/>
        <cfargument name="data_fim" required="no" default=""/>
        <cfargument name="marca_id" required="no" default=""/>
        <cfargument name="modelo_id" required="no" default=""/>
        <cfargument name="ano" required="no" default=""/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select mes_ano, ano_mes, sum(km_rodado) as km_rodado, sum(num_veiculos) as num_veiculos
              from (select to_char(mes,'mm/yyyy') as mes_ano,
                           to_char(mes,'yyyymm') as ano_mes,
                           sum(km_rodado) as km_rodado,
                           count(*) as num_veiculos
                      from (select x.placa, x.mes, kf.km-ki.km km_rodado
                      from (select a.placa, a.ultima_data, a.mes,
                                   lag(a.ultima_data, 1, (select max(t.data_hora)
                                                            from oper.v$veiculo_km t
                                                           where 1=1
                                                             and t.data_hora <= a.mes
                                                             and t.placa = a.placa)) over (partition by placa order by a.ultima_data) primeira_data
                             from(select t.placa, max(t.data_hora) ultima_data, trunc(data_hora, 'month') mes
                                    from oper.v$veiculo_km t
                                   inner join oper.v$veiculo_proprietario vp
                                           on vp.placa = t.placa
                                          and t.data_hora between vp.data_inicio and nvl(vp.data_fim,sysdate)
									   <cfif Len(Trim(arguments.cod_pessoa_proprietario))>
                                          and vp.cod_pessoa in (select pj.cod_pessoa
                                                                  from kss.v$pessoa_juridica pj
                                                                 where cnpj_basico in (select cnpj_basico
                                                                                         from kss.v$pessoa_juridica
                                                                                        where cod_pessoa in (#arguments.cod_pessoa_proprietario#)))
                                       </cfif>
                                         inner join oper.v$veiculo_dados v
                                                 on v.placa = t.placa
                                         inner join oper.v$veiculo_tracao vt
                                                 on vt.tipo_carroceria_id = v.tipo_carroceria_id
                                   where 1=1
									  <cfif Len(Trim(arguments.MARCA_ID))>
                                         and v.marca_id = #arguments.MARCA_ID#
                                      </cfif>
                                      <cfif Len(Trim(arguments.MODELO_ID))>
                                         and v.modelo_id in (#arguments.MODELO_ID#)
                                      </cfif>
                                      <cfif Len(Trim(arguments.ANO))>
                                         and v.ano = #arguments.ANO#
                                      </cfif>
									  <cfif Len(Trim(arguments.equipamento_id))>
                                         and t.placa = (select e.cod_equipamento
                                                          from almoxarifado.v$equipamento e
                                                          where e.equipamento_id = #arguments.equipamento_id#)
                                      </cfif>
								      <cfif Len(Trim(arguments.data_inicio))>
                                         and trunc(t.data_hora) >= to_date('#arguments.data_inicio#','dd/mm/yyyy')
                                      </cfif>
									  <cfif Len(Trim(arguments.data_fim))>
                                         and trunc(t.data_hora) <= '#arguments.data_fim#'
                                      </cfif>
                                   group by t.placa, trunc(data_hora, 'month'))a )x
                     inner join oper.v$veiculo_km ki
                             on ki.placa = x.placa
                            and ki.data_hora = x.primeira_data
                     inner join oper.v$veiculo_km kf
                             on kf.placa = x.placa
                            and kf.data_hora = x.ultima_data
                     group by x.placa, x.mes, kf.km-ki.km)
                     group by to_char(mes,'yyyymm'), to_char(mes,'mm/yyyy')
			  union all
                select to_char(data,'mm/yyyy') as mes_ano,
                       to_char(data,'yyyymm') as ano_mes,
                       0 as km_rodado,
                       0 as num_veiculos
                from (select add_months(sysdate,-1*(level-1)) as data
                        from dual connect by level <= 30)
                where 1=1
              <cfif Len(Trim(arguments.data_inicio))>
                    and data >= '#arguments.data_inicio#'
              </cfif>
              <cfif Len(Trim(arguments.data_fim))>
                    and trunc(data) <= '#arguments.data_fim#'
              </cfif>
				)
                group by ano_mes, mes_ano
                order by ano_mes
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Processos executados pelo recurso no periodo
	-- NOTAS EXPLICATIVAS
	-- GUTO 15/12/2006
	--->
	<cffunction name="get_recurso_processos" returntype="query" access="remote">
		<cfargument name="COD_PESSOA" required="yes" >
		<cfargument name="DATA_INICIO" required="yes" >
		<cfargument name="DATA_TERMINO" required="yes" >
		<cfargument name="ESPECIALIDADE_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.tipo, t.num_ordem_servico, t.cod_equipamento, to_char(t.cod_pessoa) as cod_pessoa,
				   t.processo, t.especialidade, t.nivel,
				   t.nivel_especialidade,
                   manutencao.to_tempo_execucao(numtodsinterval(decode(t.tempo_execucao,0,t.tempo_gasto,t.tempo_execucao), 'DAY'), 3) .retorno as tempo_execucao,
                   manutencao.to_tempo_execucao(numtodsinterval(t.tempo_gasto, 'DAY'), 3) .retorno as tempo_gasto,
                   manutencao.to_tempo_execucao(numtodsinterval(sum(decode(t.tempo_execucao, 0, t.tempo_gasto, t.tempo_execucao)) over(), 'DAY'), 3) .retorno as tempo_execucao_total,
                   manutencao.to_tempo_execucao(numtodsinterval(sum(t.tempo_gasto) over(), 'DAY'), 3) .retorno as tempo_gasto_total,
				   t.valor_servico,
				   round(sum(t.valor_servico) over(),2) as valor_servico_total,
                   sum(t.valor_servico) over(partition by t.num_ordem_servico order by t.num_ordem_servico) as valor_total_os,
                   executado_mes
			  from (
					select /*+ first_rows_1000 */ 'Individual' as tipo, os.num_ordem_servico, e.cod_equipamento, pe.cod_pessoa_principal as cod_pessoa, p.titulo as processo,
						   re.descricao as especialidade, rn.descricao as nivel,
						   re.descricao || rn.descricao as nivel_especialidade,
						   sysdate + (op.tempo_execucao_ajustado * (pr.percentual_participacao / 100)) - sysdate as tempo_execucao,
					       sysdate + (pe.tempo_execucao) - sysdate as tempo_gasto,
						   round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado))*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora,2) as valor_servico,
                           case
                             when '#arguments.DATA_INICIO#' >= pe.DATA_TERMINO then 0
                           else 1 end executado_mes
					  from manutencao.v$ordem_servico os
					 inner join almoxarifado.v$equipamento e
							 on e.equipamento_id = os.equipamento_id
					 inner join manutencao.v$os_processos op
							 on os.ordem_servico_id = op.ordem_servico_id
					 inner join manutencao.v$processo p
							 on p.processo_id = op.processo_id
					 inner join manutencao.v$os_processo_execucao pe
							 on pe.controle_id = op.controle_id
					 inner join manutencao.v$processo_recurso pr
							 on pr.item_id = op.processo_recurso_id
					 inner join manutencao.v$recurso_especialidade re
							 on re.especialidade_id = pr.especialidade_id
					 inner join manutencao.v$recurso_nivel rn
							 on rn.nivel_id = pr.nivel_id
					 inner join kss.v$pessoa p
							 on p.cod_pessoa = pe.cod_pessoa_principal
					where pe.fecha_execucao = 1
					  and pe.cod_pessoa_auxiliar is null
					  and trunc(pe.data_termino) between '#arguments.DATA_INICIO#' and '#arguments.DATA_TERMINO#'
					  and p.cod_pessoa = #arguments.COD_PESSOA#
					<cfif Len(Trim(arguments.especialidade_id))>
					  and re.especialidade_id = #arguments.especialidade_id#
					</cfif>

					UNION ALL

					select /*+ first_rows_1000 */ 'Auxiliado' as tipo, os.num_ordem_servico, e.cod_equipamento,
						   pe.cod_pessoa_principal as cod_pessoa, p.titulo as processo,
						   re.descricao as especialidade, rn.descricao as nivel,
						   re.descricao || rn.descricao as nivel_especialidade,
						   sysdate + ((op.tempo_execucao_ajustado/2) * (pr.percentual_participacao / 100)) - sysdate as tempo_execucao,
					       sysdate + (pe.tempo_execucao/2) - sysdate as tempo_gasto,
						   round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado)/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora,2) as valor_servico,
                           case
                             when '#arguments.data_inicio#' >= pe.data_termino then 0
                           else 1 end executado_mes
					  from manutencao.v$ordem_servico os
					 inner join almoxarifado.v$equipamento e
							 on e.equipamento_id = os.equipamento_id
					 inner join manutencao.v$os_processos op
							 on os.ordem_servico_id = op.ordem_servico_id
					 inner join manutencao.v$processo p
							 on p.processo_id = op.processo_id
					 inner join manutencao.v$os_processo_execucao pe
							 on pe.controle_id = op.controle_id
					 inner join manutencao.v$processo_recurso pr
							 on pr.item_id = op.processo_recurso_id
					 inner join manutencao.v$recurso_especialidade re
							 on re.especialidade_id = pr.especialidade_id
					 inner join manutencao.v$recurso_nivel rn
							 on rn.nivel_id = pr.nivel_id
					 inner join kss.v$pessoa p
							 on p.cod_pessoa = pe.cod_pessoa_principal
					where pe.fecha_execucao = 1
					  and pe.cod_pessoa_auxiliar is not null
					  and trunc(pe.data_termino) between '#arguments.DATA_INICIO#' and '#arguments.DATA_TERMINO#'
					  and p.cod_pessoa = #arguments.COD_PESSOA#
					<cfif Len(Trim(arguments.especialidade_id))>
					  and re.especialidade_id = #arguments.especialidade_id#
					</cfif>

					UNION ALL

					select /*+ first_rows_1000 */ 'Auxiliar' as tipo, os.num_ordem_servico, e.cod_equipamento, pe.cod_pessoa_auxiliar as cod_pessoa, p.titulo as processo,
						   re.descricao as especialidade, rn.descricao as nivel,
						   re.descricao || rn.descricao as nivel_especialidade,
						   sysdate + ((op.tempo_execucao_ajustado/2) * (pr.percentual_participacao / 100)) - sysdate as tempo_execucao,
					       sysdate + (pe.tempo_execucao/2) - sysdate as tempo_gasto,
						   round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado)/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pe.cod_pessoa_principal,pr.especialidade_id, pr.nivel_id, pe.data_termino).valor_hora,2) as valor_servico,
                           case
                             when '#arguments.DATA_INICIO#' >= pe.DATA_TERMINO then 0
                           else 1 end executado_mes
					  from manutencao.v$ordem_servico os
					 inner join almoxarifado.v$equipamento e
							 on e.equipamento_id = os.equipamento_id
					 inner join manutencao.v$os_processos op
							 on os.ordem_servico_id = op.ordem_servico_id
					 inner join manutencao.v$processo p
							 on p.processo_id = op.processo_id
					 inner join manutencao.v$os_processo_execucao pe
							 on pe.controle_id = op.controle_id
					 inner join manutencao.v$processo_recurso pr
							 on pr.item_id = op.processo_recurso_id
					 inner join manutencao.v$recurso_especialidade re
							 on re.especialidade_id = pr.especialidade_id
					 inner join manutencao.v$recurso_nivel rn
							 on rn.nivel_id = pr.nivel_id
					 inner join kss.v$pessoa p
							 on p.cod_pessoa = pe.cod_pessoa_auxiliar
					where pe.fecha_execucao = 1
					  and trunc(pe.data_termino) between '#arguments.DATA_INICIO#' and '#arguments.DATA_TERMINO#'
					  and p.cod_pessoa = #arguments.COD_PESSOA#
					<cfif Len(Trim(arguments.especialidade_id))>
					  and re.especialidade_id = #arguments.especialidade_id#
					</cfif>) t
                     order by num_ordem_servico, nivel_especialidade
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca lista de processos executados pelo recurso no periodo
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 02/09/2014
	--->
	<cffunction name="get_recurso_processos_lista" returntype="query" access="remote">
		<cfargument name="COD_PESSOA" required="no" default="">
		<cfargument name="DATA_INICIO" required="yes" >
		<cfargument name="DATA_TERMINO" required="yes" >
		<cfargument name="ESPECIALIDADE_ID" required="no" default="" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select y.tipo
                 , max(y.tempo_execucao) as tempo_execucao
                 , max(y.tempo_gasto) as tempo_gasto
                 , max(y.tempo_execucao_geral) as tempo_execucao_geral
                 , max(y.tempo_gasto_geral) as tempo_gasto_geral
                 , y.mecanico
                 , to_char(y.cod_pessoa) as cod_pessoa
              from (
                select t.tipo
                     , manutencao.to_tempo_execucao(numtodsinterval( sum(nvl(nullif(t.tempo_execucao, 0), t.tempo_gasto) ) over(partition by t.cod_pessoa, t.tipo) , 'DAY'), 4).retorno as tempo_execucao
                     , manutencao.to_tempo_execucao(numtodsinterval(sum(t.tempo_gasto) over(partition by t.cod_pessoa, t.tipo), 'DAY'), 4).retorno as tempo_gasto
                     , manutencao.to_tempo_execucao(numtodsinterval(sum(nvl(nullif(t.tempo_execucao, 0), t.tempo_gasto) ) over() , 'DAY'), 4).retorno as tempo_execucao_geral
                     , manutencao.to_tempo_execucao(numtodsinterval(sum(t.tempo_gasto) over(), 'DAY'), 4).retorno as tempo_gasto_geral
                     , kss.pkg_pessoa.fnc_get_cliente(t.cod_pessoa) as mecanico
                     , t.cod_pessoa
                  from (
                        select /*+ first_rows_1000 */ 'Individual' as tipo, os.num_ordem_servico, e.cod_equipamento, pe.cod_pessoa_principal as cod_pessoa, p.titulo as processo,
                               re.descricao as especialidade, rn.descricao as nivel,
                               re.descricao || rn.descricao as nivel_especialidade,
                               sysdate + (op.tempo_execucao_ajustado) - sysdate as tempo_execucao,
                               sysdate + (pe.tempo_execucao * (pr.percentual_participacao / 100)) - sysdate as tempo_gasto,
                               round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado))*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora,2) as valor_servico,
                               case
                                 when '#arguments.DATA_INICIO# 00:00:00' >= pe.DATA_TERMINO then 0
                               else 1 end executado_mes
                          from manutencao.v$ordem_servico os
                         inner join almoxarifado.v$equipamento e
                                 on e.equipamento_id = os.equipamento_id
                         inner join manutencao.v$os_processos op
                                 on os.ordem_servico_id = op.ordem_servico_id
                         inner join manutencao.v$processo p
                                 on p.processo_id = op.processo_id
                         inner join manutencao.v$os_processo_execucao pe
                                 on pe.controle_id = op.controle_id
                         inner join manutencao.v$processo_recurso pr
                                 on pr.item_id = op.processo_recurso_id
                         inner join manutencao.v$recurso_especialidade re
                                 on re.especialidade_id = pr.especialidade_id
                         inner join manutencao.v$recurso_nivel rn
                                 on rn.nivel_id = pr.nivel_id
                         inner join kss.v$pessoa p
                                 on p.cod_pessoa = pe.cod_pessoa_principal
                        where pe.fecha_execucao = 1
                          and pe.cod_pessoa_auxiliar is null
                          and trunc(pe.data_termino) between '#arguments.DATA_INICIO# 00:00:00' and '#arguments.DATA_TERMINO# 23:59:59'
                        <cfif Len(Trim(arguments.COD_PESSOA))>
                          and p.cod_pessoa = #arguments.COD_PESSOA#
                        </cfif>
                        <cfif Len(Trim(arguments.especialidade_id))>
                          and re.especialidade_id = #arguments.especialidade_id#
                        </cfif>

                        UNION ALL

                        select /*+ first_rows_1000 */ 'Auxiliado' as tipo, os.num_ordem_servico, e.cod_equipamento,
                               pe.cod_pessoa_principal as cod_pessoa, p.titulo as processo,
                               re.descricao as especialidade, rn.descricao as nivel,
                               re.descricao || rn.descricao as nivel_especialidade,
                               sysdate + (op.tempo_execucao_ajustado) - sysdate as tempo_execucao,
                               sysdate + (pe.tempo_execucao * (pr.percentual_participacao / 100)) - sysdate as tempo_gasto,
                               round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado)/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora,2) as valor_servico,
                               case
                                 when '#arguments.data_inicio#' >= pe.data_termino then 0
                               else 1 end executado_mes
                          from manutencao.v$ordem_servico os
                         inner join almoxarifado.v$equipamento e
                                 on e.equipamento_id = os.equipamento_id
                         inner join manutencao.v$os_processos op
                                 on os.ordem_servico_id = op.ordem_servico_id
                         inner join manutencao.v$processo p
                                 on p.processo_id = op.processo_id
                         inner join manutencao.v$os_processo_execucao pe
                                 on pe.controle_id = op.controle_id
                         inner join manutencao.v$processo_recurso pr
                                 on pr.item_id = op.processo_recurso_id
                         inner join manutencao.v$recurso_especialidade re
                                 on re.especialidade_id = pr.especialidade_id
                         inner join manutencao.v$recurso_nivel rn
                                 on rn.nivel_id = pr.nivel_id
                         inner join kss.v$pessoa p
                                 on p.cod_pessoa = pe.cod_pessoa_principal
                        where pe.fecha_execucao = 1
                          and pe.cod_pessoa_auxiliar is not null
                          and trunc(pe.data_termino) between '#arguments.DATA_INICIO# 00:00:00' and '#arguments.DATA_TERMINO# 23:59:59'
                        <cfif Len(Trim(arguments.COD_PESSOA))>
                          and p.cod_pessoa = #arguments.COD_PESSOA#
                        </cfif>
                        <cfif Len(Trim(arguments.especialidade_id))>
                          and re.especialidade_id = #arguments.especialidade_id#
                        </cfif>

                        UNION ALL

                        select /*+ first_rows_1000 */ 'Auxiliar' as tipo, os.num_ordem_servico, e.cod_equipamento, pe.cod_pessoa_auxiliar as cod_pessoa, p.titulo as processo,
                               re.descricao as especialidade, rn.descricao as nivel,

                               re.descricao || rn.descricao as nivel_especialidade,
                               sysdate + (op.tempo_execucao_ajustado) - sysdate as tempo_execucao,
                               sysdate + (pe.tempo_execucao * (pr.percentual_participacao / 100)) - sysdate as tempo_gasto,
                               round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado)/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pe.cod_pessoa_principal,pr.especialidade_id, pr.nivel_id, pe.data_termino).valor_hora,2) as valor_servico,
                               case
                                 when '#arguments.DATA_INICIO#' >= pe.DATA_TERMINO then 0
                               else 1 end executado_mes
                          from manutencao.v$ordem_servico os
                         inner join almoxarifado.v$equipamento e
                                 on e.equipamento_id = os.equipamento_id
                         inner join manutencao.v$os_processos op
                                 on os.ordem_servico_id = op.ordem_servico_id
                         inner join manutencao.v$processo p
                                 on p.processo_id = op.processo_id
                         inner join manutencao.v$os_processo_execucao pe
                                 on pe.controle_id = op.controle_id
                         inner join manutencao.v$processo_recurso pr
                                 on pr.item_id = op.processo_recurso_id
                         inner join manutencao.v$recurso_especialidade re
                                 on re.especialidade_id = pr.especialidade_id
                         inner join manutencao.v$recurso_nivel rn
                                 on rn.nivel_id = pr.nivel_id
                         inner join kss.v$pessoa p
                                 on p.cod_pessoa = pe.cod_pessoa_auxiliar
                        where pe.fecha_execucao = 1
                          and trunc(pe.data_termino) between '#arguments.DATA_INICIO# 00:00:00' and '#arguments.DATA_TERMINO# 23:59:59'
                        <cfif Len(Trim(arguments.COD_PESSOA))>
                          and p.cod_pessoa = #arguments.COD_PESSOA#
                        </cfif>
                        <cfif Len(Trim(arguments.especialidade_id))>
                          and re.especialidade_id = #arguments.especialidade_id#
                        </cfif>) t
                      ) y
                group by y.tipo, y.cod_pessoa, y.mecanico
                order by y.mecanico, y.tipo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca lista de processos executados pelo recurso no periodo
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 02/09/2014
	--->
	<cffunction name="get_recurso_processos_lista_detalhado" returntype="query" access="remote">
		<cfargument name="COD_PESSOA" required="no">
		<cfargument name="DATA_INICIO" required="yes" >
		<cfargument name="DATA_TERMINO" required="yes" >
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select t.tipo
                 , t.num_ordem_servico
                 , t.cod_equipamento
                 , t.placa
                 , to_char(t.cod_pessoa) as cod_pessoa
                 , t.processo
                 , t.especialidade
                 , t.nivel
                 , manutencao.to_tempo_execucao(numtodsinterval(decode(t.tempo_execucao,0,t.tempo_gasto,t.tempo_execucao), 'DAY'), 4).retorno as tempo_execucao
                 , manutencao.to_tempo_execucao(numtodsinterval(t.tempo_gasto, 'DAY'), 4).retorno as tempo_gasto
                 , kss.pkg_pessoa.fnc_get_cliente(t.cod_pessoa) as mecanico
                 , to_char(t.data_inicio, 'dd/mm/yyy hh24:mi') as data_inicio
                 , to_char(t.data_termino, 'dd/mm/yyy hh24:mi') as data_termino
                 , t.percentual_participacao
			  from (
					select /*+ first_rows_1000 */ 'Individual' as tipo, os.num_ordem_servico, e.cod_equipamento, pe.cod_pessoa_principal as cod_pessoa, p.titulo as processo,
						   re.descricao as especialidade, rn.descricao as nivel,
						   re.descricao || rn.descricao as nivel_especialidade,
						   sysdate + (op.tempo_execucao_ajustado) - sysdate as tempo_execucao,
                           sysdate + (pe.tempo_execucao * (pr.percentual_participacao / 100)) - sysdate as tempo_gasto,
                           round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado))*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora,2) as valor_servico,
                           case
                             when '#arguments.DATA_INICIO#' >= pe.DATA_TERMINO then 0
                           else 1 end executado_mes
                           , pe.data_inicio, pe.data_termino, pr.percentual_participacao, e.placa
					  from manutencao.v$ordem_servico os
					 inner join almoxarifado.v$equipamento e
							 on e.equipamento_id = os.equipamento_id
					 inner join manutencao.v$os_processos op
							 on os.ordem_servico_id = op.ordem_servico_id
					 inner join manutencao.v$processo p
							 on p.processo_id = op.processo_id
					 inner join manutencao.v$os_processo_execucao pe
							 on pe.controle_id = op.controle_id
					 inner join manutencao.v$processo_recurso pr
							 on pr.item_id = op.processo_recurso_id
					 inner join manutencao.v$recurso_especialidade re
							 on re.especialidade_id = pr.especialidade_id
					 inner join manutencao.v$recurso_nivel rn
							 on rn.nivel_id = pr.nivel_id
					 inner join kss.v$pessoa p
							 on p.cod_pessoa = pe.cod_pessoa_principal
					where pe.fecha_execucao = 1
					  and pe.cod_pessoa_auxiliar is null
					  and trunc(pe.data_termino) between '#arguments.DATA_INICIO#' and '#arguments.DATA_TERMINO#'
					<cfif Len(Trim(arguments.COD_PESSOA))>
                      and p.cod_pessoa = #arguments.COD_PESSOA#
					</cfif>

					UNION ALL

					select /*+ first_rows_1000 */ 'Auxiliado' as tipo, os.num_ordem_servico, e.cod_equipamento,
						   pe.cod_pessoa_principal as cod_pessoa, p.titulo as processo,
						   re.descricao as especialidade, rn.descricao as nivel,
						   re.descricao || rn.descricao as nivel_especialidade,
						   sysdate + (op.tempo_execucao_ajustado) - sysdate as tempo_execucao,
                           sysdate + (pe.tempo_execucao * (pr.percentual_participacao / 100)) - sysdate as tempo_gasto,
						   round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado)/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pr.especialidade_id, pr.nivel_id, pe.data_inicio,os.empresa).valor_hora,2) as valor_servico,
                           case
                             when '#arguments.data_inicio#' >= pe.data_termino then 0
                           else 1 end executado_mes
                           , pe.data_inicio, pe.data_termino, pr.percentual_participacao, e.placa
					  from manutencao.v$ordem_servico os
					 inner join almoxarifado.v$equipamento e
							 on e.equipamento_id = os.equipamento_id
					 inner join manutencao.v$os_processos op
							 on os.ordem_servico_id = op.ordem_servico_id
					 inner join manutencao.v$processo p
							 on p.processo_id = op.processo_id
					 inner join manutencao.v$os_processo_execucao pe
							 on pe.controle_id = op.controle_id
					 inner join manutencao.v$processo_recurso pr
							 on pr.item_id = op.processo_recurso_id
					 inner join manutencao.v$recurso_especialidade re
							 on re.especialidade_id = pr.especialidade_id
					 inner join manutencao.v$recurso_nivel rn
							 on rn.nivel_id = pr.nivel_id
					 inner join kss.v$pessoa p
							 on p.cod_pessoa = pe.cod_pessoa_principal
					where pe.fecha_execucao = 1
					  and pe.cod_pessoa_auxiliar is not null
					  and trunc(pe.data_termino) between '#arguments.DATA_INICIO#' and '#arguments.DATA_TERMINO#'
					<cfif Len(Trim(arguments.COD_PESSOA))>
                      and p.cod_pessoa = #arguments.COD_PESSOA#
					</cfif>

					UNION ALL

					select /*+ first_rows_1000 */ 'Auxiliar' as tipo, os.num_ordem_servico, e.cod_equipamento, pe.cod_pessoa_auxiliar as cod_pessoa, p.titulo as processo,
						   re.descricao as especialidade, rn.descricao as nivel,
						   re.descricao || rn.descricao as nivel_especialidade,
						   sysdate + (op.tempo_execucao_ajustado) - sysdate as tempo_execucao,
                           sysdate + (pe.tempo_execucao * (pr.percentual_participacao / 100)) - sysdate as tempo_gasto,
                           round(manutencao.to_tempo_convertido((decode(op.tempo_execucao_ajustado,to_dsinterval('+000000000 00:00:00'),pe.tempo_execucao,op.tempo_execucao_ajustado)/2)*(pr.percentual_participacao/100)).horas * manutencao.to_recurso_valor(pe.cod_pessoa_principal,pr.especialidade_id, pr.nivel_id, pe.data_termino).valor_hora,2) as valor_servico,
                           case
                             when '#arguments.DATA_INICIO#' >= pe.DATA_TERMINO then 0
                           else 1 end executado_mes
                           , pe.data_inicio, pe.data_termino, pr.percentual_participacao, e.placa
					  from manutencao.v$ordem_servico os
					 inner join almoxarifado.v$equipamento e
							 on e.equipamento_id = os.equipamento_id
					 inner join manutencao.v$os_processos op
							 on os.ordem_servico_id = op.ordem_servico_id
					 inner join manutencao.v$processo p
							 on p.processo_id = op.processo_id
					 inner join manutencao.v$os_processo_execucao pe
							 on pe.controle_id = op.controle_id
					 inner join manutencao.v$processo_recurso pr
							 on pr.item_id = op.processo_recurso_id
					 inner join manutencao.v$recurso_especialidade re
							 on re.especialidade_id = pr.especialidade_id
					 inner join manutencao.v$recurso_nivel rn
							 on rn.nivel_id = pr.nivel_id
					 inner join kss.v$pessoa p
							 on p.cod_pessoa = pe.cod_pessoa_auxiliar
					where pe.fecha_execucao = 1
					  and trunc(pe.data_termino) between '#arguments.DATA_INICIO#' and '#arguments.DATA_TERMINO#'
					<cfif Len(Trim(arguments.COD_PESSOA))>
                      and p.cod_pessoa = #arguments.COD_PESSOA#
					</cfif>) t
                     order by num_ordem_servico, nivel_especialidade
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca dados da montagem do material no equipamento
	-- JAQUELINEF 24/03/2015
	--->
    <cffunction name="get_montagem" returntype="query" access="remote">
        <cfargument name="equipamento_id" required="yes"/>
        <cfargument name="material_id" required="yes"/>
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(em.date_insert,'dd/mm/yyyy') as data_montagem
                 , os.km_abertura as km_montagem
                 , to_char(em.data_previsao,'dd/mm/yyyy') as data_previsao
                 , case
                      when em.data_previsao >= sysdate then
                         1
                      else
                         0
                   end as garantia
              from manutencao.v$equipamento_material em
             inner join manutencao.v$ordem_servico os
                on os.ordem_servico_id = em.ordem_servico_id_montagem
             where em.ordem_servico_id_desmontagem is null
               and em.equipamento_id = #arguments.EQUIPAMENTO_ID#
               and em.material_id = #arguments.MATERIAL_ID#
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca dados do Tipo de manuten��o
	-- MARCELOAUGUSTO 12/02/2016
	--->
    <cffunction name="get_tipo_manutencao" returntype="query" access="remote">
        <cfargument name="tipo_manutencao_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select tm.tipo_manutencao_id
            	 , tm.tipo_manutencao
              from manutencao.v$tipo_manutencao tm
             where 1 = 1
			   and tm.ativo = 1
			<cfif Len(Trim(arguments.tipo_manutencao_id))>
               and tm.tipo_manutencao_id = #arguments.TIPO_MANUTENCAO_ID#
            </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca dados da Ficha do Veculo
	-- MARCELOAUGUSTO 12/02/2016
	--->
	<cffunction name="get_ficha_dados_veiculo" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="cod_equipamento" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select e.equipamento_id, e.cod_equipamento, v.cod_veiculo, e.placa, v.ano,
                   v.marca, v.modelo, v.classificacao, to_char(pa.cod_pessoa) as cod_pessoa,
                   p.identificador, p.razao_social as proprietario
              from almoxarifado.v$equipamento e
             inner join oper.v$veiculo_dados v
                     on v.placa = e.placa
             left join oper.v$veiculo_proprietario_atual pa
                     on pa.placa = v.placa
             left join kss.v$pessoa p
                     on p.cod_pessoa = pa.cod_pessoa
            where 1=1
             <cfif Len(Trim(arguments.cod_equipamento))>
               and e.cod_equipamento = '#arguments.cod_equipamento#'
             </cfif>
             <cfif Len(Trim(arguments.equipamento_id))>
               and e.equipamento_id = #arguments.equipamento_id#
             </cfif>
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca dados Ficha do Veculo em Ordem de servi�o
	-- MARCELOAUGUSTO 12/02/2016
	--->
	<cffunction name="get_ficha_dados_veiculo_os" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfargument name="data_inicial" required="no" default="">
		<cfargument name="data_final" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.ordem_servico_id,
                   os.num_ordem_servico,
                   to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data_abertura,
                   to_char(os.data_fechamento, 'dd/mm/yyyy hh24:mi') as data_fechamento,
                   os.data_atendimento,
                   manutencao.to_veiculo_km(e.placa, os.data_abertura, nvl(os.data_fechamento, os.data_fechamento)).km_data_final as km,
                   (select kss.fnc_concat_all(distinct kss.to_concat_expr(to_char(p.num_pedido), ','))
                              from compras.v$pedido p
                             inner join compras.v$pedido_item pi
                                on pi.pedido_id = p.pedido_id
                             inner join compras.v$cotacao c
                                on c.cotacao_id = pi.cotacao_id
                             inner join compras.v$solicitacao_item sm
                                on sm.solicitacao_item_id = c.solicitacao_item_id
                             inner join compras.v$solicitacao s
                                on s.solicitacao_id = sm.solicitacao_id
                             where s.solicitacao_id = os.solicitacao_compra_id) as num_controle,
                   nvl(m.cod_genuino, m.cod_material) as codigo,
                   m.descricao_completa as material_servico,
                   om.quantidade,
                   om.valor_unitario,
                   nvl(om.valor_total, 0) as valor_total,
                   null as tempo,
                   1 as material,
                   (select kss.fnc_concat_all(kss.to_concat_expr(x.num_nota_fiscal, ', '))
                      from (select distinct nft.num_nota_fiscal, s.solicitacao_id
                              from fiscal.v$nf_terceiro nft
                             inner join fiscal.v$nf_terceiro_pedido_item nfpi
                                on nfpi.num_nota_id = nft.num_nota_id
                             inner join compras.v$pedido p
                                on p.pedido_id = nfpi.pedido_id
                             inner join compras.v$pedido_item pi
                                on pi.pedido_id = nfpi.pedido_id
                               and pi.pedido_item_id = nfpi.pedido_item_id
                             inner join compras.v$cotacao c
                                on c.cotacao_id = pi.cotacao_id
                             inner join compras.v$solicitacao_item sm
                                on sm.solicitacao_item_id = c.solicitacao_item_id
                             inner join compras.v$solicitacao s
                                on s.solicitacao_id = sm.solicitacao_id
                            ) x
                      where x.solicitacao_id = os.solicitacao_compra_id) as num_nota_fiscal,
                   ((select nvl(sum(oa2.valor_servico), 0)
                       from manutencao.v$os_atividade oa2
                      where oa2.ordem_servico_id = os.ordem_servico_id) +
                   (select nvl(sum(om2.valor_total), 0)
                       from manutencao.v$os_material om2
                      where om2.ordem_servico_id = os.ordem_servico_id)) as total_calculado
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id
              left join manutencao.v$os_material om
                     on om.ordem_servico_id = os.ordem_servico_id
              left join almoxarifado.v$material_dados m
                     on m.material_id = om.material_id
              left join manutencao.v$equipamento_posicao ep
                     on ep.posicao_id = om.posicao_id
             where 1 = 1
             <cfif Len(Trim(arguments.equipamento_id))>
               and os.equipamento_id = #arguments.equipamento_id#
             </cfif>
             <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final))>
               and trunc(os.data_abertura) between '#arguments.data_inicial#' and '#arguments.data_final#'
             </cfif>
             <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final)) eq 0>
               and trunc(os.data_abertura) >= '#arguments.data_inicial#'
             </cfif>
             <cfif Len(Trim(arguments.data_final)) and Len(Trim(arguments.data_inicial)) eq 0>
               and trunc(os.data_abertura) <= '#arguments.data_final#'
             </cfif>

             union all

            select os.ordem_servico_id,
                   os.num_ordem_servico,
                   to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data_abertura,
                   to_char(os.data_fechamento, 'dd/mm/yyyy hh24:mi') as data_fechamento,
                   os.data_atendimento,
                   manutencao.to_veiculo_km(e.placa, os.data_abertura, nvl(os.data_fechamento, os.data_fechamento)).km_data_final as km,
                   (select kss.fnc_concat_all(distinct kss.to_concat_expr(to_char(p.num_pedido), ','))
                      from compras.v$pedido p
                     inner join compras.v$pedido_item pi
                        on pi.pedido_id = p.pedido_id
                     inner join compras.v$cotacao c
                        on c.cotacao_id = pi.cotacao_id
                     inner join compras.v$solicitacao_item sa
                        on sa.solicitacao_item_id = c.solicitacao_item_id
                     inner join compras.v$solicitacao s
                        on s.solicitacao_id = sa.solicitacao_id
                     where s.solicitacao_id = os.solicitacao_compra_id) as num_controle,
                   a.cod_atividade as codigo,
                   a.titulo as material_servico,
                   1 as quantidade,
                   oa.valor_servico as valor_unitario,
                   nvl(oa.valor_servico, 0) as valor_total,
                   manutencao.to_tempo_execucao(oa.tempo_execucao_ajustado, 3).retorno as tempo,
                   0 as material,
                   (select kss.fnc_concat_all(kss.to_concat_expr(x.num_nota_fiscal, ', '))
                      from (select distinct nft.num_nota_fiscal, s.solicitacao_id
                              from fiscal.v$nf_terceiro nft
                             inner join fiscal.v$nf_terceiro_pedido_item nfpi
                                on nfpi.num_nota_id = nft.num_nota_id
                             inner join compras.v$pedido p
                                on p.pedido_id = nfpi.pedido_id
                             inner join compras.v$pedido_item pi
                                on pi.pedido_id = nfpi.pedido_id
                               and pi.pedido_item_id = nfpi.pedido_item_id
                             inner join compras.v$cotacao c
                                on c.cotacao_id = pi.cotacao_id
                             inner join compras.v$solicitacao_item sa
                                on sa.solicitacao_item_id = c.solicitacao_item_id
                             inner join compras.v$solicitacao s
                                on s.solicitacao_id = sa.solicitacao_id
                            ) x
                      where x.solicitacao_id = os.solicitacao_compra_id) as num_nota_fiscal,
                   ((select nvl(sum(oa2.valor_servico), 0)
                       from manutencao.v$os_atividade oa2
                      where oa2.ordem_servico_id = os.ordem_servico_id) +
                   (select nvl(sum(om2.valor_total), 0)
                       from manutencao.v$os_material om2
                      where om2.ordem_servico_id = os.ordem_servico_id)) as total_calculado
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento e
                     on e.equipamento_id = os.equipamento_id
             inner join manutencao.v$os_atividade oa
                     on oa.ordem_servico_id = os.ordem_servico_id
             inner join manutencao.v$atividade a
                     on a.atividade_id = oa.atividade_id
              left join manutencao.v$equipamento_posicao ep
                     on ep.posicao_id = oa.posicao_id
             where 1 = 1
               and oa.atividade_id not in (select ta.atividade_id
                                             from manutencao.v$tabela_atividade ta
                                            inner join manutencao.v$os_tabela_manutencao otm
                                               on ta.tabela_id = otm.tabela_id
                                            where otm.ordem_servico_id = oa.ordem_servico_id)
             <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final))>
               and trunc(os.data_abertura) between '#arguments.data_inicial#' and '#arguments.data_final#'
             </cfif>
             <cfif Len(Trim(arguments.data_inicial)) and Len(Trim(arguments.data_final)) eq 0>
               and trunc(os.data_abertura) >= '#arguments.data_inicial#'
             </cfif>
             <cfif Len(Trim(arguments.data_final)) and Len(Trim(arguments.data_inicial)) eq 0>
               and trunc(os.data_abertura) <= '#arguments.data_final#'
             </cfif>
             <cfif Len(Trim(arguments.equipamento_id))>
               and os.equipamento_id = #arguments.equipamento_id#
             </cfif>
             order by ordem_servico_id
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca data inicial e final da Ficha do Veculo em Ordem de servi�o
	-- MARCELOAUGUSTO 12/02/2016
	--->
	<cffunction name="get_ficha_datas_veiculo_os" returntype="query" access="remote">
		<cfargument name="equipamento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
           select min(x.data_abertura_inicial) as data_abertura_inicial
                , max(x.data_abertura_final) as data_abertura_final
             from (select to_char(min(os.data_abertura), 'dd/mm/yyyy hh24:mi') as data_abertura_inicial
                        , to_char(max(os.data_abertura), 'dd/mm/yyyy hh24:mi') as data_abertura_final
                     from manutencao.v$ordem_servico os
                    inner join almoxarifado.v$equipamento e
                            on e.equipamento_id = os.equipamento_id
                     left join manutencao.v$os_material om
                            on om.ordem_servico_id = os.ordem_servico_id
                     left join almoxarifado.v$material_dados m
                            on m.material_id = om.material_id
                     left join manutencao.v$equipamento_posicao ep
                            on ep.posicao_id = om.posicao_id
                    where 1 = 1
                    <cfif Len(Trim(arguments.equipamento_id))>
                      and os.equipamento_id = #arguments.equipamento_id#
                    </cfif>
                   union all
                   select to_char(min(os.data_abertura), 'dd/mm/yyyy hh24:mi') as data_abertura_inicial
                        , to_char(max(os.data_abertura), 'dd/mm/yyyy hh24:mi') as data_abertura_final
                     from manutencao.v$ordem_servico os
                    inner join almoxarifado.v$equipamento e
                            on e.equipamento_id = os.equipamento_id
                    inner join manutencao.v$os_atividade oa
                            on oa.ordem_servico_id = os.ordem_servico_id
                    inner join manutencao.v$atividade a
                            on a.atividade_id = oa.atividade_id
                     left join manutencao.v$equipamento_posicao ep
                            on ep.posicao_id = oa.posicao_id
                    where 1 = 1
                    <cfif Len(Trim(arguments.equipamento_id))>
                      and os.equipamento_id = #arguments.equipamento_id#
                    </cfif>
                   ) x
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca parametro
	-- MARIA 06/08/2012
	--->
	<cffunction name="get_alteracao_proprietario_web" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_parametro.fnc_valor_lista('M201-P0001') as alteracao_bloqueada
			  from dual
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca classifica��o
	-- NOTAS EXPLICATIVAS
	-- GUTO 17/07/2006
	--->
	<cffunction name="get_classificacao" access="remote" returntype="query" output="true">
		<cfargument name="agrupamento_id" required="no" default="">
		<cfargument name="tipo_carroceria_id" required="no" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select va.agrupamento_id,
            	   va.num_agrupamento,
                   va.descricao as agrupamento,
                   vc.tipo_carroceria_id,
                   vc.num_tipo_carroceria,
                   vc.descricao as classificacao,
                   (select count(pgs.num_eixo)
                      from oper.v$pneu_gabarito_setup pgs
                     where pgs.num_gabarito = vc.num_gabarito
                   ) as num_eixos
              from oper.v$veiculo_tipo_carroceria vc
             inner join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vc.agrupamento_id
               where 1=1
               <cfif Len(Trim(arguments.agrupamento_id))>
               	 and va.agrupamento_id = any(#arguments.agrupamento_id#)
               </cfif>
               <cfif Len(Trim(arguments.tipo_carroceria_id))>
               	 and va.tipo_carroceria_id = #arguments.tipo_carroceria_id#
               </cfif>
  		</cfquery>
	<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna todas as marcas de Veculos cadastradas
	-- NOTAS EXPLICATIVAS
	--
	-- 07/12/2005 - criado
	--->
	<cffunction name="get_marcas" displayname="Retorna todas as marcas de Veculos cadastradas" output="true" returntype="query" access="public">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="marca" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select marca_id, marca
			  from oper.v$veiculo_marca
			 where 1=1
			 <cfif Len(Trim(arguments.marca_id))>
				 and marca_id = #arguments.marca_id#
			 </cfif>
			 <cfif Len(Trim(arguments.marca))>
				 and upper(marca) like upper('#arguments.marca#%')
			 </cfif>
			order by marca
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca se o Veculo � tracionado
	-- MARCELOAUGUSTO 12/02/2016
	--->
	<cffunction name="get_tracao_veiculo" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select va.tracao
              from oper.v$veiculo v
             inner join oper.v$veiculo_tipo_carroceria vtc
                on v.tipo_carroceria_id = vtc.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                on va.agrupamento_id = vtc.agrupamento_id
             where v.placa = '#arguments.placa#'
 		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna dados do propriet�rio do Veculo
	-- NOTAS EXPLICATIVAS
	--
	-- 07/12/2005 - criado
	--->
	<cffunction name="get_veiculo_proprietario" displayname="Retorna dados do propriet�rio do Veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa,
             		p.cliente as nome,
                    p.cnpj_cpf,
                    p.identificador,
                    to_char(vp.data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio,
                    to_char(vp.cod_pessoa) as cod_pessoa,
		 		    v.chassis,
                    m.marca,
                    v.ano,
       				pe.logradouro||' '||pe.numero as endereco,
			        pe.municipio as municipio_uf

	     from oper.v$veiculo v
		  left join oper.v$veiculo_marca m
				 on m.marca_id = v.marca_id
		  left join oper.v$veiculo_modelo md
				 on md.marca_id = v.marca_id
				and md.modelo_id = v.modelo_id
		 inner join oper.v$veiculo_proprietario vp
				 on vp.placa = v.placa
				and vp.data_fim is null
		 inner join kss.v$pessoa p
				 on p.cod_pessoa = vp.cod_pessoa
         inner join kss.v$pessoa_endereco_todos pe on pe.cod_pessoa = p.cod_pessoa
                                    and pe.endereco_padrao = 1
			  where 1=1
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = upper('#arguments.placa#')
			</cfif>

  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna dados do propriet�rio do Veculo
	-- NOTAS EXPLICATIVAS
	--
	-- 07/12/2005 - criado
	--->
	<cffunction name="get_veiculo_proprietario_doc" displayname="Retorna dados do propriet�rio do Veculo" output="true" returntype="query" access="public">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa,
             		p.cliente as nome,
                    p.cnpj_cpf,
                    p.identificador,
                    vp.data_inicio,
                    to_char(vp.cod_pessoa) as cod_pessoa,
		 		    v.chassis,
                    m.marca,
                    v.ano
	           from oper.v$veiculo v
		  left join oper.v$veiculo_marca m
				 on m.marca_id = v.marca_id
		  left join oper.v$veiculo_modelo md
				 on md.marca_id = v.marca_id
				and md.modelo_id = v.modelo_id
		 inner join oper.v$veiculo_proprietario_doc vp
				 on vp.placa = v.placa
				and vp.data_fim is null
		 inner join kss.v$pessoa p
				 on p.cod_pessoa = vp.cod_pessoa

			  where 1=1
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = upper('#arguments.placa#')
			</cfif>

  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna dados do permissionario do Veculo
	-- NOTAS EXPLICATIVAS
	--
	-- 07/12/2005 - criado
	--->
	<cffunction name="get_veiculo_permissionario" displayname="Retorna dados do propriet�rio do Veculo" output="true" returntype="query" access="public">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.placa,
                   p.cliente as nome,
                   p.razao_social,
                   p.cnpj_cpf,
                   p.identificador,
                   vp.data_inicio,
                   to_char(vp.cod_pessoa) as cod_pessoa,
                   v.chassis,
                   m.marca,
                   v.ano,
                   oper.pkg_veiculo.fnc_capacidade_carga_compo(v.placa, sysdate) as capacidade,
                   pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero ||
                   decode(pe.complemento, '', '', ' - ') || pe.complemento endereco,
                   pe.municipio as local,
                   pe.uf,
                   pe.municipio_id,
                   pe.municipio as municipio_uf,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 6) as permisso_numero,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 7) as permisso_data,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 8) as apolice_numero,
                   kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9) as apolice_vencimento,
                   oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'TARA') as tara,
                   oper.pkg_frota_dml.fnc_veiculo_get_atributo(v.placa, 'CAPACIDADE_TRACAO') as capacidade_tracao,
                   trunc(to_date(decode(kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9), '0', to_char(sysdate, 'dd/mm/yyyy'), kss.pkg_atributo.FNC_GET_ATRIBUTO(p.cod_pessoa, 9)), 'dd/mm/yyyy') - sysdate) as dias_venc_apolice
              from oper.v$veiculo v
             inner join oper.v$veiculo_permissionario vp
                     on vp.placa = v.placa
                    and vp.data_fim is null
             inner join kss.v$pessoa p
                     on p.cod_pessoa = vp.cod_pessoa
              left join kss.v$pessoa_endereco_todos pe
                     on pe.cod_pessoa = vp.cod_pessoa
                    and pe.endereco_padrao = 1
              left join oper.v$veiculo_marca m
                     on m.marca_id = v.marca_id
              left join oper.v$veiculo_modelo md
                     on md.marca_id = v.marca_id
                    and md.modelo_id = v.modelo_id
             where 1 = 1
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = oper.pkg_veiculo.fnc_get_placa(upper('#arguments.placa#'))
			</cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Retorna dados do propriet�rio do Veculo
	-- NOTAS EXPLICATIVAS
	--
	-- 07/12/2005 - criado
	--->
	<cffunction name="get_veiculo_motorista" displayname="Retorna dados do propriet�rio do Veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select v.placa,
                   p.cliente as nome,
                   p.cnpj_cpf,
                   p.identificador,
                   to_char(vp.data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio,
                   to_char(vp.cod_pessoa) as cod_pessoa,
                   v.chassis,
                   m.marca,
                   v.ano,
                   pe.logradouro || decode(pe.numero, '', '', ', ') || pe.numero || decode(pe.complemento, '', '', ' - ') || pe.complemento endereco,
                   pe.municipio as local,
                   pe.uf as municipio_uf,
                   pe.municipio_id,
                   pf.cart_ident_num,
                   pf.cart_ident_orgao
              from oper.v$veiculo v
              left join oper.v$veiculo_marca m
                     on m.marca_id = v.marca_id
              left join oper.v$veiculo_modelo md
                     on md.marca_id = v.marca_id
                    and md.modelo_id = v.modelo_id
             inner join oper.v$veiculo_motorista vp
                     on vp.placa = v.placa
                    and vp.data_fim is null
             inner join kss.v$pessoa p
                     on p.cod_pessoa = vp.cod_pessoa
              left join kss.v$pessoa_fisica pf
                     on pf.cod_pessoa = p.cod_pessoa
              left join kss.v$pessoa_endereco_todos pe
                     on pe.cod_pessoa = p.cod_pessoa
                    and pe.endereco_padrao = 1
             where 1 = 1
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			    and vp.placa = upper('#arguments.placa#')
			</cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca a composicao do veiculo
	-- GUTO  25/06/2006
	--->
   <cffunction name="get_composicao_dados" access="remote" returntype="query" output="true">
		<cfargument name="cod_veiculo" required="yes">
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			 select t.placa
               , t.cod_veiculo
               , t.veiculo_id
               , t.capacidade
               , t.marca
               , t.modelo
               , t.ordem
               , p.cnpj_cpf
               , p.razao_social as motorista
               , t.tipo_carroceria
               , to_char(t.cod_pessoa_motorista) as cod_pessoa_motorista
            from ( 
            select /*+no_parallel*/
                  distinct t.placa
               , oper.pkg_veiculo.fnc_get_cod_veiculo(t.placa) cod_veiculo
               , oper.pkg_veiculo.fnc_veiculo_id(t.placa) as veiculo_id
               , (select oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(t.placa,sysdate) as capacidade
                     from dual) as capacidade
               , (select vm.marca
                     from oper.v$veiculo_marca vm
                     where vm.marca_id = vd.marca_id) as marca
               , (select vmo.modelo
                     from oper.v$veiculo_modelo vmo
                     where vmo.modelo_id = vd.modelo_id) as modelo
               , t.ordem
               , (select vtc.descricao
                     from oper.v$veiculo_tipo_carroceria vtc
                     where vtc.tipo_carroceria_id = vd.tipo_carroceria_id) as tipo_carroceria
               , (select max(vm.cod_pessoa) keep (dense_rank last order by vm.data_inicio)
                     from oper.v$veiculo_motorista vm
                     where vm.placa = t.placa
                     and vm.data_fim is null) as cod_pessoa_motorista
            from (select column_value as placa, 
                        rownum as ordem 
                     from table(kss.pkg_string.fnc_split(rtrim(ltrim(oper.pkg_veiculo.FNC_GET_COMPOSICAO(oper.pkg_veiculo.fnc_get_placa('#arguments.cod_veiculo#')),'|'),'|'),'|'))
               ) t
            inner join oper.v$veiculo vd
               on vd.placa = t.placa
            where vd.placa in (select column_value as placa
                                 from table(kss.pkg_string.fnc_split(rtrim(ltrim(oper.pkg_veiculo.FNC_GET_COMPOSICAO(oper.pkg_veiculo.fnc_get_placa('#arguments.cod_veiculo#')),'|'),'|'),'|')))
               ) t
            left join kss.v$pessoa p 
               on p.cod_pessoa = t.cod_pessoa_motorista
            order by t.ordem
			</cfquery>

		<cfreturn qr_result>
	</cffunction>
    <!---
	-- PROPSITO
	-- Busca se o Veculo nao est� bloqueado
	-- MARIA 06/08/2012
	--->
	<cffunction name="get_veiculo_bloqueado" access="remote" returntype="query" output="true">
		<cfargument name="placa" required="yes" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.bloqueio_manual_id
                 , t.placa
                 , v.cod_veiculo as frota
                 , t.tipo_bloqueio as tipo_bloqueio_id
                 , kss.fnc_ref_code('GRISCO','BLOQUEIO_MANUAL.TIPO_BLOQUEIO',t.tipo_bloqueio) as tipo_bloqueio
                 , nvl2(t.usuario_desbloqueio,1,0) as situacao_id
                 , nvl2(t.usuario_desbloqueio,'Desbloqueado','Bloqueado') as situacao
                 , t.motivo_bloqueio as motivo
                 , t.data_bloqueio
                 , t.usuario_bloqueio
                 , t.motivo_desbloqueio
                 , t.data_desbloqueio
                 , t.usuario_desbloqueio
                 , t.user_insert
                 , t.date_insert
                 , t.user_update
                 , t.date_update
              from grisco.v$bloqueio_manual t
              inner join oper.v$veiculo v
                on v.placa = t.placa
             where t.placa = '#arguments.placa#'
             and t.data_desbloqueio is null
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os percentiais de trabalho por centro de custo
	-- NOTAS EXPLICATIVAS
	-- WAGNER 11/12/2012
	--->
	<cffunction name="get_perc_trabalho" returntype="query" access="remote">
		<cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="controle_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ct.controle_id,
                   ct.cod_centro_custo,
                   ct.percentual,
                   to_char(ct.data_vigencia,'dd/mm/yyyy') as data_vigencia,
                   cc.centro_custo,
                   ct.date_insert,
                   ct.user_insert,
                   ct.date_update,
                   ct.user_update,
                   ct.site
              from manutencao.v$ccusto_perc_trabalho ct
             inner join kss.v$centro_custo cc
                on cc.cod_centro_custo = ct.cod_centro_custo
             where 1=1
           <cfif len(trim(arguments.cod_centro_custo)) >
           	   and ct.cod_centro_custo = '#arguments.cod_centro_custo#'
           </cfif>
           <cfif len(trim(arguments.cod_pessoa)) >
           	   and ct.cod_centro_custo in (select o.cod_centro_custo
               							  from kss.v$organograma o
                                         inner join kss.v$centro_custo cc
                                            on o.cod_centro_custo = cc.cod_centro_custo
                                         where o.cod_pessoa = '#arguments.cod_pessoa#')
           </cfif>
           <cfif len(trim(arguments.data_inicio)) and len(trim(arguments.data_fim))>
           	   and ct.data_vigencia between '#arguments.data_inicio#' and '#arguments.data_fim#'
           </cfif>
           <cfif len(trim(arguments.data_inicio)) and len(trim(arguments.data_fim)) eq 0>
           	   and ct.data_vigencia >= '#arguments.data_inicio#'
           </cfif>
           <cfif len(trim(arguments.data_fim)) and len(trim(arguments.data_inicio)) eq 0>
	           and ct.data_vigencia <= '#arguments.data_fim#'
           </cfif>
           <cfif len(trim(arguments.controle_id)) >
           	   and controle_id = '#arguments.controle_id#'
           </cfif>
            order by cc.centro_custo,ct.data_vigencia desc
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os percentiais de trabalho por centro de custo gerencial
	-- NOTAS EXPLICATIVAS
	-- WAGNER 11/12/2012
	--->
	<cffunction name="get_perc_trabalho_ccg" returntype="query" access="remote">
		<cfargument name="organizacional_id" required="no" default="">
        <cfargument name="data_inicio" required="no" default="">
        <cfargument name="data_fim" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfargument name="controle_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select ct.controle_id,
                   ct.organizacional_id,
                   ct.percentual,
                   to_char(ct.data_vigencia,'dd/mm/yyyy') as data_vigencia,
                   o.descricao as centro_custo_gerencial,
                   ct.date_insert,
                   ct.user_insert,
                   ct.date_update,
                   ct.user_update,
                   ct.site
              from manutencao.v$ccgerencial_perc_trab ct
             inner join kss.v$organizacional o
                on o.organizacional_id = ct.organizacional_id
             where 1=1
           <cfif len(trim(arguments.organizacional_id)) >
           	   and ct.organizacional_id = '#arguments.organizacional_id#'
           </cfif>
           <cfif len(trim(arguments.data_inicio)) and len(trim(arguments.data_fim)) >
           	   and ct.data_vigencia between '#arguments.data_inicio#' and '#arguments.data_fim#'
           </cfif>
           <cfif len(trim(arguments.data_inicio)) and len(trim(arguments.data_fim)) eq 0>
           	   and ct.data_vigencia >= '#arguments.data_inicio#'
           </cfif>
           <cfif len(trim(arguments.data_fim)) and len(trim(arguments.data_inicio)) eq 0>
	           and ct.data_vigencia <= '#arguments.data_fim#'
           </cfif>
           <cfif len(trim(arguments.controle_id)) >
           	   and ct.controle_id = '#arguments.controle_id#'
           </cfif>
            order by o.descricao,ct.data_vigencia desc
   		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Disponibilidade de Frota de um per�odo
    -- ANDERSON 29/09/2009 - CRIADO
    --->
    <cffunction name="get_disponibilidade_frota" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="modalidades" required="no">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.cod_centro_custo
                 , y.centro_custo
                 , y.qtde_veiculos
                 , y.qtde_veiculos_manut
                 , y.horas_disponiveis
                 , y.horas_paradas
                 , round( y.horas_falha_operacional * (y.percentual/100),2) as horas_falha_operacional
                 , round( y.horas_disponiveis - y.horas_paradas, 2) as horas_executadas
                 , round( ((y.horas_disponiveis - y.horas_paradas) / y.horas_disponiveis) * 100, 2) as horas_disponiveis_perc
                 , round( (y.horas_paradas / y.horas_disponiveis ) * 100, 2 ) as horas_paradas_perc
                 , round( (y.horas_falha_operacional * 100)  / decode(y.horas_paradas, 0, 1, y.horas_paradas) , 2 ) as horas_falha_perc
                 , round( ((y.horas_disponiveis - (y.horas_paradas - y.horas_falha_operacional)) / y.horas_disponiveis) * 100, 2) as perc_horas_sem_falha
              from (select t.cod_centro_custo,
                           (select cc.centro_custo
                              from kss.v$centro_custo cc
                             where cc.cod_centro_custo = t.cod_centro_custo) as centro_custo,
                           count(*) as qtde_veiculos,
                           sum(t.os_encerrada) as qtde_veiculos_manut,
                           ( count(*) * 24 * (t.data_fim - t.data_inicio)
                             *
                             t.percentual ) as horas_disponiveis,
                           round(nvl(sum(t.horas_paradas), 0)
                                 *
                                 t.percentual   , 2) as horas_paradas,
                           round(nvl(sum(t.horas_falha_operacional), 0), 2) as horas_falha_operacional,
                           t.percentual
                      from (select vcc.cod_centro_custo,
                                   ossub2.os_encerrada,
                                   ossub.horas_paradas,
                                   ossub2.horas_falha_operacional,
                                   to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio,
                                   to_date('#arguments.data_fim#', 'dd/mm/yyyy') as data_fim,
                                   nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                          from manutencao.v$ccusto_perc_trabalho cpt
                                         where cpt.cod_centro_custo = vcc.cod_centro_custo
                                           and cpt.data_vigencia >= vcc.data),1) as percentual
                              from oper.v$veiculo v
                             inner join manutencao.v$equipamento e
                                on e.cod_equipamento = v.cod_veiculo
                                or e.placa = v.placa
                              left join (select least(sum(least(nvl(os.data_fechamento, sysdate), to_date('#arguments.data_fim#', 'dd/mm/yyyy')) -
                                                   greatest(os.data_abertura,
                                                      to_date('#arguments.data_inicio#', 'dd/mm/yyyy'))) * 24,
                                                         (to_date('#arguments.data_fim#', 'dd/mm/yyyy') - to_date('#arguments.data_inicio#', 'dd/mm/yyyy')) * 24) as horas_paradas
                                              , e.equipamento_id
                                              , e.placa
                                           from manutencao.v$ordem_servico os
                                          inner join almoxarifado.v$equipamento e
                                             on e.equipamento_id = os.equipamento_id
                                          where ((os.data_abertura between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and
                                                to_date('#arguments.data_fim#', 'dd/mm/yyyy')) or (os.data_fechamento between
                                                to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))
                                          group by e.equipamento_id, e.placa) ossub
                                on ossub.equipamento_id = e.equipamento_id
                               and ossub.placa = e.placa
                              left join (select sign((select count(*)
                                              		    from manutencao.v$ordem_servico os2
                                                       where os2.equipamento_id = e.equipamento_id)) as os_encerrada
                                              , (select sum(least(nvl(os2.data_fechamento, sysdate), to_date('#arguments.data_fim#', 'dd/mm/yyyy')) -
                                                           greatest(os2.data_abertura, to_date('#arguments.data_inicio#', 'dd/mm/yyyy'))) * 24
                                                   from manutencao.v$ordem_servico os2
                                                  where os2.equipamento_id = e.equipamento_id
                                                    and os2.tipo_manutencao_id = 3) as horas_falha_operacional
                                              , e.equipamento_id
                                              , e.placa
                                           from manutencao.v$ordem_servico os
                                          inner join almoxarifado.v$equipamento e
                                             on e.equipamento_id = os.equipamento_id
                                          where ((os.data_abertura between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and
                                                to_date('#arguments.data_fim#', 'dd/mm/yyyy')) or (os.data_fechamento between
                                                to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))
                                            and os.data_fechamento is not null
                                          group by e.equipamento_id, e.placa) ossub2
                                on ossub2.equipamento_id = e.equipamento_id
                               and ossub2.placa = e.placa
                             inner join oper.v$veiculo_tipo_carroceria vtc
                                on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                             inner join oper.v$veiculo_modalidade m
                                on m.placa = v.placa
                             inner join oper.v$veiculo_agrupamento va
                                on va.agrupamento_id = vtc.agrupamento_id
                             inner join oper.v$veiculo_hist_situacao vhs
                                on vhs.placa = v.placa
                             inner join oper.v$veiculo_ccusto vcc
                                on vcc.placa = v.placa
                             where va.tracao = 1
                               and vhs.situacao_id = 1
                             <cfif Len(Trim(arguments.modalidades))>
                               and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
                             </cfif>
                               and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                                from oper.v$veiculo_hist_situacao vhs2
                                                               where vhs2.placa = v.placa
                                                                 and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                               and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                                from oper.v$veiculo_modalidade vm2
                                                               where vm2.placa = m.placa
                                                                 and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                               and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                              from oper.v$veiculo_ccusto vcc2
                                                             where vcc2.placa = vcc.placa
                                                               and vcc2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                          ) t
                     group by t.cod_centro_custo, t.percentual, t.data_inicio, t.data_fim) y
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Disponibilidade de Frota de um per�odo baseado em CCG
    -- ANDERSON 29/09/2009 - CRIADO
    --->
    <cffunction name="get_disponibilidade_frota_ccg" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="modalidades" required="no">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.organizacional_id
                 , y.centro_custo_gerencial
                 , y.qtde_veiculos
                 , y.qtde_veiculos_manut
                 , y.horas_disponiveis
                 , y.horas_paradas
                 , round( y.horas_falha_operacional * (y.percentual/100),2) as horas_falha_operacional
                 , round( y.horas_disponiveis - y.horas_paradas, 2) as horas_executadas
                 , round( ((y.horas_disponiveis - y.horas_paradas) / y.horas_disponiveis) * 100, 2) as horas_disponiveis_perc
                 , round( (y.horas_paradas / y.horas_disponiveis ) * 100, 2 ) as horas_paradas_perc
                 , round( (y.horas_falha_operacional * 100)  / decode(y.horas_paradas, 0, 1, y.horas_paradas) , 2 ) as horas_falha_perc
                 , round( ((y.horas_disponiveis - (y.horas_paradas - y.horas_falha_operacional)) / y.horas_disponiveis) * 100, 2) as perc_horas_sem_falha
              from (select t.organizacional_id,
                           (select o.descricao
                              from kss.v$organizacional o
                             where o.organizacional_id = t.organizacional_id) as centro_custo_gerencial,
                           count(*) as qtde_veiculos,
                           sum(t.os_encerrada) as qtde_veiculos_manut,
                           ( count(*) * 24 * ((t.data_fim + 1) - t.data_inicio)
                             *
                             t.percentual ) as horas_disponiveis,
                           round(nvl(sum(t.horas_paradas), 0)
                                 *
                                 t.percentual   , 2) as horas_paradas,
                           round(nvl(sum(t.horas_falha_operacional), 0), 2) as horas_falha_operacional,
                           t.percentual
                      from (select vcg.organizacional_id,
                                   ossub2.os_encerrada,
                                   ossub.horas_paradas,
                                   ossub2.horas_falha_operacional,
                                   to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio,
                                   to_date('#arguments.data_fim#', 'dd/mm/yyyy') as data_fim,
                                   nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                          from manutencao.v$ccgerencial_perc_trab cpt
                                         where cpt.organizacional_id = vcg.organizacional_id
                                           and cpt.data_vigencia >= vcg.data),1) as percentual
                              from oper.v$veiculo v
                             inner join manutencao.v$equipamento e
                                on e.cod_equipamento = v.cod_veiculo
                                or e.placa = v.placa
                              left join (select least(sum(least(nvl(os.data_fechamento, sysdate), to_date('#arguments.data_fim#', 'dd/mm/yyyy')) -
                                                   greatest(os.data_abertura,
                                                      to_date('#arguments.data_inicio#', 'dd/mm/yyyy'))) * 24,
                                                         (to_date('#arguments.data_fim#', 'dd/mm/yyyy') - to_date('#arguments.data_inicio#', 'dd/mm/yyyy')) * 24) as horas_paradas
                                              , e.equipamento_id
                                              , e.placa
                                           from manutencao.v$ordem_servico os
                                          inner join almoxarifado.v$equipamento e
                                             on e.equipamento_id = os.equipamento_id
                                          where ((trunc(os.data_abertura) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and
                                                to_date('#arguments.data_fim#', 'dd/mm/yyyy')) or (trunc(os.data_fechamento) between
                                                to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))
                                          group by e.equipamento_id, e.placa) ossub
                                on ossub.equipamento_id = e.equipamento_id
                               and ossub.placa = e.placa
                              left join (select sign((select count(*)
                                              		    from manutencao.v$ordem_servico os2
                                                       where os2.equipamento_id = e.equipamento_id)) as os_encerrada
                                              , (select sum(least(nvl(os2.data_fechamento, sysdate), to_date('#arguments.data_fim#', 'dd/mm/yyyy')) -
                                                           greatest(os2.data_abertura, to_date('#arguments.data_inicio#', 'dd/mm/yyyy'))) * 24
                                                   from manutencao.v$ordem_servico os2
                                                  where os2.equipamento_id = e.equipamento_id
                                                    and os2.tipo_manutencao_id = 3) as horas_falha_operacional
                                              , e.equipamento_id
                                              , e.placa
                                           from manutencao.v$ordem_servico os
                                          inner join almoxarifado.v$equipamento e
                                             on e.equipamento_id = os.equipamento_id
                                          where ((trunc(os.data_abertura) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and
                                                to_date('#arguments.data_fim#', 'dd/mm/yyyy')) or (trunc(os.data_fechamento) between
                                                to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))
                                            and os.data_fechamento is not null
                                          group by e.equipamento_id, e.placa) ossub2
                                on ossub2.equipamento_id = e.equipamento_id
                               and ossub2.placa = e.placa
                             inner join oper.v$veiculo_tipo_carroceria vtc
                                on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                             inner join oper.v$veiculo_agrupamento va
                                on va.agrupamento_id = vtc.agrupamento_id
                             inner join oper.v$veiculo_modalidade m
                                on m.placa = v.placa
                             inner join oper.v$veiculo_ccusto_gerencial vcg
                                on vcg.placa = v.placa
                             inner join oper.v$veiculo_hist_situacao vhs
                                on vhs.placa = v.placa
                             where va.tracao = 1
                               and vhs.situacao_id = 1
                             <cfif Len(Trim(arguments.modalidades))>
                               and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
                             </cfif>
                               and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                                from oper.v$veiculo_hist_situacao vhs2
                                                               where vhs2.placa = v.placa
                                                                 and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                               and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                                from oper.v$veiculo_modalidade vm2
                                                               where vm2.placa = m.placa
                                                                 and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                               and vcg.veiculo_ccusto_id = (select max(vcg2.veiculo_ccusto_id) keep(dense_rank last order by vcg2.data)
                                                              from oper.v$veiculo_ccusto_gerencial vcg2
                                                             where vcg2.placa = vcg.placa
                                                               and vcg2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                          ) t
                     group by t.organizacional_id, t.percentual, t.data_inicio, t.data_fim) y
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!---
	-- PROPSITO
    -- Disponibilidade de Frota de um per�odo baseado em CCG
    -- ANDERSON 29/09/2009 - CRIADO
    --->
    <cffunction name="get_disp_frota_ccg_marca_modelo" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="modalidades" required="no">
		
		<cfargument name="organizacional_id" required="no" default="">
		<cfargument name="marca_id_filtro" required="no" default="">
		<cfargument name="modelo_id_filtro" required="no" default="">
		
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.organizacional_id
                 , y.centro_custo_gerencial
                 , y.qtde_veiculos
                 , y.qtde_veiculos_manut
				 , y.qtde_veiculos_os_aberta
                 , y.horas_disponiveis 
                 , sum(y.horas_disponiveis ) over(partition by y.organizacional_id) as horas_disponiveis_geral
                 , sum(y.horas_disponiveis ) over(partition by y.organizacional_id, y.marca_id) as horas_disponiveis_geral_marca
				 , y.horas_paradas
                 , sum(y.horas_paradas ) over(partition by y.organizacional_id) as horas_paradas_geral
                 , sum(y.horas_paradas ) over(partition by y.organizacional_id, y.marca_id) as horas_paradas_geral_marca
                 , round( y.horas_falha_operacional * (y.percentual/100),2) as horas_falha_operacional
                 , round( y.horas_disponiveis - y.horas_paradas, 2) as horas_executadas
                 , sum( round( y.horas_disponiveis - y.horas_paradas, 2) ) over(partition by y.organizacional_id) as horas_exec_geral
                 , sum( round( y.horas_disponiveis - y.horas_paradas, 2) ) over(partition by y.organizacional_id, y.marca_id) as horas_exec_geral_marca
                 , round( ((y.horas_disponiveis - y.horas_paradas) / y.horas_disponiveis) * 100, 2) as horas_disponiveis_perc
                 , round( ( (y.horas_disponiveis - y.horas_paradas) / sum(y.horas_disponiveis ) over(partition by y.organizacional_id)) * 100 , 2) as horas_disponiveis_perc_geral
                 , round( ( sum((y.horas_disponiveis - y.horas_paradas) ) over(partition by y.organizacional_id, y.marca_id) / sum(y.horas_disponiveis ) over(partition by y.organizacional_id)) * 100 , 2) as horas_disp_perc_geral_marca
                 , round( (y.horas_paradas / y.horas_disponiveis ) * 100, 2 ) as horas_paradas_perc     
                 , round( (y.horas_paradas / sum(y.horas_disponiveis ) over(partition by y.organizacional_id)) * 100 , 2) as horas_paradas_perc_geral
                 , round( ( sum(y.horas_paradas) over(partition by y.organizacional_id, y.marca_id) / sum(y.horas_disponiveis ) over(partition by y.organizacional_id)) * 100 , 2) as horas_paradas_perc_geral_marca
                 , round( (y.horas_falha_operacional * 100)  / decode(y.horas_paradas, 0, 1, y.horas_paradas) , 2 ) as horas_falha_perc     
                 , round( ((y.horas_disponiveis - (y.horas_paradas - y.horas_falha_operacional)) / y.horas_disponiveis) * 100, 2) as perc_horas_sem_falha
                 , y.marca
				 , y.marca_id
                 , y.modelo
				 , y.modelo_id
              from (select t.organizacional_id,
                           (select o.descricao
                              from kss.v$organizacional o
                             where o.organizacional_id = t.organizacional_id) as centro_custo_gerencial,
                           count(*) as qtde_veiculos,
                           sum(t.os_encerrada) as qtde_veiculos_manut,
                           sum(t.os_aberta) as qtde_veiculos_os_aberta,						   
                           ( count(*) * 24 * ((t.data_fim + 1) - t.data_inicio)
                             *
                             t.percentual ) as horas_disponiveis,
                           round(nvl(sum(t.horas_paradas), 0)
                                 *
                                 t.percentual   , 2) as horas_paradas,
                           round(nvl(sum(t.horas_falha_operacional), 0), 2) as horas_falha_operacional,
                           t.percentual,
                           t.marca,
                           t.marca_id,
						   t.modelo,
						   t.modelo_id
                      from (select vcg.organizacional_id,
                                   ossub2.os_encerrada,
                                   ossub.horas_paradas,
                                   ossub.os_aberta,
                                   ossub2.horas_falha_operacional,
                                   to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio,
                                   to_date('#arguments.data_fim#', 'dd/mm/yyyy') as data_fim,
                                   nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                          from manutencao.v$ccgerencial_perc_trab cpt
                                         where cpt.organizacional_id = vcg.organizacional_id
                                           and cpt.data_vigencia >= vcg.data),1) as percentual,
								   ma.marca,
								   ma.marca_id,
								   vm.modelo,                                           
								   vm.modelo_id                                          
                              from oper.v$veiculo v
                             inner join manutencao.v$equipamento e
                                on e.cod_equipamento = v.cod_veiculo
                                or e.placa = v.placa
                              left join (select(manutencao.pkg_manutencao.fnc_horas_paradas(p_data_inicio    => '#arguments.data_inicio#'
                                                                                          , p_data_fim       => '#arguments.data_fim#'
                                                                                          , p_equipamento_id => e.equipamento_id
                                                                                           )) as horas_paradas
                                              , e.equipamento_id
                                              , e.placa
                                              , sign((select count(distinct os2.equipamento_id)
                                                        from manutencao.v$ordem_servico os2
                                                       where os2.equipamento_id = e.equipamento_id
                                                         and os2.data_fechamento is null)) as os_aberta
                                           from manutencao.v$ordem_servico os
                                          inner join almoxarifado.v$equipamento e 
                                             on e.equipamento_id = os.equipamento_id
                                          where ((trunc(os.data_abertura) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')) 
                                             or (trunc(os.data_fechamento) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy'))												
												)
												or (os.data_fechamento is null and os.data_abertura <= to_date('#arguments.data_fim#' || ' 23:59:59', 'dd/mm/yyyy hh24:mi:ss'))
                                          group by e.equipamento_id, e.placa) ossub
                                on ossub.equipamento_id = e.equipamento_id
                               and ossub.placa = e.placa
                              left join (select sign((select count(*)
                                              		    from manutencao.v$ordem_servico os2
                                                       where os2.equipamento_id = e.equipamento_id)) as os_encerrada
                                              ,(select sum(greatest(os2.data_abertura, to_date('#arguments.data_inicio#', 'dd/mm/yyyy')) - least(nvl(os2.data_fechamento, sysdate), to_date('#arguments.data_fim#', 'dd/mm/yyyy'))) * 24
                                                   from manutencao.v$ordem_servico os2
                                                  where os2.equipamento_id = e.equipamento_id
                                                    and os2.tipo_manutencao_id = 3) as horas_falha_operacional
                                              , e.equipamento_id
                                              , e.placa
                                           from manutencao.v$ordem_servico os
                                          inner join almoxarifado.v$equipamento e 
                                             on e.equipamento_id = os.equipamento_id
                                          where ((trunc(os.data_abertura) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')) 
                                             or (trunc(os.data_fechamento) between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))
                                            and os.data_fechamento is not null
                                          group by e.equipamento_id, e.placa) ossub2
                                on ossub2.equipamento_id = e.equipamento_id
                               and ossub2.placa = e.placa
                             inner join oper.v$veiculo_tipo_carroceria vtc
                                on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                             inner join oper.v$veiculo_agrupamento va
                                on va.agrupamento_id = vtc.agrupamento_id
                             inner join oper.v$veiculo_modalidade m
                                on m.placa = v.placa
                             inner join oper.v$veiculo_ccusto_gerencial vcg
                                on vcg.placa = v.placa
                             inner join oper.v$veiculo_hist_situacao vhs
                                on vhs.placa = v.placa
                             inner join oper.v$veiculo_marca ma
                                on v.marca_id = ma.marca_id
                             inner join oper.v$veiculo_modelo vm
                                 on v.marca_id = vm.marca_id
                                and v.modelo_id = vm.modelo_id
                             where va.tracao = 1
                               and vhs.situacao_id = 1
                             <cfif Len(Trim(arguments.modalidades))>  
                               and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
                             </cfif>
                               and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                                from oper.v$veiculo_hist_situacao vhs2
                                                               where vhs2.placa = v.placa
                                                                 and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                               and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                                from oper.v$veiculo_modalidade vm2
                                                               where vm2.placa = m.placa
                                                                 and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                               and vcg.veiculo_ccusto_id = (select max(vcg2.veiculo_ccusto_id) keep(dense_rank last order by vcg2.data)
                                                              from oper.v$veiculo_ccusto_gerencial vcg2
                                                             where vcg2.placa = vcg.placa
                                                               and vcg2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                          ) t
					  where 1 = 1
					  <cfif Len(Trim(arguments.organizacional_id))>  
					    and t.organizacional_id = '#arguments.organizacional_id#'
					  </cfif>
					  <cfif Len(Trim(arguments.marca_id_filtro))>  
					    and t.marca_id = '#arguments.marca_id_filtro#'
					  </cfif>
					  <cfif Len(Trim(arguments.modelo_id_filtro))>  
					    and t.modelo_id = '#arguments.modelo_id_filtro#'
					  </cfif>
                     group by t.organizacional_id, t.percentual, t.data_inicio, t.data_fim, t.marca, t.marca_id, t.modelo, t.modelo_id) y
					 order by y.organizacional_id, y.marca, y.modelo
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<!--- 
	-- PROPSITO 
	-- Busca se um recurso est� ou No ativo
	-- MARCELO F. AUGUSTO 17/02/2016
	--->
	<cffunction name="get_recurso_numerico" access="remote" returntype="string" output="true">
    	<cfargument name="identificador" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_controle.fnc_recurso_ativo('#arguments.identificador#') valor from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>

    <!---
    -- PROPSITO
    -- Busca os veiculos para os detalhes do Rel. Disponibilidade de Frota de um per�odo
    -- RAFAEL 05/11/2009 - CRIADO
    --->
    <cffunction name="get_disponibilidade_frota_veiculos" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfargument name="em_manutencao" required="no" default="0">
        <cfargument name="modalidades" required="no">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.cod_centro_custo
                 , x.os_encerrada
                 , x.placa
                 , x.frota
                 , x.classificacao
              from (select vcc.cod_centro_custo
                         , sign((select count(*)
                                   from manutencao.v$ordem_servico os
                                  inner join almoxarifado.v$equipamento e
                                     on e.equipamento_id = os.equipamento_id
                                  where e.placa = v.placa
                                    and os.data_fechamento is not null
                                    and os.data_abertura >= to_date('#arguments.data_inicio#', 'dd/mm/yyyy')
                                    and os.data_abertura <= to_date('#arguments.data_fim#', 'dd/mm/yyyy')
                                )
                               ) as os_encerrada
                         , v.placa
                         , v.cod_veiculo as frota
               			 , vtc.descricao as classificacao
                      from oper.v$veiculo v
                     inner join manutencao.v$equipamento e
                        on e.cod_equipamento = v.cod_veiculo
                        or e.placa = v.placa
                     inner join oper.v$veiculo_tipo_carroceria vtc
                        on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                     inner join oper.v$veiculo_agrupamento va
                        on va.agrupamento_id = vtc.agrupamento_id
                     inner join oper.v$veiculo_hist_situacao vhs
                        on vhs.placa = v.placa
                     inner join oper.v$veiculo_modalidade m
                        on m.placa = v.placa
                     inner join oper.v$veiculo_ccusto vcc
                        on vcc.placa = v.placa
                     where va.tracao = 1
                       and vhs.situacao_id = 1
                       and vcc.cod_centro_custo = #arguments.cod_centro_custo#
					 <cfif Len(Trim(arguments.modalidades))>
                       and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
                     </cfif>
                       and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                        from oper.v$veiculo_hist_situacao vhs2
                                                       where vhs2.placa = v.placa
                                                         and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                       and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                        from oper.v$veiculo_modalidade vm2
                                                       where vm2.placa = m.placa
                                                         and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                       and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                      from oper.v$veiculo_ccusto vcc2
                                                     where vcc2.placa = vcc.placa
                                                       and vcc2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
               		<cfif arguments.em_manutencao eq 1>
                       and ((select count(*)
                               from manutencao.v$ordem_servico os
                               inner join almoxarifado.v$equipamento e
                                       on e.equipamento_id = os.equipamento_id
                               where e.placa = v.placa
                                 and os.data_fechamento is not null
                                 and ((os.data_abertura between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                                      or (os.data_fechamento between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))
                            )
                           ) >= 1
               		</cfif>
                   ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca os veiculos para os detalhes do Rel. Disponibilidade de Frota de um per�odo (baseado em CCG)
    -- MARCELO 18/03/2016 - CRIADO
    --->
    <cffunction name="get_disponibilidade_frota_veiculos_ccg" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="organizacional_id" required="yes">
        <cfargument name="em_manutencao" required="no" default="0">
        <cfargument name="modalidades" required="no">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select x.organizacional_id
                 , x.os_encerrada
                 , x.placa
                 , x.frota
                 , x.classificacao
              from (select vcg.organizacional_id
                         , sign((select count(*)
                                   from manutencao.v$ordem_servico os
                                  inner join almoxarifado.v$equipamento e
                                          on e.equipamento_id = os.equipamento_id
                                  where e.placa = v.placa
                                    and os.data_fechamento is not null
                                    and ((trunc(os.data_abertura) between d.data_inicio and d.data_fim)
                                         or (trunc(os.data_fechamento) between d.data_inicio and d.data_fim))
                                )
                               ) as os_encerrada
                         , v.placa
                         , v.cod_veiculo as frota
                         , vtc.descricao as classificacao
                      from (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio
                                 , to_date('#arguments.data_fim#', 'dd/mm/yyyy') as data_fim
                              from dual
                           ) d
                         , oper.v$veiculo v
                     inner join manutencao.v$equipamento e
                        on e.cod_equipamento = v.cod_veiculo
                        or e.placa = v.placa
                     inner join oper.v$veiculo_tipo_carroceria vtc
                        on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                     inner join oper.v$veiculo_agrupamento va
                        on va.agrupamento_id = vtc.agrupamento_id
                     inner join oper.v$veiculo_modalidade m
                        on m.placa = v.placa
                     inner join oper.v$veiculo_ccusto_gerencial vcg
                        on vcg.placa = v.placa
                     inner join oper.v$veiculo_hist_situacao vhs
                        on vhs.placa = v.placa
					 inner join oper.v$veiculo_marca ma
						on v.marca_id = ma.marca_id
					 inner join oper.v$veiculo_modelo vm
						 on v.marca_id = vm.marca_id
						and v.modelo_id = vm.modelo_id
                     where va.tracao = 1
                       and vhs.situacao_id = 1
                       and vcg.organizacional_id = #arguments.organizacional_id#
					 <cfif Len(Trim(arguments.marca_id))>  
                       and v.marca_id = #arguments.marca_id#
                     </cfif>
					 <cfif Len(Trim(arguments.modelo_id))>  
                       and vm.modelo_id = #arguments.modelo_id#
                     </cfif>
					 <cfif Len(Trim(arguments.modalidades))>
                       and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
                     </cfif>
                       and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                        from oper.v$veiculo_hist_situacao vhs2
                                                       where vhs2.placa = v.placa
                                                         and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                       and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                        from oper.v$veiculo_modalidade vm2
                                                       where vm2.placa = m.placa
                                                         and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                       and vcg.veiculo_ccusto_id = (select max(vcg2.veiculo_ccusto_id) keep(dense_rank last order by vcg2.data)
                                                      from oper.v$veiculo_ccusto_gerencial vcg2
                                                     where vcg2.placa = vcg.placa
                                                       and vcg2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
					<cfif arguments.em_manutencao eq 1>
                       and ((select count(*)
                               from manutencao.v$ordem_servico os
                               inner join almoxarifado.v$equipamento e
                                       on e.equipamento_id = os.equipamento_id
                               where e.placa = v.placa
                                 and os.data_fechamento is not null
                                 and ((trunc(os.data_abertura) between d.data_inicio and d.data_fim)
                                      or (trunc(os.data_fechamento) between d.data_inicio and d.data_fim))
                            )
                           ) >= 1
            		</cfif>
					<cfif arguments.em_manutencao eq 2>
                       and ((select count(*)
                               from manutencao.v$ordem_servico os
                               inner join almoxarifado.v$equipamento e
                                       on e.equipamento_id = os.equipamento_id
                               where e.placa = v.placa
                                 and os.data_fechamento is null
                                 and ((trunc(os.data_abertura) between d.data_inicio and d.data_fim)
                                      or (trunc(os.data_fechamento) between d.data_inicio and d.data_fim))
                            )
                           ) >= 1
            		</cfif>
                   ) x
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca as OS para os detalhes do Rel. Disponibilidade de Frota de um per�odo
    -- RAFAEL 05/11/2009 - CRIADO
    --->
    <cffunction name="get_disponibilidade_frota_os" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="cod_centro_custo" required="yes">
        <cfargument name="modalidades" required="no">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.num_ordem_servico
                 , e.cod_equipamento as frota
                 , to_char(os.data_abertura , 'dd/mm/yyyy hh24:mi') as data_abertura
                 , to_char(os.data_fechamento , 'dd/mm/yyyy hh24:mi') as data_fechamento
                 , to_char(greatest(t.data_inicio,os.data_abertura), 'dd/mm/yyyy hh24:mi') as data_inicio_calculo
                 , to_char(least(t.data_fim,os.data_fechamento), 'dd/mm/yyyy hh24:mi') as data_termino_calculo
                 , kss.to_tempo(NumToDSInterval(( least(t.data_fim,os.data_fechamento) - greatest(t.data_inicio,os.data_abertura)) * 24 * 60, 'MINUTE'), 3).retorno as horas
                 , kss.to_tempo(NumToDSInterval(( least(t.data_fim,os.data_fechamento) - greatest(t.data_inicio,os.data_abertura)) * 24 * 60  * nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                                                                                                                                       from manutencao.v$ccusto_perc_trabalho cpt
                                                                                                                                                      where cpt.cod_centro_custo = vcc.cod_centro_custo
                                                                                                                                                        and cpt.data_vigencia >= vcc.data),1), 'MINUTE'), 3).retorno as horas_processadas
                 , os.valor_servico as valor
                 , os.user_insert as usuario
                 , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento e
                on e.equipamento_id = os.equipamento_id
             inner join oper.v$veiculo v
                on v.cod_veiculo = e.cod_equipamento
             inner join oper.v$veiculo_tipo_carroceria vtc
                on vtc.tipo_carroceria_id = v.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                on va.agrupamento_id = vtc.agrupamento_id
             inner join oper.v$veiculo_modalidade m
                on m.placa = v.placa
             inner join oper.v$veiculo_ccusto vcc
                on vcc.placa = v.placa
             inner join oper.v$veiculo_hist_situacao vhs
                on vhs.placa = v.placa
             inner join (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio,
                             to_date('#arguments.data_fim#', 'dd/mm/yyyy') as data_fim
                           from dual) t
                on (os.data_abertura   between t.data_inicio and t.data_fim)
                or (os.data_fechamento between t.data_inicio and t.data_fim)
             where va.tracao = 1
               and os.data_fechamento is not null
               and vhs.situacao_id = 1
			   and vcc.cod_centro_custo = #arguments.cod_centro_custo#
			 <cfif Len(Trim(arguments.modalidades))>
               and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
             </cfif>
               and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                from oper.v$veiculo_hist_situacao vhs2
                                               where vhs2.placa = v.placa
                                                 and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
               and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                from oper.v$veiculo_modalidade vm2
                                               where vm2.placa = m.placa
                                                 and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
               and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                              from oper.v$veiculo_ccusto vcc2
                                             where vcc2.placa = vcc.placa
                                               and vcc2.data <= (to_date('#arguments.data_fim#', 'dd/mm/yyyy')))
             order by os.data_abertura
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca as OS para os detalhes do Rel. Disponibilidade de Frota de um per�odo (Baseado em CCG)
    -- MARCELO 22/03/2016 - CRIADO
    --->
    <cffunction name="get_disponibilidade_frota_os_ccg" access="remote" returntype="query" output="true">
        <cfargument name="data_inicio" required="yes">
        <cfargument name="data_fim" required="yes">
        <cfargument name="organizacional_id" required="yes">
        <cfargument name="modalidades" required="no">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfargument name="somente_encerradas" required="no" default="1">		
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.num_ordem_servico
                 , e.cod_equipamento as frota
                 , to_char(os.data_abertura , 'dd/mm/yyyy hh24:mi') as data_abertura
                 , to_char(os.data_fechamento , 'dd/mm/yyyy hh24:mi') as data_fechamento
                 , to_char(greatest(t.data_inicio,os.data_abertura), 'dd/mm/yyyy hh24:mi') as data_inicio_calculo
                 , to_char(least(t.data_fim,nvl(os.data_fechamento, sysdate)), 'dd/mm/yyyy hh24:mi') as data_termino_calculo
                 , kss.to_tempo(NumToDSInterval(( least(t.data_fim,nvl(os.data_fechamento, sysdate)) - greatest(t.data_inicio,os.data_abertura)) * 24 * 60, 'MINUTE'), 3).retorno as horas
                 , kss.to_tempo(NumToDSInterval(( least(t.data_fim,nvl(os.data_fechamento, sysdate)) - greatest(t.data_inicio,os.data_abertura)) * 24 * 60  *  nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                                                                                                                                        from manutencao.v$ccgerencial_perc_trab cpt
                                                                                                                                                       where cpt.organizacional_id = vcg.organizacional_id
                                                                                                                                                         and cpt.data_vigencia >= vcg.data),1), 'MINUTE'), 3).retorno as horas_processadas
                 , os.valor_servico as valor
                 , os.user_insert as usuario
                 , to_char(os.data_abertura, 'dd/mm/yyyy hh24:mi') as data
				 , count(distinct os.equipamento_id) over() as total_placas
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento e
                on e.equipamento_id = os.equipamento_id
             inner join oper.v$veiculo v
                on v.cod_veiculo = e.cod_equipamento
             inner join oper.v$veiculo_tipo_carroceria vtc
                on vtc.tipo_carroceria_id = v.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                on va.agrupamento_id = vtc.agrupamento_id
             inner join oper.v$veiculo_modalidade m
                on m.placa = v.placa
             inner join oper.v$veiculo_ccusto_gerencial vcg
                on v.placa = vcg.placa
             inner join oper.v$veiculo_hist_situacao vhs
                on vhs.placa = v.placa
			 inner join oper.v$veiculo_marca ma
				on v.marca_id = ma.marca_id
			 inner join oper.v$veiculo_modelo vm
				on v.marca_id = vm.marca_id
			   and v.modelo_id = vm.modelo_id
             inner join (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio,
                                to_date('#arguments.data_fim#' || ' 23:59:59', 'dd/mm/yyyy hh24:mi:ss') as data_fim
                           from dual) t
                on (trunc(os.data_abertura)   between t.data_inicio and t.data_fim)
                or (trunc(os.data_fechamento) between t.data_inicio and t.data_fim)
				or (os.data_fechamento is null and os.data_abertura <= to_date('#arguments.data_fim#' || ' 23:59:59', 'dd/mm/yyyy hh24:mi:ss') )
             where va.tracao = 1
             <cfif Len(Trim(arguments.somente_encerradas)) and arguments.somente_encerradas eq 1>  
               and os.data_fechamento is not null
			 </cfif>
               and vhs.situacao_id = 1
               and vcg.organizacional_id = #arguments.organizacional_id#
			 <cfif Len(Trim(arguments.marca_id))>  
			   and v.marca_id = #arguments.marca_id#
			 </cfif>
			 <cfif Len(Trim(arguments.modelo_id))>  
			   and vm.modelo_id = #arguments.modelo_id#
			 </cfif>
			 <cfif Len(Trim(arguments.modalidades))>
               and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
             </cfif>
               and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                from oper.v$veiculo_hist_situacao vhs2
                                               where vhs2.placa = v.placa
                                                 and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
               and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                from oper.v$veiculo_modalidade vm2
                                               where vm2.placa = m.placa
                                                 and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
               and vcg.veiculo_ccusto_id = (select max(vcg2.veiculo_ccusto_id) keep(dense_rank last order by vcg2.data)
                                              from oper.v$veiculo_ccusto_gerencial vcg2
                                             where vcg2.placa = vcg.placa
                                               and vcg2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
             order by os.data_abertura
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca os veiculos do centro de custo e a sua disponibilidade
	-- NOTAS EXPLICATIVAS
	-- WAGNER 27/08/2012
	--->
	<cffunction name="get_disponibilidade_veic_ccusto" returntype="query" access="remote">
		<cfargument name="data_inicio" required="no" default="#lsdateformat(now())#">
        <cfargument name="data_fim" required="no" default="#lsdateformat(now())#">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="modalidades" required="no">
		<cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.cod_equipamento as frota,
                   y.horas_disponiveis,
                   y.horas_paradas,
                   y.horas_falha,
                   case
                    when y.horas_paradas > 0 then
                       round( nvl((( y.horas_falha * 100) / y.horas_paradas) , 0), 2)
                    else
                       0
                   end perc_horas_falha,
                   round(nvl(((y.horas_disponiveis - (y.horas_paradas - y.horas_falha )) * 100 /
                                     y.horas_disponiveis),
                                     0),
                                 2) as perc_horas_disp,
                   round( sum( y.horas_paradas ) over() ,2) as total_horas_paradas
              from (select t.cod_equipamento,
                           to_date('#arguments.data_inicio#', 'dd/mm/yyyy'),
                           to_date('#arguments.data_fim#', 'dd/mm/yyyy'),
                           ( (24 * (to_date('#arguments.data_fim#', 'dd/mm/yyyy') - to_date('#arguments.data_inicio#', 'dd/mm/yyyy'))) * t.percentual_centro_custo ) as horas_disponiveis,
                           (select least( round(nvl(sum(least(os.data_fechamento, to_date('#arguments.data_fim#', 'dd/mm/yyyy')) -
                                                        greatest(os.data_abertura, to_date('#arguments.data_inicio#', 'dd/mm/yyyy'))) * 24,
                                                     0),
                                                 2), (to_date('#arguments.data_fim#', 'dd/mm/yyyy') - to_date('#arguments.data_inicio#', 'dd/mm/yyyy')) * 24)
                                   * t.percentual_centro_custo
                              from manutencao.v$ordem_servico os
                             where os.equipamento_id = t.EQUIPAMENTO_ID
                               and os.data_fechamento is not null
                               and ((os.data_abertura between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and
                                   to_date('#arguments.data_fim#', 'dd/mm/yyyy')) or (os.data_fechamento between
                                   to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))) as horas_paradas,
                           (select round( nvl (sum(least(os.data_fechamento, to_date('#arguments.data_fim#', 'dd/mm/yyyy')) -
                                                   greatest(os.data_abertura, to_date('#arguments.data_inicio#', 'dd/mm/yyyy'))) * 24
                                                   * t.percentual_centro_custo, 0), 2)
                              from manutencao.v$ordem_servico os
                             where os.equipamento_id = t.EQUIPAMENTO_ID
                               and os.tipo_manutencao_id = 3
                               and os.data_fechamento is not null
                               and ((os.data_abertura between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and
                                   to_date('#arguments.data_fim#', 'dd/mm/yyyy')) or (os.data_fechamento between
                                   to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))) as horas_falha
                      from( select distinct e.COD_EQUIPAMENTO
                                 , e.equipamento_id
                                 , nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                          from manutencao.v$ccusto_perc_trabalho cpt
                                         where cpt.cod_centro_custo = vcc.cod_centro_custo
                                           and cpt.data_vigencia >= vcc.data),1) as percentual_centro_custo
                              from oper.v$veiculo_ccusto vcc
                             inner join oper.v$veiculo v
                                on v.placa = vcc.placa
                             inner join almoxarifado.v$equipamento e
                                on e.cod_equipamento = vcc.placa
                                or e.placa = vcc.placa
                             inner join oper.v$veiculo_tipo_carroceria vtc
                                on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                             inner join oper.v$veiculo_agrupamento va
                                on va.agrupamento_id = vtc.agrupamento_id
                             inner join oper.v$veiculo_modalidade m
                                on m.placa = v.placa
                             inner join oper.v$veiculo_hist_situacao vhs
                                on vhs.placa = v.placa
                             where va.tracao = 1
                               and vhs.situacao_id = 1
                               and vcc.cod_centro_custo = #arguments.cod_centro_custo#
						     <cfif Len(Trim(arguments.modalidades))>
                               and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
                             </cfif>
                               and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                                from oper.v$veiculo_hist_situacao vhs2
                                                               where vhs2.placa = v.placa
                                                                 and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                               and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                                from oper.v$veiculo_modalidade vm2
                                                               where vm2.placa = m.placa
                                                                 and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                               and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                                              from oper.v$veiculo_ccusto vcc2
                                                             where vcc2.placa = vcc.placa
                                                               and vcc2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy') )
                      ) t
                   ) y
              order by y.cod_equipamento
        </cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os veiculos do centro de custo GERENCIAL e a sua disponibilidade
	-- NOTAS EXPLICATIVAS
	-- MARCELO 22/03/2016
	--->
	<cffunction name="get_disponibilidade_veic_ccgerencial" returntype="query" access="remote">
		<cfargument name="data_inicio" required="no" default="#lsdateformat(now())#">
        <cfargument name="data_fim" required="no" default="#lsdateformat(now())#">
        <cfargument name="organizacional_id" required="no" default="">
        <cfargument name="modalidades" required="no">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select y.cod_equipamento as frota,
                   y.horas_disponiveis,
                   y.horas_paradas,
                   y.horas_falha,
                   case
                    when y.horas_paradas > 0 then
                       round( nvl((( y.horas_falha * 100) / y.horas_paradas) , 0), 2)
                    else
                       0
                   end perc_horas_falha,
                   round(nvl(((y.horas_disponiveis - (y.horas_paradas - y.horas_falha )) * 100 /
                                     y.horas_disponiveis),
                                     0),
                                 2) as perc_horas_disp,
                   round( sum( y.horas_paradas ) over() ,2) as total_horas_paradas
              from (select t.cod_equipamento,
                           to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio,
                           to_date('#arguments.data_fim#', 'dd/mm/yyyy') as data_fim,
                           ( (24 * (to_date('#arguments.data_fim#', 'dd/mm/yyyy') - to_date('#arguments.data_inicio#', 'dd/mm/yyyy'))) * t.percentual_centro_custo ) as horas_disponiveis,
                           (select least( round(nvl(sum(least(os.data_fechamento, to_date('#arguments.data_fim#', 'dd/mm/yyyy')) -
                                                        greatest(os.data_abertura, to_date('#arguments.data_inicio#', 'dd/mm/yyyy'))) * 24,
                                                     0),
                                                 2), (to_date('#arguments.data_fim#', 'dd/mm/yyyy') - to_date('#arguments.data_inicio#', 'dd/mm/yyyy')) * 24)
                                   * t.percentual_centro_custo
                              from manutencao.v$ordem_servico os
                             where os.equipamento_id = t.EQUIPAMENTO_ID
                               and os.data_fechamento is not null
                               and ((os.data_abertura between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and
                                   to_date('#arguments.data_fim#', 'dd/mm/yyyy')) or (os.data_fechamento between
                                   to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))) as horas_paradas,
                           (select round( nvl (sum(least(os.data_fechamento, to_date('#arguments.data_fim#', 'dd/mm/yyyy')) -
                                                   greatest(os.data_abertura, to_date('#arguments.data_inicio#', 'dd/mm/yyyy'))) * 24
                                                   * t.percentual_centro_custo, 0), 2)
                              from manutencao.v$ordem_servico os
                             where os.equipamento_id = t.EQUIPAMENTO_ID
                               and os.tipo_manutencao_id = 3
                               and os.data_fechamento is not null
                               and ((os.data_abertura between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and
                                   to_date('#arguments.data_fim#', 'dd/mm/yyyy')) or (os.data_fechamento between
                                   to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))) as horas_falha
                      from( select distinct e.COD_EQUIPAMENTO
                                 , e.equipamento_id
                                 , nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                          from manutencao.v$ccgerencial_perc_trab cpt
                                         where cpt.organizacional_id = vcg.organizacional_id
                                           and cpt.data_vigencia >= vcg.data),1) as percentual_centro_custo
                              from oper.v$veiculo_ccusto_gerencial vcg
                             inner join oper.v$veiculo v
                                on v.placa = vcg.placa
                             inner join almoxarifado.v$equipamento e
                                on e.cod_equipamento = vcg.placa
                                or e.placa = vcg.placa
                             inner join oper.v$veiculo_tipo_carroceria vtc
                                on vtc.tipo_carroceria_id = v.tipo_carroceria_id
                             inner join oper.v$veiculo_agrupamento va
                                on va.agrupamento_id = vtc.agrupamento_id
                             inner join oper.v$veiculo_modalidade m
                                on m.placa = v.placa
                             inner join oper.v$veiculo_hist_situacao vhs
                                on vhs.placa = v.placa
							 inner join oper.v$veiculo_marca ma
								on v.marca_id = ma.marca_id
							 inner join oper.v$veiculo_modelo vm
								on v.marca_id = vm.marca_id
							   and v.modelo_id = vm.modelo_id
                             where va.tracao = 1
                               and vhs.situacao_id = 1
                               and vcg.organizacional_id = #arguments.organizacional_id#
						     <cfif Len(Trim(arguments.marca_id))>  
							   and v.marca_id = #arguments.marca_id#
							 </cfif>
							 <cfif Len(Trim(arguments.modelo_id))>  
							   and vm.modelo_id = #arguments.modelo_id#
							 </cfif>
						     <cfif Len(Trim(arguments.modalidades))>
                               and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
                             </cfif>
                               and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                                from oper.v$veiculo_hist_situacao vhs2
                                                               where vhs2.placa = v.placa
                                                                 and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                               and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                                from oper.v$veiculo_modalidade vm2
                                                               where vm2.placa = m.placa
                                                                 and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                               and vcg.veiculo_ccusto_id = (select max(vcg2.veiculo_ccusto_id) keep(dense_rank last order by vcg2.data)
                                                              from oper.v$veiculo_ccusto_gerencial vcg2
                                                             where vcg2.placa = vcg.placa
                                                               and vcg2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                      ) t
                   ) y
              order by y.cod_equipamento
        </cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
	-- PROPSITO
	-- Busca as Ordens de servi�o de Falha operacional do per�odo para o centro de custo gerencial
	-- NOTAS EXPLICATIVAS
	-- MARCELO 18/03/2016
	--->
	<cffunction name="get_ordem_servico_falha_ccgerencial" returntype="query" access="remote">
		<cfargument name="data_inicio" required="no" default="#lsdateformat(now())#">
        <cfargument name="data_fim" required="no" default="#lsdateformat(now())#">
        <cfargument name="organizacional_id" required="no" default="">
        <cfargument name="modalidades" required="no">
		<cfargument name="marca_id" required="no" default="">
		<cfargument name="modelo_id" required="no" default="">
		<cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.num_ordem_servico
                 , e.cod_equipamento as equipamento
                 , to_char(os.data_abertura, 'dd/mm/yyyy  hh24:mi') as data_abertura
                 , to_char(os.data_fechamento, 'dd/mm/yyyy  hh24:mi') as data_fechamento
                 , kss.to_tempo(NumToDSInterval((os.data_fechamento - os.data_abertura) * 24 * 60, 'MINUTE'), 3).retorno as horasf
                 , kss.to_tempo(NumToDSInterval((os.data_fechamento - os.data_abertura) * 24 * 60 * nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                                                                                           from manutencao.v$ccgerencial_perc_trab cpt
                                                                                                          where cpt.organizacional_id = vcg.organizacional_id
                                                                                                            and cpt.data_vigencia >= vcg.data),1) , 'MINUTE'), 3).retorno as horasf_proc
                 , kss.to_tempo(NumToDSInterval(sum( (os.data_fechamento - os.data_abertura) ) over() * 24 * 60, 'MINUTE'), 3).retorno as total_horasf
                 , kss.to_tempo(NumToDSInterval(sum((os.data_fechamento -
                                        os.data_abertura)) over() * 24 * 60 *
                                        nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                               from manutencao.v$ccgerencial_perc_trab cpt
                                              where cpt.organizacional_id = vcg.organizacional_id
                                                and cpt.data_vigencia >= vcg.data),1),
                                    'MINUTE'),
                    3) .retorno as total_horasf_proc
                 , round((os.data_fechamento - os.data_abertura) * 24,2) as horas
                 , round(sum( (os.data_fechamento - os.data_abertura) * 24 ) over(),2) as total_horas
              from (select to_date('#arguments.data_inicio#', 'dd/mm/yyyy') as data_inicio,
                           to_date('#arguments.data_fim#', 'dd/mm/yyyy') as data_fim
                      from dual) d
                      , manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento e
                on e.equipamento_id = os.equipamento_id
             inner join oper.v$veiculo v
                on v.cod_veiculo = e.cod_equipamento
             inner join oper.v$veiculo_tipo_carroceria vtc
                on vtc.tipo_carroceria_id = v.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                on va.agrupamento_id = vtc.agrupamento_id
             inner join oper.v$veiculo_modalidade m
                on m.placa = v.placa
             inner join oper.v$veiculo_ccusto_gerencial vcg
                on vcg.placa = e.placa
             inner join oper.v$veiculo_hist_situacao vhs
                on vhs.placa = v.placa
			 inner join oper.v$veiculo_marca ma
				on v.marca_id = ma.marca_id
			 inner join oper.v$veiculo_modelo vm
				on v.marca_id = vm.marca_id
			   and v.modelo_id = vm.modelo_id
             where va.tracao = 1
               and vhs.situacao_id = 1
               and vcg.organizacional_id = #arguments.organizacional_id#
               and os.tipo_manutencao_id = 3
               and os.data_fechamento is not null
			 <cfif Len(Trim(arguments.marca_id))>  
			   and v.marca_id = #arguments.marca_id#
			 </cfif>
			 <cfif Len(Trim(arguments.modelo_id))>  
			   and vm.modelo_id = #arguments.modelo_id#
			 </cfif>
			 <cfif Len(Trim(arguments.modalidades))>
               and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
             </cfif>
               and ((os.data_abertura between d.data_inicio and d.data_fim)
                     or
                    (os.data_fechamento between d.data_inicio and d.data_fim))
               and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                from oper.v$veiculo_hist_situacao vhs2
                                               where vhs2.placa = v.placa
                                                 and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
               and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                from oper.v$veiculo_modalidade vm2
                                               where vm2.placa = m.placa
                                                 and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
               and vcg.veiculo_ccusto_id = (select max(vcg2.veiculo_ccusto_id) keep(dense_rank last order by vcg2.data)
                                              from oper.v$veiculo_ccusto_gerencial vcg2
                                             where vcg2.placa = vcg.placa
                                               and vcg2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
        </cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
	-- PROPSITO
	-- Busca as Ordens de servi�o de Falha operacional do per�odo para o centro de custo
	-- NOTAS EXPLICATIVAS
	-- WAGNER 27/08/2012
	--->
	<cffunction name="get_ordem_servico_falha_ccusto" returntype="query" access="remote">
		<cfargument name="data_inicio" required="no" default="#lsdateformat(now())#">
        <cfargument name="data_fim" required="no" default="#lsdateformat(now())#">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="modalidades" required="no">
		<cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select os.num_ordem_servico
                 , e.cod_equipamento as equipamento
                 , to_char(os.data_abertura, 'dd/mm/yyyy  hh24:mi') as data_abertura
                 , to_char(os.data_fechamento, 'dd/mm/yyyy  hh24:mi') as data_fechamento
                 , kss.to_tempo(NumToDSInterval((os.data_fechamento - os.data_abertura) * 24 * 60, 'MINUTE'), 3).retorno as horasf
                 , kss.to_tempo(NumToDSInterval((os.data_fechamento - os.data_abertura) * 24 * 60 *  nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                                                                                            from manutencao.v$ccusto_perc_trabalho cpt
                                                                                                           where cpt.cod_centro_custo = vcc.cod_centro_custo
                                                                                                             and cpt.data_vigencia >= vcc.data),1) , 'MINUTE'), 3).retorno as horasf_proc
                 , kss.to_tempo(NumToDSInterval(sum( (os.data_fechamento - os.data_abertura) ) over() * 24 * 60, 'MINUTE'), 3).retorno as total_horasf
                 , kss.to_tempo(NumToDSInterval(sum((os.data_fechamento -
                                        os.data_abertura)) over() * 24 * 60 *
                                        nvl((select max(cpt.percentual) keep(dense_rank last order by cpt.data_vigencia)/100
                                               from manutencao.v$ccusto_perc_trabalho cpt
                                              where cpt.cod_centro_custo = vcc.cod_centro_custo
                                                and cpt.data_vigencia >= vcc.data),1),
                                    'MINUTE'),
                    3) .retorno as total_horasf_proc
                 , round((os.data_fechamento - os.data_abertura) * 24,2) as horas
                 , round(sum( (os.data_fechamento - os.data_abertura) * 24 ) over(),2) as total_horas
              from manutencao.v$ordem_servico os
             inner join almoxarifado.v$equipamento e
                on e.equipamento_id = os.equipamento_id
             inner join oper.v$veiculo_controle v
                on v.cod_veiculo = e.cod_equipamento
             inner join oper.v$veiculo_tipo_carroceria vtc
                on vtc.tipo_carroceria_id = v.tipo_carroceria_id
             inner join oper.v$veiculo_agrupamento va
                on va.agrupamento_id = vtc.agrupamento_id
             inner join oper.v$veiculo_modalidade m
                on m.placa = v.placa
             inner join oper.v$veiculo_ccusto vcc
                on e.placa = vcc.placa
             inner join oper.v$veiculo_hist_situacao vhs
                on vhs.placa = v.placa
             where va.tracao = 1
               and os.tipo_manutencao_id = 3
               and os.data_fechamento is not null
               and vhs.situacao_id = 1
               and vcc.cod_centro_custo = #arguments.cod_centro_custo#
			 <cfif Len(Trim(arguments.modalidades))>
               and m.modalidade in(select column_value from table(kss.pkg_string.fnc_split('#arguments.modalidades#', ',')))
             </cfif>
               and ((os.data_abertura between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
                     or
                    (os.data_fechamento between to_date('#arguments.data_inicio#', 'dd/mm/yyyy') and to_date('#arguments.data_fim#', 'dd/mm/yyyy')))
               and vhs.veiculo_situacao_id = (select max(vhs2.veiculo_situacao_id) keep(dense_rank last order by vhs2.data)
                                                from oper.v$veiculo_hist_situacao vhs2
                                               where vhs2.placa = v.placa
                                                 and vhs2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
               and m.veiculo_modalidade_id = (select max(vm2.veiculo_modalidade_id) keep(dense_rank last order by vm2.data)
                                                from oper.v$veiculo_modalidade vm2
                                               where vm2.placa = m.placa
                                                 and vm2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
               and vcc.veiculo_ccusto_id = (select max(vcc2.veiculo_ccusto_id) keep(dense_rank last order by vcc2.data)
                                              from oper.v$veiculo_ccusto vcc2
                                             where vcc2.placa = vcc.placa
                                               and vcc2.data <= to_date('#arguments.data_fim#', 'dd/mm/yyyy'))
        </cfquery>
		<cfreturn qr_result>
	</cffunction>


    <!---
	-- PROPSITO
	-- Busca as Ordens de servi�o de Falha operacional do per�odo para o centro de custo
	-- NOTAS EXPLICATIVAS
	-- WAGNER 27/08/2012
	--->
	<cffunction name="get_modalidade_cg_ref_code" returntype="query" access="remote">
		<cfquery result="QUERY" name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select c.rv_abbreviation as modalidade
                 , c.rv_low_value as chave_modalidade
              from kss.cg_ref_codes c
             where c.owner = 'OPER'
   			   and c.rv_domain = 'VEICULO_MODALIDADE.MODALIDADE'
        </cfquery>
		<cfreturn qr_result>
	</cffunction>

	<!---
	-- PROPSITO
	-- Busca o valor de um par�metro
	-- RAFAEL PENCZKOSKI 18/10/2016 17:02:46 - CRIADO
	--->
	<cffunction name="get_parametro_valor_lista" access="remote" returntype="string" output="true">
    	<cfargument name="identificador" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_parametro.fnc_valor_lista('#arguments.identificador#') as valor from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>

   <!---
   -- PROPSITO
   -- Pegar o horario do banco para usar no manuten��o
   -- LUIS THIAGO PADILHA 06/01/2016 17:02:46 - CRIADO
   --->
   <cffunction name="get_horario_fechamento" access="remote" returntype="string" output="true">
      <cfquery name="get_horario_fechamento" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select TO_CHAR(SYSDATE, 'DD/MM/YYYY hh24:mi') as data_banco
           from dual
      </cfquery>
      <cfreturn get_horario_fechamento.data_banco>
   </cffunction>


   <!---
   -- PROPSITO
   -- Busca o hisotrico de atividades executadas no veiculo
   -- IGOR NOBREGA 18/02/2020 09:57 - CRIADO
   --->
   <cffunction name="get_veiculo_atividade_historico" returntype="query" access="remote">
      <cfargument name="placa" required="no" default="">
      <cfargument name="ordem_servico_id" required="no" default="">
      <cfargument name="equipamento_id" required="no" default="">
      <cfargument name="atividade_id" required="no" default="">
      <cfargument name="nao_executada" required="no" default="">
      <cfargument name="km" required="no" default="">
      <cfargument name="data_inicio" required="no" default="">
      <cfargument name="data_termino" required="no" default="">
      <cfset v_composicao = this.get_composicao(placa = arguments.placa, equipamento_id = arguments.equipamento_id)>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
select distinct os.ordem_servico_id
            , etm.controle_id
            , a.atividade_id
            , a.cod_atividade
            , a.titulo
            , a.garantia_dias
            , nvl(a.alerta_dias,0) as alerta_dias
            , nvl(a.alerta_km, 0) as alerta_km
            , e.equipamento_id
            , e.cod_equipamento
            , a.importancia
            , a.garantia_km
            , e.placa
            , ep.POSICAO_ID
            , em.MODELO_ID
            , etm.ORDEM_SERVICO_ID_EXECUCAO
            , etm.km_previsao
            , etm.DATA_PREVISAO
            , nvl(ep.posicao, 'nica') as posicao
            , (etm.km_previsao - (select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                                    from oper.v$veiculo_km t
                                    where t.placa = e.placa)) as km_previsto                           
            , decode(a.garantia_dias,0, 0, round(etm.data_previsao - sysdate)) as dias 
                  , (case
                  when etm.ordem_servico_id_execucao is null
                     and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                           from oper.v$veiculo_km t
                           where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                    from oper.v$veiculo_composicao_km
                                                                                 where placa = e.placa
                                                                                    and data_fim is not null)) > etm.km_previsao
                     and a.garantia_km > 0)
                     or (etm.km_previsao < etm.km_previsao and a.garantia_km > 0)
                     or (sysdate > etm.data_previsao and a.garantia_dias > 0) then
                     'VENCIDO'
                  when etm.ordem_servico_id_execucao is null
                     and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                           from oper.v$veiculo_km t
                           where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                    from oper.v$veiculo_composicao_km
                                                                                 where placa = e.placa
                                                                                    and data_fim is not null)) + a.alerta_km > etm.km_previsao and a.garantia_km > 0) 
                     or (a.garantia_dias > 0) then
                     'A VENCER'
                  when etm.ordem_servico_id_execucao is null and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                                                                     from oper.v$veiculo_km t
                                                                  where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                                                           from oper.v$veiculo_composicao_km
                                                                                                                           where placa = e.placa
                                                                                                                           and data_fim is not null)) <= etm.km_previsao or sysdate <= etm.data_previsao) then
                     'OK'
                  else
                     'EXECUTADA'
            end) as status
            , (case
                  when etm.ordem_servico_id_execucao is null
                     and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                              from oper.v$veiculo_km t
                           where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                    from oper.v$veiculo_composicao_km
                                                                                    where placa = e.placa
                                                                                    and data_fim is not null)) > etm.km_previsao and a.garantia_km > 0)
                     or (sysdate > etm.data_previsao and a.garantia_dias > 0) then
                     -2
                  when etm.ordem_servico_id_execucao is null
                     and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                              from oper.v$veiculo_km t
                           where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                    from oper.v$veiculo_composicao_km
                                                                                    where placa = e.placa
                                                                                    and data_fim is not null)) + a.alerta_km > etm.km_previsao and a.garantia_km > 0)
                     or (sysdate + a.alerta_dias > etm.data_previsao and a.garantia_dias > 0) then 
                     -1
                  when etm.ordem_servico_id_execucao is null
                     and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                              from oper.v$veiculo_km t
                           where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                    from oper.v$veiculo_composicao_km
                                                                                    where placa = e.placa
                                                                                    and data_fim is not null)) <= etm.km_previsao or sysdate <= etm.data_previsao) then 
                     1
                  else 0 
            end) as status_id
         from manutencao.v$ordem_servico os
         inner join almoxarifado.v$equipamento e
            on e.equipamento_id = os.equipamento_id
         inner join manutencao.v$os_atividade osa
            on osa.ORDEM_SERVICO_ID = os.ordem_servico_id
         inner join manutencao.v$atividade a
            on a.atividade_id = osa.ATIVIDADE_ID
         inner join manutencao.v$equipamento_posicao ep
            on ep.POSICAO_ID = osa.POSICAO_ID
         left join manutencao.v$equipamento_atividade ea
            on ea.equipamento_id = e.equipamento_id    
         inner join manutencao.v$tabela_atividade ta
            on ta.ATIVIDADE_ID = a.atividade_id    
         left join manutencao.v$equipamento_modelo em
            on em.EQUIPAMENTO_ID = e.equipamento_id
         inner join manutencao.v$equipamento_tabela_manut etm
            on etm.TABELA_ID = ta.TABELA_ID 
            and etm.EQUIPAMENTO_ID = e.equipamento_id
         where 1=1
         <cfif Len(Trim(arguments.placa)) or Len(Trim(arguments.equipamento_id))>
			   and e.equipamento_id in (#v_composicao#)
		 </cfif>
		 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
            and os.data_abertura between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino# 23:59:59', 'dd/mm/yyyy hh24:mi:ss')
         </cfif>
      </cfquery>
      <cfreturn qr_result>
   </cffunction>

      <!---
   -- PROPSITO
   -- Busca o hisotrico de atividades executadas no veiculo
   -- IGOR NOBREGA 18/02/2020 09:57 - CRIADO
   --->
   <cffunction name="get_veiculo_atividade_historico_modal" returntype="query" access="remote">
      <cfargument name="placa" required="no" default="">
      <cfargument name="ordem_servico_id" required="no" default="">
      <cfargument name="equipamento_id" required="no" default="">
      <cfargument name="atividade_id" required="no" default="">
      <cfargument name="nao_executada" required="no" default="">
      <cfargument name="km" required="no" default="">
      <cfset v_composicao = this.get_composicao(placa = arguments.PLACA, equipamento_id = arguments.EQUIPAMENTO_ID)>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
         select e.placa as cod_equipamento
            , osa.posicao_id
            , ep.POSICAO
            , os.ordem_servico_id
            , os.num_ordem_servico
            , etm.km_previsao
            , etm.KM_PREVISAO as km_previsto
            , nvl(a.alerta_km,0) as alerta_km
            , (etm.KM_PREVISAO - os.km_abertura) as diferenca
            , etm.DATA_PREVISAO
            , nvl(a.alerta_dias,0) as alerta_dias
            , nvl((etm.DATA_PREVISAO - etm.DATA_EXECUCAO),0) as dias
            
            , (case
                           when etm.ordem_servico_id_execucao is null
                              and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                                    from oper.v$veiculo_km t
                                    where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                             from oper.v$veiculo_composicao_km
                                                                                          where placa = e.placa
                                                                                             and data_fim is not null)) > etm.km_previsao
                              and a.garantia_km > 0)
                              or (etm.km_previsao < etm.km_previsao and a.garantia_km > 0)
                              or (sysdate > etm.data_previsao and a.garantia_dias > 0) then
                              'VENCIDO'
                           when etm.ordem_servico_id_execucao is null
                              and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                                    from oper.v$veiculo_km t
                                    where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                             from oper.v$veiculo_composicao_km
                                                                                          where placa = e.placa
                                                                                             and data_fim is not null)) + a.alerta_km > etm.km_previsao and a.garantia_km > 0) 
                              or (a.garantia_dias > 0) then
                              'A VENCER'
                           when etm.ordem_servico_id_execucao is null and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                                                                              from oper.v$veiculo_km t
                                                                           where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                                                                    from oper.v$veiculo_composicao_km
                                                                                                                                    where placa = e.placa
                                                                                                                                    and data_fim is not null)) <= etm.km_previsao or sysdate <= etm.data_previsao) then
                              'OK'
                           else
                              'EXECUTADA'
                     end) as status 
               , (case
                  when etm.ordem_servico_id_execucao is null
                     and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                              from oper.v$veiculo_km t
                           where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                    from oper.v$veiculo_composicao_km
                                                                                    where placa = e.placa
                                                                                    and data_fim is not null)) > etm.km_previsao and a.garantia_km > 0)
                     or (sysdate > etm.data_previsao and a.garantia_dias > 0) then
                     -2
                  when etm.ordem_servico_id_execucao is null
                     and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                              from oper.v$veiculo_km t
                           where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                    from oper.v$veiculo_composicao_km
                                                                                    where placa = e.placa
                                                                                    and data_fim is not null)) + a.alerta_km > etm.km_previsao and a.garantia_km > 0)
                     or (sysdate + a.alerta_dias > etm.data_previsao and a.garantia_dias > 0) then 
                     -1
                  when etm.ordem_servico_id_execucao is null
                     and ((select nvl( max(t.km) keep (dense_rank last order by t.data_hora) , 0)
                              from oper.v$veiculo_km t
                           where t.placa = e.placa and t.data_hora <= sysdate + (select nvl(sum(km_fim-km_inicio), 0)
                                                                                    from oper.v$veiculo_composicao_km
                                                                                    where placa = e.placa
                                                                                    and data_fim is not null)) <= etm.km_previsao or sysdate <= etm.data_previsao) then 
                     1
                  else 0 
            end) as status_id    
         from manutencao.v$ordem_servico os
         inner join manutencao.v$os_atividade osa
            on osa.ordem_servico_id = os.ordem_servico_id
         inner join manutencao.v$atividade a
            on a.atividade_id = osa.atividade_id
         inner join almoxarifado.v$equipamento e
            on e.equipamento_id =  os.equipamento_id
         inner join manutencao.v$equipamento_tabela_manut etm
            on etm.EQUIPAMENTO_ID = e.equipamento_id
         inner join manutencao.v$equipamento_posicao ep
            on ep.POSICAO_ID = osa.posicao_id
         where 1=1
         <cfif Len(Trim(arguments.placa)) or Len(Trim(arguments.equipamento_id))>
			   and e.equipamento_id in (#v_composicao#)
			</cfif>
         <cfif Len(Trim(arguments.atividade_id))>
            and a.atividade_id = '#arguments.atividade_id#'
         </cfif>
      </cfquery>
      <cfreturn qr_result>
   </cffunction>

   <!---
   -- PROPSITO
   -- Busca o hisotrico de materiais montados no veiculo
   -- IGOR NOBREGA 18/02/2020 09:57 - CRIADO
   --->

     <cffunction name="get_veiculo_material_historico" returntype="query" access="remote">
      <cfargument name="placa" required="no" default="">
      <cfargument name="equipamento_id" required="no" default="">
      <cfargument name="km_atual" required="no" default="">
      <cfargument name="data_inicial" required="no" default="">
      <cfargument name="data_final" required="no" default="">
      <cfset v_composicao = this.get_composicao(placa = arguments.placa, equipamento_id = arguments.equipamento_id)>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select distinct os.ordem_servico_id
               , e.placa
               , ma.COD_MATERIAL
               , ma.TITULO
               , e.cod_equipamento
               , ma.MATERIAL_ID
               , etm.km_previsao
               , etm.DATA_PREVISAO
               , nvl(manutencao.to_manut_material(ma.material_id).alerta_km,0) as alerta_km
               , nvl(manutencao.to_manut_material(ma.material_id).alerta_dias,0) as alerta_dias
               , round(sysdate - etm.data_previsao) as dias
               , nvl(ep.posicao, 'nica') as posicao
               , ma.cod_material as cod_equipamento_identificado
               , mem.data_desmontagem
               , case
                     when (mem.ordem_servico_id_desmontagem is null 
                        and (manutencao.to_veiculo_km(e.cod_equipamento,sysdate,sysdate).km_data_inicial > etm.km_previsao 
                        and etm.km_previsao > 0) 
                        or sysdate > etm.data_previsao) then -2
                     when (mem.ordem_servico_id_desmontagem is null 
                        and (manutencao.to_veiculo_km(e.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_material(ma.material_id).alerta_km > etm.km_previsao
                        and etm.km_previsao > 0)
                        or sysdate + manutencao.to_manut_material(ma.material_id).alerta_dias > etm.data_previsao) then -1
                     when mem.ordem_servico_id_desmontagem is null
                     and (manutencao.to_veiculo_km(e.cod_equipamento,sysdate,sysdate).km_data_inicial <= etm.km_previsao
                     or sysdate <= etm.data_previsao) then 1
                  else 0 end status_id
               , case
                     when (mem.ordem_servico_id_desmontagem is null
                     and (manutencao.to_veiculo_km(e.cod_equipamento,sysdate,sysdate).km_data_inicial > etm.km_previsao
                           and etm.km_previsao > 0)
                        or sysdate > etm.data_previsao) then 'Vencido'
                     when (mem.ordem_servico_id_desmontagem is null
                     and (manutencao.to_veiculo_km(e.cod_equipamento,sysdate,sysdate).km_data_inicial + manutencao.to_manut_material(ma.material_id).alerta_km > etm.km_previsao
                           and etm.km_previsao > 0)
                        or sysdate + manutencao.to_manut_material(ma.material_id).alerta_dias > etm.data_previsao) then 'A Vencer'
                     when mem.ordem_servico_id_desmontagem is null
                     and (manutencao.to_veiculo_km(e.cod_equipamento,sysdate,sysdate).km_data_inicial <= etm.km_previsao
                        or sysdate <= etm.data_previsao) then 'Ok'
            else 'Executada' end status
            from manutencao.v$ordem_servico os
            inner join manutencao.v$os_material osm
               on osm.ORDEM_SERVICO_ID = os.ordem_servico_id
            inner join almoxarifado.v$material ma
               on ma.material_id = osm.MATERIAL_ID    
            inner join manutencao.v$equipamento_tabela_manut etm
               on etm.EQUIPAMENTO_ID = os.equipamento_id
            inner join manutencao.v$equipamento_posicao ep
               on ep.POSICAO_ID = osm.POSICAO_ID
            inner join almoxarifado.v$equipamento e
               on e.equipamento_id =  os.equipamento_id
            left join manutencao.v$equipamento_material mem
               on mem.equipamento_id = e.equipamento_id
            where 1=1
               <cfif Len(Trim(arguments.placa)) or Len(Trim(arguments.equipamento_id))>
					   and e.equipamento_id in (#v_composicao#)
				   </cfif>
         order by os.ordem_servico_id, etm.DATA_PREVISAO, etm.KM_PREVISAO
      </cfquery>
      <cfreturn qr_result>
   </cffunction>

</cfcomponent>
