<cfcomponent displayname="Componentes de consulta para controle de trfego" extends="_transportes.funcoes.cfc_init" output="yes">
	<!--- 
	-- PROPSITO
	-- Consulta o funcionrio pelo cdigo
	-- NOTAS EXPLICATIVAS
	-- CRISTOFER
	--->	
	<cffunction name="get_funcionario" displayname="Consulta funcionrio pelo cdigo" access="remote" returntype="query" output="true">
		<cfargument name="cod_funcionario" required="no" default="">
		<cfargument name="pessoa" required="no" default="0">
		<cfargument name="nome" required="no" default="">
		<cfargument name="ativos" required="no" default="0">
		<cfargument name="filtro" required="no" default="">
        <cfargument name="num_modalidade" required="no" default="">
		<cfif arguments.pessoa EQ 0>
			<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
				<cfif session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'vialacteos/' or session.site eq 'braf/'>
				 select distinct fma.num_matricula cod_funcionario,
                        f.nome_funcionario,
                        f.cpf_funcionario,
                        to_char(f.cod_pessoa) as cod_pessoa,
                        f.cod_entreposto as empresa
                   from oper.v$rh_funcionario f
              left join kss.v$funcionario_matr_atual fma
                     on fma.cod_pessoa = f.cod_pessoa
                  where 1 = 1
                 <cfelse>
				 <cfif session.site eq 'bbmtransportes/'>
				select distinct
					   f.cod_funcionario, 
					   f.nome_funcionario, 
					   f.cpf_funcionario, 
					   to_char(f.cod_pessoa) as cod_pessoa,
					   f.cod_entreposto as empresa
				  from oper.v$rh_funcionario f
				 where 1=1
				<cfelseif session.site eq 'transemba/'>
                select fd.matricula as cod_funcionario
                     , fd.nome as nome_funcionario
                     , fd.cpf as cpf_funcionario
                     , to_char(fd.cod_pessoa) as cod_pessoa
                     , fd.cod_pessoa_empresa as empresa
                  from folha.v$funcionario_dados fd
                 where fd.data_demissao is null
                 	<cfif Len(Trim(session.cod_pessoa))>
                   		and fd.cod_pessoa_empresa = #session.cod_pessoa#
                   </cfif>
				<cfelse>
					select distinct
						   to_char(oper.pkg_global.fnc_get_cod_funcionario(f.cod_pessoa)) cod_funcionario,
						   f.nome_funcionario, 
						   f.cpf_funcionario, 
						   to_char(oper.pkg_global.fnc_get_cod_pessoa_funcionario(to_char(f.cod_funcionario))) as cod_pessoa,
						   f.cod_entreposto as empresa
					  from oper.v$rh_funcionario f
					 where 1=1
                    <cfif Len(Trim(arguments.FILTRO))>
                    	<cfif IsNumeric(arguments.FILTRO)>
                        	and f.cod_funcionario = #arguments.FILTRO#
                        <cfelse>
                            and upper(kss.pkg_string.fnc_string_clean(f.nome_funcionario)) like upper('%#arguments.FILTRO#%')
                        </cfif>
                    </cfif>
					<cfif Isdefined("arguments.ativos") and arguments.ativos eq 1>
					   and oper.pkg_global.fnc_get_cod_pessoa_funcionario(to_char(f.cod_funcionario)) <> -1
					</cfif>
				</cfif>
                </cfif>
				<cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and session.site neq 'ouroverde/' and session.site neq 'transgires/' and session.site neq 'transemba/' and session.site neq 'vialacteos/'>
				   and to_char(oper.pkg_global.fnc_get_cod_funcionario(f.cod_pessoa)) = '#arguments.cod_funcionario#'
				</cfif>
                <cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and (session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'vialacteos/')>
				   and fma.num_matricula = #arguments.cod_funcionario#			
				</cfif>
                <cfif IsDefined('arguments.cod_funcionario') and Len(trim(arguments.cod_funcionario)) and (session.site eq 'transemba/')>
				   and fd.matricula = #arguments.cod_funcionario#			
				</cfif>
                <cfif Len(Trim(arguments.num_modalidade)) and (session.site eq 'ouroverde/' or session.site eq 'transgires/' or session.site eq 'braf/')>
                   and fma.num_modalidade in (#arguments.num_modalidade#)
                </cfif>
				<cfif len(trim(arguments.nome)) and session.site neq 'transemba/'>
				   and upper(f.nome_funcionario) like upper('%#arguments.nome#%')
                <cfelseif len(trim(arguments.nome))>
                   and upper(fd.nome) like upper('%#arguments.nome#%')
				</cfif>
                
                <cfif session.site neq 'transemba/'>
				 order by f.nome_funcionario
                <cfelse>
				 order by fd.nome
				</cfif>
			</cfquery>
			<cfif qr_funcionario.RecordCount  EQ 0 and len(trim(arguments.cod_funcionario)) and session.site neq 'transemba/' and session.site neq 'vialacteos/' and session.site neq 'transgires/'>
				<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
					select to_char(p.cod_pessoa) as cod_funcionario, p.nome as nome_funcionario, to_char(p.cod_pessoa), 0 as empresa
					 from kss.v$pessoa_fisica p
						where p.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#)
				</cfquery>			
			</cfif>
		<cfelse>
			<cfquery datasource="#session.dsn#" name="qr_funcionario" username="#session.usuario#" password="#session.senha#">
				select to_Char(p.cod_pessoa) as cod_funcionario, p.nome as nome_funcionario, to_char(p.cod_pessoa), 0 as empresa
				 from oper.v$pessoa_fisica p
				 where p.cod_pessoa = oper.pkg_global.fnc_get_cod_pessoa_func(#arguments.cod_funcionario#) 
			</cfquery>			
		</cfif>			
		
		<cfreturn qr_funcionario>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Lista filiais
	-- NOTAS EXPLICATIVAS
	--  
	-- GUTO 24/02/2006 - criado
	--->	
	<cffunction name="get_filial" displayname="Lista filiais" access="remote" returntype="query" output="true">
		<cfargument name="cod_pessoa_filial" required="no" default="" />
		<cfargument name="nome" required="no" default="" />
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select to_char(cod_pessoa) as cod_pessoa,
				   razao_social,
				   nome,
				   identificador,
				   cnpj_cpf,
				   inscricao_estadual,
				   endereco,
				   bairro,
				   cep,
				   municipio,
				   uf,
				   municipio_uf,
				   municipio_id,
				   telefone,
				   pais_id,
				   pais,
				   filial
			  from oper.v$filial
			 where 1=1
			 <cfif len(trim(arguments.cod_pessoa_filial))>
			   and cod_pessoa = #arguments.cod_pessoa_filial#
			 </cfif>
			 <cfif len(trim(arguments.nome))>
			   and upper(razao_social) like upper('%#arguments.nome#%')
			 </cfif>
		     order by nome, razao_social, municipio_uf			 
		</cfquery>
  	   <cfreturn qr_result>	   
	</cffunction>
    
    
    
 </cfcomponent>
