<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!---
	-- PROPSITO
	-- Busca estrutura organizacional
	-- GUTO 29/05/2009
	--->
	<cffunction name="get_organizacional" access="remote" returntype="query" output="true">
    	<cfargument name="organizacional_id" required="no" default="" />
        <cfargument name="operacao_id" required="no" default="" />
        <cfargument name="multipla_consulta" required="no" default="0" hint="0-Busca de pelo ID e/ou pela operao separadamente; 1-Busca pelo ID e pela operao juntamente;" />
        <cfargument name="entrada_saida" required="no" default="" hint="0-Entrada; 1-Sada;" />
        <cfargument name="somente_ativos" required="no" default="0">
        <cfargument name="somente_folhas" required="no" default="0">
        <cfargument name="descricao" required="no" default="">
        <cfargument name="cod_organizacional" required="no" default="" />
		<cfargument name="buscar_area" required="no" default="" />
		<cfargument name="area_id" required="no" default="" />

		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select o.organizacional_id, o.organizacional_id_pai,
            	   upper(o.cod_organizacional) as cod_organizacional, o.descricao,
                   substr(replace(sys_connect_by_path(o.descricao, '@@'),'@@','/'),2) as descricao_completa,
                   /*trim(substr(sys_connect_by_path(o.cod_organizacional, '.'),2)) as codigo_completo, */
                   connect_by_isleaf as folha
              from kss.v$organizacional o
              where 1 = 1
              	<cfif len(trim(arguments.cod_organizacional))>
                 and o.cod_organizacional = '#arguments.cod_organizacional#'
                </cfif>
                <cfif len(trim(arguments.descricao))>
                 and lower(o.descricao) like lower('%#arguments.descricao#%')
                </cfif>
				<cfif arguments.multipla_consulta eq 1>
                   and (o.organizacional_id in (#arguments.organizacional_id#)
                        or (o.organizacional_id in (select op.organizacional_id
                                                     from logistica.v$operacao_organizacional op
                                                    where op.operacao_id = #arguments.operacao_id#)
                            or not exists (select op.organizacional_id
                                             from logistica.v$operacao_organizacional op
                                            where op.operacao_id = #arguments.operacao_id#)
                           )
                       )
                <cfelse>
                    <cfif Len(Trim(arguments.organizacional_id))>
                        and o.organizacional_id in (#arguments.organizacional_id#)
                    </cfif>
                    <cfif Len(Trim(arguments.operacao_id))>
                        and (o.organizacional_id in (select op.organizacional_id
                                                       from logistica.v$operacao_organizacional op
                                                      where op.operacao_id = #arguments.operacao_id#))
                    </cfif>
                </cfif>
                <cfif Len(Trim(arguments.entrada_saida))>
                    <cfif arguments.entrada_saida eq 0>
                        and o.tipo in (0,2)
                    <cfelseif arguments.entrada_saida eq 1>
                        and o.tipo in (1,2)
                    </cfif>
                </cfif>

				<cfif Len(Trim(arguments.buscar_area)) and arguments.buscar_area eq 1>
					<cfif Len(Trim(arguments.area_id)) >
					 and (exists (select 1
					                from compras.v$area_centro_custo_gerencial a
					               where a.organizacional_id = o.organizacional_id
					                 and a.area_id = #arguments.area_id# )
					      or
					      not exists (select 1
					                    from compras.v$area_centro_custo_gerencial a
					                   where a.area_id = #arguments.area_id# ))
					<cfelse>
					  and  1 = 0
					</cfif>
				</cfif>

                <cfif arguments.somente_ativos eq 1>
                   and o.ativo = 1
                </cfif>
                <cfif arguments.somente_folhas eq 1>
                   and connect_by_isleaf = 1
                </cfif>
             start with o.organizacional_id_pai = -1
            connect by prior o.organizacional_id = o.organizacional_id_pai
            order siblings by o.descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca o dado de um parametro
	-- CRISTOFER  10/11/2006
	--->
	<cffunction name="get_parametro_valor" access="remote" returntype="string" output="true">
    	<cfargument name="cod_projeto" required="yes">
    	<cfargument name="cod_aplicacao" required="yes">
    	<cfargument name="parametro_grupo_id" required="yes">
    	<cfargument name="parametro_id" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select kss.pkg_global.fnc_obtem_parametro_str(#arguments.cod_projeto#,'#arguments.cod_aplicacao#',#arguments.parametro_grupo_id#,#arguments.parametro_id#) valor from dual
		</cfquery>
		<cfreturn qr_result.valor>
	</cffunction>


   <cffunction name="get_parametro_ccg_sol" access="remote" returntype="query" output="true">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        	 select compras.pkg_compras.fnc_get_parametro_ccg_solic() as valor
	           from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
	<!---
	-- PROPSITO
	-- Busca as areas de compras
	-- RAFAEL 28/03/2018
	--->
	<cffunction name="get_areas" access="remote" returntype="query" output="true">
    	<cfargument name="organizacional_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select a.area_id , a.descricao
			  from compras.v$area a
			 where 1 = 1
			   <cfif Len(Trim(arguments.organizacional_id)) >
			   and exists (select 1
                             from compras.v$area_centro_custo_gerencial accg
                            where accg.area_id = a.area_id
                              and accg.organizacional_id = #arguments.organizacional_id# ) 
	           <cfelse>
			     and 1 = 0
			   </cfif>
		</cfquery>
		<cfif qr_result.recordcount eq 0 >
			<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
				select a.area_id , a.descricao
				  from compras.v$area a
				 where 1 = 1
				   and not exists (select 1
					      		 from compras.v$area_centro_custo_gerencial accg
							    where accg.area_id = a.area_id )
			</cfquery>
		</cfif>
		<cfreturn qr_result>
	</cffunction>


</cfcomponent>
