<cfcomponent displayname="Componentes de consulta para o controle de trafego" extends="_transportes.funcoes.cfc_init">

	<!---
	-- PROPSITO
	-- Busca os materiais cadastrados
	-- CRISTOFER  07/07/2006
	--->
	<cffunction name="get_material" access="remote" returntype="query" output="true">
		<cfargument  name="material_id" required="no" default="">
		<cfargument  name="inventario" required="no" default="">
		<cfargument  name="estoque" required="no" default="">
		<cfargument  name="material_pai" required="no" default="">
       	<cfargument  name="cod_material" required="no" default="">
        <cfargument  name="material_descricao" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select m.material_id as material_id,
				   m.material_pai,
				   nvl(m.material_pai,0) as material_pai_nvl,
				   almoxarifado.pkg_almoxarifado.fnc_get_material_descricao(m.material_id,' ') material_descricao,
				   m.cod_material,
				   m.titulo,
				   m.descricao,
				   m.compoe_descricao,
				   m.estoque,
                   m.ativo,
				   m.unidade_estoque,
				   um1.unidade as unid_estoque,
				   m.unidade_comercializacao,
				   um1.unidade as unid_comercializacao,
				   m.identificado, m.modelo_id, m.grupo_id
				   <cfif arguments.inventario eq 1>
				   ,(select max(data_lancamento)
				      from almoxarifado.v$movimentacao mov
					 where mov.material_id = m.material_id
					   and mov.operacao_tipo_id = 1) as ultimo_inventario
				   </cfif>
				   <cfif len(trim(arguments.estoque))>
				   ,almoxarifado.pkg_almoxarifado.fnc_estoque_material(m.material_id, #arguments.estoque#, sysdate) as quantidade_estoque
				   </cfif>
                   <cfif not len(trim(arguments.material_id))>
                   ,connect_by_isleaf as folha
                   </cfif>
			  from almoxarifado.v$material m
			  left join fiscal.v$unidade_medida um1
			         on um1.cod_unidade = m.unidade_estoque
		      left join fiscal.v$unidade_medida um2
			         on um2.cod_unidade = m.unidade_comercializacao
			 where 1=1
			<cfif len(trim(arguments.material_id))>
			   and m.material_id = #arguments.material_id#
			<cfelse>
				<cfif len(trim(arguments.material_pai))>
                    <cfif lcase(arguments.material_pai) eq 'null'>
                   and m.material_pai is #arguments.material_pai#
                    <cfelse>
                   and m.material_pai = #arguments.material_pai#
                    </cfif>
                </cfif>
                <cfif len(trim(arguments.material_descricao))>
                    and upper(material_descricao) like upper('%#arguments.material_descricao#%')
                 </cfif>
                 <cfif len(trim(arguments.cod_material))>
                    and m.cod_material = #arguments.cod_material#
                 </cfif>
                 start with m.material_pai is null
                connect by prior m.material_id = m.material_pai
                order siblings by m.titulo
			</cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca os tipos de movimentacao
	-- CRISTOFER  31/07/2006
	--->
	<cffunction name="get_operacao_tipo" access="remote" returntype="query" output="true">
		<cfargument name="operacao_tipo_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select operacao_tipo_id,
				   descricao,
				   d_c,
				   user_insert,
				   date_insert,
				   user_update,
				   date_update,
				   site
			  from almoxarifado.v$operacao_tipo
			 where 1=1
			 <cfif len(trim(arguments.operacao_tipo_id))>
			   and operacao_tipo_id in (#arguments.operacao_tipo_id#)
			 </cfif>
			 order by descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
	-- PROPSITO
	-- Retorna lista de proprietarios
	-- NOTAS EXPLICATIVAS
	--
	-- GUTO 15/02/2007 - criado
	--->
	<cffunction name="get_proprietarios" displayname="Retorna lista de proprietarios" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select distinct to_char(p.cod_pessoa) as cod_pessoa
              , p.cliente as proprietario
			  from almoxarifado.v$equip_proprietario_atual epa
			 inner join kss.v$pessoa p
				 on p.cod_pessoa = epa.cod_pessoa_proprietario
		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

   <!---
    -- PROPSITO
    -- Busca as reas para as solicitaes de compras
    -- ANDERSON 16/09/2009 - CRIADO
    --->
    <cffunction name="get_area" access="remote" returntype="query" output="true">
	    <cfargument name="cod_pessoa_fornecedor" required="no" default="">
        <cfargument name="situacao" required="no" default="1">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select a.area_id
                 , a.descricao
              from compras.v$area a
             where visivel = 1
               and situacao = #arguments.situacao#
			<cfif len(trim(arguments.cod_pessoa_fornecedor))>
               and (
                    exists (select 0
                              from compras.v$fornecedor_area fa
                             where fa.area_id = a.area_id
                               and fa.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                            )
                    or not exists (select 0
                                     from compras.v$fornecedor_area fa
                                    where fa.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                                  )
                   )
			</cfif>
             order by a.descricao
        </cfquery>
        <cfreturn qr_result>
    </cffunction>


    <!---
	-- PROPSITO
	-- Busca as unidades de medida
	-- CRISTOFER  07/07/2006
	--->
	<cffunction name="get_unidade_medida" access="remote" returntype="query" output="true">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cod_unidade,
				   unidade,
				   permite_editar,
				   permite_excluir,
				   cod_grupo_umedida,
				   valor_em
			  from fiscal.v$unidade_medida
			 where 1=1
		</cfquery>
		<cfreturn qr_result>
	</cffunction>


		<!---
	-- PROPSITO
	-- Retorna etiquetas - estoque operacional
	-- estoque operacional
	--
	-- Luiz 15/05/2017 - criado
	--->
	<cffunction name="get_etiquetas_eoper" displayname="Retorna lista de etiquetas" access="remote" returntype="query" output="true">
		<cfargument  name="material_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.USUARIO#" password="#session.SENHA#">
			select e.etiqueta_id
				 , e.codigo_especifico
				 , t.saldo
				 , e.codigo_barras
				 , ( select em.descricao 
                       from estoque.v$etiqueta_movimento_it mit1
                      inner join estoque.v$estoque_mapa em
                        on em.estoque_mapa_id = mit1.etiqueta_mapa_id_destino
                      where mit1.etiqueta_id = e.etiqueta_id
                        and not exists (select 1
                                         from estoque.v$etiqueta_movimento_it mit2
                                        where mit2.movimento_it_id_anterior = mit1.etiqueta_movimento_it_id
                                         and  mit2.etiqueta_id = e.etiqueta_id )) as mapa
				 , (select eo.descricao
                      from estoque.v$estoque_oper eo    
                     inner join estoque.v$cc_estoque cce
                        on cce.estoque_id = eo.estoque_id
                     where cce.produto_id = e.produto_id
                       and cce.cc_estoque_id = t.cc_estoque_id
					) as local_armazenamento
			  from estoque.v$etiqueta e
			 inner join estoque.v$etiqueta_cc t
				on t.etiqueta_id = e.etiqueta_id
			 where e.data_baixa is null
			   and t.saldo > 0
               <cfif len(trim(arguments.material_id))>
			   and e.produto_id = (select mp.produto_id
			                        from almoxarifado.v$material_produto mp
			                       where mp.material_id = #arguments.material_id# )

			   <cfelse>
			     and 1 = 0
			   </cfif>
			   
			   and t.cc_estoque_id in ( select cce.cc_estoque_id
										  from kss.v$organograma org
										 inner join kss.v$lotacao l
										    on l.cod_pessoa = org.cod_pessoa
										   and l.cod_departamento = org.cod_departamento
										   and l.cod_setor = org.cod_setor
										   and l.cod_centro_custo = org.cod_centro_custo
										 inner join kss.v$usuario_lotacao ul
											on ul.cod_lotacao = l.cod_lotacao
										 inner join estoque.v$estoque_oper eo
										    on eo.cod_organograma = org.cod_organograma
										 inner join estoque.v$cc_estoque cce
										    on cce.estoque_id = eo.estoque_id
										 where cce.produto_id = e.produto_id
										   and ul.usuario = upper('#session.usuario#') )  

		</cfquery>
	   <cfreturn qr_result>
	</cffunction>

	<!---
    -- PROPSITO
    -- Retorna os pedidos de compra abertos de um fornecedor
    -- IGOR 21/09/2020 - CRIADO
    --->
    <cffunction name="get_pedidos_abertos_fornecedor" access="remote" returntype="query" output="true">
        <cfargument name="cod_pessoa_fornecedor" required="yes">
        <cfargument name="equipamento_id" required="no" default="">
        <cfargument name="ordem_servico_id" required="no" default="">
        <cfargument name="nf_fornecedor" required="no" default="0">
        <cfargument name="os_externa" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.pedido_id
                 , p.num_pedido
                 , to_char(p.data_pedido, 'dd/mm/yyyy') as data_pedido
                 , (select cg.rv_abbreviation
                      from compras.v$cg_ref_codes cg
                     where cg.rv_domain = 'PEDIDO SITUACAO'
                       and cg.rv_low_value = p.situacao_id
                   ) as situacao
                 , p.valor_material
                 , p.valor_atividade
                 , p.valor_total_pedido
                 , pi.pedido_item_id
                 , ct.cotacao_id
                 , ct.atividade_id
                 , '-1' as atividade_posicao_id
                 , 'nica' as atividade_posicao
                 , ct.material_id
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(ct.material_id, 9) as material_cod_genuino
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(ct.material_id, 10) as material_cod_fabricante
                 , almoxarifado.pkg_almoxarifado.fnc_get_atributo_mat(ct.material_id, 11) as material_cod_paralelo
                 , m.identificado as material_identificado
                 , m.unidade_estoque as material_unidade_estoque
                 , '-1' as material_posicao_id
                 , 'nica' as material_posicao
                 , sp.num_controle as num_solicitacao_compra
                 , sp.solicitante
                 , sp.equipamento
                 , sp.situacao_id
                 , nvl(a.titulo, m.descricao_completa) as descricao_item
                 , nvl(
                       (select p.categoria_id
                          from manutencao.v$atividade_produto ap
                         inner join fiscal.v$produto p
                                 on p.produto_id = ap.produto_id
                         where ap.atividade_id = ct.atividade_id
                       ),
                       (select p.categoria_id
                          from almoxarifado.v$material_produto mp
                         inner join fiscal.v$produto p
                                 on p.produto_id = mp.produto_id
                         where mp.material_id = ct.material_id
                       )
                      ) as categoria_id
                 , ct.quantidade
                 , (ct.quantidade
                    - (select nvl(sum(nfpi.quantidade), 0)
                         from fiscal.v$nf_terceiro_pedido_item nfpi
                        where nfpi.pedido_item_id = pi.pedido_item_id
                      )
                   ) as quantidade_disponivel
                 , ct.valor_unitario
                 , ct.valor_negociado
			<cfif Len(Trim(arguments.ordem_servico_id))>
                 , (select count(*)
                      from manutencao.v$os_pedido osp
                     where osp.pedido_id = p.pedido_id
                       and osp.ordem_servico_id = #arguments.ordem_servico_id#
                   ) as pedido_utilizado_os
                 , nvl(
                       (select osp.valor_utilizado
                          from manutencao.v$os_pedido osp
                         where osp.pedido_id = p.pedido_id
                           and osp.ordem_servico_id = #arguments.ordem_servico_id#
                       ), 0
                      ) as pedido_valor_utilizado_os
                 , (select count(*)
                      from manutencao.v$os_pedido_item ospi
                     where ospi.pedido_item_id = pi.pedido_item_id
                       and ospi.ordem_servico_id = #arguments.ordem_servico_id#
                   ) as pedido_item_utilizado_os
            <cfelse>
                 , 0 as pedido_utilizado_os
                 , 0 as pedido_valor_utilizado_os
                 , 0 as pedido_item_utilizado_os
            </cfif>
              from compras.v$pedido p
             inner join compras.v$pedido_item pi
                     on pi.pedido_id = p.pedido_id
             inner join compras.v$cotacao ct
                     on ct.cotacao_id = pi.cotacao_id
             inner join compras.v$solicitacao_pedido sp
                     on sp.pedido_id = p.pedido_id
              left join manutencao.v$atividade a
                     on a.atividade_id = ct.atividade_id
              left join almoxarifado.v$material m
                     on m.material_id = ct.material_id
             where ct.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
            <cfif Len(Trim(arguments.equipamento_id))>
               and compras.pkg_compras.fnc_equipamento_pert_cotacao(ct.cotacao_id, #arguments.equipamento_id#) = 1
            </cfif>
			<cfif arguments.nf_fornecedor eq 1>
               and (select nvl(sum(nfpi.quantidade), 0)
                      from fiscal.v$nf_terceiro_pedido_item nfpi
                     where nfpi.pedido_item_id = pi.pedido_item_id
                   ) < ct.quantidade
			</cfif>
            <cfif arguments.os_externa eq 1>
               and pi.pedido_item_id not in (select ospi.pedido_item_id
                                   			   from manutencao.v$os_pedido_item ospi
											<cfif Len(Trim(arguments.ordem_servico_id))>
                                              where ospi.ordem_servico_id <> #arguments.ordem_servico_id#
                                            </cfif>

                                            )
			</cfif>
             order by p.num_pedido
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

</cfcomponent>
