<cfcomponent displayname="Componentes de consulta para controle de trfego"  extends="_transportes.funcoes.cfc_init">
	<cfparam name="session.dsn_menu" default="#session.dsn#">
    <!--- 
	-- PROPSITO
	-- Retorna os usuarios com acesso ao modulo
	-- CRISTOFER 07/02/2006
	--->	
	<cffunction name="get_usuarios_modulo" displayname="Retorna menus que o usuario possui acesso" output="true" returntype="query" access="public">
		<cfargument name="modulo_id" required="no" default="">
		<cfargument name="role" required="no" default="">
		<cfargument name="usuario" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn_menu#" username="#session.usuario#" password="#session.senha#">
			
			select mu.usuario,
				   mu.nivel_acesso,
				   n.descricao as nivel,
				   mu.modulo_id,
				   m.descricao as modulo,
				   m.role
			  from acesso.v$modulo_usuario mu
			 inner join acesso.v$modulo m
					 on m.modulo_id = mu.modulo_id
			 inner join acesso.v$nivel_acesso n
					 on n.nivel_acesso = mu.nivel_acesso
			 where 1=1
			 <cfif len(trim(arguments.modulo_id))>
			   and mu.modulo_id = #arguments.modulo_id#
			 </cfif>
			 <cfif len(trim(arguments.usuario))>
			   and upper(mu.usuario) = upper('#arguments.usuario#')
			 </cfif>
			 <cfif len(trim(arguments.role))>
			   and upper(m.role) = upper('#arguments.role#')
			 </cfif>
             order by mu.usuario
			 
		</cfquery>
		
		<cfreturn qr_result>
	</cffunction>
	
	<!---
	-- PROPSITO
	-- Busca as acoes disponiveis para o web_url informado, para o usuario que faz a requisicao
	-- NOTAS EXPLICATIVAS
	--  FELIPE B. 24/12/2014
	--->
	<cffunction name="get_acao_usuario" displayname="Busca as aes (nova estrutura) para o usurio informado" output="true" returntype="query" access="remote">
    	<cfargument name="web_url" required="yes"/>
		<cfargument name="cod_acao" required="no"/>
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select column_value as cod_acao
			  from table(acesso.pkg_controle_acesso.fnc_get_acao_web(p_web_url => '#arguments.web_url#', p_usuario => user))
			 where 1 = 1
			 <cfif IsDefined("arguments.cod_acao")>
			   and column_value = '#arguments.cod_acao#'
			 </cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    
</cfcomponent>