<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO 
    -- Retorna a tabela de preo fixo de um fornecedor
    -- ANDERSON 09/06/2010 - CRIADO
    --->		
    <cffunction name="get_tabela_preco_fixo" access="remote" returntype="query" output="true">
    	<cfargument name="cod_pessoa_fornecedor" required="yes">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select tpf.tabela_id
                 , tpf.cod_tabela
                 , to_char(tpf.cod_pessoa_fornecedor) as cod_pessoa_fornecedor
                 , tpf.titulo
                 , to_char(tpf.data_vigencia, 'dd/mm/yyyy') as data_vigencia
                 , tpf.observacao
                 , tpf.aprovada
                 , to_char(tpf.data_aprovacao, 'dd/mm/yyyy hh24:mi:ss') as data_aprovacao
                 , tpf.ativa
                 , to_char(tpf.data_inativacao, 'dd/mm/yyyy hh24:mi:ss') as data_inativacao
              from compras.v$tabela_preco_fixo tpf
             where tpf.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
               and tpf.aprovada = 1
               and tpf.ativa = 1
               and tpf.tabela_id = (select max(tpf2.tabela_id) keep(dense_rank last order by tpf2.data_vigencia nulls last)
                                          from compras.v$tabela_preco_fixo tpf2
                                         where tpf2.cod_pessoa_fornecedor = #arguments.cod_pessoa_fornecedor#
                                           and tpf2.aprovada = 1
                                           and tpf2.ativa = 1
                                           and nvl(tpf2.data_vigencia, sysdate) >= sysdate
                                        )
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Verifica se uma lista de materiais pertence a uma tabela
    -- ANDERSON 11/06/2010 - CRIADO
    --->		
    <cffunction name="get_verificacao_tabela_materiais" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_id" required="no" default="">
        <cfargument name="material_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.column_value as material_id
                 , x.valor
              from table(kss.pkg_string.fnc_split('#arguments.material_id#', ';')) t
              left join (select tpm.material_id
                              , tpm.valor
                           from compras.v$tabela_preco_material tpm
                          where tpm.tabela_id = #arguments.tabela_id#
                            and tpm.data_vigencia = (select max(tpm2.data_vigencia)
                                                       from compras.v$tabela_preco_material tpm2
                                                      where tpm2.material_id = tpm.material_id
                                                        and tpm2.tabela_id = tpm.tabela_id
                                                        and tpm2.data_vigencia <= sysdate
                                                    )
                        ) x
                     on x.material_id = t.column_value
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Verifica se uma lista de atividades pertence a uma tabela
    -- ANDERSON 11/06/2010 - CRIADO
    --->		
    <cffunction name="get_verificacao_tabela_atividades" access="remote" returntype="query" output="true">
    	<cfargument name="tabela_id" required="no" default="">
        <cfargument name="atividade_id" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.column_value as atividade_id
                 , x.valor
              from table(kss.pkg_string.fnc_split('#arguments.atividade_id#', ';')) t
              left join (select ma.atividade_id
                              , tpm.valor
                           from compras.v$tabela_preco_material tpm
                          inner join almoxarifado.v$material_atividade ma
                             on ma.material_id = tpm.material_id
                          where tpm.tabela_id = #arguments.tabela_id#
                            and tpm.data_vigencia = (select max(tpm2.data_vigencia)
                                                       from compras.v$tabela_preco_material tpm2
                                                      where tpm2.material_id = tpm.material_id
                                                        and tpm2.tabela_id = tpm.tabela_id
                                                        and tpm2.data_vigencia <= sysdate
                                                    )
                        ) x
                     on x.atividade_id = t.column_value
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
</cfcomponent>
