<?php
    require_once 'define.php';
	require_once 'erros.php';
    require_once 'configuracao.php';
	
//	function exception_error_handler($errno, $errstr, $errfile, $errline ) {
//		Log::escreveLog($errno.', '.$errstr.', '.$errfile.', '.$errline );
//	}
	
    ini_set("soap.wsdl_cache_enabled", "0");
	$server = new SoapServer('http://'.$_SERVER['HTTP_HOST']."/modulos/integracaoKMM/integrador.wsdl.php", array('encoding'=>'ISO-8859-1'));
    
    function integrador($parametros){
        $isString = is_string($parametros->xml);
        if(is_string($parametros->xml)) {
                $xml = utf8_encode($parametros->xml);
        } else {
                $doc = new DOMDocument();
                $doc->loadXML(file_get_contents ('php://input'));
                $xpath = new DOMXPath($doc);
                $xpath->registerNamespace("m","http://integrador.kmm.com.br");
                $query = '//m:requisicao';
                $result = $xpath->query($query, $doc);
                $xml = utf8_encode($doc->saveXML($result->item(0)));
                $returnType = XSD_ANYXML;
        }

                //set_error_handler("exception_error_handler");

		if(EM_MANUTENCAO == 1){
			return new SoapFault('-1', "Sistema em manuteno. Aguarde alguns instantes e tente novamente.");
		}
		
		$xmlData = new Xml();
		$ret = $xmlData->validaCabecalho($xml);
		
		if($ret !== true){
			return array("result" => new SoapVar($ret, $returnType));
        }
		
		//verifica se o XML informado  vlido
        if(!$xmlData->validaXml($xml)){
            return array("result" => new SoapVar($xmlData->retornaErro(RET_XML_INVALIDO, RET_XML_INVALIDO, RET_NUM_XML_INVALIDO), $returnType));
        }
		
        $operacao = new Operacao();
		
		$usuario = $xmlData->usuario;
        $senha   = $xmlData->senha;
				
        if(!$operacao->connect($usuario, $senha)){
            //verificar o tipo de erro - banco, usuario, conta bloqueada ou no catalogado
            return new SoapFault('-3', "Usurio / senha incorreta");
        }
        $param = array();
        $ret = $operacao->processaRequisicao($xml);
		if($ret === false){
			if($operacao->erro['code'] >= -20000 && $operacao->erro['code'] <= -20999){
				return array("result" => new SoapVar($xmlData->montaXmlRetorno("A operao solicitada no foi realizada.", $operacao->erro['message'], $operacao->erro['code']), $returnType));
			}else{
				return new SoapFault('-3', "Erro ao realizar a operao solicitada (".$operacao->erro['code'].")", $operacao->erro['message']);
			}
		}
		return array("result" => new SoapVar($ret, $returnType));
    }
    
    $server->addFunction(array("integrador"));
    $server->handle();

?>
