<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Classe realiza as validações no XML. Os padrões de retorno são montados por ela.
 */
class Xml {

    /**
     * Usuário para conexão com o banco de dados
     * @var String
     */
    public $usuario;
    /**
     * Senha para conexão com o banco de dados
     * @var String
     */
    public $senha;
    /**
     * Valor do XMLNS padrão
     * @var String
     */
    public $xmls;
    /**
     * Versão do XML de integração que está sendo utilizado
     * @var String
     */
    public $versao;
    /**
     * Armazena os erros que ocorreram durante a validação do XML x XSD
     * @var String
     */
    public $erroXML;
    /**
     * CNPJ da empresa que está sendo integrada
     * @var String
     */
    public $cnpj;
	
    /**
     * Indica a operação que está sendo executada (utilizado na NFT - I para inserir efetivamente e V para verificar, neste caso, após o processo um ROLLBACK é executado.
     * @var String
     */
    public $operacao;

    public function __construct() {
        $this->usuario = '';
        $this->senha = '';
    }

    public function __destruct() {

    }

	public function charClean($string) { 
	    
	    $repl = array('á' => 'a'
					 ,'í' => 'i'
					 ,'ú' => 'u'
					 ,'é' => 'e'
					 ,'ó' => 'o'
					 ,'â' => 'a'
					 ,'î' => 'i'
					 ,'û' => 'u'
					 ,'ê' => 'e'
					 ,'ô' => 'o'
					 ,'ã' => 'a'
					 ,'õ' => 'o'
					 ,'à' => 'a'
					 ,'ì' => 'i'
					 ,'ù' => 'u'
					 ,'è' => 'e'
					 ,'ò' => 'o'
					 ,'ç' => 'c'
                     ,'Á' => 'A'
					 ,'Í' => 'I'
					 ,'Ú' => 'U'
					 ,'É' => 'E'
					 ,'Ó' => 'O'
					 ,'Â' => 'A'
					 ,'Î' => 'I'
					 ,'Û' => 'U'
					 ,'Ê' => 'E'
					 ,'Ô' => 'O'
					 ,'Ã' => 'A'
					 ,'Õ' => 'O'
					 ,'À' => 'A'
					 ,'Ì' => 'I'
					 ,'Ù' => 'U'
					 ,'È' => 'E'
					 ,'Ò' => 'O'
					 ,'Ç' => 'C'
					 ,'&#13;' => ' - '//replace na quebra de linha do oracle
					 ,"\n" => ' - '//replace na quebra de linha do oracle
					 );
	    
		return strtr($string, $repl );
	} 

    /**
     * Função para retornar o XML padrão de erro, se informado que é um erro catalogado, o array $p_erroOracle deve ser informado
     * @param boolean $p_erroCatalogado
     * @param Array $p_erroOracle
     * @return String
     */
    public function retornaErro($p_mensagem = '', $p_erroOracle = '', $p_codMensagem = '') {
        if (!empty($p_erroOracle)) {
            return $this->errosCatalogados($p_erroOracle);
        }else{
            return $this->montaXmlRetorno('', $p_mensagem, $p_codMensagem);
		}
    }

    /**
     * Função que monta o XML no padrão de retorno NETSPED
     * @param String $p_mensagem
     * @param String $p_codMensagem
     * @return String
     */
    public function montaXmlRetorno($operacao, $mensagem, $codErro, $sucesso = 'false', $retorno = '') {

        $xml = '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>';
        $xml .= '<retorno xmlns="'.XMLNS.'" versao="1.0">';
        $xml .= "<sucesso>{$sucesso}</sucesso>";
		if($sucesso == "false"){
			$xml .= "<erros><erro>";
			$xml .= "<codigo>{$codErro}</codigo>";
			$xml .= '<motivo>'.$this->charClean($mensagem).'</motivo>';
			$xml .= "</erro></erros>";
		}else{
			$xml .= "<resultado>{$retorno}</resultado>";
		}
        $xml .= '</retorno>';

        return $xml;
    }

    /**
     * Erros catalogados dos retornos do ORACLE
     * @param array $erroOracle
     * @return String
     */
    public function errosCatalogados($p_erroOracle) {

        switch ($p_erroOracle['code']) {
            case ORACLE_BANCO_INDISPONIVEL :
            case ORACLE_BANCO_INDISPONIVEL2 :
            case ORACLE_BANCO_INDISPONIVEL3 :
                return $this->montaXmlRetorno('Erro conexão banco de dados.', RET_BANCO_INDISPONIVEL, RET_NUM_BANCO_INDISPONIVEL);
                break;
            case ORACLE_CONTA_BLOQUEADA :
                return $this->montaXmlRetorno('Erro de usuário/senha.', RET_CONTA_BLOQUEADA, RET_NUM_CONTA_BLOQUEADA);
                break;
            case ORACLE_USUARIO_INCORRETO :
                return $this->montaXmlRetorno('Erro de usuário/senha.', RET_USUARIO_INCORRETO, RET_NUM_USUARIO_INCORRETO);
                break;
            case ORACLE_ERRO_PADRAO_KMM :
                return $this->montaXmlRetorno('Mensagem tratada.', trim(preg_replace('/^ORA-20000: |ORA-[0-9]{5}.*/', '', $p_erroOracle['message'])), ORACLE_ERRO_PADRAO_KMM);
                break;
            default :
                return $this->montaXmlRetorno('Erro não tratado.', RET_NAO_CATALOGADO, RET_NUM_NAO_CATALOGADO);
                break;
        }
        return $this->montaXmlRetorno(RET_NAO_CATALOGADO . print_r($p_erroOracle, true), RET_NUM_NAO_CATALOGADO);
    }

    /**
     * Passa uma string XML para retornar ela em estrutura de Array
     * @param String $xml
     * @return Array()
     */
    private function getDadosXml($p_xml) {
        $xmlRead = simplexml_load_string($p_xml);
        if ($xmlRead === false){
			$this->erroXML = '';
			foreach(libxml_get_errors() as $error) {
				$this->erroXML .= $error->message;
			}
            return false;
		}

        return get_object_vars($xmlRead);
    }

    /**
     * Valida se a variável contém um XML
     * @param String $xml
     * @return boolean
     */
    public function validaXml($xml){
        $dados = $this->getDadosXml($xml);
        if ($dados === false) {
            return false;
        }else return true;
    }

    /**
     * Valida cabeçalho enviado pelo cliente
     * @param String $p_headerXml
     * @return boolean
     */
    public function validaCabecalho($p_headerXml) {

        /*modelo do CABECALHO
          <?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>
          <requisicao xmlns="http://integrador.kmm.com.br" versao="1.0">
             <usuario></usuario>
             <senha></senha>
             <unidades>
                <cnpj></cnpj>
             </unidades>
             <operacao></operacao>
          </requisicao>
         */
        
        if (EM_MANUTENCAO == 1) {
            return $this->retornaErro(RET_SERVICO_MANUTENCAO, '', RET_NUM_SERVICO_MANUTENCAO);
        }
        
        if (trim($p_headerXml) == ''){
    	    return $this->retornaErro(RET_XML_VAZIO, '', RET_NUM_XML_VAZIO);
        }
        
		$dados = $this->getDadosXml($p_headerXml);
		
        if ($dados === false) {
            return $this->retornaErro(RET_CABECALHO_INVALIDO." -- ".print_r($this->erroXML, true), '', RET_NUM_CABECALHO_INVALIDO);
        }
		
        $this->xmls = $dados['@attributes']['xmls'];
        
        $this->usuario  = $dados['usuario'];
        $this->senha    = $dados['senha'];
        
        if ((trim($this->usuario) == '') || (trim($this->senha) == '')){
			return $this->montaXmlRetorno('', RET_USUARIO_INCORRETO.print_r($dados, true), RET_NUM_USUARIO_INCORRETO);
		}
        return true;
    }

}
?>
