<?php

/**
 * Classe de conexão com o banco de dados
 */
class Conexao {
    
    /**
     * Connection
     * @var resource
     */
    public $conn;
    public $error;
    public $last_query;

    public function __contruct(){}

    public function __destruct(){
        @oci_close();
    }

    /**
     * Abre uma conexao com o banco de dados
     * @param TNS $dsns
     * @param String $username
     * @param String $password
     * @return boolean
     */
    public function connect($username, $password, $dsns = DSNS) {

        $this->conn = oci_connect($username, $password, $dsns, "AL32UTF8");
        if ($this->conn === false) {
            $this->error = oci_error();
            return false;
        } else {
			if(!$this->query('SET ROLE KSS_CORPORATIVO IDENTIFIED BY "()#3F20L13RJ@"')){
				return false;
			}
            return true;
        }
    }
    
    public function query($sql, $params){
        $stmt = oci_parse($this->conn, $sql);
        
        if(!empty($params) && is_array($params) && count($params)>0){
            foreach ($params as $campo => $valor) {
                oci_bind_by_name($stmt, $campo, $valor, -1, SQL_VARCHAR);
            }
        }
        
        $this->last_query = $sql;
        
        if(!oci_execute($stmt,OCI_DEFAULT)){
            $this->setErrors(print_r(oci_error($stmt), true)." = ".print_r($params, true));
            return false;
        }else{
			return $stmt;
        }
    }
    
    public function setErrors($error = '') {
        if(empty($error)){
            $error = error_get_last();
            $this->error = print_r($error['message'], true);
        }else{
            $this->error = $error;
        }
    }
    
    /**
     * Retorna os detalhes do erro que ocorreu
     * @return String
     */
    public function getErrors() {
        return $this->error;
    }
    
    public function numRows($statement){
        return oci_num_rows($statement);
    }
    
    public function fetchResultQuery($statement){
        return oci_fetch_object($statement);
    }
}
?>
