<cfscript>
	// Verifica se a varivel de controle de fluxo existe
	if((IsDefined("vars.OPERACAO")) and (Len(Trim(vars.OPERACAO)))) {
		conn_manip = CreateComponent("modulos.grisco._componentes.manipulacao.cfc_grisco");
		switch(val(vars.OPERACAO)) {
			case 1:
				set_manipulacao = conn_manip.consulta_pre_ordem(argumentCollection = vars);
				break;
			case 2:
				set_manipulacao = conn_manip.envia_pre_ordem(argumentCollection = vars);
				break;
			case 3:
				set_manipulacao = conn_manip.gerar_pre_ordem(argumentCollection = vars);
				break;
			case 4:
				set_manipulacao = conn_manip.can_pre_ordem_sol_carga(argumentCollection = vars);
				break;
		}
		
		if(val(vars.OPERACAO) neq 3){
			fnc_trata_erros(struct_erro = set_manipulacao, abort_on_error = false);
		}else{
			fnc_trata_erros(struct_erro = set_manipulacao, mostra_msg_ok = 0);
		}
		
	}
</cfscript>
<cfif vars.OPERACAO eq 3>	
	<cfoutput>
		<cfset v_data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss') />
        <cffile action="write" file="#ExpandPath("/")#temp/pre_ordem_#v_data_hora#.pdf" nameconflict="makeunique" output="#set_manipulacao.ARQUIVO#">
        <script type="text/javascript">
            parent.NewWindow('<cf_url>/temp/pre_ordem_<cfoutput>#v_data_hora#</cfoutput>.pdf</cf_url>', '', 800, 600, 'yes');
        </script>
    </cfoutput> 
<cfelse>  
<script type="text/javascript">
	with(parent.document.forms[0]) {
		<cfif (IsDefined("vars.ATUALIZA_COMBO")) and (Len(Trim(vars.ATUALIZA_COMBO)))>
			window.onload = function() {
				<cfoutput>
					#vars.ATUALIZA_COMBO#;
					top.window.close();
				</cfoutput>
			}	
		<cfelse>
			parent.f_atualizar();
		</cfif>
	}
</script>
</cfif>