<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
	-- PROPSITO
	-- Inserir uma pr-ordem de carregamento
	-- Rafael 17/07/2014 11:27:00 - CRIADO
	--->
	<cffunction name='ins_pre_ordem' displayname='Inserir uma pr ordem de carregamento' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
	<cfargument name='CAVALO_VEICULO_ID' required='yes'>
	<cfargument name='CARRETA_VEICULO_ID' required='yes'>
	<cfargument name='CARRETA2_VEICULO_ID' required='yes'>
	<cfargument name='CARRETA3_VEICULO_ID' required='yes'>
	<cfargument name='NATUREZA' required='yes'>
	<cfargument name='VALOR_TOTAL_SUGERIDO' required='yes'>
	<cfargument name='COD_UF_ORIGEM' required='yes'>
	<cfargument name='MUNICIPIO_ORIGEM' required='yes'>
	<cfargument name='MUNICIPIO_DESTINO' required='yes'>
	<cfargument name='COD_UF_DESTINO' required='yes'>
    <cfargument name='PEDIDO_CLIENTE' required='yes'>
	<cftry>
		<cftransaction action='begin'>
			<cfstoredproc procedure='grisco.pkg_pre_ordem.prc_ins_pre_ordem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRE_ORDEM_ID' variable='retorno.PRE_ORDEM_ID' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MOT_COD_PESSOA'  value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CAVALO_VEICULO_ID'  value='#arguments.CAVALO_VEICULO_ID#'  null='#iif(len(trim(arguments.CAVALO_VEICULO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARRETA_VEICULO_ID'  value='#arguments.CARRETA_VEICULO_ID#'  null='#iif(len(trim(arguments.CARRETA_VEICULO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARRETA2_VEICULO_ID'  value='#arguments.CARRETA2_VEICULO_ID#'  null='#iif(len(trim(arguments.CARRETA2_VEICULO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CARRETA3_VEICULO_ID'  value='#arguments.CARRETA3_VEICULO_ID#'  null='#iif(len(trim(arguments.CARRETA3_VEICULO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_MERCADORIA'  value='#arguments.NATUREZA#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_VALOR_MERCADORIA'  value='#arguments.VALOR_TOTAL_SUGERIDO#'  null='#iif(len(trim(arguments.VALOR_TOTAL_SUGERIDO)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ORIGEM_UF'  value='#arguments.COD_UF_ORIGEM#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_ORIGEM_MUNICIPIO'  value='#arguments.MUNICIPIO_ORIGEM#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESTINO_MUNICIPIO'  value='#arguments.MUNICIPIO_DESTINO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESTINO_UF'  value='#arguments.COD_UF_DESTINO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_PEDIDO_CLIENTE'  value='#arguments.PEDIDO_CLIENTE#' >
			</cfstoredproc>
                
                <cfscript>
					ret = this.envia_pre_ordem(PRE_ORDEM_ID = retorno.PRE_ORDEM_ID);
				</cfscript>
				<cfif ret.erro>
					<cfthrow object="#ret.mensagem#">
				</cfif>
                
			<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pr-ordem gerada com sucesso.')>
		</cftransaction>
		<cfcatch>
			<cftransaction action='rollback'/>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Efetuar envio da pr-ordem para a Upper
	-- Rafael 18/07/2014 14:14:12 - CRIADO
	--->
	<cffunction name='envia_pre_ordem' displayname='Efetuar envio da pr ordem para a Upper' access='remote' returntype='Struct' output='true'>
		<cfargument name='PRE_ORDEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='grisco.pkg_pre_ordem.prc_envia_pre_ordem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRE_ORDEM_ID'  value='#arguments.PRE_ORDEM_ID#'  null='#iif(len(trim(arguments.PRE_ORDEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pr-ordem enviada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Consulta pr-ordem
	-- Rafael 18/07/2014 14:14:12 - CRIADO
	--->
	<cffunction name='consulta_pre_ordem' displayname='Consulta pr-ordem' access='remote' returntype='Struct' output='true'>
		<cfargument name='PRE_ORDEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='grisco.pkg_pre_ordem.prc_consulta_pre_ordem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRE_ORDEM_ID'  value='#arguments.PRE_ORDEM_ID#'  null='#iif(len(trim(arguments.PRE_ORDEM_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pr-ordem atualizada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Imprimir pr ordem de carregamento
	-- rafael 28/08/2014 23:59:58 - CRIADO
	--->
	<cffunction name='gerar_pre_ordem' displayname='Imprimir pr ordem de carregamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='PRE_ORDEM_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='grisco.pkg_impressao_pre_ordem.prc_gerar_pre_ordem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_PRE_ORDEM_ID'  value='#arguments.PRE_ORDEM_ID#'  null='#iif(len(trim(arguments.PRE_ORDEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB' dbvarname='P_ARQUIVO' variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Pr-ordem gerada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Cancelar vnculo entre solicitao de carga e pr ordem
	-- rafael 11/09/2014 00:04:04 - CRIADO
	--->
	<cffunction name='can_pre_ordem_sol_carga' displayname='Cancelar vnculo entre solicitao de carga e pr ordem' access='remote' returntype='Struct' output='true'>
		<cfargument name='SOLICITACAO_CARGA_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='grisco.pkg_pre_ordem.prc_can_pre_ordem_sol_carga' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SOLICITACAO_CARGA_ID'  value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao de carga desvinculada de pr-ordem de carregamento com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>   

    <!--- 
	-- PROPSITO
	-- Insere liberaao manual da SM
	-- GUTO - CRIADO
	--->
	<cffunction name='ins_romaneio_requisicao_buonny' displayname='Insere liberaao manual da SM' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COD_AUTORIZACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='grisco.pkg_buonny.prc_ins_romaneio_requisicao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_ROMANEIO_REQ_ID' variable='retorno.ROMANEIO_REQ_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISICAO_ID' null='yes'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_REQUISICAO_ID' value='98'> <!--- liberaao manual --->
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5' dbvarname='P_COD_AUTORIZACAO'  value='#arguments.COD_AUTORIZACAO#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Solicitao de monitoramento manual inserida com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>      
</cfcomponent>
