<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	-- RAFAEL
	-- 16/07/2014 - criado
	--->	
	<cffunction name="get_veiculo_dados" displayname="Retorna dados do veculo" output="true" returntype="query" access="remote">
		<cfargument name="placa" required="no">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select v.placa
                 , p.cliente as nome
                 , p.cnpj_cpf
                 , vp.cod_pessoa
                 , prop.cod_pessoa as proprietario
                 , v.chassis
                 , v.renavan as renavam
                 , v.veiculo_id
                 , (select vc.placa_1
                      from oper.v$veiculo_composicao vc 
                     where vc.placa_2 = v.placa
                       and vc.data_hora_engate <=  sysdate
                       and nvl(vc.data_hora_desengate, sysdate) >= sysdate) as placa_cavalo
                 , (select vc.placa_2
                      from oper.v$veiculo_composicao vc 
                     where vc.placa_1 = v.placa
                       and vc.data_hora_engate <=  sysdate
                       and nvl(vc.data_hora_desengate, sysdate) >= sysdate) as placa_carreta
                  , (select kss.pkg_pessoa.fnc_get_identificador(vm.cod_pessoa, 0)
                      from oper.v$veiculo_motorista vm
                     where vm.placa = v.placa
                       and sysdate between vm.data_inicio and nvl(vm.data_fim, sysdate) ) as motorista
              from oper.v$veiculo v
             inner join oper.v$veiculo_proprietario_doc vp
                on vp.placa = v.placa
               and vp.data_fim is null 
             inner join kss.v$pessoa p
                on p.cod_pessoa = vp.cod_pessoa
             inner join oper.v$veiculo_proprietario prop
                on prop.placa = v.placa
               and prop.data_fim is null
             where 1 = 1
			<cfif IsDefined("arguments.placa") and Len(Trim(arguments.placa))>
			   and vp.placa = upper('#arguments.placa#')
			</cfif>		
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca natureza
	-- NOTAS EXPLICATIVAS
	-- RAFAEL 17/07/2014
	--->
	<cffunction name="get_natureza" displayname="Busca Natureza" access="remote" returntype="query" output="false">
		<cfargument name="num_natureza" required="no" default="">
		<cfargument name="descricao" required="no" default="">
        <cfargument name="order_by" required="no" default="0" hint="0-Descrio Resumida, Descrio; 1-Descrio">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select n.num_natureza, n.descricao, n.grupo_natureza_id, gn.descricao_resumida grupo, gn.descricao as descricao_grupo, n.peso_especifico
              from oper.v$natureza n
             inner join oper.v$grupo_natureza gn
                     on gn.grupo_natureza_id = n.grupo_natureza_id
             where 1=1
			<cfif Len(Trim(arguments.num_natureza))>
			   and n.num_natureza = #arguments.num_natureza#
			</cfif>
			<cfif Len(Trim(arguments.descricao))>
			   and upper(n.descricao) like upper('%#arguments.descricao#%')
			</cfif>
            <cfif arguments.order_by eq 0>
			 order by gn.descricao_resumida, n.descricao
            <cfelseif arguments.order_by eq 1>
             order by n.descricao
            </cfif>
		</cfquery>		
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna pr-ordens
	-- NOTAS EXPLICATIVAS
	-- RAFAEL
	-- 21/07/2014 - criado
	--->	
	<cffunction name="get_pre_ordens" displayname="Retorna pr-ordens" output="true" returntype="query" access="remote">
		<cfargument name="pre_ordem_id_filtro" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfargument name="cod_pessoa_motorista" required="no" default="" />
        <cfargument name="placa_cavalo" required="no" default="" />
        <cfargument name="placa_carreta" required="no" default="" />
        <cfargument name="status_codigo" required="no" default="" />        
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select p.pre_ordem_id
                 , to_char(p.data_validade, 'dd/mm/yyyy hh24:mi') as data_validade
                 , case when p.data_validade  < sysdate
                      then 0
                      else 1
                   end as valida
                 , p.mot_cod_pessoa
                 , p.mot_nome
                 , kss.pkg_string.fnc_formata_cnpj_cpf(p.mot_cpf) as mot_cpf
                 , p.mot_pai_nome
                 , p.mot_mae_nome
                 , to_char(p.mot_data_nasc, 'dd/mm/yyyy') as mot_data_nasc
                 , p.mot_rg
                 , p.mot_cnh
                 , p.mot_uf
                 , p.cavalo_veiculo_id
                 , p.cavalo_placa
                 , p.cavalo_renavam
                 , p.cavalo_chassi
                 , p.cav_prop_cod_pessoa
                 , kss.pkg_pessoa.fnc_get_identificador(p.cav_prop_cod_pessoa) as cavalo_prop_cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(p.cav_prop_cod_pessoa) as cavalo_prop_nome
                 , p.carreta_veiculo_id
                 , p.carreta_placa
                 , p.carreta_renavam
                 , p.carreta_chassi
                 , p.car_prop_cod_pessoa
                 , kss.pkg_pessoa.fnc_get_identificador(p.car_prop_cod_pessoa) as carreta_prop_cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(p.car_prop_cod_pessoa) as carreta_prop_nome
                 , p.carreta2_veiculo_id
                 , p.carreta2_placa
                 , p.carreta2_renavam
                 , p.carreta2_chassi
                 , p.car2_prop_cod_pessoa
                 , kss.pkg_pessoa.fnc_get_identificador(p.car2_prop_cod_pessoa) as carreta2_prop_cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(p.car2_prop_cod_pessoa) as carreta2_prop_nome
                 , p.carreta3_veiculo_id
                 , p.carreta3_placa
                 , p.carreta3_renavam
                 , p.carreta3_chassi
                 , p.car3_prop_cod_pessoa
                 , kss.pkg_pessoa.fnc_get_identificador(p.car3_prop_cod_pessoa) as carreta3_prop_cnpj_cpf
                 , kss.pkg_pessoa.fnc_get_cliente(p.car3_prop_cod_pessoa) as carreta3_prop_nome
                 , p.mercadoria
                 , p.valor_mercadoria
                 , p.mercadoria
                 , p.valor_mercadoria
                 , grisco.pkg_impressao_pre_ordem.fnc_converte_valor_xml( p.valor_mercadoria) as valor_mercadoria_formatado
                 , p.origem_municipio
                 , p.origem_uf
                 , p.destino_municipio
                 , p.destino_uf
                 , p.pedido_cliente
                 , nvl((select max(cg.rv_abbreviation) keep (dense_rank last order by pr.date_insert) 
                          from grisco.v$pre_ordem_requisicao pr
                          left join grisco.v$cg_ref_codes cg
                            on cg.rv_domain = 'PRE_ORDEM.STATUS'
                           and cg.rv_low_value = pr.cod_retorno
                         where pr.pre_ordem_id = p.pre_ordem_id )
                       , 'Status no encontrado') as status_descricao
                 , (select max(pr.cod_retorno) keep (dense_rank last order by pr.date_insert) 
                      from grisco.v$pre_ordem_requisicao pr
                     where pr.pre_ordem_id = p.pre_ordem_id ) as status_codigo
                 , (select ps.solicitacao_carga_id
                      from grisco.v$pre_ordem_sol_carga ps
                     where ps.pre_ordem_id = p.pre_ordem_id
                       and ps.data_cancelamento is null) as solicitacao_carga_id
                 , p.user_insert
                 , to_char(p.date_insert, 'dd/mm/yyyy hh24:mi') as date_insert
                 , p.user_update
                 , to_char(p.date_update, 'dd/mm/yyyy hh24:mi') as date_update
                 , p.site
              from grisco.v$pre_ordem p
             where 1 = 1
            <cfif Len(Trim(arguments.pre_ordem_id_filtro))>
               and p.pre_ordem_id = #arguments.pre_ordem_id_filtro#
		    <cfelse>
			    <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                  and p.date_insert between to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino# 23:59:00', 'dd/mm/yyyy hh24:mi:ss')
                <cfelseif Len(Trim(arguments.data_inicio))>
                  and p.date_insert >= to_date('#arguments.data_inicio# 00:00:00', 'dd/mm/yyyy hh24:mi:ss')
                <cfelseif Len(Trim(arguments.data_termino))>
                  and p.date_insert <= to_date('#arguments.data_termino# 23:59:00', 'dd/mm/yyyy hh24:mi:ss')
                </cfif>
                
                <cfif len(trim(arguments.cod_pessoa_motorista))>
                  and p.mot_cod_pessoa = #arguments.cod_pessoa_motorista#
                </cfif>
                <cfif len(trim(arguments.placa_cavalo))>
                  and p.cavalo_placa = '#arguments.placa_cavalo#'
                </cfif>
                <cfif len(trim(arguments.placa_carreta))>
                  and p.carreta_placa = '#arguments.placa_carreta#'
                </cfif>
                <cfif len(trim(arguments.status_codigo))>
                  and (select max(pr.cod_retorno) keep (dense_rank last order by pr.date_insert) 
                         from grisco.v$pre_ordem_requisicao pr
                        where pr.pre_ordem_id = p.pre_ordem_id ) = #arguments.status_codigo#                
                </cfif>
                
            </cfif>
             order by p.pre_ordem_id desc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os status das pr-ordens
	-- NOTAS EXPLICATIVAS
	-- RAFAEL
	-- 21/07/2014 - criado
	--->	
	<cffunction name="get_pre_ordem_status" displayname="Retorna os status das pr-ordens" output="true" returntype="query" access="remote">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cg.rv_low_value as status_codigo
                 , cg.rv_abbreviation as status_descricao
              from grisco.v$cg_ref_codes cg
             where cg.rv_domain = 'PRE_ORDEM.STATUS'
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna as requisies da Repom
    -- RAFAEL 23/07/2014 - CRIADO
    --->		
    <cffunction name="get_requisicao" access="remote" returntype="query" output="true">
    	<cfargument name="pre_ordem_id" required="no" default="" />
        <cfargument name="data_inicio" required="no" default="" />
        <cfargument name="data_termino" required="no" default="" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select 'Envio' as tipo
                 , pr.pre_ordem_id
                 , pr.requisicao_id
                 , pr.referencia as referencia
                 , pr.cod_retorno as status_codigo
                 , nvl((select cg.rv_abbreviation
                          from grisco.v$cg_ref_codes cg
                         where cg.rv_domain = 'PRE_ORDEM.STATUS'
                           and cg.rv_low_value = pr.cod_retorno)
                     , 'Status no encontrado') as status_descricao
                 , (select case
                              when r.erro is not null then 1
                              else 0
                           end
                      from grisco.v$requisicao r
                      where r.requisicao_id = pr.requisicao_id ) as possui_erro
                 , pr.user_insert
                 , to_char(pr.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , pr.user_update
                 , to_char(pr.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from grisco.v$pre_ordem_requisicao pr
             where 1 = 1
             <cfif Len(Trim(arguments.pre_ordem_id))>
                and pr.pre_ordem_id = #arguments.pre_ordem_id#
			 <cfelse>
				 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                   and pr.date_insert between to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
                 <cfelseif Len(Trim(arguments.data_inicio))>
                   and pr.date_insert >= to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss')
                 <cfelseif Len(Trim(arguments.data_termino))>
                   and pr.date_insert <= to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
                 </cfif>
             </cfif>
            
            union all
            
            select 'Consulta' as tipo
                 , pr.pre_ordem_id
                 , poc.requisicao_id
                 , pr.referencia as referencia
                 , poc.cod_retorno as status_codigo
                 , nvl((select cg.rv_abbreviation
                          from grisco.v$cg_ref_codes cg
                         where cg.rv_domain = 'PRE_ORDEM.STATUS'
                           and cg.rv_low_value = poc.cod_retorno)
                     , 'Status no encontrado') as status_descricao
                  , (select case
                              when r.erro is not null then 1
                              else 0
                           end
                      from grisco.v$requisicao r
                     where r.requisicao_id = poc.requisicao_id ) as possui_erro
                  , poc.user_insert
                 , to_char(poc.date_insert, 'dd/mm/yyyy hh24:mi:ss') as date_insert
                 , poc.user_update
                 , to_char(poc.date_update, 'dd/mm/yyyy hh24:mi:ss') as date_update
              from grisco.v$pre_ordem_consulta poc 
             inner join grisco.v$pre_ordem_requisicao pr
                on pr.envio_id = poc.envio_id
             where 1 = 1
             <cfif Len(Trim(arguments.pre_ordem_id))>
                and pr.pre_ordem_id = #arguments.pre_ordem_id#
			 <cfelse>
				 <cfif Len(Trim(arguments.data_inicio)) and Len(Trim(arguments.data_termino))>
                   and poc.date_insert between to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss') and to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
                 <cfelseif Len(Trim(arguments.data_inicio))>
                   and poc.date_insert >= to_date('#arguments.data_inicio#:00', 'dd/mm/yyyy hh24:mi:ss')
                 <cfelseif Len(Trim(arguments.data_termino))>
                   and poc.date_insert <= to_date('#arguments.data_termino#:59', 'dd/mm/yyyy hh24:mi:ss')
                 </cfif>
             </cfif>
             
             order by date_insert desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o XML de Envio de uma requisio
    -- RAFAEL 23/07/2014 - CRIADO
    --->		
    <cffunction name="get_requisicao_xml_envio" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.xml_envio
              from grisco.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o XML de Retorno de uma requisio
    -- RAFAEL 23/07/2014 - CRIADO
    --->		
    <cffunction name="get_requisicao_xml_retorno" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select xml_retorno
              from grisco.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
    -- PROPSITO 
    -- Retorna o Erro de uma requisio
    -- RAFAEL 23/07/2014 - CRIADO
    --->		
    <cffunction name="get_requisicao_erro" access="remote" returntype="query" output="true">
    	<cfargument name="requisicao_id" required="yes" />
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.erro
              from grisco.v$requisicao r
             where r.requisicao_id = #arguments.requisicao_id#
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna os municpios do IBGE cadastrados
	-- JAQUELINEF 26/09/2012
	--->	
	<cffunction name="get_municipio_ibge" displayname="Retorna os municpios do IBGE cadastrados" output="true" returntype="query" access="remote">
    	<cfargument name="municipio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select im.sigla_uf, im.nome_municipio, im.cod_uf, im.cod_municipio,
				   im.cod_dv, im.cod_distrito,
                   oper.pkg_coord_geografica.fnc_graus2decimais(m.latitude) as latitude,
                   oper.pkg_coord_geografica.fnc_graus2decimais(m.longitude) as longitude
			  from cep.ibge_municipio im
              left outer join cep.municipio m
                on im.municipio_id_kmm = m.municipio_id
			 where 1=1
			<cfif Len(Trim(arguments.municipio))>
			   and upper(kss.pkg_string.fnc_string_clean(municipio)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.municipio#%'))
			</cfif>
			 order by im.nome_municipio asc
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Retorna dados do romaneio
	-- GUTO
	--->	
	<cffunction name="get_romaneio_dados" displayname="Retorna os dados do romaneio" output="true" returntype="query" access="remote">
    	<cfargument name="num_romaneio" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select v.num_romaneio, v.viagem_id,
                   to_char(v.data_inicio,'dd/mm/yyyy hh24:mi') as data_inicio, 
                   to_char(v.data_termino,'dd/mm/yyyy hh24:mi') as data_termino,
                   v.num_viagem_ctrc_cliente,
                   oper.pkg_veiculo.fnc_placa(v.veiculo_id) as cavalo,
                   oper.pkg_veiculo.fnc_placa(v.veiculo_id_referencia) as carreta,
                   kss.pkg_pessoa.fnc_get_identificador(v.cod_motorista) as cpf_motorista,
                   kss.pkg_pessoa.fnc_get_cliente(v.cod_motorista,1) as motorista,
                   (select t.telefone
                      from kss.v$pessoa_telefone_padrao t
                     where t.cod_pessoa = v.cod_motorista)  as telefone,
                   sc.solicitacao_carga_id,
                   kss.pkg_pessoa.fnc_get_cliente(sc.cod_remetente,1) as remetente,
                   cep.pkg_municipio.fnc_municipio_uf(sc.origem_municipio_id) as origem,
                   kss.pkg_pessoa.fnc_get_cliente(sc.cod_destinatario,1) as destinatario,
                   cep.pkg_municipio.fnc_municipio_uf(sc.destino_municipio_id) as destino,
                   nvl((select sum(snf.valor_segurado)
                          from logistica.v$solicitacao_carga_nf snf
                         where snf.solicitacao_carga_id = sc.solicitacao_carga_id),0) as valor_segurado,
                   n.descricao as mercadoria,
                   (select count(*)
                      from logistica.v$viagem vi
                     where vi.cod_motorista = v.cod_motorista
                       and vi.viagem_id <> v.viagem_id
                       and vi.situacao_id > 0) as numero_viagens_anteriores
              from logistica.v$viagem v
             inner join logistica.v$viagem_carga vc
                on vc.viagem_id = v.viagem_id
             inner join logistica.v$solicitacao_carga sc
                on vc.solicitacao_carga_id = sc.solicitacao_carga_id
             inner join oper.v$natureza n
                on n.num_natureza = sc.num_natureza
             where 1=1
			<cfif Len(Trim(arguments.num_romaneio))>
		       and v.num_romaneio = #arguments.num_romaneio#
            <cfelse>
               and 1=0
			</cfif>
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>    
    
</cfcomponent>