<cfcomponent displayname="Gesto de Viagens" extends="_transportes.funcoes.cfc_init">
   
    <!---
   -- PROPSITO
   -- Busca os dados da viagem
   -- RICARDOC 27/01/2014 - CRIADO
   ---> 
   <cffunction name="get_viagem_terceiro" access="remote" returntype="query" output="true">
      <cfargument name="num_romaneio" required="yes"/>
      <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select r.num_romaneio
             , r.carregamento as origem
             , r.destino as destino
             , r.cliente as cliente
             , n.descricao as mercadoria
             , to_char(rhv.data_inicio, 'dd/mm/yyyy hh24:mi') as data_inicio
             , sysdate as data_atual
             , (select vm.modalidade from oper.v$veiculo_modalidade vm where r.placa_controle = vm.placa) as modalidade             
             , to_char(to_timestamp(coalesce((select max(con.data_emissao) as data
                           from fiscal.v$conhecimento con
                          where con.num_romaneio = r.num_romaneio
                            and con.substituto = 0
                            and con.conhecimento_tipo_id = 1
                       ) , (select max(nfes.data_emissao) as data
                              from fiscal.v$nf_es_frete n
                             inner join fiscal.v$nf_es nfes
                                on nfes.num_nota_id = n.nf_es_id
                             where n.num_romaneio = r.num_romaneio
                           ))),'dd/mm/yyyy hh24:mi') as data_emissao
          from oper.v$romaneio r
          left join oper.v$natureza n
            on r.num_natureza = n.num_natureza
         inner join oper.v$romaneio_hist_veiculo rhv
            on rhv.num_romaneio = r.num_romaneio
         where r.num_romaneio = '#arguments.num_romaneio#'
           and rhv.roo_hist_veiculo_id = (select max(rh.roo_hist_veiculo_id) keep(dense_rank last order by rh.data_inicio)
                                            from oper.v$romaneio_hist_veiculo rh
                                           where rh.num_romaneio = '#arguments.num_romaneio#') 
           and r.situacao_id < 2
           and r.data_inicio >= (select max(vm.data) from oper.v$veiculo_modalidade vm where r.placa_controle = vm.placa)
        </cfquery>
        <cfreturn qr_result>
   </cffunction>
  
</cfcomponent>
