<script language="javascript1.2" src="/_scripts/scripts_db.js"></script>
<cfif (isDefined("vars.data_inicio") and len(trim(vars.data_inicio))) and (isDefined("vars.data_fim") and len(trim(vars.data_fim))) >
	<cfscript>
		connMann = CreateComponent("modulos.gerenciamento_multas._componentes.manipulacao.cfc_gerenciamento_multas");
		connCons = CreateComponent("modulos.gerenciamento_multas._componentes.consulta.cfc_gerenciamento_multas");
		
        ret = connMann.gera_protocolo_acomp( data_inicio = vars.data_inicio,
                                             data_fim	 = vars.data_fim);		
		qrEmpresa = connCons.get_dados_empresa_protocolo( cod_pessoa = 1);
		
	</cfscript>
    <cfif ret.erro >	
    	<cfthrow object="#ret.mensagem#">
	</cfif>	

    <cfif isDefined("vars.ACAO") and vars.ACAO eq 1 >
		<cfscript>
            qrInfracao = connCons.get_auto_infracao( data_inicio_lancamento = vars.data_inicio
                                                   , data_fim_lancamento	= vars.data_fim
                                                   , num_protocolo			= ret.NUM_PROTOCOLO
                                                    );
    
            qrPessoa = connCons.get_pessoa_usuario( cod_pessoa = session.cod_pessoa_usuario );
        </cfscript>
    <cfelse>
    	<cfif isDefined("vars.ACAO") and vars.ACAO eq 2 >
			<cfscript>
                qrInfracao = connCons.get_auto_infracao( num_protocolo	= vars.protocolo );
        		
                qrPessoa = connCons.get_pessoa_usuario( usuario = qrInfracao.usuario_protocolo );
            </cfscript>
    	</cfif>
    </cfif>        
    <cfif ret.erro>
        <cfthrow object="#ret.mensagem#">
    </cfif>
 <cfelse>
 	<cfabort>
</cfif>

<cfscript>
	v_meses = ArrayNew(1);
	arrayAppend(v_meses,'Janeiro');
	arrayAppend(v_meses,'Fevereiro');
	arrayAppend(v_meses,'Maro');
	arrayAppend(v_meses,'Abril');
	arrayAppend(v_meses,'Maio');
	arrayAppend(v_meses,'Junho');
	arrayAppend(v_meses,'Julho');
	arrayAppend(v_meses,'Agosto');
	arrayAppend(v_meses,'Setembro');
	arrayAppend(v_meses,'Outubro');
	arrayAppend(v_meses,'Novembro');
	arrayAppend(v_meses,'Dezembro');
</cfscript>

<cfdocument format="pdf" pagetype="A4" margintop="5" marginbottom="2.5" unit="cm" >

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Protocolo de Acompanhamento</title>
  <style>
	body{
		text-align: center;	
		font-family: Verdana, Geneva, sans-serif;
		letter-spacing:0.3;
		font-size:12px;
	}
	
	.conteiner{
		margin-left: auto;
		margin-right: auto;
		width: 640px;
		text-align:center;
	}
	
	.td_logo{
		width:100px;
		border:1px solid #666;
	}
	
	.td_titulo{
		border-bottom:1px solid #666;
		color: #000;
		font-size:16px;
		font-weight:bold;
		padding-left:5px;
		font-family: Verdana, Geneva, sans-serif;
	}
	
	.td_dados{
		font-size:12px;
		padding-left:5px;	
		font-family: Verdana, Geneva, sans-serif;
	}
	
	.td_titulo_infracao{
		color:#039 ;
		font-size:14px;	
		font-weight:bold;
		border-bottom:1px solid #000;
		padding:5px;
	}
	
	.table_resultados{
		border:1px solid #000;
		margin-top:-11px;
		font-size:10px;
		color: #000;
		padding-bottom:20px;
	}
	
	.tr_resultados{
		height:22px;
	}
	
	.tr_resultados_back{
		/*background-color:#c9c9c9;*/
		border-right:2px solid #000;
	}
	
	.tr_resultados td{
		padding:5px;
	}
	
	.dv_resultados{
		height:600px;	
	}
	
	.td_assinatura{
		font-size:12px;
		color: #000;
		border-top:1px solid #000;
		width:40%;
		text-align:center;
	}
	
	.td_endereco{
		font-size:12px;
	}
</style>
</head>

<body>
 <cfdocumentitem type="header" >
 	<style>	
	
		.table_titulo{
			margin-top:20px;
			border-bottom:4px solid #06C;
			font-size:14px;
			font-weight:bold;
			color: #000;
			text-align:center;
			font-family: Verdana, Geneva, sans-serif;
		}
		
		.td_logo{
			width:100px;
			border:1px solid #666;
		}
		
		.td_titulo{
			border-bottom:1px solid #666;
			color: #000;
			font-size:16px;
			font-weight:bold;
			padding-left:5px;
			font-family: Verdana, Geneva, sans-serif;
		}
		
		.td_dados{
			font-size:12px;
			padding-left:5px;	
			font-family: Verdana, Geneva, sans-serif;
		}	
	
	</style>
	<cfoutput>
        <table width="100%" cellspacing="0" id="table_header1" >
            <tr>
                <td rowspan="4" class="td_logo"><img src="<cf_url>/_imagens/logos/logo_relatorio.jpg</cf_url>" /></td>
                <td class="td_titulo">#qrEmpresa.RAZAO_SOCIAL#</td>
            </tr>
            <tr>
                <td class="td_dados">CNPJ #qrEmpresa.CNPJ_CPF# Inscr. Estadual #qrEmpresa.INSCRICAO_ESTADUAL#</td>
            </tr>
            <tr>
                <td class="td_dados">CEP #qrEmpresa.CEP#, #qrEmpresa.MUNICIPIO# - #qrEmpresa.UF#</td>
            </tr>
            <tr>
                <td class="td_dados">#qrEmpresa.LOGRADOURO#, #qrEmpresa.NUMERO# #qrEmpresa.BAIRRO#</td>
            </tr>
        </table>
    
    
        <table width="100%" class="table_titulo">
            <tr>
                <td>Protocolo de Entrega de Multas de Tr&acirc;nsito n&deg; <cfoutput><cfif isDefined("vars.acao") and vars.acao eq 1 >#ret.num_protocolo#<cfelse>#vars.protocolo#</cfif></cfoutput></td>
            </tr>
        </table>
    </cfoutput>
  </cfdocumentitem>
  
   <cfdocumentitem type="footer" >
 	<style>	
		.sp_paginas{
			font-size:11px;
			font-family: Verdana, Geneva, sans-serif;
		}	
	</style>
    <cfoutput>
 	 <span class="sp_paginas">P&aacute;gina #cfdocument.currentpagenumber# de #cfdocument.totalpagecount#</span>
    </cfoutput>
  </cfdocumentitem>
    
        <table width="100%" class="table_resultados" cellspacing="0">
            <tr class="tr_titulo_infracao">
                <td width="7%" align="left" class="td_titulo_infracao">Placa</td>
                <td width="5%" align="center" class="td_titulo_infracao">C&oacute;d.</td>
                <td width="20%" class="td_titulo_infracao">Motorista</td>
                <td width="10%" align="center" class="td_titulo_infracao">Data</td>
                <td width="57%" class="td_titulo_infracao">Infra&ccedil;&atilde;o</td>
            </tr>
            
            <cfif qrInfracao.RecordCount gt 0 >
            	<cfset count = 1 >
				<cfoutput query="qrInfracao">
                  
                    <cfscript>
                        qrInfracaoItem = connCons.get_auto_infracao_item( auto_infracao_id = qrInfracao.AUTO_INFRACAO_ID );
                    </cfscript>
                    
                    
                    <cfloop index="i" from="1" to="#qrInfracaoItem.recordCount#" step="1">
                        <tr valign="middle" class="tr_resultados" <cfif count mod 2 eq 1 > style="background-color:##DFDFDF" </cfif> >
                            <td align="left">#qrInfracao.PLACA#</td>
                            <td align="center">#qrInfracao.COD_PESSOA_MOTORISTA#</td>
                            <td>#qrInfracao.MOTORISTA#</td>
                            <td align="center">#LSDateFormat(qrInfracao.DATA_INFRACAO,'dd/mm/yyyy')#</td>
                            <td>#textcut(qrInfracaoItem.DESCRICAO[i],50)#</td>
                        </tr>
                        <cfset count = count + 1 >
                    </cfloop>
                </cfoutput>
             <cfelse>
            	<tr class="tr_resultados" >
                            <td align="left" colspan="5">Nenhum auto de infra&ccedil;&atilde;o encontrado...</td>
                        </tr>
            </cfif>
        
        </table>

        
    <table width="100%" style="margin-top:100px">
    	<tr>
        	<td colspan="3" class="td_endereco">Ponta Grossa, <cfoutput>#LSDateFormat(now(),'dd')#</cfoutput> de <cfoutput>#v_meses[LSDateFormat(now(),'mm')]#</cfoutput> de <cfoutput>#LSDateFormat(now(),'yyyy')#</cfoutput></td>
        </tr>
        <tr>
        	<td height="80" colspan="3"></td>
        </tr>
        <tr>
        	<td class="td_assinatura"><cfoutput>#qrPessoa.RAZAO_SOCIAL#</cfoutput></td>
            <td width="20%">&nbsp;</td>
            <td class="td_assinatura">Recebedor</td>
        </tr>
    </table>
</body>
</html>
</cfdocument>

<cfset path = ExpandPath("/temp")>
<cfpdf action="merge" destination="#path#/protocolo_#lstimeformat(now(),'hhmiss')#.pdf" overwrite="yes">
        <cfpdfparam source="pdf_documento" />
</cfpdf>
<script>	
  window.open('/temp/protocolo_<cfoutput>#lstimeformat(now(),'hhmiss')#</cfoutput>.pdf','_self','');
</script>