<html>
<cfinclude template="/_scripts/scripts.cfm" />
<cfscript>
	conn = CreateComponent("modulos.gerenciamento_multas._componentes.consulta.cfc_gerenciamento_multas");
	qrSituacao = conn.get_situacao();
	qrInfracao = conn.get_tipo_infracao();

	if (isDefined("vars.CONSULTA")){
        qrAcompanhamento = conn.get_acompanhamento_infracao(motorista_cod = vars.COD_MOTORISTA,
                                                            veiculo_placa = vars.PLACA,
                                                            orgao_autuador_id = vars.ORGAO_AUTUADOR_ID,
                                                            num_romaneio = vars.NUM_ROMANEIO,
															situacao = '',
                                                            infracao = vars.INFRACAO,
                                                            data_inicial = vars.DATA_INICIAL,
                                                            data_final = vars.DATA_FINAL);
		
	}
	
</cfscript>

<script type="text/javascript">
	// Configura botes //
	parent.f_set_texto('titulo_aplicacao', 'Gerenciamento de Multas');
	parent.f_set_texto('titulo_pagina', 'Relatrio de Auto Infrao');
	
	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); }
	
	parent.f_hidden('btn_incluir');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	
	<cfif IsDefined("vars.CONSULTA") and qrAcompanhamento.RecordCount gt 0>
		f_cria_botao('imprimir', 'Imprimir Auto Infraes Selecionadas', 'gerarPDF()', parent.document.getElementById('barra_botoes_top'));
		parent.document.getElementById('btn_imprimir').style.width = 230;
	</cfif>
	parent.f_habilitar_botao('confirmar', 'f_confirmar()');
	
	// ---------------- //
	
	function f_confirmar() {
		with(document.forms[0]) {
			
			if(Number(DATA_FINAL.value.getDateTime()) < Number(DATA_INICIAL.value.getDateTime())) {
				alert('A data final no pode ser maior que a data inicial.');
				DATA_FINAL.select();
				return false;
			}
			
			if(COD_MOTORISTA.value == ''){ 
				CNPJ_FUNCIONARIO.value = '';
				NOME_MOTORISTA.value = '';
			}
			
			if(PLACA.value == ''){
            	COD_VEICULO.value = '';
            	MARCA_MODELO.value = '';
			}
			
			target = '_self';
			action = 'principal.cfm';		
			submit();
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;
	
	function f_excluir() {
		with(document.forms[0]) {
			OPERACAO.value = 4; // Excluir
			try {
				ATUALIZA_COMBO.disabled = false;
			} catch(e) {}
			target = 'consultas';
			action = 'confirma.cfm';		
			if(confirm('Para confirmar a excluso do registro clique em OK.')) {
				submit();
			}
		}
	}	
	parent.f_excluir = f_excluir;
	
	function f_localizar() {
		NewWindow('localizar.cfm', 'Localizar', '800', '600', 'yes');
	}
	parent.f_localizar = f_localizar;
	
	
		
	function f_busca_motorista(p_opcao) {
		with(document.forms[0]) {
			var v_filtro;
			
			if(p_opcao == 1) {
				NOME_MOTORISTA.value = '';
				//COD_MOTORISTA.value = '';
				if(!CNPJ_FUNCIONARIO.value) {
					return;
				}				
				v_filtro = 'tipo_pessoa=1&cnpj_cpf=' + CNPJ_FUNCIONARIO.value;
			}
			else if(p_opcao == 2) {
				NOME_MOTORISTA.value = '';
				CNPJ_FUNCIONARIO.value = '';
				v_filtro = 'tipo_pessoa=1&cnpj_cpf=' + CNPJ_MOTORISTA.value;
			}
			else if(p_opcao == 3){
				if(COD_MOTORISTA.value.trim() == '')
					return;
					
				NOME_MOTORISTA.value = '';
				CNPJ_FUNCIONARIO.value = '';
				v_filtro = 'tipo_pessoa=1&cod_pessoa=' + COD_MOTORISTA.value;
			}
			
			NOME_MOTORISTA.value = 'Buscando motorista...';
			f_query_wddx('<cf_url>/modulos/gerenciamento_multas/_componentes/consulta/cfc_pessoa.cfc</cf_url>?method=getPessoa'
						,v_filtro
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.cod_pessoa.length > 0) {
									if(p_opcao == 1) {
										NOME_MOTORISTA.value = obj.struct.cliente[0];
										COD_MOTORISTA.value = obj.struct.cod_pessoa[0];
									}
									else if(p_opcao == 2) {
										NOME_MOTORISTA.value = obj.struct.cliente[0];
										CNPJ_FUNCIONARIO.value = obj.struct.cnpj_cpf[0];
										COD_MOTORISTA.value = obj.struct.cod_pessoa[0];
									}
									else if(p_opcao == 3) {
										NOME_MOTORISTA.value = obj.struct.cliente[0];
										CNPJ_FUNCIONARIO.value = obj.struct.cnpj_cpf[0];
									}
								}
								else {
									NOME_MOTORISTA.value = 'Motorista no encontrado.';
									CNPJ_FUNCIONARIO.focus();
								}
							}
						});
		}
	}
	
	function f_busca_veiculo() {
		with(document.forms[0]) {
			PLACA.value = '';
			MARCA_MODELO.value = '';
			
			if(!COD_VEICULO.value) {
				return;
			}
			f_query_wddx('<cf_url>/modulos/gerenciamento_multas/_componentes/consulta/cfc_veiculo.cfc</cf_url>?method=get_veiculo'
						,'frota=' + COD_VEICULO.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								
								if(obj.struct.placa.length == 1) {
									
									PLACA.value = obj.struct.placa[0];
									MARCA_MODELO.value = obj.struct.modelo[0] + ' / ' + obj.struct.marca[0];
									
								}else if(obj.struct.placa.length > 1) {
									var msg;
									msg = 'Foi encontrado mais de um veculo (';
																			  
									for(var i = 0; i < obj.struct.placa.length; i++) {
										msg += obj.struct.placa[i];
										
										if(i != (obj.struct.placa.length - 1)) {
											msg += ' / ';
										}
									}
									
									msg += ').';
									alert(msg);
									COD_VEICULO.focus();
								}
								else {
									MARCA_MODELO.value = 'Veculo no encontrado.';
									COD_VEICULO.focus();
								}
							}
						});
		}
	}
	
	function f_busca_orgao_autuador() {
		
		with(document.forms[0]){
			
			DESCRICAO.value = '';
			
			if(ORGAO_AUTUADOR_ID.value == ''){
				
				return false;
				
			}else{
				
				f_query_wddx('<cf_url>/modulos/gerenciamento_multas/_componentes/consulta/cfc_gerenciamento_multas.cfc</cf_url>?method=get_orgao_autuador'
						,'orgao_autuador_id=' + ORGAO_AUTUADOR_ID.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								
								if(obj.struct.descricao.length == 1) {
									
									DESCRICAO.value = obj.struct.descricao[0];
									
								}else {
									DESCRICAO.value = 'Orgo Autuador no encontrado.';
									ORGAO_AUTUADOR_ID.focus();
								}
							}
						});
				
			}
		
		}
	
	}
	
	function gerarPDF(){
		
		var elemChk = document.getElementsByName('chk_auto_infracao[]');
		var cods = '';
		
		for(var i = 0; i < elemChk.length; i++){
			
			if(elemChk[i].checked){
				if(cods == '')
					cods = elemChk[i].value;
				else cods = cods + ',' + elemChk[i].value;
			}	
			
		}
		
		if(cods == ''){
			alert('Selecione ao menos uma infrao para gerar a impresso.');
			return false;
		}
		
		NewWindow('<cf_url>/modulos/gerenciamento_multas/relatorios/auto_infracao/pdf.cfm</cf_url>?cod_auto_infracao=' + cods,'Impressao',screen.width,screen.height,'yes');
	
	}
	
	function f_selecionarTodos(chk){
		
		var elemChk = document.getElementsByName('chk_auto_infracao[]');
		
		for(var i = 0; i < elemChk.length; i++){
			
			elemChk[i].checked = chk.checked;
			
		}
		
	}
	
</script>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height: 100%;">
<style type="text/css">
.botao-lupa{
	background-image:url(/_imagens/botoes/16x16/buscar.gif);
	width:16px;
	height:16px;
}
</style>
<form id="form_transportes" name="form_transportes" method="post" action="" onSubmit="return f_confirmar()">
    <input type="hidden" name="CONSULTA" id="CONSULTA" value="1" sempre_ativo="1" />
	<table width="100%" border="0" cellspacing="0" cellpadding="0">
		<tr>
			<td>
            <fieldset>
            	<legend>Dados</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                	<tr>
                    	<td width="1%" nowrap class="texto">C&oacute;d. Funcionario:</td>
                        <td><input type="text" name="COD_MOTORISTA" id="COD_MOTORISTA" style="width:85px" onChange="f_busca_motorista(3)" value="<cfif isDefined("vars.COD_MOTORISTA")><cfoutput>#vars.COD_MOTORISTA#</cfoutput></cfif>" />
                    </tr>
                    <tr>
                        <td width="1%" nowrap class="texto">Motorista:</td>
                        <td width="99%" class="texto">
                        	<!---<input type="hidden" name="COD_MOTORISTA" id="COD_MOTORISTA" value="<cfif isDefined("vars.COD_MOTORISTA")><cfoutput>#vars.COD_MOTORISTA#</cfoutput></cfif>" />--->
                            <input type="text" name="CNPJ_FUNCIONARIO" id="CNPJ_FUNCIONARIO" value="<cfif isDefined("vars.CNPJ_FUNCIONARIO")><cfoutput>#vars.CNPJ_FUNCIONARIO#</cfoutput></cfif>"  maxlength="10" display="CNPJ DO MOTORISTA" onChange="f_busca_motorista(1)" onKeyPress="return f_formata(this, '0000000000')" style="width: 85px;" />
                        	<input type="text" name="NOME_MOTORISTA" id="NOME_MOTORISTA" value="<cfif isDefined("vars.NOME_MOTORISTA")><cfoutput>#vars.NOME_MOTORISTA#</cfoutput></cfif>" readonly="true" display="MOTORISTA" style="width: 322px;" />&nbsp;
                            <button type="button" id="btn_busca_motorista" class="botao-16x16 botao-lupa" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?funcao=f_busca_motorista(1)&field=CNPJ_CPF&campo=CNPJ_FUNCIONARIO&num_modalidade=2,6,8&tipo=2', '_blank', 800, 600, 'yes')" />
                        </td>
                    </tr>
                    <tr>
                        <td width="1%" nowrap class="texto">Veculo:</td>
                        <td width="99%" class="texto">
                        	<input type="hidden" name="PLACA" id="PLACA" value="<cfif isDefined("vars.PLACA")><cfoutput>#vars.PLACA#</cfoutput></cfif>" />
                            <input type="text" name="COD_VEICULO" id="COD_VEICULO" value="<cfif isDefined("vars.COD_VEICULO")><cfoutput>#vars.COD_VEICULO#</cfoutput></cfif>" maxlength="12" display="CODIGO VECULO" onChange="f_busca_veiculo()" onKeyPress="return f_formata(this, 'AAAAAAAAAAAA')" style="width: 85px;" />
                        	<input type="text" name="MARCA_MODELO" id="MARCA_MODELO" value="<cfif isDefined("vars.MARCA_MODELO")><cfoutput>#vars.MARCA_MODELO#</cfoutput></cfif>" readonly="true" display="MARCA_MODELO" style="width: 322px;" />&nbsp;
                        	<button type="button" id="btn_busca_tracao" class="botao-16x16 botao-lupa" onClick="NewWindow('/_consultas/localizar_veiculo.cfm?funcao=f_busca_veiculo()&cod_veiculo=COD_VEICULO&placa=PLACA', '_blank', 640, 360, 'yes')" />
                        </td>
                    </tr>
                    <tr>
                        <td width="1%" nowrap class="texto">Orgo Autuador:</td>
                        <td width="99%" class="texto">
	                        <input type="text" name="ORGAO_AUTUADOR_ID" id="ORGAO_AUTUADOR_ID" value="<cfif isDefined("vars.ORGAO_AUTUADOR_ID")><cfoutput>#vars.ORGAO_AUTUADOR_ID#</cfoutput></cfif>" maxlength="15" tipo="numerico" display="CDIGO DO ORGO AUTUADOR" onChange="f_busca_orgao_autuador()" onKeyPress="return f_formata(this, '0000000000')" style="width: 85px;" />
                            <input type="text" name="DESCRICAO" id="DESCRICAO" value="<cfif isDefined("vars.DESCRICAO")><cfoutput>#vars.DESCRICAO#</cfoutput></cfif>" readonly="true" display="ORGO AUTUADOR" style="width: 322px;" />&nbsp;
                            <button type="button" class="botao-16x16 botao-lupa" onClick="NewWindow('/modulos/gerenciamento_multas/cadastros/orgao_autuador/localizar.cfm?funcao=f_busca_orgao_autuador()', '_blank', '640', '480', 'yes')">
                        </td>
                    </tr>
                    <tr>
                        <td width="1%" nowrap class="texto">Romaneio:</td>
                        <td width="99%" class="texto">
                        	<input type="text" name="NUM_ROMANEIO" id="NUM_ROMANEIO" value="<cfif isDefined("vars.NUM_ROMANEIO")><cfoutput>#vars.NUM_ROMANEIO#</cfoutput></cfif>" maxlength="15" tipo="numerico" display="CDIGO DO ROMANEIO" onKeyPress="return f_formata(this, '000000000000000')" style="width: 85px;" />
                        </td>
                    </tr>
                    <tr>
                        <td width="1%" nowrap class="texto">Infrao:</td>
                        <td width="99%" class="texto">
                        	<select name="INFRACAO" id="INFRACAO" style="width: 150px;">
                            <option value="">-- Selecione --</option>
							<cfoutput query="qrInfracao">
                                <option value="#qrInfracao.tipo_infracao_id#"
                                <cfif isDefined("vars.INFRACAO") and qrInfracao.tipo_infracao_id eq vars.INFRACAO>
                                	selected
                                </cfif>
                                >#qrInfracao.descricao#</option>
                            </cfoutput>
                            </select>
                        </td>
                    </tr>
                    <tr>	
                        <td width="1%" nowrap class="texto">Perodo:</td>
                        <td width="99%" class="texto">
							<input type="text" name="DATA_INICIAL" id="DATA_INICIAL" maxlength="16" value="<cfif isDefined("vars.DATA_INICIAL")><cfoutput>#vars.DATA_INICIAL#</cfoutput><cfelse><cfoutput>#LSDateFormat(Now()-30, 'dd/mm/yyyy')#</cfoutput></cfif>" tipo="data" secao="SECAO" display="DATA INICIAL" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 85px;" />
							<button type="button" id="BTN_DATA_I" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "DATA_INICIAL",   // ID of the input field
									ifFormat    : "%d/%m/%Y", 		// the date format
									button      : "BTN_DATA_I",		// ID of the button
									range       : [2001,2050],
									showsTime   : false
								} );
                            </script>
                            at
                            <input type="text" name="DATA_FINAL" id="DATA_FINAL" maxlength="16" value="<cfif isDefined("vars.DATA_FINAL")><cfoutput>#vars.DATA_FINAL#</cfoutput><cfelse><cfoutput>#LSDateFormat(Now(), 'dd/mm/yyyy')#</cfoutput></cfif>" tipo="data" secao="SECAO" display="DATA FINAL" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 85px;" />
							<button type="button" id="BTN_DATA_F" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle"></button>
							<script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "DATA_FINAL", // ID of the input field
									ifFormat    : "%d/%m/%Y",	// the date format
									button      : "BTN_DATA_F", // ID of the button
									range       : [2001, 2050],
									showsTime   : false
								} );
                            </script>
                        </td>
                    </tr>
                </table>
            </fieldset>
			</td>
        </tr>
	</table>
</form>
<cfif IsDefined("qrAcompanhamento")>
	<cfif qrAcompanhamento.RecordCount gt 0>
    <table width="100%" border="0" cellspacing="1" cellpadding="3">
        <thead>
            <tr class="titulo_1">
                <td nowrap align="center" width="1%"><input type="checkbox" title="Marcar/desmarcar todos" onClick="f_selecionarTodos(this)"></td>
                <td nowrap align="right" width="8%">C&oacute;digo</td>
                <td nowrap align="center" width="14%">Infra&ccedil;&atilde;o</td>
                <td nowrap align="center" width="25%">Munic&iacute;pio</td>
                <td nowrap align="center" width="12%">KM Infra&ccedil;&atilde;o</td>
                <td nowrap align="center" width="14%">Motorista</td>
                <td nowrap align="center" width="12%">Data Infra&ccedil;&atilde;o</td>
                <td nowrap align="center" width="10%">Local Infra&ccedil;&atilde;o</td>
                <td nowrap align="center" width="10%">Romaneio</td>
                <td nowrap align="center" width="10%">Origem / Destino</td>
                <td nowrap align="center" width="10%">Placa / Ve&iacute;culo</td>
                <td nowrap align="center" width="10%">Sentido Infra&ccedil;&atilde;o</td>
                <td nowrap align="center" width="10%">&Oacute;rg&atilde;o Autuador</td>
            </tr>
        </thead>
        <tbody>
        	<cfoutput query="qrAcompanhamento">
            	<tr class="linha_2">
                    <td><input type="checkbox" name="chk_auto_infracao[]" value="#qrAcompanhamento.auto_infracao_id#"></td>
                    <td>#qrAcompanhamento.auto_infracao_id#</td>
                    <td>#qrAcompanhamento.cod_auto_infracao#</td>
                    <td>#qrAcompanhamento.municipio#</td>
                    <td>#qrAcompanhamento.numero_km_infracao#</td>
                    <td>#qrAcompanhamento.motorista_nome#</td>
                    <td>#qrAcompanhamento.data_infracao#</td>
                    <td>#qrAcompanhamento.local_infracao#</td>
                    <td>#qrAcompanhamento.num_romaneio#</td>
                    <td>#qrAcompanhamento.viagem#</td>
                    <td>#qrAcompanhamento.veiculo_placa# - #qrAcompanhamento.veiculo_marca_modelo#</td>
                    <td>#qrAcompanhamento.sentido_infracao#</td>
                    <td>#qrAcompanhamento.orgao_autuador#</td>
                </tr>
            </cfoutput>
			
        </tbody>
    </table>
    <cfelse>
    <table width="100%" border="0" cellspacing="0" cellpadding="3">
        <tr>
            <td class="obrigatorio" align="center">N&atilde;o foram encontradas Autos de Infra&ccedil;&atilde;o.</td>
        </tr>
    </table>
    </cfif>
</cfif>
</body>
</html>
<cfset RequestEnd = 0>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style="display: none;"></iframe>