<cfif IsDefined("vars.cod_auto_infracao")>
	<cfscript>
		conn = CreateComponent("modulos.gerenciamento_multas._componentes.consulta.cfc_gerenciamento_multas");
		qrAutoInfracao = conn.get_acompanhamento_infracao(auto_infracao_id = vars.cod_auto_infracao);
	</cfscript>
<cfelse>
	<script type="text/javascript">
		alert('Dados no definidos!');
		window.close();
	</script>
</cfif>

<cfdocument name="auto_infracao" format="pdf" orientation="portrait">
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Relatrio de Auto Infrao</title>
<style type="text/css">
	body {
		margin: 0;
		padding: 0;
	}
	.fonte {
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-stretch: condensed;
		font-size: 10px;
	}
	table{
		font-family: Verdana, Arial, Helvetica, sans-serif;
		font-stretch: condensed;
		font-size: 10px;
	}
	table tr th{
		text-align:left;
		width:90px;
		font-weight:bold;
	}
	
	.tabela-pdf table{
		width:100%;
		border-bottom:1px solid #000000;
		border-top:1px solid #000000;
		border-left:1px solid #000000;
		border-right:1px solid #000000;
		margin-top:10px;
	}
	
	.tabela-titulo{
		color:#30C;
		font-weight:bold;
		margin-top:4px;
		padding:2px;
		margin-left:10px;
		position:absolute;
		background-color:#FFFFFF;
	}
	
	.celulas-padding th, .celulas-padding td{
		padding-top:5px;
	}
	.celulas-padding-tabela th{
		padding-bottom:6px;
	}
	
	.tabela-pdf table tr td{
		text-align:left;
	}
	
	.tabela-tipo-infracao thead tr{
		border-bottom:1px solid #000000;
	}
	
	.linha-bottom th{
		text-align:left;
		font-weight:bold;
		border-bottom:1px solid #000000;
	}
	
</style>
</head>
<body>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
	<tr>
    	<td>
        	<img style="float:left;" src="<cf_url>/_imagens/logos/logo_relatorio.jpg</cf_url>" alt="" title="" align="absmiddle" />
            <h1 style="float:right;">Relatrio de Auto de Infrao</h1>
        </td>
    </tr>
	<tr>
		<td class="tabela-pdf">
			<cfoutput query="qrAutoInfracao">
            	<div style="position:relative;">
                    <div class="tabela-titulo"> Identificao da Autuao </div>
                    <table>
                        <tr class="celulas-padding">
                            <th>Cdigo:</th>
                            <td colspan="3">#qrAutoInfracao.auto_infracao_id#</td>
                        </tr>
                        <tr>
                            <th>Orgo Autuador:</th>
                            <td colspan="3">#qrAutoInfracao.orgao_autuador#</td>
                        </tr>
                        <tr>
                            <th>Auto Infrao:</th>
                            <td style="width:560px !important;">#qrAutoInfracao.cod_auto_infracao#</td>
                            <th style="width:110px !important;">Data da Impresso:</th>
                            <td>#qrAutoInfracao.data_impressao#</td>
                        </tr>
                    </table>
                </div>
                
                <div style="position:relative;">
                    <div class="tabela-titulo"> Tipo de Infrao </div>
                    <table class="tabela-tipo-infracao" style="width:850px;border-collapse:collapse; border:1px solid black; cell-spacing:0; cell-padding:0;">
                        <thead>
                            <tr class="celulas-padding celulas-padding-tabela">
                                <th style="width:100px !important;">Cdigo Infrao</th>
                                <th style="width:564px !important;">Descrio</th>
                                <th style="width:186px !important;">Cdigo RENAINF</th>
                            </tr>
                        </thead>
                        <tbody>
                            <cfscript>
                            qrTipoInfracao = conn.get_auto_infracao_item(auto_infracao_id = qrAutoInfracao.auto_infracao_id);
                            </cfscript>
                            <cfloop query="qrTipoInfracao">
                                <tr>
                                    <td>#qrTipoInfracao.cod_infracao#</td>
                                    <td>#qrTipoInfracao.descricao#</td>
                                    <td>#qrTipoInfracao.cod_renainf#</td>
                                </tr>
                            </cfloop>
                        </tbody>
                    </table>
                </div>
                
                <div style="position:relative;">
                    <div class="tabela-titulo"> Identificao do Local </div>
                    <table>
                       <tr class="celulas-padding">
                            <th>Data/Hora:</th>
                            <td colspan="3">#qrAutoInfracao.data_infracao#</td>
                        </tr>
                        <tr>
                            <th>Rodovia:</th>
                            <td colspan="3">#qrAutoInfracao.local_infracao#</td>
                        </tr>
                        <tr>
                            <th>KM:</th>
                            <td style="width:560px !important;">#qrAutoInfracao.numero_km_infracao#</td>
                            <th style="width:40px !important;">Sentido:</th>
                            <td>#qrAutoInfracao.sentido_infracao#</td>
                        </tr>
                        <tr>
                            <th>Municpio:</th>
                            <td>#qrAutoInfracao.municipio#</td>
                            <th style="width:40px !important;">UF:</th>
                            <td>#qrAutoInfracao.uf_id#</td>
                        </tr>
                    </table>
                </div>
                <div style="position:relative;">
                    <div class="tabela-titulo"> Identificao do Veculo </div>
                    <table>
                        <tr class="celulas-padding">
                            <th>Placa/Frota:</th>
                            <td>#qrAutoInfracao.veiculo_placa#</td>
                        </tr>
                        <tr>
                            <th>Marca/Modelo:</th>
                            <td>#qrAutoInfracao.veiculo_marca_modelo#</td>
                        </tr>
                        <tr>
                            <th>Agrupamento:</th>
                            <td>#qrAutoInfracao.agrupamento#</td>
                        </tr>
                        <tr>
                            <th>Romaneio:</th>
                            <td>#qrAutoInfracao.viagem#</td>
                        </tr>
                    </table>
                </div>
                <div style="position:relative;">
                    <div class="tabela-titulo"> Identificao do Motorista </div>
                    <table>
                        <tr class="celulas-padding">
                            <th>Motorista:</th>
                            <td>#qrAutoInfracao.motorista_nome#</td>
                        </tr>
                        <tr>
                            <th>Endereo:</th>
                            <td>#qrAutoInfracao.motorista_endereco#</td>
                        </tr>
                        <tr>
                            <th>CPF:</th>
                            <td>#qrAutoInfracao.motorista_cpf#</td>
                        </tr>
                        <tr>
                            <th>RG:</th>
                            <td>#qrAutoInfracao.motorista_rg#</td>
                        </tr>
                        <tr>
                            <th>Habilitao:</th>
                            <td>#qrAutoInfracao.motorista_cnh#</td>
                        </tr>
                    </table>
                </div>
    			<div style="position:relative;">
                    <div class="tabela-titulo"> Acompanhamento </div>
                    <table class="tabela-acompanhamento" style="width:850px;border-collapse:collapse; border:1px solid black; cell-spacing:0px; cell-padding:0px;">
                        <thead>
                            <tr class="celulas-padding celulas-padding-tabela">
                                <th style="width:60px !important;">Data</th>
                                <th style="width:200px !important;">Situao</th>
                                <th style="width:150px !important;">Instncia</th>
                                <th style="width:300px !important;">Observaes</th>
                            </tr>
                        </thead>
                        <tbody>
                            <cfscript>
                            qrTipoInfracao = conn.get_auto_infracao_ocorrencia(auto_infracao_id = qrAutoInfracao.auto_infracao_id);
                            </cfscript>
                            <cfloop query="qrTipoInfracao">
                                <tr>
                                    <td>#qrTipoInfracao.data_ocorrencia#</td>
                                    <td>#qrTipoInfracao.situacao#</td>
                                    <td>#qrTipoInfracao.instancia#</td>
                                    <td>#qrTipoInfracao.observacoes#</td>
                                </tr>
                            </cfloop>
                        </tbody>
                    </table>
                </div>
                <cfif qrAutoInfracao.CurrentRow neq qrAutoInfracao.RecordCount>
	                <cfdocumentitem type="pagebreak" />
				</cfif>
                
            </cfoutput>
		</td>
	</tr>
</table>
</body>
</html>

<cfdocumentitem type="footer">
	<style type="text/css">
		body {
			margin: 0;
			padding: 0;
		}
		.fonte {
			font-family: Verdana, Arial, Helvetica, sans-serif;
			font-stretch: condensed;
			font-size: 10px;
		}
	</style>
<table width="100%" border="0" cellpadding="0" cellspacing="0" class="fonte">
		<tr>
			<td colspan="2">&nbsp;</td>
		</tr>
		<tr>
			<td nowrap align="left"><cfoutput>#ucase(session.usuario)# - #DateFormat(Now(), 'dd/mm/yyyy') & " " & TimeFormat(Now(), 'HH:mm:ss')#</cfoutput></td>
			<td nowrap align="right">P&aacute;ginas: <cfoutput>#cfdocument.CurrentPageNumber# de #cfdocument.TotalPageCount#</cfoutput></td>
		</tr>
	</table>
</cfdocumentitem>
</cfdocument>
<cfset path = ExpandPath("/temp")>
<cfset data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss')>

<cfpdf action="merge" destination="#path#/rel_auto_infracao_#data_hora#.pdf" overwrite="yes">
	<cfpdfparam source="auto_infracao" />
</cfpdf>
<script>
	window.location = '/temp/rel_auto_infracao_<cfoutput>#data_hora#</cfoutput>.pdf';
</script>
