<cfcomponent extends="_transportes.funcoes.cfc_init">

	<!--- 
    -- PROPSITO
    -- Inserir tipo de infrator.
    -- ERICG 18/06/2010 17:38:19 - CRIADO
    --->
    <cffunction name='ins_tipo_infrator' displayname='Inserir tipo de infrator.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_ins_tipo_infrator' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.TIPO_INFRATOR_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de infrator inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>	
    
	<!--- 
    -- PROPSITO
    -- Alterar tipo de infrator.
    -- ERICG 18/06/2010 17:43:33 - CRIADO
    --->
    <cffunction name='upd_tipo_infrator' displayname='Alterar tipo de infrator.' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_INFRATOR_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_alt_tipo_infrator' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRATOR_ID#'  null='#iif(len(trim(arguments.TIPO_INFRATOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de infrator alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Excluir tipo de infrator.
    -- ERICG 18/06/2010 17:44:56 - CRIADO
    --->
    <cffunction name='del_tipo_infrator' displayname='Excluir tipo de infrator.' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_INFRATOR_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_del_tipo_infrator' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRATOR_ID#'  null='#iif(len(trim(arguments.TIPO_INFRATOR_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de infrator excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>  
    
	<!--- 
    -- PROPSITO
    -- Inserir Gravidade de infrao.
    -- ERICG 21/06/2010 09:40:26 - CRIADO
    --->
    <cffunction name='ins_gravidade_infr' displayname='Inserir Gravidade de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='PONTUACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_ins_gravidade_infr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.GRAVIDADE_INFRACAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PONTUACAO#'  null='#iif(len(trim(arguments.PONTUACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Gravidade de infrao inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>      
    
	<!--- 
    -- PROPSITO
    -- Alterar Gravidade de infrao.
    -- ERICG 21/06/2010 09:42:51 - CRIADO
    --->
    <cffunction name='upd_gravidade_infr' displayname='Alterar Gravidade de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='GRAVIDADE_INFRACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='PONTUACAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_alt_gravidade_infr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRAVIDADE_INFRACAO_ID#'  null='#iif(len(trim(arguments.GRAVIDADE_INFRACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PONTUACAO#'  null='#iif(len(trim(arguments.PONTUACAO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Gravidade de infrao alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 
    
	<!--- 
    -- PROPSITO
    -- Excluir Gravidade de infrao.
    -- ERICG 21/06/2010 09:44:38 - CRIADO
    --->
    <cffunction name='del_gravidade_infr' displayname='Excluir Gravidade de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='GRAVIDADE_INFRACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_del_gravidade_infr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRAVIDADE_INFRACAO_ID#'  null='#iif(len(trim(arguments.GRAVIDADE_INFRACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Gravidade de infrao excluda com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Inserir rgo autuador.
    -- ERICG 22/06/2010 09:05:23 - CRIADO
    --->
    <cffunction name='ins_orgao_autuador' displayname='Inserir rgo autuador.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_ins_orgao_autuador' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.ORGAO_AUTUADOR_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_PESSOA#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('rgo autuador inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Alterar rgo autuador.
    -- ERICG 22/06/2010 09:15:59 - CRIADO
    --->
    <cffunction name='upd_orgao_autuador' displayname='Alterar rgo autuador.' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORGAO_AUTUADOR_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='COD_PESSOA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_alt_orgao_autuador' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGAO_AUTUADOR_ID#'  null='#iif(len(trim(arguments.ORGAO_AUTUADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_PESSOA#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('rgo autuador alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 
    
	<!--- 
    -- PROPSITO
    -- Excluir rgo autuador.
    -- ERICG 22/06/2010 09:17:12 - CRIADO
    --->
    <cffunction name='del_orgao_autuador' displayname='Excluir rgo autuador.' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORGAO_AUTUADOR_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_del_orgao_autuador' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGAO_AUTUADOR_ID#'  null='#iif(len(trim(arguments.ORGAO_AUTUADOR_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('rgo autuador excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 
    
	<!--- 
    -- PROPSITO
    -- Inserir instncia.
    -- publico 22/06/2010 09:58:01 - CRIADO
    --->
    <cffunction name='ins_instancia' displayname='Inserir instncia.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_ins_instancia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.INSTANCIA_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Instncia inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Alterar instncia.
    -- publico 22/06/2010 10:08:34 - CRIADO
    --->
    <cffunction name='upd_instancia' displayname='Alterar instncia.' access='remote' returntype='Struct' output='true'>
        <cfargument name='INSTANCIA_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_alt_instancia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INSTANCIA_ID#'  null='#iif(len(trim(arguments.INSTANCIA_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Instncia alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Excluir instncia.
    -- publico 22/06/2010 10:09:27 - CRIADO
    --->
    <cffunction name='del_instancia' displayname='Excluir instncia.' access='remote' returntype='Struct' output='true'>
        <cfargument name='INSTANCIA_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_del_instancia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INSTANCIA_ID#'  null='#iif(len(trim(arguments.INSTANCIA_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Instncia excluda com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Inserir situao.
    -- publico 22/06/2010 10:12:12 - CRIADO
    --->
    <cffunction name='ins_situacao' displayname='Inserir situao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_ins_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.SITUACAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Situao inserida com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Alterar situao.
    -- publico 22/06/2010 10:13:00 - CRIADO
    --->
    <cffunction name='upd_situacao' displayname='Alterar situao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_alt_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Situao alterada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Excluir situao.
    -- publico 22/06/2010 10:11:04 - CRIADO
    --->
    <cffunction name='del_situacao' displayname='Excluir situao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_del_situacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Situao excluda com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>   
    
	<!--- 
    -- PROPSITO
    -- Inserir motivo de no apresentao de condutor.
    -- ERICG 22/06/2010 11:50:37 - CRIADO
    --->
    <cffunction name='ins_motivo_nao_apr' displayname='Inserir motivo de no apresentao de condutor.' access='remote' returntype='Struct' output='true'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_ins_motivo_nao_apr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.MOTIVO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Motivo de no apresentao de condutor inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Alterar motivo de no apresentao de condutor.
    -- ERICG 22/06/2010 11:51:37 - CRIADO
    --->
    <cffunction name='upd_motivo_nao_apr' displayname='Alterar motivo de no apresentao de condutor.' access='remote' returntype='Struct' output='true'>
        <cfargument name='MOTIVO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_alt_motivo_nao_apr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOTIVO_ID#'  null='#iif(len(trim(arguments.MOTIVO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Motivo de no apresentao de condutor alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Excluir motivo de no apresentao de condutor.
    -- ERICG 22/06/2010 11:52:29 - CRIADO
    --->
    <cffunction name='del_motivo_nao_apr' displayname='Excluir motivo de no apresentao de condutor.' access='remote' returntype='Struct' output='true'>
        <cfargument name='MOTIVO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_del_motivo_nao_apr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOTIVO_ID#'  null='#iif(len(trim(arguments.MOTIVO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Motivo de no apresentao de condutor excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Inserir tipo de infrao.
    -- ERICG 22/06/2010 09:32:40 - CRIADO
    --->
    <cffunction name='ins_tipo_infracao' displayname='Inserir tipo de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_INFRACAO' required='yes'>
        <cfargument name='INCISO' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='TIPO_INFRATOR_ID' required='yes'>
        <cfargument name='GRAVIDADE_INFRACAO_ID' required='yes'>
        <cfargument name='PONTUACAO' required='yes'>
        <cfargument name='PENALIDADE' required='yes'>
        <cfargument name='MEDIDA_ADM' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_ins_tipo_infracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.TIPO_INFRACAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.INCISO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRATOR_ID#'  null='#iif(len(trim(arguments.TIPO_INFRATOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRAVIDADE_INFRACAO_ID#'  null='#iif(len(trim(arguments.GRAVIDADE_INFRACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PONTUACAO#'  null='#iif(len(trim(arguments.PONTUACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PENALIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MEDIDA_ADM#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>

				<!---Insere as vigncias--->
				<cfscript>
					v_tipo_infracao_vig_id = this.ListaToArray (lista = arguments, variavel = "TIPO_INFRACAO_VIG_ID_TIPO_INFRACAO_VIGENCIA");
					v_data_inicio  		   = this.ListaToArray (lista = arguments, variavel = "DATA_INICIO_TIPO_INFRACAO_VIGENCIA");
					v_data_termino		   = this.ListaToArray (lista = arguments, variavel = "DATA_TERMINO_TIPO_INFRACAO_VIGENCIA");
					v_valor_ufir		   = this.ListaToArray (lista = arguments, variavel = "VALOR_UFIR_TIPO_INFRACAO_VIGENCIA");
					v_valor_reais		   = this.ListaToArray (lista = arguments, variavel = "VALOR_REAIS_TIPO_INFRACAO_VIGENCIA");
					v_valor_reais_desconto = this.ListaToArray (lista = arguments, variavel = "VALOR_REAIS_DESCONTO_TIPO_INFRACAO_VIGENCIA");
	            </cfscript>
                <cfloop from="1" to="#ArrayLen(v_tipo_infracao_vig_id)#" index="count">
					<cfscript>
                    	ret_vigencia = this.ins_tipo_infracao_vigencia(tipo_infracao_vig_id = v_tipo_infracao_vig_id[count]
                                                                      ,tipo_infracao_id     = retorno.tipo_infracao_id
                                                                      ,data_inicio          = v_data_inicio[count]
                                                                      ,data_termino         = v_data_termino[count]
                                                                      ,valor_ufir           = v_valor_ufir[count]
                                                                      ,valor_reais          = v_valor_reais[count]
                                                                      ,valor_reais_desconto = v_valor_reais_desconto[count]
                                                                      );
                    </cfscript>
					<cfif ret_vigencia.erro>
	                    <cfthrow object="#ret_vigencia.mensagem#">
                    </cfif>
                </cfloop>

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de infrao inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>   
    
	<!--- 
    -- PROPSITO
    -- Alterar tipo de infrao.
    -- ERICG 22/06/2010 09:33:42 - CRIADO
    --->
    <cffunction name='upd_tipo_infracao' displayname='Alterar tipo de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_INFRACAO_ID' required='yes'>
        <cfargument name='COD_INFRACAO' required='yes'>
        <cfargument name='INCISO' required='yes'>
        <cfargument name='DESCRICAO' required='yes'>
        <cfargument name='TIPO_INFRATOR_ID' required='yes'>
        <cfargument name='GRAVIDADE_INFRACAO_ID' required='yes'>
        <cfargument name='PONTUACAO' required='yes'>
        <cfargument name='PENALIDADE' required='yes'>
        <cfargument name='MEDIDA_ADM' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_alt_tipo_infracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRACAO_ID#'  null='#iif(len(trim(arguments.TIPO_INFRACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.INCISO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRATOR_ID#'  null='#iif(len(trim(arguments.TIPO_INFRATOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRAVIDADE_INFRACAO_ID#'  null='#iif(len(trim(arguments.GRAVIDADE_INFRACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PONTUACAO#'  null='#iif(len(trim(arguments.PONTUACAO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PENALIDADE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MEDIDA_ADM#' >
                </cfstoredproc>
                
				<cfscript>
					v_tipo_infracao_vig_id = this.ListaToArray (lista = arguments, variavel = "TIPO_INFRACAO_VIG_ID_TIPO_INFRACAO_VIGENCIA");
					v_data_inicio  		   = this.ListaToArray (lista = arguments, variavel = "DATA_INICIO_TIPO_INFRACAO_VIGENCIA");
					v_data_termino		   = this.ListaToArray (lista = arguments, variavel = "DATA_TERMINO_TIPO_INFRACAO_VIGENCIA");
					v_valor_ufir		   = this.ListaToArray (lista = arguments, variavel = "VALOR_UFIR_TIPO_INFRACAO_VIGENCIA");
					v_valor_reais		   = this.ListaToArray (lista = arguments, variavel = "VALOR_REAIS_TIPO_INFRACAO_VIGENCIA");
					v_valor_reais_desconto = this.ListaToArray (lista = arguments, variavel = "VALOR_REAIS_DESCONTO_TIPO_INFRACAO_VIGENCIA");
                    v_excluir              = this.ListDiff(lista1 = arguments.lista_deleted_TIPO_INFRACAO_VIGENCIA, lista2 = ArrayToList(v_tipo_infracao_vig_id));		
				</cfscript>
 				
				<!---Exclui as vigncias--->
                <cfloop list="#v_excluir#" delimiters="," index="i">
					<cfscript>
						ret_vigencia = this.del_tipo_infracao_vigencia(tipo_infracao_vig_id = i);
					</cfscript>
					<cfif ret_vigencia.erro>
					<cfthrow object="#ret_vigencia.mensagem#">
					</cfif>
				</cfloop>
            
				<!---Insere ou altera as vigncias--->
				<cfloop from="1" to="#ArrayLen(v_tipo_infracao_vig_id)#" index="count">
					<cfscript>
						if(not len(trim(v_tipo_infracao_vig_id[count]))) {
							ret_vigencia = this.ins_tipo_infracao_vigencia(tipo_infracao_vig_id = v_tipo_infracao_vig_id[count]
						  	 	                                   		  ,tipo_infracao_id     = arguments.tipo_infracao_id
        					                                              ,data_inicio          = v_data_inicio[count]
						  	 	                                   		  ,data_termino         = v_data_termino[count]
						  	 	                                   		  ,valor_ufir           = v_valor_ufir[count]
						  	 	                                   		  ,valor_reais          = v_valor_reais[count]
						  	 	                                   		  ,valor_reais_desconto = v_valor_reais_desconto[count]
								                                   		  );
						} else {
							ret_vigencia = this.upd_tipo_infracao_vigencia(tipo_infracao_vig_id = v_tipo_infracao_vig_id[count]
						  	 	                                   		  ,tipo_infracao_id     = arguments.tipo_infracao_id
        					                                              ,data_inicio          = v_data_inicio[count]
						  	 	                                   		  ,data_termino         = v_data_termino[count]
						  	 	                                   		  ,valor_ufir           = v_valor_ufir[count]
						  	 	                                   		  ,valor_reais          = v_valor_reais[count]
						  	 	                                   		  ,valor_reais_desconto = v_valor_reais_desconto[count]
								                                   		  );
						}
					</cfscript>
					<cfif isdefined('ret_vigencia.erro') and ret_vigencia.erro>
						<cfthrow object="#ret_vigencia.mensagem#">
					</cfif>
				</cfloop>                

                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de infrao alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Excluir tipo de infrao.
    -- ERICG 22/06/2010 09:34:27 - CRIADO
    --->
    <cffunction name='del_tipo_infracao' displayname='Excluir tipo de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_INFRACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_del_tipo_infracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRACAO_ID#'  null='#iif(len(trim(arguments.TIPO_INFRACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de infrao excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Inserir tipo de infrao (vigncia).
    -- ERICG 22/06/2010 09:32:40 - CRIADO
    --->
    <cffunction name='ins_tipo_infracao_vigencia' displayname='Inserir tipo de infrao (vigncia).' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_INFRACAO_ID' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_TERMINO' required='yes'>
        <cfargument name='VALOR_UFIR' required='yes'>
        <cfargument name='VALOR_REAIS' required='yes'>
        <cfargument name='VALOR_REAIS_DESCONTO' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_multa.prc_ins_tipo_infracao_vigencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.TIPO_INFRACAO_VIG_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.TIPO_INFRACAO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UFIR#'  null='#iif(len(trim(arguments.VALOR_UFIR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_REAIS#'  null='#iif(len(trim(arguments.VALOR_REAIS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_REAIS_DESCONTO#'  null='#iif(len(trim(arguments.VALOR_REAIS_DESCONTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de infrao (vigncia) inserido com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>   
    
	<!--- 
    -- PROPSITO
    -- Alterar tipo de infrao (vigncia).
    -- ERICG 22/06/2010 09:33:42 - CRIADO
    --->
    <cffunction name='upd_tipo_infracao_vigencia' displayname='Alterar tipo de infrao (vigncia).' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_INFRACAO_VIG_ID' required='yes'>
        <cfargument name='TIPO_INFRACAO_ID' required='yes'>
        <cfargument name='DATA_INICIO' required='yes'>
        <cfargument name='DATA_TERMINO' required='yes'>
        <cfargument name='VALOR_UFIR' required='yes'>
        <cfargument name='VALOR_REAIS' required='yes'>
        <cfargument name='VALOR_REAIS_DESCONTO' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_multa.prc_alt_tipo_infracao_vigencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRACAO_VIG_ID#'  null='#iif(len(trim(arguments.TIPO_INFRACAO_VIG_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.TIPO_INFRACAO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_TERMINO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UFIR#'  null='#iif(len(trim(arguments.VALOR_UFIR)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_REAIS#'  null='#iif(len(trim(arguments.VALOR_REAIS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_REAIS_DESCONTO#'  null='#iif(len(trim(arguments.VALOR_REAIS_DESCONTO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de infrao (vigncia) alterado com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Excluir tipo de infrao (vigncia).
    -- ERICG 22/06/2010 09:34:27 - CRIADO
    --->
    <cffunction name='del_tipo_infracao_vigencia' displayname='Excluir tipo de infrao (vigncia).' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_INFRACAO_VIG_ID' required='yes'>
        <cftry>
                <cfstoredproc procedure='oper.pkg_multa.prc_del_tipo_infracao_vigencia' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRACAO_VIG_ID#'  null='#iif(len(trim(arguments.TIPO_INFRACAO_VIG_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de infrao (vigncia) excludo com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

	<!--- 
    -- PROPSITO
    -- Inserir auto de infrao.
    -- ERICG 28/06/2010 10:18:53 - CRIADO
    --->
    <cffunction name='ins_auto_infracao' displayname='Inserir auto de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='ORGAO_AUTUADOR_ID' required='yes'>
        <cfargument name='COD_AUTO_INFRACAO' required='yes'>
        <cfargument name='DATA_IMPRESSAO' required='yes'>
        <cfargument name='DATA_INFRACAO' required='yes'>
        <cfargument name='LOCAL_INFRACAO' required='yes'>
        <cfargument name='NUMERO_KM_INFRACAO' required='yes'>
        <cfargument name='SENTIDO_INFRACAO' required='yes'>
        <cfargument name='COD_MUNICIPIO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
        <cfargument name='CONDUTOR_APRESENTADO' required='yes'>
        <cfargument name='MOTIVO_APRESENTACAO_ID' required='yes'>
        <cfargument name='NUM_PROTOCOLO' required='no' default="">
        <cfargument name='COD_RESPONSAVEL' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='TIPO_INFRATOR_ID' required='no' default="">
        <cfargument name='LANCAMENTO_MANUAL' required='no' default="">
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_ins_auto_infracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.AUTO_INFRACAO_ID' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGAO_AUTUADOR_ID#'  null='#iif(len(trim(arguments.ORGAO_AUTUADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_AUTO_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_IMPRESSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LOCAL_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUMERO_KM_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SENTIDO_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MUNICIPIO#'  null='#iif(len(trim(arguments.COD_MUNICIPIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONDUTOR_APRESENTADO#'  null='#iif(len(trim(arguments.CONDUTOR_APRESENTADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOTIVO_APRESENTACAO_ID#'  null='#iif(len(trim(arguments.MOTIVO_APRESENTACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_PROTOCOLO#'  null='#iif(len(trim(arguments.NUM_PROTOCOLO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
                </cfstoredproc>

                <!--- Insero dos Itens de Infrao --->
				<cfscript>
				    v_tipo_infracao_id 	   = this.ListaToArray(lista = arguments, variavel = 'TIPO_INFRACAO_ID_ITEM');
					v_valor_ufir 		   = this.ListaToArray(lista = arguments, variavel = 'VALOR_UFIR_ITEM');
					v_valor_reais 	       = this.ListaToArray(lista = arguments, variavel = 'VALOR_REAIS_ITEM');
					v_valor_reais_desconto = this.ListaToArray(lista = arguments, variavel = 'VALOR_REAIS_DESCONTO_ITEM');
					v_cod_renainf      	   = this.ListaToArray(lista = arguments, variavel = 'COD_RENAINF_ITEM');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_tipo_infracao_id)#" index="count_item">
                    <cfscript>
						ret_item = this.ins_auto_infr_item(AUTO_INFRACAO_ID 	= retorno.AUTO_INFRACAO_ID,
													       TIPO_INFRACAO_ID 	= v_tipo_infracao_id[count_item],
														   VALOR_UFIR			= v_valor_ufir[count_item],
														   VALOR_REAIS			= v_valor_reais[count_item],
														   VALOR_REAIS_DESCONTO = v_valor_reais_desconto[count_item],
													       COD_RENAINF      	= v_cod_renainf[count_item]);
                    </cfscript>
                    <cfif ret_item.erro>
                        <cfthrow object="#ret_item.mensagem#">
                    </cfif>
                </cfloop>
                
                <!--- Insero das Ocorrncias --->
				<cfscript>
                    v_ocorrencia_id   = this.ListaToArray(lista = arguments, variavel = 'OCORRENCIA_ID_OCORRENCIA');
					v_data_ocorrencia = this.ListaToArray(lista = arguments, variavel = 'DATA_OCORRENCIA_OCORRENCIA');
					v_situacao_id     = this.ListaToArray(lista = arguments, variavel = 'SITUACAO_ID_OCORRENCIA');
					v_instancia_id    = this.ListaToArray(lista = arguments, variavel = 'INSTANCIA_ID_OCORRENCIA');
					v_observacoes  	  = this.ListaToArray(lista = arguments, variavel = 'OBSERVACOES_OCORRENCIA');
                </cfscript>
                <cfloop from="1" to="#ArrayLen(v_ocorrencia_id)#" index="count_ocorr">
                    <cfscript>
                        ret_ocorr = this.ins_auto_infr_ocorr(AUTO_INFRACAO_ID = retorno.AUTO_INFRACAO_ID,
														     DATA_OCORRENCIA  = v_data_ocorrencia[count_ocorr],
														     SITUACAO_ID      = v_situacao_id[count_ocorr],
														     INSTANCIA_ID     = v_instancia_id[count_ocorr],
														     OBSERVACOES      = v_observacoes[count_ocorr]);
                    </cfscript>
                    <cfif ret_ocorr.erro>
                        <cfthrow object="#ret_ocorr.mensagem#">
                    </cfif>
                </cfloop>    
                
                <!---Anexos---->
                 <cfscript>
					 v_anexo_descricao = this.ListaToArray(lista = arguments, variavel = 'ANEXO_DESCRICAO_ANEXOS');
					 v_nome_anexo	   = this.ListaToArray(lista = arguments, variavel = 'NOME_ARQUIVO_ANEXOS');
				</cfscript>	 
                
                 <cfloop from="1" to="#ArrayLen(v_anexo_descricao)#" index="count_an">
                 	<!--- Busca arquivo --->
					<cfif Len(Trim(v_nome_anexo[count_an]))>
                        <cffile action="readbinary" file="#expandPath("/")#temp/#v_nome_anexo[count_an]#" variable="VARQUIVO">
                    <cfelse>
                        <cfset VARQUIVO = ''>
                    </cfif>
					<cfscript>
						ret_ane = this.ins_auto_infracao_anexo(auto_infracao_id = retorno.AUTO_INFRACAO_ID
															  ,nome_arquivo 	= v_nome_anexo[count_an]
														      ,descricao	    = v_anexo_descricao[count_an]
															  ,arquivo			= VARQUIVO
															  );	
					</cfscript>
                    
					<cfif ret_ane.erro >
                       <cfthrow object="#ret_ane.mensagem#">
                    </cfif>   
                 </cfloop>            
                
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Auto de infrao inserido com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
	<!--- 
    -- PROPSITO
    -- Alterar auto de infrao.
    -- ERICG 28/06/2010 10:20:24 - CRIADO
    --->
    <cffunction name='upd_auto_infracao' displayname='Alterar auto de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='AUTO_INFRACAO_ID' required='yes'>
        <cfargument name='ORGAO_AUTUADOR_ID' required='yes'>
        <cfargument name='COD_AUTO_INFRACAO' required='yes'>
        <cfargument name='DATA_IMPRESSAO' required='yes'>
        <cfargument name='DATA_INFRACAO' required='yes'>
        <cfargument name='LOCAL_INFRACAO' required='yes'>
        <cfargument name='NUMERO_KM_INFRACAO' required='yes'>
        <cfargument name='SENTIDO_INFRACAO' required='yes'>
        <cfargument name='COD_MUNICIPIO' required='yes'>
        <cfargument name='PLACA' required='yes'>
        <cfargument name='NUM_ROMANEIO' required='yes'>
        <cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
        <cfargument name='CONDUTOR_APRESENTADO' required='yes'>
        <cfargument name='MOTIVO_APRESENTACAO_ID' required='yes'>
        <cfargument name='NUM_PROTOCOLO' required='no' default="">
        <cfargument name='COD_RESPONSAVEL' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='TIPO_INFRATOR_ID' required='no' default="">
        <cftry>	
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_alt_auto_infracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AUTO_INFRACAO_ID#'  null='#iif(len(trim(arguments.AUTO_INFRACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGAO_AUTUADOR_ID#'  null='#iif(len(trim(arguments.ORGAO_AUTUADOR_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_AUTO_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_IMPRESSAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.LOCAL_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUMERO_KM_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SENTIDO_INFRACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MUNICIPIO#'  null='#iif(len(trim(arguments.COD_MUNICIPIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONDUTOR_APRESENTADO#'  null='#iif(len(trim(arguments.CONDUTOR_APRESENTADO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.MOTIVO_APRESENTACAO_ID#'  null='#iif(len(trim(arguments.MOTIVO_APRESENTACAO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_PROTOCOLO#'  null='#iif(len(trim(arguments.NUM_PROTOCOLO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_RESPONSAVEL#'  null='#iif(len(trim(arguments.COD_RESPONSAVEL)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                
                <!--- Alterao dos Itens de Infrao --->
				<cfscript>
				    v_tipo_infracao_id 	   = this.ListaToArray(lista = arguments, variavel = 'TIPO_INFRACAO_ID_ITEM');
					v_valor_ufir 		   = this.ListaToArray(lista = arguments, variavel = 'VALOR_UFIR_ITEM');
					v_valor_reais 		   = this.ListaToArray(lista = arguments, variavel = 'VALOR_REAIS_ITEM');
					v_valor_reais_desconto = this.ListaToArray(lista = arguments, variavel = 'VALOR_REAIS_DESCONTO_ITEM');
					v_cod_renainf          = this.ListaToArray(lista = arguments, variavel = 'COD_RENAINF_ITEM');
  				    v_excluir	           = this.ListDiff(lista1 = arguments.lista_deleted_ITEM, lista2 = ArrayToList(v_tipo_infracao_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret_item = this.del_auto_infr_item(TIPO_INFRACAO_ID = c_id, auto_infracao_id = arguments.auto_infracao_id);
                    </cfscript>
                    <cfif ret_item.erro>
                        <cfthrow object="#ret_item.mensagem#">
                    </cfif>
                </cfloop>

                <cfloop from="1" to="#ArrayLen(v_tipo_infracao_id)#" index="count_item">
                	<cfif len(trim(v_tipo_infracao_id[count_item])) >                    
						<cfscript>
                            ret_item = this.upd_auto_infr_item(AUTO_INFRACAO_ID 	= arguments.AUTO_INFRACAO_ID,
                                                               TIPO_INFRACAO_ID 	= v_tipo_infracao_id[count_item],
															   VALOR_UFIR			= v_valor_ufir[count_item],
															   VALOR_REAIS			= v_valor_reais[count_item],
															   VALOR_REAIS_DESCONTO = v_valor_reais_desconto[count_item],
                                                               COD_RENAINF      	= v_cod_renainf[count_item]);
                        </cfscript>
					<cfelse>                    
						<cfscript>
                            conVeiculo = CreateComponent("modulos.gerenciamento_multas._componentes.consulta.cfc_veiculo");
                            qrVeiculo  = conVeiculo.get_veiculo_light(placa = arguments.placa_agregado);
                        </cfscript>
					</cfif>                    
                    
                    <cfif ret_item.erro>
                        <cfthrow object="#ret_item.mensagem#">
                    </cfif>
                </cfloop>

                <!--- Alterao das Ocorrncias --->
				<cfscript>
				    v_ocorrencia_id   = this.ListaToArray(lista = arguments, variavel = 'OCORRENCIA_ID_OCORRENCIA');
					v_data_ocorrencia = this.ListaToArray(lista = arguments, variavel = 'DATA_OCORRENCIA_OCORRENCIA');
					v_situacao_id     = this.ListaToArray(lista = arguments, variavel = 'SITUACAO_ID_OCORRENCIA');
					v_instancia_id    = this.ListaToArray(lista = arguments, variavel = 'INSTANCIA_ID_OCORRENCIA');
					v_observacoes  	  = this.ListaToArray(lista = arguments, variavel = 'OBSERVACOES_OCORRENCIA');
  				    v_excluir	      = this.ListDiff(lista1 = arguments.lista_deleted_OCORRENCIA, lista2 = ArrayToList(v_ocorrencia_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="c_id">
                    <cfscript>
                        ret_ocorr = this.del_auto_infr_ocorr(OCORRENCIA_ID = c_id);
                    </cfscript>
                    <cfif ret_ocorr.erro>
                        <cfthrow object="#ret_ocorr.mensagem#">
                    </cfif>
                </cfloop>
                <cfloop from="1" to="#ArrayLen(v_ocorrencia_id)#" index="count_ocorr">
                    <cfscript>
						if(Not Len(Trim(v_ocorrencia_id[count_ocorr]))) {
							ret_ocorr = this.ins_auto_infr_ocorr(AUTO_INFRACAO_ID = arguments.AUTO_INFRACAO_ID,
															     DATA_OCORRENCIA  = v_data_ocorrencia[count_ocorr],
															     SITUACAO_ID      = v_situacao_id[count_ocorr],
															     INSTANCIA_ID     = v_instancia_id[count_ocorr],
															     OBSERVACOES      = v_observacoes[count_ocorr]);
						}
						else{
							ret_ocorr = this.upd_auto_infr_ocorr(OCORRENCIA_ID    = v_ocorrencia_id[count_ocorr],
															     AUTO_INFRACAO_ID = arguments.AUTO_INFRACAO_ID,
															     DATA_OCORRENCIA  = v_data_ocorrencia[count_ocorr],
															     SITUACAO_ID      = v_situacao_id[count_ocorr],
															     INSTANCIA_ID     = v_instancia_id[count_ocorr],
															     OBSERVACOES      = v_observacoes[count_ocorr]);							
						}
                    </cfscript>
                    <cfif ret_ocorr.erro>
                        <cfthrow object="#ret_ocorr.mensagem#">
                    </cfif>
                </cfloop>
                			
                <!--- Anexos 1 exclui os anexos e depois insere os novos --->
                <cfscript>
				    v_auto_infracao_anexo_id = this.ListaToArray(lista = arguments, variavel = 'AUTO_INFRACAO_ANEXO_ID_ANEXOS');
                	v_excluir                = this.ListDiff(lista1 = arguments.lista_deleted_ANEXOS, lista2 = ArrayToList(v_auto_infracao_anexo_id));
                </cfscript>
                <cfloop list="#v_excluir#" delimiters="," index="aui_id">
                    <cfscript>
                        ret_ane_ex = this.del_auto_infracao_anexo(AUTO_INFRACAO_ANEXO_ID = aui_id);
                    </cfscript>
                    <cfif ret_ane_ex.erro>
                        <cfthrow object="#ret_ane_ex.mensagem#">
                    </cfif>
                </cfloop>
                
                
                 <!---Anexos inclui os novos se existirem---->
                <cfscript>
					 v_anexo_descricao = this.ListaToArray(lista = arguments, variavel = 'ANEXO_DESCRICAO_ANEXOS');
					 v_nome_anexo	   = this.ListaToArray(lista = arguments, variavel = 'NOME_ARQUIVO_ANEXOS');
				</cfscript>	 
                
                 <cfloop from="1" to="#ArrayLen(v_anexo_descricao)#" index="count_an">
                 	<!--- Busca arquivo --->
					<cfif Len(Trim(v_nome_anexo[count_an]))>
                        <cffile action="readbinary" file="#expandPath("/")#temp/#v_nome_anexo[count_an]#" variable="VARQUIVO">
                    <cfelse>
                        <cfset VARQUIVO = ''>
                    </cfif>
					<cfscript>
						ret_ane_ins = this.ins_auto_infracao_anexo(auto_infracao_id = arguments.AUTO_INFRACAO_ID
															      ,nome_arquivo 	= v_nome_anexo[count_an]
														      	  ,descricao	    = v_anexo_descricao[count_an]
															  	  ,arquivo			= VARQUIVO
															  	  );	
					</cfscript>
                    
					 <cfif ret_ane_ins.erro >
                        <cfthrow object="#ret_ane_ins.mensagem#">
                     </cfif>   
                 </cfloop>
                <cfset retorno = structnew() >
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Auto de infrao alterado com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Excluir auto de infrao.
    -- ERICG 28/06/2010 10:21:34 - CRIADO
    --->
    <cffunction name='del_auto_infracao' displayname='Excluir auto de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='AUTO_INFRACAO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_multa.prc_del_auto_infracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AUTO_INFRACAO_ID#'  null='#iif(len(trim(arguments.AUTO_INFRACAO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Auto de infrao excludo com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    
    
    <!--- 
    -- PROPSITO
    -- Inserir item de auto de infrao.
    -- ERICG 28/06/2010 09:48:00 - CRIADO
    --->
    <cffunction name='ins_auto_infr_item' displayname='Inserir item de auto de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='AUTO_INFRACAO_ID' required='yes'>
        <cfargument name='TIPO_INFRACAO_ID' required='yes'>
		<cfargument name='VALOR_UFIR' required='yes'>
        <cfargument name='VALOR_REAIS' required='yes'>
        <cfargument name='VALOR_REAIS_DESCONTO' required='yes'>
        <cfargument name='COD_RENAINF' required='yes'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_multa.prc_ins_auto_infr_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AUTO_INFRACAO_ID#'  null='#iif(len(trim(arguments.AUTO_INFRACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRACAO_ID#'  null='#iif(len(trim(arguments.TIPO_INFRACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UFIR#'  null='#iif(len(trim(arguments.VALOR_UFIR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_REAIS#'  null='#iif(len(trim(arguments.VALOR_REAIS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_REAIS_DESCONTO#'  null='#iif(len(trim(arguments.VALOR_REAIS_DESCONTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_RENAINF#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>    

	<!--- 
    -- PROPSITO
    -- Alterar item de auto de infrao.
    -- ERICG 28/06/2010 10:12:48 - CRIADO
    --->
    <cffunction name='upd_auto_infr_item' displayname='Alterar item de auto de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='AUTO_INFRACAO_ID' required='yes'>
        <cfargument name='TIPO_INFRACAO_ID' required='yes'>
		<cfargument name='VALOR_UFIR' required='yes'>
        <cfargument name='VALOR_REAIS' required='yes'>
        <cfargument name='VALOR_REAIS_DESCONTO' required='yes'>
        <cfargument name='COD_RENAINF' required='yes'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_multa.prc_alt_auto_infr_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AUTO_INFRACAO_ID#'  null='#iif(len(trim(arguments.AUTO_INFRACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRACAO_ID#'  null='#iif(len(trim(arguments.TIPO_INFRACAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_UFIR#'  null='#iif(len(trim(arguments.VALOR_UFIR)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_REAIS#'  null='#iif(len(trim(arguments.VALOR_REAIS)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_REAIS_DESCONTO#'  null='#iif(len(trim(arguments.VALOR_REAIS_DESCONTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_RENAINF#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Excluir item de auto de infrao.
    -- ERICG 28/06/2010 10:14:43 - CRIADO
    --->
    <cffunction name='del_auto_infr_item' displayname='Excluir item de auto de infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='AUTO_INFRACAO_ID' required='yes'>
        <cfargument name='TIPO_INFRACAO_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_multa.prc_del_auto_infr_item' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AUTO_INFRACAO_ID#'  null='#iif(len(trim(arguments.AUTO_INFRACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_INFRACAO_ID#'  null='#iif(len(trim(arguments.TIPO_INFRACAO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Inserir ocorrncia de auto infrao.
    -- ERICG 23/06/2010 09:27:46 - CRIADO
    --->
    <cffunction name='ins_auto_infr_ocorr' displayname='Inserir ocorrncia de auto infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='AUTO_INFRACAO_ID' required='yes'>
        <cfargument name='DATA_OCORRENCIA' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='INSTANCIA_ID' required='yes'>
        <cfargument name='OBSERVACOES' required='yes'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_multa.prc_ins_auto_infr_ocorr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.OCORRENCIA_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AUTO_INFRACAO_ID#'  null='#iif(len(trim(arguments.AUTO_INFRACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_OCORRENCIA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INSTANCIA_ID#'  null='#iif(len(trim(arguments.INSTANCIA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACOES#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction> 
    
	<!--- 
    -- PROPSITO
    -- Alterar ocorrncia de auto infrao.
    -- ERICG 23/06/2010 09:28:46 - CRIADO
    --->
    <cffunction name='upd_auto_infr_ocorr' displayname='Alterar ocorrncia de auto infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='OCORRENCIA_ID' required='yes'>
        <cfargument name='AUTO_INFRACAO_ID' required='yes'>
        <cfargument name='DATA_OCORRENCIA' required='yes'>
        <cfargument name='SITUACAO_ID' required='yes'>
        <cfargument name='INSTANCIA_ID' required='yes'>
        <cfargument name='OBSERVACOES' required='yes'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_multa.prc_alt_auto_infr_ocorr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AUTO_INFRACAO_ID#'  null='#iif(len(trim(arguments.AUTO_INFRACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_OCORRENCIA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SITUACAO_ID#'  null='#iif(len(trim(arguments.SITUACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INSTANCIA_ID#'  null='#iif(len(trim(arguments.INSTANCIA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACOES#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Excluir ocorrncia de auto infrao.
    -- ERICG 23/06/2010 09:30:04 - CRIADO
    --->
    <cffunction name='del_auto_infr_ocorr' displayname='Excluir ocorrncia de auto infrao.' access='remote' returntype='Struct' output='true'>
        <cfargument name='OCORRENCIA_ID' required='yes'>
        <cftry>
            <cfstoredproc procedure='oper.pkg_multa.prc_del_auto_infr_ocorr' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OCORRENCIA_ID#'  null='#iif(len(trim(arguments.OCORRENCIA_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Gera protocolo de acompanhamento
	-- WAGNERS 16/02/2011 09:30:02 - CRIADO
	--->
	<cffunction name='gera_protocolo_acomp' displayname='Gera protocolo de acompanhamento' access='remote' returntype='Struct' output='true'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='DATA_FIM' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_multa.prc_gera_protocolo_acomp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.NUM_PROTOCOLO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_FIM#' >
				</cfstoredproc>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Protocolo gerado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Estornar protocolo de acompanhamento de multas
	-- WAGNERS 16/02/2011 16:20:52 - CRIADO
	--->
	<cffunction name='estorna_protocolo_acomp' displayname='Estornar protocolo de acompanhamento de multas' access='remote' returntype='Struct' output='true'>
		<cfargument name='PROTOCOLO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_multa.prc_estorna_protocolo_acomp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PROTOCOLO#'  null='#iif(len(trim(arguments.PROTOCOLO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Protocolo estornado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Inserir um anexo ao auto de infrao
	-- FABIOG 20/07/2011 15:35:38 - CRIADO
	--->
	<cffunction name='ins_auto_infracao_anexo' displayname='Inserir um anexo ao auto de infrao' access='remote' returntype='Struct' output='true'>
		<cfargument name='AUTO_INFRACAO_ID' required='yes'>
		<cfargument name='NOME_ARQUIVO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ARQUIVO' required='yes'>
		<cftry>
            <cfstoredproc procedure='oper.pkg_multa.prc_ins_auto_infracao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.AUTO_INFRACAO_ANEXO_ID' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AUTO_INFRACAO_ID#'  null='#iif(len(trim(arguments.AUTO_INFRACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME_ARQUIVO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_BLOB'   value='#arguments.ARQUIVO#' >
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  variable='retorno.ROWID' >
            </cfstoredproc>
			<cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Alterar um anexo de auto de infrao
	-- FABIOG 20/07/2011 15:37:01 - CRIADO
	--->
	<cffunction name='alt_auto_infracao_anexo' displayname='Alterar um anexo de auto de infrao' access='remote' returntype='Struct' output='true'>
		<cfargument name='AUTO_INFRACAO_ANEXO_ID' required='yes'>
		<cfargument name='NOME_ARQUIVO' required='yes'>
		<cfargument name='DESCRICAO' required='yes'>
		<cfargument name='ARQUIVO' required='yes'>
		<cftry>
				<cfstoredproc procedure='oper.pkg_multa.prc_alt_auto_infracao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AUTO_INFRACAO_ANEXO_ID#'  null='#iif(len(trim(arguments.AUTO_INFRACAO_ANEXO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME_ARQUIVO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_BLOB'   value='#arguments.ARQUIVO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Deletar um anexo de auto de infrao
	-- FABIOG 20/07/2011 15:37:47 - CRIADO
	--->
	<cffunction name='del_auto_infracao_anexo' displayname='a' access='remote' returntype='Struct' output='true'>
	<cfargument name='AUTO_INFRACAO_ANEXO_ID' required='yes'>
	<cftry>
        <cfstoredproc procedure='oper.pkg_multa.prc_del_auto_infracao_anexo' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.AUTO_INFRACAO_ANEXO_ID#'  null='#iif(len(trim(arguments.AUTO_INFRACAO_ANEXO_ID)), de('no'), de('yes'))#'>
        </cfstoredproc>
        <cfset retorno.erro = false>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Insere o arquivo temporariamento no servidor
	-- FABIOG 20/07/2011 15:47:40 - CRIADO
	--->
	<cffunction name='ins_anexo_temp' displayname='Insere o arquivo temporariamento no servidor' access='remote' returntype='Struct' output='true'>
		<cfargument name='ANEXO' required='yes'>
        <cftry>
            <!---Envia o Arquivo para o Servidor--->
            <cffile action="upload" destination="#expandPath("/")#temp" file="#arguments.ANEXO#" nameconflict="makeunique" result="VANEXO" filefield="ANEXO">
            
            <cfset retorno.nome_arquivo = VANEXO.serverfile>
            <cfset retorno.erro = false>
        <cfcatch>
        	<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>
