<cfcomponent displayname="Componentes de Veculos"
		     hint="<b>KM&M  de Engenharia de Sistemas</b><br>
				   <b>Autor					: Guto ( guto@kmm.com.br )</b><br>
				   <b>Data Criao</b> 		: 07/12/2004<br> 
				   <b>Atualizador			: </b><br>
				   <b>Data Atualizao</b> 	: <br> 
				   <b>Descrio				: </b><br> <div align='justify'>Componente de consultas sobre veculos.</div>"
		     extends="_transportes.funcoes.cfc_init">
             	   	
	<!--- 
	-- PROPSITO
	-- Retorna dados do veculo
	-- NOTAS EXPLICATIVAS
	--  
	-- 07/12/2005 - criado
	--->	
	<cffunction name="get_veiculo" displayname="Retorna dados do veculo" output="false" returntype="query" access="remote">
		<cfargument name="placa" required="no" default="">
		<cfargument name="placa_exa" required="no" default="">
		<cfargument name="cod_veiculo" required="no" default="">
		<cfargument name="frota" required="no" default="">
		<cfargument name="frota_exa" required="no" default="">
		<cfargument name="proprietario" required="no" default="">
		<cfargument name="num_modalidade" required="no" default="7"> 
		<!---Terceiros--->	
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select distinct vd.veiculo_id, vd.placa,
                    vd.cod_veiculo,
                    vd.num_rastreador,
                    vd.rastreador_id,
                    vd.rastreador_com_problemas,
                    vd.marca_id,
                    vd.marca,
                    vd.modelo_id,
                    vd.situacao_id,
                    vd.uf,
                    vd.capacidade_tanque,
                    oper.pkg_veiculo.FNC_CAPACIDADE_CARGA_COMPO(vd.placa,sysdate) capacidade,
                    vd.km_revisao,
                    vd.modelo,
                    vd.proprietario,
                    vd.observacao,
                    vd.cor_predominante,
                    vd.ano,
                    vd.chassis,
                    vd.renavan,
                    va.agrupamento_id,
                    va.descricao as agrupamento,
                    vtc.tipo_carroceria_id,
               		vtc.descricao as tipo_carroceria,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TAG_CTF') as tag_ctf,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'TARA') as tara,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'CAPACIDADE_TRACAO') as capacidade_tracao,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'COMBUSTIVEL') as combustivel,
                    oper.pkg_frota_dml.fnc_veiculo_get_atributo(vd.placa,'NUMERO_EIXOS') as numero_eixos,
                    va.tracao,
                    vd.municipio_id,
                    (select municipio
                       from cep.municipio m
                      where m.municipio_id = vd.municipio_id) as municipio,
                    vd.tipo_carroceria_id,
                    vtc.descricao as tipo
              from oper.v$veiculo_dados vd
              left join oper.v$veiculo_tipo_carroceria vtc
                     on vd.tipo_carroceria_id = vtc.tipo_carroceria_id
              left join oper.v$veiculo_agrupamento va
                     on va.agrupamento_id = vtc.agrupamento_id
              left join oper.v$veiculo_proprietario vp on vp.placa = vd.placa
                                                      and vp.data_fim is null
             where 1 = 1			  
			<cfif Len(Trim(arguments.placa))>
			   and vd.placa like upper('%#arguments.placa#%')
			</cfif>		
			<cfif Len(Trim(arguments.placa_exa))>
			   and upper(vd.placa) = '#arguments.placa_exa#'
			</cfif>	
			<cfif Len(Trim(arguments.cod_veiculo))>
			   and upper(vd.cod_veiculo) like upper('#arguments.cod_veiculo#%')
			</cfif>		
			<cfif Len(Trim(arguments.proprietario))>
			   and vd.proprietario in (#arguments.proprietario#)
			</cfif>		
			<cfif Len(Trim(arguments.frota))>
			   and (vd.placa like upper('#arguments.frota#%')
			       or vd.cod_veiculo like upper('#arguments.frota#%'))
			</cfif>	
			<cfif Len(Trim(arguments.frota_exa))>
			   and (upper(vd.placa) = '#arguments.frota_exa#'
			       or upper(vd.cod_veiculo) = '#arguments.frota_exa#')
			</cfif>		
			order by vd.cod_veiculo
  		</cfquery>
		<cfreturn qr_result>
	</cffunction>	   
      
  	<!--- 
	-- PROPSITO
	-- Retorna as informaes bsicas do veculo
	-- NOTAS EXPLICATIVAS
	-- 16/09/2011 - criado
	--->	
    <cffunction name="get_veiculo_light" displayname="Retorna dados do veculo" returntype="query" access="remote" output="true">
         <cfargument name="placa" required="yes"> 
         <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
                    select v.veiculo_id
                      from oper.v$veiculo v
                     where v.placa = '#arguments.PLACA#'
           </cfquery>
       <cfreturn qr_result>
     </cffunction>    
</cfcomponent>