<?php
/**
 * Handle de requisições pelo gateway utilizando XML ou JSON
 *
 * @author Lukas Jacomin
 */
error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
ini_set("error_reporting", E_ALL ^ E_NOTICE ^ E_WARNING);

require_once "Request.class.php";
require_once "Utils.class.php";
require_once "JWT.class.php";
require_once $_SERVER['DOCUMENT_ROOT'] . '/config/lock.php';
require_once $_SERVER['DOCUMENT_ROOT'] . '/_class/funcoes/data_sources.php';

$guestLogin = 'MUVLY';
$guestPassword = 'kmm$2020$kmm';

function guest_request($login, $pwd, $tns) {
    $conexao = oci_connect($login, $pwd, $tns, 'WE8ISO8859P15');
        if ($conexao === false) {
            $err = oci_error();

            if (strpos($err["message"], 'ORA-01017') !== false) {
                throw new Exception('Usuário ou senha inválidos.', 401);
            } else if (strpos($err["message"], 'ORA-28001') !== false) {
                throw new Exception('Senha expirada.', 401);
            } else if (strpos($err["message"], 'ORA-28000') !== false) {
                throw new Exception('Conta bloqueada.', 401);
            } else {
                throw new Exception(utf8_encode($err["message"]), 403);
            }
        } else {
            return $conexao;
        }
}

function real_ip()
{
    $header_checks = array(
        'HTTP_CLIENT_IP',
        'HTTP_PRAGMA',
        'HTTP_XONNECTION',
        'HTTP_CACHE_INFO',
        'HTTP_XPROXY',
        'HTTP_PROXY',
        'HTTP_PROXY_CONNECTION',
        'HTTP_VIA',
        'HTTP_X_COMING_FROM',
        'HTTP_COMING_FROM',
        'HTTP_X_FORWARDED_FOR',
        'HTTP_X_FORWARDED',
        'HTTP_X_CLUSTER_CLIENT_IP',
        'HTTP_FORWARDED_FOR',
        'HTTP_FORWARDED',
        'ZHTTP_CACHE_CONTROL',
        'REMOTE_ADDR',
    );

    foreach ($header_checks as $key) {
        if (array_key_exists($key, $_SERVER) === true) {
            foreach (explode(',', $_SERVER[$key]) as $ip) {
                $ip = trim($ip);

                //filter the ip with filter functions
                if (filter_var($ip, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4) !== false) {
                    return $ip;
                }
            }
        }
    }
}

$ambiente = "PRODUCAO";

if (preg_match("/s([0-9]{2})b([0-9]{2}).kmm.com.br/i", $_SERVER['HTTP_HOST'], $matches)) {
    $slot = "S{$matches[1]}B{$matches[2]}";

    $dsns[$slot] = array(
        "DBTYPE" => "oracle",
        "TNS" => "(DESCRIPTION =
                                 (ADDRESS_LIST =
                                    (ADDRESS = (PROTOCOL = TCP)(HOST = s{$matches[1]}.kmm.com.br)(PORT = 1521))
                                 )
                                 (CONNECT_DATA =
                                    (SID = $slot)
                                 )
                              )",
        "USERNAME" => "",
        "PASSWORD" => "",
    );
    $_SESSION['dsn'] = $slot;
    $ambiente = $slot;
}

if (preg_match("/o([0-9]{2})b([0-9]{2}).kmm.com.br/i", $_SERVER['HTTP_HOST'], $matches)) {
    $slot = "O{$matches[1]}B{$matches[2]}";

    $dsns[$slot] = array(
        "DBTYPE" => "oracle",
        "TNS" => "(DESCRIPTION =
                                 (ADDRESS_LIST =
                                    (ADDRESS = (PROTOCOL = TCP)(HOST = o{$matches[1]}.kmm.com.br)(PORT = 1521))
                                 )
                                 (CONNECT_DATA =
                                    (SID = $slot)
                                 )
                              )",
        "USERNAME" => "",
        "PASSWORD" => "",
    );
    $_SESSION['dsn'] = $slot;
    $ambiente = $slot;
}

// Origem
$ip = real_ip();

$tns = $dsns[$_SESSION['dsn']]['TNS'];
$chaveSSL = "]]as+01";
$cryptMethod = "AES256";
$request = new Request(); // Inicializa as variáveis úteis

// Necessário para CORS
if ($_SERVER["REQUEST_METHOD"] == "OPTIONS") {
    $request->responseHeaders();
    die();
}

try {
    if (!in_array($cryptMethod, openssl_get_cipher_methods(true))) {
        throw new Exception("Método 'AES256' não encontrado.", 503);
    }

    $response = array(
        "success" => true,
        "code" => 200,
    );

    $request->handle(); // Handle aqui pois gera exception

    if (!is_array($request->parameters)) {
        $request->parameters = array();
    }

    $username = $request->parameters["username"];
    $password = $request->parameters["password"];
    $codGestao = $request->parameters["cod_gestao"];
    $filiais = $request->parameters["filiais"];
    $agile = $request->parameters["agile"]; // valida se logon pertence ao agile
    $operation = $request->operation;
    $module = $request->module;
    $paramsXML = Utils::arrayToXml($request->parameters, "params");

    if (!$username && (
        $operation === 'recuperarSenha' ||
        $operation === 'manipulaUsuario' ||
        $operation === 'verificaCPF'
       )
    ) {
        $username = $guestLogin;
        $password = $guestPassword;
        $isGuest = true;

        $query = "
              select c.cod_gestao
                from agile.v\$cadastro c
               where c.usuario = upper(:p_usuario)
            ";


            $stmt = oci_parse(guest_request($guestLogin, $guestPassword, $tns), $query);
            oci_bind_by_name($stmt, ":p_usuario", $username);

            if (!oci_execute($stmt, OCI_DEFAULT)) {
                $err = oci_error($stmt);
                throw new Exception(utf8_encode($err["message"]), 500);
            } else {
                $row = oci_fetch_array($stmt);
                $codGestao = (int) $row['COD_GESTAO'];
            }
    }

    if ($request->header("Authorization")) {
        $token = str_replace("Bearer ", "", $request->header("Authorization"));
    } else {
        $token = str_replace("Bearer ", "", $request->header("authorization"));
    }

    if (!Utils::hasValue($module)) {
        throw new Exception("Módulo não informado.", 405);
    }
    if (!Utils::hasValue($operation)) {
        throw new Exception("Operation não informada.", 405);
    }
    if (!Utils::hasValue($token) && $operation !== "LOGON" && $operation !== "LOGON_AGILE" && !$isGuest) {
        throw new Exception("Header: Authorization não informado.", 405);
    }

    $tokenData = array();
    if (Utils::hasValue($token)) {
        $aux = explode(".", $token);
        $tokenData = json_decode(base64_decode($aux[0]), true);
        $tokenData = $tokenData["data"];
        $username = $tokenData["username"];
        $password = openssl_decrypt($tokenData["password"], $cryptMethod, $chaveSSL);
        $codGestao = $tokenData["cod_gestao"];
        if (!$request->parameters["filiais"]) {
            $filiais = $tokenData["filiais"];
        }
        //$filiais = $tokenData["filiais"];
    }

    // Modulo LOGON
    // Modulo LOGON sem cod_gestao retorna as gestões com as filiais
    // Modulo LOGON com cod_gestao e sem filiais, loga em todas as filiais
    // Modulo LOGON com cod_gestao e com filiais, loga nas filiais selecionadas
    if ($module == "LOGON" && ($operation == "LOGON" || $operation == "GETGESTOES" || $operation == "LISTGESTOES" || $operation == "TESTCONNECTION" || $operation == "CONNECTDATA")) {
        if ($operation == "TESTCONNECTION") {
            die(json_encode(array("status" => "OK")));
        }
        if ($operation == "CONNECTDATA") {
            include $_SERVER['DOCUMENT_ROOT'] . '/config/connectdata.php';
            if ($request->header("verify") && $request->header("verify") == "]]as+02") {
                die(json_encode(array(
                    "success" => true,
                    "cod_aplicacao" => $_CONNECTDATA['cod_aplicacao'],
                    "tns" => $_CONNECTDATA['tns'],
                    "authtype" => $_CONNECTDATA['authtype'],
                    "authdata" => $_CONNECTDATA['authdata'],
                )));
            } else {
                throw new Exception("Acesso não autorizado", 403);
            }
        }
    } else {
        $tokenData = array();
        if (Utils::hasValue($token)) {
            $tokenData = JWT::validate($token); // Gera exception
        }
    }

    // Faz a conexão com usuário 'MUVLY' para buscar o usuário pelo email
    if (strpos($username, '@') !== false) {
        $query = '
            select u.usuario
              from kss.v$usuarios u
             inner join kss.v$email e
                on u.email_id = e.email_id
             where e.email_completo = :p_email
        ';

        $conexao = guest_request($guestLogin, $guestPassword, $tns);
        $stmt = oci_parse($conexao, $query);

        oci_bind_by_name($stmt, ":p_email", $username);

        if (!oci_execute($stmt, OCI_DEFAULT)) {
            $err = oci_error($stmt);
            throw new Exception(utf8_encode($err["message"]), 500);
        } else {
            $row = oci_fetch_array($stmt);

            if ($row) {
                $username = $row['USUARIO'];
            }
        }
    }
    $conexao = oci_connect($username, $password, $tns, 'WE8ISO8859P15');
    if ($conexao === false) {
        $err = oci_error();

        if (strpos($err["message"], 'ORA-01017') !== false) {
            throw new Exception('Usuário ou senha inválidos.', 401);
        } else if (strpos($err["message"], 'ORA-28001') !== false) {
            throw new Exception('Senha expirada.', 401);
        } else if (strpos($err["message"], 'ORA-28000') !== false) {
            throw new Exception('Conta bloqueada.', 401);
        } else {
            throw new Exception(utf8_encode($err["message"]), 401);
        }
    } else {
        $stmt = oci_parse($conexao, "SET ROLE KSS_CORPORATIVO IDENTIFIED BY \"()#3F20L13RJ@\"");
        if (!@oci_execute($stmt, OCI_DEFAULT)) {
            throw new Exception(oci_error(), 403);
        }

        if ($module === "LOGON" && $operation === "LOGON_AGILE") {
            $query = "
              select c.cod_gestao
                from agile.cadastro c
               where c.usuario = upper(:p_usuario)
                 and finalizado = 0
            ";

            $stmt = oci_parse($conexao, $query);
            oci_bind_by_name($stmt, ":p_usuario", $username);

            if (!oci_execute($stmt, OCI_DEFAULT)) {
                $err = oci_error($stmt);
                throw new Exception(utf8_encode($err["message"]), 500);
            } else {
                $row = oci_fetch_array($stmt);
                $codGestao = (int) $row['COD_GESTAO'];

                if ($row) {
                    $tokenData = array(
                        "username"   => $username,
                        "password"   => openssl_encrypt($password, $cryptMethod, $chaveSSL),
                        "cod_gestao" => $codGestao,
                        "filiais"    => $filiais,
                        "action"     => "REGISTER"
                    );

                    $tempo = 24 * 60 * 60;
                    $token = JWT::generateToken($tokenData, $tempo);
                    $response["result"]["token"] = $token;
                    $response["result"]["ambiente"] = $ambiente;
                } else {
                    $operation = "LOGON";
                }
            }
        }

        // Se module e operation == "LOGON", retorna o token
        if ($module === "LOGON" && $operation === "LOGON") {
            $query = "
            select c.cod_gestao
                 , c.cod_pessoa_pj as cod_pessoa
                 , (select count(*)
                      from kss.kss_usuarios u
                     where u.usuario = c.usuario
                       and u.primeiro_acesso is null) as primeiro_acesso
              from agile.cadastro c
             where c.usuario = upper(:p_usuario)
      ";

            $stmt = oci_parse($conexao, $query);
            oci_bind_by_name($stmt, ":p_usuario", $username);

            $primeiroAcesso = 0;
            if (!oci_execute($stmt, OCI_DEFAULT)) {
                $err = oci_error($stmt);
                throw new Exception(utf8_encode($err["message"]), 500);
            } else {
                $row = oci_fetch_array($stmt);

                if (!$row) {
                    throw new Exception('Não foi possivel recuperar a gestão', 500);
                }

                $codGestao = (int) $row['COD_GESTAO'];
                $filiais = $filiais ? $filiais : (string) $row['COD_PESSOA'];
                $primeiroAcesso = (int) $row['PRIMEIRO_ACESSO'];
            }

            $tokenData = array(
                "username" => $username,
                "password" => openssl_encrypt($password, $cryptMethod, $chaveSSL),
                "cod_gestao" => $codGestao,
                "filiais" => $filiais,
                "action" => ($primeiroAcesso == 0) ? "NORMAL" : "RESETPASSWORD"
            );

            // 30 dias
            if ($request->header("Token-Time-Hours")) {
                $tokenTimeHours = $request->header("Token-Time-Hours");
            } else {
                $tokenTimeHours = $request->header("token-time-hours");
            }
            if (!Utils::hasValue($tokenTimeHours) || $tokenTimeHours === 0) {
                $tokenTimeHours = 6 * 30 * 24; // 180 dias
            }
            $tempo = $tokenTimeHours * 60 * 60;
            $token = JWT::generateToken($tokenData, $tempo);
            $response["result"]["token"] = $token;
            $response["result"]["ambiente"] = $ambiente;
        }

        if ($codGestao !== null) {
            $queryToken = "
           begin
               agile.pkg_acesso.prc_acesso(p_cod_gestao   => :p_cod_gestao,
                                           p_operation    => :p_operation,
                                           p_token        => :p_token,
                                           p_ip           => :p_ip,
                                           p_result       => :p_result
                                           );
           end;";

            $stmt = oci_parse($conexao, $queryToken);
            oci_bind_by_name($stmt, ':p_cod_gestao', $codGestao, 4000);
            oci_bind_by_name($stmt, ':p_operation', $operation, 4000);
            oci_bind_by_name($stmt, ':p_token', $token, 4000);
            oci_bind_by_name($stmt, ':p_ip', $ip, 4000);
            oci_bind_by_name($stmt, ':p_result', $resultToken, 4000);

            if (!oci_execute($stmt, OCI_COMMIT_ON_SUCCESS)) {
                $err = oci_error($stmt);
                throw new Exception(utf8_encode($err["message"]), 500);
            } else {
                if ($resultToken !== "OK") {
                    throw new Exception(utf8_encode($resultToken), 401);
                }
            }
        }

        if (!($module === "LOGON" && $operation === "LOGON") && !($module === "LOGON" && $operation === "LOGON_AGILE")) {
            $query = "begin
                  kss.pkg_remote.prc_gateway(p_cod_gestao   => :p_cod_gestao,
                                             p_filiais      => :p_filiais,
                                             p_module       => :p_module,
                                             p_operation    => :p_operation,
                                             p_parameters   => :p_parameters,
                                             p_result       => :p_result
                                             );
               end;";
            $stmt = oci_parse($conexao, $query);
            oci_bind_by_name($stmt, ':p_cod_gestao', $codGestao, 4000);
            oci_bind_by_name($stmt, ':p_filiais', $filiais, 4000);
            oci_bind_by_name($stmt, ':p_module', $module, 4000);
            oci_bind_by_name($stmt, ':p_operation', $operation, 4000);
            $parametersXMLGateway = oci_new_descriptor($conexao, OCI_D_LOB);
            $result = oci_new_descriptor($conexao, OCI_D_LOB);
            $parametersXMLGateway->writeTemporary($paramsXML, OCI_TEMP_CLOB);
            oci_bind_by_name($stmt, ':p_parameters', $parametersXMLGateway, -1, OCI_B_CLOB);
            oci_bind_by_name($stmt, ':p_result', $result, -1, OCI_B_CLOB);

            if (!oci_execute($stmt, OCI_COMMIT_ON_SUCCESS)) {
                $err = oci_error($stmt);
                throw new Exception(utf8_encode($err["message"]), 500);
            } else {
                $resultAux = $result->load();
                if (Utils::hasValue($resultAux)) {
                    $response["result"] = Utils::xmlToArray($resultAux);
                    if (isset($response["result"]["fault"]["error"])) {

                        http_response_code(500);
                        $message = $request->isDebug() && Utils::hasValue($response["result"]["fault"]["stacktrace"]) ? $response["result"]["fault"]["message"] . "\n" . $response["result"]["fault"]["stacktrace"] : $response["result"]["fault"]["message"];
                        $response = array(
                            "success" => false,
                            "code" => 500,
                            "message" => $message,
                            "detail" => $response["result"]["fault"],
                        );
                    }
                } else {
                    //$response["result"] = array();
                }
            }
        }
    }

    // O header KMM-Platform é enviado para identificar qual plataforma está sendo executada
    //$response["KMM-Platform"] = $request->header("KMM-Platform");

    // É debug se tem 1 no header "Debug"
    if ($request->isDebug()) {
        $response["debug"] = $request->isDebug();
        $response["token"] = $token != null ? $token : $response["result"]["token"];
    }
} catch (Exception $e) {
    $code = $e->getCode();
    $message = $e->getMessage();
    if ($code == 0 || !isset($code)) {
        $code = 500;
    }
    http_response_code($code);
    $response = array(
        "success" => false,
        "code" => $code,
        "message" => $message,
    );
}

// Printa o response
$request->showResponse($response);
