<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas de fluxos de documentos" extends="_transportes.funcoes.cfc_init">
	
	<!--- 
    -- PROPSITO
    -- Insere um tipo de documento
    -- WAGNERS 07/03/2012 17:17:30 - CRIADO
    --->
    <cffunction name='ins_tipo_documento' displayname='Insere um tipo de documento' access='remote' returntype='Struct' output='true'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='TIPO_DOCUMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_fluxo_docto.prc_ins_tipo_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO'  value='#arguments.TIPO_DOCUMENTO#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID' variable='retorno.TIPO_DOCUMENTO_ID' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de documento inserido com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Altera um tipo de documento
    -- WAGNERS 07/03/2012 17:18:17 - CRIADO
    --->
    <cffunction name='upd_tipo_documento' displayname='Altera um tipo de documento' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
        <cfargument name='NOME' required='yes'>
        <cfargument name='TIPO_DOCUMENTO' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_fluxo_docto.prc_alt_tipo_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_NOME'  value='#arguments.NOME#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO'  value='#arguments.TIPO_DOCUMENTO#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de documento alterado com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
    -- PROPSITO
    -- Exclui um tipo de documento
    -- WAGNERS 07/03/2012 17:18:51 - CRIADO
    --->
    <cffunction name='del_tipo_documento' displayname='Exclui um tipo de documento' access='remote' returntype='Struct' output='true'>
        <cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='oper.pkg_fluxo_docto.prc_del_tipo_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO_ID'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Tipo de documento excludo com sucesso!')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Insere um documento digitalizado
	-- WAGNERS 09/03/2012 09:47:50 - CRIADO
	--->
	<cffunction name='ins_documento_digital' displayname='Insere um documento digitalizado' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='no' default="">
        <cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
		<cfargument name='NUMERO_NF' required='no' default="">
		<cfargument name='MODELO_NF' required='no' default="">
		<cfargument name='SERIE_NF' required='no' default="">
		<cfargument name='SUBSERIE_NF' required='no' default="">
		<cfargument name='ARQUIVO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
            	<cffile action="readbinary" file="#arguments.arquivo#" variable="v_conteudo">
				<cfstoredproc procedure='oper.pkg_fluxo_docto.prc_ins_documento_digital' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUM_ROMANEIO'  value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TIPO_DOCUMENTO'  value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_DESCRICAO'  value='#arguments.DESCRICAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_NUMERO_NF'  value='#arguments.NUMERO_NF#'  null='#iif(len(trim(arguments.NUMERO_NF)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_MODELO_NF'  value='#arguments.MODELO_NF#'  null='#iif(len(trim(arguments.MODELO_NF)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SERIE_NF'  value='#arguments.SERIE_NF#'  null='#iif(len(trim(arguments.SERIE_NF)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_SUBSERIE_NF'  value='#arguments.SUBSERIE_NF#'  null='#iif(len(trim(arguments.SUBSERIE_NF)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_BLOB' dbvarname='P_CONTEUDO'  value='#v_conteudo#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_EXTENSAO'  value='#arguments.EXTENSAO#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID' variable='retorno.DOCUMENTO_ID' >

                </cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento registrado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    
    <!--- 
	-- PROPSITO
	-- Exclui um documento digitalizado
	-- WAGNERS 09/03/2012 09:48:27 - CRIADO
	--->
	<cffunction name='del_documento_digital' displayname='Exclui um documento digitalizado' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_fluxo_docto.prc_del_documento_digital' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_DOCUMENTO_ID'  value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento excludo com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
	
</cfcomponent>