<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas de fluxos de documentos" extends="_transportes.funcoes.cfc_init">
    <!--- 
	-- PROPSITO 
	-- Busca filiais
	-- NOTAS EXPLICATIVAS
	-- GUTO
	--->
	<cffunction name="get_unidade_negocio" access="remote" returntype="query">
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select un.cod_pessoa, un.unidade_negocio
              from kss.v$unidade_negocio un
            order by un.unidade_negocio  
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!--- 
	-- PROPSITO 
	-- Busca centros de custo
	-- NOTAS EXPLICATIVAS
	-- GUTO
	--->
	<cffunction name="get_centro_custo" access="remote" returntype="query">
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select og.cod_pessoa, cc.cod_centro_custo, cc.centro_custo 
              from kss.v$organograma og
              inner join kss.v$centro_custo cc
               on og.cod_centro_custo = cc.cod_centro_custo
            order by og.cod_pessoa, cc.centro_custo 
		</cfquery>
		<cfreturn qr_result>
	</cffunction>    

    <!--- 
	-- PROPSITO 
	-- Busca pessoa
	-- NOTAS EXPLICATIVAS
	-- ROBSON CESAR
	--->
	<cffunction name="get_pessoa" access="remote" returntype="query">
    	<cfargument name="cod_pessoa" required="no" default="">
		<cfargument name="razao_social" required="no" default="">
        <cfargument name="cnpj_cpf" required="no" default="">
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select p.cod_pessoa,p.razao_social,p.identificador,p.CNPJ_CPF
    		from kss.v$pessoa p
            where 1=1
             <cfif len(trim(arguments.razao_social))>
               and upper(kss.pkg_string.fnc_string_clean(p.razao_social)) like upper(kss.pkg_string.fnc_string_clean('%#arguments.razao_social#%'))
             </cfif>
             <cfif len(trim(arguments.cod_pessoa))>
               and p.cod_pessoa = #arguments.cod_pessoa#
             </cfif>
			 <cfif len(trim(arguments.cnpj_cpf))>
               and p.cnpj_cpf like kss.pkg_string.fnc_num_clean('#arguments.cnpj_cpf#')
             </cfif> 
		</cfquery>
		<cfreturn qr_result>
	</cffunction>    
</cfcomponent>