<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas de fluxos de documentos" extends="_transportes.funcoes.cfc_init">
	
   
     <!--- 
	-- PROPSITO 
	-- Busca o proximo valor da sequence de movimentao de documentos
	-- NOTAS EXPLICATIVAS
	-- WAGNER  21/09/2010
	--->
	<cffunction name="get_tipo_documento" access="remote" returntype="query">
        <cfargument name="nome"	required="no" default="">
        <cfargument name="tipo_documento_id"  required="no" default="">
        <cfargument name="tipo_documento"  required="no" default="">
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select tipo_documento_id,
                   nome,
                   tipo_documento,
                   (select rv_abbreviation
                      from oper.v$cg_ref_codes c
                     where c.rv_low_value = t.tipo_documento
                       and c.rv_domain = 'OPER.TIPO_DOCUMENTO') as tipo_documento_desc,
                   date_insert,
                   user_insert,
                   date_update,
                   user_update,
                   site
              from oper.v$tipo_documento t
             where 1=1
            <cfif len(trim(arguments.tipo_documento_id)) >
				and tipo_documento_id = #arguments.tipo_documento_id#
			</cfif>
            <cfif len(trim(arguments.nome)) >
				and nome like '%#arguments.nome#%'
			</cfif>
            <cfif len(trim(arguments.tipo_documento)) >
				and tipo_documento = #arguments.tipo_documento#
			</cfif>
            order by nome
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    
    
    <!--- 
	-- PROPSITO 
	-- Busca o proximo valor da sequence de movimentao de documentos
	-- NOTAS EXPLICATIVAS
	-- WAGNER  21/09/2010
	--->
	<cffunction name="get_documento_digital" access="remote" returntype="query">
        <cfargument name="nome"	required="no" default="">
        <cfargument name="documento_id"  required="no" default="">
        <cfargument name="conhecimento_id"  required="no" default="">
        <cfargument name="num_romaneio"  required="no" default="">
        <cfargument name="numero_nf"  required="no" default="">
        <cfargument name="modelo_nf"  required="no" default="">
        <cfargument name="serie_nf"  required="no" default="">
        <cfargument name="subserie_nf"  required="no" default="">
        <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select dg.documento_id,
                   dg.descricao,
                   dg.conhecimento_id,
                   dg.num_romaneio,
                   dg.numero_nf,
                   dg.modelo_nf,
                   dg.serie_nf,
                   dg.subserie_nf,
                   oper.pkg_fluxo_docto.fnc_get_documento_digital(p_documento_id => dg.documento_id) as conteudo,
                   dg.extensao,
                   dg.tipo_documento_id,
                   tp.documento as tipo_documento,
                   dg.user_insert,
                   to_char(dg.date_insert,'dd/mm/yyyy hh:mi') as date_insert,
                   dg.user_update,
                   to_char(dg.date_update,'dd/mm/yyyy hh:mi') as date_update,
                   dg.site,
                   case when dg.conhecimento_id is null then to_char(dg.numero_nf) else to_char(dg.conhecimento_id) end as num_documento
              from oper.v$documento_digital dg
              left join oper.v$documento_frete tp
                on tp.documento_id = dg.tipo_documento_id
             where 1=1
            <cfif len(trim(arguments.documento_id)) >
				and dg.documento_id = #arguments.documento_id#
			</cfif>
            
            <cfif len(trim(arguments.conhecimento_id)) >
            	<cfif arguments.conhecimento_id eq 'null'>
                	and conhecimento_id is null
                <cfelse>
					and conhecimento_id = #arguments.conhecimento_id#
                </cfif>
			</cfif>
            
            <cfif len(trim(arguments.num_romaneio)) >
				and num_romaneio = #arguments.num_romaneio#
			</cfif>
            
			<cfif len(trim(arguments.numero_nf)) >
                <cfif arguments.numero_nf eq 'null'>
                	and numero_nf is null
                <cfelse>
					and numero_nf = #arguments.numero_nf#
                </cfif>
			</cfif>
            
            <cfif len(trim(arguments.modelo_nf)) >
                <cfif arguments.modelo_nf eq 'null'>
                	and modelo_nf is null
                <cfelse>
					and modelo_nf = #arguments.modelo_nf#
                </cfif>
			</cfif>
            
            <cfif len(trim(arguments.serie_nf)) >
                <cfif arguments.serie_nf eq 'null'>
                	and serie_nf is null
                <cfelse>
					and serie_nf = #arguments.serie_nf#
                </cfif>
			</cfif>
            
            <cfif len(trim(arguments.subserie_nf)) >
                <cfif arguments.subserie_nf eq 'null'>
                	and subserie_nf is null
                <cfelse>
					and subserie_nf = #arguments.subserie_nf#
                </cfif>
			</cfif>
            
            order by descricao
		</cfquery>
		<cfreturn qr_result>
	</cffunction>
    

</cfcomponent>
