<cfcomponent displayname="Consultas da rea de emissao de documentos" extends="_transportes.funcoes.cfc_init">
	<!--- 
	-- PROPSITO 
	-- Busca romaneios
	-- GUTO
	--->	
	<cffunction name="get_romaneio_documentos" access="remote" returntype="query" output="true">
    	<cfargument name="num_conhecimento" required="no" default="">
        <cfargument name="conhecimento_id" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_departamento" required="no" default="">
        <cfargument name="cod_setor" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="cod_organograma" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select r.num_romaneio, r.cliente, r.carregamento, r.destino, r.data_inicio, r.data_termino, r.situacao_id,
                   (select count(*)
                      from oper.v$documento_digital dg
                      left join oper.v$documento_frete tp
                             on tp.documento_id  = dg.tipo_documento_id
                      left join oper.v$tipo_documento td
					         on td.tipo_documento_id = tp.documento_id_digital 
					 where dg.num_romaneio = r.num_romaneio
                       and td.tipo_documento = 1) as doc_romaneio,
                       
                   c.conhecimento_id, c.num_conhecimento, c.serie, f.cliente as filial, cc.centro_custo, c.data_emissao, c.cob_razao_social, c.rem_razao_social, c.dest_razao_social, c.placa_tracao, c.placa, c.peso, c.total_conhecimento,
                   decode(c.cancelado,null,'No','Sim') as cancelado,
                   (select count(*)
                      from oper.v$documento_digital dg
                     where dg.num_romaneio = r.num_romaneio
                       and dg.conhecimento_id = c.conhecimento_id) as doc_cte,       
                   cnf.numero as num_nota_fiscal, 
                   cnf.modelo as modelo_nf,
                   cnf.serie as serie_nf,
                   cnf.sub_serie as sub_serie_nf,
                   cnf.data_emissao as data_emissao_nf,
                   n.descricao as natureza, 
                   e.descricao as especie,
                   cnf.valor_total as valor_nf,
                   (select count(*)
                      from oper.v$documento_digital dg
                      left join oper.v$documento_frete tp
                             on tp.documento_id = dg.tipo_documento_id
                      left join oper.v$tipo_documento td
					         on td.tipo_documento_id = tp.documento_id_digital 
					 where dg.num_romaneio = r.num_romaneio
                       and dg.conhecimento_id = c.conhecimento_id
                       and dg.numero_nf = cnf.numero
                       and dg.modelo_nf = cnf.modelo
                       and dg.serie_nf = cnf.serie
                       and dg.subserie_nf = cnf.sub_serie
                       and td.tipo_documento = 3) as doc_nf       
              from oper.v$romaneio r
             left join fiscal.v$conhecimento c
                     on c.num_romaneio = r.num_romaneio 
             left join kss.v$pessoa f
                    on f.cod_pessoa = c.cod_pessoa_filial
             left join kss.v$centro_custo cc
                    on cc.cod_centro_custo = c.cod_centro_custo
             left join fiscal.v$conhecimento_nota_fiscal cnf
                     on cnf.conhecimento_id = c.conhecimento_id         
             left join oper.v$natureza n
                    on n.num_natureza = cnf.num_natureza
             left join oper.v$especie e
                    on e.num_especie = cnf.num_especie
            where 1=1 
             <cfif len(trim( arguments.num_romaneio )) >
             	and r.num_romaneio = '#arguments.num_romaneio#'
             </cfif>
             <cfif len(trim( arguments.conhecimento_id )) >
             	and c.conhecimento_id = '#arguments.conhecimento_id#'
             </cfif>
             <cfif len(trim( arguments.num_conhecimento )) >
             	and c.num_conhecimento = '#arguments.num_conhecimento#'
             </cfif>
             <cfif len(trim( arguments.cod_pessoa_filial )) >
             	and c.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
             </cfif>
             <cfif len(trim( arguments.cod_centro_custo )) >
             	and c.cod_centro_custo = '#arguments.cod_centro_custo#'
             </cfif>
             <cfif len(trim( arguments.cod_setor )) >
             	and c.cod_setor = '#arguments.cod_setor#'
             </cfif>
             <cfif len(trim( arguments.cod_departamento )) >
             	and c.cod_departamento = '#arguments.cod_departamento#'
             </cfif>
            order by doc_romaneio desc, r.num_romaneio, c.num_conhecimento, num_nota_fiscal		
          </cfquery>
		<cfreturn qr_result>		
	</cffunction>	
    	

	<!--- 
	-- PROPSITO 
	-- Busca documentos viagens, conhecimento, NF
	-- ROBSON CESAR
	--->	
	<cffunction name="get_viagem_documentos" access="remote" returntype="query" output="true">
    	<cfargument name="DATA_VIAGEM_INICIO" required="no" default="">
    	<cfargument name="DATA_VIAGEM_TERMINO" required="no" default="">
        <cfargument name="DATA_INICIO_EMISSAO" required="no" default="">
        <cfargument name="DATA_FIM_EMISSAO" required="no" default="">
		<cfargument name="DOCS_VINCULADOS" required="no" default="">
        <cfargument name="TIPO_DOCUMENTO" required="no" default="">
        <cfargument name="NUM_ROMANEIO" required="no" default="">
        <cfargument name="COD_PESSOA_FILIAL" required="no" default="">
        <cfargument name="COD_CENTRO_CUSTO" required="no" default="">
        <cfargument name="num_documento" required="no" default="">
        <cfargument name="cod_cliente_cobranca" required="no" default="">
        <cfargument name="cod_destinatario" required="no" default="">
        <cfargument name="cod_remetente" required="no" default="">        
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.*
              from (
            select decode((select count(*)
                                  from oper.v$documento_digital dg
                                  inner join oper.v$documento_frete tp
                                          on tp.documento_id = dg.tipo_documento_id
                                 where dg.num_romaneio = r.num_romaneio
								   and dg.conhecimento_id = c.conhecimento_id),0,'No','Sim') as docs_vinculados
                   , r.num_romaneio
                   , 'CTE' as tipo_documento
                   , c.conhecimento_id
                   , c.num_conhecimento as num_documento
                   , c.serie
                   , to_char(c.data_emissao,'dd/mm/yyyy hh:mi') as data_emissao
                   , pneg.razao_social as negociador
                   , pMot.nome as motorista
                   , ptp.telefone as telefone_contato_motorista
                   , f.cliente as filial
                   , c.cod_pessoa_filial
                   , cc.centro_custo
                   , cc.cod_centro_custo
                   , (select kss.fnc_concat_all(kss.to_concat_expr(cvei.placa, ', ')) 
                        from fiscal.v$conhecimento_veiculo cvei
                       where cvei.conhecimento_id = c.conhecimento_id) as veiculos
                   , c.rem_razao_social
                   , kss.pkg_string.fnc_formata_cnpj_cpf(c.REM_CNPJ_CPF) as REM_CNPJ_CPF
                   , c.cod_remetente
                   , c.DEST_RAZAO_SOCIAL
                   , kss.pkg_string.fnc_formata_cnpj_cpf(c.DEST_CNPJ_CPF) as DEST_CNPJ_CPF
                   , c.cod_destinatario
                   , c.COLETA_LOGRADOURO
                   , c.COLETA_BAIRRO
                   , c.COLETA_COMPLEMENTO
                   , case when c.COLETA_COMPLEMENTO IS NULL OR c.COLETA_COMPLEMENTO = 'null' THEN c.COLETA_LOGRADOURO ELSE concat(c.COLETA_LOGRADOURO,concat(', ',c.COLETA_COMPLEMENTO)) END COLETA_ENDERECO_COMPLETO
                   , c.COLETA_CEP
                   , cep.pkg_municipio.fnc_cidade_completa(c.coleta_municipio_id) as municipio_coleta
                   , c.ENTREGA_LOGRADOURO
                   , c.ENTREGA_COMPLEMENTO
                   , case when c.ENTREGA_COMPLEMENTO IS NULL OR c.ENTREGA_COMPLEMENTO = 'null' THEN c.ENTREGA_LOGRADOURO ELSE concat(c.ENTREGA_LOGRADOURO,concat(', ',c.ENTREGA_COMPLEMENTO)) END ENTREGA_ENDERECO_COMPLETO
                   , c.ENTREGA_BAIRRO
                   , c.ENTREGA_CEP
                   , cep.pkg_municipio.fnc_cidade_completa(c.ENTREGA_MUNICIPIO_ID) as municipio_entrega    
                   , c.modalidade
                   , ptomador.razao_social as tomador
                   , ptomador.identificador as cnpj_tomador
                   , o.descricao as organizacional
                   , r.DATA_INICIO
                   , r.DATA_TERMINO
                   , to_char(r.DATA_INICIO,'dd/mm/yyyy hh:mi') as data_inicio_viagem
                   , to_char(r.DATA_TERMINO,'dd/mm/yyyy hh:mi') as data_termino_viagem
                   , un.unidade_negocio as razao_filial
                   , un.cod_unidade_negocio
                   , c.cod_cliente_cobranca
				   , c.baixado_por
				   , to_char(c.baixado_em,'dd/mm/yyyy hh:mi') as baixado_em
				   , c.baixado_observacao
                  from oper.v$romaneio r
            inner join fiscal.v$conhecimento c
                    on c.num_romaneio = r.num_romaneio 
             left join kss.v$pessoa ptomador
                    on ptomador.cod_pessoa = c.cod_cliente_cobranca
             left join kss.v$pessoa f
                    on f.cod_pessoa = c.cod_pessoa_filial
             left join kss.v$pessoa pneg
                    on pneg.cod_pessoa = c.cod_negociador
             left join kss.v$pessoa_fisica pMot
                    on pMot.cod_pessoa = c.cod_motorista
             left join kss.v$pessoa_telefone_padrao ptp
                    on ptp.cod_pessoa = pMot.cod_pessoa       
             left join kss.v$centro_custo cc
                    on cc.cod_centro_custo = c.cod_centro_custo
             left join KSS.v$ORGANIZACIONAL o
                    on o.organizacional_id = c.organizacional_id
             left join kss.v$unidade_negocio un
                    on un.cod_pessoa = c.cod_pessoa_filial
            
			union all
			
            select decode((select count(*)
                                  from oper.v$documento_digital dg
                                  inner join oper.v$documento_frete tp
                                          on tp.documento_id = dg.tipo_documento_id
                                 where dg.conhecimento_id = c.conhecimento_id),0,'No','Sim') as docs_vinculados
                   , null as num_romaneio
                   , 'CTE Cancelado' as tipo_documento
                   , c.conhecimento_id
                   , c.num_conhecimento as num_documento
                   , c.serie
                   , to_char(c.data_emissao,'dd/mm/yyyy hh:mi') as data_emissao
                   , pneg.razao_social as negociador
                   , pMot.nome as motorista
                   , ptp.telefone as telefone_contato_motorista
                   , f.cliente as filial
                   , c.cod_pessoa_filial
                   , cc.centro_custo
                   , cc.cod_centro_custo
                   , (select kss.fnc_concat_all(kss.to_concat_expr(cvei.placa, ', ')) 
                        from fiscal.v$conhecimento_veiculo cvei
                       where cvei.conhecimento_id = c.conhecimento_id) as veiculos
                   , c.rem_razao_social
                   , kss.pkg_string.fnc_formata_cnpj_cpf(c.REM_CNPJ_CPF) as REM_CNPJ_CPF
                   , c.cod_remetente
                   , c.DEST_RAZAO_SOCIAL
                   , kss.pkg_string.fnc_formata_cnpj_cpf(c.DEST_CNPJ_CPF) as DEST_CNPJ_CPF
                   , c.cod_destinatario
                   , c.COLETA_LOGRADOURO
                   , c.COLETA_BAIRRO
                   , c.COLETA_COMPLEMENTO
                   , case when c.COLETA_COMPLEMENTO IS NULL OR c.COLETA_COMPLEMENTO = 'null' THEN c.COLETA_LOGRADOURO ELSE concat(c.COLETA_LOGRADOURO,concat(', ',c.COLETA_COMPLEMENTO)) END COLETA_ENDERECO_COMPLETO
                   , c.COLETA_CEP
                   , cep.pkg_municipio.fnc_cidade_completa(c.coleta_municipio_id) as municipio_coleta
                   , c.ENTREGA_LOGRADOURO
                   , c.ENTREGA_COMPLEMENTO
                   , case when c.ENTREGA_COMPLEMENTO IS NULL OR c.ENTREGA_COMPLEMENTO = 'null' THEN c.ENTREGA_LOGRADOURO ELSE concat(c.ENTREGA_LOGRADOURO,concat(', ',c.ENTREGA_COMPLEMENTO)) END ENTREGA_ENDERECO_COMPLETO
                   , c.ENTREGA_BAIRRO
                   , c.ENTREGA_CEP
                   , cep.pkg_municipio.fnc_cidade_completa(c.ENTREGA_MUNICIPIO_ID) as municipio_entrega    
                   , c.modalidade
                   , ptomador.razao_social as tomador
                   , ptomador.identificador as cnpj_tomador
                   , o.descricao as organizacional
                   , null as DATA_INICIO
                   , null as DATA_TERMINO
                   , null as data_inicio_viagem
                   , null as data_termino_viagem
                   , un.unidade_negocio as razao_filial
                   , un.cod_unidade_negocio
                   , c.cod_cliente_cobranca
				   , c.baixado_por
				   , to_char(c.baixado_em,'dd/mm/yyyy hh:mi') as baixado_em
				   , c.baixado_observacao
                from fiscal.v$conhecimento c
             left join kss.v$pessoa ptomador
                    on ptomador.cod_pessoa = c.cod_cliente_cobranca
             left join kss.v$pessoa f
                    on f.cod_pessoa = c.cod_pessoa_filial
             left join kss.v$pessoa pneg
                    on pneg.cod_pessoa = c.cod_negociador
             left join kss.v$pessoa_fisica pMot
                    on pMot.cod_pessoa = c.cod_motorista
             left join kss.v$pessoa_telefone_padrao ptp
                    on ptp.cod_pessoa = pMot.cod_pessoa       
             left join kss.v$centro_custo cc
                    on cc.cod_centro_custo = c.cod_centro_custo
             left join KSS.v$ORGANIZACIONAL o
                    on o.organizacional_id = c.organizacional_id
             left join kss.v$unidade_negocio un
                    on un.cod_pessoa = c.cod_pessoa_filial
              where c.cancelado is not null
			
			union all
            
            select decode((select count(*)
                                  from oper.v$documento_digital dg
                                  inner join oper.v$documento_frete tp
                                          on tp.documento_id = dg.tipo_documento_id
                                 where dg.num_romaneio = r.num_romaneio
								   and dg.numero_nf = n.num_nota_fiscal
                                   and dg.serie_nf = n.serie),0,'No','Sim') as docs_vinculados
                   , r.num_romaneio
                   , 'NF' as tipo_documento
                   , null as conhecimento_id
                   , n.num_nota_fiscal as num_documento
                   , n.serie
                   , to_char(n.data_emissao,'dd/mm/yyyy hh:mi') as data_emissao
                   , pneg.razao_social as negociador
                   , pMot.nome as motorista
                   , ptp.telefone as telefone_contato_motorista
                   , f.cliente as filial
                   , n.cod_pessoa_filial
                   , cc.centro_custo
                   , cc.cod_centro_custo
                   , '' as veiculos
                   , nef.rem_razao_social
                   , kss.pkg_string.fnc_formata_cnpj_cpf(nef.REM_CNPJ_CPF) as REM_CNPJ_CPF
                   , nef.cod_remetente
                   , nef.DEST_RAZAO_SOCIAL
                   , kss.pkg_string.fnc_formata_cnpj_cpf(nef.DEST_CNPJ_CPF) as DEST_CNPJ_CPF
                   , nef.cod_destinatario
                   , nef.COLETA_LOGRADOURO
                   , nef.COLETA_BAIRRO
                   , nef.COLETA_COMPLEMENTO
                   , case when nef.COLETA_COMPLEMENTO IS NULL OR nef.COLETA_COMPLEMENTO = 'null' THEN nef.COLETA_LOGRADOURO ELSE concat(nef.COLETA_LOGRADOURO,concat(', ',nef.COLETA_COMPLEMENTO)) END COLETA_ENDERECO_COMPLETO
                   , nef.COLETA_CEP
                   , cep.pkg_municipio.fnc_cidade_completa(nef.coleta_municipio_id) as municipio_coleta
                   , nef.ENTREGA_LOGRADOURO
                   , nef.ENTREGA_COMPLEMENTO
                   , case when nef.ENTREGA_COMPLEMENTO IS NULL OR nef.ENTREGA_COMPLEMENTO = 'null' THEN nef.ENTREGA_LOGRADOURO ELSE concat(nef.ENTREGA_LOGRADOURO,concat(', ',nef.ENTREGA_COMPLEMENTO)) END ENTREGA_ENDERECO_COMPLETO
                   , nef.ENTREGA_BAIRRO
                   , nef.ENTREGA_CEP
                   , cep.pkg_municipio.fnc_cidade_completa(nef.ENTREGA_MUNICIPIO_ID) as municipio_entrega    
                   , nef.modalidade
                   , ptomador.razao_social as tomador
                   , ptomador.identificador as cnpj_tomador
                   , o.descricao as organizacional
                   , r.DATA_INICIO
                   , r.DATA_TERMINO
                   , to_char(r.DATA_INICIO,'dd/mm/yyyy hh:mi') as data_inicio_viagem
                   , to_char(r.DATA_TERMINO,'dd/mm/yyyy hh:mi') as data_termino_viagem
                   , un.unidade_negocio as razao_filial
                   , un.cod_unidade_negocio
                   , nef.cod_cliente_cobranca
				   , null as baixado_por
				   , null as baixado_em
				   , null as baixado_observacao
                  from oper.v$romaneio r
            inner join fiscal.v$nf_es_frete nef
                    on nef.num_romaneio = r.num_romaneio 
            inner join fiscal.v$nf_es n
                    on nef.nf_es_id = n.num_nota_id
             left join kss.v$pessoa ptomador
                    on ptomador.cod_pessoa = nef.cod_cliente_cobranca
             left join kss.v$pessoa f
                    on f.cod_pessoa = n.cod_pessoa_filial
             left join kss.v$pessoa pneg
                    on pneg.cod_pessoa = nef.cod_negociador
             left join kss.v$pessoa_fisica pMot
                    on pMot.cod_pessoa = nef.cod_motorista
             left join kss.v$pessoa_telefone_padrao ptp
                    on ptp.cod_pessoa = pMot.cod_pessoa       
             left join kss.v$centro_custo cc
                    on cc.cod_centro_custo = n.cod_centro_custo
             left join KSS.v$ORGANIZACIONAL o
                    on o.organizacional_id = nef.organizacional_id
             left join kss.v$unidade_negocio un
                    on un.cod_pessoa = n.cod_pessoa_filial
              ) t
            where 1=1
            
            <cfif len(trim( arguments.DATA_VIAGEM_INICIO )) 
				and (!len(trim( arguments.num_romaneio )) and !len(trim( arguments.num_documento )))>                
             	and t.DATA_INICIO >= to_date('#DATA_VIAGEM_INICIO# 00:00:00', 'DD/MM/YYYY HH24:MI:SS')
             </cfif>
            <cfif len(trim( arguments.DATA_VIAGEM_TERMINO )) 
				and (!len(trim( arguments.num_romaneio )) and !len(trim( arguments.num_documento )))> 
             	and t.DATA_TERMINO <= to_date('#DATA_VIAGEM_TERMINO# 23:59:59', 'DD/MM/YYYY HH24:MI:SS')
             </cfif>
             <cfif len(trim( arguments.DATA_INICIO_EMISSAO ))
				and (!len(trim( arguments.num_romaneio )) and !len(trim( arguments.num_documento ))) >
             	and t.data_emissao >= trunc(to_date('#DATA_INICIO_EMISSAO# 00:00:00'))
             </cfif>
             <cfif len(trim( arguments.DATA_FIM_EMISSAO )) 
				and (!len(trim( arguments.num_romaneio )) and !len(trim( arguments.num_documento )))>
             	and t.data_emissao < to_date('#DATA_FIM_EMISSAO# 23:59:59', 'DD/MM/YYYY HH24:MI:SS')
             </cfif>
             <cfif arguments.DOCS_VINCULADOS eq 0>
             	and t.docs_vinculados = 'No'
             </cfif>
             <cfif arguments.DOCS_VINCULADOS eq 1>
             	and t.docs_vinculados = 'Sim'
             </cfif>
             <cfif arguments.TIPO_DOCUMENTO eq 0>
             	and t.TIPO_DOCUMENTO = 'NF'
             </cfif>
             <cfif arguments.TIPO_DOCUMENTO eq 1>
             	and t.TIPO_DOCUMENTO = 'CTE'
             </cfif>
			 <cfif arguments.TIPO_DOCUMENTO eq 2>
             	and t.TIPO_DOCUMENTO = 'CTE Cancelado'
             </cfif>
			 
             <cfif len(trim( arguments.num_romaneio )) >
             	and t.num_romaneio = #arguments.NUM_ROMANEIO#
             </cfif>
             <cfif len(trim( arguments.COD_PESSOA_FILIAL )) >
             	and t.cod_pessoa_filial = #arguments.COD_PESSOA_FILIAL#
             </cfif>
             <cfif len(trim( arguments.cod_centro_custo )) >
             	and t.cod_centro_custo = #arguments.COD_CENTRO_CUSTO#
             </cfif>
             <cfif len(trim( arguments.num_documento )) >
             	and t.num_documento = #arguments.num_documento#
             </cfif> 
             <cfif len(trim( arguments.cod_cliente_cobranca )) >
             	and t.cod_cliente_cobranca = #arguments.cod_cliente_cobranca#
             </cfif>
             <cfif len(trim( arguments.cod_destinatario )) >
             	and t.cod_destinatario = #arguments.cod_destinatario#
             </cfif>
             <cfif len(trim( arguments.cod_remetente )) >
             	and t.cod_remetente = #arguments.cod_remetente#
             </cfif>
          </cfquery>
		<cfreturn qr_result>		
	</cffunction>	
    	

	<!--- 
	-- PROPSITO 
	-- Busca os valores da cg_ref_codes
	-- CRISTOFER  11/06/2007
	--->		
	<cffunction name="get_cg_ref_codes" access="remote" returntype="query" output="true">
		<cfargument name="DOMINIO" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select rv_domain dominio, 
				   rv_low_value id, 
				   rv_high_value, 
				   rv_abbreviation abreviacao, 
				   rv_meaning descricao
			  from oper.v$cg_ref_codes
			 where rv_domain = '#arguments.dominio#'
             order by rv_low_value
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>	
    
    <!--- 
	-- PROPSITO 
	-- Busca os valores da cg_ref_codes
	-- CRISTOFER  11/06/2007
	--->		
	<cffunction name="get_romaneio" access="remote" returntype="query" output="true">
		<cfargument name="NUM_ROMANEIO" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select num_romaneio,
                   carregamento,
                   destino,
                   cliente,
                   remetente,
                   destinatario,
                   to_char(data_inicio,'dd/mm/yyyy hh:mi') as data_inicio,
                   data_destinado,
                   data_termino,
                   data_previsao_descarga,
                   data_previsao_vazio,
                   data_previsao_carregado,
                   data_vazio_planejado,
                   data_carregado_planejado,
                   num_natureza,
                   num_especie,
                   cod_unidade,
                   frete_em,
                   peso_total,
                   peso_cobrado,
                   volume_total,
                   m3_total,
                   frete_liquido,
                   despacho,
                   frete_total,
                   valor_entregue,
                   km_vazio,
                   km_carregado,
                   valor_pedagio_vazio,
                   valor_pedagio_carregado,
                   valor_descarga,
                   org_logradouro,
                   org_complemento,
                   org_bairro,
                   org_cep,
                   org_municipio_id,
                   dest_logradouro,
                   dest_complemento,
                   dest_bairro,
                   dest_cep,
                   dest_municipio_id,
                   situacao_id,
                   data_inicio_carga,
                   data_termino_carga,
                   data_inicio_descarga,
                   data_termino_descarga,
                   placa_controle,
                   placa_referencia,
                   cod_pessoa_filial,
                   mensagem_motorista,
                   cod_pessoa_atraso_vazio,
                   bloquear_previsao_vazio,
                   mensagem_prev_carregado,
                   cod_pessoa_atraso_carr,
                   bloquear_previsao_carr,
                   peso_retorno,
                   cod_pessoa_responsavel,
                   muda_filial_responsavel,
                   observacao,
                   user_insert,
                   date_insert,
                   user_update,
                   site,
                   date_update,
                   situacao_viagem_id,
                   0 as  solicitacao_carga_id
              from oper.v$romaneio
			where 1=1 
            <cfif len(trim( arguments.num_romaneio )) >
            	and num_romaneio = #arguments.num_romaneio#
            </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    <cffunction name="get_solicitacao_carga" access="remote" returntype="query" output="true">
		<cfargument name="NUM_CONHECIMENTO" required="yes">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select 0 as num_romaneio,
                   sc.solicitacao_carga_id,
     			   to_char(sc.data_carregamento_inicio,'DD-MM-YYYY HH24:MI') as data_inicio,
             	   (select municipio ||'/'|| uf_id
         			    from cep.municipio where municipio_id = sc.origem_municipio_id) as carregamento,
                   (select municipio ||'/'|| uf_id
                        from cep.municipio where municipio_id = sc.destino_municipio_id) as destino,
                   conh.rem_razao_social as cliente,
                   conh.rem_razao_social as remetente,
                   conh.dest_razao_social as destinatario,
                   0 as situacao_id
              from LOGISTICA.V$SOLICITACAO_CARGA sc 
             inner join LOGISTICA.V$SOLICITACAO_CARGA_DOCUMENTO scd
                on scd.solicitacao_carga_id = sc.solicitacao_carga_id
             inner join FISCAL.v$CONHECIMENTO conh
  				on conh.conhecimento_id = scd.conhecimento_id
             where 1=1 
            <cfif len(trim( arguments.NUM_CONHECIMENTO )) >
            	and conh.num_conhecimento = #arguments.NUM_CONHECIMENTO#
            </cfif>
		</cfquery>
      
     
		<cfreturn qr_result>		
	</cffunction>
    
    
    
    
	<!--- 
	-- PROPSITO 
	-- Busca os valores da cg_ref_codes
	-- CRISTOFER  11/06/2007
	--->		
	<cffunction name="get_conhecimento" access="remote" returntype="query" output="true">
    	<cfargument name="num_conhecimento" required="no" default="">
        <cfargument name="conhecimento_id" required="no" default="">
		<cfargument name="num_romaneio" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_departamento" required="no" default="">
        <cfargument name="cod_setor" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="cod_organograma" required="no" default="">
        <cfargument name="ativo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select conhecimento_id,
                   num_conhecimento,
                   serie,
                   item_id,
                   num_romaneio,
                   cod_pessoa_filial,
                   cod_departamento,
                   cod_setor,
                   cod_centro_custo,
                   cod_organograma_gerencial,
                   organizacional_id_gerencial,
                   to_char(data_emissao,'dd/mm/yyyy hh24:mi:ss') as data_emissao,
                   prazo_entrega,
                   data_chegada,
                   data_entrega,
                   num_produto,
                   cfop_id,
                   cfop,
                   natureza_operacao,
                   st_origem_id,
                   st_icms_id,
                   pagador,
                   cod_remetente,
                   rem_razao_social,
                   rem_endereco,
                   rem_endereco_num,
                   rem_bairro,
                   rem_municipio,
                   rem_uf,
                   rem_cep,
                   rem_cnpj_cpf,
                   rem_inscricao_estadual,
                   rem_municipio_id,
                   cod_destinatario,
                   dest_razao_social,
                   dest_endereco,
                   dest_endereco_num,
                   dest_bairro,
                   dest_municipio,
                   dest_uf,
                   dest_cep,
                   dest_cnpj_cpf,
                   dest_inscricao_estadual,
                   dest_municipio_id,
                   cod_consignatario,
                   cons_razao_social,
                   cons_endereco,
                   cons_endereco_num,
                   cons_bairro,
                   cons_municipio,
                   cons_uf,
                   cons_cep,
                   cons_cnpj_cpf,
                   cons_inscricao_estadual,
                   cons_municipio_id,
                   cod_redespacho,
                   red_razao_social,
                   red_endereco,
                   red_endereco_num,
                   red_bairro,
                   red_municipio,
                   red_uf,
                   red_cep,
                   red_cnpj_cpf,
                   red_inscricao_estadual,
                   red_municipio_id,
                   cod_cliente_cobranca,
                   cob_razao_social,
                   cob_endereco,
                   cob_endereco_num,
                   cob_bairro,
                   cob_municipio,
                   cob_uf,
                   cob_cep,
                   cob_cnpj_cpf,
                   cob_inscricao_estadual,
                   cob_municipio_id,
                   cod_negociador,
                   cod_proprietario,
                   prop_cnpj_cpf,
                   prop_razao_social,
                   prop_endereco,
                   prop_uf,
                   cod_motorista,
                   nome_motorista,
                   placa_tracao,
                   placa,
                   coleta_entrega,
                   coleta_logradouro,
                   coleta_complemento,
                   coleta_bairro,
                   coleta_cep,
                   coleta_municipio_id,
                   entrega_logradouro,
                   entrega_complemento,
                   entrega_bairro,
                   entrega_cep,
                   entrega_municipio_id,
                   peso,
                   peso_real,
                   volume,
                   m3,
                   num_natureza,
                   num_especie,
                   cod_unidade,
                   frete_unitario,
                   frete_valor,
                   despacho,
                   base_calculo_icms,
                   aliquota_icms,
                   valor_icms,
                   ademe,
                   desconto,
                   impostos,
                   total_conhecimento,
                   frete_peso,
                   sec_cat,
                   gris,
                   pedagio,
                   valor_icms_substit,
                   base_calculo_iss,
                   aliquota_iss,
                   valor_iss,
                   aliquota_icms_substit,
                   valor_icms_presumido,
                   reducao_base_icms,
                   reducao_base_icms_substit,
                   base_calculo_icms_substit,
                   valor_faturamento,
                   cancelado,
                   impresso,
                   conferido,
                   conferido_por,
                   baixado_por,
                   baixado_em,
                   baixado_observacao,
                   faturado,
                   observacao,
                   rodape,
                   entrada_dados,
                   contabilizacao_id,
                   regra_fiscal_id,
                   rota_id,
                   km_rota,
                   conhecimento_id_sub_contr,
                   num_conhecimento_sub_contr,
                   serie_conhecimento_sub_contr,
                   tipo_venda,
                   data_vencimento,
                   modalidade,
                   fundamentacao_legal,
                   valor_reducao_base_icms,
                   liberado_impressao,
                   operacao_id,
                   ignora_pagamento,
                   modelo_documento,
                   tipo_servico_id,
                   coleta_cod_pessoa,
                   coleta_cnpj_cpf,
                   coleta_razao_social,
                   coleta_endereco,
                   coleta_num,
                   coleta_cod_uf,
                   coleta_inscricao_estadual,
                   coleta_municipio,
                   coleta_uf,
                   entrega_cod_pessoa,
                   entrega_cnpj_cpf,
                   entrega_razao_social,
                   entrega_endereco,
                   entrega_num,
                   entrega_cod_uf,
                   entrega_uf,
                   entrega_inscricao_estadual,
                   entrega_municipio,
                   tomador_servico_id,
                   dest_isuf,
                   lancto_id,
                   cst_id,
                   impressao_dacte,
                   status_email_remetente,
                   status_email_destinatario,
                   status_email_expedidor,
                   status_email_recebedor,
                   status_email_tomador,
                   tipo_conhecimento,
                   user_insert,
                   date_insert,
                   user_update,
                   date_update,
                   site,
                   conhecimento_tipo_id,
                   produto,
                   cod_endereco_rem,
                   cod_endereco_coleta,
                   cod_endereco_dest,
                   cod_endereco_entrega,
                   cod_endereco_cob,
                   cod_endereco_neg,
                   organizacional_id,
                   cod_organizacional,
                   ambiente_id
              from fiscal.v$conhecimento c

			 where 1=1
             <cfif len(trim( arguments.num_romaneio )) >
             	and c.num_romaneio = '#arguments.num_romaneio#'
             </cfif>
             <cfif len(trim( arguments.conhecimento_id )) >
             	and c.conhecimento_id = '#arguments.conhecimento_id#'
             </cfif>
             <cfif len(trim( arguments.num_conhecimento )) >
             	and c.num_conhecimento = '#arguments.num_conhecimento#'
             </cfif>
             <cfif len(trim( arguments.cod_pessoa_filial )) >
             	and c.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
             </cfif>
             <cfif len(trim( arguments.cod_centro_custo )) >
             	and c.cod_centro_custo = '#arguments.cod_centro_custo#'
             </cfif>
             <cfif len(trim( arguments.cod_setor )) >
             	and c.cod_setor = '#arguments.cod_setor#'
             </cfif>
             <cfif len(trim( arguments.cod_departamento )) >
             	and c.cod_departamento = '#arguments.cod_departamento#'
             </cfif>
             <cfif len(trim( arguments.ativo )) && arguments.ativo eq 1 >
             	and c.cancelado is null
             </cfif>

             order by date_insert desc
		</cfquery>
         
		<cfreturn qr_result>		
	</cffunction>
    
    <!--- 
	-- PROPSITO 
	-- Busca as notas fiscais do conhecimento
	-- CRISTOFER  06/12/2006
	--->		
	<cffunction name="get_conhecimento_nota_fiscal" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select cnf.conhecimento_id,
				   cnf.numero,
				   to_char(cnf.data_emissao,'dd/mm/yyyy') as data_emissao,
				   to_char(cnf.data_emissao,'dd/mm/yyyy') data_emissao_data,
				   cnf.modelo,
				   cnf.serie,
				   cnf.sub_serie,
				   cnf.valor_total,
				   cnf.user_insert,
				   cnf.date_insert,
				   cnf.user_update,
				   cnf.date_update,
				   cnf.site,
				   cnf.valor_segurado,
				   cnf.ordem_compra_cliente,
				   cnf.peso,
				   to_char(fiscal.pkg_fiscal.fnc_converte_peso(cnf.peso,cnf.cod_unidade,'Kg')) peso_kg_convertido,
				   cnf.peso_cubado,
				   cnf.peso_cobrado,
				   cnf.qtde_volume,
				   cnf.altura,
				   cnf.comprimento,
				   cnf.largura,
				   cnf.m3,
				   cnf.cubagem,
				   cnf.num_natureza,
				   nat.descricao natureza,
				   cnf.complemento,
				   cnf.num_especie,
                   cnf.tipo_documento_id,
                   cnf.cfop,
				   esp.descricao especie,
				   cnf.cod_unidade,
				   cnf.premio_seguro_rctrc,
				   cnf.premio_seguro_rcfdc,
				   cnf.premio_seguro_rr,
                   (select cc.carga_id
                      from oper.v$carga_ctrc cc
                     where cc.conhecimento_id = cnf.conhecimento_id
                       and cc.num_nota_id = cnf.numero) as carga_id 
			  from fiscal.v$conhecimento_nota_fiscal cnf
			  left join oper.v$especie esp
					 on esp.num_especie = cnf.num_especie
			  left join oper.v$natureza nat
					 on nat.num_natureza = cnf.num_natureza
			 where 1=1
			   and cnf.conhecimento_id = #arguments.conhecimento_id#
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
    
    <!--- 
	-- PROPSITO 
	-- Busca as notas fiscais do conhecimento
	-- CRISTOFER  06/12/2006
	--->		
	<cffunction name="get_contrato_transporte" access="remote" returntype="query" output="true">
		<cfargument name="conhecimento_id" required="no" default="">
        <cfargument name="num_romaneio" required="no" default="">
        <cfargument name="num_formulario" required="no" default="">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_setor" required="no" default="">
        <cfargument name="cod_departamento" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select lancto_id,
                   num_formulario,
                   serie_formulario,
                   tipo_contrato,
                   cod_pessoa_filial,
                   cod_departamento,
                   cod_setor,
                   cod_centro_custo,
                   data_emissao,
                   peso,
                   volume,
                   m3,
                   frete_em,
                   cod_unidade,
                   tolerancia_falta,
                   valor_unitario,
                   valor_frete_bruto,
                   valor_frete_liquido,
                   parcela,
                   total_parcela,
                   valor_parcelamento,
                   lancto_id_pai,
                   num_romaneio,
                   motorista_cod_pessoa,
                   placa_controle,
                   placa_referencia,
                   proprietario_cod_pessoa,
                   proprietario_endereco,
                   proprietario_municipio_id,
                   proprietario_nit,
                   num_rpa,
                   rpa_id,
                   impresso,
                   observacao,
                   cod_modelo,
                   data_cancelamento,
                   usuario_cancelamento,
                   motivo_cancelamento,
                   cod_remetente,
                   cod_destinatario,
                   modalidade_veiculo,
                   operacao_id,
                   tabela_frete_rota_id,
                   avulsa,
                   conhecimento_id,
                   conhecimento_id_diaria,
                   crt_id_diaria,
                   usuario_liberacao,
                   senha_liberacao,
                   data_liberacao,
                   percentual_receita,
                   organizacional_id,
                   cod_organizacional,
                   valor_maximo_tabela_frete,
                   internacional,
                   user_insert,
                   date_insert,
                   user_update,
                   date_update,
                   site
              from oper.v$contrato_transp ct

			 where 1=1
             <cfif len(trim(arguments.num_romaneio)) >
			   and ct.num_romaneio = #arguments.num_romaneio#
             </cfif>
             <cfif len(trim(arguments.lancto_id)) >
			   and ct.lancto_id = #arguments.lancto_id#
             </cfif>
             <cfif len(trim(arguments.num_formulario)) >
			   and ct.num_formulario = #arguments.num_formulario#
             </cfif>
             <cfif len(trim( arguments.cod_pessoa_filial )) >
             	and ct.cod_pessoa_filial = '#arguments.cod_pessoa_filial#'
             </cfif>
             <cfif len(trim( arguments.cod_centro_custo )) >
             	and ct.cod_centro_custo = '#arguments.cod_centro_custo#'
             </cfif>
             <cfif len(trim( arguments.cod_setor )) >
             	and ct.cod_setor = '#arguments.cod_setor#'
             </cfif>
             <cfif len(trim( arguments.cod_departamento )) >
             	and ct.cod_departamento = '#arguments.cod_departamento#'
             </cfif>
		</cfquery>
		<cfreturn qr_result>		
	</cffunction>
    
    
</cfcomponent>
