<cfscript>
	conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
	qrSub  	= conn.get_sub_serie_nota(documento_proprio = 0
									 ,carga_transportada = 1);
	
	conn = CreateComponent("_transportes.consulta.cfc_global");
	qrTipoDocumentos = conn.get_cg_ref_codes(owner = 'FISCAL', rv_domain = 'CONHECIMENTO_NOTA_FISCAL.TIPO_DOCUMENTO_ID');
	qrTipoDocOutros = conn.get_cg_ref_codes(owner = 'FISCAL', rv_domain = 'CONHECIMENTO_NOTA_FISCAL.TIPO_DOC_OUTROS');
</cfscript>
<cfparam name="vars.AVON" default="0">
<script>

setReadOnly['NOTAS_FISCAIS'] = function(value) {
		with(document.forms[0]) {
			<cfif isdefined("vars.subcontratado") and vars.subcontratado eq 1>			
				document.getElementById('tr_lista_botoes_NOTAS_FISCAIS').style.display = value?'none':'';
			</cfif>
			NOTA_NUMERO.readOnly		= value;
			NOTA_SERIE.disabled			= value;
			NOTA_SUB_SERIE.disabled		= value;
			NOTA_MODELO.disabled		= value;
			NOTA_DATA_EMISSAO.readOnly	= value;
			NOTA_VALOR.readOnly			= value;
			NOTA_VALOR_SEGURADO.readOnly= value;
			NOTA_ORDEM_COMPRA.readOnly	= value;
			NOTA_QTDE_VOLUME.readOnly	= value;
			NOTA_PESO.readOnly			= value;
			NOTA_COD_UNIDADE.disabled	= value;
			NOTA_M3.readOnly			= value;
			NOTA_PESO_CUBADO.readOnly	= value;
			NOTA_NUM_NATUREZA.readOnly	= value;
			NOTA_COMPLEMENTO.readOnly	= value;
			NOTA_NUM_ESPECIE.readOnly	= value;
			NOTA_ALTURA.readOnly		= value;
			NOTA_LARGURA.readOnly		= value;
			NOTA_COMPRIMENTO.readOnly	= value;
			NOTA_PESO_COBRADO.readOnly	= value;
			PEDIDO_SHIPMENT.readOnly	= value;
			
			document.getElementById('btn_pedido_shipment').disabled = value;
			document.getElementById('btn_pedido_shipment_sem_preenchimento').disabled = value;
		}
	}

setReadOnly['NOTA_MERCADORIA'] = function(value) {
		with(document.forms[0]) {
			PEDIDO_SHIPMENT.readOnly	= value;			
			document.getElementById('btn_pedido_shipment').disabled = value;

			// nota
			document.getElementById('tr_lista_botoes_NOTAS_FISCAIS').style.display = value?'none':'';
			NOTA_NUMERO.readOnly		= value;
			NOTA_SERIE.disabled			= value;
			NOTA_SUB_SERIE.disabled		= value;
			NOTA_MODELO.disabled		= value;
			NOTA_DATA_EMISSAO.readOnly	= value;
			NOTA_VALOR.readOnly			= value;
			NOTA_VALOR_SEGURADO.readOnly= value;
			NOTA_CFOP.readOnly			= value;
			NOTA_ORDEM_COMPRA.readOnly	= value;
			NOTA_QTDE_VOLUME.readOnly	= value;
			NOTA_PESO.readOnly			= value;
			NOTA_COD_UNIDADE.disabled	= value;
			NOTA_M3.readOnly			= value;
			NOTA_PESO_CUBADO.readOnly	= value;
			NOTA_NUM_NATUREZA.readOnly	= value;
			NOTA_COMPLEMENTO.readOnly	= value;
			NOTA_NUM_ESPECIE.readOnly	= value;
			NOTA_ALTURA.readOnly		= value;
			NOTA_LARGURA.readOnly		= value;
			NOTA_COMPRIMENTO.readOnly	= value;
			NOTA_PESO_COBRADO.readOnly	= value;
			
			//nfe
			document.getElementById('tr_lista_botoes_NFE').style.display = value?'none':'';
			CHAVE_ACESSO_NFE.readOnly	= value;
			PIN_SUFRAMA_NFE.readOnly	= value;
			NFE_VALOR.readOnly			= value;
			NFE_VALOR_SEGURADO.readOnly	= value;
			DATA_EMISSAO_NFE.readOnly	= value;
			NUMERO_NFE.readOnly			= value;
			MODELO_NFE.disabled			= value;
			SERIE_NFE.disabled			= value;
			NFE_CFOP.disabled			= value;
			NFE_ORDEM_COMPRA.readOnly	= value;			
			NFE_QTDE_VOLUME.readOnly	= value;
			NFE_PESO.readOnly			= value;
			NFE_COD_UNIDADE.disabled	= value;
			NFE_M3.readOnly				= value;
			NFE_PESO_CUBADO.readOnly	= value;
			NFE_NUM_NATUREZA.readOnly	= value;
			NFE_COMPLEMENTO.readOnly	= value;
			NFE_NUM_ESPECIE.readOnly	= value;
			NFE_ALTURA.readOnly			= value;
			NFE_LARGURA.readOnly		= value;
			NFE_COMPRIMENTO.readOnly	= value;
			NFE_PESO_COBRADO.readOnly	= value;
			
			//outros
			document.getElementById('tr_lista_botoes_OUTROS').style.display = value?'none':'';
			OUTROS_NUMERO.readOnly			= value;
			OUTROS_DATA_EMISSAO.readOnly	= value;
			OUTROS_VALOR.readOnly			= value;
			OUTROS_VALOR_SEGURADO.readOnly	= value;
			OUTROS_DESCRICAO.readOnly		= value;
			OUTROS_ORDEM_COMPRA.readOnly	= value;
			OUTROS_QTDE_VOLUME.readOnly		= value;
			OUTROS_PESO.readOnly			= value;
			OUTROS_COD_UNIDADE.disabled		= value;
			OUTROS_M3.readOnly				= value;
			OUTROS_PESO_CUBADO.readOnly		= value;
			OUTROS_NUM_NATUREZA.readOnly	= value;
			OUTROS_COMPLEMENTO.readOnly		= value;
			OUTROS_NUM_ESPECIE.readOnly		= value;
			OUTROS_ALTURA.readOnly			= value;
			OUTROS_LARGURA.readOnly			= value;
			OUTROS_COMPRIMENTO.readOnly		= value;
			OUTROS_PESO_COBRADO.readOnly	= value;
        }
	}

setReadOnly['NOTAS_ANULACAO'] = function(value) {
   with(document.forms[0]) {
      CHAVE_ACESSO_NFE.readOnly	= value;
      PIN_SUFRAMA_NFE.readOnly	= value;
      NFE_VALOR.readOnly			= value;
      NFE_VALOR_SEGURADO.readOnly= value;
      DATA_EMISSAO_NFE.readOnly	= value;
      NUMERO_NFE.readOnly			= value;
      MODELO_NFE.disabled			= value;
      SERIE_NFE.disabled			= value;
      NFE_CFOP.disabled			   = value;
      NFE_ORDEM_COMPRA.readOnly	= value;
      NFE_COMPLEMENTO.readOnly	= value;
      
      document.getElementById('btn_pedido_shipment').disabled = value;
      document.getElementById('btn_pedido_shipment_sem_preenchimento').disabled = value;
   }
}

function f_busca_natureza(p_nome) {
	with(document.forms[0]) {
		if(POPULANDO_DADOS.value == 1){
		   return;
		}
		
		if (!v_edicao){
			if(document.getElementById(p_nome+'_NUM_NATUREZA').value){
				document.getElementById(p_nome+'_NATUREZA').value = 'Aguarde, consultando...';
				f_query_wddx('/modulos/cte/_componentes/consulta/cfc_emissao_documentos.cfc?method=get_natureza'
							,'num_natureza='+document.getElementById(p_nome+'_NUM_NATUREZA').value+'&operacao_id='+ OPERACAO_ID_CTRC.value
							,function(obj){
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200){
									if(obj.struct.num_natureza.length == 1){
										document.getElementById(p_nome+'_NATUREZA').value = obj.struct.descricao[0];
									}else{
										document.getElementById(p_nome+'_NATUREZA').value = '';
										alert('Natureza no encontrada ou no permitida para esta Operao Logstica.');
									}
								}
							});
			}else{
				document.getElementById(p_nome+'_NATUREZA').value = '';
			}
		}
	}
}

function f_busca_especie(p_nome) {
	with(document.forms[0]) {
		if(POPULANDO_DADOS.value == 1){
		   return;
		}
		
		if (!v_edicao){
			if(document.getElementById(p_nome+'_NUM_ESPECIE').value){
				document.getElementById(p_nome+'_ESPECIE').value = 'Aguarde, consultando...';
				f_query_wddx('/modulos/cte/_componentes/consulta/cfc_emissao_documentos.cfc?method=get_especie'
							,'num_especie='+document.getElementById(p_nome+'_NUM_ESPECIE').value
							,function(obj){
								if(obj.ajax.readyState == 4 && obj.ajax.status == 200){
									if(obj.struct.num_especie.length > 0){
										document.getElementById(p_nome+'_ESPECIE').value = obj.struct.descricao[0];
									}else{
										document.getElementById(p_nome+'_ESPECIE').value = '';
										alert('Espcie no encontrada.');
									}
								}
							});
			}else{
				document.getElementById(p_nome+'_ESPECIE').value = '';
			}
		}
	}
}


</script>
<script language="javascript1.2">
	v_modelo = [];
	<cfoutput query="qrSub" group="cod_modelo">
	v_modelo.push('#qrSub.cod_modelo#');
	</cfoutput>
	v_serie1 = [];
	<cfoutput query="qrSub" group="cod_modelo">
	<cfoutput group="serie">
	v_serie1.push({cod_modelo: '#qrSub.cod_modelo#',serie: '#qrSub.serie#' });
	</cfoutput>
	</cfoutput>
	v_sub_serie1 = [];
	<cfoutput query="qrSub">
	v_sub_serie1.push({cod_modelo: '#qrSub.cod_modelo#',serie: '#qrSub.serie#',sub_serie: '#qrSub.subserie#'});
	</cfoutput>
	function f_busca_serie_nota() {
		with(document.forms[0]) {
		<cfif v_nf_serie_liberada eq 1>
			v_c = 0;
			v_serie = '';
			NOTA_SERIE.value = '';
			for(var i=0;i<v_serie1.length;i++) {
				if(v_serie1[i].cod_modelo == NOTA_MODELO.value) {
					v_serie_sel = v_serie1[i].serie;
					v_c++;
				}
			}
			if(v_c == 1) {
				NOTA_SERIE.value = v_serie_sel;
			}
			f_busca_sub_serie_nota();
		<cfelse>
			f_limpa_select(NOTA_SERIE);
			if(NOTA_MODELO.value == '') {
				f_cria_option('','--',NOTA_SERIE);
				return;
			}
			v_brc = f_cria_option('','--',NOTA_SERIE);
			v_c = 0;
			for(var i=0;i<v_serie1.length;i++) {
				if(v_serie1[i].cod_modelo == NOTA_MODELO.value) {
					f_cria_option(v_serie1[i].serie, v_serie1[i].serie,NOTA_SERIE);
					v_c++;
				}
			}
			if(v_c == 1) {
				v_brc.removeNode(true);
				f_busca_sub_serie_nota();
			}
		</cfif>
		}
	}
	function f_busca_sub_serie_nota() {
		with(document.forms[0]) {
		<cfif v_nf_serie_liberada eq 1>
			NOTA_SUB_SERIE.value = '';
			v_c = 0;
			v_subserie_sel = '';
			for(var i=0;i<v_serie1.length;i++) {
				if(v_sub_serie1[i].serie == NOTA_SERIE.value && v_sub_serie1[i].cod_modelo == NOTA_MODELO.value) {
					v_sub_serie_sel = v_sub_serie1[i].sub_serie;
					v_c++;
				}
			}
			if(v_c == 1) {
				NOTA_SUB_SERIE.value = v_sub_serie_sel;
			}
			
		<cfelse>
			f_limpa_select(NOTA_SUB_SERIE);
			if(NOTA_SERIE.value == '') {
				f_cria_option('','--',NOTA_SUB_SERIE);
				return;
			}
			v_brc1 = f_cria_option('','--',NOTA_SUB_SERIE);
			v_c = 0;
			for(var i=0;i<v_serie1.length;i++) {
				if(v_sub_serie1[i].serie == NOTA_SERIE.value && v_sub_serie1[i].cod_modelo == NOTA_MODELO.value) {
					f_cria_option(v_sub_serie1[i].sub_serie, v_sub_serie1[i].sub_serie,NOTA_SUB_SERIE);
					v_c++;
				}
			}
			if(v_c == 1) {
				NOTA_SUB_SERIE.options[0] = null;
			}
		</cfif>
		}
	}
	
	function f_calcula_peso_cobrado(p_nome) {
		with(document.forms[0]){
			var p_nome = p_nome ? p_nome : 'NOTA';
			if(Number(document.getElementById(p_nome+'_PESO_KG_CONVERTIDO').value) > Number(document.getElementById(p_nome+'_CUBAGEM').value)){
				document.getElementById(p_nome+'_PESO_COBRADO').value = document.getElementById(p_nome+'_PESO_KG_CONVERTIDO').value; 
			}else{
				document.getElementById(p_nome+'_PESO_COBRADO').value = document.getElementById(p_nome+'_CUBAGEM').value;
			}
		}
	}

	function f_calcula_peso_kg(p_nome) {
		with(document.forms[0]) {
			var p_nome = p_nome ? p_nome : 'NOTA';
			document.getElementById(p_nome+'_PESO_KG_CONVERTIDO').value = '';
			if(document.getElementById(p_nome+'_PESO').value == '' || document.getElementById(p_nome+'_COD_UNIDADE').value == '') {
				return;
			}
			f_query_wddx('/modulos/cte/_componentes/consulta/cfc_logistico.cfc?method=converte_unidade'
						,'valor='+document.getElementById(p_nome+'_PESO').value+'&unidade_origem='+document.getElementById(p_nome+'_COD_UNIDADE').value+'&unidade_destino=KG'
						,function (obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								with(document.forms[0]) {
									document.getElementById(p_nome+'_PESO_KG_CONVERTIDO').value = toCurrency(obj.struct);
									f_calcula_peso_cobrado(p_nome);
								}
							}
						})	
		}
	}
	function f_calcula_cubagem(p_nome){		
		with(document.forms[0]){
			var p_nome = p_nome ? p_nome : 'NOTA';
			var v_calcula_peso_cobrado = v_inserida == 0;
			
			if(document.getElementById(p_nome+'_ALTURA').value != null &&  document.getElementById(p_nome+'_LARGURA').value != null && document.getElementById(p_nome+'_COMPRIMENTO').value != null){
				if (v_calcula_peso_cobrado){
					document.getElementById(p_nome+'_M3').value = toCurrency(Number(document.getElementById(p_nome+'_ALTURA').value * document.getElementById(p_nome+'_LARGURA').value * document.getElementById(p_nome+'_COMPRIMENTO').value * document.getElementById(p_nome+'_QTDE_VOLUME').value));
					document.getElementById(p_nome+'_CUBAGEM_SUGERIDA').value = toCurrency(Number(document.getElementById('COEFICIENTE_CUBAGEM').value * document.getElementById(p_nome+'_M3').value));
					document.getElementById(p_nome+'_CUBAGEM').value = document.getElementById(p_nome+'_CUBAGEM_SUGERIDA').value;
					document.getElementById(p_nome+'_PESO_CUBADO').value = Number(document.getElementById(p_nome+'_ALTURA').value * document.getElementById(p_nome+'_LARGURA').value * document.getElementById(p_nome+'_COMPRIMENTO').value * document.getElementById(p_nome+'_QTDE_VOLUME').value);
				}
				
				if (document.getElementById(p_nome+'_PESO_CUBADO').value == ''){
				   document.getElementById(p_nome+'_PESO_CUBADO').value = document.getElementById(p_nome+'_CUBAGEM').value;
				}				
				
			}
		}
		if (v_calcula_peso_cobrado){
			f_calcula_peso_cobrado(p_nome);
		}
	}
	
	function f_muda_tipo_documento(){
		with(document.forms[0]) {
			//Verifica se no possui ennhum documento
			v_total_nf = f_listagem_NOTAS_FISCAIS();
			v_total_nfe = f_listagem_NFE();
			v_total_outros = f_listagem_OUTROS();
			
			if( (Number(v_total_nf.length) + Number(v_total_nfe.length) + Number(v_total_outros.length) ) > 0){
				alert('Para alternar para outro tipo de documento , os documentos inseridos atualmente devem ser excluidos.');
				
				if(Number(v_total_nf.length)){
					TIPO_DOCUMENTO_ID.value = 0;
				}
				
				if(Number(v_total_nfe.length)){
					TIPO_DOCUMENTO_ID.value = 1;
				}
				
				if(Number(v_total_outros.length)){
					TIPO_DOCUMENTO_ID.value = 2;
				}
				
				return;
			}
			
			switch (Number(TIPO_DOCUMENTO_ID.value)){
				case 0:
					//habilita o fieldset especifico
					document.getElementById('tb_nota_fiscal').style.display = '';
					document.getElementById('tb_nota_fiscal').disabled = 0;
					
					
					//desabilita os outros fieldsets
					document.getElementById('fs_nfe').style.display = 'none';
					document.getElementById('fs_nfe').disabled = 1;
					document.getElementById('td_nfe').style.display = 'none';
					document.getElementById('td_nfe').disabled = 1;
					
					document.getElementById('fs_outros').style.display = 'none';
					document.getElementById('fs_outros').disabled = 1;
					break;
				case 1:
					//habilita o fieldset especifico
					document.getElementById('fs_nfe').style.display = '';
					document.getElementById('fs_nfe').disabled = 0;
					document.getElementById('td_nfe').style.display = '';
					document.getElementById('td_nfe').disabled = 0;
					
					//desabilita os outros fieldsets
					document.getElementById('tb_nota_fiscal').style.display = 'none';
					document.getElementById('tb_nota_fiscal').disabled = 1;
					document.getElementById('fs_outros').style.display = 'none';
					document.getElementById('fs_outros').disabled = 1;
					break;
				case 2:
					//habilita o fieldset especifico
					document.getElementById('fs_outros').style.display = '';
					document.getElementById('fs_outros').disabled = 0;
					
					//desabilita os outros fieldsets
					document.getElementById('fs_nfe').style.display = 'none';
					document.getElementById('fs_nfe').disabled = 1;
					document.getElementById('td_nfe').style.display = 'none';
					document.getElementById('td_nfe').disabled = 1;
					document.getElementById('tb_nota_fiscal').style.display = 'none';
					document.getElementById('tb_nota_fiscal').disabled = 1;
					break;
				case 3:
					//habilita o fieldset especifico
					document.getElementById('fs_outros').style.display = '';
					document.getElementById('fs_outros').disabled = 0;
					
					//desabilita os outros fieldsets
					document.getElementById('fs_nfe').style.display = 'none';
					document.getElementById('fs_nfe').disabled = 1;
					document.getElementById('td_nfe').style.display = 'none';
					document.getElementById('td_nfe').disabled = 1;
					document.getElementById('tb_nota_fiscal').style.display = 'none';
					document.getElementById('tb_nota_fiscal').disabled = 1;
					break;
				default:
					
			}
		}
	}
	
	function f_busca_dados_nfe() {
			with(document.forms[0]) {
			if(ARQUIVO.value){
				var v_nome_arquivo = ARQUIVO.value;
				var v_extensao = v_nome_arquivo.substr(v_nome_arquivo.lastIndexOf('.'));
				
				if(v_extensao != '.xml' && v_extensao != '.XML'){
					document.getElementById('td_nfe').innerHTML = document.getElementById('td_nfe').innerHTML;
					alert('O arquivo selecionado deve ser um XML.');
					return false;					
				}
				
				OPERACAO.value = 10;
				target = 'consultas';
				action = 'confirma.cfm';
				submit();
			}
		}
	}
	
	function f_busca_dados_chave_nfe(){
		with(document.forms[0]) {
		   MODELO_NFE.readOnly = false;
		   NUMERO_NFE.readOnly = false;
		   SERIE_NFE.readOnly = false;

			if(CHAVE_ACESSO_NFE.value){
				if( isNaN(CHAVE_ACESSO_NFE.value)){
					alert('Preencha somente os nmeros da chave.');
					return false;
				}
				f_validar_chave_nfe();
				
				if(BUSCA_POR_CHAVE.value == 1) {
				   f_localizar_nfe_chave();
				}
				   v_chave = CHAVE_ACESSO_NFE.value.toString();
				   MODELO_NFE.value = Number(v_chave.substr(20,2));
				   NUMERO_NFE.value = Number(v_chave.substr(25,9));
				   SERIE_NFE.value = Number(v_chave.substr(22,3));
				   NFE_ORDEM_COMPRA.value = PEDIDO_SHIPMENT_SOLICITACAO.value;

				   MODELO_NFE.readOnly = true;
				   NUMERO_NFE.readOnly = true;
				   SERIE_NFE.readOnly = true;
			}
		}
			
	}
	
	function f_controla_tipo_docto_frete(){	
		with(document.forms[0]){
			if(TIPO_DOCTO_FRETE.value == ''){
				TIPO_DOCUMENTO_ID.disabled = '';
			}else{
				TIPO_DOCUMENTO_ID.value = TIPO_DOCTO_FRETE.value;
				f_muda_tipo_documento();
				TIPO_DOCUMENTO_ID.disabled = 'disabled';	
			}
		}
	}
	
	function f_pedido_shipment_obrigatorio(v_obrigatorio){
		v_class = v_obrigatorio == 1 ? 'requerido_form' : '';
		v_nota = document.getElementById('NOTA_ORDEM_COMPRA');
		v_nfe = document.getElementById('NFE_ORDEM_COMPRA');
		v_outros = document.getElementById('OUTROS_ORDEM_COMPRA');
		
		v_nota.setAttribute('obrigatorio',v_obrigatorio);
		v_nfe.setAttribute('obrigatorio',v_obrigatorio);
		v_outros.setAttribute('obrigatorio',v_obrigatorio);
		v_nota.className = v_class;
		v_nfe.className  = v_class;
		v_outros.className  = v_class;
	}

	function f_pedido_shipment_edicao(v_permite_editar){
		v_bool = v_permite_editar == 0 ? true : false;
		
		//Ajuste para registro de CT-e
		if (document.getElementById('ABERTO').value == 1){
		   v_bool = false;
		}

		document.getElementById('NOTA_ORDEM_COMPRA').readOnly	= v_bool;
		document.getElementById('NFE_ORDEM_COMPRA').readOnly	= v_bool;
		document.getElementById('OUTROS_ORDEM_COMPRA').readOnly = v_bool;
		
		document.getElementById('btn_pedido_shipment').disabled                   = v_bool;
		document.getElementById('btn_pedido_shipment_sem_preenchimento').disabled = v_bool;
	}

	parent.f_busca_dados_chave_nfe = f_busca_dados_chave_nfe;	

	function f_get_nfe_cfop_obrigatorio(){
		with(document.forms[0]){
			<cfset retorno = "#v_nfe_cfop_obrigatorio#">
			 <cfoutput>
				var #toScript(retorno, "js_v_nfe_cfop_obrigatorio")#;
			 </cfoutput>
			return js_v_nfe_cfop_obrigatorio;
		}
	}

	function f_preenche_constantes_cfop_mercadoria(){
		var v_maior_valor = -0.001;
		with(document.forms[0]){
			//Notas Fiscais
			var v_valor_nfoc;
			v_nfs  = f_listagem_NOTAS_FISCAIS();
			for(i=0; i<v_nfs.length; i++){
				v_valor_nfoc = document.getElementById('NOTA_VALOR_NOTAS_FISCAIS_' + v_nfs[i].id);
				NFE_ICMS_PARTILHADO.value = 0;
				if (v_valor_nfoc.value > v_maior_valor){
					v_maior_valor = v_valor_nfoc.value;
					MERCADORIA_TRANSPORTADA.value = document.getElementById('NOTA_NUM_NATUREZA_NOTAS_FISCAIS_' + v_nfs[i].id).value;
					CFOP_TRANSPORTADO.value = document.getElementById('NOTA_CFOP_NOTAS_FISCAIS_' + v_nfs[i].id).value;
				}
			}

			//NFe
			var v_valor_nfeoc;
			v_nfes = f_listagem_NFE();
			NFE_ICMS_PARTILHADO.value = 0;
			for(i=0; i<v_nfes.length; i++){
				v_valor_nfeoc = document.getElementById('NFE_VALOR_NFE_' + v_nfes[i].id);
				if (v_valor_nfeoc.value > v_maior_valor){
					v_maior_valor = v_valor_nfeoc.value;
					MERCADORIA_TRANSPORTADA.value = document.getElementById('NFE_NUM_NATUREZA_NFE_' + v_nfes[i].id).value;
					CFOP_TRANSPORTADO.value = document.getElementById('NFE_CFOP_NFE_' + v_nfes[i].id).value;
				}
				if (document.getElementById('ICMS_PARTILHADO_NFE_' + v_nfes[i].id).value == 1) {
				   NFE_ICMS_PARTILHADO.value = 1;
				}
			}

			//Outros
			var v_valor_outrosoc;
			v_outros = f_listagem_OUTROS();
			for(i=0; i<v_outros.length; i++){
				v_valor_outrosoc = document.getElementById('OUTROS_VALOR_OUTROS_' + v_outros[i].id)
				NFE_ICMS_PARTILHADO.value = 0;
				if (v_valor_outrosoc.value > v_maior_valor){
					v_maior_valor = v_valor_outrosoc.value;
					MERCADORIA_TRANSPORTADA.value = document.getElementById('OUTROS_NUM_NATUREZA_OUTROS_' + v_outros[i].id).value;
      				CFOP_TRANSPORTADO.value = '';
				}
			}
		}
		return true;
	}
	
	/*Valida se  obrigatorio o preenchimento do campo pedido/shipment
	  das notas ficais e se o campo est preenchido */
function f_valida_notas_fiscais_ps(){
		v_notas = Array();
		
		if(document.getElementById("TIPO_DOCUMENTO_ID").value == 0){
			v_nfoc = document.getElementById('NOTA_ORDEM_COMPRA');
			if(v_nfoc.getAttribute('obrigatorio') == 1){
				v_nfs  = f_listagem_NOTAS_FISCAIS();
				for(i=0; i<v_nfs.length; i++){
					if(v_nfs[i].NOTA_ORDEM_COMPRA == '')
						v_notas.push(v_nfs[i].NOTA_NUMERO);
				}
			}
		}
		
		if(document.getElementById("TIPO_DOCUMENTO_ID").value == 1){
			v_nfeoc = document.getElementById('NFE_ORDEM_COMPRA');
			if(v_nfeoc.getAttribute('obrigatorio') == 1){
				v_nfes = f_listagem_NFE();
				
				for(i=0; i<v_nfes.length; i++){
					if(v_nfes[i].NFE_ORDEM_COMPRA == '')
						v_notas.push(v_nfes[i].NUMERO_NFE);
				}
			}
		}
		
		if(document.getElementById("TIPO_DOCUMENTO_ID").value == 2	){
			v_nfooc = document.getElementById('OUTROS_ORDEM_COMPRA');
			if(v_nfooc.getAttribute('obrigatorio') == 1){
				v_nfos = f_listagem_OUTROS();
				
				for(i=0; i<v_nfos.length; i++){
					if(v_nfos[i].OUTROS_ORDEM_COMPRA == '')
						v_notas.push(v_nfos[i].OUTROS_NUMERO);
				}
			}
		}		
		
		if(v_notas.length == 1){
			alert('A nota fiscal '+v_notas+' no possui valor informado no campo PEDIDO/SHIPMENT,  necessrio seu preenchimento para prosseguir.');
			return false;
		}else if(v_notas.length > 1){
			alert('As notas fiscais '+v_notas.join(',')+' no possuem valor informado no campo PEDIDO/SHIPMENT,  necessrio seu preenchimento para prosseguir.');
			return false;
		}else
			return true;
		
	}
	
	function f_replica_pedido_shipment(p_todos){
		with(document.forms[0]){
			if(PEDIDO_SHIPMENT.value == ''){
				alert('Para replicar um valor de Pedido/Shipment a todos os documentos o campo deve estar com um valor preenchido.');
				return false;
			}
			//contador
			var v_count = 0;
			
			//Notas Fiscais
			var v_nfoc;
			v_nfs  = f_listagem_NOTAS_FISCAIS();
			for(i=0; i<v_nfs.length; i++){
				v_nfoc = document.getElementById('NOTA_ORDEM_COMPRA_NOTAS_FISCAIS_' + v_nfs[i].id)
				if (v_nfoc.value == '' || p_todos == '1'){
					v_nfoc.value = PEDIDO_SHIPMENT.value;
					v_count++;
				}
			}
			
			//NFe
			var v_nfeoc;
			v_nfes = f_listagem_NFE();
			for(i=0; i<v_nfes.length; i++){
				v_nfeoc = document.getElementById('NFE_ORDEM_COMPRA_NFE_' + v_nfes[i].id)
				if (v_nfeoc.value == '' || p_todos == '1'){
					v_nfeoc.value = PEDIDO_SHIPMENT.value;
					v_count++;
				}
			}
			
			//Outros
			var v_outrosoc;
			v_outros = f_listagem_OUTROS();
			for(i=0; i<v_outros.length; i++){
				v_outrosoc = document.getElementById('OUTROS_ORDEM_COMPRA_OUTROS_' + v_outros[i].id)
				if (v_outrosoc.value == '' || p_todos == '1'){
					v_outrosoc.value = PEDIDO_SHIPMENT.value;
					v_count++;
				}
			}
			
			if(v_count++ == 0){
				alert('Nenhum documento teve o valor do Pedido/Shipment atualizado.');
			}else{
				if (p_todos == '1'){
					alert('Tdos os documentos foram atualizados para o valor do Pedido/Shipment da Viagem.');
				}else{
				alert('Os documentos que no continham valor Pedido/Shipment foram atualizados para o valor do Pedido/Shipment da Viagem.');
			}
		}
	}
	}
	
	function f_localizar_nfe(){
		with(document.forms[0]){
			if(DEST_CNPJ_CPF.value == '' || REM_CNPJ_CPF.value == '' || (OPERACAO_ID.value == '' && OPERACAO_ID_CTRC.value == '')){
				alert("Para localizar NF-e's integradas o Remetente e o Destinatrio devem estar preenchidos.");
				return false;
			}
			
			<cfif vars.AVON eq 1>
			   f_abrir_janela('<cf_url>/modulos/cte/emitir/localizar_nfe.cfm</cf_url>?cpf_cnpj_destinatario='+DEST_CNPJ_CPF.value+'&cpf_cnpj_emitente='+REM_CNPJ_CPF.value +'&placa='+PLACA_CONTROLE.value +'&operacao_id='+ nvl(OPERACAO_ID.value,OPERACAO_ID_CTRC.value) +'&num_manifesto='+MANIFESTO_NUMERO.value, 'f_atualizar()', 800, 600, true)
			<cfelse>
			   f_abrir_janela('<cf_url>/modulos/cte/emitir/localizar_nfe.cfm</cf_url>?cpf_cnpj_destinatario='+DEST_CNPJ_CPF.value+'&cpf_cnpj_emitente='+REM_CNPJ_CPF.value +'&placa='+PLACA_CONTROLE.value +'&operacao_id='+ nvl(OPERACAO_ID.value,OPERACAO_ID_CTRC.value), 'f_atualizar()', 800, 600, true)
			</cfif>
		}
	}
	
	function f_localizar_nfe_chave(){
		with(document.forms[0]){
			var v_aux = 'chave='+CHAVE_ACESSO_NFE.value;
			f_busca_info_nfe(v_aux, NUM_NATUREZA.value, '','');
		}
	}
	
	function f_insere_nfe_integrada(p_documento_id, p_num_natureza, p_natureza, p_pedido_shippment){
		with(document.forms[0]) {
			DOCUMENTO_ID.value = p_documento_id;

			if(!DOCUMENTO_ID.value) {
				return;
			}
			
			var v_aux ='documento_id=' + DOCUMENTO_ID.value;
			f_busca_info_nfe(v_aux, p_num_natureza, p_natureza, p_pedido_shippment);
						
			v_inserida = 0;
			BUSCA_POR_CHAVE.value = 1;
		}
	}	
	
	function f_busca_info_nfe(p_filtro, p_num_natureza, p_natureza, p_pedido_shippment){ // recebe o filtro que ser passado na query de busca da nota
		//38303 Incluir NFe ao CT-e 
		with(document.forms[0]){
			v_pedido_shipment_obg = NFE_ORDEM_COMPRA.getAttribute('obrigatorio');
			var tipoDoc = document.getElementById("TIPO_DOCUMENTO_ID").value ;
            
			f_query_wddx('<cf_url>/modulos/cte/_componentes/consulta/cfc_cte.cfc</cf_url>?method=get_nfe'
						,p_filtro + '&avon=<cfoutput>#vars.AVON#</cfoutput>'
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.documento_id.length > 0) {									
									for(var i = 0; i < obj.struct.documento_id.length; i++) {
										f_incluir_NFE();
                                        NFE_ORDEM_COMPRA.setAttribute('obrigatorio', 0);
										
										v_inserida = 1;
										
										//Atribui o pedido shipment do xml da nota
										p_pedido_shippment = obj.struct.pedido_shippment[i];
										
										if(p_pedido_shippment == PEDIDO_SHIPMENT_SOLICITACAO.value){
										   p_pedido_shippment = '';
										}
										
										try{
											if(Number(p_pedido_shippment) == Number(PEDIDO_SHIPMENT_SOLICITACAO.value) ){
											   p_pedido_shippment = '';
											}
										} catch(e) {}
										
										/* Campos */
										// verifica tipo do documento para atribuir o pedido shipment correto
										if (tipoDoc == 0){
										   NOTA_ORDEM_COMPRA.value = NOTA_ORDEM_COMPRA.value + ' ' + p_pedido_shippment;
										}
										if (tipoDoc == 1){
									       if (p_pedido_shippment) {
  										      NFE_ORDEM_COMPRA.value = 'DT '+ p_pedido_shippment + '\n' + NFE_ORDEM_COMPRA.value;
										   }
										}

										CHAVE_ACESSO_NFE.value       = obj.struct.chave_numerica[i];
										NFE_VALOR.value              = obj.struct.valor[i];
										NFE_VALOR_SEGURADO.value     = obj.struct.valor[i];
										NFE_NUM_NATUREZA.value       = p_num_natureza;
										NFE_NATUREZA.value           = 'NFe Integrada';
										NFE_PESO.value               = obj.struct.peso_calculado[i];
										NFE_PESO_COBRADO.value       = obj.struct.peso_calculado[i];
										NFE_QTDE_VOLUME.value        = obj.struct.volume[i];
										NFE_CFOP.value               = obj.struct.cfop[i];
										NFE_NUM_ESPECIE.value        = obj.struct.num_especie[i];
										NFE_ESPECIE.value            = obj.struct.especie_mapeada[i];
										PIN_SUFRAMA_NFE.value        = '';
										REMETENTE_NFE.value          = obj.struct.razao_social_emitente[i];
										CNPJ_REMETENTE_NFE.value     = obj.struct.cpf_cnpj_emitente[i];
										DESTINATARIO_NFE.value       = obj.struct.razao_social_destinatario[i];
										CNPJ_DESTINATARIO_NFE.value  = obj.struct.cpf_cnpj_destinatario[i];
										NOME_ARQUIVO.value           = '';
										NUMERO_NFE.value             = obj.struct.numero_documento[i];
										MODELO_NFE.value             = obj.struct.modelo_documento[i];
										SERIE_NFE.value              = obj.struct.serie_documento[i];
										DATA_EMISSAO_NFE.value       = obj.struct.data_emissao[i];
										NFE_DOCUMENTO_ID.value       = obj.struct.documento_id[i];
										NFE_PESO_CUBADO.value 		  = obj.struct.peso_calculado[i];
										NFE_PESO_KG_CONVERTIDO.value = obj.struct.peso_calculado[i];
										NFE_PESO_COBRADO.value 		  = obj.struct.peso_calculado[i];
										ICMS_PARTILHADO.value    = obj.struct.icms_partilhado[i];
										f_calcula_cubagem('NFE');
										/* ------ */
										
										f_salvar_NFE();
										NFE_ORDEM_COMPRA.setAttribute('obrigatorio', v_pedido_shipment_obg);
									}
									
								}
								else {
									alert('NFE no encontrada.');
								}
							}
						});	
		}
	}
	
	function f_valor_segurado_automatico(tipo_documento, atualiza_valor_segurado) {
		with(document.forms[0]) {
			if(OPERACAO_ID.value == ''){
				return;
			}
			
			f_query_wddx('<cf_url>/modulos/cte/_componentes/consulta/logistica/cfc_operacao.cfc</cf_url>?method=get_config_valor_segurado'
						,'operacao_id=' + OPERACAO_ID.value
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {								
								if(obj.struct.destinado_exportacao.length > 0) {		

									for(var i = 0; i < obj.struct.destinado_exportacao.length; i++) {

										if (obj.struct.destinado_exportacao[i] == 1 && obj.struct.adicional_valor_segurado[i] > 0) {
											document.getElementById(tipo_documento+'_VALOR_SEGURADO').setAttribute('disabled', 'disabled');
											if (atualiza_valor_segurado == 1) {
												if (document.getElementById(tipo_documento+'_VALOR').value == '') {
													document.getElementById(tipo_documento+'_VALOR_SEGURADO').value = document.getElementById(tipo_documento+'_VALOR').value;
												} else {
													document.getElementById(tipo_documento+'_VALOR_SEGURADO').value = toCurrency(Number(document.getElementById(tipo_documento+'_VALOR').value) + (document.getElementById(tipo_documento+'_VALOR').value * obj.struct.adicional_valor_segurado[i] / 100));
												}
											}
										} else {
											document.getElementById(tipo_documento+'_VALOR_SEGURADO').removeAttribute('disabled');
											if (atualiza_valor_segurado == 1) {
												document.getElementById(tipo_documento+'_VALOR_SEGURADO').value = document.getElementById(tipo_documento+'_VALOR').value;
											}
										}
                              
                              // Calcula sobretaxa valor segurado, de acordo com quantidade de notas da solicitao
                              if (NUM_ROMANEIO.value != "" && obj.struct.perc_sobretaxa[i] > 0) {
                                 var perc_sobretaxa = obj.struct.perc_sobretaxa[i];
                                 f_query_wddx('<cf_url>/modulos/cte/_componentes/consulta/logistica/cfc_operacao.cfc</cf_url>?method=get_count_notas_solicitacao'
                                    ,'num_romaneio=' + NUM_ROMANEIO.value
                                    ,function(obj2) {
                                       if(obj2.ajax.readyState == 4 && obj2.ajax.status == 200) {
                                          var valor_segurado = Number(document.getElementById(tipo_documento+'_VALOR_SEGURADO').value);
                                          valor_segurado = toCurrency(valor_segurado + (valor_segurado * perc_sobretaxa / 100));
                                          document.getElementById(tipo_documento+'_VALOR_SEGURADO').value = valor_segurado;
                                          var num_notas = obj2.struct.num_notas[0] + ';';
                                          if (NOTA_NUMERO.value != '' && obj2.struct.count_notas[0] > 0 && num_notas.search(NOTA_NUMERO.value + ';') > -1) {
                                             NOTA_VALOR_SEGURADO.disabled = true;
                                          } else {
                                             NOTA_VALOR_SEGURADO.disabled = false;
                                          }
                                       }
                                    }
                                 );
                              }

									}
								}
							}
						});
		}
	}
</script>
<input name="CFOP_TRANSPORTADO" type="hidden" id="CFOP_TRANSPORTADO" value=""/>
<input name="NFE_ICMS_PARTILHADO" type="hidden" id="NFE_ICMS_PARTILHADO" value="0"/>
<input name="BUSCA_POR_CHAVE" type="hidden" id="BUSCA_POR_CHAVE" value="1" secao="NFE"/>
<input name="MERCADORIA_TRANSPORTADA" type="hidden" id="MERCADORIA_TRANSPORTADA" value=""/>
<input type="hidden" name="NF_CONHECIMENTO_ID" id="NF_CONHECIMENTO_ID" fixo="1" value="" />
<table width="900px%" border="0" cellpadding="0" cellspacing="0">
	<tr>
    	<td width="90%">
        	<table width="90%" border="0" cellpadding="1" cellspacing="3">
            	<tr id="tr_nf_substituto" style="display:none;">
                   <td colspan="3" style="color:#F00;" class="texto_negrito">*Para Emitir CTe de Substitui&ccedil;&atilde;o de Valores a NFe ou NF informada deve ser Anula&ccedil;&atilde;o de Valores (CFOP 1206, 2206, 5206, 6206 ou 7206).<br />
                                                                              Para esta emiss&atilde;o somente &eacute; permitido inserir NFe atrav&eacute;s da importa&ccedil;&atilde;o do XML.</td>
                </tr>
                <tr>
                	<td class="texto" nowrap style="width:1%">Tipo do Documento:</td>
                    <td class="texto" nowrap style="width:1%">
                    <select name="TIPO_DOCUMENTO_ID" id="TIPO_DOCUMENTO_ID" obrigatorio="1" display="TIPO DO DOCUMENTO" style="width: 300px;" onChange="f_muda_tipo_documento();">
					  <cfoutput query="qrTipoDocumentos">
                        	<option value="#qrTipoDocumentos.RV_LOW_VALUE#">#qrTipoDocumentos.RV_ABBREVIATION#</option>                        
                      </cfoutput>
                    </select></td>
					
                    <td class="texto" nowrap style=";width:98%">
                        <span id="td_nfe" style="display:none;">Enviar Arquivo:
                        <input type="file" name="CONTEUDO" id="CONTEUDO" display="NFE / XML" secao="NFE" onChange="document.forms[0].ARQUIVO.value = document.forms[0].CONTEUDO.value;document.forms[0].BUSCA_POR_CHAVE.value = 0;f_busca_dados_nfe();">&nbsp;&nbsp;
                        <cfif vars.AVON eq 1>
							&nbsp;&nbsp;N&ordm; Manifesto:
							<input name="MANIFESTO_NUMERO" type="text" id="MANIFESTO_NUMERO" size="15" maxlength="10" obrigatorio="0" display="NOTAS FISCAIS / NUM MANIFESTO" tipo="numerico" secao="NOTAS_FISCAIS" onkeypress="return f_formata(this,event,'000000000000')">&nbsp;
						</cfif>
						
						
						
						<button id="btn_busca_nfe" class="botao" onClick="document.forms[0].BUSCA_POR_CHAVE.value = 0;f_localizar_nfe();">
                        	<img alt="" align=absmiddle src="/_imagens/botoes/16x16/buscar.gif" width=16 height=16>&nbsp;Localizar NFE
                        </button>
                        </span>
                    </td>
                </tr>
                <tr>
                	<td valign="top" class="texto" nowrap>
                       Pedido / Shipment Viagem:
                    </td>
                    <td valign="top" nowrap class="texto" colspan="2"> 
                       <table>
							<tr>
								<td rowspan="2">
                       <textarea name="PEDIDO_SHIPMENT" id="PEDIDO_SHIPMENT" size="160" onKeyPress="if (this.value.length >= 160) return false;" onBlur="if (this.value.length > 160) this.value = this.value.substr(0, 160);" obrigatorio="0" cols="60" row="4" style="width: 500px; resize: none; height:45px;"></textarea>
                       <input name="PEDIDO_SHIPMENT_SOLICITACAO" type="hidden" id="PEDIDO_SHIPMENT_SOLICITACAO" size="160" maxlength="160" obrigatorio="0"/>&nbsp;
								</td>
								<td>
			                       <button id ="btn_pedido_shipment" type="button" class="botao" onclick="f_replica_pedido_shipment(1)" style="width: 350px;">
                          <img src="/_imagens/botoes/16x16/aplicar.gif" alt="" width="16" height="16" align="absmiddle">&nbsp;
                          Aplicar a todos os Documentos
                       </button>
                    </td>
                </tr>
							<tr>
								<td>
			                       <button id ="btn_pedido_shipment_sem_preenchimento" type="button" class="botao" onclick="f_replica_pedido_shipment()" style="width: 350px;">
			                          <img src="/_imagens/botoes/16x16/aplicar.gif" alt="" width="16" height="16" align="absmiddle">&nbsp;
			                          Aplicar a todos os Documentos sem preenchimento
			                       </button>
								</td>
							</tr>
						</table>
                    </td>
                </tr>
            </table>            
        </td>
    </tr>
</table>
<table width="100%" border="0" cellpadding="3" cellspacing="1" class="texto" id="tb_nota_fiscal"><!--DWLayoutTable-->
   <tr>
     <td height="1" colspan="4" nowrap style="padding:0"><fieldset><legend>Nota Fiscal</legend><table width="100%" border="0" cellspacing="1" cellpadding="3">
   <tr>
      <td width="1%" height="1" nowrap class="texto">N&ordm; Nota:
	    <input name="NOTAS" type="hidden" id="NOTAS" value="">
        <input type="hidden" name="ARQUIVO" id="ARQUIVO" display="NFE / XML DA NFE" value="" sempre_ativo="1" secao="NFE" <cfif vars.substituto eq 1>obrigatorio="1"</cfif>/>
        <input type="hidden" name="COD_MODELO" id="COD_MODELO" value=""/></td>
      <td class="texto" ><input name="NOTA_NUMERO" type="text" id="NOTA_NUMERO" size="15" maxlength="10" obrigatorio="1" display="NOTAS FISCAIS / NUM NOTA" tipo="numerico" secao="NOTAS_FISCAIS" onkeypress="return f_formata(this,event,'000000000000')"></td>
      <td class="texto" ><nobr>Emiss&atilde;o: </nobr></td>
      <td class="texto" ><nobr><input name="NOTA_DATA_EMISSAO" type="text" id="NOTA_DATA_EMISSAO" onkeypress="return f_formata(this,event,'00/00/0000')" size="15" maxlength="10" obrigatorio="1" value="" display="NOTAS FISCAIS / DATA EMISS&Atilde;O" tipo="data" secao="NOTAS_FISCAIS" />
<button class="botao-16x16" id="trigger"><img src="/_imagens/botoes/16x16/calendario.gif" width="16" height="16" align="absmiddle" /></button>
     </nobr>	  </td>
   </tr>
   
   <tr>
      <td height="1" nowrap class="texto">Modelo:</td>
      <td width="1%" class="texto"><select name="NOTA_MODELO" id="NOTA_MODELO" obrigatorio="1" display="NOTAS FISCAIS / MODELO" secao="NOTAS_FISCAIS" fixo="1" onchange="f_busca_serie_nota()">
        <cfif qrSub.RecordCount gt 0>
          <option value="">--- Selecione ---</option>
          <cfoutput query="qrSub" group="cod_modelo">
            <option value="#qrSub.COD_MODELO#">#qrSub.COD_MODELO#</option>
          </cfoutput>
        </cfif>
      </select></td>
      <td width="1%" class="texto">S&eacute;rie:<nobr></nobr></td>
      <td width="99%" class="texto">
      <cfif v_nf_serie_liberada eq 1>
      <input name="NOTA_SERIE" id="NOTA_SERIE" style="width:40px" obrigatorio="1" display="NOTAS FISCAIS / S&Eacute;RIE" fixo="1" secao="NOTAS_FISCAIS" onchange="f_busca_sub_serie_nota()" onkeypress="return f_formata(this,event,'AAA')">
        Sub-s&eacute;rie:
        <input name="NOTA_SUB_SERIE" id="NOTA_SUB_SERIE" style="width:40px" obrigatorio="1" display="NOTAS FISCAIS / SUB-S&Eacute;RIE" fixo="1" secao="NOTAS_FISCAIS"  onkeypress="return f_formata(this,event,'000')">
      <cfelse>
      <select name="NOTA_SERIE" id="NOTA_SERIE" obrigatorio="1" display="NOTAS FISCAIS / S&Eacute;RIE" fixo="1" secao="NOTAS_FISCAIS" onchange="f_busca_sub_serie_nota()">
        <option value="">--</option>
      </select>
        Sub-s&eacute;rie:
        <select name="NOTA_SUB_SERIE" id="NOTA_SUB_SERIE" obrigatorio="1" display="NOTAS FISCAIS / SUB-S&Eacute;RIE" fixo="1" secao="NOTAS_FISCAIS" >
          <option value="">--</option>
        </select>
       </cfif></td></tr>
   
   <tr>
     <td height="1" nowrap class="texto">Valor da Nota:</td>
     <td class="texto"><input name="NOTA_VALOR" type="text" id="NOTA_VALOR" onkeypress="return f_formata_numero_decimal(this,event)" size="15" maxlength="15" obrigatorio="1" display="NOTAS FISCAIS / VALOR" tipo="numerico" secao="NOTAS_FISCAIS" onchange="this.value = toCurrency(this.value);  f_valor_segurado_automatico('NOTA', 1);" /></td>
     <td class="texto"><nobr>Valor Segurado: </nobr> </td>
     <td class="texto"><input name="NOTA_VALOR_SEGURADO" type="text" id="NOTA_VALOR_SEGURADO" onkeypress="return f_formata_numero_decimal(this,event)" size="15" maxlength="15" obrigatorio="0" display="NOTAS FISCAIS / VALOR" tipo="numerico" secao="NOTAS_FISCAIS" onchange="this.value = toCurrency(this.value)" />
     <nobr>CFOP: </nobr>
     <input name="NOTA_CFOP" type="text" id="NOTA_CFOP" size="10" maxlength="4" obrigatorio="1" display="NOTAS FISCAIS / CFOP" secao="NOTAS_FISCAIS" /></td>
  </tr>
   <tr>
     <td valign="top" height="1" nowrap class="texto">Pedido/Shipment:</td>
     <td colspan="6" valign="top" class="texto"><textarea name="NOTA_ORDEM_COMPRA" id="NOTA_ORDEM_COMPRA" obrigatorio="0" onKeyPress="if (this.value.length >= 160) return false;" onBlur="if (this.value.length > 160) this.value = this.value.substr(0, 160);" display="NOTAS FISCAIS / PEDIDO/SHIPMENT" secao="NOTAS_FISCAIS" cols="60" row="4" style="width: 500px; resize: none; height:45px;"></textarea></td>
     </tr>
     </table></fieldset></td>
   </tr>
   <tr>
     <td height="1" colspan="4" nowrap style="padding:0"><fieldset>
     <legend>Mercadoria</legend>
     <table width="100%" border="0" cellspacing="1" cellpadding="3">
              <tr>
                <td width="8%" class="texto">Volumes:</td>
                <td width="12%" class="texto"><input name="NOTA_QTDE_VOLUME" type="text" id="NOTA_QTDE_VOLUME" size="15" maxlength="10" obrigatorio="1" display="NOTAS FISCAIS / QUANTIDADE" tipo="numerico" secao="NOTAS_FISCAIS" onkeypress="return f_formata_numero_decimal(this,event)" onchange="f_calcula_cubagem('NOTA');"/></td>
                <td class="texto">Peso:
                  <input name="NOTA_PESO" type="text" id="NOTA_PESO" size="10" maxlength="10" obrigatorio="1" display="NOTAS FISCAIS / PESO" tipo="numerico" secao="NOTAS_FISCAIS" onkeypress="return f_formata_numero_decimal(this,event)" onchange="/*this.value = toCurrency(this.value);*/ f_calcula_peso_kg('NOTA')" />
                  <select name="NOTA_COD_UNIDADE" id="NOTA_COD_UNIDADE" fixo="1" manter="1" obrigatorio="1" display="NOTAS FISCAIS / UNIDADE" secao="NOTAS_FISCAIS" onchange="f_calcula_peso_kg('NOTA')">
	                  <option value="">-- Selecione --</option>
					  <cfoutput query="qrUnidade">
					  <option value="#qrUnidade.cod_unidade#" <cfif qrUnidade.cod_unidade eq 'Kg'>selected</cfif>>#qrUnidade.unidade#</option>
					  </cfoutput>
                  </select>
                  <input name="NOTA_M3" type="hidden" id="NOTA_M3" value="0" fixo="1" />
                  <input name="NOTA_PESO_CUBADO" type="hidden" id="NOTA_PESO_CUBADO" value="0" fixo="1" />
                  <input name="NOTA_PESO_KG_CONVERTIDO" type="hidden" id="NOTA_PESO_KG_CONVERTIDO" size="10" maxlength="10" obrigatorio="0" display="NOTAS FISCAIS / PESO" tipo="numerico" secao="NOTAS_FISCAIS"  /></td>
              </tr>
              <tr>
                <td class="texto">Natureza:</td>
                <td colspan="2" class="texto"><input name="NOTA_NUM_NATUREZA" type="text" id="NOTA_NUM_NATUREZA" style="width: 40px" onkeypress="return f_formata(this,event,'000000')" onchange="f_busca_natureza('NOTA')" obrigatorio="1" display="NOTAS FISCAIS / NATUREZA" secao="NOTAS_FISCAIS" />
                  <input name="NOTA_NATUREZA" type="text" id="NOTA_NATUREZA" readonly="true" style="width: 200px" obrigatorio="1" display="NOTAS FISCAIS / NATUREZA" secao="NOTAS_FISCAIS" />
                  <button type="button" class="botao-16x16" onclick="NewWindow('localizar_natureza.cfm?num_natureza=NOTA_NUM_NATUREZA&natureza=NOTA_NATUREZA&operacao_id=' + OPERACAO_ID_CTRC.value,'_blank',600,400,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle" /></button>
                  
                <input name="NOTA_COMPLEMENTO" type="text" id="NOTA_COMPLEMENTO" style="width: 177px" display="NOTAS FISCAIS / COMPLEMENTO" secao="NOTAS_FISCAIS" /></td>
              </tr>
              <tr>
                <td class="texto">Esp&eacute;cie:</td>
                <td colspan="2" class="texto"><input name="NOTA_NUM_ESPECIE" type="text" id="NOTA_NUM_ESPECIE" style="width: 40px" onkeypress="return f_formata(this,event,'000000')" onchange="f_busca_especie('NOTA')" obrigatorio="1" display="NOTAS FISCAIS / ESPECIE" secao="NOTAS_FISCAIS" />
                  <input name="NOTA_ESPECIE" type="text" id="NOTA_ESPECIE" readonly="true" style="width: 200px" obrigatorio="1" display="NOTAS FISCAIS / ESPECIE" secao="NOTAS_FISCAIS" />
                  <button type="button" class="botao-16x16" onclick="NewWindow('/_consultas/localizar_especie.cfm?num_ESPECIE=NOTA_NUM_ESPECIE&ESPECIE=NOTA_ESPECIE','_blank',600,400,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle" /></button></td>
              </tr>
              <tr>
                <td class="texto">Altura:</td>
                <td colspan="2" class="texto"><input name="NOTA_ALTURA" type="text" id="NOTA_ALTURA" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / ALTURA" obrigatorio="0" onchange="f_calcula_cubagem('NOTA');" tipo="numerico" secao="NOTAS_FISCAIS" />
                  Comprimento:
                    <input name="NOTA_COMPRIMENTO" type="text" id="NOTA_COMPRIMENTO" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / COMPRIMENTO" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('NOTA');" secao="NOTAS_FISCAIS" />
                    Largura:
                    <input name="NOTA_LARGURA" type="text" id="NOTA_LARGURA" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / LARGURA" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('NOTA');" secao="NOTAS_FISCAIS" />
              </tr>
              <tr>
              	<td class="texto">Cubagem sugerida:</td>
                <td colspan="2" class="texto"><input name="NOTA_CUBAGEM_SUGERIDA" type="text" id="NOTA_CUBAGEM_SUGERIDA" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / CUBAGEM SUGERIDA" tipo="numerico" obrigatorio="0" secao="NOTAS_FISCAIS" readonly="true" />
                Cubagem total:
                <input name="NOTA_CUBAGEM" type="text" id="NOTA_CUBAGEM" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / CUBAGEM" tipo="numerico" obrigatorio="0" secao="NOTAS_FISCAIS"  onchange="f_calcula_peso_cobrado('NOTA');"/>
                </td>
              </tr>
              <tr>
                <td class="texto"><nobr>Peso Cobrado: </nobr> </td>
                <td colspan="2" class="texto"><input name="NOTA_PESO_COBRADO" type="text" id="NOTA_PESO_COBRADO" style="width: 90px" obrigatorio="1" display="NOTAS FISCAIS / PESO COBRADO" secao="NOTAS_FISCAIS" onkeypress="return f_formata_numero_decimal(this,event)" />
                  Kg</td>
              </tr>
      </table></fieldset></td>
   </tr>
   <tr>
      <td colspan="4">
		<cfset lista_id = 'NOTAS_FISCAIS'>
			  <cfset lista_campos = 'NF_CONHECIMENTO_ID,NOTA_NUMERO,NOTA_SERIE,NOTA_SUB_SERIE,NOTA_MODELO,NOTA_DATA_EMISSAO,NOTA_VALOR,'>
			  <cfset lista_campos = lista_campos&'NOTA_VALOR_SEGURADO,NOTA_ORDEM_COMPRA,NOTA_QTDE_VOLUME,NOTA_PESO,'>
			  <cfset lista_campos = lista_campos&'NOTA_COD_UNIDADE,NOTA_M3,NOTA_PESO_CUBADO,NOTA_PESO_KG_CONVERTIDO,'>
			  <cfset lista_campos = lista_campos&'NOTA_NUM_NATUREZA,NOTA_NATUREZA,NOTA_COMPLEMENTO,NOTA_NUM_ESPECIE,NOTA_ESPECIE,'>
			  <cfset lista_campos = lista_campos&'NOTA_ALTURA,NOTA_LARGURA,NOTA_COMPRIMENTO,NOTA_CUBAGEM,NOTA_CUBAGEM_SUGERIDA,NOTA_PESO_COBRADO,NOTA_CFOP'>
			  
			  <cfset lista_titulos = 'N&ordm; Nota,Modelo,S&eacute;rie,Sub-S&eacute;rie,Data Emiss&atilde;o,Valor,Peso'>
			  <cfset lista_titulos_campos = 'NOTA_NUMERO,NOTA_MODELO,NOTA_SERIE,NOTA_SUB_SERIE,NOTA_DATA_EMISSAO,NOTA_VALOR,NOTA_PESO'>
			  <cfset lista_titulos_tamanho = '100,80,80,80,120,150,150'>
			  <cfset lista_campo_id = 'NOTA_NUMERO'>
			  <cfset lista_default = 0>
			  <cfset lista_height = '200'>
			  <cfset lista_width = '100%'>
			  <cfinclude template="/_include/lista.cfm">
		<script language="javascript1.2">
		var v_num_especie_notas = '';
		var v_num_natureza_notas = '';
		var v_cod_unidade_notas = '';
		var v_edicao = false;
		var v_nota_num_natureza = '';
		var v_nota_num_especie = '';
		function f_on_incluir_NOTAS_FISCAIS() {
			with(document.forms[0]) {
            NOTA_ALTURA.value = 0;
				NOTA_LARGURA.value = 0;
				NOTA_COMPRIMENTO.value = 0;
				if (!v_edicao){
					NOTA_COMPRIMENTO.onchange();
				}
				
				v_lista = f_listagem_NOTAS_FISCAIS();
				if(v_lista.length > 0){
					NOTA_NUM_NATUREZA.value = v_nota_num_natureza;
					NOTA_NUM_NATUREZA.onchange();
					NOTA_NUM_ESPECIE.value = v_nota_num_especie;
					
					NOTA_NUM_ESPECIE.onchange();
				}
				
				NOTA_QTDE_VOLUME.value = 1;
				NOTA_ORDEM_COMPRA.value = PEDIDO_SHIPMENT_SOLICITACAO.value;
				
				f_valor_segurado_automatico('NOTA', 0);
				
				v_edicao = false;
			}
		}
		function f_on_salva_lista_NOTAS_FISCAIS() {
			with(document.forms[0]) {
				v_lista = f_listagem_NOTAS_FISCAIS();
				if(v_lista.length > 0){
					//Segundo regra, se a natureza veio da solicitao, no deve ser substituida pela natureza da nota.
					if (SOLICITACAO_NUM_NATUREZA.value == '') {
					   NUM_NATUREZA.value = v_lista[0].NOTA_NUM_NATUREZA;
					   NUM_NATUREZA.onchange();
					}
					NUM_ESPECIE.value =  v_lista[0].NOTA_NUM_ESPECIE;
					NUM_ESPECIE.onchange();
				}
				VALOR_MERCADORIA.value = f_total_campo_NOTAS_FISCAIS('NOTA_VALOR');
				PESO.value = f_total_campo_NOTAS_FISCAIS('NOTA_PESO_COBRADO');
				M3.value = f_total_campo_NOTAS_FISCAIS('NOTA_M3')
				CUBAGEM.value = f_total_campo_NOTAS_FISCAIS('NOTA_CUBAGEM')
				PESO_KG.value = f_total_campo_NOTAS_FISCAIS('NOTA_PESO_KG_CONVERTIDO');
				var v_lista = f_listagem_NOTAS_FISCAIS();
				NOTAS.value = '';
				for(var i=0;i<v_lista.length;i++) {
					if(NOTAS.value == ''){
						NOTAS.value = v_lista[i].NOTA_NUMERO;						
					}else{
						NOTAS.value += ' , '+v_lista[i].NOTA_NUMERO;						
					}
				}
				f_preenche_constantes_cfop_mercadoria();
				try{
				f_preenche_observacao();
				} catch(e) {}
				
				COD_UNIDADE.value = 'Kg';
				VOLUME.value = f_total_campo_NOTAS_FISCAIS('NOTA_QTDE_VOLUME');
				
				if(POPULANDO_DADOS.value == 0){
				   f_calculos();
				}				
				PESO_REAL.value = f_total_campo_NOTAS_FISCAIS('NOTA_PESO');
				f_atualiza_peso_cte_ref();
				if (f_listagem_CTES_REF().length > 0) {
				   f_seleciona_CTES_REF(0);
				}
			}
		}
		function f_before_salvar_NOTAS_FISCAIS() {
			with(document.forms[0]) {
				if(f_ajax_running() > 0 && v_inserida == 0) {
					alert('Aguarde o trmino do processamento antes de salvar.');
					return false;
				}
				if(NOTA_NUM_ESPECIE.value != '' && NOTA_ESPECIE.value == '') {
					alert('A espcie selecionada no  vlida!');
					return false;
				}
				if(NOTA_NUM_NATUREZA.value != '' && NOTA_NATUREZA.value == '') {
					alert('A natureza selecionada no  vlida!');
					return false;
				}
				v_lista = f_listagem_NOTAS_FISCAIS();
				if(v_lista.length == 0){
					v_nota_num_natureza = NOTA_NUM_NATUREZA.value;
					v_nota_num_especie = NOTA_NUM_ESPECIE.value;
				}
				<cfif IsDefined("v_valida_valor_segurado") and v_valida_valor_segurado eq 1>
				if(Number(NOTA_VALOR.value) > Number(NOTA_VALOR_SEGURADO.value)) {
					alert('O Valor Segurado (R$ '+ Number(NOTA_VALOR_SEGURADO.value).toFixed(2) +') da nota fiscal ' + NOTA_NUMERO.value + '/' + NOTA_SERIE.value + ' deve ser maior ou igual ao valor da mesma (R$ '+ Number(NOTA_VALOR.value).toFixed(2) +').');
					NOTA_VALOR_SEGURADO.focus();					
					return false;
				}
				</cfif>
				<cfif vars.substituto eq 1>
					if(TEM_ANULACAO.value != 1 && NOTA_CFOP.value != 1206 && NOTA_CFOP.value != 2206 && NOTA_CFOP.value != 5206 && NOTA_CFOP.value != 6206 && NOTA_CFOP.value != 7206){
						alert('Para CTe substituto a NFe de Anulao deve possuir o CFOP 1206, 2206, 5206, 6206 ou 7206.');
						return false;
					}
				</cfif>
				return true;
			}
		}
		function f_on_seleciona_NOTAS_FISCAIS() {
			with(document.forms[0]) {
				f_busca_serie_nota();
				NOTA_SERIE.value = document.getElementById('NOTA_SERIE_NOTAS_FISCAIS_'+lista_selected_NOTAS_FISCAIS.value).value;
				f_busca_sub_serie_nota();
				NOTA_SUB_SERIE.value = document.getElementById('NOTA_SUB_SERIE_NOTAS_FISCAIS_'+lista_selected_NOTAS_FISCAIS.value).value;
			}
		}
		function f_before_selecionar_NOTAS_FISCAIS(){
			v_edicao = true;			
		}
		function f_on_excluir_NOTAS_FISCAIS(){
			v_listagem = f_listagem_NOTAS_FISCAIS();
			if(v_listagem.length == 0)
				f_controla_tipo_docto_frete();
		}
		</script>
       </td>
   </tr>
</table>

<table width="100%" border="0" cellpadding="1" cellspacing="0">
	<tr>
    	<td width="100%">
        	<fieldset id="fs_nfe" style="display:none" disabled="true"><legend>Nota Fiscal Eletr&ocirc;nica</legend>
                <table width="100%" border="0" cellpadding="1" cellspacing="3">
                    <tr>
                        <td nowrap width="100%" class="texto">Chave de Acesso da NFe:
                        <input type="hidden" name="NFE_ID" id="NFE_ID" />
                        <input type="hidden" name="NOME_ARQUIVO" id="NOME_ARQUIVO" />
                        <input type="hidden" name="DOCUMENTO_ID" id="DOCUMENTO_ID" />
                        <input type="hidden" name="NFE_DOCUMENTO_ID" id="NFE_DOCUMENTO_ID" />
                        <input type="hidden" name="ICMS_PARTILHADO" id="ICMS_PARTILHADO" secao="NFE" />
                        <input type="text" name="CHAVE_ACESSO_NFE" id="CHAVE_ACESSO_NFE" maxlength="44" obrigatorio="1" secao="NFE" display="NFE / CHAVE DE ACESSO DA NFE" style="width: 320px;" onchange="document.forms[0].BUSCA_POR_CHAVE.value = 0;f_busca_dados_chave_nfe();document.forms[0].BUSCA_POR_CHAVE.value = 0;"/>
                        &nbsp;PIN do Suframa:
                    	<input type="text" name="PIN_SUFRAMA_NFE" id="PIN_SUFRAMA_NFE"  onkeypress="return f_formata(this,event,'000000000')" maxlength="9" secao="NFE" display="NFE / PIN DO SUFRAMA" style="width: 100px;" />
                        &nbsp;Valor da Nota:
                    	<input type="text" name="NFE_VALOR" id="NFE_VALOR" maxlength="15" obrigatorio="1" tipo="numerico" secao="NFE" display="NFE / VALOR" onChange="this.value = Number(this.value).toFixed(2);  f_valor_segurado_automatico('NFE', 1);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;" />
                        &nbsp;Valor Segurado:
                    	<input type="text" name="NFE_VALOR_SEGURADO" id="NFE_VALOR_SEGURADO" maxlength="15" obrigatorio="1" tipo="numerico" secao="NFE" display="NFE / VALOR SEGURADO" onChange="this.value = Number(this.value).toFixed(2);" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px;" />
                        </td>
                    <tr>
                        <td nowrap width="100%" class="texto">Data de Emiss&atilde;o:<input type="text" name="DATA_EMISSAO_NFE" id="DATA_EMISSAO_NFE" maxlength="44" obrigatorio="1" secao="NFE" display="NFE / DATA DE EMISSAO DA NFE" style="width: 85px;" onkeypress="return f_formata(this,event,'00/00/0000')" tipo="data"/>
                                                            <button type="button" id="BTN_DATA_EMISSAO_NFE" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
																<script type="text/javascript"> 
                                                                    Calendar.setup( {
                                                                        inputField  : "DATA_EMISSAO_NFE",      // ID of the input field
                                                                        ifFormat    : "%d/%m/%Y",               // the date format
                                                                        button      : "BTN_DATA_EMISSAO_NFE",  // ID of the button
                                                                        range       : [2001,2050]
                                                                    } );
                                                                </script>
                        &nbsp;N&uacute;mero:<input type="text" name="NUMERO_NFE" id="NUMERO_NFE" maxlength="44" obrigatorio="1" secao="NFE" display="NFE / NMERO DA NFE" style="width: 85px;" readonly="readonly"/>
                        &nbsp;Modelo:<input type="text" name="MODELO_NFE" id="MODELO_NFE" maxlength="44" obrigatorio="1" secao="NFE" display="NFE / MODELO DA NFE" style="width: 85px;" readonly="readonly"/>
                        &nbsp;S&eacute;rie:<input type="text" name="SERIE_NFE" id="SERIE_NFE" maxlength="44" obrigatorio="1" secao="NFE" display="NFE / SRIE DA NFE" style="width: 85px;" readonly="readonly"/>
                        &nbsp;CFOP:<cfif v_nfe_cfop_obrigatorio eq "Sim">
                                      <input name="NFE_CFOP" type="text" id="NFE_CFOP" size="10" maxlength="4" obrigatorio="1" display="NFE / CFOP" secao="NFE" />
                                   <cfelse>
                                      <input name="NFE_CFOP" type="text" id="NFE_CFOP" size="10" maxlength="4" obrigatorio="0" display="NFE / CFOP" secao="NFE" />
                                   </cfif>
                        </td>
                    </tr>
                    <tr>
                    	<td nowrap width="100%" class="texto">
                        	<label style="vertical-align:top;">Pedido/Shipment:</label><textarea name="NFE_ORDEM_COMPRA" id="NFE_ORDEM_COMPRA" obrigatorio="0" display="NFE / PEDIDO/SHIPMENT" secao="NFE" onKeyPress="if (this.value.length >= 160) return false;" onBlur="if (this.value.length > 160) this.value = this.value.substr(0, 160);" cols="60" row="4" style="width: 500px; resize: none; height:45px;"></textarea>
                        </td>
                    </tr>                    
                    <tr>
                    	<td nowrap width="100%" class="texto">

                        	<fieldset id="fs_nfe_arquivo"><legend>Dados do Arquivo</legend>
                                <table width="100%" border="0" cellpadding="1" cellspacing="0">
                                    <tr>
                                        <td width="8%" class="texto">Remetente:</td>
                                        <td width="20%" class="texto"><input type="text" name="REMETENTE_NFE" id="REMETENTE_NFE" readonly="readonly" maxlength="30" secao="NFE" display="NFE / REMETENTE DA NFE" style="width: 400px;"/>                                        </td>
                                        <td width="10%" class="texto" nowrap="nowrap">CPF/CNPJ Remetente:</td>
                                        <td width="50%" class="texto">
                                            <input type="text" name="CNPJ_REMETENTE_NFE" id="CNPJ_REMETENTE_NFE" readonly="readonly" maxlength="30" secao="NFE" display="NFE / REMETENTE DA NFE" style="width: 125px;"/>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td width="8%" class="texto">Destinat&aacute;rio:</td>
                                        <td width="20%" class="texto"><input type="text" name="DESTINATARIO_NFE" id="DESTINATARIO_NFE" readonly="readonly" maxlength="30" secao="NFE" display="NFE / DESTINATRIO DA NFE" style="width: 400px;"/>                                        </td>
                                        <td width="10%" class="texto" nowrap="nowrap">CPF/CNPJ Destinat&aacute;rio:</td>
                                        <td width="50%" class="texto">
                                            <input type="text" name="CNPJ_DESTINATARIO_NFE" id="CNPJ_DESTINATARIO_NFE" readonly="readonly" maxlength="30" secao="NFE" display="NFE / DESTINATRIO DA NFE" style="width: 125px;"/></td>
                                    </tr>
                                    
                                </table>
                            </fieldset>
                        </td>
                    </tr>
                    <tr>
                     	<td height="1" colspan="4" nowrap style="padding:0"><fieldset>
                         <legend>Mercadoria</legend>
                         <table width="100%" border="0" cellspacing="1" cellpadding="3">
                                  <tr>
                                    <td width="8%" class="texto">Volumes:</td>
                                    <td width="12%" class="texto"><input name="NFE_QTDE_VOLUME" type="text" id="NFE_QTDE_VOLUME" size="15" maxlength="10" obrigatorio="1" display="NFE / QUANTIDADE" tipo="numerico" secao="NFE" onkeypress="return f_formata_numero_decimal(this,event)"  onchange="f_calcula_cubagem('NFE');"/></td>
                                    <td class="texto">Peso:
                                      <input name="NFE_PESO" type="text" id="NFE_PESO" size="10" maxlength="10" obrigatorio="1" display="NFE / PESO" tipo="numerico" secao="NFE" onkeypress="return f_formata_numero_decimal(this,event)" onchange="/*this.value = toCurrency(this.value);*/ f_calcula_peso_kg('NFE')" />
                                      <select name="NFE_COD_UNIDADE" id="NFE_COD_UNIDADE" fixo="1" manter="1" obrigatorio="1" display="NFE / UNIDADE" secao="NFE" onchange="f_calcula_peso_kg('NFE')">
                                           <option value="">-- Selecione --</option>
										  <cfoutput query="qrUnidade">
										  <option value="#qrUnidade.cod_unidade#" <cfif qrUnidade.cod_unidade eq 'Kg'>selected</cfif>>#qrUnidade.unidade#</option>
										  </cfoutput>
                                      </select>
                                      <input name="NFE_M3" type="hidden" id="NFE_M3" value="0" fixo="1" />
                                      <input name="NFE_PESO_CUBADO" type="hidden" id="NFE_PESO_CUBADO" value="0" fixo="1" />
                                      <input name="NFE_PESO_KG_CONVERTIDO" type="hidden" id="NFE_PESO_KG_CONVERTIDO" size="10" maxlength="10" obrigatorio="0" display="NFE / PESO" tipo="numerico" secao="NFE"  /></td>
                                  </tr>
                                  <tr>
                                    <td class="texto">Natureza:</td>
                                    <td colspan="2" class="texto"><input name="NFE_NUM_NATUREZA" type="text" id="NFE_NUM_NATUREZA" style="width: 40px" onkeypress="return f_formata(this,event,'000000')" onchange="f_busca_natureza('NFE')" obrigatorio="1" display="NFE / NATUREZA" secao="NFE" />
                                      <input name="NFE_NATUREZA" type="text" id="NFE_NATUREZA" readonly="true" style="width: 200px" obrigatorio="1" display="NFE / NATUREZA" secao="NFE" />
                                      <button type="button" class="botao-16x16" onclick="NewWindow('localizar_natureza.cfm?num_natureza=NFE_NUM_NATUREZA&natureza=NFE_NATUREZA&operacao_id=' + OPERACAO_ID_CTRC.value,'_blank',600,400,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle" /></button>
                                      
                                    <input name="NFE_COMPLEMENTO" type="text" id="NFE_COMPLEMENTO" style="width: 177px" display="NFE / COMPLEMENTO" secao="NFE" /></td>
                                  </tr>
                                  <tr>
                                    <td class="texto">Esp&eacute;cie:</td>
                                    <td colspan="2" class="texto"><input name="NFE_NUM_ESPECIE" type="text" id="NFE_NUM_ESPECIE" style="width: 40px" onkeypress="return f_formata(this,event,'000000')" onchange="f_busca_especie('NFE')" obrigatorio="1" display="NFE / ESPECIE" secao="NFE" />
                                      <input name="NFE_ESPECIE" type="text" id="NFE_ESPECIE" readonly="true" style="width: 200px" obrigatorio="1" display="NFE / ESPECIE" secao="NFE" />
                                      <button type="button" class="botao-16x16" onclick="NewWindow('/_consultas/localizar_especie.cfm?num_ESPECIE=NFE_NUM_ESPECIE&ESPECIE=NFE_ESPECIE','_blank',600,400,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle" /></button></td>
                                  </tr>
                                  <tr>
                                    <td class="texto">Altura:</td>
                                    <td colspan="2" class="texto"><input name="NFE_ALTURA" type="text" id="NFE_ALTURA" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / ALTURA" obrigatorio="0" onchange="f_calcula_cubagem('NFE');" tipo="numerico" secao="NFE" />
                                      Comprimento:
                                        <input name="NFE_COMPRIMENTO" type="text" id="NFE_COMPRIMENTO" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / COMPRIMENTO" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('NFE');" secao="NFE" />
                                        Largura:
                                        <input name="NFE_LARGURA" type="text" id="NFE_LARGURA" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / LARGURA" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('NFE');" secao="NFE" />
                                  </tr>
                                  <tr>
                                  	<td class="texto">Cubagem sugerida:</td>
                                    <td colspan="2" class="texto">
                                        <input name="NFE_CUBAGEM_SUGERIDA" type="text" id="NFE_CUBAGEM_SUGERIDA" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / CUBAGEM SUGERIDA" tipo="numerico" obrigatorio="0" secao="NFE" readonly="true" />
                                        Cubagem total:
                                        <input name="NFE_CUBAGEM" type="text" id="NFE_CUBAGEM" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / CUBAGEM" tipo="numerico" obrigatorio="0" secao="NFE" onchange="f_calcula_peso_cobrado('NFE');"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td class="texto"><nobr>Peso Cobrado: </nobr> </td>
                                    <td colspan="2" class="texto"><input name="NFE_PESO_COBRADO" type="text" id="NFE_PESO_COBRADO" style="width: 90px" obrigatorio="1" display="NFE / PESO COBRADO" secao="NFE" onkeypress="return f_formata_numero_decimal(this,event)" />
                                      Kg</td>
                                  </tr>
                          </table></fieldset></td>
                   </tr>
                </table>
                <table width="100%" border="0" cellpadding="1" cellspacing="3">
                	<tr>
                        <td style="padding-top: 5px;" width="90%">
                            <table width="100%" border="0" cellpadding="1" cellspacing="3">
                            <tr><td>
                            <cfset lista_id = 'NFE'>
                            <cfset lista_campos = 'NF_CONHECIMENTO_ID,NFE_ID,CHAVE_ACESSO_NFE,NFE_VALOR,NFE_VALOR_SEGURADO,PIN_SUFRAMA_NFE,REMETENTE_NFE,CNPJ_REMETENTE_NFE,DESTINATARIO_NFE,'>
							<cfset lista_campos = lista_campos&'CNPJ_DESTINATARIO_NFE,NOME_ARQUIVO,NUMERO_NFE,MODELO_NFE,SERIE_NFE,DATA_EMISSAO_NFE,NFE_DOCUMENTO_ID,'>
                            <cfset lista_campos = lista_campos&'NFE_QTDE_VOLUME,NFE_PESO,NFE_COD_UNIDADE,NFE_M3,NFE_PESO_CUBADO,NFE_CUBAGEM_SUGERIDA,NFE_PESO_KG_CONVERTIDO,NFE_NUM_NATUREZA,'>
							<cfset lista_campos = lista_campos&'NFE_NATUREZA,NFE_COMPLEMENTO,NFE_NUM_ESPECIE,NFE_ESPECIE,'>
                            <cfset lista_campos = lista_campos&'NFE_ALTURA,NFE_COMPRIMENTO,NFE_LARGURA,NFE_CUBAGEM,NFE_PESO_COBRADO,NFE_ORDEM_COMPRA,NFE_CFOP,ICMS_PARTILHADO'>
                            <cfset lista_titulos = 'N&ordm; Nota, Modelo, S&eacute;rie,Data de Emiss&atilde;o,Chave de Acesso,Valor'>
                            <cfset lista_titulos_campos = "NUMERO_NFE,MODELO_NFE,SERIE_NFE,DATA_EMISSAO_NFE,CHAVE_ACESSO_NFE,NFE_VALOR">
                            <cfset lista_default = 0>
                            <cfset lista_titulos_tamanho = '10%,10%,10%,10%,40%,20%'>
                            <cfset lista_titulos_align = 'right,left,left,left,right,left'>
                            <cfset lista_campo_id = 'CHAVE_ACESSO_NFE'>
                            <cfset lista_campos_unique = 'CHAVE_ACESSO_NFE'>
                            <cfset lista_width = '100%'>
                            <cfset lista_height = '200'>
                            
                            <cfinclude template="/_include/lista.cfm">                        
                            </script>
                            <script type="text/javascript">	
								var v_num_especie_notas = '';
								var v_num_natureza_notas = '';
								var v_cod_unidade_notas = '';
								function f_on_incluir_NFE() {
									with(document.forms[0]) {
										NFE_ALTURA.value = 0;
										NFE_LARGURA.value = 0;
										NFE_COMPRIMENTO.value = 0;
										
										if (!v_edicao){
											NFE_COMPRIMENTO.onchange();
										}
										
										v_lista = f_listagem_NFE();
										if(v_lista.length > 0){
											NFE_NUM_NATUREZA.value = v_nota_num_natureza;
											NFE_NUM_NATUREZA.onchange();
											NFE_NUM_ESPECIE.value = v_nota_num_especie;
											NFE_NUM_ESPECIE.onchange();
										}
										
										NFE_QTDE_VOLUME.value = 1;
										NFE_ORDEM_COMPRA.value = NFE_ORDEM_COMPRA.value + PEDIDO_SHIPMENT_SOLICITACAO.value;
										
										f_valor_segurado_automatico('NFE', 0);
										
										v_edicao = false;
									}
								}
								function f_on_salva_lista_NFE() {
									with(document.forms[0]) {
										v_lista = f_listagem_NFE();
										if(v_lista.length > 0){
										    //Segundo regra, se a natureza veio da solicitao, no deve ser substituida pela natureza da nota.
											if (SOLICITACAO_NUM_NATUREZA.value == '') {
											   NUM_NATUREZA.value = v_lista[0].NFE_NUM_NATUREZA;
											   NUM_NATUREZA.onchange();
											}
											NUM_ESPECIE.value = v_lista[0].NFE_NUM_ESPECIE;
											NUM_ESPECIE.onchange();
										}
										VALOR_MERCADORIA.value = f_total_campo_NFE('NFE_VALOR');
										PESO.value = f_total_campo_NFE('NFE_PESO_COBRADO');
										M3.value = f_total_campo_NFE('NFE_M3')
										CUBAGEM.value = f_total_campo_NFE('NFE_CUBAGEM')
										PESO_KG.value = f_total_campo_NFE('NFE_PESO_KG_CONVERTIDO');
										var v_lista = f_listagem_NFE();
										NOTAS.value = '';
										for(var i=0;i<v_lista.length;i++) {
											if(NOTAS.value == ''){
												NOTAS.value = v_lista[i].NFE_NUMERO;						
											}else{
												NOTAS.value += ' , '+v_lista[i].NFE_NUMERO;						
											}
										}
						//				alert(PESO_KG.value);
						
										f_preenche_constantes_cfop_mercadoria();
										try{
										f_preenche_observacao();
										} catch(e) {}
										COD_UNIDADE.value = 'Kg';
										VOLUME.value = f_total_campo_NFE('NFE_QTDE_VOLUME');
										
										if(POPULANDO_DADOS.value == 0){
										   f_calculos();
										}
										PESO_REAL.value = f_total_campo_NFE('NFE_PESO');
										f_atualiza_peso_cte_ref();
										if (f_listagem_CTES_REF().length > 0) {
										   f_seleciona_CTES_REF(0);
										}
									}
								}
								function f_before_salvar_NFE() {
									with(document.forms[0]) {
										if(f_ajax_running() > 0 && v_inserida == 0) {
											alert('Aguarde o trmino do processamento antes de salvar.');
											return false;
										}
										if(NFE_NUM_ESPECIE.value != '' && NFE_ESPECIE.value == '') {
											alert('A espcie selecionada no  vlida!');
											return false;
										}
										if(NFE_NUM_NATUREZA.value != '' && NFE_NATUREZA.value == '') {
											alert('A natureza selecionada no  vlida!');
											return false;
										}
										if(Number(CHAVE_ACESSO_NFE.value.length) != 44) {
											alert('A Chave de Acesso da NFE no  vlida.');
											return false;
										}
										v_lista = f_listagem_NFE();
										if(v_lista.length == 0){
											v_nota_num_natureza = NFE_NUM_NATUREZA.value;
											v_nota_num_especie = NFE_NUM_ESPECIE.value;
										}
										<cfif IsDefined("v_valida_valor_segurado") and v_valida_valor_segurado eq 1>
										if(Number(NFE_VALOR.value) > Number(NFE_VALOR_SEGURADO.value)) {
											alert('O Valor Segurado (R$ '+ Number(NFE_VALOR_SEGURADO.value).toFixed(2) +') da nota fiscal ' + NUMERO_NFE.value + '/' + SERIE_NFE.value + ' deve ser maior ou igual ao valor da mesma (R$ '+ Number(NFE_VALOR.value).toFixed(2) +').');
											NFE_VALOR_SEGURADO.focus();					
											return false;
										}
										</cfif>
										return true;
									}
								}
								function f_on_excluir_NFE(){
									v_listagem = f_listagem_NFE();
									if(v_listagem.length == 0)
										f_controla_tipo_docto_frete();
								}
								function f_before_selecionar_NFE(){								
									v_edicao = true;			
									with(document.forms[0]) {
										MODELO_NFE.readOnly = false;
										NUMERO_NFE.readOnly = false;
										SERIE_NFE.readOnly = false;

										if(CHAVE_ACESSO_NFE.value != ''){
										   MODELO_NFE.readOnly = true;
										   NUMERO_NFE.readOnly = true;
										   SERIE_NFE.readOnly = true;
										}
									}
								}								
							</script>
                            </td>
                            </tr>
                            </table>
                        </td>
                    </tr>
                </table>
        	</fieldset>
    	</td>
	</tr>    
</table>

<table width="90%" border="0" cellpadding="1" cellspacing="0">
	<tr>
    	<td width="90%">
        	<fieldset id="fs_outros" style="display:none" disabled="true"><legend>Outros Documentos</legend>
                <table width="90%" border="0" cellpadding="1" cellspacing="3">
                    <tr>
                      <td width="1%" nowrap class="texto">N&uacute;mero:</td>
                      <td colspan="2" width="1%" nowrap class="texto"><input type="hidden" name="OUTROS_ID" id="OUTROS_ID" />
                      <input type="text"  name="OUTROS_NUMERO" id="OUTROS_NUMERO" maxlength="20" obrigatorio="1" secao="OUTROS" display="NMERO DO DOCUMENTO" style="width: 85px;" />
                      <nobr>Data de Emiss&atilde;o:</nobr>
                      <input type="text" name="OUTROS_DATA_EMISSAO" id="OUTROS_DATA_EMISSAO" maxlength="10" obrigatorio="1" tipo="data" secao="OUTROS" display="OUTROS DOCUMENTOS / DATA DE EMISSO" onkeypress="return f_formata(this, '00/00/0000')" style="width: 85px;" />
                        <button type="button" id="BTN_OUTROS_DATA_EMISSAO" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
                      <script type="text/javascript"> 
                                Calendar.setup( {
                                    inputField  : "OUTROS_DATA_EMISSAO",      // ID of the input field
                                    ifFormat    : "%d/%m/%Y",               // the date format
                                    button      : "BTN_OUTROS_DATA_EMISSAO",  // ID of the button
                                    range       : [2001,2050]
                                } );
                            </script>
                      <nobr>Valor do Documento:</nobr>
                      <input type="text" name="OUTROS_VALOR" id="OUTROS_VALOR" maxlength="15" obrigatorio="1" tipo="numerico" secao="OUTROS" display="OUTROS DOCUMENTOS / VALOR" onchange="this.value = Number(this.value).toFixed(2);  f_valor_segurado_automatico('OUTROS', 1);" onkeypress="return f_formata_numero_decimal(this, event)" style="width: 85px;" />
                      <nobr>Valor do Segurado:</nobr>
                      <input type="text" name="OUTROS_VALOR_SEGURADO" id="OUTROS_VALOR_SEGURADO" maxlength="15" obrigatorio="1" tipo="numerico" secao="OUTROS" display="OUTROS DOCUMENTOS / VALOR SEGURADO" onchange="this.value = Number(this.value).toFixed(2);" onkeypress="return f_formata_numero_decimal(this, event)" style="width: 85px;" /></td>
                    </tr>
                    <tr>
                      <td width="1%" nowrap class="texto">Descri&ccedil;&atilde;o: </td>
                      <td width="97%" nowrap class="texto"><input type="text" name="OUTROS_DESCRICAO" id="OUTROS_DESCRICAO" obrigatorio="1" secao="OUTROS" display="OUTROS DOCUMENTOS / DESCRIO DO DOCUMENTO" style="width: 500px;" /></td>
                    </tr>
                    <tr>
                       <td valign="top" nowrap class="texto"><nobr>Pedido/Shipment:</nobr></td>
                       <td valign="top" nowrap class="texto"><textarea name="OUTROS_ORDEM_COMPRA" id="OUTROS_ORDEM_COMPRA" obrigatorio="0" display="OUTROS DOCUMENTOS / PEDIDO/SHIPMENT" secao="OUTROS" onKeyPress="if (this.value.length >= 160) return false;" onBlur="if (this.value.length > 160) this.value = this.value.substr(0, 160);" cols="60" row="4" style="width: 500px; resize: none; height:45px;"></textarea></td>
                    </tr>
					<td class="texto" nowrap style="width:1%">Tipo de doc. para Outros: </td>
                      <td class="texto" nowrap style="width:1%">
                      <select name="TIPO_DOC_OUTROS" id="TIPO_DOC_OUTROS" display="TIPO DOCUMENTO OUTROS" style="width:200px;">
					  <cfoutput query="qrTipoDocOutros">
                        	<option value="#qrTipoDocOutros.RV_LOW_VALUE#">#qrTipoDocOutros.RV_LOW_VALUE# - #qrTipoDocOutros.RV_ABBREVIATION#</option>                        
                      </cfoutput>
                      </select></td>
                    <tr>
                     	<td height="1" colspan="7" nowrap style="padding:0"><fieldset>
                         <legend>Mercadoria</legend>
                         <table width="100%" border="0" cellspacing="1" cellpadding="3">
                                  <tr>
                                    <td width="8%" class="texto">Volumes:</td>
                                    <td width="12%" class="texto"><input name="OUTROS_QTDE_VOLUME" type="text" id="OUTROS_QTDE_VOLUME" size="15" maxlength="10" obrigatorio="1" display="OUTROS DOCUMENTOS / QUANTIDADE" tipo="numerico" secao="OUTROS" onkeypress="return f_formata_numero_decimal(this,event)"  onchange="f_calcula_cubagem('OUTROS');"/></td>
                                    <td class="texto">Peso:
                                      <input name="OUTROS_PESO" type="text" id="OUTROS_PESO" size="10" maxlength="10" obrigatorio="1" display="OUTROS DOCUMENTOS / PESO" tipo="numerico" secao="OUTROS" onkeypress="return f_formata_numero_decimal(this,event)" onchange="/*this.value = toCurrency(this.value);*/ f_calcula_peso_kg('OUTROS')" />
                                      <select name="OUTROS_COD_UNIDADE" id="OUTROS_COD_UNIDADE" fixo="1" manter="1" obrigatorio="1" display="OUTROS DOCUMENTOS / UNIDADE" secao="OUTROS" onchange="f_calcula_peso_kg('OUTROS')">
                                          <option value="">-- Selecione --</option>
										  <cfoutput query="qrUnidade">
										  <option value="#qrUnidade.cod_unidade#" <cfif qrUnidade.cod_unidade eq 'Kg'>selected</cfif>>#qrUnidade.unidade#</option>
										  </cfoutput>
                                      </select>
                                      <input name="OUTROS_M3" type="hidden" id="OUTROS_M3" value="0" fixo="1" />
                                      <input name="OUTROS_PESO_CUBADO" type="hidden" id="OUTROS_PESO_CUBADO" value="0" fixo="1" />
                                      <input name="OUTROS_PESO_KG_CONVERTIDO" type="hidden" id="OUTROS_PESO_KG_CONVERTIDO" size="10" maxlength="10" obrigatorio="0" display="OUTROS DOCUMENTOS / PESO" tipo="numerico" secao="OUTROS"  /></td>
                                  </tr>
                                  <tr>
                                    <td class="texto">Natureza:</td>
                                    <td colspan="2" class="texto"><input name="OUTROS_NUM_NATUREZA" type="text" id="OUTROS_NUM_NATUREZA" style="width: 40px" onkeypress="return f_formata(this,event,'000000')" onchange="f_busca_natureza('OUTROS')" obrigatorio="1" display="OUTROS DOCUMENTOS / NATUREZA" secao="OUTROS" />
                                      <input name="OUTROS_NATUREZA" type="text" id="OUTROS_NATUREZA" readonly="true" style="width: 200px" obrigatorio="1" display="OUTROS DOCUMENTOS / NATUREZA" secao="OUTROS" />
                                      <button type="button" class="botao-16x16" onclick="NewWindow('localizar_natureza.cfm?num_natureza=OUTROS_NUM_NATUREZA&natureza=OUTROS_NATUREZA&operacao_id=' + OPERACAO_ID_CTRC.value,'_blank',600,400,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle" /></button>                                      
                                      
                                    <input name="OUTROS_COMPLEMENTO" type="text" id="OUTROS_COMPLEMENTO" style="width: 177px" display="OUTROS DOCUMENTOS / COMPLEMENTO" secao="OUTROS" /></td>
                                  </tr>
                                  <tr>
                                    <td class="texto">Esp&eacute;cie:</td>
                                    <td colspan="2" class="texto"><input name="OUTROS_NUM_ESPECIE" type="text" id="OUTROS_NUM_ESPECIE" style="width: 40px" onkeypress="return f_formata(this,event,'000000')" onchange="f_busca_especie('OUTROS')" obrigatorio="1" display="OUTROS DOCUMENTOS / ESPECIE" secao="OUTROS" />
                                      <input name="OUTROS_ESPECIE" type="text" id="OUTROS_ESPECIE" readonly="true" style="width: 200px" obrigatorio="1" display="OUTROS DOCUMENTOS / ESPECIE" secao="OUTROS" />
                                      <button type="button" class="botao-16x16" onclick="NewWindow('/_consultas/localizar_especie.cfm?num_ESPECIE=OUTROS_NUM_ESPECIE&ESPECIE=OUTROS_ESPECIE','_blank',600,400,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="" width="16" height="16" align="absmiddle" /></button></td>
                                  </tr>
                                  <tr>
                                    <td class="texto">Altura:</td>
                                    <td colspan="2" class="texto"><input name="OUTROS_ALTURA" type="text" id="OUTROS_ALTURA" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / ALTURA" obrigatorio="0" onchange="f_calcula_cubagem('OUTROS');" tipo="numerico" secao="OUTROS" />
                                      Comprimento:
                                        <input name="OUTROS_COMPRIMENTO" type="text" id="OUTROS_COMPRIMENTO" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / COMPRIMENTO" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('OUTROS');" secao="OUTROS" />
                                        Largura:
                                        <input name="OUTROS_LARGURA" type="text" id="OUTROS_LARGURA" size="15" maxlength="10" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);"  display="NOTA FISCAL / LARGURA" tipo="numerico" obrigatorio="0" onchange="f_calcula_cubagem('OUTROS');" secao="OUTROS" />
                                    </td>
                                  </tr>
                                  <tr>
                                  	<td class="texto">Cubagem sugerida:</td>
                                    <td colspan="2" class="texto"><input name="OUTROS_CUBAGEM_SUGERIDA" type="text" id="OUTROS_CUBAGEM_SUGERIDA" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / CUBAGEM SUGERIDA" tipo="numerico" obrigatorio="0" secao="OUTROS" readonly="true" />
                                        Cubagem total:
                                    <input name="OUTROS_CUBAGEM" type="text" id="OUTROS_CUBAGEM" size="15" fixo="1" onkeypress="return f_formata_numero_decimal(this,event);" maxlength="10"  display="NOTA FISCAL / CUBAGEM" tipo="numerico" obrigatorio="0" secao="OUTROS" onchange="f_calcula_peso_cobrado('OUTROS');"/>
                                    </td>
                                  </tr>
                                  <tr>
                                    <td class="texto"><nobr>Peso Cobrado: </nobr> </td>
                                    <td colspan="2" class="texto"><input name="OUTROS_PESO_COBRADO" type="text" id="OUTROS_PESO_COBRADO" style="width: 90px" obrigatorio="1" display="OUTROS DOCUMENTOS / PESO COBRADO" secao="OUTROS" onkeypress="return f_formata_numero_decimal(this,event)" />
                                      Kg</td>
                                  </tr>
                          </table></fieldset></td>
                   </tr>
                </table>
                <table width="90%" border="0" cellpadding="1" cellspacing="3">
                	<tr>
                        <td style="padding-top: 5px;" width="90%">
                            <table width="90%" border="0" cellpadding="1" cellspacing="3">
                            <tr><td>
                            <cfset lista_id = 'OUTROS'>
                            <cfset lista_campos = 'NF_CONHECIMENTO_ID,OUTROS_ID,OUTROS_NUMERO,OUTROS_DATA_EMISSAO,OUTROS_DESCRICAO,OUTROS_VALOR,OUTROS_VALOR_SEGURADO,OUTROS_QTDE_VOLUME,OUTROS_PESO,'>
                            <cfset lista_campos = lista_campos&'OUTROS_COD_UNIDADE,OUTROS_M3,OUTROS_PESO_CUBADO,OUTROS_PESO_KG_CONVERTIDO,OUTROS_NUM_NATUREZA,'>
							<cfset lista_campos = lista_campos&'OUTROS_NATUREZA,OUTROS_COMPLEMENTO,OUTROS_NUM_ESPECIE,OUTROS_ESPECIE,'>
                            <cfset lista_campos = lista_campos&'OUTROS_ALTURA,OUTROS_COMPRIMENTO,OUTROS_LARGURA,OUTROS_CUBAGEM,OUTROS_CUBAGEM_SUGERIDA,OUTROS_PESO_COBRADO,OUTROS_ORDEM_COMPRA,TIPO_DOC_OUTROS'>
							<cfset lista_titulos = 'N&ordm; do Documento,Data de Emiss&atilde;o,Descri&ccedil;&atilde;o,Valor,Tipo Doc. Outros'>
                            <cfset lista_titulos_campos = "OUTROS_NUMERO,OUTROS_DATA_EMISSAO,OUTROS_DESCRICAO,OUTROS_VALOR,TIPO_DOC_OUTROS">
                            <cfset lista_default = 0>
                            <cfset lista_titulos_tamanho = '10%,10%,60%,10%,10%'>
                            <cfset lista_titulos_align = 'right,right,left,right,right'>
                            <cfset lista_campo_id = 'OUTROS_NUMERO'>
                            <cfset lista_width = '100%'>
                            <cfset lista_height = '200'>
                            <cfinclude template="/_include/lista.cfm">                        
                            </script>
                            <script type="text/javascript">	 
								var v_num_especie_notas = '';
								var v_num_natureza_notas = '';
								var v_cod_unidade_notas = '';
								function f_on_incluir_OUTROS() {
									with(document.forms[0]) {
										OUTROS_ALTURA.value = 0;
										OUTROS_LARGURA.value = 0;
										OUTROS_COMPRIMENTO.value = 0;
										
										if (!v_edicao){
											OUTROS_COMPRIMENTO.onchange();
										}
										
										v_lista = f_listagem_OUTROS();
										if(v_lista.length > 0){
											OUTROS_NUM_ESPECIE.value = v_num_especie_notas;
											OUTROS_NUM_ESPECIE.onchange();
											OUTROS_NUM_NATUREZA.value = v_num_natureza_notas;
											OUTROS_NUM_NATUREZA.onchange();
										}
										
										OUTROS_QTDE_VOLUME.value = 1;
										
										f_valor_segurado_automatico('OUTROS', 0);
										
										v_edicao = false;
									}
								}
								function f_on_salva_lista_OUTROS() {
									with(document.forms[0]) {
										v_lista = f_listagem_OUTROS();
										if(v_lista.length > 0){
											//Segundo regra, se a natureza veio da solicitao, no deve ser substituida pela natureza da nota.
											if (SOLICITACAO_NUM_NATUREZA.value == '') {
											   NUM_NATUREZA.value = v_lista[0].OUTROS_NUM_NATUREZA;
											   NUM_NATUREZA.onchange();
											}
											NUM_ESPECIE.value = v_lista[0].OUTROS_NUM_ESPECIE;
											NUM_ESPECIE.onchange();
										}
										VALOR_MERCADORIA.value = f_total_campo_OUTROS('OUTROS_VALOR');
										PESO.value = f_total_campo_OUTROS('OUTROS_PESO_COBRADO');
										M3.value = f_total_campo_OUTROS('OUTROS_M3')
										CUBAGEM.value = f_total_campo_OUTROS('OUTROS_CUBAGEM')
										PESO_KG.value = f_total_campo_OUTROS('OUTROS_PESO_KG_CONVERTIDO');
										var v_lista = f_listagem_OUTROS();
										NOTAS.value = '';
										for(var i=0;i<v_lista.length;i++) {
											if(NOTAS.value == ''){
												NOTAS.value = v_lista[i].OUTROS_NUMERO;						
											}else{
												NOTAS.value += ' , '+v_lista[i].OUTROS_NUMERO;						
											}
										}
						
										f_preenche_constantes_cfop_mercadoria();
										try{
										f_preenche_observacao();
										} catch(e) {}
										COD_UNIDADE.value = 'Kg';
										VOLUME.value = f_total_campo_OUTROS('OUTROS_QTDE_VOLUME');
										
										if(POPULANDO_DADOS.value == 0){
										   f_calculos();
										}
										PESO_REAL.value = f_total_campo_OUTROS('OUTROS_PESO');
										f_atualiza_peso_cte_ref();
										if (f_listagem_CTES_REF().length > 0) {
										   f_seleciona_CTES_REF(0);
										}
									}
								}
								function f_before_salvar_OUTROS() {
									with(document.forms[0]) {
										if(f_ajax_running() > 0 && v_inserida == 0) {
											alert('Aguarde o trmino do processamento antes de salvar.');
											return false;
										}
										if(OUTROS_NUM_ESPECIE.value != '' && OUTROS_ESPECIE.value == '') {
											alert('A espcie selecionada no  vlida!');
											return false;
										}
										if(OUTROS_NUM_NATUREZA.value != '' && OUTROS_NATUREZA.value == '') {
											alert('A natureza selecionada no  vlida!');
											return false;
										}
										return true;
									}
								}
								function f_on_excluir_OUTROS(){
									v_listagem = f_listagem_OUTROS();
									if(v_listagem.length == 0)
										f_controla_tipo_docto_frete();
								}
								function f_before_selecionar_OUTROS(){
									v_edicao = true;			
								}	
							</script>
                            </td>
                            </tr>
                            </table>
                        </td>
                  </tr>
              </table>
        	</fieldset>
    	</td>
	</tr>    
</table>
<script>
Calendar.setup(
    {
      inputField  : "NOTA_DATA_EMISSAO",      // ID of the input field
      ifFormat    :    "%d/%m/%Y",    // the date format
      button      : "trigger",    // ID of the button
	  range       : [2001,2050]
    }
  );
</script>
