<cfscript>
	conn = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
	qrControleRecurso = conn.get_controle_recursos(cod_recurso = "M204-REC00001");	
</cfscript>

<cfif not isDefined("vars.COD_PESSOA_FORNECEDORA") >
	<cfset vars.COD_PESSOA_FORNECEDORA = '' >
</cfif>

<cfif isdefined("vars.consulta")>
	<script language="javascript1.2" src="/_scripts/scripts_db.js"></script>
   
    <!---Busca Organograma--->
    <cffunction name="busca_organograma" access="remote" output="true">
        <script type="text/javascript">
			//Busca o Organograma
			<cfif qrOrganograma.recordcount gt 0>
				f_limpa_select(parent.document.getElementById('COD_PESSOA_FILIAL'));
				f_limpa_select(parent.document.getElementById('COD_DEPARTAMENTO'));
				f_limpa_select(parent.document.getElementById('COD_SETOR'));
				f_limpa_select(parent.document.getElementById('COD_CENTRO_CUSTO'));
				
				f_cria_option('', '-- Selecione uma Filial --', parent.document.getElementById('COD_PESSOA_FILIAL'));
				f_cria_option('', '-- Selecione um Departamento --', parent.document.getElementById('COD_SETOR'));
				f_cria_option('', '-- Selecione um Setor --', parent.document.getElementById('COD_CENTRO_CUSTO'));
				f_cria_option('', '-- Selecione uma Filial --', parent.document.getElementById('COD_DEPARTAMENTO'));
				
				<cfoutput query="qrOrganograma" group="COD_PESSOA">
					v_option = f_cria_option('#JSStringFormat(qrOrganograma.COD_PESSOA)#', '#JSStringFormat(qrOrganograma.FILIAL)#', parent.document.getElementById('COD_PESSOA_FILIAL'));
					v_option.setAttribute('mensagem', '#JSStringFormat(qrOrganograma.MENSAGEM_CONTINGENCIA)#');
				</cfoutput>
				
				parent.v_departamento = new Array();
				<cfoutput query="qrOrganograma" group="COD_PESSOA">
					<cfoutput group="COD_DEPARTAMENTO">
					parent.v_departamento.push( {
						cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
						cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
						departamento: 	  '#JSStringFormat(qrOrganograma.DEPARTAMENTO)#'
					} );
					</cfoutput>
				</cfoutput>
				
				parent.v_setor = new Array();
				<cfoutput query="qrOrganograma" group="COD_PESSOA">
					<cfoutput group="COD_DEPARTAMENTO">
						<cfoutput group="COD_SETOR">
							parent.v_setor.push( {
								cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
								cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
								cod_setor:		  '#JSStringFormat(qrOrganograma.COD_SETOR)#',
								setor:			  '#JSStringFormat(qrOrganograma.SETOR)#'
							} );
						</cfoutput>
					</cfoutput>
				</cfoutput>
				
				parent.v_centro_custo = new Array();
				<cfoutput query="qrOrganograma">
					parent.v_centro_custo.push( {
						cod_pessoa: 	  '#JSStringFormat(qrOrganograma.COD_PESSOA)#',
						cod_departamento: '#JSStringFormat(qrOrganograma.COD_DEPARTAMENTO)#',
						cod_setor:		  '#JSStringFormat(qrOrganograma.COD_SETOR)#',
						cod_centro_custo: '#JSStringFormat(qrOrganograma.COD_CENTRO_CUSTO)#',
						centro_custo: 	  '#JSStringFormat(qrOrganograma.CENTRO_CUSTO)#'
					} );
				</cfoutput>


				if(parent.document.getElementById('COD_PESSOA_FILIAL').options.length == 2) {
					parent.document.getElementById('COD_PESSOA_FILIAL').options[0] = null;
					parent.document.getElementById('COD_PESSOA_FILIAL').options[0].selected = true;
					parent.document.getElementById('COD_PESSOA_FILIAL').onchange();
				}
				
			</cfif>                    
		</script>        
    </cffunction>
    
    <!---Busca Endereos--->
    <cffunction name="busca_enderecos" access="remote" output="true">
    	<cfargument name="query" required="yes">
        <cfargument name="prefixo" required="yes">
        <cfargument name="busca" required="no" default="0">
        <cfargument name="campo_busca" required="no" default=""> 
			<script type="text/javascript">
                /*------------------------------------------------------------------------------------------------*/

				
				
				
                f_limpa_select(parent.document.getElementById('#arguments.prefixo#_CB_ENDERECO'));
                parent.v_enderecos_#arguments.prefixo# = new Array();
                <cfif arguments.query.recordcount gte 1>
				    <cfoutput query="arguments.query">
                        parent.v_enderecos_#arguments.prefixo#.push( {
                            cod_pessoa		      : '#JSStringFormat(arguments.query.cod_pessoa)#',
                            cod_endereco	      : '#JSStringFormat(arguments.query.cod_endereco)#',
                            municipio_id	      : '#JSStringFormat(arguments.query.municipio_id)#',
                            municipio		      : '#JSStringFormat(arguments.query.municipio)#',
                            cep				      : '#JSStringFormat(arguments.query.cep)#',
                            logradouro		      : '#JSStringFormat(arguments.query.logradouro)#',
                            numero			      : '#JSStringFormat(arguments.query.numero)#',
                            bairro			      : '#JSStringFormat(arguments.query.bairro)#',
                            uf				      : '#JSStringFormat(arguments.query.uf)#',
                            padrao			      : '#JSStringFormat(arguments.query.endereco_padrao)#',
							inscricao_estadual    : '#JSStringFormat(arguments.query.inscricao_estadual)#',
							cod_atividade_fiscal  : '#JSStringFormat(arguments.query.cod_atividade_fiscal)#'
                        } );

                    </cfoutput>						
					<cfif arguments.busca eq 1>
						parent.f_busca_endereco_#arguments.prefixo#('#arguments.campo_busca#');
					</cfif>
				</cfif>
                /*------------------------------------------------------------------------------------------------*/

            </script>    
    </cffunction>
    
    <!---Busca Pessoas--->
    <cffunction name="busca_pessoas" access="remote" output="true">
    	<cfargument name="query" required="yes">
        <cfargument name="prefixo" required="yes">
        <cfargument name="identificador_cod_pessoa" required="yes">
        	<script type="text/javascript">
                /*------------------------------------------------------------------------------------------------*/
                with(parent.document.forms[0]) {
					<cfif arguments.query.recordcount eq 1>
						parent.document.getElementById('sp_#arguments.prefixo#_unica').style.display = '';
						parent.document.getElementById('sp_#arguments.prefixo#_multipla').style.display = 'none';
						<cfoutput>
							#arguments.identificador_cod_pessoa#.value		= '#JSStringFormat(arguments.query.cod_pessoa)#';
							#arguments.prefixo#_TIPO_PESSOA.value			= '#JSStringFormat(arguments.query.tipo_pessoa)#';
							#arguments.prefixo#_CNPJ_CPF.value				= '#JSStringFormat(arguments.query.cnpj_cpf)#';
							#arguments.prefixo#_RAZAO_SOCIAL.value			= '#JSStringFormat(arguments.query.razao_social)#';
							parent.setReadOnly['#arguments.prefixo#'](true);
							parent.f_busca_endereco_#arguments.prefixo#(<cfoutput>'#JSStringFormat(arguments.query.cod_pessoa)#'</cfoutput>);
       parent.f_preenche_cb_ie_#arguments.prefixo#("#arguments.query.inscricao_estadual#,#arguments.query.ie_adicional#", null);
						</cfoutput>
					<cfelseif  arguments.query.recordcount gt 1>
						f_limpa_select(parent.document.getElementById('NOME_#arguments.prefixo#_COMBO'));
						parent.document.getElementById('sp_#arguments.prefixo#_unica').style.display = 'none';
						parent.document.getElementById('sp_#arguments.prefixo#_multipla').style.display = '';
						<cfoutput query="arguments.query">
							v_option = f_cria_option('#JSStringFormat(arguments.query.COD_PESSOA)#', '#JSStringFormat(arguments.query.IDENTIFICADOR)# - #JSStringFormat(arguments.query.RAZAO_SOCIAL)#', parent.document.getElementById('NOME_#arguments.prefixo#_COMBO'));
							v_option.setAttribute('tipo_pessoa', '#JSStringFormat(arguments.query.TIPO_PESSOA)#');
							v_option.setAttribute('cnpj_cpf', '#JSStringFormat(arguments.query.CNPJ_CPF)#');
							v_option.setAttribute('razao_social', '#JSStringFormat(arguments.query.RAZAO_SOCIAL)#');
							v_option.setAttribute('lista_ie', '#JSStringFormat(arguments.query.INSCRICAO_ESTADUAL)#,#JSStringFormat(arguments.query.IE_ADICIONAL)#');
						</cfoutput>

						parent.f_muda_pessoa_#arguments.prefixo#();
					<cfelse>
						parent.setReadOnly['#arguments.prefixo#'](false);
						parent.document.getElementById('sp_#arguments.prefixo#_unica').style.display = '';
						parent.document.getElementById('sp_#arguments.prefixo#_multipla').style.display = 'none';							
					</cfif>
				}
                /*------------------------------------------------------------------------------------------------*/
            </script>        
    </cffunction>
    
	<cfswitch expression="#vars.consulta#">
		<cfcase value="1">
        	<cfset retorno = StructNew()>
            
            <cftry>
                <cfscript>
                    conn = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
					connS = CreateComponent("modulos.cte._componentes.consulta.logistica.cfc_solicitacao");
					connOp = CreateComponent("modulos.cte._componentes.consulta.logistica.cfc_operacao");
					
					connCte = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");

					qrIsFracionado = conn.get_romaneio_fracionado(num_romaneio = vars.num_romaneio
													                		,solicitacao_carga_id = vars.solicitacao_carga_id);
					
					if ( qrIsFracionado.fracionado eq 1 ){
					   qrConhecimento = conn.get_operacao_ctrc_fracionado(carga_consolidada_id = vars.CARGA_CONSOLIDADA_ID, num_romaneio = vars.num_romaneio, solicitacao_carga_id = vars.solicitacao_carga_id, acerto = vars.acerto);
					} else {
					   qrConhecimento = conn.get_operacao_ctrc(viagem_carga_id = vars.VIAGEM_CARGA_ID, acerto = vars.acerto);
					}
					
					
					qrInscricoesEstaduais = conn.get_inscricoes_estaduais_pessoa(cod_pessoa = 1);
					qrGerencial = conn.get_organizacional(operacao_id = qrConhecimento.OPERACAO_ID, entrada_saida=1);
					
					qrEspecie = conn.get_especie(num_especie = qrConhecimento.num_especie);
					qrNatureza = conn.get_natureza(num_natureza = qrConhecimento.num_natureza);
										
					
					if (Len(Trim(qrConhecimento.num_natureza_operacao))){
						qrNatureza_operacao = conn.get_natureza(num_natureza = qrConhecimento.num_natureza_operacao);
					}else{
						qrNatureza_operacao.descricao = '';
					}
					
					v_operacao_vale_pedagio = qrConhecimento.OPERACAO_ID;
										
					// Vale pedagio
					qrValePedagio = conn.verifica_emissao_vale_pedagio(operacao_id          = v_operacao_vale_pedagio
				                                                      ,num_romaneio         = vars.num_romaneio
																	  ,viagem_carga_id      = vars.VIAGEM_CARGA_ID
																	  ,solicitacao_carga_id = vars.solicitacao_carga_id);

					
					fnc_trata_erros(struct_erro = qrValePedagio, mostra_msg_ok  = false);
					
					if (qrValePedagio.EMITE_VALEPEDAGIO eq 2){
						if(Len(Trim(qrValePedagio.NUM_COMPROVANTE))){
							qrVale = conn.get_vale_pedagio(num_comprovante = qrValePedagio.NUM_COMPROVANTE);
						} else {																										
							qrValorVale = conn.get_vale_pedagio_valor(solicitacao_carga_id = vars.SOLICITACAO_CARGA_ID
																	 ,viagem_id            = qrConhecimento.VIAGEM_ID
							                                         );	
							
							fnc_trata_erros(struct_erro = qrValorVale, mostra_msg_ok  = false);
						}
					}
					
					qrEmpresa = conn.get_empresa();
					
					if (Len(Trim(vars.lancto_id)) ){
						qrAcertoNF = connCte.get_carta_frete_nf(lancto_id = vars.LANCTO_ID);
					}
					
					if ( qrIsFracionado.fracionado eq 1 ){
					   qrEnderecos = connS.get_id_enderecos_solicitacao_frac(solicitacao_carga_id = vars.solicitacao_carga_id);
					} else {
					qrEnderecos = connS.get_id_enderecos_solicitacao(num_romaneio = vars.num_romaneio, viagem_carga_id = vars.viagem_carga_id);
					}

					//Busca Endereos
					if(Len(Trim(qrEnderecos.endereco_remetente_id))){
						varEndRem = '1';
						qrEnderecosRemetente = connS.get_enderecos_solicitacao(cod_endereco = qrEnderecos.endereco_remetente_id);
					} else {
					    varEndRem = '0';
						if (Len(Trim(qrConhecimento.cod_remetente)) ){
						   qrEnderecosRemetente = connOp.get_operacao_enderecos(cod_pessoa = qrConhecimento.cod_remetente);
						}
					}
					
					if(Len(Trim(qrEnderecos.endereco_coleta_id))){
						varEndCol = '1';
						qrEnderecosColeta = connS.get_enderecos_solicitacao(cod_endereco = qrEnderecos.endereco_coleta_id);
					} else {
						varEndCol = '0';
						if (Len(Trim(qrConhecimento.cod_consignatario)) ){
							qrEnderecosColeta = connOp.get_operacao_enderecos(cod_pessoa = qrConhecimento.cod_consignatario);
						}
					}
					
					if(Len(Trim(qrEnderecos.endereco_destinatario_id))){
						varEndDest = '1';
						qrEnderecosDestinatario = connS.get_enderecos_solicitacao(cod_endereco = qrEnderecos.endereco_destinatario_id);
					} else {
					    varEndDest = '0';
						if (Len(Trim(qrConhecimento.cod_destinatario)) ){
						   qrEnderecosDestinatario = connOp.get_operacao_enderecos(cod_pessoa = qrConhecimento.cod_destinatario);
						}
					}
					
					if(Len(Trim(qrEnderecos.endereco_entrega_id))){
						varEndEnt = '1';
						qrEnderecosEntrega = connS.get_enderecos_solicitacao(cod_endereco = qrEnderecos.endereco_entrega_id);
					} else {
					    varEndEnt = '0';
						if (Len(Trim(qrConhecimento.cod_redespacho)) ){
							qrEnderecosEntrega = connOp.get_operacao_enderecos(cod_pessoa = qrConhecimento.cod_redespacho);
						}
					}
					
					if (Len(Trim(qrConhecimento.cod_negociador))){
						qrEnderecosNegociador = connOp.get_operacao_enderecos(cod_pessoa = qrConhecimento.cod_negociador);
					}
					
					//Busca Pessoas
					if ( Len(Trim(qrConhecimento.COD_CLIENTE_COBRANCA)) ){
						qrPessoasCobranca   = connOp.get_operacao_pessoa(cod_pessoa = qrConhecimento.COD_CLIENTE_COBRANCA);
					}else if ( qrIsFracionado.fracionado eq 1 ){
					   qrPessoasCobranca   = connOp.get_operacao_pessoa_fracionado(carga_consolidada_id = qrConhecimento.CARGA_CONSOLIDADA_ID, tipo_cliente = 4);
					} else {
					   qrPessoasCobranca   = connOp.get_operacao_pessoa(viagem_carga_id = vars.VIAGEM_CARGA_ID, tipo_cliente = 4);
					}
					
					if(Len(Trim(qrEnderecos.endereco_cobranca_id))){
						varEndCob = '1';
						qrEnderecosCobranca = connS.get_enderecos_solicitacao(cod_endereco = qrEnderecos.endereco_cobranca_id);
					} else {
						varEndCob = '0';
						if ( qrIsFracionado.fracionado eq 1 ){
							qrEnderecosCobranca = connOp.get_operacao_enderecos_fracionado(carga_consolidada_id = qrConhecimento.CARGA_CONSOLIDADA_ID, tipo_cliente = 4);
						} else {
							qrEnderecosCobranca = connOp.get_operacao_enderecos(viagem_carga_id = vars.VIAGEM_CARGA_ID, tipo_cliente = 4);
						}
					}
					
					//Busca o Organograma
					qrOrganograma = connOp.get_organograma(operacao_id = qrConhecimento.OPERACAO_ID, lotacao = vars.lotacao);
					
					//Busca a Composio
					if (Len(Trim(qrConhecimento.composicao)) ){
						v_composicao = ListToArray(qrConhecimento.composicao, ' > ');
						
						if( Len(Trim(v_composicao[1])) ){
							conn = CreateComponent("modulos.cte._componentes.consulta.cfc_veiculo");
							qrProprietario = conn.get_motorista_proprietario(placa_controle = v_composicao[1], qrConhecimento = vars.DATA_EMISSAO);
						}
					}
					
					qrSolicitacaoNF = connS.get_solicitacao_carga_nf(viagem_carga_id = vars.VIAGEM_CARGA_ID, xml = 1, solicitacao_carga_id = vars.SOLICITACAO_CARGA_ID);
					
					if (qrConhecimento.emite_multimodal eq 1) {
					    qrSolicitacaoCTeMultimodal = connS.get_cte_multimodal_sol_carga(solicitacao_carga_id = vars.SOLICITACAO_CARGA_ID);
					}
					
					connC = CreateComponent("_transportes.consulta.cfc_global");
					v_valor_parametro	     = connC.get_parametro_valor(25, 'FISCAL.EXE', 7, 50);
					v_gerencial_obrigatorio	 = iif(v_valor_parametro eq 'Sim', true , false);
					
					retorno.erro = false;
                    retorno.mensagem = '';
                </cfscript>	
				
				<cfif vars.PARAM_DATA_BASE_COMPOSICAO eq 'Data de incio da solicitao'>
					<script>
						with(parent.document.forms[0]){
							DATA_BASE_COMPOSICAO.value = <cfoutput>'#qrConhecimento.data_carregamento_inicio#'</cfoutput>;
						}
					</script>
				</cfif>
				
                <script type="text/javascript">
					if(<cfoutput>#varEndRem#</cfoutput> == 1){
						parent.document.getElementById('REM_ENDERECO_SOLICITACAO').value = '<cfoutput>#qrEnderecos.endereco_remetente_id#</cfoutput>';
						parent.document.getElementById('REM_LBL_AVISO').style.display = '';
						parent.document.getElementById('REM_CB_ENDERECO').setAttribute("disabled", "disabled");						
					} else {
						parent.document.getElementById('REM_ENDERECO_SOLICITACAO').value = 0;
						parent.document.getElementById('REM_LBL_AVISO').style.display = 'none';
						parent.document.getElementById('REM_CB_ENDERECO').removeAttribute("disabled");
					}
					if(<cfoutput>#varEndDest#</cfoutput> == 1){
						parent.document.getElementById('DEST_ENDERECO_SOLICITACAO').value = '<cfoutput>#qrEnderecos.endereco_destinatario_id#</cfoutput>';
						parent.document.getElementById('DEST_LBL_AVISO').style.display = '';
						parent.document.getElementById('DEST_CB_ENDERECO').setAttribute("disabled", "disabled");
					} else {
						parent.document.getElementById('DEST_ENDERECO_SOLICITACAO').value = 0;
						parent.document.getElementById('DEST_LBL_AVISO').style.display = 'none';
						parent.document.getElementById('DEST_CB_ENDERECO').removeAttribute("disabled");	
					}
					if(<cfoutput>#varEndCol#</cfoutput> == 1){
						parent.document.getElementById('COLETA_ENDERECO_SOLICITACAO').value = '<cfoutput>#qrEnderecos.endereco_coleta_id#</cfoutput>';
						parent.document.getElementById('COLETA_LBL_AVISO').style.display = '';
						parent.document.getElementById('COLETA_CB_ENDERECO').setAttribute("disabled", "disabled");
					} else {
						parent.document.getElementById('COLETA_ENDERECO_SOLICITACAO').value = 0;
						parent.document.getElementById('COLETA_LBL_AVISO').style.display = 'none';
						parent.document.getElementById('COLETA_CB_ENDERECO').removeAttribute("disabled");
					}
					if(<cfoutput>#varEndEnt#</cfoutput> == 1){
						parent.document.getElementById('RED_ENDERECO_SOLICITACAO').value = '<cfoutput>#qrEnderecos.endereco_entrega_id#</cfoutput>';
						parent.document.getElementById('RED_LBL_AVISO').style.display = '';
						parent.document.getElementById('RED_CB_ENDERECO').setAttribute("disabled", "disabled");
					} else {
						parent.document.getElementById('RED_ENDERECO_SOLICITACAO').value = 0;
						parent.document.getElementById('RED_LBL_AVISO').style.display = 'none';
						parent.document.getElementById('RED_CB_ENDERECO').removeAttribute("disabled");
					}
					if(<cfoutput>#varEndCob#</cfoutput> == 1){
					 parent.document.getElementById('COB_ENDERECO_SOLICITACAO').value = '<cfoutput>#qrEnderecos.endereco_cobranca_id#</cfoutput>';
						parent.document.getElementById('COB_LBL_AVISO').style.display = '';
						parent.document.getElementById('COB_CB_ENDERECO').setAttribute("disabled", "disabled");
					} else {
						parent.document.getElementById('COB_ENDERECO_SOLICITACAO').value = 0;
						parent.document.getElementById('COB_LBL_AVISO').style.display = 'none';
						parent.document.getElementById('COB_CB_ENDERECO').removeAttribute("disabled");
					}
				    parent.f_preenche_cb_ie_REM("<cfoutput>#qrConhecimento.rem_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.rem_inscricao_estadual#</cfoutput>");
			  	    parent.f_preenche_cb_ie_DEST("<cfoutput>#qrConhecimento.dest_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.dest_inscricao_estadual#</cfoutput>");
				    parent.f_preenche_cb_ie_COLETA("<cfoutput>#qrConhecimento.coleta_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.cons_inscricao_estadual#</cfoutput>");
				    parent.f_preenche_cb_ie_COB("<cfoutput>#qrConhecimento.cob_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.cob_inscricao_estadual#</cfoutput>");
					parent.f_preenche_cb_ie_RED("<cfoutput>#qrConhecimento.entrega_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.redespacho_inscricao_estadual#</cfoutput>");
					parent.f_preenche_cb_ie_NEG("<cfoutput>#qrConhecimento.neg_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.neg_inscricao_estadual#</cfoutput>");
				</script>
				<cfif qrOrganograma.recordcount eq 0>
                    <script type="text/javascript">
                        alert('Romaneio no pertence a esta filial!');
                        parent.f_limpa_romaneio();
                    </script>
                    
                    <cfabort>
                </cfif>
				
				<cfif Len(Trim(qrConhecimento.PERMITE_EMITIR_CTE))>
                    <script type="text/javascript">
                        <cfoutput>
						alert('No foi possvel continuar. #JSStringFormat(qrConhecimento.PERMITE_EMITIR_CTE)#');
						</cfoutput>
						parent.document.getElementById('tr_romaneio_carregando').style.display = 'none';
                        parent.f_limpa_romaneio();
                    </script>
                    <cfabort>
                </cfif>
				
                <cfif qrConhecimento.recordcount gt 0>
                    <script type="text/javascript">
                        parent.f_calculos = function() {};
                        parent.v_emite_tabela_frete = -1;
						
                        parent.document.getElementById('td_negociacao_info').innerHTML = 'Por favor, informe o negociador para buscar qual forma ir&aacute; utilizar para executar os c&aacute;lculos.';
                        
                        parent.document.getElementById('tr_negociacao_tabela_frete').style.display = 'none';
                        parent.document.getElementById('tr_negociacao_convencional').style.display = 'none';
                        parent.document.getElementById('tr_negociacao_info').style.display = '';
                        
                        <cfoutput>
                            with(parent.document.forms[0]) {
                                OPERACAO_ID.value               = '#JSStringFormat(qrConhecimento.operacao_id)#';
								PAGTO_VALE_PEDAGIO.value        = '#JSStringFormat(qrConhecimento.pagto_vale_pedagio)#';
							    VP_OBRIGATORIO_CTE.value        = '#JSStringFormat(qrConhecimento.vp_obrigatorio_cte)#';
								NUM_ROMANEIO_FROTA.value = '#JSStringFormat(vars.num_romaneio)#';
								TIPO_FRETE.value = '#JSStringFormat(qrConhecimento.tipo_frete)#';
                                parent.f_preenche_operacao('#JSStringFormat(qrConhecimento.operacao_id)#', '#JSStringFormat(qrConhecimento.operacao_descricao)#');
								TIPO_SERVICO_COMERCIAL.value   =  '#JSStringFormat(qrConhecimento.TIPO_SERVICO_ID)#';
								TIPO_DOCTO_FRETE.value  =  '#JSStringFormat(qrConhecimento.TIPO_DOCTO_FRETE)#';
								VIAGEM_ID.value  =  '#qrConhecimento.VIAGEM_ID#';
								EMITE_MULTIMODAL.value = '#qrConhecimento.EMITE_MULTIMODAL#';
								VINCULADO_MULTIMODAL.value = '#qrConhecimento.VINCULADO_MULTIMODAL#';
								POSSUI_MULTIMODAL_VINCULADO.value = '#qrConhecimento.POSSUI_MULTIMODAL_VINCULADO#';
								TIPO_DOCUMENTO_OPERACAO.value = '#qrConhecimento.TIPO_DOCUMENTO_OPERACAO#';
								parent.f_valida_cte_ref();
								parent.f_valida_obs_globalizado();
								VIAGEM_ID.value  =  '#qrConhecimento.VIAGEM_ID#';		
								parent.f_controla_tipo_docto_frete();
								parent.f_pedido_shipment_obrigatorio('#qrConhecimento.PEDIDO_SHIPMENT#');
								PEDIDO_SHIPMENT_EDICAO.value = '#qrConhecimento.PEDIDO_SHIPMENT_EDICAO#';
								parent.f_pedido_shipment_edicao('#qrConhecimento.PEDIDO_SHIPMENT_EDICAO#');
								
                                NUM_PRODUTO.value 			= '#JSStringFormat(qrConhecimento.num_produto)#';
								REGRA_FISCAL.value 			= '#JSStringFormat(qrConhecimento.regra_fiscal_id)#';
                                REGRA_FISCAL_ID.value 		= '#JSStringFormat(qrConhecimento.regra_fiscal_id)#';
								COD_ATIVIDADE.value			= '#JSStringFormat(qrConhecimento.cod_atividade_fiscal)#';
							    PEDIDO_SHIPMENT_SOLICITACAO.value = '#JSStringFormat(qrConhecimento.pedido_shipment_solicitacao)#';
								
								OBSERVACAO.value			= '#JSStringFormat(qrConhecimento.observacao)#';
							
                                
                                //Busca o Remetente
                                if ('#JSStringFormat(qrConhecimento.cod_remetente)#') {
									COD_REMETENTE.value			= '#JSStringFormat(qrConhecimento.cod_remetente)#';
									REM_TIPO_PESSOA.value		= '#JSStringFormat(qrConhecimento.rem_tipo_pessoa)#';
									REM_CNPJ_CPF.value			= '#JSStringFormat(qrConhecimento.rem_cnpj_cpf)#';
									REM_RAZAO_SOCIAL.value		= '#JSStringFormat(qrConhecimento.rem_razao_social)#';
									//REM_INSCRICAO_ESTADUAL.value= '#JSStringFormat(qrConhecimento.rem_inscricao_estadual)#';
									
									parent.setReadOnly['REM'](true);
                                } else {
									parent.setReadOnly['REM'](false);
											}
                                
                                if ('#JSStringFormat(qrConhecimento.cod_destinatario)#') {
									COD_DESTINATARIO.value		  = '#JSStringFormat(qrConhecimento.cod_destinatario)#';
									DEST_TIPO_PESSOA.value		  = '#JSStringFormat(qrConhecimento.dest_tipo_pessoa)#';
									DEST_CNPJ_CPF.value			  = '#JSStringFormat(qrConhecimento.dest_cnpj_cpf)#';
									DEST_RAZAO_SOCIAL.value		  = '#JSStringFormat(qrConhecimento.dest_razao_social)#';
									//DEST_INSCRICAO_ESTADUAL.value = '#JSStringFormat(qrConhecimento.dest_inscricao_estadual)#';
									
									parent.setReadOnly['DEST'](true);
                                } else {
									parent.setReadOnly['DEST'](false);
											}
                                
                                if('#JSStringFormat(qrConhecimento.cod_negociador)#') {
                                        COD_NEGOCIADOR.value			= '#JSStringFormat(qrConhecimento.cod_negociador)#';
                                        NEG_TIPO_PESSOA.value			= '#JSStringFormat(qrConhecimento.neg_tipo_pessoa)#';
                                        NEG_CNPJ_CPF.value				= '#JSStringFormat(qrConhecimento.neg_cnpj_cpf)#';
                                        NEG_RAZAO_SOCIAL.value			= '#JSStringFormat(qrConhecimento.neg_razao_social)#';
                                        //NEG_INSCRICAO_ESTADUAL.value	= '#JSStringFormat(qrConhecimento.neg_inscricao_estadual)#';
                                        
										parent.setReadOnly['NEG'](true);
                                }
                                
                                if ('#JSStringFormat(qrConhecimento.cod_consignatario)#' != '') {
                                    COLETA_COD_PESSOA.value			= '#JSStringFormat(qrConhecimento.cod_consignatario)#';
                                    COLETA_TIPO_PESSOA.value		= '#JSStringFormat(qrConhecimento.cons_tipo_pessoa)#';
                                    COLETA_CNPJ_CPF.value			= '#JSStringFormat(qrConhecimento.cons_cnpj_cpf)#';
                                    COLETA_RAZAO_SOCIAL.value   	= '#JSStringFormat(qrConhecimento.cons_razao_social)#';
                                    //COLETA_INSCRICAO_ESTADUAL.value	= '#JSStringFormat(qrConhecimento.cons_inscricao_estadual)#';
                                }
								
								if('#JSStringFormat(qrConhecimento.permite_editar_consignatario)#' == 0){
									parent.setReadOnly['COLETA'](true);
								}
                                
                                <cfif not isdefined("vars.terceiro") and not isdefined("vars.complemento") >								
                                    if (ITEM_ID.value == '00' && Number(ENTREGAS.value) == 1) {
                                        if (MUNICIPIO_ID_ORIGEM.value != COLETA_MUNICIPIO_ID.value) {
                                            alert('Problema na integridade das rotas. Origem do CTRC  ( ' + COLETA_MUNICIPIO.value + '-' + COLETA_UF.value + ') difere do destino da ultima rota do veculo ( '+ MUNICIPIO_ORIGEM.value +' ). Altere o local de coleta ou o lote.');
                                            document.getElementById('btn_buscar_lote').click();
                                        }						
                                    }								
                                </cfif>
                                
                                if ('#JSStringFormat(qrConhecimento.cod_redespacho)#' != '') {
                                    // Redespacho
                                    COD_REDESPACHO.value 	= '#JSStringFormat(qrConhecimento.cod_redespacho)#';
                                    RED_TIPO_PESSOA.value 	= '#JSStringFormat(qrConhecimento.redespacho_tipo_pessoa)#';
                                    RED_CNPJ_CPF.value 		= '#JSStringFormat(qrConhecimento.redespacho_cnpj_cpf)#';
                                    RED_RAZAO_SOCIAL.value 	= '#JSStringFormat(qrConhecimento.redespacho_razao_social)#';
                                    //RED_INSCRICAO_ESTADUAL.value = '#JSStringFormat(qrConhecimento.redespacho_inscricao_estadual)#';
                                }
								
								if('#JSStringFormat(qrConhecimento.permite_editar_redespacho)#' == 0){
									parent.setReadOnly['RED'](true);
								}
                                
                                NUM_NATUREZA.value			= '#JSStringFormat(qrConhecimento.num_natureza)#';
                                NATUREZA.value				= '#JSStringFormat(qrNatureza.descricao)#';
								/*Natureza das notas*/
								NOTA_NUM_NATUREZA.value		= '#JSStringFormat(qrConhecimento.num_natureza_operacao)#';
								NOTA_NATUREZA.value			= '#JSStringFormat(qrNatureza_operacao.descricao)#';
								NFE_NUM_NATUREZA.value		= '#JSStringFormat(qrConhecimento.num_natureza_operacao)#';
								NFE_NATUREZA.value			= '#JSStringFormat(qrNatureza_operacao.descricao)#';
								OUTROS_NUM_NATUREZA.value	= '#JSStringFormat(qrConhecimento.num_natureza_operacao)#';
								OUTROS_NATUREZA.value		= '#JSStringFormat(qrNatureza_operacao.descricao)#';
								
								SOLICITACAO_NUM_NATUREZA.value = '#JSStringFormat(qrConhecimento.num_natureza_operacao)#';

                                NUM_ESPECIE.value			= '#JSStringFormat(qrConhecimento.num_especie)#';
                                ESPECIE.value				= '#JSStringFormat(qrEspecie.descricao)#';
                                COD_UNIDADE.value			= '#JSStringFormat(qrConhecimento.cod_unidade)#';
                                FRETE_EM.value				= '#JSStringFormat(qrConhecimento.frete_em)#';
                                
                                parent.v_num_natureza_notas		= '#JSStringFormat(qrConhecimento.num_natureza)#';
                                parent.v_num_especie_notas		= '#JSStringFormat(qrConhecimento.num_especie)#';
                                parent.v_cod_unidade_notas		= '#JSStringFormat(qrConhecimento.cod_unidade)#';
                                
                                MOTORISTA.value				= '#JSStringFormat(qrConhecimento.motorista_nome)#';
                                NOME_MOTORISTA.value		= '#JSStringFormat(qrConhecimento.motorista_nome)#';
                                COD_MOTORISTA.value 		= '#JSStringFormat(qrConhecimento.motorista)#';
                                parent.f_limpar_engates();
                                PLACA_CONTROLE.value =  '';
								PLACA_CONTROLE.onchange();
                                
                                parent.f_atualiza_pagador();
                            }	
                        </cfoutput>
                    </script>
                        
                    <!---Busca os endereos do Remetente--->
                    <cfif IsDefined("qrEnderecosRemetente")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosRemetente, prefixo = "REM", busca = 1, campo_busca = QrConhecimento.cod_remetente);
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os endereos da Coleta--->
                    <cfif IsDefined("qrEnderecosColeta")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosColeta, prefixo = "COLETA", busca = 1, campo_busca = QrConhecimento.cod_consignatario);
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os endereos do Destinatrio--->
                    <cfif IsDefined("qrEnderecosDestinatario")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosDestinatario, prefixo = "DEST", busca = 1, campo_busca = QrConhecimento.cod_destinatario);
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os endereos da Entrega--->
                    <cfif IsDefined("qrEnderecosEntrega")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosEntrega, prefixo = "RED", busca = 1, campo_busca = QrConhecimento.cod_redespacho);
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os endereos do Negociador--->
                    <cfif IsDefined("qrEnderecosNegociador")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosNegociador, prefixo = "NEG", busca = 1, campo_busca = QrConhecimento.cod_negociador);
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os endereos dde Cobrana--->
                    <cfif IsDefined("qrEnderecosCobranca")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosCobranca, prefixo = "COB");
                        </cfscript>
                    </cfif>
                    
                    
                    <!---Busca os Clientes de Cobrana--->
                    <cfif IsDefined("qrPessoasCobranca")>
                        <cfscript>
                            busca_pessoas(query = qrPessoasCobranca, prefixo = "COB",identificador_cod_pessoa = "COD_CLIENTE_COBRANCA");
                        </cfscript>
                    </cfif>
                    
                        
                    <!---Busca o Organograma--->
                    <cfif vars.lotacao eq 0>
                        <cfscript>
                           busca_organograma();
                        </cfscript>
                    </cfif>
                    
                    <!---Busca o Centro de Custo Gerencial--->
					<script type="text/javascript">
                        with(parent.document.forms[0]) {
                            parent.f_limpa_select(parent.document.getElementById('ORGANIZACIONAL_ID'));
							
							<cfif qrGerencial.recordcount gt 1>
								v_option = f_cria_option('', '-- Selecione --', parent.document.getElementById('ORGANIZACIONAL_ID'));
								v_option.setAttribute('codigo', '');
							</cfif>
							
							<cfif qrGerencial.recordcount gte 1>
								<cfoutput query="qrGerencial">
									v_option = f_cria_option('#qrGerencial.ORGANIZACIONAL_ID#', '#JSStringFormat(qrGerencial.DESCRICAO_COMPLETA)#', parent.document.getElementById('ORGANIZACIONAL_ID'));
									v_option.setAttribute('codigo', '#qrGerencial.COD_ORGANIZACIONAL#');
								</cfoutput>
								
								if( ORGANIZACIONAL_ID_GERENCIAL.value != '' && ORGANIZACIONAL_ID_GERENCIAL.value == '#qrGerencial.ORGANIZACIONAL_ID#'){


                                    v_opt.selected = true;
                                    COD_ORGANIZACIONAL.value = '#qrGerencial.COD_ORGANIZACIONAL#';
                                }
							<cfelse>
								<cfif v_gerencial_obrigatorio>
									alert('Nenhum Centro de Custo Gerencial foi encontrado para esta operao.');
								</cfif>
							</cfif>
							
							<cfif not isDefined("vars.complemento") or vars.complemento neq 1>
                                <cfif qrGerencial.recordcount eq 1>
                                    ORGANIZACIONAL_ID.onchange();
                                    ORGANIZACIONAL_ID.disabled = true;
                                    COD_ORGANIZACIONAL.readOnly = true;
                                <cfelse>
                                    ORGANIZACIONAL_ID.disabled = false;
                                    COD_ORGANIZACIONAL.readOnly = false;
                                </cfif>
                            </cfif>
                        }
						
						<cfif IsDefined("qrAcertoNF")>
							<script type="text/javascript">
								with(parent.document.forms[0]) {
									parent.f_limpar_NOTAS_FISCAIS();
									TIPO_DOCUMENTO_ID.value = '0';
									TIPO_DOCUMENTO_ID.onchange();
									parent.v_inserida = 1;
								}
							</script>

							<cfoutput query="qrAcertoNF">
								<script type="text/javascript">

											with(parent.document.forms[0]) {
												NOTA_CFOP.setAttribute('obrigatorio', 0);
												parent.f_incluir_NOTAS_FISCAIS();

												NOTA_M3.value			= 0;
												NOTA_NUMERO.value		= '#JSStringFormat(qrAcertoNF.numero)#';
												NOTA_DATA_EMISSAO.value	= '#JSStringFormat(qrAcertoNF.data_emissao)#';
												NOTA_MODELO.value		= '#JSStringFormat(qrAcertoNF.modelo)#';
												NOTA_MODELO.onchange();
												NOTA_SERIE.value     = '#JSStringFormat(qrAcertoNF.serie)#';
												NOTA_SERIE.onchange();
												NOTA_SUB_SERIE.value = '#JSStringFormat(qrAcertoNF.sub_serie)#';
												NOTA_VALOR.value		  = toCurrency('#JSStringFormat(qrAcertoNF.valor_total)#');
												NOTA_VALOR_SEGURADO.value = toCurrency('#JSStringFormat(qrAcertoNF.valor_total)#');
												NOTA_ORDEM_COMPRA.value   = '';
												NOTA_QTDE_VOLUME.value	  = '1';
												NOTA_COD_UNIDADE.value	  = 'Kg';
												NOTA_NUM_NATUREZA.value	  = '#JSStringFormat(qrConhecimento.num_natureza)#';
												NOTA_NATUREZA.value    	  = '#JSStringFormat(qrConhecimento.natureza)#';
												NOTA_COMPLEMENTO.value    = '';
												NOTA_NUM_ESPECIE.value 	  = '#JSStringFormat(qrConhecimento.num_especie)#';
												NOTA_ESPECIE.value 		  = '#JSStringFormat(qrConhecimento.especie)#';
												NOTA_ALTURA.value 		  = '0';
												NOTA_COMPRIMENTO.value 	  = '0';
												NOTA_LARGURA.value 		  = '0';
												NOTA_CUBAGEM_SUGERIDA.value 		  = '0';
												NOTA_CUBAGEM.value 		  = '0';
												NOTA_CFOP.value 		  = '#JSStringFormat(qrAcertoNF.cfop)#';
												NOTA_PESO.value               = 0;
												NOTA_PESO_CUBADO.value        = 0;
												NOTA_PESO_KG_CONVERTIDO.value = 0;
												NOTA_PESO_COBRADO.value       = 0;


												parent.f_salvar_NOTAS_FISCAIS();
														NOTA_CFOP.setAttribute('obrigatorio', 1);
											}
								</script>
							</cfoutput>
						</cfif>
		
                        <!---Dados do Proprietrio--->
                        <cfif IsDefined("qrProprietario")>

                            with(parent.document.forms[0]) {
                                parent.v_placas_viagem = <cfoutput>'#JSStringFormat(qrConhecimento.composicao)#'</cfoutput>;

                                if (parent.v_placas_viagem.length) {
                                    parent.v_placas_viagem = parent.v_placas_viagem.split(' > ');
                                    for (var i=0; i<parent.v_placas_viagem.length; i++){
                                        if (i==0) {
                                            PLACA_CONTROLE.value =  parent.v_placas_viagem[i];
											PLACA_CONTROLE.onchange();
                                            if(PLACA_CONTROLE.value != ''){
                                                
                                                <cfoutput>
                                                    COD_PROPRIETARIO.value  = '#JSStringFormat(qrProprietario.cod_pessoa_proprietario)#';
                                                    PROP_CNPJ_CPF.value 	= '#JSStringFormat(qrProprietario.cnpj_prop)#';
                                                    PROPRIETARIO.value      = '#JSStringFormat(qrProprietario.proprietario)#';
                                                    PROP_RAZAO_SOCIAL.value = '#JSStringFormat(qrProprietario.proprietario)#';
                                                    PROP_ENDERECO.value     = '#JSStringFormat(qrProprietario.endereco)#';
                                                    PROP_UF.value 			= '#JSStringFormat(Trim(qrProprietario.uf))#';
                                                </cfoutput>
                                                
                                            }
                                        } else {
                                            parent.f_engata();
                                            parent.f_seta_placa_referencia(parent.v_placas_viagem[i],i);
                                        }
                                    }
									
									parent.setReadOnly['composicao'](true);
									parent.f_valida_veiculos();
                                }
                            }
                        </cfif>

						<!---Remove trava de obrigatoriedade do campo pedido/shipment--->
						v_pedido_ship_nf  = parent.document.getElementById('NOTA_ORDEM_COMPRA');
						v_pedido_ship_nfe = parent.document.getElementById('NFE_ORDEM_COMPRA');
						v_pedido_ship_outros = parent.document.getElementById('OUTROS_ORDEM_COMPRA');
						v_pedido_ship_obrigatorio_nf  = v_pedido_ship_nf.getAttribute('obrigatorio');
						v_pedido_ship_obrigatorio_nfe = v_pedido_ship_nfe.getAttribute('obrigatorio');
						v_pedido_ship_obrigatorio_outros = v_pedido_ship_outros.getAttribute('obrigatorio');
						v_pedido_ship_nf.setAttribute('obrigatorio',0);
						v_pedido_ship_nfe.setAttribute('obrigatorio',0);
						v_pedido_ship_outros.setAttribute('obrigatorio',0);
                                
                        <!---Busca as Notas Ficais Vinculadas a Solicitao de Carga--->
                        with(parent.document.forms[0]) {
                        parent.f_limpar_NOTAS_FISCAIS();
							<cfif qrSolicitacaoNF.recordCount gt 0 >
							TIPO_DOCUMENTO_ID.value = <cfoutput>'#JSStringFormat(qrSolicitacaoNF.tipo_documento_id)#'</cfoutput>;
							if(TIPO_DOCUMENTO_ID.value == ''){
								TIPO_DOCUMENTO_ID.value = 1;
							}
							
                            TIPO_DOCUMENTO_ID.onchange();
							</cfif>
                            parent.v_inserida = 1;
                        }
                        
                        <cfoutput query="qrSolicitacaoNF">
							<cfif Len(Trim(qrSolicitacaoNF.NFE_XML))>								
								   <cffile action = "write" file ='#expandPath("/")#temp/nfe_#qrSolicitacaoNF.chave_acesso_nfe#.xml' output = "#qrSolicitacaoNF.NFE_XML#">								
							</cfif>
							
							<cfswitch expression="#qrSolicitacaoNF.tipo_documento_id#">
								<cfcase value="0">
									with(parent.document.forms[0]) {
										NOTA_CFOP.setAttribute('obrigatorio', 0);
										parent.f_incluir_NOTAS_FISCAIS();
												
										NOTA_M3.value			= '#JSStringFormat(qrSolicitacaoNF.m3)#';
										NOTA_NUMERO.value		= '#JSStringFormat(qrSolicitacaoNF.numero)#';
										NOTA_DATA_EMISSAO.value	= '#JSStringFormat(qrSolicitacaoNF.data_emissao)#';
										NOTA_MODELO.value		= '#JSStringFormat(qrSolicitacaoNF.modelo)#';
										NOTA_MODELO.onchange();
										NOTA_SERIE.value     = '#JSStringFormat(qrSolicitacaoNF.serie)#';
										NOTA_SERIE.onchange();
										NOTA_SUB_SERIE.value = '#JSStringFormat(qrSolicitacaoNF.sub_serie)#';
										NOTA_VALOR.value		  = toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_total)#');
										NOTA_VALOR_SEGURADO.value = toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_segurado)#');
										NOTA_ORDEM_COMPRA.value   = '#JSStringFormat(qrSolicitacaoNF.ordem_compra_cliente)#';
										NOTA_QTDE_VOLUME.value	  = '#JSStringFormat(qrSolicitacaoNF.qtde_volume)#';
										NOTA_COD_UNIDADE.value	  = 'Kg';
										NOTA_NUM_NATUREZA.value	  = '#JSStringFormat(qrSolicitacaoNF.num_natureza)#';
										NOTA_NATUREZA.value    	  = '#JSStringFormat(qrSolicitacaoNF.natureza)#';
										NOTA_COMPLEMENTO.value    = '';
										NOTA_NUM_ESPECIE.value 	  = '#JSStringFormat(qrSolicitacaoNF.num_especie)#';
										NOTA_ESPECIE.value 		  = '#JSStringFormat(qrSolicitacaoNF.especie)#';
										NOTA_ALTURA.value 		  = ('#JSStringFormat(qrSolicitacaoNF.altura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.altura)#';
										NOTA_COMPRIMENTO.value 	  = ('#JSStringFormat(qrSolicitacaoNF.comprimento)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.comprimento)#';
										NOTA_LARGURA.value 		  = ('#JSStringFormat(qrSolicitacaoNF.largura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.largura)#';
										NOTA_CUBAGEM_SUGERIDA.value 		  = '#JSStringFormat(qrSolicitacaoNF.cubagem_sugerida)#';
										NOTA_CUBAGEM.value 		  = '#JSStringFormat(qrSolicitacaoNF.cubagem)#';
										NOTA_CFOP.value 		     = '#JSStringFormat(qrSolicitacaoNF.cfop)#';
										ICMS_PARTILHADO.value     = 0;
										<cfif IsDefined("vars.COMPLEMENTO") and vars.COMPLEMENTO eq 1>
											NOTA_PESO.value               = 0;
											NOTA_PESO_CUBADO.value        = 0;
											NOTA_PESO_KG_CONVERTIDO.value = 0;
											NOTA_PESO_COBRADO.value       = 0;
										<cfelse>	
											NOTA_PESO.value               = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											NOTA_PESO_CUBADO.value        = '#JSStringFormat(qrSolicitacaoNF.peso_cubado)#';
											NOTA_PESO_KG_CONVERTIDO.value = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											NOTA_PESO_COBRADO.value       = ('#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#' == '') ? '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#' : '#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#';
										</cfif>
												parent.f_calcula_cubagem('NOTA');
												
										parent.f_salvar_NOTAS_FISCAIS();
												NOTA_CFOP.setAttribute('obrigatorio', 1);
									}
								</cfcase>
								<cfcase value="1">
									with(parent.document.forms[0]) {
										NFE_CFOP.setAttribute('obrigatorio', 0);
										parent.f_incluir_NFE();
										
										CHAVE_ACESSO_NFE.value      = '#JSStringFormat(qrSolicitacaoNF.chave_acesso_nfe)#';
										NFE_VALOR.value             = toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_total)#');
										NFE_VALOR_SEGURADO.value    = toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_segurado)#');
										<cfif Len(Trim(qrSolicitacaoNF.NFE_XML))>
											NOME_ARQUIVO.value          = 'nfe_#qrSolicitacaoNF.chave_acesso_nfe#.xml';
										</cfif>
										
										NUMERO_NFE.value            = '#JSStringFormat(qrSolicitacaoNF.numero)#';
										MODELO_NFE.value            = '#JSStringFormat(qrSolicitacaoNF.modelo)#';
										SERIE_NFE.value             = '#JSStringFormat(qrSolicitacaoNF.serie)#';
										DATA_EMISSAO_NFE.value      = '#JSStringFormat(qrSolicitacaoNF.data_emissao)#';
										REMETENTE_NFE.value			= '';
										CNPJ_REMETENTE_NFE.value    = '';
										DESTINATARIO_NFE.value      = '';
										CNPJ_DESTINATARIO_NFE.value = '';
										NFE_QTDE_VOLUME.value      	= '#JSStringFormat(qrSolicitacaoNF.qtde_volume)#';
										NFE_COD_UNIDADE.value      	= 'Kg';
										NFE_NUM_NATUREZA.value     	= '#JSStringFormat(qrSolicitacaoNF.num_natureza)#';
										NFE_NATUREZA.value       	= '#JSStringFormat(qrSolicitacaoNF.natureza)#';
										NFE_NUM_ESPECIE.value      	= '#JSStringFormat(qrSolicitacaoNF.num_especie)#';
										NFE_ESPECIE.value       	= '#JSStringFormat(qrSolicitacaoNF.especie)#';
										NFE_ALTURA.value       		= ('#JSStringFormat(qrSolicitacaoNF.altura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.altura)#';
										NFE_COMPRIMENTO.value      	= ('#JSStringFormat(qrSolicitacaoNF.comprimento)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.comprimento)#';
										NFE_LARGURA.value       	= ('#JSStringFormat(qrSolicitacaoNF.largura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.largura)#';
										NFE_CUBAGEM_SUGERIDA.value 	= '#JSStringFormat(qrSolicitacaoNF.cubagem_sugerida)#';
                                        NFE_CFOP.value       		= '#JSStringFormat(qrSolicitacaoNF.CFOP)#';
										NFE_CUBAGEM.value       	= '#JSStringFormat(qrSolicitacaoNF.cubagem)#';
										NFE_ORDEM_COMPRA.value      = '#JSStringFormat(qrSolicitacaoNF.ordem_compra_cliente)#';
										ICMS_PARTILHADO.value     = '#JSStringFormat(qrSolicitacaoNF.icms_partilhado)#';
										<cfif IsDefined("vars.COMPLEMENTO") and vars.COMPLEMENTO eq 1>
											NFE_PESO.value               = 0;
											NFE_PESO_CUBADO.value        = 0;
											NFE_PESO_KG_CONVERTIDO.value = 0;
											NFE_PESO_COBRADO.value       = 0;
										<cfelse>	
											NFE_PESO.value               = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											NFE_PESO_CUBADO.value        = '#JSStringFormat(qrSolicitacaoNF.peso_cubado)#';
											NFE_PESO_KG_CONVERTIDO.value = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											NFE_PESO_COBRADO.value       = ('#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#' == '') ? '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#' : '#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#';
										</cfif>
										parent.f_calcula_cubagem('NFE');
										
										parent.f_salvar_NFE();
										if (parent.f_get_nfe_cfop_obrigatorio() == "Sim"){
                                      		NFE_CFOP.setAttribute('obrigatorio', 1);
										} else {
											NFE_CFOP.setAttribute('obrigatorio', 0);
										}
									}
								</cfcase>
								<cfcase value="2">
									with(parent.document.forms[0]) {
										parent.f_incluir_OUTROS();
										
										OUTROS_NUMERO.value				= '#JSStringFormat(qrSolicitacaoNF.numero)#';
										OUTROS_DATA_EMISSAO.value       = '#JSStringFormat(qrSolicitacaoNF.data_emissao)#';
										OUTROS_DESCRICAO.value			= '#JSStringFormat(qrSolicitacaoNF.descricao_docto)#';
										OUTROS_VALOR.value				= toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_total)#');
										OUTROS_VALOR_SEGURADO.value     = toCurrency('#JSStringFormat(qrSolicitacaoNF.valor_segurado)#');
										OUTROS_QTDE_VOLUME.value      	= '#JSStringFormat(qrSolicitacaoNF.qtde_volume)#';
										OUTROS_COD_UNIDADE.value      	= 'Kg';
										OUTROS_NUM_NATUREZA.value     	= '#JSStringFormat(qrSolicitacaoNF.num_natureza)#';
										OUTROS_NATUREZA.value       	= '#JSStringFormat(qrSolicitacaoNF.natureza)#';
										OUTROS_NUM_ESPECIE.value      	= '#JSStringFormat(qrSolicitacaoNF.num_especie)#';
										OUTROS_ESPECIE.value       		= '#JSStringFormat(qrSolicitacaoNF.especie)#';
										OUTROS_ALTURA.value       		= ('#JSStringFormat(qrSolicitacaoNF.altura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.altura)#';
										OUTROS_COMPRIMENTO.value      	= ('#JSStringFormat(qrSolicitacaoNF.comprimento)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.comprimento)#';
										OUTROS_LARGURA.value       		= ('#JSStringFormat(qrSolicitacaoNF.largura)#' == '') ? '0' : '#JSStringFormat(qrSolicitacaoNF.largura)#';
										OUTROS_CUBAGEM.value       		= '#JSStringFormat(qrSolicitacaoNF.cubagem)#';
										OUTROS_CUBAGEM_SUGERIDA.value 	= '#JSStringFormat(qrSolicitacaoNF.cubagem_sugerida)#';
										OUTROS_ORDEM_COMPRA.value		   = '#JSStringFormat(qrSolicitacaoNF.ordem_compra_cliente)#';
										ICMS_PARTILHADO.value            = 0;
										<cfif IsDefined("vars.COMPLEMENTO") and vars.COMPLEMENTO eq 1>
											OUTROS_PESO.value               = 0;
											OUTROS_PESO_CUBADO.value        = 0;
											OUTROS_PESO_KG_CONVERTIDO.value = 0;
											OUTROS_PESO_COBRADO.value       = 0;
										<cfelse>	
											OUTROS_PESO.value               = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											OUTROS_PESO_CUBADO.value        = '#JSStringFormat(qrSolicitacaoNF.peso_cubado)#';
											OUTROS_PESO_KG_CONVERTIDO.value = '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#';
											OUTROS_PESO_COBRADO.value       = ('#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#' == '') ? '#JSStringFormat(qrSolicitacaoNF.peso_kg_convertido)#' : '#JSStringFormat(qrSolicitacaoNF.peso_cobrado)#';
										</cfif>
										parent.f_calcula_cubagem('OUTROS');
										
										parent.f_salvar_OUTROS();
									}
								</cfcase>                            
							</cfswitch>
                        </cfoutput>
						
						<cfoutput>
                            with(parent.document.forms[0]) {
										
								<cfscript> connVP = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");</cfscript>		
																
								<cfif qrValePedagio.EMITE_VALEPEDAGIO eq 2 or qrValePedagio.EMITE_VALEPEDAGIO eq 1>
								   UTILIZA_VALE_PEDAGIO.value = 1;
								<cfelse>
								   UTILIZA_VALE_PEDAGIO.value = 0;
								</cfif>
								
								UTILIZA_VALE_PEDAGIO.onchange();
								NUM_COMPROVANTE.value = '#qrValePedagio.NUM_COMPROVANTE#';
								VALOR_COMPROVANTE.value = '#qrValePedagio.VALOR#';
								
								//Se = 2 significa que est configurado na operao e encontrou configurao de vale pedgio
								<cfif qrValePedagio.EMITE_VALEPEDAGIO eq 2 or qrValePedagio.EMITE_VALEPEDAGIO eq 1>
									CNPJ_OPERADORA.value			= '#JSStringFormat(qrConhecimento.cnpj_operadora_vale_ped)#';
									OPERADORA_RAZAO_SOCIAL.value	= '#JSStringFormat(qrConhecimento.nome_operadora_vale_ped)#';
									COD_PESSOA_OPERADORA.value	    = '#JSStringFormat(qrConhecimento.operadora_vale_pedagio)#';
								   
								   UTILIZA_VALE_PEDAGIO.disabled = true;
								   <cfif qrValePedagio.EMITE_VALEPEDAGIO eq 2>
									  EMITIR_SEM_NUM_COMPROVANTE.value = 1;
								   <cfelse>
									  EMITIR_SEM_NUM_COMPROVANTE.value = 0;
								   </cfif>
								<cfelse>
								   UTILIZA_VALE_PEDAGIO.disabled = false;
								   CNPJ_OPERADORA.value			= '';
								   OPERADORA_RAZAO_SOCIAL.value	= '';
								   COD_PESSOA_OPERADORA.value	= '';
								   EMITIR_SEM_NUM_COMPROVANTE.value = 0;
								</cfif>
								
								<cfif qrValePedagio.EMITE_VALEPEDAGIO eq 2>
								    parent.f_bloquear_valeped_operadora(false, 0, 0, 0, 0);
								<cfelseif qrValePedagio.EMITE_VALEPEDAGIO eq 1>
									<cfset v_bloqueia_operadora = 0>
									<cfif len(trim(qrConhecimento.operadora_vale_pedagio))>
									   <cfset v_bloqueia_operadora = 1>
									</cfif>
								    parent.f_bloquear_valeped_operadora(true, 0, #v_bloqueia_operadora#, 0, 0);
								<cfelse>
									parent.f_bloquear_valeped_operadora(false, 0, 0, 0, 0);
								</cfif>
								
								//Dados da empresa para quando selecionar a opo transportadora
								COD_TRANSPORTADORA.value  = '#qrEmpresa.cod_pessoa#';
								CNPJ_TRANSPORTADORA.value = '#JSStringFormat(qrEmpresa.cnpj)#';
   								NOME_TRANSPORTADORA.value = '#JSStringFormat(qrEmpresa.razao_social)#';
								
								<cfif qrValePedagio.EMITE_VALEPEDAGIO eq 2>
								   <cfif Len(Trim(qrValePedagio.NUM_COMPROVANTE)) eq 0>
								      parent.document.getElementById('MENSAGEM_RETORNO_VALE_PEDAGIO').innerHTML = 'Configurao de emisso de vale pedgio encontrada. O vale pedgio ser emitido automaticamente.'; 
									  parent.document.getElementById('MENSAGEM_RETORNO_VALE_PEDAGIO').style.color = 'blue';
									  
									  parent.document.getElementById('FORNECEDOR_VALE_PEDAGIO_#JSStringFormat(qrConhecimento.fornecedora_vale_pedagio)#').setAttribute('checked',true);
									  if ('#JSStringFormat(qrConhecimento.fornecedora_vale_pedagio)#' != 5) {
										  parent.f_desabilita_pedagio_check(true);
									  }else{
										  parent.f_desabilita_pedagio_check(false);
									  }
									  parent.f_muda_fornecedora('#JSStringFormat(qrConhecimento.fornecedora_vale_pedagio)#');
									  
									  with(parent.document.forms[0]) {
										 parent.document.getElementById('MENSAGEM_CONFIG_VALE_PEDAGIO').innerHTML = ''; 
									     parent.f_limpar_VALE_PEDAGIO();
									 	 parent.f_incluir_VALE_PEDAGIO();
										 NUM_COMPROVANTE.value          = '';
										 VALOR_COMPROVANTE.value        = '#qrValorVale.VALOR#';
										 CNPJ_OPERADORA.value			 = '#JSStringFormat(qrConhecimento.cnpj_operadora_vale_ped)#';
										 OPERADORA_RAZAO_SOCIAL.value 	 = '#JSStringFormat(qrConhecimento.nome_operadora_vale_ped)#';
										 COD_PESSOA_OPERADORA.value	 = '#JSStringFormat(qrConhecimento.operadora_vale_pedagio)#';
										 parent.f_salvar_VALE_PEDAGIO();
										 
										 <cfscript>
										    qrVerificaRepom = connVP.verifica_vpr(cod_pessoa_operadora = qrConhecimento.operadora_vale_pedagio);
										 </cfscript>
									 }
								   <cfelse>
								      parent.document.getElementById('MENSAGEM_RETORNO_VALE_PEDAGIO').innerHTML = 'Vale pedgio j emitido para o romaneio n #JSStringFormat(vars.num_romaneio)#.'; 
									  parent.document.getElementById('MENSAGEM_RETORNO_VALE_PEDAGIO').style.color = 'blue';
									  
									  parent.f_desabilita_pedagio_check(true);
									  parent.f_bloquear_valeped_operadora(true, 1, 1, 1, 1);
									  CNPJ_FORNECEDORA.readOnly 		= false;
									  COD_PESSOA_FORNECEDORA.readOnly 	= false;
									  
									  with(parent.document.forms[0]) {
										 parent.f_limpar_VALE_PEDAGIO();
									 	 parent.f_incluir_VALE_PEDAGIO();
										 NUM_COMPROVANTE.value = '#qrValePedagio.NUM_COMPROVANTE#';
	  									 VALOR_COMPROVANTE.value = '#qrValePedagio.VALOR#';
										 CNPJ_FORNECEDORA.value = '#qrVale.cnpj_cpf_fornecedora#';
										 COD_PESSOA_FORNECEDORA.value  = '#qrVale.cod_pessoa_fornecedora#';
										 FORNECEDORA_RAZAO_SOCIAL.value = '#JSStringFormat(qrVale.fornecedora)#';
										 CNPJ_OPERADORA.value			= '#JSStringFormat(qrVale.cnpj_cpf_operadora)#';
										 OPERADORA_RAZAO_SOCIAL.value	= '#JSStringFormat(qrVale.operadora)#';
										 COD_PESSOA_OPERADORA.value	    = '#JSStringFormat(qrVale.cod_pessoa_operadora)#';
									  	 parent.f_salvar_VALE_PEDAGIO();
										 
										 <cfscript>
										    qrVerificaRepom = connVP.verifica_vpr(cod_pessoa_operadora = qrVale.cod_pessoa_operadora);
										 </cfscript>										 
									  }
									  
								   </cfif>
								   // Buscar o carto do motorista								
								   <cfif qrVerificaRepom.RESULT eq 1 and Len(Trim(vars.COD_MOTORISTA))>
									  <cfscript>
										 qrCartaoVPR = connVP.get_cartao_vpr(cod_motorista = vars.COD_MOTORISTA
																		    ,cod_operadora  = qrVerificaRepom.COD_OPERADORA);
									  </cfscript>
									  <cfif qrCartaoVPR.recordCount eq 1>
										  with(parent.document.forms[0]) {
  											  document.getElementById('LBL_NUM_CARTAO_VALE_PEDAGIO').innerHTML = '';
											  document.getElementById('NUM_CARTAO_VALE_PEDAGIO').value = '#JSStringFormat(qrCartaoVPR.num_cartao)#';
     										  document.getElementById('NUM_CARTAO_VALE_PEDAGIO').readOnly = false;
										  }									  
									  <cfelse>
										  with(parent.document.forms[0]) {
											  document.getElementById('LBL_NUM_CARTAO_VALE_PEDAGIO').innerHTML = 'Carto no encontrado.';
     										  document.getElementById('NUM_CARTAO_VALE_PEDAGIO').readOnly = false;
										  }
									  </cfif>

										  
								   <cfelse>
									  with(parent.document.forms[0]) {
										  document.getElementById('NUM_CARTAO_VALE_PEDAGIO').value = '';
										  document.getElementById('NUM_CARTAO_VALE_PEDAGIO').readOnly = true;
									  }								   	  
								   </cfif>									   
								<cfelse>
								   parent.document.getElementById('MENSAGEM_RETORNO_VALE_PEDAGIO').innerHTML = '#JSStringFormat(qrValePedagio.MENSAGEM_RETORNO)#';
								   parent.document.getElementById('MENSAGEM_RETORNO_VALE_PEDAGIO').style.color = 'red';
								   
								   //atualizar fornecedor

								   parent.document.getElementById('FORNECEDOR_VALE_PEDAGIO_#JSStringFormat(qrConhecimento.fornecedora_vale_pedagio)#').setAttribute('checked',true);
								   if ('#JSStringFormat(qrConhecimento.fornecedora_vale_pedagio)#' != 5) {
									   parent.f_desabilita_pedagio_check(true);
								   }else{
									   parent.f_desabilita_pedagio_check(false);
								   }
								   parent.f_muda_fornecedora('#JSStringFormat(qrConhecimento.fornecedora_vale_pedagio)#');
								  
								</cfif>
								
							}
						</cfoutput>
                        
						parent.v_inserida = 0;
                        parent.f_busca_tipo_calculo();
                        <!---FIM INSERO DE NOTAS--->
						
						<!---Reatribui trava de obrigatoriedade do campo pedido/shipment--->
						v_pedido_ship_nf.setAttribute('obrigatorio',v_pedido_ship_obrigatorio_nf);
						v_pedido_ship_nfe.setAttribute('obrigatorio',v_pedido_ship_obrigatorio_nfe);
                        
                        with(parent.document.forms[0]) {
                            NUM_CONHECIMENTO.select();
							 
                        }
						
						<!---Busca o Prazo de Entrega--->
						with(parent.document.forms[0]) {
							<cfif vars.calcula_prazo_entrega eq 0>
								PRAZO_ENTREGA.value 		= <cfoutput>'#JSStringFormat(qrConhecimento.PRAZO_ENTREGA)#'</cfoutput>;
								
								if(Number(PRAZO_ENTREGA.value.getDateTime()) < Number(DATA_EMISSAO.value.getDateTime())) {
									v_dt =  new Date( Number(DATA_EMISSAO.value.getDateTime()) + (60 * 1000));
									v_dt_prazo = v_dt.format('dd/mm/')+v_dt.getFullYear()+v_dt.format(' hh24:mi');
									PRAZO_ENTREGA.value = v_dt_prazo;
								}
							<cfelse>
								parent.f_prazo_entrega(0);
							</cfif>
						}
						
                        
                        try {
							parent.document.getElementById('tr_romaneio_carregando').style.display = 'none';
						} catch(e) {}
   					    parent.f_busca_tipo_servico();
						
						<!---Tags--->
						<cfscript>
							qrTags = connCte.get_tags_cte(conhecimento_id = vars.CONHECIMENTO_ID);
							qrTagsOper = connCte.get_tags_operacao(operacao_id = qrConhecimento.OPERACAO_ID, utilizado_em = 1);
						</cfscript>
						<cfif qrTags.recordCount gt 0>
								tags ='<table class="borda" border="0" cellspacing="1" cellpadding="3"> '
									 +'   <tr class="titulo_3"> '
									 +'      <td>Ordem</td> '
									 +'      <td>Descri&ccedil;&atilde;o</td> '
									 +'      <td>Obrigat&oacute;rio</td> '
									 +'      <td>Valor</td> '
									 +'   </tr> '
									 +'   <cfloop query="qrTags"> '
									 +'	  <cfif qrTags.tipo eq 'LISTA_VALORES' > '
									 +'      <tr class="linha_2"> '
									 +'         <td align="center"> '
									 +'            <input type="hidden" name="TAG_OPERACAO_OBS_CONTRIB_ID" id="TAG_OPERACAO_OBS_CONTRIB_ID" value="<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" /> '
									 +'            <input type="hidden" name="TAG_CONHECIMENTO_OBS_CONTRIB_ID" id="CONHECIMENTO_OBS_CONTRIB_ID" value="<cfoutput>#qrTags.CONHECIMENTO_OBS_CONTRIB_ID#</cfoutput>" /> '
									 +'            <cfoutput>#qrTags.ORDEM#</cfoutput> '
									 +'         </td> '
									 +'         <td nowrap align="left"><nobr><cfoutput>#JSStringFormat(qrTags.DESCRICAO)#</cfoutput></td> '
									 +'         <td align="center"><cfoutput>#qrTags.OBRIGATORIO_STR#</cfoutput></td> '
									 +'         <td> '
									 + '<cfscript> connCte2 = CreateComponent("modulos.cte._componentes.consulta.cfc_cte"); qrListaValores = connCte2.get_tags_operacao_lista_valores(operacao_tag_lista_id = qrTags.valor_padrao); </cfscript>'
									 + '   <select style="width: 100%" name="TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\" id="TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\" obrigatorio=<cfoutput>#qrTagsOper.OBRIGATORIO#</cfoutput>  display="<cfoutput>#JSStringFormat(qrTags.DESCRICAO)#</cfoutput>">  '
									 + '  <option value="">---Selecione---</option>'																															     					
									 +'			 	<cfloop query="qrListaValores"> '
									 +'                             <option value="#qrListaValores.valor#"   <cfif qrTags.valor eq qrListaValores.valor>selected</cfif> >#qrListaValores.descricao#</option>'
									 +'             </cfloop> '	 									 
								 	 +'         </td> '
									 +'      </tr> '
									 +'   <cfelse>'		
									 +'      <tr class="linha_2"> '
									 +'         <td align="center"> '
									 +'            <input type="hidden" name="TAG_OPERACAO_OBS_CONTRIB_ID" id="TAG_OPERACAO_OBS_CONTRIB_ID" value="<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" /> '
									 +'            <input type="hidden" name="TAG_CONHECIMENTO_OBS_CONTRIB_ID" id="CONHECIMENTO_OBS_CONTRIB_ID" value="<cfoutput>#qrTags.CONHECIMENTO_OBS_CONTRIB_ID#</cfoutput>" /> '
									 +'            <cfoutput>#qrTags.ORDEM#</cfoutput> '
									 +'         </td> '
									 +'         <td nowrap align="left"><nobr><cfoutput>#JSStringFormat(qrTags.DESCRICAO)#</cfoutput></td> '
									 +'         <td align="center"><cfoutput>#qrTags.OBRIGATORIO_STR#</cfoutput></td> '
									 +'         <td> '
									 +'			 	<textarea onkeydown="limitText(\'TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" onkeyup="limitText(\'TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" maxlenght="160" rows="2" cols="100" display="Valor, referente  observao <cfoutput>#JSStringFormat(qrTags.DESCRICAO)#</cfoutput>" obrigatorio=<cfoutput>#qrTags.OBRIGATORIO#</cfoutput> name="TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" id="TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>"><cfoutput>#qrTags.VALOR#</cfoutput></textarea> '
									 +'         </td> '
									 +'      </tr> '
									 +'   </cfif>'	
									 +'   </cfloop> '
									 +'</table> ';
								<cfif qrControleRecurso.RESULT eq 1>
									parent.f_muda_obs_contrib(tags); 
									parent.f_msg_obs_contrib("tags");
							 	</cfif>
								
						<cfelseif qrTagsOper.recordCount gt 0>
						        tags ='<table class="borda" border="0" cellspacing="1" cellpadding="3"> '
									 +'   <tr class="titulo_3"> '
									 +'      <td>Ordem</td> '
									 +'      <td>Descri&ccedil;&atilde;o</td> '
									 +'      <td>Obrigat&oacute;rio</td> '
									 +'      <td>Valor</td> '
									 +'   </tr> '
									 +'   <cfloop query="qrTagsOper"> '
									 +'	  <cfif qrTagsOper.tipo eq 'LISTA_VALORES' > ' 			
									 +'      <tr class="linha_2"> '
									 +'         <td align="center"> '
									 +'            <input type="hidden" name="TAG_OPERACAO_OBS_CONTRIB_ID" id="TAG_OPERACAO_OBS_CONTRIB_ID" value="<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" /> '
									 +'            <input type="hidden" name="TAG_CONHECIMENTO_OBS_CONTRIB_ID" id="CONHECIMENTO_OBS_CONTRIB_ID" /> '
									 +'            <cfoutput>#qrTagsOper.ORDEM#</cfoutput> '
									 +'         </td> '
									 +'         <td nowrap align="left"><nobr><cfoutput>#JSStringFormat(qrTagsOper.DESCRICAO)#</cfoutput></td> '
									 +'         <td align="center"><cfoutput>#qrTagsOper.OBRIGATORIO_STR#</cfoutput></td> '
									 +'         <td> '
									 + '<cfscript> connCte2 = CreateComponent("modulos.cte._componentes.consulta.cfc_cte"); qrListaValores = connCte2.get_tags_operacao_lista_valores(operacao_tag_lista_id = qrTagsOper.valor_padrao); </cfscript>'
									 + '   <select style="width: 100%" name="TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\" id="TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\" obrigatorio=<cfoutput>#qrTagsOper.OBRIGATORIO#</cfoutput>  display="<cfoutput>#JSStringFormat(qrTagsOper.DESCRICAO)#</cfoutput>">  '
									 + '  <option value="">---Selecione---</option>'
									 +'			 	<cfloop query="qrListaValores"> '
									 +'                             <option value="<cfoutput>#qrListaValores.valor#</cfoutput>" ><cfoutput>#qrListaValores.descricao#</cfoutput></option>'
									 +'             </cfloop> '									
									 +'         </td> '
									 +'      </tr> ' 
									 +'   <cfelse>'								 
									 +'      <tr class="linha_2"> '
									 +'         <td align="center"> '
									 +'            <input type="hidden" name="TAG_OPERACAO_OBS_CONTRIB_ID" id="TAG_OPERACAO_OBS_CONTRIB_ID" value="<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" /> '
									 +'            <input type="hidden" name="TAG_CONHECIMENTO_OBS_CONTRIB_ID" id="CONHECIMENTO_OBS_CONTRIB_ID" /> '
									 +'            <cfoutput>#qrTagsOper.ORDEM#</cfoutput> '
									 +'         </td> '
									 +'         <td nowrap align="left"><nobr><cfoutput>#JSStringFormat(qrTagsOper.DESCRICAO)#</cfoutput></td> '
									 +'         <td align="center"><cfoutput>#qrTagsOper.OBRIGATORIO_STR#</cfoutput></td> '
									 +'         <td> '
									 +'			 	<textarea onkeydown="limitText(\'TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" onkeyup="limitText(\'TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" maxlenght="160" rows="2" cols="100" display="Valor, referente  observao <cfoutput>#JSStringFormat(qrTagsOper.DESCRICAO)#</cfoutput>" obrigatorio=<cfoutput>#qrTagsOper.OBRIGATORIO#</cfoutput> name="TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" id="TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>"><cfoutput>#qrTagsOper.VALOR_PADRAO#</cfoutput></textarea> '
									 +'         </td> '
									 +'      </tr> '
								     +'   </cfif>'		
									 +'   </cfloop> '
									 +'</table> ';
								<cfif qrControleRecurso.RESULT eq 1>
									parent.f_muda_obs_contrib(tags); 
									parent.f_msg_obs_contrib("tags");
							 	</cfif>								
						<cfelse>
								<cfif qrControleRecurso.RESULT eq 1>
									parent.f_msg_obs_contrib("oper");
							 	</cfif>				
					    </cfif>
						
                        <!---Busca CTe multimodal vinculado a Solicitao de Carga--->
						<cfif qrConhecimento.EMITE_MULTIMODAL eq 1>
							<cfoutput query="qrSolicitacaoCteMultimodal">
								with(parent.document.forms[0]) {
									parent.f_limpar_CTES_REF();
									parent.f_incluir_CTES_REF();											
									CTE_REF_CHAVE.value			       = '#JSStringFormat(qrSolicitacaoCteMultimodal.chave)#';
									CTE_REF_NUMERO.value		       = '#JSStringFormat(qrSolicitacaoCteMultimodal.numero)#';
									CTE_REF_SERIE.value		           = '#JSStringFormat(qrSolicitacaoCteMultimodal.serie)#';
									CTE_REF_SITUACAO.value	           = '#JSStringFormat(qrSolicitacaoCteMultimodal.situacao)#';
									CTE_REF_DATA_EMISSAO.value         = '#JSStringFormat(qrSolicitacaoCteMultimodal.data_emissao)#';
									CTE_REF_EMIT_CNPJ_CPF.value	       = '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_cnpj_cpf)#';
									CTE_REF_EMIT_RAZAO.value	       = '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_razao)#';
									CTE_REF_REM_CNPJ_CPF.value	       = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_cnpj_cpf)#';
									CTE_REF_REM_IE.value	           = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_ie)#';
									CTE_REF_REM_RAZAO.value	           = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_razao)#';
									CTE_REF_REM_ENDERECO.value         = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco)#';
									CTE_REF_REM_ENDERECO_NRO.value	   = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_nro)#';
									CTE_REF_REM_ENDERECO_BAIRRO.value  = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_bairro)#';
									CTE_REF_REM_ENDERECO_CMUN.value    = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_cmun)#';
									CTE_REF_REM_ENDERECO_XMUN.value    = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_xmun)#';
									CTE_REF_REM_ENDERECO_CEP.value     = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_cep)#';
									CTE_REF_REM_ENDERECO_UF.value      = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_uf)#';
									CTE_REF_REM_ENDERECO_PAIS.value    = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_pais)#';
									CTE_REF_DEST_CNPJ_CPF.value	       = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_cnpj_cpf)#';
									CTE_REF_DEST_IE.value	           = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_ie)#';
									CTE_REF_DEST_RAZAO.value	       = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_razao)#';
									CTE_REF_DEST_ENDERECO.value        = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco)#';
									CTE_REF_DEST_ENDERECO_NRO.value	   = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_nro)#';
									CTE_REF_DEST_ENDERECO_BAIRRO.value = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_bairro)#';
									CTE_REF_DEST_ENDERECO_CMUN.value   = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_cmun)#';
									CTE_REF_DEST_ENDERECO_XMUN.value   = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_xmun)#';
									CTE_REF_DEST_ENDERECO_CEP.value    = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_cep)#';
									CTE_REF_DEST_ENDERECO_UF.value     = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_uf)#';
									CTE_REF_DEST_ENDERECO_PAIS.value   = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_pais)#';
									CTE_REF_PESO_MULTIMODAL.value      = '#JSStringFormat(qrSolicitacaoCteMultimodal.peso_multimodal)#';
									CTE_REF_PERCENTUAL_TOLERANCIA.value = '#JSStringFormat(qrSolicitacaoCteMultimodal.percentual_tolerancia)#';
									CTE_REF_VALOR_TOLERANCIA.value      = '#JSStringFormat(qrSolicitacaoCteMultimodal.valor_tolerancia)#';
									CTE_REF_PESO_CTES_VINCULADOS.value  = '#JSStringFormat(qrSolicitacaoCteMultimodal.peso_ctes_vinculados)#';
									CTE_REF_PESO_RESTANTE.value         = '#JSStringFormat(qrSolicitacaoCteMultimodal.peso_restante)#';
									CTE_REF_PESO_RESTANTE_TOLERANCIA.value = '#JSStringFormat(qrSolicitacaoCteMultimodal.peso_restante_tolerancia)#';
									CTE_REF_PESO_REAL.value             = '#JSStringFormat(qrSolicitacaoCteMultimodal.peso_real)#';
									parent.f_salvar_CTES_REF();	
									parent.f_atualiza_peso_cte_ref();
									
									// atualiza o tomador				
									COD_CLIENTE_COBRANCA.value 	= '#JSStringFormat(qrSolicitacaoCteMultimodal.cod_emitente)#';
									COB_CNPJ_CPF.value 			= '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_cnpj_cpf)#';
									COB_RAZAO_SOCIAL.value 		= '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_razao)#';
								
								    f_limpa_select(parent.document.getElementById('COB_CB_ENDERECO'));
								    parent.v_enderecos_COB = new Array();
								    parent.v_enderecos_COB.push( {
									cod_pessoa		: '#JSStringFormat(qrSolicitacaoCteMultimodal.cod_emitente)#',
									cod_endereco	: '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_cod_endereco)#',
									municipio_id	: '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_endereco_mun_id)#',
									municipio		: '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_endereco_mun)#',
									cep				: '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_endereco_cep)#',
									logradouro		: '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_endereco)#',
									numero			: '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_endereco_nro)#',
									bairro			: '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_endereco_bairro)#',
									uf				: '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_endereco_uf)#',
									padrao			: '1',
									inscricao_estadual    : '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_inscricao_estadual)#',
									cod_atividade_fiscal  : '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_cod_atividade)#'
								    } );
								    parent.f_busca_endereco_COB('#JSStringFormat(qrSolicitacaoCteMultimodal.cod_emitente)#');									
								    }
									parent.f_preenche_cb_ie_COB("#qrSolicitacaoCteMultimodal.emit_inscricao_estadual#", "");
									parent.setReadOnly['COB'](true);
							</cfoutput>
						</cfif>
                    </script>
                </cfif>
            <cfcatch>
				<script type="text/javascript">
                    try {
						parent.document.getElementById('tr_romaneio_carregando').style.display = 'none';
					} catch(e) {}
                </script>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
            </cftry>
            <cfscript>
                fnc_trata_erros(struct_erro = retorno, mostra_msg_ok  = false);
            </cfscript>
        </cfcase>
        
        <cfcase value="2">
        	<cfparam name="vars.MUNICIPAL" default="0">
            <cfparam name="vars.tipo_documento" default="">
			
            <cfset retorno = StructNew()>
            <cftry>
                <cfscript>
                    conn = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
					qrRomaneio = conn.get_romaneio_aberto(num_romaneio = vars.num_romaneio);
					
					qrIsFracionado = conn.get_romaneio_fracionado(num_romaneio = vars.num_romaneio
					                                             ,solicitacao_carga_id = vars.solicitacao_carga_id);
					
					if ( qrIsFracionado.fracionado eq 1 ){
					   qrItem = conn.get_romaneio_item_fracionado(num_romaneio = vars.num_romaneio,  tipo_documento = vars.tipo_documento);					
					} else{
					   qrItem = conn.get_romaneio_item(num_romaneio = vars.num_romaneio,  tipo_documento = vars.tipo_documento);					
					}
					
					if(qrRomaneio.recordCount gt 0)
					{
						qrEspecie = conn.get_especie(num_especie = qrRomaneio.num_especie);
						qrNatureza = conn.get_natureza(num_natureza = qrRomaneio.num_natureza);
						
						connV = CreateComponent("modulos.cte._componentes.consulta.cfc_veiculo");
						qrComposicao = connV.get_composicao(cod_veiculo = qrRomaneio.placa_controle, data = vars.DATA_EMISSAO);
						qrMotorista  = connV.get_motorista_proprietario(placa_controle = qrRomaneio.placa_controle, data = vars.DATA_EMISSAO);
						
						connCT = CreateComponent("modulos.cte._componentes.consulta.cfc_controle_trafego");				
						qrPosicaoAtual = connCT.get_ultimo_itinerario(placa = qrRomaneio.PLACA_REFERENCIA);
					}
		
					retorno.erro = false;
                    retorno.mensagem = '';
                </cfscript>
				
				<cfif vars.PARAM_DATA_BASE_COMPOSICAO eq 'Data de incio da solicitao'>
					<script>
						with(parent.document.forms[0]){
							DATA_BASE_COMPOSICAO.value = <cfoutput>'#qrItem.data_carregamento_inicio#'</cfoutput>;
						}
					</script>
				</cfif>
				
                <cfif qrRomaneio.recordCount gt 0>
                    <div id="div_item_romaneio">
                        <cfif qrItem.recordCount eq 0>
                                <script language="javascript1.2">
                                    alert('O romaneio indicado no possui itens para a emisso!');
                                </script>
                                <input type="hidden" name="PERMITIDO_FILIAL_ROMANEIO" value="0" />
                                <span class="obrigatorio">O romaneio indicado no possui itens para a emisso!</span>
                                <script language="javascript1.2">
	                                 parent.document.getElementById('tr_romaneio_carregando').style.display = 'none';
							     </script>                                
                                <cfabort/>
                        </cfif>	
                
                        <cfif vars.MUNICIPAL eq 1 and qrItem.ORIGEM_MUNICIPIO_ID NEQ qrItem.DESTINO_MUNICIPIO_ID>
                                <script language="javascript1.2">
                                    alert('O romaneio indicado no  MUNICIPAL!');
                                </script>
                                <input type="hidden" name="PERMITIDO_FILIAL_ROMANEIO" value="0" />
                                <span class="obrigatorio">O romaneio indicado no  MUNICIPAL!</span>
                                <script language="javascript1.2">
	                                 parent.document.getElementById('tr_romaneio_carregando').style.display = 'none';
							     </script> 
                                <cfabort/>
                        </cfif>	

                        <cfoutput>
                            <input type="hidden" name="NUM_ROMANEIO_ROMANEIO" value="#qrRomaneio.num_romaneio#" />
                            <input type="hidden" name="PLACA_CONTROLE_ROMANEIO" value="#qrRomaneio.placa_controle#" />
                            <input type="hidden" name="COMPOSICAO_ROMANEIO" value="#qrRomaneio.composicao#" />
                            <input type="hidden" name="PROPRIETARIO_ROMANEIO" value="#qrRomaneio.veiculo_proprietario#" />
                
                            <input type="hidden" name="NUM_NATUREZA_ROMANEIO" value="#qrRomaneio.num_natureza#" />
                            <input type="hidden" name="NUM_ESPECIE_ROMANEIO" value="#qrRomaneio.num_especie#" />
                            <input type="hidden" name="COD_UNIDADE_ROMANEIO" value="#qrRomaneio.cod_unidade#" />
                            <input type="hidden" name="NUM_ENTREGAS" value="#qrRomaneio.num_entregas#" />
                            <input type="hidden" name="ITEMS_ROMANEIO" value="#ValueList(qrItem.item_id)#" />
                            <input type="hidden" name="MUNICIPIO_ID_ORIGEM" value="#qrPosicaoAtual.destino_municipio_id#" />
                            <input type="hidden" name="MUNICIPIO_ORIGEM" value="#qrPosicaoAtual.municipio#" />
                            <cfif isDefined("vars.lotacao") and vars.lotacao neq 0>
                                <cfif qrRomaneio.COD_PESSOA_FILIAL neq session.COD_PESSOA and vars.FRETE_PROPRIO eq 1>
                                <script language="javascript1.2">
                                    alert('O romaneio indicado pertence a outra filial!');
									parent.document.getElementById('tr_romaneio_carregando').style.display = 'none';
                                </script>
                                <input type="hidden" name="PERMITIDO_FILIAL_ROMANEIO" value="0" />
                                <span class="obrigatorio">O romaneio indicado pertence a outra filial!</span>
                                <script language="javascript1.2">
	                                 parent.document.getElementById('tr_romaneio_carregando').style.display = 'none';
							     </script>                                
                                <cfabort/>
                                <cfelse>
                                    <input type="hidden" name="PERMITIDO_FILIAL_ROMANEIO" value="1" />
                                </cfif>
                            <cfelse>
                                    <input type="hidden" name="PERMITIDO_FILIAL_ROMANEIO" value="1" />
                            </cfif>
                                
                            <!--- <cfif  (vars.FRETE_PROPRIO eq 0 and qrRomaneio.SITUACAO_ID eq 2)>
                                <input type="hidden" name="ROMANEIO_SITUACAO" value="#qrRomaneio.SITUACAO_ID#" />
                                <span class="obrigatorio">Romaneio encerrado!</span>
                                <script language="javascript1.2">
	                                 parent.document.getElementById('tr_romaneio_carregando').style.display = 'none';
							     </script>
                                <cfabort/>
                            </cfif> --->
                            
                            <fieldset><legend>Dados do Romaneio</legend><table border="0" cellpadding="3" cellspacing="1">
                              <tr>
                                <td class="texto">Data In&iacute;cio: </td>
                                <td colspan="3" class="texto_negrito">#LSDateFormat(qrRomaneio.data_inicio)# #TimeFormat(qrRomaneio.data_inicio,'HH:MM')#</td>
                              </tr>
                              <tr>
                                <td class="texto">Carregamento:</td>
                                <td class="texto_negrito">#qrRomaneio.carregamento#</td>
                                <td class="texto">Destino:</td>
                                <td class="texto_negrito">#qrRomaneio.destino#</td>
                              </tr>
                              <tr>
                                <td class="texto">Cliente:</td>
                                <td colspan="3" class="texto_negrito">#qrRomaneio.cliente# </td>
                              </tr>
                              <tr>
                                <td class="texto">Remetente:</td>
                                <td colspan="3" class="texto_negrito">#qrRomaneio.remetente#</td>
                              </tr>
                              <tr>
                                <td class="texto">Destinatario:</td>
                                <td colspan="3" class="texto_negrito">#qrRomaneio.destinatario#</td>
                              </tr>
                              <tr>
                                <td class="texto">Mercadoria:</td>
                                <td colspan="3" class="texto_negrito">#qrRomaneio.natureza#</td>
                              </tr>
                            </table></fieldset></cfoutput>
                            <fieldset><legend>Itens do Romaneio</legend><table width="100%" border="0" cellspacing="1" cellpadding="3" class="borda">
                                <thead>
                              <tr class="titulo_1" onclick="sortColumn(event)">
                                <td type="nao_ordenar" width="1%">&nbsp;</td>
                                <td type="caseinsensitivestring" width="7%">Carga</td>
                                <td type="caseinsensitivestring" width="7%">Agendamento</td>
                                <td type="caseinsensitivestring" width="7%">Operao</td>
                                <td type="caseinsensitivestring" width="17%">Remetente</td>
                                <td type="caseinsensitivestring" width="19%">Origem</td>
                                <td type="caseinsensitivestring" width="20%">Destinat&aacute;rio</td>
                                <td type="caseinsensitivestring" width="23%">Destino</td>
                                <td type="number" width="4%">Peso</td>
                                <td type="number" width="5%">Valor</td>
                                <td style="display:none" type="caseinsensitivestring" width="9%">Rota</td>
                              </tr>
                              </thead>
                              <tbody>
                              <cfif vars.FRETE_PROPRIO eq 1>
                                  <tr class="linha_2" onmouseover="this.className = 'linha_over'" onmouseout="this.className = 'linha_2'" style="display:none">
                                    <td><input name="ITEM_ID_ROMANEIO" id="ITEM_ID_ROMANEIO_00" type="radio" class="check" value="00" onclick="f_preenche_item('00')"></td>
                                    <td colspan="8"><button onclick="f_vincula_item_romaneio('00')" type="button" class="botao-16x16"><img alt="Insere uma nova entrega" src="/_imagens/botoes/16x16/caminhao.gif" width="16" height="16" align="absmiddle">&nbsp;Nova Entrega</button></td>
                                  </tr>
                                  <input type="hidden" name="ITEM_ID_ROMANEIO_00" id="ITEM_ID_ROMANEIO_00" value="0" />
                                  <input type="hidden" name="OPERACAO_ID_ROMANEIO_00" id="OPERACAO_ID_ROMANEIO_00" value="" />
                                  <input type="hidden" name="NUM_PRODUTO_ROMANEIO_00" id="NUM_PRODUTO_ROMANEIO_00" value="" />
                                  <input type="hidden" name="REGRA_FISCAL_ID_ROMANEIO_00" id="REGRA_FISCAL_ID_ROMANEIO_00" value="" />
                                  <input type="hidden" name="PAGADOR_ROMANEIO_00" id="PAGADOR_ROMANEIO_00" value="" />
                                  <input type="hidden" name="VIAGEM_CARGA_ID_ROMANEIO_00" id="VIAGEM_CARGA_ID_ROMANEIO_00" value="" />
                                  <input type="hidden" name="SOLICITACAO_CARGA_ID_ROMANEIO_00" id="SOLICITACAO_CARGA_ID_ROMANEIO_00" value="" />
                              </cfif>	  
                              <cfoutput query="qrItem">
                              <tr class="linha_2" onmouseover="this.className = 'linha_over'" onmouseout="this.className = 'linha_2'">
                                <td><cfif qrItem.possui_conhecimento eq 0 or (isDefined("vars.substituto") and vars.substituto eq 1 or 1 eq 1)><input name="ITEM_ID_ROMANEIO" id="ITEM_ID_ROMANEIO_#qrItem.item_id#" type="radio" class="check" value="#qrItem.item_id#" onclick="f_preenche_item(#qrItem.item_id#,#qrItem.solicitacao_carga_id# )"></cfif></td>
                                <td align="right">#qritem.solicitacao_carga_id#</td>
                                <td align="right">#qritem.viagem_id#</td>
                                <td nowrap="nowrap">#qritem.operacao#</td>
                                <td>#qritem.remetente#</td>
                                <td>#qritem.rem_municipio#-#qrItem.rem_uf#</td>
                                <td>#qritem.destinatario#</td>
                                <td>#qritem.dest_municipio#-#qrItem.dest_uf#</td>
                                <td align="right">#NumberFormat(qrItem.peso,'._')#</td>
                                <td align="right">#NumberFormat(qrItem.valor_frete,'._')#</td>
                                <td style="display:none" align="center">#qritem.rota_abreviatura#</td>
                              </tr>
                              <input type="hidden" name="ITEM_ID_ROMANEIO_#qrItem.item_id#" id="ITEM_ID_ROMANEIO_#qrItem.item_id#" value="#qrItem.item_id#" />
                              <input type="hidden" name="OPERACAO_ID_ROMANEIO_#qrItem.item_id#" id="OPERACAO_ID_ROMANEIO_#qrItem.item_id#" value="#qrItem.operacao_id#" />
                              <input type="hidden" name="NUM_PRODUTO_ROMANEIO_#qrItem.item_id#" id="NUM_PRODUTO_ROMANEIO_#qrItem.item_id#" value="#qrItem.num_produto#" />
                              <input type="hidden" name="REGRA_FISCAL_ID_ROMANEIO_#qrItem.item_id#" id="REGRA_FISCAL_ID_ROMANEIO_#qrItem.item_id#" value="#qrItem.regra_fiscal_id#" />
                              <input type="hidden" name="PAGADOR_ROMANEIO_#qrItem.item_id#" id="PAGADOR_ROMANEIO_#qrItem.item_id#" value="#qrItem.frete_por_conta#" />
                              <input type="hidden" name="VIAGEM_CARGA_ID_ROMANEIO_#qrItem.item_id#" id="VIAGEM_CARGA_ID_ROMANEIO_#qrItem.item_id#" value="#qrItem.viagem_carga_id#" />
                              <input type="hidden" name="SOLICITACAO_CARGA_ID_ROMANEIO_#qrItem.item_id#" id="SOLICITACAO_CARGA_ID_ROMANEIO_#qrItem.item_id#" value="#qrItem.solicitacao_carga_id#" />
                              </cfoutput>
                              </tbody>
                
                            </table>
                            </fieldset>
                    </div>
                    
					<cfif not(IsDefined("vars.flag_conhecimento") and vars.flag_conhecimento eq "cadastrar")>
                    	<script>
							with(parent.document.forms[0]){
								DATA_EMISSAO.value="<cfoutput>#DateFormat(Now(),'dd/mm/yyyy')# #TimeFormat(Now(),'HH:MM')#</cfoutput>";
								DATA_EMISSAO.readOnly=true;
								IMPRESSO.value = 0;
								parent.document.getElementById("btn_data_emissao").style.display='none';
								IMPRIMIR.value     = 1;
								NOTA_DATA_EMISSAO.value="<cfoutput>#DateFormat(Now(),'dd/mm/yyyy')#</cfoutput>";
							}
						</script>
                    </cfif>

                    <script type="text/javascript">
                        parent.document.getElementById('td_romaneio').innerHTML = document.getElementById('div_item_romaneio').innerHTML;
                        
                        with(parent.document.forms[0]) {					
                            if(PROPRIETARIO_ROMANEIO.value == 3 && false) {
                                alert('O romaneio indicado tem como veiculo de trao um terceiro, no podendo ser utilizado nesta interface!');
                                f_limpa_romaneio();
                            }
                            parent.document.getElementById('proprietario_romaneio').innerHTML = (PROPRIETARIO_ROMANEIO.value == 2)?'Veiculo de agregado':'Veculo da Frota';
                            NUM_ROMANEIO.value = NUM_ROMANEIO_ROMANEIO.value;
                            PLACA_CONTROLE.value = PLACA_CONTROLE_ROMANEIO.value;
							PLACA_CONTROLE.onchange();

                            //Busca Composio
                            if(PLACA_CONTROLE.value == '') {
                                PLACA_REFERENCIA.value 		= '';
                                VEICULO_PROPRIETARIO.value 	= '';
                                COD_PROPRIETARIO.value  	= '';
                                PROP_CNPJ_CPF.value 		= '';
                                PROPRIETARIO.value          = '';
                                PROP_RAZAO_SOCIAL.value 	= '';
                                PROP_ENDERECO.value     	= '';
                                PROP_UF.value 				= '';
                                COD_MOTORISTA.value 		= '';
                                MOTORISTA.value 			= '';			
                                NOME_MOTORISTA.value		= '';					
                            }else{
                                <cfoutput>
									//Busca dados do Motorista/Proprietrio
                                    COD_PROPRIETARIO.value  = '#JSStringFormat(qrMotorista.cod_pessoa_proprietario)#';
                                    PROP_CNPJ_CPF.value 	= '#JSStringFormat(qrMotorista.cnpj_prop)#';
                                    PROPRIETARIO.value      = '#JSStringFormat(qrMotorista.proprietario)#';
                                    PROP_RAZAO_SOCIAL.value = '#JSStringFormat(qrMotorista.proprietario)#';			
                                    PROP_ENDERECO.value     = '#JSStringFormat(qrMotorista.endereco)#';
                                    PROP_UF.value 			= '#JSStringFormat(qrMotorista.uf)#';
                                
                                    VEICULO_PROPRIETARIO.value = 1;
                                    v_cod_veiculo = '#JSStringFormat(qrComposicao.cod_veiculo)#';

                                    if(v_cod_veiculo.length == 0) {
                                        alert('Veiculo no cadastrado!');
                                        PLACA_REFERENCIA.value = '';
                                        PLACA_CONTROLE.select();
                                    }else{
                                        <cfif isdefined("vars.terceiro") and vars.terceiro eq 1>
                                            if('#JSStringFormat(qrComposicao.veiculo_proprietario)#' != 3) {
                                                alert('Apenas veiculos de Terceiros podem ser selecionados como cavalo para esta emisso!');
                                                PLACA_CONTROLE.value = '';
                                                PLACA_CONTROLE.onchange();
                                                PLACA_CONTROLE.select();
                                            }
                                        </cfif>
										
										
                                        PLACA_CONTROLE.value = '#JSStringFormat(qrComposicao.placa)#';
                                        PLACA_CONTROLE.onchange();
                                        parent.f_limpar_engates();
										
										
                                </cfoutput>
                            
                                        <cfoutput query="qrComposicao" startrow="2">
											v_placa = '#JSStringFormat(qrComposicao.placa)#';
                                            v_obj = parent.f_engata();
                                            v_obj.setValue(v_placa);
                                        </cfoutput>	
                                <cfoutput>						
                                        
                                        if ('#JSStringFormat(qrComposicao.veiculo_proprietario)#' == 2) {
                                           VEICULO_PROPRIETARIO.value = 2;
                                        }
                                        
                                        <cfif isdefined("vars.placa_tracao")>
                                            setReadOnly['composicao'](true);
                                        </cfif>			
                                        VEICULO_PROPRIETARIO.value = 	'#JSStringFormat(qrComposicao.veiculo_proprietario)#';
                                    }
                                </cfoutput>
								
								parent.f_valida_veiculos();
                            }

                            NUM_ESPECIE.value	= NUM_ESPECIE_ROMANEIO.value;
                            ESPECIE.value = <cfoutput>'#JSStringFormat(qrEspecie.descricao)#'</cfoutput>;
                            NUM_NATUREZA.value	= NUM_NATUREZA_ROMANEIO.value;
                            NUM_NATUREZA.value = <cfoutput>'#JSStringFormat(qrNatureza.descricao)#'</cfoutput>;
                            COD_UNIDADE.value	= COD_UNIDADE_ROMANEIO.value;
            
                            v_num_natureza_notas		= NUM_NATUREZA_ROMANEIO.value;
                            v_num_especie_notas			= NUM_ESPECIE_ROMANEIO.value;
                            v_cod_unidade_notas			= COD_UNIDADE_ROMANEIO.value;
                            
                            parent.f_cancelar_NOTAS_FISCAIS();
            
                            v_itens = String(ITEMS_ROMANEIO.value).split(',');
            
                            ENTREGAS.value= parseInt(NUM_ENTREGAS.value) + 1;							

                            if(String(ITEMS_ROMANEIO.value).length > 0 && v_itens.length == 1) {
                                parent.f_preenche_item(ITEMS_ROMANEIO.value);
                                parent.document.getElementById('ITEM_ID_ROMANEIO_'+ITEMS_ROMANEIO.value).setAttribute('checked',true);
                            }

                            try {
                                parent.document.getElementById('tr_romaneio_carregando').style.display = 'none';
                            } catch(e) {}
                        }
                    </script>
            <cfelse>
            	<cfthrow message="O Romaneio #vars.num_romaneio# no est cadastrado."/>
            </cfif>                               
            <cfcatch>
            	<script type="text/javascript">
					try {
						parent.document.getElementById('tr_romaneio_carregando').style.display = 'none';
						parent.f_limpar_campos();
					} catch(e) {}
				</script>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
            </cftry>          
            <cfscript>
                fnc_trata_erros(struct_erro = retorno, mostra_msg_ok  = false);
            </cfscript>
		</cfcase>
        
        <cfcase value="3">
        	<cfset retorno = StructNew()>
            
            <cftry>
                <cfscript>
                    connOp = CreateComponent("modulos.cte._componentes.consulta.logistica.cfc_operacao");
					
					qrOrganograma = connOp.get_organograma();
					
					retorno.erro = false;
                    retorno.mensagem = '';
                </cfscript>
                
                <!---Busca o Organograma--->            
				<cfscript>
                   busca_organograma();
                </cfscript>
                
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
            </cftry>
            <cfscript>
                fnc_trata_erros(struct_erro = retorno, mostra_msg_ok  = false);
            </cfscript>
        </cfcase>
        
        <cfcase value="4">
        	<cfset retorno = StructNew()>
            
            <cftry>
                <cfscript>
			        connCte = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
                    connOp = CreateComponent("modulos.cte._componentes.consulta.logistica.cfc_operacao");					
					qrOperacao = connOp.get_operacao(operacao_id=  vars.OPERACAO_ID_CTRC, internacional = 0, somente_ativas = 1, lotacao = vars.lotacao, argumentCollection = vars);
					
					connEmis = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");					
					qrGerencial = connEmis.get_organizacional(operacao_id = qrOperacao.OPERACAO_ID, entrada_saida=1);
					
					qrEspecie = connEmis.get_especie(num_especie = qrOperacao.num_especie);
					
					//Busca Pessoas
					if(qrOperacao.recordcount eq 1){
						//Remetente
						qrPessoasRemetente	     = connOp.get_operacao_pessoa(operacao_id = qrOperacao.OPERACAO_ID, tipo_cliente = 0);
						qrEnderecosRemetente	 = connOp.get_operacao_enderecos(operacao_id = qrOperacao.OPERACAO_ID, tipo_cliente = 0);
						
						qrPessoasDestinatario	 = connOp.get_operacao_pessoa(operacao_id = qrOperacao.OPERACAO_ID, tipo_cliente = 1);
						qrEnderecosDestinatario	 = connOp.get_operacao_enderecos(operacao_id = qrOperacao.OPERACAO_ID, tipo_cliente = 1);
						
						qrPessoasColeta			 = connOp.get_operacao_pessoa(operacao_id = qrOperacao.OPERACAO_ID, tipo_cliente = 2);
						qrEnderecosColeta		 = connOp.get_operacao_enderecos(operacao_id = qrOperacao.OPERACAO_ID, tipo_cliente = 2);
						
						qrPessoasEntrega		 = connOp.get_operacao_pessoa(operacao_id = qrOperacao.OPERACAO_ID, tipo_cliente = 3);
						qrEnderecosEntrega		 = connOp.get_operacao_enderecos(operacao_id = qrOperacao.OPERACAO_ID, tipo_cliente = 3);
						
						qrPessoasCobranca		 = connOp.get_operacao_pessoa(operacao_id = qrOperacao.OPERACAO_ID, tipo_cliente = 4);

						qrEnderecosCobranca		 = connOp.get_operacao_enderecos(operacao_id = qrOperacao.OPERACAO_ID, tipo_cliente = 4);
						
						if( Len(Trim(qrOperacao.COD_NEGOCIADOR)) ){
							qrPessoasNegociador	     = connOp.get_operacao_pessoa(cod_pessoa = qrOperacao.COD_NEGOCIADOR);
							qrEnderecosNegociador	 = connOp.get_operacao_enderecos(cod_pessoa = qrOperacao.COD_NEGOCIADOR);
						}
						
						//Busca o Organograma
						qrOrganograma = connOp.get_organograma(operacao_id = qrOperacao.OPERACAO_ID, lotacao = vars.lotacao);
					}

					qrEmpresa = connEmis.get_empresa();
					
					v_operacao_vale_pedagio = '';
					
					if (IsDefined('vars.OPERACAO_ID') and Trim(vars.OPERACAO_ID) neq ''){
						v_operacao_vale_pedagio = vars.OPERACAO_ID;
					}
					else if (IsDefined('vars.OPERACAO_ID_CTRC') and Trim(vars.OPERACAO_ID_CTRC) neq ''){ 
						v_operacao_vale_pedagio = vars.OPERACAO_ID_CTRC;
					}
					
					// Vale pedagio
					if (IsDefined('vars.num_romaneio') and Trim(vars.num_romaneio) neq ''){
					qrValePedagio = connEmis.verifica_emissao_vale_pedagio(operacao_id  = v_operacao_vale_pedagio
				                                                          ,num_romaneio = vars.num_romaneio);
			        fnc_trata_erros(struct_erro = qrValePedagio, mostra_msg_ok  = false);
					}
					
					connC = CreateComponent("_transportes.consulta.cfc_global");
					v_valor_parametro	     = connC.get_parametro_valor(25, 'FISCAL.EXE', 7, 50);
					v_gerencial_obrigatorio	 = iif(v_valor_parametro eq 'Sim', true , false);
					
					retorno.erro = false;
                    retorno.mensagem = '';
                </cfscript>

                <cfif qrOperacao.recordcount eq 1>                   
                    <script type="text/javascript">
                        with(parent.document.forms[0]) {
							   <cfoutput>
                           CIF_FOB.value                 = '#JSStringFormat(qrOperacao.CIF_FOB)#';
                        </cfoutput>
                        }
                     </script>
                    <!---Busca os endereos do Remetente--->
                    <cfif IsDefined("qrEnderecosRemetente")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosRemetente, prefixo = "REM", busca = 1, campo_busca = qrEnderecosRemetente.cod_pessoa[1]);
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os endereos da Coleta--->
                    <cfif IsDefined("qrEnderecosColeta")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosColeta, prefixo = "COLETA", busca = 1, campo_busca = qrEnderecosColeta.cod_pessoa[1]);
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os endereos do Destinatrio--->
                    <cfif IsDefined("qrEnderecosDestinatario")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosDestinatario, prefixo = "DEST", busca = 1, campo_busca = qrEnderecosDestinatario.cod_pessoa[1]);
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os endereos da Entrega--->
                    <cfif IsDefined("qrEnderecosEntrega")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosEntrega, prefixo = "RED", busca = 1, campo_busca = qrEnderecosEntrega.cod_pessoa[1]);
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os endereos dde Cobrana--->
                    <cfif IsDefined("qrEnderecosCobranca")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosCobranca, prefixo = "COB");
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os endereos do Negociador--->                    
					<cfif IsDefined("qrEnderecosNegociador")>
                        <cfscript>
                            busca_enderecos(query = qrEnderecosNegociador, prefixo = "NEG", busca = 1, campo_busca = qrOperacao.cod_negociador);
                        </cfscript>
                    </cfif>
                    
                    <!---Busca os Remetentes--->
                    <cfif IsDefined("qrPessoasRemetente")>
                        <cfscript>
                            busca_pessoas(query = qrPessoasRemetente, prefixo = "REM",identificador_cod_pessoa = "COD_REMETENTE");
                        </cfscript>
                    <cfelse>
                    	<script type="text/javascript">
                        	parent.f_limpa_REM();
							parent.setReadOnly['REM'](false);
						</script>
                    </cfif>
                    
                    <!---Busca os Clientes de Coleta--->
                    <cfif IsDefined("qrPessoasColeta")>
                        <cfscript>
                            busca_pessoas(query = qrPessoasColeta, prefixo = "COLETA",identificador_cod_pessoa = "COLETA_COD_PESSOA");
                        </cfscript>
                    <cfelse>
                    	<script type="text/javascript">
                        	parent.f_limpa_COLETA();
							parent.setReadOnly['COLETA'](false);
						</script>
                    </cfif>
                    
                    <!---Busca os Destinatrios--->
                    <cfif IsDefined("qrPessoasDestinatario")>
                        <cfscript>
                            busca_pessoas(query = qrPessoasDestinatario, prefixo = "DEST",identificador_cod_pessoa = "COD_DESTINATARIO");
                        </cfscript>
                    <cfelse>
                    	<script type="text/javascript">
                        	parent.f_limpa_DEST();
							parent.setReadOnly['DEST'](false);
						</script>
                    </cfif>
                    
                    <!---Busca os Clientes de entrega--->
                    <cfif IsDefined("qrPessoasEntrega")>
                        <cfscript>
                            busca_pessoas(query = qrPessoasEntrega, prefixo = "RED",identificador_cod_pessoa = "COD_REDESPACHO");
                        </cfscript>
                    <cfelse>
                    	<script type="text/javascript">
                        	parent.f_limpa_RED();
							parent.setReadOnly['RED'](false);
						</script>
                    </cfif>
                    
                    <!---Busca o Negociador--->
                    <cfif IsDefined("qrPessoasNegociador")>
                        <cfscript>
                            busca_pessoas(query = qrPessoasNegociador, prefixo = "NEG",identificador_cod_pessoa = "COD_NEGOCIADOR");
                        </cfscript>
                        <script type="text/javascript">
							parent.f_busca_tipo_calculo();
						</script>
                    <cfelse>
                    	<script type="text/javascript">
                        	parent.f_limpa_NEG();
							parent.setReadOnly['NEG'](false);
						</script>
                    </cfif>
                    
                    <!---Busca os Clientes de Cobrana--->
                    <cfif qrOperacao.CIF_FOB neq 0>
                       <script type="text/javascript">
                          parent.f_limpa_COB();
                          parent.setReadOnly['COB'](true);
                       </script>
                    <cfelse>
                       <cfif IsDefined("qrPessoasCobranca")>
                          <cfscript>
                             busca_pessoas(query = qrPessoasCobranca, prefixo = "COB",identificador_cod_pessoa = "COD_CLIENTE_COBRANCA");
                          </cfscript>
                       <cfelse>
                           <script type="text/javascript">
                              parent.f_limpa_COB();
                              parent.setReadOnly['COB'](false);
                           </script>
                        </cfif>
                    </cfif>
                    
                    <!---Atualiza o pagador--->
					<script type="text/javascript">
						parent.f_atualiza_pagador();
					</script>                    
                        
                    <!---Busca o Organograma--->
                    <cfif vars.lotacao eq 0>
                        <cfscript>
                           busca_organograma();
                        </cfscript>
                    </cfif>
                    
					<script type="text/javascript">
                        with(parent.document.forms[0]) {
							<cfoutput>
								OPERACAO_CTRC.value		     = '#JSStringFormat(qrOperacao.OPERACAO_COMPLETA)#';
								TIPO_FRETE.value			 = '#JSStringFormat(qrOperacao.TIPO_FRETE)#';
								REGRA_FISCAL.value			 = '#JSStringFormat(qrOperacao.REGRA_FISCAL_ID)#';
								TIPO_SERVICO_COMERCIAL.value = '#JSStringFormat(qrOperacao.TIPO_SERVICO_ID)#';
								TIPO_DOCTO_FRETE.value  	 = '#JSStringFormat(qrOperacao.TIPO_DOCTO_FRETE)#';
								EMITE_MULTIMODAL.value       = '#JSStringFormat(qrOperacao.EMITE_MULTIMODAL)#';
								VINCULADO_MULTIMODAL.value   = '#JSStringFormat(qrOperacao.VINCULADO_MULTIMODAL)#';
								TIPO_DOCUMENTO_OPERACAO.value = '#JSStringFormat(qrOperacao.TIPO_DOCUMENTO_OPERACAO)#';
								
								parent.f_valida_cte_ref();
								parent.f_valida_obs_globalizado();
								parent.f_controla_tipo_docto_frete();
								parent.f_pedido_shipment_obrigatorio('#qrOperacao.PEDIDO_SHIPMENT#');
								parent.f_pedido_shipment_edicao('#qrOperacao.PEDIDO_SHIPMENT_EDICAO#');
							</cfoutput>
						}  
                    
                    <!---Preenche a Espcie--->
                        with(parent.document.forms[0]) {
							<cfoutput>
								NOTA_NUM_ESPECIE.value		= '#JSStringFormat(qrEspecie.NUM_ESPECIE)#';
							    NOTA_ESPECIE.value			= '#JSStringFormat(qrEspecie.DESCRICAO)#';
							    NFE_NUM_ESPECIE.value		= '#JSStringFormat(qrEspecie.NUM_ESPECIE)#';
							    NFE_ESPECIE.value			= '#JSStringFormat(qrEspecie.DESCRICAO)#';					   
							</cfoutput>
						}					

                    <cfoutput>
							with(parent.document.forms[0]) {
								//Vale pedgio
								UTILIZA_VALE_PEDAGIO.value 		= '#qrOperacao.pagto_vale_pedagio#';
								UTILIZA_VALE_PEDAGIO.onchange();
								if(UTILIZA_VALE_PEDAGIO.value == 1){
									UTILIZA_VALE_PEDAGIO.disabled = true;
								}else{
									UTILIZA_VALE_PEDAGIO.disabled = false;
								}
								
								if ('#JSStringFormat(qrOperacao.operadora_vale_pedagio)#') {
								   CNPJ_OPERADORA.value			= '#JSStringFormat(qrOperacao.cnpj_operadora_vale_ped)#';
								   OPERADORA_RAZAO_SOCIAL.value = '#JSStringFormat(qrOperacao.nome_operadora_vale_ped)#';
								   COD_PESSOA_OPERADORA.value	= '#JSStringFormat(qrOperacao.operadora_vale_pedagio)#';
									parent.f_bloquear_valeped_operadora(true);
								}else{
									CNPJ_OPERADORA.value			= '';
									OPERADORA_RAZAO_SOCIAL.value	= '';
									COD_PESSOA_OPERADORA.value	= '';
									parent.f_bloquear_valeped_operadora(false);
								}
								
								COD_TRANSPORTADORA.value  = '#qrEmpresa.cod_pessoa#';
								CNPJ_TRANSPORTADORA.value = '#JSStringFormat(qrEmpresa.cnpj)#';
								NOME_TRANSPORTADORA.value = '#JSStringFormat(qrEmpresa.razao_social)#';
								
								//atualizar fornecedor
								parent.document.getElementById('FORNECEDOR_VALE_PEDAGIO_#JSStringFormat(qrOperacao.fornecedora_vale_pedagio)#').checked = true;
								if ('#JSStringFormat(qrOperacao.fornecedora_vale_pedagio)#' != 5) {
									parent.f_desabilita_pedagio_check(true);
								}else{
									parent.f_desabilita_pedagio_check(false);
								}
								parent.f_muda_fornecedora('#JSStringFormat(qrOperacao.fornecedora_vale_pedagio)#');
							}
                    </cfoutput>
                    
                    
                    
                    <!---Busca o Centro de Custo Gerencial--->
                        with(parent.document.forms[0]) {
                            parent.f_limpa_select(parent.document.getElementById('ORGANIZACIONAL_ID'));
							
							<cfif qrGerencial.recordcount gt 1>
								v_option = f_cria_option('', '-- Selecione --', parent.document.getElementById('ORGANIZACIONAL_ID'));
								v_option.setAttribute('codigo', '');
							</cfif>
							
							<cfif qrGerencial.recordcount gte 1>
								<cfoutput query="qrGerencial">
									v_option = f_cria_option('#qrGerencial.ORGANIZACIONAL_ID#', '#JSStringFormat(qrGerencial.DESCRICAO_COMPLETA)#', parent.document.getElementById('ORGANIZACIONAL_ID'));
									v_option.setAttribute('codigo', '#qrGerencial.COD_ORGANIZACIONAL#');
								
								
									if( ORGANIZACIONAL_ID_GERENCIAL.value != '' && ORGANIZACIONAL_ID_GERENCIAL.value == '#qrGerencial.ORGANIZACIONAL_ID#'){
										v_opt.selected = true;
										COD_ORGANIZACIONAL.value = '#qrGerencial.COD_ORGANIZACIONAL#';
									}
								</cfoutput>
							<cfelse>
								<cfif v_gerencial_obrigatorio>
									alert('Nenhum Centro de Custo Gerencial foi encontrado para esta operao.');
								</cfif>
							</cfif>
							
							<cfif not isDefined("vars.complemento") or vars.complemento neq 1>
                                <cfif qrGerencial.recordcount eq 1>
                                    ORGANIZACIONAL_ID.onchange();
                                    ORGANIZACIONAL_ID.disabled = true;
                                    COD_ORGANIZACIONAL.readOnly = true;
                                <cfelse>
                                    ORGANIZACIONAL_ID.disabled = false;
                                    COD_ORGANIZACIONAL.readOnly = false;
                                </cfif>
                            </cfif>
                        }
                    
                    <!---Busca o Prazo de Entrega--->
                        with(parent.document.forms[0]) {
							<cfif vars.calcula_prazo_entrega eq 0>
								v_dt =  new Date( Number(DATA_EMISSAO.value.getDateTime()) + (60 * 1000));
								v_dt_prazo = v_dt.format('dd/mm/')+v_dt.getFullYear()+v_dt.format(' hh24:mi');
								PRAZO_ENTREGA.value = v_dt_prazo;								
							<cfelse>
								parent.f_prazo_entrega(0);
							</cfif>
						}
                <cfelse>
						with(parent.document.forms[0]) {
							OPERACAO_CTRC.value = '';
							OPERACAO_ID_CTRC.value = '';
							TIPO_FRETE.value = '';
							OPERACAO_VINCULADA_OTM.value = '';
							parent.f_valida_ref_cte();
							parent.document.getElementById('sp_produto_definido').style.display = 'none';
							NUM_PRODUTO.disabled = false;
							CIF_FOB.value := 0;

							<!---Remetente--->
							parent.f_limpa_REM();
							parent.setReadOnly['REM'](false);
							
							<!---Coleta--->
							parent.f_limpa_COLETA();
							parent.setReadOnly['COLETA'](false);
							
							<!---Destinatario--->
							parent.f_limpa_DEST();
							parent.setReadOnly['DEST'](false);
							
							<!---Entrega--->
							parent.f_limpa_RED();
							parent.setReadOnly['RED'](false);
							
							<!---Cobrana--->
							parent.f_limpa_COB();
							parent.setReadOnly['COB'](false);							
							
							<!---Negociador--->
							parent.f_limpa_NEG();
							parent.setReadOnly['NEG'](false);
							
							<!---Limpa o Organograma--->
							<cfif vars.lotacao eq 0>
								f_limpa_select(parent.document.getElementById('COD_PESSOA_FILIAL'));
								f_limpa_select(parent.document.getElementById('COD_DEPARTAMENTO'));
								f_limpa_select(parent.document.getElementById('COD_SETOR'));
								f_limpa_select(parent.document.getElementById('COD_CENTRO_CUSTO'));
								
								f_cria_option('', '-- Selecione uma Operao --', parent.document.getElementById('COD_PESSOA_FILIAL'));
								f_cria_option('', '-- Selecione uma Filial --', parent.document.getElementById('COD_DEPARTAMENTO'));
								f_cria_option('', '-- Selecione um Departamento --', parent.document.getElementById('COD_SETOR'));
								f_cria_option('', '-- Selecione um Setor --', parent.document.getElementById('COD_CENTRO_CUSTO'));
							</cfif>
							
							
							alert('Operao no encontrada/ No permitida!');
						}						
                </cfif>
				
				<!---Tags--->
				<cfscript>
					qrTagsOper = connCte.get_tags_operacao(operacao_id = qrOperacao.OPERACAO_ID);
				</cfscript>
				<cfif qrTagsOper.recordCount gt 0>
						tags ='<table class="borda" border="0" cellspacing="1" cellpadding="3"> '
							 +'   <tr class="titulo_3"> '
							 +'      <td>Ordem</td> '
							 +'      <td>Descri&ccedil;&atilde;o</td> '
							 +'      <td>Obrigat&oacute;rio</td> '
							 +'      <td>Valor</td> '
							 +'   </tr> '
							 +'   <cfloop query="qrTagsOper"> '
							 +'      <tr class="linha_2"> '
							 +'         <td align="center"> '
							 +'            <input type="hidden" name="TAG_OPERACAO_OBS_CONTRIB_ID" id="TAG_OPERACAO_OBS_CONTRIB_ID" value="<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" /> '
							 +'            <input type="hidden" name="TAG_CONHECIMENTO_OBS_CONTRIB_ID" id="CONHECIMENTO_OBS_CONTRIB_ID" /> '
							 +'            <cfoutput>#qrTagsOper.ORDEM#</cfoutput> '
							 +'         </td> '
							 +'         <td nowrap align="left"><nobr><cfoutput>#JSStringFormat(qrTagsOper.DESCRICAO)#</cfoutput></td> '
							 +'         <td align="center"><cfoutput>#qrTagsOper.OBRIGATORIO_STR#</cfoutput></td> '
							 +'         <td> '
							 +'			 	<textarea onkeydown="limitText(\'TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" onkeyup="limitText(\'TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" maxlenght="160" rows="2" cols="100" display="Valor, referente  observao <cfoutput>#JSStringFormat(qrTagsOper.DESCRICAO)#</cfoutput>" obrigatorio=<cfoutput>#qrTagsOper.OBRIGATORIO#</cfoutput> name="TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" id="TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>"><cfoutput>#qrTagsOper.VALOR_PADRAO#</cfoutput></textarea> '
							 +'         </td> '
							 +'      </tr> '
							 +'   </cfloop> '
							 +'</table> ';
						<cfif qrControleRecurso.RESULT eq 1>
							parent.f_muda_obs_contrib(tags); 
							parent.f_msg_obs_contrib("tags");
						</cfif>
				<cfelse>
						<cfif qrControleRecurso.RESULT eq 1>
							parent.f_msg_obs_contrib("oper");
						</cfif>				
				</cfif>
                
                <!---Oculta imagem de carregamento--->
                    parent.document.getElementById('tr_operacao_carregando').style.display = 'none';

					parent.f_busca_tipo_servico();
                </script>
                										 
            <cfcatch>
                <script type="text/javascript">
                    parent.document.getElementById('tr_operacao_carregando').style.display = 'none';
                    
                </script>
				<cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
            </cftry>
            <cfscript>
                fnc_trata_erros(struct_erro = retorno, mostra_msg_ok  = false);
            </cfscript>           
            
        </cfcase>
        
        <cfcase value="5">
        	<cfset retorno = StructNew()>
            
            <cftry>
                <cfscript>
                    conn = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
					connCte = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
					connS = CreateComponent("modulos.cte._componentes.consulta.logistica.cfc_solicitacao");
					
					qrConhecimento = conn.get_conhecimento_dados(conhecimento_id = vars.CONHECIMENTO_ID);
					qrConhecimentoNotasFiscais = conn.get_conhecimento_nota_fiscal(conhecimento_id = vars.CONHECIMENTO_ID, xml = 1, complemento = vars.COMPLEMENTO, substituto = vars.SUBSTITUTO);
					qrConhecimentoDocAnteriores = connCte.get_documentos_anteriores(conhecimento_id = vars.CONHECIMENTO_ID);
					qrConhecimentoValePedagio = connCte.get_cte_vale_pedagio(conhecimento_id = vars.CONHECIMENTO_ID);
					
					if (qrConhecimento.emite_multimodal eq 1) {
					    qrSolicitacaoCTeMultimodal = connS.get_cte_multimodal_sol_carga(solicitacao_carga_id = qrConhecimento.SOLICITACAO_CARGA_ID, conhecimento_id_substituido = vars.CONHECIMENTO_ID);
					}
					
					retorno.erro = false;					
                    retorno.mensagem = '';
                </cfscript>
					<cfif vars.substituto eq 1 && qrConhecimento.COD_STATUS eq 128 >
					   <script type="text/javascript">
                            with(parent.document.forms[0]) {
							   ARQUIVO.setAttribute('obrigatorio', 0);
                            }
                       </script>
					</cfif>
					
					<cfif vars.PARAM_DATA_BASE_COMPOSICAO eq 'Data de incio da solicitao'>
						<script>
							with(parent.document.forms[0]){
								DATA_BASE_COMPOSICAO.value = <cfoutput>'#qrConhecimento.data_emissao_dt_hr#'</cfoutput>;
							}
						</script>
					</cfif>
					
					<cfif vars.substituto neq 1 or (vars.substituto eq 1 && qrConhecimento.COD_STATUS eq 128) >					
						<script type="text/javascript">
                            with(parent.document.forms[0]) {

                                parent.f_limpar_NOTAS_FISCAIS();
                                parent.document.getElementById('tr_nf_substituto').style.display = 'none';
                                TIPO_DOCUMENTO_ID.value = <cfoutput>'#JSStringFormat(qrConhecimentoNotasFiscais.tipo_documento_id)#'</cfoutput>;
                                TIPO_DOCUMENTO_ID.onchange();
                                parent.v_inserida = 1;
                            }
                        </script>
						
						<script type="text/javascript">
							with(parent.document.forms[0]) {
								POPULANDO_DADOS.value = 1;
							}
						</script>
						
                        <cfoutput query="qrConhecimentoNotasFiscais">
                            <cfif Len(Trim(qrConhecimentoNotasFiscais.NFE_XML))>
								<cffile action = "write" file ='#expandPath("/")#temp/nfe_#qrConhecimentoNotasFiscais.chave_acesso_nfe#.xml' output = "#qrConhecimentoNotasFiscais.nfe_xml#">
							</cfif>
							
							<cfswitch expression="#qrConhecimentoNotasFiscais.tipo_documento_id#">
                                <cfcase value="0">
                                    <script type="text/javascript">
                                        with(parent.document.forms[0]) {
                                            parent.f_incluir_NOTAS_FISCAIS();
                                            NF_CONHECIMENTO_ID.value	  = '#JSStringFormat(qrConhecimentoNotasFiscais.conhecimento_id)#';
                                            NOTA_NUMERO.value             = '#JSStringFormat(qrConhecimentoNotasFiscais.numero)#';
                                            NOTA_MODELO.value             = '#JSStringFormat(qrConhecimentoNotasFiscais.modelo)#';
                                            NOTA_MODELO.onchange();
                                            NOTA_SERIE.value              = '#JSStringFormat(qrConhecimentoNotasFiscais.serie)#';
                                            NOTA_SERIE.onchange();
                                            NOTA_SUB_SERIE.value          = '#JSStringFormat(qrConhecimentoNotasFiscais.sub_serie)#';
                                            NOTA_DATA_EMISSAO.value       = '#JSStringFormat(qrConhecimentoNotasFiscais.data_emissao_data)#';
                                            NOTA_VALOR.value              = toCurrency('#JSStringFormat(qrConhecimentoNotasFiscais.valor_total)#');
                                            NOTA_VALOR_SEGURADO.value     = '#JSStringFormat(qrConhecimentoNotasFiscais.valor_segurado)#';
                                            NOTA_ORDEM_COMPRA.value       = '#JSStringFormat(qrConhecimentoNotasFiscais.ordem_compra_cliente)#';
                                            NOTA_QTDE_VOLUME.value        = '#JSStringFormat(qrConhecimentoNotasFiscais.qtde_volume)#';
                                            NOTA_COD_UNIDADE.value        = '#JSStringFormat(qrConhecimentoNotasFiscais.cod_unidade)#';
                                            NOTA_M3.value                 = '#JSStringFormat(qrConhecimentoNotasFiscais.m3)#';
                                            NOTA_NUM_NATUREZA.value       = '#JSStringFormat(qrConhecimentoNotasFiscais.num_natureza)#';
                                            NOTA_NATUREZA.value           = '#JSStringFormat(qrConhecimentoNotasFiscais.natureza)#';
                                            NOTA_COMPLEMENTO.value        = '#JSStringFormat(qrConhecimentoNotasFiscais.complemento)#';
                                            NOTA_NUM_ESPECIE.value        = '#JSStringFormat(qrConhecimentoNotasFiscais.num_especie)#';
                                            NOTA_ESPECIE.value            = '#JSStringFormat(qrConhecimentoNotasFiscais.especie)#';
                                            NOTA_ALTURA.value             = ('#JSStringFormat(qrConhecimentoNotasFiscais.altura)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.altura)#';
                                            NOTA_LARGURA.value            = ('#JSStringFormat(qrConhecimentoNotasFiscais.largura)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.largura)#';
                                            NOTA_COMPRIMENTO.value        = ('#JSStringFormat(qrConhecimentoNotasFiscais.comprimento)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.comprimento)#';
                                            NOTA_CUBAGEM.value            = '#JSStringFormat(qrConhecimentoNotasFiscais.cubagem)#';
											NOTA_CUBAGEM_SUGERIDA.value   = '#JSStringFormat(qrConhecimentoNotasFiscais.cubagem_sugerida)#';
                                            NOTA_CFOP.value               = '#JSStringFormat(qrConhecimentoNotasFiscais.cfop)#';
                                            NOTA_PESO_COBRADO.value       = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_cobrado)#';
                                            <cfif isdefined("vars.complemento") and vars.complemento eq 1>
                                                NOTA_PESO.value               = 0;
                                                NOTA_PESO_CUBADO.value        = 0;
                                                NOTA_PESO_KG_CONVERTIDO.value = 0;
                                            <cfelse>	
                                                NOTA_PESO.value               = '#JSStringFormat(qrConhecimentoNotasFiscais.peso)#';
                                                NOTA_PESO_CUBADO.value        = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_cubado)#';
                                                NOTA_PESO_KG_CONVERTIDO.value = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_kg_convertido)#';
                                                
                                                parent.f_calcula_cubagem('NOTA');
                                            </cfif>
                                            
                                            parent.f_salvar_NOTAS_FISCAIS();
                                        }										
                                    </script>
                                </cfcase>
                                <cfcase value="1">
                                    <script type="text/javascript">
                                        with(parent.document.forms[0]) {
                                            parent.f_incluir_NFE();
                                                
                                            /* Campos */
                                            NF_CONHECIMENTO_ID.value	= '#JSStringFormat(qrConhecimentoNotasFiscais.conhecimento_id)#';
                                            CHAVE_ACESSO_NFE.value      = '#JSStringFormat(qrConhecimentoNotasFiscais.chave_acesso_nfe)#';
                                            NFE_VALOR.value             = toCurrency('#JSStringFormat(qrConhecimentoNotasFiscais.valor_total)#');
                                            NFE_VALOR_SEGURADO.value    = '#JSStringFormat(qrConhecimentoNotasFiscais.valor_segurado)#';
                                            <cfif Len(Trim(qrConhecimentoNotasFiscais.NFE_XML))>
												NOME_ARQUIVO.value          = 'nfe_#qrConhecimentoNotasFiscais.chave_acesso_nfe#.xml';
											</cfif>
                                            NUMERO_NFE.value            = '#JSStringFormat(qrConhecimentoNotasFiscais.numero)#';
                                            MODELO_NFE.value            = '#JSStringFormat(qrConhecimentoNotasFiscais.modelo)#';
                                            SERIE_NFE.value             = '#JSStringFormat(qrConhecimentoNotasFiscais.serie)#';
                                            DATA_EMISSAO_NFE.value      = '#JSStringFormat(qrConhecimentoNotasFiscais.data_emissao_data)#';
                                            NFE_ORDEM_COMPRA.value      = '#JSStringFormat(qrConhecimentoNotasFiscais.ordem_compra_cliente)#';
                                            REMETENTE_NFE.value			= '#JSStringFormat(qrConhecimentoNotasFiscais.emitente)#';
                                            CNPJ_REMETENTE_NFE.value    = '#JSStringFormat(qrConhecimentoNotasFiscais.cnpj_emitente)#';
                                            DESTINATARIO_NFE.value      = '#JSStringFormat(qrConhecimentoNotasFiscais.destinatario)#';
                                            CNPJ_DESTINATARIO_NFE.value = '#JSStringFormat(qrConhecimentoNotasFiscais.cnpj_destinatario)#';
                                            
                                            NFE_QTDE_VOLUME.value      	= '#JSStringFormat(qrConhecimentoNotasFiscais.qtde_volume)#';
                                            NFE_COD_UNIDADE.value      	= '#JSStringFormat(qrConhecimentoNotasFiscais.cod_unidade)#';
                                            NFE_NUM_NATUREZA.value     	= '#JSStringFormat(qrConhecimentoNotasFiscais.num_natureza)#';
                                            NFE_NATUREZA.value       	= '#JSStringFormat(qrConhecimentoNotasFiscais.natureza)#';
                                            NFE_NUM_ESPECIE.value      	= '#JSStringFormat(qrConhecimentoNotasFiscais.num_especie)#';
                                            NFE_ESPECIE.value       	= '#JSStringFormat(qrConhecimentoNotasFiscais.especie)#';
                                            NFE_ALTURA.value       		= ('#JSStringFormat(qrConhecimentoNotasFiscais.altura)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.altura)#';
                                            NFE_COMPRIMENTO.value      	= ('#JSStringFormat(qrConhecimentoNotasFiscais.comprimento)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.comprimento)#';
                                            NFE_LARGURA.value       	= ('#JSStringFormat(qrConhecimentoNotasFiscais.largura)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.largura)#';
                                            NFE_CUBAGEM.value       	= '#JSStringFormat(qrConhecimentoNotasFiscais.cubagem)#';
                                            NFE_CFOP.value       		= '#JSStringFormat(qrConhecimentoNotasFiscais.CFOP)#';
											NFE_CUBAGEM_SUGERIDA.value  = '#JSStringFormat(qrConhecimentoNotasFiscais.cubagem_sugerida)#';
                                            NFE_PESO_COBRADO.value      = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_cobrado)#';									
                                            ICMS_PARTILHADO.value      = '#JSStringFormat(qrConhecimentoNotasFiscais.icms_partilhado)#';									
                                            
                                            <cfif isdefined("vars.complemento") and vars.complemento eq 1>
                                                NFE_PESO.value               = 0;
                                                NFE_PESO_CUBADO.value        = 0;
                                                NFE_PESO_KG_CONVERTIDO.value = 0;
                                            <cfelse>	
                                                NFE_PESO.value               = '#JSStringFormat(qrConhecimentoNotasFiscais.peso)#';
                                                NFE_PESO_CUBADO.value        = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_cubado)#';
                                                NFE_PESO_KG_CONVERTIDO.value = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_kg_convertido)#';
                                                
                                                parent.f_calcula_cubagem('NFE');
                                            </cfif>
                                            
                                            parent.f_salvar_NFE();
                                        }
                                    </script>
                                </cfcase>
                                <cfcase value="2">
                                    <script type="text/javascript">
                                        with(parent.document.forms[0]) {
                                            parent.f_incluir_OUTROS();
                                            NF_CONHECIMENTO_ID.value		= '#JSStringFormat(qrConhecimentoNotasFiscais.conhecimento_id)#';
                                            OUTROS_NUMERO.value             = '#JSStringFormat(qrConhecimentoNotasFiscais.numero)#';
                                            OUTROS_DATA_EMISSAO.value       = '#JSStringFormat(qrConhecimentoNotasFiscais.data_emissao_data)#';
                                            OUTROS_DESCRICAO.value			= '#JSStringFormat(qrConhecimentoNotasFiscais.descricao_docto)#';
                                            OUTROS_VALOR.value				= toCurrency('#JSStringFormat(qrConhecimentoNotasFiscais.valor_total)#');
                                            OUTROS_VALOR_SEGURADO.value		= toCurrency('#JSStringFormat(qrConhecimentoNotasFiscais.valor_segurado)#');
                                            OUTROS_QTDE_VOLUME.value      	= '#JSStringFormat(qrConhecimentoNotasFiscais.qtde_volume)#';
                                            OUTROS_COD_UNIDADE.value      	= '#JSStringFormat(qrConhecimentoNotasFiscais.cod_unidade)#';
                                            OUTROS_NUM_NATUREZA.value     	= '#JSStringFormat(qrConhecimentoNotasFiscais.num_natureza)#';
                                            OUTROS_NATUREZA.value       	= '#JSStringFormat(qrConhecimentoNotasFiscais.natureza)#';
                                            OUTROS_NUM_ESPECIE.value      	= '#JSStringFormat(qrConhecimentoNotasFiscais.num_especie)#';
                                            OUTROS_ESPECIE.value       		= '#JSStringFormat(qrConhecimentoNotasFiscais.especie)#';
                                            OUTROS_ALTURA.value       		= ('#JSStringFormat(qrConhecimentoNotasFiscais.altura)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.altura)#';
                                            OUTROS_COMPRIMENTO.value      	= ('#JSStringFormat(qrConhecimentoNotasFiscais.comprimento)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.comprimento)#';
                                            OUTROS_LARGURA.value       		= ('#JSStringFormat(qrConhecimentoNotasFiscais.largura)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.largura)#';
                                            OUTROS_CUBAGEM.value       		= '#JSStringFormat(qrConhecimentoNotasFiscais.cubagem)#';
                                            OUTROS_CUBAGEM_SUGERIDA.value   = '#JSStringFormat(qrConhecimentoNotasFiscais.cubagem_sugerida)#';
                                            OUTROS_PESO_COBRADO.value       = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_cobrado)#';
                                            OUTROS_ORDEM_COMPRA.value       = '#JSStringFormat(qrConhecimentoNotasFiscais.ordem_compra_cliente)#';
                                            
                                            <cfif isdefined("vars.complemento") and vars.complemento eq 1>
                                                OUTROS_PESO.value               = 0;
                                                OUTROS_PESO_CUBADO.value        = 0;
                                                OUTROS_PESO_KG_CONVERTIDO.value = 0;
                                            <cfelse>	
                                                OUTROS_PESO.value               = '#JSStringFormat(qrConhecimentoNotasFiscais.peso)#';
                                                OUTROS_PESO_CUBADO.value        = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_cubado)#';
                                                OUTROS_PESO_KG_CONVERTIDO.value = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_kg_convertido)#';
                                                
                                                parent.f_calcula_cubagem('OUTROS');
                                            </cfif>
                                            
                                            parent.f_salvar_OUTROS();
                                        }
                                    </script>
                                </cfcase>
                                <cfcase value="3">
                                    <script type="text/javascript">
                                        with(parent.document.forms[0]) {
                                            parent.f_incluir_OUTROS();
                                            NF_CONHECIMENTO_ID.value	   	= '#JSStringFormat(qrConhecimentoNotasFiscais.conhecimento_id)#';
                                            OUTROS_NUMERO.value            = '#JSStringFormat(qrConhecimentoNotasFiscais.numero)#';
                                            OUTROS_DATA_EMISSAO.value      = '#JSStringFormat(qrConhecimentoNotasFiscais.data_emissao_data)#';
                                            OUTROS_DESCRICAO.value			= '#JSStringFormat(qrConhecimentoNotasFiscais.descricao_docto)#';
                                            OUTROS_VALOR.value				   = toCurrency('#JSStringFormat(qrConhecimentoNotasFiscais.valor_total)#');
                                            OUTROS_VALOR_SEGURADO.value		= toCurrency('#JSStringFormat(qrConhecimentoNotasFiscais.valor_segurado)#');
                                            OUTROS_QTDE_VOLUME.value      	= '#JSStringFormat(qrConhecimentoNotasFiscais.qtde_volume)#';
                                            OUTROS_COD_UNIDADE.value      	= '#JSStringFormat(qrConhecimentoNotasFiscais.cod_unidade)#';
                                            OUTROS_NUM_NATUREZA.value     	= '#JSStringFormat(qrConhecimentoNotasFiscais.num_natureza)#';
                                            OUTROS_NATUREZA.value       	= '#JSStringFormat(qrConhecimentoNotasFiscais.natureza)#';
                                            OUTROS_NUM_ESPECIE.value      	= '#JSStringFormat(qrConhecimentoNotasFiscais.num_especie)#';
                                            OUTROS_ESPECIE.value       		= '#JSStringFormat(qrConhecimentoNotasFiscais.especie)#';
                                            OUTROS_ALTURA.value       		= ('#JSStringFormat(qrConhecimentoNotasFiscais.altura)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.altura)#';
                                            OUTROS_COMPRIMENTO.value      	= ('#JSStringFormat(qrConhecimentoNotasFiscais.comprimento)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.comprimento)#';
                                            OUTROS_LARGURA.value       		= ('#JSStringFormat(qrConhecimentoNotasFiscais.largura)#' == '')?'0':'#JSStringFormat(qrConhecimentoNotasFiscais.largura)#';
                                            OUTROS_CUBAGEM.value       		= '#JSStringFormat(qrConhecimentoNotasFiscais.cubagem)#';
                                            OUTROS_CUBAGEM_SUGERIDA.value  = '#JSStringFormat(qrConhecimentoNotasFiscais.cubagem_sugerida)#';
                                            OUTROS_PESO_COBRADO.value      = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_cobrado)#';
                                            OUTROS_ORDEM_COMPRA.value      = '#JSStringFormat(qrConhecimentoNotasFiscais.ordem_compra_cliente)#';
                                            
                                            <cfif isdefined("vars.complemento") and vars.complemento eq 1>
                                                OUTROS_PESO.value               = 0;
                                                OUTROS_PESO_CUBADO.value        = 0;
                                                OUTROS_PESO_KG_CONVERTIDO.value = 0;
                                            <cfelse>	
                                                OUTROS_PESO.value               = '#JSStringFormat(qrConhecimentoNotasFiscais.peso)#';
                                                OUTROS_PESO_CUBADO.value        = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_cubado)#';
                                                OUTROS_PESO_KG_CONVERTIDO.value = '#JSStringFormat(qrConhecimentoNotasFiscais.peso_kg_convertido)#';
                                                
                                                parent.f_calcula_cubagem('OUTROS');
                                            </cfif>
                                            
                                            parent.f_salvar_OUTROS();
                                        }
                                    </script>
                                </cfcase>
                            </cfswitch>
                        </cfoutput>   
						
						<script type="text/javascript">
							with(parent.document.forms[0]) {
								POPULANDO_DADOS.value = 0;
							}
						</script>
						
						<cfif vars.substituto eq 1 && qrConhecimento.COD_STATUS eq 128>
							<script type="text/javascript">
                                with(parent.document.forms[0]) {
                                    parent.setReadOnly['NOTAS_FISCAIS'](true);
                                    parent.document.getElementById('btn_lista_incluir_NOTAS_FISCAIS').style.display = 'none';
                                    parent.document.getElementById('btn_lista_excluir_NOTAS_FISCAIS').style.display = 'none';
                                    parent.document.getElementById('btn_lista_salvar_NOTAS_FISCAIS').style.display = 'none';
                                    parent.document.getElementById('btn_lista_cancelar_NOTAS_FISCAIS').style.display = 'none';
                                }
                            </script>
					    </cfif>
                    <cfelse>
					    <cfif qrConhecimento.TEM_ANULACAO neq 1>
							<script type="text/javascript">
								with(parent.document.forms[0]) {
									TIPO_DOCUMENTO_ID.value = 2;
									TIPO_DOCUMENTO_ID.onchange();
									var x = document.getElementById("TIPO_DOCUMENTO_ID");
									x.remove(x.selectedIndex);
									parent.document.getElementById('tr_nf_substituto').style.display = '';
									TIPO_DOCUMENTO_ID.value = 1;
									TIPO_DOCUMENTO_ID.onchange();
								}
							</script>
					    </cfif>                    
                    </cfif>
					
					<cfif vars.substituto eq 1 && qrConhecimento.COD_STATUS eq 128 >
					   <script type="text/javascript">
                            with(parent.document.forms[0]) {
							   ARQUIVO.setAttribute('obrigatorio', 1);
							   parent.setReadOnly['NOTAS_ANULACAO'](true);
                            }
                        </script>
					</cfif>
					
                    <script type="text/javascript">
						with(parent.document.forms[0]) {
							<cfoutput>							
								parent.v_inserida = 0;
							
								// Dados Gerais
								parent.v_proprietario_tracao = '#JSStringFormat(qrConhecimento.proprietario_tracao)#';
								CONHECIMENTO_ID.value		= '#JSStringFormat(qrConhecimento.conhecimento_id)#';
								NUM_CONHECIMENTO.value		= '#JSStringFormat(qrConhecimento.num_conhecimento)#';
								DATA_EMISSAO.value			= '#JSStringFormat(qrConhecimento.data_emissao_data_hora)#';
								PLACA_CONTROLE.value 		= '#JSStringFormat(qrConhecimento.placa_tracao)#';
								PLACA_CONTROLE.onchange();
								PLACA_REFERENCIA.value 		= '#JSStringFormat(qrConhecimento.placa)#';
								<cfif IsDefined('vars.complemento') and vars.complemento neq 1>
									FRETE_EM.value              = '#JSStringFormat(qrConhecimento.frete_em)#';
									REGRA_FISCAL.value			= '#JSStringFormat(qrConhecimento.regra_fiscal_id)#';
									REGRA_FISCAL_ID.value		= '#JSStringFormat(qrConhecimento.regra_fiscal_id)#';
								<cfelse>
									if(TIPO_COMPLEMENTO_ID.value == 1){
										FRETE_EM.value				= 'LOTACAO';
										REGRA_FISCAL.value			= '1';
										REGRA_FISCAL_ID.value		= '1';
									}else{
										FRETE_EM.value				= '#JSStringFormat(qrConhecimento.frete_em)#';
										REGRA_FISCAL.value			= '#JSStringFormat(qrConhecimento.regra_fiscal_id)#';
										REGRA_FISCAL_ID.value		= '#JSStringFormat(qrConhecimento.regra_fiscal_id)#';
									}
								</cfif>
								
								parent.f_limpar_engates();
								if ('#JSStringFormat(qrConhecimento.placa)#' != '' && '#JSStringFormat(qrConhecimento.placa)#' != '#JSStringFormat(qrConhecimento.placa_tracao)#') {
									parent.v_obj = parent.f_engata();
									parent.v_obj.setValue('#JSStringFormat(qrConhecimento.placa)#');
									parent.f_valida_veiculos();
								}
								
                                var v_placas_viagem = <cfoutput>'#JSStringFormat(qrConhecimento.carretas)#'</cfoutput>;

                                if (v_placas_viagem.length) {
                                    v_placas_viagem = v_placas_viagem.split(',');
                                    for (var i=0; i<v_placas_viagem.length; i++){
										parent.f_engata();
										parent.f_seta_placa_referencia(v_placas_viagem[i],i+2);
                                    }
								}

								EMITE_MULTIMODAL.value      = '#qrConhecimento.EMITE_MULTIMODAL#';
								VINCULADO_MULTIMODAL.value  = '#qrConhecimento.VINCULADO_MULTIMODAL#';
								parent.f_valida_cte_ref();
								TEM_ANULACAO.value          = '#qrConhecimento.TEM_ANULACAO#';

								COD_PROPRIETARIO.value 		= '#JSStringFormat(qrConhecimento.cod_proprietario)#';
								PROP_CNPJ_CPF.value 		= '#JSStringFormat(qrConhecimento.prop_cnpj_cpf)#';
								PROPRIETARIO.value          = '#JSStringFormat(qrConhecimento.prop_razao_social)#';
								PROP_RAZAO_SOCIAL.value 	= '#JSStringFormat(qrConhecimento.prop_razao_social)#';
								PROP_ENDERECO.value 		= '#JSStringFormat(qrConhecimento.prop_endereco)#';
								PROP_UF.value 				= '#JSStringFormat(qrConhecimento.prop_uf)#';
								COD_MOTORISTA.value 		= '#JSStringFormat(qrConhecimento.cod_motorista)#';
								MOTORISTA.value 			= '#JSStringFormat(qrConhecimento.nome_motorista)#';
								NOME_MOTORISTA.value 		= '#JSStringFormat(qrConhecimento.nome_motorista)#';
								
								NUM_ROMANEIO.value			= '#JSStringFormat(qrConhecimento.num_romaneio)#';
								ITEM_ID.value				= '#JSStringFormat(qrConhecimento.item_id)#';
								VIAGEM_CARGA_ID.value		= '#JSStringFormat(qrConhecimento.viagem_carga_id)#';
								CFOP_ID.value 				= '#JSStringFormat(qrConhecimento.cfop_id)#';
								CFOP.value 					= '#JSStringFormat(qrConhecimento.cfop)#';
								NATUREZA_OPERACAO.value		= '#JSStringFormat(qrConhecimento.natureza_operacao)#';
								M3.value					= '#JSStringFormat(qrConhecimento.m3)#';
								SITUACAO_ID.value			= '#JSStringFormat(qrConhecimento.situacao_id)#';
								
								IMPRESSO.value				= '#JSStringFormat(qrConhecimento.impresso)#';
								ENTRADA_DADOS.value			= '#JSStringFormat(qrConhecimento.entrada_dados)#';
								TEM_NOTA.value				= 0
								
								NUM_PRODUTO.value 			= '#JSStringFormat(qrConhecimento.num_produto)#';
								
								<cfif vars.substituto eq 0>
								ST_ICMS_ID.value 			= '#JSStringFormat(qrConhecimento.st_icms_id)#';
								ST_ICMS_ID_COMBO.value 		= '#JSStringFormat(qrConhecimento.st_icms_id)#';
								</cfif>

								
								ST_ORIGEM_ID.value 			= '#JSStringFormat(qrConhecimento.st_origem_id)#';
								
								PESO.value					= '#JSStringFormat(qrConhecimento.peso)#';
								
								VOLUME.value 				= '#JSStringFormat(qrConhecimento.volume)#';
								NUM_NATUREZA.value			= '#JSStringFormat(qrConhecimento.num_natureza)#';
								NUM_NATUREZA.onchange();
								NUM_ESPECIE.value			= '#JSStringFormat(qrConhecimento.num_especie)#';
								NUM_ESPECIE.onchange();
								<cfif not (isdefined("vars.complemento") and vars.complemento eq 1)>
									OBSERVACAO.value			= '#JSStringFormat(qrConhecimento.observacao)#';
									OBSERVACAO_AUTOMATICA.value	= '#JSStringFormat(qrConhecimento.observacao_automatica)#';
								</cfif>
								RODAPE.value				= '#JSStringFormat(qrConhecimento.rodape)#';
								
								CNPJ_TRANSPORTADORA.value	= '#JSStringFormat(qrConhecimento.cnpj_cpf_filial)#';
								COD_PESSOA_FILIAL_AUX.value = '#JSStringFormat(qrConhecimento.COD_PESSOA_FILIAL)#';
								
								//Organograma
								COD_PESSOA_FILIAL.value	= '#JSStringFormat(qrConhecimento.COD_PESSOA_FILIAL)#';
								try{COD_PESSOA_FILIAL.onchange();}catch (e){}
								COD_DEPARTAMENTO.value	= '#JSStringFormat(qrConhecimento.COD_DEPARTAMENTO)#';
								try{COD_DEPARTAMENTO.onchange();}catch (e){}
								COD_SETOR.value			= '#JSStringFormat(qrConhecimento.COD_SETOR)#';
								try{COD_SETOR.onchange();}catch (e){}
								COD_CENTRO_CUSTO.value	= '#JSStringFormat(qrConhecimento.COD_CENTRO_CUSTO)#';
								
								COD_PESSOA_FILIAL.disabled = true;
								COD_DEPARTAMENTO.disabled = true;
								COD_SETOR.disabled = true;
								COD_CENTRO_CUSTO.disabled = true;
								
								// Coleta
								COLETA_COD_PESSOA.value			= '#JSStringFormat(qrConhecimento.coleta_cod_pessoa)#';
								COLETA_CNPJ_CPF.value			= '#JSStringFormat(qrConhecimento.coleta_cnpj_cpf)#';
								COLETA_RAZAO_SOCIAL.value   	= '#JSStringFormat(qrConhecimento.coleta_razao_social)#';
								//COLETA_INSCRICAO_ESTADUAL.value = '#JSStringFormat(qrConhecimento.coleta_inscricao_estadual)#';
								
								f_limpa_select(parent.document.getElementById('COLETA_CB_ENDERECO'));
								parent.v_enderecos_COLETA = new Array();
								parent.v_enderecos_COLETA.push( {
									cod_pessoa		: '#JSStringFormat(qrConhecimento.coleta_cod_pessoa)#',
									cod_endereco	: '#JSStringFormat(qrConhecimento.cod_endereco_coleta)#',
									municipio_id	: '#JSStringFormat(qrConhecimento.coleta_municipio_id)#',
									municipio		: '#JSStringFormat(qrConhecimento.coleta_municipio)#',
									cep				: '#JSStringFormat(qrConhecimento.coleta_cep)#',
									logradouro		: '#JSStringFormat(qrConhecimento.coleta_logradouro)#',
									numero			: '#JSStringFormat(qrConhecimento.coleta_num)#',
									bairro			: '#JSStringFormat(qrConhecimento.coleta_bairro)#',
									uf				: '#JSStringFormat(qrConhecimento.coleta_uf)#',
									padrao			: '1',
									inscricao_estadual    : '#JSStringFormat(qrConhecimento.coleta_inscricao_estadual)#',
									cod_atividade_fiscal  : '#JSStringFormat(qrConhecimento.coleta_cod_atividade)#'
								} );
								parent.f_busca_endereco_COLETA('#JSStringFormat(qrConhecimento.coleta_cod_pessoa)#');
								
								// Rementente
								COD_REMETENTE.value 		= '#JSStringFormat(qrConhecimento.cod_remetente)#';
								REM_CNPJ_CPF.value 			= '#JSStringFormat(qrConhecimento.rem_cnpj_cpf)#';
								REM_RAZAO_SOCIAL.value 		= '#JSStringFormat(qrConhecimento.rem_razao_social)#';
								//REM_INSCRICAO_ESTADUAL.value = '#JSStringFormat(qrConhecimento.rem_inscricao_estadual)#';
								
								f_limpa_select(parent.document.getElementById('REM_CB_ENDERECO'));
								parent.v_enderecos_REM = new Array();
								parent.v_enderecos_REM.push( {
									cod_pessoa		: '#JSStringFormat(qrConhecimento.cod_remetente)#',
									cod_endereco	: '#JSStringFormat(qrConhecimento.cod_endereco_rem)#',
									municipio_id	: '#JSStringFormat(qrConhecimento.rem_municipio_id)#',
									municipio		: '#JSStringFormat(qrConhecimento.rem_municipio)#',
									cep				: '#JSStringFormat(qrConhecimento.rem_cep)#',
									logradouro		: '#JSStringFormat(qrConhecimento.rem_endereco)#',
									numero			: '#JSStringFormat(qrConhecimento.rem_endereco_num)#',
									bairro			: '#JSStringFormat(qrConhecimento.rem_bairro)#',
									uf				: '#JSStringFormat(qrConhecimento.rem_uf)#',
									padrao			: '1',
									inscricao_estadual    : '#JSStringFormat(qrConhecimento.rem_inscricao_estadual)#',
									cod_atividade_fiscal  : '#JSStringFormat(qrConhecimento.rem_cod_atividade)#'
								} );
								parent.f_busca_endereco_REM('#JSStringFormat(qrConhecimento.cod_remetente)#');
								
								// Destinatario
								COD_DESTINATARIO.value 		= '#JSStringFormat(qrConhecimento.cod_destinatario)#';
								DEST_CNPJ_CPF.value 		= '#JSStringFormat(qrConhecimento.dest_cnpj_cpf)#';
								DEST_RAZAO_SOCIAL.value 	= '#JSStringFormat(qrConhecimento.dest_razao_social)#';
								//DEST_INSCRICAO_ESTADUAL.value = '#JSStringFormat(qrConhecimento.dest_inscricao_estadual)#';
																
								f_limpa_select(parent.document.getElementById('DEST_CB_ENDERECO'));
								parent.v_enderecos_DEST = new Array();
								parent.v_enderecos_DEST.push( {
									cod_pessoa		: '#JSStringFormat(qrConhecimento.cod_destinatario)#',
									cod_endereco	: '#JSStringFormat(qrConhecimento.cod_endereco_dest)#',
									municipio_id	: '#JSStringFormat(qrConhecimento.dest_municipio_id)#',
									municipio		: '#JSStringFormat(qrConhecimento.dest_municipio)#',
									cep				: '#JSStringFormat(qrConhecimento.dest_cep)#',
									logradouro		: '#JSStringFormat(qrConhecimento.dest_endereco)#',
									numero			: '#JSStringFormat(qrConhecimento.dest_endereco_num)#',
									bairro			: '#JSStringFormat(qrConhecimento.dest_bairro)#',
									uf				: '#JSStringFormat(qrConhecimento.dest_uf)#',
									padrao			: '1',
									inscricao_estadual    : '#JSStringFormat(qrConhecimento.dest_inscricao_estadual)#',
									cod_atividade_fiscal  : '#JSStringFormat(qrConhecimento.dest_cod_atividade)#'
								} );
								parent.f_busca_endereco_DEST('#JSStringFormat(qrConhecimento.cod_destinatario)#');
								
								// Redespacho - Entrega
								COD_REDESPACHO.value 	= '#JSStringFormat(qrConhecimento.cod_redespacho)#';
								RED_CNPJ_CPF.value 		= '#JSStringFormat(qrConhecimento.red_cnpj_cpf)#';
								RED_RAZAO_SOCIAL.value 	= '#JSStringFormat(qrConhecimento.red_razao_social)#';
								//RED_INSCRICAO_ESTADUAL.value = '#JSStringFormat(qrConhecimento.red_inscricao_estadual)#';
								
								f_limpa_select(parent.document.getElementById('RED_CB_ENDERECO'));
								parent.v_enderecos_RED = new Array();
								parent.v_enderecos_RED.push( {
									cod_pessoa		: '#JSStringFormat(qrConhecimento.cod_redespacho)#',
									cod_endereco	: '#JSStringFormat(qrConhecimento.cod_endereco_entrega)#',
									municipio_id	: '#JSStringFormat(qrConhecimento.red_municipio_id)#',
									municipio		: '#JSStringFormat(qrConhecimento.red_municipio)#',
									cep				: '#JSStringFormat(qrConhecimento.red_cep)#',
									logradouro		: '#JSStringFormat(qrConhecimento.entrega_logradouro)#',
									numero			: '#JSStringFormat(qrConhecimento.entrega_num)#',
									bairro			: '#JSStringFormat(qrConhecimento.entrega_bairro)#',
									uf				: '#JSStringFormat(qrConhecimento.entrega_uf)#',
									padrao			: '1',
									inscricao_estadual    : '#JSStringFormat(qrConhecimento.entrega_inscricao_estadual)#',
									cod_atividade_fiscal  : '#JSStringFormat(qrConhecimento.entrega_cod_atividade)#'
								} );
								parent.f_busca_endereco_RED('#JSStringFormat(qrConhecimento.cod_redespacho)#');
								
								// Cliente Cobranca
								COD_CLIENTE_COBRANCA.value 	= '#JSStringFormat(qrConhecimento.cod_cliente_cobranca)#';
								COB_CNPJ_CPF.value 			= '#JSStringFormat(qrConhecimento.cob_cnpj_cpf)#';
								COB_RAZAO_SOCIAL.value 		= '#JSStringFormat(qrConhecimento.cob_razao_social)#';
								//COB_INSCRICAO_ESTADUAL.value = '#JSStringFormat(qrConhecimento.cob_inscricao_estadual)#';
								
								f_limpa_select(parent.document.getElementById('COB_CB_ENDERECO'));
								parent.v_enderecos_COB = new Array();
								parent.v_enderecos_COB.push( {
									cod_pessoa		: '#JSStringFormat(qrConhecimento.cod_cliente_cobranca)#',
									cod_endereco	: '#JSStringFormat(qrConhecimento.cod_endereco_cob)#',
									municipio_id	: '#JSStringFormat(qrConhecimento.cob_municipio_id)#',
									municipio		: '#JSStringFormat(qrConhecimento.cob_municipio)#',
									cep				: '#JSStringFormat(qrConhecimento.cob_cep)#',
									logradouro		: '#JSStringFormat(qrConhecimento.cob_endereco)#',
									numero			: '#JSStringFormat(qrConhecimento.cob_endereco_num)#',
									bairro			: '#JSStringFormat(qrConhecimento.cob_bairro)#',
									uf				: '#JSStringFormat(qrConhecimento.cob_uf)#',
									padrao			: '1',
									inscricao_estadual    : '#JSStringFormat(qrConhecimento.cob_inscricao_estadual)#',
									cod_atividade_fiscal  : '#JSStringFormat(qrConhecimento.cob_cod_atividade)#'
								} );
								parent.f_busca_endereco_COB('#JSStringFormat(qrConhecimento.cod_cliente_cobranca)#');
		
								// Cliente Negociador
								COD_NEGOCIADOR.value 		= '#JSStringFormat(qrConhecimento.cod_negociador)#';
								NEG_CNPJ_CPF.value 			= '#JSStringFormat(qrConhecimento.neg_cnpj_cpf)#';
								NEG_RAZAO_SOCIAL.value 		= '#JSStringFormat(qrConhecimento.neg_razao_social)#';
								//NEG_INSCRICAO_ESTADUAL.value = '#JSStringFormat(qrConhecimento.neg_inscricao_estadual)#';
								
								f_limpa_select(parent.document.getElementById('NEG_CB_ENDERECO'));
								parent.v_enderecos_NEG = new Array();
								parent.v_enderecos_NEG.push( {
									cod_pessoa		: '#JSStringFormat(qrConhecimento.cod_negociador)#',
									cod_endereco	: '1',
									municipio_id	: '#JSStringFormat(qrConhecimento.neg_municipio_id)#',
									municipio		: '#JSStringFormat(qrConhecimento.neg_municipio)#',
									cep				: '#JSStringFormat(qrConhecimento.neg_cep)#',
									logradouro		: '#JSStringFormat(qrConhecimento.neg_endereco)#',
									numero			: '#JSStringFormat(qrConhecimento.neg_endereco_num)#',
									bairro			: '#JSStringFormat(qrConhecimento.neg_bairro)#',
									uf				: '#JSStringFormat(qrConhecimento.neg_uf)#',
									padrao			: '1',
									inscricao_estadual    : '#JSStringFormat(qrConhecimento.neg_inscricao_estadual)#',
									cod_atividade_fiscal  : '#JSStringFormat(qrConhecimento.neg_cod_atividade)#'
								} );
								parent.f_busca_endereco_NEG('#JSStringFormat(qrConhecimento.cod_negociador)#');
								
								ADEME.value					= '#JSStringFormat(qrConhecimento.ademe)#';
								DESCONTO.value				= '#JSStringFormat(qrConhecimento.desconto)#';
								IMPOSTOS.value				= '#JSStringFormat(qrConhecimento.impostos)#';
								DESPACHO_CALC.value			= '#JSStringFormat(qrConhecimento.despacho)#';
								PEDAGIO_CALC.value			= '#JSStringFormat(qrConhecimento.pedagio)#';
								SEC_CAT_CALC.value			= '#JSStringFormat(qrConhecimento.sec_cat)#';
								GRIS_CALC.value				= '#JSStringFormat(qrConhecimento.gris)#';
								COLETA_ENTREGA_CALC.value	= '#JSStringFormat(qrConhecimento.coleta_entrega)#';
								DESPACHO.value				= '#JSStringFormat(qrConhecimento.despacho)#';
								PEDAGIO.value				= '#JSStringFormat(qrConhecimento.pedagio)#';
								SEC_CAT.value				= '#JSStringFormat(qrConhecimento.sec_cat)#';
								GRIS.value					= '#JSStringFormat(qrConhecimento.gris)#';
								COLETA_ENTREGA.value		= '#JSStringFormat(qrConhecimento.coleta_entrega)#';
								FRETE_UNITARIO.value		= '#JSStringFormat(qrConhecimento.frete_unitario)#';
								FRETE_UNITARIO_DESC.value	= '#JSStringFormat(qrConhecimento.frete_unitario)#';
								FRETE_PESO.value			= '#JSStringFormat(qrConhecimento.frete_peso)#';
								FRETE_VALOR.value			= '#JSStringFormat(qrConhecimento.frete_valor)#';
								BASE_CALCULO_ICMS.value		= '#JSStringFormat(qrConhecimento.base_calculo_icms)#';
								ALIQUOTA_ICMS.value			= '#JSStringFormat(qrConhecimento.aliquota_icms)#';
								VALOR_ICMS.value			= '#JSStringFormat(qrConhecimento.valor_icms)#';
								TOTAL_CONHECIMENTO.value	= '#JSStringFormat(qrConhecimento.total_conhecimento)#';
								VALOR_ICMS_SUBSTIT.value	= '#JSStringFormat(qrConhecimento.valor_icms_substit)#';
								OPERACAO_ID.value		    = '#JSStringFormat(qrConhecimento.operacao_id)#';
								OPERACAO_CTRC.value		    = '#JSStringFormat(qrConhecimento.operacao_descricao)#';
								OPERACAO_ID_CTRC.value		= '#JSStringFormat(qrConhecimento.operacao_id)#';
								TIPO_FRETE.value			= '#JSStringFormat(qrConhecimento.tipo_frete)#';
								TIPO_FRETE_DESC.value	    = '#JSStringFormat(qrConhecimento.tipo_frete_desc)#';
								SOLICITACAO_CARGA_ID.value  = '#JSStringFormat(qrConhecimento.solicitacao_carga_id)#';
								MODAL.value                 = '#JSStringFormat(qrConhecimento.modal)#';
								if ('#JSStringFormat(qrConhecimento.conhecimento_tipo_id)#' == 1000) {// 1000 - EDI
								   CONHECIMENTO_TIPO_ID.value  = '#JSStringFormat(qrConhecimento.conhecimento_tipo_id)#';
								}
								DISPENSADO_TABELA_FRETE.value = '#JSStringFormat(qrConhecimento.dispensado_tabela_frete)#';
								
								parent.f_atualiza_pagador();
             					
								<!---Busca o Centro de Custo Gerencial--->
								parent.f_limpa_select(parent.document.getElementById('ORGANIZACIONAL_ID'));
								v_option = f_cria_option('#qrConhecimento.ORGANIZACIONAL_ID#', '#JSStringFormat(qrConhecimento.ORGANIZACIONAL_DESCRICAO)#', parent.document.getElementById('ORGANIZACIONAL_ID'));
								v_option.setAttribute('codigo', '#qrConhecimento.COD_ORGANIZACIONAL#');
								ORGANIZACIONAL_ID.onchange();
								ORGANIZACIONAL_ID.disabled = true;
								COD_ORGANIZACIONAL.readOnly = true;
								
								if (NUM_PRODUTO.value == 7) {
									BASE_CALCULO_ICMS.value		= '#JSStringFormat(qrConhecimento.base_calculo_iss)#';
									ALIQUOTA_ICMS.value			= '#JSStringFormat(qrConhecimento.aliquota_iss)#';
									VALOR_ICMS.value			= '#JSStringFormat(qrConhecimento.valor_iss)#';
								}
								
								if ( '#JSStringFormat(qrConhecimento.valor_icms_substit)#' > 0) 
									parent.document.getElementById("tr_icms_substit").style.display = '';
								else
									parent.document.getElementById("tr_icms_substit").style.display = 'none';
								
								parent.v_cnpj_ordem = '#JSStringFormat(qrConhecimento.cnpj_ordem)#';
								PESO_KG.value = '#JSStringFormat(qrConhecimento.peso)#';
								parent.f_on_busca_conhecimento();
								<cfif not (isdefined("vars.complemento") and vars.complemento eq 1)>
									parent.f_muda_uf(1);
									
									if (OPERACAO_ID.value == '') {
										parent.document.getElementById('btn_buscar_lote').click();			
										parent.document.getElementById('btn_buscar_lote').style.display = '';
									}
									<cfif vars.substituto eq 0>
									if(Number('#JSStringFormat(qrConhecimento.possui_tabela_frete)#') == 1) {

										parent.document.getElementById('aba_auditoria_comercial').style.display = '';
										parent.f_busca_versoes();
									}
									</cfif>
								<cfelse>
									parent.f_busca_tipo_calculo();
								</cfif>
        parent.f_preenche_cb_ie_REM("<cfoutput>#qrConhecimento.rem_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.rem_inscricao_estadual#</cfoutput>");
        parent.f_preenche_cb_ie_DEST("<cfoutput>#qrConhecimento.dest_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.dest_inscricao_estadual#</cfoutput>");
        parent.f_preenche_cb_ie_COLETA("<cfoutput>#qrConhecimento.coleta_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.cons_inscricao_estadual#</cfoutput>");
        parent.f_preenche_cb_ie_COB("<cfoutput>#qrConhecimento.cob_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.cob_inscricao_estadual#</cfoutput>");
        parent.f_preenche_cb_ie_RED("<cfoutput>#qrConhecimento.entrega_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.entrega_inscricao_estadual#</cfoutput>");
        parent.f_preenche_cb_ie_NEG("<cfoutput>#qrConhecimento.neg_ie_adicional#</cfoutput>", "<cfoutput>#qrConhecimento.neg_inscricao_estadual#</cfoutput>");
								
								<!---Busca o Prazo de Entrega--->
								with(parent.document.forms[0]) {
									<cfif vars.calcula_prazo_entrega eq 0>
										PRAZO_ENTREGA.value 		= <cfoutput>'#JSStringFormat(qrConhecimento.prazo_entrega_data)#'</cfoutput>;

										if(Number(PRAZO_ENTREGA.value.getDateTime()) < Number(DATA_EMISSAO.value.getDateTime())) {
											v_dt =  new Date( Number(DATA_EMISSAO.value.getDateTime()) + (60 * 1000));
											v_dt_prazo = v_dt.format('dd/mm/')+v_dt.getFullYear()+v_dt.format(' hh24:mi');
											PRAZO_ENTREGA.value = v_dt_prazo;
										}

									<cfelse>
										parent.f_prazo_entrega(0);
									</cfif>
								}
								
							    PEDIDO_SHIPMENT_SOLICITACAO.value = '#JSStringFormat(qrConhecimento.pedido_shipment_solicitacao)#';
								
								
								
								<!---Tags--->
						<cfscript>
						
							//qrTags = connCte.get_tags_cte(conhecimento_id = vars.CONHECIMENTO_ID); nao procurar mais devido as novas configs de complementar
							if(isdefined("qrConhecimento.OPERACAO_ID") and Len(Trim(qrConhecimento.OPERACAO_ID)) ){
								qrTagsOper = connCte.get_tags_operacao(operacao_id = qrConhecimento.OPERACAO_ID, utilizado_em= 2);
							}
						</cfscript>
						 
							<cfif isdefined("qrTags") and qrTags.recordCount gt 0>
								<cfif IsDefined('vars.COMPLEMENTO') and vars.complemento eq 1>
									tags_complemento ='<table class="borda" border="0" cellspacing="1" cellpadding="3"> '
										 +'   <tr class="titulo_3"> '
										 +'      <td>Ordem</td> '
										 +'      <td>Descri&ccedil;&atilde;o</td> '
										 +'      <td>Obrigat&oacute;rio</td> '
										 +'      <td>Valor</td> '
										 +'   </tr> '
										 +'   <cfloop query="qrTags"> '
										 +'      <tr class="linha_2"> '
										 +'         <td align="center"> '
										 +'            <input type="hidden" name="TAG_OPERACAO_OBS_CONTRIB_ID" id="TAG_OPERACAO_OBS_CONTRIB_ID" value="<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" /> '
										 +'            <input type="hidden" name="TAG_CONHECIMENTO_OBS_CONTRIB_ID" id="CONHECIMENTO_OBS_CONTRIB_ID" value="<cfoutput>#qrTags.CONHECIMENTO_OBS_CONTRIB_ID#</cfoutput>" /> '
										 +'            <cfoutput>#qrTags.ORDEM#</cfoutput> '
										 +'         </td> '
										 +'         <td nowrap align="left"><nobr><cfoutput>#JSStringFormat(qrTags.DESCRICAO)#</cfoutput></td> '
										 +'         <td align="center"><cfoutput>#qrTags.OBRIGATORIO_CPL_STR#</cfoutput></td> '
										 +'         <td> '
										 +'			 	<textarea onkeydown="limitText(\'TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" onkeyup="limitText(\'TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" maxlenght="160" rows="2" cols="100" display="Valor, referente  observao <cfoutput>#JSStringFormat(qrTags.DESCRICAO)#</cfoutput>" obrigatorio=<cfoutput>#qrTags.OBRIGATORIO_COMPLEMENTO#</cfoutput> name="TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" id="TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>"><cfoutput>#REReplace(REReplace(qrTags.VALOR, chr(10), '<br />', 'all'), chr(13), '<br />', 'all')#</cfoutput></textarea> '
										 +'         </td> '
										 +'      </tr> '
										 +'   </cfloop> '
										 +'</table> ';

								<cfelse>
									tags_complemento ='<table class="borda" border="0" cellspacing="1" cellpadding="3"> '
										 +'   <tr class="titulo_3"> '
										 +'      <td>Ordem</td> '
										 +'      <td>Descri&ccedil;&atilde;o</td> '
										 +'      <td>Obrigat&oacute;rio</td> '
										 +'      <td>Valor</td> '
										 +'   </tr> '
										 +'   <cfloop query="qrTags"> '
										 +'	  <cfif qrTags.tipo eq 'LISTA_VALORES' > '
								     +'      <tr class="linha_2"> '
										 +'         <td align="center"> '
										 +'            <input type="hidden" name="TAG_OPERACAO_OBS_CONTRIB_ID" id="TAG_OPERACAO_OBS_CONTRIB_ID" value="<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" /> '
										 +'            <input type="hidden" name="TAG_CONHECIMENTO_OBS_CONTRIB_ID" id="CONHECIMENTO_OBS_CONTRIB_ID" value="<cfoutput>#qrTags.CONHECIMENTO_OBS_CONTRIB_ID#</cfoutput>" /> '
										 +'            <cfoutput>#qrTags.ORDEM#</cfoutput> '
										 +'         </td> '
										 +'         <td nowrap align="left"><nobr><cfoutput>#JSStringFormat(qrTags.DESCRICAO)#</cfoutput></td> '
										 +'         <td align="center"><cfoutput>#qrTags.OBRIGATORIO_STR#</cfoutput></td> '
										 +'         <td> '
										 + '<cfscript> connCte2 = CreateComponent("modulos.cte._componentes.consulta.cfc_cte"); qrListaValores = connCte2.get_tags_operacao_lista_valores(operacao_tag_lista_id = qrTags.valor_padrao); </cfscript>'
										 + '   <select style="width: 100%" name="TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\" id="TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\" obrigatorio=<cfoutput>#qrTagsOper.OBRIGATORIO#</cfoutput>  display="<cfoutput>#qrTags.DESCRICAO#</cfoutput>">  '
                                     + '  <option value="">----Selecione----</option>'										
										 +'			 	<cfloop query="qrListaValores"> '
										 +'                             <option value="#qrListaValores.valor#"   <cfif qrTags.valor eq qrListaValores.valor>selected</cfif> >#qrListaValores.descricao#</option>'
										 +'             </cfloop> '	 									 
										 +'         </td> '
										 +'      </tr> '
										 +'   <cfelse>'		
										 +'      <tr class="linha_2"> '
										 +'         <td align="center"> '
										 +'            <input type="hidden" name="TAG_OPERACAO_OBS_CONTRIB_ID" id="TAG_OPERACAO_OBS_CONTRIB_ID" value="<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" /> '
										 +'            <input type="hidden" name="TAG_CONHECIMENTO_OBS_CONTRIB_ID" id="CONHECIMENTO_OBS_CONTRIB_ID" value="<cfoutput>#qrTags.CONHECIMENTO_OBS_CONTRIB_ID#</cfoutput>" /> '
										 +'            <cfoutput>#qrTags.ORDEM#</cfoutput> '
										 +'         </td> '
									 +'         <td nowrap align="left"><nobr><cfoutput>#JSStringFormat(qrTags.DESCRICAO)#</cfoutput></td> '
										 +'         <td align="center"><cfoutput>#qrTags.OBRIGATORIO_STR#</cfoutput></td> '
										 +'         <td> '
									 +'			 	<textarea onkeydown="limitText(\'TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" onkeyup="limitText(\'TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" maxlenght="160" rows="2" cols="100" display="Valor, referente  observao <cfoutput>#JSStringFormat(qrTags.DESCRICAO)#</cfoutput>" obrigatorio=<cfoutput>#qrTags.OBRIGATORIO#</cfoutput> name="TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" id="TAG_VALOR_<cfoutput>#qrTags.OPERACAO_OBS_CONTRIB_ID#</cfoutput>"><cfoutput>#qrTags.VALOR#</cfoutput></textarea> '
										 +'         </td> '
										 +'      </tr> '
										 +'   </cfif>'	
										 +'   </cfloop> '
										 +'</table> ';
								</cfif>
								<cfif qrControleRecurso.RESULT eq 1>
									parent.f_muda_obs_contrib(tags_complemento); 
									parent.f_msg_obs_contrib("tags_complemento");
							    </cfif>	
								
						<cfelseif isdefined("qrTagsOper") and  qrTagsOper.recordCount gt 0>
						        <cfif IsDefined('vars.COMPLEMENTO') and vars.complemento eq 1>
									tags_complemento ='<table class="borda" border="0" cellspacing="1" cellpadding="3"> '
									 +'   <tr class="titulo_3"> '
									 +'      <td>Ordem</td> '
									 +'      <td>Descri&ccedil;&atilde;o</td> '
									 +'      <td>Obrigat&oacute;rio</td> '
									 +'      <td>Valor</td> '
									 +'   </tr> '
									 +'   <cfloop query="qrTagsOper"> '
									 +'	  <cfif qrTagsOper.tipo eq 'LISTA_VALORES' > ' 			
										 +'      <tr class="linha_2"> '
									 +'         <td align="center"> '
									 +'            <input type="hidden" name="TAG_OPERACAO_OBS_CONTRIB_ID" id="TAG_OPERACAO_OBS_CONTRIB_ID" value="<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" /> '
									 +'            <input type="hidden" name="TAG_CONHECIMENTO_OBS_CONTRIB_ID" id="CONHECIMENTO_OBS_CONTRIB_ID" /> '
									 +'            <cfoutput>#qrTagsOper.ORDEM#</cfoutput> '
									 +'         </td> '
									 +'         <td nowrap align="left"><nobr><cfoutput>#JSStringFormat(qrTagsOper.DESCRICAO)#</cfoutput></td> '
									 +'         <td align="center"><cfoutput>#qrTagsOper.OBRIGATORIO_STR#</cfoutput></td> '
									 +'         <td> '
									 + '<cfscript> connCte2 = CreateComponent("modulos.cte._componentes.consulta.cfc_cte"); qrListaValores = connCte2.get_tags_operacao_lista_valores(operacao_tag_lista_id = qrTagsOper.valor_padrao); </cfscript>'
									 + '   <select style="width: 100%" name="TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\" id="TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\" obrigatorio=<cfoutput>#qrTagsOper.OBRIGATORIO#</cfoutput>  display="<cfoutput>#qrTagsOper.DESCRICAO#</cfoutput>">  '
                                     +'  <option value="">----Selecione----</option>'
									 +'			 	<cfloop query="qrListaValores"> '
									 +'                             <option value="#qrListaValores.valor#"     >#qrListaValores.descricao#</option>'
									 +'             </cfloop> '									
									 +'         </td> '
									 +'      </tr> ' 
									 +'   <cfelse>'								 
									 +'      <tr class="linha_2"> '
									 +'         <td align="center"> '
									 +'            <input type="hidden" name="TAG_OPERACAO_OBS_CONTRIB_ID" id="TAG_OPERACAO_OBS_CONTRIB_ID" value="<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" /> '
									 +'            <input type="hidden" name="TAG_CONHECIMENTO_OBS_CONTRIB_ID" id="CONHECIMENTO_OBS_CONTRIB_ID" /> '
									 +'            <cfoutput>#qrTagsOper.ORDEM#</cfoutput> '
									 +'         </td> '
									 +'         <td nowrap align="left"><nobr><cfoutput>#JSStringFormat(qrTagsOper.DESCRICAO)#</cfoutput></td> '
									 +'         <td align="center"><cfoutput>#qrTagsOper.OBRIGATORIO_STR#</cfoutput></td> '
									 +'         <td> '
									 +'			 	<textarea onkeydown="limitText(\'TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" onkeyup="limitText(\'TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>\', 160)" maxlenght="160" rows="2" cols="100" display="Valor, referente  observao <cfoutput>#JSStringFormat(qrTagsOper.DESCRICAO)#</cfoutput>" obrigatorio=<cfoutput>#qrTagsOper.OBRIGATORIO#</cfoutput> name="TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>" id="TAG_VALOR_<cfoutput>#qrTagsOper.OPERACAO_OBS_CONTRIB_ID#</cfoutput>"><cfoutput>#qrTagsOper.VALOR_PADRAO#</cfoutput></textarea> '
									 +'         </td> '
									 +'      </tr> '
								     +'   </cfif>'		
									 +'   </cfloop> '
									 +'</table> ';
								</cfif>
								<cfif qrControleRecurso.RESULT eq 1>
									parent.f_muda_obs_contrib(tags_complemento); 
									parent.f_msg_obs_contrib("tags_complemento");
								</cfif>	
						<cfelse>
							<cfif qrControleRecurso.RESULT eq 1>
								parent.f_msg_obs_contrib("oper");
							</cfif>
					    </cfif>
							</cfoutput>
						
							if(parent.document.getElementById('tr_complemento_carregando')){
								parent.document.getElementById('tr_complemento_carregando').style.display = 'none';
							}
							if(parent.document.getElementById('tr_substituto_carregando')){
								parent.document.getElementById('tr_substituto_carregando').style.display = 'none';
							}
						}
					</script>

					<cfscript>
                        connS = CreateComponent("modulos.cte._componentes.consulta.logistica.cfc_solicitacao");
        
                        qrEndereco = connS.get_id_enderecos_solicitacao(num_romaneio = qrConhecimento.num_romaneio, viagem_carga_id = qrConhecimento.viagem_carga_id);
        
                        //Busca Endereos
                        if(Len(Trim(qrEndereco.endereco_remetente_id)) && Len(Trim(qrConhecimento.cod_remetente))){
                            varEndRem = '2';
                        }
                        else {
    					    varEndRem = '0';
						}

                        if(Len(Trim(qrEndereco.endereco_coleta_id)) && Len(Trim(qrConhecimento.cod_consignatario))){
                            varEndCol = '2';
                        }
                        else {
							varEndCol = '0';
						}
                        
                        if(Len(Trim(qrEndereco.endereco_destinatario_id)) && Len(Trim(qrConhecimento.cod_destinatario))){
                            varEndDest = '2';
                        }
                        else {
							varEndDest = '0';
						}

                        if(Len(Trim(qrEndereco.endereco_entrega_id)) && Len(Trim(qrConhecimento.cod_redespacho))){
                            varEndEnt = '2';
                        }
                        else {
							varEndEnt = '0';
						}

                        if(Len(Trim(qrEndereco.endereco_cobranca_id)) && Len(Trim(qrConhecimento.cod_cliente_cobranca))){
                            varEndCob = '2';
                        }
                        else {
                            varEndCob = '0';
                        }
                    </cfscript>	
					<!---Busca CTe multimodal vinculado a Solicitao de Carga--->
					<cfif qrConhecimento.EMITE_MULTIMODAL eq 1>
						<cfoutput query="qrSolicitacaoCteMultimodal">
							<script type="text/javascript">						
								with(parent.document.forms[0]) {
									parent.f_limpar_CTES_REF();
									parent.f_incluir_CTES_REF();											
									CTE_REF_CHAVE.value			       = '#JSStringFormat(qrSolicitacaoCteMultimodal.chave)#';
									CTE_REF_NUMERO.value		       = '#JSStringFormat(qrSolicitacaoCteMultimodal.numero)#';
									CTE_REF_SERIE.value		           = '#JSStringFormat(qrSolicitacaoCteMultimodal.serie)#';
									CTE_REF_SITUACAO.value	           = '#JSStringFormat(qrSolicitacaoCteMultimodal.situacao)#';
									CTE_REF_DATA_EMISSAO.value         = '#JSStringFormat(qrSolicitacaoCteMultimodal.data_emissao)#';
									CTE_REF_EMIT_CNPJ_CPF.value	       = '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_cnpj_cpf)#';
									CTE_REF_EMIT_RAZAO.value	       = '#JSStringFormat(qrSolicitacaoCteMultimodal.emit_razao)#';
									CTE_REF_REM_CNPJ_CPF.value	       = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_cnpj_cpf)#';
									CTE_REF_REM_IE.value	           = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_ie)#';
									CTE_REF_REM_RAZAO.value	           = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_razao)#';
									CTE_REF_REM_ENDERECO.value         = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco)#';
									CTE_REF_REM_ENDERECO_NRO.value	   = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_nro)#';
									CTE_REF_REM_ENDERECO_BAIRRO.value  = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_bairro)#';
									CTE_REF_REM_ENDERECO_CMUN.value    = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_cmun)#';
									CTE_REF_REM_ENDERECO_XMUN.value    = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_xmun)#';
									CTE_REF_REM_ENDERECO_CEP.value     = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_cep)#';
									CTE_REF_REM_ENDERECO_UF.value      = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_uf)#';
									CTE_REF_REM_ENDERECO_PAIS.value    = '#JSStringFormat(qrSolicitacaoCteMultimodal.rem_endereco_pais)#';
									CTE_REF_DEST_CNPJ_CPF.value	       = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_cnpj_cpf)#';
									CTE_REF_DEST_IE.value	           = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_ie)#';
									CTE_REF_DEST_RAZAO.value	       = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_razao)#';
									CTE_REF_DEST_ENDERECO.value        = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco)#';
									CTE_REF_DEST_ENDERECO_NRO.value	   = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_nro)#';
									CTE_REF_DEST_ENDERECO_BAIRRO.value = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_bairro)#';
									CTE_REF_DEST_ENDERECO_CMUN.value   = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_cmun)#';
									CTE_REF_DEST_ENDERECO_XMUN.value   = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_xmun)#';
									CTE_REF_DEST_ENDERECO_CEP.value    = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_cep)#';
									CTE_REF_DEST_ENDERECO_UF.value     = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_uf)#';
									CTE_REF_DEST_ENDERECO_PAIS.value   = '#JSStringFormat(qrSolicitacaoCteMultimodal.dest_endereco_pais)#';
									CTE_REF_PESO_MULTIMODAL.value      = '#JSStringFormat(qrSolicitacaoCteMultimodal.peso_multimodal)#';
									CTE_REF_PERCENTUAL_TOLERANCIA.value = '#JSStringFormat(qrSolicitacaoCteMultimodal.percentual_tolerancia)#';
									CTE_REF_VALOR_TOLERANCIA.value      = '#JSStringFormat(qrSolicitacaoCteMultimodal.valor_tolerancia)#';
									CTE_REF_PESO_CTES_VINCULADOS.value  = '#JSStringFormat(qrSolicitacaoCteMultimodal.peso_ctes_vinculados)#';
									CTE_REF_PESO_RESTANTE.value         = '#JSStringFormat(qrSolicitacaoCteMultimodal.peso_restante)#';
									CTE_REF_PESO_RESTANTE_TOLERANCIA.value = '#JSStringFormat(qrSolicitacaoCteMultimodal.peso_restante_tolerancia)#';
									CTE_REF_PESO_REAL.value             = '#JSStringFormat(qrSolicitacaoCteMultimodal.peso_real)#';
									parent.f_salvar_CTES_REF();	
									parent.f_atualiza_peso_cte_ref();
								}
							</script>
						</cfoutput>
					</cfif>	
					<cfif vars.SUBSTITUTO neq 2>
						<script type="text/javascript">						
                            if(<cfoutput>#varEndRem#</cfoutput> == 2){
                                parent.document.getElementById('REM_ENDERECO_SOLICITACAO').value = '<cfoutput>#qrEndereco.endereco_remetente_id#</cfoutput>';
                                parent.document.getElementById('REM_LBL_AVISO').style.display = '';
                                parent.document.getElementById('REM_CB_ENDERECO').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LOCALIZAR_REM').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LIMPAR_REM').setAttribute("disabled", "disabled");
                                parent.document.getElementById('REM_CNPJ_CPF').setAttribute("disabled", "disabled");
                            } else if (<cfoutput>#varEndRem#</cfoutput> == 1) {
                                parent.document.getElementById('BTN_LOCALIZAR_REM').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LIMPAR_REM').setAttribute("disabled", "disabled");
                                parent.document.getElementById('REM_CNPJ_CPF').setAttribute("disabled", "disabled");
                            } else{
                                parent.document.getElementById('REM_ENDERECO_SOLICITACAO').value = 0;
                                parent.document.getElementById('REM_LBL_AVISO').style.display = 'none';
                                parent.document.getElementById('REM_CB_ENDERECO').removeAttribute("disabled");
                                parent.document.getElementById('BTN_LOCALIZAR_REM').removeAttribute("disabled");
                                parent.document.getElementById('BTN_LIMPAR_REM').removeAttribute("disabled");
                                parent.document.getElementById('REM_CNPJ_CPF').removeAttribute("disabled");
                            }
    
                            if(<cfoutput>#varEndDest#</cfoutput> == 2){
                                parent.document.getElementById('DEST_ENDERECO_SOLICITACAO').value = '<cfoutput>#qrEndereco.endereco_destinatario_id#</cfoutput>';
                                parent.document.getElementById('DEST_LBL_AVISO').style.display = '';
                                parent.document.getElementById('DEST_CB_ENDERECO').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LOCALIZAR_DEST').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LIMPAR_DEST').setAttribute("disabled", "disabled");
                                parent.document.getElementById('DEST_CNPJ_CPF').setAttribute("disabled", "disabled");
                            } else if (<cfoutput>#varEndDest#</cfoutput> == 1) {
                                parent.document.getElementById('BTN_LOCALIZAR_DEST').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LIMPAR_DEST').setAttribute("disabled", "disabled");
                                parent.document.getElementById('DEST_CNPJ_CPF').setAttribute("disabled", "disabled");
                            } else{
                                parent.document.getElementById('DEST_ENDERECO_SOLICITACAO').value = 0;
                                parent.document.getElementById('DEST_LBL_AVISO').style.display = 'none';
                                parent.document.getElementById('DEST_CB_ENDERECO').removeAttribute("disabled");
                                parent.document.getElementById('BTN_LOCALIZAR_DEST').removeAttribute("disabled");
                                parent.document.getElementById('BTN_LIMPAR_DEST').removeAttribute("disabled");
                                parent.document.getElementById('DEST_CNPJ_CPF').removeAttribute("disabled");
                            }
    
                            if(<cfoutput>#varEndCol#</cfoutput> == 2){
                                parent.document.getElementById('COLETA_ENDERECO_SOLICITACAO').value = '<cfoutput>#qrEndereco.endereco_coleta_id#</cfoutput>';
                                parent.document.getElementById('COLETA_LBL_AVISO').style.display = '';
                                parent.document.getElementById('COLETA_CB_ENDERECO').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LOCALIZAR_COLETA').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LIMPAR_COLETA').setAttribute("disabled", "disabled");
                                parent.document.getElementById('COLETA_CNPJ_CPF').setAttribute("disabled", "disabled");
                            } else if (<cfoutput>#varEndCol#</cfoutput> == 1) {
                                parent.document.getElementById('BTN_LOCALIZAR_COLETA').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LIMPAR_COLETA').setAttribute("disabled", "disabled");
                                parent.document.getElementById('COLETA_CNPJ_CPF').setAttribute("disabled", "disabled");
                            } else{
                                parent.document.getElementById('COLETA_ENDERECO_SOLICITACAO').value = 0;
                                parent.document.getElementById('COLETA_LBL_AVISO').style.display = 'none';
                                parent.document.getElementById('COLETA_CB_ENDERECO').removeAttribute("disabled");
                                parent.document.getElementById('BTN_LOCALIZAR_COLETA').removeAttribute("disabled");
                                parent.document.getElementById('BTN_LIMPAR_COLETA').removeAttribute("disabled");
                                parent.document.getElementById('COLETA_CNPJ_CPF').removeAttribute("disabled");
                            }
                            if(<cfoutput>#varEndEnt#</cfoutput> == 2){
                                parent.document.getElementById('RED_ENDERECO_SOLICITACAO').value = '<cfoutput>#qrEndereco.endereco_entrega_id#</cfoutput>';
                                parent.document.getElementById('RED_LBL_AVISO').style.display = '';
                                parent.document.getElementById('RED_CB_ENDERECO').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LOCALIZAR_RED').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LIMPAR_RED').setAttribute("disabled", "disabled");
                                parent.document.getElementById('RED_CNPJ_CPF').setAttribute("disabled", "disabled");
                            } else if (<cfoutput>#varEndEnt#</cfoutput> == 1) {
                                parent.document.getElementById('BTN_LOCALIZAR_RED').setAttribute("disabled", "disabled");
                                parent.document.getElementById('BTN_LIMPAR_RED').setAttribute("disabled", "disabled");
                                parent.document.getElementById('RED_CNPJ_CPF').setAttribute("disabled", "disabled");
                            } else{
                                parent.document.getElementById('RED_ENDERECO_SOLICITACAO').value = 0;
                                parent.document.getElementById('RED_LBL_AVISO').style.display = 'none';
                                parent.document.getElementById('RED_CB_ENDERECO').removeAttribute("disabled");
                                parent.document.getElementById('BTN_LOCALIZAR_RED').removeAttribute("disabled");
                                parent.document.getElementById('BTN_LIMPAR_RED').removeAttribute("disabled");
                                parent.document.getElementById('RED_CNPJ_CPF').removeAttribute("disabled");
                            }
							if(<cfoutput>#varEndCob#</cfoutput> == 2){
								parent.document.getElementById('COB_ENDERECO_SOLICITACAO').value = '<cfoutput>#qrEndereco.endereco_cobranca_id#</cfoutput>';
								parent.document.getElementById('COB_LBL_AVISO').style.display = '';
								parent.document.getElementById('COB_CB_ENDERECO').setAttribute("disabled", "disabled");
								parent.document.getElementById('BTN_LOCALIZAR_COB').setAttribute("disabled", "disabled");
								parent.document.getElementById('BTN_LIMPAR_COB').setAttribute("disabled", "disabled");
								parent.document.getElementById('COB_CNPJ_CPF').setAttribute("disabled", "disabled");
							} else if (<cfoutput>#varEndCob#</cfoutput> == 1) {
								parent.document.getElementById('BTN_LOCALIZAR_COB').setAttribute("disabled", "disabled");
								parent.document.getElementById('BTN_LIMPAR_COB').setAttribute("disabled", "disabled");
								parent.document.getElementById('COB_CNPJ_CPF').setAttribute("disabled", "disabled");
							} else{
								parent.document.getElementById('COB_ENDERECO_SOLICITACAO').value = 0;
								parent.document.getElementById('COB_LBL_AVISO').style.display = 'none';
								parent.document.getElementById('COB_CB_ENDERECO').removeAttribute("disabled");
								parent.document.getElementById('BTN_LOCALIZAR_COB').removeAttribute("disabled");
								parent.document.getElementById('BTN_LIMPAR_COB').removeAttribute("disabled");
								parent.document.getElementById('COB_CNPJ_CPF').removeAttribute("disabled");
							}
                        </script>
                    </cfif>

					<!--- Busca documentos anteriores	--->
					<cfif qrConhecimentoDocAnteriores.recordcount gte 1 and vars.COMPLEMENTO neq 1>
						<script type="text/javascript">						
							with(parent.document.forms[0]) {
								parent.f_limpar_DOCSANT();
							}
						</script>

						<cfoutput query="qrConhecimentoDocAnteriores">
							<script type="text/javascript">						
								with(parent.document.forms[0]) {
									parent.f_incluir_DOCSANT();
									//CTE_DOCTO_ANTERIOR_ID.value = '#JSStringFormat(qrConhecimentoDocAnteriores.CTE_DOCTO_ANTERIOR_ID)#';
									
									DOC_COD_EMISSOR.value		= '#JSStringFormat(qrConhecimentoDocAnteriores.COD_EMISSOR)#';
									DOC_CNPJ_EMISSOR.value		= '#JSStringFormat(qrConhecimentoDocAnteriores.EMISSOR_IDENTIFICADOR)#';
									DOC_EMITENTE.value		    = '#JSStringFormat(qrConhecimentoDocAnteriores.EMISSOR_DESCRICAO)#';
									CHAVECTE.value		        = '#JSStringFormat(qrConhecimentoDocAnteriores.CHAVE)#';
									ELETRONICO_PAPEL.value      = '#JSStringFormat(qrConhecimentoDocAnteriores.ELETRONICO_PAPEL)#';
									parent.f_salvar_DOCSANT();	
								}
							</script>
						</cfoutput>
					</cfif>	

					<!--- Busca vale pedgio --->
					<cfif qrConhecimentoValePedagio.recordcount gte 1 >
						<script type="text/javascript">						
							with(parent.document.forms[0]) {
								parent.f_limpar_VALE_PEDAGIO();
							}
						</script>

						<cfoutput query="qrConhecimentoValePedagio">
							<script type="text/javascript">						
							  parent.document.getElementById('MENSAGEM_RETORNO_VALE_PEDAGIO').innerHTML = 'Vale pedgio j emitido para o romaneio n #JSStringFormat(qrConhecimento.num_romaneio)#.'; 
							  parent.document.getElementById('MENSAGEM_RETORNO_VALE_PEDAGIO').style.color = 'blue';

							  with(parent.document.forms[0]) {							  
								 UTILIZA_VALE_PEDAGIO.value = 1;
								 UTILIZA_VALE_PEDAGIO.onchange();
								 //parent.f_desabilita_pedagio_check(true);
								 //parent.f_bloquear_valeped_operadora(true, 1, 1, 1, 1);
								 parent.v_inserida = 1;
								 CNPJ_FORNECEDORA.readOnly 		= false;
								 COD_PESSOA_FORNECEDORA.readOnly 	= false;							  

								 parent.f_incluir_VALE_PEDAGIO();
								 NUM_COMPROVANTE.value = '#qrConhecimentoValePedagio.NUM_COMPROVANTE#';
								 VALOR_COMPROVANTE.value = '#qrConhecimentoValePedagio.VALOR#';
								 CNPJ_FORNECEDORA.value = '#qrConhecimentoValePedagio.cnpj_cpf_fornecedora#';
								 COD_PESSOA_FORNECEDORA.value  = '#qrConhecimentoValePedagio.cod_pessoa_fornecedora#';
								 FORNECEDORA_RAZAO_SOCIAL.value = '#JSStringFormat(qrConhecimentoValePedagio.fornecedora)#';
								 CNPJ_OPERADORA.value			= '#JSStringFormat(qrConhecimentoValePedagio.cnpj_cpf_operadora)#';
								 OPERADORA_RAZAO_SOCIAL.value	= '#JSStringFormat(qrConhecimentoValePedagio.operadora)#';
								 COD_PESSOA_OPERADORA.value	    = '#JSStringFormat(qrConhecimentoValePedagio.cod_pessoa_operadora)#';
								 parent.f_salvar_VALE_PEDAGIO();
								 parent.v_inserida = 0;
							  }
							</script>
						</cfoutput>
					</cfif>	

            <cfcatch>
				<script type="text/javascript">
                    if(parent.document.getElementById('tr_complemento_carregando')){
						parent.document.getElementById('tr_complemento_carregando').style.display = 'none';
					}
					if(parent.document.getElementById('tr_substituto_carregando')){
						parent.document.getElementById('tr_substituto_carregando').style.display = 'none';
					}
                </script>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
            </cftry>

            <cfscript>
                fnc_trata_erros(struct_erro = retorno, mostra_msg_ok  = false);
            </cfscript>

        </cfcase>
        
        <cfcase value="6">
        	<cfset v_retorno = structnew()>
        	<cftry>
				<cfscript>
                    conn_cons_tf = CreateComponent("modulos.cte._componentes.consulta.comercial.cfc_tabela_frete");
                    conn_global  = CreateComponent("modulos.cte._componentes.consulta.cfc_global");				
					
					v_param_tolerancia = conn_global.get_parametro_valor_numerico('M309-P0150');
					
					if(IsDefined('vars.PLACA_REFERENCIA_INTERNA')) {
						v_placa_referencia_interna = Replace(vars.PLACA_REFERENCIA_INTERNA, ',', ' > ', 'all');
					}
					else {
						v_placa_referencia_interna = '';
					}
				
					v_tipo_servico_cte_tipo = '';
					if (IsDefined('vars.CONHECIMENTO_TIPO_ID') && len(trim(vars.CONHECIMENTO_TIPO_ID))) {
						connCteTipo = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
						qrConhecimentoTipo = connCteTipo.get_conhecimento_tipo(conhecimento_tipo_id = vars.CONHECIMENTO_TIPO_ID);
						v_tipo_servico_cte_tipo = qrConhecimentoTipo.tipo_servico_id;
						
						if (v_tipo_servico_cte_tipo == '0') {
							v_tipo_servico_cte_tipo = '';
						}
					}
					
					v_tipo_servico_operacao = '';
					if(len(trim(vars.OPERACAO_ID_CTRC))){
							connO = CreateComponent("modulos.cte._componentes.consulta.logistica.cfc_operacao");
							qrOperacao= connO.get_operacao(operacao_id = vars.OPERACAO_ID_CTRC);
						v_tipo_servico_operacao = qrOperacao.TIPO_SERVICO_ID;

						if (v_tipo_servico_cte_tipo == '') {
							vars.TIPO_SERVICO_COMERCIAL = qrOperacao.TIPO_SERVICO_ID;
						}else{
							vars.TIPO_SERVICO_COMERCIAL =  v_tipo_servico_cte_tipo;
						}
					}else{
						vars.TIPO_SERVICO_COMERCIAL =  v_tipo_servico_cte_tipo;
					}
					
					vars.ST_ICMS_ID = '';
					
					if(IsDefined('vars.conhecimento_tipo_id')) {
						v_conhecimento_tipo_id = vars.conhecimento_tipo_id;
					}
					else {
						v_conhecimento_tipo_id = '';
					}
					
                    qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id(ORIGEM_MUNICIPIO_ID  = vars.COLETA_MUNICIPIO_ID,
																				DESTINO_MUNICIPIO_ID = iif(vars.FRETE_ULT_ENTREGA eq 0, de(vars.RED_MUNICIPIO_ID), de(vars.MUNICIPIO_ULT_ENTREGA_ID)),
																				COD_NEGOCIADOR       = vars.COD_NEGOCIADOR,
																				NUM_NATUREZA		 = vars.NUM_NATUREZA,
																				COMPOSICAO			 = vars.PLACA_CONTROLE & ' > ' & v_placa_referencia_interna,
																				TIPO_SERVICO_ID		 = vars.tipo_servico_comercial,
																				SOLICITACAO_CARGA_ID = vars.SOLICITACAO_CARGA_ID,
																				CONHECIMENTO_TIPO_ID = v_conhecimento_tipo_id
																				);
                </cfscript>
                <script>
					parent.document.form_transportes.TIPO_SERVICO_COMERCIAL.value = '<cfoutput>#vars.TIPO_SERVICO_COMERCIAL#</cfoutput>';
				</script>
				<cfif qrTabelaFreteRotaId.erro>    
                    <cfif isDefined('qrTabelaFreteRotaId.mensagem.NativeErrorCode') and qrTabelaFreteRotaId.mensagem.NativeErrorCode eq 20666 
					      and vars.TIPO_SERVICO_COMERCIAL neq v_tipo_servico_operacao and v_tipo_servico_operacao neq '' >
						<cfscript>
							vars.TIPO_SERVICO_COMERCIAL = v_tipo_servico_operacao;
							
                            qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id(ORIGEM_MUNICIPIO_ID  = vars.COLETA_MUNICIPIO_ID,
                                                                                        DESTINO_MUNICIPIO_ID = iif(vars.FRETE_ULT_ENTREGA eq 0, de(vars.RED_MUNICIPIO_ID), de(vars.MUNICIPIO_ULT_ENTREGA_ID)),
                                                                                        COD_NEGOCIADOR       = vars.COD_NEGOCIADOR,
                                                                                        NUM_NATUREZA		 = vars.NUM_NATUREZA,
                                                                                        COMPOSICAO			 = vars.PLACA_CONTROLE & ' > ' & v_placa_referencia_interna,
                                                                                        TIPO_SERVICO_ID		 = vars.tipo_servico_comercial,
																						SOLICITACAO_CARGA_ID = vars.SOLICITACAO_CARGA_ID,
																						CONHECIMENTO_TIPO_ID = v_conhecimento_tipo_id
                                                                                        );                
                        </cfscript>
                        <script>
                            parent.document.form_transportes.TIPO_SERVICO_COMERCIAL.value = '<cfoutput>#vars.TIPO_SERVICO_COMERCIAL#</cfoutput>';
                        </script>
                        <cfif qrTabelaFreteRotaId.erro>                   
                            <cfthrow object="#qrTabelaFreteRotaId.mensagem#">
                        </cfif>
                    <cfelse>
	   				    <cfthrow object="#qrTabelaFreteRotaId.mensagem#">
                    </cfif>
                </cfif>
                                   
                <cfscript>
					conn_cons_doc = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
					qrDadosFiscais = conn_cons_doc.get_ctrc_dados_fiscais(NUM_ROMANEIO		   = vars.NUM_ROMANEIO,
																		  ITEM_ID 			   = vars.ITEM_ID,
																		  COD_DESTINATARIO 	   = vars.COD_DESTINATARIO,
																		  PRODUTO_ID  		   = vars.NUM_PRODUTO,
																		  PAGO_POR 			   = vars.PAGADOR,
																		  COLETA_UF 		   = vars.COLETA_UF,
																		  ENTREGA_UF 		   = vars.RED_UF,
																		  ST_ICMS_ID 		   = vars.ST_ICMS_ID,
																		  COD_REMETENTE 	   = vars.COD_REMETENTE,
																		  REGRA_FISCAL_ID 	   = vars.REGRA_FISCAL,
																		  COB_UF 			   = vars.COB_UF,
																		  COLETA_MUNICIPIO_ID  = vars.COLETA_MUNICIPIO_ID,
																		  ENTREGA_MUNICIPIO_ID = iif(vars.FRETE_ULT_ENTREGA eq 0, de(vars.RED_MUNICIPIO_ID), de(vars.MUNICIPIO_ULT_ENTREGA_ID)),
																		  VIAGEM_CARGA_ID 	   = vars.VIAGEM_CARGA_ID,
																		  COD_CLIENTE_COBRANCA = vars.COD_CLIENTE_COBRANCA,
																		  UF_FILIAL 		   = vars.UF_FILIAL_EMISSAO,
																		  NOTA_FISCAL 		   = 0,
																		  COD_ATIVIDADE_TOMA   = vars.COB_COD_ATIVIDADE_FISCAL,
																		  COD_NEGOCIADOR       = vars.COD_NEGOCIADOR,
                                                                          TIPO_DOCUMENTO_ID    = vars.TIPO_DOCUMENTO_ID);
				</cfscript>
                
                <cfif qrDadosFiscais.erro>
                    <cfthrow object="#qrDadosFiscais.mensagem#">
                </cfif>
                <cfscript>
					conn_cons_vei = CreateComponent("modulos.cte._componentes.consulta.cfc_veiculo");
					qrNumeroEixos = conn_cons_vei.get_numero_eixos_composicao(PLACA = vars.PLACA_CONTROLE & ' > ' & v_placa_referencia_interna);
				</cfscript>
                <cfif qrNumeroEixos.erro>
                    <cfthrow object="#qrNumeroEixos.mensagem#">
                </cfif>
                
                <cfscript>
                    if ((isdefined("vars.COD_PESSOA_FILIAL") and len(trim(vars.COD_PESSOA_FILIAL)) > 0) or (isdefined("vars.COD_PESSOA_FILIAL_AUX") and len(trim(vars.COD_PESSOA_FILIAL_AUX)) > 0)) {
                        conn_pessoa = CreateComponent("modulos.cte._componentes.consulta.cfc_pessoa");
						if (isdefined("vars.COD_PESSOA_FILIAL")) {
                        	qrPessoa = conn_pessoa.get_pessoa_cnpj(COD_PESSOA = vars.COD_PESSOA_FILIAL);
						} else {
							qrPessoa = conn_pessoa.get_pessoa_cnpj(COD_PESSOA = vars.COD_PESSOA_FILIAL_AUX);
						}
                        v_pessoa_emitente = qrPessoa.CNPJ_CPF;
                    }
                </cfscript>
                
                <cfif (not isdefined("v_pessoa_emitente"))>
                	<cfthrow message="Organograma do CT-e no definido.">
                </cfif>
                <cfscript>
					qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID
																		 , tabela_frete_id 		= qrTabelaFreteRotaId.TABELA_FRETE_ID);
                	
					vars.TABELA_FRETE_ID	  = qrTabelaFreteRota.TABELA_FRETE_ID;
					vars.TABELA_FRETE_ROTA_ID = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID;
					vars.TABELA_FRETE_VIGENCIA_ID = qrTabelaFreteRota.TABELA_FRETE_VIGENCIA_ID;
					vars.DOCUMENTO_ID		      = 1; // Conhecimento de Transporte Rodovirio de Cargas

					vars.PRODUTO_ID = vars.NUM_PRODUTO;
					if (vars.TABELA_FRETE_MODELO_ID == 1) {
					    vars.PRODUTO_ID 		  = qrDadosFiscais.PRODUTO_ID;

						if(IsDefined('vars.VAR_ST_ICMS_ID')) {
							v_st_icms_id = vars.VAR_ST_ICMS_ID;
						}
						else {
							v_st_icms_id = Trim(qrDadosFiscais.ST_ICMS_ID);
						}
						vars.CONSTANTE_ST_ICMS_ID 	= v_st_icms_id;
					}
					
					// Constantes
					vars.CONSTANTE_VIAGEM_CARGA_ID		 	= vars.VIAGEM_CARGA_ID;
					vars.CONSTANTE_SOLICITACAO_CARGA_ID		= vars.SOLICITACAO_CARGA_ID;
					vars.CONSTANTE_NUM_ROMANEIO		 	    = vars.NUM_ROMANEIO;
					vars.CONSTANTE_PESO_BRUTO            	= vars.PESO_KG;
					vars.CONSTANTE_PESO_COBRADO          	= vars.PESO;
					vars.CONSTANTE_VALOR_MERCADORIA      	= vars.VALOR_MERCADORIA;
					vars.CONSTANTE_NRO_VOLUMES			 	= vars.VOLUME;
					vars.CONSTANTE_MUNICIPIO_ID_ORIGEM   	= vars.COLETA_MUNICIPIO_ID;
					vars.CONSTANTE_MUNICIPIO_ID_DESTINO  	= iif(vars.FRETE_ULT_ENTREGA eq 0, de(vars.RED_MUNICIPIO_ID), de(vars.MUNICIPIO_ULT_ENTREGA_ID));
					vars.CONSTANTE_FRETE_PROPRIO		 	= qrDadosFiscais.FRETE_PROPRIO;
					vars.CONSTANTE_UF_TOMADOR			 	= qrDadosFiscais.TOMADOR_UF;
					vars.CONSTANTE_UF_EMITENTE           	= vars.UF_FILIAL_EMISSAO;
					vars.CONSTANTE_COD_ATIVIDADE_TOMADOR    = qrDadosFiscais.COD_ATIVIDADE_TOMADOR;
					vars.CONSTANTE_PRODUTO_ID			    = vars.PRODUTO_ID;
					vars.CONSTANTE_TABELA_FRETE_MODELO_ID   = vars.TABELA_FRETE_MODELO_ID;
					vars.CONSTANTE_M3 					    = vars.M3;
					vars.CONSTANTE_CUBAGEM				    = vars.CUBAGEM;
					vars.CONSTANTE_MERCADORIA_TRANSPORTADA  = vars.MERCADORIA_TRANSPORTADA;
					vars.CONSTANTE_CFOP_TRANSPORTADO 		= vars.CFOP_TRANSPORTADO;
					vars.CONSTANTE_NFE_ICMS_PARTILHADO      = vars.NFE_ICMS_PARTILHADO;
					
					// Definio do tipo de CT-e
					if (IsDefined('vars.COMPLEMENTO') and vars.COMPLEMENTO == 1) {
						vars.CONSTANTE_TIPO_CTE = 1;
					} else if (vars.SUBSTITUTO == 1) {
						vars.CONSTANTE_TIPO_CTE = 3;
					} else {
						vars.CONSTANTE_TIPO_CTE = 0;
					}
					
					// Pega o valor do tipo de documento vinculado
					v_documento_tipo = '';
					if (IsDefined('vars.TIPO_DOCUMENTO_ID')) {
						v_documento_tipo = vars.TIPO_DOCUMENTO_ID;
					} else {
						v_documento_tipo = vars.TIPO_DOCTO_FRETE;
					}
					// Define se  nta fiscal ou outros (Outos = 1 e NF = 0)
					if (v_documento_tipo == 2) {
						vars.CONSTANTE_DOCUMENTO_VINCULADO = 1;
					} else {
						vars.CONSTANTE_DOCUMENTO_VINCULADO = 0;
					}
					
					vars.CONSTANTE_PLACA_TRACAO	= vars.PLACA_CONTROLE;
					
					if(v_placa_referencia_interna eq '') {
						vars.CONSTANTE_PLACA_CARRETA = '';
					}
					else {
						vars.CONSTANTE_PLACA_CARRETA = ListGetAt(v_placa_referencia_interna, 1, ' > ');
					}
					vars.CONSTANTE_NRO_EIXOS 		 = qrNumeroEixos.EIXOS;
					vars.CONSTANTE_CNPJ_REMETENTE 	 = vars.REM_CNPJ_CPF;
					vars.CONSTANTE_CNPJ_DESTINATARIO = vars.DEST_CNPJ_CPF;
					vars.CONSTANTE_CNPJ_COLETA 		 = vars.COLETA_CNPJ_CPF;
					vars.CONSTANTE_CNPJ_ENTREGA 	 = vars.RED_CNPJ_CPF;
					vars.CONSTANTE_CNPJ_EMITENTE 	 = v_pessoa_emitente;
					vars.CONSTANTE_CNPJ_TOMADOR 	 = vars.COB_CNPJ_CPF;
					vars.CONSTANTE_VALIDA_IMPOSTO    = 0;
					vars.CONSTANTE_DATA_EMISSAO		= vars.DATA_EMISSAO;
					vars.CONSTANTE_NFE_ICMS_PARTILHADO      = vars.NFE_ICMS_PARTILHADO;					
					vars.CONSTANTE_COD_ENDERECO_DESTINATARIO = vars.DEST_COD_ENDERECO;
					vars.CONSTANTE_COD_ENDERECO_ENTREGA		= vars.RED_COD_ENDERECO;
					vars.CONSTANTE_COD_ENDERECO_COLETA		= vars.COLETA_COD_ENDERECO;
					vars.CONSTANTE_COD_ENDERECO_TOMADOR		= vars.COB_COD_ENDERECO;
					vars.CONSTANTE_COD_MODELO				= '57';
					
					if (IsDefined('vars.CONHECIMENTO_ID_CONSULTA')){
					   vars.CONSTANTE_CONHECIMENTO_ID_ORIGINAL	= vars.CONHECIMENTO_ID_CONSULTA;
					}
					// ----------
					qrCalculo = conn_cons_tf.calculo_tabela_frete(argumentCollection = vars);
				</cfscript>
                                
                <cfif qrCalculo.erro>
                    <cfthrow object="#qrCalculo.mensagem#">
                </cfif>
                <cfoutput query="qrCalculo.query">
	                <cfif qrCalculo.query.COD_VARIAVEL eq 'CFOP'>
                    	<cfscript>
							conn = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");						
							qrCfop = conn.get_cfop(cfop = qrCalculo.query.VALOR);						
						</cfscript>
                        <cfif qrCfop.recordcount eq 0>
	                        <cfthrow message="CFOP #qrCalculo.query.VALOR# no cadastrado.">
                        </cfif>
    	            </cfif>
                </cfoutput>
					
                <script type="text/javascript">
					with(parent.document.forms[0]) {
						
						<cfoutput>
						<cfif vars.TABELA_FRETE_MODELO_ID eq 1>
						
							NUM_PRODUTO.value = '#JSStringFormat(qrDadosFiscais.PRODUTO_ID)#';
							
							<cfif not IsDefined('vars.VAR_ST_ICMS_ID')>
								<cfif IsDefined('vars.TIPO_COMPLEMENTO_ID') and vars.TIPO_COMPLEMENTO_ID neq 1 and vars.TIPO_COMPLEMENTO_ID neq 3>
									ST_ICMS_ID.value       = '#JSStringFormat(Trim(qrCalculo.st_icms_id))#';
									ST_ICMS_ID_COMBO.value = '#JSStringFormat(Trim(qrCalculo.st_icms_id))#';
								<cfelseif not IsDefined('vars.TIPO_COMPLEMENTO_ID')>
									ST_ICMS_ID.value          = '#JSStringFormat(Trim(qrCalculo.st_icms_id))#';
									ST_ICMS_ID_COMBO.value    = '#JSStringFormat(Trim(qrCalculo.st_icms_id))#';
									ST_ICMS_ID_COMBO.disabled = true;
									ST_ICMS_ID_COMBO.onchange = function() {};
								</cfif>
								
								parent.v_st_icms_id_calculada = '#JSStringFormat(Trim(qrCalculo.st_icms_id))#';
								<cfset vars.ST_ICMS_ID = qrCalculo.st_icms_id>
							<cfelse>
								ST_ICMS_ID.value       	      = '#JSStringFormat(vars.VAR_ST_ICMS_ID)#';
								ST_ICMS_ID_COMBO.value 		  = '#JSStringFormat(vars.VAR_ST_ICMS_ID)#';
								parent.v_st_icms_id_calculada = '#JSStringFormat(vars.VAR_ST_ICMS_ID)#';
								<cfset vars.ST_ICMS_ID = vars.VAR_ST_ICMS_ID>
							</cfif>
						</cfif>
						</cfoutput>
					}
				</script>
                
				<cfscript>
                    qrDadosFiscais = conn_cons_doc.get_ctrc_dados_fiscais(NUM_ROMANEIO		   = vars.NUM_ROMANEIO,
                                                                          ITEM_ID 			   = vars.ITEM_ID,
                                                                          COD_DESTINATARIO 	   = vars.COD_DESTINATARIO,
                                                                          PRODUTO_ID  		   = vars.NUM_PRODUTO,
                                                                          PAGO_POR 			   = vars.PAGADOR,
                                                                          COLETA_UF 		   = vars.COLETA_UF,
                                                                          ENTREGA_UF 		   = vars.RED_UF,
                                                                          ST_ICMS_ID 		   = vars.ST_ICMS_ID,
                                                                          COD_REMETENTE 	   = vars.COD_REMETENTE,
                                                                          REGRA_FISCAL_ID 	   = vars.REGRA_FISCAL,
                                                                          COB_UF 			   = vars.COB_UF,
                                                                          COLETA_MUNICIPIO_ID  = vars.COLETA_MUNICIPIO_ID,
                                                                          ENTREGA_MUNICIPIO_ID = iif(vars.FRETE_ULT_ENTREGA eq 0, de(vars.RED_MUNICIPIO_ID), de(vars.MUNICIPIO_ULT_ENTREGA_ID)),
                                                                          VIAGEM_CARGA_ID 	   = vars.VIAGEM_CARGA_ID,
                                                                          COD_CLIENTE_COBRANCA = vars.COD_CLIENTE_COBRANCA,
                                                                          UF_FILIAL 		   = vars.UF_FILIAL_EMISSAO,
                                                                          NOTA_FISCAL 		   = 0,
                                                                          COD_ATIVIDADE_TOMA   = vars.COB_COD_ATIVIDADE_FISCAL,
                                                                          COD_NEGOCIADOR       = vars.COD_NEGOCIADOR,
                                                                          TIPO_DOCUMENTO_ID    = vars.TIPO_DOCUMENTO_ID);
                </cfscript>
                <cfif qrDadosFiscais.erro>
                    <cfthrow object="#qrDadosFiscais.mensagem#">
                </cfif>
                
                <script type="text/javascript">
                	with(parent.document.forms[0]) {
						<cfoutput>
						<cfif vars.TABELA_FRETE_MODELO_ID eq 1>
							CFOP.value 				= '#JSStringFormat(qrDadosFiscais.CFOP)#';
							CFOP_ID.value 			= '#JSStringFormat(qrDadosFiscais.CFOP_ID)#';
							NATUREZA_OPERACAO.value = '#JSStringFormat(qrDadosFiscais.NATUREZA_OPERACAO)#';
							
							<cfif not (IsDefined('vars.COMPLEMENTO') and vars.complemento eq 1)>
								FUNDAMENTACAO_LEGAL.value = '#JSStringFormat(qrDadosFiscais.FUNDAMENTACAO_LEGAL)#';
							<cfelse>
								<cfif vars.TIPO_COMPLEMENTO_ID eq 2>
									FUNDAMENTACAO_LEGAL.value = '#JSStringFormat(qrDadosFiscais.FUNDAMENTACAO_LEGAL)#';
								</cfif>
							</cfif>
							
							
							if(!FUNDAMENTACAO_LEGAL.value) {
								FUNDAMENTACAO_LEGAL.style.display = 'none';
							}
							else {
								FUNDAMENTACAO_LEGAL.style.display = '';
							}	
						
						<cfelse>
							if(!FUNDAMENTACAO_LEGAL.value) {
								FUNDAMENTACAO_LEGAL.style.display = 'none';
							}
							else {
								FUNDAMENTACAO_LEGAL.style.display = '';
							}	
						</cfif> 
						</cfoutput>
					}
				</script>
                
                <cfif vars.TABELA_FRETE_MODELO_ID eq 2>
                <cfset v_valor_total_tributavel = ''>
                    <cfset v_valor_icms = ''>
                    <cfset v_valor_icms_substituto = ''>
                    <cfset v_total_ctrc = ''>
                    <cfset v_pedagio = ''>
                    <cfset v_icms_compoe_base_calculo = ''>
                    <cfset v_cfop = ''>
                    <cfset v_cfop_id = ''>
                    <cfset v_natureza_operacao = ''>
                    <cfset v_st_icms_id = ''>
                    <cfset v_st_icms_desc = ''>
                    <cfset v_num_produto = vars.NUM_PRODUTO>
                    <cfset v_cod_pessoa_filial = ''>
                    <cfset v_base_calculo_icms = ''>
					<cfset v_possui_base_calculo_icms = '0'>
                    <cfset v_base_calculo_icms_st = ''>
					<cfset v_possui_base_calculo_icms_st = '0'>
                    <cfset v_icms_part_compoe_base_calc = ''>
                    <cfif isdefined("vars.COD_PESSOA_FILIAL")>
                        <cfset v_cod_pessoa_filial = vars.COD_PESSOA_FILIAL>
                    <cfelseif isdefined("vars.COD_PESSOA_FILIAL_AUX")>
                        <cfset v_cod_pessoa_filial = vars.COD_PESSOA_FILIAL_AUX>
                    </cfif>
                    <cfoutput query="qrCalculo.query">
                        <cfswitch expression="#qrCalculo.query.COD_VARIAVEL#">
                            <cfcase value="VALOR_TOTAL_TRIBUTAVEL">
                                <cfset v_valor_total_tributavel = qrCalculo.query.VALOR>
                            </cfcase>
                            <cfcase value="TOTALCTRC">
                                <cfset v_total_ctrc = qrCalculo.query.VALOR>
                            </cfcase>
                            <cfcase value="VALORICMS">
                                <cfset v_valor_icms = qrCalculo.query.VALOR>
                            </cfcase>
                            <cfcase value="VALORICMSSUBSTITUTO">
                                <cfset v_valor_icms_substituto = qrCalculo.query.VALOR>
                            </cfcase>
                            <cfcase value="PEDAGIO">
                                <cfset v_pedagio = qrCalculo.query.VALOR>
                            </cfcase>
                            <cfcase value="ICMS_COMPOE_BASE_CALCULO">
                                <cfset v_icms_compoe_base_calculo = qrCalculo.query.VALOR>
                            </cfcase>
                            <cfcase value="CFOP">
                                <cfset v_cfop = qrCalculo.query.VALOR>
                            </cfcase>
                            <cfcase value="CST_ICMS">
                                <cfset v_st_icms_id = qrCalculo.query.VALOR>
                            </cfcase>
                            <cfcase value="CFOP_ID">
                                <cfset v_cfop_id = qrCalculo.query.VALOR>
                            </cfcase>
                            <cfcase value="NATUREZA_OPERACAO">
                                <cfset v_natureza_operacao = qrCalculo.query.VALOR>
                            </cfcase>
                            <cfcase value="BASECALCULOICMS">
                                <cfset v_base_calculo_icms = qrCalculo.query.VALOR>
                                <cfset v_possui_base_calculo_icms = 1>
                            </cfcase>
                            <cfcase value="BASECALCULOICMSSUBSTITUTO">
                                <cfset v_base_calculo_icms_st = qrCalculo.query.VALOR>
								<cfset v_possui_base_calculo_icms_st = 1>
                            </cfcase>
                            <cfcase value="ICMS_PART_COMPOE_BASE_CALCULO">
                                <cfset v_icms_part_compoe_base_calc = qrCalculo.query.VALOR>
                            </cfcase>
                        </cfswitch>
                    </cfoutput>

					<cfif v_cfop eq '' or v_num_produto eq '' or v_valor_total_tributavel eq '' or (v_total_ctrc eq '' and v_st_icms_id neq '') or v_pedagio eq '' or v_icms_compoe_base_calculo eq '' or v_cod_pessoa_filial eq '' or vars.COD_DESTINATARIO eq '' or vars.COD_REDESPACHO eq '' or vars.COLETA_COD_PESSOA eq '' or vars.COD_CLIENTE_COBRANCA eq '' or v_icms_part_compoe_base_calc eq '' or v_possui_base_calculo_icms eq 0 or v_possui_base_calculo_icms_st eq 0 >
                        <cfset impMsg = 'No foi possvel buscar as configuraes de impostos. Motivo(s):'>
                        <cfif v_cfop eq ''>
                            <cfset impMsg = impMsg&'<br> - Varivel CFOP no definida na tabela frete ou nula.'>
                        </cfif>
                        <cfif v_num_produto eq ''>
                            <cfset impMsg = impMsg&'<br> - Produto no selecionado.'>
                        </cfif>
                        <cfif v_valor_total_tributavel eq ''>
                            <cfset impMsg = impMsg&'<br> - Varivel VALOR_TOTAL_TRIBUTAVEL no definida na tabela frete ou nula.'>
                        </cfif>
                        <cfif v_total_ctrc eq ''>
                            <cfset impMsg = impMsg&'<br> - Varivel TOTALCTRC no definida na tabela frete ou nula.'>
                        </cfif>
                        <cfif v_pedagio eq ''>
                            <cfset impMsg = impMsg&'<br> - Varivel PEDAGIO no definida na tabela frete ou nula.'>
                        </cfif>
                        <cfif v_icms_compoe_base_calculo eq ''>
                            <cfset impMsg = impMsg&'<br> - Varivel ICMS_COMPOE_BASE_CALCULO no definida na tabela frete ou nula.'>
                        </cfif>
                        <cfif v_cod_pessoa_filial eq ''>
                            <cfset impMsg = impMsg&'<br> - Unidade de negcio no selecionada.'>
                        </cfif>
                        <cfif vars.COD_DESTINATARIO eq ''>
                            <cfset impMsg = impMsg&'<br> - Destinatrio no selecionado.'>
                        </cfif>
                        <cfif vars.COD_REDESPACHO eq ''>
                            <cfset impMsg = impMsg&'<br> - Expedidor no selecionado.'>
                        </cfif>
                        <cfif vars.COLETA_COD_PESSOA eq ''>
                            <cfset impMsg = impMsg&'<br> - Recebedor no selecionado.'>
                        </cfif>
                        <cfif vars.COD_CLIENTE_COBRANCA eq ''>
                            <cfset impMsg = impMsg&'<br> - Tomador no selecionado.'>
                        </cfif>
                        <cfif vars.MERCADORIA_TRANSPORTADA eq ''>
                            <cfset impMsg = impMsg&'<br> - Natureza no selecionada.'>
                        </cfif>
                        <cfif v_icms_part_compoe_base_calc eq ''>
                            <cfset impMsg = impMsg&'<br> - Varivel ICMS_PART_COMPOE_BASE_CALCULO no definida na tabela frete ou nula.'>
                        </cfif>
						 <cfif v_possui_base_calculo_icms eq 0>
                            <cfset impMsg = impMsg&'<br> - Varivel BASECALCULOICMS no definida na tabela frete ou nula.'>
							<cfset v_base_calculo_icms = 0>
                        </cfif>
						 <cfif v_possui_base_calculo_icms_st eq 0>
                            <cfset impMsg = impMsg&'<br> - Varivel BASECALCULOICMSSUBSTITUTO no definida na tabela frete ou nula.'>
							<cfset v_base_calculo_icms_st = 0>
                        </cfif>
                        <cfthrow message="#impMsg#">
                    </cfif>
                </cfif>
                
                <div id="div_negociacao_tabela_frete" style="display: none;">
                    <table border="0" cellpadding="0" cellspacing="0">
                        <tr>
                            <td valign="top">
                            	<table border="0">
                                    <tr>
                                        <td valign="top">
                                            <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                <tr class="titulo_1">
                                                    <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                    <td nowrap align="left">Valor</td>
                                                    <td nowrap align="center">Tipo</td>
                                                </tr>
                                                <cfset countRowVisivel = 0>
                                                <cfset primeiraTabela  = 1>
												<cfoutput query="qrCalculo.query">
                                                	<cfif qrCalculo.query.COD_VARIAVEL eq 'PERC_TOLERANCIA_QUEBRA' and v_param_tolerancia gt 0>
	                                                    <cfset v_valor = v_param_tolerancia>
                                                    <cfelse>
                                                    	<cfset v_valor = qrCalculo.query.VALOR>
                                                    </cfif>
                                                    
                                                    <cfif qrCalculo.query.COD_VARIAVEL eq 'PERMITE_BASE_CALC_MAIOR_TOTAL' and len(trim(qrCalculo.query.VALOR))>	
                                                        <script>
															with(parent.document.forms[0]) {
			                                                    BASE_CALC_MAIOR_TOTAL.value = '#qrCalculo.query.VALOR#';
															}
														</script>
                                                    </cfif>
                                                    <cfswitch expression="#qrCalculo.query.TIPO#">
                                                        <cfcase value="0">
                                                            <cfset v_imagem = 'seta_matriz'>

                                                            <cfset v_tipo   = 'Interna - No Editvel'>
                                                        </cfcase>
                                                        <cfcase value="1">
                                                            <cfset v_imagem = 'fx'>
                                                            <cfset v_tipo   = 'Frmula'>
                                                        </cfcase>
                                                        <cfcase value="2">
                                                            <cfset v_imagem = 'arquivo_detalhes'>
                                                            <cfset v_tipo   = 'Valor - Informando na Tabela'>
                                                        </cfcase>
                                                        <cfcase value="3">
                                                            <cfset v_imagem = 'editar'>
                                                            <cfset v_tipo   = 'Valor - Informando na Emisso do Documento'>
                                                        </cfcase>
                                                    </cfswitch>
                                                    
                                                    <cfif qrCalculo.query.CurrentRow neq qrCalculo.query.RecordCount and countRowVisivel%10 eq 0 and qrCalculo.query.exibir_emissao eq 1 and primeiraTabela eq 0>
														</table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                        <tr class="titulo_1">
                                                            <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                            <td nowrap align="left">Valor</td>
                                                            <td nowrap align="center">Tipo</td>
                                                        </tr>
                                                	</cfif>
                                                    
                                                    <cfif qrCalculo.query.exibir_emissao eq 1>
	                                                    <cfset primeiraTabela  = 0>
                                                    	<cfset countRowVisivel = countRowVisivel + 1>
                                                    </cfif>
                                                    
                                                    <tr class="linha_#(qrCalculo.query.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrCalculo.query.CurrentRow Mod 2) + 1#';" <cfif qrCalculo.query.exibir_emissao eq 0>style="DISPLAY: none"</cfif>>
                                                        <td nowrap align="left">#qrCalculo.query.DESCRICAO#</td>
                                                        <td nowrap align="left">
                                                        	<input type="hidden" name="VARIAVEL_#qrCalculo.query.COD_VARIAVEL#" id="VARIAVEL_#qrCalculo.query.COD_VARIAVEL#" maxlength="15" value="<cfif IsNumeric(v_valor)>#v_valor#<cfelse>#v_valor#</cfif>" <cfif qrCalculo.query.TIPO eq 3>obrigatorio="1"<cfelse>readonly</cfif> <cfif IsNumeric(v_valor)>tipo="numerico"</cfif> display="#UCase(qrCalculo.query.DESCRICAO)#" onChange="this.value = Number(this.value); <cfif qrCalculo.query.TIPO eq 3>f_calculos();</cfif>" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px; text-align: right;" />
                                                            <input type="text" name="VARIAVEL_#qrCalculo.query.COD_VARIAVEL#_CALC" id="VARIAVEL_#qrCalculo.query.COD_VARIAVEL#_CALC" maxlength="15" value="<cfif IsNumeric(v_valor)>#NumberFormat(Replace(v_valor, ',', '.', 'all'), '_.__')#<cfelse>#v_valor#</cfif>" <cfif qrCalculo.query.TIPO eq 3>obrigatorio="1"<cfelse>readonly</cfif> <cfif IsNumeric(v_valor)>tipo="numerico"</cfif> display="#UCase(qrCalculo.query.DESCRICAO)#" onChange="this.value = Number(this.value); VARIAVEL_#qrCalculo.query.COD_VARIAVEL#.value = VARIAVEL_#qrCalculo.query.COD_VARIAVEL#_CALC.value;  <cfif qrCalculo.query.TIPO eq 3>f_calculos();</cfif>" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 85px; text-align: right;" />
                                                        </td>
                                                        <td nowrap align="center"><img src="/_imagens/botoes/16x16/#v_imagem#.gif" alt="#v_tipo#" title="#v_tipo#" width="16" height="16" align="absmiddle" /></td>
                                                    </tr>
                                            	</cfoutput>
                                                <tr class="linha_#((qrCalculo.query.RecordCount + 1) Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#((qrCalculo.query.RecordCount + 1) Mod 2) + 1#';">
                                                    <td colspan="2" nowrap align="left">&nbsp;</td>
                                                    <td nowrap align="center"><button type="button" class="botao-16x16" onClick="f_calculos()"><img src="/_imagens/botoes/16x16/calculadora.gif" alt="Executar C&aacute;lculos" title="Executar C&aacute;lculos" width="16" height="16" align="absmiddle" /></button></td>
                                                </tr>
                                            </table>
                                        </td>
                                	</tr>
                                </table>
                            </td>
                            <td valign="top" style="padding-left: 20px;">
                            	<cfscript>
									v_retorno = f_dados_tabela_frete();
								</cfscript>

                            </td>
                        </tr>
                    </table>
                </div>
                
                <cfscript>
					conn_st = CreateComponent('modulos.cte._componentes.consulta.cfc_emissao_documentos');
					qrStICMS = conn_st.get_situacao_tributaria(st_icms_id = v_st_icms_id);
				</cfscript>
                
                <cfif vars.TABELA_FRETE_MODELO_ID eq 2>
					<script>
                        with(parent.document.forms[0]) {
                            CFOP.value 				  = <cfoutput>'#JSStringFormat(v_cfop)#'</cfoutput>;
                            CFOP_ID.value 			  = <cfoutput>'#JSStringFormat(v_cfop_id)#'</cfoutput>;
                            NATUREZA_OPERACAO.value   = <cfoutput>'#JSStringFormat(v_natureza_operacao)#'</cfoutput>;
                            ST_ICMS_ID.value          = VARIAVEL_CST_ICMS.value;
							ST_ICMS_ID_COMBO.value    = VARIAVEL_CST_ICMS.value;
							FUNDAMENTACAO_LEGAL.value =  '';
                        }
                    </script>
                    
					<cfscript>
                        connImp = CreateComponent('modulos.cte._componentes.consulta.cfc_impostos');
                        qrBuscaimposto = connImp.get_impostos_ctrc(
                            NUM_PRODUTO                  = v_num_produto,
                            COD_PESSOA_FILIAL            = v_cod_pessoa_filial,
							COD_REMETENTE                = vars.COD_REMETENTE,
                            COD_DESTINATARIO	         = vars.COD_DESTINATARIO,
                            COD_REDESPACHO               = vars.COD_REDESPACHO,
                            COLETA_COD_PESSOA            = vars.COLETA_COD_PESSOA,
                            COD_CLIENTE_COBRANCA         = vars.COD_CLIENTE_COBRANCA,
                            CFOP                         = v_cfop,
                            VALOR_TOTAL_TRIBUTAVEL_CALC	 = v_valor_total_tributavel,
                            TOTALCTRC_CALC 			     = v_total_ctrc,
                            PEDAGIO_CALC                 = v_pedagio,
                            ICMS_COMPOE_BASE_CALCULO     = v_icms_compoe_base_calculo,
                            VALOR_ICMS                   = v_valor_icms,
                            VALOR_ICMS_SUBSTITUTO        = v_valor_icms_substituto,
                            NUM_NATUREZA                 = vars.MERCADORIA_TRANSPORTADA,
                            CFOP_TRANSPORTADO            = vars.CFOP_TRANSPORTADO,
                            ICMS_PARTILHADO              = vars.NFE_ICMS_PARTILHADO,
                            BASE_CALCULO_ICMS            = v_base_calculo_icms + v_base_calculo_icms_st,
                            DATA_EMISSAO                 = vars.DATA_EMISSAO,
							ICMS_PART_COMPOE_BASE_CALC   = v_icms_part_compoe_base_calc,
							COD_MODELO                   = 57,
                            COD_ENDERECO_DESTINATARIO    = vars.DEST_COD_ENDERECO,
                            COD_ENDERECO_ENTREGA         = vars.RED_COD_ENDERECO,
                            COD_ENDERECO_COLETA          = vars.COLETA_COD_ENDERECO,
                            COD_ENDERECO_TOMADOR         = vars.COB_COD_ENDERECO,
							REM_MUNICIPIO_ID             = vars.REM_MUNICIPIO_ID,
							COLETA_UF 		             = vars.COLETA_UF,
							ENTREGA_UF 		             = vars.RED_UF,
							COLETA_MUNICIPIO_ID          = vars.COLETA_MUNICIPIO_ID,
							ENTREGA_MUNICIPIO_ID         = iif(vars.FRETE_ULT_ENTREGA eq 0, de(vars.RED_MUNICIPIO_ID), de(vars.MUNICIPIO_ULT_ENTREGA_ID)),
							TOMA_COD_ATIVIDADE_FISCAL    = vars.COB_COD_ATIVIDADE_FISCAL,
							DEST_COD_ATIVIDADE_FISCAL    = vars.DEST_COD_ATIVIDADE_FISCAL,
							CONHECIMENTO_TIPO_ID         = vars.CONHECIMENTO_TIPO_ID,
							EMIT_COD_ENDERECO            = vars.REM_CB_ENDERECO,
							NFE_PARTILHADA               = vars.NFE_ICMS_PARTILHADO
                        );
                    </cfscript>
					
                    <script>
                        countPis	 		= 0;
                        countCofins  		= 0;
                        countPisRetido	 	= 0;
                        countCofinsRetido	= 0;
                    </script>
                    <cfoutput query="qrBuscaimposto.query">
                        <script>
                            if ('#qrBuscaimposto.query.IMP_TIPO_DESC#' == 'PIS') {
                                countPis++;
                            } else if ('#qrBuscaimposto.query.IMP_TIPO_DESC#' == 'COFINS') {
                                countCofins++;
                            } else if ('#qrBuscaimposto.query.IMP_TIPO_DESC#' == 'PIS Retido') {
                                countPisRetido++;
                            } else if ('#qrBuscaimposto.query.IMP_TIPO_DESC#' == 'COFINS Retido') {
                                countCofinsRetido++;
                            }
                        </script>
                    </cfoutput>
                    <cfoutput query="qrBuscaimposto.query">
                        <script>
						
                            if (countPis == countCofins || ('#qrBuscaimposto.query.IMP_TIPO_DESC#' != 'PIS' && '#qrBuscaimposto.query.IMP_TIPO_DESC#' != 'COFINS')) {
                                if (countPisRetido == countCofinsRetido || ('#qrBuscaimposto.query.IMP_TIPO_DESC#' != 'PIS Retido' && '#qrBuscaimposto.query.IMP_TIPO_DESC#' != 'COFINS Retido')) {
                                    with(parent.document.forms[0]) {							
                                        IMPOSTO_TIPO_ID.value				= '#qrBuscaimposto.query.IMPOSTO_TIPO_ID#';
                                        IMP_TIPO_DESC.value					= '#qrBuscaimposto.query.IMP_TIPO_DESC#';
                                        DESCRICAO.value						= '#qrBuscaimposto.query.DESCRICAO#';
                                        ALIQUOTA.value						= '#qrBuscaimposto.query.ALIQUOTA#';
                                        ALIQUOTA_FORMAT.value				= '#lsNumberFormat(qrBuscaimposto.query.ALIQUOTA,',___.____')#';
                                        REDUCAO_BASE.value 					= '#qrBuscaimposto.query.REDUCAO_BASE#';
                                        REDUCAO_BASE_FORMAT.value 			= '#lsNumberFormat(qrBuscaimposto.query.REDUCAO_BASE,',___.__')#';
                                        BASE_CALCULO.value 					= '#qrBuscaimposto.query.BASE_CALCULO#';
                                        BASE_CALCULO_FORMAT.value 			= '#lsNumberFormat(qrBuscaimposto.query.BASE_CALCULO,',__________________.__')#';
                                        IMPOSTO_TOTAL.value 				= '#qrBuscaimposto.query.IMPOSTO_TOTAL#';
                                        IMPOSTO_TOTAL_FORMAT.value 			= '#lsNumberFormat(qrBuscaimposto.query.IMPOSTO_TOTAL,',__________________.__')#';
                                        IMPOSTO_SITUACAO_ID.value 			= '#qrBuscaimposto.query.IMPOSTO_SITUACAO_ID#';
                                        IMP_COD_SITUACAO.value 				= '#qrBuscaimposto.query.IMP_COD_SITUACAO#';
                                        RETIDO_FONTE.value 					= '#qrBuscaimposto.query.RETIDO_FONTE#';
                                        RETIDO_FONTE_DESC.value 			= '#qrBuscaimposto.query.RETIDO_FONTE_DESC#';
                                        IMPOSTO_COD_RETENCAO_ID.value 		= '#qrBuscaimposto.query.IMPOSTO_COD_RETENCAO_ID#';
                                        COD_RETENCAO.value 					= '#qrBuscaimposto.query.COD_RETENCAO#';
                                        REGIME_CUMULATIVO.value 			= '#qrBuscaimposto.query.REGIME_CUMULATIVO#';
                                        REGIME_CUMULATIVO_DESC.value 		= '#qrBuscaimposto.query.REGIME_CUMULATIVO_DESC#';
                                        IMPOSTO_ORIGEM_ID.value 			= '#qrBuscaimposto.query.IMPOSTO_ORIGEM_ID#';
                                        IND_ORIG_CRED.value 				= '#qrBuscaimposto.query.IND_ORIG_CRED#';
                                        NAT_BC_CRED.value 					= '#qrBuscaimposto.query.NAT_BC_CRED#';
                                        IMPOSTO_NATUREZA_BC_ID.value 		= '#qrBuscaimposto.query.IMPOSTO_NATUREZA_BC_ID#';
                                        IMP_FUNDAMENTACAO_LEGAL.value 		= '#qrBuscaimposto.query.IMP_FUNDAMENTACAO_LEGAL#';
                                        RESERVADO_FISCO.value 				= '#qrBuscaimposto.query.RESERVADO_FISCO#';

                                        PRODUTO_DESCRICAO.value 			= '#qrBuscaimposto.query.PRODUTO_DESCRICAO#';
                                        IMPOSTO_SITUACAO_TRIB_TIPO_ID.value = '#qrBuscaimposto.query.IMPOSTO_SITUACAO_TRIB_TIPO_ID#'
										BASE_CALCULO_REDUZIDA.value			= '#qrBuscaimposto.query.BASE_CALCULO_REDUZIDA#';
										BASE_CALCULO_REDUZIDA_FORMAT.value	= '#lsNumberFormat(qrBuscaimposto.query.BASE_CALCULO_REDUZIDA,',__________________.__')#';
                                        GERA_CPG_ICMS_ANTECIPADO.value		= '#qrBuscaimposto.query.GERA_CPG_ICMS_ANTECIPADO#'; 
                                        FUNDAMENTACAO_LEGAL.value           =  FUNDAMENTACAO_LEGAL.value + '#qrBuscaimposto.query.imp_fundamentacao_legal#';

										if(FUNDAMENTACAO_LEGAL.value != ''){
											FUNDAMENTACAO_LEGAL.style.display = '';
										}

										if ('#qrBuscaimposto.query.IMP_TIPO_DESC#' == 'ICMS' || '#qrBuscaimposto.query.IMP_TIPO_DESC#' == 'ICMS Substituto') {
										   ST_ICMS_ID.value          = '#qrBuscaimposto.query.COD_SITUACAO#';
										   ST_ICMS_ID_COMBO.value    = '#qrBuscaimposto.query.COD_SITUACAO#';
										}

                                        parent.f_salvar_IMPOSTOS();
                                    }
                                }
                            }
                        </script>
                    </cfoutput>
                    <script>
                        parent.document.getElementById('tb_impostos').style.display = '';
                        parent.document.getElementById('spam_imposto_info').style.display = 'none';
						parent.document.getElementById('td_impostos_title').style.display = '';
                    </script>
                <cfelse>
                	<script>
	                	parent.document.getElementById('td_impostos_title').style.display = 'none';
					</script>
                </cfif>

			    <cfset v_retorno.erro = false>

                <cfcatch>
                	<cfset v_retorno.erro = true>
					<cfset v_retorno.mensagem = cfcatch>
                    <cfset v_retorno.tabela_encontrada = 0>
                    <cfset v_mensagem_erro = ''>
                    <cfif not len(trim(v_retorno.mensagem.detail)) and len(trim(cfcatch.Message))>
	                    <cfset v_mensagem_erro = cfcatch.Message>
                    </cfif>
                    <div id="div_negociacao_tabela_frete" style="display: none;">
                   		<cfscript>
						    if(not len(trim(v_mensagem_erro)))
							v_tabela = f_dados_tabela_frete(erro = v_retorno.erro, mensagem = v_retorno.mensagem.detail);
							else
								v_tabela = f_dados_tabela_frete(erro = v_retorno.erro, mensagem_erro = v_mensagem_erro);
							if(v_retorno.erro == false)
								v_retorno = v_tabela;
							
                            if (isdefined("qrBuscaimposto")){
							   fnc_trata_erros(struct_erro = qrBuscaimposto, mostra_msg_ok  = false, abort_on_error = false);
							}
						</cfscript>
                    </div>
                </cfcatch>
			</cftry>
            
        <cfif Len(Trim(vars.CONHECIMENTO_ID))>
			<cfscript>
                conn = CreateComponent("modulos.cte._componentes.consulta.comercial.cfc_tabela_frete");
                qrUltimaVersao = conn.get_ctrc_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID, ultima_versao = 1);
            </cfscript>
            <!--- se foi emitido por tabela frete --->
			<cfif (Len(Trim(qrUltimaVersao.VERSAO_ID))) >
                <cfscript>qrVersaoTarifa = conn.get_conhecimento_tarifa(versao_id = qrUltimaVersao.VERSAO_ID);</cfscript>
            
				<script>
                if(parent.v_variaveis_tabela_frete == 1){
                    parent.v_variaveis_tabela_frete = 0;
                    <cfoutput query="qrVersaoTarifa">
                        try{
                            var valor = #qrVersaoTarifa.VALOR#;
                            document.getElementById("VARIAVEL_#qrVersaoTarifa.COD_VARIAVEL#").value = valor.toFixed(2);
                            document.getElementById("VARIAVEL_#qrVersaoTarifa.COD_VARIAVEL#_CALC").value = valor.toFixed(2);						
                        }catch (e){
                        }
                    </cfoutput>  
                }
                </script>
            </cfif>
        </cfif>
            
            <script type="text/javascript">
				parent.document.getElementById('tr_negociacao_carregando').style.display = 'none';
				parent.document.getElementById('tr_negociacao_info').style.display = 'none';
				parent.document.getElementById('tr_negociacao_tabela_frete').style.display = '';
				
				parent.document.getElementById('td_negociacao_tabela_frete').innerHTML = document.getElementById('div_negociacao_tabela_frete').innerHTML;
			</script>
            <div id="div_mensagem_erro" style="display:;">
			<cfscript>
                fnc_trata_erros(struct_erro = v_retorno, mostra_msg_ok = false, abre_popup = false, abort_on_error = false);
            </cfscript>
            </div>
            <script>
				parent.document.getElementById('dv_form_erro_tabela_frete').innerHTML = document.getElementById('div_mensagem_erro').innerHTML;
				<cfif not v_retorno.erro and isDefined("v_retorno.tabela_encontrada") and v_retorno.tabela_encontrada eq 1>
					parent.f_habilitar_botao('confirmar', 'f_confirmar()');
				<cfelse>
					parent.f_desabilitar_botao('confirmar');
				</cfif>
			</script>
        </cfcase>
        
        <cfcase value="7">
			<cfscript>
                conn = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
                qrVersao       = conn.get_ctrc_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID);
                qrUltimaVersao = conn.get_ctrc_comercial_versao(conhecimento_id = vars.CONHECIMENTO_ID, ultima_versao = 1);
                qrVersaoTarifa = conn.get_conhecimento_tarifa(versao_id = qrUltimaVersao.VERSAO_ID);
                
                conn = CreateComponent("modulos.cte._componentes.consulta.comercial.cfc_tabela_frete");
                qrTabelaFreteRota = conn.get_tabela_frete_rota(tabela_frete_rota_id = qrUltimaVersao.TABELA_FRETE_ROTA_ID
															 , tabela_frete_id		= qrUltimaVersao.TABELA_FRETE_ID);
            </cfscript>
            <fieldset><legend>Vers&otilde;es</legend>
            <table width="100%" border="0" cellspacing="1" cellpadding="3">
                <tr class="titulo_1">
                    <td width="1%" nowrap align="center">&nbsp;</td>
                    <td width="1%" nowrap align="center">N&ordm; Vers&atilde;o</td>
                    <td width="1%" nowrap align="left">Inserido por</td>
                    <td nowrap align="left">Data de Inser&ccedil;&atilde;o</td>
                </tr>
                <cfoutput query="qrVersao">
                    <tr class="titulo_4">
                        <td nowrap align="center"><button type="button" id="BTN_MOSTRAR_TARIFAS_#qrVersao.VERSAO_ID#" class="botao-16x16" onClick="f_mostrar_tarifas(#qrVersao.VERSAO_ID#)" <cfif qrVersao.CurrentRow eq 1>style="display: none;"</cfif>><img src="/_imagens/botoes/16x16/mostrar.gif" alt="Mostrar Tarifas" title="Mostrar Tarifas" width="16" height="16" align="absmiddle" /></button>
                            <button type="button" id="BTN_OCULTAR_TARIFAS_#qrVersao.VERSAO_ID#" class="botao-16x16" onClick="f_ocultar_tarifas(#qrVersao.VERSAO_ID#)" <cfif qrVersao.CurrentRow neq 1>style="display: none;"</cfif>><img src="/_imagens/botoes/16x16/ocultar.gif" alt="Ocultar Tarifas" title="Ocultar Tarifas" width="16" height="16" align="absmiddle" /></button></td>
                        <td nowrap align="center">#qrVersao.NUM_VERSAO#</td>
                        <td nowrap align="left">#qrVersao.USER_INSERT#</td>
                        <td nowrap align="left">#qrVersao.DATE_INSERT#</td>
                    </tr>
                    <cfif qrVersao.CurrentRow eq 1>
                    <tr id="tr_versao_#qrVersao.VERSAO_ID#">
                        <td id="td_versao_#qrVersao.VERSAO_ID#" colspan="4">
                            <table border="0" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td valign="top">
                                        <table border="0">
                                            <tr>
                                                <td valign="top">
                                                    <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                        <tr class="titulo_1">
                                                            <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                            <td nowrap align="right">Valor</td>
                                                        </tr>
                                                        <cfloop query="qrVersaoTarifa">
                                                            <tr class="linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#';">
                                                                <td nowrap align="left">#qrVersaoTarifa.DESCRICAO#</td>
                                                                <td nowrap align="right">#LSNumberFormat(qrVersaoTarifa.VALOR, ',.__')#</td>
                                                            </tr>
                                                            <cfif qrVersaoTarifa.CurrentRow neq qrVersaoTarifa.RecordCount and qrVersaoTarifa.CurrentRow%10 eq 0>
                                                                </table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                                <tr class="titulo_1">
                                                                    <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                                    <td nowrap align="right">Valor</td>
                                                                </tr>
                                                            </cfif>
                                                        </cfloop>
                                                    </table>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                    <td>
                                    	<cfscript>
											v_retorno = f_dados_tabela_frete();
										</cfscript>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                    <cfelse>
                    <tr id="tr_versao_#qrVersao.VERSAO_ID#" style="display: none;">
                        <td id="td_versao_#qrVersao.VERSAO_ID#" colspan="4"></td>
                    </tr>
                    </cfif>
                </cfoutput>
            </table>
            </fieldset>
        </cfcase>
        
        <cfcase value="8">
            <cfscript>
                conn = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
                qrVersao       = conn.get_ctrc_comercial_versao(versao_id = vars.VERSAO_ID);
                qrVersaoTarifa = conn.get_conhecimento_tarifa(versao_id = vars.VERSAO_ID);
                
                conn = CreateComponent("modulos.cte._componentes.consulta.comercial.cfc_tabela_frete");
                qrTabelaFreteRota = conn.get_tabela_frete_rota(tabela_frete_rota_id = qrVersao.TABELA_FRETE_ROTA_ID
															 , tabela_frete_id 		= qrVersao.TABELA_FRETE_ID);
            </cfscript>
            <table border="0" cellpadding="0" cellspacing="0">
                <tr>
                    <td valign="top">
                        <table border="0">
                            <tr>
                                <td valign="top">
                                    <table border="0" cellspacing="1" cellpadding="3" class="borda">
                                        <tr class="titulo_1">
                                            <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                            <td nowrap align="right">Valor</td>
                                        </tr>
                                        <cfoutput query="qrVersaoTarifa">
                                            <tr class="linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrVersaoTarifa.CurrentRow Mod 2) + 1#';">
                                                <td nowrap align="left">#qrVersaoTarifa.DESCRICAO#</td>
                                                <td nowrap align="right">#LSNumberFormat(qrVersaoTarifa.VALOR, ',.__')#</td>
                                            </tr>
                                            <cfif qrVersaoTarifa.CurrentRow neq qrVersaoTarifa.RecordCount and qrVersaoTarifa.CurrentRow%10 eq 0>
                                                </table></td><td valign="top"><table border="0" cellspacing="1" cellpadding="3" class="borda">
                                                <tr class="titulo_1">
                                                    <td nowrap align="left">Descri&ccedil;&atilde;o</td>
                                                    <td nowrap align="right">Valor</td>
                                                </tr>
                                            </cfif>
                                        </cfoutput>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                    <td valign="top" style="padding-left: 20px;">
                        <fieldset><legend>Dados da Tabela de Frete</legend>
                        <table border="0" cellspacing="1" cellpadding="3">
                            <cfoutput>
                            <tr>
                                <td nowrap align="left" class="texto">Tabela de Frete:</td>
                                <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.TABELA_FRETE_DESC#</td>
                            </tr>
                            <tr>
                                <td nowrap align="left" class="texto">Rota:</td>
                                <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.ROTA_DESC#</td>
                            </tr>
                            <tr>
                                <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o de Natureza:</td>
                                <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_NATUREZA_DESC#</td>
                            </tr>
                            <tr>
                                <td nowrap align="left" class="texto">Classifica&ccedil;&atilde;o Comercial:</td>
                                <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.CLASSIFICACAO_COMERCIAL_DESC#</td>
                            </tr>
                            <tr>
                                <td nowrap align="left" class="texto">Tipo de Negocia&ccedil;&atilde;o:</td>
                                <td nowrap align="left" class="texto_negrito">#qrTabelaFreteRota.TIPO_NEGOCIACAO#</td>
                            </tr>
                            </cfoutput>
                        </table>
                        </fieldset>
                    </td>
                </tr>
            </table>
        </cfcase>
        <cfcase value="9">
                <cfscript>
                    conn = CreateComponent("modulos.cte._componentes.consulta.logistica.cfc_operacao");
                    qrOperacao= conn.get_operacao(internacional = 0, somente_ativas = 1, lotacao = vars.lotacao, argumentCollection = vars);
                </cfscript>
                <table width="100%" border="0" cellspacing="0" cellpadding="0">
                    <tr>
                        <td class="texto">
                            <table width="100%" border="0" cellspacing="1" cellpadding="1">
                                <tr class="titulo_2">
                                    <td nowrap align="left">C&oacute;d. Opera&ccedil;&atilde;o</td>
                                    <td nowrap align="left">Descri&ccedil;&atilde;o</td>                  
                                </tr>
                                <cfoutput query="qrOperacao">
                                    <cfif not qrOperacao.POSSUI_FILHOS>                            
                                        <tr class="linha_#(qrOperacao.CurrentRow Mod 2) + 1#" onMouseOver="this.className = 'linha_over';" onMouseOut="this.className = 'linha_#(qrOperacao.CurrentRow Mod 2) + 1#';" onClick="f_retorna_valor('#JSStringFormat(qrOperacao.OPERACAO_ID)#', '#JSStringFormat(Replace(qrOperacao.OPERACAO_COMPLETA, '"', '', "ALL"))#')">
                                            <td nowrap align="left">#qrOperacao.OPERACAO_ID#</td>
                                            <td nowrap align="left">#JSStringFormat(Replace(qrOperacao.OPERACAO_COMPLETA, '"', '', "ALL"))#</td>
                                        </tr>
                                    </cfif>
                                </cfoutput>
                                <cfif qrOperacao.RecordCount eq 0>
                                <tr>
                                    <td colspan="3" align="center" valign="middle" class="obrigatorio">Nenhuma opera&ccedil;&atilde;o foi encontrada.</td>
                                </tr>
                                </cfif>
                            </table>
                        </td>
                    </tr>
                </table>
            </cfcase>
            
            <cfcase value="20">
				<cfscript>
                    conn = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
                    qrConhecimento = conn.get_conhecimento_dados(argumentCollection = vars, cod_modelo = '57');
                </cfscript>
                <cfif qrConhecimento.recordcount gt 0>
                    <cfoutput>
                    <input type="hidden" name="CONHECIMENTO_ID_CONSULTA" value="#qrConhecimento.conhecimento_id#" />
                    <input type="hidden" name="CNPJ_CPF_FILIAL_CONSULTA" value="#qrConhecimento.cnpj_cpf_filial#" />
                    <input type="hidden" name="SERIE_CONSULTA" value="#qrConhecimento.serie#" />
                    <input type="hidden" name="CANCELADO_CONSULTA" value="#qrConhecimento.cancelado#" />
                    <input type="hidden" name="COMPLEMENTO_NUM_ROMANEIO" value="#qrConhecimento.NUM_ROMANEIO#" />
                    <input type="hidden" name="COMPLEMENTO_ROMANEIO_ITEM_ID" value="#qrConhecimento.ITEM_ID#" />
					<input type="hidden" name="QTDE_COMPLEMENTOS" value="#qrConhecimento.QTDE_COMPLEMENTOS#" />
                    <fieldset><legend>Dados do Conhecimento</legend>
                    <table width="100%" border="0" cellspacing="1" cellpadding="3">
                      <tr>
                        <td width="12%" class="texto"><nobr>N&ordm; Conhecimento: </nobr> </td>
                        <td width="10%" class="texto_negrito">#qrConhecimento.num_conhecimento#/#qrConhecimento.serie#</td>
                        <td width="7%" class="texto">Emiss&atilde;o:</td>
                        <td width="25%" class="texto_negrito">#LSDateFormat(qrConhecimento.data_emissao)# #TimeFormat(qrConhecimento.data_emissao,'HH:MM')#</td>
                        <td width="7%" class="texto">&nbsp;</td>
                        <td width="39%" class="texto">&nbsp;</td>
                      </tr>
                      
                      <tr>
                        <td class="texto">Remetente:</td>
                        <td colspan="5" class="texto"><span class="texto_negrito">#qrConhecimento.rem_cnpj_cpf# - #qrConhecimento.rem_razao_social#</span></td>
                      </tr>
                      <tr>
                        <td class="texto">Endere&ccedil;o:</td>
                        <td colspan="3" class="texto_negrito"><span class="">#qrConhecimento.rem_cep# - #qrConhecimento.rem_endereco#</span></td>
                        <td class="texto">Munic&iacute;pio:</td>
                        <td class="texto"><span class="texto_negrito">#qrConhecimento.rem_municipio#/#qrConhecimento.rem_uf#</span></td>
                      </tr>
                      <tr>
                        <td class="texto">Destinat&aacute;rio:</td>
                        <td colspan="5" class="texto_negrito">#qrConhecimento.dest_cnpj_cpf# - #qrConhecimento.dest_razao_social#</td>
                      </tr>
                      <tr>
                        <td class="texto">Endere&ccedil;o:</td>
                        <td colspan="3" class="texto_negrito">#qrConhecimento.dest_cep# - #qrConhecimento.dest_endereco#</td>
                        <td class="texto">Munic&iacute;pio:</td>
                        <td class="texto"><span class="texto_negrito">#qrConhecimento.dest_municipio#/#qrConhecimento.dest_uf#</span></td>
                      </tr>
                    </table>
                    </fieldset>
                    </cfoutput>
                <cfelse>
                    <table width="100%" border="0" cellspacing="1" cellpadding="3">
                      <tr>
                        <td class="obrigatorio">Conhecimento no encontrado ou pertence a outra filial.</td>
                      </tr>
                     </table>
                    <input type="hidden" name="CONHECIMENTO_ID_CONSULTA" value="" />
                    <input type="hidden" name="COMPLEMENTO_NUM_ROMANEIO" value="-1" />
                    <input type="hidden" name="COMPLEMENTO_ROMANEIO_ITEM_ID" value="-1" />
                </cfif>
            </cfcase>
            
            <cfcase value="21">
				<cfscript>
                    conn = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
                    qrConhecimento = conn.get_conhecimento_dados(argumentCollection = vars, cod_modelo = '57');
                </cfscript>
                <cfif qrConhecimento.recordcount gt 0>
                    <cfoutput>
                    <input type="hidden" name="CONHECIMENTO_ID_CONSULTA" value="#qrConhecimento.conhecimento_id#" />
                    <input type="hidden" name="CNPJ_CPF_FILIAL_CONSULTA" value="#qrConhecimento.cnpj_cpf_filial#" />
                    <input type="hidden" name="SERIE_CONSULTA" value="#qrConhecimento.serie#" />
                    <input type="hidden" name="CANCELADO_CONSULTA" value="#qrConhecimento.cancelado#" />
                    <input type="hidden" name="SUBST_DATA_EMISSAO" value="#LSDateFormat(qrConhecimento.data_emissao)#" />
                    <input type="hidden" name="SUBST_NUM_ROMANEIO" value="#qrConhecimento.NUM_ROMANEIO#" />
                    <input type="hidden" name="SUBST_ROMANEIO_ITEM_ID" value="#qrConhecimento.ITEM_ID#" />
                    <input type="hidden" name="SUBST_POSSUI_COMPLEMENTO" value="#qrConhecimento.POSSUI_COMPLEMENTO#" />
                    <input type="hidden" name="SUBST_POSSUI_SUBSTITUTO" value="#qrConhecimento.POSSUI_SUBSTITUTO#" />
                    <input type="hidden" name="SUBST_COMPLEMENTO" value="#qrConhecimento.COMPLEMENTO#" />
                    <fieldset><legend>Dados do Conhecimento</legend>
                    <table width="100%" border="0" cellspacing="1" cellpadding="3">
                      <tr>
                        <td width="12%" class="texto"><nobr>N&ordm; Conhecimento: </nobr> </td>
                        <td width="10%" class="texto_negrito">#qrConhecimento.num_conhecimento#/#qrConhecimento.serie#</td>
                        <td width="7%" class="texto">Emiss&atilde;o:</td>
                        <td width="25%" class="texto_negrito">#LSDateFormat(qrConhecimento.data_emissao)# #TimeFormat(qrConhecimento.data_emissao,'HH:MM')#</td>
                        <td width="7%" class="texto">&nbsp;</td>
                        <td width="39%" class="texto">&nbsp;</td>
                      </tr>
                      
                      <tr>
                        <td class="texto">Remetente:</td>
                        <td colspan="5" class="texto"><span class="texto_negrito">#qrConhecimento.rem_cnpj_cpf# - #qrConhecimento.rem_razao_social#</span></td>
                      </tr>
                      <tr>
                        <td class="texto">Endere&ccedil;o:</td>
                        <td colspan="3" class="texto_negrito"><span class="">#qrConhecimento.rem_cep# - #qrConhecimento.rem_endereco#</span></td>
                        <td class="texto">Munic&iacute;pio:</td>
                        <td class="texto"><span class="texto_negrito">#qrConhecimento.rem_municipio#/#qrConhecimento.rem_uf#</span></td>
                      </tr>
                      <tr>
                        <td class="texto">Destinat&aacute;rio:</td>
                        <td colspan="5" class="texto_negrito">#qrConhecimento.dest_cnpj_cpf# - #qrConhecimento.dest_razao_social#</td>
                      </tr>
                      <tr>
                        <td class="texto">Endere&ccedil;o:</td>
                        <td colspan="3" class="texto_negrito">#qrConhecimento.dest_cep# - #qrConhecimento.dest_endereco#</td>
                        <td class="texto">Munic&iacute;pio:</td>
                        <td class="texto"><span class="texto_negrito">#qrConhecimento.dest_municipio#/#qrConhecimento.dest_uf#</span></td>
                      </tr>
                    </table>
                    </fieldset>
                    </cfoutput>
                <cfelse>
                    <table width="100%" border="0" cellspacing="1" cellpadding="3">
                      <tr>
                        <td class="obrigatorio">Conhecimento no encontrado ou pertence a outra filial.</td>
                      </tr>
                     </table>
                    <input type="hidden" name="CONHECIMENTO_ID_CONSULTA" value="" />
                    <input type="hidden" name="SUBST_NUM_ROMANEIO" value="-1" />
                    <input type="hidden" name="SUBST_ROMANEIO_ITEM_ID" value="-1" />
                </cfif>
            </cfcase>
            <cfcase value="22" >
            <cfscript>
                    conn = CreateComponent('modulos.cte._componentes.consulta.comercial.cfc_tabela_frete');
        			qrTabelaFrete = conn.get_tabela_frete_ids(argumentCollection = vars);
                </cfscript>
                <table width="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
                    <tr>
                        <td class="texto">
                            <table width="100%" border="0" cellspacing="1" cellpadding="1">
                                <tr class="titulo_2">
                                    <td nowrap align="left">Cdigo</td>
                                    <td nowrap align="left">Descri&ccedil;&atilde;o</td>                  
                                </tr>
                                <cfoutput query="qrTabelaFrete">
                                    <tr class="linha_2" >
                                        <td nowrap align="left">#qrTabelaFrete.TABELA_FRETE_ID#</td>
                                        <td nowrap align="left">#JSStringFormat(qrTabelaFrete.DESCRICAO)#</td>
                                    </tr>
                                </cfoutput>
                                <cfif qrTabelaFrete.RecordCount eq 0>
                                <tr>
                                    <td colspan="3" align="center" valign="middle" class="obrigatorio">Nenhuma tabela de frete foi encontrada.</td>
                                </tr>
                                </cfif>
                            </table>
                        </td>
                    </tr>
                </table>
            </cfcase>
            <cfcase value="23" >
            	<cfif IsDefined('vars.EMITIR_SEM_NUM_COMPROVANTE') and vars.EMITIR_SEM_NUM_COMPROVANTE neq 0>
					<cfscript>
                        conn = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");                    
                        
                        qrValePedagioConfig= conn.get_vale_pedagio_config(cod_pessoa_fornecedora = vars.COD_PESSOA_FORNECEDORA
                                                                         ,cod_pessoa_operadora   = vars.COD_PESSOA_OPERADORA
                                                                         );
                                                                         
                        if (Len(Trim(qrValePedagioConfig.vale_pedagio_config_id)) && ( Len(Trim(vars.SOLICITACAO_CARGA_ID)) or Len(Trim(vars.VIAGEM_ID))) ) {
                            qrValorVale = conn.get_vale_pedagio_valor(solicitacao_carga_id   = vars.SOLICITACAO_CARGA_ID
                                                                     ,viagem_id              = vars.VIAGEM_ID
                                                                     ,vale_pedagio_config_id = qrValePedagioConfig.vale_pedagio_config_id
                                                                     );																	 
                            
                            fnc_trata_erros(struct_erro = qrValorVale, mostra_msg_ok  = false);
                        }
                    </cfscript> 
                    
                    <cfoutput>
                       <script>
                           <cfif Len(Trim(qrValePedagioConfig.vale_pedagio_config_id)) && ( Len(Trim(vars.SOLICITACAO_CARGA_ID)) or Len(Trim(vars.VIAGEM_ID)))>
                               with(parent.document.forms[0]) {
                                   parent.document.getElementById('MENSAGEM_CONFIG_VALE_PEDAGIO').innerHTML = 'O vale pedgio ser emitido automaticamente.'; 
                                   NUM_COMPROVANTE.value = '';
                                   VALOR_COMPROVANTE.value = '#qrValorVale.valor#';
                                   NUM_COMPROVANTE.disabled = true;
                                   VALOR_COMPROVANTE.disabled = true;
								   EMITIR_SEM_NUM_COMPROVANTE.value = 1;
                               }
                           <cfelse>
                               with(parent.document.forms[0]) {
                                   NUM_COMPROVANTE.value = '';
                                   VALOR_COMPROVANTE.value = '';
                                   NUM_COMPROVANTE.disabled = false;
                                   VALOR_COMPROVANTE.disabled = false;
                                   parent.document.getElementById('MENSAGEM_CONFIG_VALE_PEDAGIO').innerHTML = ''; 
								   EMITIR_SEM_NUM_COMPROVANTE.value = 0;
                               }
                           </cfif>
                       </script>
                    </cfoutput>
                </cfif>
            </cfcase>
        
        <cfdefaultcase>
			<script>
				alert('Valor "<cfoutput>#vars.consulta#</cfoutput>" no implementado para a variavel CONSULTA!');
			</script>
		</cfdefaultcase>
	</cfswitch>
<cfelse>
<script>
alert('Variavel CONSULTA no definida!');
</script>
</cfif>

<cffunction name="f_dados_tabela_frete" >
	<cfargument name="mensagem" required="no" default="" >
	<cfargument name="mensagem_erro" required="no" default="" >    
    <cfif not isDefined("vars.FRETE_ULT_ENTREGA") >
    	<cfset vars.FRETE_ULT_ENTREGA = 0 >
    </cfif>
	<cfscript>
        connC = CreateComponent('modulos.cte._componentes.consulta.comercial.cfc_tabela_frete');
        if(IsDefined('vars.PLACA_REFERENCIA_INTERNA')) {
            v_placa_referencia_interna = Replace(vars.PLACA_REFERENCIA_INTERNA, ',', ' > ', 'all');
        }
        else {
            v_placa_referencia_interna = '';
        }
		
		if(IsDefined('vars.conhecimento_tipo_id')) {
            v_conhecimento_tipo_id = vars.conhecimento_tipo_id;
        }
        else {
            v_conhecimento_tipo_id = '';
        }
        
        qrTabela = connC.busca_tabela_frete(ORIGEM_MUNICIPIO_ID  = vars.COLETA_MUNICIPIO_ID,
                                             DESTINO_MUNICIPIO_ID = iif(vars.FRETE_ULT_ENTREGA eq 0, de(vars.RED_MUNICIPIO_ID), de(vars.MUNICIPIO_ULT_ENTREGA_ID)),
                                             COD_NEGOCIADOR       = vars.COD_NEGOCIADOR,
                                             NUM_NATUREZA		  = vars.NUM_NATUREZA,
											 TIPO			      = 0,
                                             COMPOSICAO			  = vars.PLACA_CONTROLE & ' > ' & v_placa_referencia_interna,
                                             TIPO_SERVICO_ID	  = vars.tipo_servico_comercial,
											 SOLICITACAO_CARGA_ID = vars.solicitacao_carga_id,
											 CONHECIMENTO_TIPO_ID = v_conhecimento_tipo_id
                                            );
    </cfscript>
    <cfset v_tipo = 'Nacional' >
    <cfif qrTabela.erro >
    	<cfscript>
			fnc_trata_erros(struct_erro = qrTabela, mostra_msg_ok  = 1);
		</cfscript>
        <cfset qrTabela.NEGOCIADOR       = 'No identificado...' >
        <cfset qrTabela.NUM_TIPO         = 0 >
        <cfset qrTabela.NUM_NEGOCIADOR   = 0 >
        <cfset qrTabela.NUM_VIGENCIA     = 0 >
        <cfset qrTabela.NUM_ROTAS        = 0 >
        <cfset qrTabela.TIPO_VEICULO     = 'No identificado...' >
        <cfset qrTabela.NUM_TIPO_VEICULO = 0 >
        <cfset qrTabela.PRODUTO          = 'No identificado...' >
        <cfset qrTabela.NUM_PRODUTO      = 0 >
        <cfset qrTabela.TIPO_SERVICO     = 'No identificado...' >
        <cfset qrTabela.NUM_TIPO_SERVICO = 0 >
        <cfset qrTabela.NEGOCIADOR_TF_IDS = 0 >
        <cfset qrTabela.TIPO_TF_IDS = 0 >
        <cfset qrTabela.TIPO_SERVICO_TF_IDS = 0 >
        <cfset qrTabela.VIGENCIA_IDS = 0 >
        <cfset qrTabela.ROTA_IDS = 0 >
        <cfset qrTabela.PRODUTO_IDS = 0 >
        <cfset qrTabela.TIPO_VEICULO_IDS = 0 >        
        <cfset v_tabela_frete     		 = 'N&atilde;o foi poss&iacute;vel definir a tabela de frete, entre em contato com o departamento comercial.<br />'&mid(qrTabela.mensagem.cause.message,12,len(qrTabela.mensagem.cause.message))>

    <cfelse>
        <cfset v_tabela_frete     = ''>
    </cfif>
    <table border="0" cellspacing="1" cellpadding="3" class="borda" width="498" style="margin-top:2px">                           
        <tr>
            <td colspan="4" class="titulo_1" align="center" style="border-bottom:1px solid #91A6B9">Tabela de Frete</td>
        </tr>
        <tr class="texto" style="text-align:center; font-weight:bold;">
            <td style="border-bottom:1px solid #99adbf" width="20%">Itens</td>
            <td style="border-bottom:1px solid #99adbf" width="79%">Valores</td>
            <td style="border-bottom:1px solid #99adbf" width="10%"><nobr>Tabelas Encontradas</nobr></td>
            <td style="border-bottom:1px solid #99adbf" width="1%">&nbsp;</td>
        </tr>
        <cfoutput>

       <cfif qrTabela.NUM_NEGOCIADOR eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif qrTabela.NUM_NEGOCIADOR eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_1">
            <td>Negociador</td>
            <td><nobr>#qrTabela.NEGOCIADOR#</nobr></td>
            <td align="center">#qrTabela.NUM_NEGOCIADOR#</td>
            <td><button type="button" class="botao-16x16" onclick="f_exibir_tabelas('TABELA_FRETE', '#qrTabela.NEGOCIADOR_TF_IDS#')"><img alt="Clique para exibir as tabelas encontradas" src="/_imagens/botoes/16x16/#v_img#" width="16" height="16" /></button></td>
        </tr>
        <cfif qrTabela.NUM_TIPO eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif qrTabela.NUM_TIPO eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_2">
            <td>Tipo</td>
            <td><nobr>#v_tipo#</nobr></td>
            <td align="center">#qrTabela.NUM_TIPO#</td>
            <td><button type="button" class="botao-16x16" onclick="f_exibir_tabelas('TABELA_FRETE', '#qrTabela.TIPO_TF_IDS#')"><img alt="Clique para exibir as tabelas encontradas" src="/_imagens/botoes/16x16/#v_img#" width="16" height="16" /></button></td>
        </tr>
        <cfif qrTabela.NUM_TIPO_SERVICO eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif qrTabela.NUM_TIPO_SERVICO eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_1">
            <td><nobr>Tipo Servi&ccedil;o</nobr></td>
            <td>#qrTabela.TIPO_SERVICO#</td>
            <td align="center">#qrTabela.NUM_TIPO_SERVICO#</td>
            <td><button type="button" class="botao-16x16" onclick="f_exibir_tabelas('TABELA_FRETE', '#qrTabela.TIPO_SERVICO_TF_IDS#')"><img alt="Clique para exibir as tabelas encontradas" src="/_imagens/botoes/16x16/#v_img#" width="16" height="16" /></button></td>
        </tr>
        <cfif qrTabela.NUM_VIGENCIA eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif qrTabela.NUM_VIGENCIA eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_2">
            <td>Vig&ecirc;ncia</td>
            <td>#lsDateFormat(now())#</td>
            <td align="center">#qrTabela.NUM_VIGENCIA#</td>
            <td><button type="button" class="botao-16x16" onclick="f_exibir_tabelas('VIGENCIA', '#qrTabela.VIGENCIA_IDS#')"><img alt="Clique para exibir as tabelas encontradas" src="/_imagens/botoes/16x16/#v_img#" width="16" height="16" /></button></td>
        </tr>
        <cfif qrTabela.NUM_ROTAS eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif qrTabela.NUM_ROTAS eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_1">
            <td>Rota</td>
            <cfif len(trim(qrTabela.ROTA_IDS))>
            <td>#vars.COLETA_MUNICIPIO# x #vars.RED_MUNICIPIO#</td>
            <cfelse>
            	<td>#qrTabela.ROTA#</td>
            </cfif>
            <td align="center">#qrTabela.NUM_ROTAS#</td>
            <cfif len(trim(qrTabela.ROTA_IDS))>
            <td><button type="button" class="botao-16x16" onclick="f_exibir_tabelas('ROTA', '#qrTabela.ROTA_IDS#')"><img alt="Clique para exibir as tabelas encontradas" src="/_imagens/botoes/16x16/#v_img#" width="16" height="16" /></button></td>
            <cfelse>
            	<td><button type="button" class="botao-16x16" onclick="f_exibir_tabelas('TABELA_FRETE', '#qrTabela.ROTA_TF_IDS#')"><img alt="Clique para exibir as tabelas encontradas" src="/_imagens/botoes/16x16/#v_img#" width="16" height="16" /></button></td>
            </cfif>
        </tr>
        <cfif qrTabela.NUM_PRODUTO eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif qrTabela.NUM_PRODUTO eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_2">
            <td>Mercadoria</td>
            <td>#qrTabela.PRODUTO#</td>
            <td align="center">#qrTabela.NUM_PRODUTO#</td>
            <cfif len(trim(qrTabela.PRODUTO_IDS))>
            <td><button type="button" class="botao-16x16" onclick="f_exibir_tabelas('ROTA', '#qrTabela.PRODUTO_IDS#')"><img alt="Clique para exibir as tabelas encontradas" src="/_imagens/botoes/16x16/#v_img#" width="16" height="16" /></button></td>
            <cfelse>
            	<td><button type="button" class="botao-16x16" onclick="f_exibir_tabelas('TABELA_FRETE', '#qrTabela.PRODUTO_TF_IDS#')"><img alt="Clique para exibir as tabelas encontradas" src="/_imagens/botoes/16x16/#v_img#" width="16" height="16" /></button></td>
            </cfif>
        </tr>
        <cfif qrTabela.NUM_TIPO_VEICULO eq 0>
            <cfset v_img = 'error2.png' >
        <cfelseif qrTabela.NUM_TIPO_VEICULO eq 1>
            <cfset v_img = 'confirmar_transp.gif' >
        <cfelse>
            <cfset v_img = 'atencao.png' >
        </cfif>
        <tr class="linha_1">
            <td><nobr>Tipo do Ve&iacute;culo</nobr></td>
            <td>#qrTabela.TIPO_VEICULO#</td>
            <td align="center">#qrTabela.NUM_TIPO_VEICULO#</td>
    		<cfif len(trim(qrTabela.TIPO_VEICULO_IDS))>
            <td><button type="button" class="botao-16x16" onclick="f_exibir_tabelas('ROTA', '#qrTabela.TIPO_VEICULO_IDS#')"><img alt="Clique para exibir as tabelas encontradas" src="/_imagens/botoes/16x16/#v_img#" width="16" height="16" /></button></td>
            <cfelse>
            	<td><button type="button" class="botao-16x16" onclick="f_exibir_tabelas('TABELA_FRETE', '#qrTabela.TIPO_VEICULO_TF_IDS#')"><img alt="Clique para exibir as tabelas encontradas" src="/_imagens/botoes/16x16/#v_img#" width="16" height="16" /></button></td>
            </cfif>
        </tr>
        <tr>
            <td colspan="4" <cfif not isDefined("qrTabela.TABELA_FRETE") or not len(trim(qrTabela.TABELA_FRETE)) or (isDefined("arguments.erro") and arguments.erro ) or qrTabela.NUM_TIPO_VEICULO gt 1>  class="obrigatorio" <cfelse> class="texto" </cfif> align="center" height="30" style="border-top:1px solid ##91A6B9; <cfif isDefined("qrTabela.TABELA_FRETE") and len(trim(qrTabela.TABELA_FRETE))>font-weight:bold</cfif>">
            	<cfif (not isDefined("qrTabela.TABELA_FRETE") or not len(trim(qrTabela.TABELA_FRETE)) or (isDefined("arguments.erro") and arguments.erro )) or qrTabela.NUM_TIPO_VEICULO gt 1>
                	<cfset qrTabela.TABELA_ENCONTRADA  = 0 >
                    	<cfif len(trim(arguments.mensagem)) > 0 >
                        	<a onClick="f_show_erro_tf()" class="a_erro_tf" onmouseover="this.className = 'a_erro_tf_hover'" onmouseout="this.className = 'a_erro_tf'" >
								<cfscript>
                                    v_msg = right(arguments.mensagem, len(arguments.mensagem)-10);                                    
                                </cfscript>
                                <cfif isDefined("qrTabela.NUM_TIPO_VEICULO") and qrTabela.NUM_TIPO_VEICULO gt 1>
                                	Foram econtradas mais de uma tabela de frete.<br />
	                                #qrTabela.TABELA_FRETE#<br />
                                <cfelse>
                                	#v_msg#
                            </cfif>
                            </a>
                        <cfelse>
	                        <cfif isDefined("qrTabela.NUM_TIPO_VEICULO") and qrTabela.NUM_TIPO_VEICULO gt 1>
								Foram econtradas mais de uma tabela de frete.<br />
                                #qrTabela.TABELA_FRETE#
                            <cfelseif Len(Trim(mensagem_erro))>
                            	#mensagem_erro#    
                          <cfelse>
                            	No foi possvel identificar a tabela de frete. Entre em contato com o departamento comercial.
                            </cfif>
                        </cfif>
                <cfelse>
                	<cfset qrTabela.TABELA_ENCONTRADA  = 1 >
                    Tabela Selecionada: #qrTabela.TABELA_FRETE#
              </cfif>
            </td>
        </tr>
        <tr>
            <td colspan="4" style="border-top:1px solid ##91A6B9">
                <button type="button" class="botao_tbl_frete" onClick="f_busca_tipo_calculo()" style="margin-right: 5px; width:100%; text-align:center;"><img src="/_imagens/botoes/16x16/atualizar.gif" alt="Tentar Novamente" title="Tentar Novamente" width="16" height="16" align="absmiddle" />&nbsp;Reconsultar forma de C&aacute;lculo</button>
            </td>
        </tr>
        </cfoutput>
    </table>
	<cfreturn qrTabela >
</cffunction>



<cfset requestEnd = 0>
