<cfscript>
	// Verifica se a varivel de controle de fluxo existe
	if((IsDefined("vars.OPERACAO")) and (Len(Trim(vars.OPERACAO)))) {
		conn_manip = CreateComponent("modulos.cte._componentes.manipulacao.cfc_cte");
		conn_cons  = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
		switch(val(vars.OPERACAO)) {
			case 2:
				set_manipulacao = conn_manip.ins_mapeamento_especie(argumentCollection = vars);
				break;
			case 3:
				set_manipulacao = conn_manip.atualizar_peso(argumentCollection = vars);
				break;
			case 4:
				set_manipulacao = conn_manip.inverter_unidade(DOCUMENTO_ID_ALTERACAO = vars.DOCUMENTO_ID_ALTERACAO);
				break;
			case 5:
				set_manipulacao = conn_manip.inverter_peso_utilizado(DOCUMENTO_ID_ALTERACAO = vars.DOCUMENTO_ID_ALTERACAO);
				break;
			case 6:
				set_manipulacao = conn_manip.consultar_doc(AMBIENTE_ID = vars.AMBIENTE_ID); 
				break;			
			case 7:
				set_manipulacao = conn_manip.consultar_doc_result(REQUISICAO_ID = vars.REQUISICAO_ID, AMBIENTE_ID = vars.AMBIENTE_ID, CHAVE = vars.CHAVE, CAPTCHA = vars.CAPTCHA);
				break;					
			case 8:
				set_manipulacao = conn_manip.baixar_documento(REQUISICAO_ID = vars.REQUISICAO_ID);
				break;
			case 9:
				set_manipulacao = conn_cons.get_captcha(REQUISICAO_ID = vars.REQUISICAO_ID);
				break;
		}
	}
</cfscript>

<cfif (vars.OPERACAO eq 6 or vars.OPERACAO eq 7 or vars.OPERACAO eq 8) and set_manipulacao.erro>
	<script type="text/javascript">
		parent.f_hide_carregando_ajax();
	</script>
</cfif>

<cfscript>
    if(val(vars.OPERACAO) eq 6 or val(vars.OPERACAO) eq 7){
		fnc_trata_erros(struct_erro = set_manipulacao, mostra_msg_ok = 0);
	}
	else if(val(vars.OPERACAO) neq 9) {
		fnc_trata_erros(struct_erro = set_manipulacao);		
	}
</cfscript>


<cfif vars.OPERACAO eq 6>
	<script type="text/javascript">
        with(parent.document.forms[0]) {
			REQUISICAO_ID.value = <cfoutput>'#set_manipulacao.requisicao_id#'</cfoutput>;
			parent.f_carregar_imagem();
        }
    </script>
<cfelseif vars.OPERACAO eq 7>
	<script type="text/javascript">
        with(parent.document.forms[0]) {
			parent.f_carregar_html();
        }
    </script>	
<cfelseif vars.OPERACAO eq 8>
	<script type="text/javascript">
        with(parent.document.forms[0]) {
		    parent.f_fechar_html();
        }
    </script>		
<cfelseif vars.OPERACAO eq 9>
	<script type="text/javascript">
        with(parent.document.forms[0]) {
		   parent.document.getElementById("div_image").innerHTML = '<img src="' + <cfoutput>'#set_manipulacao.image#'</cfoutput> + '" />';
		}
	</script>
<cfelse>
	<script type="text/javascript">
		with(parent.document.forms[0]) {
			<cfif (IsDefined("vars.ATUALIZA_COMBO")) and (Len(Trim(vars.ATUALIZA_COMBO)))>
				window.onload = function() {
					<cfoutput>
						#vars.ATUALIZA_COMBO#;
						top.window.close();
					</cfoutput>
				}	
			<cfelse>
				parent.f_atualizar();
			</cfif>
		}
	</script>
</cfif>
