<html>

<cfparam name="vars.DATA_INICIO" default="#DateFormat(now(), 'DD/MM/YYYY')#">
<cfparam name="vars.DATA_TERMINO" default="#DateFormat(now(), 'DD/MM/YYYY')#">
<cfparam name="vars.DATA_EMISSAO" default="#DateFormat(now(), 'DD/MM/YYYY')#">
<cfparam name="vars.SITUACAO_ID" default="">
<cfparam name="vars.SOMENTE_FILIAL" default="0">
<cfinclude template="/_scripts/scripts.cfm" />
<cfinclude template="/_include/carregando.cfm" />
<script src="/_scripts/dragdrop.js" type="text/javascript"></script>
<script src="/_scripts/dragdrop/drag.js" type="text/javascript"></script>
<cfscript>
	conn = CreateComponent("modulos.cte._componentes.consulta.cfc_global");
	v_modulo_cte = conn.get_parametro_valor(cod_projeto = 25,
											cod_aplicacao = 'SEFAZ.EXE',
											parametro_id = 3,
											parametro_grupo_id = 42);

	v_util_tipo_conhecimento = conn.get_parametro_valor(cod_projeto = 25,
														cod_aplicacao = 'FISCAL.EXE',
														parametro_id = 466,
														parametro_grupo_id = 8);
	
	v_permite_cancelamento = conn.get_parametro_valor(cod_projeto = 25,
													  cod_aplicacao = 'FISCAL.EXE',
													  parametro_id = 509,
													  parametro_grupo_id = 8);
												 
	v_usuarios_cancelamento = conn.get_parametro_valor(cod_projeto = 25,
													   cod_aplicacao = 'FISCAL.EXE',
													   parametro_id = 510,
													   parametro_grupo_id = 8);
													   
	v_usuarios_desvinculo = conn.get_parametro_valor(  cod_projeto = 25,
													   cod_aplicacao = 'FISCAL.EXE',
													   parametro_id = 708,
													   parametro_grupo_id = 8);
													   
	v_grupo_cte = 40;
													   
	v_tipo_conhecimento_cadastro = conn.get_parametro_valor(25, 'FISCAL.EXE', v_grupo_cte, 9);
	
	conn = CreateComponent("_transportes.consulta.cfc_acesso");
	administrador = false;
	qrModulo = conn.get_modulo_usuario(usuario = session.usuario, modulo_id = v_modulo_cte);
	if(qrmodulo.nivel_acesso gt 3) {
		administrador = true;
	}
	
	if(administrador or vars.SOMENTE_FILIAL eq 0){
		vars.cod_pessoa = '';
	}else{
		vars.cod_pessoa = session.cod_pessoa;
	}
	
	if(IsDefined("session.cod_pessoa") and Len(Trim(session.cod_pessoa))){
		vars.cod_pessoa = #session.cod_pessoa#;
	}
	
	if(IsDefined("vars.cod_pessoa_filial")){
		vars.cod_pessoa = #vars.cod_pessoa_filial#;
	}
	
	if(!IsDefined("vars.web_url")){
	   vars.web_url = '/modulos/cte/cte_lista/principal.cfm';
	}
	
	conn = CreateComponent("_transportes.consulta.cfc_emissao_documentos");
	qrSerie = conn.get_serie(cod_modelo = '57', todas = 1);
	
	if ( v_util_tipo_conhecimento == 1)
		qrConhecimentoTipo = conn.get_conhecimento_tipo();
	
	conn = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
	qrConhecimentos = conn.get_CTE_LISTA(cod_pessoa_filial = vars.cod_pessoa, argumentCollection = vars);
	qrAmbienteEmissao = conn.get_ambiente_emissao();
	qrFilial  	= conn.get_filial_usuario();
	
	
	conn = CreateComponent("modulos.cte._componentes.consulta.cfc_funcionario");
	qrCentroCusto = conn.get_organograma();
</cfscript>



<cfscript>
    v_possui_acao_mdfe_encerrar = 0;
    v_possui_acao_mdfe_cancelar = 0;
	v_possui_acao_todas_filiais = 0;

    conn = CreateComponent("modulos.cte._componentes.consulta.cfc_acesso");
    qrAcaoUsuario = conn.get_acao_usuario(web_url = vars.web_url);
</cfscript>

<cfloop query="qrAcaoUsuario">
	<cfscript>
		if(qrAcaoUsuario.COD_ACAO eq 'DACTE_MDFE_ENCERRAR' and v_possui_acao_mdfe_encerrar eq 0) {
			v_possui_acao_mdfe_encerrar = 1;
		}
		if(qrAcaoUsuario.COD_ACAO eq 'DACTE_MDFE_CANCELAR' and v_possui_acao_mdfe_cancelar eq 0) {
			v_possui_acao_mdfe_cancelar = 1;
		}
		
		if(qrAcaoUsuario.COD_ACAO eq 'DACTE_TODAS_FILIAIS' and v_possui_acao_todas_filiais eq 0) {
			v_possui_acao_todas_filiais = 1;
			administrador = true;
		}

	</cfscript>
</cfloop>

<script type="text/javascript">
	// Configura botoes //
	parent.f_set_texto('titulo_aplicacao', 'Controle de Documentos');
	parent.f_set_texto('titulo_pagina', 'Lista de Conhecimento de Transporte Eletrnico');

	parent.document.getElementById('btn_voltar').onclick = function() { window.open('/aplicacoes.cfm?menu_inicial=<cfoutput>#session.ultimo_menu_inicial#</cfoutput>','_parent',''); } 
	
	parent.f_hidden('btn_incluir');
	parent.f_hidden('btn_editar');
	parent.f_hidden('btn_excluir');
	parent.f_hidden('btn_cancelar');
	f_habilitar_botao('confirmar', 'f_confirmar()');
	
	/*Criao dos botes de Exportao de Documentos*/
	f_cria_botao('download_xml','Exportar XMLs',"f_exportar_documentos('XML');", parent.document.getElementById('barra_botoes_top'));
	f_cria_botao('download_pdf','Exportar DACTEs',"f_exportar_documentos('PDF');", parent.document.getElementById('barra_botoes_top'));
	// -------------------- //
	
	var v_centro_custo = [];
	<cfoutput query="qrCentroCusto">
		v_centro_custo.push( {
			cod_pessoa: 	  '#qrCentroCusto.COD_PESSOA#',
			cod_centro_custo: '#qrCentroCusto.COD_CENTRO_CUSTO#',
			centro_custo: 	  '#JSStringFormat(qrCentroCusto.CENTRO_CUSTO)#',
			cod_organograma:  '#qrCentroCusto.COD_ORGANOGRAMA#'
		} );
	</cfoutput>
	
	function f_confirmar() {
		with(document.forms[0]) {
			if (NUM_CTE.value != ''){
				document.getElementById('DATA_INICIO').setAttribute('obrigatorio',0);
				document.getElementById('DATA_TERMINO').setAttribute('obrigatorio',0);
			}else{
				document.getElementById('DATA_INICIO').setAttribute('obrigatorio',1);
				document.getElementById('DATA_TERMINO').setAttribute('obrigatorio',1);
			}
			
			if(SEL_TODOS.getAttribute('checked')) {
				SITUACAO_ID.value = "";
			}
			
			target = '_self';
			action = 'principal.cfm';		
			if(f_verifica_form(document.forms[0])) {
				
				if(Number(DATA_TERMINO.value.getDateTime()) < Number(DATA_INICIO.value.getDateTime())) {
					alert('A data de trmino no pode ser maior que a data inicial.');
					DATA_TERMINO.select();
					return false;
				}
				
				submit();
			}
		}
		return false;
	}
	parent.f_confirmar = f_confirmar;
	
	function f_atualizar_status(p_conhecimento_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 1;
				CONHECIMENTO_ID.value = p_conhecimento_id;
				target = 'consultas';
				action = 'confirma.cfm';
				CONFIRMA.value = 0;	
				submit();
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}

	function f_reenviar_cte(p_conhecimento_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 2;
				CONHECIMENTO_ID.value = p_conhecimento_id;
				target = 'consultas';
				action = 'confirma.cfm';		
				CONFIRMA.value = 0;	
				submit();		
			} else { alert('Operao em processamento. Aguarde...'); }	
		}
		return false;
	}
	
	function f_cancelar(p_conhecimento_id) {
		f_abrir_janela('/modulos/cte/emitir/cancelar.cfm?conhecimento_id='+p_conhecimento_id, 'f_atualizar()','600', '200');
	}
	
	function f_imprimir_dacte(p_documento_id, p_num_cte, p_placa) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				CONSULTA.value = 99;
				DOCUMENTO_ID.value = p_documento_id;
				NOME_ARQUIVO.value = 'DACTE_'+p_num_cte+'_PLACA_'+p_placa;
				target = 'consultas';
				action = 'consultas.cfm';
				CONFIRMA.value = 0;
				submit();
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}

    function f_imprimir_documentos_viagem(p_documento_id, p_num_cte, p_placa){
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 22;
				DOCUMENTO_ID.value = p_documento_id;
				NOME_ARQUIVO.value = 'DACTE_'+p_num_cte+'_PLACA_'+p_placa;
				target = 'consultas';
				action = 'salvar.cfm';
				CONFIRMA.value = 0;
				submit();			
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}
	
	function f_imprimir_cce(p_conhecimento_id, p_num_cte) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				CONSULTA.value = 100;
				CONHECIMENTO_ID.value = p_conhecimento_id;
				NOME_ARQUIVO.value = 'CCE_'+p_num_cte;
				target = 'consultas';
				action = 'consultas.cfm';
				CONFIRMA.value = 0;
				submit();			
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}	
	
	function f_imprimir_declaracao(p_documento_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 18;
				DOCUMENTO_ID.value = p_documento_id;
				target = 'consultas';
				action = 'confirma.cfm';
				CONFIRMA.value = 0;
				submit();			
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}
	
	function f_imprimir_vale_pedagio(p_num_comprovante, p_num_romaneio) {
		with(document.forms[0]) {
			if(p_num_romaneio){
				if (Number(CONFIRMA.value) == 1) {
					OPERACAO.value = 19;
					VP_NUM_COMPROVANTE.value = p_num_comprovante;
					VP_NUM_ROMANEIO.value = p_num_romaneio;
					target = 'consultas';
					action = 'confirma.cfm';
					CONFIRMA.value = 0;
					submit();
				} else { alert('Operao em processamento. Aguarde...'); }				
			}else{
				alert('O CT-e no possui romaneio vinculado. No  possvel imprimir o comprovante do vale pedgio.');
			}			
		}
		return false;
	}
	
	function f_inutilizar_cte(p_conhecimento_id) {
		f_abrir_janela('/modulos/cte/emitir/inutilizar.cfm?conhecimento_id='+p_conhecimento_id, 'f_atualizar()','600', '200');
	}
	
	function f_consultar_chave(p_conhecimento_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 8;
				CONHECIMENTO_ID.value = p_conhecimento_id;
				target = 'consultas';
				action = 'confirma.cfm';
				CONFIRMA.value = 0;				
				submit();	
			} else { alert('Operao em processamento. Aguarde...'); }			
		}
		return false;
	}
	
	function f_muda_check_sel_todos(p_value) {
		with(document.forms[0]) {
			var v_checked = true;
			
			if(p_value) {
				for(var i = 2; i <= 6; i++) {
					if(!document.getElementById('SITUACAO_ID_' + i).getAttribute('checked')) {
						v_checked = false;
					}
				}
			}
			
			SEL_TODOS.setAttribute('checked',v_checked);
		}
	}
	
	function f_seleciona_todos() {
		with(document.forms[0]) {
			if(SEL_TODOS.checked) {
				for(var i = 2; i <= 6; i++) {
					document.getElementById('SITUACAO_ID_' + i).setAttribute('checked',true);
				}
			}
			else {
				for(var i = 2; i <= 6; i++) {
					document.getElementById('SITUACAO_ID_' + i).setAttribute('checked',false);
				}
			}
		}
	}
	
	function f_enviar_email() {
		with(document.forms[0]) {
			if(EMAIL.value){
				target = 'consultas';
				action = 'confirma.cfm';			
				
				<cfif v_util_tipo_conhecimento eq 1>
					CONHECIMENTO_TIPO_ID.setAttribute('obrigatorio',0);
				</cfif>
				
				if(f_verifica_form(document.forms[0])) {
					submit();					
				}
				
				
			}else{
				alert('O campo EMAIL deve ser preenchido com um e-mail vlido.');
			}
		}
		return false;
	}
	
	function f_mostrar_div(p_conhecimento_id, p_documento_id, p_tipo, p_email) {
		with(document.forms[0]) {
			OPERACAO.value = 5;
			CONHECIMENTO_ID.value = p_conhecimento_id;
			DOCUMENTO_ID.value = p_documento_id;
			TIPO_EMAIL.value = p_tipo;
		}
		
		var v_tipo = '';
		f_ocultar_div();
		
		obj = document.getElementById('div_manipulacao');
		f_get_scroll();
		
		switch(p_tipo) {
			case 1: 
				v_tipo = 'Remetente';
				break;
			case 2: 
				v_tipo = 'Destinatrio';
				break;
			case 3: 
				v_tipo = 'Expedidor';
				break;
			case 4: 
				v_tipo = 'Recebedor';
				break;
			case 5: 
				v_tipo = 'Tomador do Servio';
				break;
         case 6: 
				v_tipo = 'Proprietrio';
				break;
         case 7: 
				v_tipo = 'Emissor';
				break;
         case 7: 
				v_tipo = 'Transportador terceirizado';
				break;
		}		
		
		document.getElementById('lb_manipulacao').innerHTML = 'Enviar E-mail para o ' + v_tipo;
		
		if(obj.style.display == 'none') {
			
			document.getElementById('EMAIL').value = p_email;
			setTimeout("document.getElementById('div_manipulacao').style.display = '';", 100);
			obj.style.top  = 10 + window.event.clientY + scrOfY;
			obj.style.left = 10 + window.event.clientX +scrOfX;			
		}
	}
	
	function f_ocultar_div() {
		document.getElementById('div_manipulacao').style.display = 'none';
		
		document.getElementById('lb_manipulacao').innerHTML = '';
		document.getElementById('EMAIL').value = '';
	}
	
	function f_liberar_impressao(p_conhecimento_id) {
		with(document.forms[0]) {
			OPERACAO.value = 7;
			CONHECIMENTO_ID.value = p_conhecimento_id;
			target = 'consultas';
			action = 'confirma.cfm';
			if(confirm('Clique OK para liberar o CTe para impresso.')) {
				submit();
			}
		}
		return false;
	}
	
	function f_editar(p_conhecimento_id) {
		with(document.forms[0]) {
			CONHECIMENTO_ID.value = p_conhecimento_id;
			f_abrir_janela('/modulos/cte/emitir/principal.cfm?aberto=1&conhecimento_id=' + CONHECIMENTO_ID.value, 'f_atualizar()', 800, 600, true);
		}
	}

	function f_busca_centro_custo() {
		with(document.forms[0]) {
			f_limpa_select(COD_CENTRO_CUSTO);
			if(!COD_PESSOA_FILIAL.value) {
				v_option = f_cria_option('', '-- Selecione a Unidade de Negcio --', COD_CENTRO_CUSTO);
				v_option.setAttribute('cod_organograma', '');
				v_option.setAttribute('cod_pessoa', '');
				return;
			}
			
			v_option = f_cria_option('', '-- Selecione --', COD_CENTRO_CUSTO);
			v_option.setAttribute('cod_organograma', '');
			v_option.setAttribute('cod_pessoa', '');
			
			for(var i = 0; i < v_centro_custo.length; i++) {
				if(v_centro_custo[i].cod_pessoa == COD_PESSOA_FILIAL.value) {
					v_option = f_cria_option(v_centro_custo[i].cod_centro_custo, v_centro_custo[i].centro_custo, COD_CENTRO_CUSTO);			
				}
			}
			
			if(COD_CENTRO_CUSTO.options.length == 2) {
				COD_CENTRO_CUSTO.options[0] = null;
				COD_CENTRO_CUSTO.options[0].setAttribute('selected',true);
			}
		}
	}
	
	function f_busca_pessoa(p_param) {
		with(document.forms[0]) {
			var v_filtro;
			switch(p_param) {
				case 'REMETENTE':
					NOME_REMETENTE.value = '';
					COD_REMETENTE.value = '';
					if(!CNPJ_CPF_REMETENTE.value) {
						return;
					}
					NOME_REMETENTE.value = 'Buscando remetente...';
					v_filtro = 'num_modalidade=9,5,13,15&cnpj_cpf=' + CNPJ_CPF_REMETENTE.value;
					break;
				case 'DESTINATARIO':
					NOME_DESTINATARIO.value = '';
					COD_DESTINATARIO.value = '';
					if(!CNPJ_CPF_DESTINATARIO.value) {
						return;
					}
					NOME_DESTINATARIO.value = 'Buscando destinatrio...';
					v_filtro = 'num_modalidade=9,5,13,15&cnpj_cpf=' + CNPJ_CPF_DESTINATARIO.value;
					break;
				case 'CLIENTE_COBRANCA':
					NOME_CLIENTE_COBRANCA.value = '';
					COD_CLIENTE_COBRANCA.value = '';
					if(!CNPJ_CPF_CLIENTE_COBRANCA.value) {
						return;
					}
					NOME_CLIENTE_COBRANCA.value = 'Buscando cliente cobrana...';
					v_filtro = 'num_modalidade=9,5,13,15&cnpj_cpf=' + CNPJ_CPF_CLIENTE_COBRANCA.value;
					break;
			}
			f_query_wddx('/modulos/cte/_componentes/consulta/cfc_pessoa.cfc?method=getPessoa'
						,'completo=1&'+v_filtro
						,function(obj) {
							if(obj.ajax.readyState == 4 && obj.ajax.status == 200) {
								if(obj.struct.cod_pessoa.length > 0) {
									switch(p_param) {
										case 'REMETENTE':
											NOME_REMETENTE.value = obj.struct.razao_social[0];
											COD_REMETENTE.value = obj.struct.cod_pessoa[0];
											break;
										case 'DESTINATARIO':
											NOME_DESTINATARIO.value = obj.struct.razao_social[0];
											COD_DESTINATARIO.value = obj.struct.cod_pessoa[0];
											break;
										case 'CLIENTE_COBRANCA':
											NOME_CLIENTE_COBRANCA.value = obj.struct.razao_social[0];
											COD_CLIENTE_COBRANCA.value = obj.struct.cod_pessoa[0];
											break;
									}
								}
								else {
									switch(p_param) {
										case 'REMETENTE':
											NOME_REMETENTE.value = 'Remetente no encontrado.';
											break;
										case 'DESTINATARIO':
											NOME_DESTINATARIO.value = 'Destinatrio no encontrado.';
											break;
										case 'CLIENTE_COBRANCA':
											NOME_CLIENTE_COBRANCA.value = 'Cliente cobrana no encontrado.';
											break;
									}
								}
							}
						});
		}
	}
	
	function f_mostrar_div_visualizacao(p_opcao, p_documento_id) {
		f_ocultar_div_visualizacao();
		
		obj = document.getElementById('div_visualizacao');
		f_get_scroll();
		
		if(obj.style.display == 'none') {
			setTimeout("document.getElementById('div_visualizacao').style.display = '';", 100);
			obj.style.top = window.event.clientY + scrOfY;
			if(p_opcao == 1)
				obj.style.left = window.event.clientX + scrOfX;
			else
				obj.style.left = window.event.clientX-300+scrOfX;
		}
		
		if(!p_opcao || p_opcao == '' || !p_documento_id || p_documento_id == '') {
			return;
		}
		
		if(p_opcao == 1) {
			document.getElementById('lb_cabecalho').innerHTML = 'XML de Envio CT-e';
		}
		
		if(p_opcao == 2) {
			document.getElementById('lb_cabecalho').innerHTML = 'XML de Envio MDF-e';
			p_opcao = 1;
		}		
		
		f_buscar_dados(p_opcao, p_documento_id);
	}
	
	function f_ocultar_div_visualizacao() {
		with(document.forms[0]) {
			document.getElementById('div_visualizacao').style.display = 'none';
			VISUALIZACAO.value = '';
		}
	}
	
	function f_buscar_dados(p_opcao, p_documento_id) {
		with(document.forms[0]) {
			document.getElementById('sp_carregando').style.display = '';
			CONSULTA.value 	    = p_opcao;
			DOCUMENTO_ID.value  = p_documento_id;
			target = 'consultas';
			action = 'consultas.cfm';
			submit();
		}
	}
	
	function f_desvincular_cte_romaneio(p_conhecimento_id){
		<cfif listfind(v_usuarios_desvinculo,uCase(session.usuario)) >
			with(document.forms[0]) {
				CONHECIMENTO_ID.value  = p_conhecimento_id;
				OPERACAO.value = 9;
				target = 'consultas';
				action = 'confirma.cfm';
				if(confirm('Clique OK para desvincular o CTe do romaneio.')) {
					submit();
				}
			}
		</cfif>
	}
	
	function f_selecionar_todos_documentos(){
		v_checked = document.getElementById('SELECIONAR_TODOS').getAttribute('checked');
		var v_documentos = document.forms[0].elements["LISTA_DOCUMENTO_ID"];
		
		<cfif qrConhecimentos.Recordcount gt 1>		
			for(var i = 0; i < v_documentos.length; i++) {
				v_documentos[i].setAttribute('checked',v_checked);
			}
		<cfelse>
		   document.getElementById(v_documentos.id).setAttribute('checked',v_checked);
		</cfif>
		
	}
	
	function f_verifica_documentos_selecionados(){
                with(document.forms[0]) {
                        var v_documentos = document.forms[0].elements["LISTA_DOCUMENTO_ID"];

                        <cfif qrConhecimentos.Recordcount gt 1>
                        if(v_documentos == undefined){
                                return 0;
                        }

                        if (v_documentos.length == undefined) {
                                if(v_documentos.getAttribute('checked') ){
                                        return 1;
                                }
                        } else {
                                for(var i = 0; i < v_documentos.length; i++) {
                                        if(v_documentos[i].getAttribute('checked') ){
                                                return 1;
                                        }
                                }
                        }
                        <cfelse>
                           if(document.getElementById(v_documentos.id).getAttribute('checked')){
                                   return 1;
                           }
                        </cfif>

                        return 0;

                }
        }

	
	function f_exportar_documentos(p_tipo){
		with(document.forms[0]) {
			if(f_verifica_documentos_selecionados() == 0){
				alert(" necessrio selecionar ao menos um documento para exportar os CTe's.");
				return;
			}
			
			TIPO.value = p_tipo;
			OPERACAO.value = 1;
			method = 'post';
			target = 'consultas';
			action = 'exportar.cfm';			
			submit();
			
			return false;
		}
	}	
	
	function f_imprimir_damdfe(p_mdfe_id, p_conhecimento_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 10;
				MDFE_ID.value = p_mdfe_id;
				CONHECIMENTO_ID.value = p_conhecimento_id;
				target = 'consultas';
				action = 'confirma.cfm';			
				CONFIRMA.value = 0;
				submit();			
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}		
	
	function f_atualizar_status_mdfe(p_mdfe_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 11;
				MDFE_ID.value = p_mdfe_id;
				target = 'consultas';
				action = 'confirma.cfm';
				CONFIRMA.value = 0;	
				submit();
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}

	function f_reenviar_mdfe(p_mdfe_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 12;
				MDFE_ID.value = p_mdfe_id;
				target = 'consultas';
				action = 'confirma.cfm';	
				CONFIRMA.value = 0;		
				submit();	
			} else { alert('Operao em processamento. Aguarde...'); }		
		}
		return false;
	}

	function f_reenviar_mdfe2(p_mdfe_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 12;
				MDFE_ID.value = p_mdfe_id;
				target = 'consultas';
				action = 'confirma.cfm';
				CONFIRMA.value = 0;
				submit();
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}

	function f_consultar_chave_mdfe(p_mdfe_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 13;
				MDFE_ID.value = p_mdfe_id;
				target = 'consultas';
				action = 'confirma.cfm';	
				CONFIRMA.value = 0;		
				submit();	
			} else { alert('Operao em processamento. Aguarde...'); }				
		}
		return false;
	}
	
	function f_encerrar_mdfe(p_mdfe_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 14;
				MDFE_ID.value = p_mdfe_id;
				target = 'consultas';
				action = 'confirma.cfm';
				CONFIRMA.value = 0;
				if(confirm('Para confirmar o encerramento do MDF-e clique em OK.')) {
					submit();
				}
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}
	
	function f_cancelar_mdfe(p_mdfe_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 15;
				MDFE_ID.value = p_mdfe_id;
				target = 'consultas';
				action = 'confirma.cfm';
				CONFIRMA.value = 0;				
				if(confirm('Para confirmar o Cancelamento do MDF-e clique em OK.')) {
					submit();
				}
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}	
	
	function f_emitir_mdfe(p_num_romaneio, p_uf_origem, p_uf_destino, p_carga_consolidada_id, p_conhecimento_id){
		with(document.forms[0]) {
			f_abrir_janela('/modulos/cte/cte_lista/mdfe.cfm?NUM_ROMANEIO='+p_num_romaneio +'&UF_ORIGEM=' + p_uf_origem + '&UF_DESTINO=' + p_uf_destino + '&CARGA_CONSOLIDADA_ID=' + p_carga_consolidada_id + '&CONHECIMENTO_ID=' + p_conhecimento_id, 'f_atualizar()','600', '200');
		}
		return false;		
	}
	
	function f_excluir_mdfe(p_mdfe_id) {
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 17;
				MDFE_ID.value = p_mdfe_id;
				target = 'consultas';
				action = 'confirma.cfm';
				CONFIRMA.value = 0;				
				if(confirm('Para confirmar a Excluso do MDF-e clique em OK.')) {
					submit();
				}
			} else { alert('Operao em processamento. Aguarde...'); }
		}
		return false;
	}
	
	function f_inserir_mdfe_obr(p_num_romaneio, p_uf_origem, p_uf_destino, p_carga_consolidada_id, p_conhecimento_id){				
		with(document.forms[0]) {
			OPERACAO.value = 16;
		    NUM_ROMANEIO.value = p_num_romaneio;
			UF_ORIGEM.value = p_uf_origem;
			UF_DESTINO.value = p_uf_destino;
			CARGA_CONSOLIDADA_ID.value = p_carga_consolidada_id;
			CONHECIMENTO_ID.value = p_conhecimento_id;
			
			
			target = 'consultas';
			action = 'confirma.cfm';		
			
			submit();
		}
	}

	function f_inutilizar_mdfe(p_mdfe_id){
		with(document.forms[0]) {
			if (Number(CONFIRMA.value) == 1) {
				OPERACAO.value = 20;
				MDFE_ID.value = p_mdfe_id;
				
				target = 'consultas';
				action = 'confirma.cfm';
				CONFIRMA.value = 0;
				if(confirm('Para confirmar a Inutilizao do MDF-e clique em OK.')) {
					submit();
				}
			} else { alert('Operao em processamento. Aguarde...'); }OPERACAO.value = 20;
		}

	}
	
	function f_enviar_ev_pag_oper_transp_mdfe(p_mdfe_id){
		with(document.forms[0]) {
			OPERACAO.value = 23;
			MDFE_ID.value = p_mdfe_id;
			
			target = 'consultas';
			action = 'confirma.cfm';
			if(confirm('Para confirmar o envio do evento de pagamento de operao de transporte para o MDF-e clique em OK.')) {
				submit();
			}
		}

	}

</script>
<style>
	.linha_2, .linha1{
		height: 25px;
	}
	
	div.opcao{
	   width:16px !important;
	   height: 16px !important;
	   display:inline;
	   margin:1px;
	   vertical-align:middle;
	}
	div.opcao button, div.opcao img{
		margin-left:0px !important;
		padding:0px !important;
	}
	.opcao button{
		margin:1px !important;
		padding:0px !important;
	}
	div.opcao button img, div.opcao img{
		width:16px;
		margin:1px !important;
		height:16px;
	}	
	div.opcao img{
		margin:2px !important;
		margin-left:3px !important;
	}	
	.encerrado{
		background:#030;
		color:#fff;
	}
	
	@media screen and (-ms-high-contrast: active), (-ms-high-contrast: none) {  
	   /* CSS especifico para o IE10 aqui */
	   input[type=radio], input[type=checkbox]{
			height:17px !important;
			width:17px !important;	
		}
	}
</style>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>..: KM&amp;M :..</title>
<link href="<cf_url>/_estilos/class.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="<cf_url>/_estilos/tags.css</cf_url>" rel="stylesheet" type="text/css" />
<link href="/_estilos/tarefa_status.css" rel="stylesheet" type="text/css" />
</head>
<body class="background" style="height: 100%;">
<form id="form_transportes" name="form_transportes" method="get" action="" onSubmit="return f_confirmar()">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
        <input name="OPERACAO" id="OPERACAO" type="hidden" value="" sempre_ativo="1" />
        <input name="CONSULTA" id="CONSULTA" type="hidden" value="" sempre_ativo="1" />
		<input name="CONFIRMA" type="hidden" value="1" fixo="1">
        <input name="CONHECIMENTO_ID" id="CONHECIMENTO_ID" type="hidden" value="" sempre_ativo="1" />
        <input name="MDFE_ID" id="MDFE_ID" type="hidden" value="" sempre_ativo="1" />        
        <input name="NUM_ROMANEIO" id="NUM_ROMANEIO" type="hidden" value="" sempre_ativo="1" />
        <input name="UF_ORIGEM" id="UF_ORIGEM" type="hidden" value="" sempre_ativo="1" />
        <input name="UF_DESTINO" id="UF_DESTINO" type="hidden" value="" sempre_ativo="1" />                
        <input name="DOCUMENTO_ID" id="DOCUMENTO_ID" type="hidden" value="" sempre_ativo="1" />
        <input name="CARGA_CONSOLIDADA_ID" id="CARGA_CONSOLIDADA_ID" type="hidden" value="" sempre_ativo="1" />        
        <input name="TIPO_EMAIL" id="TIPO_EMAIL" type="hidden" value="" sempre_ativo="1" />
        <input name="SOMENTE_FILIAL" id="SOMENTE_FILIAL" type="hidden" value="<cfoutput>#vars.SOMENTE_FILIAL#</cfoutput>" sempre_ativo="1" />
        <input name="TIPO" id="TIPO" type="hidden" value="" sempre_ativo="1" />
        <input name="NOME_ARQUIVO" id="NOME_ARQUIVO" type="hidden" value="" sempre_ativo="1" />
        <input name="VP_NUM_COMPROVANTE" id="VP_NUM_COMPROVANTE" type="hidden" value="" sempre_ativo="1" />
        <input name="VP_NUM_ROMANEIO" id="VP_NUM_ROMANEIO" type="hidden" value="" sempre_ativo="1" />
        <input name="OBS_MDFE" id="OBS_MDFE" type="hidden" value="" sempre_ativo="1" />
		<input name="DATA_EMISSAO" id="DATA_EMISSAO" type="hidden" tipo="data" sempre_ativo="1" />
        <input name="AUTORIZA_MDFE" type="hidden" value="1" sempre_ativo="1" fixo="1">
		<tr>
			<td>
                <fieldset><legend>Par&acirc;metros</legend>
                <table width="100%" border="0" cellspacing="0" cellpadding="3">
                	<tr>
                        <td nowrap class="texto" width="5%">Per&iacute;odo:</td>
                        <td class="texto" align="left" width="95%"><input type="text" name="DATA_INICIO" id="DATA_INICIO" maxlength="10" tipo="data" display="PERODO" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" obrigatorio="1"/>
							<button type="button" id="BTN_DATA_INICIO" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
                            &nbsp;at&eacute;
                            <input type="text" name="DATA_TERMINO" id="DATA_TERMINO" maxlength="10" tipo="data" display="PERODO" onKeyPress="return f_formata(this, '00/00/0000')" style="width: 80px;" obrigatorio="1"/>
							<button type="button" id="BTN_DATA_TERMINO" class="botao-16x16"><img src="/_imagens/botoes/16x16/calendario.gif" alt="Data" title="Data" width="16" height="16" align="absmiddle" /></button>
                            <script type="text/javascript"> 
								Calendar.setup( {
									inputField  : "DATA_INICIO",      // ID of the input field
									ifFormat    : "%d/%m/%Y",         // the date format
									button      : "BTN_DATA_INICIO",  // ID of the button
									range       : [2001,2050]
								} );
                            
								Calendar.setup( {
									inputField  : "DATA_TERMINO",      // ID of the input field
									ifFormat    : "%d/%m/%Y",         // the date format
									button      : "BTN_DATA_TERMINO",  // ID of the button
									range       : [2001,2050]
								} );
                            </script>
                        </td>
                    </tr>
                    <tr>
                        <td nowrap class="texto" width="5%">DACTE Impresso:</td>
                        <td class="texto" align="left" width="95%"><select name="DACTE_IMPRESSO" id="DACTE_IMPRESSO" display="DACTE IMPRESSO">
                                                                        <option value="0">N&atilde;o</option>
                                                                        <option value="1">Sim</option>
                                                                        <option value="" selected>Ambos</option>
                                                                   </select></td>
                    </tr>                 
                    <tr>
                        <td nowrap class="texto" width="5%">N&ordm; CTE:</td>
                        <td class="texto" align="left" width="95%"><input type="text" name="NUM_CTE" id="NUM_CTE" display="NUM. CTE" tipo="numerico" onKeyPress="return f_formata(this, '000000000000')"/></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto" width="5%">S&eacute;rie:</td>
                        <td class="texto" align="left" width="95%"><select name="SERIE" id="SERIE" obrigatorio="0" display="SRIE" style="width: 110px; height:60px;" multiple>
																	   <option value="" <cfif not IsDefined("vars.SERIE") or #vars.SERIE# eq ''>selected</cfif>>Todas</option>
                                                                       <cfoutput query="qrSerie">
                                                                       	<option value="#qrSerie.SERIE#" <cfif IsDefined("vars.SERIE") and ListFind(#vars.SERIE#,'#qrSerie.SERIE#') >selected</cfif>>#qrSerie.SERIE#</option>
                                                                       </cfoutput>
                                                                   </select></td>
                    </tr>
                    <tr>
                        <td nowrap class="texto" width="5%">N&ordm; Romaneio:</td>
                        <td class="texto" align="left" width="95%"><input type="text" name="NUM_ROMANEIO_FILTRO" id="NUM_ROMANEIO_FILTRO" display="NUM. ROMANEIO" tipo="numerico" onKeyPress="return f_formata(this, '000000000000')"/></td>
                    </tr>                       
                    <tr>
                        <td nowrap class="texto" width="5%">N&ordm; MDF-e:</td>
                        <td class="texto" align="left" width="95%"><input type="text" name="NUM_MDFE" id="NUM_MDFE" display="NUM. MDF-E" tipo="numerico" onKeyPress="return f_formata(this, '000000000000')"/></td>
                    </tr>                     
                    <cfif v_util_tipo_conhecimento eq 1>
                    <tr>
                        <td class="texto">Tipo:</td>
                        <td height="1" colspan="3">
                            <select name="CONHECIMENTO_TIPO_ID" id="CONHECIMENTO_TIPO_ID" obrigatorio="0" display="TIPO">
                                <option value="">-- Selecione --</option>
                                <cfoutput query="qrConhecimentoTipo">
                                    <option value="#qrConhecimentoTipo.CONHECIMENTO_TIPO_ID#" <cfif isDefined("vars.conhecimento_tipo_id") and qrConhecimentoTipo.CONHECIMENTO_TIPO_ID eq vars.conhecimento_tipo_id> selected </cfif> >#qrConhecimentoTipo.DESCRICAO#</option>
                                </cfoutput>
                            </select>
                        </td>
                    </tr>
                    </cfif>
					<cfif administrador or vars.SOMENTE_FILIAL eq 0>
                    <tr>
                        <td class="texto" nowrap><nobr>Unidade Neg&oacute;cio:</nobr></td>
                        <td class="texto"><select name="COD_PESSOA_FILIAL" id="COD_PESSOA_FILIAL" display="UNIDADE DE NEGCIO" style="width: 400px;" onChange="f_busca_centro_custo()">
                                              <option value="">-- Selecione a Unidade de Negcio --</option>
                                                  <cfoutput query="qrFilial">
                                                    <option value="#qrFilial.COD_PESSOA#">#qrFilial.NOME#</option>
                                                  </cfoutput>
                                          </select>
                        </td>
                    </tr>
                    <tr>
                        <td width="1%" nowrap class="texto">Centro de Custo:</td>
                        <td width="99%" class="texto"><select name="COD_CENTRO_CUSTO" id="COD_CENTRO_CUSTO" display="CENTRO DE CUSTO" style="width: 250px;">
                        	<option value="" cod_pessoa="">-- Selecione a Unidade de Negcio --</option>
                        	</select></td>
                    </tr>
                    <cfelse>
                    	<input name="COD_PESSOA_FILIAL" type="hidden" id="COD_PESSOA_FILIAL" value="<cfoutput>#session.cod_pessoa#</cfoutput>" />
                        <input name="COD_CENTRO_CUSTO" type="hidden" id="COD_CENTRO_CUSTO" value="<cfoutput>#session.cod_centro_custo#</cfoutput>" />
                    </cfif>
                    <tr>
                        <td width="1%" nowrap class="texto">Remetente:</td>
                        <td width="99%" class="texto"><input type="text" name="CNPJ_CPF_REMETENTE" id="CNPJ_CPF_REMETENTE" maxlength="40" display="REMETENTE" onChange="f_busca_pessoa('REMETENTE')" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 130px;" />
                            <input type="text" name="NOME_REMETENTE" id="NOME_REMETENTE" readonly display="REMETENTE" style="width: 315px;" />
                            <input type="hidden" name="COD_REMETENTE" id="COD_REMETENTE" display="REMETENTE" />
                            <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?funcao=f_busca_pessoa(\'REMETENTE\')&campo=CNPJ_CPF_REMETENTE&num_modalidade=9,5,13,15','_blank',800,600,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Remetente" title="Buscar Remetente" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                        <td width="1%" nowrap class="texto">Destinat&aacute;rio:</td>
                        <td width="99%" class="texto"><input type="text" name="CNPJ_CPF_DESTINATARIO" id="CNPJ_CPF_DESTINATARIO" maxlength="40" display="DESTINATRIO" onChange="f_busca_pessoa('DESTINATARIO')" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 130px;" />
                            <input type="text" name="NOME_DESTINATARIO" id="NOME_DESTINATARIO" readonly display="DESTINATRIO" style="width: 315px;" />
                            <input type="hidden" name="COD_DESTINATARIO" id="COD_DESTINATARIO" display="DESTINATRIO" />
                            <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?funcao=f_busca_pessoa(\'DESTINATARIO\')&campo=CNPJ_CPF_DESTINATARIO&num_modalidade=9,5,13,15','_blank',800,600,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Destinat&aacute;rio" title="Buscar Destinat&aacute;rio" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                        <td width="1%" nowrap class="texto">Tomador do Servi&ccedil;o:</td>
                        <td width="99%" class="texto"><input type="text" name="CNPJ_CPF_CLIENTE_COBRANCA" id="CNPJ_CPF_CLIENTE_COBRANCA" maxlength="40" display="CLIENTE COBRANA" onChange="f_busca_pessoa('CLIENTE_COBRANCA')" onKeyPress="return f_formata_numero_decimal(this, event)" style="width: 130px;" />
                            <input type="text" name="NOME_CLIENTE_COBRANCA" id="NOME_CLIENTE_COBRANCA" readonly display="CLIENTE COBRANA" style="width: 315px;" />
                            <input type="hidden" name="COD_CLIENTE_COBRANCA" id="COD_CLIENTE_COBRANCA" display="CLIENTE COBRANA" />
                            <button type="button" class="botao-16x16" onClick="NewWindow('/_consultas/localizar_pessoa.cfm?funcao=f_busca_pessoa(\'CLIENTE_COBRANCA\')&campo=CNPJ_CPF_CLIENTE_COBRANCA&num_modalidade=9,5,13,15','_blank',800,600,'yes')"><img src="/_imagens/botoes/16x16/buscar.gif" alt="Buscar Cliente Cobrana" title="Buscar Cliente Cobrana" width="16" height="16" align="absmiddle" /></button></td>
                    </tr>
                    <tr>
                      <td nowrap class="texto">Num. Fatura:</td>
                      <td class="texto"><input type="text" name="NUM_DOCTO_FATURA" id="NUM_DOCTO_FATURA" tipo="numerico" onKeyPress="return f_formata(this, '000000000000')"/></td>
                    </tr>
                    <tr>
                    	<td colspan="2"><fieldset><legend>Situa&ccedil;&atilde;o</legend>
                        					<table width="100%" border="0" cellspacing="0" cellpadding="3">
                                            	<tr>
                                                	<td class="texto">
													    <input type="checkbox" name="SITUACAO_ID" id="SITUACAO_ID_2" class="check" value="0,1" <cfif ListFind(#vars.SITUACAO_ID#,'0') >checked</cfif> onClick="f_muda_check_sel_todos(this.value)" />
                                                        <label for="SITUACAO_ID_2">&nbsp;Em Processamento</label>&nbsp;
                                                        <input type="checkbox" name="SITUACAO_ID" id="SITUACAO_ID_3" class="check" value="2" <cfif ListFind(#vars.SITUACAO_ID#,'2') >checked</cfif> onClick="f_muda_check_sel_todos(this.value)" />
                                                        <label for="SITUACAO_ID_3">&nbsp;Autorizada</label>&nbsp;
                                                        <input type="checkbox" name="SITUACAO_ID" id="SITUACAO_ID_4" class="check" value="3" <cfif ListFind(#vars.SITUACAO_ID#,'3') >checked</cfif> onClick="f_muda_check_sel_todos(this.value)" />
                                                        <label for="SITUACAO_ID_4">&nbsp;Cancelada</label>&nbsp;
                                                        <input type="checkbox" name="SITUACAO_ID" id="SITUACAO_ID_5" class="check" value="4" <cfif ListFind(#vars.SITUACAO_ID#,'4') >checked</cfif> onClick="f_muda_check_sel_todos(this.value)" />
                                                        <label for="SITUACAO_ID_5">&nbsp;Denegada</label>&nbsp;
                                                        <input type="checkbox" name="SITUACAO_ID" id="SITUACAO_ID_6" class="check" value="5" <cfif ListFind(#vars.SITUACAO_ID#,'5') >checked</cfif> onClick="f_muda_check_sel_todos(this.value)" />
                                                        <label for="SITUACAO_ID_6">&nbsp;Rejeitada</label>&nbsp;
                                                        
                                                        <input type="checkbox" name="SEL_TODOS" id="SEL_TODOS" class="check" value="" <cfif vars.SITUACAO_ID eq '0,1,2,3,4,5' or vars.SITUACAO_ID eq ''>checked</cfif> onClick="f_seleciona_todos()" />
                                            			<label for="SEL_TODOS_TIPOS">&nbsp;Todos</label>

                                                    </td>
                                                </tr>
                                            </table>
                        				</fieldset></td>
                    </tr>
                </table>
                </fieldset>
			</td>
        </tr>
        <cfif IsDefined("qrConhecimentos")>
            	<cfset grid_cod = 'CTE_LISTA_MDFE'>        
           <cfif qrConhecimentos.recordCount gt 0>
      	<tr>
        	<td>
				<cfset grid_query = 'qrConhecimentos'>
                <cfset grid_field_list    = ''>
                <cfset grid_field_caption = ''>
                <cfset grid_field_align   = ''>
                <cfset grid_field_type    = ''>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SELECIONAR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Exportao')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>                
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'OPERACOES_CTE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Opera&ccedil;&otilde;es CT-e</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DESCRICAO_STATUS')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Status CT-e</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CENTRO_CUSTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Centro de Custo</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>                
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_EMISSAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data de Emisso CT-e</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>                
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_CONHECIMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N CTE</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SERIE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Srie CT-e</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_ROMANEIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; Romaneio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'OPERACOES_MDFE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Opera&ccedil;&otilde;es MDF-e</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_MDFE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Status MDF-e</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>                
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_MDFE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N&ordm; MDF-e</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'date')>                
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'SERIE_MDFE')>

                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>S&eacute;rie MDF-e</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DATA_EMISSAO_MDFE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Data Emiss&atilde;o MDF-e</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>                                
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COD_VEICULO_TRACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Frota')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>                
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NOME_MOTORISTA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Motorista')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>                
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'FILIAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Filial')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>                
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'USER_INSERT')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Usurio')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'REM_RAZAO_SOCIAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Remetente')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'REM_CNPJ_CPF')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Remetente CNPJ</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DEST_RAZAO_SOCIAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Destinatrio')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'DEST_CNPJ_CPF')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Destinatrio CNPJ</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COLETA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Coleta')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ENTREGA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Entrega')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_EMAIL_REMETENTE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Remetente e-mail</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_EMAIL_DESTINATARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Destinatrio e-mail</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_EMAIL_RECEBEDOR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Recebedor e-mail</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_EMAIL_EXPEDIDOR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Entrega e-mail</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_EMAIL_TOMADOR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tomador e-mail</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_EMAIL_PROPRIETARIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Proprietrio e-mail</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_EMAIL_EMISSOR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Emissor e-mail</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'STATUS_EMAIL_TRANSPORTADOR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Transportador terceirizado e-mail</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TIPO_CONHECIMENTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Tipo')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'MODALIDADE')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Modalidade')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COB_RAZAO_SOCIAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Tomador')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'COB_CNPJ_CPF')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Tomador CNPJ</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_CONHECIMENTO_SUBSTITUIDO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Substituto de</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_CONHECIMENTO_SUBSTITUTO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Substitudo por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'CARGA_CONSOLIDADA_ID')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Carga Consolidada</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'ORGANIZACIONAL')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Organizacional')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>

                <cfset grid_field_list 	  = ListAppend(grid_field_list,'TIPO_EMISSAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'Tipo de Emisso')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_CONHECIMENTO_ANULADO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Anulado de</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'NUM_CONHECIMENTO_ANULACAO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Anulado por</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'left')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALE_PEDAGIO_IMPRIMIR')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Imprimir Vale Pedgio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'nao_ordenar')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALE_PEDAGIO_POSSUI')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Possui Vale Pedgio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
				
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALE_PEDAGIO_COMPROV_VAZIO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N Comprovante Vale Pedgio Vazio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
				
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALE_PEDAGIO_COMPROV_CARREGADO')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>N Comprovante Vale Pedgio Carregado</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'number')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALE_PEDAGIO_OPERADORA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Operadora Vale Pedgio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_field_list 	  = ListAppend(grid_field_list,'VALE_PEDAGIO_FORNECEDORA')>
                <cfset grid_field_caption = ListAppend(grid_field_caption,'<nobr>Fornecedora Vale Pedgio</nobr>')>
                <cfset grid_field_align	  = ListAppend(grid_field_align,'center')>
                <cfset grid_field_type 	  = ListAppend(grid_field_type,'caseinsensitivestring')>
                
                <cfset grid_td_context_eval = 'fnc_td_context_eval'>
                <cfset grid_td_inline_function = 'fnc_grid_td_inline_function'>
                <cfset grid_td_class_function = 'fnc_grid_td_class_function'>
                
                <cfscript>
                    function fnc_td_context_eval(field) {
                        switch(ucase(field)) {
							case "SELECIONAR":
								if(ListFind('2,3',qrConhecimentos.SITUACAO_ID) and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)) {
									return '<input type="checkbox" class="check" name="LISTA_DOCUMENTO_ID" id="LISTA_DOCUMENTO_ID" value="#qrConhecimentos.DOCUMENTO_ID#" />';
								}else{
									return '<input type="checkbox" class="check" name="CHECK_DISABLE_CTE" disabled title="O status do conhecimento no permite esta operao." />';
								}
								break;							
							case "OPERACOES_CTE":
   							    v_return = '';							
								/*ATUALIZAR*/
								v_return = v_return&'<div class="opcao">';								
								if(Len(Trim(qrConhecimentos.LIBERADO_IMPRESSAO)) and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID) ){
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_atualizar_status(#qrConhecimentos.CONHECIMENTO_ID#);" title="Atualizar" ><img src="/_imagens/botoes/16x16/atualizar.gif" alt="Atualizar" title="Atualizar" width="16" height="16" align="absmiddle" /></button>';
								}else{
									v_return = v_return&'<img src="/_imagens/botoes/16x16/atualizar_disable.gif" alt="Atualizar"  width="16" height="16" align="absmiddle" />';
								}
								v_return = v_return&'</div>';								
							    /*REENVIAR*/
								v_return = v_return&'<div class="opcao">';								
								if(((qrConhecimentos.EMITIDO eq 0 and qrConhecimentos.PERMITE_EDITAR eq 1) or qrConhecimentos.COD_STATUS eq 1) and Len(TRim(qrConhecimentos.LIBERADO_IMPRESSAO)) and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)  ) {
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_reenviar_cte(#qrConhecimentos.CONHECIMENTO_ID#);" alt="Reenviar CTE" title="Reenviar CTE"><img src="/_imagens/botoes/16x16/envio_multiplo.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{
									v_msg = 'O Status atual do conhecimento no permite o reenvio.';
									v_return = v_return&'<img src="/_imagens/botoes/16x16/envio_multiplo_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
								}	
								v_return = v_return&'</div>';								
							    /*CANCELAR*/
								v_return = v_return&'<div class="opcao">';								
								if( (qrConhecimentos.EMITIDO eq 1) and (qrConhecimentos.LIBERA_CANCELAMENTO eq 1) and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID) and not ((qrConhecimentos.NUM_CONHECIMENTO_SUBSTITUTO neq '' and qrConhecimentos.SUBSTITUTO eq 1) or (qrConhecimentos.NUM_CONHECIMENTO_SUBSTITUIDO neq '' and qrConhecimentos.TIPO_SUBSTITUTO eq 1)) ) {
									//criar funo, passando o user_insert e ele vai retornar se permite cancelar
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_cancelar(#qrConhecimentos.CONHECIMENTO_ID#);" alt="Cancelar" title="Cancelar"><img src="/_imagens/botoes/16x16/cancelar.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{
									if(qrConhecimentos.SITUACAO_ID eq 3)
										v_msg = 'O conhecimento j est cancelado.';
									else if(qrConhecimentos.EMITIDO neq 1)
										v_msg = 'No  possvel cancelar o conhecimento pois o mesmo ainda no foi integrado.';
									else if(qrConhecimentos.LIBERA_CANCELAMENTO neq 1)
										v_msg = 'Para este usurio no est permitida a operao de cancelamento de conhecimentos.';
									else if(qrConhecimentos.NUM_CONHECIMENTO_SUBSTITUTO neq '' and qrConhecimentos.SUBSTITUTO eq 1)
										v_msg = 'Nao  possvel cancelar o conhecimento pois ele ja foi substitudo pelo conhecimento '&qrConhecimentos.NUM_CONHECIMENTO_SUBSTITUTO&'.';
									else if(qrConhecimentos.NUM_CONHECIMENTO_SUBSTITUIDO neq '' and qrConhecimentos.TIPO_SUBSTITUTO eq 1)
										v_msg = 'Nao  possvel cancelar o conhecimento pois  um substituto do conhecimento '&qrConhecimentos.NUM_CONHECIMENTO_SUBSTITUIDO&'.';
									else
										v_msg = 'No  possvel cancelar o conhecimento.';
									v_return = v_return&'<img src="/_imagens/botoes/16x16/cancelar_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
								}
								v_return = v_return&'</div>';								
							    /*DESVINCULAR*/
								v_return = v_return&'<div class="opcao">';								
								if (listfind(v_usuarios_desvinculo,uCase(session.usuario)) && qrConhecimentos.NUM_ROMANEIO neq '') {
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_desvincular_cte_romaneio(#qrConhecimentos.CONHECIMENTO_ID#);" alt="Desvincular CTE da viagem" title="Desvincular CTE da viagem"><img src="/_imagens/botoes/16x16/desvincular_viagem.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{
									if (qrConhecimentos.NUM_ROMANEIO neq '')
										v_msg = 'Desvincular CTe da Viagem: Funo desabilitada para este usurio';
									else
										v_msg = 'Este CTE no est vinculado a uma viagem.';
									v_return = v_return&'<img src="/_imagens/botoes/16x16/desvincular_viagem_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
								}	
								v_return = v_return&'</div>';																
							    /*IMPRIMIR*/
								v_return = v_return&'<div class="opcao">';								
								if( v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID){
									if(qrConhecimentos.EMITIDO eq 1 or (qrConhecimentos.TIPO_EMISSAO_ID eq 5 and qrConhecimentos.COD_STATUS eq 1) or (not Len(Trim(qrConhecimentos.LIBERADO_IMPRESSAO))) or (qrConhecimentos.PARAMETRO_STATUS_INCLUSO neq 0) or (qrConhecimentos.SITUACAO_ID eq 7) ) {
										v_return = v_return&'<button type="button" class="botao-16x16"  onClick="f_imprimir_dacte(#qrConhecimentos.DOCUMENTO_ID#,#qrConhecimentos.NUM_CONHECIMENTO#,''#qrConhecimentos.PLACA_TRACAO#'');" alt="Imprimir DACTE" title="Imprimir DACTE"><img src="/_imagens/botoes/16x16/imprimir.gif"  width="16" height="16" align="absmiddle" /></button>';
									}else{										
										v_msg = 'O Status atual do conhecimento no permite a sua impresso.';
										v_return = v_return&'<img src="/_imagens/botoes/16x16/imprimir_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
									}
								}else{
									v_msg = 'O tipo do conhecimento no permite a sua impresso.';
									v_return = v_return&'<img src="/_imagens/botoes/16x16/imprimir_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
								}
								v_return = v_return&'</div>';								
							    /*INUTILIZAR*/
								v_return = v_return&'<div class="opcao">';								
								if(qrConhecimentos.EMITIDO eq 0 and qrConhecimentos.PERMITE_INUTILIZAR eq 1 and Len(TRim(qrConhecimentos.LIBERADO_IMPRESSAO)) and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID) ) {
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_inutilizar_cte(#qrConhecimentos.CONHECIMENTO_ID#);"  alt="Inutilizar CTE" title="Inutilizar CTE"><img src="/_imagens/botoes/16x16/cancelar_doc.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{									
									v_msg = 'O Status atual do conhecimento no permite a sua inutilizao.';
									v_return = v_return&'<img src="/_imagens/botoes/16x16/cancelar_doc_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
								}
								v_return = v_return&'</div>';								
								/*LIBERAR_IMPRESSAO*/
								v_return = v_return&'<div class="opcao">';								
								switch(qrConhecimentos.LIBERA_IMPRESSAO) {
									case 0:
										v_return = v_return&'<button type="button" class="botao-16x16"  alt="Para Liberar para impresso,  necessrio emitir o Contrato REPOM" title="Para Liberar para impresso,  necessrio emitir o Contrato REPOM"><img src="/_imagens/botoes/20x20/alerta.gif" width="16" height="16" align="absmiddle" /></button>';
										break;
									case 1:
										v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_liberar_impressao(#qrConhecimentos.CONHECIMENTO_ID#);" alt="Liberar Impresso" title="Liberar Impresso"><img src="/_imagens/botoes/16x16/ico_desenvolvimento_revisao.gif"  width="16" height="16" align="absmiddle" /></button>';
										break;
									default:
										v_return = v_return&'<img src="/_imagens/botoes/16x16/ico_desenvolvimento_revisao_disable.gif" alt="Liberar Impresso" title="Liberar Impresso" width="16" height="16" align="absmiddle" />';
								        break;
									
								}
								
								if(not Len(Trim(qrConhecimentos.LIBERA_IMPRESSAO))  ){
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_liberar_impressao(#qrConhecimentos.CONHECIMENTO_ID#);" alt="Liberar Impresso" title="Liberar Impresso"><img src="/_imagens/botoes/16x16/ico_desenvolvimento_revisao.gif"  width="16" height="16" align="absmiddle" /></button>';
								}				
								v_return = v_return&'</div>';												
								/*EDITAR*/
								v_return = v_return&'<div class="opcao">';								
								if(not Len(Trim(qrConhecimentos.LIBERADO_IMPRESSAO)) and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)  ){
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_editar(#qrConhecimentos.CONHECIMENTO_ID#);" alt="Editar CTe" title="Editar CTe"><img src="/_imagens/botoes/16x16/editar.gif"  width="16" height="16" align="absmiddle" /></button>';
								}else{
									v_return = v_return&'<img src="/_imagens/botoes/16x16/editar_disable.gif" alt="O conhecimento no  do tipo que permite edio." title="O conhecimento no  do tipo que permite edio." width="16" height="16" align="absmiddle" />';
								}
								v_return = v_return&'</div>';								
							    /*CONSULTAR_CHAVE*/
								v_return = v_return&'<div class="opcao">';								
								if( qrConhecimentos.PERMITE_CONSULTA_CHAVE eq 1 ) {
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_consultar_chave(#qrConhecimentos.CONHECIMENTO_ID#);" alt="Consultar CTe por Chave de Acesso" title="Consultar CTe por Chave de Acesso"><img src="/\_imagens/botoes/16x16/consultar_chave_cte.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{
									v_return = v_return&'<img src="/_imagens/botoes/16x16/consultar_chave_cte_disable.gif" alt="O Status deste conhecimento no mais permite a consulta por chave." title="O Status deste conhecimento no mais permite a consulta por chave." width="16" height="16" align="absmiddle" />';
								}		
								v_return = v_return&'</div>';														
							    /*XML_ENVIO*/
								v_return = v_return&'<div class="opcao">';								
								if( v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID){
									v_return = v_return&'<button type="button" id="btn_botao" class="botao-16x16" onClick="f_mostrar_div_visualizacao(1, #qrConhecimentos.DOCUMENTO_ID#)" alt="Visualizar XML de Envio" title="Visualizar XML de Envio"><img src="/_imagens/botoes/16x16/xml_exportar.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{
									v_return = v_return&'<img src="/_imagens/botoes/16x16/xml_exportar_disable.gif" alt="Visualizar XML de Envio" title="Visualizar XML de Envio" width="16" height="16" align="absmiddle" />';
								}		
								v_return = v_return&'</div>';
							    /*IMPRIMIR Declarao*/
								v_return = v_return&'<div class="opcao">';								
								if( v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID){
									if(!Len(Trim(qrConhecimentos.DECLARACAO_ID))){
										v_msg = 'Declarao no encontrada.';
										v_return = v_return&'<img src="/_imagens/botoes/16x16/impressao_dacte_disable.png" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';										
									}else{
										if((qrConhecimentos.EMITIDO eq 1 or (qrConhecimentos.TIPO_EMISSAO_ID eq 5 and qrConhecimentos.COD_STATUS eq 1) or (not Len(Trim(qrConhecimentos.LIBERADO_IMPRESSAO))))) {
											v_return = v_return&'<button type="button" class="botao-16x16"  onClick="f_imprimir_declaracao(#qrConhecimentos.DOCUMENTO_ID#);" alt="Imprimir Declarao" title="Imprimir Declarao"><img src="/_imagens/botoes/16x16/impressao_dacte.png"  width="16" height="16" align="absmiddle" /></button>';
										}else{										
											v_msg = 'O Status atual do conhecimento no permite a sua impresso.';
											v_return = v_return&'<img src="/_imagens/botoes/16x16/impressao_dacte_disable.png" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
										}
									}
								}else{
									v_msg = 'O tipo do conhecimento no permite a sua impresso.';
									v_return = v_return&'<img src="/_imagens/botoes/16x16/impressao_dacte_disable.png" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
								}	
								v_return = v_return&'</div>';																								
								/*IMPRIMIR CC-e*/
								v_return = v_return&'<div class="opcao">';								
								if( (qrConhecimentos.EMITIDO eq 1) and (qrConhecimentos.POSSUI_CCE eq 1) and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)) {
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_imprimir_cce(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.NUM_CONHECIMENTO#);" alt="Imprimir CC-e" title="Imprimir CC-e"><img src="/_imagens/botoes/16x16/imprimir_cce.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{
									if(qrConhecimentos.POSSUI_CCE neq 1)
										v_msg = 'No  possvel imprimir a CC-e, pois o conhecimento no possui CC-e gerada.'; 
									else if(qrConhecimentos.SITUACAO_ID eq 3)
										v_msg = 'No  possvel imprimir a CC-e para o conhecimento, pois o mesmo j est cancelado.';
									else if(qrConhecimentos.EMITIDO neq 1)
										v_msg = 'No  possvel imprimir a CC-e para o conhecimento pois o mesmo ainda no foi integrado.';
									else
										v_msg = 'No  possvel imprimir a CC-e para o conhecimento.';
									v_return = v_return&'<img src="/_imagens/botoes/16x16/imprimir_cce_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
								}
								v_return = v_return&'</div>';																															
								/*IMPRIMIR DOCUMENTOS VIAGEM*/
								v_return = v_return&'<div class="opcao">';								
								if( v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID){
									if(qrConhecimentos.EMITIDO eq 1 or (qrConhecimentos.TIPO_EMISSAO_ID eq 5 and qrConhecimentos.COD_STATUS eq 1) or (not Len(Trim(qrConhecimentos.LIBERADO_IMPRESSAO))) or (qrConhecimentos.PARAMETRO_STATUS_INCLUSO neq 0)) {
										v_return = v_return&'<button type="button" class="botao-16x16"  onClick="f_imprimir_documentos_viagem(#qrConhecimentos.DOCUMENTO_ID#,#qrConhecimentos.NUM_CONHECIMENTO#,''#qrConhecimentos.PLACA_TRACAO#'');" alt="Imprimir Documentos da Viagem" title="Imprimir Documentos da Viagem"><img src="/_imagens/botoes/16x16/imprimir.gif"  width="16" height="16" align="absmiddle" /></button>';
									}else{										
										v_msg = 'O Status atual do conhecimento no permite a impresso dos documentos da viagem.';
										v_return = v_return&'<img src="/_imagens/botoes/16x16/imprimir_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
									}
								}else{
									v_msg = 'O tipo do conhecimento no permite a sua impresso.';
									v_return = v_return&'<img src="/_imagens/botoes/16x16/imprimir_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
								}
								v_return = v_return&'</div>';	
								return v_return;						
								break;							
							case "OPERACOES_MDFE":	
   							    v_return = '';
								/*ATUALIZAR*/
								v_return = v_return&'<div class="opcao">';
								if(Len(Trim(qrConhecimentos.MDFE_ID)))
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_atualizar_status_mdfe(#qrConhecimentos.MDFE_ID#);" title="Atualizar MDF-e" ><img src="/_imagens/botoes/16x16/atualizar_mdfe.gif" alt="Atualizar MDF-e" title="Atualizar MDF-e" width="16" height="16" align="absmiddle" /></button>';
								else
									v_return = v_return&'<img src="/_imagens/botoes/16x16/atualizar_mdfe_disabled.gif" alt="Atualizar" title="MDF-e no emitido" width="16" height="16" align="absmiddle" />';
								v_return = v_return&'</div>';
							    /*REENVIAR*/
								v_return = v_return&'<div class="opcao">';
								if(qrConhecimentos.MDFE_ID_STATUS eq 0){
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_reenviar_mdfe2(#qrConhecimentos.MDFE_ID#);" alt="Reenviar MDF-e" title="Reenviar MDF-e"><img src="/_imagens/botoes/16x16/enviar_mdfe.gif" width="16" height="16" align="absmiddle" /></button>';
								}else if((qrConhecimentos.EMITIDO_MDFE eq 0 and qrConhecimentos.NUM_ROMANEIO neq '' and (qrConhecimentos.PERMITE_EDITAR_MDFE eq 1 or qrConhecimentos.situacao_id_mdfe neq 6))) {
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_reenviar_mdfe(#qrConhecimentos.MDFE_ID#);" alt="Reenviar MDF-e" title="Reenviar MDF-e"><img src="/_imagens/botoes/16x16/enviar_mdfe.gif" width="16" height="16" align="absmiddle" /></button>';
									}else{
									if((qrConhecimentos.SITUACAO_ID_MDFE eq 3 or qrConhecimentos.SITUACAO_ID_MDFE eq 11 or (!Len(Trim(qrConhecimentos.MDFE_ID)))) and (qrConhecimentos.PERMITE_MDFE eq 1 or qrConhecimentos.PERMITE_MDFE eq 2) or qrConhecimentos.situacao_id_mdfe eq 6 ) {
										v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_emitir_mdfe(#chr(39)##qrConhecimentos.NUM_ROMANEIO##chr(39)#,#chr(39)##qrConhecimentos.COLETA_UF##chr(39)#,#chr(39)##qrConhecimentos.ENTREGA_UF##chr(39)#,#chr(39)##qrConhecimentos.CARGA_CONSOLIDADA_ID##chr(39)#,#chr(39)##qrConhecimentos.CONHECIMENTO_ID##chr(39)#);" alt="Emitir MDF-e" title="Emitir MDF-e"><img src="/_imagens/botoes/16x16/enviar_mdfe.gif" width="16" height="16" align="absmiddle" /></button>';										
									}
									else{
										if(!Len(Trim(qrConhecimentos.MDFE_ID)) and qrConhecimentos.PERMITE_MDFE eq 0)
											v_msg = 'Emisso de MDF-e no permitido para o romaneio #qrConhecimentos.NUM_ROMANEIO#';
										else
											v_msg = 'O Status atual do MDF-e no permite o reenvio.';
										v_return = v_return&'<img src="/_imagens/botoes/16x16/enviar_mdfe_disabled.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
									}
								}
								v_return = v_return&'</div>';								
							    /*CANCELAR*/
								v_return = v_return&'<div class="opcao">';								
								if(qrConhecimentos.EMITIDO_MDFE eq 1 and qrConhecimentos.SITUACAO_ID_MDFE neq 3 and qrConhecimentos.SITUACAO_ID_MDFE neq 11 and qrAmbienteEmissao.ambiente_fsda neq 1) {
									if(v_possui_acao_mdfe_cancelar eq 1){
										v_return = v_return&'<button type="button" class="botao-16x16 opcao" onClick="f_cancelar_mdfe(#qrConhecimentos.MDFE_ID#);" alt="Cancelar" title="Cancelar"><img src="/_imagens/botoes/16x16/cancelar_mdfe.gif" width="16" height="16" align="absmiddle" /></button>';
									}else{
										v_msg = 'Para este usurio no est permitida a operao de cancelamento de MDF-e.';
									   v_return = v_return&'<img src="/_imagens/botoes/16x16/encerrar_mdfe_disabled.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
									}
								}else{
									if(Len(Trim(qrConhecimentos.MDFE_ID)) and qrConhecimentos.PERMITE_EXCLUIR_MDFE eq 1 and qrAmbienteEmissao.ambiente_fsda neq 1)
										v_return = v_return&'<button type="button" class="botao-16x16 opcao" onClick="f_excluir_mdfe(#qrConhecimentos.MDFE_ID#);" alt="Excluir MDF-e" title="Excluir MDF-e"><img src="/_imagens/botoes/16x16/cancelar_mdfe.gif" width="16" height="16" align="absmiddle" /></button>';
									else{
										if(!Len(Trim(qrConhecimentos.MDFE_ID)))									
											v_msg = 'MDF-e no emitido';
										else if(qrConhecimentos.SITUACAO_ID_MDFE eq 3)
											v_msg = 'O MDF-e j est cancelado.';
										else if(qrConhecimentos.SITUACAO_ID_MDFE eq 11)
											v_msg = 'No  possvel cancelar o MDF-e pois o mesmo j est encerrado.';										
										else if(qrConhecimentos.EMITIDO_MDFE neq 1)
											v_msg = 'No  possvel cancelar o MDF-e pois o mesmo ainda no foi integrado.';
										else if(qrAmbienteEmissao.ambiente_fsda eq 1)
											v_msg = 'No  possvel cancelar o MDF-e pois o mesmo foi gerado em ambiente de contingncia.';
										else
											v_msg = 'No  possvel cancelar o MDF-e.';
										v_return = v_return&'<img src="/_imagens/botoes/16x16/cancelar_mdfe_disabled.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
									}
								}
								v_return = v_return&'</div>';								
							    /*ENCERRAR*/
								v_return = v_return&'<div class="opcao">';									
								if(qrConhecimentos.EMITIDO_MDFE eq 1 and qrConhecimentos.SITUACAO_ID_MDFE neq 3 and qrConhecimentos.SITUACAO_ID_MDFE neq 11 and qrAmbienteEmissao.ambiente_fsda neq 1) {
									if(v_possui_acao_mdfe_encerrar eq 1){
									   v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_encerrar_mdfe(#qrConhecimentos.MDFE_ID#);" alt="Encerrar MDF-e" title="Encerrar MDF-e"><img src="/_imagens/botoes/16x16/encerrar_mdfe.gif" width="16" height="16" align="absmiddle" /></button>';
									}else{
										v_msg = 'Para este usurio no est permitida a operao de encerramento de MDF-e.';
									   v_return = v_return&'<img src="/_imagens/botoes/16x16/encerrar_mdfe_disabled.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
									}
								}else{
									if(!Len(Trim(qrConhecimentos.MDFE_ID)))									
										v_msg = 'MDF-e no emitido';
									else if(qrConhecimentos.SITUACAO_ID_MDFE eq 11)
										v_msg = 'O MDF-e j est encerrado.';
									else if(qrConhecimentos.SITUACAO_ID_MDFE eq 3)
										v_msg = 'No  possvel encerrar o MDF-e pois o mesmo j est cancelado.';										
									else if(qrConhecimentos.EMITIDO_MDFE neq 1)
										v_msg = 'No  possvel encerrar o MDF-e pois o mesmo ainda no foi integrado.';
									else if(qrAmbienteEmissao.ambiente_fsda eq 1)
											v_msg = 'No  possvel cancelar o MDF-e pois o mesmo foi gerado em ambiente de contingncia.';
									else
										v_msg = 'No  possvel cancelar o MDF-e.';
									v_return = v_return&'<img src="/_imagens/botoes/16x16/encerrar_mdfe_disabled.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
								}
								v_return = v_return&'</div>';									
								/*IMPRESSAO*/
								v_return = v_return&'<div class="opcao">';									
								if(Len(Trim(qrConhecimentos.MDFE_ID))) {
									if(qrConhecimentos.MDFE_ID_STATUS eq 100 or qrConhecimentos.tipo_emissao_id_mdfe eq 5){
										v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_imprimir_damdfe(#qrConhecimentos.MDFE_ID#,#qrConhecimentos.CONHECIMENTO_ID#);" alt="Imprimir DAMDFE" title="Imprimir DAMDFE"><img style="margin:0px !important;" src="/_imagens/botoes/16x16/impressao_documento.gif"  width="16" height="16" align="absmiddle" /></button>';
									}
									else{
										v_msg = 'O Status atual do MDF-e no permite impresso.';
										v_return = v_return&'<img src="/_imagens/botoes/16x16/impressao_documento_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
									}
								}else{										
										v_msg = 'MDF-e no emitido';
										v_return = v_return&'<img src="/_imagens/botoes/16x16/impressao_documento_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
									}
								v_return = v_return&'</div>';
							    /*XML_ENVIO*/
								v_return = v_return&'<div class="opcao">';									
								if(Len(Trim(qrConhecimentos.DOCUMENTO_ID_MDFE))) {
									v_return = v_return&'<button type="button" id="btn_botao" class="botao-16x16" onClick="f_mostrar_div_visualizacao(2, #qrConhecimentos.DOCUMENTO_ID_MDFE#)" alt="Visualizar XML de Envio" title="Visualizar XML de Envio"><img src="/_imagens/botoes/16x16/visualizar_xml.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{						
									v_msg = 'MDF-e no emitido';		
									v_return = v_return&'<img src="/_imagens/botoes/16x16/visualizar_xml_disable.gif" alt="#v_msg#" title="#v_msg#" width="16" height="16" align="absmiddle" />';
								}
								v_return = v_return&'</div>';
							    /*CONSULTAR_CHAVE*/
								v_return = v_return&'<div class="opcao">';								
								if( qrConhecimentos.PERMITE_CONSULTA_CHAVE_MDFE eq 1 and qrAmbienteEmissao.ambiente_fsda neq 1) {
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_consultar_chave_mdfe(#qrConhecimentos.MDFE_ID#);" alt="Consultar MDF-e por Chave de Acesso" title="Consultar MDF-e por Chave de Acesso"><img src="/\_imagens/botoes/16x16/consulta_chave.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{
									v_return = v_return&'<img src="/_imagens/botoes/16x16/consulta_chave_disable.gif" alt="O Status deste conhecimento no mais permite a consulta por chave." title="O Status deste conhecimento no mais permite a consulta por chave." width="16" height="16" align="absmiddle" />';
								}		
								v_return = v_return&'</div>';	

								/*INUTILIZAR MDF-E*/
								v_return = v_return&'<div class="opcao">';								
								if( qrConhecimentos.PERMITE_INUTILIZAR_MDFE eq 1 and qrAmbienteEmissao.ambiente_fsda neq 1) {
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_inutilizar_mdfe(#qrConhecimentos.MDFE_ID#);" alt="Inutilizar MDF-e" title="Inutilizar MDF-e"><img src="/\_imagens/botoes/16x16/cancelar_doc.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{
									v_return = v_return&'<img src="/_imagens/botoes/16x16/cancelar_doc_disable.gif" alt="A MDF-e no pode ser inutilizada." title="A MDF-e no pode ser inutilizada." width="16" height="16" align="absmiddle" />';
								}		
								v_return = v_return&'</div>';

								/*ENVIAR EVENTO DE PAGAMENTO DE OPERAO DE TRANSPORTE DE MDF-E*/
								v_return = v_return&'<div class="opcao">';								
								if(qrConhecimentos.ev_pag_oper_transp eq 0 and qrConhecimentos.permite_ev_pag_oper_transp eq 1 and qrAmbienteEmissao.ambiente_fsda neq 1 and (qrConhecimentos.SITUACAO_ID_MDFE eq 2 or qrConhecimentos.SITUACAO_ID_MDFE eq 11)) {
									v_return = v_return&'<button type="button" class="botao-16x16" onClick="f_enviar_ev_pag_oper_transp_mdfe(#qrConhecimentos.MDFE_ID#);" alt="Enviar Evento de Pagamento de Operao de Transporte do MDF-e" title="Enviar Evento de Pagamento de Operao de Transporte do MDF-e"><img src="/\_imagens/botoes/16x16/enviar_mdfe.gif" width="16" height="16" align="absmiddle" /></button>';
								}else{
								    if(qrConhecimentos.ev_pag_oper_transp eq 1) {
									   v_return = v_return&'<img src="/_imagens/botoes/16x16/enviar_mdfe_disabled.gif" alt="MDF-e j possui Evento de Pagamento de Operao de Transporte" title="MDF-e j possui Evento de Pagamento de Operao de Transporte" width="16" height="16" align="absmiddle" />';
								    } else if(not (qrConhecimentos.SITUACAO_ID_MDFE eq 2 or qrConhecimentos.SITUACAO_ID_MDFE eq 11)) {
									   v_return = v_return&'<img src="/_imagens/botoes/16x16/enviar_mdfe_disabled.gif" alt="S  permitido enviar Evento de Pagamento de Operao de Transporte se o MDF-e estiver Autorizado/Encerrado" title="S  permitido enviar Evento de Pagamento de Operao de Transporte se o MDF-e estiver Autorizado/Encerrado" width="16" height="16" align="absmiddle" />';
								    } else {
									   v_return = v_return&'<img src="/_imagens/botoes/16x16/enviar_mdfe_disabled.gif" alt="No  permitido Enviar Evento de Pagamento de Operao de Transporte do MDF-e" title="No  permitido Enviar Evento de Pagamento de Operao de Transporte do MDF-e" width="16" height="16" align="absmiddle" />';
									}
								}		
								v_return = v_return&'</div>';							

								return v_return;						
							    break;
							case "STATUS_EMAIL_REMETENTE":
								if(qrConhecimentos.EMITIDO eq 1 and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)) {
									if(qrConhecimentos.STATUS_EMAIL_REMETENTE eq 0) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,1,''#qrConhecimentos.EMAIL_REMETENTE#'');" alt="E-mail no enviado" title="E-mail no enviado" ><img src="/_imagens/botoes/16x16/fechado.gif"width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_REMETENTE eq 1) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,1,''#qrConhecimentos.EMAIL_REMETENTE#'');" alt="E-mail enviado" title="E-mail enviado" width="16" ><img src="/_imagens/botoes/16x16/aberto.gif"height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_REMETENTE eq 2) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,1,''#qrConhecimentos.EMAIL_REMETENTE#'');" alt="E-mail no cadastrado" title="E-mail no cadastrado" ><img src="/_imagens/botoes/16x16/alerta.gif"width="16" height="16" align="absmiddle" /></button>';
									}else{
										return '';
									}
								}else{
									return '';
								}
								break;
							case "STATUS_EMAIL_DESTINATARIO":
								if(qrConhecimentos.EMITIDO eq 1 and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)) {
									if(qrConhecimentos.STATUS_EMAIL_DESTINATARIO eq 0) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,2,''#qrConhecimentos.EMAIL_DESTINATARIO#'');" alt="E-mail no enviado" title="E-mail no enviado"><img src="/_imagens/botoes/16x16/fechado.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_DESTINATARIO eq 1) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,2,''#qrConhecimentos.EMAIL_DESTINATARIO#'');" alt="E-mail enviado" title="E-mail enviado"><img src="/_imagens/botoes/16x16/aberto.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_DESTINATARIO eq 2) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,2,''#qrConhecimentos.EMAIL_DESTINATARIO#'');" alt="E-mail no cadastrado" title="E-mail no cadastrado"><img src="/_imagens/botoes/16x16/alerta.gif" width="16" height="16" align="absmiddle" /></button>';
									}else{
										return '';
									}
								}else{
									return '';
								}
								break;
							case "STATUS_EMAIL_EXPEDIDOR":
								if(qrConhecimentos.EMITIDO eq 1 and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)) {
									if(qrConhecimentos.STATUS_EMAIL_EXPEDIDOR eq 0) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,3,''#qrConhecimentos.EMAIL_EXPEDIDOR#'');" alt="E-mail no enviado" title="E-mail no enviado"><img src="/_imagens/botoes/16x16/fechado.gif"  width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_EXPEDIDOR eq 1) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,3,''#qrConhecimentos.EMAIL_EXPEDIDOR#'');" alt="E-mail enviado" title="E-mail enviado"><img src="/_imagens/botoes/16x16/aberto.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_EXPEDIDOR eq 2) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,3,''#qrConhecimentos.EMAIL_EXPEDIDOR#'');" alt="E-mail no cadastrado" title="E-mail no cadastrado"><img src="/_imagens/botoes/16x16/alerta.gif" width="16" height="16" align="absmiddle" /></button>';
									}else{
										return '';
									}
								}else{
									return '';
								}
								break;
							case "STATUS_EMAIL_RECEBEDOR":
								if(qrConhecimentos.EMITIDO eq 1 and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)) {
									if(qrConhecimentos.STATUS_EMAIL_RECEBEDOR eq 0) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,4,''#qrConhecimentos.EMAIL_RECEBEDOR#'');" alt="E-mail no enviado" title="E-mail no enviado"><img src="/_imagens/botoes/16x16/fechado.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_RECEBEDOR eq 1) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,4,''#qrConhecimentos.EMAIL_RECEBEDOR#'');" alt="E-mail enviado" title="E-mail enviado"><img src="/_imagens/botoes/16x16/aberto.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_RECEBEDOR eq 2) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,4,''#qrConhecimentos.EMAIL_RECEBEDOR#'');" alt="E-mail no cadastrado" title="E-mail no cadastrado"><img src="/_imagens/botoes/16x16/alerta.gif" width="16" height="16" align="absmiddle" /></button>';
									}else{
										return '';
									}
								}else{
									return '';
								}
								break;
							case "STATUS_EMAIL_TOMADOR":
								if(qrConhecimentos.EMITIDO eq 1 and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)) {
									if(qrConhecimentos.STATUS_EMAIL_TOMADOR eq 0) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,5,''#qrConhecimentos.EMAIL_TOMADOR#'');" alt="E-mail no enviado" title="E-mail no enviado"><img src="/_imagens/botoes/16x16/fechado.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_TOMADOR eq 1) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,5,''#qrConhecimentos.EMAIL_TOMADOR#'');" alt="E-mail enviado" title="E-mail enviado"><img src="/_imagens/botoes/16x16/aberto.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_TOMADOR eq 2) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,5,''#qrConhecimentos.EMAIL_TOMADOR#'');" alt="E-mail no cadastrado" title="E-mail no cadastrado"><img src="/_imagens/botoes/16x16/alerta.gif" width="16" height="16" align="absmiddle" /></button>';
									}else{
										return '';
									}
								}else{
									return '';
								}
								break;
                     case "STATUS_EMAIL_PROPRIETARIO":
								if(qrConhecimentos.EMITIDO eq 1 and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)) {
									if(qrConhecimentos.STATUS_EMAIL_PROPRIETARIO eq 0) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,6,''#qrConhecimentos.EMAIL_PROPRIETARIO#'');" alt="E-mail no enviado" title="E-mail no enviado"><img src="/_imagens/botoes/16x16/fechado.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_PROPRIETARIO eq 1) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,6,''#qrConhecimentos.EMAIL_PROPRIETARIO#'');" alt="E-mail enviado" title="E-mail enviado"><img src="/_imagens/botoes/16x16/aberto.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_PROPRIETARIO eq 2) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,6,''#qrConhecimentos.EMAIL_PROPRIETARIO#'');" alt="E-mail no cadastrado" title="E-mail no cadastrado"><img src="/_imagens/botoes/16x16/alerta.gif" width="16" height="16" align="absmiddle" /></button>';
									}else{
										return '';
									}
								}else{
									return '';
								}
								break;
                     case "STATUS_EMAIL_EMISSOR":
								if(qrConhecimentos.EMITIDO eq 1 and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)) {
									if(qrConhecimentos.STATUS_EMAIL_EMISSOR eq 0) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,7,''#qrConhecimentos.EMAIL_EMISSOR#'');" alt="E-mail no enviado" title="E-mail no enviado"><img src="/_imagens/botoes/16x16/fechado.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_EMISSOR eq 1) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,7,''#qrConhecimentos.EMAIL_EMISSOR#'');" alt="E-mail enviado" title="E-mail enviado"><img src="/_imagens/botoes/16x16/aberto.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_EMISSOR eq 2) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,7,''#qrConhecimentos.EMAIL_EMISSOR#'');" alt="E-mail no cadastrado" title="E-mail no cadastrado"><img src="/_imagens/botoes/16x16/alerta.gif" width="16" height="16" align="absmiddle" /></button>';
									}else{
										return '';
									}
								}else{
									return '';
								}
								break;
                     case "STATUS_EMAIL_TRANSPORTADOR":
								if(qrConhecimentos.EMITIDO eq 1 and (v_tipo_conhecimento_cadastro neq qrConhecimentos.CONHECIMENTO_TIPO_ID)) {
									if(qrConhecimentos.STATUS_EMAIL_TRANSPORTADOR eq 0) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,8,''#qrConhecimentos.EMAIL_TRANSPORTADOR#'');" alt="E-mail no enviado" title="E-mail no enviado"><img src="/_imagens/botoes/16x16/fechado.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_TRANSPORTADOR eq 1) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,8,''#qrConhecimentos.EMAIL_TRANSPORTADOR#'');" alt="E-mail enviado" title="E-mail enviado"><img src="/_imagens/botoes/16x16/aberto.gif" width="16" height="16" align="absmiddle" /></button>';
									}else if(qrConhecimentos.STATUS_EMAIL_TRANSPORTADOR eq 2) {
										return '<button type="button" class="botao-16x16 opcao" onClick="f_mostrar_div(#qrConhecimentos.CONHECIMENTO_ID#,#qrConhecimentos.DOCUMENTO_ID#,8,''#qrConhecimentos.EMAIL_TRANSPORTADOR#'');" alt="E-mail no cadastrado" title="E-mail no cadastrado"><img src="/_imagens/botoes/16x16/alerta.gif" width="16" height="16" align="absmiddle" /></button>';
									}else{
										return '';
									}
								}else{
									return '';
								}
								break;
							case "VALE_PEDAGIO_IMPRIMIR":
							   if(qrConhecimentos.VALE_PEDAGIO_POSSUI eq 'Sim'){
								   return '<button type="button" class="botao-16x16" onClick="f_imprimir_vale_pedagio(''#qrConhecimentos.VALE_PEDAGIO_COMPROV_CARREGADO#'', ''#qrConhecimentos.NUM_ROMANEIO#'');" alt="Imprimir Vale Pedgio" title="Imprimir Vale Pedgio"><img src="/_imagens/botoes/16x16/impressao_dacte.png" width="16" height="16" align="absmiddle" /></button>';								   
							   }else{
								   return '<img src="/_imagens/botoes/16x16/impressao_dacte_disable.png" width="16" height="16" align="absmiddle" alt="CT-e no possui Vale Pedgio" title="CT-e no possui Vale Pedgio"/>';
							   }
							   break;
							default:
								return Evaluate("#grid_query#.#field#");
								break;
						}
                    }
                    
                    function fnc_grid_td_inline_function(field) {
                        return " nowrap";
                    }
					
					function fnc_grid_td_class_function(field) {
						switch(ucase(field)) {
								case 'DESCRICAO_STATUS' : 
									switch(qrConhecimentos.SITUACAO_ID) {
										case 0:
											return 'tarefa_liberada_atualizacao';
										case 1:
											return 'tarefa_liberada_atualizacao';
										case 2:
											return 'tarefa_executando';
										case 3:
											return 'tarefa_recusada';
										case 4:
											return 'tarefa_recusada';
										case 5:
											return 'tarefa_recusada';
										case 6:
											if(qrConhecimentos.PERMITE_EDITAR eq 1){
												return 'tarefa_testando';
											}else{
												return 'tarefa_recusada';
											}
										case 7:
											return 'tarefa_recusada';
										case 8:
											return 'tarefa_recusada';
										case 9:
											return 'tarefa_recusada';
										case 10:
											return 'tarefa_recusada';
										case 11:
											return 'encerrado';
										default:
											return '';										
									}
								case 'STATUS_MDFE' : 
									switch(qrConhecimentos.SITUACAO_ID_MDFE) {
										case 0:
											return 'tarefa_liberada_atualizacao';
										case 1:
											return 'tarefa_liberada_atualizacao';
										case 2:
											return 'tarefa_executando';
										case 3:
											return 'tarefa_recusada';
										case 4:
											return 'tarefa_recusada';
										case 5:
											return 'tarefa_recusada';
										case 6:
											if(qrConhecimentos.PERMITE_EDITAR_MDFE eq 1){
												return 'tarefa_testando';
											}else{
												return 'tarefa_recusada';
											}
										case 7:
											return 'tarefa_recusada';
										case 8:
											return 'tarefa_recusada';
										case 9:
											return 'tarefa_recusada';
										case 10:
											return 'tarefa_recusada';
										case 11:
											return 'encerrado';
										default:
											return '';										
									}									
						default: return '';
						}
						
					}
                </cfscript>
                
                <cfset grid_fixed_header = 0>
                <cfinclude template="/_include/grid/grid.cfm">
            </td>
        </tr>
	    <cfelse>
        	<tr>
            	<td>
					<span class="obrigatorio">Nenhum conhecimento de transporte encontrado.</span>
                </td>
            </tr> 
        </cfif>	
    </cfif>
</table>
<div id="div_manipulacao" style="position: absolute; width: 200px; height: 100px; display: none;">
    <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
        <tr>
            <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<nobr><label id="lb_manipulacao" style="padding-right: 10px;"></label></nobr></td>
        </tr>
        <tr>
            <td height="98%" valign="top">
                <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
                    <tr>
                        <td class="texto" nowrap>E-mail:</td>
                        <td class="texto" nowrap><input name="EMAIL" type="text" id="EMAIL" style="width: 400px" maxlength="90" tipo="lista_email" display="ENDERECO DE EMAIL"/></td>
                    </tr>                        
                </table>
                                
            </td>
        </tr>
        <tr>
            <td height="1%" id="barra_botoes_bottom" class="texto" align="right"><button type="button" class="botao" onClick="f_ocultar_div()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button>&nbsp;
                <button type="button" class="botao" onClick="f_enviar_email()"><nobr><img src="/_imagens/botoes/16x16/confirmar.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Confirmar</nobr></button></td>
        </tr>
    </table>
</form>
</div>
<div id="div_visualizacao" style="position: absolute; width: 640px; height: 480px; display: none;">
    <table width="100%" height="100%" border="0" cellspacing="0" cellpadding="0" class="borda">
        <tr id="tr_cabecalho_interno_visualizacao" style="cursor: move;">
            <td width="92%" height="1%" id="cabecalho_interno" class="texto_negrito"><img src="/_imagens/uteis/pontinhos-1.gif" alt="" title="" width="5" height="16" align="absmiddle">&nbsp;<img src="<cf_url>/_imagens/logos/logo_kmm.jpg</cf_url>" alt="" title="" width="25" height="20" align="absmiddle" />&nbsp;<label id="lb_cabecalho"></label></td>
        </tr>
        <tr>
            <td height="98%">
                <table width="100%" height="100%" border="0" cellspacing="1" cellpadding="3">
                    <tr>
                        <td height="100%" valign="top" class="texto"><span id="sp_carregando"><img src="/_imagens/uteis/carregando.gif" alt="" title="" /><br /></span>
                            <textarea name="VISUALIZACAO" id="VISUALIZACAO" readonly display="VISUALIZAO" style="width: 100%; height: 100%; border: solid 1px #A0A0A0; overflow: auto; padding: 3px;"></textarea></td>
                    </tr>                   
                </table>
            </td>
        </tr>
        <tr>
            <td height="1%" id="barra_botoes_bottom" class="texto" align="right"><button type="button" class="botao" onClick="f_ocultar_div_visualizacao()"><nobr><img src="/_imagens/botoes/16x16/fechar_tela.gif" alt="" title="" width="16" height="16" align="absmiddle" />&nbsp;Fechar</nobr></button></td>
        </tr>
    </table>
</div>
</body>
<script type="text/javascript">
	f_hide_carregando();	
</script>

<cfif IsDefined("qrConhecimentos")>
	<script type="text/javascript">
		v_dragObj = new DragObj({ type: 'preview', moveOpacity : 60 });
		v_dragObj.addObj(document.getElementById('div_visualizacao'), document.getElementById('tr_cabecalho_interno_visualizacao'));
		
		try{
			document.getElementById("td_<cfoutput>#grid_cod#</cfoutput>_SELECIONAR").innerHTML = '';
		}catch (e){}
		
		with(document.forms[0]) {
			<cfoutput>
				<cfif IsDefined("vars.DATA_INICIO") and Len(Trim(vars.DATA_INICIO))>
					DATA_INICIO.value     = '#JSStringFormat(vars.DATA_INICIO)#';					
				</cfif>
				<cfif IsDefined("vars.DATA_TERMINO") and Len(Trim(vars.DATA_TERMINO))>
					DATA_TERMINO.value     = '#JSStringFormat(vars.DATA_TERMINO)#';					
				</cfif>
				<cfif IsDefined("vars.DACTE_IMPRESSO")>
					DACTE_IMPRESSO.value     = '#JSStringFormat(vars.DACTE_IMPRESSO)#';					
				</cfif>
				<cfif IsDefined("vars.NUM_MDFE")>
					NUM_MDFE.value     = '#JSStringFormat(vars.NUM_MDFE)#';					
				</cfif>	
				<cfif IsDefined("vars.NUM_ROMANEIO_FILTRO")>
					NUM_ROMANEIO_FILTRO.value     = '#JSStringFormat(vars.NUM_ROMANEIO_FILTRO)#';					
				</cfif>								
				<cfif IsDefined("vars.NUM_CTE") and Len(Trim(vars.NUM_CTE))>
					NUM_CTE.value     = '#JSStringFormat(vars.NUM_CTE)#';					
				</cfif>
				<cfif IsDefined("vars.COD_PESSOA_FILIAL") and Len(Trim(vars.COD_PESSOA_FILIAL))>
					COD_PESSOA_FILIAL.value     = '#JSStringFormat(vars.COD_PESSOA_FILIAL)#';
					<cfif administrador or vars.SOMENTE_FILIAL eq 0>
						f_busca_centro_custo();
					</cfif>
				</cfif>
				<cfif IsDefined("vars.COD_CENTRO_CUSTO") and Len(Trim(vars.COD_CENTRO_CUSTO))>
					COD_CENTRO_CUSTO.value     = '#JSStringFormat(vars.COD_CENTRO_CUSTO)#';
				</cfif>
				<cfif vars.SITUACAO_ID eq '0,1,2,3,4,5' or vars.SITUACAO_ID eq ''>
					f_seleciona_todos();
				</cfif>
				<cfif IsDefined("vars.COD_REMETENTE") and Len(Trim(vars.COD_REMETENTE))>
					COD_REMETENTE.value			= '#JSStringFormat(vars.COD_REMETENTE)#';
					CNPJ_CPF_REMETENTE.value    = '#JSStringFormat(vars.CNPJ_CPF_REMETENTE)#';
					NOME_REMETENTE.value		= '#JSStringFormat(vars.NOME_REMETENTE)#';
				</cfif>
				<cfif IsDefined("vars.COD_DESTINATARIO") and Len(Trim(vars.COD_DESTINATARIO))>
					COD_DESTINATARIO.value			= '#JSStringFormat(vars.COD_DESTINATARIO)#';
					CNPJ_CPF_DESTINATARIO.value   	= '#JSStringFormat(vars.CNPJ_CPF_DESTINATARIO)#';
					NOME_DESTINATARIO.value			= '#JSStringFormat(vars.NOME_DESTINATARIO)#';
				</cfif>
				<cfif IsDefined("vars.COD_CLIENTE_COBRANCA") and Len(Trim(vars.COD_CLIENTE_COBRANCA))>
					COD_CLIENTE_COBRANCA.value		= '#JSStringFormat(vars.COD_CLIENTE_COBRANCA)#';
					CNPJ_CPF_CLIENTE_COBRANCA.value = '#JSStringFormat(vars.CNPJ_CPF_CLIENTE_COBRANCA)#';
					NOME_CLIENTE_COBRANCA.value		= '#JSStringFormat(vars.NOME_CLIENTE_COBRANCA)#';
				</cfif>
				<cfif IsDefined("vars.NUM_DOCTO_FATURA")>
					NUM_DOCTO_FATURA.value     = '#JSStringFormat(vars.NUM_DOCTO_FATURA)#';					
				</cfif>

			</cfoutput>
			
			try {
				document.getElementById('td_CTE_LISTA_MDFE_SELECIONAR').innerHTML = '<input name="SELECIONAR_TODOS" id="SELECIONAR_TODOS" type="checkbox" class="check" value="" onClick="f_selecionar_todos_documentos();" />';
			} catch(e) {}
			parent.document.getElementById('btn_download_pdf').style.width = '120 px';
			parent.document.getElementById('btn_download_xml').style.width = '110 px';
			
		}
	</script>
</cfif>
</html>
<iframe name="consultas" frameborder="0" width="100%" height="600" src="" style="display: none;"></iframe>
<cfset RequestEnd = 0>
