<cfinclude template="/_scripts/scripts.cfm" />
<cfscript>
	// Verifica se a varivel de controle de fluxo existe
	if((IsDefined("vars.OPERACAO")) and (Len(Trim(vars.OPERACAO)))) {
		conn_manip = CreateComponent("modulos.cte._componentes.manipulacao.cfc_cte");
		conn_mdfe  = CreateComponent("modulos.mdfe._componentes.manipulacao.cfc_mdfe");		
		switch(val(vars.OPERACAO)) {
			case 1:
				set_manipulacao = conn_manip.consulta_status(argumentCollection = vars);
				break;
			case 2:
				set_manipulacao = conn_manip.atualiza_cte(argumentCollection = vars);
				break;
			case 3:
				set_manipulacao = conn_manip.cancela_cte(argumentCollection = vars);
				break;
			case 4:
				set_manipulacao = conn_manip.gerar_dacte(argumentCollection = vars);
				break;
			case 5:
				set_manipulacao = conn_manip.envia_email(argumentCollection = vars);
				break;
			case 6:
				set_manipulacao = conn_manip.prc_inutilizar_cte(argumentCollection = vars);
				break;
			case 7:
				set_manipulacao = conn_manip.cte_liberado_impressao(argumentCollection = vars);
				break;
			case 8:
				set_manipulacao = conn_manip.prc_consulta_chave(argumentCollection = vars);
				break;
			case 9:
				set_manipulacao = conn_manip.desvincula_ctrc_romaneio(argumentCollection = vars);
				break;
			case 10:
				set_manipulacao = conn_mdfe.gera_damdfe(argumentCollection = vars);
				break;
			case 11:
				set_manipulacao = conn_mdfe.consulta_status(argumentCollection = vars);
				break;
			case 12:
				set_manipulacao = conn_mdfe.envia_mdfe(argumentCollection = vars);
				break;
			case 13:
				set_manipulacao = conn_mdfe.consulta_chave(argumentCollection = vars);
				break;
			case 14:
				set_manipulacao = conn_mdfe.encerrar_mdfe(argumentCollection = vars);
				break;
			case 15:
				set_manipulacao = conn_mdfe.cancelar_mdfe(argumentCollection = vars);
				break;
			case 16: 		 	
				if((IsDefined("vars.carga_consolidada_id")) and (Len(Trim(vars.carga_consolidada_id)))) {
					set_manipulacao = conn_mdfe.ins_mdfe(num_romaneio = '', uf_origem = vars.uf_origem, uf_destino = vars.uf_destino, carga_consolidada_id = vars.carga_consolidada_id, obs_mdfe = vars.obs_mdfe, conhecimento_id = vars.conhecimento_id, autoriza_mdfe = vars.autoriza_mdfe);
				} else {
					set_manipulacao = conn_mdfe.ins_mdfe(num_romaneio = vars.num_romaneio, uf_origem = vars.uf_origem, uf_destino = vars.uf_destino, carga_consolidada_id = vars.carga_consolidada_id, obs_mdfe = vars.obs_mdfe, conhecimento_id = vars.conhecimento_id, autoriza_mdfe = vars.autoriza_mdfe);
				}
				break;
			case 17: 		 	
				set_manipulacao = conn_mdfe.del_mdfe(argumentCollection = vars);
				break;
			case 18: 		 	
				set_manipulacao = conn_manip.gerar_declaracao(argumentCollection = vars);
				break;
			case 19: 		 	
				set_manipulacao = conn_manip.gerar_comprovante_vale_pedagio(argumentCollection = vars);
				break;
			case 20: 		 	
				set_manipulacao = conn_mdfe.prc_inutilizar_mdfe(argumentCollection = vars);
				break;
			case 21:
				set_manipulacao = conn_mdfe.ins_mdfe_romaneio(argumentCollection = vars);
				break;
            case 22:
				set_manipulacao = conn_manip.gerar_documentos_viagem(argumentCollection = vars);
                break;
            case 23:
				set_manipulacao = conn_mdfe.prc_pag_oper_transporte(argumentCollection = vars);
                break;
		}
		if(val(vars.OPERACAO) neq 10 and val(vars.OPERACAO) neq 18 and val(vars.OPERACAO) neq 4 and val(vars.OPERACAO) neq 19)
			fnc_trata_erros(struct_erro = set_manipulacao);
		else
			fnc_trata_erros(struct_erro = set_manipulacao, mostra_msg_ok = 0);
	}
</cfscript>


<cfscript>
   if((IsDefined("vars.OPERACAO")) and (Len(Trim(vars.OPERACAO)))) {
      if (val(vars.OPERACAO) eq 1 or val(vars.OPERACAO) eq 2  or val(vars.OPERACAO) eq 10){
		conn = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
		qrCTE = conn.get_CTE_LISTA(cte_id = vars.conhecimento_id);		
	  }	
   }	
</cfscript>
<cfif vars.OPERACAO eq 1 or vars.OPERACAO eq 2>   
   <cfoutput>
       <cfif  not Len(Trim(qrCTE.MDFE_id)) and qrCTE.SITUACAO_ID eq 2>
		<cfif qrCTE.PERMITE_MDFE eq 2 >
		    <script type="text/javascript">
			   parent.f_inserir_mdfe_obr(#qrCTE.num_romaneio#, '#qrCTE.coleta_uf#', '#qrCTE.entrega_uf#', <cfif IsDefined(#qrCTE.carga_consolidada_id#) and (Len(Trim(#qrCTE.carga_consolidada_id#)))>  #qrCTE.carga_consolidada_id# <cfelse> '', '#qrCTE.conhecimento_id#' </cfif>);
		    </script>
        <cfelseif qrCTE.PERMITE_MDFE eq 1 >
            <script type="text/javascript">
                if(confirm('Deseja emitir o MDF-e?')){
				      parent.f_inserir_mdfe_obr(#qrCTE.num_romaneio#, '#qrCTE.coleta_uf#', '#qrCTE.entrega_uf#', <cfif IsDefined(#qrCTE.carga_consolidada_id#) and (Len(Trim(#qrCTE.carga_consolidada_id#)))>  #qrCTE.carga_consolidada_id# <cfelse> '', '#qrCTE.conhecimento_id#' </cfif>);
				 }
            </script>
         </cfif>
      </cfif>
   </cfoutput>
</cfif>
<cfif vars.OPERACAO eq 10>	
	<cfoutput>
		<cfset v_data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss') />
		<cfset v_nome_arquivo_damdfe = "damdfe_" & qrCTE.num_mdfe & "_PLACA_" & qrCTE.placa_tracao & "_" & #v_data_hora# & ".pdf" />
        <cffile action="write" file="#ExpandPath("/")#temp/#v_nome_arquivo_damdfe#" nameconflict="makeunique" output="#set_manipulacao.ARQUIVO#">
        <script type="text/javascript">
            parent.document.getElementById('CONFIRMA').value = 1;
            parent.NewWindow('<cf_url>/temp/<cfoutput>#v_nome_arquivo_damdfe#</cfoutput></cf_url>', '', 800, 600, 'yes');
        </script>
    </cfoutput> 
<cfelse>  
	<cfif vars.OPERACAO eq 18>	
        <cfoutput>
            <cfset v_data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss') />
            <cffile action="write" file="#ExpandPath("/")#temp/declaracao_#v_data_hora#.pdf" nameconflict="makeunique" output="#set_manipulacao.ARQUIVO#">
            <script type="text/javascript">
                parent.NewWindow('<cf_url>/temp/declaracao_<cfoutput>#v_data_hora#</cfoutput>.pdf</cf_url>', '', 800, 600, 'yes');
            </script>
        </cfoutput>
    <cfelseif vars.OPERACAO eq 19>	
        <cfoutput>
            <cfset v_data_hora = DateFormat(Now(), 'ddmmyyyy') & "_" & TimeFormat(Now(), 'HHmmss') />
            <cffile action="write" file="#ExpandPath("/")#temp/comprovante_vp_#vars.vp_num_comprovante#_#v_data_hora#.pdf" nameconflict="makeunique" output="#set_manipulacao.ARQUIVO#">
            <script type="text/javascript">
                parent.NewWindow('<cf_url>/temp/comprovante_vp_<cfoutput>#vars.vp_num_comprovante#</cfoutput>_<cfoutput>#v_data_hora#</cfoutput>.pdf</cf_url>', '', 800, 600, 'yes');
            </script>
        </cfoutput>
    <cfelse>    
    <script type="text/javascript">
        with(parent.document.forms[0]) {
            <cfif (IsDefined("vars.ATUALIZA_COMBO")) and (Len(Trim(vars.ATUALIZA_COMBO)))>
                window.onload = function() {
                    <cfoutput>
                        #vars.ATUALIZA_COMBO#;
                        top.window.close();
                    </cfoutput>
                }	
            <cfelse>
               parent.f_atualizar();
            </cfif>
        }
    </script>
    </cfif>  
</cfif>  
