<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!--- 
    -- PROPSITO
    -- Insere o valor de uma constante
    -- ANDERSONC 13/07/2010 15:13:55 - CRIADO
    --->
    <cffunction name='set_constante' displayname='Insere o valor de uma constante' access='remote' returntype='Struct' output='true'>
        <cfargument name='COD_CONSTANTE' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cfstoredproc procedure='comercial.pkg_formula_tabela_frete.prc_set_constante' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_COD_CONSTANTE'  value='#arguments.COD_CONSTANTE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
	<!--- 
    -- PROPSITO
    -- Insere o valor de uma varivel
    -- ANDERSONC 13/07/2010 15:14:54 - CRIADO
    --->
    <cffunction name='ins_tabela_frete_var_temp' displayname='Insere o valor de uma varivel' access='remote' returntype='Struct' output='true'>
        <cfargument name='TABELA_FRETE_ID' required='yes'>
        <cfargument name='TABELA_FRETE_ROTA_ID' required='yes'>
        <cfargument name='TABELA_FRETE_VARIAVEL_ID' required='yes'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
            <cfstoredproc procedure='comercial.pkg_formula_tabela_frete.prc_ins_tabela_frete_var_temp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ID'  value='#arguments.TABELA_FRETE_ID#'  null='#iif(len(trim(arguments.TABELA_FRETE_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ROTA_ID'  value='#arguments.TABELA_FRETE_ROTA_ID#'  null='#iif(len(trim(arguments.TABELA_FRETE_ROTA_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_VARIAVEL_ID'  value='#arguments.TABELA_FRETE_VARIAVEL_ID#'  null='#iif(len(trim(arguments.TABELA_FRETE_VARIAVEL_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' dbvarname='P_VALOR'  value='#arguments.VALOR#' >
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
    
    <!--- 
	-- PROPSITO
	-- Recalcula a tabela de frete
	-- ANDERSONC 13/07/2010 15:34:47 - CRIADO
	--->
	<cffunction name='recalculo_tabela_frete' displayname='Recalcula a tabela de frete' access='remote' returntype='Struct' output='true'>
		<cftry>
			<cfstoredproc procedure='comercial.pkg_formula_tabela_frete.prc_recalculo_tabela_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#' />
			<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>