<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de emissao de documentos" extends="_transportes.funcoes.cfc_init">
    
    <!--- 
	-- PROPSITO
	-- Executa o clculo da tabela de frete para o CTRC
	-- ANDERSONC 20/07/2010 15:40:55 - CRIADO
	--->
	<cffunction name='calcula_ctrc_tabela_frete' displayname='Executa o clculo da tabela de frete para o CTRC' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='TABELA_FRETE_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_calcula_ctrc_tabela_frete' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_TABELA_FRETE_ID'  value='#arguments.TABELA_FRETE_ID#'  null='#iif(len(trim(arguments.TABELA_FRETE_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
    
    <!--- 
	-- PROPSITO
	-- Envia o e-mail de Carga/Descarga de acordo com a operao
	-- ANDERSONC 26/08/2010 13:49:30 - CRIADO
	--->
	<cffunction name='envia_email_operacao' displayname='Envia o e-mail de Carga/Descarga de acordo com a operao' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
        	<cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_envia_email_operacao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5' dbvarname='P_CONHECIMENTO_ID'  value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                </cfstoredproc>
                <cfset v_retorno.erro = false>
                <cfset v_retorno.mensagem = JSStringFormat('E-mail enviado com sucesso.')>
			</cftransaction>
			<cfcatch>
            	<cftransaction action='rollback'/>
				<cfset v_retorno.erro = true>
				<cfset v_retorno.mensagem = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn v_retorno />
	</cffunction>

</cfcomponent>