<!-- KM&M Componentes -->
<cfcomponent displayname="Consultas da rea de emissao de documentos" extends="_transportes.funcoes.cfc_init">

    <!--- 
	-- PROPSITO
-- Trocar carto do motorista
-- ricardocabral 24/08/2015 17:58:06 - CRIADO
--->
<cffunction name='troca_cartao_vale_pedagio' displayname='Trocar carto do motorista' access='remote' returntype='Struct' output='true'>
	<cfargument name='COD_PESSOA_MOTORISTA' required='yes'>
	<cfargument name='NUM_CARTAO_ANTIGO' required='yes'>
	<cfargument name='NUM_CARTAO_NOVO' required='yes'>
	<cfargument name='OPERADORA_VALE_PEDAGIO' required='yes'>
	<cftry>
			<cfstoredproc procedure='pagfrete.pkg_cartao.prc_troca_cartao_vale_pedagio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_MOTORISTA#'  null='#iif(len(trim(arguments.COD_PESSOA_MOTORISTA)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_CARTAO_ANTIGO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_CARTAO_NOVO#' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OPERADORA_VALE_PEDAGIO#' >
			</cfstoredproc>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('Operao realizada com sucesso')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
	</cftry>
	<cfreturn retorno />
</cffunction>


    <!---
	-- PROPSITO
	-- Executar lgica antes da insero em outro procedimento,
	-- devido  limitao do Cold Fusion de muitas linhas de cdigo no mesmo procedimento...
	--->
	<cffunction name='ins_cte_body' displayname='Inserir CTE Body' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='SERIE' required='no'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='COD_REDESPACHO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COLETA_ENDERECO' required='yes'>
		<cfargument name='COLETA_COMPLEMENTO' required='no' default="null">
		<cfargument name='COLETA_BAIRRO' required='yes'>
		<cfargument name='COLETA_CEP' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='RED_ENDERECO' required='yes'>
		<cfargument name='RED_COMPLEMENTO' required='no' default="null">
		<cfargument name='RED_BAIRRO' required='yes'>
		<cfargument name='RED_CEP' required='yes'>
		<cfargument name='RED_UF' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='NOME_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_UF' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='RODAPE' required='yes'>
		<cfargument name='ENTRADA_DADOS' required='yes'>
		<cfargument name='TIPO_CONHECIMENTO' required='no' default="0">
		<cfargument name='TEM_NOTA' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_MUNICIPIO_ID' required='yes'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='COB_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COB_ENDERECO' required='yes'>
		<cfargument name='COB_MUNICIPIO' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COB_CEP' required='yes'>
		<cfargument name='COB_CNPJ_CPF' required='yes'>
		<cfargument name='COB_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='PRAZO_ENTREGA' required='yes'>
		<cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='CONHECIMENTO_ID_SUB_CONTR' required='no' default="">
		<cfargument name='REDUCAO_BASE_ICMS' required='no' default="0">
		<cfargument name='REDUCAO_BASE_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='BASE_CALCULO_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='ALIQUOTA_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='VALOR_ICMS_PRESUMIDO' required='no' default="0">
		<cfargument name='NUM_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='SERIE_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='BASE_CALCULO_ISS' required='no' default="0">
		<cfargument name='ALIQUOTA_ISS' required='no' default="0">
		<cfargument name='VALOR_ISS' required='no' default="0">
		<cfargument name='VALOR_FATURAMENTO' required='no' default="0">
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='NATUREZA_OPERACAO' required='yes'>
		<cfargument name='FUNDAMENTACAO_LEGAL' required='yes'>
		<cfargument name='COD_NEGOCIADOR' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='TIPO_VENDA' required='no' default="1">
		<cfargument name='REM_ENDERECO_NUM' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DEST_ENDERECO_NUM' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_BAIRRO' required='yes'>
		<cfargument name='COB_MUNICIPIO_ID' required='yes'>
		<cfargument name='CTRC_FATURAMENTO' required='no' default="0">
		<cfargument name='MODELO_DOCUMENTO' required='no' default="57">
		<cfargument name='TIPO_SERVICO_ID' required='no' default="0">
		<cfargument name='COLETA_COD_PESSOA' required='yes'>
		<cfargument name='COLETA_CNPJ_CPF' required='yes'>
		<cfargument name='COLETA_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COLETA_ENDERECO_NUM' required='yes'>
		<cfargument name='RED_CNPJ_CPF' required='yes'>
		<cfargument name='RED_RAZAO_SOCIAL' required='yes'>
        <cfargument name='OPERACAO_ID_CTRC' required='yes'>
        <cfargument name='SUBSTITUTO' required='no' default="">
        <cfargument name='CONHECIMENTO_TIPO_ID' required='no' default="">
        <cfargument name='TERCEIRO' required='no' default="">
        <cfargument name='REM_COD_ENDERECO' required='yes'>
        <cfargument name='COLETA_COD_ENDERECO' required='yes'>
        <cfargument name='DEST_COD_ENDERECO' required='yes'>
        <cfargument name='RED_COD_ENDERECO' required='yes'>
        <cfargument name='COB_COD_ENDERECO' required='yes'>
        <cfargument name='OPERACAO_ID' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='TIPO_SERVICO_COMERCIAL' required='no' default="">
        <cfargument name='DISPENSADO_TABELA_FRETE' required='no' default="">
        <cfargument name='USUARIO_LIBERACAO' required='no' default="">
        <cfargument name='SENHA_LIBERACAO' required='no' default="">
        <cfargument name='NEG_COD_ENDERECO' required='no' default="">
        <cfargument name='PLACA_REFERENCIA_INTERNA' required='no' default="">
        <cfargument name='CONHECIMENTO_ID_SUBST' required='no' default="">
        <cfargument name='MOTIVO_SUBSTITUICAO_ID' required='no' default="">
        <cfargument name='EMITE_POR_TABELA_FRETE' required='no' default="">
        <cfargument name='BASE_CALC_MAIOR_TOTAL' required='no' default="">
        <cfargument name='TAG_OPERACAO_OBS_CONTRIB_ID' required='no' default="">
        <cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default="">
        <cfargument name='DESTINO_MUNICIPIO_ID' required='no' default="">
        <cfargument name='FRETE_EM' required='no' default="">
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default="">
        <cfargument name='VARS_PLACA_REFERENCIA' required='no' default="">
        <cfargument name='PLACAS_COMPOSICAO' required='no' default="">
      <cfargument name='CADASTRADO_ANTERIORMENTE' required='no' default="0">

		<cfargument name='CARGA_CONSOLIDADA_ID' required='no' default="">
		<cfif arguments.terceiro eq 1 and not len(trim(arguments.NUM_ROMANEIO))>
                <cfscript>
                    ger_rom_ter = this.gera_romaneio_terceiro_private(argumentCollection = arguments);
                </cfscript>
                <cfif ger_rom_ter.erro>
                    <cfthrow object="#ger_rom_ter.mensagem#">
                <cfelse>
                    <cfset arguments.num_romaneio 	= ger_rom_ter.num_romaneio>
                    <cfset arguments.item_id 		= ger_rom_ter.item_id>
                </cfif>
        </cfif>

        <cfif Len(Trim(arguments.placa_tracao)) and Len(Trim(arguments.num_romaneio)) and arguments.substituto neq 1 and arguments.substituto neq 2>
            <cfscript>
                conn = CreateObject("component","_transportes.manipulacao.cfc_controle_trafego");
                ins_rota = conn.ins_itinerario_item_romaneio(num_romaneio 		  = arguments.num_romaneio,
                                                             item_id	  		  = arguments.item_id,
                                                             municipio_origem_id  = arguments.coleta_municipio_id,
                                                             municipio_destino_id = arguments.red_municipio_id);
            </cfscript>
            <cfif ins_rota.erro>
                <cfthrow object="#ins_rota.mensagem#">
            </cfif>
        </cfif>

        <cfif Len(Trim(arguments.PLACA_REFERENCIA_INTERNA))>
            <cfset arguments.vars_placa_referencia = #arguments.PLACA_REFERENCIA_INTERNA# & ','>
            <cfset arguments.vars_placa_referencia = ListGetAt(arguments.vars_placa_referencia, 1, ',')>
            <cfset arguments.placas_composicao = arguments.placa_tracao & ',' & arguments.PLACA_REFERENCIA_INTERNA >
            <cfset arguments.placas_composicao = arguments.placa_tracao & ',' & arguments.PLACA_REFERENCIA_INTERNA >
        <cfelse>
            <cfset arguments.vars_placa_referencia = ''>
            <cfset arguments.placas_composicao = arguments.placa_tracao>
            <cfset arguments.placas_composicao = arguments.placa_tracao>
        </cfif>
		<cfreturn arguments />
	</cffunction>

    <!---
	-- PROPSITO
	-- Executar lgica antes da insero em outro procedimento,
	-- devido  limitao do Cold Fusion de muitas linhas de cdigo no mesmo procedimento...
	--->
	<cffunction name='ins_cte_prc' displayname='Inserir CTE Body' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='SERIE' required='no'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='COD_REDESPACHO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COLETA_ENDERECO' required='yes'>
		<cfargument name='COLETA_COMPLEMENTO' required='no' default="null">
		<cfargument name='COLETA_BAIRRO' required='yes'>
		<cfargument name='COLETA_CEP' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='RED_ENDERECO' required='yes'>
		<cfargument name='RED_COMPLEMENTO' required='no' default="null">
		<cfargument name='RED_BAIRRO' required='yes'>
		<cfargument name='RED_CEP' required='yes'>
		<cfargument name='RED_UF' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='NOME_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_UF' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='RODAPE' required='yes'>
		<cfargument name='ENTRADA_DADOS' required='yes'>
		<cfargument name='TIPO_CONHECIMENTO' required='no' default="0">
		<cfargument name='TEM_NOTA' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_MUNICIPIO_ID' required='yes'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='COB_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COB_ENDERECO' required='yes'>
		<cfargument name='COB_MUNICIPIO' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COB_CEP' required='yes'>
		<cfargument name='COB_CNPJ_CPF' required='yes'>
		<cfargument name='COB_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='PRAZO_ENTREGA' required='yes'>
		<cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='CONHECIMENTO_ID_SUB_CONTR' required='no' default="">
		<cfargument name='REDUCAO_BASE_ICMS' required='no' default="0">
		<cfargument name='REDUCAO_BASE_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='BASE_CALCULO_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='ALIQUOTA_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='VALOR_ICMS_PRESUMIDO' required='no' default="0">
		<cfargument name='NUM_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='SERIE_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='BASE_CALCULO_ISS' required='no' default="0">
		<cfargument name='ALIQUOTA_ISS' required='no' default="0">
		<cfargument name='VALOR_ISS' required='no' default="0">
		<cfargument name='VALOR_FATURAMENTO' required='no' default="0">
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='NATUREZA_OPERACAO' required='yes'>
		<cfargument name='FUNDAMENTACAO_LEGAL' required='yes'>
		<cfargument name='COD_NEGOCIADOR' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='TIPO_VENDA' required='no' default="1">
		<cfargument name='REM_ENDERECO_NUM' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DEST_ENDERECO_NUM' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_BAIRRO' required='yes'>
		<cfargument name='COB_MUNICIPIO_ID' required='yes'>
		<cfargument name='CTRC_FATURAMENTO' required='no' default="0">
		<cfargument name='MODELO_DOCUMENTO' required='no' default="57">
		<cfargument name='TIPO_SERVICO_ID' required='no' default="0">
		<cfargument name='COLETA_COD_PESSOA' required='yes'>
		<cfargument name='COLETA_CNPJ_CPF' required='yes'>
		<cfargument name='COLETA_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COLETA_ENDERECO_NUM' required='yes'>
		<cfargument name='RED_CNPJ_CPF' required='yes'>
		<cfargument name='RED_RAZAO_SOCIAL' required='yes'>
        <cfargument name='OPERACAO_ID_CTRC' required='yes'>
        <cfargument name='SUBSTITUTO' required='no' default="">
        <cfargument name='CONHECIMENTO_TIPO_ID' required='no' default="">
        <cfargument name='TERCEIRO' required='no' default="">
        <cfargument name='REM_COD_ENDERECO' required='yes'>
        <cfargument name='COLETA_COD_ENDERECO' required='yes'>
        <cfargument name='DEST_COD_ENDERECO' required='yes'>
        <cfargument name='RED_COD_ENDERECO' required='yes'>
        <cfargument name='COB_COD_ENDERECO' required='yes'>
        <cfargument name='OPERACAO_ID' required='no' default="">
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='TIPO_SERVICO_COMERCIAL' required='no' default="">
        <cfargument name='DISPENSADO_TABELA_FRETE' required='no' default="">
        <cfargument name='USUARIO_LIBERACAO' required='no' default="">
        <cfargument name='SENHA_LIBERACAO' required='no' default="">
        <cfargument name='NEG_COD_ENDERECO' required='no' default="">
        <cfargument name='PLACA_REFERENCIA_INTERNA' required='no' default="">
        <cfargument name='CONHECIMENTO_ID_SUBST' required='no' default="">
        <cfargument name='MOTIVO_SUBSTITUICAO_ID' required='no' default="">
        <cfargument name='EMITE_POR_TABELA_FRETE' required='no' default="">
        <cfargument name='BASE_CALC_MAIOR_TOTAL' required='no' default="">
        <cfargument name='TAG_OPERACAO_OBS_CONTRIB_ID' required='no' default="">
        <cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default="">
        <cfargument name='DESTINO_MUNICIPIO_ID' required='no' default="">
        <cfargument name='FRETE_EM' required='no' default="">
        <cfargument name='SOLICITACAO_CARGA_ID' required='no' default="">
        <cfargument name='VARS_PLACA_REFERENCIA' required='no' default="">
        <cfargument name='PLACAS_COMPOSICAO' required='no' default="">
        <cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='COLETA_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='RED_INSCRICAO_ESTADUAL' required='yes'>
        <cfargument name='NEG_INSCRICAO_ESTADUAL' required='no'>
        <cfargument name='VARIAVEL_ALIQUOTA_ICMS_PARTILHA' required='no' >
        <cfargument name='VARIAVEL_ALIQUOTA_ICMS_FCP' required='no' >
        <cfargument name='VARIAVEL_VALOR_ICMS_PARTILHA' required='no' >
        <cfargument name='VARIAVEL_VALOR_ICMS_FCP' required='no' >
		<cfargument name='CHAVE_DOC_ANTERIOR' required='no' default="">
        <cfargument name='CADASTRO' required='no' default="">
		<cfargument name='ACERTO' required='no' default="0">
      <cfargument name='CADASTRADO_ANTERIORMENTE' required='no' default="0">

		<cfstoredproc procedure='fiscal.pkg_cte.prc_ins_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
            <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONHECIMENTO#' variable='retorno.NUM_CONHECIMENTO'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
            <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
            <cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' variable='retorno.DATA_EMISSAO' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='0' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ST_ICMS_ID#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
            <cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_ENDERECO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_COMPLEMENTO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_BAIRRO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_CEP#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_UF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_ENDERECO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_COMPLEMENTO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_BAIRRO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_CEP#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_UF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.vars_placa_referencia#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME_MOTORISTA#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RODAPE#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='2'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CONHECIMENTO#'  null='#iif(len(trim(arguments.TIPO_CONHECIMENTO)), de('no'), de('yes'))#'>
            <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONHECIMENTO_ID' >
            <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PRAZO_ENTREGA#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA_GERENCIAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_TRACAO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID_SUB_CONTR#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_SUB_CONTR)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONHECIMENTO_SUB_CONTR#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO_SUB_CONTR)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE_CONHECIMENTO_SUB_CONTR#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CFOP_ID#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NATUREZA_OPERACAO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FUNDAMENTACAO_LEGAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_KG#'  null='#iif(len(trim(arguments.PESO_KG)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_VENDA#'  null='#iif(len(trim(arguments.TIPO_VENDA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REM_ENDERECO_NUM#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REM_BAIRRO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DEST_ENDERECO_NUM#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DEST_BAIRRO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_ENDERECO_NUM#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_BAIRRO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COB_ENDERECO_NUM#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COB_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COB_MUNICIPIO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODELO_DOCUMENTO#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_SERVICO_ID#'  null='#iif(len(trim(arguments.TIPO_SERVICO_ID)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_COD_PESSOA#'  null='#iif(len(trim(arguments.COLETA_COD_PESSOA)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_CNPJ_CPF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_RAZAO_SOCIAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_ENDERECO_NUM#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REDESPACHO#' null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_CNPJ_CPF#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_RAZAO_SOCIAL#' >
            <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_ENDERECO_NUM#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OPERACAO_ID_CTRC#' null='#iif(len(trim(arguments.OPERACAO_ID_CTRC)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SUBSTITUTO#' null='#iif(len(trim(arguments.SUBSTITUTO)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_TIPO_ID)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANIZACIONAL#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REM_COD_ENDERECO#'  null='#iif(len(trim(arguments.REM_COD_ENDERECO)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_COD_ENDERECO#'  null='#iif(len(trim(arguments.COLETA_COD_ENDERECO)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEST_COD_ENDERECO#'  null='#iif(len(trim(arguments.DEST_COD_ENDERECO)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RED_COD_ENDERECO#'  null='#iif(len(trim(arguments.RED_COD_ENDERECO)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COB_COD_ENDERECO#'  null='#iif(len(trim(arguments.COB_COD_ENDERECO)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_SERVICO_COMERCIAL#'  null='#iif(len(trim(arguments.TIPO_SERVICO_COMERCIAL)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DISPENSADO_TABELA_FRETE#'  null='#iif(len(trim(arguments.DISPENSADO_TABELA_FRETE)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO_LIBERACAO#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SENHA_LIBERACAO#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NEG_COD_ENDERECO#'  null='#iif(len(trim(arguments.NEG_COD_ENDERECO)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='0'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACAS_COMPOSICAO#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.CONHECIMENTO_ID_SUBST#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_SUBST)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.MOTIVO_SUBSTITUICAO_ID#'  null='#iif(len(trim(arguments.MOTIVO_SUBSTITUICAO_ID)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.EMITE_POR_TABELA_FRETE#'  null='#iif(len(trim(arguments.EMITE_POR_TABELA_FRETE)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FRETE_EM#'  null='#iif(len(trim(arguments.FRETE_EM)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='0'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.BASE_CALC_MAIOR_TOTAL#' null='#iif(len(trim(arguments.BASE_CALC_MAIOR_TOTAL)), de('no'), de('yes'))#'>                    
			 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REM_INSCRICAO_ESTADUAL#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_INSCRICAO_ESTADUAL#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_INSCRICAO_ESTADUAL#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COB_INSCRICAO_ESTADUAL#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NEG_INSCRICAO_ESTADUAL#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   null='yes' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   null='yes' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CADASTRO#'  null='#iif(len(trim(arguments.CADASTRO)), de('no'), de('yes'))#'>
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO_GLOBALIZADO#' >
			 <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE_DOC_ANTERIOR#' >
             <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.CADASTRADO_ANTERIORMENTE#' >
			 <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ACERTO#' >
        </cfstoredproc>
		<cfreturn arguments />
	</cffunction>

	<!---
	-- PROPSITO
	-- Inserir CTE
	-- RAFAEL 28/12/2010 10:53:07 - CRIADO
	--->
	<cffunction name='ins_cte' displayname='Inserir CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='SERIE' required='no'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='COD_REDESPACHO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COLETA_ENDERECO' required='yes'>
		<cfargument name='COLETA_COMPLEMENTO' required='no' default="null">
		<cfargument name='COLETA_BAIRRO' required='yes'>
		<cfargument name='COLETA_CEP' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='RED_ENDERECO' required='yes'>
		<cfargument name='RED_COMPLEMENTO' required='no' default="null">
		<cfargument name='RED_BAIRRO' required='yes'>
		<cfargument name='RED_CEP' required='yes'>
		<cfargument name='RED_UF' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='NOME_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_UF' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='RODAPE' required='yes'>
		<cfargument name='ENTRADA_DADOS' required='yes'>
		<cfargument name='TIPO_CONHECIMENTO' required='no' default="0">
		<cfargument name='TEM_NOTA' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_MUNICIPIO_ID' required='yes'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='COB_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COB_ENDERECO' required='yes'>
		<cfargument name='COB_MUNICIPIO' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COB_CEP' required='yes'>
		<cfargument name='COB_CNPJ_CPF' required='yes'>
		<cfargument name='COB_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='PRAZO_ENTREGA' required='yes'>
		<cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='CONHECIMENTO_ID_SUB_CONTR' required='no' default="">
		<cfargument name='REDUCAO_BASE_ICMS' required='no' default="0">
		<cfargument name='REDUCAO_BASE_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='BASE_CALCULO_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='ALIQUOTA_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='VALOR_ICMS_PRESUMIDO' required='no' default="0">
		<cfargument name='NUM_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='SERIE_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='BASE_CALCULO_ISS' required='no' default="0">
		<cfargument name='ALIQUOTA_ISS' required='no' default="0">
		<cfargument name='VALOR_ISS' required='no' default="0">
		<cfargument name='VALOR_FATURAMENTO' required='no' default="0">
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='NATUREZA_OPERACAO' required='yes'>
		<cfargument name='FUNDAMENTACAO_LEGAL' required='yes'>
		<cfargument name='COD_NEGOCIADOR' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='TIPO_VENDA' required='no' default="1">
		<cfargument name='REM_ENDERECO_NUM' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DEST_ENDERECO_NUM' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_BAIRRO' required='yes'>
		<cfargument name='COB_MUNICIPIO_ID' required='yes'>
		<cfargument name='CTRC_FATURAMENTO' required='no' default="0">
		<cfargument name='MODELO_DOCUMENTO' required='no' default="57">
		<cfargument name='TIPO_SERVICO_ID' required='no' default="0">
		<cfargument name='COLETA_COD_PESSOA' required='yes'>
		<cfargument name='COLETA_CNPJ_CPF' required='yes'>
		<cfargument name='COLETA_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COLETA_ENDERECO_NUM' required='yes'>
		<cfargument name='RED_CNPJ_CPF' required='yes'>
		<cfargument name='RED_RAZAO_SOCIAL' required='yes'>
		<cfargument name='OPERACAO_ID_CTRC' required='yes'>
		<cfargument name='SUBSTITUTO' required='no' default="">
		<cfargument name='CONHECIMENTO_TIPO_ID' required='no' default="">
		<cfargument name='TERCEIRO' required='no' default="">
		<cfargument name='REM_COD_ENDERECO' required='yes'>
		<cfargument name='COLETA_COD_ENDERECO' required='yes'>
		<cfargument name='DEST_COD_ENDERECO' required='yes'>
		<cfargument name='RED_COD_ENDERECO' required='yes'>
		<cfargument name='COB_COD_ENDERECO' required='yes'>
		<cfargument name='OPERACAO_ID' required='no' default="">
		<cfargument name='ORGANIZACIONAL_ID' required='no' default="">
		<cfargument name='TIPO_SERVICO_COMERCIAL' required='no' default="">
		<cfargument name='DISPENSADO_TABELA_FRETE' required='no' default="">
		<cfargument name='USUARIO_LIBERACAO' required='no' default="">
		<cfargument name='SENHA_LIBERACAO' required='no' default="">
		<cfargument name='NEG_COD_ENDERECO' required='no' default="">
		<cfargument name='PLACA_REFERENCIA_INTERNA' required='no' default="">
		<cfargument name='CONHECIMENTO_ID_SUBST' required='no' default="">
		<cfargument name='MOTIVO_SUBSTITUICAO_ID' required='no' default="">
		<cfargument name='EMITE_POR_TABELA_FRETE' required='no' default="">
		<cfargument name='BASE_CALC_MAIOR_TOTAL' required='no' default="">
		<cfargument name='TAG_OPERACAO_OBS_CONTRIB_ID' required='no' default="">
		<cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default="">
		<cfargument name='DESTINO_MUNICIPIO_ID' required='no' default="">
		<cfargument name='FRETE_EM' required='no' default="">
		<cfargument name='SOLICITACAO_CARGA_ID' required='no' default="">
		<cfargument name='VARS_PLACA_REFERENCIA' required='no' default="">
		<cfargument name='PLACAS_COMPOSICAO' required='no' default="">
		<cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='COLETA_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='RED_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='NEG_INSCRICAO_ESTADUAL' required='no'>
		<cfargument name='CADASTRO' required='no' default="">
		<cfargument name='CARGA_CONSOLIDADA_ID' required='no' default="">
        <cfargument name='CADASTRADO_ANTERIORMENTE' required='no' default="0">
  <cftry>
			<cftransaction action='begin'>
                <!--Executa a logica do CT-e-->

                <cfset arguments = this.ins_cte_body(argumentCollection = arguments)>

                <cfset arguments = this.ins_cte_prc(argumentCollection = arguments)>

                <cfset arguments.conhecimento_id = retorno.conhecimento_id>
                <cfset retorno.num_romaneio 	= arguments.num_romaneio>
				<!--- Insere Notas--->
                <cfscript>
                    ins_notas = this.ins_nfs_cte(argumentCollection = arguments);
                </cfscript>
                <cfif ins_notas.erro>
                    <cfthrow object="#ins_notas.mensagem#">
                </cfif>
                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfif arguments.EMITE_TABELA_FRETE eq 1>
					<cfscript>
                        	retorno_tabela = this.calcula_tabela_frete(argumentCollection = arguments);
                	</cfscript>
                	<cfif retorno_tabela.erro>
                    	<cfthrow object="#retorno_tabela.mensagem#">
                	</cfif>
                </cfif>
                <!--- Insero dos Impostos do Conhecimento --->
                <cfscript>
					ret_imp = this.ins_ctrc_imposto(argumentCollection = arguments);
				</cfscript>
				<cfif ret_imp.erro>
					<cfthrow object="#ret_imp.mensagem#">
				</cfif>
                <!--- Valida a obrigatoriedade dos impostos --->
                <cfif arguments.TABELA_FRETE_MODELO_ID eq 2>
					<cfscript>
                        ret_imp_obrig = this.valida_imp_config_obrig(argumentCollection = arguments);
                    </cfscript>
                    <cfif ret_imp_obrig.erro>
                        <cfthrow object="#ret_imp_obrig.mensagem#">
                    </cfif>
                </cfif>
				<!--- Insero dos Vales Pedgio --->
				<cfif arguments.UTILIZA_VALE_PEDAGIO eq 1>
                <cfscript>
					retorno_valeped = this.ins_vale_pedagio(argumentCollection = arguments);
                </cfscript>
                <cfif retorno_valeped.erro>
                    <cfthrow object="#retorno_valeped.mensagem#">
                </cfif>
                </cfif>
                <!--- Insero dos Documentos Anteriores --->
                <cfscript>
   				    argument.conhecimento_id = retorno.conhecimento_id;
					ret = this.ins_docto_anterior(argumentCollection = arguments);
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
				<!--- Insere CTes referenciados--->
                <cfscript>
                    ins_ctes_ref = this.ins_ctes_ref(argumentCollection = arguments);
                </cfscript>
                <cfif ins_ctes_ref.erro>
                    <cfthrow object="#ins_ctes_ref.mensagem#">
                </cfif>                
				<!--- Insero das Tags --->
                <cfscript>
				       v_oper_obs_id  = ListToArray(arguments.TAG_OPERACAO_OBS_CONTRIB_ID, ",");
   				    argument.conhecimento_id = retorno.conhecimento_id;
				</cfscript>
					<cfloop from="1" to="#ArrayLen(v_oper_obs_id)#" index="count">
                                <cfscript>
								    valor_id = 'TAG_VALOR_'&v_oper_obs_id[count];
                                    ret_tag = this.ins_tags_cte(CONHECIMENTO_ID 		    = arguments.conhecimento_id,
                                                                CONHECIMENTO_OBS_CONTRIB_ID = 0,
                                                                OPERACAO_OBS_CONTRIB_ID		= v_oper_obs_id[count],
                                                                VALOR						= arguments[valor_id]);
                                </cfscript>
                                <cfif ret_tag.erro>
                                    <cfthrow object="#ret_tag.mensagem#">
                                </cfif>
                            </cfloop>
				
                <!--- Valida o CTe --->
				<cfscript>
                        ret_validar = this.valida_cte(CONHECIMENTO_ID = arguments.CONHECIMENTO_ID
						                             ,OPERACAO = 'I');
                </cfscript>
                <cfif ret_validar.erro>
                    <cfthrow object="#ret_validar.mensagem#">/cfif>
                </cfif>
                <!--- Envia CTE para SEFAZ--->
                <cfscript>
                    envia_cte = this.envia_cte(conhecimento_id = retorno.conhecimento_id);
                </cfscript>
                <cfif envia_cte.erro>
                    <cfthrow object="#envia_cte.mensagem#">
                </cfif>
				<cfscript> 
					conn = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
					qrImp = conn.get_gera_CPG_ICMS_antecipado(CONHECIMENTO_ID = arguments.CONHECIMENTO_ID);
				</cfscript>				
				
				<cfif len(trim(qrImp.documento_imposto_id)) >
				<cfset retorno.erro = false>
					<cfset retorno.mensagem = JSStringFormat('CTE inserido com sucesso. Ateno! Este CTe gerar automaticamente um CPG para o ICMS antecipado. Deve ser gerado uma guia GNRE para acompanhar a viagem.')>
				<cfelse>
					<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTE inserido com sucesso.')>
				</cfif>
				
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Inserir Nota Fiscal a CTE
	-- RAFAEL 28/12/2010 09:15:53 - CRIADO
	--->
	<cffunction name='ins_nf_cte' displayname='Inserir Nota Fiscal a CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='NUMERO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='MODELO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='SUB_SERIE' required='yes'>
		<cfargument name='VALOR_TOTAL' required='yes'>
		<cfargument name='NF_ELETRONICA' required='yes'>
		<cfargument name='VALOR_SEGURADO' required='yes'>
		<cfargument name='ORDEM_COMPRA_CLIENTE' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='PESO_CUBADO' required='yes'>
		<cfargument name='PESO_COBRADO' required='yes'>
		<cfargument name='QTDE_VOLUME' required='yes'>
		<cfargument name='ALTURA' required='yes'>
		<cfargument name='COMPRIMENTO' required='yes'>
		<cfargument name='LARGURA' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='CUBAGEM' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='COMPLEMENTO' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='TIPO_DOCUMENTO_ID' required='yes'>
		<cfargument name='TIPO_DOC_OUTROS' required='no' default="99">
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='VALOR_BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_BASE_CALCULO_ICMS_ST' required='yes'>
		<cfargument name='VALOR_ICMS_ST' required='yes'>
		<cfargument name='VALOR_PRODUTOS' required='yes'>
		<cfargument name='CFOP' required='yes'>
		<cfargument name='PIN_SUFRAMA' required='yes'>
		<cfargument name='CHAVE_ACESSO_NFE' required='yes'>
		<cfargument name='DESCRICAO_DOCTO' required='yes'>
		<cfargument name='NFE_XML' required='no' default="">
		<cfargument name='VERIFICAR_NF' required='no' default="1">
      <cfargument name='DOCUMENTO_ID' required='no' default="">
      <cfargument name='ICMS_PARTILHADO' required='no' default="0">
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_cte.prc_ins_nf_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.NUMERO#'  null='#iif(len(trim(arguments.NUMERO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODELO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SUB_SERIE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_TOTAL#'  null='#iif(len(trim(arguments.VALOR_TOTAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NF_ELETRONICA#'  null='#iif(len(trim(arguments.NF_ELETRONICA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_SEGURADO#'  null='#iif(len(trim(arguments.VALOR_SEGURADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ORDEM_COMPRA_CLIENTE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_CUBADO#'  null='#iif(len(trim(arguments.PESO_CUBADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_COBRADO#'  null='#iif(len(trim(arguments.PESO_COBRADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.QTDE_VOLUME#'  null='#iif(len(trim(arguments.QTDE_VOLUME)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALTURA#'  null='#iif(len(trim(arguments.ALTURA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COMPRIMENTO#'  null='#iif(len(trim(arguments.COMPRIMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.LARGURA#'  null='#iif(len(trim(arguments.LARGURA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CUBAGEM#'  null='#iif(len(trim(arguments.CUBAGEM)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPLEMENTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_DOCUMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_DOCUMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_ROMANEIO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.VALOR_BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_BASE_CALCULO_ICMS_ST#'  null='#iif(len(trim(arguments.VALOR_BASE_CALCULO_ICMS_ST)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS_ST#'  null='#iif(len(trim(arguments.VALOR_ICMS_ST)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_PRODUTOS#'  null='#iif(len(trim(arguments.VALOR_PRODUTOS)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CFOP#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PIN_SUFRAMA#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE_ACESSO_NFE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DESCRICAO_DOCTO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_LONGVARCHAR'   value='#arguments.NFE_XML#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VERIFICAR_NF#'  null='#iif(len(trim(arguments.VERIFICAR_NF)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ICMS_PARTILHADO#' null='#iif(len(trim(arguments.ICMS_PARTILHADO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  value='#arguments.TIPO_DOC_OUTROS#'>
            </cfstoredproc>
			<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Busca Chave da NFE
	-- RAFAEL 16/07/2010 14:11:15 - CRIADO
	--->
	<cffunction name='busca_chave_nfe' displayname='Busca Chave da NFE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONTEUDO' required='yes'>
		<cfargument name='CONHECIMENTO_ID_SUBST' required='no'>
		<cftry>
        	<!---L o arquivo--->
            <cffile action="read" file="#arguments.CONTEUDO#" variable="VARQUIVO">

				<!---Busca os dados da NFE--->
                <cfscript>
                    conn = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
                </cfscript>

				<cfif IsDefined('arguments.CONHECIMENTO_ID_SUBST')>
					<cfscript>
						dados = conn.get_nfe_dados(NFE = VARQUIVO
						                          ,CONHECIMENTO_ID = arguments.CONHECIMENTO_ID_SUBST);
					</cfscript>
				<cfelse>
					<cfscript>
						dados = conn.get_nfe_dados(NFE = VARQUIVO
                                                  ,CONHECIMENTO_ID = '');
					</cfscript>
				</cfif>

                <cfif dados.erro>
                    <cfthrow object="#dados.mensagem#">
                <cfelse>
                    <cfset retorno.chave = dados.chave>
                    <cfset retorno.numero = dados.numero>
                    <cfset retorno.serie = dados.serie>
                    <cfset retorno.data_emissao = dados.data_emissao>
                    <cfset retorno.cnpj_emitente = dados.cnpj_emitente>
                    <cfset retorno.emitente = dados.emitente>
                    <cfset retorno.cnpj_destinatario = dados.cnpj_destinatario>
                    <cfset retorno.destinatario = dados.destinatario>
                    <cfset retorno.valor = dados.valor>
                    <cfset retorno.peso = dados.peso>
                    <cfset retorno.especie = dados.especie>
                    <cfset retorno.num_especie = dados.num_especie>
                    <cfset retorno.cfop = dados.cfop>
                    <cfset retorno.volumes = dados.volumes>
                    <cfset retorno.icms_partilhado = dados.icms_partilhado>

			</cfif>

			<!---Envia o Arquivo para o Servidor--->
            <cffile action="upload" destination="#expandPath("/")#temp" file="#arguments.CONTEUDO#" nameconflict="makeunique" result="VCONTEUDO" filefield="CONTEUDO">

            <cfset retorno.nome_arquivo = VCONTEUDO.serverfile>
            <cfset retorno.erro = false>
            <cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>

		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Busca Chave do CTe
	-- JAQUELINEF 08/04/2014
	--->
	<cffunction name='busca_chave_cte' displayname='Busca Chave do CTe' access='remote' returntype='Struct' output='true'>
		<cfargument name='XMLCTE' required='no' default="">
		<cfargument name='CHAVECTE' required='no' default="">
		<cftry>
        	<cfif Len(Trim(arguments.XMLCTE))>
				<!---L o arquivo--->
                <cffile action="read" file="#arguments.XMLCTE#" variable="VARQUIVO">
            <cfelse>
            	<cfset VARQUIVO = ''>
            </cfif>
				<!---Busca os dados da NFE--->
                <cfscript>
                    conn = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
                </cfscript>

                <cfscript>
                    dados = conn.get_cte_dados(CTE = VARQUIVO, CHAVE = arguments.CHAVECTE);
                </cfscript>
                <cfif dados.erro>
                    <cfthrow object="#dados.mensagem#">
                <cfelse>
                    <cfset retorno.chave = dados.chave>
                    <cfset retorno.cuf = dados.cuf>
                    <cfset retorno.aamm = dados.aamm>
                    <cfset retorno.cnpj = dados.cnpj>
                    <cfset retorno.mod = dados.mod>
                    <cfset retorno.serie = dados.serie>
                    <cfset retorno.nct = dados.nct>
                    <cfset retorno.tpemis = dados.tpemis >
                    <cfset retorno.cct = dados.cct>
                    <cfset retorno.cdv = dados.cdv>
                    <cfset retorno.emit = dados.emit>
                </cfif>
             <cfset retorno.mensagem = 'ok'>
            <cfset retorno.erro = false>
            <cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>

		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Enviar CTE para SEFAZ
	-- RAFAEL 27/07/2010 09:39:17 - CRIADO
	--->
	<cffunction name='envia_cte' displayname='Enviar CTE para SEFAZ' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_cte.prc_envia_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Atualizar o status do CTE
	-- RAFAEL 27/07/2010 14:01:21 - CRIADO
	--->
	<cffunction name='consulta_status' displayname='Atualizar o status do CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_consulta_status' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>

                <cfscript>
					conn = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
					qrStatus = conn.get_cte_resumo(CONHECIMENTO_ID = arguments.CONHECIMENTO_ID);
				</cfscript>
                <cfset retorno.cod_status = qrStatus.cod_status>
                <cfset retorno.situacao_id = qrStatus.situacao_id>
                <cfset retorno.descricao_status = qrStatus.descricao_status>
                <cfset retorno.permite_editar = qrStatus.permite_editar>
                <cfset retorno.emitido = qrStatus.emitido>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Status do CTE atualizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Atualizar os dados do CTE e Reenvia para SEFAZ
	-- RAFAEL 27/07/2010 14:40:12 - CRIADO
	--->
	<cffunction name='atualiza_cte' displayname='Atualizar os dados do CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_atualiza_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>

                <!--- Envia CTE para SEFAZ--->
                <cfscript>
					envia_cte = this.envia_cte(conhecimento_id = arguments.conhecimento_id);
				</cfscript>
				<cfif envia_cte.erro>
					<cfthrow object="#envia_cte.mensagem#">
				</cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTE reenviado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Cancelar CTE
	-- RAFAEL 03/08/2010 17:03:33 - CRIADO
	--->
	<cffunction name='cancela_cte' displayname='Cancelar CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='MOTIVO_CANCELAMENTO_ID' required='yes'>
		<cfargument name='OBS_CANCELAMENTO' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_can_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.MOTIVO_CANCELAMENTO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBS_CANCELAMENTO#' >
				</cfstoredproc>
				
				<cfscript>
					conn          = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
					qrValePedagio = conn.verifica_vale_pedagio(CONHECIMENTO_ID = arguments.CONHECIMENTO_ID);
				</cfscript>
				
				<cfset retorno.erro = false>
				
				<cfif qrValePedagio.cancelar_vp_manual eq 0>
					<cfset retorno.mensagem = JSStringFormat('CTE cancelado com sucesso.')>
				<cfelse>
					<cfset retorno.mensagem = JSStringFormat('CTE cancelado com sucesso, porm no foi possvel cancelar o vale pedgio. Realize o cancelamento manualmente pelo KMM.')>
				</cfif>
				
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Inutiliza a Numerao do CTE
	-- RAFAEL 30/11/2010 10:08:26 - CRIADO
	--->
	<cffunction name='prc_inutilizar_cte' displayname='Inutiliza a Numerao do CTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='MOTIVO_INUTILIZACAO_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_inutilizar_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.MOTIVO_INUTILIZACAO_ID#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTE inutilizado.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Gerar PDF do DACTE
	-- RAFAEL 10/09/2010 14:54:31 - CRIADO
	--->
	<cffunction name='gerar_dacte' displayname='Gerar PDF do DACTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='DECLARACAO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_impressao_cte.prc_gerar_dacte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DECLARACAO#'  null='#iif(len(trim(arguments.DECLARACAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dacte gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
    -- Gerar Carta de Correo Eletrnica para CT-e
    -- FELIPEBUENO 03/07/2014 11:02:25 - CRIADO
    --->
    <cffunction name='gerar_carta_correcao_e' displayname='Gerar Carta de Correo Eletrnica para CT-e' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cftry>
            <cftransaction action='begin'>
                <cfstoredproc procedure='fiscal.pkg_impressao_cte.prc_gerar_carta_correcao_e' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value=0>
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
                </cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Carta de Correo Eletrnica gerada com sucesso.')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Enviar email contendo o XML e o DACTE
	-- RAFAEL 22/09/2010 08:48:42 - CRIADO
	--->
	<cffunction name='envia_email' displayname='Enviar email contendo o XML e o DACTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='TIPO_EMAIL' required='yes'>
		<cfargument name='EMAIL' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte_email.prc_envia_email' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_EMAIL#'  null='#iif(len(trim(arguments.TIPO_EMAIL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.EMAIL#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('E-mail gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Gerar CTE de Complemento
	-- RAFAEL 01/04/2011 11:43:11 - CRIADO
	--->
	<cffunction name='gera_cte_complemento' displayname='Gerar CTE de Complemento' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID_COMPLEM' required='yes'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='SERIE' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='REDUCAO_BASE_ICMS' required='no' default="0">
		<cfargument name='REDUCAO_BASE_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='BASE_CALCULO_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='ALIQUOTA_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='VALOR_ICMS_PRESUMIDO' required='no' default="0">
        <cfargument name='ST_ICMS_ID' required='no' default=''>
        <cfargument name='ORGANIZACIONAL_ID' required='no' default="">
        <cfargument name='COD_ORGANIZACIONAL' required='no' default="">
        <cfargument name='CONHECIMENTO_TIPO_ID' required='no' default="">
        <cfargument name='USUARIO_LIBERACAO' required='no' default="">
        <cfargument name='SENHA_LIBERACAO' required='no' default="">
        <cfargument name='VALOR_FATURAMENTO' required='no' default="">
        <cfargument name='BASE_CALCULO_ISS' required='no' default="">
        <cfargument name='ALIQUOTA_ISS' required='no' default="">
        <cfargument name='VALOR_ISS' required='no' default="">
        <cfargument name='TABELA_FRETE_MODELO_ID' required='no' default="">
        <cfargument name='COD_CLIENTE_COBRANCA' required="no" default="">
        <cfargument name='COB_COD_ENDERECO' required="no" default="">
        <cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>

	    <cfargument name='COLETA_INSCRICAO_ESTADUAL' required='yes'>
	    <cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
	    <cfargument name='RED_INSCRICAO_ESTADUAL' required='yes'>
	    <cfargument name='NEG_INSCRICAO_ESTADUAL' required='no'>
        <cfargument name='TIPO_COMPLEMENTO_ID' required='no' default="">
		<cfargument name='TIPO_SERVICO_COMERCIAL' required='no' default="">
		<cftry>
            <cfif IsDefined('arguments.TABELA_FRETE_MODELO_ID') and arguments.TABELA_FRETE_MODELO_ID eq 2 or 
  			      (IsDefined('arguments.DISPENSADO_TABELA_FRETE') and arguments.DISPENSADO_TABELA_FRETE eq 0
				  and IsDefined('arguments.COMPLEMENTO')             and arguments.COMPLEMENTO             eq 1
				  and IsDefined('arguments.EMITIR_POR_TABELA_FRETE') and arguments.EMITIR_POR_TABELA_FRETE eq 1 <!--- baseado na funo fiscal.pkg_cte.fnc_emite_cte_diaria_tf --->
				  and IsDefined('arguments.CONHECIMENTO_TIPO_ID')    and IsDefined('arguments.COD_TIPO_CONHECIMENTO_DIARIA') and arguments.CONHECIMENTO_TIPO_ID  eq arguments.COD_TIPO_CONHECIMENTO_DIARIA)>

               <cfset arguments.EMITIDO_POR_TABELA_FRETE = 1>
            <cfelse>
                <cfset arguments.EMITIDO_POR_TABELA_FRETE = 0>
            </cfif>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_gera_cte_complemento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID_COMPLEM#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_COMPLEM)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONHECIMENTO#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' variable='retorno.DATA_EMISSAO' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONHECIMENTO_ID' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.RELACAO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REDUCAO_BASE_ICMS#'  null='#iif(len(trim(arguments.REDUCAO_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REDUCAO_BASE_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.REDUCAO_BASE_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BASE_CALCULO_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALIQUOTA_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS_PRESUMIDO#'  null='#iif(len(trim(arguments.VALOR_ICMS_PRESUMIDO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#Trim(arguments.ST_ICMS_ID)#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANIZACIONAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_TIPO_ID)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO_LIBERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SENHA_LIBERACAO#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.EMITIDO_POR_TABELA_FRETE#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_FATURAMENTO#'  null='#iif(len(trim(arguments.VALOR_FATURAMENTO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BASE_CALCULO_ISS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ISS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALIQUOTA_ISS#'  null='#iif(len(trim(arguments.ALIQUOTA_ISS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ISS#'  null='#iif(len(trim(arguments.VALOR_ISS)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TABELA_FRETE_MODELO_ID#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COB_COD_ENDERECO#'  null='#iif(len(trim(arguments.COB_COD_ENDERECO)), de('no'), de('yes'))#'>
                    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REM_INSCRICAO_ESTADUAL#' >
				    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_INSCRICAO_ESTADUAL#' >
				    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
				    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_INSCRICAO_ESTADUAL#' >
				    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COB_INSCRICAO_ESTADUAL#' >
				    <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NEG_INSCRICAO_ESTADUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TIPO_SERVICO_COMERCIAL#' >
                    <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_COMPLEMENTO_ID#'  null='#iif(len(trim(arguments.TIPO_COMPLEMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                <cfset arguments.CONHECIMENTO_ID = retorno.CONHECIMENTO_ID>
                <!--- Vincula CTe ao Romaneio--->
				<cfif Len(Trim(arguments.COMPLEMENTO_NUM_ROMANEIO))>
					<cfscript>
                        vincula_romaneio = this.vincula_conhecimento_romaneio(num_romaneio		= arguments.COMPLEMENTO_NUM_ROMANEIO
                                                                             ,item_id			= arguments.COMPLEMENTO_ROMANEIO_ITEM_ID
                                                                             ,conhecimento_id	= retorno.conhecimento_id);
                    </cfscript>
                    <cfif vincula_romaneio.erro>
                        <cfthrow object="#vincula_romaneio.mensagem#">
                    </cfif>
                </cfif>

                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfif IsDefined('arguments.TABELA_FRETE_MODELO_ID') and arguments.TABELA_FRETE_MODELO_ID eq 2 or 
  			          (IsDefined('arguments.DISPENSADO_TABELA_FRETE') and arguments.DISPENSADO_TABELA_FRETE eq 0
				      and IsDefined('arguments.COMPLEMENTO')             and arguments.COMPLEMENTO             eq 1
				      and IsDefined('arguments.EMITIR_POR_TABELA_FRETE') and arguments.EMITIR_POR_TABELA_FRETE eq 1 <!--- baseado na funo fiscal.pkg_cte.fnc_emite_cte_diaria_tf --->
					  and IsDefined('arguments.CONHECIMENTO_TIPO_ID')    and IsDefined('arguments.COD_TIPO_CONHECIMENTO_DIARIA') and arguments.CONHECIMENTO_TIPO_ID  eq arguments.COD_TIPO_CONHECIMENTO_DIARIA)>
					<cfscript>
                        	retorno_tabela = this.calcula_tabela_frete(argumentCollection = arguments);
                	</cfscript>
                	<cfif retorno_tabela.erro>
                    	<cfthrow object="#retorno_tabela.mensagem#">
                	</cfif>
                </cfif>
                <!--- /// --->

                <!--- Insero dos Impostos do Conhecimento --->
                <cfscript>
					ret_imp = this.ins_ctrc_imposto(argumentCollection = arguments);
				</cfscript>
				<cfif ret_imp.erro>
					<cfthrow object="#ret_imp.mensagem#">
				</cfif>
				<!--- Insere CTes referenciados--->
                <cfscript>
                    ins_ctes_ref = this.ins_ctes_ref(argumentCollection = arguments);
                </cfscript>
                <cfif ins_ctes_ref.erro>
                    <cfthrow object="#ins_ctes_ref.mensagem#">
                </cfif>
				
				<!--- Insero das Tags --->
				<cfif IsDefined('arguments.TAG_OPERACAO_OBS_CONTRIB_ID') and Len(Trim(arguments.TAG_OPERACAO_OBS_CONTRIB_ID))>
					<cfscript>
						   v_oper_obs_id  = ListToArray(arguments.TAG_OPERACAO_OBS_CONTRIB_ID, ",");
						argument.conhecimento_id = retorno.conhecimento_id;
					</cfscript>
					<cfloop from="1" to="#ArrayLen(v_oper_obs_id)#" index="count">
						<cfscript>
							valor_id = 'TAG_VALOR_'&v_oper_obs_id[count];
							ret_tag = this.ins_tags_cte(CONHECIMENTO_ID 		    = arguments.conhecimento_id,
														CONHECIMENTO_OBS_CONTRIB_ID = 0,
														OPERACAO_OBS_CONTRIB_ID		= v_oper_obs_id[count],
														VALOR						= arguments[valor_id]);
						</cfscript>
						<cfif ret_tag.erro>
							<cfthrow object="#ret_tag.mensagem#">
						</cfif>
					</cfloop>
				</cfif>
				
                <!--- Envia CTE para SEFAZ--->
				<cfscript>
                    envia_cte = this.envia_cte(conhecimento_id = retorno.conhecimento_id);
                </cfscript>
                <cfif envia_cte.erro>
                    <cfthrow object="#envia_cte.mensagem#">
                </cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Complemento de CTE gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Liberar o CTe para impresso
	-- RAFAEL 30/06/2011 19:00:22 - CRIADO
	--->
	<cffunction name='cte_liberado_impressao' displayname='Liberar o CTe para impresso' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_cte_liberado_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTe liberado para impresso com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Efetua edio do CTe
	-- RAFAEL 01/07/2011 10:55:23 - CRIADO
	--->
	<cffunction name='alt_cte' displayname='Efetua edio do CTe' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_CONHECIMENTO' required='yes'>
		<cfargument name='ITEM_ID' required='yes'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COD_PESSOA_FILIAL' required='yes'>
		<cfargument name='COD_DEPARTAMENTO' required='yes'>
		<cfargument name='COD_SETOR' required='yes'>
		<cfargument name='COD_CENTRO_CUSTO' required='yes'>
		<cfargument name='DATA_EMISSAO' required='yes'>
		<cfargument name='NUM_PRODUTO' required='yes'>
		<cfargument name='SERIE' required='no'>
		<cfargument name='ST_ORIGEM_ID' required='yes'>
		<cfargument name='ST_ICMS_ID' required='yes'>
		<cfargument name='PAGADOR' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='COD_REDESPACHO' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_UNITARIO' required='yes'>
		<cfargument name='FRETE_PESO' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='BASE_CALCULO_ICMS' required='yes'>
		<cfargument name='ALIQUOTA_ICMS' required='yes'>
		<cfargument name='ADEME' required='yes'>
		<cfargument name='DESCONTO' required='yes'>
		<cfargument name='SEC_CAT' required='yes'>
		<cfargument name='GRIS' required='yes'>
		<cfargument name='PEDAGIO' required='yes'>
		<cfargument name='VALOR_ICMS' required='yes'>
		<cfargument name='VALOR_ICMS_SUBSTIT' required='yes'>
		<cfargument name='COLETA_ENTREGA' required='yes'>
		<cfargument name='IMPOSTOS' required='yes'>
		<cfargument name='TOTAL_CONHECIMENTO' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='COLETA_ENDERECO' required='yes'>
		<cfargument name='COLETA_COMPLEMENTO' required='no' default="null">
		<cfargument name='COLETA_BAIRRO' required='yes'>
		<cfargument name='COLETA_CEP' required='yes'>
		<cfargument name='COLETA_UF' required='yes'>
		<cfargument name='RED_ENDERECO' required='yes'>
		<cfargument name='RED_COMPLEMENTO' required='no' default="null">
		<cfargument name='RED_BAIRRO' required='yes'>
		<cfargument name='RED_CEP' required='yes'>
		<cfargument name='RED_UF' required='yes'>
		<cfargument name='PLACA_CONTROLE' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='NOME_MOTORISTA' required='yes'>
		<cfargument name='COD_PROPRIETARIO' required='yes'>
		<cfargument name='PROP_CNPJ_CPF' required='yes'>
		<cfargument name='PROP_RAZAO_SOCIAL' required='yes'>
		<cfargument name='PROP_ENDERECO' required='yes'>
		<cfargument name='PROP_UF' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='RODAPE' required='yes'>
		<cfargument name='ENTRADA_DADOS' required='yes'>
		<cfargument name='TIPO_CONHECIMENTO' required='no' default="0">
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='TEM_NOTA' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_MUNICIPIO_ID' required='yes'>
		<cfargument name='CARGA_ID' required='yes'>
		<cfargument name='COD_CLIENTE_COBRANCA' required='yes'>
		<cfargument name='COB_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COB_ENDERECO' required='yes'>
		<cfargument name='COB_MUNICIPIO' required='yes'>
		<cfargument name='COB_UF' required='yes'>
		<cfargument name='COB_CEP' required='yes'>
		<cfargument name='COB_CNPJ_CPF' required='yes'>
		<cfargument name='COB_INSCRICAO_ESTADUAL' required='yes'>
		<cfargument name='PRAZO_ENTREGA' required='yes'>
		<cfargument name='COD_ORGANOGRAMA_GERENCIAL' required='yes'>
		<cfargument name='REGRA_FISCAL_ID' required='yes'>
		<cfargument name='PLACA_TRACAO' required='yes'>
		<cfargument name='CONHECIMENTO_ID_SUB_CONTR' required='no' default="">
		<cfargument name='REDUCAO_BASE_ICMS' required='no' default="0">
		<cfargument name='REDUCAO_BASE_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='BASE_CALCULO_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='ALIQUOTA_ICMS_SUBSTIT' required='no' default="0">
		<cfargument name='VALOR_ICMS_PRESUMIDO' required='no' default="0">
		<cfargument name='NUM_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='SERIE_CONHECIMENTO_SUB_CONTR' required='no' default="">
		<cfargument name='BASE_CALCULO_ISS' required='no' default="0">
		<cfargument name='ALIQUOTA_ISS' required='no' default="0">
		<cfargument name='VALOR_ISS' required='no' default="0">
		<cfargument name='VALOR_FATURAMENTO' required='no' default="0">
		<cfargument name='CFOP' required='yes'>
		<cfargument name='CFOP_ID' required='yes'>
		<cfargument name='NATUREZA_OPERACAO' required='yes'>
		<cfargument name='FUNDAMENTACAO_LEGAL' required='yes'>
		<cfargument name='COD_NEGOCIADOR' required='yes'>
		<cfargument name='PESO_KG' required='yes'>
		<cfargument name='TIPO_VENDA' required='no' default="1">
		<cfargument name='REM_ENDERECO_NUM' required='yes'>
		<cfargument name='REM_BAIRRO' required='yes'>
		<cfargument name='REM_MUNICIPIO_ID' required='yes'>
		<cfargument name='DEST_ENDERECO_NUM' required='yes'>
		<cfargument name='DEST_BAIRRO' required='yes'>
		<cfargument name='DEST_MUNICIPIO_ID' required='yes'>
		<cfargument name='RED_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_ENDERECO_NUM' required='yes'>
		<cfargument name='COB_BAIRRO' required='yes'>
		<cfargument name='COB_MUNICIPIO_ID' required='yes'>
		<cfargument name='CTRC_FATURAMENTO' required='no' default="0">
		<cfargument name='MODELO_DOCUMENTO' required='no' default="57">
		<cfargument name='TIPO_SERVICO_ID' required='no' default="0">
		<cfargument name='COLETA_COD_PESSOA' required='yes'>
		<cfargument name='COLETA_CNPJ_CPF' required='yes'>
		<cfargument name='COLETA_RAZAO_SOCIAL' required='yes'>
		<cfargument name='COLETA_ENDERECO_NUM' required='yes'>
		<cfargument name='RED_CNPJ_CPF' required='yes'>
		<cfargument name='RED_RAZAO_SOCIAL' required='yes'>
   <cfargument name='OPERACAO_ID_CTRC' required='yes'>
   <cfargument name='SUBSTITUTO' required='no' default="">
   <cfargument name='CONHECIMENTO_TIPO_ID' required='no' default="">
   <cfargument name='TIPO_SERVICO_COMERCIAL' required='no' default="">
   <cfargument name='DISPENSADO_TABELA_FRETE' required='no' default="">
   <cfargument name='USUARIO_LIBERACAO' required='no' default="">
   <cfargument name='SENHA_LIBERACAO' required='no' default="">
   <cfargument name='NEG_COD_ENDERECO' required='no' default="">
   <cfargument name='PLACA_REFERENCIA_INTERNA' required='no' default="">
   <cfargument name='ORIGEM_MUNICIPIO_ID' required='no' default="">
   <cfargument name='DESTINO_MUNICIPIO_ID' required='no' default="">
   <cfargument name='SOLICITACAO_CARGA_ID' required='no' default="">
   <cfargument name='TAG_CONHECIMENTO_OBS_CONTRIB_ID' required='no' default="">
   <cfargument name='TAG_OPERACAO_OBS_CONTRIB_ID' required='no' default="">
   <cfargument name='REM_INSCRICAO_ESTADUAL' required='yes'>
   <cfargument name='COLETA_INSCRICAO_ESTADUAL' required='yes'>
   <cfargument name='DEST_INSCRICAO_ESTADUAL' required='yes'>
   <cfargument name='RED_INSCRICAO_ESTADUAL' required='yes'>
   <cfargument name='NEG_INSCRICAO_ESTADUAL' required='yes'>
		<cftry>
			<cftransaction action='begin'>

                <cfif Len(Trim(arguments.PLACA_REFERENCIA_INTERNA))>
                	<cfset vars.v_placa_referencia = #arguments.PLACA_REFERENCIA_INTERNA# & ','>
                    <cfset vars.v_placa_referencia = ListGetAt(vars.v_placa_referencia, 1, ',')>
                    <cfset arguments.placas_composicao = arguments.placa_tracao & ',' & arguments.PLACA_REFERENCIA_INTERNA >
                    <cfset arguments.placas_composicao = arguments.placa_tracao & ',' & arguments.PLACA_REFERENCIA_INTERNA >
                <cfelse>
                    <cfset vars.v_placa_referencia = ''>
                    <cfset arguments.placas_composicao = arguments.placa_tracao>
                    <cfset arguments.placas_composicao = arguments.placa_tracao>
                </cfif>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_alt_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONHECIMENTO#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ITEM_ID#' variable='retorno.ITEM_ID'  null='#iif(len(trim(arguments.ITEM_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ROMANEIO#' variable='retorno.NUM_ROMANEIO'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PESSOA_FILIAL#'  null='#iif(len(trim(arguments.COD_PESSOA_FILIAL)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DEPARTAMENTO#'  null='#iif(len(trim(arguments.COD_DEPARTAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_SETOR#'  null='#iif(len(trim(arguments.COD_SETOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CENTRO_CUSTO#'  null='#iif(len(trim(arguments.COD_CENTRO_CUSTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_PRODUTO#'  null='#iif(len(trim(arguments.NUM_PRODUTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ST_ORIGEM_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ST_ICMS_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PAGADOR#'  null='#iif(len(trim(arguments.PAGADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO#' variable='retorno.PESO'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRETE_UNITARIO#'  null='#iif(len(trim(arguments.FRETE_UNITARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRETE_PESO#'  null='#iif(len(trim(arguments.FRETE_PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BASE_CALCULO_ICMS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALIQUOTA_ICMS#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ADEME#'  null='#iif(len(trim(arguments.ADEME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESCONTO#'  null='#iif(len(trim(arguments.DESCONTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SEC_CAT#'  null='#iif(len(trim(arguments.SEC_CAT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GRIS#'  null='#iif(len(trim(arguments.GRIS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PEDAGIO#'  null='#iif(len(trim(arguments.PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS#'  null='#iif(len(trim(arguments.VALOR_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.VALOR_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_ENTREGA#'  null='#iif(len(trim(arguments.COLETA_ENTREGA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTOS#'  null='#iif(len(trim(arguments.IMPOSTOS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TOTAL_CONHECIMENTO#'  null='#iif(len(trim(arguments.TOTAL_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_ENDERECO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_COMPLEMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_CEP#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_UF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#vars.v_placa_referencia#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NOME_MOTORISTA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_PROPRIETARIO#'  null='#iif(len(trim(arguments.COD_PROPRIETARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' variable='retorno.OBSERVACAO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RODAPE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='2'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_CONHECIMENTO#'  null='#iif(len(trim(arguments.TIPO_CONHECIMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CARGA_ID#'  null='#iif(len(trim(arguments.CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_CLIENTE_COBRANCA#'  null='#iif(len(trim(arguments.COD_CLIENTE_COBRANCA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PRAZO_ENTREGA#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANOGRAMA_GERENCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REGRA_FISCAL_ID#'  null='#iif(len(trim(arguments.REGRA_FISCAL_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACA_TRACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID_SUB_CONTR#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID_SUB_CONTR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REDUCAO_BASE_ICMS#'  null='#iif(len(trim(arguments.REDUCAO_BASE_ICMS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REDUCAO_BASE_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.REDUCAO_BASE_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BASE_CALCULO_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.BASE_CALCULO_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALIQUOTA_ICMS_SUBSTIT#'  null='#iif(len(trim(arguments.ALIQUOTA_ICMS_SUBSTIT)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ICMS_PRESUMIDO#'  null='#iif(len(trim(arguments.VALOR_ICMS_PRESUMIDO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_CONHECIMENTO_SUB_CONTR#'  null='#iif(len(trim(arguments.NUM_CONHECIMENTO_SUB_CONTR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE_CONHECIMENTO_SUB_CONTR#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BASE_CALCULO_ISS#'  null='#iif(len(trim(arguments.BASE_CALCULO_ISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALIQUOTA_ISS#'  null='#iif(len(trim(arguments.ALIQUOTA_ISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_ISS#'  null='#iif(len(trim(arguments.VALOR_ISS)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_FATURAMENTO#'  null='#iif(len(trim(arguments.VALOR_FATURAMENTO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CFOP#'  null='#iif(len(trim(arguments.CFOP)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CFOP_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NATUREZA_OPERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FUNDAMENTACAO_LEGAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_NEGOCIADOR#'  null='#iif(len(trim(arguments.COD_NEGOCIADOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.PESO_KG#'  null='#iif(len(trim(arguments.PESO_KG)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_VENDA#'  null='#iif(len(trim(arguments.TIPO_VENDA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REM_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REM_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.REM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DEST_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DEST_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEST_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DEST_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  null="yes">
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_BAIRRO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RED_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.RED_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COB_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COB_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COB_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MODELO_DOCUMENTO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_SERVICO_ID#'  null='#iif(len(trim(arguments.TIPO_SERVICO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_COD_PESSOA#'  null='#iif(len(trim(arguments.COLETA_COD_PESSOA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COD_REDESPACHO#'  null='#iif(len(trim(arguments.COD_REDESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_CNPJ_CPF#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_RAZAO_SOCIAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_ENDERECO_NUM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OPERACAO_ID_CTRC#'  null='#iif(len(trim(arguments.OPERACAO_ID_CTRC)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_TIPO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_TIPO_ID)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORGANIZACIONAL_ID#'  null='#iif(len(trim(arguments.ORGANIZACIONAL_ID)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_ORGANIZACIONAL#' >
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REM_COD_ENDERECO#'  null='#iif(len(trim(arguments.REM_COD_ENDERECO)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COLETA_COD_ENDERECO#'  null='#iif(len(trim(arguments.COLETA_COD_ENDERECO)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DEST_COD_ENDERECO#'  null='#iif(len(trim(arguments.DEST_COD_ENDERECO)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RED_COD_ENDERECO#'  null='#iif(len(trim(arguments.RED_COD_ENDERECO)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.COB_COD_ENDERECO#'  null='#iif(len(trim(arguments.COB_COD_ENDERECO)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.TIPO_SERVICO_COMERCIAL#'  null='#iif(len(trim(arguments.TIPO_SERVICO_COMERCIAL)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DISPENSADO_TABELA_FRETE#'  null='#iif(len(trim(arguments.DISPENSADO_TABELA_FRETE)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.USUARIO_LIBERACAO#' >
     <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SENHA_LIBERACAO#' >
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NEG_COD_ENDERECO#'  null='#iif(len(trim(arguments.NEG_COD_ENDERECO)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.PLACAS_COMPOSICAO#' >
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ORIGEM_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ORIGEM_MUNICIPIO_ID)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DESTINO_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.DESTINO_MUNICIPIO_ID)), de('no'), de('yes'))#'>
     <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.SOLICITACAO_CARGA_ID#'  null='#iif(len(trim(arguments.SOLICITACAO_CARGA_ID)), de('no'), de('yes'))#'>

     <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.REM_INSCRICAO_ESTADUAL#' >
     <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COLETA_INSCRICAO_ESTADUAL#' >
     <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DEST_INSCRICAO_ESTADUAL#' >
     <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.RED_INSCRICAO_ESTADUAL#' >
     <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COB_INSCRICAO_ESTADUAL#' >
     <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NEG_INSCRICAO_ESTADUAL#' >
				</cfstoredproc>

                
				<!--- Insero dos Documentos Anteriores --->
                <cfscript>
   				    ret = this.ins_docto_anterior(argumentCollection = arguments);
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
				
				<!--- Insero dos Vales Pedgio --->
				<cfif arguments.UTILIZA_VALE_PEDAGIO eq 1>
					<cfset retorno.CONHECIMENTO_ID = arguments.CONHECIMENTO_ID>
					<cfscript>
						retorno_valeped = this.ins_vale_pedagio(argumentCollection = arguments);
					</cfscript>
					<cfif retorno_valeped.erro>
						<cfthrow object="#retorno_valeped.mensagem#">
					</cfif>
                </cfif>
				
				<!--- Exclui as NFs de um CTe --->
                <cfscript>
                    del_notas = this.del_cte_nfs(CONHECIMENTO_ID = arguments.CONHECIMENTO_ID);
                </cfscript>
                <cfif del_notas.erro>
                    <cfthrow object="#del_notas.mensagem#">
                </cfif>

                <!--- Insere Notas--->
                <cfscript>
                    ins_notas = this.ins_nfs_cte(argumentCollection = arguments);
                </cfscript>
                <cfif ins_notas.erro>
                    <cfthrow object="#ins_notas.mensagem#">
                </cfif>

                <!--- Verifica se para esse negociador  emitido por tabela de frete. Caso seja, aplica a tabela de frete --->
                <cfif arguments.EMITE_TABELA_FRETE eq 1>
                	<cfscript>
							retorno_tabela = this.calcula_tabela_frete(argumentCollection = arguments);
					</cfscript>
					<cfif retorno_tabela.erro>
						<cfthrow object="#retorno_tabela.mensagem#">
					</cfif>
                </cfif>

                 <!--- Alterao das Tags --->
                <cfscript>
				    v_oper_obs_id  = ListToArray(arguments.TAG_OPERACAO_OBS_CONTRIB_ID, ",");
					v_tags_id	   = ListToArray(arguments.TAG_CONHECIMENTO_OBS_CONTRIB_ID, ",");
				</cfscript>
					<cfloop from="1" to="#ArrayLen(v_oper_obs_id)#" index="count">
                                <cfscript>
								    valor_id = 'TAG_VALOR_'&v_oper_obs_id[count];
                                    ret_tag = this.alt_tags_cte(CONHECIMENTO_ID 		    = arguments.conhecimento_id,
                                                                CONHECIMENTO_OBS_CONTRIB_ID = v_tags_id[count],
                                                                OPERACAO_OBS_CONTRIB_ID		= v_oper_obs_id[count],
                                                                VALOR						= arguments[valor_id]);
                                </cfscript>
                                <cfif ret_tag.erro>
                                    <cfthrow object="#ret_tag.mensagem#">
                                </cfif>
                            </cfloop>

                <!--- Valida o CTe --->
				<cfscript>
                        ret_validar = this.valida_cte(CONHECIMENTO_ID = arguments.CONHECIMENTO_ID
						                             ,OPERACAO = 'U');
                </cfscript>
                <cfif ret_validar.erro>
                    <cfthrow object="#ret_validar.mensagem#">
                </cfif>

				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTe alterado com sucesso')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Inserir Nota Fiscal a CTE
	-- RAFAEL 28/12/2010 09:15:53 - CRIADO
	--->
	<cffunction name='ins_nfs_cte' displayname='Inserir Nota Fiscal a CTE' access='remote' returntype='Struct' output='true'>
    	<cftry>


					<!---Se for substituto no verifica a nota fiscal.--->
                    <cfif arguments.SUBSTITUTO neq 0>
                       <cfset v_verificar_nf = 0>
                    <cfelse>
                       <cfset v_verificar_nf = 1>
                    </cfif>

                    <!---Verifica o Tipo de Documento que vai ser vinculado--->
                    <cfswitch expression="#arguments.tipo_documento_id#">
                        <cfcase value="0">
                            <!--- Insere Notas fiscais --->
                            <cfscript>
                                v_nota_conhecimento  = this.ListaToArray (lista = arguments, variavel = "NF_CONHECIMENTO_ID_NOTAS_FISCAIS");
                                v_numero 	         = this.ListaToArray(lista = arguments, variavel  = "NOTA_NUMERO_NOTAS_FISCAIS");
                                v_data_emissao       = this.ListaToArray(lista = arguments, variavel  = "NOTA_DATA_EMISSAO_NOTAS_FISCAIS");
                                v_serie 	         = this.ListaToArray(lista = arguments, variavel  = "NOTA_SERIE_NOTAS_FISCAIS");
                                v_sub_serie          = this.ListaToArray(lista = arguments, variavel  = "NOTA_SUB_SERIE_NOTAS_FISCAIS");
                                v_modelo             = this.ListaToArray(lista = arguments, variavel  = "NOTA_MODELO_NOTAS_FISCAIS");
                                v_valor		         = this.ListaToArray(lista = arguments, variavel  = "NOTA_VALOR_NOTAS_FISCAIS");
                                v_valor_segurado     = this.ListaToArray(lista = arguments, variavel  = "NOTA_VALOR_SEGURADO_NOTAS_FISCAIS");
                                v_peso               = this.ListaToArray(lista = arguments, variavel  = "NOTA_PESO_NOTAS_FISCAIS");
                                v_peso_cobrado       = this.ListaToArray(lista = arguments, variavel  = 'NOTA_PESO_COBRADO_NOTAS_FISCAIS');
                                v_ordem_compra       = this.ListaToArray(lista = arguments, variavel  = "NOTA_ORDEM_COMPRA_NOTAS_FISCAIS");
                                v_qtde_volume        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_QTDE_VOLUME_NOTAS_FISCAIS');
                                v_cod_unidade        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COD_UNIDADE_NOTAS_FISCAIS');
                                v_m3                 = this.ListaToArray(lista = arguments, variavel  = 'NOTA_M3_NOTAS_FISCAIS');
                                v_peso_cubado        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_PESO_CUBADO_NOTAS_FISCAIS');
                                v_num_natureza       = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NUM_NATUREZA_NOTAS_FISCAIS');
                                v_natureza           = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NATUREZA_NOTAS_FISCAIS');
                                v_complemento        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COMPLEMENTO_NOTAS_FISCAIS');
                                v_num_especie        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_NUM_ESPECIE_NOTAS_FISCAIS');
                                v_especie            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_ESPECIE_NOTAS_FISCAIS');
                                v_altura             = this.ListaToArray(lista = arguments, variavel  = 'NOTA_ALTURA_NOTAS_FISCAIS');
                                v_largura            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_LARGURA_NOTAS_FISCAIS');
                                v_comprimento        = this.ListaToArray(lista = arguments, variavel  = 'NOTA_COMPRIMENTO_NOTAS_FISCAIS');
                                v_cubagem            = this.ListaToArray(lista = arguments, variavel  = 'NOTA_CUBAGEM_NOTAS_FISCAIS');
                                v_cfop				 = this.ListaToArray(lista = arguments, variavel  = 'NOTA_CFOP_NOTAS_FISCAIS');
                            </cfscript>

                            <cfloop from="1" to="#ArrayLen(v_numero)#" index="count">
                                <cfscript>
                                    ret_nf = this.ins_nf_cte(conhecimento_id 				= arguments.conhecimento_id,
                                                             numero							= v_numero[count],
                                                             numero_old						= v_numero[count],
                                                             data_emissao					= v_data_emissao[count],
                                                             modelo							= v_modelo[count],
                                                             serie							= v_serie[count],
                                                             sub_serie						= v_sub_serie[count],
                                                             valor_total					= v_valor[count],
                                                             nf_eletronica					= 0 ,
                                                             valor_segurado					= v_valor_segurado[count],
                                                             ordem_compra_cliente			= v_ordem_compra[count],
                                                             peso							= v_peso[count],
                                                             peso_cubado					= v_peso_cubado[count],
                                                             peso_cobrado					= v_peso_cobrado[count],
                                                             qtde_volume					= v_qtde_volume[count],
                                                             altura							= v_altura[count],
                                                             comprimento					= v_comprimento[count],
                                                             largura						= v_largura[count],
                                                             m3								= v_m3[count],
                                                             cubagem						= v_cubagem[count],
                                                             num_natureza					= v_num_natureza[count],
                                                             complemento					= v_complemento[count],
                                                             num_especie					= v_num_especie[count],
                                                             cod_unidade					= v_cod_unidade[count],
                                                             tipo_documento_id				= arguments.tipo_documento_id,
															 tipo_doc_outros				= '99',
                                                             num_romaneio					= '',
                                                             valor_base_calculo_icms		= '',
                                                             valor_icms						= '',
                                                             valor_base_calculo_icms_st		= '',
                                                             valor_icms_st					= '',
                                                             valor_produtos					= '',
                                                             cfop							= v_cfop[count],
                                                             pin_suframa					= '',
                                                             chave_acesso_nfe				= '',
                                                             descricao_docto				= '',
                                                             nfe_xml						= '',
                                                             verificar_nf                   = v_verificar_nf);
                                </cfscript>
                                <cfif ret_nf.erro>
                                    <cfthrow object="#ret_nf.mensagem#">
                                </cfif>
                            </cfloop>
                        </cfcase>

                        <cfcase value="1">
                            <!--- Insere NFE --->
                            <cfscript>
                               v_nota_conhecimento   = this.ListaToArray (lista = arguments, variavel = "NF_CONHECIMENTO_ID_NFE");
                               v_chave_acesso_nfe    = this.ListaToArray (lista = arguments, variavel = "CHAVE_ACESSO_NFE_NFE");
                               v_nfe_valor           = this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_NFE");
                               v_nfe_valor_segurado  = this.ListaToArray (lista = arguments, variavel = "NFE_VALOR_SEGURADO");
                               v_pin_suframa_nfe     = this.ListaToArray (lista = arguments, variavel = "PIN_SUFRAMA_NFE_NFE");
                               v_nome_arquivo        = this.ListaToArray (lista = arguments, variavel = "NOME_ARQUIVO_NFE");
                               v_data_emissao        = this.ListaToArray (lista = arguments, variavel = "DATA_EMISSAO_NFE");
                               v_numero              = this.ListaToArray (lista = arguments, variavel = "NUMERO_NFE");
                               v_modelo              = this.ListaToArray (lista = arguments, variavel = "MODELO_NFE");
                               v_serie               = this.ListaToArray (lista = arguments, variavel = "SERIE_NFE");
                               v_documento_id        = this.ListaToArray (lista = arguments, variavel = "NFE_DOCUMENTO_ID_NFE");
                               v_peso                = this.ListaToArray (lista = arguments, variavel = "NFE_PESO_NFE");
                               v_peso_cobrado        = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_COBRADO_NFE');
                               v_qtde_volume         = this.ListaToArray (lista = arguments, variavel = 'NFE_QTDE_VOLUME_NFE');
                               v_cod_unidade         = this.ListaToArray (lista = arguments, variavel = 'NFE_COD_UNIDADE_NFE');
                               v_m3                  = this.ListaToArray (lista = arguments, variavel = 'NFE_M3_NFE');
                               v_peso_cubado         = this.ListaToArray (lista = arguments, variavel = 'NFE_PESO_CUBADO_NFE');
                               v_num_natureza        = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_NATUREZA_NFE');
                               v_natureza            = this.ListaToArray (lista = arguments, variavel = 'NFE_NATUREZA_NFE');
                               v_complemento         = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPLEMENTO_NFE');
                               v_num_especie         = this.ListaToArray (lista = arguments, variavel = 'NFE_NUM_ESPECIE_NFE');
                               v_especie             = this.ListaToArray (lista = arguments, variavel = 'NFE_ESPECIE_NFE');
                               v_altura              = this.ListaToArray (lista = arguments, variavel = 'NFE_ALTURA_NFE');
                               v_largura             = this.ListaToArray (lista = arguments, variavel = 'NFE_LARGURA_NFE');
                               v_comprimento         = this.ListaToArray (lista = arguments, variavel = 'NFE_COMPRIMENTO_NFE');
                               v_cubagem             = this.ListaToArray (lista = arguments, variavel = 'NFE_CUBAGEM_NFE');
                               v_ordem_compra        = this.ListaToArray (lista = arguments, variavel = "NFE_ORDEM_COMPRA_NFE");
                               v_cfop                = this.ListaToArray (lista = arguments, variavel = 'NFE_CFOP_NFE');
                               v_icms_partilhado     = this.ListaToArray (lista = arguments, variavel = 'ICMS_PARTILHADO');
                            </cfscript>

                            <cfloop from="1" to="#ArrayLen(v_chave_acesso_nfe)#" index="count">
                                <!--- Busca arquivo --->
                                <cfif Len(Trim(v_nome_arquivo[count]))>
                                    <cffile action="read" file="#expandPath("/")#temp/#v_nome_arquivo[count]#" variable="VARQUIVO">
                                <cfelse>
                                    <cfset VARQUIVO = ''>
                                </cfif>

                                <cfscript>
                                    ret_nfe = this.ins_nf_cte(conhecimento_id             = arguments.conhecimento_id,
                                                              numero                      = v_numero[count],
                                                              numero_old                  = v_numero[count],
                                                              data_emissao                = v_data_emissao[count],
                                                              modelo                      = v_modelo[count],
                                                              serie                       = v_serie[count],
                                                              sub_serie                   = '1',
                                                              valor_total                 = v_nfe_valor[count],
                                                              nf_eletronica               = 1,
                                                              valor_segurado              = v_nfe_valor_segurado[count],
                                                              ordem_compra_cliente        = v_ordem_compra[count],
                                                              peso                        = v_peso[count],
                                                              peso_cubado                 = v_peso_cubado[count],
                                                              peso_cobrado                = v_peso_cobrado[count],
                                                              qtde_volume                 = v_qtde_volume[count],
                                                              altura                      = v_altura[count],
                                                              comprimento                 = v_comprimento[count],
                                                              largura                     = v_largura[count],
                                                              m3                          = v_m3[count],
                                                              cubagem                     = v_cubagem[count],
                                                              num_natureza                = v_num_natureza[count],
                                                              complemento                 = v_complemento[count],
                                                              num_especie                 = v_num_especie[count],
                                                              cod_unidade                 = v_cod_unidade[count],
                                                              tipo_documento_id           = arguments.tipo_documento_id,
															  tipo_doc_outros			  = '99',
                                                              num_romaneio                = '',
                                                              valor_base_calculo_icms     = '',
                                                              valor_icms                  = '',
                                                              valor_base_calculo_icms_st  = '',
                                                              valor_icms_st               = '',
                                                              valor_produtos              = '',
                                                              cfop                        = v_cfop[count],
                                                              pin_suframa                 = v_pin_suframa_nfe[count],
                                                              chave_acesso_nfe            = v_chave_acesso_nfe[count],
                                                              descricao_docto             = '',
                                                              nfe_xml                     = VARQUIVO,
                                                              documento_id                = v_documento_id[count],
                                                              verificar_nf                = v_verificar_nf,
															  icms_partilhado             = v_icms_partilhado[count]);
                                </cfscript>
                                <cfif ret_nfe.erro>
                                    <cfthrow object="#ret_nfe.mensagem#">
                                </cfif>
                            </cfloop>
                        </cfcase>


                        <cfcase value="2">
                            <!--- Insere Outros Documentos--->
                            <cfscript>
                                v_nota_conhecimento  	= this.ListaToArray (lista = arguments, variavel = "NF_CONHECIMENTO_ID_OUTROS");
                                v_outros_numero			= this.ListaToArray (lista = arguments, variavel = "OUTROS_NUMERO_OUTROS");
                                v_outros_data_emissao	= this.ListaToArray (lista = arguments, variavel = "OUTROS_DATA_EMISSAO_OUTROS");
                                v_outros_descricao		= this.ListaToArray (lista = arguments, variavel = "OUTROS_DESCRICAO_OUTROS");
                                v_outros_valor			= this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_OUTROS");
                                v_outros_valor_segurado = this.ListaToArray (lista = arguments, variavel = "OUTROS_VALOR_SEGURADO_OUTROS");
                                v_peso                  = this.ListaToArray (lista = arguments, variavel = "OUTROS_PESO_OUTROS");
                                v_peso_cobrado          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_COBRADO_OUTROS');
                                v_qtde_volume           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_QTDE_VOLUME_OUTROS');
                                v_cod_unidade           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COD_UNIDADE_OUTROS');
                                v_m3                    = this.ListaToArray (lista = arguments, variavel = 'OUTROS_M3_OUTROS');
                                v_peso_cubado           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_PESO_CUBADO_OUTROS');
                                v_num_natureza          = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_NATUREZA_OUTROS');
                                v_complemento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPLEMENTO_OUTROS');
                                v_num_especie           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_NUM_ESPECIE_OUTROS');
                                v_altura                = this.ListaToArray (lista = arguments, variavel = 'OUTROS_ALTURA_OUTROS');
                                v_largura               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_LARGURA_OUTROS');
                                v_comprimento           = this.ListaToArray (lista = arguments, variavel = 'OUTROS_COMPRIMENTO_OUTROS');
                                v_cubagem               = this.ListaToArray (lista = arguments, variavel = 'OUTROS_CUBAGEM_OUTROS');
								v_ordem_compra       	= this.ListaToArray(lista = arguments, variavel  = "OUTROS_ORDEM_COMPRA_OUTROS");
								v_tipo_doc_outros		= this.ListaToArray(lista = arguments, variavel = "TIPO_DOC_OUTROS_OUTROS");
                            </cfscript>

                            <cfloop from="1" to="#ArrayLen(v_outros_numero)#" index="count">
                                <cfscript>
                                    outros = this.ins_nf_cte(conhecimento_id 				= arguments.conhecimento_id,
                                                             numero							= v_outros_numero[count],
                                                             numero_old						= v_outros_numero[count],
                                                             data_emissao					= v_outros_data_emissao[count],
                                                             modelo							= '01',
                                                             serie							= 'U',
                                                             sub_serie						= '1',
                                                             valor_total					= v_outros_valor[count],
                                                             nf_eletronica					= 0,
                                                             valor_segurado					= v_outros_valor_segurado[count],
                                                             ordem_compra_cliente			= v_ordem_compra[count],
                                                             peso							= v_peso[count],
                                                             peso_cubado					= v_peso_cubado[count],
                                                             peso_cobrado					= v_peso_cobrado[count],
                                                             qtde_volume					= v_qtde_volume[count],
                                                             altura							= v_altura[count],
                                                             comprimento					= v_comprimento[count],
                                                             largura						= v_largura[count],
                                                             m3								= v_m3[count],
                                                             cubagem						= v_cubagem[count],
                                                             num_natureza					= v_num_natureza[count],
                                                             complemento					= v_complemento[count],
                                                             num_especie					= v_num_especie[count],
                                                             cod_unidade					= v_cod_unidade[count],
                                                             tipo_documento_id				= arguments.tipo_documento_id,
															 tipo_doc_outros				= v_tipo_doc_outros[count],
                                                             num_romaneio					= '',
                                                             valor_base_calculo_icms		= '',
                                                             valor_icms						= '',
                                                             valor_base_calculo_icms_st		= '',
                                                             valor_icms_st					= '',
                                                             valor_produtos					= '',
                                                             cfop							= '',
                                                             pin_suframa					= '',
                                                             chave_acesso_nfe				= '',
                                                             descricao_docto				= v_outros_descricao[count],
                                                             nfe_xml						= '',
                                                             verificar_nf                   = v_verificar_nf);
                                </cfscript>
                                <cfif outros.erro>
                                    <cfthrow object="#outros.mensagem#">
                                </cfif>
                            </cfloop>
                        </cfcase>
                    </cfswitch>
    			<cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Notas Fiscais inseridas com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Exclui as NFs de um CTe
	-- ANDERSONC 19/09/2011 11:51:40 - CRIADO
	--->
	<cffunction name='del_cte_nfs' displayname='Exclui as NFs de um CTe' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
            <cfstoredproc procedure='fiscal.pkg_cte.prc_del_cte_nfs' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
            </cfstoredproc>
            <cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Consultar CTe por Chave de Acesso
	-- RAFAEL 06/12/2011 15:36:23 - CRIADO
	--->
	<cffunction name='prc_consulta_chave' displayname='Consultar CTe por Chave de Acesso' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_consulta_chave' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTe consultado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Vincula um romaneio a um CTRC
	-- 03/05/2006 - GUTO
	--->
	<cffunction name="vincula_conhecimento_romaneio" displayname="Insere uma item vinculado a carta frete" access="remote" returntype="struct" output="true">
		<cfargument name="num_romaneio" required="yes" />
		<cfargument name="item_id" 		required="yes" />
		<cfargument name="conhecimento_id" required="yes" />
		<cftry>
            <cfstoredproc datasource="#session.dsn#" procedure="oper.pkg_contrato_transp.prc_vincula_ctrc_romaneio" username="#session.usuario#" password="#session.senha#">
                <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.conhecimento_id#" null="#iif(len(trim(arguments.conhecimento_id)),de('no'),de('yes'))#">
                <cfprocparam type="in" cfsqltype="cf_sql_integer"  value="#arguments.num_romaneio#" null="#iif(len(trim(arguments.num_romaneio)),de('no'),de('yes'))#">
                <cfprocparam type="inout" cfsqltype="cf_sql_integer"  value="#arguments.item_id#" variable="retorno.item_id" null="#iif(len(trim(arguments.item_id)),de('no'),de('yes'))#">
            </cfstoredproc>
            <cfset retorno.erro = false>
            <cfset retorno.mensagem = 'Conhecimento vinculado ao romaneio n #arguments.num_romaneio# com sucesso.'>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno>
	</cffunction>


    <!---
	-- PROPSITO
	-- Desvincula o cte de uma viagem
	-- WAGNERS 23/04/2012 17:17:23 - CRIADO
	--->
	<cffunction name='desvincula_ctrc_romaneio' displayname='Desvincula o cte de uma viagem' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_desvincula_ctrc_romaneio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTE desvinculado com sucesso!')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Exportar os DACTe's ou XML's dos CTe's
	-- RAFAEL 13/06/2012 09:24:17 - CRIADO
	--->
	<cffunction name='exportar_cte' displayname='Exportar os DACTes ou XMLs dos CTes' access='remote' returntype='Struct' output='true'>
		<cfargument name='LISTA_DOCUMENTO_ID' required='yes'>
		<cfargument name='TIPO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfloop list="#arguments.LISTA_DOCUMENTO_ID#" index="v_documento_id">
               		<cfscript>
	                    v_retorno = this.ins_lista_temp(VALOR = v_documento_id);
                    </cfscript>
                </cfloop>
                <cfif v_retorno.erro>
                	<cfthrow object="#v_retorno.mensagem#">
                </cfif>

                <cfstoredproc procedure='fiscal.pkg_cte_exportacao.prc_exportar_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TIPO#' >
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTes exportados com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Validar se a chave da NFe  valida
	-- RAFAEL 27/06/2012 18:24:58 - CRIADO
	--->
	<cffunction name='valida_chave_nfe' displayname='Validar se a chave da NFe  valida' access='remote' returntype='Struct' output='true'>
		<cfargument name='CHAVE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_valida_chave_nfe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('NFe validada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Gerar Romaneio de Terceiro
	-- RAFAEL 28/12/2010 09:15:53 - CRIADO
	--->
	<cffunction name='gera_romaneio_terceiro_private' displayname='Gerar Romaneio de Terceiro' access='remote' returntype='Struct' output='true'>
    	<cftry>

                <cfset v_composicao = arguments.placa_tracao>
                <cfloop list="#arguments.placa_referencia_composicao#" index="v_pl">
                    <cfset v_composicao = ListAppend(v_composicao,v_pl,',')>
                </cfloop>

                <cfif not len(trim(arguments.num_romaneio)) >
                    <cfscript>
                        conn = CreateComponent("_transportes.manipulacao.cfc_contrato_transporte");
                        romaneio = this.gera_romaneio_terceiro(	NUM_ROMANEIO		= arguments.num_romaneio,
                                                                COMPOSICAO			= v_composicao,
                                                                DATA_INICIO			= arguments.data_emissao,
                                                                OPERACAO_ID			= arguments.operacao_id,
                                                                VIAGEM_CARGA_ID		= arguments.viagem_carga_id,
                                                                COD_MOTORISTA		= arguments.cod_motorista,
                                                                COD_REMETENTE		= arguments.cod_remetente,
                                                                COLETA_MUNICIPIO_ID	= arguments.coleta_municipio_id,
                                                                COD_DESTINATARIO	= arguments.cod_destinatario,
                                                                ENTREGA_MUNICIPIO_ID= arguments.red_municipio_id,
                                                                VOLUME				= arguments.volume,
                                                                PESO				= arguments.peso,
                                                                M3					= arguments.m3,
                                                                FRETE_VALOR			= arguments.frete_valor,
                                                                NUM_NATUREZA		= arguments.num_natureza,
                                                                NUM_ESPECIE			= arguments.num_especie,
                                                                COD_UNIDADE			= arguments.cod_unidade,
                                                                FRETE_EM			= arguments.frete_em,
                                                                DESPACHO			= arguments.despacho,
                                                                OBSERVACAO			= arguments.observacao,
                                                                SUBSTITUTO			= arguments.substituto,
																					 CARGA_CONSOLIDADA_ID = arguments.carga_consolidada_id
                                                                );
                    </cfscript>
                    <cfif romaneio.erro>
                        <cfthrow object="#romaneio.mensagem#">
                    <cfelse>
                        <cfset retorno.num_romaneio 	= romaneio.num_romaneio>
                        <cfset retorno.item_id 		= romaneio.item_id>
                    </cfif>
                </cfif>

    			<cfset retorno.erro = false>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>
	 
    <!---
	-- PROPSITO
	-- Insere um Vale Pedgio no CTe
	-- RAFAEL 19/09/2012 11:35:58 - CRIADO
	--->
	<cffunction name='ins_vale_pedagio_private' displayname='Insere um Vale Pedgio no CTe' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='OPERADORA_VALE_PEDAGIO' required='yes'>
		<cfargument name='FORNECEDORA_VALE_PEDAGIO' required='yes'>
		<cfargument name='NUM_COMPROVANTE' required='yes'>
        <cfargument name='VALOR_COMPROVANTE' required='yes'>
		<cfargument name='NUM_CARTAO_VALE_PEDAGIO' required='no' default="">
		<cfargument name='MANUAL' required='no' default="1">
		<cftry>

				<!--- Excluso dos vale pedgios --->
				<cfscript>
						ret_del = this.del_vale_pedagio_cte(CONHECIMENTO_ID  = arguments.CONHECIMENTO_ID);
				</cfscript>
				<cfif ret_del.erro>
					<cfthrow object="#ret_del.mensagem#">
				</cfif>
				
				<cfstoredproc procedure='fiscal.pkg_cte.prc_ins_vale_pedagio' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.CONHECIMENTO_VALE_PEDAGIO_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.OPERADORA_VALE_PEDAGIO#'  null='#iif(len(trim(arguments.OPERADORA_VALE_PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.FORNECEDORA_VALE_PEDAGIO#'  null='#iif(len(trim(arguments.FORNECEDORA_VALE_PEDAGIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_COMPROVANTE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VALOR_COMPROVANTE#'  null='#iif(len(trim(arguments.VALOR_COMPROVANTE)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'  variable='retorno.ROWID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.MANUAL#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUM_CARTAO_VALE_PEDAGIO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>

			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Insere um Vale Pedgio no CTe
	-- RAFAEL 19/09/2012 11:35:58 - CRIADO
	--->
	<cffunction name='ins_vale_pedagio' displayname='Insere um Vale Pedgio no CTe' access='remote' returntype='Struct' output='true'>
     <cfargument name="COD_MOTORISTA" required="no" default="">
     <cfargument name="NUM_CARTAO_VALE_PEDAGIO_ANTIGO" required="no" default="">
     <cfargument name="NUM_CARTAO_VALE_PEDAGIO" required="no" default="">
     <cfargument name="COD_PESSOA_OPERADORA" required="no" default="">
		<cftry>
		    <cfscript> 
			   connVP = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
			   qrVerificaRepom = connVP.verifica_vpr(cod_pessoa_operadora = arguments.COD_PESSOA_OPERADORA);
            </cfscript>				
			
 		    <cfif qrVerificaRepom.RESULT eq 1>
		        <cfscript> 
				   result_troca = this.troca_cartao_vale_pedagio(COD_PESSOA_MOTORISTA  = arguments.COD_MOTORISTA
																,NUM_CARTAO_ANTIGO     = arguments.NUM_CARTAO_VALE_PEDAGIO_ANTIGO
																,NUM_CARTAO_NOVO       = arguments.NUM_CARTAO_VALE_PEDAGIO
																,OPERADORA_VALE_PEDAGIO = arguments.COD_PESSOA_OPERADORA);
				</cfscript>				
				<cfif result_troca.erro>
					<cfthrow object="#result_troca.mensagem#">
  				</cfif> 
			</cfif>

        	<cfscript>
                v_cod_pessoa_operadora   = this.ListaToArray(lista = arguments, variavel = 'COD_PESSOA_OPERADORA_VALE_PEDAGIO');
                v_cod_pessoa_fornecedora = this.ListaToArray(lista = arguments, variavel = 'COD_PESSOA_FORNECEDORA_VALE_PEDAGIO');
                v_num_comprovante		 = this.ListaToArray(lista = arguments, variavel = 'NUM_COMPROVANTE_VALE_PEDAGIO');
				v_valor_comprovante	     = this.ListaToArray(lista = arguments, variavel = 'VALOR_COMPROVANTE_VALE_PEDAGIO');
            </cfscript>

            <cfloop from="1" to="#ArrayLen(v_cod_pessoa_operadora)#" index="count">
                <cfscript>

                        ret_valeped = this.ins_vale_pedagio_private(CONHECIMENTO_ID          = retorno.CONHECIMENTO_ID
																   ,OPERADORA_VALE_PEDAGIO   = v_cod_pessoa_operadora[count]
																   ,FORNECEDORA_VALE_PEDAGIO = v_cod_pessoa_fornecedora[count]
																   ,NUM_COMPROVANTE          = v_num_comprovante[count]
																   ,VALOR_COMPROVANTE	     = v_valor_comprovante[count]
																   ,NUM_CARTAO_VALE_PEDAGIO  = arguments.NUM_CARTAO_VALE_PEDAGIO);

                </cfscript>
                <cfif ret_valeped.erro>
                    <cfthrow object="#ret_valeped.mensagem#">
                </cfif>
            </cfloop>


            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Inseir os impostos vinculados do Conhecimento
	-- RAFAEL 19/03/2013 13:58:52 - CRIADO
	--->
	<cffunction name='ins_ctrc_imposto' displayname='Inseir os impostos vinculados do Conhecimento' access='remote' returntype='Struct' output='true'>
		<cftry>
			<cfif arguments.TABELA_FRETE_MODELO_ID eq 1>
				<cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_ins_ctrc_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Impostos inseridos com sucesso.')>
			<cfelse>
				<cfscript>
	                v_imposto_tipo_id    = this.ListaToArray (lista = arguments, variavel = "IMPOSTO_TIPO_ID_IMPOSTOS");
	                v_descricao     = this.ListaToArray (lista = arguments, variavel = "DESCRICAO_IMPOSTOS");
	                v_imposto_situacao_id   = this.ListaToArray (lista = arguments, variavel = "IMPOSTO_SITUACAO_ID_IMPOSTOS");
	                v_imposto_sit_trib_tipo_id  = this.ListaToArray (lista = arguments, variavel = "IMPOSTO_SITUACAO_TRIB_TIPO_ID_IMPOSTOS");
	                v_aliquota      = this.ListaToArray (lista = arguments, variavel = "ALIQUOTA_IMPOSTOS");
	                v_reducao_base     = this.ListaToArray (lista = arguments, variavel = "REDUCAO_BASE_IMPOSTOS");
	                v_base_calculo     = this.ListaToArray (lista = arguments, variavel = "BASE_CALCULO_IMPOSTOS");
	                v_imposto_total    = this.ListaToArray (lista = arguments, variavel = "IMPOSTO_TOTAL_IMPOSTOS");
	                v_retido_fonte     = this.ListaToArray (lista = arguments, variavel = "RETIDO_FONTE_IMPOSTOS");
	                v_imposto_cod_retencao_id  = this.ListaToArray (lista = arguments, variavel = "IMPOSTO_COD_RETENCAO_ID_IMPOSTOS");
	                v_regime_cumulativo   = this.ListaToArray (lista = arguments, variavel = "REGIME_CUMULATIVO_IMPOSTOS");
	                v_fundamentacao_legal   = this.ListaToArray (lista = arguments, variavel = "IMP_FUNDAMENTACAO_LEGAL_IMPOSTOS");
	                v_reservado_fisco    = this.ListaToArray (lista = arguments, variavel = "RESERVADO_FISCO_IMPOSTOS");
	                v_imposto_origem_id   = this.ListaToArray (lista = arguments, variavel = "IMPOSTO_ORIGEM_ID_IMPOSTOS");
	                v_imposto_natureza_bc_id  = this.ListaToArray (lista = arguments, variavel = "IMPOSTO_NATUREZA_BC_ID_IMPOSTOS");
	                v_gera_cpg_icms_antecipado  = this.ListaToArray (lista = arguments, variavel = "GERA_CPG_ICMS_ANTECIPADO_IMPOSTOS");
	            </cfscript>

	            <cfloop from="1" to="#ArrayLen(v_imposto_tipo_id)#" index="count">
	                <cfscript>
	                    doc_imposto = this.prc_ins_documento_imposto(
	                        imposto_tipo_id 			= v_imposto_tipo_id[count],
	                        descricao 					= v_descricao[count],
	                        imposto_situacao_id 		= v_imposto_situacao_id[count],
	                        aliquota 					= v_aliquota[count],
	                        reducao_base 				= v_reducao_base[count],
	                        base_calculo 				= v_base_calculo[count],
	                        imposto_total 				= v_imposto_total[count],
	                        data_vencimento 			= arguments.data_emissao,
	                        retido_fonte 				= v_retido_fonte[count],
	                        regime_cumulativo 			= v_regime_cumulativo[count],
	                        fundamentacao_legal 		= v_fundamentacao_legal[count],
	                        reservado_fisco 			= v_reservado_fisco[count],
	                        imposto_origem_id 			= v_imposto_origem_id[count],
	                        imposto_natureza_bc_id 		= v_imposto_natureza_bc_id[count],
	                        imposto_sit_trib_tipo_id 	= v_imposto_sit_trib_tipo_id[count],
	                        inserido_manualmente		= 0,
	                        contabiliza 				= 0,
	                        imposto_cod_retencao_id 	= v_imposto_cod_retencao_id[count],
	                        gera_cpg_icms_antecipado 	= v_gera_cpg_icms_antecipado[count]
	                    );
	                </cfscript>
	                <cfif doc_imposto.erro>
	                    <cfthrow object="#doc_imposto.mensagem#">
	                </cfif>
	                <cfscript>
	                    cte_imposto = this.prc_ins_conhecimento_imposto(
	                        conhecimento_id			= arguments.conhecimento_id,
	                        documento_imposto_id	= doc_imposto.documento_imposto_id
	                    );
	                </cfscript>
	                <cfif cte_imposto.erro>
	                    <cfthrow object="#cte_imposto.mensagem#">
	                </cfif>
	            </cfloop>
	            <cfscript>
					cte_imposto = this.prc_atualiza_ctrc_imposto(conhecimento_id			= arguments.conhecimento_id);
				</cfscript>
				<cfif cte_imposto.erro>
					<cfthrow object="#cte_imposto.mensagem#">
				</cfif>
    			<cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('Impostos inseridos com sucesso.')>
			</cfif>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO

	-- Clculo da Tabela de Frete do CTe
	-- RAFAEL 19/03/2012 09:15:53 - CRIADO
	--->
	<cffunction name='calcula_tabela_frete' displayname='Clculo da Tabela de Frete do CTe' access='remote' returntype='Struct' output='true'>
    	<cftry>
			<cfscript>
                if(IsDefined('arguments.PLACA_REFERENCIA_INTERNA')) {
                    v_placa_referencia_interna = Replace(arguments.PLACA_REFERENCIA_INTERNA, ',', ' > ', 'all');
                }
                else {
                    v_placa_referencia_interna = '';
                }

				if (IsDefined('arguments.PLACA_TRACAO')){
				    v_placa = arguments.PLACA_TRACAO & ' > ' & v_placa_referencia_interna;
				}else{
				    v_placa = arguments.PLACA_CONTROLE & ' > ' & v_placa_referencia_interna;
				}

                conn_cons_tf = CreateComponent("modulos.cte._componentes.consulta.comercial.cfc_tabela_frete");
                qrTabelaFreteRotaId = conn_cons_tf.get_tabela_frete_rota_id(ORIGEM_MUNICIPIO_ID  = arguments.COLETA_MUNICIPIO_ID,
                                                                            DESTINO_MUNICIPIO_ID = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.red_municipio_id), de(arguments.MUNICIPIO_ULT_ENTREGA_ID)),
                                                                            COD_NEGOCIADOR       = arguments.COD_NEGOCIADOR,
                                                                            NUM_NATUREZA		 = arguments.NUM_NATUREZA,
                                                                            COMPOSICAO			 = v_placa,
                                                                            TIPO_SERVICO_ID		 = arguments.TIPO_SERVICO_COMERCIAL,
																			SOLICITACAO_CARGA_ID = arguments.SOLICITACAO_CARGA_ID,
																			CONHECIMENTO_TIPO_ID = arguments.conhecimento_tipo_id
                                                                            );
            </cfscript>
            <cfif qrTabelaFreteRotaId.erro>
                <cfthrow object="#qrTabelaFreteRotaId.mensagem#">
            </cfif>

            <cfscript>
                conn_cons_doc = CreateComponent("modulos.cte._componentes.consulta.cfc_emissao_documentos");
                qrDadosFiscais = conn_cons_doc.get_ctrc_dados_fiscais(NUM_ROMANEIO 		   = arguments.NUM_ROMANEIO,
                                                                      ITEM_ID 			   = arguments.ITEM_ID,
                                                                      COD_DESTINATARIO 	   = arguments.COD_DESTINATARIO,
                                                                      PRODUTO_ID  		   = arguments.NUM_PRODUTO,
                                                                      PAGO_POR 			   = arguments.PAGADOR,
                                                                      COLETA_UF 		   = arguments.COLETA_UF,
                                                                      ENTREGA_UF 		   = arguments.RED_UF,
                                                                      ST_ICMS_ID 		   = arguments.ST_ICMS_ID,
                                                                      COD_REMETENTE 	   = arguments.COD_REMETENTE,
                                                                      REGRA_FISCAL_ID 	   = arguments.REGRA_FISCAL,
                                                                      COB_UF 			   = arguments.COB_UF,
                                                                      COLETA_MUNICIPIO_ID  = arguments.COLETA_MUNICIPIO_ID,
                                                                      ENTREGA_MUNICIPIO_ID = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.red_municipio_id), de(arguments.MUNICIPIO_ULT_ENTREGA_ID)),
                                                                      VIAGEM_CARGA_ID 	   = arguments.VIAGEM_CARGA_ID,
                                                                      COD_CLIENTE_COBRANCA = arguments.COD_CLIENTE_COBRANCA,
                                                                      UF_FILIAL 		   = arguments.UF_FILIAL_EMISSAO,
                                                                      NOTA_FISCAL 		   = 0,
																	  COD_NEGOCIADOR       = arguments.COD_NEGOCIADOR);
            </cfscript>
            <cfif qrDadosFiscais.erro>
                <cfthrow object="#qrDadosFiscais.mensagem#">
            </cfif>

            <cfscript>
                conn_cons_vei = CreateComponent("modulos.cte._componentes.consulta.cfc_veiculo");
                qrNumeroEixos = conn_cons_vei.get_numero_eixos_composicao(PLACA = v_placa);
            </cfscript>
            <cfif qrNumeroEixos.erro>
                <cfthrow object="#qrNumeroEixos.mensagem#">
            </cfif>

            <cfset v_pessoa_emitente = ''>
            <cfscript>
				if (len(trim(COD_PESSOA_FILIAL)) > 0) {
					conn_pessoa = CreateComponent("modulos.cte._componentes.consulta.cfc_pessoa");
					qrPessoa = conn_pessoa.get_pessoa_cnpj(COD_PESSOA = arguments.COD_PESSOA_FILIAL);
					v_pessoa_emitente = qrPessoa.CNPJ_CPF;
				}
			</cfscript>

            <cfscript>
                // Constantes
                arguments.CONSTANTE_VIAGEM_CARGA_ID		   = arguments.VIAGEM_CARGA_ID;
				arguments.CONSTANTE_SOLICITACAO_CARGA_ID	   = arguments.SOLICITACAO_CARGA_ID;
                arguments.CONSTANTE_NUM_ROMANEIO		   = arguments.NUM_ROMANEIO;
                arguments.CONSTANTE_PESO_BRUTO             = arguments.PESO_KG;
                arguments.CONSTANTE_PESO_COBRADO           = arguments.PESO;
                arguments.CONSTANTE_VALOR_MERCADORIA       = arguments.VALOR_MERCADORIA;
                arguments.CONSTANTE_NRO_VOLUMES			   = arguments.VOLUME;
                arguments.CONSTANTE_MUNICIPIO_ID_ORIGEM    = arguments.COLETA_MUNICIPIO_ID;
                arguments.CONSTANTE_MUNICIPIO_ID_DESTINO   = iif(arguments.FRETE_ULT_ENTREGA eq 0, de(arguments.red_municipio_id), de(arguments.MUNICIPIO_ULT_ENTREGA_ID));
                arguments.CONSTANTE_FRETE_PROPRIO		   = qrDadosFiscais.FRETE_PROPRIO;
                arguments.CONSTANTE_UF_TOMADOR			   = qrDadosFiscais.TOMADOR_UF;
				arguments.CONSTANTE_UF_EMITENTE			   = arguments.UF_FILIAL_EMISSAO;
                arguments.CONSTANTE_COD_ATIVIDADE_TOMADOR  = qrDadosFiscais.COD_ATIVIDADE_TOMADOR;
                arguments.CONSTANTE_ST_ICMS_ID			   = Trim(arguments.ST_ICMS_ID);
                arguments.CONSTANTE_PLACA_TRACAO	 	   = arguments.PLACA_CONTROLE;
                arguments.CONSTANTE_PRODUTO_ID			   = arguments.NUM_PRODUTO;
				arguments.CONSTANTE_TABELA_FRETE_MODELO_ID = arguments.TABELA_FRETE_MODELO_ID;
				arguments.CONSTANTE_M3 					   = arguments.M3;
				arguments.CONSTANTE_CUBAGEM				   = arguments.CUBAGEM;
				arguments.CONSTANTE_MERCADORIA_TRANSPORTADA = arguments.MERCADORIA_TRANSPORTADA;
				arguments.CONSTANTE_CFOP_TRANSPORTADO 		= arguments.CFOP_TRANSPORTADO;
				arguments.CONSTANTE_NFE_ICMS_PARTILHADO     = arguments.NFE_ICMS_PARTILHADO;

				// Definio do tipo de CT-e
				if (IsDefined('arguments.COMPLEMENTO') and arguments.COMPLEMENTO == 1) {
					arguments.CONSTANTE_TIPO_CTE = 1;
				} else if (arguments.SUBSTITUTO == 1) {
					arguments.CONSTANTE_TIPO_CTE = 3;
				} else {
					arguments.CONSTANTE_TIPO_CTE = 0;
				}

				// Pega o valor do tipo de documento vinculado
				v_documento_tipo = '';
				if (IsDefined('arguments.TIPO_DOCUMENTO_ID')) {
					v_documento_tipo = arguments.TIPO_DOCUMENTO_ID;
				} else {
					v_documento_tipo = arguments.TIPO_DOCTO_FRETE;
				}
				// Define se  nta fiscal ou outros (Outos = 1 e NF = 0)
				if (v_documento_tipo == 2) {
					arguments.CONSTANTE_DOCUMENTO_VINCULADO = 1;
				} else {
					arguments.CONSTANTE_DOCUMENTO_VINCULADO = 0;

				}

                if(v_placa_referencia_interna eq '') {
                    arguments.CONSTANTE_PLACA_CARRETA = '';
                }
                else {
                    arguments.CONSTANTE_PLACA_CARRETA = ListGetAt(v_placa_referencia_interna, 1, ' > ');
                }

                arguments.CONSTANTE_NRO_EIXOS 		  = qrNumeroEixos.EIXOS;
                arguments.CONSTANTE_CNPJ_REMETENTE 	  = arguments.REM_CNPJ_CPF;
                arguments.CONSTANTE_CNPJ_DESTINATARIO = arguments.DEST_CNPJ_CPF;
                arguments.CONSTANTE_CNPJ_COLETA 	  = arguments.COLETA_CNPJ_CPF;
                arguments.CONSTANTE_CNPJ_ENTREGA 	  = arguments.RED_CNPJ_CPF;
				arguments.CONSTANTE_CNPJ_EMITENTE 	  = v_pessoa_emitente;
				arguments.CONSTANTE_CNPJ_TOMADOR 	  = arguments.COB_CNPJ_CPF;
				
				arguments.CONSTANTE_COD_ENDERECO_DESTINATARIO = arguments.DEST_COD_ENDERECO;
				arguments.CONSTANTE_COD_ENDERECO_ENTREGA		= arguments.RED_COD_ENDERECO;
				arguments.CONSTANTE_COD_ENDERECO_COLETA			= arguments.COLETA_COD_ENDERECO;
				arguments.CONSTANTE_COD_ENDERECO_TOMADOR		= arguments.COB_COD_ENDERECO;
				arguments.CONSTANTE_COD_MODELO					= '57';

				if (IsDefined('arguments.CONHECIMENTO_ID_CONSULTA')){
				   arguments.CONSTANTE_CONHECIMENTO_ID_ORIGINAL	= arguments.CONHECIMENTO_ID_CONSULTA;
				}
                // ----------
            </cfscript>

            <cfscript>
                qrTabelaFreteRota = conn_cons_tf.get_tabela_frete_rota(tabela_frete_rota_id = qrTabelaFreteRotaId.TABELA_FRETE_ROTA_ID
																	 , tabela_frete_id 		= qrTabelaFreteRotaId.TABELA_FRETE_ID);
                qrConstante 	  = conn_cons_tf.get_constante();
                qrVariavel  	  = conn_cons_tf.get_tabela_frete_variavel(tabela_frete_rota_id = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID
																		 , tabela_frete_id 		= qrTabelaFreteRota.TABELA_FRETE_ID);

                conn_manip_tf = CreateComponent("modulos.cte._componentes.manipulacao.cfc_tabela_frete");
            </cfscript>

            <cfloop query="qrConstante">
                <cfscript>
                    ret_cons = conn_manip_tf.set_constante(COD_CONSTANTE = qrConstante.COD_CONSTANTE,
                                                           VALOR		 = iif(IsDefined('arguments.CONSTANTE_#qrConstante.COD_CONSTANTE#'), de(arguments['CONSTANTE_' & qrConstante.COD_CONSTANTE]), de(qrConstante.VALOR_DEFAULT)));
                </cfscript>
                <cfif ret_cons.erro>
                    <cfthrow object="#ret_cons.mensagem#">
                </cfif>
            </cfloop>

            <cfscript>
                ret_cons_tf = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ID',
                                                          VALOR		    = qrTabelaFreteRota.TABELA_FRETE_ID);
            </cfscript>
            <cfif ret_cons_tf.erro>
                <cfthrow object="#ret_cons_tf.mensagem#">
            </cfif>

            <cfscript>
                ret_cons_tfr = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_ROTA_ID',
                                                           VALOR		 = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID);
            </cfscript>
            <cfif ret_cons_tfr.erro>
                <cfthrow object="#ret_cons_tfr.mensagem#">
            </cfif>

            <cfscript>
				ret_cons_tfv = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_VIGENCIA_ID',
												  		   VALOR         = qrTabelaFreteRota.tabela_frete_vigencia_id);
			</cfscript>
			<cfif ret_cons_tfv.erro>
				<cfthrow object="#ret_cons_tfv.mensagem#">
			</cfif>

            <cfscript>
				ret_cons_tfv = conn_manip_tf.set_constante(COD_CONSTANTE = 'TABELA_FRETE_VIGENCIA_ID',
												  		   VALOR         = qrTabelaFreteRota.tabela_frete_vigencia_id);
			</cfscript>
			<cfif ret_cons_tfv.erro>
				<cfthrow object="#ret_cons_tfv.mensagem#">
			</cfif>

            <cfloop query="qrVariavel">
                <cfscript>
                    ret_var = conn_manip_tf.ins_tabela_frete_var_temp(TABELA_FRETE_ID 		   = qrVariavel.TABELA_FRETE_ID,
                                                                      TABELA_FRETE_ROTA_ID 	   = qrTabelaFreteRota.TABELA_FRETE_ROTA_ID,
                                                                      TABELA_FRETE_VARIAVEL_ID = qrVariavel.TABELA_FRETE_VARIAVEL_ID,
                                                                      VALOR					   = iif(IsDefined('arguments.VARIAVEl_#qrVariavel.COD_VARIAVEL#'), de(arguments['VARIAVEl_' & qrVariavel.COD_VARIAVEL]), de(qrVariavel.VALOR)));
                </cfscript>
                <cfif ret_var.erro>
                    <cfthrow object="#ret_var.mensagem#">
                </cfif>
            </cfloop>
            <cfscript>
                conn_manip_ed = CreateComponent("modulos.cte._componentes.manipulacao.cfc_emissao_documentos");
                if(not isDefined('retorno.CONHECIMENTO_ID')){
					retorno.CONHECIMENTO_ID = arguments.CONHECIMENTO_ID;
				}
                ret_calc = conn_manip_ed.calcula_ctrc_tabela_frete(CONHECIMENTO_ID = retorno.CONHECIMENTO_ID,
                                                                   TABELA_FRETE_ID = qrTabelaFreteRota.TABELA_FRETE_ID);
            </cfscript>
            <cfif ret_calc.erro>
                <cfthrow object="#ret_calc.mensagem#">
            </cfif>
        <cfset retorno.erro = false>
            <cfcatch>
				<cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Insere mapeamento de Espcie do XML
	-- RAFAEL 04/06/2013 15:02:20 - CRIADO
	--->
	<cffunction name='ins_mapeamento_especie' displayname='Insere mapeamento de Espcie do XML' access='remote' returntype='Struct' output='true'>
		<cfargument name='ESPECIE_XML' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='sefaz.pkg_email_integracao.prc_ins_mapeamento_especie' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.MAPEAMENTO_ESPECIE_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.ESPECIE_XML#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Mapeamento de Espcie efetuado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
    -- PROPSITO
    -- Inserir registros na lista temporria
    -- RAFAEL 20/08/2013 10:41:18 - CRIADO
    --->
    <cffunction name='ins_lista_temp' displayname='Inserir registros na lista temporria' access='remote' returntype='Struct' output='true'>
        <cfargument name='VALOR' required='yes'>
        <cftry>
           <cfstoredproc procedure='kss.pkg_lista_temp.prc_ins_lista_temp' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
              <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
           </cfstoredproc>
           <cfset retorno.erro = false>
           <cfset retorno.mensagem = JSStringFormat('Itens inseridos com sucesso.')>
            <cfcatch>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

    <!---
	-- PROPSITO
	-- Atualiza o peso de uma NFe integrada por email
	-- RAFAEL 20/11/2013 15:02:20 - CRIADO
	--->
	<cffunction name='atualizar_peso' displayname='Insere mapeamento de Espcie do XML' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID_ALTERACAO' required='yes'>
		<cfargument name='NOVO_PESO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='sefaz.pkg_email_integracao.prc_atualizar_peso' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.DOCUMENTO_ID_ALTERACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.NOVO_PESO#'  null='#iif(len(trim(arguments.NOVO_PESO)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Peso atualizado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>


    <!---
	-- PROPSITO
	-- Gerar PDF da Declarao da Operao do CT-e
	-- JAQUELINEF 05/03/2014 - CRIADO
	--->
	<cffunction name='gerar_declaracao' displayname='Gerar PDF da Declarao da Operao do CT-e' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
  		<cfargument name='DECLARACAO_ID' required='no' default="">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_impressao_cte.prc_gerar_declaracao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DECLARACAO_ID#'  null='#iif(len(trim(arguments.DECLARACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dacte gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Inserir documento anterior para o conhecimento
	-- jaquelinef 08/04/2014 11:35:54 - CRIADO
	--->
	<cffunction name='ins_docto_anterior' displayname='Inserir documento anterior para o conhecimento' access='remote' returntype='Struct' output='true'>
		<cftry>
			<!--- Excluso dos Documentos Anteriores --->
			<cfscript>
					ret_del = this.del_docto_anterior_private(CONHECIMENTO_ID  = arguments.CONHECIMENTO_ID);
			</cfscript>
			<cfif ret_del.erro>
				<cfthrow object="#ret_del.mensagem#">
			</cfif>
			
        	<cfscript>
                v_chave = this.ListaToArray(lista = arguments, variavel = 'CHAVECTE_DOCSANT');
                v_eletronico_papel = this.ListaToArray(lista = arguments, variavel = 'ELETRONICO_PAPEL_DOCSANT');
                v_data_emissao     = this.ListaToArray(lista = arguments, variavel = 'DOC_DATA_EMISSAO_DOCSANT');
                v_tipo             = this.ListaToArray(lista = arguments, variavel = 'DOC_TIPO_DOCSANT');
                v_numero           = this.ListaToArray(lista = arguments, variavel = 'DOC_NUMERO_DOCSANT');
                v_serie            = this.ListaToArray(lista = arguments, variavel = 'DOC_SERIE_DOCSANT');
                v_sub_serie        = this.ListaToArray(lista = arguments, variavel = 'DOC_SUB_SERIE_DOCSANT');
                v_cod_emissor      = this.ListaToArray(lista = arguments, variavel = 'DOC_COD_EMISSOR_DOCSANT');
            </cfscript>

            <cfloop from="1" to="#ArrayLen(v_chave)#" index="count">
                <cfscript>

                        ret = this.ins_docto_anterior_private(CONHECIMENTO_ID  = arguments.CONHECIMENTO_ID
 														     ,CHAVE            = v_chave[count]
 														     ,ELETRONICO_PAPEL = v_eletronico_papel[count]
 														     ,DATA_EMISSAO     = v_data_emissao[count]
 														     ,TIPO             = v_tipo[count]
 														     ,NUMERO           = v_numero[count]
 														     ,SERIE            = v_serie[count]
 														     ,SUB_SERIE        = v_sub_serie[count]
 														     ,COD_EMISSOR	   = v_cod_emissor[count]);
                </cfscript>
                <cfif ret.erro>
                    <cfthrow object="#ret.mensagem#">
                </cfif>
            </cfloop>


            <cfset retorno.erro = false>
        <cfcatch>
            <cfset retorno.erro = true>
            <cfset retorno.mensagem = cfcatch>
            <cfset request.erro = cfcatch>
        </cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>

		<!--- 
        -- PROPSITO
        -- Inserir documento anterior para o conhecimento.
        -- jaquelinef 08/04/2014 14:15:32 - CRIADO
        --->
        <cffunction name='ins_docto_anterior_private' displayname='Inserir documento anterior para o conhecimento.' access='remote' returntype='Struct' output='true'>
            <cfargument name='CHAVE' required='no'>
            <cfargument name='CONHECIMENTO_ID' required='yes'>
			<cfargument name='ELETRONICO_PAPEL' required='yes'>
			<cfargument name='DATA_EMISSAO' required='no'>
			<cfargument name='TIPO' required='no'>
			<cfargument name='NUMERO' required='no'>
			<cfargument name='SERIE' required='no'>
			<cfargument name='SUB_SERIE' required='no'>
            <cftry>
                    <cfstoredproc procedure='fiscal.pkg_cte.prc_ins_docto_anterior' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    	<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.ELETRONICO_PAPEL#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_EMISSAO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.TIPO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.NUMERO#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SERIE#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.SUB_SERIE#' >
						<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.COD_EMISSOR#' >
                    </cfstoredproc>
                    <cfset retorno.erro = false>
                    <cfset retorno.mensagem = JSStringFormat('Documento inserido com sucesso.')>
                <cfcatch>
                    <cfset retorno.erro = true>
                    <cfset retorno.mensagem = cfcatch>
                    <cfset request.erro = cfcatch>
                </cfcatch>
            </cftry>
            <cfreturn retorno />
        </cffunction>
		
		<!--- 
        -- PROPSITO
        -- Excluir documento anterior para o conhecimento.
        -- RAFAEL 03/12/2018 14:15:32 - CRIADO
        --->
        <cffunction name='del_docto_anterior_private' displayname='Inserir documento anterior para o conhecimento.' access='remote' returntype='Struct' output='true'>
            <cfargument name='CONHECIMENTO_ID' required='yes'>
            <cftry>
                    <cfstoredproc procedure='fiscal.pkg_cte.prc_del_docto_anterior' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    </cfstoredproc>
                    <cfset retorno.erro = false>
                    <cfset retorno.mensagem = JSStringFormat('Documento excludo com sucesso.')>
                <cfcatch>
                    <cfset retorno.erro = true>
                    <cfset retorno.mensagem = cfcatch>
                    <cfset request.erro = cfcatch>
                </cfcatch>
            </cftry>
            <cfreturn retorno />
        </cffunction>
		
		<!--- 
        -- PROPSITO
        -- Excluir vale pedgio do conhecimento.
        -- RAFAEL 03/12/2018 14:15:32 - CRIADO
        --->
        <cffunction name='del_vale_pedagio_cte' displayname='Inserir documento anterior para o conhecimento.' access='remote' returntype='Struct' output='true'>
            <cfargument name='CONHECIMENTO_ID' required='yes'>
            <cftry>
                    <cfstoredproc procedure='fiscal.pkg_cte.prc_del_vale_pedagio_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                    </cfstoredproc>
                    <cfset retorno.erro = false>
                    <cfset retorno.mensagem = JSStringFormat('Documento excludo com sucesso.')>
                <cfcatch>
                    <cfset retorno.erro = true>
                    <cfset retorno.mensagem = cfcatch>
                    <cfset request.erro = cfcatch>
                </cfcatch>
            </cftry>
            <cfreturn retorno />
        </cffunction>

        <!---
        -- PROPSITO
	-- Inserir documento imposto do conhecimento
	-- Leandro Rocha 07/08/2014 - CRIADO
        --->
	<cffunction name='prc_ins_documento_imposto' displayname='Inserir documento impostos do CTE' access='remote' returntype='Struct' output='true'>
        <cfargument name='IMPOSTO_ID' required='no' default="">
        <cfargument name='IMPOSTO_TIPO_ID' required='yes'>
        <cfargument name='DESCRICAO' required='no' default="">
        <cfargument name='IMPOSTO_SITUACAO_ID' required='no' default="">
        <cfargument name='ALIQUOTA' required='yes'>
        <cfargument name='REDUCAO_BASE' required='yes'>
        <cfargument name='BASE_CALCULO' required='yes'>
        <cfargument name='IMPOSTO_TOTAL' required='yes'>
        <cfargument name='DATA_VENCIMENTO' required='yes'>
        <cfargument name='RETIDO_FONTE' required='yes'>
        <cfargument name='REGIME_CUMULATIVO' required='no' default="">
        <cfargument name='FUNDAMENTACAO_LEGAL' required='no' default="">
        <cfargument name='RESERVADO_FISCO' required='no' default="">
        <cfargument name='IMPOSTO_ORIGEM_ID' required='no' default="">
        <cfargument name='IMPOSTO_NATUREZA_BC_ID' required='no' default="">
        <cfargument name='IMPOSTO_SIT_TRIB_TIPO_ID' required='no' default="">
        <cfargument name='INSERIDO_MANUALMENTE' required='no' default="">
        <cfargument name='CONTABILIZA' required='no' default="">
        <cfargument name='IMPOSTO_COD_RETENCAO_ID' required='no' default="">
        <cfargument name='GERA_CPG_ICMS_ANTECIPADO' required='no' default="">
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_documento_imposto.prc_ins_documento_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   variable='retorno.DOCUMENTO_IMPOSTO_ID'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTO_ID#'  null='#iif(len(trim(arguments.IMPOSTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTO_TIPO_ID#'  null='#iif(len(trim(arguments.IMPOSTO_TIPO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.DESCRICAO#'  null='#iif(len(trim(arguments.DESCRICAO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTO_SITUACAO_ID#'  null='#iif(len(trim(arguments.IMPOSTO_SITUACAO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.ALIQUOTA#'  null='#iif(len(trim(arguments.ALIQUOTA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REDUCAO_BASE#'  null='#iif(len(trim(arguments.REDUCAO_BASE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.BASE_CALCULO#'  null='#iif(len(trim(arguments.BASE_CALCULO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTO_TOTAL#'  null='#iif(len(trim(arguments.IMPOSTO_TOTAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.DATA_VENCIMENTO#'  null='#iif(len(trim(arguments.DATA_VENCIMENTO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.RETIDO_FONTE#'  null='#iif(len(trim(arguments.RETIDO_FONTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.REGIME_CUMULATIVO#'  null='#iif(len(trim(arguments.REGIME_CUMULATIVO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.FUNDAMENTACAO_LEGAL#'  null='#iif(len(trim(arguments.FUNDAMENTACAO_LEGAL)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='#arguments.RESERVADO_FISCO#'  null='#iif(len(trim(arguments.RESERVADO_FISCO)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTO_ORIGEM_ID#'  null='#iif(len(trim(arguments.IMPOSTO_ORIGEM_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTO_NATUREZA_BC_ID#'  null='#iif(len(trim(arguments.IMPOSTO_NATUREZA_BC_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   variable='retorno.ROWID'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTO_SIT_TRIB_TIPO_ID#'  null='#iif(len(trim(arguments.IMPOSTO_SIT_TRIB_TIPO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.INSERIDO_MANUALMENTE#'  null='#iif(len(trim(arguments.INSERIDO_MANUALMENTE)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONTABILIZA#'  null='#iif(len(trim(arguments.CONTABILIZA)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.IMPOSTO_COD_RETENCAO_ID#'  null='#iif(len(trim(arguments.IMPOSTO_COD_RETENCAO_ID)), de('no'), de('yes'))#'>
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   null='yes' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   null='yes' >
				<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   null='yes' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.GERA_CPG_ICMS_ANTECIPADO#'  null='#iif(len(trim(arguments.GERA_CPG_ICMS_ANTECIPADO)), de('no'), de('yes'))#'>
            </cfstoredproc>
			<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Inserir vinculo entre documento imposto e conhecimento
	-- Leandro Rocha 07/08/2014 - CRIADO
	--->
	<cffunction name='prc_ins_conhecimento_imposto' displayname='Vincular documento imposto com CTE' access='remote' returntype='Struct' output='true'>
            <cfargument name='CONHECIMENTO_ID' required='yes'>
        <cfargument name='DOCUMENTO_IMPOSTO_ID' required='yes'>
            <cftry>
			<cfstoredproc procedure='fiscal.pkg_documento_imposto.prc_ins_conhecimento_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   variable='retorno.CONHECIMENTO_IMPOSTO_ID'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTO_IMPOSTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_IMPOSTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  variable='retorno.ROWID'>
                    </cfstoredproc>
                    <cfset retorno.erro = false>
                <cfcatch>
                    <cfset retorno.erro = true>
                    <cfset retorno.mensagem = cfcatch>
                    <cfset request.erro = cfcatch>
                </cfcatch>
            </cftry>
            <cfreturn retorno />
        </cffunction>

    <!---
	-- PROPSITO
	-- Valida a obrigatoriedade dos impostos
	-- Leandro Rocha 26/08/2014 - CRIADO
	--->
	<cffunction name='valida_imp_config_obrig' displayname='Vincular documento imposto com CTE' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_documento_imposto.prc_valida_imp_config_obrig_it' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'   value='CTRC' >
            </cfstoredproc>
			<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Valida a obrigatoriedade dos impostos
	-- Leandro Rocha 26/08/2014 - CRIADO
	--->
	<cffunction name='prc_atualiza_ctrc_imposto' displayname='Vincular documento imposto com CTE' access='remote' returntype='Struct' output='true'>
        <cfargument name='CONHECIMENTO_ID' required='yes'>
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_imposto_ctrc.prc_atualiza_ctrc_imposto' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.CONHECIMENTO_ID#'  null='#iif(len(trim(arguments.CONHECIMENTO_ID)), de('no'), de('yes'))#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1' >
            </cfstoredproc>
			<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
<!---
        -- PROPSITO
        -- Inserir tags do xml do cte
        -- Ricardo Laurindo 12/01/2015 - CRIADO
        --->
        <cffunction name='ins_tags_cte' displayname='Inserir Tags para o XML do CT-e.' access='remote' returntype='Struct' output='true'>
            <cfargument name='CONHECIMENTO_ID' required='yes'>
            <cfargument name='CONHECIMENTO_OBS_CONTRIB_ID' required='yes'>
            <cfargument name='OPERACAO_OBS_CONTRIB_ID' required='yes'>
            <cfargument name='VALOR' required='yes'>
            <cftry>
                    <cfstoredproc procedure='fiscal.pkg_cte.prc_ins_conhec_obs_contrib' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    	<cfprocparam type='OUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONHECIMENTO_OBS_CONTRIB_ID#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONHECIMENTO_ID#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OPERACAO_OBS_CONTRIB_ID#' >
                    </cfstoredproc>
                    <cfset retorno.erro = false>
                <cfcatch>
                    <cfset retorno.erro = true>
                    <cfset retorno.mensagem = cfcatch>
                    <cfset request.erro = cfcatch>
                </cfcatch>
            </cftry>
            <cfreturn retorno />
        </cffunction>

         <!---
        -- PROPSITO
        -- Alterar tags do xml do cte
        -- Ricardo Laurindo 19/01/2015 - CRIADO
        --->
        <cffunction name='alt_tags_cte' displayname='ALterar Tags para o XML do CT-e.' access='remote' returntype='Struct' output='true'>
            <cfargument name='CONHECIMENTO_ID' required='yes'>
            <cfargument name='CONHECIMENTO_OBS_CONTRIB_ID' required='yes'>
            <cfargument name='OPERACAO_OBS_CONTRIB_ID' required='yes'>
            <cfargument name='VALOR' required='yes'>
            <cftry>
                    <cfstoredproc procedure='fiscal.pkg_cte.prc_alt_conhec_obs_contrib' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                    	<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONHECIMENTO_OBS_CONTRIB_ID#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.VALOR#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONHECIMENTO_ID#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OPERACAO_OBS_CONTRIB_ID#' >
                    </cfstoredproc>
                    <cfset retorno.erro = false>
                <cfcatch>
                    <cfset retorno.erro = true>
                    <cfset retorno.mensagem = cfcatch>
                    <cfset request.erro = cfcatch>
                </cfcatch>
            </cftry>
            <cfreturn retorno />
        </cffunction>

         <!---
        -- PROPSITO
        -- Validar alteraes/inseres no CTe.
        -- Nicolle 16/11/2015 - CRIADO
        --->
        <cffunction name='valida_cte' displayname='Validar alteraes/inseres no CTe.' access='remote' returntype='Struct' output='true'>
            <cfargument name='CONHECIMENTO_ID' required='yes'>
            <cfargument name='OPERACAO' required='yes'>
            <cftry>
                    <cfstoredproc procedure='fiscal.pkg_conhecimento_dml.prc_valida_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CONHECIMENTO_ID#' >
                        <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OPERACAO#' >
                    </cfstoredproc>
                    <cfset retorno.erro = false>
                <cfcatch>
                    <cfset retorno.erro = true>
                    <cfset retorno.mensagem = cfcatch>
                    <cfset request.erro = cfcatch>
                </cfcatch>
            </cftry>
            <cfreturn retorno />
        </cffunction>

        <!---
	-- PROPSITO
	-- Gerar PDF do DANFE
	-- VICTOR 20/11/2015 - CRIADO
	--->
	<cffunction name='gerar_danfe' displayname='Gerar PDF do DACTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='sefaz.pkg_email_nfe_impressao.prc_gerar_danfe' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('DANFe gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

    <!---
	-- PROPSITO
	-- Gerar PDF do comprovante de vale pedgio
	-- RAFAEL 28/02/2016 - CRIADO
	--->
	<cffunction name='gerar_comprovante_vale_pedagio' displayname='Gerar PDF da Declarao da Operao do CT-e' access='remote' returntype='Struct' output='true'>
		<cfargument name='VP_NUM_COMPROVANTE' required='yes'>
  		<cfargument name='VP_NUM_ROMANEIO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='oper.pkg_vale_pedagio.prc_impressao' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VP_NUM_COMPROVANTE#'  null='#iif(len(trim(arguments.VP_NUM_COMPROVANTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.VP_NUM_ROMANEIO#'  null='#iif(len(trim(arguments.VP_NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Comprovante de vale pedgio gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>

	
	<!--- 
	-- PROPSITO
	-- Gera um romaneio para terceiros
	-- cristofer 15/12/2006 11:24:28 - CRIADO
	--->
	<cffunction name='gera_romaneio_terceiro' displayname='Gera um romaneio para terceiros' access='remote' returntype='Struct' output='true'>
		<cfargument name='NUM_ROMANEIO' required='yes'>
		<cfargument name='COMPOSICAO' required='yes'>
		<cfargument name='DATA_INICIO' required='yes'>
		<cfargument name='OPERACAO_ID' required='yes'>
		<cfargument name='VIAGEM_CARGA_ID' required='yes'>
		<cfargument name='COD_MOTORISTA' required='yes'>
		<cfargument name='COD_REMETENTE' required='yes'>
		<cfargument name='COLETA_MUNICIPIO_ID' required='yes'>
		<cfargument name='COD_DESTINATARIO' required='yes'>
		<cfargument name='ENTREGA_MUNICIPIO_ID' required='yes'>
		<cfargument name='VOLUME' required='yes'>
		<cfargument name='PESO' required='yes'>
		<cfargument name='M3' required='yes'>
		<cfargument name='FRETE_VALOR' required='yes'>
		<cfargument name='NUM_NATUREZA' required='yes'>
		<cfargument name='NUM_ESPECIE' required='yes'>
		<cfargument name='COD_UNIDADE' required='yes'>
		<cfargument name='FRETE_EM' required='yes'>
		<cfargument name='DESPACHO' required='yes'>
		<cfargument name='OBSERVACAO' required='yes'>
		<cfargument name='CARGA_CONSOLIDADA_ID' required='no' default="">
		<cftry>
				<cfstoredproc procedure='oper.pkg_romaneio.prc_gera_romaneio_terceiro' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_ROMANEIO#' variable='retorno.NUM_ROMANEIO'  null='#iif(len(trim(arguments.NUM_ROMANEIO)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' scale='5'  variable='retorno.ITEM_ID' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COMPOSICAO#' >
					<cfprocparam type='INOUT' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.DATA_INICIO#' variable='retorno.DATA_INICIO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.OPERACAO_ID#'  null='#iif(len(trim(arguments.OPERACAO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VIAGEM_CARGA_ID#'  null='#iif(len(trim(arguments.VIAGEM_CARGA_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_MOTORISTA#'  null='#iif(len(trim(arguments.COD_MOTORISTA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_REMETENTE#'  null='#iif(len(trim(arguments.COD_REMETENTE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COLETA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.COLETA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.COD_DESTINATARIO#'  null='#iif(len(trim(arguments.COD_DESTINATARIO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.ENTREGA_MUNICIPIO_ID#'  null='#iif(len(trim(arguments.ENTREGA_MUNICIPIO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.VOLUME#'  null='#iif(len(trim(arguments.VOLUME)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.PESO#'  null='#iif(len(trim(arguments.PESO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.M3#'  null='#iif(len(trim(arguments.M3)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.FRETE_VALOR#'  null='#iif(len(trim(arguments.FRETE_VALOR)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_NATUREZA#'  null='#iif(len(trim(arguments.NUM_NATUREZA)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.NUM_ESPECIE#'  null='#iif(len(trim(arguments.NUM_ESPECIE)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.COD_UNIDADE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.FRETE_EM#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.DESPACHO#'  null='#iif(len(trim(arguments.DESPACHO)), de('no'), de('yes'))#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.OBSERVACAO#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'  value='#session.COD_PESSOA#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' scale='5'   value='#arguments.CARGA_CONSOLIDADA_ID#'  null='#iif(len(trim(arguments.CARGA_CONSOLIDADA_ID)), de('no'), de('yes'))#'>
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Romaneio gerado com sucesso')>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	
	
	
	
	<!---
	-- PROPSITO
	-- Efetua inverso do cdigo da unidade da nota
	-- RAFAEL 01/02/2017 - CRIADO
	--->
	<cffunction name='inverter_unidade' displayname='Atualiza  inverso do cdigo da unidade da nota' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID_ALTERACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='sefaz.pkg_email_integracao.prc_inverter_unidade' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.DOCUMENTO_ID_ALTERACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Unidade alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!---
	-- PROPSITO
	-- Efetua inverso do peso utilizado da nota
	-- RAFAEL 01/02/2017 - CRIADO
	--->
	<cffunction name='inverter_peso_utilizado' displayname='Atualiza  inverso do cdigo da unidade da nota' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID_ALTERACAO' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='sefaz.pkg_email_integracao.prc_inverter_peso_utilizado' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.DOCUMENTO_ID_ALTERACAO#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Peso utilizado alterada com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
    <!---
	-- PROPSITO
	-- Inserir CTE Referenciado
	-- Nicolle 14/08/2017
	--->
	<cffunction name='ins_ctes_ref' displayname='Inserir CT-es Referenciados' access='remote' returntype='Struct' output='true'>
    	<cftry>
			<!--- Insere CT-es referenciados --->
			<cfscript>
				v_chave                = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_CHAVE_CTES_REF");
				v_numero 	           = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_NUMERO_CTES_REF");
				v_serie 	           = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_SERIE_CTES_REF");
				v_situacao             = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_SITUACAO_CTES_REF");
				v_data_emissao         = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_DATA_EMISSAO_CTES_REF");
				v_emit_cnpj_cpf        = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_EMIT_CNPJ_CPF_CTES_REF");
				v_emit_razao           = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_EMIT_RAZAO_CTES_REF");
				v_rem_cnpj_cpf         = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_REM_CNPJ_CPF_CTES_REF");
				v_rem_ie               = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_REM_IE_CTES_REF");
				v_rem_razao            = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_REM_RAZAO_CTES_REF');
				v_rem_endereco         = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_REM_ENDERECO_CTES_REF");
				v_rem_endereco_nro     = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_REM_ENDERECO_NRO_CTES_REF');
				v_rem_endereco_bairro  = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_REM_ENDERECO_BAIRRO_CTES_REF');
				v_rem_endereco_cmun    = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_REM_ENDERECO_CMUN_CTES_REF');
				v_rem_endereco_xmun    = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_REM_ENDERECO_XMUN_CTES_REF');
				v_rem_endereco_cep     = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_REM_ENDERECO_CEP_CTES_REF');
				v_rem_endereco_uf      = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_REM_ENDERECO_UF_CTES_REF');
				v_rem_endereco_pais    = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_REM_ENDERECO_PAIS_CTES_REF');
				v_dest_cnpj_cpf        = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_DEST_CNPJ_CPF_CTES_REF");
				v_dest_ie              = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_DEST_IE_CTES_REF");
				v_dest_razao           = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_DEST_RAZAO_CTES_REF');
				v_dest_endereco        = this.ListaToArray(lista = arguments, variavel  = "CTE_REF_DEST_ENDERECO_CTES_REF");
				v_dest_endereco_nro    = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_DEST_ENDERECO_NRO_CTES_REF');
				v_dest_endereco_bairro = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_DEST_ENDERECO_BAIRRO_CTES_REF');
				v_dest_endereco_cmun   = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_DEST_ENDERECO_CMUN_CTES_REF');
				v_dest_endereco_xmun   = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_DEST_ENDERECO_XMUN_CTES_REF');
				v_dest_endereco_cep    = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_DEST_ENDERECO_CEP_CTES_REF');
				v_dest_endereco_uf     = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_DEST_ENDERECO_UF_CTES_REF');
				v_dest_endereco_pais   = this.ListaToArray(lista = arguments, variavel  = 'CTE_REF_DEST_ENDERECO_PAIS_CTES_REF');
			</cfscript>

			<cfloop from="1" to="#ArrayLen(v_chave)#" index="count">
				<cfscript>
					ret_cte_ref = this.ins_cte_ref(chave				= v_chave[count]
												  ,numero				= v_numero[count]
												  ,serie 				= v_serie[count]
												  ,situacao				= v_situacao[count]
												  ,data_emissao			= v_data_emissao[count]
												  ,emit_cnpj_cpf		= v_emit_cnpj_cpf[count]
												  ,emit_razao			= v_emit_razao[count]
												  ,rem_cnpj_cpf			= v_rem_cnpj_cpf[count]
												  ,rem_ie				= v_rem_ie[count] 
												  ,rem_razao			= v_rem_razao[count]
												  ,rem_endereco			= v_rem_endereco[count]
												  ,rem_endereco_nro		= v_rem_endereco_nro[count]
												  ,rem_endereco_bairro	= v_rem_endereco_bairro[count]
												  ,rem_endereco_cmun	= v_rem_endereco_cmun[count]
												  ,rem_endereco_xmun	= v_rem_endereco_xmun[count]
												  ,rem_endereco_cep		= v_rem_endereco_cep[count]
												  ,rem_endereco_uf		= v_rem_endereco_uf[count]
												  ,rem_endereco_pais	= v_rem_endereco_pais[count]
												  ,dest_cnpj_cpf		= v_dest_cnpj_cpf[count]
												  ,dest_ie				= v_dest_ie[count] 
												  ,dest_razao			= v_dest_razao[count]
												  ,dest_endereco		= v_dest_endereco[count]
												  ,dest_endereco_nro	= v_dest_endereco_nro[count]
												  ,dest_endereco_bairro	= v_dest_endereco_bairro[count]
												  ,dest_endereco_cmun	= v_dest_endereco_cmun[count]
												  ,dest_endereco_xmun	= v_dest_endereco_xmun[count]
												  ,dest_endereco_cep	= v_dest_endereco_cep[count]
												  ,dest_endereco_uf		= v_dest_endereco_uf[count]
												  ,dest_endereco_pais	= v_dest_endereco_pais[count]);
				</cfscript>
				<cfif ret_cte_ref.erro>
					<cfthrow object="#ret_cte_ref.mensagem#">
				</cfif>
				<cfscript>
					ret_cte_ref = this.ins_conhecimento_cte_ref(conhecimento_id = arguments.conhecimento_id
									   			               ,chave			= v_chave[count]);
				</cfscript>
				<cfif ret_cte_ref.erro>
					<cfthrow object="#ret_cte_ref.mensagem#">
				</cfif>
			</cfloop>
			<cfset retorno.erro = false>
			<cfset retorno.mensagem = JSStringFormat('CT-es referenciados inseridos com sucesso.')>
		<cfcatch>
			<cfset retorno.erro = true>
			<cfset retorno.mensagem = cfcatch>
			<cfset request.erro = cfcatch>
		</cfcatch>
        </cftry>
        <cfreturn retorno />
    </cffunction>	
	
	<!---
	-- PROPSITO
	-- Inserir CTE Referenciado
	-- Nicolle 14/08/2017
	--->
	<cffunction name='ins_cte_ref' displayname='Inserir CTE Referenciado' access='remote' returntype='Struct' output='true'>
		<cfargument name='CHAVE' required='yes'>
		<cfargument name='NUMERO' required='no' default="">
		<cfargument name='SERIE' required='no' default="">
		<cfargument name='SITUACAO' required='no' default="">
		<cfargument name='DATA_EMISSAO' required='no' default="">
		<cfargument name='EMIT_CNPJ_CPF' required='no' default="">
		<cfargument name='EMIT_RAZAO' required='no' default="">
		<cfargument name='REM_CNPJ_CPF' required='no' default="">
		<cfargument name='REM_IE' required='no' default="">
		<cfargument name='REM_RAZAO' required='no' default="">
		<cfargument name='REM_ENDERECO' required='no' default="">
		<cfargument name='REM_ENDERECO_NRO' required='no' default="">
		<cfargument name='REM_ENDERECO_BAIRRO' required='no' default="">
		<cfargument name='REM_ENDERECO_CMUN' required='no' default="">
		<cfargument name='REM_ENDERECO_XMUN' required='no' default="">
		<cfargument name='REM_ENDERECO_CEP' required='no' default="">
		<cfargument name='REM_ENDERECO_UF' required='no' default="">
		<cfargument name='REM_ENDERECO_PAIS' required='no' default="">
		<cfargument name='DEST_CNPJ_CPF' required='no' default="">
		<cfargument name='DEST_IE' required='no' default="">
		<cfargument name='DEST_RAZAO' required='no' default="">
		<cfargument name='DEST_ENDERECO' required='no' default="">
		<cfargument name='DEST_ENDERECO_NRO' required='no' default="">
		<cfargument name='DEST_ENDERECO_BAIRRO' required='no' default="">
		<cfargument name='DEST_ENDERECO_CMUN' required='no' default="">
		<cfargument name='DEST_ENDERECO_XMUN' required='no' default="">
		<cfargument name='DEST_ENDERECO_CEP' required='no' default="">
		<cfargument name='DEST_ENDERECO_UF' required='no' default="">
		<cfargument name='DEST_ENDERECO_PAIS' required='no' default="">
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_cte.prc_ins_cte_ref' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.CHAVE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.NUMERO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.SERIE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.SITUACAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DATA_EMISSAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.EMIT_CNPJ_CPF#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.EMIT_RAZAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_CNPJ_CPF#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_IE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_RAZAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_ENDERECO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_ENDERECO_NRO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_ENDERECO_BAIRRO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_ENDERECO_CMUN#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_ENDERECO_XMUN#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_ENDERECO_CEP#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_ENDERECO_UF#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.REM_ENDERECO_PAIS#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_CNPJ_CPF#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_IE#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_RAZAO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_ENDERECO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_ENDERECO_NRO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_ENDERECO_BAIRRO#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_ENDERECO_CMUN#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_ENDERECO_XMUN#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_ENDERECO_CEP#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_ENDERECO_UF#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.DEST_ENDERECO_PAIS#' >
            </cfstoredproc>
			<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<!---
	-- PROPSITO
	-- Inserir CTE Referenciado
	-- Nicolle 14/08/2017
	--->
	<cffunction name='ins_conhecimento_cte_ref' displayname='Inserir CTE Referenciado' access='remote' returntype='Struct' output='true'>
		<cfargument name='CONHECIMENTO_ID' required='yes'>
		<cfargument name='CHAVE' required='yes'>
		<cftry>
			<cfstoredproc procedure='fiscal.pkg_cte.prc_ins_conhecimento_cte_ref' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
                <cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  value='#arguments.CONHECIMENTO_ID#' >
                <cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'  value='#arguments.CHAVE#' >
            </cfstoredproc>
			<cfset retorno.erro = false>
			<cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
	<!---
	-- PROPSITO
	-- Validar se a chave do CTe  valida
	-- Nicolle 16/08/2017
	--->
	<cffunction name='valida_chave_cte' displayname='Validar se a chave do CTe  valida' access='remote' returntype='Struct' output='true'>
		<cfargument name='CHAVE' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_cte.prc_valida_chave_cte' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR'   value='#arguments.CHAVE#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('CTe validado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
	
<!---
	-- PROPSITO
	-- Busca Chave do CTe
	-- JAQUELINEF 08/04/2014
	--->
	<cffunction name='busca_dados_cte_xml' displayname='Busca dados do XML do CTe' access='remote' returntype='Struct' output='true'>
		<cfargument name='CTE_REF_ARQUIVO' required='no' default="">
		<cftry>
        	<cfif Len(Trim(arguments.CTE_REF_ARQUIVO))>
				<!---L o arquivo--->
                <cffile action="read" file="#arguments.CTE_REF_ARQUIVO#" variable="VARQUIVO">
            <cfelse>
            	<cfset VARQUIVO = ''>
            </cfif>
				<!---Busca os dados do xml do CTE--->
                <cfscript>
                    conn = CreateComponent("modulos.cte._componentes.consulta.cfc_cte");
                </cfscript>

                <cfscript>
                    dados = conn.get_dados_cte_xml(CTE = VARQUIVO);
                </cfscript>
                <cfif dados.erro>
                    <cfthrow object="#dados.mensagem#">
                <cfelse>
                    <cfset retorno.chave = dados.chave>
                    <cfset retorno.numero = dados.numero>
                    <cfset retorno.serie = dados.serie>
                    <cfset retorno.situacao = dados.situacao>
                    <cfset retorno.data_emissao = dados.data_emissao>
                    <cfset retorno.emit_cnpj_cpf = dados.emit_cnpj_cpf>
                    <cfset retorno.emit_razao = dados.emit_razao>
                    <cfset retorno.rem_cnpj_cpf = dados.rem_cnpj_cpf>
                    <cfset retorno.rem_ie = dados.rem_ie>
                    <cfset retorno.rem_razao = dados.rem_razao>
                    <cfset retorno.rem_endereco = dados.rem_endereco>
                    <cfset retorno.rem_endereco_nro = dados.rem_endereco_nro>
                    <cfset retorno.rem_endereco_bairro = dados.rem_endereco_bairro>
                    <cfset retorno.rem_endereco_cmun = dados.rem_endereco_cmun>
                    <cfset retorno.rem_endereco_xmun = dados.rem_endereco_xmun>
                    <cfset retorno.rem_endereco_cep = dados.rem_endereco_cep>
                    <cfset retorno.rem_endereco_uf = dados.rem_endereco_uf>
                    <cfset retorno.rem_endereco_pais = dados.rem_endereco_pais>
                    <cfset retorno.dest_cnpj_cpf = dados.dest_cnpj_cpf>
                    <cfset retorno.dest_ie = dados.dest_ie>
                    <cfset retorno.dest_razao = dados.dest_razao>
                    <cfset retorno.dest_endereco = dados.dest_endereco>
                    <cfset retorno.dest_endereco_nro = dados.dest_endereco_nro>
                    <cfset retorno.dest_endereco_bairro = dados.dest_endereco_bairro>
                    <cfset retorno.dest_endereco_cmun = dados.dest_endereco_cmun>
                    <cfset retorno.dest_endereco_xmun = dados.dest_endereco_xmun>
                    <cfset retorno.dest_endereco_cep = dados.dest_endereco_cep>
                    <cfset retorno.dest_endereco_uf = dados.dest_endereco_uf>
                    <cfset retorno.dest_endereco_pais = dados.dest_endereco_pais>
                    <cfset retorno.multimodal = dados.multimodal>					
                </cfif>
             <cfset retorno.mensagem = 'ok'>
            <cfset retorno.erro = false>
            <cfcatch>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>

		<cfreturn retorno />
	</cffunction>	
	
	<!---
	-- PROPSITO
	-- Busca captcha do site nfe
	-- NICOLLE 28/03/2018
	--->
	<cffunction name='consultar_doc' displayname='Busca captcha do site nfe' access='remote' returntype='Struct' output='true'>
		<cfargument name='AMBIENTE_ID' required='yes'>
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_integracao_documento.prc_consultar_doc' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'   value='#arguments.AMBIENTE_ID#' >
                    <cfprocparam type='OUT' cfsqltype='CF_SQL_NUMERIC' SCALE='5'  variable='retorno.REQUISICAO_ID' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Ok')>
            </cftransaction>
			<cfcatch>
                <cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	

	<!---
	-- PROPSITO
	-- Busca dados do site da sefaz NFe
	-- NICOLLE 28/03/2018
	--->
	<cffunction name='consultar_doc_result' displayname='Busca dados do site da sefaz NFe' access='remote' returntype='Struct' output='true'>
		<cfargument name='REQUISICAO_ID' required='yes'>
		<cfargument name='AMBIENTE_ID' required='yes'>
		<cfargument name='CHAVE' required='yes'>
		<cfargument name='CAPTCHA' required='yes'>
        <cftry>
            <cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_integracao_documento.prc_consultar_doc_result' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.REQUISICAO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.AMBIENTE_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  value='#arguments.CHAVE#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_VARCHAR' SCALE='5'  value='#arguments.CAPTCHA#' >
				</cfstoredproc>
                <cfset retorno.erro = false>
                <cfset retorno.mensagem = JSStringFormat('OK')>
            </cftransaction>
            <cfcatch>
                <cftransaction action='rollback'/>
                <cfset retorno.erro = true>
                <cfset retorno.mensagem = cfcatch>
                <cfset request.erro = cfcatch>
            </cfcatch>
        </cftry>
        <cfreturn retorno />
	</cffunction>	
	
	<!---
	-- PROPSITO
	-- Baixa XML do site da sefaz NFe
	-- NICOLLE 28/03/2018
	--->
	<cffunction name='baixar_documento' displayname='Baixa XML do site da sefaz NFe' access='remote' returntype='Struct' output='true'>
		<cfargument name='REQUISICAO_ID' required='yes'>
		<cfargument name='NOTA_TRANSPORTADA' required='yes' default="1">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_integracao_documento.prc_baixar_documento' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.REQUISICAO_ID#' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC'  value='#arguments.NOTA_TRANSPORTADA#' >
				</cfstoredproc>
				<cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Documento inserido com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>	
	
	<cffunction name='gerar_documentos_viagem' displayname='Gerar PDF do DACTE' access='remote' returntype='Struct' output='true'>
		<cfargument name='DOCUMENTO_ID' required='yes'>
		<cfargument name='DECLARACAO' required='no' default="0">
		<cftry>
			<cftransaction action='begin'>
				<cfstoredproc procedure='fiscal.pkg_impressao_cte.prc_gerar_documentos_viagem' datasource='#session.dsn#' username='#session.usuario#' password='#session.senha#'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DOCUMENTO_ID#'  null='#iif(len(trim(arguments.DOCUMENTO_ID)), de('no'), de('yes'))#'>
					<cfprocparam type='OUT' cfsqltype='CF_SQL_BLOB'  variable='retorno.ARQUIVO' >
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='1'>
					<cfprocparam type='IN' cfsqltype='CF_SQL_NUMERIC' SCALE='5'   value='#arguments.DECLARACAO#'  null='#iif(len(trim(arguments.DECLARACAO)), de('no'), de('yes'))#'>
				</cfstoredproc>
                <cfset retorno.erro = false>
				<cfset retorno.mensagem = JSStringFormat('Dacte gerado com sucesso.')>
			</cftransaction>
			<cfcatch>
				<cftransaction action='rollback'/>
				<cfset retorno.erro = true>
				<cfset retorno.mensagem = cfcatch>
				<cfset request.erro = cfcatch>
			</cfcatch>
		</cftry>
		<cfreturn retorno />
	</cffunction>
</cfcomponent>
