<cfcomponent extends="_transportes.funcoes.cfc_init">

    <!--- 
    -- PROPSITO 
    -- Busca os enderecos vinculados as pessoas de uma solicitao de carga
    -- RICARDO 27/10/2014
    --->		
    <cffunction name="get_enderecos_solicitacao" access="remote" returntype="query" output="true">
        <cfargument name="cod_endereco" required="yes" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select pe.cod_endereco
                 , pe.cod_pessoa
                 , to_char(pe.cep) as cep
                 , pe.logradouro
                 , pe.numero
                 , pe.bairro
                 , pe.uf
                 , pe.municipio
                 , pe.municipio_id
                 , pe.endereco_padrao
                 , pe.inscricao_estadual
                 , pe.cod_atividade_fiscal
              from kss.v$pessoa_endereco_todos pe
             <cfif Len(Trim(arguments.cod_endereco))>
             	where pe.cod_endereco = #arguments.cod_endereco#
             <cfelse>
             	where 1 = 0
             </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Trazer os novos IDs de endereos
	-- RICARDO 27/10/2014 - CRIADO
	--->
    <cffunction name="get_id_enderecos_solicitacao" access="remote" returntype="query" output="true">
    <cfargument name="num_romaneio" required="no" default="">
    <cfargument name="viagem_carga_id" required="no" default="">
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select s.solicitacao_carga_id
             , s.endereco_remetente_id
             , s.endereco_destinatario_id
             , s.endereco_coleta_id
             , s.endereco_entrega_id
             , s.endereco_cobranca_id
          from logistica.v$solicitacao_carga s
         inner join logistica.v$viagem_carga v
            on v.solicitacao_carga_id = s.solicitacao_carga_id
         inner join oper.v$romaneio_item r
            on r.viagem_carga_id = v.viagem_carga_id     
         where 1 = 1
    <cfif Len(Trim(arguments.num_romaneio))>
       and r.num_romaneio = #arguments.num_romaneio#
    </cfif>
    <cfif Len(Trim(arguments.viagem_carga_id))>
       and v.viagem_carga_id = #arguments.viagem_carga_id#
    </cfif>
    <cfif not (Len(Trim(arguments.viagem_carga_id)) and Len(Trim(arguments.num_romaneio))) >
       and 1 = 2
    </cfif>
    </cfquery>
    <cfreturn qr_result>
    </cffunction>
	
	<!---
	-- PROPSITO
	-- Trazer os novos IDs de endereos
	-- RICARDO 27/10/2014 - CRIADO
	--->
    <cffunction name="get_id_enderecos_solicitacao_frac" access="remote" returntype="query" output="true">
    <cfargument name="num_romaneio" required="no" default="">
    <cfargument name="solicitacao_carga_id" required="no" default="">
    <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
        select s.solicitacao_carga_id
             , s.endereco_remetente_id
             , s.endereco_destinatario_id
             , s.endereco_coleta_id
             , s.endereco_entrega_id
             , s.endereco_cobranca_id
          from logistica.v$solicitacao_carga s
         where 1 = 1
	<cfif Len(Trim(arguments.solicitacao_carga_id))>
       and s.solicitacao_carga_id = #arguments.solicitacao_carga_id#
    </cfif>
    <cfif not (Len(Trim(arguments.solicitacao_carga_id))) >
       and 1 = 2
    </cfif>
    </cfquery>
    <cfreturn qr_result>
    </cffunction>
	
	
	
	<!--- 
    -- PROPSITO 
    -- Busca as notas fiscais de uma solicitao de carga
    -- ANDERSON 28/09/2009 - ALTERADO
    --->		
    <cffunction name="get_solicitacao_carga_nf" access="remote" returntype="query" output="true">
        <cfargument name="solicitacao_carga_id" required="no" default="">
        <cfargument name="viagem_carga_id" required="no" default="">
        <cfargument name="xml" required="no" default="0">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select t.solicitacao_carga_nf_id
                 , t.solicitacao_carga_id
                 , t.numero
                 , to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao
                 , t.modelo
                 , t.serie
                 , t.sub_serie
                 , t.valor_total
                 , t.valor_segurado
                 , t.ordem_compra_cliente
                 , nvl(t.qtde_volume, 1) as qtde_volume
                 , t.peso
                 , t.cod_unidade
                 , t.num_natureza
                 , (select n.descricao
                     from oper.v$natureza n
                    where n.num_natureza = t.num_natureza) as natureza
                 , t.num_especie
                 , (select e.descricao
                     from oper.v$especie e
                    where e.num_especie = t.num_especie) as especie
                 , t.altura
                 , t.comprimento
                 , t.largura
                 , t.cubagem
                 , (t.altura * 
                    t.comprimento * 
                    t.largura * 
                    (select case count(1)
                               when 0
                                  then nvl(t.qtde_volume, 1)
                               else 1
                            end
                       from logistica.v$solicitacao_carga_volume scv
                      where scv.solicitacao_carga_nf_id = t.solicitacao_carga_nf_id) * 
                    (select kss.pkg_parametro.fnc_valor_numerico('M204-P0173') from dual)) as cubagem_sugerida
                 , t.m3
                 , t.peso_cubado
                 , fiscal.pkg_fiscal.fnc_converte_peso(t.peso, t.cod_unidade, 'KG') as peso_kg_convertido
                 , t.peso_cobrado
                 , t.cfop
                 , t.tipo_documento_id
                 , t.chave_acesso_nfe
                 , t.descricao_docto
                 <cfif arguments.xml eq 1>
                 , t.nfe_xml
                 </cfif>
                 , case
                      when existsnode(xmltype.createxml(t.nfe_xml),'//ICMSUFDest','xmlns="http://www.portalfiscal.inf.br/nfe"') = 1
                         and extractvalue(xmltype.createxml(t.nfe_xml),'//pFCPUFDest[0]','xmlns="http://www.portalfiscal.inf.br/nfe"') > 0 then 1
                      else 0
                   end as icms_partilhado
              from logistica.v$solicitacao_carga_nf t
             where 1 = 1
			<cfif Len(Trim(arguments.solicitacao_carga_id))>
               and t.solicitacao_carga_id = #arguments.solicitacao_carga_id#
			</cfif>
            <cfif Len(Trim(arguments.viagem_carga_id))>
               and t.solicitacao_carga_id = (select vg.solicitacao_carga_id
                                               from logistica.v$viagem_carga vg
                                              where vg.viagem_carga_id = #arguments.viagem_carga_id#)
            </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>
	
	<!--- 
	-- PROPSITO 
	-- Busca os dados do CTe multimodal emitido para a solicitao de carga
	-- NOTAS EXPLICATIVAS
	-- Nicolle 14/08/2017
	--->		
	<cffunction name="get_cte_multimodal_sol_carga" access="remote" returntype="query" output="true">
		<cfargument name="solicitacao_carga_id" required="no" default="">
		<cfargument name="conhecimento_id_substituido" required="no" default="-1">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
		select x.*
			 , (select k.rv_abbreviation
				  from kss.cg_ref_codes k
				 where k.rv_domain = 'STATUS.SITUACAO_ID'
				   and k.owner = 'SEFAZ'
				   and k.rv_low_value = x.situacao) as situacao_descricao
			 , round(x.peso_multimodal * x.percentual_tolerancia / 100, 2) as valor_tolerancia
			 , (x.peso_multimodal - x.peso_ctes_vinculados) as peso_restante
			 , (x.peso_multimodal - x.peso_ctes_vinculados) + round(x.peso_multimodal * x.percentual_tolerancia / 100, 2) as peso_restante_tolerancia
		  from (select t.conhecimento_id
					 , d.chave
				     , to_number(substr(d.chave,26,9)) as numero
				     , substr(d.chave,23,3) as serie
					 , to_char(t.data_emissao, 'dd/mm/yyyy') as data_emissao
					 , sefaz.pkg_sefaz.fnc_situacao_atual(ct.documento_id) as situacao
					 , t.cod_remetente
					 , t.cod_destinatario
					 , t.cod_pessoa_filial as cod_emitente
					 , kss.pkg_pessoa.fnc_get_identificador(t.cod_pessoa_filial,0) as emit_cnpj_cpf
					 , kss.pkg_pessoa.fnc_get_cliente(t.cod_pessoa_filial) as emit_razao
					 , kss.pkg_pessoa.fnc_get_cod_atividade_fiscal(t.cod_pessoa_filial, eemit.cod_endereco) as emit_cod_atividade
					 , kss.pkg_pessoa.fnc_get_inscricao_estadual(t.cod_pessoa_filial, eemit.cod_endereco) as emit_inscricao_estadual
					 , eemit.cod_endereco as emit_cod_endereco
					 , eemit.endereco as emit_endereco
					 , eemit.numero as emit_endereco_nro
					 , eemit.bairro as emit_endereco_bairro
					 , eemit.uf as emit_endereco_uf
					 , eemit.cep as emit_endereco_cep
					 , eemit.municipio as emit_endereco_mun
					 , eemit.municipio_id as emit_endereco_mun_id      
					 , kss.pkg_pessoa.fnc_get_identificador(t.cod_remetente,0) as rem_cnpj_cpf
					 , kss.pkg_pessoa.fnc_get_cliente(t.cod_remetente) as rem_razao
					 , t.rem_inscricao_estadual as rem_ie
					 , erem.endereco as rem_endereco
					 , erem.numero as rem_endereco_nro
					 , erem.bairro as rem_endereco_bairro
					 , (select m.cod_ibge 
						  from cep.v$municipio m
						 where m.municipio_id = erem.municipio_id) as rem_endereco_cmun
					 , erem.municipio as rem_endereco_xmun
					 , erem.cep as rem_endereco_cep
					 , erem.uf as rem_endereco_uf
					 , erem.pais as rem_endereco_pais
					 , kss.pkg_pessoa.fnc_get_identificador(t.cod_destinatario,0) as dest_cnpj_cpf
					 , kss.pkg_pessoa.fnc_get_cliente(t.cod_destinatario) as dest_razao
					 , t.dest_inscricao_estadual as dest_ie
					 , edest.endereco as dest_endereco
					 , edest.numero as dest_endereco_nro
					 , edest.bairro as dest_endereco_bairro
					 , (select m.cod_ibge 
						  from cep.v$municipio m
						 where m.municipio_id = edest.municipio_id) as dest_endereco_cmun
					 , edest.municipio as dest_endereco_xmun
					 , edest.cep as dest_endereco_cep
					 , edest.uf as dest_endereco_uf
					 , edest.pais as dest_endereco_pais
					 , nvl((select nvl(sum(nf.peso), 0)
							 from fiscal.v$conhecimento_nota_fiscal nf
							where nf.conhecimento_id = t.conhecimento_id),
						   0) as peso_multimodal
					 , kss.pkg_parametro.fnc_valor_numerico(p_identificador => 'M309-P0214') as percentual_tolerancia
					 , nvl((select nvl(sum(nf.peso), 0)
							 from fiscal.v$conhecimento c
							inner join fiscal.v$documento_cte dc
							   on dc.conhecimento_id = c.conhecimento_id
							inner join fiscal.v$conhecimento_nota_fiscal nf
							   on nf.conhecimento_id = c.conhecimento_id
							inner join fiscal.v$conhecimento_cte_ref cr
							   on cr.conhecimento_id = c.conhecimento_id
							where sefaz.pkg_sefaz.fnc_situacao_atual(dc.documento_id) in (0, 1, 2, 5)
							  and cr.chave = d.chave
							  and cr.conhecimento_id <> t.conhecimento_id
							  and cr.conhecimento_id <> #arguments.conhecimento_id_substituido# ),
						   0) as peso_ctes_vinculados
					 , 0 as peso_real
				  from fiscal.v$conhecimento t
				 inner join fiscal.v$documento_cte ct
					on ct.conhecimento_id = t.conhecimento_id
				 inner join sefaz.v$documento d
					on d.documento_id = ct.documento_id
				  left join kss.v$pessoa_endereco_padrao erem
					on erem.cod_pessoa = t.cod_remetente
				  left join kss.v$pessoa_endereco_padrao edest
					on edest.cod_pessoa = t.cod_destinatario
				  left join kss.v$pessoa_endereco_padrao eemit
				    on eemit.cod_pessoa = t.cod_pessoa_filial
				 where t.solicitacao_carga_id = #arguments.solicitacao_carga_id#
				   and t.modal = 6
				   and t.cancelado is null) x
		</cfquery>
		<cfreturn qr_result>
	</cffunction>		
</cfcomponent>
