<cfcomponent extends="_transportes.funcoes.cfc_init">
	<!---
	-- PROPSITO
	-- Busca Organograma completo
	-- GUTO  20/12/2006
	--->
	<cffunction name="get_organograma" access="remote" returntype="query" output="true">
		<cfargument name="operacao_id" required="no" default="">
        <cfargument name="lotacao" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
			select o.cod_organograma
                 , o.cod_unidade_negocio
                 , p.cliente as filial
                 , o.cod_pessoa
                 , d.descricao as departamento
                 , o.cod_departamento
                 , s.descricao as setor
                 , o.cod_setor
                 , cc.centro_custo
                 , o.cod_centro_custo
                 , fiscal.pkg_sefaz_cte.fnc_consulta_contingencia('',p.cod_pessoa) as mensagem_contingencia
			  from kss.v$organograma o
			 inner join kss.v$pessoa p
					 on p.cod_pessoa = o.cod_pessoa
			 inner join kss.v$departamento d
					 on d.cod_departamento = o.cod_departamento
			 inner join kss.v$setor s
					 on s.cod_setor = o.cod_setor
			 inner join kss.v$centro_custo cc
					 on cc.cod_centro_custo = o.cod_centro_custo
             where 1=1
			 <cfif Len(Trim(arguments.operacao_id))>
               and o.cod_organograma in (select ofe.cod_organograma
                                           from logistica.v$operacao_filial_emissao ofe
                                          where ofe.operacao_id = '#arguments.operacao_id#' )
             </cfif>
             <cfif arguments.lotacao eq 1>
               and o.cod_organograma = '#session.cod_organograma#'
             </cfif>
             order by cod_unidade_negocio, cod_departamento, cod_setor, cod_centro_custo
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

    <!---
    -- PROPSITO
    -- Busca as pessoas vinculadas a uma solicitao de carga
    -- RAFAEL 01/11/2011 - CRIADO
    --->
    <cffunction name="get_solicitacao_pessoas_cod" access="remote" returntype="query" output="true">
        <cfargument name="viagem_carga_id" required="no" default="">
        <cfargument name="tipo_cliente" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select logistica.pkg_operacao.fnc_pessoas_operacao(#arguments.viagem_carga_id#, #arguments.tipo_cliente#) as cod_pessoa
              from dual
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca os enderecos vinculadas as pessoas de uma solicitao de carga
    -- RAFAEL 01/11/2011 - CRIADO
    --->
    <cffunction name="get_operacao_enderecos" access="remote" returntype="query" output="true">
        <cfargument name="viagem_carga_id" required="no" default="">
        <cfargument name="operacao_id" required="no" default="">
        <cfargument name="tipo_cliente" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(pe.cod_endereco) as cod_endereco  /*converte para char para evitar problema de preciso. Ex: 10051646 vira 1.0051646E7, e no campo vira 1*/
                 , to_char(pe.cod_pessoa) as cod_pessoa
                 , to_char(pe.cep) as cep
                 , pe.logradouro
                 , pe.numero
                 , pe.bairro
                 , pe.uf
                 , pe.municipio
                 , pe.municipio_id
                 , pe.endereco_padrao
                 , nvl(pe.inscricao_estadual,p.inscricao_estadual) as inscricao_estadual
                 , pe.cod_atividade_fiscal
              from kss.v$pessoa_endereco_todos pe
             inner join kss.v$pessoa p
                on p.cod_pessoa = pe.cod_pessoa
              where 1 = 1
           <cfif Len(Trim(arguments.viagem_carga_id))>
               and pe.cod_pessoa in (select to_number(t.column_value)
                                       from table(kss.pkg_string.fnc_split(logistica.pkg_operacao.fnc_pessoas_viagem(#arguments.viagem_carga_id#, #arguments.tipo_cliente#), ',')) t
                                     )
		   </cfif>
           <cfif Len(Trim(arguments.operacao_id))>
               and pe.cod_pessoa in (select to_number(t.column_value)
                                       from table(kss.pkg_string.fnc_split(logistica.pkg_operacao.fnc_pessoas_operacao(#arguments.operacao_id#, #arguments.tipo_cliente#), ',')) t
                                     )
		   </cfif>
           <cfif Len(Trim(arguments.cod_pessoa))>
               and pe.cod_pessoa in (#arguments.cod_pessoa#)
		   </cfif>
              order by pe.cod_pessoa, pe.endereco_padrao desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <cffunction name="get_operacao_enderecos_fracionado" access="remote" returntype="query" output="true">
        <cfargument name="carga_consolidada_id" required="yes" default="">
        <cfargument name="operacao_id" required="no" default="">
        <cfargument name="tipo_cliente" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select to_char(pe.cod_endereco) as cod_endereco
                 , to_char(pe.cod_pessoa) as cod_pessoa
                 , to_char(pe.cep) as cep
                 , pe.logradouro
                 , pe.numero
                 , pe.bairro
                 , pe.uf
                 , pe.municipio
                 , pe.municipio_id
                 , pe.endereco_padrao
                 , pe.inscricao_estadual
                 , pe.cod_atividade_fiscal
					  , 1 as fracionado
              from kss.v$pessoa_endereco_todos pe
              where 1 = 1
           <cfif Len(Trim(arguments.carga_consolidada_id))>
               and pe.cod_pessoa in (select to_number(t.column_value)
                                       from table(kss.pkg_string.fnc_split(logistica.pkg_operacao.fnc_pessoas_viagem_frac(#arguments.carga_consolidada_id#, #arguments.tipo_cliente#), ',')) t
                                     )
		   </cfif>
           <cfif Len(Trim(arguments.operacao_id))>
               and pe.cod_pessoa in (select to_number(t.column_value)
                                       from table(kss.pkg_string.fnc_split(logistica.pkg_operacao.fnc_pessoas_operacao(#arguments.operacao_id#, #arguments.tipo_cliente#), ',')) t
                                     )
		   </cfif>
           <cfif Len(Trim(arguments.cod_pessoa))>
               and pe.cod_pessoa in (#arguments.cod_pessoa#)
		   </cfif>
              order by pe.cod_pessoa, pe.endereco_padrao desc
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
    -- PROPSITO
    -- Busca as pessoas vinculadas a uma solicitao de carga
    -- RAFAEL 01/11/2011 - CRIADO
    --->
    <cffunction name="get_operacao_pessoa" access="remote" returntype="any" output="true">
        <cfargument name="viagem_carga_id" required="no" default="">
        <cfargument name="operacao_id" required="no" default="">
        <cfargument name="tipo_cliente" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.cod_pessoa
                 , p.tipo_pessoa
                 , p.cnpj_cpf
                 , p.razao_social
                 , case
			          when p.tipo_pessoa = 1 then
			             nvl(p.inscricao_estadual, 'ISENTO')
			          else
			             p.inscricao_estadual
			       end inscricao_estadual
                 , p.identificador
                 , nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                          from kss.v$pessoa_inscricao_estadual ie2
                         where ie2.cod_pessoa = p.cod_pessoa),
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                              from kss.v$pessoa_endereco e
                             where e.cod_pessoa = p.cod_pessoa
                               and p.tipo_pessoa = 1
                               and e.inscricao_estadual <> p.inscricao_estadual)) as ie_adicional
              from kss.v$pessoa p
             where 1 = 1
           <cfif Len(Trim(arguments.viagem_carga_id))>
               and p.cod_pessoa in (select to_number(t.column_value)
                                      from table(kss.pkg_string.fnc_split(logistica.pkg_operacao.fnc_pessoas_viagem(#arguments.viagem_carga_id#, #arguments.tipo_cliente#), ',')) t
                                    )
		   </cfif>
           <cfif Len(Trim(arguments.operacao_id))>
               and p.cod_pessoa in (select to_number(t.column_value)
                                      from table(kss.pkg_string.fnc_split(logistica.pkg_operacao.fnc_pessoas_operacao(#arguments.operacao_id#, #arguments.tipo_cliente#), ',')) t
                                    )
		   </cfif>
           <cfif Len(Trim(arguments.cod_pessoa))>
               and p.cod_pessoa in (#arguments.cod_pessoa#)
		   </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

	<cffunction name="get_operacao_pessoa_fracionado" access="remote" returntype="any" output="true">
        <cfargument name="carga_consolidada_id" required="yes" default="">
        <cfargument name="operacao_id" required="no" default="">
        <cfargument name="tipo_cliente" required="no" default="">
        <cfargument name="cod_pessoa" required="no" default="">
        <cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select p.cod_pessoa
                 , p.tipo_pessoa
                 , p.cnpj_cpf
                 , p.razao_social
                 , p.inscricao_estadual
                 , p.identificador
                 , nvl((select kss.fnc_concat_all(kss.to_concat_expr(ie2.inscricao_estadual, ','))
                          from kss.v$pessoa_inscricao_estadual ie2
                         where ie2.cod_pessoa = p.cod_pessoa),
                       (select kss.fnc_concat_all(distinct kss.to_concat_expr(e.inscricao_estadual,','))
                              from kss.v$pessoa_endereco e
                             where e.cod_pessoa = p.cod_pessoa
                               and p.tipo_pessoa = 1
                               and e.inscricao_estadual <> p.inscricao_estadual)) as ie_adicional
                 , 1 as fracionado
              from kss.v$pessoa p
             where 1 = 1
           <cfif Len(Trim(arguments.carga_consolidada_id))>
               and p.cod_pessoa in (select to_number(t.column_value)
                                      from table(kss.pkg_string.fnc_split(logistica.pkg_operacao.fnc_pessoas_viagem_frac(#arguments.carga_consolidada_id#, #arguments.tipo_cliente#), ',')) t
                                    )
		   </cfif>
           <cfif Len(Trim(arguments.operacao_id))>
               and p.cod_pessoa in (select to_number(t.column_value)
                                      from table(kss.pkg_string.fnc_split(logistica.pkg_operacao.fnc_pessoas_operacao(#arguments.operacao_id#, #arguments.tipo_cliente#), ',')) t
                                    )
		   </cfif>
           <cfif Len(Trim(arguments.cod_pessoa))>
               and p.cod_pessoa in (#arguments.cod_pessoa#)
		   </cfif>
        </cfquery>
        <cfreturn qr_result>
    </cffunction>

    <!---
	-- PROPSITO
	-- Busca a arvore de Operaes
	-- CRISTOFER  09/05/2009
	--->
	<cffunction name="get_operacao" access="remote" returntype="query" output="true">
    	<cfargument name="operacao_id" required="no" default="">
        <cfargument name="edi" required="no" default="">
        <cfargument name="cod_organograma" required="no" default="">
        <cfargument name="internacional" required="no" default="">
        <cfargument name="consultar_por" required="no" default="">
        <cfargument name="valor" required="no" default="">
        <cfargument name="somente_ativas" required="no" default="0">
        <cfargument name="cod_pessoa_filial" required="no" default="">
        <cfargument name="cod_departamento" required="no" default="">
        <cfargument name="cod_setor" required="no" default="">
        <cfargument name="cod_centro_custo" required="no" default="">
        <cfargument name="lotacao" required="no" default="0">
		<cfquery name="qr_result" datasource="#session.dsn#" username="#session.usuario#" password="#session.senha#">
            select substr(sys_connect_by_path(o.descricao, '->'),3) as operacao_completa,
                   o.operacao_id,
                   operacao_id_pai,
                   nvl(o.operacao_id_pai,0) as operacao_id_pai_nvl,
                   (select o2.descricao
                      from logistica.v$operacao o2
                     where o2.operacao_id = o.operacao_id_pai) as operacao_pai_descricao,
                   descricao,
                   veiculos_dedicados,
                   internacional,
                   dedicado,
                   fracionado,
                   frete_proprio,
                   num_especie,
                   regra_fiscal_id,
                   cod_negociador,
                   (select oc.cod_pessoa
                      from logistica.v$operacao_cliente oc
                     where oc.tipo_cliente = 4
                       and oc.operacao_id = o.operacao_id
                       and rownum = 1 ) as cod_cliente_cobranca,
                   frete_por_conta,
                   case (select count(o2.operacao_id)
                           from logistica.v$operacao o2
                          where o2.operacao_id_pai = o.operacao_id)
                      when 0
                         then 'false'
                      else  'true'
                   end possui_filhos,
                   o.tipo_pagamento_id,
                   o.adiantamento_frete_vazio,
                   o.tipo_frete,
                   o.tipo_servico_id,
                   o.tipo_docto_frete,
                   o.pagto_vale_pedagio,
				   o.vp_obrigatorio_cte,
                   o.operadora_vale_pedagio,
                   kss.pkg_pessoa.fnc_get_identificador(oop.operadora_vale_pedagio, 0 ) as cnpj_operadora_vale_ped,
                   kss.pkg_pessoa.fnc_get_cliente(oop.operadora_vale_pedagio) as nome_operadora_vale_ped,
                   o.fornecedora_vale_pedagio,
                   o.pedido_shipment,
				   o.pedido_shipment_edicao,
                   o.exige_xml_nfe,
				   o.emite_multimodal,
  				   case when o.emite_multimodal = 1 or o.operacao_vinculada_otm = 1 then 1 else 0 end as vinculado_multimodal,
				   o.tipo_documento as tipo_documento_operacao,
                   o.cif_fob,
                   o.date_insert,
                   o.user_insert,
                   o.date_update,
                   o.user_update,
                   o.site
              from logistica.v$operacao o
              left join logistica.v$operacao_operadora oop
                on oop.operacao_id = o.operacao_id
               and oop.padrao = 1
             where 1=1
		 <cfif len(trim(arguments.operacao_id))>
           	   and o.operacao_id = #arguments.operacao_id#
         </cfif>
         <cfif Len(Trim(arguments.internacional))>
            and o.internacional = #arguments.internacional#
         </cfif>
         <cfif Len(Trim(arguments.consultar_por)) and Len(Trim(arguments.valor))>
         	<cfif arguments.consultar_por eq 1>
            	and o.operacao_id = #arguments.valor#
            </cfif>
            <cfif arguments.consultar_por eq 2>
            	and upper(kss.pkg_string.fnc_string_clean(o.descricao)) like  upper(kss.pkg_string.fnc_string_clean('%#arguments.valor#%'))
            </cfif>
         </cfif>
         <cfif arguments.lotacao eq 1>
         	and o.operacao_id in (select operacao_id
                                    from logistica.v$operacao op
                                   start with operacao_id in (select operacao_id
                                                                from logistica.v$operacao_filial_emissao
                                                               where cod_organograma in ('#session.cod_organograma#'))
                                 connect by operacao_id = prior operacao_id_pai)
         </cfif>
		 <cfif arguments.somente_ativas eq 1>
           and o.ativo = 1
         </cfif>
          start with o.operacao_id_pai is null
  connect by prior o.operacao_id = o.operacao_id_pai
		 <cfif len(trim(arguments.edi))>
          order by operacao_pai_descricao, o.descricao
         <cfelseif Len(Trim(arguments.consultar_por)) and Len(Trim(arguments.valor))>
          order by o.descricao
         </cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

   <!---
   -- PROPSITO
   -- Busca total de notas fiscais da solicitacao de carga vinculada ao romaneio
   -- ALEXANDRE ANFILO 05/2017
   --->
   <cffunction name="get_count_notas_solicitacao" displayname="Busca total de notas fiscais da solicitacao de carga vinculada ao romaneio" access="remote" returntype="query" output="false">
         <cfargument name="num_romaneio" required="yes" default="">
         <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
            select count(*) as count_notas
                 , kss.fnc_concat_all(kss.to_concat_expr(sc_nf.numero, ';')) as num_notas
               from oper.v$romaneio r
               inner join oper.v$romaneio_item ri
                  on ri.NUM_ROMANEIO = r.NUM_ROMANEIO
               inner join logistica.v$operacao o
                  on o.operacao_id = ri.OPERACAO_ID
               inner join logistica.v$viagem_carga vc
                  on vc.viagem_carga_id = ri.VIAGEM_CARGA_ID
               inner join logistica.v$solicitacao_carga sc
                  on sc.solicitacao_carga_id = vc.solicitacao_carga_id
               inner join logistica.v$solicitacao_carga_nf sc_nf
                  on sc_nf.solicitacao_carga_id = sc.solicitacao_carga_id
               where 1=1
            <cfif Len(Trim(arguments.num_romaneio))>
               and r.NUM_ROMANEIO = #arguments.num_romaneio#
            </cfif>
         </cfquery>
         <cfreturn qr_result>
   </cffunction>

   <!---
	-- PROPSITO
	-- Busca configurao de valor segurado para notas fiscais
	--->
	<cffunction name="get_config_valor_segurado" displayname="Busca configurao de valor segurado para notas fiscais" access="remote" returntype="query" output="false">
		<cfargument name="operacao_id" required="yes" default="">
		<cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
			select o.destinado_exportacao
                 , nvl(kss.pkg_parametro.fnc_valor_numerico('M204-P0150'), 0) as adicional_valor_segurado
                 , os.perc_sobretaxa
              from logistica.v$operacao o
             inner join logistica.v$operacao_seguro os
			       on os.operacao_id = o.operacao_id
              where 1=1
			<cfif Len(Trim(arguments.operacao_id))>
			   and o.operacao_id = #arguments.operacao_id#
			</cfif>
		</cfquery>
		<cfreturn qr_result>
	</cffunction>

   <!---
   -- PROPSITO
   -- Busca percentual de sobretaxa do seguro da operao vinculada ao romaneio
   -- ALEXANDRE ANFILO 05/2017
   --->
   <cffunction name="get_sobretaxa_seguro_operacao" displayname="Busca percentual de sobretaxa do seguro da operao vinculada ao romaneio" access="remote" returntype="query" output="false">
      <cfargument name="num_romaneio" required="yes" default="">
      <cfquery datasource="#session.dsn#" name="qr_result" username="#session.usuario#" password="#session.senha#">
         select r.NUM_ROMANEIO
               , os.perc_sobretaxa
            from oper.v$romaneio r
         inner join oper.v$romaneio_item ri
            on ri.NUM_ROMANEIO = r.NUM_ROMANEIO
         inner join logistica.v$operacao o
            on o.operacao_id = ri.OPERACAO_ID
         inner join logistica.v$operacao_seguro os
            on os.operacao_id = o.operacao_id
         where 1=1
         <cfif Len(Trim(arguments.num_romaneio))>
            and r.NUM_ROMANEIO = #arguments.num_romaneio#
         </cfif>
      </cfquery>
      <cfreturn qr_result>
   </cffunction>
</cfcomponent>
